/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.barcode.scm.IPDAOnlyMessage;
import com.kingdee.eas.barcode.scm.PDAOnlyMessageFactory;
import com.kingdee.eas.barcode.scm.PDAOnlyMessageInfo;
import com.kingdee.eas.barcode.scm.app.MoveBillCache;
import com.kingdee.eas.barcode.scm.app.MoveBillCacheManager;
import com.kingdee.eas.barcode.scm.util.MoveBarcodeCacheManager;
import com.kingdee.eas.basedata.scm.common.RIEnum;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.DataDirectionEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BarcodeServerUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.BarcodeServerUtils");

    public static int[] executeBatchUpdate(Context ctx, List<String> sqls) throws BOSException {
        Connection con = null;
        Statement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.createStatement();
            int n = sqls.size();
            for (int i = 0; i < n; ++i) {
                if (i % 500 == 0 && i != 1) {
                    ps.executeBatch();
                }
                ps.addBatch(sqls.get(i));
            }
            int[] i = ps.executeBatch();
            return i;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("Execute batch update: " + ps));
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)con);
        }
    }

    public static int getInOrOutBill(Context ctx, String bosType, String transferNumber) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection seleCol = new SelectorItemCollection();
        seleCol.add(new SelectorItemInfo("id"));
        seleCol.add(new SelectorItemInfo("number"));
        seleCol.add(new SelectorItemInfo("name"));
        seleCol.add(new SelectorItemInfo("riType.dataDirection"));
        seleCol.add(new SelectorItemInfo("riType.bizDirection"));
        seleCol.add(new SelectorItemInfo("riType.*"));
        view.setSelector(seleCol);
        FilterInfo transfilterInfo = new FilterInfo();
        transfilterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)transferNumber));
        view.setFilter(transfilterInfo);
        TransactionTypeInfo typeInfo = null;
        try {
            TransactionTypeCollection tyleCol = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(view);
            if (tyleCol.size() > 0) {
                typeInfo = tyleCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (typeInfo == null) {
            return 1;
        }
        if (typeInfo != null) {
            if (DataDirectionEnum.positive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Receive.equals((Object)typeInfo.getRiType().getRI()) || DataDirectionEnum.navitive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Issue.equals((Object)typeInfo.getRiType().getRI())) {
                return 2;
            }
            if (DataDirectionEnum.positive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Issue.equals((Object)typeInfo.getRiType().getRI()) || DataDirectionEnum.navitive.equals((Object)typeInfo.getRiType().getDataDirection()) && RIEnum.Receive.equals((Object)typeInfo.getRiType().getRI())) {
                return 3;
            }
        }
        return 1;
    }

    public static String checkReaptBill(Context ctx, String guuid) throws EASBizException, BOSException {
        if (null == guuid) {
            return null;
        }
        MoveBillCache moveBillcache = MoveBillCacheManager.getCacheInfo(guuid);
        PDAOnlyMessageInfo pdaOnlyInfo = null;
        if (null == moveBillcache) {
            if (null == pdaOnlyInfo) {
                pdaOnlyInfo = new PDAOnlyMessageInfo();
                pdaOnlyInfo.setGuid(guuid);
                pdaOnlyInfo.setIsFlag(false);
            }
        } else {
            pdaOnlyInfo = (PDAOnlyMessageInfo)moveBillcache.getValue();
            if (pdaOnlyInfo.isIsFlag()) {
                return BarcodeServerUtils.isEmpty(pdaOnlyInfo.getBillNumber()) ? null : pdaOnlyInfo.getBillNumber();
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("guid", (Object)guuid));
            filter.getFilterItems().add(new FilterItemInfo("isFlag", (Object)true));
            IPDAOnlyMessage iPDAOnlyMessage = PDAOnlyMessageFactory.getLocalInstance(ctx);
            if (iPDAOnlyMessage.exists(filter)) {
                pdaOnlyInfo = iPDAOnlyMessage.getPDAOnlyInfoByGuuId(guuid);
                return BarcodeServerUtils.isEmpty(pdaOnlyInfo.getBillNumber()) ? null : pdaOnlyInfo.getBillNumber();
            }
            return "submit";
        }
        moveBillcache = new MoveBillCache();
        moveBillcache.setKey(guuid);
        moveBillcache.setValue(pdaOnlyInfo);
        MoveBillCacheManager.putCache(guuid, moveBillcache);
        return null;
    }

    public static String temPCheckReaptBill(Context ctx, String guuid) throws EASBizException, BOSException {
        if (null == guuid) {
            return null;
        }
        MoveBillCache moveBillcache = MoveBillCacheManager.getCacheInfo(guuid);
        PDAOnlyMessageInfo pdaOnlyInfo = null;
        if (null == moveBillcache) {
            if (null == pdaOnlyInfo) {
                pdaOnlyInfo = new PDAOnlyMessageInfo();
                pdaOnlyInfo.setGuid(guuid);
                pdaOnlyInfo.setIsFlag(false);
            }
        } else {
            return "submit";
        }
        moveBillcache = new MoveBillCache();
        moveBillcache.setKey(guuid);
        moveBillcache.setValue(pdaOnlyInfo);
        MoveBillCacheManager.putCache(guuid, moveBillcache);
        return null;
    }

    public static void updatePDAOnlyMessageInfo(Context ctx, String guuid, boolean isFlag, String billNumber) throws EASBizException, BOSException {
        MoveBillCache moveBillcache = MoveBillCacheManager.getCacheInfo(guuid);
        if (null != moveBillcache) {
            PDAOnlyMessageInfo pdaOnlyInfo = (PDAOnlyMessageInfo)moveBillcache.getValue();
            pdaOnlyInfo.setIsFlag(isFlag);
            pdaOnlyInfo.setBillNumber(billNumber);
            moveBillcache.setValue(pdaOnlyInfo);
            MoveBillCacheManager.putCacheInfo(guuid, pdaOnlyInfo, 1000L);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("guid", (Object)guuid));
        IPDAOnlyMessage iPDAOnlyMessage = PDAOnlyMessageFactory.getLocalInstance(ctx);
        if (isFlag && !iPDAOnlyMessage.exists(filter)) {
            PDAOnlyMessageInfo pdaOnlyInfo = new PDAOnlyMessageInfo();
            pdaOnlyInfo.setGuid(guuid);
            pdaOnlyInfo.setIsFlag(isFlag);
            pdaOnlyInfo.setBillNumber(billNumber);
            iPDAOnlyMessage.save(pdaOnlyInfo);
        }
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() <= 0;
    }

    public static synchronized String checkReaptBarcode(Context ctx, String[] barcodeArg, String guuid) throws EASBizException, BOSException {
        if (null == barcodeArg) {
            return null;
        }
        StringBuffer bars = new StringBuffer();
        HashSet<String> barcodeSet = new HashSet<String>();
        for (String barcode : barcodeArg) {
            ArrayList<String> guuidList;
            if (barcodeSet.contains(barcode)) continue;
            barcodeSet.add(barcode);
            if (barcode == null) continue;
            MoveBillCache moveBillcache = MoveBarcodeCacheManager.getCacheInfo(barcode = barcode.trim());
            if (null == moveBillcache) {
                moveBillcache = new MoveBillCache();
                moveBillcache.setKey(barcode);
                guuidList = new ArrayList<String>();
                guuidList.add(guuid);
                moveBillcache.setValue(guuidList);
                MoveBarcodeCacheManager.putCache(barcode, moveBillcache);
                continue;
            }
            if (moveBillcache.getValue() != null) {
                guuidList = (ArrayList<String>)moveBillcache.getValue();
                guuidList.add(guuid);
                moveBillcache.setValue(guuidList);
                MoveBarcodeCacheManager.putCache(barcode, moveBillcache);
            }
            if (bars.length() > 0) {
                bars.append(",").append(barcode.substring(barcode.indexOf("-") + 1, barcode.length()));
                continue;
            }
            bars.append(barcode.substring(barcode.indexOf("-") + 1, barcode.length()));
        }
        barcodeSet.clear();
        return bars.toString();
    }

    public static void clearMap(String guuid, String barcodeStr) {
        MoveBillCache moveBillcache;
        if (guuid != null && (moveBillcache = MoveBillCacheManager.getCacheInfo(guuid)) != null && moveBillcache.getValue() != null) {
            MoveBillCacheManager.clearOnly(guuid);
            logger.info((Object)("\u5355\u636e\u751f\u6210\u5931\u8d25\uff0c\u6e05\u7a7a\u7f13\u5b58 MoveBillCacheManager \u4e2d\u7684 " + guuid));
        }
        BarcodeServerUtils.clearBarcodeMap(guuid, barcodeStr);
    }

    public static void clearBarcodeMap(String guuid, String barcodeStr) {
        if (barcodeStr != null && barcodeStr.length() > 0) {
            String[] bar = barcodeStr.split(",");
            int size = bar.length;
            for (int i = 0; i < size; ++i) {
                String barcode;
                MoveBillCache moveBillcache;
                if (bar[i] == null || (moveBillcache = MoveBarcodeCacheManager.getCacheInfo(barcode = bar[i].trim())) == null || moveBillcache.getValue() == null) continue;
                List guuidList = (List)moveBillcache.getValue();
                if (guuidList.size() <= 1) {
                    MoveBarcodeCacheManager.clearOnly(barcode);
                    continue;
                }
                if (!guuidList.contains(guuid)) continue;
                guuidList.remove(guuid);
            }
        }
    }
}

