/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.barcode.scm.BarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.BarcodeTypeCollection;
import com.kingdee.eas.barcode.scm.BarcodeTypeFactory;
import com.kingdee.eas.barcode.scm.BarcodeTypeInfo;
import com.kingdee.eas.barcode.scm.IndBarcodeMasterFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.app.AbstractBarcodeTypeControllerBean;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BarcodeTypeControllerBean
extends AbstractBarcodeTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.barcode.app.BarcodeTypeControllerBean");
    public static Pattern pattern = Pattern.compile("^\\d{2}$");
    public static String FLAG_TABLE = "T_BC_BARCODETYPEFLAG";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(model, ctx);
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.verify(model, ctx);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BarcodeTypeInfo info = (BarcodeTypeInfo)this.getValue(ctx, pk);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("barcodeType.id", (Object)pk, CompareType.EQUALS));
        if (IndBarcodeRuleFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"isRalationIndRule", (Locale)ctx.getLocale())));
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("barcodeType.id", (Object)pk, CompareType.EQUALS));
        if (BarcodeRuleFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"isRalationRule", (Locale)ctx.getLocale())));
        }
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("barcodeType.id", (Object)pk, CompareType.EQUALS));
        if (IndBarcodeMasterFactory.getLocalInstance(ctx).exists(filterInfo)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"isRalationMaster", (Locale)ctx.getLocale())));
        }
        super._delete(ctx, pk);
    }

    protected void verify(IObjectValue model, Context ctx) throws EASBizException, BOSException {
        BarcodeTypeInfo info = (BarcodeTypeInfo)model;
        if (info.getNumber() == null || "".equals(info.getNumber().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"7_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.getName() == null || "".equals(info.getName().trim())) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"8_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
        if (info.isUseSign() && (info.getSign() == null || info.getSign().equals(""))) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"53_BarcodeTypeControllerBean", (Locale)ctx.getLocale())));
        }
        BarcodeTypeCollection coll = BarcodeTypeFactory.getLocalInstance(ctx).getBarcodeTypeCollection("select id,number,sign where number != '" + info.getNumber() + "'");
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                BarcodeTypeInfo typeInfo = coll.get(i);
                String sign = typeInfo.getSign();
                String currSign = info.getSign();
                if (!info.isUseSign() || sign == null || sign.equals("") || sign.indexOf(currSign) < 0 && currSign.indexOf(sign) < 0) continue;
                throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"55_BarcodeTypeControllerBean", (Locale)ctx.getLocale()) + typeInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"56_BarcodeTypeControllerBean", (Locale)ctx.getLocale())));
            }
        }
        String idFilter = "";
        if (info.getId() != null) {
            idFilter = " and id<>'" + info.getId().toString() + "'";
        }
        if (this._exists(ctx, "where number='" + info.getNumber() + "' " + idFilter)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"10_BarcodeConfigControllerBean", (Locale)ctx.getLocale())));
        }
    }

    @Override
    protected String _getFlag(Context ctx) throws BOSException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fflag from " + FLAG_TABLE + " where findex=1"));
        String result = null;
        try {
            if (rs.next()) {
                result = rs.getString("fflag");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected boolean _saveFlag(Context ctx, String flag) throws BOSException, EASBizException {
        if (flag == null || flag.trim().length() != 1) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.barcode.scm.BARCODEAutoGenerateResource", (String)"57_BarcodeTypeControllerBean", (Locale)ctx.getLocale())));
        }
        if (flag != null && !"".equals(flag.trim())) {
            if (flag.equals("'")) {
                flag = "''";
            }
            DbUtil.execute((Context)ctx, (String)("update " + FLAG_TABLE + " set fflag='" + flag.trim() + "' where findex=1"));
        }
        return true;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        BarcodeTypeInfo info = (BarcodeTypeInfo)super._getValue(ctx, pk, sic);
        return info.getNumber();
    }
}

