/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.barcode.scm.BarcodeDossierCollection;
import com.kingdee.eas.barcode.scm.BarcodeDossierInfo;
import com.kingdee.eas.barcode.scm.BarcodeFacadeFactory;
import com.kingdee.eas.barcode.scm.BarcodeGenResult;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParamInfo;
import com.kingdee.eas.barcode.scm.BarcodeGenerateParams;
import com.kingdee.eas.barcode.scm.BarcodeUtils;
import com.kingdee.eas.barcode.scm.BarcodeWSException;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeRuleFactory;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupCollection;
import com.kingdee.eas.barcode.scm.IndBarcodeSetupFactory;
import com.kingdee.eas.barcode.scm.app.AbstractBasedataDefaultBarcodeFacadeControllerBean;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.log4j.Logger;

public class BasedataDefaultBarcodeFacadeControllerBean
extends AbstractBasedataDefaultBarcodeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.scm.app.BasedataDefaultBarcodeFacadeControllerBean");

    @Override
    protected void _materialGeneateBarcodes(Context ctx) throws BOSException, EASBizException {
        BarcodeGenerateParams params = this.geneateBarcodes(ctx);
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user == null) {
            user = UserFactory.getLocalInstance((Context)ctx).getUserInfo(ctx.getCaller());
        }
        try {
            if (user.getDefOrgUnit() != null) {
                OrgSwitchFacadeFactory.getLocalInstance((Context)ctx).orgSwitch(user.getDefOrgUnit().getId().toString());
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new BOSException("\u7528\u6237\u65e0\u7f3a\u7701\u7ec4\u7ec7");
        }
        BarcodeGenResult result = BarcodeFacadeFactory.getLocalInstance(ctx).geneateBarcodes(params);
        if (result != null) {
            BarcodeDossierCollection barcodeCol = result.getBarcodes();
            StringBuffer updateSql = new StringBuffer();
            StringBuffer idStr = new StringBuffer();
            int size = barcodeCol.size();
            for (int i = 0; i < size; ++i) {
                BarcodeDossierInfo dossierInfo = barcodeCol.get(i);
                if (dossierInfo.getMaterial() == null) continue;
                if (idStr.length() > 0) {
                    idStr.append("','").append(dossierInfo.getMaterial().getId());
                    continue;
                }
                idStr.append(dossierInfo.getMaterial().getId());
            }
            if (idStr.length() > 0) {
                updateSql.append("update T_BD_Material set FIsGeneateBarcodes=1 ").append("\t\n");
                updateSql.append("where fid in('").append(idStr.toString()).append("')");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
            }
        }
    }

    private BarcodeGenerateParams geneateBarcodes(Context ctx) throws BOSException, BarcodeWSException {
        BarcodeGenerateParams barcodeGenParam = new BarcodeGenerateParams();
        StringBuffer sqlSelect = new StringBuffer();
        sqlSelect.append("select  ").append("\t\n");
        sqlSelect.append(" material.fid").append("\t\n");
        sqlSelect.append("from T_BD_Material  material").append("\t\n");
        sqlSelect.append("left join T_BD_MaterialInventory inventory on inventory.fmaterialId=material.fid").append("\t\n");
        sqlSelect.append("where 1=1").append("\t\n");
        sqlSelect.append(" and material.FStatus=").append(1).append("\t\n");
        sqlSelect.append(" and FIsGeneateBarcodes=0").append("\t\n");
        sqlSelect.append(" and inventory.fisBarcode=1").append("\t\n");
        sqlSelect.append(" group by material.fid,material.fnumber").append("\t\n");
        sqlSelect.append(" order by material.fnumber").append("\t\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSelect.toString());
        try {
            ArrayList<BarcodeGenerateParamInfo> pList = new ArrayList<BarcodeGenerateParamInfo>();
            while (rs.next()) {
                BarcodeGenerateParamInfo pInfo = new BarcodeGenerateParamInfo();
                pInfo.setBillId(rs.getString("fid"));
                pInfo.setBarcodeCount(1);
                pInfo.setBarcodeDate(new Date());
                pInfo.setTotalCount(new BigDecimal(1));
                pInfo.setBarcodeQty(new BigDecimal(1));
                pList.add(pInfo);
            }
            barcodeGenParam.setParamList(pList);
            MaterialInfo materialInfo = new MaterialInfo();
            String bosType = materialInfo.getBOSType().toString();
            EntityObjectInfo entryEntity = BarcodeUtils.getEntityByBosType(bosType);
            barcodeGenParam.setEntity(entryEntity);
            IndBarcodeRuleCollection ruleCol = IndBarcodeRuleFactory.getLocalInstance(ctx).getIndBarcodeRuleCollection("select fid from where isDefault=1 and businessObjectID='" + bosType + "'");
            if (ruleCol.size() <= 0) {
                throw new BarcodeWSException(BarcodeWSException.BARCODERUDEISNULL);
            }
            barcodeGenParam.setBarcodeRuleId(ruleCol.get(0).getId().toString());
            IndBarcodeSetupCollection setupCol = IndBarcodeSetupFactory.getLocalInstance(ctx).getIndBarcodeSetupCollection("select fid from where isDefault=1 and businessObjectID='" + bosType + "'");
            if (setupCol.size() <= 0) {
                throw new BarcodeWSException(BarcodeWSException.SETUPISNULL);
            }
            barcodeGenParam.setIndBarcodeSetupId(setupCol.get(0).getId().toString());
            barcodeGenParam.setBaseData(true);
            barcodeGenParam.setSave(true);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return barcodeGenParam;
    }
}

