/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScmBillProcessor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.uw.app.ScmBillProcess");
    private static Map comMap = new HashMap();

    public void updateEntryQtyCompany(Context ctx, IObjectValue bill) {
        if (!(bill instanceof SCMBillBaseInfo)) {
            return;
        }
        try {
            IObjectCollection coll;
            if (bill.get("bizDate") == null) {
                bill.put("bizDate", (Object)new Date());
            }
            if ((coll = (IObjectCollection)bill.get("entry")) != null && coll.size() > 0) {
                for (int i = 0; i < coll.size(); ++i) {
                    InvBillBaseEntryInfo temp;
                    SCMBillEntryBaseInfo entry = (SCMBillEntryBaseInfo)coll.getObject(i);
                    this.calBaseQtyByQty(ctx, entry);
                    if (!(entry instanceof InvBillBaseEntryInfo) || (temp = (InvBillBaseEntryInfo)entry).getCompanyOrgUnit() != null) continue;
                    StorageOrgUnitInfo sou = ((InvBillBaseInfo)bill).getStorageOrgUnit();
                    temp.setCompanyOrgUnit(ScmBillProcessor.getCompany(ctx, sou));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateEntryQtyCompany has exception ", (Throwable)e);
        }
    }

    protected void calBaseQtyByQty(Context ctx, SCMBillEntryBaseInfo entry) {
        BigDecimal qty = (BigDecimal)entry.get("qty");
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (qty != null && qty.compareTo(SysConstant.BIGZERO) == 0) {
            entry.put("baseQty", (Object)baseQty);
            return;
        }
        try {
            BigDecimal coefficient;
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)entry.get("unit");
            MaterialInfo material = (MaterialInfo)entry.get("material");
            if (unitInfo == null || material == null) {
                return;
            }
            MultiMeasureUnitInfo mulUnit = this.getMulUnit(ctx, unitInfo, material);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = material.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId())).getBaseUnit();
                    entry.put("baseUnit", (Object)baseUnit);
                }
                mulUnit = this.getMulUnit(ctx, baseUnit, material);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            entry.put("baseQty", (Object)baseQty);
        }
        catch (BaseException e) {
            logger.error((Object)"error in calculate base qty", (Throwable)e);
        }
    }

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        if (comMap.get(sou.getId().toString()) == null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo compInfo = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 1);
            if (compInfo == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 1);
                compInfo = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            if (compInfo != null) {
                String oql = "SELECT *, baseCurrency.precision WHERE id ='" + compInfo.getId().toString() + "'";
                compInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
            }
            comMap.put(sou.getId().toString(), compInfo);
        }
        return (CompanyOrgUnitInfo)comMap.get(sou.getId().toString());
    }
}

