/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app;

import com.kingdee.eas.barcode.scm.app.Formula;
import com.kingdee.eas.barcode.scm.app.IUWFormulaProcessor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class UWMathFormulaProcessor
implements IUWFormulaProcessor {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.barcode.uw.app.MathFormulaProcessor");
    private static final BigDecimal ZERO = new BigDecimal("0");
    private static final int SCALE = 8;

    public Formula parse(String formula) {
        logger.debug((Object)("UW: parse  formula, " + formula));
        Formula f = null;
        String pStr = "[\\+\\-\\*/\\\\]";
        String[] dArr = null;
        try {
            dArr = formula.split(pStr);
        }
        catch (PatternSyntaxException e) {
            logger.error((Object)" invalid formula, ", (Throwable)e);
        }
        if (dArr != null) {
            int startInd = dArr[0].length();
            int endInd = formula.indexOf(dArr[1]);
            String op = formula.substring(startInd, endInd).trim();
            String fldA = dArr[0].replace("[", "").replace("]", "");
            String fldB = dArr[1].replace("[", "").replace("]", "");
            logger.debug((Object)("UW: fldA, " + fldA + ", op, " + op + ", fldB, " + fldB));
            f = new Formula(fldA, fldB, op);
        }
        return f;
    }

    @Override
    public Object calculate(String formula, Map<String, String> tMap) {
        Object rtnVal = null;
        logger.debug((Object)("UW: parse  formula, " + formula));
        String[] oprds = null;
        try {
            oprds = formula.split("[\\+\\-\\*/]");
        }
        catch (PatternSyntaxException e) {
            logger.error((Object)" invalid formula, ", (Throwable)e);
        }
        String withValFormula = this.replaceWithValue(formula, oprds, tMap);
        Context cx = Context.enter();
        ScriptableObject scope = cx.initStandardObjects();
        rtnVal = cx.evaluateString((Scriptable)scope, withValFormula, "", 1, null);
        logger.debug((Object)(" java's scriptEngine evaluated: " + rtnVal));
        BigDecimal amt = new BigDecimal(rtnVal.toString());
        amt = amt.setScale(8, RoundingMode.HALF_UP);
        rtnVal = amt;
        logger.debug((Object)(" set scale: " + amt));
        return rtnVal;
    }

    private String replaceWithValue(String formula, String[] oprds, Map<String, String> tMap) {
        String vFormula = formula;
        for (String oprd : oprds) {
            String bindProp = Formula.getBindName(oprd);
            String bindVal = tMap.get(bindProp);
            if (bindVal == null) continue;
            vFormula = vFormula.replace("[" + bindProp + "]", bindVal);
        }
        logger.debug((Object)("formula: repalced with value , " + vFormula));
        return vFormula;
    }

    public String calculateStr(String formula, Map<String, String> tMap) {
        String rtnVal = null;
        Formula f = this.parse(formula);
        if (f == null) {
            return rtnVal;
        }
        String fldA = f.getOpA();
        String fldB = f.getOpB();
        String op = f.getOperator();
        String valA = tMap.get(fldA);
        String valB = tMap.get(fldB);
        if (valA != null && valB != null) {
            try {
                BigDecimal amtA = new BigDecimal(valA);
                BigDecimal amtB = new BigDecimal(valB);
                logger.debug((Object)("UW: amtA, " + amtA + ", amtB, " + amtB));
                BigDecimal amtR = null;
                if (op.equals("+")) {
                    amtR = amtA.add(amtB);
                } else if (op.equals("-")) {
                    amtR = amtA.subtract(amtB);
                } else if (op.equals("*")) {
                    amtR = amtA.multiply(amtB).setScale(8, RoundingMode.HALF_UP);
                } else if (op.equals("/")) {
                    if (amtB.compareTo(ZERO) != 0) {
                        amtR = amtA.divide(amtB, 8, RoundingMode.HALF_UP);
                    } else {
                        logger.error((Object)"UW: cal formula, division is zero, null calc result");
                    }
                }
                logger.debug((Object)("UW: result : " + amtR));
                if (amtR != null) {
                    rtnVal = amtR.toString();
                }
            }
            catch (NumberFormatException e) {
                logger.error((Object)"UW: calculate formula, value invalid BigDecimal", (Throwable)e);
            }
        }
        return rtnVal;
    }
}

