/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.app.bizprocess;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.im.inv.app.SaleIssueAlgorithmForInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class ScmDataProcess {
    private static Map comMap = new HashMap();

    public void beforeSaveEasBill(Context ctx, IObjectValue bill) {
        try {
            if (bill instanceof SCMBillBaseInfo) {
                IObjectCollection coll;
                if (bill.get("bizDate") == null) {
                    bill.put("bizDate", (Object)new Date());
                }
                if ((coll = (IObjectCollection)bill.get("entry")) != null) {
                    for (int i = 0; i < coll.size(); ++i) {
                        InvBillBaseEntryInfo temp;
                        IObjectValue entry = coll.getObject(i);
                        this.calBaseQtyByQty(ctx, (SCMBillBaseInfo)bill, (SCMBillEntryBaseInfo)entry);
                        if (!(coll.getObject(i) instanceof InvBillBaseEntryInfo) || (temp = (InvBillBaseEntryInfo)entry).getCompanyOrgUnit() != null) continue;
                        StorageOrgUnitInfo sou = ((InvBillBaseInfo)bill).getStorageOrgUnit();
                        temp.setCompanyOrgUnit(ScmDataProcess.getCompany(ctx, sou));
                    }
                }
            }
            if (bill instanceof SaleIssueBillInfo) {
                new SaleIssueAlgorithmForInfo((SaleIssueBillInfo)bill, ctx).revalue();
            }
            if (bill instanceof PurInWarehsBillInfo) {
                new PurInAlgorithmForInfo((PurInWarehsBillInfo)bill, ctx).revalue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setUnitbyMatertial(Context ctx, SCMBillEntryBaseInfo entry) {
        try {
            IMaterial imateral = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialInfo materialInfo = entry.getMaterial();
            if (materialInfo.getId() != null) {
                materialInfo = imateral.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()));
            }
            if (entry.getAssistUnit() == null) {
                entry.setAssistUnit(materialInfo.getAssistUnit());
            }
            if (entry.getBaseUnit() == null) {
                entry.setBaseUnit(materialInfo.getBaseUnit());
            }
            if (entry.getUnit() == null) {
                entry.setUnit(materialInfo.getBaseUnit());
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void calBaseQtyByQty(Context ctx, SCMBillBaseInfo bill, SCMBillEntryBaseInfo entry) {
        this.setUnitbyMatertial(ctx, entry);
        BigDecimal qty = (BigDecimal)entry.get("qty");
        BigDecimal baseQty = SysConstant.BIGZERO;
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        if (qty != null && qty.compareTo(SysConstant.BIGZERO) == 0) {
            entry.put("baseQty", (Object)baseQty);
            return;
        }
        try {
            MultiMeasureUnitInfo assitmulUnit;
            MeasureUnitInfo assitUnitInfo;
            BigDecimal coefficient;
            MeasureUnitInfo unitInfo = (MeasureUnitInfo)entry.get("unit");
            MaterialInfo material = (MaterialInfo)entry.get("material");
            if (unitInfo == null || material == null) {
                return;
            }
            MultiMeasureUnitInfo mulUnit = this.getMulUnit(ctx, unitInfo, material);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = material.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = null;
                    im = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(material.getId())).getBaseUnit();
                    entry.put("baseUnit", (Object)baseUnit);
                }
                mulUnit = this.getMulUnit(ctx, baseUnit, material);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            if ((assitUnitInfo = entry.getAssistUnit()) != null && (assitmulUnit = this.getMulUnit(ctx, assitUnitInfo, material)) != null) {
                BigDecimal coefficient2 = assitmulUnit.getBaseConvsRate();
                mulUnit = this.getMulUnit(ctx, assitUnitInfo, material);
                int precision = mulUnit.getQtyPrecision();
                entry.put("assistQty", (Object)this.calAssitQtyByQty(ctx, baseQty, coefficient2, precision));
            }
            entry.put("baseQty", (Object)baseQty);
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected MultiMeasureUnitInfo getMulUnit(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = null;
        immu = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    protected BigDecimal calAssitQtyByQty(Context ctx, BigDecimal baseQty, BigDecimal convsRate, int precision) {
        BigDecimal assQty;
        BigDecimal coefficient = convsRate != null ? convsRate : new BigDecimal("1.00");
        BigDecimal bigDecimal = assQty = baseQty != null ? baseQty : new BigDecimal("0.00000");
        if (baseQty != null) {
            assQty = baseQty.divide(coefficient, precision, 4);
        }
        return assQty;
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        if (comMap.get(sou.getId().toString()) == null) {
            IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 4, 1);
            if (ret == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 4, 1);
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            if (ret != null) {
                String oql = "SELECT *, baseCurrency.precision WHERE id ='" + ret.getId().toString() + "'";
                ret = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
            }
            comMap.put(sou.getId().toString(), ret);
        }
        return (CompanyOrgUnitInfo)comMap.get(sou.getId().toString());
    }
}

