/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Json {
    public static final int MAX_LEVEL = 36;
    public static final String JSON_PREFIX = "json:";
    public static final Object NULL = new Object();

    public static void escape(String s, StringBuilder sb) {
        sb.append('\"');
        int j = s.length();
        block8: for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
    }

    public static String toString(Object o) {
        return Json.toString(o, false);
    }

    public static String toString(Object o, boolean withoutBrackets) {
        String s;
        if (o instanceof String && (s = (String)o).startsWith(JSON_PREFIX)) {
            return s.substring(JSON_PREFIX.length());
        }
        StringBuilder sb = new StringBuilder();
        Json.toString(o, sb, 0, withoutBrackets);
        return sb.toString();
    }

    public static StringBuilder toString(Object o, StringBuilder buffer, int level) {
        return Json.toString(o, buffer, level, false);
    }

    private static StringBuilder toString(Object o, StringBuilder buffer, int level, boolean withoutBrackets) {
        if (level >= 36) {
            throw new RuntimeException("Collection or Map nested level is too deep, and there may be exist a recursive reference.");
        }
        if (o == null || o == NULL) {
            return buffer.append("null");
        }
        if (o instanceof Boolean) {
            return buffer.append(o);
        }
        if (o instanceof BigDecimal) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof Number) {
            return buffer.append(o).append(' ');
        }
        if (o instanceof String) {
            Json.escape((String)o, buffer);
            return buffer;
        }
        if (o instanceof Object[]) {
            return Json.toString((Object[])o, buffer, level + 1, withoutBrackets);
        }
        if (o instanceof Collection) {
            return Json.toString((Collection)o, buffer, level + 1, withoutBrackets);
        }
        if (o instanceof Map) {
            return Json.toString((Map)o, buffer, level + 1, withoutBrackets);
        }
        if (o instanceof Date) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof Time) {
            return buffer.append('\"').append(o).append('\"');
        }
        if (o instanceof java.util.Date) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return buffer.append('\"').append(df.format((java.util.Date)o)).append('\"');
        }
        if (o instanceof Map.Entry) {
            Map.Entry p = (Map.Entry)o;
            if (!withoutBrackets) {
                buffer.append("(");
            }
            buffer.append("{");
            buffer.append("\"key\":");
            Json.toString(p.getKey(), buffer, level + 1, withoutBrackets);
            buffer.append(",\"value\":");
            Json.toString(p.getValue(), buffer, level + 1, withoutBrackets);
            buffer.append("}");
            if (!withoutBrackets) {
                buffer.append(")");
            }
            return buffer;
        }
        Json.escape(o.toString(), buffer);
        return buffer;
    }

    private static StringBuilder toString(Collection<?> l, StringBuilder buffer, int level, boolean withoutBrackets) {
        if (!withoutBrackets) {
            buffer.append("(");
        }
        buffer.append("[");
        boolean first = true;
        Iterator<?> it = l.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            Json.toString(it.next(), buffer, level + 1, withoutBrackets);
        }
        buffer.append("]");
        if (!withoutBrackets) {
            buffer.append(")");
        }
        return buffer;
    }

    private static StringBuilder toString(Object[] a, StringBuilder buffer, int level, boolean withoutBrackets) {
        if (!withoutBrackets) {
            buffer.append("(");
        }
        buffer.append("[");
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            Json.toString(a[i], buffer, level + 1, withoutBrackets);
        }
        buffer.append("]");
        if (!withoutBrackets) {
            buffer.append(")");
        }
        return buffer;
    }

    private static StringBuilder toString(Map<?, ?> m, StringBuilder buffer, int level, boolean withoutBrackets) {
        if (!withoutBrackets) {
            buffer.append("(");
        }
        buffer.append("{");
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (first) {
                first = false;
            } else {
                buffer.append(",");
            }
            Object key = entry.getKey();
            Json.toString(key, buffer, level + 1, withoutBrackets);
            buffer.append(":");
            Json.toString(value, buffer, level + 1, withoutBrackets);
        }
        buffer.append("}");
        if (!withoutBrackets) {
            buffer.append(")");
        }
        return buffer;
    }

    public static Object toObject(String json) {
        if (json == null || json.length() == 0) {
            return null;
        }
        StringReader sr = new StringReader(json);
        try {
            if (json.startsWith(JSON_PREFIX)) {
                for (int i = 0; i < JSON_PREFIX.length(); ++i) {
                    sr.read();
                }
            }
            return Json.toObject(sr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object toObject(Reader sr) throws IOException {
        int i = sr.read();
        if (i == 40) {
            i = sr.read();
        }
        switch (i) {
            case 34: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 91: 
            case 102: 
            case 110: 
            case 116: 
            case 123: {
                return Json.asObject(sr, i);
            }
        }
        throw new RuntimeException("Invalid json format, unexpected char : " + (char)i + "(" + i + ")");
    }

    private static Object asObject(Reader sr, int priorChar) throws IOException {
        switch (priorChar) {
            case 110: {
                return Json.asNull(sr);
            }
            case 102: 
            case 116: {
                return Json.asBoolean(sr);
            }
            case 34: {
                return Json.asString(sr);
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return Json.asNumber(sr, priorChar);
            }
            case 91: {
                return Json.asList(sr);
            }
            case 123: {
                return Json.asMap(sr);
            }
            case 42: {
                return null;
            }
        }
        throw new RuntimeException("invalid json format");
    }

    private static Object asNumber(Reader sr, int priorChar) throws IOException {
        StringBuilder s = new StringBuilder();
        s.append((char)priorChar);
        int c = sr.read();
        while (c != 32 && c >= 0) {
            s.append((char)c);
            c = sr.read();
        }
        String t = s.toString();
        if (t.indexOf(46) >= 0) {
            return new BigDecimal(t);
        }
        if (t.length() >= 9) {
            return new Long(t);
        }
        return new Integer(t);
    }

    private static Object asString(Reader s) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = s.read();
        while (c >= 0) {
            block0 : switch (c) {
                case 34: {
                    return sb.toString();
                }
                case 92: {
                    c = s.read();
                    switch (c) {
                        case 114: {
                            sb.append("\r");
                            break block0;
                        }
                        case 110: {
                            sb.append("\n");
                            break block0;
                        }
                        case 39: {
                            sb.append("'");
                            break block0;
                        }
                        case 34: {
                            sb.append('\"');
                            break block0;
                        }
                        case 116: {
                            sb.append("\t");
                            break block0;
                        }
                        case 92: {
                            sb.append("\\");
                            break block0;
                        }
                    }
                    throw new RuntimeException("\\" + (char)c + " is not valid char.");
                }
                default: {
                    sb.append((char)c);
                }
            }
            c = s.read();
        }
        return sb.length() != 0 ? sb.toString() : null;
    }

    private static Object asNull(Reader s) throws IOException {
        s.read();
        s.read();
        s.read();
        return null;
    }

    private static Object asBoolean(Reader s) throws IOException {
        s.read();
        s.read();
        int i = s.read();
        if (i == 101) {
            return Boolean.TRUE;
        }
        s.read();
        return Boolean.FALSE;
    }

    private static ArrayList<Object> asList(Reader s) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int c = s.read();
        block5: while (c >= 0) {
            switch (c) {
                case 93: {
                    return list;
                }
                case 34: 
                case 42: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 91: 
                case 102: 
                case 110: 
                case 116: 
                case 123: {
                    list.add(Json.asObject(s, c));
                    c = s.read();
                    continue block5;
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    continue block5;
                }
            }
            throw new RuntimeException("char {" + (char)c + "} is an invalid char.");
        }
        return list;
    }

    private static LinkedHashMap<Object, Object> asMap(Reader s) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int c = s.read();
        block5: while (c >= 0) {
            switch (c) {
                case 125: {
                    return map;
                }
                case 34: 
                case 42: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 91: 
                case 102: 
                case 110: 
                case 116: 
                case 123: {
                    Object key = Json.asObject(s, c);
                    s.read();
                    Object value = Json.toObject(s);
                    map.put(key, value);
                    c = s.read();
                    continue block5;
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    continue block5;
                }
            }
            throw new RuntimeException("char {" + (char)c + "} is an invalid char.");
        }
        return map;
    }

    public static boolean isQName(String name) {
        if (!Json.isLetter(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Json.isLetterOrDigital(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isInteger(String name) {
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Json.isDigital(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpace(char c) {
        return c <= ' ';
    }

    public static boolean isLetterOrDigital(char c) {
        return Json.isLetter(c) || Json.isDigital(c);
    }

    public static boolean isLetter(char c) {
        return c == '_' || c == '$' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isDigital(char c) {
        return c >= '0' && c <= '9';
    }

    public static void main(String[] args) throws Exception {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("key", "value1");
        map.put(true, false);
        map.put("key2", "value2");
        map.put("key3", "value3");
        map.put(true, false);
        map.put(33, 6);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("LIST");
        list.add(1);
        list.add(-1.2);
        Object[] array = new Object[]{true, false, "1", "2", map, list, "xx", null, -99.3, -0.3, 0.4, "", new java.util.Date(), false, 5};
        String s = Json.toString(array);
        System.out.println(s);
        Object o = Json.toObject(s);
        System.out.println(Json.toString(o));
    }
}

