/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.imageio.ImageIO;

public class QRCode {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    public static void main(String[] args) {
        QRCode test = new QRCode();
        File file = new File("C://test.png");
        test.encode("helloworld,I'm Hongten.welcome to my zone:http://www.cnblogs.com/hongten", file, BarcodeFormat.QR_CODE, 200, 200, null);
        test.decode(file);
    }

    public void encode(String contents, File file, BarcodeFormat format, int width, int height, Map<EncodeHintType, ?> hints) {
        try {
            contents = new String(contents.getBytes("UTF-8"), "ISO-8859-1");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(contents, format, width, height);
            QRCode.writeToFile(bitMatrix, "png", file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeToFile(BitMatrix matrix, String format, File file) throws IOException {
        BufferedImage image = QRCode.toBufferedImage(matrix);
        ImageIO.write((RenderedImage)image, format, file);
    }

    public static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public void decode(File file) {
    }
}

