/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.barcode.scm.util;

import com.kingdee.eas.barcode.scm.util.FMHelper;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class UWDateHelper {
    public static final int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    public static final String FORMAT_DAY_STR = "yyyy-MM-dd";
    public static final String FORMAT_TIME_STR = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_TIMEMIL_STR = "yyyy-MM-dd HH:mm:ss:SSS";
    public static final DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat FORMAT_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat FORMAT_TIMEMIL = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");

    public static List getTimeList(int beginYear, int beginMonth, int endYear, int endMonth, int k) {
        ArrayList<List> list = new ArrayList<List>();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                list.add(UWDateHelper.getTimeList(beginYear, j, k));
            }
        } else {
            int j;
            for (j = beginMonth; j < 12; ++j) {
                list.add(UWDateHelper.getTimeList(beginYear, j, k));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < 12; ++j2) {
                    list.add(UWDateHelper.getTimeList(i, j2, k));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                list.add(UWDateHelper.getTimeList(endYear, j, k));
            }
        }
        return list;
    }

    public static List getTimeList(int beginYear, int beginMonth, int k) {
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar begincal = new GregorianCalendar(beginYear, beginMonth, 1);
        int max = ((Calendar)begincal).getActualMaximum(5);
        for (int i = 1; i < max; i += k) {
            list.add(begincal.getTime());
            ((Calendar)begincal).add(5, k);
        }
        begincal = new GregorianCalendar(beginYear, beginMonth, max);
        list.add(begincal.getTime());
        return list;
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Timestamp getTimeStampDayBegin() {
        return new Timestamp(UWDateHelper.getDayBegin().getTime());
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getNextDay(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + 1);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) + 1);
        return cal.getTime();
    }

    public static Date getPreMonth(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(2, cal.get(2) - 1);
        return cal.getTime();
    }

    public static Date getPreMonthMaxDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(2, cal.get(2) - 1);
        cal.set(5, ((Calendar)cal).getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getNextMonthMaxDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(2, cal.get(2) + 1);
        cal.set(5, ((Calendar)cal).getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static java.sql.Date getSQLBegin(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        java.sql.Date ds = new java.sql.Date(cal.getTimeInMillis());
        return ds;
    }

    public static java.sql.Date getSQLEnd(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Date getFirstSeasonDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = UWDateHelper.getSeason(cal.get(2));
        cal.set(2, sean * 3 - 2);
        return cal.getTime();
    }

    public static Date getFirstYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static int getSeason(int mouth) {
        return SEASON[mouth];
    }

    public static Date getBeforeDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getAfterDay(Date thisDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(thisDate);
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static boolean isFirstDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) == 0 && cal.get(5) == 1;
    }

    public static Date getFirstYearDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date stringToDate(String s) {
        Date d = null;
        if (FMHelper.isEmpty(s)) {
            d = UWDateHelper.getDayBegin();
        } else {
            try {
                d = FORMAT_DAY.parse(s);
            }
            catch (ParseException e) {
                try {
                    d = new SimpleDateFormat().parse(s);
                }
                catch (ParseException e1) {
                    d = UWDateHelper.getDayBegin();
                }
            }
        }
        return d;
    }

    public static String DateToString(Date s) {
        return FORMAT_DAY.format(s);
    }

    public static String getDateStrByFormat(Date date, String format) {
        if (format == null) {
            format = FORMAT_DAY_STR;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String getDateStartStrByFormat(Date date) {
        return UWDateHelper.getDateStartStrByFormat(date, FORMAT_TIME_STR);
    }

    public static String getDateStartStrByFormat(Date date, String format) {
        if (format == null) {
            format = FORMAT_DAY_STR;
        }
        return new SimpleDateFormat(format).format(UWDateHelper.getDateStartTime(date));
    }

    public static Date getLastYearDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 11);
        cal.set(5, 31);
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static long dateDiff(Date date1, Date date2) {
        long date1ms = date1.getTime();
        long date2ms = date2.getTime();
        return date2ms - date1ms;
    }

    public static Date getDayBegin(Date da) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(da);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date ds = new Date(cal.getTimeInMillis());
        return ds;
    }

    public static Date getFirstDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMinimum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getFirstDayOfMonth(Date d) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.set(5, cal.getActualMinimum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getEndDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastDayOfCurMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, cal.getActualMaximum(5));
        return DateTimeUtils.truncateDate((Date)cal.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth2(Date date) {
        return DateTimeUtils.truncateDate((Date)UWDateHelper.getLastDayOfMonth(date));
    }

    public static String formatDate(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
        return df.format(d);
    }

    public static String formatDate2(Date d) {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_DAY_STR);
        return df.format(d);
    }

    public static Date max(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date1;
        }
        return date2;
    }

    public static Date min(Date date1, Date date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        if (date1.after(date2)) {
            return date2;
        }
        return date1;
    }

    public static java.sql.Date truncateSqlDate(java.sql.Date sqlDate) {
        Date date = new Date(sqlDate.getTime());
        return new java.sql.Date(DateTimeUtils.truncateDate((Date)date).getTime());
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue() + 1;
        return days;
    }

    public static java.sql.Date getSqlDate(Date date) {
        java.sql.Date sqlDate = new java.sql.Date(date.getTime());
        return sqlDate;
    }

    public static Date getYearDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1) + 1, 0, 0, 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getMonthDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(cal.get(1), cal.get(2) + 1, 0, 0, 0, 0);
        return new Date(cal.getTimeInMillis() / 1000L * 1000L);
    }

    public static Date getDayDate(Date date) {
        return DateTimeUtils.truncateDate((Date)date);
    }

    public static Date addDays(Date date, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        return calendar.getTime();
    }

    public static final Date getAMonthStartDate(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static final Date getDateStartTime(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static final String getNextOrPreXMonthStartDateStr(Date date, int x, String format) {
        return UWDateHelper.getDateStrByFormat(UWDateHelper.getNextOrPreXMonthStartDate(date, x), format);
    }

    public static final Date getNextOrPreXMonthStartDate(Date date, int x) {
        date = UWDateHelper.getAMonthStartDate(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, x);
        return c.getTime();
    }

    public static final String getNextOrPreXDateStartDateStr(Date date, int x) {
        return UWDateHelper.getDateStrByFormat(UWDateHelper.getNextOrPreXDateStartDate(date, x), FORMAT_TIME_STR);
    }

    public static final String getNextOrPreXDateStartDateStr(Date date, int x, String format) {
        return UWDateHelper.getDateStrByFormat(UWDateHelper.getNextOrPreXDateStartDate(date, x), format);
    }

    public static final Date getNextOrPreXDateStartDate(Date date, int x) {
        date = UWDateHelper.getDateStartTime(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, x);
        return c.getTime();
    }

    public static final Date tryParseDateStr(String dateStr) throws ParseException {
        if (FORMAT_DAY_STR.length() == dateStr.length()) {
            return FORMAT_DAY.parse(dateStr);
        }
        if (FORMAT_TIME_STR.length() == dateStr.length()) {
            return FORMAT_TIME.parse(dateStr);
        }
        if (FORMAT_TIMEMIL_STR.length() == dateStr.length()) {
            return FORMAT_TIMEMIL.parse(dateStr);
        }
        throw new ParseException("unkown format", 1);
    }
}

