/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CloseAccountFacadeFactory;
import com.kingdee.eas.scm.cal.ICloseAccountFacade;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.IPUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Map;

public class CloseJobHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;

    public Object execute(Job job) throws Exception {
        CompanyOrgUnitInfo company = null;
        Context ctx = null;
        MessageInfo info = null;
        boolean isCloseAccount = false;
        PeriodInfo oldPeriod = null;
        Connection conn = null;
        try {
            ctx = job.getContext();
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, "T_CL_COSTCOMPUTEREPORT");
            JobParam jobParam = (JobParam)job.getParameters();
            Object bizParam = jobParam.getBizParam();
            Map paraMap = null;
            Locale locale = null;
            if (bizParam != null && bizParam instanceof Object[]) {
                Object[] parObjs = (Object[])bizParam;
                company = (CompanyOrgUnitInfo)parObjs[0];
                paraMap = (Map)parObjs[1];
                locale = (Locale)parObjs[2];
                ctx.put((Object)"UserInfo", parObjs[3]);
                ctx.put((Object)OrgType.Company, (Object)company);
                ctx.put((Object)"CurOU", (Object)company);
                ctx.put((Object)OrgType.ControlUnit, parObjs[5]);
            }
            if (null == company || company.getId() == null) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            ctx.put((Object)"ClientName", (Object)IPUtils.getLocleAddress().getHostName());
            ctx.put((Object)"CAL_JOB_INST_ID", (Object)jobParam.getJobId());
            ctx.setLocale(jobParam.getLocale());
            String userId = ctx.getCaller().toString();
            oldPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
            info = new MessageInfo();
            info.setUserID(userId);
            info.setbizAction(oldPeriod.toString() + CalculateUtil.getCalServerResource(ctx, "CLOSEACCOUNT_CLOSE_MSG"));
            info.setOrgNumber(company.getName(locale) + "(" + company.getNumber() + ")");
            boolean isSendMsg = true;
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            try {
                isCloseAccount = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).isClosed(SystemEnum.INVENTORYMANAGEMENT, company);
                if (!isCloseAccount) {
                    this.doneCloseAccount(ctx, company);
                }
                ICloseAccountFacade iCloseAccountFacade = CloseAccountFacadeFactory.getLocalInstance(ctx);
                iCloseAccountFacade.closeAccount(company, paraMap);
                PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (curPeriodInfo != null && curPeriodInfo.isIsAdjustPeriod()) {
                    paraMap.put("period", curPeriodInfo);
                    iCloseAccountFacade.closeAccount(company, paraMap);
                }
                info.setSuccessed(true);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                this.delPriceSourceRpt(ctx, paraMap);
                this.stockPriceCalculate(ctx, company);
                this.delStockPrice(ctx, paraMap);
            }
            catch (EASBizException e) {
                if (!isCloseAccount && company != null && company.getId() != null) {
                    this.doneReverseCloseAccount(ctx, company);
                }
                info.setExecption(e.getMessage(ctx.getLocale()));
                info.setSuccessed(false);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                throw e;
            }
            catch (BOSException be) {
                if (!isCloseAccount && company != null && company.getId() != null) {
                    this.doneReverseCloseAccount(ctx, company);
                }
                info.setExecption(be.getMessage());
                info.setSuccessed(false);
                MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                throw be;
            }
            if (company != null && company.getId() != null) {
                this.doneReverseCloseAccount(ctx, company);
            }
        }
        catch (CalculateException ee) {
            try {
                if (info != null) {
                    info.setExecption(ee.getMessage(ctx.getLocale()));
                    info.setSuccessed(false);
                    MessageUtil.sendMsg((Context)ctx, info);
                }
                throw ee;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                JobLog log = new JobLog(JobLog.Type.Info, oldPeriod == null ? "" : oldPeriod.toString() + CalculateUtil.getCalServerResource(ctx, "CLOSEACCOUNT_FINISHED_MSG"));
                job.saveMessage(log);
                PerfSepServerUtils.updateTaskState((Job)job);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        JobLog log = new JobLog(JobLog.Type.Info, oldPeriod == null ? "" : oldPeriod.toString() + CalculateUtil.getCalServerResource(ctx, "CLOSEACCOUNT_FINISHED_MSG"));
        job.saveMessage(log);
        PerfSepServerUtils.updateTaskState((Job)job);
        return Boolean.TRUE;
    }

    private void doneCloseAccount(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, cou, true);
    }

    private void doneReverseCloseAccount(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, cou, false);
    }

    private void delPriceSourceRpt(final Context ctx, final Map paramMap) {
        new Thread(){

            @Override
            public void run() {
                CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
                PeriodInfo periodInfo = (PeriodInfo)paramMap.get("period");
                MessageInfo info = new MessageInfo();
                info.setbizAction(periodInfo.toString() + CalculateUtil.getCalServerResource(ctx, "deletePriceSourceRpt"));
                info.setOrgNumber(companyInfo.getName() + "(" + companyInfo.getNumber() + ")");
                info.setSuccessed(false);
                info.setUserID(ctx.getCaller().toString());
                info.setSendMsg(true);
                try {
                    int rpt_count = Integer.parseInt(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(companyInfo.getId()), "SCM_CAL_RPT_COUNT"));
                    PeriodInfo prePeriodInfo = CloseJobHandler.this.getPrePeriodInfo(ctx, periodInfo, rpt_count);
                    if (prePeriodInfo != null) {
                        StringBuffer sql = new StringBuffer();
                        StringBuffer whereSql = new StringBuffer();
                        whereSql.append(" select rpt.fid from T_CL_CostComputeRportHeader rpt ");
                        whereSql.append(" inner join t_bd_period period on period.fid = rpt.fperiodid ");
                        whereSql.append(" where rpt.FCompanyID = '" + companyInfo.getId().toString() + "' ");
                        whereSql.append(" and (period.fperiodyear = ").append(prePeriodInfo.getPeriodYear()).append(" and period.fperiodnumber <= ").append(prePeriodInfo.getPeriodNumber());
                        whereSql.append(" or period.fperiodyear < ").append(prePeriodInfo.getPeriodYear()).append(")");
                        sql.append(" DELETE FROM T_CL_COSTCOMPUTEPRICEREPORT where fparentid in (");
                        sql.append(whereSql.toString()).append("); ");
                        sql.append(" DELETE FROM T_CL_CostComputeRportHeader where fid in (");
                        sql.append(whereSql.toString()).append("); ");
                        KsqlUtil.execute((Context)ctx, (String)sql.toString());
                    }
                    info.setSuccessed(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                }
                catch (Exception e) {
                    info.setExecption(e.getMessage() + e.getCause());
                    info.setSuccessed(false);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                }
            }
        }.start();
    }

    public PeriodInfo getPrePeriodInfo(Context ctx, PeriodInfo periodInfo, int periodCount) throws BOSException, EASBizException {
        if (periodInfo == null) {
            throw new PeriodException(PeriodException.PERIODNOTNULL);
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        PeriodInfo prePeriodInfo = new PeriodInfo();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        periodInfo = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodInfo.getId()));
        int yearCount = 0;
        int maxPeriod = periodInfo.getPeriodNumber();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        while (periodCount >= maxPeriod) {
            periodCount -= maxPeriod;
            if (periodInfo.getPeriodYear() - ++yearCount < startPeriod.getPeriodYear()) {
                return null;
            }
            maxPeriod = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)(periodInfo.getPeriodYear() - yearCount), (String)companyInfo.getId().toString());
        }
        int destYear = periodInfo.getPeriodYear() - yearCount;
        int destPeriod = yearCount == 0 ? periodInfo.getPeriodNumber() - periodCount : maxPeriod - periodCount;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)destYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)periodInfo.getPeriodType().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodNumber", (Object)destPeriod, CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2 ");
        evi.setFilter(filter);
        PeriodCollection periodc = iPeriod.getPeriodCollection(evi);
        if (periodc.size() > 0) {
            prePeriodInfo = periodc.get(0);
        }
        if (prePeriodInfo.getId() == null) {
            prePeriodInfo = null;
        }
        return prePeriodInfo;
    }

    private void stockPriceCalculate(Context ctx, CompanyOrgUnitInfo companyOrg) throws EASBizException, BOSException {
        CalculateParams bizParams = new CalculateParams();
        bizParams.setObject("COMPANY_OBJ", (Object)companyOrg);
        bizParams.setBoolean("IsCloseAccount", true);
        JobParam jobParam = new JobParam((Object)bizParams);
        jobParam.setLocale(ctx.getLocale());
        ICreateJobFacade iCreateJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        JobConfig job = this.creteJobCfg(ctx, companyOrg);
        if (!iCreateJobFacade.checkDuplicateTask(job.getTaskType())) {
            Map map = iCreateJobFacade.executeJob(jobParam, job);
        }
    }

    private JobConfig creteJobCfg(Context ctx, CompanyOrgUnitInfo companyOrg) throws EASBizException, BOSException {
        String name = ResourceBase.getString((String)"com.kingdee.eas.scm.cal.StockPriceResource", (String)"STOCKPRICE_CALCULATE", (Locale)ctx.getLocale());
        String title = "\u3010" + companyOrg.getName() + "(" + companyOrg.getNumber() + ")\u3011-" + name;
        JobConfig jobCfg = new JobConfig();
        jobCfg.setTitle(title);
        jobCfg.setTaskType(companyOrg.getNumber());
        jobCfg.setDescription(title);
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setNumber("StockPriceCalculate");
        return jobCfg;
    }

    private void delStockPrice(final Context ctx, Map paramMap) {
        new Thread(){

            @Override
            public void run() {
                MessageInfo info = new MessageInfo();
                try {
                    CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
                    PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                    info.setbizAction(periodInfo.toString() + CalculateUtil.getCalServerResource(ctx, "deleteStockPrice"));
                    info.setOrgNumber(companyInfo.getName() + "(" + companyInfo.getNumber() + ")");
                    info.setSuccessed(false);
                    info.setUserID(ctx.getCaller().toString());
                    info.setSendMsg(true);
                    int stockprice_count = CloseJobHandler.this.getTempParamValue(ctx);
                    PeriodInfo prePeriodInfo = CloseJobHandler.this.getPrePeriodInfo(ctx, periodInfo, stockprice_count);
                    if (prePeriodInfo != null) {
                        StringBuffer sql = new StringBuffer();
                        sql.append(" DELETE FROM T_CL_STOCKPRICE");
                        sql.append(" where FCompanyOrgUnitID = '" + companyInfo.getId().toString() + "' ");
                        sql.append(" and (fyear = ").append(prePeriodInfo.getPeriodYear()).append(" and fperiod <= ").append(prePeriodInfo.getPeriodNumber());
                        sql.append(" or fyear < ").append(prePeriodInfo.getPeriodYear()).append(")");
                        KsqlUtil.execute((Context)ctx, (String)sql.toString());
                    }
                    info.setSuccessed(true);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                }
                catch (Exception e) {
                    info.setExecption(e.getMessage() + e.getCause());
                    info.setSuccessed(false);
                    MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
                }
            }
        }.start();
    }

    public Integer getTempParamValue(Context ctx) throws BOSException {
        String String2 = "select fvalue from T_DT_DTTempParam where FKEY = 'SCM_CAL_STOCKPRICE_COUNT'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)String2);
        try {
            if (rs.next()) {
                return rs.getInt("fvalue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 3;
    }
}

