/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CostObjectInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.UpdataStorageEnum;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.util.DataImportUtils;
import com.kingdee.eas.scm.im.inv.app.InvDataImport;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class CostAdjustImport
extends InvDataImport {
    private static final String resources = "com.kingdee.eas.scm.cal.CostAdjustBillImportDataResource";
    private static final String Locale_en = "l1";
    private static final String Locale_zh = "l2";
    private static final String Locale_tw = "l3";
    private StorageOrgUnitInfo sou = null;
    private CompanyOrgUnitInfo cou = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal MAXVAL = new BigDecimal("1000000000000");
    private CostAdjustBillInfo costAdjBillInfo = null;
    private HashMap currencyIfnoMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return CostAdjustBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        this.costAdjBillInfo = null;
        StorageOrgUnitInfo souTemp = null;
        super.getMainField();
        int keyCursor = 0;
        try {
            int size = hsData.size();
            for (int i = 0; i < size; ++i) {
                Object souData;
                Map lineData = (Map)hsData.get(new Integer(i));
                if (keyCursor == 0) {
                    this.costAdjBillInfo = this.transmitHead(lineData, ctx);
                    souTemp = this.costAdjBillInfo.getStorageOrgUnit();
                    if (this.costAdjBillInfo == null) {
                        return null;
                    }
                }
                if ((souData = ((DataToken)lineData.get((Object)"storageOrgUnit.number")).data) != null && souData.toString() != null && souData.toString().trim().length() > 0 && !souData.toString().equals(souTemp.getNumber().toString())) {
                    throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"StorageOrgUnitIsSame", (String)resources));
                }
                CostAdjustBillEntryInfo costadjEntryInfo = this.transmitEntry(lineData, ctx);
                int seq = this.costAdjBillInfo.getEntry().size() + 1;
                costadjEntryInfo.setSeq(seq);
                costadjEntryInfo.setParent(this.costAdjBillInfo);
                this.costAdjBillInfo.getEntry().add(costadjEntryInfo);
                ++keyCursor;
            }
        }
        catch (Exception e) {
            this.recycleNumber(ctx, (SCMBillBaseInfo)this.costAdjBillInfo);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return this.costAdjBillInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CostAdjustBillInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        this.costAdjBillInfo = new CostAdjustBillInfo();
        Object obj = ((DataToken)lineData.get((Object)"storageOrgUnit.number")).data;
        try {
            this.sou = this.getStorageOrgUnit(ctx, "number", obj);
        }
        catch (Exception e) {
            obj = ((DataToken)lineData.get((Object)"storageOrgUnit.name")).data;
            this.sou = this.getStorageOrgUnit(ctx, "name", obj);
        }
        this.costAdjBillInfo.setStorageOrgUnit(this.sou);
        this.cou = this.getCompanyOrgFromStorageOrg(ctx, this.sou);
        try {
            this.doNumber(ctx, (SCMBillBaseInfo)this.costAdjBillInfo, lineData);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        obj = ((DataToken)lineData.get((Object)"bizDate")).data;
        if (this.isEmpty(obj)) {
            throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"InvalidDateFormat", (String)resources) + obj.toString());
        }
        Date date = DataImportUtils.formatNationalDate((Context)ctx, (String)obj.toString());
        this.costAdjBillInfo.setBizDate(date);
        obj = ((DataToken)lineData.get((Object)"calculateKind")).data;
        if (obj == null || obj.toString().trim().length() <= 0) throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"CalculateKindNotExists", (String)resources));
        int calculateKind = Integer.parseInt(obj.toString().trim());
        if (calculateKind == 0) {
            this.costAdjBillInfo.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
        } else {
            if (calculateKind != 1) throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"CalculateKindNotExists", (String)resources));
            this.costAdjBillInfo.setCalculateKind(CalculateKindEnum.OUTPUT_WAREHOUSE);
        }
        obj = ((DataToken)lineData.get((Object)"issueType")).data;
        if (calculateKind == 1 && obj != null && obj.toString().trim().length() > 0) {
            int issueType = Integer.parseInt(obj.toString().trim());
            if (issueType == 0) {
                this.costAdjBillInfo.setIssueType(IssueTypeEnum.SALEISSUEBILL);
            } else if (issueType == 1) {
                this.costAdjBillInfo.setIssueType(IssueTypeEnum.PRODUCELINGLIAO);
            } else if (issueType == 2) {
                this.costAdjBillInfo.setIssueType(IssueTypeEnum.ORTHERSALE);
            } else {
                if (issueType != 3) throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"issueTypeNotExists", (String)resources));
                this.costAdjBillInfo.setIssueType(IssueTypeEnum.MOVEISSUE);
            }
        } else if (calculateKind == 1 && (obj == null || obj.toString().trim().length() <= 0)) {
            throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"issueTypeNotExists", (String)resources));
        }
        obj = ((DataToken)lineData.get((Object)"supplier.number")).data;
        if (calculateKind == 0 && obj != null && obj.toString().trim().length() > 0) {
            this.costAdjBillInfo.setSupplier(this.getSupplier(ctx, "number", obj));
        }
        obj = ((DataToken)lineData.get((Object)"customer.number")).data;
        if (calculateKind == 1 && obj != null && obj.toString().trim().length() > 0) {
            this.costAdjBillInfo.setCustomer(this.getCustomer(ctx, obj));
        }
        obj = ((DataToken)lineData.get((Object)"adminOrgUnit.number")).data;
        this.costAdjBillInfo.setAdminOrgUnit(this.getAdminOrgUnit(ctx, "number", obj));
        this.costAdjBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        this.costAdjBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
        billTypeInfo.setNumber("410");
        this.costAdjBillInfo.setBillType(billTypeInfo);
        obj = ((DataToken)lineData.get((Object)"costCenterOrgUnit.number")).data;
        this.costAdjBillInfo.setCostCenterOrgUnit(this.getCostCenter(ctx, lineData, "costCenterOrgUnit.number"));
        DataToken dt = (DataToken)lineData.get("description");
        if (dt != null && dt.data != null && dt.toString().trim().length() > 0) {
            String description = dt.data.toString().trim();
            if (description.length() > 80) {
                description = description.substring(0, 80);
            }
            this.costAdjBillInfo.setDescription(description);
        } else {
            this.costAdjBillInfo.setDescription("");
        }
        this.costAdjBillInfo.setCreateType(CostAdjuestCreateTypeEnum.MANUALIMPORT);
        return this.costAdjBillInfo;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, BigDecimal> result = new Hashtable<String, BigDecimal>();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "bizDate", rs.getString("bizDate"));
            this.putTable(result, "calculateKind", rs.getString("calculateKind"));
            this.putTable(result, "calculateKindName", this.getCalculateKindName(rs.getString("calculateKind")));
            this.putTable(result, "issueType", rs.getString("issueType"));
            this.putTable(result, "storageOrgUnit.number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "storageOrgUnit.name", rs.getString("storageOrgUnit.name"));
            this.putTable(result, "customer.number", rs.getString("customer.number"));
            this.putTable(result, "customer.name", rs.getString("customer.name"));
            this.putTable(result, "supplier.number", rs.getString("supplier.number"));
            this.putTable(result, "supplier.name", rs.getString("supplier.name"));
            this.putTable(result, "adminOrgUnit.number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "costCenterOrgUnit.number", rs.getString("costCenterOrgUnit.number"));
            this.putTable(result, "createType", rs.getString("createType"));
            this.putTable(result, "description", rs.getString("description"));
            this.putTable(result, "baseStatus", rs.getString("baseStatus"));
            this.putTable(result, "costObject.number", rs.getString("costObject.number"));
            this.putTable(result, "costObject.name", rs.getString("costObject.name"));
            this.putTable(result, "material.number", rs.getString("material.number"));
            this.putTable(result, "material.model", rs.getString("material.model"));
            this.putTable(result, "material.name", rs.getString("material.name"));
            this.putTable(result, "assistProperty.number", rs.getString("assistProperty.number"));
            this.putTable(result, "entry.lot", rs.getString("entry.lot"));
            this.putTable(result, "unit.number", rs.getString("unit.number"));
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.qty")).toString().length() <= 0) {
                result.put("entry.qty", ZERO);
            } else {
                BigDecimal qty = new BigDecimal(rs.getString("entry.qty"));
                result.put("entry.qty", qty);
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.price")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.price")).toString().length() <= 0) {
                result.put("entry.price", ZERO);
            } else {
                BigDecimal price = new BigDecimal(rs.getString("entry.price"));
                result.put("entry.price", price);
            }
            if ("".equalsIgnoreCase(DataImportUtils.transformValue((Object)rs.getString("entry.amount")).toString()) || DataImportUtils.transformValue((Object)rs.getString("entry.amount")).toString().length() <= 0) {
                result.put("entry.amount", ZERO);
            } else {
                BigDecimal amount = new BigDecimal(rs.getString("entry.amount"));
                result.put("entry.amount", amount);
            }
            this.putTable(result, "storeType.number", rs.getString("storeType.number"));
            this.putTable(result, "storeType.name", rs.getString("storeType.name"));
            this.putTable(result, "storeStatus.number", rs.getString("storeStatus.number"));
            this.putTable(result, "storeStatus.name", rs.getString("storeStatus.name"));
            this.putTable(result, "warehouse.number", rs.getString("warehouse.number"));
            this.putTable(result, "warehouse.name", rs.getString("warehouse.name"));
            this.putTable(result, "location.number", rs.getString("location.number"));
            this.putTable(result, "location.name", rs.getString("location.name"));
            this.putTable(result, "entry.customer.number", rs.getString("customer1.number"));
            this.putTable(result, "entry.customer.name", rs.getString("customer.name"));
            this.putTable(result, "entry.remark", rs.getString("entry.remark"));
            this.putTable(result, "entry.sourceBillNumber", rs.getString("entry.sourceBillNumber"));
            this.putTable(result, "entry.sourceBillEntrySeq", rs.getString("entry.sourceBillEntrySeq"));
            this.putTable(result, "entry.project.number", rs.getString("project.number"));
            this.putTable(result, "entry.trackNumber.number", rs.getString("trackNumber.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getCalculateKindName(String calculateKindStr) {
        String calculateKindName = "";
        int calculateKind = new Integer(calculateKindStr.trim());
        if (0 == calculateKind) {
            calculateKindName = CalculateKindEnum.INPUT_WAREHOUSE.toString();
        }
        if (1 == calculateKind) {
            calculateKindName = CalculateKindEnum.OUTPUT_WAREHOUSE.toString();
        }
        return calculateKindName;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Storage, (String)"costadjust_export");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("storageOrgUnit.id", keys, CompareType.INCLUDE));
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        String filterItems = (String)this.getContextParameter("filterItems");
        try {
            if (oldFilterInfo == null) {
                oldFilterInfo = StringUtils.isEmpty((CharSequence)filterItems) ? new FilterInfo() : new FilterInfo(filterItems);
            }
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (ParserException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.cal.CostAdjustBillImportDataQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public static IsUseableEnum getIsUseableEnum(String value, Context ctx) throws TaskExternalException {
        if (value != null && value.length() > 0) {
            if (CostAdjustImport.enumCompareByAlias(value, (Enum)IsUseableEnum.UnUseable)) {
                return IsUseableEnum.UnUseable;
            }
            if (CostAdjustImport.enumCompareByAlias(value, (Enum)IsUseableEnum.Useable)) {
                return IsUseableEnum.Useable;
            }
        }
        return IsUseableEnum.UnUseable;
    }

    public static boolean enumCompareByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw))) || value.equals(enumValue.getAlias(new Locale(Locale_en)));
    }

    public static boolean getBooleanValue(String value, Context ctx) throws TaskExternalException {
        if (CostAdjustImport.enumCompareByAlias(value, (Enum)UpdataStorageEnum.YES)) {
            return true;
        }
        if (CostAdjustImport.enumCompareByAlias(value, (Enum)UpdataStorageEnum.NO)) {
            return false;
        }
        return false;
    }

    private CostAdjustBillEntryInfo transmitEntry(Map hsData, Context ctx) throws TaskExternalException {
        TrackNumberInfo trackNumber;
        if (hsData == null) {
            return null;
        }
        CostAdjustBillEntryInfo costAdjEntryInfo = new CostAdjustBillEntryInfo();
        MaterialInfo materialInfo = new MaterialInfo();
        costAdjEntryInfo.setCompanyOrgUnit(this.cou);
        costAdjEntryInfo.setStorageOrgUnit(this.sou);
        Object data = ((DataToken)hsData.get((Object)"costObject.number")).data;
        CostObjectInfo costObject = this.getCostObject(ctx, this.cou, data);
        costAdjEntryInfo.setCostObject(costObject);
        data = ((DataToken)hsData.get((Object)"material.number")).data;
        materialInfo = this.getMaterial(ctx, data, resources, "MaterialNotExists", "MaterialNotExists", new OrgUnitInfo[]{this.sou, this.cou});
        MaterialInventoryInfo materialInventory = this.getMaterialInventory(ctx, materialInfo, this.sou);
        costAdjEntryInfo.setMaterial(materialInfo);
        data = ((DataToken)hsData.get((Object)"entry.lot")).data;
        if (this.checkLotInfo(ctx, materialInfo, data, this.sou, costAdjEntryInfo, materialInventory)) {
            costAdjEntryInfo.setLot(data.toString().trim());
        } else {
            costAdjEntryInfo.setLot(null);
        }
        if (materialInfo.getAssistAttr() != null) {
            data = ((DataToken)hsData.get((Object)"assistProperty.number")).data;
            if (data != null && data.toString().trim().length() > 0) {
                AsstAttrValueInfo asstAttr = this.getAsstAttr(ctx, data, materialInfo.getAssistAttr());
                costAdjEntryInfo.setAssistProperty(asstAttr);
            } else {
                try {
                    if (this.checkCalParam(ctx, costAdjEntryInfo)) {
                        throw new TaskExternalException(MessageFormat.format(CostAdjustImport.getResource((Context)ctx, (String)"ASSISTPROPERTY_NOT_NULL", (String)resources), materialInfo.getNumber()));
                    }
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
        }
        data = ((DataToken)hsData.get((Object)"warehouse.number")).data;
        WarehouseInfo warehouseInfo = this.getWarehouse(ctx, (OrgUnitInfo)this.sou, data);
        costAdjEntryInfo.setWarehouse(warehouseInfo);
        data = ((DataToken)hsData.get((Object)"location.number")).data;
        costAdjEntryInfo.setLocation(this.getLocation(ctx, data, warehouseInfo));
        if (materialInfo.getBaseUnit() != null) {
            costAdjEntryInfo.setUnit(materialInfo.getBaseUnit());
        }
        try {
            BigDecimal amount;
            data = ((DataToken)hsData.get((Object)"entry.amount")).data;
            if (data != null && data.toString().trim().length() > 0) {
                int localAmtPrecision = 21;
                CurrencyInfo currencyInfo = null;
                if (this.cou != null && this.cou.getBaseCurrency() != null) {
                    String currencyInfoId = this.cou.getBaseCurrency().getId().toString();
                    if (!this.currencyIfnoMap.containsKey(currencyInfoId)) {
                        currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfoId));
                        this.currencyIfnoMap.put(currencyInfoId, currencyInfo);
                    }
                    currencyInfo = (CurrencyInfo)this.currencyIfnoMap.get(currencyInfoId);
                    localAmtPrecision = currencyInfo.getPrecision();
                }
                amount = DataImportUtils.getDataDeciaml((Context)ctx, (String)data.toString().trim());
                if ((amount = amount.setScale(localAmtPrecision, 4)).abs().compareTo(MAXVAL) > 1) {
                    throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"AMOUNT_TOO_LONG", (String)resources));
                }
            } else {
                throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"amountISNotExsits", (String)resources));
            }
            costAdjEntryInfo.setAmount(amount);
            costAdjEntryInfo.setActualCost(costAdjEntryInfo.getAmount());
            costAdjEntryInfo.setStandardCost(costAdjEntryInfo.getAmount());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        data = ((DataToken)hsData.get((Object)"storeType.number")).data;
        StoreTypeInfo storeTypeInfo = this.getStoreType(ctx, data);
        if (storeTypeInfo != null) {
            if (!("181875d5-0105-1000-e000-0111c0a812fd97D461A6".equals(storeTypeInfo.getId().toString().trim()) || "181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(storeTypeInfo.getId().toString().trim()) || "181875d5-0105-1000-e000-0123c0a812fd97D461A6".equals(storeTypeInfo.getId().toString().trim()))) {
                throw new TaskExternalException(data.toString() + " " + CostAdjustImport.getResource((Context)ctx, (String)"STORETYPEISNotExists", (String)resources));
            }
        } else {
            throw new TaskExternalException(data.toString() + " " + CostAdjustImport.getResource((Context)ctx, (String)"STORETYPENotExists", (String)resources));
        }
        costAdjEntryInfo.setStoreType(storeTypeInfo);
        data = ((DataToken)hsData.get((Object)"storeStatus.number")).data;
        StoreStateInfo storeStateInfo = this.getStoreState(ctx, data);
        if (storeStateInfo == null) {
            throw new TaskExternalException(data.toString() + " " + CostAdjustImport.getResource((Context)ctx, (String)"STORESTATUS_NotExists", (String)resources));
        }
        costAdjEntryInfo.setStoreStatus(storeStateInfo);
        data = ((DataToken)hsData.get((Object)"entry.project.number")).data;
        ProjectInfo project = this.getProject(ctx, data, this.sou.getCU());
        if (project != null) {
            costAdjEntryInfo.setProject(project);
        }
        if ((trackNumber = this.getTrackNumber(ctx, data = ((DataToken)hsData.get((Object)"entry.trackNumber.number")).data, this.sou.getCU())) != null) {
            costAdjEntryInfo.setTrackNumber(trackNumber);
        }
        data = ((DataToken)hsData.get((Object)"entry.customer.number")).data;
        if ("181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(storeTypeInfo.getId().toString().trim()) || "181875d5-0105-1000-e000-0123c0a812fd97D461A6".equals(storeTypeInfo.getId().toString().trim())) {
            CustomerInfo customer = this.getCustomer(ctx, data);
            costAdjEntryInfo.setCustomer(customer);
        } else if (null != data && 0 < data.toString().trim().length()) {
            throw new TaskExternalException(CostAdjustImport.getResource((Context)ctx, (String)"CUSTOMERISEXSITS_DELEGATESALE_STORETYPE", (String)resources));
        }
        DataToken dt = (DataToken)hsData.get("entry.remark");
        if (dt != null && dt.data != null && dt.toString().trim().length() > 0) {
            String remark = dt.data.toString().trim();
            if (remark.length() > 80) {
                remark = remark.substring(0, 80);
            }
            costAdjEntryInfo.setRemark(remark);
        } else {
            costAdjEntryInfo.setRemark("");
        }
        return costAdjEntryInfo;
    }

    private boolean checkCalParam(Context ctx, CostAdjustBillEntryInfo costAdjEntryInfo) throws BOSException, EASBizException {
        boolean isAdjust = false;
        String paramValue = CalculateUtil.getCalParamValue(ctx, costAdjEntryInfo.getCompanyOrgUnit().getId().toString(), "SCM_CAL_012");
        isAdjust = paramValue.equalsIgnoreCase("true");
        return isAdjust;
    }

    private boolean checkLotInfo(Context ctx, MaterialInfo materialInfo, Object data, StorageOrgUnitInfo sou, CostAdjustBillEntryInfo costAdjEntryInfo, MaterialInventoryInfo materialInventory) throws TaskExternalException {
        boolean isLotNumber = materialInventory.isIsLotNumber();
        if (!isLotNumber) {
            return false;
        }
        try {
            if (isLotNumber && !this.checkCalParam(ctx, costAdjEntryInfo)) {
                return false;
            }
            if (isLotNumber && this.checkCalParam(ctx, costAdjEntryInfo) && (data == null || data.toString().length() <= 0)) {
                throw new TaskExternalException(materialInfo.getNumber() + CostAdjustImport.getResource((Context)ctx, (String)"LotManager", (String)resources));
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return true;
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty, Context ctx) {
        BigDecimal coefficient = new BigDecimal("1.00");
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = CostAdjustImport.getMulUnit(mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = CostAdjustImport.getMulUnit(baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public String getImportPermissionItem() {
        return "costadjust_new";
    }
}

