/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.basedatautil.master.OrgUnitUtil;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractCostAdjustWebFacadeControllerBean;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.NewBillBatchInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostAdjustWebFacadeControllerBean
extends AbstractCostAdjustWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostAdjustWebFacadeControllerBean");

    protected ISCMBillBase getLocalInstance(Context context) throws BOSException {
        return CostAdjustBillFactory.getLocalInstance(context);
    }

    public IObjectValue createNewData(Context context, IObjectValue model) throws BOSException, EASBizException {
        return this.createNewData(context, model, null);
    }

    private IObjectValue createNewData(Context context, IObjectValue model, StorageOrgUnitInfo sou) throws BOSException, EASBizException {
        CostAdjustBillInfo info = (CostAdjustBillInfo)model;
        CompanyOrgUnitInfo cou = null;
        if (info == null) {
            info = new CostAdjustBillInfo();
        }
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setHasEffected(false);
        info.setTransactionType(null);
        info.setIsInitBill(false);
        info.setIsReversed(false);
        info.setFiVouchered(false);
        info.setTotalActualCost(new BigDecimal(String.valueOf("0")));
        info.setTotalStandardCost(new BigDecimal(String.valueOf("0")));
        info.setTotalAmount(new BigDecimal(String.valueOf("0")));
        info.setTotalQty(new BigDecimal(String.valueOf("0")));
        BillTypeInfo aBillTypeInfo = new BillTypeInfo();
        aBillTypeInfo.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
        info.setBillType(aBillTypeInfo);
        info.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
        info.setIssueType(IssueTypeEnum.NULL);
        info.setCustomer(null);
        info.setSupplier(null);
        info.setCreateType(CostAdjuestCreateTypeEnum.USERINPUT);
        PeriodInfo aPeriodInfo = null;
        if (sou == null) {
            sou = (StorageOrgUnitInfo)this.getDefaultMainBizOrg(context);
        }
        if (sou == null) {
            return info;
        }
        info.setStorageOrgUnit(sou);
        NewBillBatchInfo billFetchData = this.getNewBillFetchData(context, sou);
        cou = billFetchData.getCompanyInfo();
        info.put("companyOrgUnit", cou);
        Timestamp d = billFetchData.getCurrTime();
        Date bdate = new Date(d.getYear(), d.getMonth(), d.getDate());
        info.setBizDate(bdate);
        info.setCreateTime(d);
        UserInfo user = UserFactory.getLocalInstance((Context)context).getUserInfo(context.getCaller());
        info.setCreator(user);
        aPeriodInfo = billFetchData.getCurrperiod();
        if (aPeriodInfo != null) {
            info.setYear(aPeriodInfo.getPeriodYear());
            info.setPeriod(aPeriodInfo.getPeriodNumber());
        } else {
            info.setYear(Calendar.getInstance().get(1));
            info.setPeriod(Calendar.getInstance().get(3));
        }
        info.setCostCenterOrgUnit(billFetchData.getCostCenterInfo());
        info.setIssueType(IssueTypeEnum.NULL);
        if (info.getEntry() != null) {
            CostAdjustBillEntryInfo entry = null;
            for (int i = 0; i < 5; ++i) {
                entry = (CostAdjustBillEntryInfo)this.createNewDetailData(context, model);
                entry.setStorageOrgUnit(sou);
                entry.setCompanyOrgUnit(cou);
                entry.setIsReWork(false);
                info.getEntry().add(entry);
            }
        }
        return info;
    }

    public IObjectValue createNewDetailData(Context context, IObjectValue model) {
        CostAdjustBillEntryInfo entry = new CostAdjustBillEntryInfo();
        entry.setBaseStatus(EntryBaseStatusEnum.NULL);
        entry.setIsPresent(false);
        entry.setActualCost(new BigDecimal(String.valueOf("0")));
        entry.setUnitActualCost(new BigDecimal(String.valueOf("0")));
        entry.setStandardCost(new BigDecimal(String.valueOf("0")));
        entry.setUnitStandardCost(new BigDecimal(String.valueOf("0")));
        entry.setPrice(new BigDecimal(String.valueOf("0")));
        entry.setReturnsQty(new BigDecimal(String.valueOf("0")));
        entry.setReverseQty(new BigDecimal(String.valueOf("0")));
        entry.setBaseQty(new BigDecimal(String.valueOf("0")));
        entry.setAssistQty(new BigDecimal(String.valueOf("0")));
        entry.setQty(new BigDecimal(String.valueOf("0")));
        entry.setAssociateQty(new BigDecimal(String.valueOf("0")));
        entry.setAssCoefficient(new BigDecimal(String.valueOf("0")));
        entry.setLot(null);
        return entry;
    }

    public String getPermissionItem() {
        if (OprtStateConstant.ADDNEW.equals(this.oprtState)) {
            return "costadjust_new";
        }
        if (OprtStateConstant.EDIT.equals(this.oprtState)) {
            return "costadjust_udpate";
        }
        if (OprtStateConstant.VIEW.equals(this.oprtState)) {
            return "costadjust_view";
        }
        return "costadjust_new";
    }

    public OrgType getMainOrgType() {
        return OrgType.Storage;
    }

    public String getMainOrgUnitName() {
        return "storageOrgUnit";
    }

    private NewBillBatchInfo getNewBillFetchData(Context ctx, StorageOrgUnitInfo storageUnitInfo) throws BOSException, EASBizException {
        HashMap<String, String> param = new HashMap<String, String>();
        String storageUnitId = storageUnitInfo == null ? null : storageUnitInfo.getId().toString();
        ISCMBillCommonFacade iCommon = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = OrgUnitUtil.getCompanyFromStorage((Context)ctx, (StorageOrgUnitInfo)storageUnitInfo);
        if (storageUnitId != null) {
            param.put("Main_Biz_org_id", storageUnitId);
        } else {
            param.put("companyId", company.getId().toString());
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user != null) {
            param.put("perisonId", user.getId().toString());
        }
        return iCommon.getCreateNewBillBatInfo(param);
    }

    private Map getParamsMap(Context ctx, String souId, String couId) throws EASBizException, BOSException {
        HashMap paramMap = new HashMap();
        Map souParamMap = this.batchGetParamValue(ctx, souId, new String[]{"INM004", "INM008"});
        paramMap.putAll(souParamMap);
        return paramMap;
    }

    public Map handleMainOrgChange(Context ctx, String mainOrgId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
        sou.setId(BOSUuid.read((String)mainOrgId));
        CostAdjustBillInfo info = new CostAdjustBillInfo();
        this.createNewData(ctx, (IObjectValue)info, sou);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)info.get("companyOrgUnit");
        info.setStorageOrgUnit(sou);
        map.put("newModel", info);
        map.put("company", company);
        map.put("param", this.getParamsMap(ctx, mainOrgId, company.getId().toString()));
        this.initData(ctx, map, (IObjectValue)info);
        return map;
    }

    public void initData(Context context, Map initData, IObjectValue model) throws EASBizException, BOSException {
        super.initData(context, initData, model);
        StorageOrgUnitInfo sou = (StorageOrgUnitInfo)model.get(this.getMainOrgUnitName());
        CompanyOrgUnitInfo company = OrgUnitUtil.getCompanyFromStorage((Context)context, (StorageOrgUnitInfo)sou);
        initData.put("param", this.getParamsMap(context, sou.getId().toString(), company.getId().toString()));
        initData.put("company", company);
    }
}

