/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.cal.CostComputeOrderCollection;
import com.kingdee.eas.scm.cal.CostComputeOrderInfo;
import com.kingdee.eas.scm.cal.app.AbstractCostComputeOrderControllerBean;
import com.kingdee.eas.scm.cal.help.ManualWriteOffHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CostComputeOrderControllerBean
extends AbstractCostComputeOrderControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostComputeOrderControllerBean");
    private static final String res = "com.kingdee.eas.scm.cal.CalRptResource";

    @Override
    protected CalculateParams _getOrder(Context ctx, CalculateParams params, int from, int len) throws BOSException, EASBizException {
        Connection con = this.getConnection(ctx);
        String sql = this.getOrderSql(ctx, params);
        CalculateParams pr = new CalculateParams();
        try {
            RptRowSet rs = DBUtil.executeQuery((String)sql, null, (int)from, (int)len, (Connection)con);
            if (!rs.next()) {
                rs = DBUtil.executeQuery((String)this.getOrderSql2(ctx, params), null, (int)from, (int)len, (Connection)con);
            }
            rs.reset();
            pr.setObject("rowset", (Object)rs);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        pr.setObject("header", (Object)this.buildRptHeader(ctx));
        return pr;
    }

    private RptTableHeader buildRptHeader(Context ctx) {
        String[][] fields = new String[][]{{"false", "selected"}, {"false", "StorageOrWrehouseNumber"}, {"false", "StorageOrWarehseName"}, {"false", "Order"}};
        String[] hiddenFields = new String[]{"fstWhid"};
        return ManualWriteOffHelp.builderRptTableHeader(ctx, fields, hiddenFields, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _resetOrder(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        CalculateParams pr = new CalculateParams();
        Connection con = this.getConnection(ctx);
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(this.getDeleteSql(params));
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        finally {
            SQLUtils.cleanup((Statement)stmt, (Connection)con);
        }
        return pr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveOrder(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        block6: {
            CostComputeOrderCollection coll = (CostComputeOrderCollection)((Object)params.getObject("ret"));
            CostComputeOrderInfo info = null;
            Connection con = this.getConnection(ctx);
            PreparedStatement ps = null;
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                stmt.execute(this.getDeleteSql(params));
                ps = con.prepareStatement(this.getInsertSql());
                for (int i = 0; coll != null && i < coll.size(); ++i) {
                    info = coll.get(i);
                    ps.setString(1, info.getId().toString());
                    ps.setString(2, info.getString("FCompanyOrgUnitID"));
                    ps.setString(3, info.getString("STORAGEORGUNITID"));
                    ps.setString(4, info.getString("WAREHOUSEID"));
                    ps.setInt(5, info.getInt("Forder"));
                    ps.addBatch();
                }
                ps.executeBatch();
                SQLUtils.cleanup((Statement)ps, (Connection)con);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                break block6;
            }
            finally {
                SQLUtils.cleanup(ps, (Connection)con);
                SQLUtils.cleanup((Statement)stmt);
            }
            SQLUtils.cleanup((Statement)stmt);
        }
    }

    private String getDeleteSql(CalculateParams params) {
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("DELETE FROM T_CL_CostComputeOrder WHERE FCompanyorgunitID='");
        deleteSql.append(params.getString("COMPANY_ID"));
        deleteSql.append("'");
        return deleteSql.toString();
    }

    private String getInsertSql() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO T_CL_CostComputeOrder(FID,FCompanyorgunitID,FStorageorgunitID,FWarehouseID,FOrder)");
        buffer.append(" VALUES(?,?,?,?,?)");
        return buffer.toString();
    }

    private String getOrderSql(Context ctx, CalculateParams params) {
        String calType = params.getString("CALTYPE");
        String companyId = params.getString("COMPANY_ID");
        StringBuffer sql = new StringBuffer();
        if ("1".equals(calType)) {
            sql.append(" SELECT 1 AS Selected,T2.FNUMBER,T2.FNAME_").append(ctx.getLocale());
            sql.append(",T1.Forder,T2.FID FROM T_CL_CostComputeOrder T1 INNER JOIN T_ORG_STORAGE T2");
            sql.append(" ON T1.FStorageorgunitID = T2.FID");
        }
        if ("2".equals(calType)) {
            sql.append(" SELECT 1 AS Selected,T2.FNUMBER,T2.FNAME_").append(ctx.getLocale());
            sql.append(",T1.Forder,T2.FID FROM T_CL_CostComputeOrder T1 INNER JOIN T_DB_WAREHOUSE T2");
            sql.append(" ON T1.FWAREHOUSEID = T2.FID");
        }
        sql.append("\n WHERE FCompanyorgunitID ='").append(companyId).append("'");
        sql.append(" AND T1.FOrder >0");
        return sql.toString();
    }

    private String getOrderSql2(Context ctx, CalculateParams params) {
        String calType = params.getString("CALTYPE");
        String companyId = params.getString("COMPANY_ID");
        if ("2".equals(calType)) {
            return CostComputeOrderControllerBean.getWarehouseSql(ctx, companyId);
        }
        return CostComputeOrderControllerBean.getStorageUnitSql(ctx, companyId);
    }

    public static String getStorageUnitSql(Context ctx, String companyId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 0 AS Selected ,T3.FNUMBER,T3.FNAME_").append(ctx.getLocale());
        sql.append(",0,T3.FID");
        sql.append("\n FROM T_ORG_UNITRELATION T1 INNER JOIN T_ORG_TypeRelation T2 ON T1.FTypeRelationID =  T2.FID");
        sql.append("\n INNER JOIN T_ORG_STORAGE T3  ON T3.FID = T1.FFROMUNITID ");
        sql.append("\n WHERE  T2.FTOTYPE =").append(1);
        sql.append(" AND T2.FFROMTYPE = ").append(4);
        sql.append("\n AND  T1.FtoUnitID ='").append(companyId).append("'");
        sql.append("\n ORDER BY t3.fnumber ");
        return sql.toString();
    }

    public static String getWarehouseSql(Context ctx, String companyId) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT 0 AS Selected, T2.FNUMBER,T2.FNAME_").append(ctx.getLocale());
        sql.append(",0,T2.FID");
        sql.append("\n FROM T_DB_SOAccreditWH T1 INNER JOIN T_DB_WAREHOUSE T2 ");
        sql.append("\n ON T1.FWAREHOUSEID = T2.FID ");
        sql.append("\n WHERE  T1.FCompanyID ='").append(companyId).append("'");
        sql.append("\n ORDER BY t2.fnumber ");
        return sql.toString();
    }
}

