/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.app.AbstractCostComputeReportControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class CostComputeReportControllerBean
extends AbstractCostComputeReportControllerBean {
    private static final long serialVersionUID = 7384584625765774194L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostComputeReportControllerBean");

    @Override
    protected RptRowSet _getMaterialList(Context ctx, EntityViewInfo entityViewInfo) throws BOSException {
        RptRowSet rs = null;
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT DISTINCT");
            sql.append("  MATERIAL.FNumber AS MATERIALNUMBER");
            sql.append(", Material.FID AS MATERIALID");
            sql.append(", Material.FName_").append(ctx.getLocale()).append(" AS MATERIALNAME");
            sql.append(", Material.FSHORTNAME AS MATERIALSHORTNAME");
            sql.append(", MATERIALCOMPANY.FACCOUNTTYPE AS MATERIALCOMPANYACCOUNTTYPE");
            sql.append(", MATERIALCOMPANY.FIsLot AS isLot");
            sql.append(", MATERIALCOMPANY.FIsAssistProperty AS isAssistProperty");
            sql.append(", MATERIALCOMPANY.FIsProject AS isProject");
            sql.append(", MATERIALCOMPANY.FIsTrackNumber AS isTrackNumber");
            sql.append(", BASEUNIT.FNAME_L1 AS baseUnitName_l1");
            sql.append(", BASEUNIT.FNAME_L2 AS baseUnitName_l2");
            sql.append(", BASEUNIT.FNAME_L3 AS baseUnitName_l3");
            sql.append(" FROM");
            sql.append(" T_CL_CostComputeReport COSTCOMPUTEREPORT");
            sql.append(" LEFT OUTER JOIN T_DB_WAREHOUSE WAREHOUSE ON COSTCOMPUTEREPORT.FWarehouseID = WAREHOUSE.FID");
            sql.append(" LEFT OUTER JOIN T_ORG_Storage STORAGEORG ON COSTCOMPUTEREPORT.FStorageOrgUnitID = STORAGEORG.FID");
            sql.append(" INNER JOIN T_BD_Material MATERIAL ON COSTCOMPUTEREPORT.FMaterialID = MATERIAL.FID");
            sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ON (");
            sql.append(" COSTCOMPUTEREPORT.FMaterialID = MATERIALCOMPANY.FMaterialID");
            sql.append(" AND COSTCOMPUTEREPORT.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID");
            sql.append(" )");
            sql.append("\n LEFT OUTER JOIN T_BD_AsstAttrValue ASS ON ASS.FID = COSTCOMPUTEREPORT.FAssistPropertyID");
            sql.append("\n LEFT OUTER JOIN T_MM_PROJECT PRO ON PRO.FID = COSTCOMPUTEREPORT.FProjectID");
            sql.append("\n LEFT OUTER JOIN T_MM_TrackNumber TRA ON TRA.FID = COSTCOMPUTEREPORT.FTrackNumberID");
            sql.append("\n LEFT OUTER JOIN T_BD_MeasureUnit BASEUNIT ON MATERIAL.FBASEUNIT = BASEUNIT.FID");
            sql.append(" WHERE ");
            sql.append(" MATERIAL.FSTATUS = ").append(1);
            sql.append(" AND MATERIALCOMPANY.FSTATUS =").append(1);
            if (entityViewInfo != null && entityViewInfo.getFilter() != null) {
                String wheresql = entityViewInfo.getFilter().toString();
                wheresql = wheresql.replaceAll("FINANCEORG.ID", "FCompanyOrgUnitID");
                wheresql = wheresql.replaceAll("WAREHOUSE.NUMBER", "WAREHOUSE.FNumber");
                wheresql = wheresql.replaceAll("STORAGEORG.NUMBER", "STORAGEORG.FNumber");
                wheresql = wheresql.replaceAll("MATERIAL.NUMBER", "MATERIAL.FNUMBER");
                wheresql = wheresql.replaceAll("MATERIAL.SHORTNAME", "MATERIAL.FSHORTNAME");
                wheresql = wheresql.replaceAll("PERIOD", "COSTCOMPUTEREPORT.FPERIOD");
                wheresql = wheresql.replaceAll("YEAR", "COSTCOMPUTEREPORT.FYEAR");
                wheresql = wheresql.replaceAll("MATERIALCOMPANY.ACCOUNTTYPE", "MATERIALCOMPANY.FACCOUNTTYPE");
                wheresql = wheresql.replaceAll("Lot", "COSTCOMPUTEREPORT.FLot");
                wheresql = wheresql.replaceAll("AssistProperty.number", "ASS.FNumber");
                wheresql = wheresql.replaceAll("Project.number", "PRO.FNumber");
                wheresql = wheresql.replaceAll("trackNumber.number", "TRA.FNumber");
                sql.append(" AND ").append(wheresql);
            }
            sql.append(" ORDER BY");
            sql.append(" MATERIAL.FNumber ASC");
            rs = DBUtil.executeQuery((String)sql.toString(), (Connection)conn);
        }
        catch (SQLException e) {
            logger.info((Object)e);
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup(ps, (Connection)conn);
        }
        return rs;
    }
}

