/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.app.AbstractCostUpdateMutexFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.help.CostUpdateMutextHelper;
import com.kingdee.eas.util.client.EASResource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostUpdateMutexFacadeControllerBean
extends AbstractCostUpdateMutexFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.CostUpdateMutexFacadeControllerBean");
    private static final String ONEKEYRESOURCE = "com.kingdee.eas.scm.cal.onekey.OneKeyCalculateResource";
    private static final String CALCOMMONRESOURCE = "com.kingdee.eas.scm.cal.CalCommonResource";

    @Override
    protected void _checkCostUpdateMutex(Context ctx, String companyId, String operateType) throws BOSException, EASBizException {
        SelectorItemCollection sics = new SelectorItemCollection();
        sics.add(new SelectorItemInfo("number"));
        CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId), sics);
        switch (operateType) {
            case "matOutCal": {
                this.outCalCheck(ctx, companyInfo);
                break;
            }
            case "prdOutCal": {
                this.outCalCheck(ctx, companyInfo);
                break;
            }
            case "oneKeyCal": {
                this.oneKeyCalCheck(ctx, companyInfo);
                break;
            }
            case "matAssembleCal": {
                this.matAssembleCalCheck(ctx, companyInfo);
                break;
            }
            case "matChangeCal": {
                this.matChangeCalCheck(ctx, companyInfo);
                break;
            }
            case "devolveCal": {
                this.devolveCalCheck(ctx, companyInfo);
                break;
            }
            case "calBill": {
                this.calBillCheck(ctx, companyInfo);
                break;
            }
            case "exceptionBill": {
                this.exceptionBillCheck(ctx, companyInfo);
                break;
            }
            case "inwarehsSumCal": {
                this.inwarehsSumCalCheck(ctx, companyInfo);
                break;
            }
            case "unShutAccount": {
                this.unShutAccountCheck(ctx, companyInfo);
                break;
            }
            case "close_account": {
                this.closeAccountCheck(ctx, companyInfo);
                break;
            }
        }
    }

    private void inwarehsSumCalCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    @Override
    protected void _addOperateMutex(Context ctx, String companyId, String operateType) throws BOSException, EASBizException {
        CostUpdateMutextHelper.addCostOperationMutex(ctx, companyId, operateType);
    }

    @Override
    protected void _clearOperateMutex(Context ctx, String companyId, String operatetype) throws BOSException, EASBizException {
        CostUpdateMutextHelper.clearCostOperationMutex(ctx, companyId, operatetype);
    }

    private void unShutAccountCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void exceptionBillCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void calBillCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void matChangeCalCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void matAssembleCalCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void outCalCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void devolveCalCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0004", EASResource.getString((String)CALCOMMONRESOURCE, (String)"devolveCalRunning"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        this.doMutexCheck(ctx, companyInfo.getId().toString(), checkMap, null);
    }

    private void oneKeyCalCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String companyId = companyInfo.getId().toString();
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0001", EASResource.getString((String)CALCOMMONRESOURCE, (String)"CALCULATE_ROWMATEIAL_WAITE_MSG"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0002", EASResource.getString((String)CALCOMMONRESOURCE, (String)"CloseMutexCalculate_Msg"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0003", EASResource.getString((String)CALCOMMONRESOURCE, (String)"CALCULATE_FINSHGOOD_WAITE_MSG"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0004", EASResource.getString((String)CALCOMMONRESOURCE, (String)"devolveCalRunning"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        ArrayList<String> operateList = new ArrayList<String>();
        operateList.add("matAssembleCal");
        operateList.add("matChangeCal");
        operateList.add("calBill");
        operateList.add("exceptionBill");
        this.doMutexCheck(ctx, companyId, checkMap, operateList);
    }

    private void doMutexCheck(Context ctx, String companyId, Map<String, String> checkMap, List<String> operateList) throws BOSException, EASBizException {
        if (operateList != null && !operateList.isEmpty()) {
            for (String string : operateList) {
                CostUpdateMutextHelper.checkUpdateCostOperation(ctx, companyId, string);
            }
        }
        if (checkMap != null && !checkMap.isEmpty()) {
            for (Map.Entry entry : checkMap.entrySet()) {
                CostUpdateMutextHelper.checkPerfSepTask(ctx, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void closeAccountCheck(Context ctx, CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        String companyId = companyInfo.getId().toString();
        HashMap<String, String> checkMap = new HashMap<String, String>();
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0001", EASResource.getString((String)CALCOMMONRESOURCE, (String)"CALCULATE_ROWMATEIAL_WAITE_MSG"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0002", EASResource.getString((String)CALCOMMONRESOURCE, (String)"CloseMutexCalculate_Msg"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0003", EASResource.getString((String)CALCOMMONRESOURCE, (String)"CALCULATE_FINSHGOOD_WAITE_MSG"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0004", EASResource.getString((String)CALCOMMONRESOURCE, (String)"devolveCalRunning"));
        checkMap.put(companyInfo.getNumber() + "SCM_CAL_0005", EASResource.getString((String)ONEKEYRESOURCE, (String)"oneKeyCalIsRunning"));
        ArrayList<String> operateList = new ArrayList<String>();
        operateList.add("matAssembleCal");
        operateList.add("matChangeCal");
        operateList.add("calBill");
        operateList.add("exceptionBill");
        this.doMutexCheck(ctx, companyId, checkMap, operateList);
    }
}

