/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupFactory;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupInfo;
import com.kingdee.eas.scm.cal.DevolveWriteOffRecordInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.MatCostWriteOffTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractDevolveWriteOffFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.help.ManualWriteOffHelp;
import com.kingdee.eas.scm.cal.info.DevolveInWarehsBillInfo;
import com.kingdee.eas.scm.cal.info.DevolveMatReqBillInfo;
import com.kingdee.eas.scm.cal.info.DevolveWriteOffResultInfo;
import com.kingdee.eas.scm.cal.info.ReturnInfo;
import com.kingdee.eas.scm.cal.info.WriteOffBillInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryFactory;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubMaterialListCollection;
import com.kingdee.eas.scm.sm.sc.SubMaterialListInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DevolveWriteOffFacadeControllerBean
extends AbstractDevolveWriteOffFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private CompanyOrgUnitInfo companyOrgUnitInfo;
    private PeriodInfo currPeriod;
    private List devWarehsInfoList;
    private List matchGatherMatPurBillList;
    Map materialBaseQtyPrecision = new HashMap();

    protected SelectorItemCollection getDownSelectItem(EntityViewInfo viewInfo) {
        return null;
    }

    protected SelectorItemCollection getUpSelectItem(EntityViewInfo viewInfo) {
        return null;
    }

    @Override
    protected ReturnInfo _devolveWriteOff(Context ctx, DevolveWriteOffResultInfo info, boolean isContinue) throws BOSException, EASBizException {
        boolean isSuccess = false;
        ReturnInfo returnInfo = new ReturnInfo();
        this.devWarehsInfoList = new ArrayList();
        this.matchGatherMatPurBillList = new ArrayList();
        if (info.getCompanyOrgUnitID() == null || info.getCompanyOrgUnitID().length() == 0) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        this.companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnitID()));
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyOrgUnitInfo);
        HashSet<String> matEntryIdSet = new HashSet<String>();
        DevolveMatReqBillInfo devMatReqInfo = null;
        DevolveMatReqBillInfo devMatUIReqInfo = null;
        List devMatReqList = info.getDevMaterialReqList();
        HashMap<String, DevolveMatReqBillInfo> devMatBillMap = new HashMap<String, DevolveMatReqBillInfo>();
        try {
            if (devMatReqList != null && devMatReqList.size() > 0) {
                int size = devMatReqList.size();
                for (int i = 0; i < size; ++i) {
                    devMatUIReqInfo = (DevolveMatReqBillInfo)devMatReqList.get(i);
                    devMatBillMap.put(devMatUIReqInfo.getEntryId(), devMatUIReqInfo);
                    matEntryIdSet.add(devMatUIReqInfo.getEntryId());
                }
                IRowSet matReqEntryRow = this.getMatReqEntryByID(ctx, matEntryIdSet);
                devMatReqList.clear();
                while (matReqEntryRow.next()) {
                    devMatReqInfo = this.buildDevolveMatReqInfo(matReqEntryRow);
                    if (devMatBillMap.get(devMatReqInfo.getEntryId()) != null) {
                        devMatUIReqInfo = (DevolveMatReqBillInfo)devMatBillMap.get(devMatReqInfo.getEntryId());
                        devMatReqInfo.setCurWriteOffBaseQty(devMatUIReqInfo.getCurWriteOffBaseQty());
                    }
                    devMatReqList.add(devMatReqInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.setWriteOffMaxBizPeriod(ctx, info);
        DevolveWriteOffGroupInfo groupInfo = this.createWrittenOffGroup(ctx, info);
        isSuccess = info.getWriteOffStandard() == 1 ? this.manualWriteOff(ctx, info, groupInfo) : (info.getWriteOffStandard() == 2 ? this.selfWriteOff(ctx, info, groupInfo) : this.orderWriteOff(ctx, info, groupInfo, isContinue));
        if (isSuccess && groupInfo.getEntry().size() > 0) {
            DevolveWriteOffGroupFactory.getLocalInstance(ctx).save((CoreBaseInfo)groupInfo);
            this.saveDevolveInWarehsBillInfo(ctx, info);
            this.saveDevolveMatReqBillInfo(ctx, info.getDevMaterialReqList());
        }
        returnInfo.setSuccess(isSuccess);
        returnInfo.setUnWriteOffInWarehsNums(this.getErrDevInWarehsNums(this.devWarehsInfoList));
        returnInfo.setMatchGPeriodMatInwareNums(this.getErrDevInWarehsNums(this.matchGatherMatPurBillList));
        return returnInfo;
    }

    private String getErrDevInWarehsNums(List devWarehsInfoList) throws BOSException {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < devWarehsInfoList.size(); ++i) {
            result.append(devWarehsInfoList.get(i));
            if (i >= devWarehsInfoList.size() - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    private void setWriteOffMaxBizPeriod(Context ctx, DevolveWriteOffResultInfo info) throws BOSException, EASBizException {
        int i;
        List devInWarehsList = info.getDevInWarehsList();
        List devMatReqList = info.getDevMaterialReqList();
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyOrgUnitInfo);
        Timestamp maxBizDate = CalculateUtil.getTime(this.currPeriod.getBeginDate());
        Timestamp bizDate = null;
        for (i = 0; i < devInWarehsList.size(); ++i) {
            bizDate = ((DevolveInWarehsBillInfo)devInWarehsList.get(i)).getBizDate();
            maxBizDate = maxBizDate.compareTo(bizDate) >= 0 ? maxBizDate : bizDate;
        }
        for (i = 0; i < devMatReqList.size(); ++i) {
            bizDate = ((DevolveMatReqBillInfo)devMatReqList.get(i)).getBizDate();
            maxBizDate = maxBizDate.compareTo(bizDate) >= 0 ? maxBizDate : bizDate;
        }
        PeriodInfo bizPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)maxBizDate, (CompanyOrgUnitInfo)this.companyOrgUnitInfo, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
        if (bizPeriod.isIsAdjustPeriod()) {
            bizPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)bizPeriod);
        }
        info.setYear(bizPeriod.getPeriodYear());
        info.setPeriod(bizPeriod.getPeriodNumber());
        info.setBizDate(maxBizDate);
    }

    private boolean manualWriteOff(Context ctx, DevolveWriteOffResultInfo info, DevolveWriteOffGroupInfo groupInfo) {
        int i;
        List devInWarehsList = info.getDevInWarehsList();
        List devMatReqList = info.getDevMaterialReqList();
        ArrayList<String> errPurIds = new ArrayList<String>();
        BigDecimal total = this.getDevInWarehsTotal(info);
        DevolveWriteOffRecordInfo inWarehsRecordInfo = null;
        DevolveWriteOffRecordInfo matReqRecordInfo = null;
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        DevolveMatReqBillInfo devMatReqInfo = null;
        int purPeriod = 0;
        int matPeriod = 0;
        block0: for (i = 0; i < devInWarehsList.size(); ++i) {
            devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsList.get(i);
            purPeriod = devInWarehsInfo.getYear() * 100 + devInWarehsInfo.getPeriod();
            for (int j = 0; j < devMatReqList.size(); ++j) {
                devMatReqInfo = (DevolveMatReqBillInfo)devMatReqList.get(j);
                matPeriod = devMatReqInfo.getYear() * 100 + devMatReqInfo.getPeriod();
                if (matPeriod <= purPeriod) continue;
                errPurIds.add(devInWarehsInfo.getBillId());
                this.devWarehsInfoList.add(devInWarehsInfo.getNumber());
                this.matchGatherMatPurBillList.add(devInWarehsInfo.getNumber());
                continue block0;
            }
        }
        for (i = 0; i < devInWarehsList.size(); ++i) {
            devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsList.get(i);
            if (errPurIds.contains(devInWarehsInfo.getBillId())) continue;
            purPeriod = devInWarehsInfo.getYear() * 100 + devInWarehsInfo.getPeriod();
            BigDecimal rate = null;
            rate = info.getApportionRule() == 2 ? devInWarehsInfo.getBaseQty().divide(total, 10, 4) : (info.getApportionRule() == 1 ? devInWarehsInfo.getMaterialCost().divide(total, 10, 4) : devInWarehsInfo.getPurchaseCost().divide(total, 10, 4));
            BigDecimal totalWriteOffAmount = CalculateUtil.ZERO;
            for (int j = 0; j < devMatReqList.size(); ++j) {
                devMatReqInfo = (DevolveMatReqBillInfo)devMatReqList.get(j);
                if (devMatReqInfo.getCurrWriteOffTotalAmount() == null) {
                    devMatReqInfo.setCurrWriteOffTotalAmount(CalculateUtil.ZERO);
                }
                if (devMatReqInfo.getDevWriteOffAmount() == null) {
                    devMatReqInfo.setDevWriteOffAmount(CalculateUtil.ZERO);
                }
                BigDecimal curWriteOffQty = devMatReqInfo.getCurWriteOffBaseQty().divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
                if (devMatReqInfo.getCurWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
                    curWriteOffQty = devMatReqInfo.getQty();
                }
                BigDecimal writeOffBaseQty = rate.multiply(devMatReqInfo.getCurWriteOffBaseQty()).setScale(devMatReqInfo.getBaseQtyPrecision(), 4);
                if (i == devInWarehsList.size() - 1) {
                    writeOffBaseQty = devMatReqInfo.getCurWriteOffBaseQty().subtract(devMatReqInfo.getHasWriteOffBaseQty());
                }
                if (writeOffBaseQty.compareTo(CalculateUtil.ZERO) == 0) continue;
                BigDecimal writeOffQty = writeOffBaseQty.divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
                if (i == devInWarehsList.size() - 1) {
                    writeOffQty = curWriteOffQty.subtract(devMatReqInfo.getHasWriteOffQty());
                    writeOffBaseQty = devMatReqInfo.getCurWriteOffBaseQty().subtract(devMatReqInfo.getHasWriteOffBaseQty());
                    devMatReqInfo.setHasWriteOffQty(curWriteOffQty);
                    devMatReqInfo.setHasWriteOffBaseQty(devMatReqInfo.getCurWriteOffBaseQty());
                } else {
                    devMatReqInfo.setHasWriteOffQty(devMatReqInfo.getHasWriteOffQty().add(writeOffQty));
                    devMatReqInfo.setHasWriteOffBaseQty(devMatReqInfo.getHasWriteOffBaseQty().add(writeOffBaseQty));
                }
                BigDecimal baseUnitPrice = devMatReqInfo.getActualCost().divide(devMatReqInfo.getBaseQty(), 10, 4);
                BigDecimal writeOffAmount = writeOffBaseQty.multiply(baseUnitPrice).setScale(devMatReqInfo.getPrecision(), 4);
                if (devMatReqInfo.getHasWriteOffBaseQty().add(devMatReqInfo.getDevWriteOffBaseQty()).compareTo(devMatReqInfo.getBaseQty()) == 0) {
                    writeOffAmount = devMatReqInfo.getActualCost().subtract(devMatReqInfo.getCurrWriteOffTotalAmount().add(devMatReqInfo.getDevWriteOffAmount()));
                }
                devMatReqInfo.setCurrWriteOffTotalAmount(devMatReqInfo.getCurrWriteOffTotalAmount().add(writeOffAmount));
                totalWriteOffAmount = totalWriteOffAmount.add(writeOffAmount);
                matReqRecordInfo = this.createWrittenOffRecord(ctx, devMatReqInfo, groupInfo, i + 1, j + 2);
                matReqRecordInfo.setCurrWriteOffQty(writeOffQty);
                matReqRecordInfo.setCurrWriteOffBaseQty(writeOffBaseQty);
                matReqRecordInfo.setCurrWriteOffAmount(writeOffAmount);
                matReqRecordInfo.setBillUnWriteOffBaseQty(devMatReqInfo.getDevUnWriteOffBaseQty().subtract(devMatReqInfo.getHasWriteOffBaseQty()));
            }
            if (this.isNeedWriteBack(devInWarehsInfo)) {
                BigDecimal materialCost = totalWriteOffAmount.divide(devInWarehsInfo.getCurWriteOffBaseQty(), 10, 4).multiply(devInWarehsInfo.getBaseQty()).setScale(devInWarehsInfo.getPrecision(), 4);
                devInWarehsInfo.setMaterialCost(materialCost);
                BigDecimal unitCost = materialCost.divide(devInWarehsInfo.getQty(), devInWarehsInfo.getPricePrecision(), 4);
                devInWarehsInfo.setUnitMaterialCost(unitCost);
            }
            inWarehsRecordInfo = this.createWrittenOffRecord(ctx, devInWarehsInfo, groupInfo, i + 1, 1);
            inWarehsRecordInfo.setCurrWriteOffQty(devInWarehsInfo.getDevUnWriteOffQty());
            inWarehsRecordInfo.setCurrWriteOffBaseQty(devInWarehsInfo.getDevUnWriteOffBaseQty());
            inWarehsRecordInfo.setCurrWriteOffAmount(totalWriteOffAmount);
            inWarehsRecordInfo.setBillUnWriteOffBaseQty(CalculateUtil.ZERO);
        }
        this.setInWarehsWriteOffInfo(devInWarehsList);
        if (devInWarehsList.size() == 0) {
            this.setRedBlueMatReqBillWriteOffAmount(devMatReqList);
        } else {
            this.setMatReqWriteOffInfo(devMatReqList, info);
        }
        if (devInWarehsList.size() == 0) {
            this.createRedAndBuleWriteOffRecord(ctx, devMatReqList, groupInfo);
        }
        return true;
    }

    private boolean selfWriteOff(Context ctx, DevolveWriteOffResultInfo info, DevolveWriteOffGroupInfo groupInfo) {
        List devInWarehsList = info.getDevInWarehsList();
        List devMatReqList = info.getDevMaterialReqList();
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        DevolveMatReqBillInfo devMatReqInfo = null;
        DevolveWriteOffRecordInfo inWarehsRecordInfo = null;
        DevolveWriteOffRecordInfo matReqRecordInfo = null;
        int i = 0;
        BigDecimal writeOffAmount = null;
        for (i = 0; i < devInWarehsList.size(); ++i) {
            devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsList.get(i);
            inWarehsRecordInfo = this.createWrittenOffRecord(ctx, devInWarehsInfo, groupInfo, i + 1, i + 1);
            inWarehsRecordInfo.setCurrWriteOffQty(devInWarehsInfo.getDevUnWriteOffQty());
            inWarehsRecordInfo.setCurrWriteOffBaseQty(devInWarehsInfo.getDevUnWriteOffBaseQty());
            writeOffAmount = devInWarehsInfo.getDevUnWriteOffQty().multiply(devInWarehsInfo.getUnitMaterialCost() == null ? BigDecimal.ZERO : devInWarehsInfo.getUnitMaterialCost()).setScale(devInWarehsInfo.getPrecision(), 4);
            if (devInWarehsInfo.getDevUnWriteOffQty().compareTo(devInWarehsInfo.getQty()) == 0) {
                writeOffAmount = devInWarehsInfo.getActualCost();
            }
            inWarehsRecordInfo.setCurrWriteOffAmount(writeOffAmount);
            inWarehsRecordInfo.setBillUnWriteOffBaseQty(CalculateUtil.ZERO);
        }
        this.setInWarehsWriteOffInfo(devInWarehsList);
        for (int j = 0; j < devMatReqList.size(); ++j) {
            devMatReqInfo = (DevolveMatReqBillInfo)devMatReqList.get(j);
            matReqRecordInfo = this.createWrittenOffRecord(ctx, devMatReqInfo, groupInfo, i + j + 1, i + j + 1);
            matReqRecordInfo.setCurrWriteOffQty(devMatReqInfo.getDevUnWriteOffQty());
            matReqRecordInfo.setCurrWriteOffBaseQty(devMatReqInfo.getDevUnWriteOffBaseQty());
            writeOffAmount = devMatReqInfo.getDevUnWriteOffAmount();
            devMatReqInfo.setCurrWriteOffTotalAmount(writeOffAmount);
            matReqRecordInfo.setCurrWriteOffAmount(writeOffAmount);
            matReqRecordInfo.setBillUnWriteOffBaseQty(CalculateUtil.ZERO);
        }
        this.setMatReqWriteOffInfo(devMatReqList, info);
        return true;
    }

    private boolean orderWriteOff(Context ctx, DevolveWriteOffResultInfo info, DevolveWriteOffGroupInfo groupInfo, boolean isContinue) throws BOSException, EASBizException {
        int i;
        List devInWarehsList = info.getDevInWarehsList();
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        WriteOffBillInfo devMatReqInfo = null;
        SubContractOrderEntryInfo entry = null;
        SubMaterialListCollection subMaterialListColl = null;
        SubMaterialListInfo materialListInfo = null;
        HashMap<String, BigDecimal> baseQtyRateMap = new HashMap<String, BigDecimal>();
        HashSet<String> coreIdSet = new HashSet<String>();
        HashMap<String, BigDecimal> entryLossRateMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryBaseQtyMap = new HashMap<String, BigDecimal>();
        HashMap devInWarehsMap = new HashMap();
        HashMap matReqMap = new HashMap();
        Map coreInWarehsMap = this.getCoreInWarehsMap(devInWarehsList);
        DevolveWriteOffRecordInfo inWarehsRecordInfo = null;
        DevolveWriteOffRecordInfo matReqRecordInfo = null;
        int groupNo = 1;
        boolean isWrittenOff = false;
        HashMap globalMaterialMap = new HashMap();
        HashMap<String, BigDecimal> matListUnWriteOffMap = new HashMap<String, BigDecimal>();
        List coreInWarehsList = null;
        String devPurInWarehsBillLabel = EASResource.getString((String)"com.kingdee.eas.scm.cal.DevolveManualWriteOffResource", (String)"devPurInWarehsBill");
        String devMaterialReqBillLabel = EASResource.getString((String)"com.kingdee.eas.scm.cal.DevolveManualWriteOffResource", (String)"devMaterialReqBill");
        String materialNumberLabel = EASResource.getString((String)"com.kingdee.eas.scm.cal.DevolveManualWriteOffResource", (String)"materialNumber");
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyOrgUnitInfo);
        IRowSet rowSet = null;
        for (String subContractOrderEntryId : coreInWarehsMap.keySet()) {
            if (subContractOrderEntryId == null || "".equals(subContractOrderEntryId) || !BOSUuid.read((String)subContractOrderEntryId).getType().equals((Object)new SubContractOrderEntryInfo().getBOSType())) continue;
            isWrittenOff = true;
            groupNo = this.purInWarehsSelfWriteOff(ctx, info, subContractOrderEntryId, coreInWarehsMap, groupInfo, groupNo);
            coreInWarehsList = (List)coreInWarehsMap.get(subContractOrderEntryId);
            entry = (SubContractOrderEntryInfo)SubContractOrderEntryFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(subContractOrderEntryId));
            subMaterialListColl = entry.getEntries1();
            if (subMaterialListColl == null || subMaterialListColl.size() == 0) {
                for (i = 0; i < coreInWarehsList.size(); ++i) {
                    devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i);
                    this.devWarehsInfoList.add(devInWarehsInfo.getNumber());
                }
                continue;
            }
            coreIdSet.clear();
            baseQtyRateMap.clear();
            entryLossRateMap.clear();
            globalMaterialMap.clear();
            matListUnWriteOffMap.clear();
            for (int j = 0; j < subMaterialListColl.size(); ++j) {
                materialListInfo = subMaterialListColl.get(j);
                coreIdSet.add(materialListInfo.getId().toString());
                baseQtyRateMap.put(materialListInfo.getId().toString(), materialListInfo.getBaseQtyRate());
                entryLossRateMap.put(materialListInfo.getId().toString(), materialListInfo.getLossRate());
                entryBaseQtyMap.put(materialListInfo.getId().toString(), materialListInfo.getBaseQty());
            }
            rowSet = this.getMatReqEntryByOrder(ctx, coreIdSet, false);
            Map matEntryId2DevMatBillsMap = this.getDevolveMatReqBillInfoColl(rowSet, globalMaterialMap, matListUnWriteOffMap);
            if (matEntryId2DevMatBillsMap.size() < coreIdSet.size() && !info.isFullWriteOff()) {
                String keyStr = null;
                boolean isNotWriteOff = false;
                for (Object e : coreIdSet) {
                    keyStr = e.toString();
                    if (matEntryId2DevMatBillsMap.get(keyStr) == null && ((BigDecimal)entryBaseQtyMap.get(keyStr)).compareTo(BigDecimal.ZERO) == 0 || ((BigDecimal)matListUnWriteOffMap.get(keyStr)).compareTo(BigDecimal.ZERO) == 0) continue;
                    isNotWriteOff = true;
                    break;
                }
                if (isNotWriteOff) continue;
            }
            boolean isFullWriteOff = false;
            boolean interrupt = false;
            BigDecimal totalWriteOffAmount = CalculateUtil.ZERO;
            int n = 2;
            int purPeriod = 0;
            int matPeriod = 0;
            boolean matchGatherPeriodMat = false;
            for (int i2 = 0; i2 < coreInWarehsList.size(); ++i2) {
                matchGatherPeriodMat = false;
                totalWriteOffAmount = CalculateUtil.ZERO;
                int n2 = 2;
                devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i2);
                purPeriod = devInWarehsInfo.getYear() * 100 + devInWarehsInfo.getPeriod();
                if (CalculateUtil.ZERO.compareTo(devInWarehsInfo.getDevUnWriteOffBaseQty()) == 0) continue;
                this.putDevBillMap(ctx, devInWarehsMap, devInWarehsInfo);
                for (String materialOrderEntryId : matEntryId2DevMatBillsMap.keySet()) {
                    BigDecimal baseQtyRate = (BigDecimal)baseQtyRateMap.get(materialOrderEntryId);
                    if (baseQtyRate == null) {
                        baseQtyRate = BigDecimal.ONE;
                    }
                    if (baseQtyRate.compareTo(BigDecimal.ZERO) == 0) continue;
                    int basePrecision = (Integer)this.materialBaseQtyPrecision.get(materialOrderEntryId);
                    BigDecimal loseRate = (BigDecimal)entryLossRateMap.get(materialOrderEntryId);
                    isFullWriteOff = info.isFullWriteOff() && i2 == coreInWarehsList.size() - 1 && isContinue;
                    List matReqBillList = (List)matEntryId2DevMatBillsMap.get(materialOrderEntryId);
                    n2 = this.matReqSelfWriteOff(ctx, matReqBillList, groupInfo, groupNo, n2);
                    BigDecimal devUnWriteOffBaseQty = CalculateUtil.ZERO;
                    devUnWriteOffBaseQty = devInWarehsInfo.getDevUnWriteOffBaseQty() != null ? devInWarehsInfo.getDevUnWriteOffBaseQty() : CalculateUtil.ZERO;
                    BigDecimal curWriteOffBaseQty = devUnWriteOffBaseQty.multiply(baseQtyRate).multiply(new BigDecimal(1).add(loseRate.divide(new BigDecimal(100)))).setScale(basePrecision, 4);
                    for (int j = 0; j < matReqBillList.size(); ++j) {
                        BigDecimal writeOffAmount;
                        BigDecimal baseUnitPrice;
                        BigDecimal curWriteOffQty;
                        devMatReqInfo = (DevolveMatReqBillInfo)matReqBillList.get(j);
                        matPeriod = devMatReqInfo.getYear() * 100 + devMatReqInfo.getPeriod();
                        if (matPeriod > purPeriod) {
                            matchGatherPeriodMat = true;
                            break;
                        }
                        if (CalculateUtil.ZERO.compareTo(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty()) >= 0) continue;
                        devMatReqInfo.getBizDate();
                        if (isFullWriteOff) {
                            devMatReqInfo.setCurWriteOffBaseQty(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty());
                            if (!isContinue && curWriteOffBaseQty.compareTo(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty()) < 0) {
                                devMatReqInfo.setCurWriteOffBaseQty(curWriteOffBaseQty);
                            }
                            curWriteOffBaseQty = curWriteOffBaseQty.subtract(devMatReqInfo.getCurWriteOffBaseQty());
                            curWriteOffQty = devMatReqInfo.getCurWriteOffBaseQty().divide(((DevolveMatReqBillInfo)devMatReqInfo).getBaseConvsRate(), ((DevolveMatReqBillInfo)devMatReqInfo).getQtyPrecision(), 4);
                            baseUnitPrice = devMatReqInfo.getActualCost().divide(devMatReqInfo.getBaseQty(), 10, 4);
                            writeOffAmount = devMatReqInfo.getCurWriteOffBaseQty().multiply(baseUnitPrice).setScale(devMatReqInfo.getPrecision(), 4);
                            if (devMatReqInfo.getCurWriteOffBaseQty().compareTo(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty()) == 0) {
                                writeOffAmount = devMatReqInfo.getActualCost().subtract(((DevolveMatReqBillInfo)devMatReqInfo).getDevWriteOffAmount());
                                curWriteOffQty = devMatReqInfo.getQty().subtract(((DevolveMatReqBillInfo)devMatReqInfo).getDevWriteOffQty());
                            }
                            devMatReqInfo.setCurrWriteOffTotalAmount(writeOffAmount);
                            totalWriteOffAmount = totalWriteOffAmount.add(writeOffAmount);
                            matReqRecordInfo = this.createWrittenOffRecord(ctx, devMatReqInfo, groupInfo, groupNo, n2++);
                            matReqRecordInfo.setCurrWriteOffQty(curWriteOffQty);
                            matReqRecordInfo.setCurrWriteOffBaseQty(devMatReqInfo.getCurWriteOffBaseQty());
                            matReqRecordInfo.setCurrWriteOffAmount(writeOffAmount);
                            matReqRecordInfo.setBillUnWriteOffBaseQty(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty().subtract(devMatReqInfo.getCurWriteOffBaseQty()));
                            if (curWriteOffBaseQty.compareTo(CalculateUtil.ZERO) != 0 || i2 >= coreInWarehsList.size() - 1) continue;
                            break;
                        }
                        this.putMatReqBillMap(ctx, matReqMap, (DevolveMatReqBillInfo)devMatReqInfo);
                        curWriteOffBaseQty = this.doWriteOffDiff(devInWarehsInfo, (DevolveMatReqBillInfo)devMatReqInfo, entry, devInWarehsMap, matReqMap, baseQtyRate, basePrecision, loseRate, curWriteOffBaseQty);
                        if (curWriteOffBaseQty.compareTo(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty()) > 0) {
                            devMatReqInfo.setCurWriteOffBaseQty(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty());
                            curWriteOffBaseQty = curWriteOffBaseQty.subtract(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty());
                        } else {
                            devMatReqInfo.setCurWriteOffBaseQty(curWriteOffBaseQty);
                            curWriteOffBaseQty = CalculateUtil.ZERO;
                        }
                        curWriteOffQty = devMatReqInfo.getCurWriteOffBaseQty().divide(((DevolveMatReqBillInfo)devMatReqInfo).getBaseConvsRate(), ((DevolveMatReqBillInfo)devMatReqInfo).getQtyPrecision(), 4);
                        baseUnitPrice = devMatReqInfo.getActualCost().divide(devMatReqInfo.getBaseQty(), 10, 4);
                        writeOffAmount = devMatReqInfo.getCurWriteOffBaseQty().multiply(baseUnitPrice).setScale(devMatReqInfo.getPrecision(), 4);
                        if (devMatReqInfo.getCurWriteOffBaseQty().compareTo(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty()) == 0) {
                            writeOffAmount = devMatReqInfo.getActualCost().subtract(((DevolveMatReqBillInfo)devMatReqInfo).getDevWriteOffAmount());
                            curWriteOffQty = devMatReqInfo.getQty().subtract(((DevolveMatReqBillInfo)devMatReqInfo).getDevWriteOffQty());
                        }
                        devMatReqInfo.setCurrWriteOffTotalAmount(writeOffAmount);
                        totalWriteOffAmount = totalWriteOffAmount.add(writeOffAmount);
                        matReqRecordInfo = this.createWrittenOffRecord(ctx, devMatReqInfo, groupInfo, groupNo, n2++);
                        matReqRecordInfo.setCurrWriteOffQty(curWriteOffQty);
                        matReqRecordInfo.setCurrWriteOffBaseQty(devMatReqInfo.getCurWriteOffBaseQty());
                        matReqRecordInfo.setCurrWriteOffAmount(writeOffAmount);
                        matReqRecordInfo.setBillUnWriteOffBaseQty(((DevolveMatReqBillInfo)devMatReqInfo).getDevUnWriteOffBaseQty().subtract(devMatReqInfo.getCurWriteOffBaseQty()));
                        this.updateMatReqMap(matReqMap, (DevolveMatReqBillInfo)devMatReqInfo);
                        if (curWriteOffBaseQty.compareTo(CalculateUtil.ZERO) == 0) break;
                    }
                    if (matchGatherPeriodMat) break;
                    if (curWriteOffBaseQty.compareTo(CalculateUtil.ZERO) == 0 || isContinue) continue;
                    interrupt = true;
                    break;
                }
                if (matchGatherPeriodMat) {
                    for (int k = 0; k < groupInfo.getEntry().size(); ++k) {
                        matReqRecordInfo = groupInfo.getEntry().get(k);
                        if (matReqRecordInfo.getGroupNO() != groupNo) continue;
                        groupInfo.getEntry().remove(matReqRecordInfo);
                        --k;
                    }
                    this.matchGatherMatPurBillList.add(devPurInWarehsBillLabel + devInWarehsInfo.getNumber() + " , " + materialNumberLabel + devInWarehsInfo.getMaterialNumber() + " ( " + devMaterialReqBillLabel + devMatReqInfo.getNumber() + " , " + materialNumberLabel + devMatReqInfo.getMaterialNumber() + " ) ");
                    continue;
                }
                if (interrupt) {
                    for (int k = 0; k < groupInfo.getEntry().size(); ++k) {
                        matReqRecordInfo = groupInfo.getEntry().get(k);
                        if (matReqRecordInfo.getGroupNO() != groupNo) continue;
                        groupInfo.getEntry().remove(matReqRecordInfo);
                        --k;
                    }
                    continue;
                }
                for (String materialOrderEntryId : matEntryId2DevMatBillsMap.keySet()) {
                    List matReqBillList = (List)matEntryId2DevMatBillsMap.get(materialOrderEntryId);
                    this.setMatReqWriteOffInfo(matReqBillList, info);
                }
                if (this.isNeedWriteBack(devInWarehsInfo)) {
                    BigDecimal materialCost = totalWriteOffAmount.divide(devInWarehsInfo.getDevUnWriteOffBaseQty(), 10, 4).multiply(devInWarehsInfo.getBaseQty()).setScale(devInWarehsInfo.getPrecision(), 4);
                    devInWarehsInfo.setMaterialCost(materialCost);
                    BigDecimal unitCost = materialCost.divide(devInWarehsInfo.getQty(), devInWarehsInfo.getPricePrecision(), 4);
                    devInWarehsInfo.setUnitMaterialCost(unitCost);
                }
                inWarehsRecordInfo = this.createWrittenOffRecord(ctx, devInWarehsInfo, groupInfo, groupNo, 1);
                inWarehsRecordInfo.setCurrWriteOffQty(devInWarehsInfo.getDevUnWriteOffQty());
                inWarehsRecordInfo.setCurrWriteOffBaseQty(devInWarehsInfo.getDevUnWriteOffBaseQty());
                inWarehsRecordInfo.setCurrWriteOffAmount(totalWriteOffAmount);
                inWarehsRecordInfo.setBillUnWriteOffBaseQty(CalculateUtil.ZERO);
                devInWarehsInfo.setDevWriteOffQty(devInWarehsInfo.getQty());
                devInWarehsInfo.setDevWriteOffBaseQty(devInWarehsInfo.getBaseQty());
                devInWarehsInfo.setDevUnWriteOffQty(CalculateUtil.ZERO);
                devInWarehsInfo.setDevUnWriteOffBaseQty(CalculateUtil.ZERO);
                ++groupNo;
                this.updateDevInWarehsMap(devInWarehsInfo, devInWarehsMap);
            }
            for (String materialOrderEntryId : matEntryId2DevMatBillsMap.keySet()) {
                List matReqBillList = (List)matEntryId2DevMatBillsMap.get(materialOrderEntryId);
                info.getDevMaterialReqList().addAll(matReqBillList);
            }
        }
        DevolveWriteOffRecordInfo devolveWriteOffRecordInfo = null;
        Date maxDate = this.currPeriod.getBeginDate();
        int size = groupInfo.getEntry().size();
        for (i = 0; i < size; ++i) {
            devolveWriteOffRecordInfo = groupInfo.getEntry().get(i);
            if (!devolveWriteOffRecordInfo.getBillDate().after(maxDate) || !"103".equals(devolveWriteOffRecordInfo.getBillTypeNumber())) continue;
            maxDate = devolveWriteOffRecordInfo.getBillDate();
        }
        PeriodInfo maxPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)maxDate, (CompanyOrgUnitInfo)this.companyOrgUnitInfo, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT);
        if (maxPeriod.isIsAdjustPeriod()) {
            maxPeriod = PeriodUtils.getNextPeriodInfo((PeriodInfo)maxPeriod);
        }
        groupInfo.setWriteOffYear(maxPeriod.getPeriodYear());
        groupInfo.setWriteOffPeriod(maxPeriod.getPeriodNumber());
        return isWrittenOff;
    }

    private int purInWarehsSelfWriteOff(Context ctx, DevolveWriteOffResultInfo info, String coreBillEntryId, Map coreInWarehsMap, DevolveWriteOffGroupInfo groupInfo, int groupNO) throws BOSException {
        int k;
        int ksize;
        BigDecimal totalWriteOffAmount;
        BigDecimal curWriteOffBaseQty;
        BigDecimal unWriteOffBaseQty;
        int i;
        List coreInWarehsList = (List)coreInWarehsMap.get(coreBillEntryId);
        ArrayList<DevolveInWarehsBillInfo> sortCoreInWarehsList = new ArrayList<DevolveInWarehsBillInfo>();
        HashMap<String, DevolveInWarehsBillInfo> coreInWarehsKeyMap = new HashMap<String, DevolveInWarehsBillInfo>();
        DevolveInWarehsBillInfo bill = null;
        int size = coreInWarehsList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            bill = (DevolveInWarehsBillInfo)coreInWarehsList.get(i2);
            coreInWarehsKeyMap.put(bill.getEntryId(), bill);
        }
        List<DevolveInWarehsBillInfo> redList = new ArrayList();
        ArrayList<DevolveInWarehsBillInfo> bothRedList = new ArrayList<DevolveInWarehsBillInfo>();
        HashMap redMap = new HashMap();
        HashSet<String> coreIdSet = new HashSet<String>();
        coreIdSet.add(coreBillEntryId);
        IRowSet rowSet = this.getPurInwarehsEntryByOrder(ctx, coreIdSet, true);
        try {
            while (rowSet.next()) {
                bill = this.buildDevolveInWarehsBillInfo(rowSet);
                if (bill.getDevUnWriteOffBaseQty().compareTo(BigDecimal.ZERO) < 0) {
                    redList = (List)redMap.get(bill.getSourceBillEntryId());
                    if (redList == null) {
                        redList = new ArrayList();
                        redMap.put(bill.getSourceBillEntryId(), redList);
                    }
                    redList.add(bill);
                    bothRedList.add(bill);
                    continue;
                }
                if (coreInWarehsKeyMap.get(bill.getEntryId()) == null) continue;
                sortCoreInWarehsList.add((DevolveInWarehsBillInfo)coreInWarehsKeyMap.get(bill.getEntryId()));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        coreInWarehsMap.put(coreBillEntryId, sortCoreInWarehsList);
        HashSet<DevolveInWarehsBillInfo> redSet = new HashSet<DevolveInWarehsBillInfo>();
        DevolveInWarehsBillInfo blueBill = null;
        DevolveInWarehsBillInfo redBill = null;
        int seq = 0;
        boolean hasDevolve = false;
        int size2 = sortCoreInWarehsList.size();
        for (i = 0; i < size2; ++i) {
            seq = 1;
            hasDevolve = false;
            blueBill = (DevolveInWarehsBillInfo)sortCoreInWarehsList.get(i);
            unWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty();
            curWriteOffBaseQty = BigDecimal.ZERO;
            totalWriteOffAmount = BigDecimal.ZERO;
            redList = (List)redMap.get(blueBill.getEntryId());
            if (redList != null) {
                ksize = redList.size();
                for (k = 0; k < ksize; ++k) {
                    redBill = (DevolveInWarehsBillInfo)redList.get(k);
                    if (CalculateUtil.ZERO.compareTo(redBill.getDevUnWriteOffBaseQty()) == 0) continue;
                    curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty().negate() : blueBill.getDevUnWriteOffBaseQty();
                    this.devolvePurInWarehsBill(blueBill, curWriteOffBaseQty, totalWriteOffAmount);
                    this.createPurInWarehsWriteOffRecord(ctx, blueBill, groupInfo, totalWriteOffAmount, groupNO, seq++);
                    this.devolvePurInWarehsBill(redBill, curWriteOffBaseQty.negate(), totalWriteOffAmount);
                    this.createPurInWarehsWriteOffRecord(ctx, redBill, groupInfo, totalWriteOffAmount, groupNO, seq++);
                    redSet.add(redBill);
                    unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                    hasDevolve = true;
                    if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) break;
                }
            }
            if (!hasDevolve) continue;
            ++groupNO;
        }
        size2 = sortCoreInWarehsList.size();
        for (i = 0; i < size2; ++i) {
            seq = 1;
            hasDevolve = false;
            blueBill = (DevolveInWarehsBillInfo)sortCoreInWarehsList.get(i);
            unWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty();
            curWriteOffBaseQty = BigDecimal.ZERO;
            totalWriteOffAmount = BigDecimal.ZERO;
            ksize = bothRedList.size();
            for (k = 0; k < ksize; ++k) {
                redBill = (DevolveInWarehsBillInfo)bothRedList.get(k);
                if (CalculateUtil.ZERO.compareTo(redBill.getDevUnWriteOffBaseQty()) == 0) continue;
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty().negate() : blueBill.getDevUnWriteOffBaseQty();
                this.devolvePurInWarehsBill(blueBill, curWriteOffBaseQty, totalWriteOffAmount);
                this.createPurInWarehsWriteOffRecord(ctx, blueBill, groupInfo, totalWriteOffAmount, groupNO, seq++);
                this.devolvePurInWarehsBill(redBill, curWriteOffBaseQty.negate(), totalWriteOffAmount);
                this.createPurInWarehsWriteOffRecord(ctx, redBill, groupInfo, totalWriteOffAmount, groupNO, seq++);
                redSet.add(redBill);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                hasDevolve = true;
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) break;
            }
            if (!hasDevolve) continue;
            ++groupNO;
        }
        info.getDevInWarehsList().addAll(redSet);
        return groupNO;
    }

    private void purInWarehsSelfWriteOffCheck(Context ctx, String coreBillEntryId, Map coreInWarehsMap) throws BOSException {
        int k;
        int ksize;
        BigDecimal totalWriteOffAmount;
        BigDecimal curWriteOffBaseQty;
        BigDecimal unWriteOffBaseQty;
        int i;
        List coreInWarehsList = (List)coreInWarehsMap.get(coreBillEntryId);
        ArrayList<DevolveInWarehsBillInfo> sortCoreInWarehsList = new ArrayList<DevolveInWarehsBillInfo>();
        HashMap<String, DevolveInWarehsBillInfo> coreInWarehsKeyMap = new HashMap<String, DevolveInWarehsBillInfo>();
        DevolveInWarehsBillInfo bill = null;
        int size = coreInWarehsList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            bill = (DevolveInWarehsBillInfo)coreInWarehsList.get(i2);
            coreInWarehsKeyMap.put(bill.getEntryId(), bill);
        }
        List<DevolveInWarehsBillInfo> redList = new ArrayList();
        ArrayList<DevolveInWarehsBillInfo> bothRedList = new ArrayList<DevolveInWarehsBillInfo>();
        HashMap redMap = new HashMap();
        HashSet<String> coreIdSet = new HashSet<String>();
        coreIdSet.add(coreBillEntryId);
        IRowSet rowSet = this.getPurInwarehsEntryByOrder(ctx, coreIdSet, true);
        try {
            while (rowSet.next()) {
                bill = this.buildDevolveInWarehsBillInfo(rowSet);
                if (bill.getDevUnWriteOffBaseQty().compareTo(BigDecimal.ZERO) < 0) {
                    redList = (List)redMap.get(bill.getSourceBillEntryId());
                    if (redList == null) {
                        redList = new ArrayList();
                        redMap.put(bill.getSourceBillEntryId(), redList);
                    }
                    redList.add(bill);
                    bothRedList.add(bill);
                    continue;
                }
                if (coreInWarehsKeyMap.get(bill.getEntryId()) == null) continue;
                sortCoreInWarehsList.add(bill);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        coreInWarehsMap.put(coreBillEntryId, sortCoreInWarehsList);
        HashSet<DevolveInWarehsBillInfo> redSet = new HashSet<DevolveInWarehsBillInfo>();
        DevolveInWarehsBillInfo blueBill = null;
        DevolveInWarehsBillInfo redBill = null;
        int size2 = sortCoreInWarehsList.size();
        block4: for (i = 0; i < size2; ++i) {
            blueBill = (DevolveInWarehsBillInfo)sortCoreInWarehsList.get(i);
            unWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty();
            curWriteOffBaseQty = BigDecimal.ZERO;
            totalWriteOffAmount = BigDecimal.ZERO;
            redList = (List)redMap.get(blueBill.getEntryId());
            if (redList == null) continue;
            ksize = redList.size();
            for (k = 0; k < ksize; ++k) {
                redBill = (DevolveInWarehsBillInfo)redList.get(k);
                if (CalculateUtil.ZERO.compareTo(redBill.getDevUnWriteOffBaseQty()) == 0) continue;
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty().negate() : blueBill.getDevUnWriteOffBaseQty();
                this.devolvePurInWarehsBill(blueBill, curWriteOffBaseQty, totalWriteOffAmount);
                this.devolvePurInWarehsBill(redBill, curWriteOffBaseQty.negate(), totalWriteOffAmount);
                redSet.add(redBill);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) continue block4;
            }
        }
        size2 = sortCoreInWarehsList.size();
        block6: for (i = 0; i < size2; ++i) {
            blueBill = (DevolveInWarehsBillInfo)sortCoreInWarehsList.get(i);
            unWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty();
            curWriteOffBaseQty = BigDecimal.ZERO;
            totalWriteOffAmount = BigDecimal.ZERO;
            ksize = bothRedList.size();
            for (k = 0; k < ksize; ++k) {
                redBill = (DevolveInWarehsBillInfo)bothRedList.get(k);
                if (CalculateUtil.ZERO.compareTo(redBill.getDevUnWriteOffBaseQty()) == 0) continue;
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty().negate() : blueBill.getDevUnWriteOffBaseQty();
                this.devolvePurInWarehsBill(blueBill, curWriteOffBaseQty, totalWriteOffAmount);
                this.devolvePurInWarehsBill(redBill, curWriteOffBaseQty.negate(), totalWriteOffAmount);
                redSet.add(redBill);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) continue block6;
            }
        }
    }

    private int matReqSelfWriteOff(Context ctx, List matReqBillList, DevolveWriteOffGroupInfo groupInfo, int groupNo, int seq) {
        ArrayList<DevolveMatReqBillInfo> redPool = new ArrayList<DevolveMatReqBillInfo>();
        ArrayList<DevolveMatReqBillInfo> bluePool = new ArrayList<DevolveMatReqBillInfo>();
        HashMap<String, DevolveMatReqBillInfo> matReqMap = new HashMap<String, DevolveMatReqBillInfo>();
        DevolveMatReqBillInfo matInfo = null;
        int size = matReqBillList.size();
        for (int i = 0; i < size; ++i) {
            matInfo = (DevolveMatReqBillInfo)matReqBillList.get(i);
            if (matInfo.getQty().compareTo(BigDecimal.ZERO) < 0) {
                redPool.add(matInfo);
            } else if (matInfo.getQty().compareTo(BigDecimal.ZERO) > 0) {
                bluePool.add(matInfo);
            }
            matReqMap.put(matInfo.getEntryId(), matInfo);
        }
        DevolveMatReqBillInfo redBill = null;
        DevolveMatReqBillInfo blueBill = null;
        int size2 = redPool.size();
        block1: for (int i = 0; i < size2; ++i) {
            redBill = (DevolveMatReqBillInfo)redPool.get(i);
            if (CalculateUtil.ZERO.compareTo(redBill.getDevUnWriteOffBaseQty()) == 0) continue;
            blueBill = (DevolveMatReqBillInfo)matReqMap.get(redBill.getSourceBillEntryId());
            BigDecimal unWriteOffBaseQty = redBill.getDevUnWriteOffBaseQty();
            BigDecimal curWriteOffBaseQty = BigDecimal.ZERO;
            if (blueBill != null) {
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty() : blueBill.getDevUnWriteOffBaseQty().negate();
                this.devolveMatReqBill(blueBill, curWriteOffBaseQty.negate());
                this.createMatReqBillWriteOffRecord(ctx, blueBill, groupInfo, groupNo, seq++);
                this.devolveMatReqBill(redBill, curWriteOffBaseQty);
                this.createMatReqBillWriteOffRecord(ctx, redBill, groupInfo, groupNo, seq++);
                blueBill.setCurWriteOffBaseQty(BigDecimal.ZERO);
                redBill.setCurWriteOffBaseQty(BigDecimal.ZERO);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) break;
            }
            int ksize = bluePool.size();
            for (int k = 0; k < ksize; ++k) {
                blueBill = (DevolveMatReqBillInfo)bluePool.get(k);
                if (CalculateUtil.ZERO.compareTo(blueBill.getDevUnWriteOffBaseQty()) == 0) continue;
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty() : blueBill.getDevUnWriteOffBaseQty().negate();
                this.devolveMatReqBill(blueBill, curWriteOffBaseQty.negate());
                this.createMatReqBillWriteOffRecord(ctx, blueBill, groupInfo, groupNo, seq++);
                this.devolveMatReqBill(redBill, curWriteOffBaseQty);
                this.createMatReqBillWriteOffRecord(ctx, redBill, groupInfo, groupNo, seq++);
                blueBill.setCurWriteOffBaseQty(BigDecimal.ZERO);
                redBill.setCurWriteOffBaseQty(BigDecimal.ZERO);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) continue block1;
            }
        }
        return seq;
    }

    private void matReqSelfWriteOffCheck(List matReqBillList) {
        ArrayList<DevolveMatReqBillInfo> redPool = new ArrayList<DevolveMatReqBillInfo>();
        ArrayList<DevolveMatReqBillInfo> bluePool = new ArrayList<DevolveMatReqBillInfo>();
        HashMap<String, DevolveMatReqBillInfo> matReqMap = new HashMap<String, DevolveMatReqBillInfo>();
        DevolveMatReqBillInfo matInfo = null;
        int size = matReqBillList.size();
        for (int i = 0; i < size; ++i) {
            matInfo = (DevolveMatReqBillInfo)matReqBillList.get(i);
            if (matInfo.getDevUnWriteOffBaseQty().compareTo(BigDecimal.ZERO) < 0) {
                redPool.add(matInfo);
            } else {
                bluePool.add(matInfo);
            }
            matReqMap.put(matInfo.getEntryId(), matInfo);
        }
        DevolveMatReqBillInfo redBill = null;
        DevolveMatReqBillInfo blueBill = null;
        int size2 = redPool.size();
        block1: for (int i = 0; i < size2; ++i) {
            redBill = (DevolveMatReqBillInfo)redPool.get(i);
            blueBill = (DevolveMatReqBillInfo)matReqMap.get(redBill.getSourceBillEntryId());
            BigDecimal unWriteOffBaseQty = redBill.getDevUnWriteOffBaseQty();
            BigDecimal curWriteOffBaseQty = BigDecimal.ZERO;
            if (blueBill != null) {
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty() : blueBill.getDevUnWriteOffBaseQty().negate();
                this.devolveMatReqBill(blueBill, curWriteOffBaseQty.negate());
                this.devolveMatReqBill(redBill, curWriteOffBaseQty);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) break;
            }
            int ksize = bluePool.size();
            for (int k = 0; k < ksize; ++k) {
                blueBill = (DevolveMatReqBillInfo)bluePool.get(k);
                if (CalculateUtil.ZERO.compareTo(blueBill.getDevUnWriteOffBaseQty()) == 0) continue;
                curWriteOffBaseQty = blueBill.getDevUnWriteOffBaseQty().add(redBill.getDevUnWriteOffBaseQty()).compareTo(BigDecimal.ZERO) >= 0 ? redBill.getDevUnWriteOffBaseQty() : blueBill.getDevUnWriteOffBaseQty().negate();
                this.devolveMatReqBill(blueBill, curWriteOffBaseQty.negate());
                this.devolveMatReqBill(redBill, curWriteOffBaseQty);
                unWriteOffBaseQty = unWriteOffBaseQty.subtract(curWriteOffBaseQty);
                if (unWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) continue block1;
            }
        }
    }

    private Map getDevolveMatReqBillInfoColl(IRowSet rowSet, Map globalMaterialMap, Map<String, BigDecimal> matListUnWriteOffMap) throws BOSException {
        HashMap<String, ArrayList<DevolveMatReqBillInfo>> materialMap = new HashMap<String, ArrayList<DevolveMatReqBillInfo>>();
        DevolveMatReqBillInfo matReqBillInfo = null;
        DevolveMatReqBillInfo existMatReqBillInfo = null;
        boolean isExist = false;
        try {
            while (rowSet.next()) {
                ArrayList<DevolveMatReqBillInfo> matReqBillList;
                matReqBillInfo = this.buildDevolveMatReqInfo(rowSet);
                String subMaterialId = matReqBillInfo.getCoreBillEntryId();
                if (matListUnWriteOffMap.containsKey(subMaterialId)) {
                    BigDecimal sumUnWriteOffQty = matListUnWriteOffMap.get(subMaterialId).add(matReqBillInfo.getDevUnWriteOffBaseQty());
                    matListUnWriteOffMap.put(subMaterialId, sumUnWriteOffQty);
                } else {
                    matListUnWriteOffMap.put(subMaterialId, matReqBillInfo.getDevUnWriteOffBaseQty());
                }
                if (matReqBillInfo.getDevUnWriteOffBaseQty().compareTo(BigDecimal.ZERO) == 0) continue;
                ArrayList<DevolveMatReqBillInfo> globalMatReqBillList = (ArrayList<DevolveMatReqBillInfo>)globalMaterialMap.get(matReqBillInfo.getCoreBillEntryId());
                for (int i = 0; globalMatReqBillList != null && i < globalMatReqBillList.size(); ++i) {
                    existMatReqBillInfo = (DevolveMatReqBillInfo)globalMatReqBillList.get(i);
                    if (!existMatReqBillInfo.getEntryId().equals(matReqBillInfo.getEntryId())) continue;
                    matReqBillInfo = existMatReqBillInfo;
                    matReqBillInfo.setCurWriteOffBaseQty(CalculateUtil.ZERO);
                    matReqBillInfo.setCurrWriteOffTotalAmount(CalculateUtil.ZERO);
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    if (globalMatReqBillList == null) {
                        globalMatReqBillList = new ArrayList<DevolveMatReqBillInfo>();
                    }
                    globalMatReqBillList.add(matReqBillInfo);
                    globalMaterialMap.put(subMaterialId, globalMatReqBillList);
                }
                if ((matReqBillList = (ArrayList<DevolveMatReqBillInfo>)materialMap.get(subMaterialId)) == null) {
                    matReqBillList = new ArrayList<DevolveMatReqBillInfo>();
                }
                matReqBillList.add(matReqBillInfo);
                materialMap.put(subMaterialId, matReqBillList);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return materialMap;
    }

    private IRowSet getPurInwarehsEntryByOrder(Context ctx, Set sourceIdSet, Boolean isFilterQty) throws BOSException {
        String queryId = "com.kingdee.eas.scm.cal.DevolvePurInWarehsQuery";
        MetaDataPK queryPk = MetaDataPK.create((String)"com.kingdee.eas.scm.cal.DevolvePurInWarehsQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPk);
        queryExec.option().isIgnorePermissionCheck = true;
        queryExec.option().isIgnoreOrder = true;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry.coreBillEntryId", (Object)sourceIdSet, CompareType.INCLUDE));
        if (isFilterQty.booleanValue()) {
            filter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)new Integer(0), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        if (isFilterQty.booleanValue()) {
            filter.setMaskString("(#0 and #1 and #2)");
        } else {
            filter.setMaskString("(#0 and #1)");
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizDate"));
        sorter.add(new SorterItemInfo("auditTime"));
        viewInfo.setSorter(sorter);
        queryExec.setObjectView(viewInfo);
        String sSQL = queryExec.getSQL();
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        return rowSet;
    }

    private DevolveInWarehsBillInfo buildDevolveInWarehsBillInfo(IRowSet rowSet) throws SQLException {
        DevolveInWarehsBillInfo info = new DevolveInWarehsBillInfo(rowSet.getString("entry.id"));
        info.setBillId(rowSet.getString("id"));
        info.setNumber(rowSet.getString("number"));
        info.setBizDate(rowSet.getTimestamp("bizDate"));
        info.setBillType(rowSet.getString("billType"));
        info.setQty(rowSet.getBigDecimal("entry.qty"));
        info.setBaseQty(rowSet.getBigDecimal("entry.baseQty"));
        info.setCurWriteOffBaseQty(CalculateUtil.ZERO);
        info.setMaterialCost(rowSet.getBigDecimal("entry.materialCost"));
        info.setPurchaseCost(rowSet.getBigDecimal("entry.purchaseCost"));
        info.setCoreBillType(rowSet.getString("entry.coreBillType"));
        info.setCoreBillNumber(rowSet.getString("entry.coreBillNumber"));
        info.setCoreBillEntrySeq(rowSet.getInt("entry.coreBillEntrySeq"));
        info.setCoreBillId(rowSet.getString("entry.coreBillId"));
        info.setCoreBillEntryId(rowSet.getString("entry.coreBillEntryId"));
        info.setMaterialId(rowSet.getString("material.id"));
        info.setCompanyOrgUnitID(rowSet.getString("companyOrgUnit.id"));
        info.setStorageOrgUnitId(rowSet.getString("storageOrgUnit.id"));
        info.setWareHouseID(rowSet.getString("warehouse.id"));
        info.setSupplierId(rowSet.getString("SUPPLIER.ID"));
        info.setPrecision(rowSet.getInt("baseCurrency.precision"));
        info.setPricePrecision(rowSet.getInt("material.pricePrecision"));
        info.setQtyPrecision(rowSet.getInt("unit.qtyPrecision"));
        info.setBaseQtyPrecision(rowSet.getInt("baseUnit.qtyPrecision"));
        this.materialBaseQtyPrecision.put(info.getMaterialId(), new Integer(info.getBaseQtyPrecision()));
        info.setBaseUnitID(rowSet.getString("baseUnit.id"));
        info.setYear(rowSet.getInt("bizYear"));
        info.setPeriod(rowSet.getInt("bizPeriod"));
        info.setDevUnWriteOffBaseQty(rowSet.getBigDecimal("entry.unWriteOffBaseQty"));
        info.setDevUnWriteOffQty(rowSet.getBigDecimal("entry.unWriteOffQty"));
        info.setDevWriteOffBaseQty(rowSet.getBigDecimal("entry.writeOffBaseQty"));
        info.setDevWriteOffQty(rowSet.getBigDecimal("entry.writeOffQty"));
        info.setCurrWriteOffTotalAmount(CalculateUtil.ZERO);
        info.setLot(rowSet.getString("entry.lot"));
        info.setSeq(rowSet.getInt("entry.seq"));
        info.setPresent(rowSet.getBoolean("entry.isPresent"));
        info.setFiVouchered(rowSet.getBoolean("isVouchered"));
        info.setTransactionTypeID(rowSet.getString("transactionType.id"));
        info.setReverseQty(rowSet.getBigDecimal("entry.reverseQty"));
        info.setReversed(rowSet.getBoolean("isReversed"));
        info.setBaseConvsRate(rowSet.getBigDecimal("baseConvsRate"));
        info.setSourceBillId(rowSet.getString("entry.sourceBillId"));
        info.setSourceBillEntryId(rowSet.getString("entry.sourceBillEntryId"));
        return info;
    }

    private IRowSet getMatReqEntryByOrder(Context ctx, Set sourceIdSet, boolean isFilterQty) throws BOSException {
        String queryId = "com.kingdee.eas.scm.cal.DevolveMaterialReqBillQuery";
        MetaDataPK queryPk = MetaDataPK.create((String)"com.kingdee.eas.scm.cal.DevolveMaterialReqBillQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPk);
        queryExec.option().isIgnorePermissionCheck = true;
        queryExec.option().isIgnoreOrder = true;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry.coreBillEntryId", (Object)sourceIdSet, CompareType.INCLUDE));
        if (isFilterQty) {
            filter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)new Integer(0), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        if (isFilterQty) {
            filter.setMaskString("(#0 and #1 and #2)");
        } else {
            filter.setMaskString("(#0 and #1)");
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizDate"));
        sorter.add(new SorterItemInfo("auditTime"));
        viewInfo.setSorter(sorter);
        queryExec.setObjectView(viewInfo);
        String sSQL = queryExec.getSQL();
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        return rowSet;
    }

    private IRowSet getMatReqEntryByID(Context ctx, Set entryIdSet) throws BOSException {
        String queryId = "com.kingdee.eas.scm.cal.DevolveMaterialReqBillQuery";
        MetaDataPK queryPk = MetaDataPK.create((String)"com.kingdee.eas.scm.cal.DevolveMaterialReqBillQuery");
        IQueryExecutor queryExec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPk);
        queryExec.option().isIgnorePermissionCheck = true;
        queryExec.option().isIgnoreOrder = true;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entry.id", (Object)entryIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("entry.unWriteOffBaseQty", (Object)new Integer(0), CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)new Integer(4)));
        filter.setMaskString("(#0 and #1 and #2)");
        viewInfo.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("bizDate"));
        sorter.add(new SorterItemInfo("auditTime"));
        viewInfo.setSorter(sorter);
        queryExec.setObjectView(viewInfo);
        String sSQL = queryExec.getSQL();
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        return rowSet;
    }

    private DevolveMatReqBillInfo buildDevolveMatReqInfo(IRowSet rowSet) throws SQLException {
        DevolveMatReqBillInfo info = new DevolveMatReqBillInfo(rowSet.getString("entry.id"));
        info.setBillId(rowSet.getString("id"));
        info.setNumber(rowSet.getString("number"));
        info.setBizDate(rowSet.getTimestamp("bizDate"));
        info.setBillType(rowSet.getString("billType"));
        info.setQty(rowSet.getBigDecimal("entry.qty"));
        info.setBaseQty(rowSet.getBigDecimal("entry.baseQty"));
        info.setCurWriteOffBaseQty(CalculateUtil.ZERO);
        info.setActualCost(rowSet.getBigDecimal("entry.actualCost"));
        info.setUnitActualCost(rowSet.getBigDecimal("entry.unitActualCost"));
        info.setCoreBillType(rowSet.getString("entry.coreBillType"));
        info.setCoreBillNumber(rowSet.getString("entry.coreBillNumber"));
        info.setCoreBillEntrySeq(rowSet.getInt("entry.coreBillEntrySeq"));
        info.setCoreBillId(rowSet.getString("entry.coreBillId"));
        info.setCoreBillEntryId(rowSet.getString("entry.coreBillEntryId"));
        info.setMaterialId(rowSet.getString("material.id"));
        info.setCompanyOrgUnitID(rowSet.getString("companyOrgUnitId"));
        info.setStorageOrgUnitId(rowSet.getString("storageOrgUnitId"));
        info.setWareHouseID(rowSet.getString("warehouse.id"));
        info.setMaterialNumber(rowSet.getString("material.number"));
        info.setMaterialName(rowSet.getString("material.name"));
        info.setSupplierId(rowSet.getString("SUPPLIER.ID"));
        info.setPrecision(rowSet.getInt("baseCurrency.precision"));
        info.setPricePrecision(rowSet.getInt("material.pricePrecision"));
        info.setQtyPrecision(rowSet.getInt("qtyPrecision"));
        info.setBaseQtyPrecision(rowSet.getInt("baseQtyPrecision"));
        this.materialBaseQtyPrecision.put(info.getCoreBillEntryId(), new Integer(info.getBaseQtyPrecision()));
        info.setBaseUnitID(rowSet.getString("baseUnit.id"));
        info.setYear(rowSet.getInt("bizYear"));
        info.setPeriod(rowSet.getInt("bizPeriod"));
        info.setDevUnWriteOffBaseQty(rowSet.getBigDecimal("entry.unWriteOffBaseQty"));
        info.setDevUnWriteOffQty(rowSet.getBigDecimal("entry.unWriteOffQty"));
        info.setDevWriteOffBaseQty(rowSet.getBigDecimal("entry.writtenOffBaseQty"));
        info.setDevWriteOffQty(rowSet.getBigDecimal("entry.writeOffQty"));
        info.setHasWriteOffBaseQty(CalculateUtil.ZERO);
        info.setHasWriteOffQty(CalculateUtil.ZERO);
        info.setCurrWriteOffTotalAmount(CalculateUtil.ZERO);
        info.setDevWriteOffAmount(rowSet.getBigDecimal("entry.writeOffAmount"));
        info.setDevUnWriteOffAmount(rowSet.getBigDecimal("entry.unWriteOffAmount"));
        info.setLot(rowSet.getString("entry.lot"));
        info.setSeq(rowSet.getInt("entry.seq"));
        info.setPresent(rowSet.getBoolean("entry.isPresent"));
        info.setFiVouchered(rowSet.getBoolean("fiVouchered"));
        info.setTransactionTypeID(rowSet.getString("transactionType.id"));
        info.setReverseQty(rowSet.getBigDecimal("entry.reverseQty"));
        info.setReversed(rowSet.getBoolean("isReversed"));
        info.setBaseConvsRate(rowSet.getBigDecimal("baseConvsRate"));
        info.setSourceBillId(rowSet.getString("entry.sourceBillId"));
        info.setSourceBillEntryId(rowSet.getString("entry.sourceBillEntryId"));
        return info;
    }

    private BigDecimal getDevInWarehsTotal(DevolveWriteOffResultInfo info) {
        BigDecimal total = CalculateUtil.ZERO;
        DevolveInWarehsBillInfo vo = null;
        List devInWarehsList = info.getDevInWarehsList();
        for (int i = 0; i < devInWarehsList.size(); ++i) {
            vo = (DevolveInWarehsBillInfo)devInWarehsList.get(i);
            total = info.getApportionRule() == 1 ? total.add(vo.getMaterialCost()) : (info.getApportionRule() == 2 ? total.add(vo.getBaseQty()) : total.add(vo.getPurchaseCost()));
        }
        return total;
    }

    private DevolveWriteOffGroupInfo createWrittenOffGroup(Context ctx, DevolveWriteOffResultInfo info) {
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        DevolveWriteOffGroupInfo groupInfo = new DevolveWriteOffGroupInfo();
        groupInfo.setId(BOSUuid.create((BOSObjectType)groupInfo.getBOSType()));
        groupInfo.setNumber(format.format(date));
        groupInfo.setCompanyOrgUnit(this.companyOrgUnitInfo);
        groupInfo.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
        groupInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        groupInfo.setWriteOffDate(date);
        groupInfo.setBizDate(info.getBizDate());
        groupInfo.setWriteOffYear(info.getYear());
        groupInfo.setWriteOffPeriod(info.getPeriod());
        groupInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        groupInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        groupInfo.setFiVouchered(false);
        groupInfo.setCreateType(this.getMatCostWriteOffType(info.getWriteOffStandard()));
        return groupInfo;
    }

    private DevolveWriteOffRecordInfo createWrittenOffRecord(Context ctx, WriteOffBillInfo calEntry, DevolveWriteOffGroupInfo groupInfo, int groupNO, int seq) {
        DevolveWriteOffRecordInfo writeOffRecordInfo = new DevolveWriteOffRecordInfo();
        writeOffRecordInfo.setId(BOSUuid.create((BOSObjectType)writeOffRecordInfo.getBOSType()));
        writeOffRecordInfo.setGroupNO(groupNO);
        writeOffRecordInfo.setSeq(seq);
        writeOffRecordInfo.setOrderBillNumber(calEntry.getCoreBillNumber());
        writeOffRecordInfo.setOrderBillEntrySeq(calEntry.getCoreBillEntrySeq());
        SupplierInfo supplierinfo = null;
        if (calEntry.getSupplierId() != null) {
            supplierinfo = new SupplierInfo();
            supplierinfo.setId(BOSUuid.read((String)calEntry.getSupplierId()));
        }
        writeOffRecordInfo.setSupplier(supplierinfo);
        MaterialInfo material = null;
        if (calEntry.getMaterialId() != null) {
            material = new MaterialInfo();
            material.setId(BOSUuid.read((String)calEntry.getMaterialId()));
        }
        writeOffRecordInfo.setMaterial(material);
        MeasureUnitInfo baseUnit = null;
        if (calEntry.getBaseUnitID() != null) {
            baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)calEntry.getBaseUnitID()));
        }
        writeOffRecordInfo.setBaseUnit(baseUnit);
        writeOffRecordInfo.setBillID(calEntry.getBillId());
        writeOffRecordInfo.setBillEntryID(calEntry.getEntryId());
        writeOffRecordInfo.setBillNumber(calEntry.getNumber());
        writeOffRecordInfo.setBillEntrySeq(calEntry.getSeq());
        writeOffRecordInfo.setBillDate(calEntry.getBizDate());
        writeOffRecordInfo.setBillTypeNumber(calEntry.getBillType());
        writeOffRecordInfo.setTransactionType(calEntry.getTransactionTypeID());
        writeOffRecordInfo.setLot(calEntry.getLot());
        writeOffRecordInfo.setCompanyOrgUnit(calEntry.getCompanyOrgUnitID());
        writeOffRecordInfo.setCalcutator(ContextUtil.getCurrentUserInfo((Context)ctx));
        groupInfo.getEntry().add(writeOffRecordInfo);
        return writeOffRecordInfo;
    }

    private boolean isNeedWriteBack(DevolveInWarehsBillInfo info) {
        return !info.isFiVouchered() && (info.getYear() > this.currPeriod.getPeriodYear() || info.getYear() == this.currPeriod.getPeriodYear() && info.getPeriod() >= this.currPeriod.getPeriodNumber());
    }

    private void saveDevolveInWarehsBillInfo(Context ctx, DevolveWriteOffResultInfo info) throws BOSException {
        List devInWarehsBillList = info.getDevInWarehsList();
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("update T_IM_PurInWarehsEntry set ");
        updateSQL.append(" FSCWrittenOffQty = ?, FSCWrittenOffBaseQty = ?, FSCUnWrittenOffQty = ?, FSCUnWrittenOffBaseQty = ? ");
        updateSQL.append(" where FID = ?");
        int curPeriodNumber = this.currPeriod.getPeriodYear() * 100 + this.currPeriod.getPeriodNumber();
        StringBuffer updateMaterialCostSQL = new StringBuffer();
        updateMaterialCostSQL.append(" update T_IM_PurInWarehsEntry set FMaterialCost = ?, FUnitMaterialCost = ? ");
        updateMaterialCostSQL.append(" where FID = ?");
        int billPeriod = 0;
        int count = 0;
        String updateActualCost = WriteOffHelp.getCalcPurActualCostSQL();
        Connection conn = null;
        PreparedStatement pm = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(updateSQL.toString());
            pm1 = conn.prepareStatement(updateMaterialCostSQL.toString());
            pm2 = conn.prepareStatement(updateActualCost);
            for (int i = 0; i < devInWarehsBillList.size(); ++i) {
                devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsBillList.get(i);
                pm.setBigDecimal(1, devInWarehsInfo.getDevWriteOffQty());
                pm.setBigDecimal(2, devInWarehsInfo.getDevWriteOffBaseQty());
                pm.setBigDecimal(3, devInWarehsInfo.getDevUnWriteOffQty());
                pm.setBigDecimal(4, devInWarehsInfo.getDevUnWriteOffBaseQty());
                pm.setString(5, devInWarehsInfo.getEntryId());
                pm.addBatch();
                billPeriod = devInWarehsInfo.getYear() * 100 + devInWarehsInfo.getPeriod();
                if (devInWarehsInfo.isFiVouchered() || billPeriod < curPeriodNumber) continue;
                pm1.setBigDecimal(1, devInWarehsInfo.getMaterialCost());
                pm1.setBigDecimal(2, devInWarehsInfo.getUnitMaterialCost() == null ? BigDecimal.ZERO : devInWarehsInfo.getUnitMaterialCost());
                pm1.setString(3, devInWarehsInfo.getEntryId());
                pm1.addBatch();
                pm2.setString(1, devInWarehsInfo.getEntryId());
                pm2.setString(2, devInWarehsInfo.getEntryId());
                pm2.addBatch();
                ++count;
            }
            pm.executeBatch();
            if (count > 0) {
                pm1.executeBatch();
                pm2.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pm);
                SQLUtils.cleanup(pm1);
                SQLUtils.cleanup(pm2, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pm);
        SQLUtils.cleanup((Statement)pm1);
        SQLUtils.cleanup((Statement)pm2, (Connection)conn);
    }

    private void saveDevolveMatReqBillInfo(Context ctx, List devMatReqBillList) throws BOSException {
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("update T_IM_MaterialReqBillEntry set FSubWrittenOffQty = ?, FSubWrittenOffBaseQty = ?,");
        updateSQL.append("FSubUnWriteOffQty = ?, FSubUnWriteOffBaseQty = ?, FSCWrittenOffAmount = ?, FSCUnWrittenOffAmount = ? ");
        updateSQL.append("where FID = ?");
        Connection conn = null;
        PreparedStatement pm = null;
        DevolveMatReqBillInfo devMatReqInfo = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(updateSQL.toString());
            for (int i = 0; i < devMatReqBillList.size(); ++i) {
                devMatReqInfo = (DevolveMatReqBillInfo)devMatReqBillList.get(i);
                pm.setBigDecimal(1, devMatReqInfo.getDevWriteOffQty());
                pm.setBigDecimal(2, devMatReqInfo.getDevWriteOffBaseQty());
                pm.setBigDecimal(3, devMatReqInfo.getDevUnWriteOffQty());
                pm.setBigDecimal(4, devMatReqInfo.getDevUnWriteOffBaseQty());
                pm.setBigDecimal(5, devMatReqInfo.getDevWriteOffAmount());
                pm.setBigDecimal(6, devMatReqInfo.getDevUnWriteOffAmount());
                pm.setString(7, devMatReqInfo.getEntryId());
                pm.addBatch();
            }
            pm.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, pm);
                throw throwable;
            }
        }
        DBUtil.close(conn, pm);
    }

    private void setInWarehsWriteOffInfo(List devInWarehsBillList) {
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        for (int i = 0; i < devInWarehsBillList.size(); ++i) {
            devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsBillList.get(i);
            if (this.devWarehsInfoList.indexOf(devInWarehsInfo.getNumber()) >= 0) continue;
            devInWarehsInfo.setDevWriteOffQty(devInWarehsInfo.getQty());
            devInWarehsInfo.setDevWriteOffBaseQty(devInWarehsInfo.getBaseQty());
            devInWarehsInfo.setDevUnWriteOffQty(CalculateUtil.ZERO);
            devInWarehsInfo.setDevUnWriteOffBaseQty(CalculateUtil.ZERO);
        }
    }

    private void setMatReqWriteOffInfo(List devMatReqBillList, DevolveWriteOffResultInfo info) {
        DevolveMatReqBillInfo devMatReqInfo = null;
        boolean isManulWriteOff = info.getWriteOffStandard() == 1;
        for (int i = 0; i < devMatReqBillList.size(); ++i) {
            devMatReqInfo = (DevolveMatReqBillInfo)devMatReqBillList.get(i);
            if (isManulWriteOff) {
                devMatReqInfo.setDevWriteOffBaseQty(devMatReqInfo.getDevWriteOffBaseQty().add(devMatReqInfo.getHasWriteOffBaseQty()));
            } else {
                devMatReqInfo.setDevWriteOffBaseQty(devMatReqInfo.getDevWriteOffBaseQty().add(devMatReqInfo.getCurWriteOffBaseQty()));
            }
            devMatReqInfo.setDevUnWriteOffBaseQty(devMatReqInfo.getBaseQty().subtract(devMatReqInfo.getDevWriteOffBaseQty()));
            BigDecimal writeOffQty = devMatReqInfo.getDevWriteOffBaseQty().divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
            if (devMatReqInfo.getDevWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
                writeOffQty = devMatReqInfo.getQty();
            }
            devMatReqInfo.setDevWriteOffQty(writeOffQty);
            devMatReqInfo.setDevUnWriteOffQty(devMatReqInfo.getQty().subtract(writeOffQty));
            if (devMatReqInfo.getDevWriteOffAmount() == null) {
                devMatReqInfo.setDevWriteOffAmount(CalculateUtil.ZERO);
            }
            BigDecimal writeOffAmount = devMatReqInfo.getDevWriteOffAmount().add(devMatReqInfo.getCurrWriteOffTotalAmount());
            if (devMatReqInfo.getDevWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
                writeOffAmount = devMatReqInfo.getActualCost();
            }
            devMatReqInfo.setDevWriteOffAmount(writeOffAmount);
            devMatReqInfo.setCurrWriteOffTotalAmount(CalculateUtil.ZERO);
            devMatReqInfo.setCurWriteOffBaseQty(CalculateUtil.ZERO);
            devMatReqInfo.setDevUnWriteOffAmount(devMatReqInfo.getActualCost().subtract(writeOffAmount));
        }
    }

    private void setRedBlueMatReqBillWriteOffAmount(List devMatReqBillList) {
        DevolveMatReqBillInfo devMatReqInfo = null;
        for (int i = 0; i < devMatReqBillList.size(); ++i) {
            devMatReqInfo = (DevolveMatReqBillInfo)devMatReqBillList.get(i);
            BigDecimal baseUnitPrice = devMatReqInfo.getActualCost().divide(devMatReqInfo.getBaseQty(), 10, 4);
            BigDecimal writeOffAmount = devMatReqInfo.getCurWriteOffBaseQty().multiply(baseUnitPrice).setScale(devMatReqInfo.getPrecision(), 4);
            if (devMatReqInfo.getCurWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
                writeOffAmount = devMatReqInfo.getActualCost();
            }
            devMatReqInfo.setDevWriteOffBaseQty(devMatReqInfo.getDevWriteOffBaseQty().add(devMatReqInfo.getCurWriteOffBaseQty()));
            devMatReqInfo.setDevUnWriteOffBaseQty(devMatReqInfo.getBaseQty().subtract(devMatReqInfo.getDevWriteOffBaseQty()));
            BigDecimal writeOffQty = devMatReqInfo.getDevWriteOffBaseQty().divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
            if (devMatReqInfo.getDevWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
                writeOffQty = devMatReqInfo.getQty();
                writeOffAmount = devMatReqInfo.getActualCost().subtract(devMatReqInfo.getDevWriteOffAmount());
            }
            devMatReqInfo.setDevWriteOffQty(writeOffQty);
            devMatReqInfo.setDevUnWriteOffQty(devMatReqInfo.getQty().subtract(writeOffQty));
            devMatReqInfo.setCurrWriteOffTotalAmount(writeOffAmount);
            if (devMatReqInfo.getDevWriteOffAmount() == null) {
                devMatReqInfo.setDevWriteOffAmount(CalculateUtil.ZERO);
            }
            devMatReqInfo.setDevWriteOffAmount(devMatReqInfo.getDevWriteOffAmount().add(devMatReqInfo.getCurrWriteOffTotalAmount()));
            devMatReqInfo.setDevUnWriteOffAmount(devMatReqInfo.getActualCost().subtract(devMatReqInfo.getDevWriteOffAmount()));
        }
    }

    private void createRedAndBuleWriteOffRecord(Context ctx, List devMatReqList, DevolveWriteOffGroupInfo groupInfo) {
        HashMap<String, ArrayList> materialBill = new HashMap<String, ArrayList>();
        ArrayList billList = null;
        DevolveMatReqBillInfo devMatReqInfo = null;
        groupInfo.setCreateType(MatCostWriteOffTypeEnum.RedBlueWriteOff);
        for (int i = 0; i < devMatReqList.size(); ++i) {
            devMatReqInfo = (DevolveMatReqBillInfo)devMatReqList.get(i);
            billList = (ArrayList)materialBill.get(devMatReqInfo.getMaterialId());
            if (billList == null) {
                billList = new ArrayList();
            }
            billList.add(devMatReqInfo);
            materialBill.put(devMatReqInfo.getMaterialId(), billList);
        }
        DevolveWriteOffRecordInfo matReqRecordInfo = null;
        int groupIndex = 1;
        Iterator it = materialBill.keySet().iterator();
        while (it.hasNext()) {
            billList = (ArrayList)materialBill.get(it.next());
            for (int i = 0; i < billList.size(); ++i) {
                devMatReqInfo = (DevolveMatReqBillInfo)billList.get(i);
                matReqRecordInfo = this.createWrittenOffRecord(ctx, devMatReqInfo, groupInfo, groupIndex, i + 1);
                BigDecimal writeOffQty = devMatReqInfo.getCurWriteOffBaseQty().divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
                if (devMatReqInfo.getCurWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
                    writeOffQty = devMatReqInfo.getQty();
                }
                matReqRecordInfo.setCurrWriteOffQty(writeOffQty);
                matReqRecordInfo.setCurrWriteOffBaseQty(devMatReqInfo.getCurWriteOffBaseQty());
                matReqRecordInfo.setCurrWriteOffAmount(devMatReqInfo.getCurrWriteOffTotalAmount());
                matReqRecordInfo.setBillUnWriteOffBaseQty(devMatReqInfo.getDevUnWriteOffBaseQty());
            }
            ++groupIndex;
        }
    }

    private MatCostWriteOffTypeEnum getMatCostWriteOffType(int writeoffStandard) {
        switch (writeoffStandard) {
            case 1: {
                return MatCostWriteOffTypeEnum.ManualWriteOff;
            }
            case 2: {
                return MatCostWriteOffTypeEnum.SelfWriteOff;
            }
            case 3: {
                return MatCostWriteOffTypeEnum.OrderWriteOff;
            }
        }
        return null;
    }

    @Override
    protected boolean _inverseWriteOff(Context ctx, String[] ids) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return false;
        }
        String SEL_VOUCHER_BILL = "SELECT a.FBILLID, inBill.FVoucherId FROM T_CL_DevolveWriteOffRecord a INNER JOIN T_IM_PurInWarehsBill inBill on a.FBILLID = inBill.FID  WHERE FParentId in ({0}) AND inBill.FVoucherId IS NOT NULL ";
        String SEL_WRITEOFF_RECORD = "Select FBillID, FBillEntryId, FBillTypeNumber, sum(FCurrWriteOffBaseQty) as curWriteOffBaseQty, sum(FCurrWriteOffQty) as curWriteOffQty, sum(FCurrWriteOffAmount) as curWriteOffAmount, min(FBillUnWriteOffBaseQty) as billUnWriteOffBaseQty from T_CL_DevolveWriteOffRecord where FParentId in ({0}) group by FBillID, FBillEntryId, FBillTypeNumber";
        String UPDATE_INWAREHS_WRITEOFF_QTY_WITH_COST = "update T_IM_PurInWarehsEntry set FScUnWrittenOffBaseQty=FScUnWrittenOffBaseQty+?, FScUnWrittenOffQty=FScUnWrittenOffQty+?, FScWrittenOffBaseQty=FScWrittenOffBaseQty-?, FScWrittenOffQty=FScWrittenOffQty-?, FMaterialCost = 0,FUNITMATERIALCOST = 0 where FID = ?";
        String UPDATE_INWAREHS_WRITEOFF_QTY_WITHOUT_COST = "update T_IM_PurInWarehsEntry set FScUnWrittenOffBaseQty=FScUnWrittenOffBaseQty+?, FScUnWrittenOffQty=FScUnWrittenOffQty+?, FScWrittenOffBaseQty=FScWrittenOffBaseQty-?, FScWrittenOffQty=FScWrittenOffQty-? where FID = ?";
        String UPDATE_MATREQ_WRITEOFF_QTY = "update T_IM_MaterialReqBillEntry set FSubUnWriteOffBaseQty=FSubUnWriteOffBaseQty+?, FSubUnWriteOffQty=FSubUnWriteOffQty+?, FSubWrittenOffBaseQty=FSubWrittenOffBaseQty-?, FSubWrittenOffQty=FSubWrittenOffQty-?,FScWrittenOffAmount=FScWrittenOffAmount-?, FSCUnWrittenOffAmount=FSCUnWrittenOffAmount+? where FID = ?";
        String UPDATE_WORECORD_UNWRITEOFFQTY = "update T_CL_DevolveWriteOffRecord set FBillUnWriteOffBaseQty = ? where FBillUnWriteOffBaseQty = 0 and FBillEntryId = ?";
        String UPDATE_MATREQ_AMOUNTDIFF = "update T_IM_MaterialReqBillEntry set FScWrittenOffAmount = 0,FSCUnWrittenOffAmount = factualcost where FSubWrittenOffQty = 0 and fid = ?";
        String[] DELETE_WRITEOFF_RECORD = new String[]{"Delete from T_CL_DevolveWriteOffGroup where FID in ({0})", "Delete from T_CL_DevolveWriteOffRecord where FParentId in ({0})"};
        String CHECK_BEFORE_ADCOST_SQL = "select fid,fnumber from T_CL_CostAdjustBill where FID in (select entry.FParentID from T_CL_CostAdjustBillEntry as entry inner join T_IM_PurInWarehsEntry as inWarehs on entry.FSourceBillEntryId = inWarehs.FID where inWarehs.FID in ({0})) and FCreateType = {1} and FFivouchered = 1";
        String GET_DELETE_BEFORE_ADCOST_SQL = "select fid from T_CL_CostAdjustBill where FID in (select entry.FParentID from T_CL_CostAdjustBillEntry as entry inner join T_IM_PurInWarehsEntry as inWarehs on entry.FSourceBillEntryId = inWarehs.FID where inWarehs.FID in ({0})) and FCreateType = {1}";
        String updateActualCost = WriteOffHelp.getCalcPurActualCostSQL();
        StringBuffer idStr = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            idStr.append("'").append(ids[i]).append("'");
            if (i >= ids.length - 1) continue;
            idStr.append(",");
        }
        Connection conn = null;
        PreparedStatement inWarehsPMWithCost = null;
        PreparedStatement inWarehsPMActualCost = null;
        PreparedStatement inWarehsPMWithoutCost = null;
        PreparedStatement matReqPM = null;
        PreparedStatement updateRecordPM = null;
        PreparedStatement matReqDiff = null;
        String billType = null;
        String fid = null;
        BigDecimal curWriteOffBaseQty = null;
        BigDecimal curWriteOffQty = null;
        BigDecimal billUnWriteOffBaseQty = null;
        BigDecimal curWriteOffAmount = null;
        StringBuffer puridStr = new StringBuffer();
        IRowSet checkRS = null;
        IRowSet delRS = null;
        String selVoucherBillSql = MessageFormat.format("SELECT a.FBILLID, inBill.FVoucherId FROM T_CL_DevolveWriteOffRecord a INNER JOIN T_IM_PurInWarehsBill inBill on a.FBILLID = inBill.FID  WHERE FParentId in ({0}) AND inBill.FVoucherId IS NOT NULL ", idStr.toString());
        IRowSet selVoucherBillRs = DBUtil.executeQuery((Context)ctx, (String)selVoucherBillSql);
        HashSet<String> voucherIds = new HashSet<String>();
        String sSQL = MessageFormat.format("Select FBillID, FBillEntryId, FBillTypeNumber, sum(FCurrWriteOffBaseQty) as curWriteOffBaseQty, sum(FCurrWriteOffQty) as curWriteOffQty, sum(FCurrWriteOffAmount) as curWriteOffAmount, min(FBillUnWriteOffBaseQty) as billUnWriteOffBaseQty from T_CL_DevolveWriteOffRecord where FParentId in ({0}) group by FBillID, FBillEntryId, FBillTypeNumber", idStr.toString());
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        try {
            while (selVoucherBillRs.next()) {
                voucherIds.add(selVoucherBillRs.getString("FBillID"));
            }
            while (rowSet.next()) {
                billType = rowSet.getString("FBillTypeNumber");
                fid = rowSet.getString("FBillEntryId");
                if (!"103".equals(billType)) continue;
                if (puridStr.length() > 0) {
                    puridStr.append(",");
                }
                puridStr.append("'").append(fid).append("'");
            }
            if (puridStr.length() > 0) {
                ICostAdjustBill costadjust = CostAdjustBillFactory.getLocalInstance(ctx);
                sSQL = MessageFormat.format("select fid,fnumber from T_CL_CostAdjustBill where FID in (select entry.FParentID from T_CL_CostAdjustBillEntry as entry inner join T_IM_PurInWarehsEntry as inWarehs on entry.FSourceBillEntryId = inWarehs.FID where inWarehs.FID in ({0})) and FCreateType = {1} and FFivouchered = 1", puridStr, String.valueOf(8));
                checkRS = DBUtil.executeQuery((Context)ctx, (String)sSQL);
                StringBuffer voucheredNumber = new StringBuffer();
                while (checkRS.next()) {
                    if (voucheredNumber.length() > 0) {
                        voucheredNumber.append(",");
                    }
                    voucheredNumber.append(checkRS.getString("fnumber"));
                }
                if (voucheredNumber.length() > 0) {
                    throw new CalculateException(CalculateException.COST_IS_VOUCHERED, new String[]{voucheredNumber.toString()});
                }
                sSQL = MessageFormat.format("select fid from T_CL_CostAdjustBill where FID in (select entry.FParentID from T_CL_CostAdjustBillEntry as entry inner join T_IM_PurInWarehsEntry as inWarehs on entry.FSourceBillEntryId = inWarehs.FID where inWarehs.FID in ({0})) and FCreateType = {1}", puridStr, String.valueOf(8));
                delRS = DBUtil.executeQuery((Context)ctx, (String)sSQL);
                ObjectUuidPK costID = null;
                while (delRS.next()) {
                    costID = new ObjectUuidPK(delRS.getString("fid"));
                    costadjust.unAudit((IObjectPK)costID);
                    costadjust.delete((IObjectPK)costID);
                }
            }
            rowSet.beforeFirst();
            conn = EJBFactory.getConnection((Context)ctx);
            inWarehsPMWithCost = conn.prepareStatement("update T_IM_PurInWarehsEntry set FScUnWrittenOffBaseQty=FScUnWrittenOffBaseQty+?, FScUnWrittenOffQty=FScUnWrittenOffQty+?, FScWrittenOffBaseQty=FScWrittenOffBaseQty-?, FScWrittenOffQty=FScWrittenOffQty-?, FMaterialCost = 0,FUNITMATERIALCOST = 0 where FID = ?");
            inWarehsPMActualCost = conn.prepareStatement(updateActualCost);
            inWarehsPMWithoutCost = conn.prepareStatement("update T_IM_PurInWarehsEntry set FScUnWrittenOffBaseQty=FScUnWrittenOffBaseQty+?, FScUnWrittenOffQty=FScUnWrittenOffQty+?, FScWrittenOffBaseQty=FScWrittenOffBaseQty-?, FScWrittenOffQty=FScWrittenOffQty-? where FID = ?");
            matReqPM = conn.prepareStatement("update T_IM_MaterialReqBillEntry set FSubUnWriteOffBaseQty=FSubUnWriteOffBaseQty+?, FSubUnWriteOffQty=FSubUnWriteOffQty+?, FSubWrittenOffBaseQty=FSubWrittenOffBaseQty-?, FSubWrittenOffQty=FSubWrittenOffQty-?,FScWrittenOffAmount=FScWrittenOffAmount-?, FSCUnWrittenOffAmount=FSCUnWrittenOffAmount+? where FID = ?");
            updateRecordPM = conn.prepareStatement("update T_CL_DevolveWriteOffRecord set FBillUnWriteOffBaseQty = ? where FBillUnWriteOffBaseQty = 0 and FBillEntryId = ?");
            matReqDiff = conn.prepareStatement("update T_IM_MaterialReqBillEntry set FScWrittenOffAmount = 0,FSCUnWrittenOffAmount = factualcost where FSubWrittenOffQty = 0 and fid = ?");
            while (rowSet.next()) {
                billType = rowSet.getString("FBillTypeNumber");
                fid = rowSet.getString("FBillEntryId");
                curWriteOffBaseQty = rowSet.getBigDecimal("curWriteOffBaseQty");
                curWriteOffQty = rowSet.getBigDecimal("curWriteOffQty");
                billUnWriteOffBaseQty = rowSet.getBigDecimal("billUnWriteOffBaseQty");
                curWriteOffAmount = rowSet.getBigDecimal("curWriteOffAmount");
                if (billType.equals("103")) {
                    if (voucherIds.contains(rowSet.getString("FBillID"))) {
                        inWarehsPMWithoutCost.setBigDecimal(1, curWriteOffBaseQty);
                        inWarehsPMWithoutCost.setBigDecimal(2, curWriteOffQty);
                        inWarehsPMWithoutCost.setBigDecimal(3, curWriteOffBaseQty);
                        inWarehsPMWithoutCost.setBigDecimal(4, curWriteOffQty);
                        inWarehsPMWithoutCost.setString(5, fid);
                        inWarehsPMWithoutCost.addBatch();
                        continue;
                    }
                    inWarehsPMActualCost.setString(1, fid);
                    inWarehsPMActualCost.setString(2, fid);
                    inWarehsPMActualCost.addBatch();
                    inWarehsPMWithCost.setBigDecimal(1, curWriteOffBaseQty);
                    inWarehsPMWithCost.setBigDecimal(2, curWriteOffQty);
                    inWarehsPMWithCost.setBigDecimal(3, curWriteOffBaseQty);
                    inWarehsPMWithCost.setBigDecimal(4, curWriteOffQty);
                    inWarehsPMWithCost.setString(5, fid);
                    inWarehsPMWithCost.addBatch();
                    continue;
                }
                if (!billType.equals("104")) continue;
                matReqPM.setBigDecimal(1, curWriteOffBaseQty);
                matReqPM.setBigDecimal(2, curWriteOffQty);
                matReqPM.setBigDecimal(3, curWriteOffBaseQty);
                matReqPM.setBigDecimal(4, curWriteOffQty);
                matReqPM.setBigDecimal(5, curWriteOffAmount);
                matReqPM.setBigDecimal(6, curWriteOffAmount);
                matReqPM.setString(7, fid);
                matReqPM.addBatch();
                matReqDiff.setString(1, fid);
                matReqDiff.addBatch();
                if (billUnWriteOffBaseQty.compareTo(CalculateUtil.ZERO) == 0) continue;
                updateRecordPM.setBigDecimal(1, curWriteOffBaseQty);
                updateRecordPM.setString(2, fid);
                updateRecordPM.addBatch();
            }
            inWarehsPMWithCost.executeBatch();
            inWarehsPMWithoutCost.executeBatch();
            inWarehsPMActualCost.executeBatch();
            matReqPM.executeBatch();
            updateRecordPM.executeBatch();
            matReqDiff.executeBatch();
            String[] delSQL = new String[]{MessageFormat.format(DELETE_WRITEOFF_RECORD[0], idStr.toString()), MessageFormat.format(DELETE_WRITEOFF_RECORD[1], idStr.toString())};
            DBUtil.execute(ctx, delSQL);
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(checkRS);
                SQLUtils.cleanup(delRS);
                DBUtil.close(conn, new PreparedStatement[]{inWarehsPMWithCost, inWarehsPMWithoutCost, matReqPM, updateRecordPM, inWarehsPMActualCost}, new ResultSet[]{rowSet});
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)checkRS);
        SQLUtils.cleanup((ResultSet)delRS);
        DBUtil.close(conn, new PreparedStatement[]{inWarehsPMWithCost, inWarehsPMWithoutCost, matReqPM, updateRecordPM, inWarehsPMActualCost}, new ResultSet[]{rowSet});
        return true;
    }

    @Override
    protected RptTableHeader _builderRptTableHeaderForDevolve(Context ctx, String[][] fields, String[] hiddenFields) throws BOSException {
        return ManualWriteOffHelp.builderRptTableHeaderForDevolve(ctx, fields, hiddenFields);
    }

    public IRowSet getMaterialRowSet(Context ctx, CompanyOrgUnitInfo cou, PeriodInfo periodInfo) throws BOSException {
        String sSQL = "select distinct temp.FCOMPANYORGUNITID, temp.FMATERIALID,record.FMATERIALID from T_CL_DevolveWriteOffRecord record inner join (  select bill.FCOMPANYORGUNITID as FCOMPANYORGUNITID ,entry.FMATERIALID as FMATERIALID ,entry.FPARENTID as FPARENTID,entry.FGROUPNO as FGROUPNO  from T_CL_DevolveWriteOffRecord entry  inner join  T_CL_DevolveWriteOffGroup bill on entry.fparentid =  bill.fid  where bill.FCOMPANYORGUNITID = '" + cou.getId().toString() + "' and  bill.FWRITEOFFYEAR = " + periodInfo.getPeriodYear() + " and bill.FWRITEOFFPERIOD =  " + periodInfo.getPeriodNumber() + " and entry.FBillTypeNumber = '" + "103" + "' ) temp on record.FCOMPANYORGUNITID = temp.FCOMPANYORGUNITID  and record.FPARENTID = temp.FPARENTID and record.FGROUPNO = temp.FGROUPNO and record.FBillTypeNumber <> '" + "103" + "' order by temp.FCOMPANYORGUNITID, temp.FMATERIALID,record.FMATERIALID ";
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        return rowSet;
    }

    @Override
    protected List _checkMatQty(Context ctx, DevolveWriteOffResultInfo info) throws BOSException, EASBizException {
        List<HashMap<String, String>> resultInfo = new ArrayList();
        this.companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnitID()));
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyOrgUnitInfo);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        List devInWarehsList = info.getDevInWarehsList();
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        StringBuffer billNumbers = new StringBuffer();
        if (2 != info.getWriteOffStandard()) {
            int size = devInWarehsList.size();
            for (int i = 0; i < size; ++i) {
                devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsList.get(i);
                if (!devInWarehsInfo.getBizDate().before(this.currPeriod.getBeginDate())) continue;
                billNumbers.append(devInWarehsInfo.getNumber());
                billNumbers.append(",");
            }
        }
        if (billNumbers.length() > 0) {
            resultMap.put("periodBeforeBills", billNumbers.substring(0, billNumbers.length() - 1));
            resultInfo.add(resultMap);
            return resultInfo;
        }
        if (info.getWriteOffStandard() == 3) {
            resultInfo = this.orderCheck(ctx, info);
        }
        return resultInfo;
    }

    private Map getCoreInWarehsMap(List devInWarehsList) {
        HashMap<String, ArrayList<DevolveInWarehsBillInfo>> coreInWarehsMap = new HashMap<String, ArrayList<DevolveInWarehsBillInfo>>();
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        ArrayList<DevolveInWarehsBillInfo> coreInWarehsList = null;
        for (int i = 0; i < devInWarehsList.size(); ++i) {
            devInWarehsInfo = (DevolveInWarehsBillInfo)devInWarehsList.get(i);
            String coreBillEntryId = devInWarehsInfo.getCoreBillEntryId();
            coreInWarehsList = (ArrayList<DevolveInWarehsBillInfo>)coreInWarehsMap.get(coreBillEntryId);
            if (coreInWarehsList == null) {
                coreInWarehsList = new ArrayList<DevolveInWarehsBillInfo>();
                coreInWarehsList.add(devInWarehsInfo);
                coreInWarehsMap.put(coreBillEntryId, coreInWarehsList);
                continue;
            }
            coreInWarehsList.add(devInWarehsInfo);
        }
        return coreInWarehsMap;
    }

    private void createMatReqBillWriteOffRecord(Context ctx, DevolveMatReqBillInfo matReqBillInfo, DevolveWriteOffGroupInfo groupInfo, int groupNo, int seq) {
        BigDecimal curWriteOffQty = matReqBillInfo.getCurWriteOffBaseQty().divide(matReqBillInfo.getBaseConvsRate(), matReqBillInfo.getQtyPrecision(), 4);
        BigDecimal baseUnitPrice = matReqBillInfo.getActualCost().divide(matReqBillInfo.getBaseQty(), 10, 4);
        BigDecimal writeOffAmount = matReqBillInfo.getCurWriteOffBaseQty().multiply(baseUnitPrice).setScale(matReqBillInfo.getPrecision(), 4);
        if (matReqBillInfo.getCurWriteOffBaseQty().compareTo(matReqBillInfo.getDevUnWriteOffBaseQty()) == 0) {
            writeOffAmount = matReqBillInfo.getActualCost().subtract(matReqBillInfo.getDevWriteOffAmount());
            curWriteOffQty = matReqBillInfo.getQty().subtract(matReqBillInfo.getDevWriteOffQty());
        }
        DevolveWriteOffRecordInfo matReqRecordInfo = this.createWrittenOffRecord(ctx, matReqBillInfo, groupInfo, groupNo, seq);
        matReqRecordInfo.setCurrWriteOffQty(curWriteOffQty);
        matReqRecordInfo.setCurrWriteOffBaseQty(matReqBillInfo.getCurWriteOffBaseQty());
        matReqRecordInfo.setCurrWriteOffAmount(writeOffAmount);
        matReqRecordInfo.setBillUnWriteOffBaseQty(matReqBillInfo.getDevUnWriteOffBaseQty().subtract(matReqBillInfo.getCurWriteOffBaseQty()));
    }

    private void devolveMatReqBill(DevolveMatReqBillInfo devMatReqInfo, BigDecimal curWriteOffBaseQty) {
        devMatReqInfo.setCurWriteOffBaseQty(curWriteOffBaseQty);
        devMatReqInfo.setDevWriteOffBaseQty(devMatReqInfo.getDevWriteOffBaseQty().add(devMatReqInfo.getCurWriteOffBaseQty()));
        devMatReqInfo.setDevUnWriteOffBaseQty(devMatReqInfo.getBaseQty().subtract(devMatReqInfo.getDevWriteOffBaseQty()));
        BigDecimal writeOffQty = devMatReqInfo.getDevWriteOffBaseQty().divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
        if (devMatReqInfo.getDevWriteOffBaseQty().compareTo(devMatReqInfo.getBaseQty()) == 0) {
            writeOffQty = devMatReqInfo.getQty();
        }
        devMatReqInfo.setDevWriteOffQty(writeOffQty);
        devMatReqInfo.setDevUnWriteOffQty(devMatReqInfo.getQty().subtract(writeOffQty));
        if (devMatReqInfo.getDevWriteOffAmount() == null) {
            devMatReqInfo.setDevWriteOffAmount(CalculateUtil.ZERO);
        }
        if (devMatReqInfo.getCurrWriteOffTotalAmount() == null) {
            devMatReqInfo.setCurrWriteOffTotalAmount(CalculateUtil.ZERO);
        }
        BigDecimal baseUnitPrice = devMatReqInfo.getActualCost().divide(devMatReqInfo.getBaseQty(), 10, 4);
        BigDecimal curWriteOffAmount = devMatReqInfo.getCurWriteOffBaseQty().multiply(baseUnitPrice).setScale(devMatReqInfo.getPrecision(), 4);
        BigDecimal curWriteOffQty = devMatReqInfo.getCurWriteOffBaseQty().divide(devMatReqInfo.getBaseConvsRate(), devMatReqInfo.getQtyPrecision(), 4);
        if (devMatReqInfo.getCurWriteOffBaseQty().compareTo(devMatReqInfo.getDevUnWriteOffBaseQty()) == 0) {
            curWriteOffAmount = devMatReqInfo.getActualCost().subtract(devMatReqInfo.getDevWriteOffAmount());
            curWriteOffQty = devMatReqInfo.getQty().subtract(devMatReqInfo.getDevWriteOffQty());
        }
        devMatReqInfo.setCurrWriteOffTotalQty(curWriteOffQty);
        devMatReqInfo.setCurrWriteOffTotalAmount(devMatReqInfo.getCurrWriteOffTotalAmount().add(curWriteOffAmount));
        devMatReqInfo.setDevWriteOffAmount(devMatReqInfo.getDevWriteOffAmount().add(devMatReqInfo.getCurrWriteOffTotalAmount()));
        devMatReqInfo.setDevUnWriteOffAmount(devMatReqInfo.getActualCost().subtract(devMatReqInfo.getDevWriteOffAmount()));
    }

    private void devolvePurInWarehsBill(DevolveInWarehsBillInfo info, BigDecimal curWriteOffBaseQty, BigDecimal totalWriteOffAmount) {
        info.setCurWriteOffBaseQty(curWriteOffBaseQty);
        info.setDevWriteOffBaseQty(info.getDevWriteOffBaseQty().add(info.getCurWriteOffBaseQty()));
        info.setDevUnWriteOffBaseQty(info.getBaseQty().subtract(info.getDevWriteOffBaseQty()));
        BigDecimal writeOffQty = info.getDevWriteOffBaseQty().divide(info.getBaseConvsRate(), info.getQtyPrecision(), 4);
        if (info.getDevWriteOffBaseQty().compareTo(info.getBaseQty()) == 0) {
            writeOffQty = info.getQty();
        }
        info.setDevWriteOffQty(writeOffQty);
        info.setDevUnWriteOffQty(info.getQty().subtract(writeOffQty));
        if (this.isNeedWriteBack(info)) {
            BigDecimal materialCost = totalWriteOffAmount.divide(info.getCurWriteOffBaseQty(), 10, 4).multiply(info.getBaseQty()).setScale(info.getPrecision(), 4);
            info.setMaterialCost(materialCost);
            BigDecimal unitCost = materialCost.divide(info.getQty(), info.getPricePrecision(), 4);
            info.setUnitMaterialCost(unitCost);
        }
        info.setCurrWriteOffTotalAmount(totalWriteOffAmount);
    }

    private void createPurInWarehsWriteOffRecord(Context ctx, DevolveInWarehsBillInfo devInWarehsInfo, DevolveWriteOffGroupInfo groupInfo, BigDecimal totalWriteOffAmount, int groupNo, int seq) {
        DevolveWriteOffRecordInfo inWarehsRecordInfo = this.createWrittenOffRecord(ctx, devInWarehsInfo, groupInfo, groupNo, 1);
        BigDecimal curWriteOffQty = devInWarehsInfo.getCurWriteOffBaseQty().divide(devInWarehsInfo.getBaseConvsRate(), devInWarehsInfo.getQtyPrecision(), 4);
        if (devInWarehsInfo.getCurWriteOffBaseQty().compareTo(devInWarehsInfo.getBaseQty()) == 0) {
            curWriteOffQty = devInWarehsInfo.getQty();
        }
        inWarehsRecordInfo.setCurrWriteOffQty(curWriteOffQty);
        inWarehsRecordInfo.setCurrWriteOffBaseQty(devInWarehsInfo.getCurWriteOffBaseQty());
        inWarehsRecordInfo.setCurrWriteOffAmount(totalWriteOffAmount);
        inWarehsRecordInfo.setBillUnWriteOffBaseQty(CalculateUtil.ZERO);
    }

    public void coreInWarehsListSort(List<DevolveInWarehsBillInfo> coreInWarehsList) {
        Collections.sort(coreInWarehsList, new Comparator<DevolveInWarehsBillInfo>(){

            @Override
            public int compare(DevolveInWarehsBillInfo one, DevolveInWarehsBillInfo two) {
                Timestamp oneBizDate = one.getBizDate();
                Timestamp twoBizDate = two.getBizDate();
                if (oneBizDate.getTime() - twoBizDate.getTime() > 0L) {
                    return 1;
                }
                if (oneBizDate.getTime() - twoBizDate.getTime() < 0L) {
                    return -1;
                }
                Timestamp oneAuditTime = one.getAuditTime();
                Timestamp twoAuditTime = two.getAuditTime();
                if (oneAuditTime == null || twoAuditTime == null) {
                    return 0;
                }
                if (oneAuditTime.getTime() - twoAuditTime.getTime() > 0L) {
                    return 1;
                }
                if (oneAuditTime.getTime() - twoAuditTime.getTime() < 0L) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private List orderCheck(Context ctx, DevolveWriteOffResultInfo info) throws BOSException, EASBizException {
        ArrayList resultInfo = new ArrayList();
        List devInWarehsList = info.getDevInWarehsList();
        DevolveInWarehsBillInfo devInWarehsInfo = null;
        DevolveMatReqBillInfo devMatReqInfo = null;
        SubContractOrderEntryInfo entry = null;
        SubMaterialListCollection subMaterialListColl = null;
        SubMaterialListInfo materialListInfo = null;
        HashMap<String, BigDecimal> matEntryId2QtyRateMap = new HashMap<String, BigDecimal>();
        HashSet<String> subMaterialListIdSet = new HashSet<String>();
        HashMap<String, BigDecimal> matEntryId2loseRateMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> matListUnWriteOffMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> matEntryId2BaseQtyMap = new HashMap<String, BigDecimal>();
        HashMap globalMaterialMap = new HashMap();
        ArrayList<String> devErrInwareNum = new ArrayList<String>();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        Map productEntryId2DevInBillsMap = this.getCoreInWarehsMap(devInWarehsList);
        List coreInWarehsList = null;
        for (String subContractOrderEntryId : productEntryId2DevInBillsMap.keySet()) {
            if (subContractOrderEntryId == null || "".equals(subContractOrderEntryId) || !BOSUuid.read((String)subContractOrderEntryId).getType().equals((Object)new SubContractOrderEntryInfo().getBOSType())) continue;
            this.purInWarehsSelfWriteOffCheck(ctx, subContractOrderEntryId, productEntryId2DevInBillsMap);
            entry = (SubContractOrderEntryInfo)SubContractOrderEntryFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(subContractOrderEntryId));
            subMaterialListColl = entry.getEntries1();
            coreInWarehsList = (List)productEntryId2DevInBillsMap.get(subContractOrderEntryId);
            if (subMaterialListColl == null || subMaterialListColl.size() == 0) {
                for (int i = 0; i < coreInWarehsList.size(); ++i) {
                    devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i);
                    devErrInwareNum.add(devInWarehsInfo.getNumber());
                }
                continue;
            }
            subMaterialListIdSet.clear();
            matEntryId2QtyRateMap.clear();
            matEntryId2loseRateMap.clear();
            globalMaterialMap.clear();
            matEntryId2BaseQtyMap.clear();
            matListUnWriteOffMap.clear();
            for (int j = 0; j < subMaterialListColl.size(); ++j) {
                materialListInfo = subMaterialListColl.get(j);
                subMaterialListIdSet.add(materialListInfo.getId().toString());
                matEntryId2QtyRateMap.put(materialListInfo.getId().toString(), materialListInfo.getBaseQtyRate());
                matEntryId2BaseQtyMap.put(materialListInfo.getId().toString(), materialListInfo.getBaseQty());
                matEntryId2loseRateMap.put(materialListInfo.getId().toString(), materialListInfo.getLossRate());
            }
            IRowSet rowSet = this.getMatReqEntryByOrder(ctx, subMaterialListIdSet, false);
            Map matEntryId2DevMatBillsMap = this.getDevolveMatReqBillInfoColl(rowSet, globalMaterialMap, matListUnWriteOffMap);
            if (matEntryId2DevMatBillsMap.size() < subMaterialListIdSet.size()) {
                block3: for (int i = 0; i < coreInWarehsList.size(); ++i) {
                    devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i);
                    for (Object e : subMaterialListIdSet) {
                        String keyStr = e.toString();
                        if ((matEntryId2DevMatBillsMap.get(keyStr) == null && ((BigDecimal)matEntryId2BaseQtyMap.get(keyStr)).compareTo(BigDecimal.ZERO) == 0 || ((BigDecimal)matListUnWriteOffMap.get(keyStr)).compareTo(BigDecimal.ZERO) == 0) && info.isFullWriteOff()) continue;
                        devErrInwareNum.add(devInWarehsInfo.getNumber());
                        continue block3;
                    }
                }
                if (devErrInwareNum.size() > 0) continue;
            }
            boolean isFullWriteOff = false;
            BigDecimal devUnWriteOffBaseQty = CalculateUtil.ZERO;
            for (int i = 0; i < coreInWarehsList.size(); ++i) {
                devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i);
                if (devInWarehsInfo.getDevUnWriteOffBaseQty() == null) continue;
                devUnWriteOffBaseQty = devUnWriteOffBaseQty.add(devInWarehsInfo.getDevUnWriteOffBaseQty());
            }
            for (String string : matEntryId2DevMatBillsMap.keySet()) {
                int i;
                BigDecimal baseQtyRate = (BigDecimal)matEntryId2QtyRateMap.get(string);
                if (baseQtyRate == null) {
                    baseQtyRate = new BigDecimal("1.0000");
                }
                int basePrecision = (Integer)this.materialBaseQtyPrecision.get(string);
                BigDecimal loseRate = (BigDecimal)matEntryId2loseRateMap.get(string);
                isFullWriteOff = info.isFullWriteOff();
                List matReqBillList = (List)matEntryId2DevMatBillsMap.get(string);
                this.matReqSelfWriteOffCheck(matReqBillList);
                BigDecimal curMatWriteOffTotalNeedBaseQty = devUnWriteOffBaseQty.multiply(baseQtyRate).multiply(BigDecimal.ONE.add(loseRate.divide(new BigDecimal(100)))).setScale(basePrecision, 4);
                if (devUnWriteOffBaseQty.compareTo(entry.getBaseQty()) == 0 && matEntryId2BaseQtyMap.get(string) != null) {
                    curMatWriteOffTotalNeedBaseQty = (BigDecimal)matEntryId2BaseQtyMap.get(string);
                }
                BigDecimal curMatTotalUnWriteOffBaseQty = curMatWriteOffTotalNeedBaseQty;
                BigDecimal matReqTotalWriteOffBaseQty = BigDecimal.ZERO;
                for (int j = 0; j < matReqBillList.size(); ++j) {
                    devMatReqInfo = (DevolveMatReqBillInfo)matReqBillList.get(j);
                    if (devMatReqInfo.getDevUnWriteOffBaseQty().compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (isFullWriteOff) {
                        matReqTotalWriteOffBaseQty = matReqTotalWriteOffBaseQty.add(devMatReqInfo.getDevUnWriteOffBaseQty());
                        devMatReqInfo.setCurWriteOffBaseQty(devMatReqInfo.getDevUnWriteOffBaseQty());
                        this.devolveMatReqBill(devMatReqInfo, devMatReqInfo.getCurWriteOffBaseQty());
                        continue;
                    }
                    if (curMatTotalUnWriteOffBaseQty.compareTo(devMatReqInfo.getDevUnWriteOffBaseQty()) > 0) {
                        devMatReqInfo.setCurWriteOffBaseQty(devMatReqInfo.getDevUnWriteOffBaseQty());
                        curMatTotalUnWriteOffBaseQty = curMatTotalUnWriteOffBaseQty.subtract(devMatReqInfo.getDevUnWriteOffBaseQty());
                    } else {
                        devMatReqInfo.setCurWriteOffBaseQty(curMatTotalUnWriteOffBaseQty);
                        curMatTotalUnWriteOffBaseQty = CalculateUtil.ZERO;
                    }
                    this.devolveMatReqBill(devMatReqInfo, devMatReqInfo.getCurWriteOffBaseQty());
                    if (curMatTotalUnWriteOffBaseQty.compareTo(CalculateUtil.ZERO) == 0) break;
                }
                if (isFullWriteOff) {
                    if (curMatTotalUnWriteOffBaseQty.compareTo(matReqTotalWriteOffBaseQty) == 0) continue;
                    resultMap = new HashMap();
                    BigDecimal unWriteRate = curMatTotalUnWriteOffBaseQty.subtract(matReqTotalWriteOffBaseQty).divide(curMatWriteOffTotalNeedBaseQty, 4, 4).multiply(new BigDecimal(100));
                    resultMap.put("coreBillNumber", devInWarehsInfo.getCoreBillNumber());
                    resultMap.put("coreBillEntrySeq", devInWarehsInfo.getCoreBillEntrySeq());
                    resultMap.put("coreMatEntrySeq", devMatReqInfo.getCoreBillEntrySeq());
                    resultMap.put("materialNumber", devMatReqInfo.getMaterialNumber());
                    resultMap.put("materialName", devMatReqInfo.getMaterialName());
                    resultMap.put("unWriteRate", unWriteRate);
                    if (matReqTotalWriteOffBaseQty.compareTo(BigDecimal.ZERO) == 0) {
                        for (i = 0; i < coreInWarehsList.size(); ++i) {
                            devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i);
                            devErrInwareNum.add(devInWarehsInfo.getNumber());
                        }
                    }
                    resultInfo.add(resultMap);
                    continue;
                }
                if (curMatTotalUnWriteOffBaseQty.compareTo(CalculateUtil.ZERO) == 0) continue;
                resultMap = new HashMap();
                BigDecimal unWriteRate = curMatTotalUnWriteOffBaseQty.divide(curMatWriteOffTotalNeedBaseQty, 4, 4).multiply(new BigDecimal(100));
                resultMap.put("coreBillNumber", devInWarehsInfo.getCoreBillNumber());
                resultMap.put("coreBillEntrySeq", devInWarehsInfo.getCoreBillEntrySeq());
                resultMap.put("coreMatEntrySeq", devMatReqInfo.getCoreBillEntrySeq());
                resultMap.put("materialNumber", devMatReqInfo.getMaterialNumber());
                resultMap.put("materialName", devMatReqInfo.getMaterialName());
                resultMap.put("unWriteRate", unWriteRate);
                if (curMatTotalUnWriteOffBaseQty.compareTo(curMatWriteOffTotalNeedBaseQty) == 0) {
                    for (i = 0; i < coreInWarehsList.size(); ++i) {
                        devInWarehsInfo = (DevolveInWarehsBillInfo)coreInWarehsList.get(i);
                        devErrInwareNum.add(devInWarehsInfo.getNumber());
                    }
                }
                resultInfo.add(resultMap);
            }
        }
        if (devErrInwareNum != null && devErrInwareNum.size() > 0 && resultInfo != null) {
            HashSet<String> numSet = new HashSet<String>();
            numSet.addAll(devErrInwareNum);
            devErrInwareNum.clear();
            devErrInwareNum.addAll(numSet);
            if (resultInfo.size() > 0 && resultInfo.get(0) != null) {
                ((HashMap)resultInfo.get(0)).put("devErrInwareNum", this.getErrDevInWarehsNums(devErrInwareNum));
            } else {
                resultMap = new HashMap();
                resultMap.put("devErrInwareNum", this.getErrDevInWarehsNums(devErrInwareNum));
                resultInfo.add(resultMap);
            }
        }
        return resultInfo;
    }

    @Override
    protected ReturnInfo _reWriteWriteoffAmount(Context ctx, Map params) throws BOSException, EASBizException {
        String companyOrgUnit = (String)params.get("companyId");
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnit));
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        ReturnInfo returnInfo = new ReturnInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT a.fid as fid FROM T_IM_MATERIALREQBILLENTRY a   ");
        sql.append(" \n inner join T_CL_DEVOLVEWRITEOFFRECORD b on  a.fid = b.FBILLENTRYID");
        sql.append(" \n inner join T_IM_MATERIALREQBILL c on a.fparentid = c.fid");
        sql.append(" \n where a.FCOMPANYORGUNITID = '").append(companyOrgUnit).append("'");
        sql.append(" \n and c.fyear = ").append(curPeriod.getPeriodYear());
        sql.append(" \n and c.fperiod = ").append(curPeriod.getPeriodNumber());
        sql.append(" \n group by a.fid ");
        sql.append(" \n having max(a.FSCWRITTENOFFAMOUNT) <> sum(b.FCURRWRITEOFFAMOUNT)");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> entryIdList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                entryIdList.add(rowSet.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (entryIdList != null && entryIdList.size() > 0) {
            WriteOffHelp.updDevWritRecordOnMatreqCostChange(ctx, entryIdList);
            returnInfo.setSuccess(true);
        } else {
            returnInfo.setSuccess(false);
        }
        return returnInfo;
    }

    @Override
    protected int _getMaxSelectedNum(Context ctx) throws BOSException {
        int manualWriteOffMaxSelectedNum = 0;
        String sql = "select fvalue from t_dt_dttempparam where fkey = 'manualWriteOffMaxSelectedNum'";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                manualWriteOffMaxSelectedNum = rs.getInt("fvalue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return manualWriteOffMaxSelectedNum;
    }

    private void putDevBillMap(Context ctx, HashMap devInWarehsMap, DevolveInWarehsBillInfo devInWarehsInfo) throws BOSException {
        HashMap<String, DevolveInWarehsBillInfo> devInWarehsEntryMap = (HashMap<String, DevolveInWarehsBillInfo>)devInWarehsMap.get(devInWarehsInfo.getCoreBillEntryId());
        DevolveInWarehsBillInfo bill = null;
        if (devInWarehsEntryMap == null) {
            try {
                devInWarehsEntryMap = new HashMap<String, DevolveInWarehsBillInfo>();
                HashSet<String> coreIdSet = new HashSet<String>();
                coreIdSet.add(devInWarehsInfo.getCoreBillEntryId());
                IRowSet rowSet = this.getPurInwarehsEntryByOrder(ctx, coreIdSet, false);
                while (rowSet.next()) {
                    bill = this.buildDevolveInWarehsBillInfo(rowSet);
                    devInWarehsEntryMap.put(bill.getEntryId(), bill);
                }
                devInWarehsMap.put(devInWarehsInfo.getCoreBillEntryId(), devInWarehsEntryMap);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void putMatReqBillMap(Context ctx, HashMap matReqMap, DevolveMatReqBillInfo devMatReqInfo) throws BOSException {
        DevolveMatReqBillInfo bill = null;
        HashMap<String, DevolveMatReqBillInfo> matReqBillMap = (HashMap<String, DevolveMatReqBillInfo>)matReqMap.get(devMatReqInfo.getCoreBillEntryId());
        if (matReqBillMap == null) {
            try {
                matReqBillMap = new HashMap<String, DevolveMatReqBillInfo>();
                HashSet<String> coreIdSet = new HashSet<String>();
                coreIdSet.add(devMatReqInfo.getCoreBillEntryId());
                IRowSet rowSet = this.getMatReqEntryByOrder(ctx, coreIdSet, false);
                while (rowSet.next()) {
                    bill = this.buildDevolveMatReqInfo(rowSet);
                    matReqBillMap.put(bill.getEntryId(), bill);
                }
                matReqMap.put(devMatReqInfo.getCoreBillEntryId(), matReqBillMap);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void updateDevInWarehsMap(DevolveInWarehsBillInfo devInWarehsInfo, HashMap devInWarehsMap) {
        HashMap devInWarehsEntryMap = (HashMap)devInWarehsMap.get(devInWarehsInfo.getCoreBillEntryId());
        DevolveInWarehsBillInfo bill = null;
        bill = (DevolveInWarehsBillInfo)devInWarehsEntryMap.get(devInWarehsInfo.getEntryId());
        bill.setDevWriteOffQty(devInWarehsInfo.getDevWriteOffQty());
        bill.setDevWriteOffBaseQty(devInWarehsInfo.getDevWriteOffBaseQty());
        bill.setDevUnWriteOffQty(devInWarehsInfo.getDevUnWriteOffQty());
        bill.setDevUnWriteOffBaseQty(devInWarehsInfo.getDevUnWriteOffBaseQty());
    }

    private void updateMatReqMap(HashMap matReqMap, DevolveMatReqBillInfo devMatReqInfo) {
        HashMap matReqEntryMap = (HashMap)matReqMap.get(devMatReqInfo.getCoreBillEntryId());
        DevolveMatReqBillInfo bill = null;
        bill = (DevolveMatReqBillInfo)matReqEntryMap.get(devMatReqInfo.getEntryId());
        bill.setDevWriteOffBaseQty(bill.getDevWriteOffBaseQty().add(devMatReqInfo.getCurWriteOffBaseQty()));
        bill.setDevUnWriteOffBaseQty(bill.getDevUnWriteOffBaseQty().subtract(bill.getDevWriteOffBaseQty()));
    }

    private BigDecimal doWriteOffDiff(DevolveInWarehsBillInfo devInWarehsInfo, DevolveMatReqBillInfo devMatReqInfo, SubContractOrderEntryInfo entry, HashMap devInWarehsMap, HashMap matReqMap, BigDecimal baseQtyRate, int basePrecision, BigDecimal loseRate, BigDecimal curWriteOffBaseQty) {
        HashMap devInWarehsEntryMap = (HashMap)devInWarehsMap.get(devInWarehsInfo.getCoreBillEntryId());
        DevolveInWarehsBillInfo bill = null;
        BigDecimal writtenOffBaseQty = BigDecimal.ZERO;
        BigDecimal devInWarehsBaseQty = BigDecimal.ZERO;
        Iterator itor = devInWarehsEntryMap.keySet().iterator();
        while (itor.hasNext()) {
            bill = (DevolveInWarehsBillInfo)devInWarehsEntryMap.get(itor.next());
            writtenOffBaseQty = writtenOffBaseQty.add(bill.getDevWriteOffBaseQty());
            devInWarehsBaseQty = devInWarehsBaseQty.add(bill.getBaseQty());
        }
        if (entry.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED) && devInWarehsInfo.getDevUnWriteOffBaseQty().add(writtenOffBaseQty).compareTo(devInWarehsBaseQty) == 0) {
            DevolveMatReqBillInfo devBill = null;
            HashMap matReqBillMap = (HashMap)matReqMap.get(devMatReqInfo.getCoreBillEntryId());
            Iterator itor2 = matReqBillMap.keySet().iterator();
            BigDecimal matWrittenOffBaseQty = BigDecimal.ZERO;
            BigDecimal matBastQty = BigDecimal.ZERO;
            while (itor2.hasNext()) {
                devBill = (DevolveMatReqBillInfo)matReqBillMap.get(itor2.next());
                matWrittenOffBaseQty = matWrittenOffBaseQty.add(devBill.getDevWriteOffBaseQty());
                matBastQty = matBastQty.add(devBill.getBaseQty());
            }
            BigDecimal devCalBaseQty = devInWarehsBaseQty.multiply(baseQtyRate).multiply(new BigDecimal(1).add(loseRate.divide(new BigDecimal(100)))).setScale(basePrecision, 2);
            BigDecimal returnBaseQty = BigDecimal.ZERO;
            returnBaseQty = devCalBaseQty.compareTo(matBastQty) < 0 ? devCalBaseQty.subtract(matWrittenOffBaseQty) : matBastQty.subtract(matWrittenOffBaseQty);
            return returnBaseQty;
        }
        return curWriteOffBaseQty;
    }
}

