/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractEvaluateDetailReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class EvaluateDetailReportFacadeControllerBean
extends AbstractEvaluateDetailReportFacadeControllerBean {
    private static final long serialVersionUID = -3085593610507916946L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.EvaluateDetailReportFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"240_EvaluateDetailReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        String tmpPeriodTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"125_CostDiffDetailReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int beginOldYear = beginYear;
        int beginOldPeriod = beginPeriod;
        String sql = "";
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, cou);
        params.setInt("amtPrecision", amtPrecision);
        long lStart = 0L;
        long lEnd = 0L;
        lStart = this.GetNowTime();
        sql = this.getCreateTempTab(ctx, tempTable);
        sql = CalculateUtil.transCreateTable(ctx, sql);
        this.executeSQL(ctx, sql);
        lEnd = this.GetNowTime();
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)cou.getId().toString(), (String)"evaluatedetailreport_view");
        if (checkPermission) {
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
            if (100 * beginYear + beginPeriod > currentPeriod) {
                beginYear = currentPeriodInfo.getPeriodYear();
                beginPeriod = currentPeriodInfo.getPeriodNumber();
                params.setInt("accPeriodYearFrom", beginYear);
                params.setInt("accPeriodMonthFrom", beginPeriod);
            }
            lStart = this.GetNowTime();
            this.getPeriodHappen(ctx, tempTable, params);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u53d6\u5f97\u53d1\u751f\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            lStart = this.GetNowTime();
            sql = this.getPeriodSql(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u83b7\u53d6\u8be5\u7269\u6599\u6709\u53d1\u751f\u7684\u4f1a\u8ba1\u671f\u95f4\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            lStart = this.GetNowTime();
            sql = this.getPeriodBegin(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u53d6\u5f97\u671f\u521d\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            sql = this.getRemoveTmpPeriodBeginSQL(ctx, tempTable);
            this.executeSQL(ctx, sql);
            sql = this.getPeriodTotal(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDealNextPeriod(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getPeriodYearTotal(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDealPrice(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDropTmpPeriodTab(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getRemoveTmpPeriodBeginRecord(ctx, tempTable);
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FYear=null Where FYear=0 ";
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FPeriod=null Where FPeriod=0 ";
            this.executeSQL(ctx, sql);
            if (100 * beginOldYear + beginOldPeriod > currentPeriod) {
                sql = "delete from " + tempTable + " where 100*fyear + fperiod < " + (100 * beginOldYear + beginOldPeriod);
                this.executeSQL(ctx, sql);
            }
            params.setInt("accPeriodYearFrom", beginOldYear);
            params.setInt("accPeriodMonthTo", beginOldPeriod);
        }
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = this.getReportHeader(ctx, params, amtPrecision);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        RptParams rpt = new RptParams();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        IMaterial aIMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)params.getObject("CurrentMaterialID").toString()));
        MaterialInfo aMaterialInfo = aIMaterial.getMaterialInfo((IObjectPK)pk);
        int prcPrecision = aMaterialInfo.getPricePrecision();
        MeasureUnitInfo aMeasureUnitInfo = aMaterialInfo.getBaseUnit();
        int qtyPrecision = 6;
        String sSQL = "select FQtyPrecision from T_BD_MultiMeasureUnit where FMaterialID='" + aMaterialInfo.getId().toString() + "' and FMeasureUnitID='" + aMeasureUnitInfo.getId().toString() + "'";
        RptRowSet rs0 = this.executeQuery(sSQL, null, ctx);
        if (rs0.first()) {
            qtyPrecision = rs0.getInt(0);
        }
        sql.append("Select FYear,FPeriod,FStorageOrgUnit,FWarehouse,FVoucherNumber,FBizDate,FBillNumber,FSupplier,FTransactionType_" + this.getLoc(ctx) + " as FTransactionType_l2,");
        sql.append("FKAClass,FAssistantAttr_" + this.getLoc(ctx)).append(" as FAssistantAttr_l2,");
        sql.append("round(FInQty,").append(qtyPrecision).append(") as FInQty,");
        sql.append("round(FInUnitPrice,").append(prcPrecision).append(") as FInUnitPrice,round(FInAmount,").append(amtPrecision).append(") as FInAmount,");
        sql.append("round(FOutQty,").append(qtyPrecision).append(") as FOutQty,round(FOutUnitPrice,").append(prcPrecision).append(") as FOutUnitPrice,");
        sql.append("round(FOutAmount,").append(amtPrecision).append(") as FOutAmount,round(FRemainQty,").append(qtyPrecision).append(") as FRemainQty,");
        sql.append("round(FRemainUnitPrice,").append(prcPrecision).append(") as FRemainUnitPrice,");
        sql.append("round(FRemainAmount,").append(amtPrecision).append(")as FRemainAmount,");
        sql.append("FIndex,FID,FMaterialID,FBillType ");
        sql.append("FROM " + params.getString("tempTable")).append(" ");
        sql.append("Order by FYear,IsNull(FPeriod, 99),FIndex,FBizDate,FBillNumber,FOrderIdx");
        if ("true".equals(params.getString("isPrint"))) {
            RptRowSet printRs = this.executeQuery(sql.toString(), null, ctx);
            rpt.setObject("printRs", (Object)printRs);
        }
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        rpt.setObject("rowset", (Object)rs);
        rpt.setInt("prcPrecision", prcPrecision);
        return rpt;
    }

    private String getCreateTempTab(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("FOrderIdx VARCHAR(44),");
        sql.append("FIndex INT DEFAULT 0,");
        sql.append("FID VARCHAR(44),");
        sql.append("FMaterialID VARCHAR(44), ");
        sql.append("FBillType INT NOT NULL,");
        sql.append("FYear INT,");
        sql.append("FPeriod INT,");
        sql.append("FStorageOrgUnit VARCHAR(80),");
        sql.append("FWarehouse VARCHAR(80),");
        sql.append("FVoucherNumber VARCHAR(80),");
        sql.append("FBizDate DATETIME,");
        sql.append("FBillNumber VARCHAR(80),");
        sql.append("FSupplier VARCHAR(1000),");
        sql.append("FKAClass VARCHAR(80),");
        sql.append("FTransactionType_" + this.getLoc(ctx) + " NVARCHAR(255),");
        sql.append("FAssistantAttr_" + this.getLoc(ctx) + " NVARCHAR(255),");
        sql.append("FInQty NUMERIC(28,16) default 0,");
        sql.append("FInUnitPrice NUMERIC(28,16) default 0,");
        sql.append("FInAmount NUMERIC(19,4) default 0,");
        sql.append("FOutQty NUMERIC(28,16) default 0,");
        sql.append("FOutUnitPrice NUMERIC(28,16) default 0,");
        sql.append("FOutAmount NUMERIC(19,4) default 0,");
        sql.append("FRemainQty NUMERIC(28,16) default 0,");
        sql.append("FRemainUnitPrice NUMERIC(28,16) default 0,");
        sql.append("FRemainAmount NUMERIC(19,4) default 0");
        sql.append(")");
        return sql.toString();
    }

    private RptTableHeader getReportHeader(Context ctx, RptParams params, int amtPrecision) throws BOSException, EASBizException {
        String amtFormat = CalculateUtil.getFormatPattern(amtPrecision);
        IMaterial aIMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)params.getObject("CurrentMaterialID").toString()));
        MaterialInfo aMaterialInfo = aIMaterial.getMaterialInfo((IObjectPK)pk);
        int prcPrecision = aMaterialInfo.getPricePrecision();
        String prcFormat = CalculateUtil.getFormatPattern(prcPrecision);
        String formaStr = RptCellFormatter.getTrimZeroFormat();
        String qtyFormat = null;
        MeasureUnitInfo aMeasureUnitInfo = aMaterialInfo.getBaseUnit();
        String sSQL = "select FQtyPrecision from T_BD_MultiMeasureUnit where FMaterialID='" + aMaterialInfo.getId().toString() + "' and FMeasureUnitID='" + aMeasureUnitInfo.getId().toString() + "'";
        RptRowSet rs = this.executeQuery(sSQL, null, ctx);
        if (rs.first()) {
            int qtyPrecision = rs.getInt(0);
            qtyFormat = CalculateUtil.getFormatPattern(qtyPrecision);
        } else {
            qtyFormat = formaStr;
        }
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FYear");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FPeriod");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnit");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FWarehouse");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FVoucherNumber");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FBizDate");
        col.setWidth(90);
        col.setFormatPattern("yyyy-MM-dd");
        header.addColumn(col);
        col = new RptTableColumn("FNumber");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FSupplier");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FTransactionType");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FKAClass");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("FAssistAttr");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FInQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FBillType");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WAREHOUSENAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VOUCHERNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"SUPPLIERNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"KAClassfication", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ASSISTPROPERTY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"InWare", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"InWare", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"InWare", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WrittenOff", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WrittenOff", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WrittenOff", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), "FIndex", "FID", "materielID", SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx)}, {SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WAREHOUSENAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VOUCHERNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"SUPPLIERNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"KAClassfication", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ASSISTPROPERTY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), "FIndex", "FID", "materielID", SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx)}}, true);
        return header;
    }

    private StringBuffer getInWareWhere(RptParams params) {
        String supplierNumber;
        boolean isJoinQuery;
        StringBuffer sqlWhere = new StringBuffer();
        String fiOrgUnitID = null;
        String CurrentMaterial = null;
        String warehouseFrom = null;
        String warehouseTo = null;
        String warehouseIn = null;
        String warehouse = null;
        int voucher = -1;
        int status = -1;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        if (isJoinQuery = params.getBoolean("IsJoinQuery")) {
            warehouse = params.getString("warehouse");
        } else {
            if (params.getObject("warehouseFrom") != null) {
                if (params.getObject("warehouseFrom") instanceof Object[]) {
                    Object[] warehouses = (Object[])params.getObject("warehouseFrom");
                    if (warehouses.length == 1) {
                        warehouseFrom = ((WarehouseInfo)warehouses[0]).getNumber();
                    } else {
                        warehouseIn = CalculateUtil.getObjArrayNumberWithQuote(warehouses);
                    }
                } else {
                    warehouseFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
                }
            }
            if (params.getObject("warehouseTo") != null) {
                warehouseTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            }
        }
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        sqlWhere.append(" And ( h.FBaseStatus = 2 or h.FBaseStatus = 4) ");
        sqlWhere.append(" And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'");
        if (CurrentMaterial != null) {
            sqlWhere.append(" AND d.FMaterialID = '" + CurrentMaterial + "' ");
        }
        if (params.getString("storageOrgUnit") != null) {
            String storageNumber = params.getString("storageOrgUnit");
            sqlWhere.append(" AND storage.FNumber in(" + storageNumber + ") ");
        }
        if (params.getObject("supperFrom") != null) {
            if (params.getObject("supperFrom") instanceof Object[]) {
                Object[] suppliers = (Object[])params.getObject("supperFrom");
                if (suppliers.length == 1) {
                    sqlWhere.append(" AND supplier.FNumber >= '" + ((SupplierInfo)suppliers[0]).getNumber() + "'");
                } else {
                    sqlWhere.append(" AND supplier.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(suppliers)).append(")");
                }
            } else {
                supplierNumber = ((SupplierInfo)params.getObject("supperFrom")).getNumber();
                sqlWhere.append(" AND supplier.FNumber >= '" + supplierNumber + "' ");
            }
        }
        if (params.getObject("supperTo") != null) {
            supplierNumber = ((SupplierInfo)params.getObject("supperTo")).getNumber();
            sqlWhere.append("  AND supplier.FNumber <= '" + supplierNumber + "' ");
        }
        if (isJoinQuery) {
            if (warehouse != null) {
                sqlWhere.append(" AND wh.FNumber in(" + warehouse + ")");
            }
        } else {
            if (warehouseFrom != null) {
                sqlWhere.append(" AND wh.FNumber >= '" + warehouseFrom + "' ");
            }
            if (warehouseTo != null) {
                sqlWhere.append(" AND wh.FNumber <= '" + warehouseTo + "' ");
            }
            if (warehouseIn != null) {
                sqlWhere.append(" AND wh.FNumber in (" + warehouseIn + ") ");
            }
        }
        if (status == 2) {
            sqlWhere.append(" AND h.FBaseStatus = " + String.valueOf(status));
        } else if (status == 4) {
            sqlWhere.append(" AND h.FBaseStatus >= " + String.valueOf(status));
        }
        if (voucher != -1) {
            sqlWhere.append(" And h.ffiVouchered = ").append(voucher);
        }
        sqlWhere.append(" \r\n ");
        return sqlWhere;
    }

    private StringBuffer getWFWhere(RptParams params) {
        String supplierNumber;
        boolean isJoinQuery;
        StringBuffer sqlWFWhere = new StringBuffer();
        String fiOrgUnitID = null;
        String CurrentMaterial = null;
        String warehouseFrom = null;
        String warehouseTo = null;
        String warehouseIn = null;
        String warehouse = null;
        int voucher = -1;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        if (isJoinQuery = params.getBoolean("IsJoinQuery")) {
            warehouse = params.getString("warehouse");
        } else {
            if (params.getObject("warehouseFrom") != null) {
                if (params.getObject("warehouseFrom") instanceof Object[]) {
                    Object[] warehouses = (Object[])params.getObject("warehouseFrom");
                    if (warehouses.length == 1) {
                        warehouseFrom = ((WarehouseInfo)warehouses[0]).getNumber();
                    } else {
                        warehouseIn = CalculateUtil.getObjArrayNumberWithQuote(warehouses);
                    }
                } else {
                    warehouseFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
                }
            }
            if (params.getObject("warehouseTo") != null) {
                warehouseTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            }
        }
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        sqlWFWhere.append(" And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'");
        if (CurrentMaterial != null) {
            sqlWFWhere.append(" AND d.FMaterialID = '" + CurrentMaterial + "' ");
        }
        if (params.getString("storageOrgUnit") != null) {
            String storageNumber = params.getString("storageOrgUnit");
            sqlWFWhere.append(" AND storage.FNumber in(" + storageNumber + ") ");
        }
        if (isJoinQuery) {
            if (warehouse != null) {
                sqlWFWhere.append(" AND wh.FNumber in(" + warehouse + ")");
            }
        } else {
            if (warehouseFrom != null) {
                sqlWFWhere.append(" AND wh.FNumber >= '" + warehouseFrom + "' ");
            }
            if (warehouseTo != null) {
                sqlWFWhere.append(" AND wh.FNumber <= '" + warehouseTo + "' ");
            }
            if (warehouseIn != null) {
                sqlWFWhere.append(" AND wh.FNumber in (" + warehouseIn + ") ");
            }
        }
        if (params.getObject("supperFrom") != null) {
            if (params.getObject("supperFrom") instanceof Object[]) {
                Object[] suppliers = (Object[])params.getObject("supperFrom");
                if (suppliers.length == 1) {
                    sqlWFWhere.append(" AND supplier.FNumber >= '" + ((SupplierInfo)suppliers[0]).getNumber() + "'");
                } else {
                    sqlWFWhere.append(" AND supplier.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(suppliers)).append(")");
                }
            } else {
                supplierNumber = ((SupplierInfo)params.getObject("supperFrom")).getNumber();
                sqlWFWhere.append(" AND supplier.FNumber >= '" + supplierNumber + "' ");
            }
        }
        if (params.getObject("supperTo") != null) {
            supplierNumber = ((SupplierInfo)params.getObject("supperTo")).getNumber();
            sqlWFWhere.append("  AND supplier.FNumber <= '" + supplierNumber + "' ");
        }
        if (voucher != -1) {
            sqlWFWhere.append(" And h.ffiVouchered = ").append(voucher);
        }
        sqlWFWhere.append(" \r\n ");
        return sqlWFWhere;
    }

    private void getPeriodHappen(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        int status = -1;
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int periodMTo = params.getInt("accPeriodMonthTo");
        StringBuffer sqlWhere = new StringBuffer();
        StringBuffer sqlWFWhere = new StringBuffer();
        sqlWhere.append(this.getInWareWhere(params));
        sqlWFWhere.append(this.getWFWhere(params));
        String insertSQL = "INSERT INTO " + tempTable + "\r\n";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,10 as FIndex, ");
        sql.append("h.FID as FID , ");
        sql.append("d.FMaterialID as FMaterialID, ");
        sql.append("1 as FBillType, ");
        sql.append("h.FYear as FYear, ");
        sql.append("h.FPeriod as FPeriod, ");
        sql.append("storage.FName_" + this.getLoc(ctx) + " as FStorageOrgUnitID, ");
        sql.append("wh.FName_" + this.getLoc(ctx) + " as FWareHouseID, ");
        sql.append("g.FNumber as FVoucherNumber, ");
        sql.append("h.FBizDate as FBizDate, ");
        sql.append("h.FNumber as FBillNumber, ");
        sql.append("supplier.FName_" + this.getLoc(ctx) + " as FSupplier, ");
        sql.append("ka.FName_" + this.getLoc(ctx) + " as FKAClass, ");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionType_" + this.getLoc(ctx) + ", ");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttr_" + this.getLoc(ctx) + ", ");
        sql.append("d.FBaseQty as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("d.FPurchaseCost, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount ");
        sql.append("FROM T_IM_PurInWarehsBill h  ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry d ON h.FID = d.FParentID ");
        sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON d.FINVUPDATETYPEID = invUpdateType.FID ");
        sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
        sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
        sql.append("INNER JOIN T_ORG_Storage storage ON h.FStorageOrgUnitID = storage.FID ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
        sql.append("LEFT JOIN T_BD_Supplier supplier ON d.FBalanceSupplierID = supplier.FID ");
        sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID ");
        sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID \r\n");
        sql.append("WHERE  1 = 1 ");
        sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
        sql.append(" AND d.FISPRESENT = 0");
        sql.append(" AND (h.FYear*100+h.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FYear*100+h.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ");
        sql.append(sqlWhere.toString());
        this.executeSQL(ctx, insertSQL + sql.toString());
        if (status != 2) {
            sql = new StringBuffer();
            sql.append("SELECT newbosid('ORDERIDX') as FOrderID,10 as FIndex, ");
            sql.append("d.FBillID as FID , ");
            sql.append("d.FMaterialID as FMaterialID, ");
            sql.append("1 as FBillType, ");
            sql.append("h.FWriteOffYear as FYear, ");
            sql.append("h.FWriteOffPeriod as FPeriod, ");
            sql.append("storage.FName_" + this.getLoc(ctx) + " as FStorageOrgUnitID, ");
            sql.append("wh.FName_" + this.getLoc(ctx) + " as FWareHouseID, ");
            sql.append("g.FNumber as FVoucherNumber, ");
            sql.append("d.FBillDate as FBizDate, ");
            sql.append("d.FBillNumber as FBillNumber, ");
            sql.append("supplier.FName_" + this.getLoc(ctx) + " as FSupplier, ");
            sql.append("ka.FName_" + this.getLoc(ctx) + " as FKAClass, ");
            sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionType_" + this.getLoc(ctx) + ", ");
            sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttr_" + this.getLoc(ctx) + ", ");
            sql.append("0 as FInQty, ");
            sql.append("0 as FInUnitPrice, ");
            sql.append("0 as FPurchaseCost, ");
            sql.append("d.FCurrWrittenOffQty as FOutQty, ");
            sql.append("0 as FOutUnitPrice, ");
            sql.append("d.FCurrWrittenOffAmount as FOutAmount, ");
            sql.append("0 as FRemainQty, ");
            sql.append("0 as FRemainUnitPrice,  ");
            sql.append("0 as FRemainAmount ");
            sql.append("FROM T_CL_WriteOffGroup h  ");
            sql.append("INNER JOIN T_CL_WriteOffRecord d ON h.FID = d.FParentID ");
            sql.append("INNER JOIN T_IM_PurInWarehsEntry pie ON d.FBillEntryID = pie.FID ");
            sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON pie.FINVUPDATETYPEID = invUpdateType.FID ");
            sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
            sql.append("INNER JOIN T_SCM_TransactionType tr ON d.FTransactionTypeID = tr.FID ");
            sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND d.FCompanyOrgUnitID = mcom.FCompanyID ");
            sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
            sql.append("INNER JOIN T_ORG_Storage storage ON pie.FStorageOrgUnitID = storage.FID ");
            sql.append("INNER JOIN t_db_warehouse wh ON pie.FWarehouseID = wh.FID ");
            sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
            sql.append("LEFT JOIN T_BD_Supplier supplier ON d.FSupplierID = supplier.FID ");
            sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID ");
            sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID = a.FID \r\n");
            sql.append("WHERE  1 = 1  ");
            sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
            sql.append(" AND pie.FISPRESENT = 0");
            sql.append(" AND (h.FWriteOffYear*100+h.FWriteOffPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FWriteOffYear*100+h.FWriteOffPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ");
            sql.append(sqlWFWhere.toString());
            sql.append(" AND d.FbillTypeNumber = '103' ");
            this.executeSQL(ctx, insertSQL + sql.toString());
        }
        sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
        sql.append("FID , ");
        sql.append("FMaterialID , ");
        sql.append("1 as FBillType, ");
        sql.append("FYear, ");
        sql.append("FPeriod, ");
        sql.append("FStorageOrgUnit, ");
        sql.append("FWarehouse, ");
        sql.append("FVoucherNumber, ");
        sql.append("FBizDate, ");
        sql.append("FBillNumber, ");
        sql.append("FSupplier, ");
        sql.append("FKAClass, ");
        sql.append("FTransactionType_" + this.getLoc(ctx) + ", ");
        sql.append("FAssistantAttr_" + this.getLoc(ctx) + ", ");
        sql.append("sum(FInQty) as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("sum(FInAmount) as FInAmount, ");
        sql.append("sum(FOutQty) as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("sum(FOutAmount) as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount ");
        sql.append(" FROM ").append(tempTable).append(" ");
        sql.append(" WHERE  1 = 1 AND FIndex = 10 ");
        sql.append(" GROUP BY FID, FMaterialID, FYear, FPeriod, FStorageOrgUnit,  ");
        sql.append("  FWarehouse, FVoucherNumber, FBizDate, FBillNumber,FSupplier,FKAClass, ");
        sql.append("  FTransactionType_" + this.getLoc(ctx) + ", ");
        sql.append("  FAssistantAttr_" + this.getLoc(ctx) + " ");
        if (params.getBoolean("filteNoINOut")) {
            sql.append(" having (sum(isnull(FInQty,0))<>0 or sum(isnull(FOutQty,0)) <>0) ");
        }
        this.executeSQL(ctx, insertSQL + sql.toString());
        sql = new StringBuffer();
        sql.append("delete from " + tempTable + " where FIndex = 10 \r\n");
        this.executeSQL(ctx, sql.toString());
    }

    private String getPeriodSql(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String sql = null;
        String fiOrgUnitID = null;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int pFrom = periodYFrom * 100 + periodMFrom;
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMTo = params.getInt("accPeriodMonthTo");
        int pTo = periodYTo * 100 + periodMTo;
        sql = "Create Table " + tmpPeriodTable + " (FCompanyOrgUnitID VARCHAR(44) NOT NULL ,  FYear INT,FPeriod INT);";
        this.executeSQL(ctx, sql);
        sql = "Insert Into " + tmpPeriodTable + " Select '" + fiOrgUnitID + "' as FCompanyOrgUnitID,fperiodyear,fperiodnumber From T_BD_Period   WHERE (fperiodyear*100+fperiodnumber >= " + String.valueOf(pFrom) + " \tAnd fperiodyear*100+fperiodnumber <= " + String.valueOf(pTo) + ")  and FIsAdjustPeriod != 1  Group By fperiodyear,fperiodnumber ; \r\n";
        return sql;
    }

    private String getPeriodBegin(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int periodYear = 0;
        int periodNumber = 0;
        int status = -1;
        ArrayList<String> sqls = new ArrayList<String>();
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        String selSQL = null;
        selSQL = "SELECT FCompanyOrgUnitID ,FYear, FPeriod FROM " + tmpPeriodTable;
        RptRowSet rs = this.executeQuery(selSQL, null, ctx);
        while (rs.next()) {
            periodYear = rs.getInt("FYear");
            periodNumber = rs.getInt("FPeriod");
            sql = new StringBuffer();
            sql.append(this.insertTotleInwarePeriodBefore(ctx, tempTable, params, periodYear, periodNumber));
            sqls.add(sql.toString());
            if (status == 2) continue;
            sql = new StringBuffer();
            sql.append(this.insertTotleWFPeriodBefore(ctx, tempTable, params, periodYear, periodNumber));
            sqls.add(sql.toString());
        }
        DBUtil.execBatchSql(ctx, sqls, true);
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" INSERT INTO  ").append(tempTable).append(" \r\n ");
        sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,-1 as FIndex, ");
        sql.append("' ' as FID , ");
        sql.append(" FMaterialID as FMaterialID, ");
        sql.append("-1 as FBillType, ");
        sql.append(" FYear as FYear, ");
        sql.append(" FPeriod as FPeriod, ");
        sql.append("' ' as FStorageOrgUnitID, ");
        sql.append("' ' as FWareHouseID, ");
        sql.append("' ' as FVoucherNumber, ");
        sql.append("null as FBizDate, ");
        sql.append("' ' as FBillNumber, ");
        sql.append("' ' as FSupplier, ");
        sql.append("' ' as FKAClass, ");
        sql.append("'").append(SCMUtils.getResource((String)this.res, (String)"BEGINBALANCE", (Context)ctx)).append("' as FTransactionType, ");
        sql.append("' ' as FAssistantAttr, ");
        sql.append("0 as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("0 as FPurchaseCost, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("0 as FOutAmount, ");
        sql.append(" SUM(ISNULL(FInQty,0)-ISNULL(FOutQty,0)) as FRemainQty, ");
        sql.append(" 0 as FRemainUnitPrice, ");
        sql.append(" SUM(ISNULL(FInAmount,0)- ISNULL(FOutAmount,0)) as FRemainAmount ");
        sql.append(" FROM ").append(tempTable).append(" as h ");
        sql.append(" WHERE FIndex = -2 GROUP BY FMaterialID, FYear, FPeriod ");
        return insertSQL.append(sql).toString();
    }

    private StringBuffer insertTotleInwarePeriodBefore(Context ctx, String tempTable, RptParams params, int periodYear, int periodNumber) throws BOSException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" INSERT INTO  ").append(tempTable).append(" \r\n ");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,-2 as FIndex, ");
        sql.append("' ' as FID , ");
        sql.append("'").append(CurrentMaterial).append("' as FMaterialID, ");
        sql.append("-1 as FBillType, ");
        sql.append(periodYear).append(" as FYear, ");
        sql.append(periodNumber).append(" as FPeriod, ");
        sql.append("' ' as FStorageOrgUnitID, ");
        sql.append("' ' as FWareHouseID, ");
        sql.append("' ' as FVoucherNumber, ");
        sql.append("null as FBizDate, ");
        sql.append("' ' as FBillNumber, ");
        sql.append("' ' as FSupplier, ");
        sql.append("' ' as FKAClass, ");
        sql.append("' ' as FTransactionType, ");
        sql.append("' ' as FAssistantAttr, ");
        sql.append("sum(d.FBaseQty) as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("sum(d.FPurchaseCost) as FPurchaseCost, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount ");
        sql.append("FROM T_IM_PurInWarehsBill h  ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry d ON h.FID = d.FParentID ");
        sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON d.FINVUPDATETYPEID = invUpdateType.FID ");
        sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("LEFT JOIN T_ORG_Storage storage ON h.FStorageOrgUnitID = storage.FID ");
        sql.append("LEFT JOIN T_BD_Supplier supplier ON d.FBalanceSupplierID = supplier.FID \r\n ");
        sql.append("WHERE  1 = 1 ");
        sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
        sql.append(" AND d.FISPRESENT = 0");
        sql.append(" AND (h.FYear*100+h.FPeriod < " + String.valueOf(periodYear * 100 + periodNumber) + ") ");
        sql.append(this.getInWareWhere(params).toString());
        return insertSQL.append(sql);
    }

    private StringBuffer insertTotleWFPeriodBefore(Context ctx, String tempTable, RptParams params, int periodYear, int periodNumber) {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" INSERT INTO  ").append(tempTable).append(" \r\n ");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,-2 as FIndex, ");
        sql.append("' ' as FID , ");
        sql.append("'").append(CurrentMaterial).append("' as FMaterialID, ");
        sql.append("-1 as FBillType, ");
        sql.append(periodYear).append(" as FYear, ");
        sql.append(periodNumber).append(" as FPeriod, ");
        sql.append("' ' as FStorageOrgUnitID, ");
        sql.append("' ' as FWareHouseID, ");
        sql.append("' ' as FVoucherNumber, ");
        sql.append("null as FBizDate, ");
        sql.append("' ' as FBillNumber, ");
        sql.append("' ' as FSupplier, ");
        sql.append("' ' as FKAClass, ");
        sql.append("' ' as FTransactionType, ");
        sql.append("' ' as FAssistantAttr, ");
        sql.append("0 as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("0 as FPurchaseCost, ");
        sql.append("sum(d.FCurrWrittenOffQty) as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("sum(d.FCurrWrittenOffAmount) as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount ");
        sql.append("FROM T_CL_WriteOffGroup h  ");
        sql.append("INNER JOIN T_CL_WriteOffRecord d ON h.FID = d.FParentID ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry pie ON d.FBillEntryID = pie.FID ");
        sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON pie.FINVUPDATETYPEID = invUpdateType.FID ");
        sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON d.FTransactionTypeID = tr.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND d.FCompanyOrgUnitID = mcom.FCompanyID ");
        sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
        sql.append("INNER JOIN T_ORG_Storage storage ON pie.FStorageOrgUnitID = storage.FID ");
        sql.append("INNER JOIN t_db_warehouse wh ON pie.FWarehouseID = wh.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
        sql.append("LEFT JOIN T_BD_Supplier supplier ON d.FSupplierID = supplier.FID ");
        sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID \r\n");
        sql.append("WHERE  1 = 1  ");
        sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
        sql.append(" AND pie.FISPRESENT = 0");
        sql.append(" AND (h.FWriteOffYear*100+h.FWriteOffPeriod < " + String.valueOf(periodYear * 100 + periodNumber) + ") ");
        sql.append(this.getWFWhere(params).toString());
        sql.append(" AND d.FbillTypeNumber = '103' ");
        return insertSQL.append(sql);
    }

    private String getRemoveTmpPeriodBeginSQL(Context ctx, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + tempTable + " where FIndex = -2 \r\n");
        return sql.toString();
    }

    private String getPeriodTotal(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + " \r\n");
        sql.append("Select newbosid('ORDERIDX') as FOrderID,1 as FIndex,");
        sql.append("' ' AS FID,");
        sql.append("'" + CurrentMaterial + "' as FMaterialID,");
        sql.append("-1 as FBillType,");
        sql.append("p.FYear as FYear,\r\n");
        sql.append("p.FPeriod as FPeriod,");
        sql.append("' ' as FStorageOrgUnit,");
        sql.append("' ' as FWarehouse,");
        sql.append("' ' as FVoucherNumber,");
        sql.append("null as FBizDate,");
        sql.append("' ' as FNumber,");
        sql.append("' ' as FSupplier,");
        sql.append("' ' as FKAClass,");
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"PERIODTOTAL", (Context)ctx) + "' as FTransactionType,");
        sql.append("' ' as FAssistantAttr,");
        sql.append("sum(p.FInQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("sum(p.FInAmount) as FInAmount,");
        sql.append("sum(p.FOutQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("sum(p.FOutAmount) as FOutAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainPrice,");
        sql.append("0 as FRemainAmount ");
        sql.append(" From " + tempTable + " p \r\n");
        sql.append(" Where p.FIndex=0 or p.Findex = -1 \r\n");
        sql.append(" Group By p.FYear,p.FPeriod\r\n");
        this.executeSQL(ctx, sql.toString());
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t2 Set(FRemainQty,FRemainAmount)=\r\n");
        sql.append("(Select isNull(t1.FRemainQty,0)+isNull(t3.FInQty,0)-isNull(t3.FOutQty,0),");
        sql.append("isNull(t1.FRemainAmount,0)+isNull(t3.FInAmount,0)-isNull(t3.FOutAmount,0) ");
        sql.append("From " + tempTable + " t3," + tempTable + " t1 \r\n");
        sql.append("Where t3.FIndex=1 And t1.FIndex=-1 And t3.FYear=t1.FYear And t3.FPeriod=t1.FPeriod ");
        sql.append(" And t1.FYear*100+t1.FPeriod<=" + String.valueOf(currentPeriod) + " ");
        sql.append(" And t2.FIndex=t3.FIndex And t2.FYear=t3.FYear And t2.FPeriod=t3.FPeriod )");
        return sql.toString();
    }

    private String getDealNextPeriod(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        PeriodInfo currentPeriodInfo;
        PeriodInfo nextPeriodInfo;
        int nextPeriod;
        int periodMTo;
        String sql = null;
        int periodYTo = params.getInt("accPeriodYearTo");
        int toPeriod = periodYTo * 100 + (periodMTo = params.getInt("accPeriodMonthTo"));
        if (toPeriod >= (nextPeriod = (nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)(currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")))))).getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber())) {
            sql = this.UpdatePeriodFirst(ctx, tempTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            this.executeSQL(ctx, sql);
            sql = this.UpdatePeriodLast(ctx, tempTable, nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            this.executeSQL(ctx, sql);
        }
        return "";
    }

    private String getPeriodYearTotal(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + " \r\n");
        sql.append("Select newbosid('ORDERIDX') as FOrderID,2 as FIndex,");
        sql.append("' ' AS FID,");
        sql.append("'" + CurrentMaterial + "' as FMaterialID,");
        sql.append("-1 as FBillType,");
        sql.append("p.FYear,");
        sql.append("0 as FPeriod,");
        sql.append("' ' as FStorageOrgUnit,");
        sql.append("' ' as FWarehouse,");
        sql.append("' ' as FVoucherNumber,");
        sql.append("null as FBizDate,");
        sql.append("' ' as FNumber,");
        sql.append("' ' as FSupplier,");
        sql.append("' ' as FKAClass,");
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' as FTransactionType,");
        sql.append("' ' as FAssistantAttr,");
        sql.append("sum(p.FInQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("sum(p.FInAmount) as FInAmount,");
        sql.append("sum(p.FOutQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("sum(p.FOutAmount) as FOutAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainPrice,");
        sql.append("0 as FRemainAmount ");
        sql.append(" From " + tempTable + " p \r\n");
        sql.append(" Where p.FIndex=1\r\n");
        sql.append(" Group By p.FYear\r\n");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t3 \r\n");
        sql.append("Set (FRemainQty,FRemainAmount)=( \r\n");
        sql.append("Select t2.FRemainQty,t2.FRemainAmount From  " + tempTable + " t1 \r\n");
        sql.append("Left Join ( \r\n");
        sql.append("\tSelect t2.FYear,t2.FPeriod,t1.FRemainQty,t1.FRemainAmount  \r\n");
        sql.append("\tFrom " + tempTable + " t1  \r\n");
        sql.append("\tInner Join(  \r\n");
        sql.append("\tselect FYear,Max(FPeriod) FPeriod  From " + tempTable + " t1 group by FYear \r\n");
        sql.append("\t) t2  \r\n");
        sql.append("\tOn  t1.FYear=t2.FYear and t1.FPeriod=t2.FPeriod where  t1.Findex=1 \r\n");
        sql.append(" ) t2  \r\n");
        sql.append("On t1.FYear=t2.FYear \r\n");
        sql.append("Where t1.FIndex=2 And t1.FIndex=t3.FIndex And t1.FYear=t3.FYear)");
        return sql.toString();
    }

    private String getDealPrice(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FInUnitPrice=(CASE WHEN isnull(FInQty,0)=0 THEN Null ELSE round(decimal(FInAmount,17,4)/decimal(FInQty,21,8),6) END),");
        sql.append("FOutUnitPrice=(CASE WHEN isnull(FOutQty,0)=0 THEN Null ELSE round(decimal(FOutAmount,17,4)/decimal(FOutQty,21,8),6) END),");
        sql.append("FRemainUnitPrice=(CASE WHEN isnull(FRemainQty,0)=0 THEN Null ELSE round(decimal(FRemainAmount,17,4)/decimal(FRemainQty,21,8),6) END) ");
        sql.append(" Where FIndex <> 9 ;");
        return sql.toString();
    }

    private String getDropTmpPeriodTab(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Drop Table " + tmpPeriodTable + "\r\n");
        return sql.toString();
    }

    private String getRemoveTmpPeriodBeginRecord(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from " + tempTable + " where FIndex = -1 and isnull(FRemainQty,0) = 0 and isnull(FRemainAmount,0) = 0 \r\n");
        return sql.toString();
    }

    private String UpdatePeriodFirst(Context ctx, String tempTable, int prePeriodY, int prePeriodM, int nextPeriodY, int nextPeriodM) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " AS t3 Set(FRemainQty,FRemainAmount)=\r\n");
        sql.append("(Select t1.FRemainQty,t1.FRemainAmount \r\n");
        sql.append("From " + tempTable + " t1 ," + tempTable + " t2 \r\n");
        sql.append("Where t1.FYear=" + prePeriodY + " And t1.FPeriod=" + prePeriodM + " And t1.FIndex=1 ");
        sql.append("And t2.FYear=" + nextPeriodY + " And t2.FPeriod=" + nextPeriodM + " And t2.FIndex=-1 \r\n");
        sql.append("And t2.FIndex=t3.FIndex And t2.FYear=t3.FYear And t2.FPeriod=t3.FPeriod )");
        return sql.toString();
    }

    private String UpdatePeriodLast(Context ctx, String tempTable, int pYear, int pMonth) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " AS t3 Set(FRemainQty,FRemainAmount)=\r\n");
        sql.append("(Select isNull(t1.FRemainQty,0)+isNull(t2.FInQty,0)-isNull(t2.FOutQty,0),");
        sql.append("isNull(t1.FRemainAmount,0)+isNull(t2.FInAmount,0)-isNull(t2.FOutAmount,0) ");
        sql.append("From " + tempTable + " t2," + tempTable + " t1 \r\n");
        sql.append("Where t2.FIndex=1 And t1.FIndex=-1 And t2.FYear=t1.FYear And t2.FPeriod=t1.FPeriod \r\n");
        sql.append("And t2.FIndex=t3.FIndex And t2.FYear=t3.FYear And t2.FPeriod=t3.FPeriod )");
        return sql.toString();
    }

    @Override
    protected Object[] _getMaterialPKArray(Context ctx, RptParams params) throws BOSException {
        int status = -1;
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        PeriodInfo currentPeriodInfo = null;
        PeriodInfo periodInfoFrom = null;
        try {
            periodInfoFrom = PeriodUtils.getPeriodInfo((Context)ctx, (int)params.getInt("accPeriodYearFrom"), (int)params.getInt("accPeriodMonthFrom"), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (periodInfoFrom == null || currentPeriodInfo == null) {
            throw new BOSException(CalculateException.ACCT_PERIOD_NOT_EXIST.getName());
        }
        if (100 * periodInfoFrom.getPeriodYear() + periodInfoFrom.getPeriodNumber() > 100 * currentPeriodInfo.getPeriodYear() + currentPeriodInfo.getPeriodNumber()) {
            periodInfoFrom = currentPeriodInfo;
        }
        String fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        Vector<String> materialIDVct = new Vector<String>();
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer billBuff = new StringBuffer();
        String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}};
        billBuff.append("select T.fmaterialid as fmaterialid from (");
        for (int i = 0; i < tableName.length; ++i) {
            if (i != 0) {
                billBuff.append(" union all ");
            }
            billBuff.append("select b.fmaterialid as fmaterialid from ").append(tableName[i][0]).append(" a,").append(tableName[i][1]).append(" b ").append("where a.fid = b.fparentid ");
            billBuff.append("and b.fcompanyorgunitid = '").append(fiOrgUnitID).append("' ");
            if (status != -1) {
                billBuff.append(" and  a.FBaseStatus = " + status + " ");
                continue;
            }
            billBuff.append(" and  (a.FBaseStatus = 2 or a.FBaseStatus = 4) ");
        }
        billBuff.append(") T group by T.fmaterialid");
        sqlBuff.append("SELECT B.FID ");
        sqlBuff.append("FROM T_BD_MaterialCompanyInfo A ");
        sqlBuff.append("INNER JOIN T_BD_Material B ON A.FMaterialID = B.FID ");
        sqlBuff.append("INNER JOIN (").append(billBuff).append(") C ON C.FMaterialID = B.FID ");
        sqlBuff.append("WHERE A.FCompanyID = '" + ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() + "' ");
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    sqlBuff.append(" AND B.FNumber >= '" + ((MaterialInfo)materials[0]).getNumber() + "'");
                } else {
                    sqlBuff.append(" AND B.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(")");
                }
            } else if (params.getObject("materialFrom") instanceof MaterialInfo) {
                sqlBuff.append(" AND B.FNumber >= '" + ((MaterialInfo)params.getObject("materialFrom")).getNumber() + "'");
            } else {
                sqlBuff.append(" AND B.FNumber >= '" + params.getObject("materialFrom") + "'");
            }
        }
        if (params.getObject("materialTo") != null) {
            if (params.getObject("materialTo") instanceof MaterialInfo) {
                sqlBuff.append(" AND B.FNumber <= '" + ((MaterialInfo)params.getObject("materialTo")).getNumber() + "'");
            } else {
                sqlBuff.append(" AND B.FNumber <= '" + params.getObject("materialTo") + "'");
            }
        }
        sqlBuff.append(" ORDER BY B.FNumber");
        RptRowSet rs = this.executeQuery(sqlBuff.toString(), null, ctx);
        while (rs.next()) {
            materialIDVct.add(rs.getString(0));
        }
        rs = null;
        return materialIDVct.toArray();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private long GetNowTime() {
        Date d = new Date();
        return d.getTime();
    }
}

