/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialGroupStandardInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.SumTypeEnum;
import com.kingdee.eas.scm.cal.SumTypeExEnum;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractEvaluateGatherReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EvaluateGatherReportFacadeControllerBean
extends AbstractEvaluateGatherReportFacadeControllerBean {
    private static final long serialVersionUID = -9065425317846042289L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.EvaluateGatherReportFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    public static final String newline = "\r\n";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String SumTypeFieldName = "";
        Object obj = params.getObject("sumType");
        if (obj instanceof SumTypeEnum) {
            SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        } else if (obj instanceof SumTypeExEnum) {
            SumTypeFieldName = ((SumTypeExEnum)((Object)params.getObject("sumType"))).getValue().toString();
        } else if (obj instanceof MaterialGroupStandardInfo) {
            SumTypeFieldName = ((MaterialGroupStandardInfo)params.getObject("sumType")).getId().toString();
        }
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int beginOldYear = beginYear;
        int beginOldPeriod = beginPeriod;
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        int toPeriod = endYear * 100 + endPeriod;
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        if (100 * beginYear + beginPeriod > currentPeriod) {
            beginYear = currentPeriodInfo.getPeriodYear();
            beginPeriod = currentPeriodInfo.getPeriodNumber();
            params.setInt("accPeriodYearFrom", beginYear);
            params.setInt("accPeriodMonthFrom", beginPeriod);
        }
        String wherePeriodSql = this.getWherePeriodSql(ctx, params, currentPeriodInfo, true);
        params.setString("wherePeriodSql", wherePeriodSql);
        if (toPeriod >= currentPeriodInfo.getNumber()) {
            params.setBoolean("hasCurrAndAfterPeriod", true);
            wherePeriodSql = this.getWherePeriodSql(ctx, params, currentPeriodInfo, false);
            params.setString("whereCurrAndAfterPeriodSql", wherePeriodSql);
        }
        String sql = "";
        long lStart = 0L;
        long lEnd = 0L;
        lStart = this.GetNowTime();
        String tempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"241_EvaluateGatherReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
        sql = this.getCreateTable(ctx, tempTable, params, SumTypeFieldName);
        this.executeSQL(ctx, sql);
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)params.getObject("company");
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)cou.getId().toString(), (String)"evaluategatherreport_view");
        if (checkPermission) {
            String tmpPeriodTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"125_CostDiffDetailReportFacadeControllerBean", (Locale)ctx.getLocale()), ctx);
            sql = this.getPeriodSql(ctx, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u83b7\u53d6\u8be5\u7269\u6599\u6709\u53d1\u751f\u7684\u4f1a\u8ba1\u671f\u95f4\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            lStart = this.GetNowTime();
            sql = this.getPeriodHappen(ctx, tempTable, tmpPeriodTable, params, SumTypeFieldName);
            this.executeSQL(ctx, sql);
            sql = this.getRemoveTmpPeriodHappenSQL(tempTable);
            this.executeSQL(ctx, sql);
            lEnd = this.GetNowTime();
            logger.info((Object)("StockGatherReporter get period happen data spend time:" + String.valueOf(lEnd - lStart)));
            sql = this.getPeriodHappenTotal(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getPeriodTotal(ctx, tempTable, SumTypeFieldName);
            this.executeSQL(ctx, sql);
            this.getYearTotal(ctx, tempTable, beginYear, beginPeriod, endYear, endPeriod, SumTypeFieldName);
            this.getAllTotal(ctx, tempTable, beginYear, beginPeriod, SumTypeFieldName);
            sql = "Update " + tempTable + " Set FYear=null Where FYear=0 ";
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FPeriod=null Where FPeriod=0 ";
            this.executeSQL(ctx, sql);
            sql = "FCalculateType".equals(SumTypeFieldName) ? "Update " + tempTable + " Set FSUMTYPEID=null Where FSUMTYPEID=0 " : "Update " + tempTable + " Set FSUMTYPEID=null Where FSUMTYPEID in('',' ')";
            this.executeSQL(ctx, sql);
            if (100 * beginOldYear + beginOldPeriod > currentPeriod) {
                sql = "delete from " + tempTable + " where 100*fyear + fperiod < " + (100 * beginOldYear + beginOldPeriod);
                this.executeSQL(ctx, sql);
            }
            params.setInt("accPeriodYearFrom", beginOldYear);
            params.setInt("accPeriodMonthTo", beginOldPeriod);
        }
        RptTableHeader header1 = this.createTableHeader(ctx, params);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header1);
        return result;
    }

    private RptTableHeader createTableHeader(Context ctx, RptParams params) throws BOSException, EASBizException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        String amtFormat = CalculateUtil.getFormatPattern(amtPrecision);
        String prcFormat = CalculateUtil.getFormatPattern(6);
        String qtyFormat = CalculateUtil.getFormatPattern(4);
        String SumTypeFieldName = "";
        Object obj = params.getObject("sumType");
        if (obj instanceof SumTypeEnum) {
            SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getAlias(ctx.getLocale());
        } else if (obj instanceof SumTypeExEnum) {
            SumTypeFieldName = ((SumTypeExEnum)((Object)params.getObject("sumType"))).getAlias(ctx.getLocale());
        } else if (obj instanceof MaterialGroupStandardInfo) {
            SumTypeFieldName = SCMUtils.getResource((String)this.res, (String)"MATERIALTYPE", (Context)ctx);
        }
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FCompanyName");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FYear");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FPeriod");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FSumTypeName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialNumber");
        col.setFormatPattern("@");
        col.setWidth(100);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FMATERIALNAME");
        col.setWidth(150);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FMaterialModel");
        col.setWidth(100);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FKAClass");
        col.setWidth(80);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FBASEUNITNAME");
        col.setWidth(100);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FBeginQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FBeginPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FBeginAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        String qtyFormat2 = RptCellFormatter.getNumberFormat((int)4, (boolean)true);
        col.setFormatPattern(qtyFormat2);
        header.addColumn(col);
        col = new RptTableColumn("FInPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FSumTypeID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyOrgUnitID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        String intFormat = CalculateUtil.getFormatPattern(0);
        col = new RptTableColumn("fqtyprecision");
        col.setWidth(0);
        col.setHided(true);
        col.setFormatPattern(intFormat);
        header.addColumn(col);
        col = new RptTableColumn("fpriceprecision");
        col.setWidth(0);
        col.setHided(true);
        col.setFormatPattern(intFormat);
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"FICU", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SumTypeFieldName, SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"KAClassfication", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"InWare", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"InWare", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"InWare", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WrittenOff", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WrittenOff", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WrittenOff", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), "FSumTypeID", "FMaterialID", "FIndex", "FCompanyOrgUnitID", "fqtyprecision", "fpriceprecision"}, {SCMUtils.getResource((String)this.res, (String)"FICU", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SumTypeFieldName, SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"KAClassfication", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), "FSumTypeID", "FMaterialID", "FIndex", "FCompanyOrgUnitID", "fqtyprecision", "fpriceprecision"}}, true);
        return header;
    }

    private String getCreateTable(Context ctx, String tempTable, RptParams params, String SumTypeFieldName) {
        StringBuffer sql = new StringBuffer();
        String SumTypeFieldType = null;
        if (params.getObject("sumType") != null) {
            SumTypeFieldType = "FCalculateType".endsWith(SumTypeFieldName) ? " int," : " Varchar(44),";
        }
        sql.append("Create Table " + tempTable + " \r\n");
        sql.append("(FINDEX Int NOT NULL , \r\n");
        sql.append("FCompanyOrgUnitID Varchar(44), \r\n");
        sql.append("FCOMPANYNAME NVarchar(255), \r\n");
        sql.append("FYear int, \r\n");
        sql.append("FPeriod int, \r\n");
        sql.append("FMaterialID Varchar(44), \r\n");
        sql.append("FMATERIALNAME NVarchar(400),\r\n");
        sql.append("FMaterialNumber NVarchar(100),\r\n");
        sql.append("FMaterialModel NVarchar(400),\r\n");
        sql.append("FKAClass VARCHAR(80),\r\n");
        sql.append("FBASEUNITNAME NVarchar(100),\r\n");
        sql.append("FSUMTYPEID " + SumTypeFieldType + newline);
        sql.append("FSUMTYPENAME Varchar(1000),\r\n");
        sql.append("FBEGINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FBEGINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FOUTQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FOUTAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FREMAINQTY NUMERIC(21, 8)  ,\r\n");
        sql.append("FREMAINAMOUNT NUMERIC(17, 4) );\r\n");
        return sql.toString();
    }

    private String getPeriodSql(Context ctx, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String sql = null;
        String fiOrgUnitID = null;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int pFrom = periodYFrom * 100 + periodMFrom;
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMTo = params.getInt("accPeriodMonthTo");
        int pTo = periodYTo * 100 + periodMTo;
        sql = "Create Table " + tmpPeriodTable + " (FCompanyOrgUnitID VARCHAR(44) NOT NULL ,  FYear INT,FPeriod INT);";
        this.executeSQL(ctx, sql);
        sql = "Insert Into " + tmpPeriodTable + " Select '" + fiOrgUnitID + "' as FCompanyOrgUnitID,fperiodyear,fperiodnumber From T_BD_Period   WHERE (fperiodyear*100+fperiodnumber >= " + String.valueOf(pFrom) + " \tAnd fperiodyear*100+fperiodnumber <= " + String.valueOf(pTo) + ")   Group By fperiodyear,fperiodnumber ; \r\n";
        return sql;
    }

    private String getWherePeriodSql(Context ctx, RptParams params, PeriodInfo currPeriodInfo, boolean isAllPeriod) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        if (!isAllPeriod) {
            beginYear = currPeriodInfo.getPeriodYear();
            beginPeriod = currPeriodInfo.getPeriodNumber();
        }
        int fromPeriod = beginYear * 100 + beginPeriod;
        int toPeriod = endYear * 100 + endPeriod;
        StringBuffer wherePeriod = new StringBuffer();
        if (fromPeriod == toPeriod) {
            wherePeriod.append("(h.fyear = ").append(beginYear).append(" and h.fperiod = ").append(beginPeriod).append(")");
        } else {
            wherePeriod.append(" h.FYear*100 + h.fperiod >= ").append(fromPeriod).append(" and h.FYear *100 + h.fperiod<= ").append(toPeriod);
        }
        return wherePeriod.toString();
    }

    private String getPeriodHappen(Context ctx, String tempTable, String tmpPeriodTable, RptParams params, String SumTypeFieldName) throws BOSException, EASBizException {
        StringBuffer sqlAll = new StringBuffer();
        String sql = "";
        sql = this.getPeriodBegin(ctx, tempTable, tmpPeriodTable, params, SumTypeFieldName);
        this.executeSQL(ctx, sql);
        sql = this.getRemoveTmpPeriodBeginSQL(ctx, tempTable);
        this.executeSQL(ctx, sql);
        sql = this.getPeriodHappen(ctx, tempTable, params, SumTypeFieldName);
        this.executeSQL(ctx, sql);
        sql = this.getRemoveTmpPeriodBeginSQL(ctx, tempTable);
        this.executeSQL(ctx, sql);
        String insertSQL = "INSERT INTO " + tempTable + newline;
        sqlAll.append(" Select 0 as FIndex,FCompanyOrgUnitID,FCompanyName,FYear,FPeriod,FMaterialID,FMaterialName,FMaterialNumber,").append(newline);
        sqlAll.append(" FMaterialModel,FKAClass,FBaseUnitName,FSumTypeID,FSumTypeName,sum(isnull(FBeginQty,0)),sum(isnull(FBeginAmount,0)),").append(newline);
        sqlAll.append(" sum(isnull(FInQty,0)),sum(isnull(FINAmount,0)),sum(isnull(FOutQty,0)),sum(isnull(FOutAmount,0)),").append(newline);
        sqlAll.append(" sum(isnull(FBeginQty,0)) + sum(isnull(FInQty,0)) - sum(isnull(FOutQty,0)) as FRemainQty ,").append(newline);
        sqlAll.append(" sum(isnull(FBeginAmount,0)) + sum(isnull(FINAmount,0)) - sum(isnull(FOutAmount,0)) as FRemainAmount ").append(newline);
        sqlAll.append(" From ").append(tempTable).append(newline);
        sqlAll.append(" T WHERE FINDEX = -1 Group by FCompanyOrgUnitID,FCompanyName,FYear,FPeriod,FMaterialID,FMaterialName,").append(newline);
        sqlAll.append(" FMaterialNumber,FMaterialModel,FKAClass,FBaseUnitName,FSumTypeID,FSumTypeName").append(newline);
        sqlAll.append(" having 1=1 ");
        if (params.getBoolean("filteNoINOut")) {
            sqlAll.append(" and (sum(isnull(FInQty,0))<>0 or sum(isnull(FOutQty,0)) <>0) ");
        }
        int endQtyFilter = params.getInt("endQtyFilter");
        String endfilterStr = "";
        if (endQtyFilter == 1) {
            endfilterStr = " and sum(isnull(FBeginQty,0)) + sum(isnull(FInQty,0)) - sum(isnull(FOutQty,0)) = 0 ";
        }
        if (endQtyFilter == 2) {
            endfilterStr = " and sum(isnull(FBeginQty,0)) + sum(isnull(FInQty,0)) - sum(isnull(FOutQty,0)) <> 0 ";
        }
        if (endQtyFilter == 3) {
            endfilterStr = " and sum(isnull(FBeginQty,0)) + sum(isnull(FInQty,0)) - sum(isnull(FOutQty,0)) > 0 ";
        }
        if (endQtyFilter == 4) {
            endfilterStr = " and sum(isnull(FBeginQty,0)) + sum(isnull(FInQty,0)) - sum(isnull(FOutQty,0)) < 0 ";
        }
        sqlAll.append(endfilterStr);
        return insertSQL + sqlAll.toString();
    }

    private String getPeriodBegin(Context ctx, String tempTable, String tmpPeriodTable, RptParams params, String SumTypeFieldName) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        int periodYear = 0;
        int periodNumber = 0;
        int count = 0;
        int it = 0;
        String cntSQL = null;
        cntSQL = "SELECT count(1) cnt FROM " + tmpPeriodTable;
        RptRowSet result = this.executeQuery(cntSQL, null, ctx);
        if (result.next()) {
            count = result.getInt("cnt");
        }
        String[] sqls = new String[count * 2];
        String selSQL = null;
        selSQL = "SELECT FCompanyOrgUnitID ,FYear, FPeriod FROM " + tmpPeriodTable;
        RptRowSet rs = this.executeQuery(selSQL, null, ctx);
        while (rs.next()) {
            periodYear = rs.getInt("FYear");
            periodNumber = rs.getInt("FPeriod");
            sql = new StringBuffer();
            sql.append(this.insertTotleInwarePeriodBefore(ctx, tempTable, params, periodYear, periodNumber, SumTypeFieldName));
            sqls[it] = sql.toString();
            sql = new StringBuffer();
            sql.append(this.insertTotleWFPeriodBefore(ctx, tempTable, params, periodYear, periodNumber, SumTypeFieldName));
            sqls[count + it] = sql.toString();
            ++it;
        }
        DBUtil.executeBatch((Context)ctx, (String[])sqls);
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO ").append(tempTable).append(newline);
        sql = new StringBuffer();
        sql.append(" SELECT -1 as FIndex, ");
        sql.append(" FCompanyOrgUnitID , ");
        sql.append(" FCompanyName, ");
        sql.append(" FYear as FYear, ");
        sql.append(" FPeriod as FPeriod, ");
        sql.append(" FMaterialID as FMaterialID, ");
        sql.append(" FMaterialName, ");
        sql.append(" FMaterialNumber, ");
        sql.append(" FMaterialModel, ");
        sql.append(" FKAClass, ");
        sql.append(" FBaseUnitName, ");
        sql.append(" FSUMTYPEID, ");
        sql.append(" FSUMTYPENAME, ");
        sql.append(" SUM(ISNULL(FInQty,0)-ISNULL(FOutQty,0)) as FBEGINQTY, ");
        sql.append(" SUM(ISNULL(FInAmount,0)- ISNULL(FOutAmount,0)) as FBEGINAMOUNT, ");
        sql.append("0 as FInQty, ");
        sql.append("0 as FINAMOUNT, ");
        sql.append("0 as FOUTQTY, ");
        sql.append("0 as FOUTAMOUNT, ");
        sql.append(" 0 as FREMAINQTY, ");
        sql.append(" 0 as FREMAINAMOUNT ");
        sql.append(" FROM ").append(tempTable).append(" ");
        sql.append(" WHERE FIndex = -2 ");
        sql.append(" GROUP BY FCompanyOrgUnitID,FCompanyName ,FYear, FPeriod,FMaterialID, FMaterialName, ");
        sql.append("   FMaterialNumber, FMaterialModel, FKAClass ,FBaseUnitName ,FSUMTYPEID, FSUMTYPENAME ");
        return insertSQL.append(sql).toString();
    }

    private StringBuffer insertTotleInwarePeriodBefore(Context ctx, String tempTable, RptParams params, int periodYear, int periodNumber, String SumTypeFieldName) throws BOSException {
        String groupstandard = null;
        MaterialGroupStandardInfo mgsInfo = null;
        Object obj = params.getObject("sumType");
        if (obj instanceof MaterialGroupStandardInfo && (mgsInfo = (MaterialGroupStandardInfo)params.getObject("sumType")) != null && mgsInfo.getId() != null) {
            groupstandard = mgsInfo.getId().toString();
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" INSERT INTO  ").append(tempTable).append(" \r\n ");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT -2 as FIndex, ");
        sql.append(" d.FCompanyOrgUnitID ,");
        sql.append(" com.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append(periodYear).append(" as FYear, ");
        sql.append(periodNumber).append(" as FPeriod, ");
        sql.append(" d.FMaterialID as FMaterialID, ");
        sql.append(" mt.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append(" mt.FNumber, ");
        sql.append(" mt.FModel, ");
        sql.append(" ka.FName_" + this.getLoc(ctx) + " as FKAClass, ");
        sql.append(" mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
        if (!StringUtils.isEmpty((String)SumTypeFieldName)) {
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("mcom.FCalculateType as FSumTypeID,");
                sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
                sql.append("d.FStorageOrgUnitID as FSumTypeID, ");
                sql.append("storage.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FWarehouse")) {
                sql.append("d.FWarehouseID as FSumTypeID, ");
                sql.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FKAClassfication")) {
                sql.append("mcom.FKAClassID as FSumTypeID, ");
                sql.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FSupplier")) {
                sql.append("d.FBalanceSupplierID as FSumTypeID,");
                sql.append("supplier.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
                sql.append("h.FAdminOrgUnitID as FSumTypeID,");
                sql.append("adminOrg.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else {
                sql.append("g.FID as FSumTypeID,");
                sql.append("g.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            }
        }
        sql.append("0 as FBEGINQTY, ");
        sql.append("0 as FBEGINAMOUNT, ");
        sql.append("sum(d.FBaseQty) as FInQty, ");
        sql.append("sum(d.FPurchaseCost) as FPurchaseCost, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainAmount ");
        sql.append("FROM T_IM_PurInWarehsBill h  ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry d ON h.FID = d.FParentID ");
        sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON d.FINVUPDATETYPEID = invUpdateType.FID ");
        sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
        sql.append("INNER JOIN T_ORG_Company com ON d.FCompanyOrgUnitID = com.FID ");
        sql.append("INNER JOIN T_BD_Material mt ON d.FMaterialID = mt.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON d.FBaseUnitID = mu.FID ");
        sql.append(" INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append(" INNER JOIN T_ORG_Storage storage ON h.FStorageOrgUnitID = storage.FID ");
        sql.append(" LEFT JOIN T_BD_Supplier supplier ON supplier.FID = d.FBalanceSupplierID ");
        sql.append(" LEFT JOIN T_BD_KAClassfication ka ON ka.FID = mcom.FKAClassID ");
        sql.append(" LEFT JOIN T_ORG_Admin adminOrg ON adminOrg.FID = h.FAdminOrgUnitID ");
        sql.append(" LEFT JOIN T_BD_MaterialGroupDetial as  MGD ON MGD.FMaterialID = mt.FID  ");
        sql.append(" LEFT JOIN T_BD_MaterialGroup as g ON g.FID = MGD.FMaterialGroupID  ");
        sql.append(" LEFT JOIN T_BD_MaterialGroupStandard as MGS ON MGS.FID = MGD.FMaterialGroupStandardID ");
        sql.append(" \r\n  ");
        sql.append("WHERE  1 = 1 ");
        sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
        if (groupstandard != null) {
            sql.append(" AND MGS.FID = '").append(groupstandard).append("' ");
        } else {
            sql.append(" AND MGS.FSTANDARDTYPE = 1 ");
        }
        sql.append(" AND (h.FYear*100+h.FPeriod < " + String.valueOf(periodYear * 100 + periodNumber) + ") ");
        sql.append(" AND  IsNull(d.FisPresent,0) = 0 ");
        sql.append(this.getInWareWhere(ctx, params).toString());
        sql.append(" GROUP BY d.FCompanyOrgUnitID,com.FName_" + this.getLoc(ctx) + " ,d.FMaterialID,mt.FName_" + this.getLoc(ctx) + ",mt.FNumber,");
        sql.append("          mt.FModel,ka.FName_" + this.getLoc(ctx) + " ,mu.FName_" + this.getLoc(ctx) + " ");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append(",mcom.FCalculateType ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append(",d.FStorageOrgUnitID,");
            sql.append("storage.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append(",d.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FSupplier")) {
            sql.append(",d.FBalanceSupplierID ,");
            sql.append("supplier.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
            sql.append(",h.FAdminOrgUnitID ,");
            sql.append("adminOrg.FName_" + this.getLoc(ctx));
        } else {
            sql.append(",g.FID, ");
            sql.append("g.FName_" + this.getLoc(ctx));
        }
        return insertSQL.append(sql);
    }

    private StringBuffer insertTotleWFPeriodBefore(Context ctx, String tempTable, RptParams params, int periodYear, int periodNumber, String SumTypeFieldName) throws BOSException {
        String groupstandard = null;
        MaterialGroupStandardInfo mgsInfo = null;
        Object obj = params.getObject("sumType");
        if (obj instanceof MaterialGroupStandardInfo && (mgsInfo = (MaterialGroupStandardInfo)params.getObject("sumType")) != null && mgsInfo.getId() != null) {
            groupstandard = mgsInfo.getId().toString();
        }
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(" INSERT INTO  ").append(tempTable).append(" \r\n ");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT -2 as FIndex, ");
        sql.append(" d.FCompanyOrgUnitID ,");
        sql.append(" com.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append(periodYear).append(" as FYear, ");
        sql.append(periodNumber).append(" as FPeriod, ");
        sql.append(" d.FMaterialID as FMaterialID, ");
        sql.append(" mt.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append(" mt.FNumber, ");
        sql.append(" mt.FModel, ");
        sql.append(" ka.FName_" + this.getLoc(ctx) + " as FKAClass, ");
        sql.append(" mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
        if (!StringUtils.isEmpty((String)SumTypeFieldName)) {
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("mcom.FCalculateType as FSumTypeID,");
                sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
                sql.append("pie.FStorageOrgUnitID as FSumTypeID, ");
                sql.append("storage.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FWarehouse")) {
                sql.append("pie.FWarehouseID as FSumTypeID, ");
                sql.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FKAClassfication")) {
                sql.append("mcom.FKAClassID as FSumTypeID, ");
                sql.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FSupplier")) {
                sql.append("d.FSupplierID as FSumTypeID,");
                sql.append("supplier.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
                sql.append("pi.FAdminOrgUnitID as FSumTypeID,");
                sql.append("adminOrg.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else {
                sql.append("g.FID as FSumTypeID,");
                sql.append("g.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            }
        }
        sql.append("0 as FBEGINQTY, ");
        sql.append("0 as FBEGINAMOUNT, ");
        sql.append("0 as FInQty, ");
        sql.append("0 as FPurchaseCost, ");
        sql.append("sum(d.FCurrWrittenOffQty) as FOutQty, ");
        sql.append("sum(d.FCurrWrittenOffAmount) as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainAmount ");
        sql.append("FROM T_CL_WriteOffGroup h  ");
        sql.append("INNER JOIN T_CL_WriteOffRecord d ON h.FID = d.FParentID ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry pie ON d.FBillEntryID = pie.FID ");
        sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON pie.FINVUPDATETYPEID = invUpdateType.FID ");
        sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
        if (SumTypeFieldName.equals("FAdminOrgUnit")) {
            sql.append("INNER JOIN T_IM_PurInWarehsBill pi ON pie.FParentID = pi.FID ");
            sql.append(" LEFT JOIN T_ORG_Admin adminOrg ON adminOrg.FID = pi.FAdminOrgUnitID ");
        }
        sql.append("INNER JOIN t_org_company com ON d.FCompanyOrgUnitID = com.FID ");
        sql.append("INNER JOIN T_BD_Material mt ON d.FMaterialID = mt.FID ");
        sql.append("INNER JOIN T_ORG_Storage storage ON pie.FStorageOrgUnitID = storage.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND d.FCompanyOrgUnitID = mcom.FCompanyID ");
        sql.append(" LEFT JOIN T_BD_KAClassfication ka ON ka.FID = mcom.FKAClassID ");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON d.FBaseUnitID = mu.FID ");
        sql.append("INNER JOIN t_db_warehouse wh ON pie.FWarehouseID = wh.FID ");
        sql.append(" LEFT JOIN T_BD_Supplier supplier ON d.FSupplierID = supplier.FID ");
        sql.append(" LEFT JOIN T_BD_MaterialGroupDetial as  MGD ON MGD.FMaterialID = mt.FID  ");
        sql.append(" LEFT JOIN T_BD_MaterialGroup as g ON g.FID = MGD.FMaterialGroupID  ");
        sql.append(" LEFT JOIN T_BD_MaterialGroupStandard as MGS ON MGS.FID = MGD.FMaterialGroupStandardID ");
        sql.append(" \r\n ");
        sql.append("WHERE  1 = 1  ");
        sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
        if (groupstandard != null) {
            sql.append(" AND MGS.FID = '").append(groupstandard).append("' ");
        } else {
            sql.append(" AND MGS.FSTANDARDTYPE = 1 ");
        }
        sql.append(" AND (h.FWriteOffYear*100+h.FWriteOffPeriod < " + String.valueOf(periodYear * 100 + periodNumber) + ") ");
        sql.append(this.getWFWhere(ctx, params).toString());
        sql.append(" AND d.FbillTypeNumber = '103' ");
        sql.append(" \r\n ");
        sql.append(" GROUP BY d.FCompanyOrgUnitID,com.FName_" + this.getLoc(ctx) + " ,d.FMaterialID,mt.FName_" + this.getLoc(ctx) + ",mt.FNumber,");
        sql.append("          mt.FModel,ka.FName_" + this.getLoc(ctx) + " ,mu.FName_" + this.getLoc(ctx) + " ");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append(",mcom.FCalculateType ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append(",pie.FStorageOrgUnitID,");
            sql.append("storage.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append(",pie.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FSupplier")) {
            sql.append(",d.FSupplierID ,");
            sql.append("supplier.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
            sql.append(",pi.FAdminOrgUnitID ,");
            sql.append("adminOrg.FName_" + this.getLoc(ctx));
        } else {
            sql.append(",g.FID, ");
            sql.append("g.FName_" + this.getLoc(ctx));
        }
        return insertSQL.append(sql);
    }

    private String getRemoveTmpPeriodBeginSQL(Context ctx, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + tempTable + " where FIndex = -2 \r\n");
        return sql.toString();
    }

    private StringBuffer getInWareWhere(Context ctx, RptParams params) throws BOSException {
        String supplierNumber;
        StringBuffer sqlWhere = new StringBuffer();
        String fiOrgUnitID = null;
        String warehouse = null;
        int voucher = -1;
        int status = -1;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        String MaterialFrom = null;
        String MaterialIn = null;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumberWithQuote(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialFrom")).getNumber() : params.getObject("materialFrom").toString();
            }
        }
        String MaterialTo = null;
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        if (params.getString("warehouse") != null) {
            warehouse = params.getString("warehouse");
        }
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        sqlWhere.append(" And ( h.FBaseStatus = 2 or h.FBaseStatus = 4) ");
        sqlWhere.append(" And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'");
        if (params.getString("storageOrgUnit") != null) {
            String storageNumber = params.getString("storageOrgUnit");
            sqlWhere.append(" AND storage.FNumber in(" + storageNumber + ") ");
        }
        if (warehouse != null) {
            sqlWhere.append(" AND wh.FNumber in(" + warehouse + ")");
        }
        if (params.getObject("supperFrom") != null) {
            if (params.getObject("supperFrom") instanceof Object[]) {
                Object[] suppliers = (Object[])params.getObject("supperFrom");
                if (suppliers.length == 1) {
                    sqlWhere.append(" AND supplier.FNumber >= '" + ((SupplierInfo)suppliers[0]).getNumber() + "' ");
                } else {
                    sqlWhere.append(" AND supplier.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(suppliers)).append(")");
                }
            } else {
                supplierNumber = ((SupplierInfo)params.getObject("supperFrom")).getNumber();
                sqlWhere.append(" AND supplier.FNumber >= '" + supplierNumber + "' ");
            }
        }
        if (params.getObject("supperTo") != null) {
            supplierNumber = ((SupplierInfo)params.getObject("supperTo")).getNumber();
            sqlWhere.append("  AND supplier.FNumber <= '" + supplierNumber + "' ");
        }
        if (MaterialFrom != null) {
            sqlWhere.append(" AND mt.FNumber >= '" + MaterialFrom + "' ");
        }
        if (MaterialTo != null) {
            sqlWhere.append(" AND mt.FNumber <= '" + MaterialTo + "' ");
        }
        if (MaterialIn != null) {
            sqlWhere.append(" AND mt.FNumber in (" + MaterialIn + ") ");
        }
        if (status == 2) {
            sqlWhere.append(" AND h.FBaseStatus = " + String.valueOf(status));
        } else if (status == 4) {
            sqlWhere.append(" AND h.FBaseStatus >= " + String.valueOf(status));
        }
        if (voucher != -1) {
            sqlWhere.append(" And h.ffiVouchered = ").append(voucher);
        }
        String materialTypeFrom = null;
        String materialTypeTo = null;
        boolean matFromIsLeaf = false;
        boolean matToIsLeaf = false;
        if (params.getObject("materialTypeFrom") != null) {
            materialTypeFrom = ((MaterialGroupInfo)params.getObject("materialTypeFrom")).getNumber();
            matFromIsLeaf = ((MaterialGroupInfo)params.getObject("materialTypeFrom")).isIsLeaf();
        }
        if (params.getObject("materialTypeTo") != null) {
            materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getNumber();
            matToIsLeaf = ((MaterialGroupInfo)params.getObject("materialTypeTo")).isIsLeaf();
        }
        if (materialTypeFrom != null || materialTypeTo != null) {
            String groupstandard = null;
            MaterialGroupStandardInfo mgsInfo = null;
            Object obj = params.getObject("sumType");
            if (obj instanceof MaterialGroupStandardInfo && (mgsInfo = (MaterialGroupStandardInfo)params.getObject("sumType")) != null && mgsInfo.getId() != null) {
                groupstandard = mgsInfo.getId().toString();
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("SELECT distinct flongnumber FROM t_bd_materialGroup WHERE 1=1 ");
            if (groupstandard != null && !"".equals(groupstandard)) {
                sql2.append(" AND Fgroupstandard = '").append(groupstandard).append("' ");
            }
            if (materialTypeFrom != null) {
                sql2.append(" AND fnumber >= '").append(materialTypeFrom).append("' ");
            }
            if (materialTypeTo != null) {
                sql2.append(" AND fnumber <= '").append(materialTypeTo).append("' ");
            }
            if (!(materialTypeFrom == null && materialTypeTo == null || matFromIsLeaf && matToIsLeaf)) {
                sql2.append(" AND fparentid is null");
            }
            RptRowSet rs = this.executeQuery(sql2.toString(), null, ctx);
            boolean rsFirst = true;
            StringBuffer sql3 = new StringBuffer();
            while (rs.next()) {
                if (!rsFirst) {
                    sql3.append(" or ");
                } else {
                    rsFirst = false;
                }
                sql3.append(" (g.flongnumber = '").append(rs.getString("flongnumber")).append("' ");
                sql3.append("or g.flongnumber like '").append(rs.getString("flongnumber")).append("!%') ");
            }
            if (!rsFirst) {
                sqlWhere.append(" and ( ").append(sql3).append(" ) ");
            } else {
                sqlWhere.append(" and 1 = 2 ");
            }
        }
        sqlWhere.append(" \r\n ");
        return sqlWhere;
    }

    private StringBuffer getWFWhere(Context ctx, RptParams params) throws BOSException {
        String supplierNumber;
        StringBuffer sqlWFWhere = new StringBuffer();
        String fiOrgUnitID = null;
        String warehouse = null;
        int voucher = -1;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        String MaterialFrom = null;
        String MaterialIn = null;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumberWithQuote(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialFrom")).getNumber() : params.getObject("materialFrom").toString();
            }
        }
        String MaterialTo = null;
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        if (params.getString("warehouse") != null) {
            warehouse = params.getString("warehouse");
        }
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        sqlWFWhere.append(" And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'");
        if (params.getString("storageOrgUnit") != null) {
            String storageNumber = params.getString("storageOrgUnit");
            sqlWFWhere.append(" AND storage.FNumber in(" + storageNumber + ") ");
        }
        if (warehouse != null) {
            sqlWFWhere.append(" AND wh.FNumber in(" + warehouse + ")");
        }
        if (params.getObject("supperFrom") != null) {
            if (params.getObject("supperFrom") instanceof Object[]) {
                Object[] suppliers = (Object[])params.getObject("supperFrom");
                if (suppliers.length == 1) {
                    sqlWFWhere.append(" AND supplier.FNumber >= '" + ((SupplierInfo)suppliers[0]).getNumber() + "' ");
                } else {
                    sqlWFWhere.append(" AND supplier.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(suppliers)).append(")");
                }
            } else {
                supplierNumber = ((SupplierInfo)params.getObject("supperFrom")).getNumber();
                sqlWFWhere.append(" AND supplier.FNumber >= '" + supplierNumber + "' ");
            }
        }
        if (params.getObject("supperTo") != null) {
            supplierNumber = ((SupplierInfo)params.getObject("supperTo")).getNumber();
            sqlWFWhere.append("  AND supplier.FNumber <= '" + supplierNumber + "' ");
        }
        if (MaterialFrom != null) {
            sqlWFWhere.append(" AND mt.FNumber >= '" + MaterialFrom + "' ");
        }
        if (MaterialTo != null) {
            sqlWFWhere.append(" AND mt.FNumber <= '" + MaterialTo + "' ");
        }
        if (MaterialIn != null) {
            sqlWFWhere.append(" AND mt.FNumber in (" + MaterialIn + ") ");
        }
        if (voucher != -1) {
            sqlWFWhere.append(" And h.ffiVouchered = ").append(voucher);
        }
        String materialTypeFrom = null;
        String materialTypeTo = null;
        boolean matFromIsLeaf = false;
        boolean matToIsLeaf = false;
        if (params.getObject("materialTypeFrom") != null) {
            materialTypeFrom = ((MaterialGroupInfo)params.getObject("materialTypeFrom")).getNumber();
            matFromIsLeaf = ((MaterialGroupInfo)params.getObject("materialTypeFrom")).isIsLeaf();
        }
        if (params.getObject("materialTypeTo") != null) {
            materialTypeTo = ((MaterialGroupInfo)params.getObject("materialTypeTo")).getNumber();
            matToIsLeaf = ((MaterialGroupInfo)params.getObject("materialTypeTo")).isIsLeaf();
        }
        if (materialTypeFrom != null || materialTypeTo != null) {
            String groupstandard = null;
            MaterialGroupStandardInfo mgsInfo = null;
            Object obj = params.getObject("sumType");
            if (obj instanceof MaterialGroupStandardInfo && (mgsInfo = (MaterialGroupStandardInfo)params.getObject("sumType")) != null && mgsInfo.getId() != null) {
                groupstandard = mgsInfo.getId().toString();
            }
            StringBuffer sql2 = new StringBuffer();
            sql2.append("SELECT flongnumber FROM t_bd_materialGroup WHERE 1=1  ");
            if (groupstandard != null && !"".equals(groupstandard)) {
                sql2.append(" AND Fgroupstandard = '").append(groupstandard).append("' ");
            }
            if (materialTypeFrom != null) {
                sql2.append(" AND fnumber >= '").append(materialTypeFrom).append("' ");
            }
            if (materialTypeTo != null) {
                sql2.append(" AND fnumber <= '").append(materialTypeTo).append("' ");
            }
            if (!(materialTypeFrom == null && materialTypeTo == null || matFromIsLeaf && matToIsLeaf)) {
                sql2.append(" AND fparentid is null");
            }
            RptRowSet rs = this.executeQuery(sql2.toString(), null, ctx);
            boolean rsFirst = true;
            StringBuffer sql3 = new StringBuffer();
            while (rs.next()) {
                if (!rsFirst) {
                    sql3.append(" or ");
                } else {
                    rsFirst = false;
                }
                sql3.append(" (g.flongnumber = '").append(rs.getString("flongnumber")).append("' ");
                sql3.append("or g.flongnumber like '").append(rs.getString("flongnumber")).append("!%') ");
            }
            if (!rsFirst) {
                sqlWFWhere.append(" and ( ").append(sql3).append(" ) ");
            } else {
                sqlWFWhere.append(" and 1 = 2 ");
            }
        }
        sqlWFWhere.append(" \r\n ");
        return sqlWFWhere;
    }

    private String getPeriodHappen(Context ctx, String tempTable, RptParams params, String SumTypeFieldName) throws BOSException, EASBizException {
        int status = -1;
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        String groupstandard = null;
        MaterialGroupStandardInfo mgsInfo = null;
        Object obj = params.getObject("sumType");
        if (obj instanceof MaterialGroupStandardInfo && (mgsInfo = (MaterialGroupStandardInfo)params.getObject("sumType")) != null && mgsInfo.getId() != null) {
            groupstandard = mgsInfo.getId().toString();
        }
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int periodMTo = params.getInt("accPeriodMonthTo");
        StringBuffer sqlWhere = new StringBuffer();
        StringBuffer sqlWFWhere = new StringBuffer();
        sqlWhere.append(this.getInWareWhere(ctx, params));
        sqlWFWhere.append(this.getWFWhere(ctx, params));
        String insertSQL = "INSERT INTO " + tempTable + newline;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT -2 as FIndex, ");
        sql.append(" d.FCompanyOrgUnitID ,");
        sql.append(" com.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append(" h.FYear as FYear, ");
        sql.append(" h.FPeriod as FPeriod, ");
        sql.append(" d.FMaterialID as FMaterialID, ");
        sql.append(" mt.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append(" mt.FNumber, ");
        sql.append(" mt.FModel, ");
        sql.append(" ka.FName_" + this.getLoc(ctx) + " as FKAClass, ");
        sql.append(" mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
        if (SumTypeFieldName != null || !"".equals(SumTypeFieldName)) {
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("mcom.FCalculateType as FSumTypeID,");
                sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
                sql.append("d.FStorageOrgUnitID as FSumTypeID, ");
                sql.append("storage.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FWarehouse")) {
                sql.append("d.FWarehouseID as FSumTypeID, ");
                sql.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FKAClassfication")) {
                sql.append("mcom.FKAClassID as FSumTypeID, ");
                sql.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FSupplier")) {
                sql.append("d.FBalanceSupplierID as FSumTypeID,");
                sql.append("supplier.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
                sql.append("h.FAdminOrgUnitID as FSumTypeID,");
                sql.append("adminOrg.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            } else {
                sql.append("g.FID as FSumTypeID,");
                sql.append("g.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
            }
        }
        sql.append("0 as FBEGINQTY, ");
        sql.append("0 as FBEGINAMOUNT, ");
        sql.append("sum(d.FBaseQty) as FInQty, ");
        sql.append("sum(d.FPurchaseCost) as FInAmount, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainAmount ");
        sql.append("FROM T_IM_PurInWarehsBill h  ");
        sql.append("INNER JOIN T_IM_PurInWarehsEntry d ON h.FID = d.FParentID ");
        sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON d.FINVUPDATETYPEID = invUpdateType.FID ");
        sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
        sql.append("INNER JOIN T_ORG_Company com ON d.FCompanyOrgUnitID = com.FID ");
        sql.append("INNER JOIN T_BD_Material mt ON d.FMaterialID = mt.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON d.FBaseUnitID = mu.FID ");
        sql.append(" INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append(" INNER JOIN T_ORG_Storage storage ON h.FStorageOrgUnitID = storage.FID ");
        sql.append(" LEFT JOIN T_BD_Supplier supplier ON supplier.FID = d.FBalanceSupplierID ");
        sql.append(" LEFT JOIN T_BD_KAClassfication ka ON ka.FID = mcom.FKAClassID ");
        sql.append(" LEFT JOIN T_ORG_Admin adminOrg ON adminOrg.FID = h.FAdminOrgUnitID ");
        sql.append(" LEFT JOIN T_BD_MaterialGroupDetial as  MGD ON MGD.FMaterialID = mt.FID  ");
        sql.append(" LEFT JOIN T_BD_MaterialGroup as g ON g.FID = MGD.FMaterialGroupID  ");
        sql.append(" LEFT JOIN T_BD_MaterialGroupStandard as MGS ON MGS.FID = MGD.FMaterialGroupStandardID ");
        sql.append(" \r\n  ");
        sql.append("WHERE  1 = 1 ");
        sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
        if (groupstandard != null) {
            sql.append(" AND MGS.FID = '").append(groupstandard).append("' ");
        } else {
            sql.append(" AND MGS.FSTANDARDTYPE = 1 ");
        }
        sql.append(" AND h.FYear*100 + h.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FYear*100 + h.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo));
        sql.append(" AND  IsNull(d.FisPresent,0) = 0 ");
        sql.append(this.getInWareWhere(ctx, params).toString());
        sql.append(" GROUP BY d.FCompanyOrgUnitID,com.FName_" + this.getLoc(ctx) + " ,h.FYear,h.FPeriod,d.FMaterialID,mt.FName_" + this.getLoc(ctx) + ",mt.FNumber,");
        sql.append("          mt.FModel,ka.FName_" + this.getLoc(ctx) + " ,mu.FName_" + this.getLoc(ctx) + " ");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append(",mcom.FCalculateType ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append(",d.FStorageOrgUnitID,");
            sql.append("storage.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append(",d.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FSupplier")) {
            sql.append(",d.FBalanceSupplierID ,");
            sql.append("supplier.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
            sql.append(",h.FAdminOrgUnitID ,");
            sql.append("adminOrg.FName_" + this.getLoc(ctx));
        } else {
            sql.append(",g.FID, ");
            sql.append("g.FName_" + this.getLoc(ctx));
        }
        this.executeSQL(ctx, insertSQL + sql.toString());
        if (status == 4) {
            sql = new StringBuffer();
            sql.append("SELECT -2 as FIndex, ");
            sql.append(" d.FCompanyOrgUnitID ,");
            sql.append(" com.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
            sql.append(" h.FWriteOffYear as FYear, ");
            sql.append(" h.FWriteOffPeriod as FPeriod, ");
            sql.append(" d.FMaterialID as FMaterialID, ");
            sql.append(" mt.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
            sql.append(" mt.FNumber, ");
            sql.append(" mt.FModel, ");
            sql.append(" ka.FName_" + this.getLoc(ctx) + " as FKAClass, ");
            sql.append(" mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
            if (SumTypeFieldName != null || !"".equals(SumTypeFieldName)) {
                if (SumTypeFieldName.equals("FCalculateType")) {
                    sql.append("mcom.FCalculateType as FSumTypeID,");
                    sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
                } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
                    sql.append("pie.FStorageOrgUnitID as FSumTypeID, ");
                    sql.append("storage.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
                } else if (SumTypeFieldName.equals("FWarehouse")) {
                    sql.append("pie.FWarehouseID as FSumTypeID, ");
                    sql.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
                } else if (SumTypeFieldName.equals("FKAClassfication")) {
                    sql.append("mcom.FKAClassID as FSumTypeID, ");
                    sql.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
                } else if (SumTypeFieldName.equals("FSupplier")) {
                    sql.append("d.FSupplierID as FSumTypeID,");
                    sql.append("supplier.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
                } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
                    sql.append("pi.FAdminOrgUnitID as FSumTypeID,");
                    sql.append("adminOrg.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
                } else {
                    sql.append("g.FID as FSumTypeID,");
                    sql.append("g.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
                }
            }
            sql.append("0 as FBEGINQTY, ");
            sql.append("0 as FBEGINAMOUNT, ");
            sql.append("0 as FInQty, ");
            sql.append("0 as FPurchaseCost, ");
            sql.append("sum(d.FCurrWrittenOffQty) as FOutQty, ");
            sql.append("sum(d.FCurrWrittenOffAmount) as FOutAmount, ");
            sql.append("0 as FRemainQty, ");
            sql.append("0 as FRemainAmount ");
            sql.append("FROM T_CL_WriteOffRecord d  ");
            sql.append("INNER JOIN T_CL_writeoffGroup h ON h.FID = d.FparentID ");
            sql.append("INNER JOIN T_IM_PurInWarehsEntry pie ON d.FBillEntryID = pie.FID ");
            sql.append("inner JOIN T_IM_INVUPDATETYPE invUpdateType ON pie.FINVUPDATETYPEID = invUpdateType.FID ");
            sql.append("inner JOIN T_IM_STORETYPE storeType ON storeType.FID = invUpdateType.FSTORETYPEID ");
            sql.append("INNER JOIN T_IM_PurInWarehsBill pi ON pie.FParentID = pi.FID ");
            sql.append("INNER JOIN t_org_company com ON d.FCompanyOrgUnitID = com.FID ");
            sql.append("INNER JOIN T_BD_Material mt ON d.FMaterialID = mt.FID ");
            sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND d.FCompanyOrgUnitID = mcom.FCompanyID ");
            sql.append("INNER JOIN T_BD_MeasureUnit mu ON d.FBaseUnitID = mu.FID ");
            sql.append("INNER JOIN T_ORG_Storage storage ON pie.FStorageOrgUnitID = storage.FID ");
            sql.append("INNER JOIN t_db_warehouse wh ON pie.FWarehouseID = wh.FID ");
            sql.append(" LEFT JOIN T_BD_Supplier supplier ON d.FSupplierID = supplier.FID ");
            sql.append(" LEFT JOIN T_BD_KAClassfication ka ON ka.FID = mcom.FKAClassID ");
            sql.append(" LEFT JOIN T_ORG_Admin adminOrg ON adminOrg.FID = pi.FAdminOrgUnitID ");
            sql.append(" LEFT JOIN T_BD_MaterialGroupDetial as  MGD ON MGD.FMaterialID = mt.FID  ");
            sql.append(" LEFT JOIN T_BD_MaterialGroup as g ON g.FID = MGD.FMaterialGroupID  ");
            sql.append(" LEFT JOIN T_BD_MaterialGroupStandard as MGS ON MGS.FID = MGD.FMaterialGroupStandardID ");
            sql.append(" \r\n ");
            sql.append("WHERE  1 = 1  ");
            sql.append(" and invUpdateType.FEXISTINGQTY = 1 and storeType.FISFORWARDAMT = 1 ");
            if (groupstandard != null) {
                sql.append(" AND MGS.FID = '").append(groupstandard).append("' ");
            } else {
                sql.append(" AND MGS.FSTANDARDTYPE = 1 ");
            }
            sql.append(" AND h.FWriteOffYear*100 + h.FWriteOffPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FWriteOffYear*100 + h.FWriteOffPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo));
            sql.append(sqlWFWhere.toString());
            sql.append(" AND d.FbillTypeNumber = '103' ");
            sql.append(" \r\n ");
            sql.append(" GROUP BY d.FCompanyOrgUnitID,com.FName_" + this.getLoc(ctx) + " ,h.FWriteOffYear,h.FWriteOffPeriod,d.FMaterialID,mt.FName_" + this.getLoc(ctx) + ",mt.FNumber,");
            sql.append("          mt.FModel,ka.FName_" + this.getLoc(ctx) + " ,mu.FName_" + this.getLoc(ctx) + " ");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append(",mcom.FCalculateType ");
            } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
                sql.append(",pie.FStorageOrgUnitID,");
                sql.append("storage.FName_" + this.getLoc(ctx));
            } else if (SumTypeFieldName.equals("FWarehouse")) {
                sql.append(",pie.FWarehouseID,");
                sql.append("wh.FName_" + this.getLoc(ctx));
            } else if (SumTypeFieldName.equals("FKAClassfication")) {
                sql.append(",mcom.FKAClassID,");
                sql.append("ka.FName_" + this.getLoc(ctx));
            } else if (SumTypeFieldName.equals("FSupplier")) {
                sql.append(",d.FSupplierID ,");
                sql.append("supplier.FName_" + this.getLoc(ctx));
            } else if (SumTypeFieldName.equals("FAdminOrgUnit")) {
                sql.append(",pi.FAdminOrgUnitID ,");
                sql.append("adminOrg.FName_" + this.getLoc(ctx));
            } else {
                sql.append(",g.FID, ");
                sql.append("g.FName_" + this.getLoc(ctx));
            }
            this.executeSQL(ctx, insertSQL + sql.toString());
        }
        sql = new StringBuffer();
        sql.append("SELECT -1 as FIndex, ");
        sql.append(" FCompanyOrgUnitID , ");
        sql.append(" FCompanyName, ");
        sql.append(" FYear as FYear, ");
        sql.append(" FPeriod as FPeriod, ");
        sql.append(" FMaterialID as FMaterialID, ");
        sql.append(" FMaterialName, ");
        sql.append(" FMaterialNumber, ");
        sql.append(" FMaterialModel, ");
        sql.append(" FKAClass, ");
        sql.append(" FBaseUnitName, ");
        sql.append(" FSUMTYPEID, ");
        sql.append(" FSUMTYPENAME, ");
        sql.append(" 0 as FBEGINQTY, ");
        sql.append(" 0 as FBEGINAMOUNT, ");
        sql.append("sum(FInQty) as FInQty, ");
        sql.append("sum(FInAmount) as FInAmount, ");
        sql.append("sum(FOutQty) as FOutQty, ");
        sql.append("sum(FOutAmount) as FOutAmount, ");
        sql.append(" 0 as FREMAINQTY, ");
        sql.append(" 0 as FREMAINAMOUNT ");
        sql.append(" FROM ").append(tempTable).append(" ");
        sql.append(" WHERE FIndex = -2 ");
        sql.append(" GROUP BY FCompanyOrgUnitID,FCompanyName ,FYear, FPeriod,FMaterialID,FMaterialName, ");
        sql.append("   FMaterialNumber, FMaterialModel,FKAClass , FBaseUnitName , FSUMTYPEID, FSUMTYPENAME");
        return insertSQL + sql.toString();
    }

    private String getRemoveTmpPeriodHappenSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from " + tempTable + " where FIndex = -1 \r\n");
        return sql.toString();
    }

    private String getPeriodHappenTotal(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FKAClass,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT  ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT) \r\n");
        sql.append("Select 1,null,FCompanyName,FYear,FPeriod,null,null,null,null,null,null,FSUMTYPEID,FSumTypeName || '" + SCMUtils.getResource((String)this.res, (String)"TOTAL", (Context)ctx) + "',");
        sql.append("sum(FBeginQty),sum(FBeginAmount),sum(FInQty),sum(FInAmount),sum(FOutQty),sum(FOutAmount),sum(FRemainQty),Sum(FRemainAmount) ");
        sql.append("From " + tempTable + " \r\n");
        sql.append("Where FIndex = 0 Group By FCompanyName,FYear,FPeriod,FSUMTYPEID,FSumTypeName");
        return sql.toString();
    }

    private String getPeriodTotal(Context ctx, String tempTable, String SumTypeFieldName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FKAClass,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
        sql.append(" Select 2 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
        sql.append("FYear,FPeriod,\r\n");
        sql.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
        sql.append("' ' as FMaterialNumber,' ' as FMaterialModel,\r\n");
        sql.append("' ' as FKAClass,' ' as FBaseUnitName,\r\n");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"PERIODTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("sum(FBeginQty) as FBeginQty,sum(FBeginAmount) as FBeginAmount,\r\n");
        sql.append("sum(FInQty) as FInQty,Sum(FInAmount)as FInAmount,\r\n");
        sql.append("Sum(FOutQty) as FOutQty,Sum(FOutAmount) as FOutAmount,\r\n");
        sql.append("sum(FRemainQty) as FRemainQty,sum(FRemainAmount) as FRemainAmount \r\n");
        sql.append("From " + tempTable + newline);
        sql.append("Where FIndex=1 \r\n");
        sql.append("Group By FYear,FPeriod \r\n");
        return sql.toString();
    }

    private void getYearTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, int endYear, int endPeroid, String SumTypeFieldName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber,FMaterialModel,FKAClass,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
        sql.append("Select 3 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
        sql.append(beginYear).append(" as FYear, \r\n");
        sql.append("0 as FPeriod, \r\n");
        sql.append("' ' as FMaterialID,' ' as FMaterialName, \r\n");
        sql.append("' ' as FMaterialNumber,' ' as FMaterialModel, \r\n");
        sql.append("' ' as FKAClass ,' ' as FBaseUnitName, \r\n");
        if ("FCalculateType".equals(SumTypeFieldName)) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("sum(isnull(FBeginQty,0)),sum(isnull(FBeginAmount,0)),\r\n");
        sql.append("0 as FInQty,0 as FInAmount,\r\n");
        sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
        sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
        sql.append("From " + tempTable + newline);
        sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + newline);
        this.executeSQL(ctx, sql.toString());
        if (endYear > beginYear) {
            sql = new StringBuffer();
            sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FKAClass,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
            sql.append("Select 3 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
            sql.append("FYear, 0 as FPeriod,\r\n");
            sql.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
            sql.append("' ' as FMaterialNumber,' ' as FMaterialModel,\r\n");
            sql.append("' ' AS FKAClass,' ' as FBaseUnitName,\r\n");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("0 as FSumTypeID, ");
            } else {
                sql.append("' ' as FSumTypeID, ");
            }
            sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + newline);
            sql.append("Where FIndex=2 And FYear>" + String.valueOf(beginYear) + " And FPeriod=1\r\n");
            this.executeSQL(ctx, sql.toString());
        }
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set(FInQty,FInAmount,FOutQty,FOutAmount)=\r\n");
        sql.append(" (Select FInTotalQty,FInTotalAmount,FOutTotalQty,FOutTotalAmount From \r\n");
        sql.append(" \t(Select FYear as FYear, \r\n");
        sql.append(" \t\t\tSum(T1.FInQty) as FInTotalQty ,Sum(T1.FInAmount) as FInTotalAmount,\r\n");
        sql.append(" \t\t\tSum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutAmount) as\t FOutTotalAmount\r\n");
        sql.append(" \tFrom " + tempTable + " T1 \r\n");
        sql.append(" \tWhere T1.FIndex=2 \r\n");
        sql.append(" \tGroup By T1.FYear) as i \r\n");
        sql.append(" Where i.FYear = " + tempTable + ".FYear and " + tempTable + ".FIndex=3 )");
        sql.append(" WHERE FIndex=3 ");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FRemainQty = isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FRemainAmount=isnull(FBeginAmount,0)+isnull(FInAmount,0)-isnull(FOutAmount,0) ");
        sql.append("Where FIndex=3  \r\n");
        this.executeSQL(ctx, sql.toString());
    }

    private void getAllTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, String SumTypeFieldName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FKAClass,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
        sql.append("Select 4 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
        sql.append("0 as FYear, 0 FPeriod,\r\n");
        sql.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
        sql.append("' ' as FMaterialNumber,' ' as FMaterialModel,\r\n");
        sql.append("' ' AS FKAClass,' ' as FBaseUnitName,\r\n");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"SUMALL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("sum(isnull(FBeginQty,0)),sum(isnull(FBeginAmount,0)),\r\n");
        sql.append("0 as FInQty,0 as FInAmount,\r\n");
        sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
        sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
        sql.append("From " + tempTable + newline);
        sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + newline);
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTable + " AS T3 Set(FInQty,FInAmount,FOutQty,FOutAmount)=\r\n");
        sql.append("    (Select FInTotalQty,FInTotalAmount,FOutTotalQty,FOutTotalAmount From \r\n");
        sql.append("       (Select 4 as FIndex, Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInAmount) as FInTotalAmount, \r\n");
        sql.append("       \t\t   Sum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutAmount) as FOutTotalAmount \r\n");
        sql.append("        From " + tempTable + " T1 \r\n");
        sql.append("        Where T1.FIndex=3 )\r\n");
        sql.append("    i," + tempTable + " T2 \r\n");
        sql.append("    Where i.Findex = T2.FIndex and T2.FIndex=4)  \r\n");
        sql.append(" Where T3.FIndex=4\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTable + " Set ");
        sql.append("FRemainQty=isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FRemainAmount=isnull(FBeginAmount,0)+isnull(FInAmount,0)-isnull(FOutAmount,0) ");
        sql.append("Where FIndex=4 ");
        this.executeSQL(ctx, sql.toString());
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String precisionSql = "select max(material.fpriceprecision),max(fqtyprecision) from t_bd_material material  left join T_BD_MultiMeasureUnit unit on material.fid = unit.fmaterialId and material.fbaseUnit=unit.FMeasureUnitID  where material.fid in (select fmaterialid from " + params.getString("tempTable") + ")";
        RptRowSet rsPrecision = this.executeQuery(precisionSql, null, ctx);
        int pricePrecision = 8;
        int qtyPrecision = 8;
        if (rsPrecision.next() && rsPrecision.getObject(0) != null && rsPrecision.getObject(1) != null) {
            pricePrecision = rsPrecision.getInt(0);
            qtyPrecision = rsPrecision.getInt(1);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        RptParams pp = new RptParams();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tmp.FCompanyName,tmp.FYear,tmp.FPeriod,");
        sql.append("tmp.FSumTypeName,");
        sql.append("tmp.FMaterialNumber,tmp.FMATERIALNAME ,tmp.FMaterialModel,tmp.FKAClass,tmp.FBASEUNITNAME,round(tmp.FBeginQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end),");
        sql.append("( Case when isnull(tmp.FBeginQty,0)=0 then Null else round(to_decimal(tmp.FBeginAmount/tmp.FBeginQty, 21, 8), case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FBeginPrice,");
        sql.append("round(tmp.FBeginAmount,").append(amtPrecision).append("),round(tmp.FInQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end),(Case when isnull(tmp.FInQty,0)=0 then Null else round(to_decimal(tmp.FInAmount/tmp.FInQty, 21, 8),case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FInPrice,");
        sql.append("round(tmp.FInAmount,").append(amtPrecision).append("),round(tmp.FOutQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end),(Case when isnull(tmp.FOutQty,0)=0 then Null else round(to_decimal(tmp.FOutAmount/tmp.FOutQty, 21, 8),case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FOutPrice,");
        sql.append("round(tmp.FOutAmount,").append(amtPrecision).append("),round(tmp.FRemainQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end),(Case when isnull(tmp.FRemainQty,0)=0 then Null else round(to_decimal(tmp.FRemainAmount/tmp.FRemainQty, 21, 8),case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FRemainPrice,");
        sql.append("round(tmp.FRemainAmount,").append(amtPrecision).append("),tmp.FSumTypeID,tmp.FMaterialID,tmp.FIndex,tmp.FCompanyOrgUnitID,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end as fqtyprecision,case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end as fpriceprecision FROM " + params.getString("tempTable") + " as tmp ");
        sql.append("left join t_bd_material material on tmp.fmaterialid = material.fid left join T_BD_MultiMeasureUnit unit on material.fid = unit.fmaterialId and material.fbaseUnit=unit.FMeasureUnitID ");
        if (params.getBoolean("onlyViewSumRow")) {
            sql.append(" Where tmp.Findex<>0 ");
        }
        if (from == 0) {
            String countSql = "select count(1) from " + params.getString("tempTable");
            if (params.getBoolean("onlyViewSumRow")) {
                countSql = countSql + " Where Findex<>0 ";
            }
            RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
            rsCount.next();
            int count = rsCount.getInt(0);
            pp.setInt("totalCount", count);
        }
        String SumTypeFieldName = "";
        if (params.getObject("sumType") != null) {
            Object obj = params.getObject("sumType");
            if (obj instanceof SumTypeEnum) {
                SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
            } else if (obj instanceof SumTypeExEnum) {
                SumTypeFieldName = ((SumTypeExEnum)((Object)params.getObject("sumType"))).getValue().toString();
            } else if (obj instanceof MaterialGroupStandardInfo) {
                SumTypeFieldName = ((MaterialGroupStandardInfo)params.getObject("sumType")).getId().toString();
            }
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append(" Order By isnull(tmp.FYear,2099) ,isnull(tmp.FPeriod,99),isnull(tmp.FSUMTYPEID,9),tmp.FIndex,tmp.FMaterialNumber ");
            } else {
                sql.append(" Order By isnull(tmp.FYear,2099) ,isnull(tmp.FPeriod,99),isnull(tmp.FSUMTYPEID,'zzzzzzzzzz'),tmp.FIndex,tmp.FMaterialNumber ");
            }
        }
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private long GetNowTime() {
        Date d = new Date();
        return d.getTime();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }
}

