/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CalculateReportFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateReportFacade;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractExceptionBillQueryFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.AbsShareSqlGenerator;
import com.kingdee.eas.scm.cal.app.calculate.ExceptionBilQueryGenertorSQL;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.app.thread.QueryDataSyncLock;
import com.kingdee.eas.scm.framework.app.thread.QueryDataTask;
import com.kingdee.eas.scm.framework.app.thread.ThreadPool;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ExceptionBillQueryFacadeControllerBean
extends AbstractExceptionBillQueryFacadeControllerBean {
    private static final long serialVersionUID = 1372422182378084341L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.ExceptionBillQueryFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTableName = params.getString("tempTable");
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)aCompanyOrgUnitInfo.getId().toString(), (String)"exceptionBillQuery_view");
        if (params.getObject("PRICE_ENUM") == null) {
            this.dropTempTable(params.getString("tempTable"), ctx);
            int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
            params.setInt("amtPrecision", amtPrecision);
            tempTableName = DBUtil.createTempTable(ctx, this.getCreateTempTableSQL(ctx, "ExpBillQuery"));
            DBUtil.createTempTableIndex(ctx, tempTableName, "FID", true);
            DBUtil.createTempTableIndex(ctx, tempTableName, "FMaterialID", false);
            if (checkPermission) {
                LowTimer t = new LowTimer();
                this.insertBillData(ctx, tempTableName, params);
                this.updateCalProperty(ctx, tempTableName);
                logger.debug((Object)("\u51c6\u5907\u6570\u636e\u5171\u8017\u65f6(ms):" + t.msValue()));
            }
        } else if (checkPermission) {
            int calType = 0;
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            String paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(params.getString("COMPANY_ID")), "SCM_CAL_002");
            if (!StringUtil.isEmpty((String)paramValue)) {
                calType = Integer.parseInt(paramValue);
            }
            params.setInt("SUMCONDITION", calType);
            ICalculateReportFacade icalculateRpt = CalculateReportFacadeFactory.getLocalInstance(ctx);
            icalculateRpt.verdictGetDaulPrice(params, tempTableName);
            String totalName = ResourceBase.getString((String)"com.kingdee.eas.scm.cal.invdep.InvdepResource", (String)"Total", (Locale)ctx.getLocale());
            StringBuffer updateSumSql = new StringBuffer();
            updateSumSql.append(" update " + tempTableName + " set Factualcost =  ");
            updateSumSql.append(" (select sum(Factualcost) from " + tempTableName + " where fid is not null)");
            updateSumSql.append(" where FTRANSACTIONNAME = ? ");
            DbUtil.execute((Context)ctx, (String)updateSumSql.toString(), (Object[])new Object[]{totalName});
        }
        RptParams result = new RptParams();
        result.setObject("header", (Object)this.createTableHeader(ctx, tempTableName));
        result.setString("tempTable", tempTableName);
        String countSql = "select count(1) cc from " + tempTableName;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        result.setInt("RecordCount", count);
        return result;
    }

    private void updateCalProperty(Context ctx, String tempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTableName).append(" T set(");
        sql.append(" FLot,FAssistPropertyID,FAssistPropertyName,");
        sql.append(" FProjectID,FProjectName,FProjectNumber,");
        sql.append(" FTrackNumberID,FTrackNumberName,FTrackNumberNumber ) = (");
        sql.append(" select ");
        sql.append(" case when MC.FISLOT = 1 then temp.FInvLot else null end , ");
        sql.append(" case when MC.FISASSISTPROPERTY = 1 then temp.FInvAssistPropertyID else null end , ");
        sql.append(" case when MC.FISASSISTPROPERTY = 1 then temp.FInvAssistPropertyName else null end , ");
        sql.append(" case when MC.FISPROJECT = 1 then temp.FInvProjectID else null end, ");
        sql.append(" case when MC.FISPROJECT = 1 then temp.FInvProjectName else null end, ");
        sql.append(" case when MC.FISPROJECT = 1 then temp.FInvProjectNumber else null end, ");
        sql.append(" case when MC.FISTRACKNUMBER = 1 then temp.FInvTrackNumberID else null end, ");
        sql.append(" case when MC.FISTRACKNUMBER = 1 then temp.FInvTrackNumberName else null end, ");
        sql.append(" case when MC.FISTRACKNUMBER = 1 then temp.FInvTrackNumberNumber else null end ");
        sql.append(" From  ").append(tempTableName).append(" temp ");
        sql.append(" inner join T_bd_materialCompanyInfo MC on temp.FMaterialID = MC.FMaterialID ");
        sql.append(" and temp.FCompanyOrgUnitID = MC.FCOMPANYID where T.fid = temp.fid )");
        this.executeUpdate(sql.toString(), null, ctx);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String tempTableName = params.getString("tempTable");
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT '' AS SELECTED,T1.FBizTypeName,T1.FBillTypeName,T1.FTransactionName,T1.FisPresent,T1.FBillNumber,T1.FBizDate,T1.FStorageName,T1.FWarehouseName,");
        sqlBuffer.append("T1.FMaterialNumber,T1.FMaterialName,T1.FModel,T1.FUnitName,T1.FQty,");
        sqlBuffer.append("CASE WHEN T1.FSeq = 99 THEN 0 ");
        sqlBuffer.append(" WHEN T1.FUnitId = T1.FBaseUnitId THEN T1.FActualBaseUnitCost ");
        sqlBuffer.append(" WHEN T1.FQty = 0 THEN 0 ");
        sqlBuffer.append(" ELSE Round(To_decimal(To_decimal(T1.FActualCost,19,4)/T1.FQty, 21,8),T1.FPricePrecision) ");
        sqlBuffer.append("END as FActualBaseUnitCost, ");
        sqlBuffer.append("T1.FActualCost,T1.FUnitStandardCost,T1.FStandardCost,T1.FBaseUnitName,T1.FBaseQty,");
        sqlBuffer.append("T1.FInvLot,T1.FInvAssistPropertyName,T1.FInvProjectName,T1.FInvProjectNumber,T1.FInvTrackNumberName,T1.FInvTrackNumberNumber,");
        sqlBuffer.append("T1.FMaterialId,T1.FUnitId,T1.FQtyPrecision,T1.FBaseQtyPrecision,T1.FPricePrecision,T1.FBillTypeId,T1.FBillId,T1.FLocalCurrencyPrecision, ");
        sqlBuffer.append("T1.FCompanyOrgUnitID,T1.FBaseUnitId,T1.FBillEntryID, ");
        sqlBuffer.append("T1.FInvAssistPropertyID,T1.FInvProjectID,T1.FInvTrackNumberID ");
        sqlBuffer.append("\n FROM ").append(tempTableName).append(" AS T1 ");
        sqlBuffer.append("\n ORDER BY T1.FSeq asc ,T1.FBizDate desc,T1.FBillNumber, T1.FBILLTYPENAME,T1.FBillEntryId");
        LowTimer t = new LowTimer();
        RptRowSet rs = this.executeQuery(sqlBuffer.toString(), null, from, len, ctx);
        logger.debug((Object)("\u5f02\u5e38\u6570\u636e\u67e5\u8be2\u5171\u8017\u65f6(ms):" + t.msValue()));
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        if (params.getBoolean("reCalcCount")) {
            RptRowSet rsCount = this.executeQuery("select count(*) count from " + tempTableName, null, ctx);
            while (rsCount.next()) {
                pp.setInt("RecordCount", rsCount.getInt("count"));
            }
        }
        return pp;
    }

    private void insertBillData(Context ctx, String tempTableName, RptParams params) throws BOSException, EASBizException {
        Connection conn = null;
        String midTmpTable = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            midTmpTable = DBUtil.createTempTable(ctx, this.getCreateMidTmpTableSQL(ctx, "MidExpBillQuery"));
            ExceptionBilQueryGenertorSQL sqlGenertor = this.buildBillQuerySQL(ctx, params);
            List<String> billelectSQLList = null;
            billelectSQLList = params.getObject("billType") != null ? this.getExceptionBills(params.getObject("billType"), sqlGenertor) : this.getSelectAllBillSQLList(sqlGenertor);
            this.takeBillData(ctx, midTmpTable, billelectSQLList, sqlGenertor.getBillQueryLock());
            String insertSql = this.getInsertSql(tempTableName, this.getSelectSql(ctx, midTmpTable, params));
            DBUtil.execute(conn, insertSql);
            String totalRow = this.getTotalInsertSql(tempTableName, this.getTotalSelectSql(ctx, tempTableName));
            DBUtil.execute(conn, totalRow);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                DBUtil.releaseTempTable(ctx, midTmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        DBUtil.releaseTempTable(ctx, midTmpTable);
    }

    private String getSelectSql(Context ctx, String midTmpTable, RptParams params) throws BOSException {
        int amtPrecision = params.getInt("amtPrecision");
        StringBuffer bfSql = new StringBuffer();
        bfSql.append("SELECT newbosid('DFDC428F') as FID,BIZTYPE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FBizTypeName,");
        bfSql.append("BILLTYPE.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FBillTypeName,");
        bfSql.append("T1.FTransactionTypeName,T1.FBillNumber,T1.FBizDate,").append("Storage.Fname_").append(CalculateUtil.getLoc(ctx)).append(" AS FStorageName,");
        bfSql.append("Warehouse.Fname_").append(CalculateUtil.getLoc(ctx)).append(" AS FWarehouseName,T1.FSTORAGEORGUNITID,T1.FWAREHOUSEID,T1.FMaterialId,T1.FMaterialNumber,T1.FMaterialName,T1.Model,");
        bfSql.append("\n T1.FUnitId,MeasureUnit.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FUnitName,");
        bfSql.append("\n T1.FQty,T1.FActualBaseUnitCost,T1.FActualCost,T1.FUnitStandardCost,T1.FStandardCost2,");
        bfSql.append("\n BaseUnit.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FBaseUnitName,");
        bfSql.append("T1.FBaseQty,multiunit.FQtyPrecision,BaseUnit.FQtyPrecision,T1.pricePrecsion,T1.FBillTypeId,T1.FBillId," + amtPrecision + " as FLocalCurrencyPrecision ,T1.FCompanyOrgUnitID,T1.FBASEUNITID,T1.FEntryID, ");
        bfSql.append("\n T1.FLot,");
        bfSql.append("\n T1.FAssistPropertyID,AsstAttr.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FAssistPropertyName,");
        bfSql.append("\n T1.FProjectID,Project.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FProjectName,Project.FNumber AS FProjectNumber,");
        bfSql.append("\n T1.FTrackNumberID,TrackNumber.FName_").append(CalculateUtil.getLoc(ctx)).append(" AS FTrackNumberName,TrackNumber.FNumber AS FTrackNumberNumber,");
        bfSql.append("\n T1.FisPresent ");
        bfSql.append("\n FROM ").append(midTmpTable).append(" T1");
        bfSql.append("\n INNER JOIN T_SCM_BILLTYPE BILLTYPE ON T1.FBILLTYPEID = BILLTYPE.FID");
        bfSql.append("\n INNER JOIN T_SCM_BIZTYPE BIZTYPE ON T1.FBIZTYPEID = BIZTYPE.FID");
        bfSql.append("\n INNER JOIN T_BD_MeasureUnit MeasureUnit ON T1.FUNITID = MeasureUnit.FID");
        bfSql.append("\n INNER JOIN T_BD_MeasureUnit BaseUnit ON T1.FBASEUNITID = baseUnit.FID");
        bfSql.append("\n INNER JOIN T_ORG_Storage Storage on T1.FSTORAGEORGUNITID = Storage.FID");
        bfSql.append("\n INNER JOIN T_DB_Warehouse Warehouse on T1.FWAREHOUSEID = Warehouse.FID");
        bfSql.append("\n LEFT JOIN T_BD_AsstAttrValue AsstAttr ON T1.FAssistPropertyID = AsstAttr.FID");
        bfSql.append("\n LEFT JOIN T_MM_Project Project ON T1.FProjectID = Project.FID");
        bfSql.append("\n LEFT JOIN T_MM_TrackNumber TrackNumber ON T1.FTrackNumberID = TrackNumber.FID");
        bfSql.append("\n  LEFT JOIN T_BD_MultiMeasureUnit multiunit ON T1.fmaterialid = multiunit.fmaterialId and t1.funitid = multiunit.FMeasureUnitID ");
        bfSql.append("\n ORDER BY T1.FBillNumber");
        return bfSql.toString();
    }

    private String getTotalSelectSql(Context ctx, String tempTable) throws BOSException {
        String total = ResourceBase.getString((String)"com.kingdee.eas.scm.cal.invdep.InvdepResource", (String)"Total", (Locale)ctx.getLocale());
        StringBuffer bfSql = new StringBuffer();
        bfSql.append("SELECT ");
        bfSql.append("'").append(total).append("' as FTransactionTypeName,");
        bfSql.append("SUM(FQty) as FTotalQty,");
        bfSql.append("SUM(FActualCost) as FTotalActualCost,");
        bfSql.append("SUM(FStandardCost) as FTotalStandardCost,");
        bfSql.append("SUM(FBaseQty) as FTotalBaseQty");
        bfSql.append(", 99 as FSeq");
        bfSql.append(" FROM ");
        bfSql.append(tempTable);
        return bfSql.toString();
    }

    private ExceptionBilQueryGenertorSQL buildBillQuerySQL(Context ctx, RptParams params) throws EASBizException, BOSException {
        Object[] objs;
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        ExceptionBilQueryGenertorSQL sqlGenertor = new ExceptionBilQueryGenertorSQL(ctx);
        sqlGenertor.setCompanyOrgUnitId(aCompanyOrgUnitInfo.getId().toString());
        if (params.getObject("storeType") != null && (objs = (Object[])params.getObject("storeType")).length > 0 && objs[0] != null) {
            sqlGenertor.setIsFilterStoreType(true);
            String[] storeTypes = new String[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                storeTypes[i] = ((StoreTypeInfo)objs[i]).getId().toString();
            }
            sqlGenertor.setStoreTypes(storeTypes);
        }
        if (params.getObject("storage") != null) {
            sqlGenertor.setQueryStorageId(((StorageOrgUnitInfo)params.getObject("storage")).getId().toString());
        }
        if (params.getObject("storageOrgIds") != null) {
            sqlGenertor.setQueryStorageIds(params.getString("storageOrgIds"));
        }
        if (params.getObject("startWarehouse") != null) {
            if (params.getObject("startWarehouse") instanceof Object[]) {
                Object[] object = (Object[])params.getObject("startWarehouse");
                if (object.length == 1) {
                    sqlGenertor.setQueryStartWarehsoueNumber(((WarehouseInfo)object[0]).getNumber());
                } else {
                    StringBuffer warehouseNumbers = new StringBuffer();
                    for (Object info : object) {
                        warehouseNumbers.append("'").append(((WarehouseInfo)info).getNumber()).append("',");
                    }
                    warehouseNumbers.setLength(warehouseNumbers.length() - 1);
                    sqlGenertor.setQueryWarehsoueNumbers(warehouseNumbers.toString());
                }
            } else if (params.getObject("startWarehouse") instanceof Object) {
                sqlGenertor.setQueryStartWarehsoueNumber(((WarehouseInfo)params.getObject("startWarehouse")).getNumber());
            }
        }
        if (params.getObject("endWarehouse") != null) {
            sqlGenertor.setQueryEndWarehsoueNumber(((WarehouseInfo)params.getObject("endWarehouse")).getNumber());
        }
        if (params.getObject("startTransacionType") != null) {
            sqlGenertor.setStartTranTypeNumber(((TransactionTypeInfo)params.getObject("startTransacionType")).getNumber());
        }
        if (params.getObject("endTransactionType") != null) {
            sqlGenertor.setEndTranTypeNumber(((TransactionTypeInfo)params.getObject("endTransactionType")).getNumber());
        }
        if (params.getObject("bizType") != null) {
            sqlGenertor.setBizTypeId(((BizTypeInfo)params.getObject("bizType")).getId().toString());
        }
        if (params.getObject("transacionTypeNumbers") != null) {
            sqlGenertor.setTransacionTypeNumbers(params.getObject("transacionTypeNumbers").toString());
        }
        if (params.getObject("startMaterial") != null) {
            if (params.getObject("startMaterial") instanceof MaterialInfo) {
                sqlGenertor.setQueryStartMaterialNumber(((MaterialInfo)params.getObject("startMaterial")).getNumber());
            } else {
                sqlGenertor.setQueryStartMaterialNumber((String)params.getObject("startMaterial"));
            }
        }
        if (params.getObject("endMaterial") != null) {
            if (params.getObject("endMaterial") instanceof MaterialInfo) {
                sqlGenertor.setQueryEndMaterialNumber(((MaterialInfo)params.getObject("endMaterial")).getNumber());
            } else {
                sqlGenertor.setQueryEndMaterialNumber((String)params.getObject("endMaterial"));
            }
        }
        if (params.getObject("materialNumbers") != null) {
            sqlGenertor.setMaterialNumbers(params.getObject("materialNumbers").toString());
        }
        if (params.getObject("vouchered") != null) {
            sqlGenertor.setisFilterVouchered(true);
            if (((VoucheredEnum)((Object)params.getObject("vouchered"))).getValue() == 1) {
                sqlGenertor.setIsVouchered(true);
            } else if (((VoucheredEnum)((Object)params.getObject("vouchered"))).getValue() == 0) {
                sqlGenertor.setIsVouchered(false);
            } else {
                sqlGenertor.setisFilterVouchered(false);
            }
        }
        if (params.getObject("billstatus") != null) {
            sqlGenertor.setBillStatus(((BillBaseStatusEnum)params.getObject("billstatus")).getValue());
        }
        if (params.getBoolean("isCalculate")) {
            sqlGenertor.setFilterIsCalculate(false);
        } else {
            sqlGenertor.setFilterIsCalculate(true);
            sqlGenertor.setCalcualte(true);
        }
        if (params.getObject("calculateType") != null) {
            if (((CalculateTypeEnum)params.getObject("calculateType")).getValue() == -1) {
                sqlGenertor.setIsFilterCalculateType(false);
            } else {
                sqlGenertor.setIsFilterCalculateType(true);
                sqlGenertor.setCalculateType(((CalculateTypeEnum)params.getObject("calculateType")).getValue());
            }
        }
        sqlGenertor.setExtendWhereCondition(true);
        StringBuffer extendWhere = new StringBuffer(this.getPeriodFilter(ctx, params));
        if (params.getBoolean("checkUnitActualcost")) {
            extendWhere.append("\n AND ENTRY.FUNITActualCost <=0");
        }
        String qtyAndAmountFilter = this.getQtyAndAmountFilter(params, "ENTRY.FQTY", "ENTRY.FActualCost");
        extendWhere.append("\n").append(qtyAndAmountFilter);
        if (params.getObject("comboCalculateType") != null && params.getObject("comboCalculateType") != CalculateTypeEnum.NULL) {
            extendWhere.append("\n AND MaterialCompanyInfo.FCalculateType = ").append(((CalculateTypeEnum)params.getObject("comboCalculateType")).getValue());
        }
        if (params.getObject("isPresent") != null) {
            if (params.getInt("isPresent") == 1) {
                extendWhere.append("\n and entry.FisPresent = 1");
            } else if (params.getInt("isPresent") == 2) {
                extendWhere.append("\n and entry.FisPresent = 0");
            }
        }
        sqlGenertor.setExtendWhereCondition(extendWhere.toString());
        return sqlGenertor;
    }

    public String getQtyAndAmountFilter(RptParams pp, String fieldQty, String fieldAmount) {
        StringBuffer filterSql = new StringBuffer();
        if (pp.getObject("combQty") == null && pp.getObject("combAmt") == null || pp.getInt("combQty") == 0 && pp.getInt("combAmt") == 0) {
            return filterSql.toString();
        }
        filterSql.append(" AND ");
        if (pp.getInt("combQty") == 1) {
            filterSql.append(fieldQty).append("  > 0 ");
        } else if (pp.getInt("combQty") == 2) {
            filterSql.append(fieldQty).append("  = 0 ");
        } else if (pp.getInt("combQty") == 3) {
            filterSql.append(fieldQty).append("  < 0 ");
        } else if (pp.getInt("combQty") == 4) {
            filterSql.append(fieldQty).append("  != 0 ");
        }
        if (pp.getInt("combQty") != 0 && pp.getInt("combAmt") != 0) {
            filterSql.append(" AND ");
        }
        if (pp.getInt("combAmt") == 1) {
            filterSql.append(fieldAmount).append("  > 0 ");
        } else if (pp.getInt("combAmt") == 2) {
            filterSql.append(fieldAmount).append("  = 0 ");
        } else if (pp.getInt("combAmt") == 3) {
            filterSql.append(fieldAmount).append("  < 0 ");
        } else if (pp.getInt("combAmt") == 4) {
            filterSql.append(fieldAmount).append("  != 0 ");
        }
        return filterSql.toString();
    }

    private String getPeriodFilter(Context ctx, RptParams params) throws EASBizException, BOSException {
        int beginYear = params.getInt("startYear");
        int beginPeriod = params.getInt("startPeriod");
        int endYear = params.getInt("endYear");
        int endPeriod = params.getInt("endPeriod");
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)beginYear, (int)beginPeriod, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        PeriodInfo endPeriodInfo = null;
        endPeriodInfo = beginYear == endYear && beginPeriod == endPeriod ? beginPeriodInfo : PeriodUtils.getPeriodInfo((Context)ctx, (int)endYear, (int)endPeriod, (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        StringBuffer extendWhere = new StringBuffer();
        extendWhere.append("(BILL.FBizDate >= {ts'").append(IMRptUtils.getFilterBeginDate((Date)beginPeriodInfo.getBeginDate())).append("'}");
        extendWhere.append(" AND BILL.FBizDate <= {ts'").append(IMRptUtils.getFilterEndDate((Date)endPeriodInfo.getEndDate())).append("'})");
        extendWhere.append("\n AND (ENTRY.FBizDate >= {ts'").append(IMRptUtils.getFilterBeginDate((Date)beginPeriodInfo.getBeginDate())).append("'}");
        extendWhere.append(" AND ENTRY.FBizDate <= {ts'").append(IMRptUtils.getFilterEndDate((Date)endPeriodInfo.getEndDate())).append("'})");
        return extendWhere.toString();
    }

    private String getInsertSql(String tempTable, String selectSql) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTable);
        sql.append("(FID");
        sql.append(",FBIZTYPENAME");
        sql.append(",FBILLTYPENAME");
        sql.append(",FTRANSACTIONNAME");
        sql.append(",FBillNumber");
        sql.append(",FBizDate");
        sql.append(",FStorageName");
        sql.append(",FWarehouseName");
        sql.append(",FSTORAGEORGUNITID");
        sql.append(",FWAREHOUSEID");
        sql.append(",FMaterialID");
        sql.append(",FMATERIALNUMBER");
        sql.append(",FMATERIALNAME");
        sql.append(",FMODEL");
        sql.append(",FUnitId");
        sql.append(",FunitName");
        sql.append(",FQty");
        sql.append(",FActualBaseUnitCost");
        sql.append(",Factualcost");
        sql.append(",FUnitStandardCost");
        sql.append(",FStandardCost");
        sql.append(",FBaseUnitName");
        sql.append(",FBaseQty");
        sql.append(",FQtyPrecision");
        sql.append(",FBaseQtyPrecision");
        sql.append(",FPricePrecision");
        sql.append(",FBILLTYPEID");
        sql.append(",FBILLID");
        sql.append(",FLocalCurrencyPrecision ");
        sql.append(",FCompanyOrgUnitID ");
        sql.append(",FBaseUnitId ");
        sql.append(",FBillEntryID");
        sql.append(",FInvLot");
        sql.append(",FInvAssistPropertyID");
        sql.append(",FInvAssistPropertyName");
        sql.append(",FInvProjectID");
        sql.append(",FInvProjectName");
        sql.append(",FInvProjectNumber");
        sql.append(",FInvTrackNumberID");
        sql.append(",FInvTrackNumberName");
        sql.append(",FInvTrackNumberNumber");
        sql.append(",FisPresent");
        sql.append(")");
        sql.append("\n");
        sql.append(selectSql);
        return sql.toString();
    }

    private String getTotalInsertSql(String tempTable, String selectSql) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTable);
        sql.append("(");
        sql.append("FTRANSACTIONNAME");
        sql.append(",FQty");
        sql.append(",Factualcost");
        sql.append(",FStandardCost");
        sql.append(",FBaseQty");
        sql.append(",FSeq");
        sql.append(")");
        sql.append("\n");
        sql.append(selectSql);
        return sql.toString();
    }

    private String getCreateTempTableSQL(Context ctx, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("\n FID VARCHAR(44),");
        sql.append("\n FBizTypeName NVARCHAR(255),");
        sql.append("\n FBilltypeName NVARCHAR(255),");
        sql.append("\n FTRANSACTIONNAME NVARCHAR(255),");
        sql.append("\n FBillNumber NVARCHAR(80),");
        sql.append("\n FBizDate DATETIME,");
        sql.append("\n FStorageName NVARCHAR(255),");
        sql.append("\n FWarehouseName NVARCHAR(255),");
        sql.append("\n FSTORAGEORGUNITID VARCHAR(44),");
        sql.append("\n FWAREHOUSEID VARCHAR(44),");
        sql.append("\n FMaterialID VARCHAR(44),");
        sql.append("\n FMATERIALNUMBER NVARCHAR(80),");
        sql.append("\n FMATERIALNAME NVARCHAR(255),");
        sql.append("\n FMODEL NVARCHAR(255),");
        sql.append("\n FUnitId VARCHAR(44),");
        sql.append("\n FunitName NVARCHAR(80),");
        sql.append("\n FQty NUMERIC(21,8) default 0,");
        sql.append("\n FActualBaseUnitCost NUMERIC(21,8) default 0,");
        sql.append("\n Factualcost NUMERIC(19,4) default 0,");
        sql.append("\n FUnitStandardCost NUMERIC(21,8) default 0,");
        sql.append("\n FStandardCost NUMERIC(19,4) default 0,");
        sql.append("\n FBaseUnitName NVARCHAR(80),");
        sql.append("\n FBaseQty NUMERIC(21,8) default 0,");
        sql.append("\n FQtyPrecision INT default 2,");
        sql.append("\n FBaseQtyPrecision INT default 2,");
        sql.append("\n FPricePrecision INT default 2,");
        sql.append("\n FBILLTYPEID VARCHAR(44),");
        sql.append("\n FBILLID VARCHAR(44),");
        sql.append("\n FLocalCurrencyPrecision INT default 2,");
        sql.append("\n FCompanyOrgUnitID VARCHAR(44),");
        sql.append("\n FBaseUnitId VARCHAR(44),");
        sql.append("\n FBillEntryID VARCHAR(44),");
        sql.append("\n FSeq int default 0,");
        sql.append("\n FisPresent int default 0,");
        sql.append("\n FLot NVARCHAR(80),");
        sql.append("\n FAssistPropertyID VARCHAR(44),");
        sql.append("\n FAssistPropertyName NVARCHAR(255),");
        sql.append("\n FProjectID VARCHAR(44),");
        sql.append("\n FProjectName NVARCHAR(255),");
        sql.append("\n FProjectNumber NVARCHAR(80),");
        sql.append("\n FTrackNumberID VARCHAR(44),");
        sql.append("\n FTrackNumberName NVARCHAR(255),");
        sql.append("\n FTrackNumberNumber NVARCHAR(80),");
        sql.append("\n FInvLot NVARCHAR(80),");
        sql.append("\n FInvAssistPropertyID VARCHAR(44),");
        sql.append("\n FInvAssistPropertyName NVARCHAR(255),");
        sql.append("\n FInvProjectID VARCHAR(44),");
        sql.append("\n FInvProjectName NVARCHAR(255),");
        sql.append("\n FInvProjectNumber NVARCHAR(80),");
        sql.append("\n FInvTrackNumberID VARCHAR(44),");
        sql.append("\n FInvTrackNumberName NVARCHAR(255),");
        sql.append("\n FInvTrackNumberNumber NVARCHAR(80)");
        sql.append(")");
        return sql.toString();
    }

    private RptTableHeader createTableHeader(Context ctx, String tempTableName) throws BOSException {
        RptTableHeader header = new RptTableHeader();
        try {
            RptTableColumn col = null;
            col = new RptTableColumn("selected");
            col.setWidth(50);
            header.addColumn(col);
            col = new RptTableColumn("FBizTypeName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FBillTypeName");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FTransactionName");
            col.setWidth(120);
            header.addColumn(col);
            col = new RptTableColumn("FisPresent");
            col.setWidth(80);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillNumber");
            col.setWidth(120);
            header.addColumn(col);
            col = new RptTableColumn("FBizDate");
            col.setWidth(80);
            col.setFormatPattern("yyyy-MM-dd");
            header.addColumn(col);
            col = new RptTableColumn("FStorageName");
            col.setWidth(150);
            header.addColumn(col);
            col = new RptTableColumn("FWarehouseName");
            col.setWidth(150);
            header.addColumn(col);
            col = new RptTableColumn("FMaterialNumber");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FMaterialName");
            col.setWidth(150);
            header.addColumn(col);
            col = new RptTableColumn("FModel");
            col.setWidth(100);
            header.addColumn(col);
            col = new RptTableColumn("FUnitName");
            col.setWidth(80);
            header.addColumn(col);
            col = new RptTableColumn("FQty");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FActualBaseUnitCost");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FActualCost");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FUnitStandardCost");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FStandardCost");
            col.setWidth(100);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FBaseUnitName");
            col.setWidth(80);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FBaseQty");
            col.setWidth(120);
            col.setAligment(2);
            header.addColumn(col);
            col = new RptTableColumn("FLot");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(0);
            header.addColumn(col);
            col = new RptTableColumn("FAssistPropertyName");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(0);
            header.addColumn(col);
            col = new RptTableColumn("FProjectName");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(0);
            header.addColumn(col);
            col = new RptTableColumn("FProjectNumber");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(0);
            header.addColumn(col);
            col = new RptTableColumn("FTrackNumberName");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(0);
            header.addColumn(col);
            col = new RptTableColumn("FTrackNumberNumber");
            col.setWidth(100);
            col.setHided(true);
            col.setAligment(0);
            header.addColumn(col);
            col = new RptTableColumn("FMaterialId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FUnitId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FQtyPrecision");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBaseQtyPrecision");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FPricePrecision");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillTypeId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FLocalCurrencyPrecision");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FCompanyOrgUnitID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBaseUnitId");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FBillEntryID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FAssistPropertyID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FProjectID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            col = new RptTableColumn("FTrackNumberID");
            col.setWidth(0);
            col.setHided(true);
            header.addColumn(col);
            this.setHeadLabes(ctx, header);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return header;
    }

    private void setHeadLabes(Context ctx, RptTableHeader header) {
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"selected", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BIZTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ISPRESENT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WAREHOUSENAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"UNITACTUALCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ACTUALCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"UNITSTANDARDCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"STANDARDCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEQTY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"LOT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AssistPropertyName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackNumber", (Context)ctx), "FQtyPrecision", "FBaseQtyPrecision", "FPricePrecision", "FBILLTYPEID", "FMaterialID", "FUnitID", "FbillID", "FLocalCurrencyPrecision", "FCompanyOrgUnitID", "FBaseUnitId", "FBillEntryID", "FAssistPropertyID", "FProjectID", "FTrackNumberID"}, {SCMUtils.getResource((String)this.res, (String)"selected", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BIZTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ISPRESENT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"STORAGEORG", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"WAREHOUSENAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"UNITACTUALCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ACTUALCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"UNITSTANDARDCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"STANDARDCOST", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BASEQTY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"LOT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AssistPropertyName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackNumber", (Context)ctx), "FQtyPrecision", "FBaseQtyPrecision", "FPricePrecision", "FBILLTYPEID", "FMaterialID", "FUnitID", "FbillID", "FLocalCurrencyPrecision", "FCompanyOrgUnitID", "FBaseUnitId", "FBillEntryID", "FAssistPropertyID", "FProjectID", "FTrackNumberID"}}, true);
    }

    private List<String> getExceptionBills(Object obj, AbsShareSqlGenerator sqlGenertor) {
        if (obj == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        BillTypeInfo billTypeInfo = null;
        if (obj instanceof BillTypeInfo) {
            billTypeInfo = (BillTypeInfo)obj;
            if (billTypeInfo.getId() != null) {
                list.add(billTypeInfo.getId().toString());
            }
        } else if (obj instanceof Object[]) {
            Object[] billTypes = (Object[])obj;
            int size = billTypes.length;
            for (int j = 0; j < size; ++j) {
                billTypeInfo = (BillTypeInfo)billTypes[j];
                if (billTypeInfo == null || billTypeInfo.getId() == null) continue;
                list.add(billTypeInfo.getId().toString());
            }
        }
        String billTypeID = null;
        ArrayList<String> billelectSQLList = new ArrayList<String>(8);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            billTypeID = (String)list.get(i);
            if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if ("50957179-0105-1000-e000-0167c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if ("50957179-0105-1000-e000-0172c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if ("50957179-0105-1000-e000-017bc0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if ("50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if ("50957179-0105-1000-e000-0177c0a812fd463ED552".equals(billTypeID)) {
                billelectSQLList.add(this.getShareBillSelectSQL("T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
                continue;
            }
            if (!"50957179-0105-1000-e000-016ec0a812fd463ED552".equals(billTypeID)) continue;
            billelectSQLList.add(this.getShareBillSelectSQL("T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
        }
        return billelectSQLList;
    }

    private String getShareBillSelectSQL(String headTableName, String entryTableName, String extendFields, boolean isCostAdjustBill, int costAdjBillType, AbsShareSqlGenerator sqlGenertor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append("ENTRY.FID AS ENTRYID, ");
        stringBuffer.append("ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID, ");
        stringBuffer.append("ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID, ");
        stringBuffer.append("ENTRY.FWarehouseID AS FWarehouseID, ");
        stringBuffer.append("ENTRY.FMaterialID AS FMaterialID, ");
        stringBuffer.append("MATERIAL.FBaseUnit AS FBaseUnitId, ");
        stringBuffer.append("ENTRY.FAssistPropertyID AS FAssistPropertyID, ");
        stringBuffer.append("ENTRY.FLot AS FLot, ");
        stringBuffer.append("ENTRY.FQty AS FQty, ");
        stringBuffer.append("ENTRY.FBaseQty AS FBaseQty");
        stringBuffer.append(",ENTRY.FActualCost AS FActualCost ");
        stringBuffer.append(",ENTRY.FStandardCost AS FStandardCost");
        stringBuffer.append(",TransactionType.FIsCalculate AS FIsCalculate ");
        stringBuffer.append(",BILL.FBizTypeID AS FBizTypeID ");
        if (extendFields != null && extendFields.trim().length() > 0) {
            stringBuffer.append(extendFields);
        }
        stringBuffer.append(",ENTRY.FProjectID AS FProjectID");
        stringBuffer.append(",ENTRY.FTrackNumberID AS FTrackNumberID");
        stringBuffer.append(",isnull(ENTRY.FisPresent,0) AS FisPresent");
        stringBuffer.append("\n FROM " + entryTableName + " ENTRY ");
        stringBuffer.append("\n INNER JOIN " + headTableName + " BILL ON ENTRY.FParentID = BILL.FID ");
        if (sqlGenertor.isFilterAccountType() || sqlGenertor.isFilterCalculateType()) {
            stringBuffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo  MaterialCompanyInfo");
            stringBuffer.append(" ON (ENTRY.FMaterialID = MaterialCompanyInfo.FMaterialID AND ENTRY.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        }
        stringBuffer.append("\n LEFT JOIN T_SCM_TransactionType TransactionType ON TransactionType.FID = BILL.FTransactionTypeID ");
        if (sqlGenertor.isFilterStoreType() || sqlGenertor.isFilterIsCalculate() && sqlGenertor.isCalcualte()) {
            stringBuffer.append("\n LEFT JOIN T_IM_InvUpdateType invUpdateType on ENTRY.FINVUPDATETYPEID = invUpdateType.FID");
            stringBuffer.append("\n LEFT JOIN T_IM_STORETYPE inStore on invUpdateType.FSTORETYPEID = inStore.FID");
            stringBuffer.append("\n LEFT JOIN T_IM_STORETYPE outStore on invUpdateType.FSTORETYPEPREID = outStore.FID");
        }
        stringBuffer.append("\n INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID ");
        if (sqlGenertor.isFilterStorage()) {
            stringBuffer.append("\n INNER JOIN T_ORG_Storage STORAGE ON STORAGE.FID = ENTRY.FStorageOrgUnitID ");
        }
        if (sqlGenertor.isFilterWarehouse()) {
            stringBuffer.append("\n INNER JOIN T_DB_WAREHOUSE WAREHOUSE ON WAREHOUSE.FID = ENTRY.FWareHouseID ");
        }
        stringBuffer.append("\n WHERE (BILL.FIsInitBill = 0 OR BILL.FIsInitBill IS NULL)");
        if ("T_IM_PurInWarehsBill".equals(headTableName) || "T_IM_ManufactureRecBill".equals(headTableName) || "T_IM_MoveInWarehsBill".equals(headTableName) || "T_IM_OtherInWarehsBill".equals(headTableName)) {
            stringBuffer.append("\n and (Entry.FIsPresent = 0 OR Entry.FIsPresent IS NULL)");
        }
        if (sqlGenertor.isFilterCompany() && sqlGenertor.getCompanyOrgUnitid() != null) {
            stringBuffer.append("\n AND ENTRY.FCompanyOrgUnitID = '" + sqlGenertor.getCompanyOrgUnitid() + "'");
            if (sqlGenertor.isFilterAccountType()) {
                stringBuffer.append("\n AND MaterialCompanyInfo.FCompanyID = '" + sqlGenertor.getCompanyOrgUnitid() + "'");
            }
        }
        if (sqlGenertor.isFilterStorage() && sqlGenertor.getQueryStorageId() != null) {
            stringBuffer.append("\n AND ENTRY.FStorageOrgUnitID ='").append(sqlGenertor.getQueryStorageId()).append("'");
        }
        if (sqlGenertor.getQueryStorageIds() != null) {
            stringBuffer.append("\n AND ENTRY.FStorageOrgUnitID in(").append(sqlGenertor.getQueryStorageIds()).append(")");
        }
        if (sqlGenertor.isFilterWarehouse() && sqlGenertor.getQueryStartWarehsoueNumber() != null) {
            stringBuffer.append("\n AND WAREHOUSE.FNUMBER >='").append(sqlGenertor.getQueryStartWarehsoueNumber()).append("'");
        }
        if (sqlGenertor.isFilterWarehouse() && sqlGenertor.getQueryEndWarehsoueNumber() != null) {
            stringBuffer.append("\n AND WAREHOUSE.FNUMBER <='").append(sqlGenertor.getQueryEndWarehsoueNumber()).append("'");
        }
        if (sqlGenertor.getQueryWarehsoueNumbers() != null) {
            stringBuffer.append("\n AND WAREHOUSE.FNUMBER IN (").append(sqlGenertor.getQueryWarehsoueNumbers()).append(")");
        }
        if (sqlGenertor.isFilterMaterial() && sqlGenertor.getQueryStrartMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(sqlGenertor.getQueryStrartMaterialNumber()).append("'");
        }
        if (sqlGenertor.isFilterMaterial() && sqlGenertor.getQueryEndMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER <='").append(sqlGenertor.getQueryEndMaterialNumber()).append("'");
        }
        if (sqlGenertor.getMaterialNumbers() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER IN (").append(sqlGenertor.getMaterialNumbers()).append(")");
        }
        if (sqlGenertor.isFilterStartDate() && sqlGenertor.getQueryStartDate() != null) {
            stringBuffer.append("\n AND  BILL.FBizDate >= TO_DATE('" + IMRptUtils.getFilterBeginDate((Date)sqlGenertor.getQueryStartDate()) + "')");
        }
        if (sqlGenertor.isFilterEndDate() && sqlGenertor.getQueryEndDate() != null) {
            stringBuffer.append("\n AND  BILL.FBizDate <= TO_DATE('" + IMRptUtils.getFilterEndDate((Date)sqlGenertor.getQueryEndDate()) + "')");
        }
        if (sqlGenertor.isFilterPeriod() && sqlGenertor.getQueryPeriod() != null) {
            stringBuffer.append("\n AND  BILL.FPeriod = " + sqlGenertor.getQueryPeriod().getPeriodNumber());
            stringBuffer.append(" AND BILL.FYear = " + sqlGenertor.getQueryPeriod().getPeriodYear());
        }
        if (sqlGenertor.isFilterBillstatus()) {
            if (sqlGenertor.getBillStatus() != -1) {
                stringBuffer.append("\n AND BILL.FBaseStatus = " + sqlGenertor.getBillStatus());
            } else {
                stringBuffer.append("\n AND (BILL.FBaseStatus = 1");
                stringBuffer.append(" OR BILL.FBaseStatus = 2");
                stringBuffer.append(" OR BILL.FBaseStatus = 4");
                stringBuffer.append("\n )");
            }
        }
        if (sqlGenertor.isFilterAccountType()) {
            stringBuffer.append("\n AND MaterialCompanyInfo.FAccountType = " + sqlGenertor.getAccountType());
        }
        if (sqlGenertor.isFilterTranType() && sqlGenertor.getStartTranTypeNumber() != null) {
            stringBuffer.append("\n AND TransactionType.FNUMBER >= '" + sqlGenertor.getStartTranTypeNumber()).append("'");
        }
        if (sqlGenertor.isFilterTranType() && sqlGenertor.getEndTranTypeNumber() != null) {
            stringBuffer.append(" AND TransactionType.FNUMBER <= '" + sqlGenertor.getEndTranTypeNumber()).append("'");
        }
        if (sqlGenertor.getTransacionTypeNumbers() != null) {
            stringBuffer.append("\n  AND TransactionType.FNUMBER in (").append(sqlGenertor.getTransacionTypeNumbers()).append(")");
        }
        if (sqlGenertor.getBizTypeId() != null) {
            stringBuffer.append("\n AND BILL.FBizTypeID = '" + sqlGenertor.getBizTypeId() + "'");
        }
        if (sqlGenertor.isFilterVouchered()) {
            if (sqlGenertor.getIsVouchered()) {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 1");
            } else {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 0");
            }
        }
        if (sqlGenertor.isFilterCalculateType()) {
            stringBuffer.append("\n AND MaterialCompanyInfo.FCalculateType = " + sqlGenertor.getCalculateType());
        }
        if (sqlGenertor.isFilterIsCalculate() && !isCostAdjustBill) {
            if (sqlGenertor.isCalcualte()) {
                stringBuffer.append("\n AND TransactionType.FIsCalculate =1 ");
                stringBuffer.append(" and ENTRY.FInvUpdateTypeID not in (");
                stringBuffer.append("  select fid from T_IM_InvUpdateType where ");
                stringBuffer.append("  (FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("'").append(" and FStoreTypePreID is null ) ");
                stringBuffer.append("  or (FStoreTypePreID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' and FStoreTypeID is null ) ");
                stringBuffer.append("  or (FStoreTypePreID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' and FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' )");
                stringBuffer.append(" )");
            } else {
                stringBuffer.append("\n AND TransactionType.FIsCalculate =0");
            }
        }
        if (sqlGenertor.isExtendWhereCondition() && sqlGenertor.getExtendWhereCondition() != null) {
            stringBuffer.append("\n AND " + sqlGenertor.getExtendWhereCondition());
        }
        if (isCostAdjustBill && (costAdjBillType == 0 || costAdjBillType == 1)) {
            stringBuffer.append("\n AND BILL.FCalculateKind=").append(costAdjBillType);
        }
        if (sqlGenertor.isFilterStoreType()) {
            String[] storeTypes = sqlGenertor.getStoreTypes();
            StringBuffer ids = new StringBuffer();
            for (String s : storeTypes) {
                ids.append("'").append(s).append("',");
            }
            stringBuffer.append("\n AND (inStore.FID IN(").append(ids.substring(0, ids.length() - 1)).append(")");
            stringBuffer.append("\n OR OUTStore.FID IN(").append(ids.substring(0, ids.length() - 1)).append("))");
        }
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void takeBillData(Context ctx, String midTmpTable, List<String> sqlList, List<String> lockList) throws BOSException {
        Connection conn = null;
        QueryDataSyncLock lock = new QueryDataSyncLock();
        ThreadPool threadPool = ThreadPool.getInstance();
        int size = sqlList.size();
        try {
            String insertSQL = this.getInsertMidTmpTableSQL(midTmpTable);
            StringBuffer sSQL = new StringBuffer();
            conn = EJBFactory.getConnection((Context)ctx);
            for (int i = 0; i < size; ++i) {
                String selectSQL = sqlList.get(i);
                if (StringUtil.isEmpty((String)selectSQL)) continue;
                sSQL.setLength(0);
                sSQL.append(insertSQL).append("\n").append(selectSQL);
                QueryDataTask thread = new QueryDataTask(lock, lockList.get(i), conn, sSQL.toString());
                lock.addLock(lockList.get(i));
                threadPool.addTask((Runnable)thread);
            }
            lock.waitFinish();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (BOSException bose) {
                    throw bose;
                }
            }
            catch (Throwable throwable) {
                KsqlUtil.cleanup(conn);
                throw throwable;
            }
        }
        KsqlUtil.cleanup((Connection)conn);
    }

    private List<String> getSelectAllBillSQLList(ExceptionBilQueryGenertorSQL sqlGenertor) {
        ArrayList<String> allSelectSQLList = new ArrayList<String>(8);
        int count = sqlGenertor.getBillHeadTableName().size();
        for (int i = 0; i < count; ++i) {
            allSelectSQLList.add(this.getShareBillSelectSQL((String)sqlGenertor.getBillHeadTableName().get(i), (String)sqlGenertor.getBillEntryTableName().get(i), sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
        }
        return allSelectSQLList;
    }

    private String getInsertMidTmpTableSQL(String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTable);
        sql.append("(FEntryID");
        sql.append(",FCompanyOrgUnitID");
        sql.append(",FStorageOrgUnitID");
        sql.append(",FWarehouseID");
        sql.append(",FMaterialID");
        sql.append(",FBaseUnitId");
        sql.append(",FAssistPropertyID");
        sql.append(",FLot");
        sql.append(",FQty");
        sql.append(",FBaseQty");
        sql.append(",FActualCost");
        sql.append(",FStandardCost");
        sql.append(",FIsCalculate");
        sql.append(",FBizTypeID");
        sql.append(",FBILLTYPEID");
        sql.append(",FTRANSACTIONTYPEID");
        sql.append(",FBILLNUMBER");
        sql.append(",FUNITID");
        sql.append(",FActualBaseUnitCost");
        sql.append(",FACTCOST");
        sql.append(",FUnitStandardCost");
        sql.append(",FSTANDARDCOST2");
        sql.append(",MODEL");
        sql.append(",pricePrecsion");
        sql.append(",FBizDate ");
        sql.append(",FMaterialNumber");
        sql.append(",FMaterialName");
        sql.append(",FTransactionTypeName");
        sql.append(",FBILLID");
        sql.append(",FProjectID");
        sql.append(",FTrackNumberID");
        sql.append(",FisPresent");
        sql.append(")");
        return sql.toString();
    }

    private String getCreateMidTmpTableSQL(Context ctx, String tempTable) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE " + tempTable + " (");
        sql.append("FCompanyOrgUnitID Varchar(44)");
        sql.append(",FStorageOrgUnitID Varchar(44)");
        sql.append(",FWarehouseID Varchar(44)");
        sql.append(",FMaterialID Varchar(44)");
        sql.append(",FBaseUnitId Varchar(44)");
        sql.append(",FAssistPropertyID Varchar(44)");
        sql.append(",FLot NVarchar(255)");
        sql.append(",FQty Numeric(21, 8) Default 0");
        sql.append(",FBaseQty Numeric(21, 8) Default 0");
        sql.append(",FActualCost Numeric(19, 4) Default 0");
        sql.append(",FStandardCost Numeric(19, 4) Default 0");
        sql.append(",FIsCalculate Int Default 0");
        sql.append(",FBizTypeID Varchar(44)");
        sql.append(",FBILLTYPEID Varchar(44)");
        sql.append(",FTRANSACTIONTYPEID Varchar(44)");
        sql.append(",FBILLNUMBER Varchar(255)");
        sql.append(",FUNITID Varchar(44)");
        sql.append(",FActualBaseUnitCost Numeric(21, 8) Default 0");
        sql.append(",FACTCOST Numeric(19, 4) Default 0");
        sql.append(",FUnitStandardCost Numeric(21, 8) Default 0");
        sql.append(",FSTANDARDCOST2 Numeric(19, 4) Default 0");
        sql.append(",MODEL NVarchar(255)");
        sql.append(",pricePrecsion Int default 2");
        sql.append(",FBizDate DateTime");
        sql.append(",FMaterialNumber Varchar(255)");
        sql.append(",FMaterialName NVarchar(255)");
        sql.append(",FTransactionTypeName NVarchar(255)");
        sql.append(",FBILLID Varchar(44)");
        sql.append(",FEntryID Varchar(44)");
        sql.append(",FProjectID VARCHAR(44)");
        sql.append(",FTrackNumberID VARCHAR(44)");
        sql.append(",FisPresent int ");
        sql.append(")");
        return sql.toString();
    }

    public String getInBillSql(ExceptionBilQueryGenertorSQL sqlGenertor) {
        int beginBillNumber = 4;
        int endBillNumber = sqlGenertor.getBillHeadTableName().size() - 1;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)sqlGenertor.getBillHeadTableName().get(i), (String)sqlGenertor.getBillEntryTableName().get(i), sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    public String getOutBillSql(ExceptionBilQueryGenertorSQL sqlGenertor) {
        int beginBillNumber = 0;
        int endBillNumber = 3;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)sqlGenertor.getBillHeadTableName().get(i), (String)sqlGenertor.getBillEntryTableName().get(i), sqlGenertor.getExtendFields(), false, -1, sqlGenertor));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }
}

