/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.ApportionResultInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionEntryInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionException;
import com.kingdee.eas.scm.cal.ExpenseApportionInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractExpenseApportionFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.MoveWeightedAverageCalculate;
import com.kingdee.eas.scm.cal.app.help.CostAdjustHelp;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExpenseApportionFacadeControllerBean
extends AbstractExpenseApportionFacadeControllerBean {
    public static final String RES = "com.kingdee.eas.scm.cal.ManualWriteOffResource";
    private static final long serialVersionUID = 4676750810198496795L;
    private static final String RESOURCE_PATH = "com.kingdee.eas.scm.cal.ExpenseApportionResource";
    private static final String DEVOLVE_BIZ_BizCategory_ID = "('+f4mYqj4xUGaNf69/HWRdqk4kCA=','6LFeB81CJ0mD3wyAekUV7Kk4kCA=')";
    public static final BigDecimal ZERO = new BigDecimal(String.valueOf("0.0"));
    private RptParams result = null;
    private static final String EXPAPPORT_BOSTYPE = "87E4684C";
    private boolean isDevolve;
    private boolean isAdjust = true;

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    private void createPurExpenseTable(Context ctx, RptParams params, String extend) throws BOSException {
        this.dropTempTable(params.getString("tempTable1"), ctx);
        SqlParams sqlParams = null;
        String tempTable1 = "";
        if (null == extend) {
            String[][] fields = this.getPurExpenseTablefields();
            String createSql = this.getCreateTempTableSql(fields);
            tempTable1 = this.createTempTable(ctx, createSql);
        } else {
            tempTable1 = this.getTempTableName("tempTable1", ctx);
            sqlParams = new SqlParams();
            StringBuffer bf1 = new StringBuffer();
            bf1.append("select ");
            bf1.append("OTHERBILL.FID AS id,");
            bf1.append("OTHERBILL.FNumber as number,");
            bf1.append("OTHERBILL.FBizDate as bizDate, ");
            bf1.append("OTHERBILL.FAsstActName_" + this.getLoc(ctx) + " as supplier_name,");
            bf1.append("COMPANY.FName_" + this.getLoc(ctx) + " as companyOrgUnit_name,");
            bf1.append("EXPENSEITEM.FNumber as expense_number,");
            bf1.append("EXPENSEITEM.FName_" + this.getLoc(ctx) + " as expense_name,");
            bf1.append("OTHERBILL.FAbstractName as FAbstractName,");
            bf1.append("ENTRY.FRemark as FRemark, ");
            bf1.append("MATERIAL.FNumber as material_number,");
            bf1.append("MATERIAL.FName_" + this.getLoc(ctx) + " as material_name,");
            bf1.append("ENTRY.FRecievePayAmountLocal as localNonTaxAmount,");
            bf1.append("ENTRY.FAmountLocal as amount,");
            bf1.append("ENTRY.FID as entry_id,");
            bf1.append("OTHERBILL.FCompanyID as companyOrgUnit_id,");
            bf1.append("BASECURRENCY.FPrecision as fprecision,");
            bf1.append("OTHERBILL.FAsstActID as supplier_id,");
            bf1.append("ENTRY.FUnApportionAmount as unApportionAmount,");
            bf1.append("0 as apportionAmount,");
            bf1.append("ENTRY.FSOURCEBILLID as SOURCEBILLID,");
            bf1.append("ENTRY.FSOURCEBILLENTRYID as SOURCEBILLENTRYID,");
            bf1.append("ENTRY.FCOREBILLID as COREBILLID,");
            bf1.append("ENTRY.FCOREBILLENTRYID as COREBILLENTRYID");
            bf1.append(" into ");
            bf1.append(tempTable1);
            bf1.append(" FROM T_AP_OtherBill AS OTHERBILL");
            bf1.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON OTHERBILL.FAdminOrgUnitID = ADMINORGUNIT.FID");
            bf1.append(" INNER JOIN T_BD_Currency AS CURRENCY ON CURRENCY.FID = OTHERBILL.FCurrencyID");
            bf1.append(" INNER JOIN T_BD_AsstActType AS ASSTACTTYPE ON ASSTACTTYPE.FID = OTHERBILL.FAsstActTypeID");
            bf1.append(" LEFT OUTER JOIN T_ORG_Purchase AS PURORG ON PURORG.FID = OTHERBILL.FPurOrgID");
            bf1.append(" INNER JOIN T_ORG_Company AS COMPANY ON COMPANY.FID = OTHERBILL.FCompanyID");
            bf1.append(" INNER JOIN T_AP_OtherBillentry AS ENTRY ON OTHERBILL.FID = ENTRY.FParentID");
            bf1.append(" LEFT OUTER JOIN T_BD_Person AS PERSON ON OTHERBILL.FPersonId = PERSON.FID");
            bf1.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
            bf1.append(" LEFT OUTER JOIN T_SCM_ExpenseItem AS EXPENSEITEM ON ENTRY.FExpenseItemID = EXPENSEITEM.FID");
            bf1.append(" LEFT OUTER JOIN T_SCM_BillType AS COREBILLTYPE ON ENTRY.FCoreBillTypeID = COREBILLTYPE.FID");
            bf1.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID");
            bf1.append(" LEFT OUTER JOIN T_PM_User AS CREATOR ON OTHERBILL.FCreatorID = CREATOR.FID");
            bf1.append(" LEFT OUTER JOIN T_PM_User AS auditor ON OTHERBILL.FauditorID = auditor.FID");
            bf1.append(" LEFT OUTER JOIN T_SCM_BizType AS BizType ON OTHERBILL.FBizTypeID = BizType.FID");
            bf1.append(" where (OTHERBILL.FBillType = 203 or OTHERBILL.FBillType = 204) and OTHERBILL.FBillStatus = 3");
            bf1.append(" and OTHERBILL.FisReversed = 0 and OTHERBILL.FisReverseBill = 0 and OTHERBILL.FisBizBill = 0");
            bf1.append(" and OTHERBILL.fisTransBill = 0 and OTHERBILL.FisInitializeBill = 0 and Entry.FUnApportionAmount != 0");
            if (this.isDevolve) {
                bf1.append(" and BizType.FBizCategoryID in ").append(DEVOLVE_BIZ_BizCategory_ID);
            } else {
                bf1.append(" and (BizType.FBizCategoryID not in ").append(DEVOLVE_BIZ_BizCategory_ID);
                bf1.append(" Or BizType.FNumber is Null)");
            }
            bf1.append(" and " + extend);
            String sql1 = bf1.toString();
            this.executeCreateAsSelectInto(sql1, sqlParams, ctx);
        }
        String countSql = "select count(1) cc from " + tempTable1;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        if (null == this.result) {
            this.result = new RptParams();
        }
        this.result.setString("index", "PurExpense");
        this.result.setString("tempTable1", tempTable1);
        this.result.setObject("header1", (Object)this.getAPRptHeader(ctx));
        this.result.setInt("verticalCount1", count);
    }

    private RptTableHeader getAPRptHeader(Context ctx) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col1 = null;
        col1 = new RptTableColumn("selected");
        col1.setWidth(40);
        header.addColumn(col1);
        col1 = new RptTableColumn("id");
        col1.setHided(true);
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("number");
        col1.setWidth(150);
        header.addColumn(col1);
        col1 = new RptTableColumn("bizDate");
        col1.setWidth(120);
        col1.setFormatPattern("yyyy-MM-dd");
        header.addColumn(col1);
        col1 = new RptTableColumn("supplier_name");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("companyOrgUnit_name");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("expense_number");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("expense_name");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("abstractName");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("remark");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("material_number");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("material_name");
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("amount");
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("localNonTaxAmount");
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("entry_id");
        col1.setHided(true);
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("companyOrgUnit_id");
        col1.setHided(true);
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("fprecision");
        col1.setHided(true);
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("supplier_id");
        col1.setHided(true);
        col1.setWidth(120);
        header.addColumn(col1);
        col1 = new RptTableColumn("unApportionAmount");
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("apportionAmount");
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("sourceBillID");
        col1.setHided(true);
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("sourceBillEntryID");
        col1.setHided(true);
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("coreBillID");
        col1.setHided(true);
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        col1 = new RptTableColumn("coreBillEntryID");
        col1.setHided(true);
        col1.setWidth(120);
        col1.setAligment(2);
        header.addColumn(col1);
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)RESOURCE_PATH, (String)"selected", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"id", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"number", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"bizDate", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"supplier_name", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"companyOrgUnit_name", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"expense_number", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"expense_name", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"abstractName", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"remark", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"material_number", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"material_name", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"entries_amount", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"entries_localNonTaxAmount", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_id", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"companyOrgUnit_id", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"fprecision", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"supplier_id", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"nonApportionAmount", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"apportionAmount", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"sourceBillID", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"sourceBillEntryID", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"coreBillID", (Context)ctx), SCMUtils.getResource((String)RESOURCE_PATH, (String)"coreBillEntryID", (Context)ctx)}}, true);
        return header;
    }

    private void createPurInWarehsTable(Context ctx, RptParams params, String extend) throws BOSException {
        this.dropTempTable(params.getString("tempTable2"), ctx);
        String autoApport = params.getString("autoApport");
        String tempPurExpenseTable = params.getString("tempPurExpenseTable");
        HashMap custFieldMap = null;
        String tempTable2 = "";
        if (null == extend && null == autoApport) {
            String[][] fields = this.getPurInWarehsTablefields();
            String createSql = this.getCreateTempTableSql(fields);
            tempTable2 = this.createTempTable(ctx, createSql);
        } else {
            tempTable2 = this.getTempTableName("tempTable2", ctx);
            SqlParams sqlParams = new SqlParams();
            custFieldMap = CalculateUtil.getUserDefineField(ctx);
            StringBuffer bf2 = new StringBuffer();
            bf2.append("select ");
            bf2.append("PURINWAREHSBILL.FID as id,");
            bf2.append("PURINWAREHSBILL.FNumber as number,");
            bf2.append("PURINWAREHSBILL.FBizDate as bizDate,");
            bf2.append("SUPPLIER.FName_" + this.getLoc(ctx) + " as supplier_name,");
            bf2.append("COMPANYORGUNIT.FName_" + this.getLoc(ctx) + " as companyOrgUnit_name,");
            bf2.append("ENTRY.FPurOrderNumber as purOrderNumber,");
            bf2.append("MATERIAL.FNumber as material_number,");
            bf2.append("MATERIAL.FName_" + this.getLoc(ctx) + " as material_name,");
            bf2.append("UNIT.FName_" + this.getLoc(ctx) + " as unit_name,");
            bf2.append("ENTRY.FLot as lot,");
            bf2.append("ENTRY.FQty as qty,");
            bf2.append("ENTRY.FBaseQty as baseQty,");
            bf2.append("ENTRY.FpurchaseCost as purchaseCost,");
            bf2.append("ENTRY.FpurchaseFee as purchaseFee,");
            bf2.append("ENTRY.FActualCost as actualCost,");
            for (String name : custFieldMap.keySet()) {
                bf2.append("ENTRY." + name + " as " + name + ",");
            }
            bf2.append("ENTRY.FImputedCost as imputedCost,");
            bf2.append("ENTRY.FID as entry_id,");
            bf2.append("ENTRY.FCompanyOrgUnitID as companyOrgUnit_id,");
            bf2.append("ENTRY.FStorageOrgUnitID as storageOrgUnit_id,");
            bf2.append("BASECURRENCY.FPrecision as fprecision,");
            bf2.append("MULTIUNIT.FQtyPrecision as qtyPrecision,");
            bf2.append("MULTIBASEUNIT.FQtyPrecision as baseQtyPrecision,");
            bf2.append("ENTRY.FPURORDERID as coreBillID,");
            bf2.append("ENTRY.FPURORDERENTRYID as coreBillEntryID");
            bf2.append(" into ");
            bf2.append(tempTable2);
            bf2.append(" FROM T_IM_PurInWarehsBill as PURINWAREHSBILL");
            bf2.append(" LEFT OUTER JOIN T_BD_Supplier as SUPPLIER ON PURINWAREHSBILL.FSupplierID = SUPPLIER.FID");
            bf2.append(" LEFT OUTER JOIN T_IM_PurInWarehsEntry as ENTRY ON PURINWAREHSBILL.FID = ENTRY.FParentID");
            bf2.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
            bf2.append(" LEFT OUTER JOIN T_BD_MeasureUnit as UNIT ON ENTRY.FBaseUnitID = UNIT.FID");
            bf2.append(" LEFT OUTER JOIN T_BD_Material as MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
            bf2.append(" LEFT OUTER JOIN T_SCM_TransactionType AS TRANSACTIONTYPE ON PURINWAREHSBILL.FTransactionTypeID = TRANSACTIONTYPE.FID");
            bf2.append(" LEFT OUTER JOIN T_SCM_BillType AS SOURCEBILLTYPE ON PURINWAREHSBILL.FSourceBillTypeID = SOURCEBILLTYPE.FID");
            bf2.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON PURINWAREHSBILL.FAdminOrgUnitID = ADMINORGUNIT.FID");
            bf2.append(" LEFT OUTER JOIN T_ORG_Storage AS STORAGEORGUNIT ON PURINWAREHSBILL.FStorageOrgUnitID = STORAGEORGUNIT.FID");
            bf2.append(" LEFT OUTER JOIN T_PM_User AS CREATOR ON PURINWAREHSBILL.FCreatorID = CREATOR.FID");
            bf2.append(" LEFT OUTER JOIN T_ORG_CtrlUnit AS CU ON PURINWAREHSBILL.FControlUnitID = CU.FID");
            bf2.append(" LEFT OUTER JOIN T_GL_Voucher AS VOUCHER ON PURINWAREHSBILL.FVoucherID = VOUCHER.FID");
            bf2.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR ON PURINWAREHSBILL.FAuditorID = AUDITOR.FID");
            bf2.append(" LEFT OUTER JOIN T_PM_User AS MODIFIER ON PURINWAREHSBILL.FModifierID = MODIFIER.FID");
            bf2.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON ENTRY.FLocationID = LOCATION.FID");
            bf2.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON ENTRY.FWarehouseID = WAREHOUSE.FID");
            bf2.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON ENTRY.FAssistPropertyID = ASSISTPROPERTY.FID");
            bf2.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON (ENTRY.FMaterialID = MULTIUNIT.FMaterialID AND ENTRY.FUnitID = MULTIUNIT.FMeasureUnitID)");
            bf2.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON (ENTRY.FMaterialID = MULTIBASEUNIT.FMaterialID AND ENTRY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)");
            bf2.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON (ENTRY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND ENTRY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID)");
            bf2.append(" LEFT OUTER JOIN T_SCM_BillType AS BILLTYPE ON ENTRY.FCoreBillTypeID = BILLTYPE.FID");
            bf2.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
            bf2.append(" LEFT OUTER JOIN T_SCM_BizType AS BizType ON PURINWAREHSBILL.FBizTypeID = BizType.FID");
            bf2.append(" LEFT OUTER JOIN t_mm_project AS project ON ENTRY.fprojectid = project.FID");
            bf2.append(" LEFT OUTER JOIN t_mm_tracknumber AS tracknumber ON ENTRY.ftracknumberid = tracknumber.FID");
            bf2.append(" where PURINWAREHSBILL.FBaseStatus = 4");
            bf2.append(" and ENTRY.fIsPresent = 0 ");
            bf2.append(" and TRANSACTIONTYPE.FIsCalculate = 1");
            if (this.isDevolve) {
                bf2.append(" and BizType.FBizCategoryID in ").append(DEVOLVE_BIZ_BizCategory_ID);
            } else {
                bf2.append(" and BizType.FBizCategoryID not in ").append(DEVOLVE_BIZ_BizCategory_ID);
            }
            if (null != autoApport && "true".equals(autoApport) && tempPurExpenseTable != null) {
                HashMap hm = this.getSourceIDandCoreID(ctx, tempPurExpenseTable);
                String coreBillIDs = (String)hm.get("coreBillIDs");
                String sourceBillIDs = (String)hm.get("sourceBillIDs");
                if (null != coreBillIDs && coreBillIDs.length() > 0 || null != sourceBillIDs && sourceBillIDs.length() > 0) {
                    if (null == coreBillIDs || null != coreBillIDs && coreBillIDs.length() == 0) {
                        bf2.append("and PURINWAREHSBILL.FID in " + sourceBillIDs);
                    } else if (null == sourceBillIDs || null != sourceBillIDs && sourceBillIDs.length() == 0) {
                        bf2.append("and ENTRY.FPURORDERID in " + coreBillIDs);
                    } else {
                        bf2.append("and ( PURINWAREHSBILL.FID in " + sourceBillIDs + "or ENTRY.FPURORDERID in " + coreBillIDs + ")");
                    }
                } else {
                    bf2.append(" and 1 <> 1");
                }
            } else {
                bf2.append(" and " + extend);
            }
            String sql2 = bf2.toString();
            this.executeCreateAsSelectInto(sql2, sqlParams, ctx);
        }
        String countSql = "select count(1) cc from " + tempTable2;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        if (null == this.result) {
            this.result = new RptParams();
        }
        this.result.setString("tempTable2", tempTable2);
        this.result.setString("index", "PurInWareshs");
        this.result.setObject("header2", (Object)this.getPurInRptHeader(ctx, extend, custFieldMap));
        this.result.setInt("verticalCount2", count);
    }

    private RptTableHeader getPurInRptHeader(Context ctx, String extend, Map custFieldMap) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col2 = null;
        col2 = new RptTableColumn("selected");
        col2.setWidth(40);
        header.addColumn(col2);
        col2 = new RptTableColumn("id");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("number");
        col2.setWidth(150);
        header.addColumn(col2);
        col2 = new RptTableColumn("bizDate");
        col2.setWidth(120);
        col2.setFormatPattern("yyyy-MM-dd");
        header.addColumn(col2);
        col2 = new RptTableColumn("supplier_name");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("companyOrgUnit_name");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("purOrderNumber");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("material_number");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("material_name");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("unit_name");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("lot");
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("qty");
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("baseQty");
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("purchaseCost");
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("purchaseFee");
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("actualCost");
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        ArrayList<String> listLabel = new ArrayList<String>();
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"selected", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"id", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"number", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"bizDate", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"supplier_name", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"companyOrgUnit_name", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_purOrderNumber", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"material_number", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"material_name", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"unit_name", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_lot", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_qty", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_baseQty", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_purchaseCost", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"purchaseFee", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_actualCost", (Context)ctx));
        if (null != extend && null != custFieldMap) {
            for (String name : custFieldMap.keySet()) {
                String value = (String)custFieldMap.get(name);
                listLabel.add(value);
                col2 = new RptTableColumn(name);
                col2.setWidth(120);
                col2.setAligment(2);
                header.addColumn(col2);
            }
        }
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_imputedCost", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"entry_id", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"companyOrgUnit_id", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"storageOrgUnit_id", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"fprecision", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"qtyPrecision", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"baseQtyPrecision", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"coreBillID", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"coreBillEntryID", (Context)ctx));
        listLabel.add(SCMUtils.getResource((String)RESOURCE_PATH, (String)"apportionAmount", (Context)ctx));
        col2 = new RptTableColumn("imputedCost");
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("entry_id");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("companyOrgUnit_id");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("storageOrgUnit_id");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("fprecision");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("qtyPrecision");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("baseQtyPrecision");
        col2.setHided(true);
        col2.setWidth(120);
        header.addColumn(col2);
        col2 = new RptTableColumn("coreBillID");
        col2.setHided(true);
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("coreBillEntryID");
        col2.setHided(true);
        col2.setWidth(120);
        col2.setAligment(2);
        header.addColumn(col2);
        col2 = new RptTableColumn("apportionAmount");
        col2.setWidth(120);
        col2.setAligment(2);
        col2.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
        header.addColumn(col2);
        int length = listLabel.size();
        Object[][] obj = new Object[1][length];
        for (int i = 0; i < length; ++i) {
            obj[0][i] = listLabel.get(i);
        }
        header.setLabels(obj, true);
        return header;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        Object object = params.getObject("index");
        String strParams = null;
        this.isDevolve = params.getBoolean("isDevolve");
        if (null != object && "PurExpense".equals(object)) {
            strParams = params.getString("purExpenseFilter");
            this.createPurExpenseTable(ctx, params, strParams);
        } else if (null != object && "PurInWareshs".equals(object)) {
            strParams = params.getString("purInWarehsFilter");
            this.createPurInWarehsTable(ctx, params, strParams);
        }
        return this.result;
    }

    protected RptParams _query(Context ctx, RptParams params, int start, int length) throws BOSException, EASBizException {
        String index = params.getString("index");
        RptParams para = new RptParams();
        if ("PurExpense".equals(index)) {
            String sql1 = "select * from " + params.getString("tempTable1") + " Order by number, bizDate, entry_id";
            RptRowSet rs1 = this.executeQuery(sql1, null, start, length, ctx);
            para.setObject("rowset1", (Object)rs1);
        } else if ("PurInWareshs".equals(index)) {
            String sql2 = "select T.*,0 as FapportionAmount from " + params.getString("tempTable2") + " T Order by number, bizDate, entry_id";
            RptRowSet rs2 = this.executeQuery(sql2, null, start, length, ctx);
            para.setObject("rowset2", (Object)rs2);
        }
        return para;
    }

    @Override
    protected String _getApportionStandard(Context ctx, String userid, String companyOrgUnitID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fstandard from T_CL_ExpenseApportionStandard");
        sql.append(" where fcompanyorgunitid = '").append(companyOrgUnitID).append("'");
        sql.append(" and fuserid = '").append(userid).append("'");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next() && rs.getString("fstandard") != null) {
                return rs.getString("fstandard");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e.getNextException());
        }
        return "HAND_DEAL";
    }

    @Override
    protected void _setApportionStandard(Context ctx, String userid, String companyOrgUnitID, String standard) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_CL_ExpenseApportionStandard");
        sql.append(" where fcompanyorgunitid = '").append(companyOrgUnitID).append("'");
        sql.append("   and fuserid = '").append(userid).append("'");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" insert into T_CL_ExpenseApportionStandard");
        sql2.append(" (FID,FCOMPANYORGUNITID,FUSERID,FSTANDARD)");
        sql2.append(" values (");
        sql2.append("  newbosid('expensea')");
        sql2.append(" ,'").append(companyOrgUnitID).append("'");
        sql2.append(" ,'").append(userid).append("'");
        sql2.append(" ,'").append(standard).append("'");
        sql2.append("  )");
        String[] s = new String[]{sql.toString(), sql2.toString()};
        com.kingdee.eas.scm.cal.util.DBUtil.execute(ctx, s);
    }

    private String createOtherBillEntryQuery() {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append("NEWBOSID('ED4DBC81') as entryID,");
        bf.append("OtherBillEntry.FID as fid,");
        bf.append("OtherBillEntry.FExpenseItemID as expenseItemID,");
        bf.append("OtherBillEntry.FMaterialid as materialID,");
        bf.append("OtherBillEntry.FParentID as parentID,");
        bf.append("OtherBillEntry.FSeq as seq,");
        bf.append("OtherBill.FNumber as number,");
        bf.append("OtherBill.FBizDate as bizDate");
        bf.append(" From T_AP_OtherBillentry as OtherBillEntry");
        bf.append(" INNER JOIN T_AP_OtherBill as OtherBill ON OtherBillEntry.FParentID = OtherBill.FID");
        bf.append(" Where OtherBillEntry.FID=?");
        return bf.toString();
    }

    private String createPurInWarehsEntryQuery() {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append("NEWBOSID('" + this.getSourceBosType(new ExpenseApportionEntryInfo()) + "') as entryID,");
        bf.append("PurInWarehsEntry.FID as fid,");
        bf.append("PurInWarehsBill.FNumber as number,");
        bf.append("PurInWarehsBill.FBizDate as bizDate,");
        bf.append("PurInWarehsEntry.FParentID as parentID,");
        bf.append("PurInWarehsEntry.FMaterialID as materialID,");
        bf.append("PurInWarehsEntry.FSeq as seq");
        bf.append(" From T_IM_PurInWarehsEntry as PurInWarehsEntry");
        bf.append(" INNER JOIN T_IM_PurInWarehsBill as PurInWarehsBill ON PurInWarehsEntry.FParentID = PurInWarehsBill.FID");
        bf.append(" Where PurInWarehsEntry.FID=?");
        return bf.toString();
    }

    private String createCostAdjustEntryQuery() {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append("NEWBOSID('" + this.getSourceBosType(new ExpenseApportionEntryInfo()) + "') as entryID,");
        bf.append("CostAdjustBillEntry.FID as fid,");
        bf.append("CostAdjustBill.FNumber as number,");
        bf.append("CostAdjustBillEntry.FAmount as amount,");
        bf.append("CostAdjustBillEntry.FParentID as parentID,");
        bf.append("CostAdjustBillEntry.FMaterialID as materialID,");
        bf.append("CostAdjustBillEntry.FSeq as seq");
        bf.append(" From T_CL_CostAdjustBillEntry as CostAdjustBillEntry");
        bf.append(" INNER JOIN T_CL_CostAdjustBill as CostAdjustBill ON CostAdjustBillEntry.FParentID = CostAdjustBill.FID");
        bf.append(" Where CostAdjustBillEntry.FID=?");
        return bf.toString();
    }

    private String createApportionQuery() {
        StringBuffer bf = new StringBuffer();
        bf.append("select TOP 1 ");
        bf.append(" NEWBOSID('" + this.getSourceBosType(new ExpenseApportionInfo()) + "') as id");
        bf.append(" from T_IM_PurInWarehsBill");
        return bf.toString();
    }

    public void createAportionListing(Context ctx, ApportionResultInfo info, List list) throws BOSException {
        ResultSet rs4;
        ResultSet rs3;
        ResultSet rs2;
        ResultSet rs1;
        PreparedStatement pm6;
        PreparedStatement pm5;
        PreparedStatement pm4;
        PreparedStatement pm3;
        PreparedStatement pm2;
        PreparedStatement pm1;
        Connection conn;
        block12: {
            String insertBillSql = "insert into T_CL_ExpenseApportion(FID,FCreateTime,FCreatorID,FControlUnitID,FCompanyOrgUnitID,FNumber,FApportionDate,FYear,FPeriod,FCreateType) values(?,?,?,?,?,?,?,?,?,?)";
            String insertEntrySql = "insert into T_CL_ExpenseApportionEntry (FID,FSeq,FParentID,FBillTypeID,FSourceNumber,FObjectID,FCurrApportionAmt,FBizDate,FSourceBillId,FSourceEntryId,FSourceSeq) values(?,?,?,?,?,?,?,?,?,?,?)";
            String querySql = this.createApportionQuery();
            String queryOtherBillEntrySql = this.createOtherBillEntryQuery();
            String queryPurInWarehsEntrySql = this.createPurInWarehsEntryQuery();
            String queryCostAdjustEntrySql = this.createCostAdjustEntryQuery();
            conn = null;
            pm1 = null;
            pm2 = null;
            pm3 = null;
            pm4 = null;
            pm5 = null;
            pm6 = null;
            rs1 = null;
            rs2 = null;
            rs3 = null;
            rs4 = null;
            try {
                BigDecimal amount;
                HashMap map;
                conn = EJBFactory.getConnection((Context)ctx);
                pm1 = conn.prepareStatement(querySql);
                rs1 = pm1.executeQuery();
                String number = String.valueOf(System.currentTimeMillis());
                if (!rs1.next()) break block12;
                String id = rs1.getString("id");
                pm2 = conn.prepareStatement(insertBillSql);
                pm2.setString(1, id);
                pm2.setTimestamp(2, this.getTime());
                pm2.setString(3, this.getCurrentUserID(ctx));
                pm2.setString(4, this.getControlUnitID(ctx));
                pm2.setString(5, info.getCompanyOrgUnitID());
                pm2.setString(6, number);
                pm2.setTimestamp(7, this.getTime());
                pm2.setInt(8, info.getYear());
                pm2.setInt(9, info.getPeriod());
                int createType = this.isDevolve ? 1 : 0;
                pm2.setInt(10, createType);
                pm2.execute();
                int i = 0;
                pm3 = conn.prepareStatement(insertEntrySql);
                pm4 = conn.prepareStatement(queryOtherBillEntrySql);
                for (String fid : info.getExpenseVoiceMap().keySet()) {
                    map = (HashMap)info.getExpenseVoiceMap().get(fid);
                    for (String entryID : map.keySet()) {
                        amount = null != map.get(entryID) ? (BigDecimal)map.get(entryID) : new BigDecimal("0.0");
                        pm4.setString(1, entryID);
                        rs2 = pm4.executeQuery();
                        if (!rs2.next()) continue;
                        pm3.setString(1, rs2.getString("entryID"));
                        pm3.setInt(2, ++i);
                        pm3.setString(3, id);
                        pm3.setString(4, "510b6503-0105-1000-e000-010fc0a812fd463ED552");
                        pm3.setString(5, rs2.getString("number"));
                        String expenseItemID = rs2.getString("expenseItemID");
                        if (expenseItemID == null || "".equals(expenseItemID.trim())) {
                            pm3.setString(6, rs2.getString("materialID"));
                        } else {
                            pm3.setString(6, rs2.getString("expenseItemID"));
                        }
                        pm3.setBigDecimal(7, amount);
                        pm3.setTimestamp(8, rs2.getTimestamp("bizDate"));
                        pm3.setString(9, fid);
                        pm3.setString(10, entryID);
                        pm3.setInt(11, rs2.getInt("seq"));
                        pm3.addBatch();
                    }
                }
                pm5 = conn.prepareStatement(queryPurInWarehsEntrySql);
                for (String fid : info.getPurInWarehsMap().keySet()) {
                    map = (HashMap)info.getPurInWarehsMap().get(fid);
                    for (String entryID : map.keySet()) {
                        amount = null != map.get(entryID) ? (BigDecimal)map.get(entryID) : new BigDecimal("0.0");
                        pm5.setString(1, entryID);
                        rs3 = pm5.executeQuery();
                        if (!rs3.next()) continue;
                        pm3.setString(1, rs3.getString("entryID"));
                        pm3.setInt(2, ++i);
                        pm3.setString(3, id);
                        pm3.setString(4, "50957179-0105-1000-e000-015fc0a812fd463ED552");
                        pm3.setString(5, rs3.getString("number"));
                        pm3.setString(6, rs3.getString("materialID"));
                        pm3.setBigDecimal(7, amount);
                        pm3.setTimestamp(8, rs3.getTimestamp("bizDate"));
                        pm3.setString(9, fid);
                        pm3.setString(10, entryID);
                        pm3.setInt(11, rs3.getInt("seq"));
                        pm3.addBatch();
                    }
                }
                pm6 = conn.prepareStatement(queryCostAdjustEntrySql);
                for (String fid : list) {
                    pm6.setString(1, fid);
                    rs4 = pm6.executeQuery();
                    if (!rs4.next()) continue;
                    pm3.setString(1, rs4.getString("entryID"));
                    pm3.setInt(2, ++i);
                    pm3.setString(3, id);
                    pm3.setString(4, "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552");
                    pm3.setString(5, rs4.getString("number"));
                    pm3.setString(6, rs4.getString("materialID"));
                    pm3.setBigDecimal(7, rs4.getBigDecimal("amount"));
                    pm3.setTimestamp(8, info.getBizDate());
                    pm3.setString(9, rs4.getString("parentID"));
                    pm3.setString(10, rs4.getString("fid"));
                    pm3.setInt(11, rs4.getInt("seq"));
                    pm3.addBatch();
                }
                if (i > 0) {
                    pm3.executeBatch();
                }
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtil.close(conn, new PreparedStatement[]{pm1, pm2, pm3, pm4, pm5, pm6}, new ResultSet[]{rs1, rs2, rs3, rs4});
                    throw throwable;
                }
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm1, pm2, pm3, pm4, pm5, pm6}, new ResultSet[]{rs1, rs2, rs3, rs4});
    }

    private String getCurrentUserID(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return userInfo.getId().toString();
    }

    private String getControlUnitID(Context ctx) {
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return null == ctrlUnitInfo ? "" : ctrlUnitInfo.getId().toString();
    }

    private String getCurrCompanyOrgUnitID(Context ctx) {
        CompanyOrgUnitInfo companyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        return companyOrgUnitInfo.getId().toString();
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        createtime.toString();
        return createtime;
    }

    private Timestamp getTime(Date date) {
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        createtime.toString();
        return createtime;
    }

    private String getSourceBosType(Object obj) {
        String temp = null;
        if (obj instanceof ExpenseApportionInfo) {
            temp = ((ExpenseApportionInfo)obj).getBOSType().toString();
        } else if (obj instanceof ExpenseApportionEntryInfo) {
            temp = ((ExpenseApportionEntryInfo)obj).getBOSType().toString();
        } else if (obj instanceof CostAdjustBillInfo) {
            temp = ((CostAdjustBillInfo)obj).getBOSType().toString();
        } else if (obj instanceof CostAdjustBillEntryInfo) {
            temp = ((CostAdjustBillEntryInfo)obj).getBOSType().toString();
        } else if (((CoreBaseInfo)obj).getBOSType().equals((Object)BOSObjectType.create((String)"ED4DBC81"))) {
            temp = BOSObjectType.create((String)"ED4DBC81").toString();
        }
        return temp;
    }

    private HashMap getPeroid(Context ctx, Map map, String table) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append("Max(FYear * 100 + FPeriod) as maxPeriod,");
        bf.append("Max(FBizDate) as maxBizDate ");
        bf.append("from " + table);
        int i = 0;
        for (String id : map.keySet()) {
            if (1 == ++i) {
                bf.append(" where FID='" + id + "'");
                continue;
            }
            bf.append(" or FID='" + id + "'");
        }
        String sql = bf.toString();
        IRowSet rs = null;
        HashMap<String, Comparable<Integer>> period = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            period = new HashMap<String, Comparable<Integer>>();
            if (rs.next()) {
                period.put("maxPeriod", new Integer(rs.getInt("maxPeriod")));
                period.put("maxBizDate", rs.getTimestamp("maxBizDate"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return period;
    }

    private void setPeriod(Context ctx, ApportionResultInfo info) throws BOSException, EASBizException {
        HashMap expenseVoice = this.getPeroid(ctx, info.getExpenseVoiceMap(), "T_AP_OtherBill");
        int expenseMaxPeriod = (Integer)expenseVoice.get("maxPeriod");
        Timestamp expenseMaxBizDate = (Timestamp)expenseVoice.get("maxBizDate");
        HashMap purInWarehs = this.getPeroid(ctx, info.getPurInWarehsMap(), "T_IM_PurInWarehsBill");
        int warehsMaxPeriod = (Integer)purInWarehs.get("maxPeriod");
        Timestamp warehsMaxBizDate = (Timestamp)purInWarehs.get("maxBizDate");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)info.getCompanyOrgUnitID()));
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)pk);
        Date temp = curPeriodInfo.getBeginDate();
        Timestamp currBizDate = this.getTime(temp);
        int periodNumber = 190001;
        Timestamp bizDate = null;
        bizDate = warehsMaxBizDate.compareTo(expenseMaxBizDate) >= 0 ? warehsMaxBizDate : expenseMaxBizDate;
        bizDate = bizDate.compareTo(currBizDate) >= 0 ? bizDate : currBizDate;
        periodNumber = expenseMaxPeriod >= warehsMaxPeriod ? expenseMaxPeriod : warehsMaxPeriod;
        periodNumber = periodNumber >= curPeriodInfo.getNumber() ? periodNumber : curPeriodInfo.getNumber();
        info.setBizDate(bizDate);
        info.setYear(periodNumber / 100);
        info.setPeriod(periodNumber % 100);
    }

    public void updatePurInWarehs(Context ctx, Map map) throws BOSException {
        String updateSql = "update T_IM_PurInWarehsEntry set FImputedCost=FImputedCost+? where FID=?";
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = this.getConnection(ctx);
            pm = conn.prepareStatement(updateSql);
            Iterator iter1 = map.keySet().iterator();
            while (iter1.hasNext()) {
                HashMap hashMap = (HashMap)map.get(iter1.next());
                for (String entryID : hashMap.keySet()) {
                    BigDecimal amount = null != hashMap.get(entryID) ? (BigDecimal)hashMap.get(entryID) : new BigDecimal("0.0");
                    pm.setBigDecimal(1, amount);
                    pm.setString(2, entryID);
                    pm.execute();
                }
            }
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (null != pm) {
                    pm.close();
                }
                if (null != conn) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private Map<IObjectPK, PurInWarehsBillInfo> getPurInWarehsBillCollectionMap(Context ctx, Map purBillMap) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        HashMap<IObjectPK, PurInWarehsBillInfo> purInfoMap = new HashMap<IObjectPK, PurInWarehsBillInfo>();
        Iterator iter1 = purBillMap.keySet().iterator();
        while (iter1.hasNext()) {
            String purBillId = iter1.next().toString();
            idSet.add(purBillId);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getPurInBillSelector4Cal());
        PurInWarehsBillCollection coll = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillCollection(view);
        PurInWarehsBillInfo purInfo = null;
        if (coll != null && coll.size() > 0) {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                purInfo = coll.get(i);
                purInfoMap.put((IObjectPK)new ObjectUuidPK(purInfo.getId()), purInfo);
            }
        }
        return purInfoMap;
    }

    private Map<IObjectPK, PurInWarehsEntryInfo> getPurInWarehsBillEntryCollectionMap(Context ctx, Map purBillMap) throws BOSException {
        HashSet<String> entryIdSet = new HashSet<String>();
        HashMap<IObjectPK, PurInWarehsEntryInfo> purEntryInfoMap = new HashMap<IObjectPK, PurInWarehsEntryInfo>();
        Iterator iter1 = purBillMap.keySet().iterator();
        while (iter1.hasNext()) {
            String purBillId = iter1.next().toString();
            HashMap purEntryMap = (HashMap)purBillMap.get(purBillId);
            Iterator iter2 = purEntryMap.keySet().iterator();
            while (iter2.hasNext()) {
                String purEntryId = iter2.next().toString();
                entryIdSet.add(purEntryId);
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getPurInEntrySelector((boolean)false));
        PurInWarehsEntryCollection entryColl = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(view);
        PurInWarehsEntryInfo purEntryInfo = null;
        if (entryColl != null && entryColl.size() > 0) {
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                purEntryInfo = entryColl.get(i);
                purEntryInfoMap.put((IObjectPK)new ObjectUuidPK(purEntryInfo.getId()), purEntryInfo);
            }
        }
        return purEntryInfoMap;
    }

    private Map<String, MaterialCompanyInfoInfo> getMaterialCompanyMap(Context ctx, Map<IObjectPK, PurInWarehsEntryInfo> purEntryInfoMap) throws BOSException {
        HashMap<String, MaterialCompanyInfoInfo> materialComMap = new HashMap<String, MaterialCompanyInfoInfo>();
        PurInWarehsEntryInfo purEntryInfo = null;
        String materialID = null;
        String couID = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        IObjectPK pk2 = null;
        for (IObjectPK pk2 : purEntryInfoMap.keySet()) {
            purEntryInfo = purEntryInfoMap.get(pk2);
            materialID = purEntryInfo.getMaterial().getId().toString();
            couID = purEntryInfo.getCompanyOrgUnit().getId().toString();
            filter.getFilterItems().add(new FilterItemInfo("mateial", (Object)materialID));
            filter.getFilterItems().add(new FilterItemInfo("company", (Object)couID));
        }
        StringBuffer maskString = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size() / 2; ++i) {
            maskString.append("(#").append(2 * i).append(" and #").append(2 * i + 1).append(")");
            if (i >= filter.getFilterItems().size() / 2 - 1) continue;
            maskString.append(" or ");
        }
        filter.setMaskString(maskString.toString());
        view.setFilter(filter);
        MaterialCompanyInfoCollection collection = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(view);
        String key = null;
        for (int i = 0; i < collection.size(); ++i) {
            key = collection.get(i).getMateial().getId().toString() + collection.get(i).getCompany().getId().toString();
            materialComMap.put(key, collection.get(i));
        }
        return materialComMap;
    }

    @Override
    protected void _apportion(Context ctx, ApportionResultInfo info) throws BOSException, EASBizException {
        this.setPeriod(ctx, info);
        ArrayList costList = new ArrayList();
        ArrayList list = new ArrayList();
        HashMap purBillMap = info.getPurInWarehsMap();
        ArrayList updatePursqlList = new ArrayList();
        ArrayList updateOtherList = new ArrayList();
        ArrayList updatePurBillList = new ArrayList();
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String value = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnitID()), "SCM_CAL_011");
        this.isAdjust = CalculateUtil.getCalParamValue(ctx, info.getCompanyOrgUnitID(), "SCM_CAL_012").equalsIgnoreCase("true");
        boolean tempValue = Boolean.valueOf(value);
        this.isDevolve = info.isDevolve();
        Map<IObjectPK, PurInWarehsBillInfo> purInfoMap = this.getPurInWarehsBillCollectionMap(ctx, purBillMap);
        Map<IObjectPK, PurInWarehsEntryInfo> purEntryInfoMap = this.getPurInWarehsBillEntryCollectionMap(ctx, purBillMap);
        Map<String, MaterialCompanyInfoInfo> materialComMap = this.getMaterialCompanyMap(ctx, purEntryInfoMap);
        BigDecimal apportionAmount = null;
        BigDecimal FPurchaseFee = null;
        BigDecimal balance = null;
        PurInWarehsBillInfo purInWarehsBillInfo = null;
        PurInWarehsEntryInfo purEntryInfo = null;
        MaterialCompanyInfoInfo materinfo = null;
        Iterator iter1 = purBillMap.keySet().iterator();
        while (iter1.hasNext()) {
            String purBillId = iter1.next().toString();
            ObjectUuidPK purBillPk = new ObjectUuidPK(purBillId);
            purInWarehsBillInfo = purInfoMap.get(purBillPk);
            if (purInWarehsBillInfo == null) {
                purInWarehsBillInfo = PurInWarehsBillFactory.getLocalInstance((Context)ctx).getPurInWarehsBillInfo((IObjectPK)purBillPk, SCMSelectorFactory.getPurInBillSelector4Cal());
            }
            CostAdjustBillInfo costBillInfo = this.createOrFindCostAdJust(costList, purInWarehsBillInfo, info, ctx, costList);
            HashMap purEntryMap = (HashMap)purBillMap.get(purBillId);
            int i = 0;
            Iterator iter2 = purEntryMap.keySet().iterator();
            while (iter2.hasNext()) {
                BigDecimal imputedCost;
                AccountType accountType;
                String purEntryId = iter2.next().toString();
                ObjectUuidPK pk = new ObjectUuidPK(purEntryId);
                purEntryInfo = purEntryInfoMap.get(pk);
                if (purEntryInfo == null) {
                    purEntryInfo = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryInfo((IObjectPK)pk, SCMSelectorFactory.getPurInEntrySelector((boolean)false));
                }
                String couID = purEntryInfo.getCompanyOrgUnit().getId().toString();
                String materialID = purEntryInfo.getMaterial().getId().toString();
                materinfo = materialComMap.get(materialID + couID);
                if (materinfo == null) {
                    materinfo = MaterialFactory.getLocalInstance((Context)ctx).getCompanyInfo(materialID, couID);
                }
                if ((accountType = materinfo.getAccountType()).equals((Object)AccountType.MOVE_ADD_AVERAGE)) {
                    BigDecimal imputedCost2 = purEntryInfo.getImputedCost();
                    apportionAmount = new BigDecimal(purEntryMap.get(purEntryId).toString());
                    if (imputedCost2.compareTo(new BigDecimal("0.0")) == 0) {
                        FPurchaseFee = purEntryInfo.getPurchaseFee();
                        balance = apportionAmount.subtract(FPurchaseFee);
                        this.createAdCostBillEntry(purEntryInfo, purInWarehsBillInfo, ++i, costBillInfo, balance, list, false);
                    } else {
                        this.createAdCostBillEntry(purEntryInfo, purInWarehsBillInfo, ++i, costBillInfo, apportionAmount, list, false);
                    }
                    this.updatePur(purEntryId, apportionAmount, updatePursqlList, false, false);
                    continue;
                }
                int Year = purInWarehsBillInfo.getYear();
                int Month = purInWarehsBillInfo.getPeriod();
                PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)purEntryInfo.getCompanyOrgUnit());
                boolean tempTag = false;
                int currYear = currentPeriodInfo.getPeriodYear();
                int currMonth = currentPeriodInfo.getPeriodNumber();
                if (Year == currYear) {
                    if (Month >= currMonth) {
                        tempTag = true;
                    }
                } else if (Year > currYear) {
                    tempTag = true;
                }
                if (!purInWarehsBillInfo.isFiVouchered() && tempTag && tempValue) {
                    imputedCost = purEntryInfo.getImputedCost();
                    apportionAmount = new BigDecimal(purEntryMap.get(purEntryId).toString());
                    if (imputedCost.compareTo(new BigDecimal("0.0")) == 0) {
                        this.updatePur(purEntryId, apportionAmount, updatePursqlList, true, false);
                        continue;
                    }
                    this.updatePur(purEntryId, apportionAmount, updatePursqlList, true, true);
                    continue;
                }
                imputedCost = purEntryInfo.getImputedCost();
                apportionAmount = new BigDecimal(purEntryMap.get(purEntryId).toString());
                if (imputedCost.compareTo(new BigDecimal("0.0")) == 0) {
                    FPurchaseFee = purEntryInfo.getPurchaseFee();
                    balance = apportionAmount.subtract(FPurchaseFee);
                    ++i;
                    if (accountType.equals((Object)AccountType.SPECIAL_ACCT)) {
                        this.createAdCostBillEntry(purEntryInfo, purInWarehsBillInfo, i, costBillInfo, balance, list, true);
                    } else {
                        this.createAdCostBillEntry(purEntryInfo, purInWarehsBillInfo, i, costBillInfo, balance, list, false);
                    }
                } else {
                    ++i;
                    if (accountType.equals((Object)AccountType.SPECIAL_ACCT)) {
                        this.createAdCostBillEntry(purEntryInfo, purInWarehsBillInfo, i, costBillInfo, apportionAmount, list, true);
                    } else {
                        this.createAdCostBillEntry(purEntryInfo, purInWarehsBillInfo, i, costBillInfo, apportionAmount, list, false);
                    }
                }
                this.updatePur(purEntryId, apportionAmount, updatePursqlList, false, false);
            }
        }
        this.updatePurAndOther(info, updateOtherList);
        com.kingdee.eas.scm.cal.util.DBUtil.execBatchSql(ctx, updatePursqlList, true);
        com.kingdee.eas.scm.cal.util.DBUtil.execBatchSql(ctx, updatePurBillList, true);
        com.kingdee.eas.scm.cal.util.DBUtil.execBatchSql(ctx, updateOtherList, true);
        ICostAdjustBill costadjust = CostAdjustBillFactory.getLocalInstance(ctx);
        ArrayList<IObjectPK> pkArray = new ArrayList<IObjectPK>();
        for (int i = 0; i < costList.size(); ++i) {
            CostAdjustBillInfo costInfo = (CostAdjustBillInfo)costList.get(i);
            if (costInfo.getEntry().size() <= 0) continue;
            pkArray.add(costadjust.addnew((CoreBaseInfo)costInfo));
        }
        if (CalculateUtil.getApportVoucherType(ctx, info.getCompanyOrgUnitID())) {
            HashMap expenseVoiceMap = info.getExpenseVoiceMap();
            String expenseVoiceId = "";
            Iterator iterator = expenseVoiceMap.keySet().iterator();
            if (iterator.hasNext()) {
                expenseVoiceId = (String)iterator.next();
            }
            this.reverseApportionDetail(ctx, expenseVoiceId, list);
        }
        this.createAportionListing(ctx, info, list);
        this.setApportionStandard(ctx, this.getCurrentUserID(ctx), this.getCurrCompanyOrgUnitID(ctx), info.getStandard());
        for (int i = 0; i < pkArray.size(); ++i) {
            costadjust.audit((IObjectPK)pkArray.get(i));
        }
    }

    private void reverseApportionDetail(Context ctx, String expenseVoiceId, List list) throws BOSException, EASBizException {
        if (list == null || list.size() == 0) {
            return;
        }
        StringBuffer strid = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                strid.append(",");
            }
            strid.append("'").append(list.get(i)).append("'");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into T_AP_OtherBillExpApportion (FID,FParentID,FCostAdjustBillId,FCostCenterID,FIssueType,FCreateType,");
        sqlBuffer.append("FCalculateKind,FSupplierID,FCustomerID,FEntryId,FCostObjectID,FMaterialID,FCompanyOrgUnitID,FWarehouseID,FUnitID,FLot,FQty,FPrice,");
        sqlBuffer.append("FAmount,FSeq,FSourceBillNumber,FSourceBillEntrySeq,FStorageOrgUnitID,FAdminOrgUnitID ,FStockerID ,FVoucherID,");
        sqlBuffer.append("FTotalQty,FTotalAmount,FFiVouchered ,FTotalStandardCost,FTotalActualCost,FIsReversed,FTransactionTypeID,");
        sqlBuffer.append("FIsInitBill,FAuditTime ,FBaseStatus,FBizTypeID,FSourceBillTypeID,FBillTypeID,FYear,FPeriod,FModifierID,FModificationTime,");
        sqlBuffer.append("FNumber,FBizDate,FHandlerID,FDescription,FHasEffected,FAuditorID,FSourceBillID,FSourceFunction,FCreatorID,FCreateTime,");
        sqlBuffer.append("FLastUpdateUserID,FLastUpdateTime,FControlUnitID)\n");
        sqlBuffer.append("select NEWBOSID('").append(EXPAPPORT_BOSTYPE).append("'),");
        sqlBuffer.append("'").append(expenseVoiceId).append("',");
        sqlBuffer.append("a.FID,a.FCostCenterOrgUnitID,a.FIssueType,a.FCreateType,a.FCalculateKind,a.FSupplierID,a.FCustomerID,b.FID,b.FCostObjectID,");
        sqlBuffer.append("b.FMaterialID,b.FCompanyOrgUnitID,b.FWarehouseID,b.FUnitID,b.FLot,b.FQty,b.FPrice,b.FAmount,b.FSeq,b.FSourceBillNumber,b.FSourceBillEntrySeq,");
        sqlBuffer.append("a.FStorageOrgUnitID,a.FAdminOrgUnitID,a.FStockerID,a.FVoucherID,a.FTotalQty,a.FTotalAmount,a.FFiVouchered,a.FTotalStandardCost,");
        sqlBuffer.append("a.FTotalActualCost,a.FIsReversed,a.FTransactionTypeID,a.FIsInitBill,a.FAuditTime,4,a.FBizTypeID,a.FSourceBillTypeID,");
        sqlBuffer.append("a.FBillTypeID,a.FYear,a.FPeriod,a.FModifierID,a.FModificationTime,a.FNumber,a.FBizDate,a.FHandlerID,a.FDescription,a.FHasEffected,");
        sqlBuffer.append("a.FAuditorID,a.FSourceBillID,a.FSourceFunction,a.FCreatorID,a.FCreateTime,a.FLastUpdateUserID,a.FLastUpdateTime,a.FControlUnitID ");
        sqlBuffer.append("from T_CL_CostAdjustBill a inner join T_CL_CostAdjustBillEntry b on a.FID=b.FParentID \n");
        sqlBuffer.append("where b.FID in(").append(strid.toString()).append(")");
        String sSQL = sqlBuffer.toString();
        com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _deleteExpenseApportion(Context ctx, String[] ids) throws BOSException, EASBizException {
        String companyOrgUnitID = this.check(ctx, ids);
        if (companyOrgUnitID == null) throw new ExpenseApportionException(ExpenseApportionException.COMPANYORGUNIT_IS_NULL);
        if ("".equals(companyOrgUnitID)) {
            throw new ExpenseApportionException(ExpenseApportionException.COMPANYORGUNIT_IS_NULL);
        }
        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyOrgUnitID));
        StringBuffer sqldel = new StringBuffer();
        sqldel.append("SELECT ");
        sqldel.append("bill.FNumber,");
        sqldel.append("0 AS FQty,");
        sqldel.append("factualcost AS FCost,");
        sqldel.append("entry.FMaterialID AS FMaterialID,");
        sqldel.append("materialcompany.FAccountType AS FAccountType ,");
        sqldel.append("entry.FCompanyOrgUnitID AS FCompanyOrgUnitID,");
        sqldel.append("entry.FStorageOrgUnitID AS FStorageOrgUnitID,");
        sqldel.append("entry.FWarehouseID AS FWarehouseID ");
        sqldel.append("        ,MATERIAL.FPricePrecision AS FPricePrecision");
        sqldel.append("        ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sqldel.append("        ,CURRENCY.FPrecision AS FLocalCurrencyPrecision");
        sqldel.append("        ,T_SCM_BillType.FName_").append(ctx.getLocale().toString()).append(" AS FDescriptionName");
        sqldel.append(" FROM t_cl_costadjustbill bill ");
        sqldel.append(" inner join t_cl_costadjustbillentry entry on bill.fid=entry.fparentid ");
        sqldel.append(" INNER JOIN T_BD_MaterialCompanyInfo materialcompany ");
        sqldel.append(" ON (entry.FMaterialID = materialcompany.FMaterialID ");
        sqldel.append(" AND entry.FCompanyOrgUnitID = materialcompany.FCompanyID )");
        sqldel.append(" INNER JOIN T_BD_Material MATERIAL ");
        sqldel.append(" ON entry.FMaterialID = MATERIAL.FId");
        sqldel.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sqldel.append(" ON (entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sqldel.append(" AND MATERIAL.FBaseUnit = MeasureUnitBase.FMeasureUnitID )");
        sqldel.append(" INNER JOIN T_SCM_BillType ON T_SCM_BillType.FID='").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sqldel.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sqldel.append(" ON entry.FCompanyOrgUnitID = COMPANY.FID");
        sqldel.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sqldel.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sqldel.append(" WHERE materialcompany.FAccountType = 1");
        sqldel.append(" AND entry.FID in ");
        sqldel.append(" (");
        sqldel.append(" SELECT FSourceEntryId FROM T_CL_ExpenseApportionEntry");
        sqldel.append(" WHERE FParentid in (").append(this.getIdArrayToStrng(ids)).append(")");
        sqldel.append("   AND FBillTypeID = '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        sqldel.append(" )");
        sqldel.append(" Order by bill.FNumber,entry.Fseq");
        MoveWeightedAverageCalculate mwac = new MoveWeightedAverageCalculate();
        mwac.unCalculateCost(ctx, sqldel.toString(), CalculateKindEnum.INPUT_WAREHOUSE);
        mwac.commit(ctx);
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select distinct A.FSourceBillId as sourceBillId, B.FSourceBillEntryID as sourceEntryId");
        sql1.append(" from T_CL_ExpenseApportionEntry A Inner join T_CL_CostAdjustBillEntry B");
        sql1.append(" on B.FParentID = A.FSourceBillId");
        sql1.append(" where A.FParentID = ? and A.FBillTypeID = ?");
        String querySql1 = sql1.toString();
        String delCostAdjustEntrySql = "delete from T_CL_CostAdjustBillEntry where FParentID = ?";
        String delCostAdjustBillSql = "delete from T_CL_CostAdjustBill where FID = ?";
        String deleteApportRecordSql = "delete from T_AP_OtherBillExpApportion where FCostAdjustBillId = ?";
        boolean isMergeVoucher = CalculateUtil.getApportVoucherType(ctx, companyOrgUnitID);
        StringBuffer sql2 = new StringBuffer();
        sql2.append("select PurInWarehsEntry.FParentId as ParentId, PurInWarehsEntry.FID as id,PurInWarehsEntry.FActualCost,PurInWarehsEntry.FImputedCost as PurInImputedCost,");
        sql2.append("(ExpenseApportionEntry.FCurrApportionAmt) as imputedCost");
        sql2.append(" from T_CL_ExpenseApportionEntry AS ExpenseApportionEntry");
        sql2.append(" left outer join T_IM_PurInWarehsEntry as PurInWarehsEntry");
        sql2.append(" on ExpenseApportionEntry.FSourceEntryId = PurInWarehsEntry.FID");
        sql2.append(" where ExpenseApportionEntry.FParentID = ?");
        sql2.append(" and ExpenseApportionEntry.FBillTypeID = ?");
        String querySql2 = sql2.toString();
        String updatePurInWarehsEntrySql = "update T_IM_PurInWarehsEntry set FImputedCost = FImputedCost-? where FID =? ";
        String updatePurchaseFeeSql = "update T_IM_PurInWarehsEntry set FPurchaseFee = FPurchaseFee-? where FID =? and  exists (select 1 from T_IM_PurInWarehsBill where  isnull(FFiVouchered,0) = 0 and fid in (  select fparentid from T_IM_PurInWarehsEntry  where fid = ? ) and ( fyear > ? or fyear = ? and fperiod >= ?) )";
        String updateActualCostSql = WriteOffHelp.getCalcPurActualCostSQL() + " and exists (select 1 from T_IM_PurInWarehsBill where fid in ( select fparentid from T_IM_PurInWarehsEntry  where fid = ? )  and ( fyear > ? or fyear = ? and fperiod >= ? ) )";
        StringBuffer sql3 = new StringBuffer();
        sql3.append("select t2.FCurrApportionAmt as ImputedCost,");
        sql3.append(" t1.fid as Fid from T_AP_OtherBillentry t1");
        sql3.append(" inner join T_CL_ExpenseApportionEntry t2");
        sql3.append(" on t1.fid=t2.fsourceentryid");
        sql3.append(" where t2.FParentID = ? and t2.FBillTypeID=?");
        String querySql3 = sql3.toString();
        String updateOtherbillEntrySQL = "update T_AP_OtherBillentry set FApportionAmount=FApportionAmount-? ,FUnApportionAmount=FUnApportionAmount+? where FID =?";
        String delApporListBillSql = "delete from T_CL_ExpenseApportion where FID = ?";
        String delApporListEntrySql = "delete from T_CL_ExpenseApportionEntry where FParentID = ?";
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        PreparedStatement pm3 = null;
        PreparedStatement pm4 = null;
        PreparedStatement pm5 = null;
        PreparedStatement pm6 = null;
        PreparedStatement pm7 = null;
        PreparedStatement pm8 = null;
        PreparedStatement pm9 = null;
        PreparedStatement pm10 = null;
        PreparedStatement pm11 = null;
        PreparedStatement pm12 = null;
        Object pm13 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        ArrayList<String> costAdjBillId = new ArrayList<String>();
        ArrayList<String> sourceBillIdList = new ArrayList<String>();
        ArrayList<String> sourceEntryIdList = new ArrayList<String>();
        ArrayList<String> purBillIdSet = new ArrayList<String>();
        try {
            StringBuffer sqlIds = new StringBuffer();
            for (String s : ids) {
                sqlIds.append("'").append(s).append("',");
            }
            sqlIds.setLength(sqlIds.length() - 1);
            StringBuffer billNumber = new StringBuffer();
            String querySql = "select FSOURCENUMBER from T_CL_ExpenseApportionEntry entry inner join T_CL_ExpenseApportion ea on ea.fid = entry.fparentid where ea.fid in (" + sqlIds + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
            while (rs.next()) {
                billNumber.append(rs.getString("FSOURCENUMBER")).append(";");
            }
            if (billNumber.length() > 0) {
                billNumber.setLength(billNumber.length() - 1);
                if (billNumber.length() > 1200) {
                    billNumber.setLength(1200);
                }
            }
            String title = EASResource.getString((String)RES, (String)"delPurExpenseApportion");
            IObjectPK pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("FDB07C43"), null, (String)billNumber.toString(), (String)title);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
            conn = this.getConnection(ctx);
            pm1 = conn.prepareStatement(querySql1);
            pm2 = conn.prepareStatement(delCostAdjustBillSql);
            pm3 = conn.prepareStatement(delCostAdjustEntrySql);
            pm4 = conn.prepareStatement(querySql2);
            pm5 = conn.prepareStatement(updatePurInWarehsEntrySql);
            pm6 = conn.prepareStatement(delApporListBillSql);
            pm7 = conn.prepareStatement(delApporListEntrySql);
            pm8 = conn.prepareStatement(deleteApportRecordSql);
            pm9 = conn.prepareStatement(querySql3);
            pm10 = conn.prepareStatement(updateOtherbillEntrySQL);
            pm11 = conn.prepareStatement(updatePurchaseFeeSql);
            pm12 = conn.prepareStatement(updateActualCostSql);
            for (int i = 0; null != ids && i < ids.length; ++i) {
                pm1.setString(1, ids[i]);
                pm1.setString(2, "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552");
                rs1 = pm1.executeQuery();
                while (rs1.next()) {
                    String sourceBillId = rs1.getString("sourceBillId");
                    sourceEntryIdList.add(rs1.getString("sourceEntryId"));
                    if (sourceBillIdList.indexOf(sourceBillId) > -1) continue;
                    sourceBillIdList.add(sourceBillId);
                    costAdjBillId.add(sourceBillId);
                    pm2.setString(1, sourceBillId);
                    pm3.setString(1, sourceBillId);
                    pm2.addBatch();
                    pm3.addBatch();
                    if (!isMergeVoucher) continue;
                    pm8.setString(1, sourceBillId);
                    pm8.addBatch();
                }
                pm8.executeBatch();
                pm4.setString(1, ids[i]);
                pm4.setString(2, "50957179-0105-1000-e000-015fc0a812fd463ED552");
                rs2 = pm4.executeQuery();
                while (rs2.next()) {
                    if (purBillIdSet.indexOf(rs2.getString("ParentId")) == -1) {
                        purBillIdSet.add(rs2.getString("ParentId"));
                    }
                    String entryId = rs2.getString("id");
                    BigDecimal actualCost = rs2.getBigDecimal("FActualCost");
                    BigDecimal imputedCost = rs2.getBigDecimal("imputedCost");
                    pm5.setBigDecimal(1, imputedCost);
                    pm5.setString(2, entryId);
                    pm5.addBatch();
                    if (sourceEntryIdList.indexOf(entryId) != -1) continue;
                    if (actualCost.abs().compareTo(imputedCost.abs()) < 0) {
                        throw new ExpenseApportionException(ExpenseApportionException.PURIN_ACTUAL_ZERO);
                    }
                    pm11.setBigDecimal(1, imputedCost);
                    pm11.setString(2, entryId);
                    pm11.setString(3, entryId);
                    pm11.setInt(4, currPeriodInfo.getPeriodYear());
                    pm11.setInt(5, currPeriodInfo.getPeriodYear());
                    pm11.setInt(6, currPeriodInfo.getPeriodNumber());
                    pm11.execute();
                    pm12.setString(1, entryId);
                    pm12.setString(2, entryId);
                    pm12.setString(3, entryId);
                    pm12.setInt(4, currPeriodInfo.getPeriodYear());
                    pm12.setInt(5, currPeriodInfo.getPeriodYear());
                    pm12.setInt(6, currPeriodInfo.getPeriodNumber());
                    pm12.execute();
                }
                pm5.executeBatch();
                pm9.setString(1, ids[i]);
                pm9.setString(2, "510b6503-0105-1000-e000-010fc0a812fd463ED552");
                rs3 = pm9.executeQuery();
                while (rs3.next()) {
                    pm10.setBigDecimal(1, rs3.getBigDecimal("ImputedCost"));
                    pm10.setBigDecimal(2, rs3.getBigDecimal("ImputedCost"));
                    pm10.setString(3, rs3.getString("FId"));
                    pm10.execute();
                }
                pm6.setString(1, ids[i]);
                pm7.setString(1, ids[i]);
                pm6.execute();
                pm7.execute();
            }
            if (costAdjBillId.size() > 0) {
                this.deleteRelationCostAdjBill(ctx, costAdjBillId.toArray(new String[costAdjBillId.size()]));
            }
            pm2.executeBatch();
            pm3.executeBatch();
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm1, pm2, pm3, pm4, pm5, pm6, pm7, pm8, pm9, pm10, pm11, pm12, pm13}, new ResultSet[]{rs1, rs2, rs3});
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm1, pm2, pm3, pm4, pm5, pm6, pm7, pm8, pm9, pm10, pm11, pm12, pm13}, new ResultSet[]{rs1, rs2, rs3});
    }

    private String getIdArrayToStrng(String[] ids) {
        if (ids != null && ids.length > 0) {
            StringBuffer id = new StringBuffer();
            for (int i = 0; i < ids.length; ++i) {
                String temp = ids[i];
                if (temp == null || temp.length() <= 0) continue;
                id.append(",'");
                id.append(temp);
                id.append("'");
            }
            if (id.length() > 0) {
                return id.toString().replaceFirst(",", "");
            }
        }
        return "' '";
    }

    private String check(Context ctx, String[] ids) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("select");
        bf.append(" distinct ExpenseApportionEntry.FSourceBillId as sourceBillId,");
        bf.append(" ExpenseApportion.FCompanyOrgUnitID as companyOrgUnitID,ExpenseApportionEntry.FBillTypeID as FBillTypeID,");
        bf.append(" ExpenseApportion.FYear as curYear,");
        bf.append(" ExpenseApportion.FPeriod as curPeriod,");
        bf.append(" CostAdjustBill.FFiVouchered as fiVouchered ");
        bf.append(" from T_CL_ExpenseApportion as ExpenseApportion");
        bf.append(" inner join T_CL_ExpenseApportionEntry as ExpenseApportionEntry");
        bf.append(" on ExpenseApportion.FID = ExpenseApportionEntry.FParentID");
        bf.append(" left outer join T_CL_CostAdjustBill as CostAdjustBill");
        bf.append(" on ExpenseApportionEntry.FSourceBillId = CostAdjustBill.FID");
        for (int i = 0; null != ids && i < ids.length; ++i) {
            if (0 == i) {
                bf.append(" where ExpenseApportion.FID='" + ids[i] + "'");
                continue;
            }
            bf.append(" or ExpenseApportion.FID='" + ids[i] + "'");
        }
        String sql = bf.toString();
        String companyOrgUnitID = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            int currYear = 0;
            int currPeriod = 0;
            while (rs.next()) {
                companyOrgUnitID = rs.getString("companyOrgUnitID");
                if (!"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(rs.getString("FBillTypeID"))) continue;
                if (0 == currYear && 0 == currPeriod) {
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)companyOrgUnitID));
                    PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)pk);
                    currYear = periodInfo.getPeriodYear();
                    currPeriod = periodInfo.getPeriodNumber();
                }
                int year = rs.getInt("curYear");
                int period = rs.getInt("curPeriod");
                int fiVouchered = rs.getInt("fiVouchered");
                if ((year > currYear || year == currYear && period >= currPeriod) && fiVouchered == 0) continue;
                throw new ExpenseApportionException(ExpenseApportionException.DEL_APPORLISTING_ALERT);
            }
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyOrgUnitID;
    }

    protected void _deleteExpenseApportion(Context ctx, String id) throws BOSException, EASBizException {
    }

    protected void _deleteExpenseApportion(Context ctx, ArrayList ids) throws BOSException, EASBizException {
    }

    private void updatePur(String fid, BigDecimal amount, ArrayList updatePursqlList, boolean isNeedWriteBack, boolean hasApportioned) {
        StringBuffer sql = new StringBuffer();
        if (isNeedWriteBack) {
            sql.append("update T_IM_PurInWarehsEntry As entry set (FImputedCost,FPurchaseFee,FActualCost,FUnitActualCost)=");
            sql.append("(select IsNull(t1.FImputedCost, 0)+" + amount);
            if (hasApportioned) {
                sql.append(" ,IsNull(t1.FPurchaseFee, 0)+" + amount);
                sql.append(" ,IsNull(t1.FActualCost, 0)+" + amount);
                sql.append(" ,ROUND(TO_DECIMAL((t1.FActualCost+" + amount).append(")/t1.fqty,17,4), t2.FPriceprecision) ");
            } else {
                sql.append(" ,").append(amount);
                sql.append(" ,IsNull(t1.FPurchaseCost, 0)+IsNull(t1.FMaterialCost, 0)+").append(amount);
                sql.append(" ,ROUND(TO_DECIMAL((t1.FPurchaseCost+t1.FMaterialCost+" + amount).append(")/t1.fqty,17,4), t2.FPriceprecision) ");
            }
            sql.append(" from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid ");
            sql.append(" where entry.FID=t1.FID and t1.FID ='").append(fid).append("')");
        } else {
            sql.append("update T_IM_PurInWarehsEntry set FImputedCost = IsNull(FImputedCost, 0)+");
            sql.append(amount);
            sql.append(" where FID = '").append(fid).append("'");
        }
        updatePursqlList.add(sql.toString());
    }

    private CostAdjustBillInfo createOrFindCostAdJust(ArrayList list, PurInWarehsBillInfo purInWarehsBillInfo, ApportionResultInfo info, Context ctx, ArrayList costList) {
        CostAdjustBillInfo costBill = null;
        boolean flag = false;
        for (int i = 0; i < list.size(); ++i) {
            costBill = (CostAdjustBillInfo)list.get(i);
            if (!costBill.getStorageOrgUnit().equals((Object)purInWarehsBillInfo.getStorageOrgUnit())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            costBill = new CostAdjustBillInfo();
            costBill.setId(BOSUuid.create((String)"8FA62986"));
            costBill.setNumber(String.valueOf(System.currentTimeMillis()));
            costBill.setIssueType(IssueTypeEnum.NULL);
            costBill.setCreateType(CostAdjuestCreateTypeEnum.APPORTION_EXPENSE);
            costBill.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
            SupplierInfo supplier = null;
            if (info.getSupplerID() != null && !"".equals(info.getSupplerID())) {
                supplier = new SupplierInfo();
                supplier.setId(BOSUuid.read((String)info.getSupplerID()));
            }
            costBill.setSupplier(supplier);
            costBill.setStorageOrgUnit(purInWarehsBillInfo.getStorageOrgUnit());
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
            BillTypeInfo sourceBillType = new BillTypeInfo();
            sourceBillType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
            costBill.setSourceBillType(sourceBillType);
            costBill.setYear(info.getYear());
            costBill.setPeriod(info.getPeriod());
            costBill.setBizDate(info.getBizDate());
            costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            costBill.setCreateTime(this.getTime());
            costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            costBill.setAuditTime(this.getTime());
            costBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            costBill.setBillType(billType);
            costBill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            costBill.setAdminOrgUnit(purInWarehsBillInfo.getAdminOrgUnit());
            costBill.setCostCenterOrgUnit(purInWarehsBillInfo.getCostCenterOrgUnit());
            costList.add(costBill);
        }
        return costBill;
    }

    private void createAdCostBillEntry(PurInWarehsEntryInfo purEntryInfo, PurInWarehsBillInfo purInWarehsBillInfo, int i, CostAdjustBillInfo costBillInfo, BigDecimal balance, List list, boolean isSpecialAccType) {
        if (balance.compareTo(ZERO) != 0) {
            CostAdjustBillEntryInfo costBillEntryInfo = new CostAdjustBillEntryInfo();
            costBillEntryInfo.setId(BOSUuid.create((String)"2774F28C"));
            list.add(costBillEntryInfo.getId().toString());
            costBillEntryInfo.setParent(costBillInfo);
            costBillEntryInfo.setStorageOrgUnit(purEntryInfo.getStorageOrgUnit());
            costBillEntryInfo.setCompanyOrgUnit(purEntryInfo.getCompanyOrgUnit());
            costBillEntryInfo.setWarehouse(purEntryInfo.getWarehouse());
            costBillEntryInfo.setMaterial(purEntryInfo.getMaterial());
            costBillEntryInfo.setBaseUnit(purEntryInfo.getBaseUnit());
            costBillEntryInfo.setUnit(purEntryInfo.getBaseUnit());
            costBillEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            costBillEntryInfo.setSourceBillId(purEntryInfo.getParent().getId().toString());
            costBillEntryInfo.setSourceBillEntryId(purEntryInfo.getId().toString());
            costBillEntryInfo.setSourceBillNumber(purInWarehsBillInfo.getNumber());
            costBillEntryInfo.setSourceBillEntrySeq(purEntryInfo.getSeq());
            costBillEntryInfo.setBaseQty(new BigDecimal("0.0"));
            costBillEntryInfo.setSeq(i);
            costBillEntryInfo.setAmount(balance);
            costBillEntryInfo.setStandardCost(balance);
            costBillEntryInfo.setActualCost(balance);
            costBillEntryInfo.setBigDecimal("unitPurseCost_adj", purEntryInfo.getUnitActualCost());
            if (this.isAdjust || isSpecialAccType) {
                costBillEntryInfo.setLot(purEntryInfo.getLot());
                costBillEntryInfo.setAssistProperty(purEntryInfo.getAssistProperty());
            }
            costBillEntryInfo.setProject(purEntryInfo.getProject());
            costBillEntryInfo.setTrackNumber(purEntryInfo.getTrackNumber());
            StoreTypeInfo storeType = new StoreTypeInfo();
            storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
            StoreStateInfo storeState = new StoreStateInfo();
            storeState.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
            costBillEntryInfo.setStoreType(storeType);
            costBillEntryInfo.setStoreStatus(storeState);
            costBillEntryInfo.setLocation(purEntryInfo.getLocation());
            costBillEntryInfo.setBizDate(costBillInfo.getBizDate());
            costBillInfo.getEntry().add(costBillEntryInfo);
        }
    }

    private void updatePurAndOther(ApportionResultInfo info, ArrayList list) {
        HashMap headMap = info.getExpenseVoiceMap();
        for (String fid : headMap.keySet()) {
            HashMap entryMap = (HashMap)info.getExpenseVoiceMap().get(fid);
            Iterator iter2 = entryMap.keySet().iterator();
            while (iter2.hasNext()) {
                String entryId = iter2.next().toString();
                BigDecimal amount = (BigDecimal)entryMap.get(entryId);
                String sql = "update T_AP_OtherBillentry set funapportionAmount=funapportionAmount-(" + amount + "),fapportionAmount=fapportionAmount+(" + amount + ") where fid='" + entryId + "'";
                list.add(sql);
            }
        }
    }

    private void deleteRelationCostAdjBill(Context ctx, String[] costAjdIdList) throws BOSException, EASBizException, SQLException {
        IRowSet row = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)CostAdjustHelp.getCostAdjnumberSql(costAjdIdList));
        ArrayList<String> numberArr = new ArrayList<String>();
        while (row.next()) {
            numberArr.add(row.getString("NEWFNUMBER"));
        }
        if (numberArr.size() == 0) {
            return;
        }
        String[] numbers = numberArr.toArray(new String[numberArr.size()]);
        CostAdjustHelp.checkCostAdjBillIsVouchered(ctx, numbers, true);
        MoveWeightedAverageCalculate calculator = new MoveWeightedAverageCalculate();
        if (numberArr.size() > 0) {
            calculator.unCalculateCost(ctx, CostAdjustHelp.getCostAdjSqlForNumber(ctx, numbers), CalculateKindEnum.OUTPUT_WAREHOUSE);
            calculator.commit(ctx);
            StringBuffer buffer = new StringBuffer();
            buffer.append("DELETE FROM t_cl_costadjustbillentry WHERE fparentid in (");
            buffer.append(" SELECT FID FROM t_cl_costadjustbill WHERE FNUMBER=?)");
            String delteEntry = buffer.toString();
            buffer.setLength(0);
            buffer.append("DELETE FROM t_cl_costadjustbill WHERE FNUMBER=?");
            String deleteBill = buffer.toString();
            Connection conn = null;
            PreparedStatement psDeleteEntry = null;
            PreparedStatement psDeleteBill = null;
            try {
                conn = this.getConnection(ctx);
                psDeleteEntry = conn.prepareStatement(delteEntry);
                psDeleteBill = conn.prepareStatement(deleteBill);
                for (int i = 0; i < numberArr.size(); ++i) {
                    psDeleteEntry.setString(1, (String)numberArr.get(i));
                    psDeleteBill.setString(1, (String)numberArr.get(i));
                    psDeleteEntry.addBatch();
                    psDeleteBill.addBatch();
                }
                psDeleteEntry.executeBatch();
                psDeleteBill.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(psDeleteEntry, (Connection)conn);
                    SQLUtils.cleanup(psDeleteBill);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)psDeleteEntry, (Connection)conn);
            SQLUtils.cleanup((Statement)psDeleteBill);
        }
    }

    private String getCreateTempTableSql(String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append("tempTableName");
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql.toString();
    }

    private String[][] getPurExpenseTablefields() {
        String[][] fields = new String[][]{{"id", "VARCHAR(44)"}, {"SOURCEBILLID", "VARCHAR(44)"}, {"COREBILLID", "VARCHAR(44)"}, {"NUMBER", "VARCHAR(80)"}, {"bizDate", "DateTime"}, {"supplier_name", "VARCHAR(80)"}, {"companyOrgUnit_name", "VARCHAR(80)"}, {"expense_number", "VARCHAR(80)"}, {"expense_name", "VARCHAR(80)"}, {"FAbstractName", "VARCHAR(80)"}, {"FRemark", "VARCHAR(80)"}, {"material_number", "VARCHAR(80)"}, {"material_name", "VARCHAR(80)"}, {"localNonTaxAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"amount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"entry_id", "VARCHAR(44)"}, {"companyOrgUnit_id", "VARCHAR(80)"}, {"fprecision", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"supplier_id", "VARCHAR(80)"}, {"unApportionAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    private String[][] getPurInWarehsTablefields() {
        String[][] fields = new String[][]{{"id", "VARCHAR(44)"}, {"NUMBER", "VARCHAR(80)"}, {"bizDate", "DateTime"}, {"supplier_name", "VARCHAR(80)"}, {"companyOrgUnit_name", "VARCHAR(80)"}, {"purOrderNumber", "VARCHAR(80)"}, {"material_number", "VARCHAR(80)"}, {"material_name", "VARCHAR(80)"}, {"unit_name", "VARCHAR(80)"}, {"lot", "NVARCHAR(255)"}, {"qty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"baseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"purchaseCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"purchaseFee", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"actualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"imputedCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"entry_id", "VARCHAR(44)"}, {"companyOrgUnit_id", "VARCHAR(80)"}, {"storageOrgUnit_id", "VARCHAR(44)"}, {"fprecision", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"qtyPrecision", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"baseQtyPrecision", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}};
        return fields;
    }

    @Override
    protected Map _fetchDatabyCou(Context ctx, String couID) throws BOSException, EASBizException {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        CompanyOrgUnitInfo cou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(couID));
        if (cou == null) {
            return rs;
        }
        rs.put("CompanyOrgUnit", cou);
        rs.put("CurrentPeriod", SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou));
        rs.put("StartPeriod", SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou));
        rs.put("MinPeriodYear", PeriodUtils.getMaxOrMinPeriodYear((Context)ctx, (String)cou.getId().toString(), (boolean)false));
        rs.put("MaxPeriodYear", PeriodUtils.getMaxOrMinPeriodYear((Context)ctx, (String)cou.getId().toString(), (boolean)true));
        return rs;
    }

    @Override
    protected Map _getPeriodNumber(Context ctx, int periodYear, CompanyOrgUnitInfo cou) throws BOSException, EASBizException {
        HashMap<String, Object> rs = new HashMap<String, Object>();
        if (cou == null) {
            return rs;
        }
        rs.put("CurrentPeriod", SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou));
        rs.put("StartPeriod", SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou));
        rs.put("MinPeriodNumber", PeriodUtils.getMinPeriodNumber((Context)ctx, (int)periodYear, (String)cou.getId().toString()));
        rs.put("MaxPeriodNumber", PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)periodYear, (String)cou.getId().toString()));
        return rs;
    }

    @Override
    protected void _deleteExpenseApportion4Sale(Context ctx, String[] ids) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps1 = null;
        PreparedStatement ps2 = null;
        try {
            StringBuffer strIds = new StringBuffer();
            for (String s : ids) {
                strIds.append("'").append(s).append("',");
            }
            if (strIds.length() > 0) {
                strIds.setLength(strIds.length() - 1);
            }
            StringBuffer tempSql = new StringBuffer();
            tempSql.append("update T_CL_ExpenseApportion set fid = fid where fid in (").append(strIds).append(")");
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)tempSql.toString());
            tempSql.setLength(0);
            tempSql.append("select 1 from T_CL_ExpenseApportion where (FFIVOUCHERED = 1 or FPCVOUCHERED = 1) and fid in (").append(strIds).append(")");
            IRowSet checkRs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)tempSql.toString());
            if (checkRs.next()) {
                throw new CalculateException(CalculateException.APPORTION_HAS_VOUCHER);
            }
            StringBuffer querySql = new StringBuffer();
            querySql.append("select a.FNUMBER,b.FPARENTID FAPPORTIONID,b.FBILLTYPEID,b.FCURRAPPORTIONAMT,b.FSOURCEBILLID,b.FSOURCEENTRYID,b.FSOURCENUMBER \n");
            querySql.append("from T_CL_ExpenseApportion a inner join T_CL_ExpenseApportionEntry b on a.fid = b.fparentid \n");
            querySql.append("where a.fid in (").append(strIds).append(")");
            String updateSaleIssueEntry = "update t_im_saleIssueEntry set FTOTALSALEFEE = FTOTALSALEFEE - ? where fid = ?";
            String updateOtherbillEntrySQL = "update T_AP_OtherBillentry set FApportionAmount=FApportionAmount-? ,FUnApportionAmount=FUnApportionAmount+? where FID =?";
            String deleteApportRecordSql = "delete from T_AP_OtherBillExpApportion where FCostAdjustBillId in (" + strIds + ")";
            String delApporListBillSql = "delete from T_CL_ExpenseApportion where FID in (" + strIds + ")";
            String delApporListEntrySql = "delete from T_CL_ExpenseApportionEntry where FParentID in (" + strIds + ")";
            conn = this.getConnection(ctx);
            ps1 = conn.prepareStatement(updateOtherbillEntrySQL);
            ps2 = conn.prepareStatement(updateSaleIssueEntry);
            IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)querySql.toString());
            StringBuffer billNumber = new StringBuffer();
            while (rs.next()) {
                if ("510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(rs.getString("FBILLTYPEID"))) {
                    ps1.setBigDecimal(1, rs.getBigDecimal("FCURRAPPORTIONAMT"));
                    ps1.setBigDecimal(2, rs.getBigDecimal("FCURRAPPORTIONAMT"));
                    ps1.setString(3, rs.getString("FSOURCEENTRYID"));
                    ps1.addBatch();
                } else if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(rs.getString("FBILLTYPEID"))) {
                    ps2.setBigDecimal(1, rs.getBigDecimal("FCURRAPPORTIONAMT"));
                    ps2.setString(2, rs.getString("FSOURCEENTRYID"));
                    ps2.addBatch();
                } else {
                    throw new EASBizException(CalculateException.APPORTION_TYPE_ERROR, (Object[])new String[]{rs.getString("FNUMBER")});
                }
                billNumber.append(rs.getString("FSOURCENUMBER")).append(";");
            }
            ps1.executeBatch();
            ps2.executeBatch();
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)deleteApportRecordSql);
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)delApporListBillSql);
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)delApporListEntrySql);
            if (billNumber.length() > 0) {
                billNumber.setLength(billNumber.length() - 1);
                if (billNumber.length() > 1200) {
                    billNumber.setLength(1200);
                }
            }
            String title = EASResource.getString((String)RES, (String)"delSaleExpenseApportion");
            IObjectPK pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("FDB07C43"), null, (String)billNumber.toString(), (String)title);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                com.kingdee.eas.scm.cal.util.DBUtil.close(conn, new PreparedStatement[]{ps2, ps1}, null);
                throw throwable;
            }
        }
        com.kingdee.eas.scm.cal.util.DBUtil.close(conn, new PreparedStatement[]{ps2, ps1}, null);
    }

    @Override
    protected void _deleteVouchers(Context ctx, ArrayList idList) throws BOSException, EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        StringBuilder ids = new StringBuilder("(");
        for (int i = 0; i < idList.size(); ++i) {
            ids.append("'").append(idList.get(i)).append("',");
        }
        ids.setLength(ids.length() - 1);
        ids.append(")");
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct FVOUCHERID  from T_CL_ExpenseApportion where fid in ").append((CharSequence)ids);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            IDAPTransformer dapTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
            while (rs.next()) {
                String id = rs.getString("FVOUCHERID");
                iVoucher.delete((IObjectPK)new ObjectUuidPK(id.toString()));
                BaseVoucherInfo voucher = new BaseVoucherInfo();
                voucher.setId(BOSUuid.read((String)id));
                dapTransformer.undoTransformFromVoucher(voucher);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private HashMap getSourceIDandCoreID(Context ctx, String tempPurExpenseTable) throws BOSException {
        IRowSet rs = null;
        StringBuffer coreBillIDs = new StringBuffer();
        StringBuffer sourceBillIDs = new StringBuffer();
        HashMap<String, String> hm = new HashMap<String, String>();
        String sqlquery = "select SOURCEBILLID,COREBILLID from " + tempPurExpenseTable;
        rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sqlquery);
        try {
            while (rs.next()) {
                if (null != rs.getString("SOURCEBILLID")) {
                    if (sourceBillIDs.length() > 0) {
                        sourceBillIDs.append(", '").append(rs.getString("SOURCEBILLID")).append("'");
                    } else {
                        sourceBillIDs.append("'").append(rs.getString("SOURCEBILLID")).append("'");
                    }
                }
                if (null == rs.getString("COREBILLID")) continue;
                if (coreBillIDs.length() > 0) {
                    coreBillIDs.append(", '").append(rs.getString("COREBILLID")).append("'");
                    continue;
                }
                coreBillIDs.append("'").append(rs.getString("COREBILLID")).append("'");
            }
            if (coreBillIDs.length() > 0) {
                coreBillIDs.insert(0, "(");
                coreBillIDs.append(")");
                hm.put("coreBillIDs", coreBillIDs.toString());
            }
            if (sourceBillIDs.length() > 0) {
                sourceBillIDs.insert(0, "(");
                sourceBillIDs.append(")");
                hm.put("sourceBillIDs", sourceBillIDs.toString());
            }
            return hm;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

