/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionCreateTypeEnum;
import com.kingdee.eas.scm.cal.ExpenseApportionEntryInfo;
import com.kingdee.eas.scm.cal.ExpenseApportionException;
import com.kingdee.eas.scm.cal.ExpenseApportionFacadeFactory;
import com.kingdee.eas.scm.cal.ExpenseApportionFactory;
import com.kingdee.eas.scm.cal.ExpenseApportionInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IExpenseApportion;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.framework.writeoff.IWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.IllegalConversionException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExpenseApportionStrategy
implements IWriteOffStrategy {
    public static final String RES = "com.kingdee.eas.scm.cal.ManualWriteOffResource";

    public List buildWriteOffBillInfo(Context ctx, Map mainMap, Map secMap, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        String supplierId;
        IObjectCollection entryColl;
        ExpenseApportionInfo billInfo;
        CoreBaseCollection billColl;
        PeriodInfo curPeriodInfo;
        block27: {
            Map.Entry me2;
            block26: {
                curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                params.put((Object)"currentPeriod", (Object)curPeriodInfo);
                HashMap paramMap = new HashMap();
                paramMap.put("SCM_CAL_011", params.getCompanyId());
                paramMap.put("SCM_CAL_008", params.getCompanyId());
                paramMap = ParamManager.getParamHashMap((Context)ctx, paramMap);
                params.put((Object)"isExpenseEstimate", (Object)"true".equalsIgnoreCase(paramMap.get("SCM_CAL_011").toString()));
                params.put((Object)"isCombineVoucher", (Object)"1".equals(paramMap.get("SCM_CAL_008")));
                billColl = new CoreBaseCollection();
                billInfo = null;
                entryColl = null;
                supplierId = null;
                if (!"handDeal".equals(params.get((Object)"apportionStd"))) break block26;
                billInfo = new ExpenseApportionInfo();
                entryColl = (IObjectCollection)billInfo.get("entry");
                if (mainMap.get("") == null || secMap.get("") == null) break block27;
                me2 = null;
                for (Map.Entry me2 : mainMap.entrySet()) {
                    if (!secMap.containsKey(me2.getKey())) continue;
                    List secList = (List)secMap.get(me2.getKey());
                    this.checkData((List)me2.getValue(), secList, params);
                }
                Iterator it = ((List)mainMap.get("")).iterator();
                while (it.hasNext()) {
                    entryColl.addObject((IObjectValue)it.next());
                }
                supplierId = ((ExpenseApportionEntryInfo)((List)mainMap.get("")).get(0)).getString("supplierId");
                it = ((List)secMap.get("")).iterator();
                while (it.hasNext()) {
                    entryColl.addObject((IObjectValue)it.next());
                }
                if (entryColl.size() <= 0) break block27;
                billColl.add((CoreBaseInfo)billInfo);
                break block27;
            }
            me2 = null;
            Map newMainMap = this.getGroupMap(mainMap);
            for (Map.Entry me2 : newMainMap.entrySet()) {
                String secMapkey = this.getsecMapKey((String)me2.getKey(), true);
                String asstActID = this.getsecMapKey((String)me2.getKey(), false);
                if (!secMap.containsKey(secMapkey)) continue;
                List secList = (List)secMap.get(secMapkey);
                billInfo = this.buildExpenseApportionInfo(ctx, (List)me2.getValue(), secList, conditionEntryInfo, asstActID, params);
                if (billInfo == null) continue;
                billColl.add((CoreBaseInfo)billInfo);
            }
        }
        ArrayList<IObjectPK> result = new ArrayList<IObjectPK>();
        if (billColl.size() > 0) {
            ArrayList sqlList = new ArrayList();
            HashMap costAdjustMap = new HashMap();
            ExpenseApportionEntryInfo entryInfo = null;
            String prefix = null;
            HashSet<String> purIdSet = new HashSet<String>();
            HashSet<String> apIdSet = new HashSet<String>();
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                entryColl = (IObjectCollection)billColl.get(i).get("entry");
                prefix = BOSUuid.create((String)"FDB07C43").toString();
                int k = entryColl.size();
                for (int j = 0; j < k; ++j) {
                    entryInfo = (ExpenseApportionEntryInfo)entryColl.getObject(j);
                    params.put((Object)"cycleNumer", (Object)new Integer(i * 10 + j));
                    if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(entryInfo.getBillType().getId().toString())) {
                        purIdSet.add(entryInfo.getSourceBillId());
                        if ("handDeal".equals(params.get((Object)"apportionStd"))) {
                            entryInfo.setString("asstActID", supplierId);
                        }
                        this.buildUpdateIMBillSql(ctx, entryColl, entryInfo, prefix, costAdjustMap, params, sqlList);
                        continue;
                    }
                    if (!"510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(entryInfo.getBillType().getId().toString())) continue;
                    apIdSet.add(entryInfo.getSourceBillId());
                    this.buildUpdateAPBillSql(ctx, entryInfo, params, sqlList);
                }
            }
            this.updateHead(ctx, purIdSet, "T_IM_PurInWarehsBill");
            this.updateHead(ctx, apIdSet, "T_AP_OtherBill");
            CoreBaseCollection caBillColl = new CoreBaseCollection();
            Iterator it = costAdjustMap.entrySet().iterator();
            while (it.hasNext()) {
                caBillColl.add((CoreBaseInfo)((CostAdjustBillInfo)it.next().getValue()));
            }
            HashSet<String> imBillNumber = new HashSet<String>();
            HashSet<String> invoiceBillNumber = new HashSet<String>();
            ArrayList<String> apIdList = new ArrayList<String>();
            ArrayList caIdList = new ArrayList();
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            int size2 = billColl.size();
            for (int i = 0; i < size2; ++i) {
                billInfo = (ExpenseApportionInfo)billColl.get(i);
                billInfo.setNumber(sf.format(new Date()) + i);
                Timestamp maxBizDate = CalculateUtil.getTime("1900-01-01 00:00:00.000");
                int maxPeriodNumber = 190001;
                int k = billInfo.getEntry().size();
                for (int j = 0; j < k; ++j) {
                    if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billInfo.getEntry().get(j).getBillType().getId().toString())) {
                        imBillNumber.add(billInfo.getEntry().get(j).getSourceNumber());
                    } else if ("510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(billInfo.getEntry().get(j).getBillType().getId().toString())) {
                        invoiceBillNumber.add(billInfo.getEntry().get(j).getSourceNumber());
                    }
                    billInfo.getEntry().get(j).setId(null);
                    if (maxBizDate.compareTo(billInfo.getEntry().get(j).getBizDate()) >= 0) continue;
                    maxBizDate = CalculateUtil.getTime(billInfo.getEntry().get(j).getBizDate());
                    maxPeriodNumber = billInfo.getEntry().get(j).getInt("year") * 100 + billInfo.getEntry().get(j).getInt("period");
                }
                int periodNumber = curPeriodInfo.getNumber();
                if (maxBizDate.compareTo(curPeriodInfo.getBeginDate()) < 0) {
                    maxBizDate = CalculateUtil.getTime(curPeriodInfo.getBeginDate());
                } else if (maxBizDate.compareTo(curPeriodInfo.getEndDate()) > 0) {
                    periodNumber = maxPeriodNumber;
                }
                billInfo.setYear(periodNumber / 100);
                billInfo.setPeriod(periodNumber % 100);
                Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
                billInfo.setApportionDate(now);
                boolean isSubContract = false;
                if (params.get((Object)"isSubContract") != null) {
                    isSubContract = (Boolean)params.get((Object)"isSubContract");
                }
                billInfo.setCreateType(!isSubContract ? ExpenseApportionCreateTypeEnum.PUR_APPORTION : ExpenseApportionCreateTypeEnum.DEV_APPORTION);
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)params.getCompanyId()));
                billInfo.setCompanyOrgUnit(company);
                billInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                billInfo.setCreateTime(now);
                String apBillId = null;
                ArrayList<String> caEntryIdList = new ArrayList<String>();
                CostAdjustBillInfo caBillInfo = null;
                int k2 = billInfo.getEntry().size();
                for (int j = 0; j < k2; ++j) {
                    if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(billInfo.getEntry().get(j).getBillType().getId().toString())) {
                        billInfo.getEntry().get(j).setBizDate(maxBizDate);
                        caBillInfo = (CostAdjustBillInfo)caBillColl.get((Object)BOSUuid.read((String)billInfo.getEntry().get(j).getSourceBillId()));
                        caBillInfo.setBizDate(maxBizDate);
                        caBillInfo.setYear(periodNumber / 100);
                        caBillInfo.setPeriod(periodNumber % 100);
                        caBillInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                        caBillInfo.setCreateTime(now);
                        caBillInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
                        caBillInfo.setAuditTime(now);
                        caBillInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
                        Iterator it2 = caBillInfo.getEntry().iterator();
                        while (it2.hasNext()) {
                            ((CostAdjustBillEntryInfo)it2.next()).setBizDate(maxBizDate);
                        }
                        caEntryIdList.add(billInfo.getEntry().get(j).getSourceEntryId());
                        continue;
                    }
                    if (!"510b6503-0105-1000-e000-010fc0a812fd463ED552".equals(billInfo.getEntry().get(j).getBillType().getId().toString()) || apBillId != null) continue;
                    apBillId = billInfo.getEntry().get(j).getSourceBillId();
                }
                apIdList.add(apBillId);
                caIdList.add(caEntryIdList);
            }
            IExpenseApportion iBill = ExpenseApportionFactory.getLocalInstance(ctx);
            IObjectPK[] pks = iBill.submitBatchData(billColl);
            result.addAll(Arrays.asList(pks));
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            if (caBillColl.size() > 0) {
                ICostAdjustBill iCABill = CostAdjustBillFactory.getLocalInstance(ctx);
                IObjectPK[] caPKs = iCABill.submitBatchData(caBillColl);
                int len = caPKs.length;
                for (int i = 0; i < len; ++i) {
                    iCABill.audit(caPKs[i]);
                }
            }
            if (((Boolean)params.get((Object)"isCombineVoucher")).booleanValue()) {
                int size3 = apIdList.size();
                for (int i = 0; i < size3; ++i) {
                    this.reverseApportionDetail(ctx, String.valueOf(apIdList.get(i)), (List)caIdList.get(i));
                }
            }
            ExpenseApportionFacadeFactory.getLocalInstance(ctx).setApportionStandard(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), params.getCompanyId(), String.valueOf(params.get((Object)"apportionStd")));
            this.writeLog(ctx, imBillNumber, invoiceBillNumber);
        }
        return result;
    }

    protected void checkData(List mainList, List secList, WriteOffCommonParams params) throws EASBizException {
        boolean isCombineVoucher = (Boolean)params.get((Object)"isCombineVoucher");
        ExpenseApportionEntryInfo entryInfo2 = null;
        BigDecimal totalApportionAmt = BigDecimal.ZERO;
        int periodNumber = 0;
        HashSet<String> billIdSet = new HashSet<String>();
        for (ExpenseApportionEntryInfo entryInfo2 : mainList) {
            if (isCombineVoucher && entryInfo2.getBoolean("fiVouchered")) {
                throw new ExpenseApportionException(ExpenseApportionException.BILLCANTBSVOUCHERED);
            }
            totalApportionAmt = totalApportionAmt.add(entryInfo2.getCurrApportionAmt());
            periodNumber = entryInfo2.getInt("year") * 100 + entryInfo2.getInt("period");
            billIdSet.add(entryInfo2.getSourceBillId());
        }
        if (isCombineVoucher && billIdSet.size() > 1) {
            throw new ExpenseApportionException(ExpenseApportionException.NOTSUPPORTMULTISELECTED);
        }
        BigDecimal totalApportionStd = BigDecimal.ZERO;
        Iterator it = secList.iterator();
        while (it.hasNext()) {
            totalApportionStd = totalApportionStd.add(((ExpenseApportionEntryInfo)it.next()).getBigDecimal("currapportionamt"));
        }
        if (totalApportionStd.signum() == 0) {
            throw new ExpenseApportionException(ExpenseApportionException.ZEROTOTAL_APPORTIONSTANDARD, new String[]{String.valueOf(params.get((Object)"apportionStdAlias"))});
        }
        BigDecimal sumApportionAmt = BigDecimal.ZERO;
        BigDecimal currApportionAmt = null;
        int signum = 0;
        int size = secList.size();
        for (int i = 0; i < size; ++i) {
            entryInfo2 = (ExpenseApportionEntryInfo)secList.get(i);
            if (isCombineVoucher && periodNumber < entryInfo2.getInt("year") * 100 + entryInfo2.getInt("period")) {
                throw new ExpenseApportionException(ExpenseApportionException.PURWAREHSCANTBENEXTPERIOD);
            }
            currApportionAmt = i == size - 1 ? totalApportionAmt.subtract(sumApportionAmt) : totalApportionAmt.multiply(entryInfo2.getBigDecimal("currapportionamt")).divide(totalApportionStd, entryInfo2.getInt("basePrecision"), 4);
            sumApportionAmt = sumApportionAmt.add(currApportionAmt);
            signum = currApportionAmt.add(entryInfo2.getBigDecimal("imputedCost")).add(entryInfo2.getBigDecimal("purchaseCost")).add(entryInfo2.getBigDecimal("materialCost")).signum();
            if (signum == 0 || signum == entryInfo2.getBigDecimal("qty").signum()) continue;
            throw new ExpenseApportionException(ExpenseApportionException.ACTUALCOST_SIGN_DIFF, new String[]{entryInfo2.getSourceNumber(), String.valueOf(entryInfo2.getSourceSeq())});
        }
    }

    protected void reverseApportionDetail(Context ctx, String apBillId, List list) throws BOSException, EASBizException {
        if (apBillId == null || list == null || list.size() == 0) {
            return;
        }
        StringBuffer strid = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                strid.append(",");
            }
            strid.append("'").append(list.get(i)).append("'");
        }
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("insert into T_AP_OtherBillExpApportion (FID,FParentID,FCostAdjustBillId,FCostCenterID,FIssueType,FCreateType,");
        sqlBuffer.append("FCalculateKind,FSupplierID,FCustomerID,FEntryId,FCostObjectID,FMaterialID,FCompanyOrgUnitID,FWarehouseID,FUnitID,FLot,FQty,FPrice,");
        sqlBuffer.append("FAmount,FSeq,FSourceBillNumber,FSourceBillEntrySeq,FStorageOrgUnitID,FAdminOrgUnitID ,FStockerID ,FVoucherID,");
        sqlBuffer.append("FTotalQty,FTotalAmount,FFiVouchered ,FTotalStandardCost,FTotalActualCost,FIsReversed,FTransactionTypeID,");
        sqlBuffer.append("FIsInitBill,FAuditTime ,FBaseStatus,FBizTypeID,FSourceBillTypeID,FBillTypeID,FYear,FPeriod,FModifierID,FModificationTime,");
        sqlBuffer.append("FNumber,FBizDate,FHandlerID,FDescription,FHasEffected,FAuditorID,FSourceBillID,FSourceFunction,FCreatorID,FCreateTime,");
        sqlBuffer.append("FLastUpdateUserID,FLastUpdateTime,FControlUnitID)\n");
        sqlBuffer.append("select NEWBOSID('87E4684C'),");
        sqlBuffer.append("'").append(apBillId).append("',");
        sqlBuffer.append("a.FID,a.FCostCenterOrgUnitID,a.FIssueType,a.FCreateType,a.FCalculateKind,a.FSupplierID,a.FCustomerID,b.FID,b.FCostObjectID,");
        sqlBuffer.append("b.FMaterialID,b.FCompanyOrgUnitID,b.FWarehouseID,b.FUnitID,b.FLot,b.FQty,b.FPrice,b.FAmount,b.FSeq,b.FSourceBillNumber,b.FSourceBillEntrySeq,");
        sqlBuffer.append("a.FStorageOrgUnitID,a.FAdminOrgUnitID,a.FStockerID,a.FVoucherID,a.FTotalQty,a.FTotalAmount,a.FFiVouchered,a.FTotalStandardCost,");
        sqlBuffer.append("a.FTotalActualCost,a.FIsReversed,a.FTransactionTypeID,a.FIsInitBill,a.FAuditTime,4,a.FBizTypeID,a.FSourceBillTypeID,");
        sqlBuffer.append("a.FBillTypeID,a.FYear,a.FPeriod,a.FModifierID,a.FModificationTime,a.FNumber,a.FBizDate,a.FHandlerID,a.FDescription,a.FHasEffected,");
        sqlBuffer.append("a.FAuditorID,a.FSourceBillID,a.FSourceFunction,a.FCreatorID,a.FCreateTime,a.FLastUpdateUserID,a.FLastUpdateTime,a.FControlUnitID ");
        sqlBuffer.append("from T_CL_CostAdjustBill a inner join T_CL_CostAdjustBillEntry b on a.FID=b.FParentID \n");
        sqlBuffer.append("where b.FID in(").append(strid.toString()).append(")");
        String sSQL = sqlBuffer.toString();
        DBUtil.execute((Context)ctx, (String)sSQL);
    }

    protected void buildUpdateAPBillSql(Context ctx, ExpenseApportionEntryInfo entryInfo, WriteOffCommonParams params, List sqlList) {
        StringBuffer sb = new StringBuffer("");
        sb.append("UPDATE T_AP_OTHERBILLENTRY SET FUNAPPORTIONAMOUNT = FUNAPPORTIONAMOUNT - ");
        sb.append(entryInfo.getCurrApportionAmt()).append(", FAPPORTIONAMOUNT = FAPPORTIONAMOUNT + ");
        sb.append(entryInfo.getCurrApportionAmt());
        sb.append(" WHERE FID = '").append(entryInfo.getSourceEntryId()).append("'");
        sqlList.add(sb.toString());
    }

    protected ExpenseApportionInfo buildExpenseApportionInfo(Context ctx, List mainList, List secList, MappingConditionEntryInfo conditionEntryInfo, String asstActID, WriteOffCommonParams params) throws EASBizException {
        boolean isCombineVoucher = (Boolean)params.get((Object)"isCombineVoucher");
        ExpenseApportionInfo billInfo = new ExpenseApportionInfo();
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entry");
        ExpenseApportionEntryInfo entryInfo2 = null;
        ExpenseApportionEntryInfo entryInfoc = null;
        BigDecimal totalApportionAmt = BigDecimal.ZERO;
        int periodNumber = 0;
        HashSet<String> billIdSet = new HashSet<String>();
        for (ExpenseApportionEntryInfo entryInfo2 : mainList) {
            if (isCombineVoucher && entryInfo2.getBoolean("fiVouchered")) {
                throw new ExpenseApportionException(ExpenseApportionException.BILLCANTBSVOUCHERED);
            }
            totalApportionAmt = totalApportionAmt.add(entryInfo2.getCurrApportionAmt());
            periodNumber = entryInfo2.getInt("year") * 100 + entryInfo2.getInt("period");
            entryColl.addObject((IObjectValue)entryInfo2);
            billIdSet.add(entryInfo2.getSourceBillId());
        }
        if (isCombineVoucher && billIdSet.size() > 1) {
            throw new ExpenseApportionException(ExpenseApportionException.NOTSUPPORTMULTISELECTED);
        }
        BigDecimal totalApportionStd = BigDecimal.ZERO;
        Iterator it = secList.iterator();
        while (it.hasNext()) {
            totalApportionStd = totalApportionStd.add(((ExpenseApportionEntryInfo)it.next()).getBigDecimal("apportionStd"));
        }
        if (totalApportionStd.signum() == 0) {
            throw new ExpenseApportionException(ExpenseApportionException.ZEROTOTAL_APPORTIONSTANDARD, new String[]{String.valueOf(params.get((Object)"apportionStdAlias"))});
        }
        BigDecimal sumApportionAmt = BigDecimal.ZERO;
        BigDecimal currApportionAmt = null;
        BigDecimal imputedCost = null;
        int signum = 0;
        int size = secList.size();
        for (int i = 0; i < size; ++i) {
            entryInfo2 = (ExpenseApportionEntryInfo)secList.get(i);
            if (isCombineVoucher && periodNumber < entryInfo2.getInt("year") * 100 + entryInfo2.getInt("period")) {
                throw new ExpenseApportionException(ExpenseApportionException.PURWAREHSCANTBENEXTPERIOD);
            }
            currApportionAmt = i == size - 1 ? totalApportionAmt.subtract(sumApportionAmt) : totalApportionAmt.multiply(entryInfo2.getBigDecimal("apportionStd")).divide(totalApportionStd, entryInfo2.getInt("basePrecision"), 4);
            sumApportionAmt = sumApportionAmt.add(currApportionAmt);
            signum = currApportionAmt.add(entryInfo2.getBigDecimal("imputedCost")).add(entryInfo2.getBigDecimal("purchaseCost")).add(entryInfo2.getBigDecimal("materialCost")).signum();
            if (signum != 0 && signum != entryInfo2.getBigDecimal("qty").signum()) {
                throw new ExpenseApportionException(ExpenseApportionException.ACTUALCOST_SIGN_DIFF, new String[]{entryInfo2.getSourceNumber(), String.valueOf(entryInfo2.getSourceSeq())});
            }
            entryInfo2.setCurrApportionAmt(currApportionAmt);
            if (entryInfo2.getCurrApportionAmt().signum() != 0) {
                entryInfoc = (ExpenseApportionEntryInfo)entryInfo2.clone();
                entryInfoc.setString("asstActID", asstActID);
                entryColl.addObject((IObjectValue)entryInfoc);
            }
            if (null == (imputedCost = entryInfo2.getBigDecimal("imputedCost"))) {
                imputedCost = BigDecimal.ZERO;
            }
            entryInfo2.setBigDecimal("imputedCost", imputedCost.add(currApportionAmt));
        }
        if (entryColl.size() > 0) {
            return billInfo;
        }
        return null;
    }

    protected void buildUpdateIMBillSql(Context ctx, IObjectCollection entryColl, ExpenseApportionEntryInfo entryInfo, String prefix, Map costAdjustMap, WriteOffCommonParams params, List sqlList) throws EASBizException, IllegalConversionException, BOSException {
        if (entryInfo.getInt("accountType") != 1 && !entryInfo.getBoolean("fiVouchered") && ((Boolean)params.get((Object)"isExpenseEstimate")).booleanValue() && entryInfo.getInt("year") * 100 + entryInfo.getInt("period") >= ((PeriodInfo)params.get((Object)"currentPeriod")).getNumber()) {
            if (entryInfo.getBigDecimal("imputedCost").signum() == 0) {
                this.updatePur(entryInfo.getSourceEntryId(), entryInfo.getCurrApportionAmt(), sqlList, true, false);
            } else {
                this.updatePur(entryInfo.getSourceEntryId(), entryInfo.getCurrApportionAmt(), sqlList, true, true);
            }
        } else {
            if (entryInfo.getBigDecimal("imputedCost").signum() == 0) {
                this.buildCostAdjustBill(ctx, entryColl, entryInfo, prefix, costAdjustMap, entryInfo.getCurrApportionAmt().subtract(entryInfo.getBigDecimal("purchaseFee")), params);
            } else {
                this.buildCostAdjustBill(ctx, entryColl, entryInfo, prefix, costAdjustMap, entryInfo.getCurrApportionAmt(), params);
            }
            this.updatePur(entryInfo.getSourceEntryId(), entryInfo.getCurrApportionAmt(), sqlList, false, false);
        }
    }

    protected void buildCostAdjustBill(Context ctx, IObjectCollection entryColl, ExpenseApportionEntryInfo entryInfo, String prefix, Map costAdjustMap, BigDecimal diffAmt, WriteOffCommonParams params) throws BOSException, EASBizException {
        if (diffAmt.signum() == 0) {
            return;
        }
        CostAdjustBillInfo caBillInfo = null;
        String key = prefix + entryInfo.getString("storageOrgUnitId") + entryInfo.getString("asstActID") + entryInfo.getString("adminOrgUnitId") + entryInfo.getString("costCenterOrgUnitId");
        Integer cycleNumer = (Integer)params.get((Object)"cycleNumer");
        if (costAdjustMap.containsKey(key)) {
            caBillInfo = (CostAdjustBillInfo)costAdjustMap.get(key);
        } else {
            caBillInfo = new CostAdjustBillInfo();
            caBillInfo.setId(BOSUuid.create((String)"8FA62986"));
            caBillInfo.setIssueType(IssueTypeEnum.NULL);
            caBillInfo.setCreateType(CostAdjuestCreateTypeEnum.APPORTION_EXPENSE);
            caBillInfo.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
            SupplierInfo supplier = new SupplierInfo();
            supplier.setId(BOSUuid.read((String)entryInfo.getString("asstActID")));
            caBillInfo.setSupplier(supplier);
            StorageOrgUnitInfo storageOrg = new StorageOrgUnitInfo();
            storageOrg.setId(BOSUuid.read((String)entryInfo.getString("storageOrgUnitId")));
            caBillInfo.setStorageOrgUnit(storageOrg);
            caBillInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            caBillInfo.setSourceBillId(entryInfo.getSourceBillId());
            BillTypeInfo srcBillType = new BillTypeInfo();
            srcBillType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
            caBillInfo.setSourceBillType(srcBillType);
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
            caBillInfo.setBillType(billType);
            if (entryInfo.getString("adminOrgUnitId") != null) {
                AdminOrgUnitInfo adminOrg = new AdminOrgUnitInfo();
                adminOrg.setId(BOSUuid.read((String)entryInfo.getString("adminOrgUnitId")));
                caBillInfo.setAdminOrgUnit(adminOrg);
            }
            if (entryInfo.getString("costCenterOrgUnitId") != null) {
                CostCenterOrgUnitInfo costOrg = new CostCenterOrgUnitInfo();
                costOrg.setId(BOSUuid.read((String)entryInfo.getString("costCenterOrgUnitId")));
                caBillInfo.setCostCenterOrgUnit(costOrg);
            }
            Object value = EJBTransactionProxy.invokeByManual((Object)this, (String)"getCodeNumber", (Class[])new Class[]{Context.class, CostAdjustBillInfo.class, String.class, Integer.class}, (Object[])new Object[]{ctx, caBillInfo, entryInfo.getString("storageOrgUnitId"), (int)cycleNumer}, (int)3);
            caBillInfo.setNumber(String.valueOf(value));
            costAdjustMap.put(key, caBillInfo);
        }
        CostAdjustBillEntryInfo caEntryInfo = new CostAdjustBillEntryInfo();
        caEntryInfo.setId(BOSUuid.create((String)"2774F28C"));
        caEntryInfo.setSeq(caBillInfo.getEntry().size() + 1);
        caEntryInfo.setStorageOrgUnit(caBillInfo.getStorageOrgUnit());
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)params.getCompanyId()));
        caEntryInfo.setCompanyOrgUnit(company);
        if (entryInfo.getString("warehouseId") != null) {
            WarehouseInfo warehouse = new WarehouseInfo();
            warehouse.setId(BOSUuid.read((String)entryInfo.getString("warehouseId")));
            caEntryInfo.setWarehouse(warehouse);
        }
        caEntryInfo.setLot(entryInfo.getString("lot"));
        MaterialInfo material = new MaterialInfo();
        material.setId(BOSUuid.read((String)entryInfo.getObjectID()));
        caEntryInfo.setMaterial(material);
        MeasureUnitInfo baseUnit = new MeasureUnitInfo();
        baseUnit.setId(BOSUuid.read((String)entryInfo.getString("baseUnitId")));
        caEntryInfo.setBaseUnit(baseUnit);
        caEntryInfo.setUnit(baseUnit);
        caEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        caEntryInfo.setSourceBillId(entryInfo.getSourceBillId());
        caEntryInfo.setSourceBillEntryId(entryInfo.getSourceEntryId());
        caEntryInfo.setSourceBillNumber(entryInfo.getSourceNumber());
        caEntryInfo.setSourceBillEntrySeq(entryInfo.getSourceSeq());
        if (entryInfo.getString("assistPropertyId") != null) {
            AsstAttrValueInfo asstAttr = new AsstAttrValueInfo();
            asstAttr.setId(BOSUuid.read((String)entryInfo.getString("assistPropertyId")));
            caEntryInfo.setAssistProperty(asstAttr);
        }
        StoreTypeInfo storeType = new StoreTypeInfo();
        storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
        caEntryInfo.setStoreType(storeType);
        StoreStateInfo stateInfo = new StoreStateInfo();
        stateInfo.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
        caEntryInfo.setStoreStatus(stateInfo);
        if (entryInfo.getString("locationId") != null) {
            LocationInfo location = new LocationInfo();
            location.setId(BOSUuid.read((String)entryInfo.getString("locationId")));
            caEntryInfo.setLocation(location);
        }
        if (entryInfo.getString("projectId") != null) {
            ProjectInfo project = new ProjectInfo();
            project.setId(BOSUuid.read((String)entryInfo.getString("projectId")));
            caEntryInfo.setProject(project);
        }
        if (entryInfo.getString("trackNumberId") != null) {
            TrackNumberInfo trackNumber = new TrackNumberInfo();
            trackNumber.setId(BOSUuid.read((String)entryInfo.getString("trackNumberId")));
            caEntryInfo.setTrackNumber(trackNumber);
        }
        this.buildCAWfRecord(ctx, entryColl, entryInfo, diffAmt, caBillInfo, caEntryInfo, params);
    }

    private String getCodeNumber(Context ctx, CostAdjustBillInfo caBillInfo, String orgUnitId, Integer cycleNumer) {
        String number = null;
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            number = iCodingRuleManager.getNumber((IObjectValue)caBillInfo, orgUnitId);
        }
        catch (Exception e) {
            number = String.valueOf(System.currentTimeMillis()) + cycleNumer;
        }
        return number;
    }

    protected void buildCAWfRecord(Context ctx, IObjectCollection entryColl, ExpenseApportionEntryInfo entryInfo, BigDecimal diffAmt, CostAdjustBillInfo caBillInfo, CostAdjustBillEntryInfo caEntryInfo, WriteOffCommonParams params) {
        ExpenseApportionEntryInfo caApportionEntryInfo = (ExpenseApportionEntryInfo)entryInfo.clone();
        caApportionEntryInfo.setId(null);
        caApportionEntryInfo.setSourceEntryId(caEntryInfo.getId().toString());
        caApportionEntryInfo.setSourceSeq(caEntryInfo.getSeq());
        caApportionEntryInfo.setSourceNumber(caBillInfo.getNumber());
        caApportionEntryInfo.setSourceBillId(caBillInfo.getId().toString());
        caApportionEntryInfo.setBillType(caBillInfo.getBillType());
        caApportionEntryInfo.setObjectID(caEntryInfo.getMaterial().getId().toString());
        caApportionEntryInfo.setCurrApportionAmt(diffAmt);
        caEntryInfo.setQty(BigDecimal.ZERO);
        caEntryInfo.setBaseQty(BigDecimal.ZERO);
        caEntryInfo.setPrice(BigDecimal.ZERO);
        caEntryInfo.setAmount(diffAmt);
        caEntryInfo.setStandardCost(diffAmt);
        caEntryInfo.setActualCost(diffAmt);
        caBillInfo.getEntry().add(caEntryInfo);
        entryColl.addObject((IObjectValue)caApportionEntryInfo);
    }

    protected void updatePur(String fid, BigDecimal amount, List updatePursqlList, boolean isNeedWriteBack, boolean hasApportioned) {
        StringBuffer sql = new StringBuffer();
        if (isNeedWriteBack) {
            sql.append("update T_IM_PurInWarehsEntry As entry set (FImputedCost,FPurchaseFee,FActualCost,FUnitActualCost)=");
            sql.append("(select IsNull(t1.FImputedCost, 0)+" + amount);
            if (hasApportioned) {
                sql.append(" ,IsNull(t1.FPurchaseFee, 0)+" + amount);
                sql.append(" ,IsNull(t1.FActualCost, 0)+" + amount);
                sql.append(" ,ROUND(TO_DECIMAL((t1.FActualCost+" + amount).append(")/t1.fqty,17,8), t2.FPriceprecision) ");
            } else {
                sql.append(" ,").append(amount);
                sql.append(" ,IsNull(t1.FPurchaseCost, 0)+IsNull(t1.FMaterialCost, 0)+").append(amount);
                sql.append(" ,ROUND(TO_DECIMAL((t1.FPurchaseCost+t1.FMaterialCost+" + amount).append(")/t1.fqty,17,8), t2.FPriceprecision) ");
            }
            sql.append(" from T_IM_PurInWarehsEntry t1 inner join T_BD_Material t2 on t1.fmaterialid=t2.fid ");
            sql.append(" where entry.FID=t1.FID and t1.FID ='").append(fid).append("')");
        } else {
            sql.append("update T_IM_PurInWarehsEntry set FImputedCost = IsNull(FImputedCost, 0)+");
            sql.append(amount);
            sql.append(" where FID = '").append(fid).append("'");
        }
        updatePursqlList.add(sql.toString());
    }

    public IObjectValue buildWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        ExpenseApportionEntryInfo entryInfo = new ExpenseApportionEntryInfo();
        entryInfo.setId(BOSUuid.create((String)"1F91CDEF"));
        entryInfo.setSourceBillId(rs.getString("id"));
        entryInfo.setSourceEntryId(rs.getString("entry.id"));
        entryInfo.setSourceNumber(rs.getString("number"));
        entryInfo.setSourceSeq(rs.getInt("entry.seq"));
        entryInfo.setObjectID(rs.getString("material.id"));
        String bosType = BOSUuid.read((String)rs.getString("id")).getType().toString();
        if (info != null) {
            entryInfo.setCurrApportionAmt(info.getLocalAmount());
        } else if ("48DA3A71".equals(bosType)) {
            entryInfo.setCurrApportionAmt(rs.getBigDecimal("entry.unApportionAmount"));
        }
        entryInfo.setBoolean("fiVouchered", rs.getBoolean("fiVouchered"));
        entryInfo.setInt("year", rs.getInt("year"));
        entryInfo.setInt("period", rs.getInt("period"));
        if ("48DA3A71".equals(bosType)) {
            entryInfo.setBizDate(rs.getDate("billDate"));
            if (entryInfo.getObjectID() == null) {
                entryInfo.setObjectID(rs.getString("expenseItem.id"));
            }
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            entryInfo.setBillType(billType);
            entryInfo.setString("supplierId", rs.getString("asstActID"));
        } else if ("783061E3".equals(bosType)) {
            entryInfo.setBizDate(rs.getDate("bizDate"));
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"50957179-0105-1000-e000-015fc0a812fd463ED552"));
            entryInfo.setBillType(billType);
            if (!"handDeal".equals(params.get((Object)"apportionStd"))) {
                entryInfo.setBigDecimal("apportionStd", rs.getBigDecimal(String.valueOf(params.get((Object)"apportionStd"))));
            }
            entryInfo.setInt("basePrecision", rs.getInt("currency2.precision"));
            entryInfo.setString("warehouseId", rs.getString("warehouse.id"));
            entryInfo.setString("locationId", rs.getString("location.id"));
            entryInfo.setString("projectId", rs.getString("project.id"));
            entryInfo.setString("trackNumberId", rs.getString("trackNumber.id"));
            entryInfo.setString("lot", rs.getString("entry.lot"));
            entryInfo.setString("storageOrgUnitId", rs.getString("storageOrgUnit1.id"));
            entryInfo.setString("baseUnitId", rs.getString("baseUnit.id"));
            entryInfo.setString("assistPropertyId", rs.getString("assistProperty.id"));
            entryInfo.setBigDecimal("imputedCost", rs.getBigDecimal("entry.imputedCost"));
            entryInfo.setBigDecimal("purchaseFee", rs.getBigDecimal("entry.purchaseFee"));
            entryInfo.setString("supplierId", rs.getString("supplier.id"));
            entryInfo.setString("costCenterOrgUnitId", rs.getString("costCenterOrgUnit.id"));
            entryInfo.setString("adminOrgUnitId", rs.getString("adminOrgUnit.id"));
            entryInfo.setInt("accountType", rs.getInt("materialCompany.accountType"));
            entryInfo.setBigDecimal("purchaseCost", rs.getBigDecimal("entry.purchaseCost"));
            entryInfo.setBigDecimal("materialCost", rs.getBigDecimal("entry.materialCost"));
            entryInfo.setBigDecimal("qty", rs.getBigDecimal("entry.qty"));
        }
        return entryInfo;
    }

    public SelectorItemCollection getSelector(String bosType, WriteOffCommonParams params) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String[] selectors = null;
        if ("48DA3A71".equals(bosType)) {
            selectors = new String[]{"billDate", "entry.seq", "material.id", "expenseItem.id", "entry.unApportionAmount", "year", "period", "fiVouchered", "asstActID"};
        } else if ("783061E3".equals(bosType)) {
            selectors = new String[]{"bizDate", "entry.seq", "material.id", "currency2.precision", "materialCompany.accountType", "entry.imputedCost", "entry.purchaseFee", "storageOrgUnit1.id", "warehouse.id", "baseUnit.id", "assistProperty.id", "entry.lot", "project.id", "trackNumber.id", "location.id", "supplier.id", "materialCompany.accountType", "fiVouchered", "year", "period", "entry.qty", "entry.purchaseCost", "entry.materialCost", "costCenterOrgUnit.id", "adminOrgUnit.id"};
        }
        if (selectors != null) {
            int len = selectors.length;
            for (int i = 0; i < len; ++i) {
                sic.add(new SelectorItemInfo((String)selectors[i]));
            }
            if ("783061E3".equals(bosType) && !"handDeal".equals(params.get((Object)"apportionStd"))) {
                sic.add(new SelectorItemInfo(String.valueOf(params.get((Object)"apportionStd"))));
            }
        }
        return sic;
    }

    protected Map getGroupMap(Map mainMap) {
        LinkedHashMap<String, ArrayList<ExpenseApportionEntryInfo>> groupMap = new LinkedHashMap<String, ArrayList<ExpenseApportionEntryInfo>>();
        Map.Entry me2 = null;
        ExpenseApportionEntryInfo entryInfo2 = null;
        String supplier = null;
        ArrayList<ExpenseApportionEntryInfo> newMainList = null;
        for (Map.Entry me2 : mainMap.entrySet()) {
            String oriKey = (String)me2.getKey();
            List mainList = (List)me2.getValue();
            for (ExpenseApportionEntryInfo entryInfo2 : mainList) {
                supplier = entryInfo2.getString("supplierId");
                newMainList = (ArrayList<ExpenseApportionEntryInfo>)groupMap.get(oriKey + "_@_" + supplier);
                if (null == newMainList) {
                    newMainList = new ArrayList<ExpenseApportionEntryInfo>();
                }
                newMainList.add(entryInfo2);
                groupMap.put(oriKey + "_@_" + supplier, newMainList);
            }
        }
        return groupMap;
    }

    protected String getsecMapKey(String key, boolean iskey) {
        String[] secMapKey = key.split("_@_");
        if (iskey) {
            return secMapKey[0];
        }
        return secMapKey[1];
    }

    public void writeLog(Context ctx, Set imBillNumber, Set invoiceBillNumber) {
        Iterator it2;
        StringBuffer msg = new StringBuffer();
        String number = null;
        ArrayList<String> msgList = new ArrayList<String>();
        String[] title = new String[3];
        String msgToContinueTitle = EASResource.getString((String)RES, (String)"msgToContinue");
        int limitLength = 1024;
        title[0] = EASResource.getString((String)RES, (String)"purExpenseApportion");
        title[1] = EASResource.getString((String)RES, (String)"purInWarehsBill");
        title[2] = EASResource.getString((String)RES, (String)"otherApBill");
        Iterator it = imBillNumber.iterator();
        if (it.hasNext()) {
            msg.append(title[1]).append(":");
            while (it.hasNext()) {
                number = it.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(title[1]).append(":");
                }
                msg.append(number).append(", ");
            }
        }
        if ((it2 = invoiceBillNumber.iterator()).hasNext()) {
            msg.append(title[2]).append(":");
            while (it2.hasNext()) {
                number = it2.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(title[2]).append(":");
                }
                msg.append(number).append(", ");
            }
        }
        if (msg.length() > 0) {
            msgList.add(msg.toString());
        }
        IObjectPK pklog = null;
        for (int i = 0; i < msgList.size(); ++i) {
            pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("FDB07C43"), null, (String)((String)msgList.get(i)), (String)title[0]);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }

    private void updateHead(Context ctx, Set<String> idSet, String tblName) throws BOSException {
        if (idSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("update ").append(tblName);
            sql.append(" set  FLastUpdateTime = getDate() where fid in (").append(CalculateUtil.getSqlInString(idSet)).append(")");
            DBUtil.execute((Context)ctx, (String)sql.toString());
        }
    }
}

