/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class InOutCalculateHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;
    private static final String res = "com.kingdee.eas.basedata.common.perf.PerfResource";
    private static Locale locale = null;

    public Object execute(Job job) throws Exception {
        Boolean bl;
        Context ctx = null;
        MessageInfo info = null;
        CompanyOrgUnitInfo company = null;
        boolean isCloseAccount = false;
        String operateType = null;
        Connection conn = null;
        try {
            ctx = job.getContext();
            conn = EJBFactory.getConnection((Context)ctx);
            TempTablePool.getInstance((Context)ctx).analyzeTable(conn, "T_CL_COSTCOMPUTEREPORT");
            JobParam jobParam = (JobParam)job.getParameters();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String startTime = df.format(new Date());
            CalculateParams parmas = (CalculateParams)jobParam.getBizParam();
            StringBuffer title = new StringBuffer(parmas.getString("title"));
            title.append(this.getAccountTypeName(parmas.getInt("ACCOUNT_TYPE"), ctx));
            ctx.put((Object)"UserInfo", parmas.getObject("CURRENT_USER"));
            ctx.put((Object)OrgType.Company, parmas.getObject("CURRENT_COMPANY"));
            ctx.put((Object)OrgType.ControlUnit, parmas.getObject("CURRENT_CU"));
            ctx.put((Object)"SCM_JOB_INST_ID", (Object)jobParam.getJobId());
            ctx.setLocale(jobParam.getLocale());
            boolean isSendMsg = true;
            locale = ctx.getLocale();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            info = new MessageInfo();
            info.setUserID(userId);
            info.setbizAction(title.toString());
            info.setOrgNumber(parmas.getString("COMPANY_NAME") + "(" + parmas.getString("COMPANY_NUMBER") + ")");
            String companyId = parmas.getString("COMPANY_ID");
            company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            if (null == company || null == company.getId()) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            if (CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                IRowSet row = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)company.getId().toString(), (boolean)false);
                if (row.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    while (row.next()) {
                        msg.append("\n").append(row.getString("fbilltype")).append(row.getString("fnumber")).append(",").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"operatorInfo", (Locale)ctx.getLocale())).append(row.getString("fuser"));
                    }
                    throw new CalculateException(CalculateException.IS_GEN_VOUCHER_EXCEPTION, new Object[]{msg});
                }
                operateType = jobNum + "_" + parmas.getInt("ACCOUNT_TYPE");
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"insertGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, List.class, String.class, String.class, String.class}, (Object[])new Object[]{ctx, company.getId().toString(), null, null, null, ctx.getUserName(), operateType}, (int)3);
            }
            if (!(isCloseAccount = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).isClosed(SystemEnum.INVENTORYMANAGEMENT, company))) {
                this.doneCloseAccount(ctx, company);
            }
            parmas.setString("startTime", startTime);
            CalculateFacadeFactory.getLocalInstance(ctx).costCalculate(parmas);
            JobLog log = new JobLog(JobLog.Type.Info, title + this.getResource("SUCCESS"));
            job.saveMessage(log);
            info.setSuccessed(true);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
            bl = new Boolean(true);
        }
        catch (Exception ee) {
            try {
                info.setExecption(ee.getMessage());
                info.setSuccessed(false);
                MessageUtil.sendMsg((Context)ctx, info);
                throw ee;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                PerfSepServerUtils.updateTaskState((Job)job);
                if (!isCloseAccount && company != null && company.getId() != null) {
                    this.doneReverCloseAccount(ctx, company);
                }
                if (company != null && company.getId() != null) {
                    EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, company.getId().toString(), null, operateType}, (int)3);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        PerfSepServerUtils.updateTaskState((Job)job);
        if (!isCloseAccount && company != null && company.getId() != null) {
            this.doneReverCloseAccount(ctx, company);
        }
        if (company != null && company.getId() != null) {
            EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, company.getId().toString(), null, operateType}, (int)3);
        }
        return bl;
    }

    private String getResource(String resName) {
        return ResourceBase.getString((String)res, (String)resName, (Locale)locale);
    }

    private void doneCloseAccount(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, cou, true);
    }

    private void doneReverCloseAccount(Context ctx, CompanyOrgUnitInfo cou) throws EASBizException, BOSException {
        ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        iSystemStatusCtrol.close(SystemEnum.INVENTORYMANAGEMENT, cou, false);
    }

    private String getAccountTypeName(int accountType, Context ctx) {
        String resFile = "com.kingdee.eas.scm.common.SCMResource";
        if (accountType == 3) {
            return SCMUtils.getResource((String)resFile, (String)"ADD_AVERAGE_VALUE", (Context)ctx);
        }
        if (accountType == 6) {
            return SCMUtils.getResource((String)resFile, (String)"MOVE_WEIGHTED_AVERAGE_VALUE", (Context)ctx);
        }
        if (accountType == 1) {
            return SCMUtils.getResource((String)resFile, (String)"MOVE_ADD_AVERAGE_VALUE", (Context)ctx);
        }
        if (accountType == 2) {
            return SCMUtils.getResource((String)resFile, (String)"STANDARDCOST_VALUE", (Context)ctx);
        }
        if (accountType == 4) {
            return SCMUtils.getResource((String)resFile, (String)"FIN_FOUT_VALUE", (Context)ctx);
        }
        if (accountType == 5) {
            return SCMUtils.getResource((String)resFile, (String)"SPECIAL_ACCT_VALUE", (Context)ctx);
        }
        return null;
    }
}

