/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.app.AbstractInvBalanceFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.util.LocaleUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class InvBalanceFacadeControllerBean
extends AbstractInvBalanceFacadeControllerBean {
    private static final long serialVersionUID = 4177056804122956666L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.InvBalanceFacadeControllerBean");
    private static String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private static String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry"}, {"T_CL_StandardCostAdjBill", "T_CL_StandardCostAdjEntry"}};

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        RptTableHeader header = this.buildHead(ctx, params);
        boolean isGrp = this.isGroup(params);
        boolean ckCompareBil = params.getBoolean("ckCompareBil");
        String tempTable = this.crtTempTable(ctx, params);
        params.setObject("tempTable", (Object)tempTable);
        String couNumber = params.getString("bizCompanyOrg");
        CompanyOrgUnitInfo cou = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where number = '" + couNumber + "'");
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)cou.getId().toString(), (String)"invbalanceui_view");
        if (checkPermission) {
            String pSql = this.getWherePeriodSql(ctx, params);
            params.setObject("wherePeriodSql", (Object)pSql);
            this.insInvBalance(ctx, params);
            if (ckCompareBil) {
                this.insBillData(ctx, params, 0, 4);
                this.insBillData(ctx, params, 5, 9);
            }
            if (isGrp) {
                this.groupTemp(ctx, params);
            }
        }
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String fName = this.getLocName(ctx);
        boolean isGrp = this.isGroup(params);
        if (!isGrp) {
            sql.append("select ").append("so.").append(fName).append(" as FStorageOrgName,FYEAR as FYear,FPERIOD as FPeriod,").append("m.").append(fName).append(" as FMaterialName,m.FNUMBER as FMaterialNumber,").append("w.").append(fName).append(" as FWarehouseName,w.FNUMBER as FWarehouseNumber,").append("l.FNUMBER as FLocationNumber,t.FLOT as FLot,").append("st.").append(fName).append(" as FStorestatusName,a.").append(fName).append(" as FAsstAttrName,").append("t.FPERIODBEGINQTY,t.FPERIODBEGINBALANCE,").append("t.FPERIODBEGINCOSTDIFF,t.FPERIODBEGINACTUALCOST,t.FPERIODRECEIPTQTY,t.FPERIODRECEIPTAMOUNT,").append("t.FPERIODRECEIPTCOSTDIFF,t.FPERIODISSUEQTY,t.FPERIODISSUECOSTDIFF,t.FPERIODISSUEAMOUNT,").append("t.FPERIODENDQTY,t.FPERIODENDBALANCE,t.FPERIODENDCOSTDIFF,t.FPERIODENDACTUALCOST ");
        } else {
            sql.append("select ").append("so.").append(fName).append(" as FStorageOrgName,FYEAR as FYear,FPERIOD as FPeriod,").append("m.").append(fName).append(" as FMaterialName,m.FNUMBER as FMaterialNumber,").append("w.").append(fName).append(" as FWarehouseName,w.FNUMBER as FWarehouseNumber,").append("t.FLOT as FLot,").append("t.FPERIODBEGINQTY,t.FPERIODBEGINBALANCE,").append("t.FPERIODBEGINCOSTDIFF,t.FPERIODBEGINACTUALCOST,t.FPERIODRECEIPTQTY,t.FPERIODRECEIPTAMOUNT,").append("t.FPERIODRECEIPTCOSTDIFF,t.FPERIODISSUEQTY,t.FPERIODISSUECOSTDIFF,t.FPERIODISSUEAMOUNT,").append("t.FPERIODENDQTY,t.FPERIODENDBALANCE,t.FPERIODENDCOSTDIFF,t.FPERIODENDACTUALCOST ");
            if (params.getBoolean("ckCompareBil")) {
                sql.append(",t.FBillRecQty,t.FBillRecAmount,t.FBillIssueQty,t.FBillIssueAmout ").append(",t.FPERIODRECEIPTQTY - t.FBillRecQty,t.FPERIODRECEIPTAMOUNT - t.FBillRecAmount").append(",t.FPERIODISSUEQTY - t.FBillIssueQty,t.FPERIODISSUEAMOUNT - t.FBillIssueAmout ");
            }
        }
        sql.append("from ").append(tempTable).append(" t ").append("inner join t_org_company co on t.FCompanyOrgUnitID = co.FID ").append("left join t_org_storage so on t.FStorageOrgUnitID = so.FID ").append("inner join t_bd_material m on t.FMATERIALID = m.FID ").append("left join t_db_warehouse w on t.FWAREHOUSEID = w.FID ").append("left join t_db_location l on t.FLOCATIONID = l.FID ");
        if (!isGrp) {
            sql.append("left join t_bd_asstattrvalue a on t.FASSISTPROPERTYID = a.FID ").append("left join t_im_storestate st on t.FSTORESTATUSID = st.FID ");
        }
        sql.append("where  1 = 1 ");
        if (isGrp && params.getBoolean("ckOnlyShowErrorRow")) {
            sql.append("and ( t.FPERIODRECEIPTQTY <> t.FBillRecQty  or t.FPERIODRECEIPTAMOUNT <> t.FBillRecAmount ").append("or  t.FPERIODISSUEQTY <> t.FBillIssueQty or t.FPERIODISSUEAMOUNT <> t.FBillIssueAmout) ");
        }
        sql.append("order by ").append("t.FYEAR,t.FPERIOD,so.FNumber,m.FNumber,w.FNumber,t.FLOT ");
        if (from == 0) {
            StringBuffer countSql = new StringBuffer("select count(1) from ").append(tempTable).append(" t ");
            countSql.append("where 1 = 1 ");
            if (isGrp && params.getBoolean("ckOnlyShowErrorRow")) {
                countSql.append("and ( t.FPERIODRECEIPTQTY <> t.FBillRecQty  or t.FPERIODRECEIPTAMOUNT <> t.FBillRecAmount ").append("or  t.FPERIODISSUEQTY <> t.FBillIssueQty or t.FPERIODISSUEAMOUNT <> t.FBillIssueAmout) ");
            }
            RptRowSet rsCount = this.executeQuery(countSql.toString(), null, ctx);
            rsCount.next();
            int count = rsCount.getInt(0);
            pp.setInt("totalCount", count);
        }
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected boolean isGroup(RptParams params) {
        boolean isGrp = false;
        if (params.getBoolean("ckGroupBy")) {
            isGrp = true;
        }
        return isGrp;
    }

    protected String getCreateTempTable(RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ").append(" InvBalance ").append("( ").append("FINDEX Int  NOT NULL Default -1 , ").append("FCompanyOrgUnitID Varchar(44),").append("FSTORAGEORGUNITID Varchar(44),").append("FWAREHOUSEID Varchar(44),").append("FMATERIALID Varchar(44),").append("FLOCATIONID Varchar(44),").append("FLOT NVarchar(255),").append("FYEAR INT,").append("FPERIOD INT,").append("FSTORESTATUSID Varchar(44),").append("FASSISTPROPERTYID Varchar(44),").append("FPERIODBEGINQTY NUMERIC(28,8)  DEFAULT 0,").append("FPERIODBEGINBALANCE NUMERIC(28,8)  DEFAULT 0,").append("FPERIODBEGINCOSTDIFF NUMERIC(28,8)  DEFAULT 0,").append("FPERIODBEGINACTUALCOST NUMERIC(28,8)  DEFAULT 0,").append("FPERIODRECEIPTQTY NUMERIC(28,8)  DEFAULT 0,").append("FPERIODRECEIPTAMOUNT NUMERIC(28,8)  DEFAULT 0,").append("FPERIODRECEIPTCOSTDIFF NUMERIC(28,8)  DEFAULT 0,").append("FPERIODISSUEQTY NUMERIC(28,8)  DEFAULT 0,").append("FPERIODISSUECOSTDIFF NUMERIC(28,8)  DEFAULT 0,").append("FPERIODISSUEAMOUNT NUMERIC(28,8)  DEFAULT 0,").append("FPERIODENDQTY NUMERIC(28,8)  DEFAULT 0,").append("FPERIODENDBALANCE NUMERIC(28,8)  DEFAULT 0,").append("FPERIODENDCOSTDIFF NUMERIC(28,8)  DEFAULT 0,").append("FPERIODENDACTUALCOST NUMERIC(28,8)  DEFAULT 0,").append("FBillRecQty NUMERIC(28,8)  DEFAULT 0,").append("FBillRecAmount NUMERIC(28,8)  DEFAULT 0,").append("FBillIssueQty NUMERIC(28,8)  DEFAULT 0,").append("FBillIssueAmout NUMERIC(28,8)  DEFAULT 0").append(")");
        return sql.toString();
    }

    protected String crtTempTable(Context ctx, RptParams params) throws BOSException {
        return KsqlUtil.createTempTable((Context)ctx, (String)this.getCreateTempTable(params));
    }

    protected void insInvBalance(Context ctx, RptParams params) throws BOSException {
        boolean isGrp = this.isGroup(params);
        StringBuffer sql = new StringBuffer();
        if (!isGrp) {
            sql.append("insert into ").append(params.getString("tempTable")).append("(").append("FCompanyOrgUnitID,FSTORAGEORGUNITID,FWAREHOUSEID,FMATERIALID,FLOCATIONID,FLOT,FYEAR,FPERIOD,").append("FSTORESTATUSID,FASSISTPROPERTYID,FPERIODBEGINQTY,FPERIODBEGINBALANCE,").append("FPERIODBEGINCOSTDIFF,FPERIODBEGINACTUALCOST,FPERIODRECEIPTQTY,FPERIODRECEIPTAMOUNT,").append("FPERIODRECEIPTCOSTDIFF,FPERIODISSUEQTY,FPERIODISSUECOSTDIFF,FPERIODISSUEAMOUNT,").append("FPERIODENDQTY,FPERIODENDBALANCE,FPERIODENDCOSTDIFF,FPERIODENDACTUALCOST").append(") ").append("select ").append("h.FCompanyOrgUnitID,h.FSTORAGEORGUNITID,h.FWAREHOUSEID,h.FMATERIALID,h.FLOCATIONID,h.FLOT,h.FYEAR,h.FPERIOD,").append("h.FSTORESTATUSID,h.FASSISTPROPERTYID,h.FPERIODBEGINQTY,h.FPERIODBEGINBALANCE,").append("h.FPERIODBEGINCOSTDIFF,h.FPERIODBEGINACTUALCOST,h.FPERIODRECEIPTQTY,h.FPERIODRECEIPTAMOUNT,").append("h.FPERIODRECEIPTCOSTDIFF,h.FPERIODISSUEQTY,h.FPERIODISSUECOSTDIFF,h.FPERIODISSUEAMOUNT,").append("h.FPERIODENDQTY,h.FPERIODENDBALANCE,h.FPERIODENDCOSTDIFF,h.FPERIODENDACTUALCOST ");
        } else {
            sql.append("insert into ").append(params.getString("tempTable")).append("(").append("FCompanyOrgUnitID,FSTORAGEORGUNITID,FWAREHOUSEID,FMATERIALID,FLOT,FYEAR,FPERIOD,").append("FPERIODBEGINQTY,FPERIODBEGINBALANCE,").append("FPERIODBEGINCOSTDIFF,FPERIODBEGINACTUALCOST,FPERIODRECEIPTQTY,FPERIODRECEIPTAMOUNT,").append("FPERIODRECEIPTCOSTDIFF,FPERIODISSUEQTY,FPERIODISSUECOSTDIFF,FPERIODISSUEAMOUNT,").append("FPERIODENDQTY,FPERIODENDBALANCE,FPERIODENDCOSTDIFF,FPERIODENDACTUALCOST").append(") ").append("select ").append("h.FCompanyOrgUnitID,h.FSTORAGEORGUNITID,h.FWAREHOUSEID,h.FMATERIALID,h.FLOT,h.FYEAR,h.FPERIOD,").append("sum(h.FPERIODBEGINQTY),sum(h.FPERIODBEGINBALANCE),").append("sum(h.FPERIODBEGINCOSTDIFF),sum(h.FPERIODBEGINACTUALCOST),sum(h.FPERIODRECEIPTQTY),sum(h.FPERIODRECEIPTAMOUNT),").append("sum(h.FPERIODRECEIPTCOSTDIFF),sum(h.FPERIODISSUEQTY),sum(h.FPERIODISSUECOSTDIFF),sum(h.FPERIODISSUEAMOUNT),").append("sum(h.FPERIODENDQTY),sum(h.FPERIODENDBALANCE),sum(h.FPERIODENDCOSTDIFF),sum(h.FPERIODENDACTUALCOST) ");
        }
        sql.append("from t_im_inventorybalance h ").append("inner join t_org_company co on h.FCompanyOrgUnitID = co.FID ").append("inner join t_org_storage so on h.FSTORAGEORGUNITID = so.FID ").append("inner join t_bd_material m on  h.FMaterialID = m.FID ").append("inner join t_bd_materialcompanyinfo mcom on h.FMaterialId = mcom.FMaterialID and h.FCompanyOrgUnitid = mcom.FCompanyID ").append("left join t_db_warehouse w on  h.FWarehouseID = w.FID ").append("left join t_db_location l on  h.FLocationID = l.FID ").append("left join t_bd_asstattrvalue a on h.FASSISTPROPERTYID = a.FID ");
        sql.append(" where ");
        sql.append("co.FNumber = '").append(params.getString("bizCompanyOrg")).append("' ").append("and ").append(params.getString("wherePeriodSql")).append(" ");
        if (!params.getBoolean("ckShowNoCalculate")) {
            sql.append(" and h.FIsCalculate = 1 ");
        }
        if (params.getObject("bizMaterialFrom") != null) {
            if (params.getObject("bizMaterialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("bizMaterialFrom");
                if (materials.length == 1) {
                    sql.append(" and m.FNumber >= '").append(((MaterialInfo)materials[0]).getNumber()).append("' ");
                } else {
                    sql.append(" and m.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(")");
                }
            } else {
                sql.append(" and m.FNumber >= '").append(params.getString("bizMaterialFrom")).append("' ");
            }
        }
        if (params.getString("bizMaterialTo") != null) {
            sql.append(" and m.FNumber <= '").append(params.getString("bizMaterialTo")).append("' ");
        }
        if (params.getObject("bizWarehouseFrom") != null) {
            if (params.getObject("bizWarehouseFrom") instanceof Object[]) {
                Object[] warehouses = (Object[])params.getObject("bizWarehouseFrom");
                if (warehouses.length == 1) {
                    sql.append(" and w.FNumber >= '").append(((WarehouseInfo)warehouses[0]).getNumber()).append("' ");
                } else {
                    sql.append(" and w.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(warehouses)).append(")");
                }
            } else {
                sql.append(" and w.FNumber >= '").append(params.getObject("bizWarehouseFrom")).append("' ");
            }
        }
        if (params.getString("bizWarehouseTo") != null) {
            sql.append(" and w.FNumber <= '").append(params.getString("bizWarehouseTo")).append("' ");
        }
        if (params.getString("bizLocationFrom") != null) {
            sql.append(" and l.FNumber >= '").append(params.getString("bizLocationFrom")).append("' ");
        }
        if (params.getString("bizLocationTo") != null) {
            sql.append(" and l.FNumber <= '").append(params.getString("bizLocationTo")).append("' ");
        }
        if (params.getString("txtLotFrom") != null) {
            sql.append(" and h.FLot >= '").append(params.getString("txtLotFrom")).append("' ");
        }
        if (params.getString("txtLotTo") != null) {
            sql.append(" and h.FLot <= '").append(params.getString("txtLotTo")).append("' ");
        }
        if (params.getString("bizAssPropFrom") != null) {
            sql.append(" and a.FNumber >= '").append(params.getString("bizAssPropFrom")).append("' ");
        }
        if (params.getString("bizAssPropTo") != null) {
            sql.append(" and a.FNumber <= '").append(params.getString("bizAssPropTo")).append("' ");
        }
        if (isGrp) {
            sql.append(" group by ").append("h.FCompanyOrgUnitID,h.FSTORAGEORGUNITID,h.FWAREHOUSEID,h.FMATERIALID,h.FLOT,h.FYEAR,h.FPERIOD ");
        }
        logger.debug((Object)("insertBalance sql\n" + sql.toString()));
        this.executeSQL(ctx, sql.toString());
    }

    protected void insBillData(Context ctx, RptParams params, int startIndex, int endIndex) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(params.getString("tempTable")).append("(").append("FCompanyOrgUnitID,FSTORAGEORGUNITID,FWAREHOUSEID,FMATERIALID,FLOT,FYEAR,FPERIOD,").append("FBillRecQty,FBillRecAmount,FBillIssueQty,FBillIssueAmout) ").append("\r\n");
        sql.append("select  ").append("a.FCompanyOrgUnitID,a.FSTORAGEORGUNITID,a.FWAREHOUSEID,a.FMATERIALID,a.FLOT,a.FYEAR,a.FPERIOD,").append("sum(a.FBillRecQty),").append("sum(CASE mcom.FAccountType WHEN 2 THEN a.FBillRecStdAmount ELSE  a.FBillRecActAmount END) as FBillRecAmount,").append("sum(a.FBillIssueQty),").append("sum(CASE mcom.FAccountType WHEN 2 THEN a.FBillIssueStdAmout ELSE  a.FBillIssueActAmout END) as FBillIssueAmout ").append("from ( ").append("\r\n");
        for (int i = startIndex; i <= endIndex; ++i) {
            if (i != startIndex) {
                sql.append(" union all ").append("\r\n");
            }
            sql.append(this.getBillSql(params, tableName[i][0], tableName[i][1])).append(" ");
            sql.append("\r\n");
        }
        sql.append("\r\n").append(") a ").append("inner join t_bd_materialcompanyinfo mcom ").append("on a.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = a.FCompanyOrgUnitID ").append("group by ").append("a.FCompanyOrgUnitID,a.FSTORAGEORGUNITID,a.FWAREHOUSEID,a.FMATERIALID,a.FLOT,a.FYEAR,a.FPERIOD ");
        this.executeSQL(ctx, sql.toString());
    }

    protected String getBillSql(RptParams params, String headTb, String entryTb) {
        StringBuffer sql = new StringBuffer();
        if (headTb.equals("T_CL_StandardCostAdjBill")) {
            sql.append("select ").append("h.FCompanyOrgUnitID as FCompanyOrgUnitID,null as FSTORAGEORGUNITID,").append("null as FWAREHOUSEID,e.FMATERIALID as FMATERIALID,").append("null as FLOT,h.FYEAR as FYEAR,h.FPERIOD as FPERIOD,").append("0 as FBillRecQty,e.FDiffAmount as FBillRecStdAmount,e.FDiffAmount as FBillRecActAmount,").append("0 as FBillIssueQty,0 as FBillIssueStdAmout,0 as FBillIssueActAmout ").append("from ").append(headTb).append(" h ").append("inner join ").append(entryTb).append(" e  on ").append(" h.fid = e.fparentid ").append("inner join t_org_company co on h.FCompanyOrgUnitID = co.FID ").append("inner join t_bd_material m on  e.FMaterialID = m.FID ").append("where ").append("co.Fnumber = '").append(params.getString("bizCompanyOrg")).append("' ").append("and ").append(params.getString("wherePeriodSql")).append(" ").append("and h.FBaseStatus = ").append(4).append(" ");
            if (params.getObject("bizMaterialFrom") != null) {
                if (params.getObject("bizMaterialFrom") instanceof Object[]) {
                    Object[] materials = (Object[])params.getObject("bizMaterialFrom");
                    if (materials.length == 1) {
                        sql.append(" and m.FNumber >= '").append(((MaterialInfo)materials[0]).getNumber()).append("' ");
                    } else {
                        sql.append(" and m.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(")");
                    }
                } else {
                    sql.append(" and m.FNumber >= '").append(params.getObject("bizMaterialFrom")).append("' ");
                }
            }
            if (params.getString("bizMaterialTo") != null) {
                sql.append(" and m.FNumber <= '").append(params.getString("bizMaterialTo")).append("' ");
            }
            return sql.toString();
        }
        sql.append("select ").append("e.FCompanyOrgUnitID as FCompanyOrgUnitID,e.FSTORAGEORGUNITID as FSTORAGEORGUNITID,").append("e.FWAREHOUSEID as FWAREHOUSEID,e.FMATERIALID as FMATERIALID,").append("e.FLOT as FLOT,h.FYEAR as FYEAR,h.FPERIOD as FPERIOD,");
        String joinSql = this.getJoinSql(params, "e");
        String sqlWhere = this.getWhereSql(params);
        if (headTb.equals("T_IM_PurInWarehsBill") || headTb.equals("T_IM_ManufactureRecBill") || headTb.equals("T_IM_MoveInWarehsBill") || headTb.equals("T_IM_OtherInWarehsBill")) {
            sql.append("fbaseqty as FBillRecQty,e.FStandardCost as FBillRecStdAmount,e.FActualCost as FBillRecActAmount,").append("0 as FBillIssueQty,0 as FBillIssueStdAmout,0 as FBillIssueActAmout ");
            joinSql = joinSql + " inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid ";
            if (!params.getBoolean("ckShowNoCalculate")) {
                sqlWhere = sqlWhere + " and tr.FIsCalculate = 1 ";
            }
        } else if (headTb.equals("T_IM_SaleIssueBill") || headTb.equals("T_IM_MaterialReqBill") || headTb.equals("T_IM_MoveIssueBill") || headTb.equals("T_IM_OtherIssueBill")) {
            sql.append("0 as FBillRecQty,0 as FBillRecStdAmount,0 as FBillRecActAmount,").append("fbaseqty as FBillIssueQty,e.FStandardCost as FBillIssueStdAmout,e.FActualCost as FBillIssueActAmout ");
            joinSql = joinSql + " inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid ";
            if (!params.getBoolean("ckShowNoCalculate")) {
                sqlWhere = sqlWhere + " and tr.FIsCalculate = 1 ";
            }
        } else if (headTb.equals("T_CL_CostAdjustBill")) {
            sql.append("0 as FBillRecQty,").append("case h.FCalculateKind when 0 then e.FStandardCost else 0 end as FBillRecStdAmount,").append("case h.FCalculateKind when 0 then e.FActualCost   else 0 end as  FBillRecActAmount,").append("0 as FBillIssueQty,").append("case h.FCalculateKind when 1 then e.FStandardCost else 0 end as FBillIssueStdAmout,").append("case h.FCalculateKind when 1 then e.FActualCost   else 0 end as  FBillIssueActAmout ");
        }
        if (headTb.equals("T_CL_CostAdjustBill")) {
            sql.append("from ").append(headTb).append(" h ").append("inner join ").append(entryTb).append(" e  on ").append(" h.fid = e.fparentid ").append("inner join t_bd_materialcompanyinfo mc ").append("on  mc.FMaterialID = e.FMaterialID  AND mc.FCompanyID = e.FCompanyOrgUnitID ").append(joinSql).append(sqlWhere).append("and mc.FAccountType <> 2 ");
        } else {
            sql.append("from ").append(headTb).append(" h ").append("inner join ").append(entryTb).append(" e  on ").append(" h.fid = e.fparentid ").append(joinSql).append(sqlWhere);
        }
        return sql.toString();
    }

    protected String getJoinSql(RptParams params, String tbAlias) {
        StringBuffer joinSql = new StringBuffer();
        joinSql.append("inner join t_org_company co on ").append(tbAlias).append(".FCompanyOrgUnitID = co.FID ");
        if (params.getString("bizMaterialFrom") != null || params.getString("bizMaterialTo") != null) {
            joinSql.append("inner join t_bd_material m on  ").append(tbAlias).append(".FMaterialID = m.FID ");
        }
        if (params.getString("bizWarehouseFrom") != null || params.getString("bizWarehouseTo") != null) {
            joinSql.append("left join t_db_warehouse w on  ").append(tbAlias).append(".FWarehouseID = w.FID ");
        }
        if (params.getString("bizLocationFrom") != null || params.getString("bizLocationTo") != null) {
            joinSql.append("left join t_db_location l on  ").append(tbAlias).append(".FLocationID = l.FID ");
        }
        if (params.getString("bizAssPropFrom") != null || params.getString("bizAssPropTo") != null) {
            joinSql.append("left join t_bd_asstattrvalue a on ").append(tbAlias).append(".FASSISTPROPERTYID = a.FID ");
        }
        return joinSql.toString();
    }

    protected String getWhereSql(RptParams params) {
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append("where ").append("co.Fnumber = '").append(params.getString("bizCompanyOrg")).append("' ").append("and ").append(params.getString("wherePeriodSql")).append(" ").append("and h.FBaseStatus = ").append(4).append(" ");
        if (params.getObject("bizMaterialFrom") != null) {
            if (params.getObject("bizMaterialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("bizMaterialFrom");
                if (materials.length == 1) {
                    sqlWhere.append(" and m.FNumber >= '").append(((MaterialInfo)materials[0]).getNumber()).append("' ");
                } else {
                    sqlWhere.append(" and m.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(")");
                }
            } else {
                sqlWhere.append(" and m.FNumber >= '").append(params.getObject("bizMaterialFrom")).append("' ");
            }
        }
        if (params.getString("bizMaterialTo") != null) {
            sqlWhere.append(" and m.FNumber <= '").append(params.getString("bizMaterialTo")).append("' ");
        }
        if (params.getObject("bizWarehouseFrom") != null) {
            if (params.getObject("bizWarehouseFrom") instanceof Object[]) {
                Object[] warehouses = (Object[])params.getObject("bizWarehouseFrom");
                if (warehouses.length == 1) {
                    sqlWhere.append(" and w.FNumber >= '").append(((WarehouseInfo)warehouses[0]).getNumber()).append("' ");
                } else {
                    sqlWhere.append(" and w.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(warehouses)).append(")");
                }
            } else {
                sqlWhere.append(" and w.FNumber >= '").append(params.getObject("bizWarehouseFrom")).append("' ");
            }
        }
        if (params.getString("bizWarehouseTo") != null) {
            sqlWhere.append(" and w.FNumber <= '").append(params.getString("bizWarehouseTo")).append("' ");
        }
        if (params.getString("bizLocationFrom") != null) {
            sqlWhere.append(" and l.FNumber >= '").append(params.getString("bizLocationFrom")).append("' ");
        }
        if (params.getString("bizLocationTo") != null) {
            sqlWhere.append(" and l.FNumber <= '").append(params.getString("bizLocationTo")).append("' ");
        }
        if (params.getString("txtLotFrom") != null) {
            sqlWhere.append(" and e.FLot >= '").append(params.getString("txtLotFrom")).append("' ");
        }
        if (params.getString("txtLotTo") != null) {
            sqlWhere.append(" and e.FLot <= '").append(params.getString("txtLotTo")).append("' ");
        }
        if (params.getString("bizAssPropFrom") != null) {
            sqlWhere.append(" and a.FNumber >= '").append(params.getString("bizAssPropFrom")).append("' ");
        }
        if (params.getString("bizAssPropTo") != null) {
            sqlWhere.append(" and a.FNumber <= '").append(params.getString("bizAssPropTo")).append("' ");
        }
        return sqlWhere.toString();
    }

    protected void groupTemp(Context ctx, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        sql.append("insert into ").append(tempTable).append("(").append("FIndex,FCompanyOrgUnitID,FSTORAGEORGUNITID,FWAREHOUSEID,FMATERIALID,FLOT,FYEAR,FPERIOD,").append("FPERIODBEGINQTY,FPERIODBEGINBALANCE,").append("FPERIODBEGINCOSTDIFF,FPERIODBEGINACTUALCOST,FPERIODRECEIPTQTY,FPERIODRECEIPTAMOUNT,").append("FPERIODRECEIPTCOSTDIFF,FPERIODISSUEQTY,FPERIODISSUECOSTDIFF,FPERIODISSUEAMOUNT,").append("FPERIODENDQTY,FPERIODENDBALANCE,FPERIODENDCOSTDIFF,FPERIODENDACTUALCOST,").append("FBillRecQty,FBillRecAmount,FBillIssueQty,FBillIssueAmout").append(") ").append("select ").append("0 as FIndex,FCompanyOrgUnitID,FSTORAGEORGUNITID,FWAREHOUSEID,FMATERIALID,FLOT,FYEAR,FPERIOD,").append("sum(FPERIODBEGINQTY),sum(FPERIODBEGINBALANCE),").append("sum(FPERIODBEGINCOSTDIFF),sum(FPERIODBEGINACTUALCOST),sum(FPERIODRECEIPTQTY),sum(FPERIODRECEIPTAMOUNT),").append("sum(FPERIODRECEIPTCOSTDIFF),sum(FPERIODISSUEQTY),sum(FPERIODISSUECOSTDIFF),sum(FPERIODISSUEAMOUNT),").append("sum(FPERIODENDQTY),sum(FPERIODENDBALANCE),sum(FPERIODENDCOSTDIFF),sum(FPERIODENDACTUALCOST),").append("sum(FBillRecQty),sum(FBillRecAmount),sum(FBillIssueQty),sum(FBillIssueAmout)").append("from ").append(tempTable).append(" ").append("group by ").append("FCompanyOrgUnitID,FSTORAGEORGUNITID,FWAREHOUSEID,FMATERIALID,FLOT,FYEAR,FPERIOD ");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("delete from ").append(tempTable).append(" where FIndex = -1 ");
        this.executeSQL(ctx, sql.toString());
    }

    private String getWherePeriodSql(Context ctx, RptParams params) throws BOSException, EASBizException {
        int toPeriod;
        String beginYear = params.getObject("spAccPeriodYear").toString();
        String beginPeriod = params.getObject("spAccPeriodMonth").toString();
        String endYear = params.getObject("spAccPeriodYearTo").toString();
        String endPeriod = params.getObject("spAccPeriodMonthTo").toString();
        int fromPeriod = new Integer(beginYear) * 100 + new Integer(beginPeriod);
        if (fromPeriod > (toPeriod = new Integer(endYear) * 100 + new Integer(endPeriod))) {
            return " 1 = 0 ";
        }
        String bizCompanyOrg = params.getString("bizCompanyOrg");
        StringBuffer sql = new StringBuffer();
        sql.append("select fperiodyear,fperiodnumber ").append("from t_bd_period p,t_org_company co ").append("where ").append("p.ftypeid = co.FAccountPeriodID ").append("and co.fnumber = '").append(bizCompanyOrg).append("' ").append("and p.fperiodyear * 100 + p.fperiodnumber >= ").append(fromPeriod).append(" ").append("and fperiodyear * 100 + fperiodnumber <= ").append(toPeriod).append(" ").append(" and p.FISADJUSTPERIOD = 0 ").append("order by fperiodyear,fperiodnumber");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        StringBuffer wsql = new StringBuffer();
        while (rs.next()) {
            wsql.append(" or (h.fyear = ").append(rs.getInt("fperiodyear")).append(" and h.fperiod = ").append(rs.getInt("fperiodnumber")).append(")");
        }
        if (wsql.length() > 3) {
            return " (" + wsql.substring(3) + ") ";
        }
        return wsql.toString();
    }

    protected RptTableHeader buildHead(Context ctx, RptParams params) {
        RptTableHeader header = new RptTableHeader();
        Vector<String> vlabel = new Vector<String>();
        Vector<String> vlabel2 = new Vector<String>();
        boolean isGrp = this.isGroup(params);
        int textPrec = -1;
        int qtyPrec = 6;
        int pricePrec = 2;
        boolean isShowAll = params.getBoolean("ckShowAllCol");
        InvBalanceFacadeControllerBean.setHeadCol(header, "FSTORAGEORGUNITName", 150, textPrec, 0);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FYear", 50, textPrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPeriod", 50, textPrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FMATERIALName", 120, textPrec, 0);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FMATERIALNum", 80, textPrec, 0);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FWAREHOUSEName", 120, textPrec, 0);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FWAREHOUSENum", 80, textPrec, 0);
        if (!isGrp) {
            InvBalanceFacadeControllerBean.setHeadCol(header, "FLOCATIONNum", 80, textPrec, 0);
        }
        InvBalanceFacadeControllerBean.setHeadCol(header, "FLOT", 80, textPrec, 0);
        if (!isGrp) {
            InvBalanceFacadeControllerBean.setHeadCol(header, "FSTORESTATUSName", 120, textPrec, 0);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FASSISTPROPERTYName", 80, textPrec, 0);
        }
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODBEGINQTY", 80, qtyPrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODBEGINBALANCE", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODBEGINCOSTDIFF", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODBEGINACTUALCOST", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODRECEIPTQTY", 80, qtyPrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODRECEIPTAMOUNT", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODRECEIPTCOSTDIFF", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODISSUEQTY", 80, qtyPrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODISSUECOSTDIFF", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODISSUEAMOUNT", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODENDQTY", 80, qtyPrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODENDBALANCE", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODENDCOSTDIFF", 80, pricePrec, 2);
        InvBalanceFacadeControllerBean.setHeadCol(header, "FPERIODENDACTUALCOST", 80, pricePrec, 2);
        if (params.getBoolean("ckCompareBil")) {
            InvBalanceFacadeControllerBean.setHeadCol(header, "FBillRecQty", 80, qtyPrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FBillRecAmount", 80, pricePrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FBillIssueQty", 80, qtyPrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FBillIssueAmout", 80, pricePrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FRECEPTQTYDIFF", 80, qtyPrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FRECEPTAMOUNTDIFF", 80, pricePrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FISSUEQTYDIFF", 80, qtyPrec, 2);
            InvBalanceFacadeControllerBean.setHeadCol(header, "FISSUEAMOUNTDIFF", 80, pricePrec, 2);
        }
        ArrayList<String> hideCol = new ArrayList<String>();
        hideCol.add("FMATERIALName");
        hideCol.add("FWAREHOUSEName");
        hideCol.add("FPERIODBEGINCOSTDIFF");
        hideCol.add("FPERIODBEGINACTUALCOST");
        hideCol.add("FPERIODRECEIPTCOSTDIFF");
        hideCol.add("FPERIODISSUECOSTDIFF");
        hideCol.add("FPERIODENDCOSTDIFF");
        hideCol.add("FPERIODENDACTUALCOST");
        if (!isShowAll) {
            int size = header.getColumnCount();
            for (int i = 0; i < size; ++i) {
                if (!hideCol.contains(header.getColumn(i).getName())) continue;
                header.getColumn(i).setHided(true);
                header.getColumn(i).setWidth(-1);
            }
        }
        vlabel.add(SCMUtils.getResource((String)res, (String)"STORAGEORG", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"YEAR", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"PERIOD", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"MATERIELNAME", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"MATERIELCODE", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"WAREHOUSENAME", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"WAREHOUSENUM", (Context)ctx));
        if (!isGrp) {
            vlabel.add(SCMUtils.getResource((String)res, (String)"LOCATIONNUM", (Context)ctx));
        }
        vlabel.add(SCMUtils.getResource((String)res, (String)"LOT", (Context)ctx));
        if (!isGrp) {
            vlabel.add(SCMUtils.getResource((String)res, (String)"INVSTORESTATUS", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"ASSISTPROPERTY", (Context)ctx));
        }
        vlabel.add(SCMUtils.getResource((String)res, (String)"FIRSTPERIOD", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"FIRSTPERIOD", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"FIRSTPERIOD", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"FIRSTPERIOD", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"IN", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"IN", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"IN", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"OUT", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"OUT", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"OUT", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"BALANCE", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"BALANCE", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"BALANCE", (Context)ctx));
        vlabel.add(SCMUtils.getResource((String)res, (String)"BALANCE", (Context)ctx));
        if (params.getBoolean("ckCompareBil")) {
            vlabel.add(SCMUtils.getResource((String)res, (String)"Bill", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"Bill", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"Bill", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"Bill", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"DIFFERENCE", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"DIFFERENCE", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"DIFFERENCE", (Context)ctx));
            vlabel.add(SCMUtils.getResource((String)res, (String)"DIFFERENCE", (Context)ctx));
        }
        vlabel2.add(SCMUtils.getResource((String)res, (String)"STORAGEORG", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"YEAR", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIOD", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"MATERIELNAME", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"MATERIELCODE", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"WAREHOUSENAME", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"WAREHOUSENUM", (Context)ctx));
        if (!isGrp) {
            vlabel2.add(SCMUtils.getResource((String)res, (String)"LOCATIONNUM", (Context)ctx));
        }
        vlabel2.add(SCMUtils.getResource((String)res, (String)"LOT", (Context)ctx));
        if (!isGrp) {
            vlabel2.add(SCMUtils.getResource((String)res, (String)"INVSTORESTATUS", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"ASSISTPROPERTY", (Context)ctx));
        }
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODBEGINQTY", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODBEGINBALANCE", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODBEGINCOSTDIFF", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODBEGINACTUALCOST", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODRECEIPTQTY", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODRECEIPTAMOUNT", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODRECEIPTCOSTDIFF", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODISSUEQTY", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODISSUECOSTDIFF", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODISSUEAMOUNT", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODENDQTY", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODENDBALANCE", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODENDCOSTDIFF", (Context)ctx));
        vlabel2.add(SCMUtils.getResource((String)res, (String)"PERIODENDACTUALCOST", (Context)ctx));
        if (params.getBoolean("ckCompareBil")) {
            vlabel2.add(SCMUtils.getResource((String)res, (String)"BillRecQty", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"BillRecAmount", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"BillIssueQty", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"BillIssueAmout", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"RECEPTQTYDIFF", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"RECEPTAMOUNTDIFF", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"ISSUEQTYDIFF", (Context)ctx));
            vlabel2.add(SCMUtils.getResource((String)res, (String)"ISSUEAMOUNTDIFF", (Context)ctx));
        }
        Object[] labels1 = vlabel.toArray();
        Object[] labels2 = vlabel2.toArray();
        Object[][] labels = new Object[][]{labels1, labels2};
        header.setLabels(labels, true);
        header.setLabels(labels, true);
        return header;
    }

    protected static void setHeadCol(RptTableHeader header, String colName, int colLength, int precision, int lignStyle) {
        RptTableColumn col = new RptTableColumn(colName);
        col.setWidth(colLength);
        if (colLength == -1) {
            col.setHided(true);
        }
        if (precision > -1) {
            col.setFormatPattern(CalculateUtil.getFormatPattern(precision));
        }
        col.setAligment(lignStyle);
        header.addColumn(col);
    }

    protected static void setHeadCol(Context ctx, RptParams params, boolean isHide, RptTableHeader header, String colName, int colLength, int precision, List vlabel, String resName, int lignStyle) {
        if (isHide) {
            colLength = -1;
        }
        InvBalanceFacadeControllerBean.setHeadCol(header, colName, colLength, precision, lignStyle);
        vlabel.add(SCMUtils.getResource((String)res, (String)resName, (Context)ctx));
    }

    protected static boolean isShowCol(RptParams params, List hideCol, String colName) {
        boolean isShowAll = params.getBoolean("ckShowAllCol");
        return isShowAll || !hideCol.contains(colName);
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }
}

