/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.app.AbstractInvCkMutiAccountDetailFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.InvCkAccountDetailFacadeControllerBean;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LowTimer;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class InvCkMutiAccountDetailFacadeControllerBean
extends AbstractInvCkMutiAccountDetailFacadeControllerBean {
    private Logger logger = Logger.getLogger(InvCkAccountDetailFacadeControllerBean.class);
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";
    private static final String newline = "\r\n";
    private final int IN = 0;
    private final int OUT = 1;
    private String loc;
    public String[][] invTableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}};

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.loc = this.getLoc(ctx);
        this.logger.info((Object)"===================\u5bf9\u8d26\u660e\u7ec6\u8868\u5f00\u59cb=====================");
        LowTimer timer = new LowTimer();
        String invTempTable = this.getInvBillData(ctx, params);
        this.logger.info((Object)("\u67e5\u8be2\u5355\u636e\u6570\u636e\u5171\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        String glTempTable = this.getGLBillData(ctx, params);
        this.logger.info((Object)("\u67e5\u8be2\u51ed\u8bc1\u6570\u636e\u5171\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        String reportDataTable = this.getReportData(ctx, invTempTable, glTempTable);
        this.logger.info((Object)("\u6c47\u603b\u5e93\u5b58\u4e0e\u603b\u8d26\u6570\u636e\u5171\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        this.updateDiffAmount(ctx, reportDataTable);
        this.logger.info((Object)("\u66f4\u65b0\u5e93\u5b58\u4e0e\u603b\u8d26\u5dee\u989d\u5171\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        this.updateReason(ctx, reportDataTable);
        this.logger.info((Object)("\u66f4\u65b0\u5bf9\u8d26\u4e0d\u5e73\u539f\u56e0\u5171\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        String countSql = "Select COUNT(1) Count, SUM(ISNULL(FBillAmount, 0)) FBillAmount from " + reportDataTable;
        boolean isShowException = params.getBoolean("isShowException");
        if (isShowException) {
            countSql = countSql + " Where FDiffAmount <> 0";
        }
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        int count = 0;
        BigDecimal billAmount = new BigDecimal("0.00");
        if (rs.next()) {
            count = rs.getInt("Count");
            billAmount = rs.getBigDecimal("FBillAmount");
        }
        this.logger.info((Object)("\u83b7\u53d6\u603b\u8bb0\u5f55\u6570\u548c\u5e93\u5b58\u5355\u636e\u603b\u91d1\u989d\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        BigDecimal voucherAmount = this.getVoucherTotalAmount(ctx, glTempTable);
        this.logger.info((Object)("\u83b7\u53d6\u51ed\u8bc1\u603b\u91d1\u989d\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        this.dropTempTable(invTempTable, ctx);
        this.dropTempTable(glTempTable, ctx);
        this.logger.info((Object)("\u91ca\u653e\u4e34\u65f6\u8868\u5171\u82b1\u8d39\uff1a" + timer.msValue()));
        RptParams result = new RptParams();
        result.setString("reportDataTable", reportDataTable);
        result.setInt("recordCount", count);
        result.setBigDecimal("totalBillAmount", billAmount);
        result.setBigDecimal("totalVoucherAmount", voucherAmount);
        if (billAmount == null || voucherAmount == null) {
            result.setBigDecimal("totalDiffAmount", null);
        } else {
            result.setBigDecimal("totalDiffAmount", billAmount.subtract(voucherAmount));
        }
        return result;
    }

    private BigDecimal getVoucherTotalAmount(Context ctx, String glTempTable) throws BOSException {
        BigDecimal voucherAmount = new BigDecimal("0.00");
        String sql = "Select SUM(ISNULL(FVoucherAmount, 0)) FVoucherAmount from " + glTempTable;
        RptRowSet rs = this.executeQuery(sql, null, ctx);
        if (rs.next()) {
            voucherAmount = rs.getBigDecimal("FVoucherAmount");
        }
        return voucherAmount;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String reportDataTable = params.getString("reportDataTable");
        boolean isShowException = params.getBoolean("isShowException");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select FBillTypeID,FBillTypeName,FBillID,FBillNumber,FBillVoucherID,FBillVoucherNumber,");
        sSQL.append(" FBillAmount,FVoucherID,FVoucherNumber,FVoucherAmount,FDiffAmount,FReason");
        sSQL.append(" From ").append(reportDataTable);
        if (isShowException) {
            sSQL.append(" Where FDiffAmount <> 0");
        }
        sSQL.append(" Order by ISNULL(FBillVoucherID, 'zzzz'),FBillTypeID,ISNULL(FBillNumber, 'zzzz'),FBillID");
        RptRowSet rs = this.executeQuery(sSQL.toString(), null, from, len, ctx);
        RptParams rptParam = new RptParams();
        rptParam.setObject("rowset", (Object)rs);
        return rptParam;
    }

    private String getReportData(Context ctx, String invTempTable, String glTempTable) throws BOSException {
        String reportDataTable = this.createTempTable(ctx, this.getCreateInvToGLTempTableSQL());
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Insert into ").append(reportDataTable).append("(");
        sSQL.append("FBillID,FBillTypeID,FBillTypeName,FBillNumber,FBillVoucherID,FBillVoucherNumber,");
        sSQL.append("FBillAmount,FVoucherID,FVoucherNumber,FVoucherAmount)").append(newline);
        sSQL.append("Select bill.FBillID,bill.FBillTypeID,bill.FBillTypeName,bill.FBillNumber,bill.FBillVoucherID,");
        sSQL.append("bill.FBillVoucherNumber,bill.FBillAmount,voucher.FVoucherID,voucher.FVoucherNumber,voucher.FVoucherAmount ");
        sSQL.append("From ").append(invTempTable).append(" bill ");
        sSQL.append("Full Outer Join ").append(glTempTable).append(" voucher on bill.FBillVoucherID = voucher.FVoucherID ");
        this.executeUpdate(sSQL.toString(), null, ctx);
        return reportDataTable;
    }

    private String getInvBillData(Context ctx, RptParams params) throws BOSException {
        int i;
        String tempTableName = this.createTempTable(ctx, this.getCreateInvTempTableSQL());
        Integer direction = (Integer)params.getObject("Direction");
        StringBuffer sSQL = new StringBuffer();
        LowTimer timer = new LowTimer();
        for (i = 0; i < this.invTableName.length; ++i) {
            timer.reset();
            sSQL.setLength(0);
            sSQL.append(this.getInsertInvDataSQL(tempTableName)).append(newline);
            sSQL.append(this.getSelectInvBillDataSQL(params, this.invTableName[i], direction, false));
            this.logger.debug((Object)("\u67e5\u8be2\u300a" + this.invTableName[i][0] + "\u300bSQL\uff1a" + sSQL.toString()));
            this.executeUpdate(sSQL.toString(), null, ctx);
            this.logger.info((Object)("\u67e5\u8be2\u300a" + this.invTableName[i][0] + "\u300b\u6570\u636e\u82b1\u8d39\uff1a" + timer.msValue()));
        }
        for (i = 0; i < this.invTableName.length; ++i) {
            timer.reset();
            sSQL.setLength(0);
            sSQL.append(this.getInsertInvDataSQL(tempTableName)).append(newline);
            sSQL.append(this.getSelectInvBillDataSQL(params, this.invTableName[i], direction, true));
            this.logger.debug((Object)("\u67e5\u8be2\u300a" + this.invTableName[i][0] + "\u300bSQL\uff1a" + sSQL.toString()));
            this.executeUpdate(sSQL.toString(), null, ctx);
            this.logger.info((Object)("\u67e5\u8be2\u300a" + this.invTableName[i][0] + "\u300b\u6570\u636e\u82b1\u8d39\uff1a" + timer.msValue()));
        }
        timer.reset();
        sSQL.setLength(0);
        sSQL.append(this.getInsertInvDataSQL(tempTableName)).append(newline);
        sSQL.append(this.getCostAdjustBillSQL(params, direction));
        this.logger.debug((Object)("\u67e5\u8be2\u300a\u6210\u672c\u8c03\u6574\u5355\u300bSQL\uff1a" + sSQL.toString()));
        this.executeUpdate(sSQL.toString(), null, ctx);
        this.logger.info((Object)("\u67e5\u8be2\u300a\u6210\u672c\u8c03\u6574\u5355\u300b\u6570\u636e\u82b1\u8d39\uff1a" + timer.msValue()));
        timer.reset();
        sSQL.setLength(0);
        sSQL.append(this.getInsertInvDataSQL(tempTableName)).append(newline);
        sSQL.append(this.getStandardCostAdjBillSQL(params, direction));
        this.logger.debug((Object)("\u67e5\u8be2\u300a\u6807\u51c6\u4ef7\u53d8\u66f4\u5355\u300bSQL\uff1a" + sSQL.toString()));
        this.executeUpdate(sSQL.toString(), null, ctx);
        this.logger.info((Object)("\u67e5\u8be2\u300a\u6807\u51c6\u4ef7\u53d8\u66f4\u5355\u300b\u6570\u636e\u82b1\u8d39\uff1a" + timer.msValue()));
        return tempTableName;
    }

    private String getCostAdjustBillSQL(RptParams params, int direction) {
        String actItemNumber = (String)params.getObject("ActItemNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select bill.FID,bill.FBillTypeID,billType.FName_" + this.loc + ",");
        sSQL.append("bill.FNumber,bill.FVoucherID,voucher.FNumber,");
        if ("1005".equals(actItemNumber)) {
            sSQL.append(" SUM(Case matCom.FAccountType when 2 then entry.FAmount else 0 end) as FBillAmount ");
        } else {
            sSQL.append(" SUM(Case matCom.FAccountType when 2 then 0 else entry.FAmount end) as FBillAmount ");
        }
        sSQL.append("From T_CL_CostAdjustBill bill ");
        sSQL.append("Inner Join T_CL_CostAdjustBillEntry entry on entry.FParentID = bill.FID ");
        sSQL.append("Inner Join T_SCM_BillType billType on bill.FBillTypeID = billType.FID ");
        sSQL.append("Inner Join T_IM_StoreType sType on entry.FStoreTypeID = sType.FID ");
        sSQL.append("Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ");
        if ("1005".equals(actItemNumber)) {
            sSQL.append("Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ");
            sSQL.append("Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ");
            sSQL.append("Inner Join T_BD_AccountView accView  ON kaClass.FAccountLinkID = accView.FID  ");
        } else if (1 == direction) {
            sSQL.append("Inner Join T_BD_AccountView accView  ON entry.FAccountViewOutId = accView.FID  ");
        } else {
            sSQL.append("Inner Join T_BD_AccountView accView  ON entry.FAccountViewInId = accView.FID  ");
        }
        sSQL.append("Left Join T_GL_Voucher voucher on voucher.FID = bill.FVoucherID ");
        sSQL.append(this.getCostAdjBillWhereSQL(params));
        sSQL.append("Group by bill.FID,bill.FBillTypeID,billType.FName_" + this.loc + ", bill.FNumber,bill.FVoucherID,voucher.FNumber");
        return sSQL.toString();
    }

    private String getCostAdjBillWhereSQL(RptParams params) {
        int direction = (Integer)params.getObject("Direction");
        String actItemNumber = (String)params.getObject("ActItemNumber");
        StringBuffer sSQL = new StringBuffer();
        if ("1005".equals(actItemNumber)) {
            sSQL.append(this.getCommonWhereSQL(params, true));
        } else {
            sSQL.append(this.getCommonWhereSQL(params, false));
        }
        sSQL.append(" And bill.FCalculateKind = ").append(direction);
        if ("1005".equals(actItemNumber)) {
            sSQL.append(" And kaItem.FNumber = '").append(actItemNumber).append("'");
        } else {
            sSQL.append(" And matCom.FAccountType <> 2 ");
        }
        return sSQL.toString();
    }

    private String getStandardCostAdjBillSQL(RptParams params, int inOrOut) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select bill.FID,bill.FBillTypeID,billType.FName_" + this.loc + ",bill.FNumber,bill.FVoucherID,voucher.FNumber,");
        sSQL.append("SUM(-1*FDiffAmount)  as FBillAmount ");
        sSQL.append("From T_CL_StandardCostAdjBill bill ");
        sSQL.append("Inner Join T_CL_StandardCostAdjEntry entry on entry.FParentID = bill.FID ");
        sSQL.append("Inner Join T_SCM_BillType billType on bill.FBillTypeID = billType.FID ");
        sSQL.append("Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID ");
        sSQL.append("Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ");
        sSQL.append("Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ");
        if (inOrOut == 0) {
            sSQL.append(" and kaItem.Fnumber = '1005' ");
        } else if (inOrOut == 1) {
            sSQL.append(" and kaItem.Fnumber = '1001' ");
        }
        sSQL.append("");
        sSQL.append("Inner Join T_BD_AccountView accView  ON kaClass.FAccountLinkID = accView.FID  ");
        sSQL.append("Left Join T_GL_Voucher voucher on voucher.FID = bill.FVoucherID ");
        sSQL.append(this.getStdCostAdjBillWhereSQL(params));
        sSQL.append("Group by bill.FID,bill.FBillTypeID,billType.FName_" + this.loc + ",bill.FNumber,bill.FVoucherID,voucher.FNumber");
        return sSQL.toString();
    }

    private String getStdCostAdjBillWhereSQL(RptParams params) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        Integer spnYear = (Integer)params.getObject("Year");
        Integer spnPeriod = (Integer)params.getObject("Period");
        String actNumber = (String)params.getObject("ActNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Where bill.FCompanyOrgUnitID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And matCom.FCompanyID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And bill.FYear = ").append(spnYear);
        sSQL.append(" And bill.FPeriod = ").append(spnPeriod);
        sSQL.append(" And bill.FBaseStatus = ").append(4);
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        sSQL.append(" And (kaItem.FNumber = '1001' or kaItem.FNumber = '1005')");
        return sSQL.toString();
    }

    private String getGLBillData(Context ctx, RptParams params) throws BOSException {
        String tempTableName = this.createTempTable(ctx, this.getCreateGLTempTableSQL());
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(this.getInsertGLDataSQL(tempTableName)).append(newline);
        sSQL.append(this.getSelectGLDataSQL(params));
        this.logger.debug((Object)("\u67e5\u8be2\u300a\u603b\u8d26\u6570\u636e\u300bSQL\uff1a" + sSQL.toString()));
        this.executeUpdate(sSQL.toString(), null, ctx);
        return tempTableName;
    }

    private String getInsertInvDataSQL(String tableName) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Insert into ").append(tableName).append("(");
        sSQL.append("FBillID,FBillTypeID,FBillTypeName,FBillNumber,FBillVoucherID,FBillVoucherNumber,FBillAmount");
        sSQL.append(")");
        return sSQL.toString();
    }

    private void updateDiffAmount(Context ctx, String tableName) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Update ").append(tableName).append(" as T Set (FDiffAmount) = (");
        sSQL.append("  Select temp.FTotalBillAmount - ISNULL(T.FVoucherAmount, 0) from (");
        sSQL.append("    Select a.FBillTypeID,a.FBillVoucherID,SUM(ISNULL(FBillAmount, 0)) as FTotalBillAmount");
        sSQL.append("    from ").append(tableName).append(" a ");
        sSQL.append("    group by a.FBillTypeID,a.FBillVoucherID ");
        sSQL.append("  ) temp where ISNULL(temp.FBillTypeID, 'XXXX') = ISNULL(T.FBillTypeID, 'XXXX') ");
        sSQL.append("  AND ISNULL(temp.FBillVoucherID, 'XXXX') = ISNULL(T.FBillVoucherID, 'XXXX')");
        sSQL.append(")");
        this.logger.debug((Object)("\u66f4\u65b0\u4f59\u989dSQL\uff1a" + sSQL.toString()));
        this.executeUpdate(sSQL.toString(), null, ctx);
    }

    private void updateReason(Context ctx, String tableName) throws BOSException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Update ").append(tableName).append(" as T Set FReason = '").append(ResourceBase.getString((String)RESOURCE, (String)"250_NoVoucher", (Locale)ctx.getLocale())).append("' ");
        sSQL.append(" Where FBillVoucherID IS NULL And FVoucherID IS NULL");
        this.executeUpdate(sSQL.toString(), null, ctx);
        sSQL.setLength(0);
        sSQL.append("Update ").append(tableName).append(" as T Set FReason = '").append(ResourceBase.getString((String)RESOURCE, (String)"251_NotSubmitOrSubjectErOfVoucher", (Locale)ctx.getLocale())).append("' ");
        sSQL.append(" Where FBillVoucherID IS NOT NULL And FVoucherID IS NULL");
        this.executeUpdate(sSQL.toString(), null, ctx);
        sSQL.setLength(0);
        sSQL.append("Update ").append(tableName).append(" as T Set FReason = '").append(ResourceBase.getString((String)RESOURCE, (String)"252_ExistsManVoucher", (Locale)ctx.getLocale())).append("' ");
        sSQL.append(" Where FBillID IS NULL And FVoucherID IS NOT NULL");
        this.executeUpdate(sSQL.toString(), null, ctx);
        sSQL.setLength(0);
        sSQL.append("Update ").append(tableName).append(" as T Set FReason = '").append(ResourceBase.getString((String)RESOURCE, (String)"281_AmountErOf", (Locale)ctx.getLocale())).append("' ");
        sSQL.append(" Where FBillVoucherID IS NOT NULL And FVoucherID IS NOT NULL And FDiffAmount <> 0");
        this.executeUpdate(sSQL.toString(), null, ctx);
    }

    private String getSelectInvBillDataSQL(RptParams params, String[] tableName, int direction, boolean isDifAccount) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select bill.FID,bill.FBillTypeID,billType.FName_" + this.loc + ",bill.FNumber,bill.FVoucherID,voucher.FNumber,\r\n");
        if (isDifAccount) {
            sSQL.append("SUM(Case matCom.FAccountType when 2 then entry.FActualCost - entry.FStandardCost else 0 end) as FBillAmount ");
        } else {
            sSQL.append("SUM(Case matCom.FAccountType when 2 then entry.FStandardCost else entry.FActualCost end)  as FBillAmount \r\n");
        }
        sSQL.append("From ").append(tableName[0]).append(" bill ");
        sSQL.append("Inner Join ").append(tableName[1]).append(" entry on entry.FParentID = bill.FID ");
        sSQL.append("Inner Join T_SCM_BillType billType on bill.FBillTypeID = billType.FID ");
        sSQL.append("Inner Join T_SCM_TransactionType transType on bill.FTransactionTypeID = transType.FID ");
        sSQL.append("Inner Join T_IM_InvUpdateType invType on entry.FInvUpdateTypeID = invType.FID ");
        if (0 == direction) {
            sSQL.append("Inner Join T_IM_StoreType sType on invType.FStoreTypeID = sType.FID ");
        } else {
            sSQL.append("Inner Join T_IM_StoreType sType on invType.FStoreTypePreID = sType.FID ");
        }
        sSQL.append("Inner Join T_BD_MaterialCompanyInfo matCom ON entry.FMaterialID = matCom.FMaterialID AND entry.FCompanyOrgUnitID = matCom.FCompanyID ");
        if (isDifAccount) {
            sSQL.append("Inner Join T_BD_KAClassificationDetail kaClass ON matCom.FKAClassID = kaClass.FKAClassFicLink ");
            sSQL.append("Inner Join T_BD_KAccountItem kaItem ON kaClass.FAccountitemlinkID = kaItem.FID ");
            sSQL.append("Inner Join T_BD_AccountView accView  ON kaClass.FAccountLinkID = accView.FID  ");
        } else if (1 == direction) {
            sSQL.append("Inner Join T_BD_AccountView accView  ON entry.FAccountViewOutId = accView.FID  ");
        } else {
            sSQL.append("Inner Join T_BD_AccountView accView  ON entry.FAccountViewInId = accView.FID  ");
        }
        sSQL.append("Left Join T_GL_Voucher voucher on voucher.FID = bill.FVoucherID ");
        sSQL.append(this.getInvWhereSQL(params, tableName[0], isDifAccount));
        if (isDifAccount) {
            sSQL.append(" and kaItem.fnumber = '1005' ");
        }
        sSQL.append("Group by bill.FID,bill.FBillTypeID,billType.FName_" + this.loc + ",bill.FNumber,bill.FVoucherID,voucher.FNumber");
        return sSQL.toString();
    }

    private String getInvWhereSQL(RptParams params, String billTableName, boolean isDifAccount) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(this.getCommonWhereSQL(params, isDifAccount));
        sSQL.append(" And ISNULL(bill.FIsInitBill, 0) = 0");
        sSQL.append(" And transType.FIsManuCheckAccount =1 ");
        sSQL.append(this.getIsCalculateWhereSQL(params));
        if (this.invTableName[2][0].equals(billTableName) || this.invTableName[6][0].equals(billTableName)) {
            sSQL.append(this.getCostMoveWhereSQL(params));
        }
        return sSQL.toString();
    }

    private String getIsCalculateWhereSQL(RptParams params) {
        Boolean ckShowNoCalculate = (Boolean)params.getObject("ckShowNoCalculate");
        StringBuffer sSQL = new StringBuffer();
        if (ckShowNoCalculate != null && !ckShowNoCalculate.booleanValue()) {
            sSQL.append(" And transType.FIsCalculate = 1 ");
        }
        return sSQL.toString();
    }

    private String getCostMoveWhereSQL(RptParams params) {
        Boolean noSelectMovebill = (Boolean)params.getObject("noSelectMovebill");
        StringBuffer sSQL = new StringBuffer();
        if (noSelectMovebill != null && noSelectMovebill.booleanValue()) {
            sSQL.append(" And (bill.FBizTypeID <> '").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            sSQL.append(" And bill.FBizTypeID <> '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("')");
        }
        return sSQL.toString();
    }

    private String getCommissionWhereSQL(RptParams params) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" And (Bill.FBizTypeId <> '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("'");
        sSQL.append(" And ISNUll(transType.FStoreTypeId,'99999') <> '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'");
        sSQL.append(" And transType.FRITypeID <> '").append(RecIssueTypeConstant.CONSIGNOUT_RITYPEID).append("' )");
        return sSQL.toString();
    }

    private String getCommonWhereSQL(RptParams params, boolean isDifAccount) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        Integer spnYear = (Integer)params.getObject("Year");
        Integer spnPeriod = (Integer)params.getObject("Period");
        String actNumber = (String)params.getObject("ActNumber");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Where entry.FCompanyOrgUnitID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And bill.FYear = ").append(spnYear);
        sSQL.append(" And bill.FPeriod = ").append(spnPeriod);
        sSQL.append(" And bill.FBaseStatus = ").append(4);
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        sSQL.append(" And sType.FIsForwardAmt = 1");
        return sSQL.toString();
    }

    private String getInsertGLDataSQL(String tableName) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Insert into ").append(tableName).append("(");
        sSQL.append("FVoucherID,FVoucherNumber,FVoucherAmount");
        sSQL.append(")");
        return sSQL.toString();
    }

    private String getSelectGLDataSQL(RptParams params) {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select bill.FID, bill.FNumber, entry.FLocalAmount ");
        sSQL.append("From T_GL_Voucher bill ");
        sSQL.append("Inner Join T_GL_VoucherEntry entry on bill.FID = entry.FBillID ");
        sSQL.append("Inner Join T_BD_AccountView accView on entry.FAccountID = accView.FID ");
        sSQL.append("Inner Join T_BD_Period prd on bill.FPeriodID = prd.FID ");
        sSQL.append(this.getGLWhereSQL(params));
        return sSQL.toString();
    }

    private String getGLWhereSQL(RptParams params) {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("bizCompnayOrg");
        Integer spnYear = (Integer)params.getObject("Year");
        Integer spnPeriod = (Integer)params.getObject("Period");
        String actNumber = (String)params.getObject("ActNumber");
        Integer direction = (Integer)params.getObject("Direction");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Where bill.FCompanyID = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sSQL.append(" And prd.FPeriodYear = ").append(spnYear);
        sSQL.append(" And prd.FPeriodNumber = ").append(spnPeriod);
        sSQL.append(" And accView.FNumber = '").append(actNumber).append("'");
        if (0 == direction) {
            sSQL.append(" And entry.FEntryDC = 1");
        } else {
            sSQL.append(" And entry.FEntryDC = 0");
        }
        sSQL.append(" And (bill.FBizStatus = ").append(1);
        sSQL.append(" or bill.FBizStatus = ").append(3);
        sSQL.append(" or bill.FBizStatus = ").append(5).append(")");
        return sSQL.toString();
    }

    private String getCreateInvTempTableSQL() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Create Table InvTempReportTable (");
        sSQL.append("FBillID Varchar(44) NOT NULL,");
        sSQL.append("FBillTypeID nvarchar(44),");
        sSQL.append("FBillTypeName nvarchar(255),");
        sSQL.append("FBillNumber nvarchar(255),");
        sSQL.append("FBillVoucherID Varchar(44),");
        sSQL.append("FBillVoucherNumber nvarchar(255),");
        sSQL.append("FBillAmount Numeric(17, 4)");
        sSQL.append(")");
        return sSQL.toString();
    }

    private String getCreateGLTempTableSQL() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Create Table VoucherTempReportTable (");
        sSQL.append("FVoucherID Varchar(44) NOT NULL,");
        sSQL.append("FVoucherNumber nvarchar(255),");
        sSQL.append("FVoucherAmount Numeric(17, 4)");
        sSQL.append(")");
        return sSQL.toString();
    }

    private String getCreateInvToGLTempTableSQL() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Create Table InvTempReportTable (");
        sSQL.append("FBillID Varchar(44),");
        sSQL.append("FBillTypeID Varchar(44),");
        sSQL.append("FBillTypeName nvarchar(255),");
        sSQL.append("FBillNumber nvarchar(255),");
        sSQL.append("FBillVoucherID Varchar(44),");
        sSQL.append("FBillVoucherNumber nvarchar(255),");
        sSQL.append("FBillAmount Numeric(17, 4),");
        sSQL.append("FVoucherID Varchar(44),");
        sSQL.append("FVoucherNumber nvarchar(255),");
        sSQL.append("FVoucherAmount Numeric(17, 4),");
        sSQL.append("FDiffAmount Numeric(17, 4),");
        sSQL.append("FReason NVarchar(255)");
        sSQL.append(")");
        return sSQL.toString();
    }
}

