/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.ITransactionType;
import com.kingdee.eas.basedata.scm.common.TransactionTypeCollection;
import com.kingdee.eas.basedata.scm.common.TransactionTypeFactory;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.im.inv.IInvUpdateType;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.InvUpdateTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeCollection;
import com.kingdee.eas.basedata.scm.im.inv.TransactionInvUpdateTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.LotAccountContrastEnum;
import com.kingdee.eas.scm.cal.LotAccountContrastFactory;
import com.kingdee.eas.scm.cal.LotAccountContrastInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;

public class LotAccountContrastImport
extends AbstractDataTransmission {
    private static final String resources = "com.kingdee.eas.scm.cal.LotAccountContrastResource";
    private LotAccountContrastInfo lotAccountContrastInfo = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LotAccountContrastFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.lotAccountContrastInfo = new LotAccountContrastInfo();
        this.doNumber(hsData, ctx);
        this.doCompanyOrgUnit(hsData, ctx);
        this.doBillType(hsData, ctx);
        this.doBizTypeInfo(hsData, ctx);
        this.doTransactionType(hsData, ctx);
        this.doUpdateType(hsData, ctx);
        Object obj = ((DataToken)hsData.get((Object)"FUpdateType_number")).data;
        String updateTypeNumber = obj.toString().trim();
        StoreTypeInfo wareStoreType = null;
        StoreTypeInfo issueStoreType = null;
        try {
            IInvUpdateType is = InvUpdateTypeFactory.getLocalInstance((Context)ctx);
            InvUpdateTypeCollection coll = is.getInvUpdateTypeCollection(this.getFilter(updateTypeNumber));
            InvUpdateTypeInfo updateType = coll.get(0);
            wareStoreType = updateType.getStoreType();
            issueStoreType = updateType.getStoreTypePre();
            if (wareStoreType != null) {
                this.lotAccountContrastInfo.setWareStoreType(wareStoreType);
            }
            if (issueStoreType != null) {
                this.lotAccountContrastInfo.setIssueStoreType(issueStoreType);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.doWareAccount(hsData, ctx, wareStoreType);
        this.doIsssueAccount(hsData, ctx, issueStoreType);
        obj = ((DataToken)hsData.get((Object)"FIsPriority")).data;
        if (obj == null || obj.toString().trim().equals("")) {
            this.lotAccountContrastInfo.setIsPriority(LotAccountContrastEnum.yes);
        } else {
            int isPriority = 1;
            try {
                isPriority = Integer.parseInt(obj.toString().trim());
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Numeric_Transform_Error", resources));
            }
            if (isPriority == 0) {
                this.lotAccountContrastInfo.setIsPriority(LotAccountContrastEnum.no);
            } else {
                this.lotAccountContrastInfo.setIsPriority(LotAccountContrastEnum.yes);
            }
        }
        this.lotAccountContrastInfo.setStatus(UseStatusEnum.SAVED);
        return this.lotAccountContrastInfo;
    }

    private void doNumber(Hashtable lineData, Context ctx) throws TaskExternalException {
        Object obj = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (obj == null || "".equals(obj.toString())) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "NUM_NOT_NULL", resources));
        }
        this.lotAccountContrastInfo.setNumber(obj.toString());
    }

    private void doBizTypeInfo(Hashtable lineData, Context ctx) throws TaskExternalException {
        try {
            this.loadBizType(lineData, ctx, "number", "FBizType_number");
        }
        catch (Exception e_number) {
            try {
                this.loadBizType(lineData, ctx, "name", "FBizType_name_l2");
            }
            catch (Exception e_name) {
                throw new TaskExternalException(e_number.getMessage(), e_number.getCause());
            }
        }
    }

    private void loadBizType(Hashtable lineData, Context ctx, String byProperty, String propertyName) throws TaskExternalException, BOSException {
        BizTypeCollection collection;
        Object obj = ((DataToken)lineData.get((Object)propertyName)).data;
        if (obj != null && obj.toString().trim().length() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)obj.toString(), CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            collection = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeCollection(viewInfo);
            if (collection == null || collection.size() == 0) {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "BIZTYPE_NOT_EXIST", resources));
            }
        } else {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "BIZTYPE_NOT_NULL", resources));
        }
        this.lotAccountContrastInfo.setBizType(collection.get(0));
    }

    private void doCompanyOrgUnit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = ((DataToken)hsData.get((Object)"FCompanyOrgUnit_number")).data;
        if (obj == null || obj.toString().trim().equals("")) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_Company_Cannt_Null", resources));
        }
        String companyOrgUnitNumber = obj.toString().trim();
        IObjectPK userPK = ctx.getCaller();
        FullOrgUnitCollection coll = null;
        try {
            coll = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg(userPK, OrgType.Company, null, "accountContrast_import");
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        boolean flag = false;
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                FullOrgUnitInfo company = coll.get(i);
                if (!obj.toString().trim().equals(company.getNumber())) continue;
                flag = true;
                break;
            }
        }
        if (!flag) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_no_permission", resources));
        }
        try {
            CompanyOrgUnitInfo info;
            ICompanyOrgUnit is = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection collection = is.getCompanyOrgUnitCollection(this.getFilter(companyOrgUnitNumber));
            if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                this.lotAccountContrastInfo.setCompanyOrgUnit(info);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doBillType(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = ((DataToken)hsData.get((Object)"FBillType_number")).data;
        if (obj == null || obj.toString().trim().equals("")) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_BillType_Cannt_Null", resources));
        }
        String billTypeNumber = obj.toString().trim();
        try {
            IBillType is = BillTypeFactory.getLocalInstance((Context)ctx);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)billTypeNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billTypeGroup", (Object)12, CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            BillTypeCollection coll = is.getBillTypeCollection(viewInfo);
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_BillType_Invalid", resources));
            }
            BillTypeInfo billType = coll.get(0);
            this.lotAccountContrastInfo.setBillType(billType);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doTransactionType(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = ((DataToken)hsData.get((Object)"FTransactionType_number")).data;
        if (obj == null || obj.toString().trim().equals("")) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_TransactionType_Cannt_Null", resources));
        }
        String transactionTypeNumber = obj.toString().trim();
        String billTypeNumber = ((DataToken)hsData.get((Object)"FBillType_number")).data.toString();
        try {
            ITransactionType is = TransactionTypeFactory.getLocalInstance((Context)ctx);
            BillTypeCollection billTypeCollection = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeCollection(this.getFilter(billTypeNumber));
            BillTypeInfo billType = billTypeCollection.get(0);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)transactionTypeNumber, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billType.getId(), CompareType.EQUALS));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            TransactionTypeCollection coll = is.getTransactionTypeCollection(viewInfo);
            if (coll == null || coll.size() == 0) {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_TransactionType_Invalid", resources));
            }
            TransactionTypeInfo info = coll.get(0);
            this.lotAccountContrastInfo.setTransactionType(info);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doUpdateType(Hashtable hsData, Context ctx) throws TaskExternalException {
        Object obj = ((DataToken)hsData.get((Object)"FUpdateType_number")).data;
        if (obj == null || obj.toString().trim().equals("")) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_UpdateType_Cannt_Null", resources));
        }
        String updateTypeNumber = obj.toString().trim();
        String transactionTypeNumber = ((DataToken)hsData.get((Object)"FTransactionType_number")).data.toString();
        try {
            InvUpdateTypeCollection coll;
            TransactionTypeCollection transactionTypeCollection = TransactionTypeFactory.getLocalInstance((Context)ctx).getTransactionTypeCollection(this.getFilter(transactionTypeNumber));
            TransactionTypeInfo transactionTypeInfo = transactionTypeCollection.get(0);
            TransactionInvUpdateTypeCollection transactionInvUpdateTypeCollection = transactionTypeInfo.getTransactionInvUpdateType();
            HashSet<String> entryIdSet = new HashSet<String>();
            if (transactionInvUpdateTypeCollection != null && transactionInvUpdateTypeCollection.size() > 0) {
                for (int i = 0; i < transactionInvUpdateTypeCollection.size(); ++i) {
                    TransactionInvUpdateTypeInfo transactionInvUpdateType = transactionInvUpdateTypeCollection.get(i);
                    InvUpdateTypeInfo updateType = transactionInvUpdateType.getInvUpdateType();
                    entryIdSet.add(updateType.getId().toString());
                }
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", entryIdSet, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)1));
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)updateTypeNumber, CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                IInvUpdateType is = InvUpdateTypeFactory.getLocalInstance((Context)ctx);
                coll = is.getInvUpdateTypeCollection(viewInfo);
                if (coll == null || coll.size() == 0) {
                    throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_UpdateType_Invalid", resources));
                }
            } else {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_UpdateType_Invalid", resources));
            }
            InvUpdateTypeInfo info = coll.get(0);
            this.lotAccountContrastInfo.setUpdateType(info);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void doIsssueAccount(Hashtable hsData, Context ctx, StoreTypeInfo issueStoreType) throws TaskExternalException {
        Object obj = ((DataToken)hsData.get((Object)"FIssueAccountView_number")).data;
        if (issueStoreType == null) {
            if (obj != null && !obj.toString().trim().equals("")) {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_IssueAccount_MustNUll", resources));
            }
        } else if (obj == null || obj.toString().trim().equals("")) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_IssueAccount_Cannt_Null", resources));
        }
        if (obj != null && !obj.toString().trim().equals("")) {
            String issueAccountNumber = obj.toString().trim();
            String companyOrgUnitNumber = ((DataToken)hsData.get((Object)"FCompanyOrgUnit_number")).data.toString();
            try {
                IAccountView is = AccountViewFactory.getLocalInstance((Context)ctx);
                AccountViewCollection coll = is.getAccountViewCollection(this.getAccountViewFilter(ctx, issueAccountNumber, companyOrgUnitNumber));
                if (coll == null || coll.size() == 0) {
                    throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_IssueAccount_Invalid", resources));
                }
                AccountViewInfo info = coll.get(0);
                this.lotAccountContrastInfo.setIssueAccountView(info);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }

    private void doWareAccount(Hashtable hsData, Context ctx, StoreTypeInfo wareStoreType) throws TaskExternalException {
        Object obj = ((DataToken)hsData.get((Object)"FWareAccountView_number")).data;
        if (wareStoreType == null) {
            if (obj != null && !obj.toString().trim().equals("")) {
                throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_WareAccount_MustNUll", resources));
            }
        } else if (obj == null || obj.toString().trim().equals("")) {
            throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_WareAccount_Cannt_Null", resources));
        }
        if (obj != null && !obj.toString().trim().equals("")) {
            String wareAccountNumber = obj.toString().trim();
            String companyOrgUnitNumber = ((DataToken)hsData.get((Object)"FCompanyOrgUnit_number")).data.toString();
            try {
                IAccountView is = AccountViewFactory.getLocalInstance((Context)ctx);
                AccountViewCollection coll = is.getAccountViewCollection(this.getAccountViewFilter(ctx, wareAccountNumber, companyOrgUnitNumber));
                if (coll == null || coll.size() == 0) {
                    throw new TaskExternalException(LotAccountContrastImport.getResource(ctx, "Import_WareAccount_Invalid", resources));
                }
                AccountViewInfo info = coll.get(0);
                this.lotAccountContrastInfo.setWareAccountView(info);
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
    }

    private EntityViewInfo getFilter(String number) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getAccountViewFilter(Context ctx, String accountViewNumber, String companyOrgUnitNumber) throws TaskExternalException {
        EntityViewInfo view = new EntityViewInfo();
        try {
            ICompanyOrgUnit is = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection collection = is.getCompanyOrgUnitCollection(this.getFilter(companyOrgUnitNumber));
            CompanyOrgUnitInfo companyOrgUnitInfo = collection.get(0);
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)companyOrgUnitInfo.getAccountTable().getId()));
            filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyOrgUnitInfo.getId()));
            filter.getFilterItems().add(new FilterItemInfo("isCFreeze", (Object)false));
            filter.getFilterItems().add(new FilterItemInfo("isGFreeze", (Object)false));
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountViewNumber));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return view;
    }

    private static String getResource(Context ctx, String strKey, String resource) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        try {
            LotAccountContrastInfo lotAccountContrastInfo = (LotAccountContrastInfo)coreBaseInfo;
            this.getController(ctx).addnew((CoreBaseInfo)lotAccountContrastInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompanyOrgUnit_name_l2", rs.getString("companyOrgUnit.name"));
            this.putTable(result, "FCompanyOrgUnit_number", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "FBillType_name_l2", rs.getString("billType.name"));
            this.putTable(result, "FBillType_number", rs.getString("billType.number"));
            this.putTable(result, "FBizType_number", rs.getString("bizType.number"));
            this.putTable(result, "FBizType_name_l2", rs.getString("bizType.name"));
            this.putTable(result, "FTransactionType_name_l2", rs.getString("transactionType.name"));
            this.putTable(result, "FTransactionType_number", rs.getString("transactionType.number"));
            this.putTable(result, "FUpdateType_name_l2", rs.getString("updateType.name"));
            this.putTable(result, "FUpdateType_number", rs.getString("updateType.number"));
            this.putTable(result, "FWareAccountView_number", rs.getString("wareAccountView.number"));
            this.putTable(result, "FIssueAccountView_number", rs.getString("issueAccountView.number"));
            this.putTable(result, "FIsPriority", rs.getString("isPriority"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo oldFilterInfo;
        FilterInfo filterInfo = null;
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Company, (String)"accountContrast_export");
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", keys, CompareType.INCLUDE));
        }
        if ((oldFilterInfo = (FilterInfo)this.getContextParameter("filter")) == null) {
            oldFilterInfo = new FilterInfo();
        }
        try {
            if (filterInfo != null) {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return oldFilterInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.cal.app.LotAccountContrastQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }
}

