/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.CostAdjustBillCollection;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.DevolveWriteOffFacadeFactory;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.ManualWriteOffException;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.app.AbstractManualWriteOffFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.help.ManualWriteOffHelp;
import com.kingdee.eas.scm.cal.info.WriteOffBillInfo;
import com.kingdee.eas.scm.cal.info.WriteOffCostAdjustInfo;
import com.kingdee.eas.scm.cal.info.WriteOffPurInWarehsInfo;
import com.kingdee.eas.scm.cal.info.WriteOffPurInvoiceInfo;
import com.kingdee.eas.scm.cal.info.WriteOffResultInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.AutoSplitBillServerUtils;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.constant.RecIssueTypeConstant;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ManualWriteOffFacadeControllerBean
extends AbstractManualWriteOffFacadeControllerBean {
    private static final long serialVersionUID = -8690357475963166949L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.ManualWriteOffFacadeControllerBean");
    private static final String RES = "com.kingdee.eas.scm.cal.ManualWriteOffResource";
    private static final String DEVOLVE_BIZ_TYPE_NUMBER = "('130','131','132','140','141')";
    private static final String DEVOLVE_BIZ_CATEGORT = "('13','14')";
    private String language = "L2";
    private RptParams result = null;
    private String[] topTableName = new String[]{"T_AP_OtherBill", "T_AP_OtherBillEntry"};
    private String[] bottomTableName = new String[]{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"};
    private int row = 0;
    private boolean isDevolve;
    private boolean isSaleWriteOff;

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return null;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.language = this.getLoc(ctx);
        Object object = params.getObject("index");
        String extend = null;
        this.isDevolve = params.getBoolean("isDevolve");
        this.isSaleWriteOff = params.getBoolean("isSaleWriteOff");
        if (null != object && "tblPurInvoice".equals(object)) {
            extend = params.getString("purInvoiceFilter");
            this.createPurInvoiceTable(ctx, params, extend);
        } else if (null != object && "tblPurInWareshs".equals(object)) {
            extend = params.getString("purInWarehsFilter");
            this.createPurInWarehsTable(ctx, params, extend);
        }
        return this.result;
    }

    protected RptParams _query(Context ctx, RptParams params, int start, int length) throws BOSException, EASBizException {
        String index = params.getString("index");
        RptParams para = new RptParams();
        if ("tblPurInvoice".equals(index)) {
            SorterItemCollection orderColl = (SorterItemCollection)params.getObject("upOrder");
            String sql1 = "select * from " + params.getString("tempTable1");
            sql1 = orderColl != null ? sql1 + " order by " + orderColl.toString() + ",number" : sql1 + " order by bizDate,number,seq";
            RptRowSet rs1 = this.executeQuery(sql1, null, start, length, ctx);
            para.setObject("rowset1", (Object)rs1);
        } else if ("tblPurInWareshs".equals(index)) {
            SorterItemCollection orderColl = (SorterItemCollection)params.getObject("downOrder");
            String sql2 = "select * from " + params.getString("tempTable2");
            sql2 = orderColl != null ? sql2 + " order by " + orderColl.toString() + ",number" : sql2 + " order by bizDate,number,seq";
            RptRowSet rs2 = this.executeQuery(sql2, null, start, length, ctx);
            para.setObject("rowset2", (Object)rs2);
        }
        return para;
    }

    private String getPurInvoiceSQL(String tempTable, String extend, SqlParams sqlParams) {
        StringBuffer bf1 = new StringBuffer();
        bf1.append("select ");
        bf1.append(" OTHERBILL.FNumber as number,");
        bf1.append(" OTHERBILL.FBizDate as bizDate,");
        bf1.append(" COMPANY.FName_" + this.language + " as companyOrgUnitName,");
        bf1.append(" ASSTACTTYPE.FName_" + this.language + " as asstActType,");
        bf1.append(" OTHERBILL.FAsstActName_" + this.language + " as asstActName,");
        bf1.append(" MATERIAL.FNumber as materialNumber,");
        bf1.append(" MATERIAL.FName_" + this.language + " as materialName,");
        bf1.append(" MATERIAL.FSHORTNAME as shortName,");
        bf1.append(" ENTRY.FQuantity as qty,");
        bf1.append(" UNIT.FName_" + this.language + " as baseUnit,");
        bf1.append(" ENTRY.FBaseQty as baseQty,");
        bf1.append(" ENTRY.FRecievePayAmountLocal as recievePayAmountLocal,");
        bf1.append(" ENTRY.FAmountLocal as amountLocal,");
        bf1.append(" ENTRY.FUnWriteOffBaseQty as unWriteOffBaseQty,");
        bf1.append(" ENTRY.FLocalUnWriteOffAmount as unWriteOffAmountLocal,");
        bf1.append(" ENTRY.FUnWriteOffBaseQty as curWriteOffBaseQty,");
        bf1.append(" ENTRY.FLocalUnWriteOffAmount as curWriteOffAmountLocal,");
        bf1.append(" COREBILLTYPE.FName_" + this.language + " as coreBillType,");
        bf1.append(" ENTRY.FCoreBillNumber as coreBillNumber,");
        bf1.append(" ENTRY.FCoreBillEntrySeq as coreBillEntrySeq,");
        bf1.append(" OTHERBILL.FID AS billId,");
        bf1.append(" ENTRY.FID as entryId,");
        bf1.append(" ENTRY.FCoreBillEntryId as coreBillEntryId,");
        bf1.append(" ENTRY.FMaterialId as materialId,");
        bf1.append(" OTHERBILL.FCompanyID as companyOrgUnitId,");
        bf1.append(" OTHERBILL.FAsstActID as supplierId,");
        bf1.append(" BASECURRENCY.FPrecision as fprecision,");
        bf1.append(" MULTIUNIT.FQtyPrecision as qtyPrecision,");
        bf1.append(" MULTIBASEUNIT.FQtyPrecision as baseQtyPrecision,");
        bf1.append(" MATERIAL.FPricePrecision as pricePrecision,");
        bf1.append(" OTHERBILL.FYear as fyear,");
        bf1.append(" OTHERBILL.FPeriod as fperiod,");
        bf1.append(" ENTRY.FSeq as seq,");
        bf1.append(" ENTRY.FBaseUnitID as baseUnitID,");
        bf1.append(" ENTRY.FWrittenOffBaseQty as writtenOffBaseQty,");
        bf1.append(" ENTRY.FLocalWrittenOffAmount as writtenOffAmount,");
        bf1.append(" OTHERBILL.FBizTypeID as transactionTypeID,");
        bf1.append(" Entry.FTaxAmountLocal as localTax,");
        bf1.append(" Entry.FTaxAmount as tax,");
        bf1.append(" Entry.FRecievePayAmount as recievePayAmount,");
        bf1.append(" OTHERBILL.FExchangeRate as exchangeRate,");
        bf1.append(" OTHERBILL.FCurrencyID as currencyID,");
        bf1.append(" BizType.FNumber as bizTypeNumber,");
        bf1.append(" OTHERBILL.FPaymentTypeID as paymentTypeID");
        bf1.append(" into ");
        bf1.append(tempTable);
        bf1.append(" FROM T_AP_OtherBill AS OTHERBILL");
        bf1.append(" INNER JOIN T_AP_OtherBillentry AS ENTRY ON OTHERBILL.FID = ENTRY.FParentID");
        bf1.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON OTHERBILL.FAdminOrgUnitID = ADMINORGUNIT.FID");
        bf1.append(" INNER JOIN T_BD_Currency AS CURRENCY ON CURRENCY.FID = OTHERBILL.FCurrencyID");
        bf1.append(" INNER JOIN T_BD_AsstActType AS ASSTACTTYPE ON ASSTACTTYPE.FID = OTHERBILL.FAsstActTypeID");
        bf1.append(" LEFT OUTER JOIN T_ORG_Purchase AS PURORG ON PURORG.FID = OTHERBILL.FPurOrgID");
        bf1.append(" INNER JOIN T_ORG_Company AS COMPANY ON COMPANY.FID = OTHERBILL.FCompanyID");
        bf1.append(" LEFT OUTER JOIN T_BD_Person AS PERSON ON OTHERBILL.FPersonId = PERSON.FID");
        bf1.append(" LEFT OUTER JOIN T_PM_User AS Creator ON OTHERBILL.FCreatorID = Creator.FID");
        bf1.append(" INNER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
        bf1.append(" LEFT OUTER JOIN T_SCM_ExpenseItem AS EXPENSEITEM ON ENTRY.FExpenseItemID = EXPENSEITEM.FID");
        bf1.append(" LEFT OUTER JOIN T_SCM_BillType AS COREBILLTYPE ON ENTRY.FCoreBillTypeID = COREBILLTYPE.FID");
        bf1.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID");
        bf1.append(" LEFT OUTER JOIN T_BD_MeasureUnit as UNIT ON ENTRY.FBaseUnitID = UNIT.FID");
        bf1.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT");
        bf1.append(" ON (ENTRY.FMaterialID = MULTIUNIT.FMaterialID AND ENTRY.FMeasureUnitID = MULTIUNIT.FMeasureUnitID)");
        bf1.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT");
        bf1.append(" ON (ENTRY.FMaterialID = MULTIBASEUNIT.FMaterialID AND ENTRY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)");
        bf1.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR ON OTHERBILL.FAuditorID = AUDITOR.FID");
        bf1.append(" LEFT OUTER JOIN T_SCM_BizType AS BizType ON OTHERBILL.FBizTypeID = BizType.FID");
        bf1.append(" LEFT OUTER JOIN T_SCM_BizCategory AS BizCategory  ON BizType.FBizCategoryID = BizCategory.Fid ");
        bf1.append(" where OTHERBILL.FBillType = ").append(202);
        bf1.append(" and OTHERBILL.FBillStatus = ").append(3);
        bf1.append(" and OTHERBILL.FIsReversed = 0 and OTHERBILL.FIsReverseBill = 0");
        bf1.append(" and (ENTRY.FUnWriteOffBaseQty > 0 or ENTRY.FUnWriteOffBaseQty < 0) ");
        bf1.append(" and OTHERBILL.FIsBizBill = 0");
        if (this.isDevolve) {
            bf1.append(" and BizCategory.FNumber in ").append(DEVOLVE_BIZ_CATEGORT);
        } else {
            bf1.append(" and (BizCategory.FNumber not in ").append(DEVOLVE_BIZ_CATEGORT);
            bf1.append(" Or BizType.FNumber is Null)");
        }
        bf1.append(" and " + extend);
        return bf1.toString();
    }

    private String getSaleInvoiceSQL(String tempTable, String extend, SqlParams sqlParams) {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append(" OTHERBILL.FNumber as number,");
        bf.append(" OTHERBILL.FBizDate as bizDate,");
        bf.append(" COMPANY.FName_" + this.language + " as companyOrgUnitName,");
        bf.append(" ASSTACTTYPE.FName_" + this.language + " as asstActType,");
        bf.append(" OTHERBILL.FAsstActName_" + this.language + " as asstActName,");
        bf.append(" MATERIAL.FNumber as materialNumber,");
        bf.append(" MATERIAL.FName_" + this.language + " as materialName,");
        bf.append(" MATERIAL.FShortName as shortName,");
        bf.append(" ENTRY.FQuantity as qty,");
        bf.append(" UNIT.FName_" + this.language + " as baseUnit,");
        bf.append(" ENTRY.FBaseQty as baseQty,");
        bf.append(" ENTRY.FRecievePayAmountLocal as receiveAmountLocal,");
        bf.append(" ENTRY.FAmountLocal as amountLocal,");
        bf.append(" ENTRY.FUnWriteOffBaseQty as unWriteOffBaseQty,");
        bf.append(" ENTRY.FLocalUnWriteOffAmount as unWriteOffAmountLocal,");
        bf.append(" ENTRY.FUnWriteOffBaseQty as curWriteOffBaseQty,");
        bf.append(" ENTRY.FLocalUnWriteOffAmount as curWriteOffAmountLocal,");
        bf.append(" COREBILLTYPE.FName_" + this.language + " as coreBillType,");
        bf.append(" ENTRY.FCoreBillNumber as coreBillNumber,");
        bf.append(" ENTRY.FCoreBillEntrySeq as coreBillEntrySeq,");
        bf.append(" OTHERBILL.FID AS billId,");
        bf.append(" ENTRY.FID as entryId,");
        bf.append(" ENTRY.FCoreBillEntryId as coreBillEntryId,");
        bf.append(" ENTRY.FMaterialId as materialId,");
        bf.append(" OTHERBILL.FCompanyID as companyOrgUnitId,");
        bf.append(" OTHERBILL.FAsstActID as supplierId,");
        bf.append(" BASECURRENCY.FPrecision as fprecision,");
        bf.append(" MULTIUNIT.FQtyPrecision as qtyPrecision,");
        bf.append(" MULTIBASEUNIT.FQtyPrecision as baseQtyPrecision,");
        bf.append(" MATERIAL.FPricePrecision as pricePrecision,");
        bf.append(" OTHERBILL.FYear as fyear,");
        bf.append(" OTHERBILL.FPeriod as fperiod,");
        bf.append(" ENTRY.FSeq as seq,");
        bf.append(" ENTRY.FBaseUnitID as baseUnitID,");
        bf.append(" ENTRY.FWrittenOffBaseQty as writtenOffBaseQty,");
        bf.append(" ENTRY.FLocalWrittenOffAmount as writtenOffAmount,");
        bf.append(" OTHERBILL.FBizTypeID as transactionTypeID,");
        bf.append(" Entry.FTaxAmountLocal as localTax,");
        bf.append(" Entry.FTaxAmount as tax,");
        bf.append(" Entry.FRecievePayAmount as recievePayAmount,");
        bf.append(" OTHERBILL.FExchangeRate as exchangeRate,");
        bf.append(" OTHERBILL.FCurrencyID as currencyID,");
        bf.append(" BizType.FNumber as bizTypeNumber,");
        bf.append(" OTHERBILL.FPaymentTypeID as paymentTypeID");
        bf.append(" into ");
        bf.append(tempTable);
        bf.append(" FROM T_AR_OtherBill AS OTHERBILL");
        bf.append(" INNER JOIN T_ORG_Company AS COMPANY ON COMPANY.FID = OTHERBILL.FCompanyID");
        bf.append(" INNER JOIN T_AR_OtherBillentry AS ENTRY ON OTHERBILL.FID = ENTRY.FParentID");
        bf.append(" INNER JOIN T_BD_Currency AS CURRENCY ON CURRENCY.FID = OTHERBILL.FCurrencyID");
        bf.append(" INNER JOIN T_BD_AsstActType AS ASSTACTTYPE ON ASSTACTTYPE.FID = OTHERBILL.FAsstActTypeID");
        bf.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON OTHERBILL.FAdminOrgUnitID = ADMINORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Sale AS SALEORG ON SALEORG.FID = OTHERBILL.FSaleOrgID");
        bf.append(" LEFT OUTER JOIN T_BD_Person AS PERSON ON OTHERBILL.FPersonId = PERSON.FID");
        bf.append(" LEFT OUTER JOIN T_PM_User AS Creator ON OTHERBILL.FCreatorID = Creator.FID");
        bf.append(" LEFT OUTER JOIN T_BD_VoucherTypes AS VOUCHERTYPE ON OTHERBILL.FVoucherTypeID = VOUCHERTYPE.FID");
        bf.append(" LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ON OTHERBILL.FSaleGroupID = SALEGROUP.FID");
        bf.append(" LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ON OTHERBILL.FBizTypeID = BIZTYPE.FID");
        bf.append(" LEFT OUTER JOIN T_BD_PaymentType AS PAYMENTTYPE ON OTHERBILL.FPaymentTypeID = PAYMENTTYPE.FID");
        bf.append(" INNER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
        bf.append(" LEFT OUTER JOIN T_SCM_ExpenseItem AS EXPENSEITEM ON ENTRY.FExpenseItemID = EXPENSEITEM.FID");
        bf.append(" LEFT OUTER JOIN T_SCM_BillType AS COREBILLTYPE ON ENTRY.FCoreBillTypeID = COREBILLTYPE.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANY.FBaseCurrencyID = BASECURRENCY.FID");
        bf.append(" LEFT OUTER JOIN T_BD_MeasureUnit as UNIT ON ENTRY.FBaseUnitID = UNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT");
        bf.append(" ON (ENTRY.FMaterialID = MULTIUNIT.FMaterialID AND ENTRY.FMeasureUnitID = MULTIUNIT.FMeasureUnitID)");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT");
        bf.append(" ON (ENTRY.FMaterialID = MULTIBASEUNIT.FMaterialID AND ENTRY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)");
        bf.append(" LEFT OUTER JOIN T_SCM_BizCategory AS BizCategory  ON BizType.FBizCategoryID = BizCategory.Fid ");
        bf.append(" where OTHERBILL.FBillType = ").append(102);
        bf.append(" and OTHERBILL.FBillStatus = ").append(3);
        bf.append(" and OTHERBILL.FIsReversed = 0 and OTHERBILL.FIsReverseBill = 0");
        bf.append(" and ENTRY.FUnWriteOffBaseQty <> 0 ");
        bf.append(" and OTHERBILL.FIsBizBill = 0");
        if (this.isDevolve) {
            bf.append(" and BizCategory.FNumber in ").append(DEVOLVE_BIZ_CATEGORT);
        } else {
            bf.append(" and (BizCategory.FNumber not in ").append(DEVOLVE_BIZ_CATEGORT);
            bf.append(" Or BizType.FNumber is Null)");
        }
        bf.append(" and " + extend);
        return bf.toString();
    }

    private String getPurInWarehsSQL(String tempTable, String extend, SqlParams sqlParams) {
        StringBuffer bf2 = new StringBuffer();
        bf2.append("select ");
        bf2.append(" PURINWAREHSBILL.FNumber as number,");
        bf2.append(" PURINWAREHSBILL.FBizDate as bizDate,");
        bf2.append(" STORAGEORGUNIT.FName_" + this.language + " as storageOrgUnitName,");
        bf2.append(" SUPPLIER.FName_" + this.language + " as supplierName,");
        bf2.append(" MATERIAL.FNumber as materialNumber,");
        bf2.append(" MATERIAL.FName_" + this.language + " as materialName,");
        bf2.append(" MATERIAL.FShortName as shortName,");
        bf2.append(" ENTRY.FQty as qty,");
        bf2.append(" UNIT.FName_" + this.language + " as baseUnit,");
        bf2.append(" ENTRY.FBaseQty as baseQty,");
        bf2.append(" ENTRY.fpurchaseCost as purchaseCost,");
        bf2.append(" ENTRY.FActualCost as actualCost,");
        bf2.append(" ENTRY.FUnWriteOffBaseQty as unWriteOffBaseQty,");
        bf2.append(" ENTRY.FUnWriteOffAmount as unWriteOffAmount,");
        bf2.append(" ENTRY.FUnWriteOffBaseQty as curWriteOffBaseQty,");
        bf2.append(" ENTRY.FUnWriteOffAmount as curWriteOffAmount,");
        bf2.append(" BILLTYPE.FName_" + this.language + " as coreBillType,");
        bf2.append(" ENTRY.FPurOrderNumber as coreBillNumber,");
        bf2.append(" ENTRY.FPurOrderEntrySeq as coreBillEntrySeq,");
        bf2.append(" PURINWAREHSBILL.FID as billId,");
        bf2.append(" ENTRY.FID as entryId,");
        bf2.append(" ENTRY.FPurOrderEntryID as coreBillEntryId,");
        bf2.append(" ENTRY.FMaterialId as materialId,");
        bf2.append(" ENTRY.FCompanyOrgUnitID as companyOrgUnitId,");
        bf2.append(" ENTRY.FStorageOrgUnitID as storageOrgUnitId,");
        bf2.append(" BASECURRENCY.FPrecision as fprecision,");
        bf2.append(" MULTIUNIT.FQtyPrecision as qtyPrecision,");
        bf2.append(" MULTIBASEUNIT.FQtyPrecision as baseQtyPrecision,");
        bf2.append(" MATERIAL.FPricePrecision as pricePrecision,");
        bf2.append(" PURINWAREHSBILL.FYear as fyear,");
        bf2.append(" PURINWAREHSBILL.FPeriod as fperiod,");
        bf2.append(" ENTRY.FWareHouseID as wareHouseID,");
        bf2.append(" ENTRY.FLot as lot,");
        bf2.append(" Project.Fid as FProjectID,");
        bf2.append(" TrackNumber.Fid as FTrackNumberID,");
        bf2.append(" ENTRY.FSeq as seq,");
        bf2.append(" ENTRY.FUnitID as unitID,");
        bf2.append(" ENTRY.FBaseUnitID as baseUnitID,");
        bf2.append(" ENTRY.FIsPresent as isPresent,");
        bf2.append(" PURINWAREHSBILL.FFiVouchered as fiVouchered,");
        bf2.append(" MaterialCompanyInfo.FAccountType as accountType,");
        bf2.append(" ENTRY.FWrittenOffBaseQty as writtenOffBaseQty,");
        bf2.append(" ENTRY.FWrittenOffAmount as writtenOffAmount,");
        bf2.append(" ENTRY.FUnitActualCost as unitActualCost,");
        bf2.append(" CASE WHEN MULTIUNIT.FBaseConvsRate IS NULL THEN 1 ELSE MULTIUNIT.FBaseConvsRate END AS baseConvsRate,");
        bf2.append(" PURINWAREHSBILL.FTransactionTypeID as transactionTypeID,");
        bf2.append(" PURINWAREHSBILL.FSupplierID as supplierId,");
        bf2.append(" ENTRY.FReverseQty as reverseQty,");
        bf2.append(" ENTRY.FTax AS tax,");
        bf2.append(" ENTRY.FLocalTax AS localTax,");
        bf2.append(" ENTRY.FLocalAmount AS localAmount,");
        bf2.append(" ENTRY.FAmount AS amount,");
        bf2.append(" PURINWAREHSBILL.FExchangeRate as exchangeRate,");
        bf2.append(" PURINWAREHSBILL.FCurrencyID as currencyID,");
        bf2.append(" PURINWAREHSBILL.FISREVERSED as isReversed,");
        bf2.append(" BizType.FNumber as bizTypeNumber,");
        bf2.append(" ENTRY.FUnitPurchaseCost as unitPurchaseCost,");
        bf2.append(" ENTRY.fpurchaseFee as purchaseFee,");
        bf2.append(" ADMINORGUNIT.FName_" + this.language + " as adminOrgUnit,");
        bf2.append(" ASSISTPROPERTY.FName_" + this.language + " AS assistProperty,");
        bf2.append(" ENTRY.FLocationID AS location,");
        bf2.append(" PURINWAREHSBILL.FPaymentTypeID AS paymentTypeID,");
        bf2.append(" PURINWAREHSBILL.FCostCenterOrgUnitID AS costCenterOrgUnit,");
        bf2.append(" TRANSACTIONTYPE.FIsWriteOff AS isWriteOff,");
        bf2.append(" ENTRY.FREMARK AS remark ");
        bf2.append(" into ");
        bf2.append(tempTable);
        bf2.append(" FROM T_IM_PurInWarehsBill as PURINWAREHSBILL");
        bf2.append(" INNER JOIN T_IM_PurInWarehsEntry as ENTRY ON PURINWAREHSBILL.FID = ENTRY.FParentID");
        bf2.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON PURINWAREHSBILL.FStorageOrgUnitID = STORAGEORGUNIT.FID");
        bf2.append(" INNER JOIN T_ORG_Company as COMPANYORGUNIT ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf2.append(" INNER JOIN T_SCM_BizType AS BizType ON PURINWAREHSBILL.FBizTypeID = BizType.FID");
        bf2.append(" INNER JOIN T_BD_MeasureUnit as UNIT ON ENTRY.FBaseUnitID = UNIT.FID");
        bf2.append(" INNER JOIN T_BD_Material as MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
        bf2.append(" INNER JOIN T_SCM_TransactionType TRANSACTIONTYPE ON PURINWAREHSBILL.FTransactionTypeID = TRANSACTIONTYPE.FID");
        bf2.append(" LEFT OUTER JOIN T_SCM_BillType AS SOURCEBILLTYPE ON PURINWAREHSBILL.FSourceBillTypeID = SOURCEBILLTYPE.FID");
        bf2.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON PURINWAREHSBILL.FAdminOrgUnitID = ADMINORGUNIT.FID");
        bf2.append(" LEFT OUTER JOIN T_PM_User AS CREATOR ON PURINWAREHSBILL.FCreatorID = CREATOR.FID");
        bf2.append(" LEFT OUTER JOIN T_ORG_CtrlUnit AS CU ON PURINWAREHSBILL.FControlUnitID = CU.FID");
        bf2.append(" LEFT OUTER JOIN T_GL_Voucher AS VOUCHER ON PURINWAREHSBILL.FVoucherID = VOUCHER.FID");
        bf2.append(" LEFT OUTER JOIN T_PM_User AS AUDITOR ON PURINWAREHSBILL.FAuditorID = AUDITOR.FID");
        bf2.append(" LEFT OUTER JOIN T_PM_User AS MODIFIER ON PURINWAREHSBILL.FModifierID = MODIFIER.FID");
        bf2.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON ENTRY.FLocationID = LOCATION.FID");
        bf2.append(" INNER JOIN T_BD_MaterialCompanyInfo AS MaterialCompanyInfo ON (ENTRY.FMaterialID = MaterialCompanyInfo.FMaterialID");
        bf2.append(" and ENTRY.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        bf2.append(" INNER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON ENTRY.FWarehouseID = WAREHOUSE.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON ENTRY.FAssistPropertyID = ASSISTPROPERTY.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ");
        bf2.append(" ON (ENTRY.FMaterialID = MULTIUNIT.FMaterialID AND ENTRY.FUnitID = MULTIUNIT.FMeasureUnitID)");
        bf2.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT");
        bf2.append(" ON (ENTRY.FMaterialID = MULTIBASEUNIT.FMaterialID AND ENTRY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)");
        bf2.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT");
        bf2.append(" ON (ENTRY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND ENTRY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID)");
        bf2.append(" LEFT OUTER JOIN T_SCM_BillType AS BILLTYPE ON ENTRY.FCoreBillTypeID = BILLTYPE.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf2.append(" LEFT OUTER JOIN T_BD_Supplier as SUPPLIER ON PURINWAREHSBILL.FSupplierID = SUPPLIER.FID");
        bf2.append(" LEFT OUTER JOIN T_MM_Project AS Project ON ENTRY.FProjectID = Project.FID");
        bf2.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TrackNumber ON ENTRY.FTrackNumberID = TrackNumber.FID");
        bf2.append(" LEFT OUTER JOIN T_SCM_BizCategory AS BizCategory  ON BizType.FBizCategoryID = BizCategory.Fid ");
        bf2.append(" WHERE PURINWAREHSBILL.FBaseStatus = ").append(4);
        bf2.append(" AND ENTRY.FUnWriteOffBaseQty <> 0 ");
        bf2.append(" and BizCategory.FNumber in ").append(DEVOLVE_BIZ_CATEGORT);
        bf2.append(" AND " + extend);
        return bf2.toString();
    }

    private String getSaleIssueSQL(String tempTable, String extend, SqlParams sqlParams) {
        StringBuffer bf = new StringBuffer();
        bf.append("select ");
        bf.append(" SALEISSUEBILL.FNumber as number,");
        bf.append(" SALEISSUEBILL.FBizDate as bizDate,");
        bf.append(" STORAGEORGUNIT.FName_" + this.language + " as storageOrgUnitName,");
        bf.append(" CUSTOMER.FName_" + this.language + " as customer,");
        bf.append(" MATERIAL.FNumber as materialNumber,");
        bf.append(" MATERIAL.FName_" + this.language + " as materialName,");
        bf.append(" MATERIAL.FShortName as shortName,");
        bf.append(" ENTRY.FQty as qty,");
        bf.append(" UNIT.FName_" + this.language + " as baseUnit,");
        bf.append(" ENTRY.FBaseQty as baseQty,");
        bf.append(" 0.00 as purchaseCost,");
        bf.append(" ENTRY.FActualCost as actualCost,");
        bf.append(" ENTRY.FUnWriteOffBaseQty as unWriteOffBaseQty,");
        bf.append(" ENTRY.FUnWriteOffAmount as unWriteOffAmount,");
        bf.append(" ENTRY.FUnWriteOffBaseQty as curWriteOffBaseQty,");
        bf.append(" ENTRY.FUnWriteOffAmount as curWriteOffAmount,");
        bf.append(" BILLTYPE.FName_" + this.language + " as coreBillType,");
        bf.append(" ENTRY.FSaleOrderNumber as coreBillNumber,");
        bf.append(" ENTRY.FSaleOrderEntrySeq as coreBillEntrySeq,");
        bf.append(" SALEISSUEBILL.FID as billId,");
        bf.append(" ENTRY.FID as entryId,");
        bf.append(" ENTRY.FSaleOrderEntryID as coreBillEntryId,");
        bf.append(" ENTRY.FMaterialId as materialId,");
        bf.append(" ENTRY.FCompanyOrgUnitID as companyOrgUnitId,");
        bf.append(" ENTRY.FStorageOrgUnitID as storageOrgUnitId,");
        bf.append(" CURRENCY2.FPrecision as fprecision,");
        bf.append(" MULTIUNIT.FQtyPrecision as qtyPrecision,");
        bf.append(" MULTIBASEUNIT.FQtyPrecision as baseQtyPrecision,");
        bf.append(" MATERIAL.FPricePrecision as pricePrecision,");
        bf.append(" SALEISSUEBILL.FYear as fyear,");
        bf.append(" SALEISSUEBILL.FPeriod as fperiod,");
        bf.append(" ENTRY.FWareHouseID as wareHouseID,");
        bf.append(" ENTRY.FLot as lot,");
        bf.append(" Project.FNumber as FProjectID,");
        bf.append(" TrackNumber.FNumber as FTrackNumberID,");
        bf.append(" ENTRY.FSeq as seq,");
        bf.append(" ENTRY.FUnitID as unitID,");
        bf.append(" ENTRY.FBaseUnitID as baseUnitID,");
        bf.append(" ENTRY.FIsPresent as isPresent,");
        bf.append(" SALEISSUEBILL.FFiVouchered as fiVouchered,");
        bf.append(" MaterialCompanyInfo.FAccountType as accountType,");
        bf.append(" ENTRY.FWrittenOffBaseQty as writtenOffBaseQty,");
        bf.append(" ENTRY.FWrittenOffAmount as writtenOffAmount,");
        bf.append(" ENTRY.FUnitActualCost as unitActualCost,");
        bf.append(" CASE WHEN MULTIUNIT.FBaseConvsRate IS NULL THEN 1 ELSE MULTIUNIT.FBaseConvsRate END AS baseConvsRate,");
        bf.append(" SALEISSUEBILL.FTransactionTypeID as transactionTypeID,");
        bf.append(" SALEISSUEBILL.FCustomerID as supplierId,");
        bf.append(" ENTRY.FReverseQty as reverseQty,");
        bf.append(" ENTRY.FTax AS tax,");
        bf.append(" ENTRY.FLocalTax AS localTax,");
        bf.append(" ENTRY.FLocalAmount AS localAmount,");
        bf.append(" ENTRY.FAmount AS amount,");
        bf.append(" SALEISSUEBILL.FExchangeRate as exchangeRate,");
        bf.append(" SALEISSUEBILL.FCurrencyID as currencyID, ");
        bf.append(" SALEISSUEBILL.FISREVERSED as isReversed,");
        bf.append(" BizType.FNumber as bizTypeNumber,");
        bf.append(" 0.00 as unitPurchaseCost,");
        bf.append(" 0.00 as purchaseFee,");
        bf.append(" SALEISSUEBILL.FAdminOrgUnitID as adminOrgUnit,");
        bf.append(" ENTRY.FAssistPropertyID AS assistProperty,");
        bf.append(" ENTRY.FLocationID AS location,");
        bf.append(" SALEISSUEBILL.FPaymentTypeID AS paymentTypeID,");
        bf.append(" SALEISSUEBILL.FCostCenterOrgUnitID AS costCenterOrgUnit,");
        bf.append(" TRANSACTIONTYPE.FIsWriteOff AS isWriteOff,");
        bf.append(" ENTRY.FREMARK AS remark ");
        bf.append(" into ");
        bf.append(tempTable);
        bf.append(" FROM T_IM_SaleIssueBill AS SALEISSUEBILL");
        bf.append(" LEFT OUTER JOIN T_SCM_BillType AS SOURCEBILLTYPE ON SALEISSUEBILL.FSourceBillTypeID = SOURCEBILLTYPE.FID");
        bf.append(" LEFT OUTER JOIN T_GL_Voucher AS VOUCHER ON SALEISSUEBILL.FVoucherID = VOUCHER.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Admin AS ADMINORGUNIT ON SALEISSUEBILL.FAdminOrgUnitID = ADMINORGUNIT.FID");
        bf.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON SALEISSUEBILL.FStorageOrgUnitID = STORAGEORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON SALEISSUEBILL.FCustomerID = CUSTOMER.FID");
        bf.append(" INNER JOIN T_IM_SaleIssueEntry AS ENTRY ON SALEISSUEBILL.FID = ENTRY.FParentID");
        bf.append(" INNER JOIN T_SCM_TransactionType AS TRANSACTIONTYPE ON SALEISSUEBILL.FTransactionTypeID = TRANSACTIONTYPE.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON SALEISSUEBILL.FCurrencyID = CURRENCY.FID");
        bf.append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON ENTRY.FUnitID = UNIT.FID");
        bf.append(" INNER JOIN T_BD_Material AS MATERIAL ON ENTRY.FMaterialID = MATERIAL.FID");
        bf.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON ENTRY.FLocationID = LOCATION.FID");
        bf.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON ENTRY.FWarehouseID = WAREHOUSE.FID");
        bf.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT1 ON ENTRY.FStorageOrgUnitID = STORAGEORGUNIT1.FID");
        bf.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON ENTRY.FAssistUnitID = ASSISTUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON ENTRY.FAssistPropertyID = ASSISTPROPERTY.FID");
        bf.append(" LEFT OUTER JOIN T_SCM_BillType AS BILLTYPE ON ENTRY.FCoreBillTypeID = BILLTYPE.FID");
        bf.append(" LEFT OUTER JOIN T_ORG_Sale AS SALEORGUNIT ON ENTRY.FSaleOrgUnitID = SALEORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_SaleGroup AS SALEGROUP ON ENTRY.FSaleGroupID = SALEGROUP.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS CURRENCY2 ON COMPANYORGUNIT.FBaseCurrencyID = CURRENCY2.FID");
        bf.append(" INNER JOIN T_BD_MeasureUnit AS BASEUNIT ON ENTRY.FBaseUnitID = BASEUNIT.FID");
        bf.append(" INNER JOIN T_BD_MaterialCompanyInfo AS MaterialCompanyInfo ON (ENTRY.FMaterialID = MaterialCompanyInfo.FMaterialID");
        bf.append(" and ENTRY.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ");
        bf.append(" ON (ENTRY.FMaterialID = MULTIUNIT.FMaterialID AND ENTRY.FUnitID = MULTIUNIT.FMeasureUnitID)");
        bf.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT");
        bf.append(" ON (ENTRY.FMaterialID = MULTIBASEUNIT.FMaterialID AND ENTRY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID)");
        bf.append(" INNER JOIN T_SCM_BizType AS BizType ON SALEISSUEBILL.FBizTypeID = BizType.FID");
        bf.append(" LEFT OUTER JOIN T_MM_Project AS Project ON ENTRY.FProjectID = Project.FID ");
        bf.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TrackNumber ON ENTRY.FTrackNumberID = TrackNumber.FID");
        bf.append(" LEFT OUTER JOIN T_SCM_BizCategory AS BizCategory  ON BizType.FBizCategoryID = BizCategory.Fid ");
        bf.append(" WHERE SALEISSUEBILL.FBaseStatus = ").append(4);
        bf.append(" AND ENTRY.FUnWriteOffBaseQty <> 0 ");
        bf.append(" AND TRANSACTIONTYPE.FRITypeID <> '" + RecIssueTypeConstant.CONSIGNOUT_RITYPEID + "' ");
        bf.append(" AND TRANSACTIONTYPE.FRITypeID <> '" + RecIssueTypeConstant.CONSIGNRT_RITYPEID + "' ");
        bf.append(" and BizCategory.FNumber in ").append(DEVOLVE_BIZ_CATEGORT);
        bf.append(" AND " + extend);
        return bf.toString();
    }

    private void createPurInvoiceTable(Context ctx, RptParams params, String extend) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable1"), ctx);
        String tempTable1 = "";
        if (null == extend) {
            String[][] fields = this.getPurInvoiceTablefields();
            String createSql = this.getCreateTempTableSql(fields);
            tempTable1 = this.createTempTable(ctx, createSql);
        } else {
            tempTable1 = this.getTempTableName("tempTable1", ctx);
            SqlParams sqlParams = new SqlParams();
            String sql = this.isSaleWriteOff ? this.getSaleInvoiceSQL(tempTable1, extend, sqlParams) : this.getPurInvoiceSQL(tempTable1, extend, sqlParams);
            this.executeCreateAsSelectInto(sql, sqlParams, ctx);
        }
        String countSql = "select count(1) cc from " + tempTable1;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        int count1 = rs.next() ? rs.getInt(0) : 0;
        String temp = this.isSaleWriteOff ? "receiveAmountLocal" : "recievePayAmountLocal";
        String[][] fields = new String[][]{{"false", "selected"}, {"false", "number"}, {"false", "bizDate"}, {"false", "companyOrgUnitName"}, {"false", "asstActType"}, {"false", "asstActName"}, {"false", "materialNumber"}, {"true", "materialName"}, {"true", "shortName"}, {"true", "qty"}, {"false", "baseUnit"}, {"true", "baseQty"}, {"true", temp}, {"true", "amountLocal"}, {"true", "unWriteOffBaseQty"}, {"true", "unWriteOffAmountLocal"}, {"true", "curWriteOffBaseQty"}, {"true", "curWriteOffAmount"}, {"false", "coreBillType"}, {"false", "coreBillNumber"}, {"false", "coreBillEntrySeq"}};
        String[] hiddenFields = new String[]{"billId", "entryId", "coreBillEntryId", "materialId", "companyOrgUnitId", "supplierId", "fprecision", "qtyPrecision", "baseQtyPrecision", "pricePrecision", "fyear", "fperiod", "seq", "baseUnitID", "writtenOffBaseQty", "writtenOffAmount", "transactionTypeID", "localTax", "tax", "recievePayAmount", "exchangeRate", "currencyID", "bizTypeNumber", "paymentTypeID"};
        RptTableHeader header1 = ManualWriteOffHelp.builderRptTableHeader(ctx, fields, hiddenFields);
        if (null == this.result) {
            this.result = new RptParams();
        }
        this.result.setString("index", "tblPurInvoice");
        this.result.setString("tempTable1", tempTable1);
        this.result.setObject("header1", (Object)header1);
        this.result.setInt("verticalCount1", count1);
    }

    private void createPurInWarehsTable(Context ctx, RptParams params, String extend) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable2"), ctx);
        String tempTable2 = "";
        if (null == extend) {
            String[][] fields = this.getPurInWarehsTablefields();
            String createSql = this.getCreateTempTableSql(fields);
            tempTable2 = this.createTempTable(ctx, createSql);
        } else {
            tempTable2 = this.getTempTableName("tempTable2", ctx);
            SqlParams sqlParams = new SqlParams();
            String sql = this.isSaleWriteOff ? this.getSaleIssueSQL(tempTable2, extend, sqlParams) : this.getPurInWarehsSQL(tempTable2, extend, sqlParams);
            this.executeCreateAsSelectInto(sql, sqlParams, ctx);
        }
        String countSql = "select count(1) cc from " + tempTable2;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count2 = rs.getInt(0);
        String temp = this.isSaleWriteOff ? "customer" : "supplierName";
        String[][] fields = new String[][]{{"false", "selected"}, {"false", "number"}, {"false", "bizDate"}, {"false", "storageOrgUnitName"}, {"false", temp}, {"false", "materialNumber"}, {"false", "materialName"}, {"true", "shortName"}, {"true", "qty"}, {"false", "baseUnit"}, {"true", "baseQty"}, {"true", "purchaseCost"}, {"true", "actualCost"}, {"true", "unWriteOffBaseQty"}, {"true", "unWriteOffAmount"}, {"true", "curWriteOffBaseQty"}, {"true", "curWriteOffAmount"}, {"false", "coreBillType"}, {"false", "coreBillNumber"}, {"false", "coreBillEntrySeq"}};
        String[] hiddenFields = new String[]{"billId", "entryId", "coreBillEntryId", "materialId", "companyOrgUnitId", "storageOrgUnitId", "fprecision", "qtyPrecision", "baseQtyPrecision", "pricePrecision", "fyear", "fperiod", "wareHouseID", "lot", "projectID", "trackNumberID", "seq", "unitID", "baseUnitID", "isPresent", "fiVouchered", "accountType", "writtenOffBaseQty", "writtenOffAmount", "unitActualCost", "baseConvsRate", "transactionTypeID", "supplierId", "reverseQty", "tax", "localTax", "localAmount", "amount", "exchangeRate", "currencyID", "isReversed", "bizTypeNumber", "unitPurchaseCost", "purchaseFee", "adminOrgUnit", "assistProperty", "location", "paymentTypeID", "costCenterOrgUnit", "isWriteOff", "remark"};
        RptTableHeader header2 = ManualWriteOffHelp.builderRptTableHeader(ctx, fields, hiddenFields);
        if (null == this.result) {
            this.result = new RptParams();
        }
        this.result.setString("tempTable2", tempTable2);
        this.result.setString("index", "PurInWareshs");
        this.result.setObject("header2", (Object)header2);
        this.result.setInt("verticalCount2", count2);
    }

    @Override
    protected void _inverseWriteOff(Context ctx, String[] ids, boolean isSaleWriteOff) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return;
        }
        String subSql = this.getIdTempTbleName(ctx, ids);
        if (subSql != null && subSql.length() > 0) {
            this.validateInverseWriteOff(ctx, subSql, isSaleWriteOff);
            this.afterUnWriteOff(ctx, subSql, ids, true);
            DBUtil.releaseTempTable(ctx, subSql);
        }
    }

    @Override
    protected void _inverseWriteOff(Context ctx, String[] ids) throws BOSException, EASBizException {
        String[] newid = this.getWriteOffRecordParentId(ctx, ids, "T_CL_WriteOffRecord");
        if (ids == null || newid == null || newid.length == 0 || ids.length == 0) {
            return;
        }
        String subSql = this.getIdTempTbleName(ctx, newid);
        if (subSql != null && subSql.length() > 0) {
            this.validateInverseWriteOff(ctx, subSql, false);
            this.afterUnWriteOff(ctx, subSql, ids, true);
            DBUtil.releaseTempTable(ctx, subSql);
        }
    }

    @Override
    protected void _inverseWriteOff(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        IObjectPK pklog = this.getWriteOffLogPk(ctx, ids);
        String[] newid = null;
        String[] devIds = null;
        String tempTblName = null;
        if ("2001".equals(billType)) {
            this.deleteJDTZCostAdjBill(ctx, ids);
        }
        if ("2001".equals(billType) || "103".equals(billType)) {
            newid = this.getWriteOffRecordParentId(ctx, ids, "T_CL_WriteOffRecord");
            devIds = this.getDevolveWriteOffRecordParentId(ctx, ids, "T_CL_DevolveWriteOffRecord");
        } else if ("104".equals(billType)) {
            devIds = this.getDevolveWriteOffRecordParentId(ctx, ids, "T_CL_DevolveWriteOffRecord");
        } else if ("1001".equals(billType) || "102".equals(billType)) {
            newid = this.getWriteOffRecordParentId(ctx, ids, "T_CL_WriteOffRecord");
        } else {
            tempTblName = this.getIdTempTbleName(ctx, ids);
            try {
                for (int i = 0; i < ids.length; ++i) {
                    String writeOffID = ids[i];
                    String woSql = "select FBillID,FBillEntryID,fparentid from t_cl_writeoffrecord where fparentid ='" + writeOffID + "' and FBillTypeNumber='330'";
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)woSql);
                    if (!rs.next()) continue;
                    String arBillID = rs.getString("FBillID");
                    ctx.put((Object)"ArBillEntryID", (Object)rs.getString("FBillEntryID"));
                    ctx.put((Object)"writeOffID", (Object)rs.getString("fparentid"));
                    CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(new Object[]{arBillID}, CreditOperationEnum.ManualUnWriteOff);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                ctx.remove((Object)"ArBillEntryID");
                ctx.remove((Object)"writeOffID");
            }
        }
        if (tempTblName == null) {
            tempTblName = this.getIdTempTbleName(ctx, newid);
        }
        if (tempTblName != null && tempTblName.length() > 0) {
            String subSql = "( select fid from  " + tempTblName + " ) ";
            this.checkInvoiced4PurInw(ctx, subSql);
            this.validateInverseWriteOff(ctx, tempTblName, false);
            HashSet<String> cAdjustIdSet = new HashSet<String>();
            String[] costAdjustid = this.getCostAdjustBillId(ctx, tempTblName);
            ICostAdjustBill costAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
            for (int i = 0; i < costAdjustid.length; ++i) {
                cAdjustIdSet.add(costAdjustid[i]);
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)costAdjustid[i]));
                costAdjust.unAudit((IObjectPK)pk);
            }
            this.deleteIssueCostAdjust(ctx, cAdjustIdSet);
            this.afterUnWriteOff(ctx, tempTblName, ids, true);
            if (pklog != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
            }
            DBUtil.releaseTempTable(ctx, tempTblName);
        }
        if (devIds != null && devIds.length > 0) {
            DevolveWriteOffFacadeFactory.getLocalInstance(ctx).inverseWriteOff(devIds);
        }
    }

    private void deleteIssueCostAdjust(Context ctx, Set<String> cAdjustIdSet) throws BOSException, EASBizException {
        ICostAdjustBill costAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", cAdjustIdSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        view.setFilter(filter);
        view.setSelector(selector);
        CostAdjustBillCollection coll = costAdjust.getCostAdjustBillCollection(view);
        if (coll != null && coll.size() > 0) {
            StringBuffer idStr = new StringBuffer();
            for (int i = 0; i < coll.size(); ++i) {
                if (i > 0) {
                    idStr.append(",");
                }
                idStr.append("'").append(coll.get(i).getId().toString()).append("'");
                costAdjust.unAudit((IObjectPK)new ObjectUuidPK(coll.get(i).getId()));
            }
            String deleteSql = "delete from T_CL_CostAdjustBillEntry where fparentid in (" + idStr + ")";
            DbUtil.execute((Context)ctx, (String)deleteSql);
            deleteSql = "delete from T_CL_CostAdjustBill where fid in (" + idStr + ")";
            DbUtil.execute((Context)ctx, (String)deleteSql);
        }
    }

    private IObjectPK getWriteOffLogPk(Context ctx, String[] ids) throws BOSException {
        IObjectPK pklog = null;
        try {
            StringBuffer queryIds = new StringBuffer();
            for (String s : ids) {
                queryIds.append("'").append(s).append("',");
            }
            if (queryIds.length() > 0) {
                queryIds.setLength(queryIds.length() - 1);
                String querySql = "select FBILLNUMBER,G.FCREATETYPE from T_CL_WriteOffRecord R INNER JOIN T_CL_WriteOffGroup G ON R.FPARENTID = G.FID where G.fid in(" + queryIds + ")";
                StringBuffer billNumber = new StringBuffer();
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql);
                int createType = -1;
                while (rs.next()) {
                    if (createType == -1) {
                        createType = rs.getInt("FCREATETYPE");
                    }
                    billNumber.append(rs.getString("FBILLNUMBER")).append(";");
                }
                if (createType != -1) {
                    if (billNumber.length() > 0) {
                        billNumber.setLength(billNumber.length() - 1);
                        if (billNumber.length() > 1200) {
                            billNumber.setLength(1200);
                        }
                    }
                    String title = "undefined unWriteOff Type";
                    if (createType == 0 || createType == 1) {
                        title = EASResource.getString((String)RES, (String)"stockUnWriteOff");
                    } else if (createType == 6 || createType == 7 || createType == 8 || createType == 9 || createType == 10 || createType == 11) {
                        title = EASResource.getString((String)RES, (String)"devUnWriteOff");
                    } else if (createType == 12 || createType == 13) {
                        title = EASResource.getString((String)RES, (String)"saleUnWriteOff");
                    } else if (createType == 14 || createType == 15) {
                        title = EASResource.getString((String)RES, (String)"incomeUnWriteOff");
                    }
                    pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("B84FB1E2"), null, (String)billNumber.toString(), (String)title);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return pklog;
    }

    private String getIdTempTbleName(Context ctx, String[] ids) throws BOSException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (ids.length > 500) {
            StringBuffer sql = new StringBuffer();
            StringBuffer createSql = new StringBuffer("create table tempTableName ( fid varchar(44))");
            String tempTableName = this.createTempTable(ctx, createSql.toString());
            ArrayList<String> sqlList = new ArrayList<String>();
            int length = ids.length;
            for (int i = 0; i < length; ++i) {
                sql.append("insert into ").append(tempTableName).append("(fid) values ('").append(ids[i]).append("');");
                sqlList.add(sql.toString());
                sql.setLength(0);
                if (sqlList.size() <= 200) continue;
                DBUtil.execBatchSql(ctx, sqlList, true);
                sqlList.clear();
            }
            DBUtil.execBatchSql(ctx, sqlList, true);
            result.append("(select fid from ").append(tempTableName).append(")");
        } else {
            result.append(" (");
            int length = ids.length;
            for (int i = 0; i < length; ++i) {
                if (i != 0) {
                    result.append(",");
                }
                result.append("'").append(ids[i]).append("'");
            }
            result.append(") ");
        }
        return result.toString();
    }

    private void deleteJDTZCostAdjBill(Context ctx, String[] ids) throws BOSException, EASBizException {
        String updateApportionAmount = "update t_ap_otherbillentry set FUnApportionAmount = FAmountLocal, FApportionAmount = 0 where FParentId in (select Fid from t_ap_otherbill where FBillType=204 and FId in {0})";
        if (ids == null || ids.length == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        String idStr = this.getIdString(ids);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourcebillId", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        ICostAdjustBill costAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
        CoreBaseCollection coll = costAdjust.getCollection(view);
        if (coll != null && coll.size() > 0) {
            CostAdjustBillInfo info = null;
            for (int i = 0; i < coll.size(); ++i) {
                info = (CostAdjustBillInfo)coll.get(i);
                costAdjust.unAudit((IObjectPK)new ObjectUuidPK(info.getId()));
                costAdjust.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            }
        }
        String sSQL = MessageFormat.format(updateApportionAmount, idStr);
        DBUtil.execute((Context)ctx, (String)sSQL);
    }

    private String getIdString(String[] ids) {
        if (ids.length == 0) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        return bf.toString();
    }

    private String[] getCostAdjustBillId(Context ctx, String writeOffGroupId) throws BOSException, EASBizException {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("select fbillid from T_CL_WriteOffRecord ");
        sSQL.append("where fbilltypenumber='").append("410").append("' ");
        sSQL.append("and fparentid in ").append(writeOffGroupId);
        sSQL.append(" group by fbillid");
        logger.debug((Object)("getCostAdjustBillId 'S sql" + sSQL.toString()));
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        String[] costAdjustid = new String[rs.size()];
        try {
            int index = 0;
            while (rs.next()) {
                costAdjustid[index] = rs.getString("fbillid");
                ++index;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return costAdjustid;
    }

    private void afterUnWriteOff(Context ctx, String parentId, String[] billIds, boolean isWOBill) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table tempTableName (");
        sql.append(" FCurrWrittenOffQty Decimal(28,10) Not Null Default 0, ");
        sql.append(" FCurrWrittenOffAmount Decimal(28,10) Not Null Default 0, ");
        sql.append(" FBillEntryId varchar(44) )");
        String tempTableName = this.createTempTable(ctx, sql.toString());
        KsqlUtil.createTempTableIndex((Context)ctx, (String)tempTableName, (String)"FBillEntryId", (boolean)true);
        sql.setLength(0);
        sql.append(" insert Into ").append(tempTableName);
        sql.append(" (FCurrWrittenOffQty,FCurrWrittenOffAmount,FBillEntryId) ");
        sql.append(" select sum(entry.FCurrWrittenOffQty) as FCurrWrittenOffQty,sum(entry.FCurrWrittenOffAmount) as FCurrWrittenOffAmount,");
        sql.append(" entry.FBillEntryId from T_CL_WriteOffRecord entry");
        sql.append(" where entry.fparentid in ").append(parentId);
        sql.append(" group by entry.FBillEntryId ");
        DBUtil.execute((Context)ctx, (String)sql.toString());
        String[] sqls = new String[7];
        sqls[0] = this.updatePurInwarehsSQL(tempTableName);
        logger.debug((Object)("updatePurInwarehsSQL" + sqls[0]));
        sqls[1] = this.updateSaleIssueSQL(tempTableName);
        logger.debug((Object)("updateSaleIssueSQL" + sqls[1]));
        sqls[2] = this.updateOtherApBillSQL(tempTableName);
        logger.debug((Object)("updateOtherApBillSQL" + sqls[2]));
        sqls[3] = this.updateOtherArBillSQL(tempTableName);
        logger.debug((Object)("updateOtherArBillSQL" + sqls[3]));
        sqls[4] = this.deleteCostAdjustBillEntrySQL(parentId);
        logger.debug((Object)("deleteCostAdjustBillEntrySQL" + sqls[4]));
        sqls[5] = this.deleteCostAdjustBillSQL(parentId);
        logger.debug((Object)("deleteCostAdjustBillSQL" + sqls[5]));
        sqls[6] = this.updateIncomeConfirmBillSQL(tempTableName);
        logger.debug((Object)("updateIncomeConfirmBillSQL" + sqls[6]));
        DBUtil.execute(ctx, sqls);
        logger.info((Object)"update PurInwarehs ,SaleIssue,OtherApBill,deleteCostAdjustBillEntry,deleteCostAdjustBill OK");
        this.wrietOffBizLog(ctx, billIds);
        DBUtil.execute((Context)ctx, (String)this.deleteWriteOffRecordSQL(parentId));
        DBUtil.execute((Context)ctx, (String)this.deleteWriteOffGroupSQL(parentId));
        logger.info((Object)"InverseWriteOff OK");
        DBUtil.releaseTempTable(ctx, tempTableName);
    }

    private void wrietOffBizLog(Context ctx, String[] billIds) {
        if (billIds.length == 0) {
            return;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        HashMap<String, String> hashLog = new HashMap<String, String>(10);
        hashLog.put("FMethodName", "inverseWriteOff");
        hashLog.put("FMethodAlias", "\u53cd\u6838\u9500");
        HashSet<String> idSet = new HashSet<String>(Arrays.asList(billIds));
        SCMBizLogAdapter.writeBizLogForWriteOff((Context)ctx, hashLog, (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), idSet);
    }

    private String[] getWriteOffRecordParentId(Context ctx, String[] ids, String tabName) throws BOSException, EASBizException {
        if (ids == null || ids.length == 0) {
            return null;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        String billId = bf.toString();
        bf.setLength(0);
        bf.append("select distinct fparentid from ").append(tabName);
        bf.append(" where fbillid in ").append(billId);
        String sql = bf.toString();
        logger.debug((Object)("sql=" + sql));
        bf.setLength(0);
        ArrayList<String> newids = new ArrayList<String>();
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                newids.add(rs.getString("fparentid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        String[] parentids = new String[newids.size()];
        return newids.toArray(parentids);
    }

    private String[] getDevolveWriteOffRecordParentId(Context ctx, String[] ids, String tabName) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        String billId = bf.toString();
        bf.setLength(0);
        bf.append("select distinct fparentid from ").append(tabName);
        bf.append(" where fbillid in ").append(billId);
        String sql = bf.toString();
        logger.debug((Object)("sql=" + sql));
        ArrayList<String> retIds = new ArrayList<String>();
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                retIds.add(rs.getString("fparentid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        String[] IdArray = new String[retIds.size()];
        for (int i = 0; i < retIds.size(); ++i) {
            IdArray[i] = retIds.get(i).toString();
        }
        return IdArray;
    }

    private void validateInverseWriteOff(Context ctx, String id, boolean isSaleWriteOff) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("select innerTable.FWriteOffYear,innerTable.FWriteOffPeriod,innerTable.materialNumber,innerTable.companyOrgUnitID,innerTable.writeOffVoucher,");
        bf.append("innerTable.isDischarged,innerTable.fpcvouchered,costAdjustBill.fnumber as billNumber,costAdjustBill.ffivouchered from ");
        bf.append(" (select");
        bf.append(" bill.FWriteOffYear,bill.FWriteOffPeriod,material.fnumber as materialNumber,");
        bf.append(" entry.fid entryId,entry.FCompanyOrgUnitID as companyOrgUnitID,");
        bf.append(" bill.ffivouchered as writeOffVoucher, bill.FIsDischarged as isDischarged,");
        bf.append(" bill.fpcvouchered as fpcvouchered");
        bf.append(" from T_CL_WriteOffGroup bill");
        bf.append(" inner join T_CL_WriteOffRecord entry on bill.fid=entry.fparentid");
        bf.append(" inner join T_BD_Material material on entry.fmaterialid=material.fid");
        bf.append(" where bill.fid in ");
        bf.append(id);
        bf.append(" group by bill.FWriteOffYear,bill.fwriteOffPeriod,material.fnumber,");
        bf.append(" entry.fid,entry.FCompanyOrgUnitID,");
        bf.append(" bill.ffivouchered, bill.FIsDischarged,bill.fpcvouchered) innerTable");
        bf.append(" left join T_CL_CostAdjustBill costAdjustBill on innerTable.entryId=costAdjustBill.fid");
        String sql = bf.toString();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
        try {
            PeriodInfo currentPeriodInfo = null;
            int curYear = 2100;
            int curPeriod = 1;
            while (rs.next()) {
                int writeOffYear = rs.getInt("FWriteOffYear");
                int writeOffPeriod = rs.getInt("FWriteOffPeriod");
                String billNumber = rs.getString("billNumber");
                boolean fivouchered = rs.getBoolean("ffivouchered");
                String companyOrgUnitID = rs.getString("companyOrgUnitID");
                boolean writeOffVoucher = rs.getBoolean("writeOffVoucher");
                boolean isDischarged = rs.getBoolean("isDischarged");
                boolean isPcVouchered = rs.getBoolean("fpcvouchered");
                if (writeOffVoucher || isPcVouchered) {
                    throw new ManualWriteOffException(ManualWriteOffException.WRITEOFFVOUCHER_ALERT);
                }
                if (isDischarged) {
                    throw new ManualWriteOffException(ManualWriteOffException.DEL_DISCHARGEWRITEOFF_ALERT);
                }
                if (null == currentPeriodInfo && companyOrgUnitID != null) {
                    currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(companyOrgUnitID));
                    curYear = currentPeriodInfo.getPeriodYear();
                    curPeriod = currentPeriodInfo.getPeriodNumber();
                }
                if (writeOffYear < curYear || writeOffYear == curYear && writeOffPeriod < curPeriod) {
                    throw new ManualWriteOffException(ManualWriteOffException.WRITEOFFPERIOD_ALERT);
                }
                if (StringUtil.isEmpty((String)billNumber) || !fivouchered) continue;
                throw new ManualWriteOffException(ManualWriteOffException.COSTADJBILL_ALERT, new Object[]{billNumber});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String updatePurInwarehsSQL(String tempTableName) {
        StringBuffer bf = new StringBuffer();
        bf.append("update t_im_purinwarehsentry as T1");
        bf.append(" set(FUnWriteOffBaseQty,FWrittenOffBaseQty,FUnWriteOffQty,FWrittenOffQty,FUnWriteOffAmount,FWrittenOffAmount)=(");
        bf.append(" select");
        bf.append(" case when purinwarehsentry.FWrittenOffBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" purinwarehsentry.FBaseQty");
        bf.append(" else");
        bf.append(" purinwarehsentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when purinwarehsentry.FWrittenOffBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" purinwarehsentry.FWrittenOffBaseQty-T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when purinwarehsentry.FWrittenOffBaseQty=T.FCurrWrittenOffQty then purinwarehsentry.FQty");
        bf.append(" else ");
        bf.append(" case when measureunit.FBaseConvsRate=1 then");
        bf.append(" round((purinwarehsentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty),measureunit.FQtyPrecision)");
        bf.append(" else");
        bf.append(" round(to_decimal((to_decimal(purinwarehsentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty,21,8))*");
        bf.append(CalculateUtil.TO_DECIMAL_DIVIDE("1/measureunit.FBaseConvsRate"));
        bf.append(" ,21,8),measureunit.FQtyPrecision) end ");
        bf.append(" end,");
        bf.append(" purinwarehsentry.fqty -");
        bf.append(" case when purinwarehsentry.FWrittenOffBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" purinwarehsentry.FQty");
        bf.append(" when measureunit.FBaseConvsRate=1 then");
        bf.append(" round((purinwarehsentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty),measureunit.FQtyPrecision)");
        bf.append(" else");
        bf.append(" round(to_decimal((to_decimal(purinwarehsentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty,21,8))*");
        bf.append(CalculateUtil.TO_DECIMAL_DIVIDE("1/measureunit.FBaseConvsRate"));
        bf.append(",21,8),measureunit.FQtyPrecision)");
        bf.append(" end,");
        bf.append(" case when purinwarehsentry.FWrittenOffBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" purinwarehsentry.FPurchaseCost");
        bf.append(" else");
        bf.append(" purinwarehsentry.FUnWriteOffAmount+T.FCurrWrittenOffAmount");
        bf.append(" end,");
        bf.append(" case when purinwarehsentry.FWrittenOffBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" purinwarehsentry.FWrittenOffAmount-T.FCurrWrittenOffAmount");
        bf.append(" end");
        bf.append(" from t_im_purinwarehsentry purinwarehsentry");
        bf.append(" inner join ").append(tempTableName).append(" T");
        bf.append(" on purinwarehsentry.fid=T.FBillEntryId ");
        bf.append(" left outer join T_BD_MultiMeasureUnit measureunit on");
        bf.append(" (purinwarehsentry.FMaterialID = measureunit.FMaterialid and purinwarehsentry.funitID = measureunit.FMeasureUnitID)");
        bf.append("  where T1.fid=purinwarehsentry.fid ) where T1.fid in ( select FBillEntryId from ").append(tempTableName).append(")");
        return bf.toString();
    }

    private String updateSaleIssueSQL(String tempTableName) {
        StringBuffer bf = new StringBuffer();
        bf.append("update T_IM_SaleIssueEntry as T1");
        bf.append(" set(FUnWriteOffBaseQty,FWrittenOffBaseQty,FUnWriteOffQty,FWrittenOffQty,FUnWriteOffAmount,FWrittenOffAmount)=(");
        bf.append(" select");
        bf.append(" case when saleissueentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" saleissueentry.FBaseQty");
        bf.append(" else");
        bf.append(" saleissueentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when saleissueentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" saleissueentry.FWrittenOffBaseQty-T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when saleissueentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" saleissueentry.FQty");
        bf.append(" when measureunit.FBaseConvsRate=1 then");
        bf.append(" round((saleissueentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty),measureunit.FQtyPrecision)");
        bf.append(" else");
        bf.append(" round(to_decimal(saleissueentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty,21,8)*");
        bf.append(CalculateUtil.TO_DECIMAL_DIVIDE("1/measureunit.FBaseConvsRate"));
        bf.append(",measureunit.FQtyPrecision)");
        bf.append(" end,");
        bf.append(" saleissueentry.fqty -");
        bf.append(" case when saleissueentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" saleissueentry.FQty");
        bf.append(" when measureunit.FBaseConvsRate=1 then");
        bf.append(" round((saleissueentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty),measureunit.FQtyPrecision)");
        bf.append(" else");
        bf.append(" round((saleissueentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty)*");
        bf.append(CalculateUtil.TO_DECIMAL_DIVIDE("1/measureunit.FBaseConvsRate"));
        bf.append(",measureunit.FQtyPrecision)");
        bf.append(" end,");
        bf.append(" case when saleissueentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" saleissueentry.FActualCost");
        bf.append(" else");
        bf.append(" saleissueentry.FUnWriteOffAmount+T.FCurrWrittenOffAmount");
        bf.append(" end,");
        bf.append(" case when saleissueentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" saleissueentry.FWrittenOffAmount-T.FCurrWrittenOffAmount");
        bf.append(" end");
        bf.append(" from T_IM_SaleIssueEntry saleissueentry");
        bf.append(" inner join ").append(tempTableName).append(" T");
        bf.append(" on saleissueentry.fid=T.FBillEntryId ");
        bf.append(" left outer join T_BD_MultiMeasureUnit measureunit on");
        bf.append(" (saleissueentry.FMaterialID = measureunit.FMaterialid and saleissueentry.funitID = measureunit.FMeasureUnitID)");
        bf.append(" where T1.fid=saleissueentry.fid ) where T1.fid in ( select FBillEntryId from ").append(tempTableName).append(")");
        return bf.toString();
    }

    private String updateOtherApBillSQL(String tempTableName) {
        StringBuffer bf = new StringBuffer();
        bf.append("update t_ap_otherbillentry as T1 set(FUnWriteOffBaseQty,FWrittenOffBaseQty,FLocalUnWriteOffAmount,FLocalWrittenOffAmount)=(");
        bf.append(" select");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" otherbillentry.FBaseQty");
        bf.append(" else");
        bf.append(" otherbillentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" otherbillentry.FWrittenOffBaseQty-T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" otherbillentry.FAmountLocal");
        bf.append(" else");
        bf.append(" otherbillentry.FLocalUnWriteOffAmount+T.FCurrWrittenOffAmount");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" otherbillentry.FLocalWrittenOffAmount-T.FCurrWrittenOffAmount");
        bf.append(" end");
        bf.append(" from t_ap_otherbillentry otherbillentry");
        bf.append(" inner join ").append(tempTableName).append(" T");
        bf.append(" on otherbillentry.fid=T.FBillEntryId ");
        bf.append("  where T1.fid=otherbillentry.fid ) where T1.fid in ( select FBillEntryId from ").append(tempTableName).append(")");
        return bf.toString();
    }

    private String updateIncomeConfirmBillSQL(String tempTableName) {
        StringBuffer bf = new StringBuffer();
        bf.append("update T_AR_IncomeConfimEntry as T1 set(FUnWriteOffBaseQty,FWrittenOffBaseQty,FLocalUnWriteOffAmount,FLocalWrittenOffAmount)=(");
        bf.append(" select");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" otherbillentry.FBaseQty");
        bf.append(" else");
        bf.append(" otherbillentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" otherbillentry.FWrittenOffBaseQty-T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" otherbillentry.FAmountLocal");
        bf.append(" else");
        bf.append(" otherbillentry.FLocalUnWriteOffAmount+T.FCurrWrittenOffAmount");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" otherbillentry.FLocalWrittenOffAmount-T.FCurrWrittenOffAmount");
        bf.append(" end");
        bf.append(" from T_AR_IncomeConfimEntry otherbillentry");
        bf.append(" inner join ").append(tempTableName).append(" T");
        bf.append(" on otherbillentry.fid=T.FBillEntryId ");
        bf.append("  where T1.fid=otherbillentry.fid ) where T1.fid in ( select FBillEntryId from ").append(tempTableName).append(")");
        return bf.toString();
    }

    private String updateOtherArBillSQL(String tempTableName) {
        StringBuffer bf = new StringBuffer();
        bf.append("update t_ar_otherbillentry as T1 set(FUnWriteOffBaseQty,FWrittenOffBaseQty,FLocalUnWriteOffAmount,FLocalWrittenOffAmount)=(");
        bf.append(" select");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" otherbillentry.FBaseQty");
        bf.append(" else");
        bf.append(" otherbillentry.FUnWriteOffBaseQty+T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" otherbillentry.FWrittenOffBaseQty-T.FCurrWrittenOffQty");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" otherbillentry.FAmountLocal");
        bf.append(" else");
        bf.append(" otherbillentry.FLocalUnWriteOffAmount+T.FCurrWrittenOffAmount");
        bf.append(" end,");
        bf.append(" case when otherbillentry.FBaseQty=T.FCurrWrittenOffQty then");
        bf.append(" 0");
        bf.append(" else");
        bf.append(" otherbillentry.FLocalWrittenOffAmount-T.FCurrWrittenOffAmount");
        bf.append(" end");
        bf.append(" from t_ar_otherbillentry otherbillentry");
        bf.append(" inner join ").append(tempTableName).append(" T");
        bf.append(" on otherbillentry.fid=T.FBillEntryId ");
        bf.append(" where T1.fid=otherbillentry.fid) where T1.fid in ( select FBillEntryId from ").append(tempTableName).append(")");
        return bf.toString();
    }

    private String deleteCostAdjustBillEntrySQL(String id) {
        StringBuffer bf = new StringBuffer();
        bf.append("delete from t_cl_costAdjustBillEntry where fid in (");
        bf.append(" select entry.fid from t_cl_costAdjustBillEntry entry");
        bf.append(" inner join T_CL_CostAdjustBill bill on bill.fid=entry.fparentid");
        bf.append(" inner join T_CL_WriteOffRecord writeOffRecord on writeOffRecord.fbillid=bill.fid and entry.fseq=writeOffRecord.fbillEntrySeq");
        bf.append(" where writeOffRecord.fparentid in");
        bf.append(id).append(")");
        logger.debug((Object)("deleteCostAdjustBillEntrySQL=" + bf.toString()));
        return bf.toString();
    }

    private String deleteCostAdjustBillSQL(String id) {
        StringBuffer bf = new StringBuffer();
        bf.append("delete from T_CL_CostAdjustBill where fid in (");
        bf.append(" select bill.fid from T_CL_CostAdjustBill bill");
        bf.append(" left join T_CL_CostAdjustBillEntry entry on bill.fid  = entry.fparentid");
        bf.append(" inner join T_CL_WriteOffRecord writeOffRecord on writeOffRecord.fbillid=bill.fid");
        bf.append(" where writeOffRecord.fparentid in");
        bf.append(id);
        bf.append(" and entry.fid is null)");
        logger.debug((Object)("deleteCostAdjustBillSQL=" + bf.toString()));
        return bf.toString();
    }

    private String deleteWriteOffRecordSQL(String id) {
        StringBuffer bf = new StringBuffer();
        bf.append("delete from T_CL_WriteOffRecord where fparentid in ");
        bf.append(id);
        logger.debug((Object)("deleteWriteOffRecordSQL=" + bf.toString()));
        return bf.toString();
    }

    private String deleteWriteOffGroupSQL(String id) {
        StringBuffer bf = new StringBuffer();
        bf.append("delete from T_CL_WriteOffGroup where fid in ");
        bf.append(id);
        logger.debug((Object)("deleteWriteOffGroupSQL=" + bf.toString()));
        return bf.toString();
    }

    @Override
    protected boolean _writeOff(Context ctx, WriteOffResultInfo writeOffResultInfo) throws BOSException, EASBizException {
        if (writeOffResultInfo.isSaleWriteOff()) {
            this.topTableName = new String[]{"T_AR_OtherBill", "T_AR_OtherBillEntry"};
            this.bottomTableName = new String[]{"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"};
        }
        this.updatePurInvoice(ctx, writeOffResultInfo.getPurInvoiceList());
        this.updatePurInWarehs(ctx, writeOffResultInfo.getPurInWarehsList(), writeOffResultInfo.isSaleWriteOff());
        if (!this.isSaleWriteOff) {
            this.updateFullReverseBillCost(ctx, writeOffResultInfo.getPurInWarehsList());
        }
        CoreBillBaseCollection costAdjColl = this.createCostAdjust(ctx, writeOffResultInfo);
        this.createWriteOffRecord(ctx, writeOffResultInfo);
        if (writeOffResultInfo.getPurInvoiceList().isEmpty() && writeOffResultInfo.getPurInWarehsList().isEmpty()) {
            logger.error((Object)"");
            throw new ManualWriteOffException(ManualWriteOffException.WRITEOFF_ALERT);
        }
        if (costAdjColl != null && costAdjColl.size() > 0) {
            CostAdjustBillInfo costInfo = null;
            ICostAdjustBill icostBill = CostAdjustBillFactory.getLocalInstance(ctx);
            for (int i = 0; i < costAdjColl.size(); ++i) {
                costInfo = (CostAdjustBillInfo)costAdjColl.get(i);
                icostBill.audit((IObjectPK)new ObjectUuidPK(costInfo.getId()));
            }
        }
        if (writeOffResultInfo.isSaleWriteOff()) {
            List idList = writeOffResultInfo.getPurInWarehsList();
            WriteOffBillInfo writeOffInfo = null;
            int size = null == idList ? 0 : idList.size();
            String[] idArray = new String[size];
            boolean[] isContainArBill = new boolean[size];
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    writeOffInfo = (WriteOffBillInfo)idList.get(i);
                    idArray[i] = writeOffInfo.getBillId();
                    isContainArBill[i] = true;
                }
                AutoSplitBillServerUtils.autoSplitBillByWrittenOffQty((Context)ctx, (boolean[])isContainArBill, (String[])idArray);
            }
        }
        this.writeLog(ctx, writeOffResultInfo.getPurInWarehsList(), writeOffResultInfo.getPurInvoiceList());
        return !writeOffResultInfo.getPurInvoiceList().isEmpty() || !writeOffResultInfo.getPurInWarehsList().isEmpty();
    }

    private void updatePurInvoice(Context ctx, List purInvoiceList) throws BOSException {
        if (purInvoiceList.isEmpty()) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("update ").append(this.topTableName[1]);
        bf.append(" set FUnWriteOffBaseQty=FUnWriteOffBaseQty-?");
        bf.append(" ,FWrittenOffBaseQty=FWrittenOffBaseQty+?");
        bf.append(" ,FLocalUnWriteOffAmount=FLocalUnWriteOffAmount-?");
        bf.append(" ,FLocalWrittenOffAmount=FLocalWrittenOffAmount+?");
        bf.append(" where FID=?");
        String updatePurInVoiceSQL = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(updatePurInVoiceSQL);
            for (WriteOffPurInvoiceInfo writeOffPurInvoiceInfo : purInvoiceList) {
                pm.setBigDecimal(1, writeOffPurInvoiceInfo.getCurWriteOffBaseQty());
                pm.setBigDecimal(2, writeOffPurInvoiceInfo.getCurWriteOffBaseQty());
                pm.setBigDecimal(3, writeOffPurInvoiceInfo.getCurWriteOffAmount());
                pm.setBigDecimal(4, writeOffPurInvoiceInfo.getCurWriteOffAmount());
                pm.setString(5, writeOffPurInvoiceInfo.getEntryId());
                pm.addBatch();
            }
            pm.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, pm);
                throw throwable;
            }
        }
        DBUtil.close(conn, pm);
    }

    private void updatePurInWarehs(Context ctx, List purInWarehsList, boolean isSaleWriteOff) throws BOSException, EASBizException {
        if (purInWarehsList.isEmpty()) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("update ").append(this.bottomTableName[1]);
        bf.append(" set FUnWriteOffBaseQty=FUnWriteOffBaseQty-?");
        bf.append(" ,FWrittenOffBaseQty=FWrittenOffBaseQty+?");
        bf.append(" ,FUnWriteOffQty=FUnWriteOffQty-?");
        bf.append(" ,FWrittenOffQty=FWrittenOffQty+?");
        bf.append(" ,FUnWriteOffAmount=?-(FWrittenOffAmount+?)");
        bf.append(" ,FWrittenOffAmount=FWrittenOffAmount+?");
        if (isSaleWriteOff) {
            bf.append(" ,FUnitActualCost=?");
            bf.append(" ,FActualCost=?");
        } else {
            bf.append(" ,FUnitPurchaseCost=?");
            bf.append(" ,FPurchaseCost=?");
        }
        bf.append(" where FID=?");
        String updatePurInWarehsSQL = bf.toString();
        String updateActualCostSql = WriteOffHelp.getCalcPurActualCostSQL2();
        Connection conn = null;
        PreparedStatement pm = null;
        PreparedStatement pm1 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(updatePurInWarehsSQL);
            pm1 = conn.prepareStatement(updateActualCostSql);
            for (WriteOffPurInWarehsInfo writeOffPurInWarehsInfo : purInWarehsList) {
                writeOffPurInWarehsInfo.setCurWriteOffQty(writeOffPurInWarehsInfo.getCurWriteOffBaseQty().divide(writeOffPurInWarehsInfo.getBaseConvsRate(), writeOffPurInWarehsInfo.getQtyPrecision(), 4));
                pm.setBigDecimal(1, writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
                pm.setBigDecimal(2, writeOffPurInWarehsInfo.getCurWriteOffBaseQty());
                pm.setBigDecimal(3, writeOffPurInWarehsInfo.getCurWriteOffQty());
                pm.setBigDecimal(4, writeOffPurInWarehsInfo.getCurWriteOffQty());
                pm.setBigDecimal(5, writeOffPurInWarehsInfo.getActualCost());
                pm.setBigDecimal(6, writeOffPurInWarehsInfo.getCurWriteOffAmount());
                pm.setBigDecimal(7, writeOffPurInWarehsInfo.getCurWriteOffAmount());
                pm.setBigDecimal(8, writeOffPurInWarehsInfo.getUnitActualCost());
                pm.setBigDecimal(9, writeOffPurInWarehsInfo.getActualCost());
                pm.setString(10, writeOffPurInWarehsInfo.getEntryId());
                pm.addBatch();
            }
            pm.executeBatch();
            if (!isSaleWriteOff) {
                for (WriteOffPurInWarehsInfo writeOffPurInWarehsInfo : purInWarehsList) {
                    String fid = writeOffPurInWarehsInfo.getEntryId();
                    pm1.setString(1, fid);
                    pm1.setString(2, fid);
                    pm1.addBatch();
                }
                pm1.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm, pm1}, new ResultSet[0]);
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm, pm1}, new ResultSet[0]);
    }

    public void updateFullReverseBillCost(Context ctx, List purInWarehsList) throws BOSException, EASBizException {
        if (purInWarehsList.isEmpty()) {
            return;
        }
        StringBuffer bf1 = new StringBuffer();
        bf1.append("select entry.fid as entryID");
        bf1.append(" ,entry.fqty as qty");
        bf1.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf1.append(" from ").append(this.bottomTableName[0]).append(" as bill");
        bf1.append(" inner join ").append(this.bottomTableName[1]).append(" as entry");
        bf1.append(" on bill.fid = entry.fparentid");
        bf1.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf1.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf1.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf1.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf1.append(" where bill.FIsReversed = 1 and bill.ffiVouchered = 0");
        bf1.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        String queryReverseBillSql = bf1.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("update ").append(this.bottomTableName[1]);
        bf2.append(" set FUnitPurchaseCost=?,FPurchaseCost=?");
        bf2.append(" where fid=?");
        String updateReverseBillSql = bf2.toString();
        String updateActualCostSql = "";
        StringBuffer updateEntrySCFilds = new StringBuffer();
        updateEntrySCFilds.append(" update T_IM_PurInWarehsEntry ");
        updateEntrySCFilds.append(" set FSCWrittenOffQty = FSCWrittenOffQty + ? ");
        updateEntrySCFilds.append(" ,FSCWrittenOffBaseQty = FSCWrittenOffBaseQty + ?");
        updateEntrySCFilds.append(" ,FSCUnWrittenOffQty = FSCUnWrittenOffQty - ? ");
        updateEntrySCFilds.append(" ,FSCUnWrittenOffBaseQty = FSCUnWrittenOffBaseQty - ?");
        updateEntrySCFilds.append(" where fid = ? and fparentid in (  select fid from  T_IM_PurInWarehsbill where fid = ?  and FPurchaseType = 1) ");
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        PreparedStatement pm3 = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pm1 = conn.prepareStatement(queryReverseBillSql, 1004, 1007);
            pm2 = conn.prepareStatement(updateReverseBillSql);
            for (WriteOffPurInWarehsInfo writeOffPurInWarehsInfo : purInWarehsList) {
                if (!writeOffPurInWarehsInfo.isWriteCost()) continue;
                pm1.setString(1, writeOffPurInWarehsInfo.getEntryId());
                rs = pm1.executeQuery();
                BigDecimal purchaseCost = writeOffPurInWarehsInfo.getActualCost();
                BigDecimal unitPurchaseCost = writeOffPurInWarehsInfo.getUnitActualCost();
                BigDecimal cost = new BigDecimal("0.00");
                int i = 0;
                while (rs.next()) {
                    int precision = rs.getInt("fprecision");
                    BigDecimal reverseCost = unitPurchaseCost.multiply(rs.getBigDecimal("qty")).setScale(precision, 4);
                    if (writeOffPurInWarehsInfo.getQty().compareTo(writeOffPurInWarehsInfo.getReverseQty()) == 0 && rs.isLast() && ++i > 1) {
                        reverseCost = purchaseCost.subtract(cost).negate();
                    } else if (writeOffPurInWarehsInfo.getQty().compareTo(writeOffPurInWarehsInfo.getReverseQty()) == 0 && rs.isLast() && i == 1) {
                        reverseCost = purchaseCost.negate();
                    }
                    cost = cost.add(reverseCost.abs());
                    pm2.setBigDecimal(1, unitPurchaseCost);
                    pm2.setBigDecimal(2, reverseCost);
                    pm2.setString(3, rs.getString("entryID"));
                    pm2.addBatch();
                }
                pm2.executeBatch();
                updateActualCostSql = WriteOffHelp.getCalcPurActualCostSQL2();
                pm3 = conn.prepareStatement(updateActualCostSql);
                rs.first();
                while (rs.next()) {
                    pm3.setString(1, rs.getString("entryID"));
                    pm3.setString(2, rs.getString("entryID"));
                    pm3.execute();
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm1, pm2, pm3}, new ResultSet[]{rs});
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm1, pm2, pm3}, new ResultSet[]{rs});
    }

    private CoreBillBaseCollection createCostAdjust(Context ctx, WriteOffResultInfo writeOffResultInfo) throws BOSException {
        CoreBillBaseCollection coreBillBaseCollection;
        CoreBillBaseCollection costAdjCollection = null;
        if (null == writeOffResultInfo.getCostAdjustMap() || writeOffResultInfo.getCostAdjustMap().isEmpty()) {
            return costAdjCollection;
        }
        costAdjCollection = new CoreBillBaseCollection();
        StringBuffer bf1 = new StringBuffer();
        bf1.append("insert into T_CL_CostAdjustBill(FID,FNumber,FIssueType,FCreateType,");
        bf1.append("FCalculateKind,FSupplierID,FStorageOrgUnitID,FBaseStatus,FSourceBillID,FSourceBillTypeID,FBillTypeID,");
        bf1.append("FYear,FPeriod,FBizDate,FCreatorID,FCreateTime,FAuditorID,FAuditTime,FControlUnitID,FAdminOrgUnitID,FCostCenterOrgUnitID)");
        bf1.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertBillSql = bf1.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("insert into T_CL_CostAdjustBillEntry(FID,FParentID,FStorageOrgUnitID,FCompanyOrgUnitID,");
        bf2.append("FWareHouseID,FLot,FQty,FBaseQty,FPrice,FAmount,FStandardCost,FActualCost,FMaterialID,FUnitID,");
        bf2.append("FBaseUnitID,FBaseStatus,FSourceBillID,FSourceBillEntryID,FSourceBillNumber,FSourceBillEntrySeq,FSeq,FAssistPropertyID,FStoreTypeID,FStoreStatusID,FLocationID,FProjectID,FTrackNumberID,FBizDate)");
        bf2.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertEntrySql = bf2.toString();
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm1 = conn.prepareStatement(insertBillSql);
            pm2 = conn.prepareStatement(insertEntrySql);
            CostAdjustBillInfo costBill = null;
            CostAdjustBillEntryInfo costEntry = null;
            Iterator iter = writeOffResultInfo.getCostAdjustMap().keySet().iterator();
            while (iter.hasNext()) {
                String number = String.valueOf(System.currentTimeMillis());
                String storageOrgUnitID = (String)iter.next();
                costBill = new CostAdjustBillInfo();
                String billId = this.getId(costBill);
                costBill.setId(BOSUuid.read((String)billId));
                String sourceBillId = null;
                List costAdjustList = (List)writeOffResultInfo.getCostAdjustMap().get(storageOrgUnitID);
                int k = 0;
                String adminOrgUnit = "";
                String costCenterOrgUnit = "";
                int size = costAdjustList.size();
                for (int i = 0; i < size; ++i) {
                    costEntry = new CostAdjustBillEntryInfo();
                    String entryId = this.getId(costEntry);
                    costEntry.setId(BOSUuid.read((String)entryId));
                    costBill.getEntry().add(costEntry);
                    WriteOffCostAdjustInfo writeOffCostAdjustInfo = (WriteOffCostAdjustInfo)costAdjustList.get(i);
                    writeOffCostAdjustInfo.setNumber(number);
                    writeOffCostAdjustInfo.setBillId(billId);
                    writeOffCostAdjustInfo.setEntryId(entryId);
                    pm2.setString(1, entryId);
                    pm2.setString(2, billId);
                    pm2.setString(3, writeOffCostAdjustInfo.getStorageOrgUnitID());
                    pm2.setString(4, writeOffCostAdjustInfo.getCompanyOrgUnitID());
                    pm2.setString(5, writeOffCostAdjustInfo.getWareHouseID());
                    pm2.setString(6, writeOffCostAdjustInfo.getLot());
                    pm2.setBigDecimal(7, writeOffCostAdjustInfo.getBaseQty());
                    pm2.setBigDecimal(8, writeOffCostAdjustInfo.getBaseQty());
                    pm2.setBigDecimal(9, writeOffCostAdjustInfo.getPrice());
                    pm2.setBigDecimal(10, writeOffCostAdjustInfo.getDiffAmount());
                    pm2.setBigDecimal(11, writeOffCostAdjustInfo.getDiffAmount());
                    pm2.setBigDecimal(12, writeOffCostAdjustInfo.getDiffAmount());
                    pm2.setString(13, writeOffCostAdjustInfo.getMaterialId());
                    pm2.setString(14, writeOffCostAdjustInfo.getBaseUnitID());
                    pm2.setString(15, writeOffCostAdjustInfo.getBaseUnitID());
                    pm2.setInt(16, 2);
                    pm2.setString(17, writeOffCostAdjustInfo.getSourceBillID());
                    pm2.setString(18, writeOffCostAdjustInfo.getSourceBillEntryID());
                    pm2.setString(19, writeOffCostAdjustInfo.getSourceBillNumber());
                    pm2.setInt(20, writeOffCostAdjustInfo.getSourceBillEntrySeq());
                    pm2.setInt(21, ++k);
                    pm2.setString(22, writeOffCostAdjustInfo.getAssistProperty());
                    pm2.setString(23, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
                    pm2.setString(24, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
                    pm2.setString(25, writeOffCostAdjustInfo.getLocationId());
                    pm2.setString(26, writeOffCostAdjustInfo.getProjectID());
                    pm2.setString(27, writeOffCostAdjustInfo.getTrackNumberID());
                    pm2.setTimestamp(28, writeOffResultInfo.getBizDate());
                    pm2.addBatch();
                    writeOffCostAdjustInfo.setSeq(k);
                    sourceBillId = writeOffCostAdjustInfo.getSourceBillID();
                    if (i != 0) continue;
                    adminOrgUnit = writeOffCostAdjustInfo.getAdminOrgUnit();
                    costCenterOrgUnit = writeOffCostAdjustInfo.getCostCenterOrgUnit();
                }
                costAdjCollection.add((CoreBillBaseInfo)costBill);
                pm1.setString(1, billId);
                pm1.setString(2, number);
                pm1.setInt(3, -1);
                pm1.setInt(4, 0);
                if (writeOffResultInfo.isDevolve()) {
                    pm1.setInt(4, 11);
                }
                pm1.setInt(5, 0);
                pm1.setString(6, writeOffResultInfo.getSupplerID());
                pm1.setString(7, storageOrgUnitID);
                pm1.setInt(8, 2);
                pm1.setString(9, sourceBillId);
                pm1.setString(10, "50957179-0105-1000-e000-015fc0a812fd463ED552");
                pm1.setString(11, "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552");
                pm1.setInt(12, writeOffResultInfo.getYear());
                pm1.setInt(13, writeOffResultInfo.getPeriod());
                pm1.setTimestamp(14, writeOffResultInfo.getBizDate());
                pm1.setString(15, writeOffResultInfo.getUserID());
                pm1.setTimestamp(16, this.getTime());
                pm1.setString(17, writeOffResultInfo.getUserID());
                pm1.setTimestamp(18, this.getTime());
                pm1.setString(19, this.getControlUnitID(ctx));
                pm1.setString(20, adminOrgUnit);
                pm1.setString(21, costCenterOrgUnit);
                pm1.addBatch();
            }
            pm1.executeBatch();
            pm2.executeBatch();
            coreBillBaseCollection = costAdjCollection;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm1, pm2}, null);
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm1, pm2}, null);
        return coreBillBaseCollection;
    }

    private void createWriteOffRecord(Context ctx, WriteOffResultInfo writeOffResultInfo) throws BOSException, EASBizException {
        if (writeOffResultInfo.getPurInvoiceList().isEmpty() && writeOffResultInfo.getPurInWarehsList().isEmpty()) {
            return;
        }
        StringBuffer bf1 = new StringBuffer();
        bf1.append("insert into T_CL_WriteOffGroup");
        bf1.append("(FID,FCreatorID,FCreateTime,FControlUnitID,FWriteOffDate,FWriteOffYear,FWriteOffPeriod");
        bf1.append(",FCompanyOrgUnitID,FCalculateKind,FCreateType,FNumber,FExchangeRate,FCurrencyID,FDischargeType)");
        bf1.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertWriteOffGroupSql = bf1.toString();
        StringBuffer bf2 = new StringBuffer();
        bf2.append("insert Into T_CL_WriteOffRecord");
        bf2.append("(FID,FSeq,FParentID,FOrderBillNumber,FOrderBillEntrySeq");
        bf2.append(",FSupplierID,FCustomerID,FMaterialID,FBaseUnitID,FBillID,FBillEntryID");
        bf2.append(",FBillNumber,FBillEntrySeq,FBillTypeNumber,FBillDate,FTransactionTypeID");
        bf2.append(",FCurrWrittenOffQty,FCurrWrittenOffPrice,FCurrWrittenOffAmount,FWirttenOffQty,FWrittenOffAmount");
        bf2.append(",FUnWirteOffQty,FUnWriteOffAmount,FCalcutatorID,FCompanyOrgUnitID");
        bf2.append(",FTax,FLocalTax,FAmount,FLocalAmount,FActualCost,FAccountViewInId,FAccountViewOutId,FWRITEOFFYEAR,FWRITEOFFPERIOD)");
        bf2.append(" values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertWriteOffRecordSql = bf2.toString();
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        int dischargeType = CalculateUtil.getDischargeType(ctx, writeOffResultInfo.getCompanyOrgUnitID());
        try {
            int calculateKind = writeOffResultInfo.isSaleWriteOff() ? 1 : 0;
            String controlUnitID = this.getControlUnitID(ctx);
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            String number = sf.format(new Date());
            conn = EJBFactory.getConnection((Context)ctx);
            pm1 = conn.prepareStatement(insertWriteOffGroupSql);
            pm2 = conn.prepareStatement(insertWriteOffRecordSql);
            String billId = this.getId(new WriteOffGroupInfo());
            Iterator iter1 = writeOffResultInfo.getPurInvoiceList().iterator();
            Iterator iter2 = writeOffResultInfo.getPurInWarehsList().iterator();
            this.buildWriteOffRecord(billId, controlUnitID, pm2, iter1, writeOffResultInfo);
            this.buildWriteOffRecord(billId, controlUnitID, pm2, iter2, writeOffResultInfo);
            pm1.setString(1, billId);
            pm1.setString(2, writeOffResultInfo.getUserID());
            pm1.setTimestamp(3, this.getTime());
            pm1.setString(4, controlUnitID);
            pm1.setTimestamp(5, this.getTime());
            pm1.setInt(6, writeOffResultInfo.getYear());
            pm1.setInt(7, writeOffResultInfo.getPeriod());
            pm1.setString(8, writeOffResultInfo.getCompanyOrgUnitID());
            pm1.setInt(9, calculateKind);
            pm1.setInt(10, this.getWriteOffCreateType(writeOffResultInfo.getWriteOffStandard(), writeOffResultInfo.isDevolve(), writeOffResultInfo.isSaleWriteOff()));
            pm1.setString(11, number);
            pm1.setBigDecimal(12, writeOffResultInfo.getExchangeRate());
            pm1.setString(13, writeOffResultInfo.getCurrencyID());
            pm1.setInt(14, dischargeType);
            if (null != writeOffResultInfo.getCostAdjustMap()) {
                for (String storageOrgUnitID : writeOffResultInfo.getCostAdjustMap().keySet()) {
                    List costAdjustList = (List)writeOffResultInfo.getCostAdjustMap().get(storageOrgUnitID);
                    Iterator iter3 = costAdjustList.iterator();
                    this.buildWriteOffRecord(billId, controlUnitID, pm2, iter3, writeOffResultInfo);
                }
            }
            this.row = 0;
            pm1.execute();
            pm2.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm1, pm2}, null);
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm1, pm2}, null);
    }

    private void buildWriteOffRecord(String billId, String controlUnitID, PreparedStatement pm, Iterator iter, WriteOffResultInfo writeOffResultInfo) throws SQLException {
        String userID = writeOffResultInfo.getUserID();
        while (iter.hasNext()) {
            String billTypeNumber;
            String entryId = this.getId(new WriteOffRecordInfo());
            WriteOffBillInfo info = (WriteOffBillInfo)iter.next();
            String string = billTypeNumber = writeOffResultInfo.isSaleWriteOff() ? "330" : "230";
            if (info instanceof WriteOffPurInWarehsInfo) {
                billTypeNumber = writeOffResultInfo.isSaleWriteOff() ? "102" : "103";
            } else if (info instanceof WriteOffCostAdjustInfo) {
                billTypeNumber = "410";
                info.setBizDate(writeOffResultInfo.getBizDate());
            }
            if (info instanceof WriteOffPurInWarehsInfo || info instanceof WriteOffPurInvoiceInfo) {
                writeOffResultInfo.setCurrencyID(info.getCurrencyID());
                writeOffResultInfo.setExchangeRate(info.getExchangeRate());
            }
            pm.setString(1, entryId);
            pm.setInt(2, ++this.row);
            pm.setString(3, billId);
            pm.setString(4, info.getCoreBillNumber());
            pm.setInt(5, info.getCoreBillEntrySeq());
            pm.setString(6, writeOffResultInfo.isSaleWriteOff() ? null : info.getSupplierId());
            pm.setString(7, writeOffResultInfo.isSaleWriteOff() ? info.getSupplierId() : null);
            pm.setString(8, info.getMaterialId());
            pm.setString(9, info.getBaseUnitID());
            pm.setString(10, info.getBillId());
            pm.setString(11, info.getEntryId());
            pm.setString(12, info.getNumber());
            pm.setInt(13, info.getSeq());
            pm.setString(14, billTypeNumber);
            pm.setTimestamp(15, info.getBizDate());
            pm.setString(16, info.getTransactionTypeID());
            pm.setBigDecimal(17, info.getCurWriteOffBaseQty());
            pm.setBigDecimal(18, CalculateUtil.ZERO);
            pm.setBigDecimal(19, info.getCurWriteOffAmount());
            pm.setBigDecimal(20, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getWrittenOffBaseQty().add(info.getCurWriteOffBaseQty()));
            pm.setBigDecimal(21, info instanceof WriteOffCostAdjustInfo ? info.getCurWriteOffAmount() : info.getWrittenOffAmount().add(info.getCurWriteOffAmount()));
            pm.setBigDecimal(22, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getBaseQty().subtract(info.getWrittenOffBaseQty()).subtract(info.getCurWriteOffBaseQty()));
            pm.setBigDecimal(23, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getActualCost().subtract(info.getWrittenOffAmount()).subtract(info.getCurWriteOffAmount()));
            pm.setString(24, userID);
            pm.setString(25, info.getCompanyOrgUnitID());
            if (info.getTax() == null) {
                info.setTax(CalculateUtil.ZERO);
            }
            if (info.getLocalTax() == null) {
                info.setLocalTax(CalculateUtil.ZERO);
            }
            if (info.getAmount() == null) {
                info.setAmount(CalculateUtil.ZERO);
            }
            if (info.getLocalAmount() == null) {
                info.setLocalAmount(CalculateUtil.ZERO);
            }
            pm.setBigDecimal(26, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getTax());
            pm.setBigDecimal(27, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getLocalTax());
            pm.setBigDecimal(28, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getAmount());
            pm.setBigDecimal(29, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getLocalAmount());
            pm.setBigDecimal(30, info instanceof WriteOffCostAdjustInfo ? CalculateUtil.ZERO : info.getActualCost());
            pm.setString(31, info.getAccountViewInId());
            pm.setString(32, info.getAccountViewOutId());
            pm.setInt(33, info.getYear());
            pm.setInt(34, info.getPeriod());
            pm.addBatch();
        }
    }

    private String getId(Object obj) {
        String id = null;
        if (obj instanceof CostAdjustBillInfo) {
            id = BOSUuid.create((BOSObjectType)((CostAdjustBillInfo)obj).getBOSType()).toString();
        } else if (obj instanceof CostAdjustBillEntryInfo) {
            id = BOSUuid.create((BOSObjectType)((CostAdjustBillEntryInfo)obj).getBOSType()).toString();
        } else if (obj instanceof WriteOffGroupInfo) {
            id = BOSUuid.create((BOSObjectType)((WriteOffGroupInfo)obj).getBOSType()).toString();
        } else if (obj instanceof WriteOffRecordInfo) {
            id = BOSUuid.create((BOSObjectType)((WriteOffRecordInfo)obj).getBOSType()).toString();
        }
        return id;
    }

    private int getWriteOffCreateType(String writeOffStandard, boolean isDevolve, boolean isSaleOff) {
        int createType = 0;
        if (writeOffStandard.equals("100")) {
            createType = isDevolve ? 7 : (isSaleOff ? 13 : 1);
        } else if (writeOffStandard.equals("110")) {
            createType = isDevolve ? 8 : (isSaleOff ? 13 : 1);
        } else if (writeOffStandard.equals("120")) {
            createType = isDevolve ? 9 : (isSaleOff ? 13 : 1);
        } else if (writeOffStandard.equals("130")) {
            createType = isDevolve ? 10 : (isSaleOff ? 13 : 1);
        } else if (writeOffStandard.equals("140")) {
            createType = isDevolve ? 11 : (isSaleOff ? 13 : 1);
        }
        return createType;
    }

    private String getControlUnitID(Context ctx) {
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return null == ctrlUnitInfo ? "" : ctrlUnitInfo.getId().toString();
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        createtime.toString();
        return createtime;
    }

    @Override
    protected OrgUnitCollection _getAuthorPurInStorageOrgs(Context ctx, String permission) throws BOSException, EASBizException {
        String purInQueryPK = "com.kingdee.eas.scm.im.inv.PurInWarehsQuery";
        OrgUnitCollection result = new OrgUnitCollection();
        MetaDataPK purInMetaPk = MetaDataPK.create((String)purInQueryPK);
        String permItem = SCMGroupServerUtils.getPermissionItem((Context)ctx, (IMetaDataPK)purInMetaPk);
        OrgUnitCollection storageColl = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Storage, (String)permItem);
        storageColl = SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)storageColl, (OrgType)OrgType.Storage);
        OrgUnitCollection companyColl = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Company, (String)permission);
        companyColl = SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)companyColl, (OrgType)OrgType.Company);
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        for (int i = 0; storageColl != null && i < storageColl.size(); ++i) {
            OrgUnitInfo orgInfo = storageColl.get(i);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(orgInfo.getId().toString(), 4, 1);
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
            for (int j = 0; companyColl != null && j < companyColl.size(); ++j) {
                if (ret == null || !companyColl.get(j).getId().toString().equalsIgnoreCase(ret.getId().toString())) continue;
                result.add(orgInfo);
            }
        }
        return result;
    }

    @Override
    protected OrgUnitCollection _getAuthorMainBizOrgs(Context ctx, OrgType orgType, String queryPk) throws BOSException, EASBizException {
        if (orgType != null && queryPk != null) {
            MetaDataPK metaPk = MetaDataPK.create((String)queryPk);
            String permItem = SCMGroupServerUtils.getPermissionItem((Context)ctx, (IMetaDataPK)metaPk);
            OrgUnitCollection collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)orgType, (String)permItem);
            return SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)collection, (OrgType)orgType);
        }
        return null;
    }

    private String getCreateTempTableSql(String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append("tempTableName");
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql.toString();
    }

    private String[][] getPurInvoiceTablefields() {
        String[][] fields = new String[][]{{"NUMBER", "VARCHAR(80)"}, {"bizDate", "DateTime"}, {"companyOrgUnitName", "VARCHAR(80)"}, {"asstActType", "VARCHAR(80)"}, {"asstActName", "VARCHAR(80)"}, {"materialNumber", "VARCHAR(80)"}, {"materialName", "VARCHAR(80)"}, {"shortName", "VARCHAR(80)"}, {"qty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"baseUnit", "VARCHAR(80)"}, {"baseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"recievePayAmountLocal", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"amountLocal", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"unWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"unWriteOffAmountLocal", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"curWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"curWriteOffAmountLocal", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"coreBillType", "VARCHAR(80)"}, {"coreBillNumber", "VARCHAR(80)"}, {"coreBillEntrySeq", "INT DEFAULT 0"}, {"billId", "VARCHAR(44)"}, {"entryId", "VARCHAR(44)"}, {"coreBillEntryId", "VARCHAR(44)"}, {"materialId", "VARCHAR(44)"}, {"companyOrgUnitId", "VARCHAR(44)"}, {"supplierId", "VARCHAR(44)"}, {"fprecision", "INT DEFAULT 2"}, {"qtyPrecision", "INT DEFAULT 4"}, {"baseQtyPrecision", "INT DEFAULT 4"}, {"pricePrecision", "INT DEFAULT 2"}, {"FYear", "INT DEFAULT 1999"}, {"FPeriod", "INT DEFAULT 1"}, {"seq", "INT DEFAULT 0"}, {"baseUnitID", "VARCHAR(44)"}, {"writtenOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"writtenOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"transactionTypeID", "VARCHAR(44)"}, {"localTax", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"tax", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"recievePayAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"exchangeRate", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"currencyID", "VARCHAR(44)"}, {"bizTypeNumber", "VARCHAR(80)"}};
        return fields;
    }

    private String[][] getPurInWarehsTablefields() {
        String[][] fields = new String[][]{{"NUMBER", "VARCHAR(80)"}, {"bizDate", "DateTime"}, {"storageOrgUnitName", "VARCHAR(80)"}, {"supplierName", "VARCHAR(80)"}, {"materialNumber", "VARCHAR(80)"}, {"materialName", "VARCHAR(80)"}, {"shortName", "VARCHAR(80)"}, {"qty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"baseUnit", "VARCHAR(80)"}, {"baseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"purchaseCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"actualCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"unWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"unWriteOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"curWriteOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"curWriteOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"coreBillType", "VARCHAR(80)"}, {"coreBillNumber", "VARCHAR(80)"}, {"coreBillEntrySeq", "INT DEFAULT 0"}, {"billId", "VARCHAR(44)"}, {"entryId", "VARCHAR(44)"}, {"coreBillEntryId", "VARCHAR(44)"}, {"materialId", "VARCHAR(44)"}, {"companyOrgUnitId", "VARCHAR(44)"}, {"storageOrgUnitId", "VARCHAR(44)"}, {"fprecision", "INT DEFAULT 2"}, {"qtyPrecision", "INT DEFAULT 4"}, {"baseQtyPrecision", "INT DEFAULT 4"}, {"pricePrecision", "INT DEFAULT 2"}, {"FYear", "INT DEFAULT 1999"}, {"FPeriod", "INT DEFAULT 1"}, {"wareHouseID", "VARCHAR(44)"}, {"lot", "NVARCHAR(255)"}, {"seq", "INT DEFAULT 0"}, {"unitID", "VARCHAR(44)"}, {"baseUnitID", "VARCHAR(44)"}, {"isPresent", "INT DEFAULT 0"}, {"fiVouchered", "INT DEFAULT 0"}, {"accountType", "INT DEFAULT -1"}, {"writtenOffBaseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"writtenOffAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"unitActualCost", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"baseConvsRate", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"transactionTypeID", "VARCHAR(44)"}, {"supplierId", "VARCHAR(44)"}, {"reverseQty", "NUMERIC(21,8) DEFAULT 0 NOT NULL"}, {"tax", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"localTax", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"localAmount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"amount", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"exchangeRate", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"currencyID", "VARCHAR(44)"}, {"isReversed", "INT DEFAULT 0"}, {"bizTypeNumber", "VARCHAR(80)"}, {"unitPurchaseCost", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"purchaseFee", "NUMERIC(17,4) DEFAULT 0 NOT NULL"}, {"adminOrgUnit", "VARCHAR(44)"}, {"assistProperty", "VARCHAR(44)"}, {"location", "VARCHAR(44)"}};
        return fields;
    }

    @Override
    protected OrgUnitCollection _getAuthorMainBizOrgs(Context ctx, OrgType fromOrgType, OrgType toOrgType, String queryPk, String permission) throws BOSException, EASBizException {
        if (fromOrgType == null || toOrgType == null || queryPk == null || permission == null) {
            return null;
        }
        OrgUnitCollection result = new OrgUnitCollection();
        MetaDataPK metaPk = MetaDataPK.create((String)queryPk);
        String permItem = SCMGroupServerUtils.getPermissionItem((Context)ctx, (IMetaDataPK)metaPk);
        OrgUnitCollection storageColl = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)fromOrgType, (String)permItem);
        storageColl = SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)storageColl, (OrgType)fromOrgType);
        OrgUnitCollection companyColl = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)toOrgType, (String)permission);
        companyColl = SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)companyColl, (OrgType)toOrgType);
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        for (int i = 0; storageColl != null && i < storageColl.size(); ++i) {
            OrgUnitInfo orgInfo = storageColl.get(i);
            OrgUnitCollection orgCol = iUnitRel.getToUnit(orgInfo.getId().toString(), fromOrgType.getValue(), toOrgType.getValue());
            CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)orgCol.get(0);
            for (int j = 0; companyColl != null && j < companyColl.size(); ++j) {
                if (ret == null || !companyColl.get(j).getId().toString().equalsIgnoreCase(ret.getId().toString())) continue;
                result.add(orgInfo);
            }
        }
        return result;
    }

    public void writeLog(Context ctx, List imBillList, List invoiceBillList) {
        int i;
        StringBuffer msg = new StringBuffer();
        StringBuffer number = new StringBuffer();
        HashSet<String> numberSet = new HashSet<String>();
        WriteOffBillInfo info = null;
        String purInWarehsTitle = EASResource.getString((String)RES, (String)"devPurInWarehsBill");
        String purInvoiceTitle = EASResource.getString((String)RES, (String)"otherApBill");
        String msgToContinueTitle = EASResource.getString((String)RES, (String)"msgToContinue");
        String purWriteOffTitle = EASResource.getString((String)RES, (String)"purWriteOff");
        ArrayList<String> msgList = new ArrayList<String>();
        int limitLength = 1024;
        if (imBillList != null && !imBillList.isEmpty()) {
            msg.append(purInWarehsTitle).append(":");
            for (i = 0; i < imBillList.size(); ++i) {
                info = (WriteOffPurInWarehsInfo)imBillList.get(i);
                if (!numberSet.add(info.getNumber())) continue;
                if (msg.length() + info.getNumber().length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(purInWarehsTitle).append(":");
                }
                msg.append(info.getNumber()).append(", ");
            }
        }
        if (invoiceBillList != null && !invoiceBillList.isEmpty()) {
            msg.append(purInvoiceTitle).append(":");
            for (i = 0; i < invoiceBillList.size(); ++i) {
                info = (WriteOffPurInvoiceInfo)invoiceBillList.get(i);
                if (!numberSet.add(info.getNumber())) continue;
                if (msg.length() + info.getNumber().length() > limitLength) {
                    msg.append(msgToContinueTitle);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                    msg.append(purInvoiceTitle).append(":");
                }
                msg.append(info.getNumber()).append(", ");
            }
        }
        if (msg.length() > 0) {
            msgList.add(msg.toString());
        }
        IObjectPK pklog = null;
        for (int i2 = 0; i2 < msgList.size(); ++i2) {
            pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("13AF665D"), null, (String)((String)msgList.get(i2)), (String)purWriteOffTitle);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }

    private void checkInvoiced4PurInw(Context ctx, String subSql) throws BOSException, ManualWriteOffException {
        if (CommonUtils.hasCFField((Context)ctx)) {
            StringBuffer sql = new StringBuffer();
            sql.append("select r.FPARENTID as id,max(r.FBILLNUMBER) as num from T_CL_WRITEOFFRECORD r ");
            sql.append("inner join T_IM_PURINWAREHSENTRY en on en.fid = r.FBILLENTRYID ");
            sql.append("where r.FPARENTID in " + subSql);
            sql.append("and r.FBILLTYPENUMBER = '103' and en.CFIsContrastDrew = 1 ");
            sql.append("group by r.FPARENTID having sum(r.FCURRWRITTENOFFQTY) = 0 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                if (rs.next()) {
                    throw new ManualWriteOffException(ManualWriteOffException.PURINWAREHS_INVOICED, new Object[]{rs.getString("num")});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

