/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreStateInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.common.app.SQLUtils;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.CalInEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.IssueTypeEnum;
import com.kingdee.eas.scm.cal.app.AbstractMatAssembleCalculateFacadeControllerBean;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatAssembleCalculateFacadeControllerBean
extends AbstractMatAssembleCalculateFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.MatAssembleCalculateFacadeControllerBean");
    private String companyOrgID = null;
    PeriodInfo periodInfo = null;
    protected int currPeriod;
    private String DEAL_TAIL = new StringBuffer().append("select entry.FID, entry.FQTY, entry.FACTUALCOST, entry.FUNITACTUALCOST, entry.FSOURCEBILLENTRYID, bill.FFIVOUCHERED, bill.FPERIOD+bill.FYEAR*100 FPERIOD, bill.FNUMBER,").append(" disBefore.FPROCESSCHARGE ,isnull(beforeEntry.FQTY, afterEntry.FQTY) FALLINQTY, sum(issueEntry.FACTUALCOST) FOUTACTUALCOST,isnull(afterEntry.FID ,beforeEntry.FID) FINENTRYID,MATERIAL.FPRICEPRECISION,").append(" afterEntry.FCOSTRATE ").append(" from T_IM_OtherInwarehsBillEntry entry").append(" inner join T_IM_OtherInwarehsBill bill ON ENTRY.FPARENTID = BILL.FID").append(" INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = entry.FMATERIALID").append(" inner join T_IM_OtherIssueBillEntry issueEntry on issueEntry.FSourceBillEntryID = entry.FSourceBillEntryID ").append(" left join T_IM_MatAssembleBeforeEntry beforeEntry on beforeEntry.FID  = entry.FSourceBillEntryID").append(" left join T_IM_MatDisassembleAfterEntry afterEntry on afterEntry.FParentID  = entry.FSourceBillEntryID and entry.FSOURCEBILLENTRYSEQ = afterEntry.FSeq").append(" LEFT OUTER JOIN T_IM_MatDisassembleBeforeEntry disBefore on disBefore.FID = afterEntry.FParentID").append(" where bill.FPERIOD+bill.FYEAR*100 <= {1} and bill.FBASESTATUS = 4").append(" and entry.FSOURCEBILLENTRYID in (select FSOURCEBILLENTRYID from {0})").append(" group by entry.FID, entry.FQTY, entry.FACTUALCOST, entry.FUNITACTUALCOST, entry.FSOURCEBILLENTRYID, bill.FFIVOUCHERED, bill.FPERIOD, bill.FYEAR,beforeEntry.FQTY, afterEntry.FQTY,").append(" disBefore.FPROCESSCHARGE,afterEntry.FID ,beforeEntry.FID,MATERIAL.FPRICEPRECISION,bill.FNUMBER,afterEntry.FCOSTRATE ").append(" order by entry.FQTY desc, entry.fid").toString();
    protected String IS_OLD_PERIOD = "select distinct inWarehs.FNumber from {0} inWarehs where (inWarehs.FYear * 100 + inWarehs.FPeriod) < {1}";
    protected String IS_ACTUALCOST_EQUALS_ZERO = "select distinct inWarehs.FNumber from {0} inWarehs where inWarehs.FIssueActualCost = 0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CalculateParams _costCalculate(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String CHECK_BEFORE_ADCOST_SQL = "select fnumber from T_CL_CostAdjustBill bill inner join T_CL_CostAdjustBillEntry entry on bill.fid = entry.FParentId where   {0} and FFivouchered = 1 and (FCreateType = {1} or FCreateType = {2})";
        String GET_DELETE_BEFORE_ADCOST_SQL = "select bill.fid from T_CL_CostAdjustBill bill inner join T_CL_CostAdjustBillEntry entry on bill.fid = entry.FParentId  where  {0}  and  (FCreateType = {1} or FCreateType = {2})";
        String INSERT_INWAREHSBILL_SQL = new StringBuffer().append("insert into {0} (FBillID, FEntryID, FSeq, FSourceBillEntryID, FNumber, FYear, FPeriod, FMaterialID, FPricePrecision, FCostPrecision,").append(" FQty, FBaseQty, FAfterEntryQty, FIssueActualCost, FFivouchered, FAccountType, FOldInActualCost,FProcessCharge) ").append(" select bill.FID as FBillID,entry.FID as FEntryID,entry.FSeq,entry.FSourceBillEntryID,bill.FNumber,bill.FYear,bill.FPeriod, ").append(" entry.FMaterialID,material.FPricePrecision,currency.FPrecision,entry.FQty,entry.FBaseQty,beforeEntry.FQty,sum(issueEntry.FActualCost) as FIssueActualCost,").append(" bill.FFivouchered,matCompany.FAccountType,isnull(entry.FActualCost,0) as FOldInActualCost, isnull(beforeEntry.FProcessCharge,0) ").append(" from T_IM_OtherInWarehsBill bill ").append(" inner join T_IM_OtherInWarehsBillEntry entry on entry.FParentId = bill.FID ").append(" inner join T_ORG_COMPANY company on entry.FCOMPANYORGUNITID = company.fid ").append(" left join T_BD_Currency currency on company.FBASECURRENCYID  = currency.fid ").append(" inner join T_BD_Material material on entry.FMaterialId = material.FID ").append(" inner join T_IM_OtherIssueBillEntry issueEntry on issueEntry.FSourceBillEntryID = entry.FSourceBillEntryID ").append(" inner join T_IM_MatAssembleBeforeEntry beforeEntry on beforeEntry.FID  = entry.FSourceBillEntryID").append(" inner join T_BD_MaterialCompanyInfo matCompany on matCompany.FMaterialID = entry.FMaterialID and matCompany.FCompanyID = entry.FCompanyOrgUnitID ").append(" where bill.FBaseStatus = 4 and bill.FIsReversed = 0 and {1} ").append(" group by bill.FID ,entry.FID ,entry.FSeq,entry.FSourceBillEntryID,bill.FNumber,bill.FYear,bill.FPeriod,entry.FMaterialID,material.FPricePrecision,").append(" currency.FPrecision,entry.FQty,entry.FBaseQty,beforeEntry.FQty, bill.FFivouchered,matCompany.FAccountType,entry.FActualCost,beforeEntry.FProcessCharge").toString();
        String INSERT_INWAREHSBILL_SQL2 = new StringBuffer().append(" insert into {0} (FBillID, FEntryID, FSeq, FSourceBillEntryID, FNumber, FYear, FPeriod, FMaterialID, FPricePrecision, FCostPrecision, ").append(" FQty, FBaseQty, FAfterEntryQty, FIssueActualCost, FFivouchered, FAccountType, FOldInActualCost,FManualActualCost,FProcessCharge,FRate) ").append(" select bill.FID as FBillID,entry.FID as FEntryID,entry.FSeq,entry.FSourceBillEntryID,bill.FNumber,bill.FYear,bill.FPeriod, ").append(" entry.FMaterialID,material.FPricePrecision,currency.FPrecision,entry.FQty,entry.FBaseQty,afterEntry.FQty,sum(issueEntry.FActualCost) as FIssueActualCost,").append(" bill.FFivouchered,matCompany.FAccountType,isnull(entry.FActualCost,0) as FOldInActualCost, ").append(" isnull(afterEntry.FAmount,0),isnull(afterEntry.FProcessCharge,0),isnull(to_decimal(afterEntry.FCostRate/100,24,12),0) ").append(" from T_IM_OtherInWarehsBill bill ").append(" inner join T_IM_OtherInWarehsBillEntry entry on entry.FParentId = bill.FID ").append(" inner join T_ORG_COMPANY company on entry.FCOMPANYORGUNITID = company.fid ").append(" left join T_BD_Currency currency on company.FBASECURRENCYID  = currency.fid ").append(" inner join T_BD_Material material on entry.FMaterialId = material.FID ").append(" inner join T_IM_OtherIssueBillEntry issueEntry on issueEntry.FSourceBillEntryID = entry.FSourceBillEntryID ").append(" inner join T_IM_MatDisassembleAfterEntry afterEntry on afterEntry.FparentID  = entry.FSourceBillEntryID and entry.FSOURCEBILLENTRYSEQ = afterEntry.FSeq \n").append(" inner join T_IM_MatDisassembleBeforeEntry beforeEntry on beforeEntry.FID  = afterEntry.FParentID").append(" inner join T_BD_MaterialCompanyInfo matCompany on matCompany.FMaterialID = entry.FMaterialID and matCompany.FCompanyID = entry.FCompanyOrgUnitID ").append(" where bill.FBaseStatus = 4 and bill.FIsReversed = 0 and {1} ").append(" group by bill.FID ,entry.FID ,entry.FSeq,entry.FSourceBillEntryID,bill.FNumber,bill.FYear,bill.FPeriod,entry.FMaterialID,material.FPricePrecision,currency.FPrecision,entry.FQty,entry.FBaseQty,afterEntry.FQty,").append(" bill.FFivouchered,matCompany.FAccountType,entry.FActualCost , afterEntry.FAmount,afterEntry.FProcessCharge,afterEntry.FCostRate").toString();
        String INSERT_TO_MANUALCOST_TABLE = new StringBuffer().append(" insert into {0} (FSourceBillEntryID,FSumManualCost)").append(" select FSourceBillEntryID,sum(cost) from (select FSourceBillEntryID,max(FManualActualCost) cost from {1} where FManualActualCost >= 0  Group by FSourceBillEntryID,FSeq) temp ").append(" group by FSourceBillEntryID").toString();
        String UPDATE_INWAREHS_ACTUALCOST_SQL = new StringBuffer().append(" update {0} t set (FIssueActualCost) = (select t.FIssueActualCost - t1.FSumManualCost ").append(" from {1} t1 where t.FSourceBillEntryID = t1.FSourceBillEntryID)").toString();
        String INSERT_TO_UPDATE_TABLE = new StringBuffer().append(" insert into {0} (FEntryID,FSourceBillEntryID,FFivouchered,FAccountType,FProcessCharge,FQty,FAfterEntryQty,FPricePrecision,FCostPrecision) ").append(" select distinct FEntryID,FSourceBillEntryID,FFivouchered,FAccountType,FProcessCharge,FQty,FAfterEntryQty,FPricePrecision,FCostPrecision ").append(" from {1} ").toString();
        String UPDATEMATERIALCOST_TO_UPDATE_TABLE = new StringBuffer().append(" update {0} t set (FMaterialCost) = ( select FMaterialCost from ").append(" (select  ").append(" sum(case FManualActualCost when 0 then FIssueActualCost*FRate else FManualActualCost end) as FMaterialCost,FEntryID ").append(" from {1} Group by FEntryID) t1  ").append(" where t.FEntryID = t1.FEntryID )").toString();
        String UPDATE_ACTUALCOST_TO_UPDATE_TABLE = new StringBuffer().append(" update {0} set FActualCost = round((isnull(FProcessCharge,0) + isnull(FMaterialCost,0))*(FQty/FAfterEntryQty) ,isnull(FCostPrecision,2)) , ").append(" FUnitActualCost = round(TO_DECIMAL(round((isnull(FProcessCharge,0) + isnull(FMaterialCost,0))*(FQty/FAfterEntryQty) ,isnull(FCostPrecision,2)) / FQty, 21,8), FPricePrecision)").toString();
        String UPDATE_ACTUALCOST = new StringBuffer().append("update T_IM_OtherInwarehsBillEntry as entry set (FActualCost, FUnitActualCost) = ").append("(select FActualCost,FUnitActualCost from (select FActualCost,FUnitActualCost,updateTable.FEntryID from {0} updateTable ").append(" where updateTable.FFivouchered = 0 and updateTable.FAccountType <> 1 ").append(" and updateTable.FActualCost >= 0 and updateTable.FUnitActualCost >=0 ) temp where entry.fid = temp.FEntryID) ").toString();
        String GET_ADJUSTCOST_BILL_SQL = new StringBuffer().append(" select entry.FParentId, entry.FId, bill.FNumber,entry.FMaterialId, inWarehs.FPricePrecision, ").append(" bill.FBillTypeId, entry.FSupplierId, inWarehs.FActualCost - entry.FActualCost as FDiffAmount, ").append(" entry.FStorageOrgUnitId, entry.FWarehouseId, entry.FLocationid ,entry.FBaseUnitId, entry.FLot, entry.FAssistPropertyID, entry.FProjectID, ").append(" entry.FTrackNumberID, entry.FSeq , bill.FAdminOrgUnitID, bill.FCostCenterOrgUnitID ").append(" from {0} as inWarehs inner join T_IM_OtherInwarehsBillEntry as entry on entry.FId = inWarehs.FEntryID ").append(" inner join T_IM_OtherInwarehsBill bill on entry.FParentId = bill.FId ").append(" where inWarehs.FFivouchered = 1 or inWarehs.FAccountType = 1").toString();
        CalculateParams result = new CalculateParams();
        this.initParams(ctx, params);
        String inWarehsTempTable = null;
        String updateInWarehsTempTable = null;
        String sumManualCostTempTable = null;
        IRowSet rowSet = null;
        IRowSet checkRS = null;
        IRowSet delRS = null;
        ICostAdjustBill costadjust = CostAdjustBillFactory.getLocalInstance(ctx);
        try {
            ThreadLocalHelper.checkInterruptedForInCalc();
            if (CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                IRowSet row = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)this.companyOrgID, (boolean)false);
                if (row.size() > 0) {
                    StringBuffer msg = new StringBuffer();
                    while (row.next()) {
                        msg.append("\n").append(row.getString("fbilltype")).append(row.getString("fnumber")).append(",").append(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"operatorInfo", (Locale)ctx.getLocale())).append(row.getString("fuser"));
                    }
                    throw new CalculateException(CalculateException.IS_GEN_VOUCHER_EXCEPTION, new Object[]{msg});
                }
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"insertGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, List.class, String.class, String.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, null, null, ctx.getUserName(), CalInEnum.MATASSEMBLECAL.getName()}, (int)3);
            }
            String IDFilter = this.getFilterByParams(params, 0);
            String sSQL = MessageFormat.format(CHECK_BEFORE_ADCOST_SQL, IDFilter, String.valueOf(14), String.valueOf(15));
            logger.debug((Object)("\u83b7\u53d6\u4ee5\u524d\u521b\u5efa\u7c7b\u578b\u4e3a\u7684\u6210\u672c\u8c03\u6574\u5355ID: \n" + sSQL));
            checkRS = DBUtil.executeQuery((Context)ctx, (String)sSQL);
            StringBuffer voucheredNumber = new StringBuffer();
            while (checkRS.next()) {
                if (voucheredNumber.length() > 0) {
                    voucheredNumber.append(",");
                }
                voucheredNumber.append(checkRS.getString("fnumber"));
            }
            SQLUtils.cleanup((ResultSet)checkRS);
            if (voucheredNumber.length() > 0) {
                throw new CalculateException(CalculateException.COST_IS_VOUCHERED, new String[]{voucheredNumber.toString()});
            }
            sSQL = MessageFormat.format(GET_DELETE_BEFORE_ADCOST_SQL, IDFilter, String.valueOf(14), String.valueOf(15));
            delRS = DBUtil.executeQuery((Context)ctx, (String)sSQL);
            ObjectUuidPK costID = null;
            while (delRS.next()) {
                costID = new ObjectUuidPK(delRS.getString("fid"));
                costadjust.unAudit((IObjectPK)costID);
                costadjust.delete((IObjectPK)costID);
            }
            SQLUtils.cleanup((ResultSet)delRS);
            inWarehsTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getInWarehsTableFields());
            DBUtil.createTempTableIndex(ctx, inWarehsTempTable, "FEntryID", false);
            DBUtil.createTempTableIndex(ctx, inWarehsTempTable, "FSourceBillEntryID", false);
            ThreadLocalHelper.checkInterruptedForInCalc();
            updateInWarehsTempTable = DBUtil.createTempTable(ctx, "INWAREHSBILL", this.getUpdateInWarehsFields());
            DBUtil.createTempTableIndex(ctx, updateInWarehsTempTable, "FEntryID", false);
            sumManualCostTempTable = DBUtil.createTempTable(ctx, "manualicost", this.getSumManualCostTableFields());
            DBUtil.createTempTableIndex(ctx, sumManualCostTempTable, "FSourceBillEntryID", false);
            String filter = this.getFilterByParams(params, 1);
            sSQL = MessageFormat.format(INSERT_INWAREHSBILL_SQL, inWarehsTempTable, filter);
            DBUtil.execute((Context)ctx, (String)sSQL);
            filter = this.getFilterByParams(params, 2);
            sSQL = MessageFormat.format(INSERT_INWAREHSBILL_SQL2, inWarehsTempTable, filter);
            DBUtil.execute((Context)ctx, (String)sSQL);
            if (!params.getBoolean("ONE_KEY_CALC")) {
                String info = this.checkZeroCostBill(ctx, inWarehsTempTable);
                result.setString("hasZeroEntryOtherBill", info);
                this.checkCanCalculate(ctx, inWarehsTempTable);
                logger.debug((Object)"\u5355\u636e\u6821\u9a8c\u901a\u8fc7\uff0c\u5f00\u59cb\u7ec4\u88c5\u5165\u5e93\u7684\u6210\u672c\u6838\u7b97\u5904\u7406\u3002\u3002\u3002");
            }
            sSQL = MessageFormat.format(INSERT_TO_MANUALCOST_TABLE, sumManualCostTempTable, inWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_INWAREHS_ACTUALCOST_SQL, inWarehsTempTable, sumManualCostTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(INSERT_TO_UPDATE_TABLE, updateInWarehsTempTable, inWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            sSQL = MessageFormat.format(UPDATEMATERIALCOST_TO_UPDATE_TABLE, updateInWarehsTempTable, inWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            sSQL = MessageFormat.format(UPDATE_ACTUALCOST_TO_UPDATE_TABLE, updateInWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)sSQL);
            String executeSql = MessageFormat.format(UPDATE_ACTUALCOST, updateInWarehsTempTable);
            DBUtil.execute((Context)ctx, (String)executeSql);
            String errorNumber = this.dealTail(ctx, updateInWarehsTempTable);
            if (errorNumber.length() > 0) {
                result.setString("errorNumber", errorNumber);
            }
            sSQL = MessageFormat.format(GET_ADJUSTCOST_BILL_SQL, updateInWarehsTempTable);
            rowSet = DBUtil.executeQuery((Context)ctx, (String)sSQL);
            ThreadLocalHelper.checkInterruptedForInCalc();
            logger.debug((Object)"\u751f\u6210\u6210\u672c\u8c03\u6574\u5355");
            ArrayList billList = new ArrayList();
            while (rowSet.next()) {
                CostAdjustBillInfo bill = this.createAdCostBill(ctx, billList, rowSet);
                this.createAdCostBillEntry(rowSet, bill);
            }
            logger.debug((Object)"\u4fdd\u5b58\u5e76\u5ba1\u6838\u6210\u672c\u8c03\u6574\u5355");
            for (int i = 0; i < billList.size(); ++i) {
                CostAdjustBillInfo costInfo = (CostAdjustBillInfo)billList.get(i);
                if (costInfo.getEntry().size() <= 0) continue;
                IObjectPK id = costadjust.addnew((CoreBaseInfo)costInfo);
                costadjust.audit(id);
            }
        }
        catch (Exception e) {
            try {
                if (!params.getBoolean("ONE_KEY_CALC")) {
                    if (e instanceof EASBizException) {
                        throw (EASBizException)((Object)e);
                    }
                    throw new BOSException((Throwable)e);
                }
                result.setObject("calcException", (Object)e);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, inWarehsTempTable);
                DBUtil.releaseTempTable(ctx, updateInWarehsTempTable);
                DBUtil.releaseTempTable(ctx, sumManualCostTempTable);
                SQLUtils.cleanup(rowSet);
                SQLUtils.cleanup(checkRS);
                SQLUtils.cleanup(delRS);
                EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, CalInEnum.MATASSEMBLECAL.getName()}, (int)3);
                throw throwable;
            }
            DBUtil.releaseTempTable(ctx, inWarehsTempTable);
            DBUtil.releaseTempTable(ctx, updateInWarehsTempTable);
            DBUtil.releaseTempTable(ctx, sumManualCostTempTable);
            SQLUtils.cleanup(rowSet);
            SQLUtils.cleanup(checkRS);
            SQLUtils.cleanup(delRS);
            EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, CalInEnum.MATASSEMBLECAL.getName()}, (int)3);
        }
        DBUtil.releaseTempTable(ctx, inWarehsTempTable);
        DBUtil.releaseTempTable(ctx, updateInWarehsTempTable);
        DBUtil.releaseTempTable(ctx, sumManualCostTempTable);
        SQLUtils.cleanup((ResultSet)rowSet);
        SQLUtils.cleanup((ResultSet)checkRS);
        SQLUtils.cleanup((ResultSet)delRS);
        EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, this.companyOrgID, null, CalInEnum.MATASSEMBLECAL.getName()}, (int)3);
        return result;
    }

    private String checkZeroCostBill(Context ctx, String inWarehsTempTable) throws BOSException {
        StringBuffer numSB = new StringBuffer();
        String sql = MessageFormat.format(this.IS_ACTUALCOST_EQUALS_ZERO, inWarehsTempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                numSB.append(rs.getString("FNumber")).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String info = null;
        if (rs.size() > 0) {
            info = MessageFormat.format(CalculateUtil.getCalServerResource(ctx, "BILLCOSTNULL"), numSB);
        }
        return info;
    }

    protected void checkCanCalculate(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer numSB = new StringBuffer("\n");
        try {
            numSB.setLength(1);
            String sql = MessageFormat.format(this.IS_OLD_PERIOD, tempTable, String.valueOf(this.currPeriod));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                numSB.append(rs.getString("FNumber")).append("\n");
            }
            if (rs.size() > 0) {
                throw new CalculateException(CalculateException.BILL_IS_OLDPERIOD, new String[]{numSB.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getFilterByParams(CalculateParams params, int isAssemble) {
        FilterInfo filter = new FilterInfo();
        List idList = (List)params.getObject("BILL_ID");
        List entryIdList = (List)params.getObject("ENTRY_ID");
        HashSet idSet = new HashSet();
        String adjFilter = "bill.FSourceBillID";
        String billFilter = "bill.FID";
        if (entryIdList != null) {
            adjFilter = "entry.FSourceBillEntryID";
            billFilter = "entry.FID";
            idSet.addAll(entryIdList);
        } else {
            idSet.addAll(idList);
        }
        if (isAssemble == 0) {
            filter.getFilterItems().add(new FilterItemInfo(adjFilter, idSet, CompareType.INCLUDE));
        } else {
            filter.getFilterItems().add(new FilterItemInfo(billFilter, idSet, CompareType.INCLUDE));
        }
        if (isAssemble == 1) {
            filter.getFilterItems().add(new FilterItemInfo("bill.FBizTypeID", (Object)"CJeXjSzsKhfgU0ETqMA1niQHQ1w=", CompareType.EQUALS));
        } else if (isAssemble == 2) {
            filter.getFilterItems().add(new FilterItemInfo("bill.FBizTypeID", (Object)"CJewLHpMKe/gU0ETqMDApyQHQ1w=", CompareType.EQUALS));
        }
        return filter.toString();
    }

    private String[][] getInWarehsTableFields() {
        String[][] fields = new String[][]{{"FBillID", "varchar(44)"}, {"FEntryID", "varchar(44)"}, {"FSeq", "int"}, {"FSourceBillEntryID", "varchar(44)"}, {"FNumber", "varchar(44)"}, {"FYear", "int"}, {"FPeriod", "int"}, {"FMaterialID", "varchar(44)"}, {"FPricePrecision", "int"}, {"FCostPrecision", "int"}, {"FQty", "decimal(21, 8)"}, {"FAfterEntryQty", "decimal(21, 8)"}, {"FBaseQty", "decimal(21, 8)"}, {"FIssueActualCost", "decimal(21, 8)"}, {"FFivouchered", "int"}, {"FAccountType", "int"}, {"FOldInActualCost", "decimal(21, 8)"}, {"FManualActualCost", "decimal(21, 8) DEFAULT 0 NOT NULL"}, {"FProcessCharge", "decimal(21, 8) DEFAULT 0 NOT NULL"}, {"FRate", "decimal(21, 8) DEFAULT 1 NOT NULL"}};
        return fields;
    }

    public String[][] getUpdateInWarehsFields() {
        String[][] fields = new String[][]{{"FEntryID", "varchar(44)"}, {"FSourceBillEntryID", "varchar(44)"}, {"FActualCost", "decimal(17, 4)"}, {"FUnitActualCost", "decimal(21,8)"}, {"FAccountType", "int"}, {"FFivouchered", "int"}, {"FManualActualCost", "decimal(21, 8) DEFAULT 0 NOT NULL"}, {"FProcessCharge", "decimal(17,4)"}, {"FMaterialCost", "decimal(17,4)"}, {"FQty", "decimal(21, 8)"}, {"FAfterEntryQty", "decimal(21, 8)"}, {"FPricePrecision", "decimal(21,8)"}, {"FCostPrecision", "decimal(21,8)"}};
        return fields;
    }

    public String[][] getSumManualCostTableFields() {
        String[][] fields = new String[][]{{"FSourceBillEntryID", "varchar(44)"}, {"FSumManualCost", "decimal(17, 4)"}};
        return fields;
    }

    protected void initParams(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        this.companyOrgID = params.getString("COMPANY_ID");
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        try {
            companyOrgUnitInfo.setId(BOSUuid.read((String)this.companyOrgID));
        }
        catch (Exception e) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
        if (this.periodInfo == null) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
        }
        this.currPeriod = this.periodInfo.getPeriodYear() * 100 + this.periodInfo.getPeriodNumber();
    }

    private CostAdjustBillInfo createAdCostBill(Context ctx, List billList, IRowSet rowSet) throws SQLException {
        CostAdjustBillInfo costBill = null;
        for (int i = 0; i < billList.size(); ++i) {
            costBill = (CostAdjustBillInfo)billList.get(i);
            if (!costBill.getSourceBillId().equals(rowSet.getString("FParentId"))) continue;
            return costBill;
        }
        costBill = new CostAdjustBillInfo();
        costBill.setId(BOSUuid.create((BOSObjectType)costBill.getBOSType()));
        costBill.setNumber(String.valueOf(System.currentTimeMillis()));
        costBill.setIssueType(IssueTypeEnum.NULL);
        costBill.setCalculateKind(CalculateKindEnum.INPUT_WAREHOUSE);
        SupplierInfo supplier = null;
        String supplierId = rowSet.getString("FSupplierId");
        if (supplierId != null) {
            supplier = new SupplierInfo();
            supplier.setId(BOSUuid.read((String)supplierId));
        }
        costBill.setSupplier(supplier);
        StorageOrgUnitInfo storage = null;
        String storageId = rowSet.getString("FStorageOrgUnitId");
        if (storageId != null) {
            storage = new StorageOrgUnitInfo();
            storage.setId(BOSUuid.read((String)storageId));
        }
        costBill.setStorageOrgUnit(storage);
        BillTypeInfo billType = new BillTypeInfo();
        billType.setId(BOSUuid.read((String)"3a3b5446-0106-1000-e000-01bcc0a812e6463ED552"));
        costBill.setBillType(billType);
        BillTypeInfo sourceBillType = null;
        String billTypeId = rowSet.getString("FBillTypeId");
        if (billTypeId != null) {
            sourceBillType = new BillTypeInfo();
            sourceBillType.setId(BOSUuid.read((String)billTypeId));
        }
        costBill.setSourceBillType(sourceBillType);
        if ("CJeXjSzrKhfgU0ETqMA1nkY+1VI=".equals(billTypeId)) {
            costBill.setCreateType(CostAdjuestCreateTypeEnum.ASSEMBLE_COST_CALC);
        } else {
            costBill.setCreateType(CostAdjuestCreateTypeEnum.DISASSEMBLE_COST_CALC);
        }
        AdminOrgUnitInfo adminOrg = null;
        String adminOrgId = rowSet.getString("FAdminOrgUnitId");
        if (adminOrgId != null) {
            adminOrg = new AdminOrgUnitInfo();
            adminOrg.setId(BOSUuid.read((String)adminOrgId));
        }
        costBill.setAdminOrgUnit(adminOrg);
        CostCenterOrgUnitInfo costCenter = null;
        String costCenterId = rowSet.getString("FCostCenterOrgUnitId");
        if (costCenterId != null) {
            costCenter = new CostCenterOrgUnitInfo();
            costCenter.setId(BOSUuid.read((String)costCenterId));
        }
        costBill.setCostCenterOrgUnit(costCenter);
        costBill.setYear(this.periodInfo.getPeriodYear());
        costBill.setPeriod(this.periodInfo.getPeriodNumber());
        costBill.setBizDate(this.periodInfo.getBeginDate());
        costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        costBill.setCreateTime(new Timestamp(System.currentTimeMillis()));
        costBill.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        costBill.setAuditTime(new Timestamp(System.currentTimeMillis()));
        costBill.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        costBill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        costBill.setSourceBillId(rowSet.getString("FParentId"));
        billList.add(costBill);
        return costBill;
    }

    private void createAdCostBillEntry(IRowSet rowSet, CostAdjustBillInfo costBillInfo) throws SQLException {
        BigDecimal diffAmount = rowSet.getBigDecimal("FDiffAmount");
        if (diffAmount.compareTo(CalculateUtil.ZERO) != 0) {
            CostAdjustBillEntryInfo costBillEntryInfo = new CostAdjustBillEntryInfo();
            costBillEntryInfo.setId(BOSUuid.create((BOSObjectType)costBillEntryInfo.getBOSType()));
            costBillEntryInfo.setParent(costBillInfo);
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)this.companyOrgID));
            costBillEntryInfo.setCompanyOrgUnit(company);
            StorageOrgUnitInfo storage = null;
            String storageId = rowSet.getString("FStorageOrgUnitId");
            if (storageId != null) {
                storage = new StorageOrgUnitInfo();
                storage.setId(BOSUuid.read((String)storageId));
            }
            costBillEntryInfo.setStorageOrgUnit(storage);
            WarehouseInfo warehouse = null;
            String warehouseId = rowSet.getString("FWarehouseId");
            if (warehouseId != null) {
                warehouse = new WarehouseInfo();
                warehouse.setId(BOSUuid.read((String)warehouseId));
            }
            costBillEntryInfo.setWarehouse(warehouse);
            LocationInfo location = null;
            String locationId = rowSet.getString("FLocationid");
            if (locationId != null) {
                location = new LocationInfo();
                location.setId(BOSUuid.read((String)locationId));
            }
            costBillEntryInfo.setLocation(location);
            MaterialInfo material = null;
            String materialId = rowSet.getString("FMaterialId");
            if (materialId != null) {
                material = new MaterialInfo();
                material.setId(BOSUuid.read((String)materialId));
            }
            costBillEntryInfo.setMaterial(material);
            MeasureUnitInfo baseUnit = null;
            String baseUnitId = rowSet.getString("FBaseUnitId");
            if (baseUnitId != null) {
                baseUnit = new MeasureUnitInfo();
                baseUnit.setId(BOSUuid.read((String)baseUnitId));
            }
            costBillEntryInfo.setBaseUnit(baseUnit);
            costBillEntryInfo.setUnit(baseUnit);
            AsstAttrValueInfo assistProperty = null;
            String assistPropertyId = rowSet.getString("FAssistPropertyID");
            if (assistPropertyId != null) {
                assistProperty = new AsstAttrValueInfo();
                assistProperty.setId(BOSUuid.read((String)assistPropertyId));
            }
            costBillEntryInfo.setAssistProperty(assistProperty);
            ProjectInfo project = null;
            String projectId = rowSet.getString("FProjectID");
            if (projectId != null) {
                project = new ProjectInfo();
                project.setId(BOSUuid.read((String)projectId));
            }
            costBillEntryInfo.setProject(project);
            TrackNumberInfo trackNumber = null;
            String trackNumberId = rowSet.getString("FTrackNumberID");
            if (trackNumberId != null) {
                trackNumber = new TrackNumberInfo();
                trackNumber.setId(BOSUuid.read((String)trackNumberId));
            }
            costBillEntryInfo.setTrackNumber(trackNumber);
            StoreTypeInfo storeType = new StoreTypeInfo();
            storeType.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-0111c0a812fd97D461A6"));
            costBillEntryInfo.setStoreType(storeType);
            StoreStateInfo storeState = new StoreStateInfo();
            storeState.setId(BOSUuid.read((String)"181875d5-0105-1000-e000-012ec0a812fd62A73FA5"));
            costBillEntryInfo.setStoreStatus(storeState);
            costBillEntryInfo.setLot(rowSet.getString("FLot"));
            costBillEntryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            costBillEntryInfo.setSourceBillId(rowSet.getString("FParentId"));
            costBillEntryInfo.setSourceBillEntryId(rowSet.getString("FId"));
            costBillEntryInfo.setSourceBillNumber(rowSet.getString("FNumber"));
            costBillEntryInfo.setSourceBillEntrySeq(rowSet.getInt("FSeq"));
            costBillEntryInfo.setBaseQty(new BigDecimal("0.0"));
            costBillEntryInfo.setAmount(diffAmount);
            costBillEntryInfo.setStandardCost(diffAmount);
            costBillEntryInfo.setActualCost(diffAmount);
            costBillEntryInfo.setBizDate(costBillInfo.getBizDate());
            costBillInfo.getEntry().add(costBillEntryInfo);
        }
    }

    private String dealTail(Context ctx, String tempTable) throws BOSException, SQLException {
        List<Map<String, BigDecimal>> innerList;
        Map<String, BigDecimal> inEntry;
        StringBuffer errorNumber = new StringBuffer();
        String sSQL = MessageFormat.format(this.DEAL_TAIL, tempTable, String.valueOf(this.currPeriod));
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sSQL);
        HashMap outMap = new HashMap();
        while (rs.next()) {
            inEntry = new HashMap<String, Object>();
            inEntry.put("FID", (BigDecimal)((Object)rs.getString("FID")));
            inEntry.put("FQTY", rs.getBigDecimal("FQTY"));
            inEntry.put("FACTUALCOST", rs.getBigDecimal("FACTUALCOST"));
            inEntry.put("FNUMBER", (BigDecimal)((Object)rs.getString("FNUMBER")));
            inEntry.put("FSOURCEBILLENTRYID", (BigDecimal)((Object)rs.getString("FSOURCEBILLENTRYID")));
            inEntry.put("FINENTRYID", (BigDecimal)((Object)rs.getString("FINENTRYID")));
            inEntry.put("FALLINQTY", rs.getBigDecimal("FALLINQTY"));
            inEntry.put("FFIVOUCHERED", (BigDecimal)((Object)Integer.valueOf(rs.getInt("FFIVOUCHERED"))));
            inEntry.put("FPERIOD", (BigDecimal)((Object)Integer.valueOf(rs.getInt("FPERIOD"))));
            inEntry.put("FPROCESSCHARGE", rs.getBigDecimal("FPROCESSCHARGE"));
            inEntry.put("FOUTACTUALCOST", rs.getBigDecimal("FOUTACTUALCOST"));
            inEntry.put("FPRICEPRECISION", (BigDecimal)((Object)Integer.valueOf(rs.getInt("FPRICEPRECISION"))));
            inEntry.put("FCOSTRATE", (BigDecimal)((Object)Integer.valueOf(rs.getInt("FCOSTRATE"))));
            if (outMap.containsKey(rs.getString("FSOURCEBILLENTRYID"))) {
                innerList = (List)outMap.get(rs.getString("FSOURCEBILLENTRYID"));
                innerList.add(inEntry);
                continue;
            }
            innerList = new ArrayList<Map<String, BigDecimal>>();
            innerList.add(inEntry);
            outMap.put(rs.getString("FSOURCEBILLENTRYID"), innerList);
        }
        BigDecimal allInQty = CalculateUtil.ZERO;
        BigDecimal allCost = CalculateUtil.ZERO;
        BigDecimal sumInQty = CalculateUtil.ZERO;
        BigDecimal sumCost = CalculateUtil.ZERO;
        BigDecimal dealTailCost = CalculateUtil.ZERO;
        int dealTailIndex = -1;
        ArrayList needUpdate = new ArrayList();
        BigDecimal maxCost = CalculateUtil.ZERO;
        for (Map.Entry entry : outMap.entrySet()) {
            innerList = (ArrayList<Map<String, BigDecimal>>)entry.getValue();
            allCost = (BigDecimal)((Map)innerList.get(0)).get("FOUTACTUALCOST");
            if (((Map)innerList.get(0)).get("FPROCESSCHARGE") != null) {
                allCost = allCost.add((BigDecimal)((Map)innerList.get(0)).get("FPROCESSCHARGE"));
            }
            ArrayList<String> inEntryIdList = new ArrayList<String>();
            for (int i = 0; i < innerList.size(); ++i) {
                inEntry = (Map)innerList.get(i);
                if (!inEntryIdList.contains(inEntry.get("FINENTRYID").toString())) {
                    allInQty = allInQty.add((BigDecimal)((Map)innerList.get(i)).get("FALLINQTY"));
                    inEntryIdList.add(inEntry.get("FINENTRYID").toString());
                }
                sumInQty = sumInQty.add((BigDecimal)inEntry.get("FQTY"));
                sumCost = sumCost.add((BigDecimal)inEntry.get("FACTUALCOST"));
                if (Integer.parseInt(inEntry.get("FFIVOUCHERED").toString()) != 0 || Integer.parseInt(inEntry.get("FPERIOD").toString()) != this.currPeriod || Integer.parseInt(inEntry.get("FCOSTRATE").toString()) == 0 || maxCost.compareTo((BigDecimal)inEntry.get("FACTUALCOST")) >= 0 && maxCost.compareTo(CalculateUtil.ZERO) != 0) continue;
                maxCost = (BigDecimal)inEntry.get("FACTUALCOST");
                dealTailIndex = i;
            }
            if (allInQty.compareTo(sumInQty) == 0 && dealTailIndex != -1) {
                dealTailCost = allCost.subtract(sumCost.subtract((BigDecimal)((Map)innerList.get(dealTailIndex)).get("FACTUALCOST")));
                if (dealTailCost.compareTo(CalculateUtil.ZERO) < 0) {
                    errorNumber.append(((Map)innerList.get(dealTailIndex)).get("FNUMBER").toString()).append(",");
                    sumInQty = CalculateUtil.ZERO;
                    sumCost = CalculateUtil.ZERO;
                    allInQty = CalculateUtil.ZERO;
                    allCost = CalculateUtil.ZERO;
                    continue;
                }
                ((Map)innerList.get(dealTailIndex)).put("FACTUALCOST", dealTailCost);
                ((Map)innerList.get(dealTailIndex)).put("FUNITACTUALCOST", dealTailCost.divide((BigDecimal)((Map)innerList.get(dealTailIndex)).get("FQTY"), Integer.parseInt(((Map)innerList.get(dealTailIndex)).get("FPRICEPRECISION").toString()), RoundingMode.HALF_UP));
                needUpdate.add(innerList.get(dealTailIndex));
            }
            sumInQty = CalculateUtil.ZERO;
            sumCost = CalculateUtil.ZERO;
            allInQty = CalculateUtil.ZERO;
            allCost = CalculateUtil.ZERO;
            dealTailIndex = -1;
            maxCost = CalculateUtil.ZERO;
        }
        if (needUpdate.size() > 0) {
            ArrayList<Object[]> paramlist = new ArrayList<Object[]>();
            for (int i = 0; i < needUpdate.size(); ++i) {
                ArrayList execParams = new ArrayList();
                execParams.add(((Map)needUpdate.get(i)).get("FACTUALCOST"));
                execParams.add(((Map)needUpdate.get(i)).get("FUNITACTUALCOST"));
                execParams.add(((Map)needUpdate.get(i)).get("FID"));
                paramlist.add(execParams.toArray());
            }
            String updateSql = "update T_IM_OtherInwarehsBillEntry set FACTUALCOST = ?,FUNITACTUALCOST=? where fid = ?";
            DBUtil.executeBatch((Context)ctx, (String)updateSql, paramlist);
        }
        if (errorNumber.length() > 0) {
            return errorNumber.substring(0, errorNumber.length() - 1);
        }
        return "";
    }
}

