/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.cal.app.AbstractMoveLocationUpdateFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import org.apache.log4j.Logger;

public class MoveLocationUpdateFacadeControllerBean
extends AbstractMoveLocationUpdateFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.MoveLocationUpdateFacadeControllerBean");
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.UpdateBillResource";

    @Override
    protected HashMap _updateBill(Context ctx, HashMap params) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (((Boolean)params.get("isManual")).booleanValue()) {
            this.manalUpdateBill(ctx, params, result);
        } else {
            String tempTable = DBUtil.createTempTable(ctx, this.getCreateTableSql());
            params.put("tempTable", tempTable);
            this.updateBillCost(ctx, params, result);
        }
        return result;
    }

    private void manalUpdateBill(Context ctx, HashMap params, HashMap result) throws EASBizException, BOSException {
        StringBuffer updateSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        BigDecimal price = (BigDecimal)params.get("price");
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.get("companyInfo");
        int yearFrom = (Integer)params.get("yearFrom");
        int periodFrom = (Integer)params.get("periodFrom");
        int yearTo = (Integer)params.get("yearTo");
        int periodTo = (Integer)params.get("periodTo");
        PeriodInfo fromPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearFrom, (int)periodFrom, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo toPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearTo, (int)periodTo, (CompanyOrgUnitInfo)companyInfo);
        MaterialInfo materialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(params.get("materialId").toString()));
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()));
        BigDecimal minValueByScale = RecentCostHelp.getMinValueByScale(currencyInfo.getPrecision(), 1);
        updateSql.append(" UPDATE T_IM_MOVELOCATIONBILLENTRY SET FPRICE = Round(").append(price).append(",").append(materialInfo.getPricePrecision()).append("), ");
        updateSql.append(" FAMOUNT = case when Round(FQTY*").append(price).append(",").append(currencyInfo.getPrecision()).append(") = 0 and ").append(price).append(" <> 0");
        updateSql.append(" then ").append(minValueByScale).append(" else Round(FQTY*").append(price).append(",").append(currencyInfo.getPrecision()).append(") end");
        whereSql.append(" where Entry.FCOMPANYORGUNITID = '").append(companyInfo.getId()).append("' ");
        whereSql.append(" and Entry.FMATERIALID = '").append(params.get("materialId")).append("' ");
        whereSql.append(" and Entry.FBIZDATE >= to_date('").append(fromPeriodInfo.getBeginDate()).append("') ");
        whereSql.append(" and Entry.FBIZDATE <= to_date('").append(toPeriodInfo.getEndDate()).append("') ");
        whereSql.append(" and Bill.FBASESTATUS = 4 ");
        if (params.get("storageId") != null) {
            whereSql.append(" and Entry.FSTORAGEORGUNITID ='").append(params.get("storageId")).append("'");
        }
        if (params.get("warehouseId") != null) {
            whereSql.append(" and Entry.FWAREHOUSEID ='").append(params.get("warehouseId")).append("'");
        }
        if (params.get("lot") != null && !"".equals(params.get("lot"))) {
            whereSql.append(" and Entry.FLOT =").append(params.get("lot"));
        }
        if (params.get("assistProperty") != null) {
            whereSql.append(" and Entry.FASSISTPROPERTYID ='").append(params.get("assistProperty")).append("'");
        }
        if (params.get("project") != null) {
            whereSql.append(" and Entry.FPROJECTID ='").append(params.get("project")).append("'");
        }
        if (params.get("trackNum") != null) {
            whereSql.append(" and Entry.FTRACKNUMBERID ='").append(params.get("trackNum")).append("'");
        }
        StringBuffer fromAndWhereSql = new StringBuffer();
        fromAndWhereSql.append(" from T_IM_MOVELOCATIONBILLENTRY Entry");
        fromAndWhereSql.append(" inner join T_IM_MOVELOCATIONBILL Bill on Entry.fparentid = Bill.fid");
        fromAndWhereSql.append(" inner join T_IM_STORETYPE Store on Entry.FSTORETYPEID = store.FID ");
        fromAndWhereSql.append(whereSql).append(" and Store.FISFORWARDAMT = 1 ");
        StringBuffer getBillNumberSql = new StringBuffer();
        getBillNumberSql.append(" select distinct Bill.fnumber ").append(fromAndWhereSql.toString());
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getBillNumberSql.toString());
        updateSql.append(" where fid in ( select Entry.fid ").append(fromAndWhereSql).append(")");
        DBUtil.execute((Context)ctx, (String)updateSql.toString());
        StringBuffer updateNum = new StringBuffer();
        try {
            while (rs.next()) {
                updateNum.append(rs.getString("fnumber")).append("\n");
            }
            result.put("resultMsg", updateNum.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateBillCost(Context ctx, HashMap params, HashMap result) throws EASBizException, BOSException {
        int yearFrom = (Integer)params.get("yearFrom");
        int periodFrom = (Integer)params.get("periodFrom");
        int yearTo = (Integer)params.get("yearTo");
        int periodTo = (Integer)params.get("periodTo");
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.get("companyInfo");
        CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyInfo.getBaseCurrency().getId()));
        params.put("currencyPrecision", currencyInfo.getPrecision());
        PeriodInfo fromPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearFrom, (int)periodFrom, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo toPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (int)yearTo, (int)periodTo, (CompanyOrgUnitInfo)companyInfo);
        StringBuffer insertSql = new StringBuffer();
        ArrayList insertSqlList = new ArrayList();
        Object rs = null;
        HashSet billNumSet = new HashSet();
        String tempTable = null;
        String billTable = null;
        try {
            billTable = this.getBillTable(ctx, params);
            tempTable = DBUtil.createTempTable(ctx, this.getCreateTableSql());
            params.put("tempTable", tempTable);
            while (fromPeriodInfo.getNumber() <= toPeriodInfo.getNumber()) {
                insertSql.append(this.getInsertSql(companyInfo, fromPeriodInfo, params)).append(";\n");
                if ((fromPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)fromPeriodInfo)) != null) continue;
            }
            DBUtil.execute((Context)ctx, (String)insertSql.toString());
            DBUtil.execute((Context)ctx, (String)this.getUpdateSql(tempTable, billTable, currencyInfo.getPrecision()));
            this.afterUpdateBill(ctx, params, billTable, result);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, tempTable);
                DBUtil.releaseTempTable(ctx, billTable);
                throw throwable;
            }
        }
        DBUtil.releaseTempTable(ctx, tempTable);
        DBUtil.releaseTempTable(ctx, billTable);
    }

    private String getBillTable(Context ctx, HashMap params) throws BOSException {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table tempTableName (");
        createSql.append(" FENTRYID varchar(44), FNUMBER nvarchar(255),");
        createSql.append(" FPRICE NUMERIC(21,8) DEFAULT 0 NOT NULL , FAMOUNT NUMERIC(21,8) DEFAULT 0 NOT NULL )");
        String billTable = DBUtil.createTempTable(ctx, createSql.toString());
        int dete1 = (Integer)params.get("yearFrom") * 100 + (Integer)params.get("periodFrom");
        int dete2 = (Integer)params.get("yearTo") * 100 + (Integer)params.get("periodTo");
        String dateFrom = dete1 + "";
        String dateTo = dete2 + "";
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.get("companyInfo");
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(billTable).append(" (");
        insertSql.append(" FENTRYID, FNUMBER, FPRICE, FAMOUNT)");
        insertSql.append("select entry.fid,bill.fnumber, entry.fprice, entry.famount from T_IM_MOVELOCATIONBILL bill ");
        insertSql.append(" inner join T_IM_MOVELOCATIONBILLENTRY entry on entry.fparentid = bill.fid ");
        insertSql.append(" inner join T_IM_STORETYPE store on entry.FSTORETYPEID = store.FID ");
        insertSql.append(" where bill.fbasestatus = 4 and store.FISFORWARDAMT = 1 and entry.FCOMPANYORGUNITID ='").append(companyInfo.getId()).append("' ");
        insertSql.append(" and (bill.FYEAR*100+bill.FPERIOD) >= ").append(dateFrom).append(" and (bill.FYEAR*100+bill.FPERIOD) <= ").append(dateTo);
        DBUtil.execute((Context)ctx, (String)insertSql.toString());
        return billTable;
    }

    private String getCreateTableSql() {
        StringBuffer createSql = new StringBuffer();
        createSql.append("create table tempTableName (");
        createSql.append(" FCOMPANYORGUNITID varchar(44), FSTORAGEORGUNITID varchar(44),");
        createSql.append(" FWAREHOUSEID varchar(44), FMATERIALID varchar(44),");
        createSql.append(" FBEGINDATE datetime, FENDDATE datetime,");
        createSql.append(" FLot nvarchar(255), FASSISTPROPERTYID nvarchar(255), FPROJECTID nvarchar(255), FTRACKNUMBERID nvarchar(255),");
        createSql.append(" FPRECISION int, FPRICE NUMERIC(21,8) DEFAULT 0 NOT NULL ) ");
        return createSql.toString();
    }

    private String getInsertSql(CompanyOrgUnitInfo companyInfo, PeriodInfo curPeriodInfo, HashMap params) {
        StringBuffer selectSql = new StringBuffer();
        String tempTable = params.get("tempTable").toString();
        selectSql.append(this.getInsertSelectSql(tempTable));
        selectSql.append(" SELECT T.FCOMPANYORGUNITID, T.FSTORAGEORGUNITID, T.FWAREHOUSEID, T.FMATERIALID,");
        selectSql.append(" T.FLOT, T.FASSISTPROPERTYID, T.FPROJECTID, T.FTRACKNUMBERID, ");
        selectSql.append(" case when T.FPERIODENDQTY <> 0 then Round(T.FPERIODENDBALANCE/T.FPERIODENDQTY, T.FPRICEPRECISION) ");
        selectSql.append(" else case when T.FPERIODBEGINQTY <> 0 then Round(T.FPERIODBEGINBALANCE/T.FPERIODBEGINQTY, T.FPRICEPRECISION) ");
        selectSql.append(" else 0 end end, ");
        selectSql.append(" to_date('").append(curPeriodInfo.getBeginDate()).append("') as FBEGINDATE, ");
        selectSql.append(" to_date('").append(curPeriodInfo.getEndDate()).append("') as FENDDATE ");
        selectSql.append("  FROM (");
        selectSql.append(" SELECT T1.FCOMPANYORGUNITID, T1.FSTORAGEORGUNITID, T1.FWAREHOUSEID, T1.FMATERIALID, ");
        selectSql.append(" T1.FLot, T1.FASSISTPROPERTYID, T1.FPROJECTID, T1.FTRACKNUMBERID, ");
        selectSql.append(" SUM(T1.FPERIODBEGINQTY) as FPERIODBEGINQTY,SUM(T1.FPERIODENDQTY) as FPERIODENDQTY, ");
        selectSql.append(" SUM(T1.FPERIODBEGINBALANCE) as FPERIODBEGINBALANCE,SUM(T1.FPERIODENDBALANCE) as FPERIODENDBALANCE, ");
        selectSql.append(" T2.FPRICEPRECISION FROM T_IM_INVENTORYBALANCE T1 ");
        selectSql.append(" INNER JOIN T_BD_MATERIAL T2 ON T1.FMATERIALID = T2.FID ");
        selectSql.append(" where FCOMPANYORGUNITID = '").append(companyInfo.getId()).append("'");
        selectSql.append(" and FISCALCULATE = 1");
        selectSql.append(" and FPERIOD = ").append(curPeriodInfo.getPeriodNumber()).append(" and FYEAR = ").append(curPeriodInfo.getPeriodYear());
        selectSql.append(" Group by T1.FCOMPANYORGUNITID, T1.FSTORAGEORGUNITID, T1.FWAREHOUSEID, T1.FMATERIALID,");
        selectSql.append(" T1.FLOT, T1.FASSISTPROPERTYID, T1.FPROJECTID, T1.FTRACKNUMBERID, T2.FPRICEPRECISION ) T");
        return selectSql.toString();
    }

    private String getInsertSelectSql(String tempTable) {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(tempTable).append(" (");
        insertSql.append(" FCOMPANYORGUNITID, FSTORAGEORGUNITID, FWAREHOUSEID, FMATERIALID,");
        insertSql.append(" FLot, FASSISTPROPERTYID, FPROJECTID, FTRACKNUMBERID,");
        insertSql.append("  FPRICE, FBEGINDATE, FENDDATE) ");
        return insertSql.toString();
    }

    private void afterUpdateBill(Context ctx, HashMap params, String billTable, HashMap result) throws BOSException, SQLException {
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select bill.fnumber as fnumber , entry.fid as entryId,  ");
        selectSql.append(" T.fprice as priceBefore, entry.fprice as priceAfter, T.famount as amountBefore, entry.famount as amountAfter ");
        selectSql.append(" from T_IM_MOVELOCATIONBILL bill ");
        selectSql.append(" inner join T_IM_MOVELOCATIONBILLENTRY entry on entry.fparentid = bill.fid ");
        selectSql.append(" inner join ").append(billTable).append(" T on T.fentryid = entry.fid ");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        HashSet<String> updateBillNumSet = new HashSet<String>();
        HashSet<String> unUpdateBillNumSet = new HashSet<String>();
        StringBuffer updateNumber = new StringBuffer();
        StringBuffer unUpdateNumber = new StringBuffer();
        StringBuffer updateEntryId = new StringBuffer();
        while (rs.next()) {
            if (rs.getBigDecimal("priceBefore").compareTo(rs.getBigDecimal("priceAfter")) != 0 || rs.getBigDecimal("amountBefore").compareTo(rs.getBigDecimal("amountAfter")) != 0) {
                updateEntryId.append(rs.getString("entryId")).append(",");
                if (!updateBillNumSet.add(rs.getString("fnumber"))) continue;
                updateNumber.append(rs.getString("fnumber")).append("\n");
                continue;
            }
            if (rs.getBigDecimal("priceBefore") != null && rs.getBigDecimal("amountBefore") != null && rs.getBigDecimal("priceBefore").compareTo(BigDecimal.ZERO) != 0 && rs.getBigDecimal("amountBefore").compareTo(BigDecimal.ZERO) != 0 || !unUpdateBillNumSet.add(rs.getString("fnumber"))) continue;
            unUpdateNumber.append(rs.getString("fnumber")).append("\n");
        }
        Locale locale = SysContext.getSysContext().getLocale();
        String loc = locale.getLanguage();
        selectSql.setLength(0);
        selectSql.append(" select company.fname_").append(loc).append(" as company, storage.fname_").append(loc).append(" as storage,");
        selectSql.append(" warehouse.fname_").append(loc).append(" as warehouse, material.fname_").append(loc).append(" as material, ");
        selectSql.append(" T.FLOT as lot, assist.fname_").append(loc).append(" as assist, project.fname_").append(loc).append(" as project,");
        selectSql.append(" track.fname_").append(loc).append(" as trackNum from (");
        selectSql.append(" select entry.FCOMPANYORGUNITID, entry.FSTORAGEORGUNITID, entry.FWAREHOUSEID, entry.FMATERIALID, ");
        selectSql.append(" entry.FLOT, entry.FASSISTPROPERTYID, entry.FPROJECTID, entry.FTRACKNUMBERID ");
        selectSql.append(" from T_IM_MOVELOCATIONBILLENTRY entry ");
        selectSql.append(" inner join ").append(billTable).append(" T on T.fentryid = entry.fid ");
        selectSql.append(" where (entry.fprice is null or entry.fprice = 0) and (entry.famount is null or entry.famount = 0 ) ");
        selectSql.append(" group by entry.FCOMPANYORGUNITID,entry.FSTORAGEORGUNITID,entry.FWAREHOUSEID,entry.FMATERIALID, ");
        selectSql.append(" entry.FLOT,entry.FASSISTPROPERTYID,entry.FPROJECTID,entry.FTRACKNUMBERID ) T ");
        selectSql.append(" inner join T_ORG_COMPANY company on company.fid = T.FCOMPANYORGUNITID ");
        selectSql.append(" inner join T_ORG_STORAGE storage on storage.fid = T.FSTORAGEORGUNITID ");
        selectSql.append(" inner join T_DB_WAREHOUSE warehouse on warehouse.fid = T.FWAREHOUSEID ");
        selectSql.append(" inner join T_BD_MATERIAL material on material.fid = T.FMATERIALID ");
        selectSql.append(" left join T_BD_AsstAttrValue assist on assist.fid = T.FASSISTPROPERTYID ");
        selectSql.append(" left join T_MM_Project project on project.fid = T.FPROJECTID ");
        selectSql.append(" left join T_MM_TrackNumber track on track.fid = T.FTRACKNUMBERID ");
        rs = DBUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        StringBuffer msg = new StringBuffer();
        while (rs.next()) {
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"company", (Locale)locale)).append(rs.getString("company")).append(", ");
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"storage", (Locale)locale)).append(rs.getString("storage")).append(", ");
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"warehouse", (Locale)locale)).append(rs.getString("warehouse")).append(", ");
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"material", (Locale)locale)).append(rs.getString("material"));
            if (rs.getString("lot") != null) {
                msg.append(", ").append(ResourceBase.getString((String)RESOURCE, (String)"lot", (Locale)locale)).append(rs.getString("lot"));
            }
            if (rs.getString("assist") != null) {
                msg.append(", ").append(ResourceBase.getString((String)RESOURCE, (String)"assist", (Locale)locale)).append(rs.getString("assist"));
            }
            if (rs.getString("project") != null) {
                msg.append(", ").append(ResourceBase.getString((String)RESOURCE, (String)"project", (Locale)locale)).append(rs.getString("project"));
            }
            if (rs.getString("trackNum") != null) {
                msg.append(", ").append(ResourceBase.getString((String)RESOURCE, (String)"trackNum", (Locale)locale)).append(rs.getString("trackNum"));
            }
            msg.append("\n");
        }
        String[] msgInfo = new String[]{updateNumber.toString(), unUpdateNumber.toString(), msg.toString()};
        result.put("resultMsg", msgInfo);
    }

    private String getUpdateSql(String tempTable, String billTable, int precision) {
        StringBuffer updateSql = new StringBuffer();
        BigDecimal minValueByScale = RecentCostHelp.getMinValueByScale(precision, 1);
        updateSql.append(" UPDATE T_IM_MOVELOCATIONBILLENTRY Entry SET (FPRICE,FAMOUNT) = ( select T.FPRICE, ");
        updateSql.append(" case when Round(T.FPRICE*Entry.FQTY,").append(precision).append(")=0 and T.FPRICE <> 0 then ").append(minValueByScale.toPlainString());
        updateSql.append(" else Round(T.FPRICE*Entry.FQTY,").append(precision).append(") end from ").append(tempTable).append(" T ");
        updateSql.append(" where T.FCOMPANYORGUNITID = Entry.FCOMPANYORGUNITID and T.FSTORAGEORGUNITID = Entry.FSTORAGEORGUNITID and T.FPRICE >=0 ");
        updateSql.append(" and T.FWAREHOUSEID = Entry.FWAREHOUSEID and T.FMATERIALID = Entry.FMATERIALID ");
        updateSql.append(" and isnull(T.FLot,'null') = isnull(Entry.FLot,'null') and isnull(T.FASSISTPROPERTYID,'null') = isnull(Entry.FASSISTPROPERTYID,'null') ");
        updateSql.append(" and isnull(T.FPROJECTID,'null') = isnull(Entry.FPROJECTID,'null') and isnull(T.FTRACKNUMBERID,'null') = isnull(Entry.FTRACKNUMBERID,'null') ");
        updateSql.append(" and Entry.FBIZDATE >= T.FBEGINDATE and Entry.FBIZDATE <= T.FENDDATE ) ");
        updateSql.append(" where Entry.FID in ( select FENTRYID from ").append(billTable).append(")");
        return updateSql.toString();
    }
}

