/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.BizCLOSEACCOUNTException;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupCollection;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupFactory;
import com.kingdee.eas.scm.cal.DevolveWriteOffGroupInfo;
import com.kingdee.eas.scm.cal.DevolveWriteOffRecordInfo;
import com.kingdee.eas.scm.cal.MatCostWriteOffTypeEnum;
import com.kingdee.eas.scm.cal.PeriodEndCheckParam;
import com.kingdee.eas.scm.cal.app.AbstractPeriodEndCheckFacadeControllerBean;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.CloseAccountCheckHelper;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.CloseAccountCheckProcessor;
import com.kingdee.eas.scm.cal.app.bizprocess.processor.closeaccount.CloseAccountDataLoaderProcessor;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeriodEndCheckFacadeControllerBean
extends AbstractPeriodEndCheckFacadeControllerBean {
    private static final long serialVersionUID = -1430337533136053127L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.PeriodEndCheckFacadeControllerBean");
    private PeriodEndCheckParam param;
    private final String resource = "com.kingdee.eas.scm.cal.CalRptResource";
    private Context ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PeriodEndCheckParam _periodEndCheck(Context ctx, PeriodEndCheckParam param) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.param = param;
        Object[] companyOrgUnitInfos = param.getCompanyOrgUnitInfos();
        Map<String, Comparable<Boolean>> currParam = new HashMap<String, Comparable<Boolean>>();
        currParam.put("IsCheckCostbill", Boolean.valueOf(param.isCheckCostbill()));
        currParam.put("isChkUnVoucherBillZeroCost", Boolean.valueOf(param.isChkUnVoucherBillZeroCost()));
        currParam.put("isUseMutiCk", Boolean.valueOf(param.isUseMutiCk()));
        currParam.put("balanceCondition", Integer.valueOf(param.getBalanceCondition()));
        String local = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        if (companyOrgUnitInfos.length > 0) {
            String createSQL = SysTempTableHelper.getCreateSQl((String[][])CloseAccountCheckProcessor.getTempCheckDataNameFields());
            String tempCheckDataTableName = KsqlUtil.createTempTable((Context)ctx, (String)createSQL);
            String tempCostMoveTable = null;
            try {
                for (int i = 0; i < companyOrgUnitInfos.length; ++i) {
                    CompanyOrgUnitInfo currCompany = (CompanyOrgUnitInfo)companyOrgUnitInfos[i];
                    PeriodInfo curPeriodInfo = null;
                    curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currCompany);
                    if (curPeriodInfo == null) {
                        throw new BizCLOSEACCOUNTException(BizCLOSEACCOUNTException.NOTSTARTFORENDCHECK);
                    }
                    currParam = CloseAccountDataLoaderProcessor.getSystemParams((Context)ctx, (CompanyOrgUnitInfo)currCompany, currParam);
                    if (param.isChkBillIsVoucher()) {
                        this.doCheckForCommon(ctx, currParam, currCompany, local, tempCheckDataTableName, 3);
                    }
                    if (param.isChkBillZeroCost()) {
                        this.doCheckForCommon(ctx, currParam, currCompany, local, tempCheckDataTableName, 2);
                    }
                    if (param.isChkMoveBillBalance()) {
                        this.doCheckForCostMoveBill(ctx, currParam, currCompany, tempCostMoveTable);
                    }
                    PeriodInfo currentPeriodInfo = null;
                    if (param.isChkAccountBalance()) {
                        this.doCheckInvckAccount(ctx, currCompany, currentPeriodInfo);
                    }
                    if (param.isChkPeriodEndBalanceException()) {
                        this.doCheckPeriodEndBalanceException(ctx, currCompany, currentPeriodInfo);
                    }
                    if (param.isChkWriteOffRecordAmt()) {
                        this.doCheckWriteOffRecordAmt(ctx, currCompany, currentPeriodInfo);
                    }
                    this.deleteCostComputerPriceSourceRpt(ctx, currCompany);
                }
            }
            finally {
                KsqlUtil.releaseTempTable((Context)ctx, (String)tempCheckDataTableName);
                KsqlUtil.releaseTempTable((Context)ctx, tempCostMoveTable);
            }
        }
        return this.param;
    }

    private void deleteCostComputerPriceSourceRpt(Context ctx, CompanyOrgUnitInfo currCompany) throws BOSException {
        try {
            String sql = "select FVALUE from t_dt_dttempparam where FKEY='saveCostComputerPriceSourceRptMonthNum' ";
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rs.next()) {
                return;
            }
            int monthNum = rs.getInt("FVALUE");
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currCompany);
            String currentPeriod = currentPeriodInfo.getPeriodYear() * 10000 + currentPeriodInfo.getPeriodNumber() * 100 + 1 + "";
            StringBuffer deleteSql = new StringBuffer();
            deleteSql.append(" DELETE FROM T_CL_CostComputePriceReport \n");
            deleteSql.append(" WHERE FCOMPANYORGUNITID='").append(currCompany.getId().toString()).append("'  \n");
            deleteSql.append(" AND to_date(to_char(FYEAR*10000+FPERIOD*100+1))<").append("add_months(to_date('" + currentPeriod + "'),-" + monthNum + ")  \n");
            DBUtil.execute((Context)ctx, (String)deleteSql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void doCheckWriteOffRecordAmt(Context ctx, CompanyOrgUnitInfo currCompany, PeriodInfo currentPeriodInfo) throws EASBizException, BOSException {
        if (currentPeriodInfo == null) {
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)currCompany);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyorgunit.id", (Object)currCompany.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("WRITEOFFYEAR", (Object)currentPeriodInfo.getPeriodYear(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("WRITEOFFPERIOD", (Object)currentPeriodInfo.getPeriodNumber(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("CREATETYPE"));
        selector.add(new SelectorItemInfo("entry.billTypeNumber"));
        selector.add(new SelectorItemInfo("entry.currWriteOffAmount"));
        view.setSelector(selector);
        DevolveWriteOffGroupCollection billConlletion = DevolveWriteOffGroupFactory.getLocalInstance(ctx).getDevolveWriteOffGroupCollection(view);
        for (int i = 0; i < billConlletion.size(); ++i) {
            DevolveWriteOffGroupInfo billVO = billConlletion.get(i);
            if (billVO.getCreateType() != MatCostWriteOffTypeEnum.RedBlueWriteOff) continue;
            BigDecimal positive = new BigDecimal("0.00");
            BigDecimal negative = new BigDecimal("0.00");
            for (int j = 0; j < billVO.getEntry().size(); ++j) {
                DevolveWriteOffRecordInfo recordInfo = billVO.getEntry().get(j);
                if (recordInfo.getCurrWriteOffAmount().signum() == 1) {
                    positive = positive.add(recordInfo.getCurrWriteOffAmount());
                    continue;
                }
                negative = negative.add(recordInfo.getCurrWriteOffAmount());
            }
            if (positive.compareTo(negative.abs()) == 0) continue;
            this.param.addResults(currCompany.getName(), this.getRes("CHECK_ITEM_WRITEOFF_AMT"), this.getRes("CHECK_INFO_WARN"), this.getRes("DEV_WRITEOFF_NUMBER") + billVO.getNumber());
        }
    }

    /*
     * Exception decompiling
     */
    private void doCheckPeriodEndBalanceException(Context ctx, CompanyOrgUnitInfo currCompany, PeriodInfo currentPeriodInfo) throws EASBizException, BOSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void doCheckInvckAccount(Context ctx, CompanyOrgUnitInfo currCompany, PeriodInfo currentPeriodInfo) throws BOSException, EASBizException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doCheckForCostMoveBill(Context ctx, Map currParam, CompanyOrgUnitInfo currCompany, String tempCostMoveTable) throws BOSException, EASBizException {
        String checkSql = CloseAccountCheckHelper.checkCostMoveBillBalance((Context)ctx, (Map)currParam, (CompanyOrgUnitInfo)currCompany, (String)tempCostMoveTable);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)checkSql);
        try {
            while (rs.next()) {
                this.param.addResults(currCompany.getName(), this.getRes("CHECK_ITEM_MOVE_COST"), this.getRes("CHECK_INFO_WARN"), this.getRes("BILLNO") + rs.getString("FBILLNUMBER") + "\uff0c" + this.getRes("MATERIELCODE") + rs.getString("FMATERIALNUMBER"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.releaseTempTable(ctx, tempCostMoveTable);
                throw throwable;
            }
        }
        DBUtil.releaseTempTable(ctx, tempCostMoveTable);
    }

    private void doCheckForCommon(Context ctx, Map currParam, CompanyOrgUnitInfo currCompany, String local, String tempCheckDataTableName, int checkType) throws BOSException {
        String checkSql = CloseAccountCheckHelper.getCheckSQL((Context)ctx, (Map)currParam, (CompanyOrgUnitInfo)currCompany, (int)checkType, (String)tempCheckDataTableName, (String)local);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)checkSql);
        try {
            while (rs.next()) {
                this.param.addResults(currCompany.getName(), this.getRes("CHECK_ITEM_ZERO_COST"), this.getRes("CHECK_INFO_WARN"), rs.getString("FBizOrTransName") + rs.getString("FBillNumber"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            String truncateSql = "truncate table " + tempCheckDataTableName;
            DBUtil.execute((Context)ctx, (String)truncateSql);
        }
    }

    private String getRes(String item) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)item, (Context)this.ctx);
    }
}

