/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.framework.balance.BalanceReCalCalculateFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.IPUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class ReCalBalanceJobHandler
implements IJobHandler {
    private static final long serialVersionUID = 1L;
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.ReCalBalanceResource";

    public Object execute(Job job) throws Exception {
        CompanyOrgUnitInfo company = null;
        Context ctx = null;
        MessageInfo info = null;
        boolean isCloseAccount = false;
        StringBuffer calInfo = new StringBuffer();
        try {
            Iterator iterator;
            ctx = job.getContext();
            JobParam jobParam = (JobParam)job.getParameters();
            Object bizParam = jobParam.getBizParam();
            HashMap paraMap = null;
            Locale locale = null;
            if (bizParam != null && bizParam instanceof Object[]) {
                Object[] parObjs = (Object[])bizParam;
                company = (CompanyOrgUnitInfo)parObjs[0];
                paraMap = (HashMap)parObjs[1];
                locale = (Locale)parObjs[2];
                ctx.put((Object)"UserInfo", parObjs[3]);
                ctx.put((Object)OrgType.Company, (Object)company);
                ctx.put((Object)"CurOU", (Object)company);
                ctx.put((Object)OrgType.ControlUnit, parObjs[5]);
            }
            if (null == company || company.toString().length() <= 0) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            ctx.put((Object)"ClientName", (Object)IPUtils.getLocleAddress().getHostName());
            ctx.put((Object)"RECALBAL_JOB_INST_ID", (Object)jobParam.getJobId());
            ctx.setLocale(jobParam.getLocale());
            String userId = ctx.getCaller().toString();
            info = new MessageInfo();
            info.setUserID(userId);
            String reCalInfo = ResourceBase.getString((String)RESOURCE, (String)"ReCalBalanceInfo", (Locale)locale);
            String reCalResut = ResourceBase.getString((String)RESOURCE, (String)"ReCalResut", (Locale)locale);
            calInfo.append(MessageFormat.format(reCalInfo, company.getNumber(), company.getName(), paraMap.get("yearFrom").toString(), paraMap.get("periodFrom"), paraMap.get("yearTo").toString(), paraMap.get("periodTo")));
            calInfo.append(reCalResut).append("\n");
            if (paraMap.get("storageNumberSet") != null) {
                calInfo.append(ResourceBase.getString((String)RESOURCE, (String)"ReCalStorage", (Locale)locale)).append("\n");
                HashSet storageNumberSet = (HashSet)paraMap.get("storageNumberSet");
                StringBuffer storagesb = new StringBuffer();
                iterator = storageNumberSet.iterator();
                while (iterator.hasNext()) {
                    storagesb.append(iterator.next());
                    storagesb.append(",");
                }
                calInfo.append(storagesb.substring(0, storagesb.length() - 1));
                calInfo.append("\n");
            }
            if (paraMap.get("warehouseNumberSet") != null) {
                calInfo.append(ResourceBase.getString((String)RESOURCE, (String)"ReCalWarehouse", (Locale)locale)).append("\n");
                HashSet warehouseNumberSet = (HashSet)paraMap.get("warehouseNumberSet");
                StringBuffer warehousesb = new StringBuffer();
                iterator = warehouseNumberSet.iterator();
                while (iterator.hasNext()) {
                    warehousesb.append(iterator.next());
                    warehousesb.append(",");
                }
                calInfo.append(warehousesb.substring(0, warehousesb.length() - 1));
                calInfo.append("\n");
            }
            if (paraMap.get("materialNumberSet") != null) {
                calInfo.append(ResourceBase.getString((String)RESOURCE, (String)"ReCalMaterial", (Locale)locale)).append("\n");
                StringBuffer materialSb = new StringBuffer();
                HashSet materialNumberSet = (HashSet)paraMap.get("materialNumberSet");
                iterator = materialNumberSet.iterator();
                while (iterator.hasNext()) {
                    materialSb.append(iterator.next());
                    materialSb.append(",");
                }
                calInfo.append(materialSb.substring(0, materialSb.length() - 1));
                calInfo.append("\n");
            }
            calInfo.append(ResourceBase.getString((String)RESOURCE, (String)"ReCalBalance", (Locale)locale));
            info.setbizAction(calInfo.toString());
            info.setOrgNumber(company.getName(locale) + "(" + company.getNumber() + ")");
            boolean isSendMsg = true;
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            BalanceReCalCalculateFacadeFactory.getLocalInstance((Context)ctx).reCalBalance(paraMap);
            info.setSuccessed(true);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
        }
        catch (EASBizException e) {
            info.setExecption(e.getMessage(ctx.getLocale()));
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw e;
        }
        catch (BOSException be) {
            info.setExecption(be.getMessage());
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw be;
        }
        finally {
            JobLog log = new JobLog(JobLog.Type.Info, calInfo.toString());
            job.saveMessage(log);
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return Boolean.TRUE;
    }
}

