/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.AbstractRecentCostControllerBean;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RecentCostControllerBean
extends AbstractRecentCostControllerBean {
    private static final long serialVersionUID = -5784829451582797229L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.RecentCostControllerBean");

    @Override
    protected String _calculateCost(Context ctx, String calMode, CalculateWrittenOffEntry entryInfo, BigDecimal qty, BigDecimal inSum, BigDecimal diffSum) throws BOSException, EASBizException {
        StringBuffer returnStr = new StringBuffer();
        if (!AccountType.MOVE_ADD_AVERAGE.equals((Object)entryInfo.getMaterialAccountType())) {
            return null;
        }
        RecentCostInfo info = new RecentCostInfo();
        RecentCostInfo tempInfo = RecentCostHelp.getRecentCost(ctx, calMode, entryInfo);
        String id = RecentCostHelp.getRecentCostID(ctx, RecentCostHelp.getFilterByCalMode(calMode, entryInfo));
        if (tempInfo != null && id != null && id.length() > 0) {
            returnStr.append(RecentCostHelp.takeAmountQytPriceDesc(tempInfo.getRecentCost(), tempInfo.getRecentQty(), tempInfo.getPrice()));
            ObjectUuidPK pk = new ObjectUuidPK(id);
            BigDecimal qtyAll = qty.add(tempInfo.getRecentQty());
            BigDecimal inSumAll = inSum.add(tempInfo.getRecentCost());
            BigDecimal diffSumAll = diffSum;
            RecentCostHelp.setRecentCostInfo(ctx, info, entryInfo, qtyAll, inSumAll.add(diffSumAll));
            info.setId(pk.getKeyValue());
            this.update(ctx, (IObjectPK)pk, (CoreBaseInfo)info);
        } else {
            returnStr.append(RecentCostHelp.takeAmountQytPriceDesc(CalculateUtil.ZERO, CalculateUtil.ZERO, CalculateUtil.ZERO));
            BigDecimal qtyAll = qty;
            BigDecimal inSumAll = inSum;
            BigDecimal diffSumAll = diffSum;
            RecentCostHelp.setRecentCostInfo(ctx, info, entryInfo, qtyAll, inSumAll.add(diffSumAll));
            this.addnew(ctx, (CoreBaseInfo)info);
        }
        if (!"".equals(returnStr.toString())) {
            returnStr.append("\n");
        }
        returnStr.append(RecentCostHelp.takeAmountQytPriceDesc(info.getRecentCost(), info.getRecentQty(), info.getPrice()));
        return returnStr.toString();
    }

    @Override
    protected BigDecimal _getMaterialRecentCost(Context ctx, String calMode, CalculateWrittenOffEntry entry, CalculateKindEnum calculateKindEnum) throws EASBizException, BOSException {
        NumericExceptionSubItem exceptionitem = CalculateException.MATERIAL_RECENT_COST_NOT_EXIST;
        String id = RecentCostHelp.getRecentCostID(ctx, RecentCostHelp.getFilterByCalMode(calMode, entry));
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FRecentCost,FRecentQty,FPrice");
        sql.append(" ,CURRENCY.FPrecision AS CURRENCYPRECISION");
        sql.append(" FROM T_CL_RecentCost ");
        sql.append(" INNER JOIN T_ORG_Company AS COMPANY");
        sql.append(" ON T_CL_RecentCost.FCompanyOrgUnitID = COMPANY.FID");
        sql.append(" INNER JOIN T_BD_Currency AS CURRENCY");
        sql.append(" ON COMPANY.FBaseCurrencyID = CURRENCY.FID");
        sql.append(" WHERE T_CL_RecentCost.FID = '").append(id).append("'");
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            JdbcRowSet rs = (JdbcRowSet)SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            if (rs != null && rs.next()) {
                if (rs.getBigDecimal("FPrice") == null || rs.getBigDecimal("FRecentCost") == null || rs.getBigDecimal("FRecentQty") == null) {
                    throw RecentCostHelp.throwException(ctx, exceptionitem, calMode, entry);
                }
                exceptionitem = CalculateException.MATERIAL_RECENT_COST_EQUAL_ZERO;
                if (rs.getBigDecimal("FRecentQty").add(entry.getBaseUnitQty().multiply(calculateKindEnum.equals((Object)CalculateKindEnum.INPUT_WAREHOUSE) ? CalculateUtil.ONE : CalculateUtil.ONE_MINUS)).compareTo(CalculateUtil.ZERO) == 0) {
                    if (CalculateUtil.ZERO.compareTo(rs.getBigDecimal("FRecentCost")) == 0) {
                        throw RecentCostHelp.throwException(ctx, exceptionitem, calMode, entry);
                    }
                    BigDecimal bigDecimal = rs.getBigDecimal("FRecentCost");
                    return bigDecimal;
                }
                if (CalculateUtil.ZERO.compareTo(rs.getBigDecimal("FPrice").multiply(entry.getBaseUnitQty())) == 0) {
                    throw RecentCostHelp.throwException(ctx, exceptionitem, calMode, entry);
                }
                BigDecimal bigDecimal = rs.getBigDecimal("FPrice").multiply(entry.getBaseUnitQty()).setScale(rs.getInt("CURRENCYPRECISION"), 4);
                return bigDecimal;
            }
            try {
                throw RecentCostHelp.throwException(ctx, exceptionitem, calMode, entry);
            }
            catch (SQLException ex) {
                throw RecentCostHelp.throwException(ctx, exceptionitem, calMode, entry);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

