/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffCreateTypeEnum;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.app.WriteOffStrategy;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.AutoSplitBillServerUtils;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SaleWriteOffStrategy
extends WriteOffStrategy {
    @Override
    public List buildWriteOffBillInfo(Context ctx, Map mainMap, Map secMap, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
        params.put((Object)"currentPeriod", (Object)curPeriodInfo);
        HashMap paramMap = new HashMap();
        paramMap.put("SCM_CAL_020", params.getCompanyId());
        paramMap = ParamManager.getParamHashMap((Context)ctx, paramMap);
        params.put((Object)"dischargeType", (Object)0);
        params.put((Object)"isSaleWriteOff", (Object)true);
        CoreBaseCollection billColl = new CoreBaseCollection();
        WriteOffGroupInfo billInfo = null;
        if ("qA2INiX2StqRcB1t+p4RMJVAboA=".equals(String.valueOf(conditionEntryInfo.getId()))) {
            if (!params.isFlowWriteOff() && (billInfo = this.buildSingleBillInfo(ctx, (List)mainMap.get(""), (List)secMap.get(""))) != null) {
                billColl.add((CoreBaseInfo)billInfo);
            }
        } else {
            if (!params.isFlowWriteOff() && params.isSameSideFirst() || params.isFlowWriteOff() && !"1".equals(paramMap.get("SCM_CAL_020").toString())) {
                params.put((Object)"isCrossPeriodNotWriteOff", (Object)"2".equals(paramMap.get("SCM_CAL_020").toString()));
                params.put((Object)"SCM_CAL_020", paramMap.get("SCM_CAL_020"));
                for (List list : mainMap.values()) {
                    billInfo = this.buildSameSideBillInfo(ctx, list, params);
                    if (billInfo == null) continue;
                    billColl.add((CoreBaseInfo)billInfo);
                }
                for (List list : secMap.values()) {
                    billColl.addObjectCollection((IObjectCollection)this.buildSameSideBillInfoByRelation(ctx, list, params));
                    billInfo = this.buildSameSideBillInfo(ctx, list, params);
                    if (billInfo != null) {
                        billColl.add((CoreBaseInfo)billInfo);
                    }
                    if (billColl == null) continue;
                    int size = billColl.size();
                    for (int i = 0; i < size; ++i) {
                        billInfo = (WriteOffGroupInfo)billColl.getObject(i);
                        int k = billInfo.getEntry().size();
                        for (int j = 0; j < k; ++j) {
                            if (!"102".equals(billInfo.getEntry().get(j).getBillTypeNumber())) continue;
                            billInfo.getEntry().get(j).setBoolean("isSameSideWriteOff", true);
                        }
                    }
                }
            }
            ArrayList<WriteOffRecordInfo> mainPositive = new ArrayList<WriteOffRecordInfo>();
            ArrayList<WriteOffRecordInfo> mainNegative = new ArrayList<WriteOffRecordInfo>();
            ArrayList<WriteOffRecordInfo> secPositive = new ArrayList<WriteOffRecordInfo>();
            ArrayList<WriteOffRecordInfo> secNegative = new ArrayList<WriteOffRecordInfo>();
            HashMap costAdjustMap = new HashMap();
            WriteOffRecordInfo entryInfo2 = null;
            Map.Entry me2 = null;
            for (Map.Entry me2 : mainMap.entrySet()) {
                if (!secMap.containsKey(me2.getKey())) continue;
                mainPositive.clear();
                mainNegative.clear();
                secPositive.clear();
                secNegative.clear();
                for (WriteOffRecordInfo entryInfo2 : (List)me2.getValue()) {
                    if (entryInfo2.getCurrWrittenOffQty().signum() > 0) {
                        mainPositive.add(entryInfo2);
                        continue;
                    }
                    mainNegative.add(entryInfo2);
                }
                List secList = (List)secMap.get(me2.getKey());
                Iterator itList = secList.iterator();
                while (itList.hasNext()) {
                    entryInfo2 = (WriteOffRecordInfo)itList.next();
                    if (!((Boolean)entryInfo2.get("isWriteOff")).booleanValue()) {
                        itList.remove();
                        continue;
                    }
                    if (entryInfo2.getCurrWrittenOffQty().signum() > 0) {
                        secPositive.add(entryInfo2);
                        continue;
                    }
                    secNegative.add(entryInfo2);
                }
                billInfo = this.buildTwoSideBillInfo(ctx, mainPositive, secPositive, conditionEntryInfo, params, costAdjustMap);
                if (billInfo != null) {
                    billColl.add((CoreBaseInfo)billInfo);
                }
                if ((billInfo = this.buildTwoSideBillInfo(ctx, mainNegative, secNegative, conditionEntryInfo, params, costAdjustMap)) == null) continue;
                billColl.add((CoreBaseInfo)billInfo);
            }
        }
        ArrayList<IObjectPK> result = new ArrayList<IObjectPK>();
        if (billColl.size() > 0) {
            ArrayList<WriteOffRecordInfo> invoiceBill = new ArrayList<WriteOffRecordInfo>();
            ArrayList<WriteOffRecordInfo> imBill = new ArrayList<WriteOffRecordInfo>();
            HashSet<String> invoiceBillNumber = new HashSet<String>();
            HashSet<String> imBillNumber = new HashSet<String>();
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            WriteOffCreateTypeEnum createType = WriteOffCreateTypeEnum.SAL_MANUAL_WRITEOFF;
            if (params.isFlowWriteOff()) {
                createType = WriteOffCreateTypeEnum.SAL_AUTO_WRITEOFF;
                if (null == conditionEntryInfo.getId()) {
                    conditionEntryInfo.setId(BOSUuid.read((String)"62l4P/XTRz+KchgVHxywn5VAboA="));
                }
            }
            int size = billColl.size();
            for (int i = 0; i < size; ++i) {
                billInfo = (WriteOffGroupInfo)billColl.getObject(i);
                billInfo.setNumber(sf.format(new Date()) + i);
                Timestamp maxBizDate = CalculateUtil.getTime("1900-01-01 00:00:00.000");
                int maxPeriodNumber = 190001;
                int k = billInfo.getEntry().size();
                for (int j = 0; j < k; ++j) {
                    billInfo.getEntry().get(j).setId(null);
                    if (maxBizDate.compareTo(billInfo.getEntry().get(j).getBillDate()) >= 0) continue;
                    maxBizDate = CalculateUtil.getTime(billInfo.getEntry().get(j).getBillDate());
                    maxPeriodNumber = billInfo.getEntry().get(j).getInt("year") * 100 + billInfo.getEntry().get(j).getInt("period");
                }
                int periodNumber = curPeriodInfo.getNumber();
                if (maxBizDate.compareTo(curPeriodInfo.getBeginDate()) < 0) {
                    maxBizDate = CalculateUtil.getTime(curPeriodInfo.getBeginDate());
                } else if (maxBizDate.compareTo(curPeriodInfo.getEndDate()) > 0) {
                    periodNumber = maxPeriodNumber;
                }
                billInfo.setWriteOffYear(periodNumber / 100);
                billInfo.setWriteOffPeriod(periodNumber % 100);
                Timestamp now = new Timestamp(Calendar.getInstance().getTimeInMillis());
                billInfo.setWriteOffDate(now);
                billInfo.setCalculateKind(CalculateKindEnum.OUTPUT_WAREHOUSE);
                billInfo.setCreateType(createType);
                billInfo.setMappingConditionEntry(conditionEntryInfo);
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)params.getCompanyId()));
                billInfo.setCompanyOrgUnit(company);
                billInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                billInfo.setCreateTime(now);
                int k2 = billInfo.getEntry().size();
                for (int j = 0; j < k2; ++j) {
                    if ("330".equals(billInfo.getEntry().get(j).getBillTypeNumber())) {
                        invoiceBill.add(billInfo.getEntry().get(j));
                        invoiceBillNumber.add(billInfo.getEntry().get(j).getBillNumber());
                        continue;
                    }
                    if (!"102".equals(billInfo.getEntry().get(j).getBillTypeNumber())) continue;
                    imBill.add(billInfo.getEntry().get(j));
                    imBillNumber.add(billInfo.getEntry().get(j).getBillNumber());
                }
            }
            IWriteOffGroup iBill = WriteOffGroupFactory.getLocalInstance(ctx);
            IObjectPK[] pks = iBill.submitBatchData(billColl);
            this.updateInvoiceBill(ctx, invoiceBill, mainMap, "T_AR_OtherBillEntry");
            this.updateIMBill(ctx, imBill, secMap, true);
            ArrayList<String> splitList = new ArrayList<String>();
            int size2 = imBill.size();
            for (int i = 0; i < size2; ++i) {
                if (((WriteOffRecordInfo)imBill.get(i)).getBoolean("isSameSideWriteOff")) continue;
                splitList.add(((WriteOffRecordInfo)imBill.get(i)).getBillID());
            }
            String[] idArray = new String[splitList.size()];
            boolean[] isSplit = new boolean[splitList.size()];
            int size3 = splitList.size();
            for (int i = 0; i < size3; ++i) {
                idArray[i] = String.valueOf(splitList.get(i));
                isSplit[i] = true;
            }
            AutoSplitBillServerUtils.autoSplitBillByWrittenOffQty((Context)ctx, (boolean[])isSplit, (String[])idArray);
            result.addAll(Arrays.asList(pks));
            this.writeLog(ctx, imBillNumber, invoiceBillNumber, "saleWriteOff");
        }
        this.wrietOffBizLog(ctx, result);
        return result;
    }

    @Override
    protected boolean addEntryInfo(Context ctx, IObjectCollection entryColl, WriteOffRecordInfo mainEntryInfo, WriteOffRecordInfo secEntryInfo, List removeItem, boolean isSameSide, WriteOffCommonParams params) {
        WriteOffRecordInfo tempEntryInfo = null;
        if (mainEntryInfo.getCurrWrittenOffQty().abs().compareTo(secEntryInfo.getCurrWrittenOffQty().abs()) == 0 && mainEntryInfo.getUnWirteOffQty().abs().compareTo(BigDecimal.ZERO) != 0) {
            if (isSameSide) {
                removeItem.add(mainEntryInfo);
            }
            removeItem.add(secEntryInfo);
            if (entryColl.containsKey((Object)mainEntryInfo.getId())) {
                tempEntryInfo = (WriteOffRecordInfo)entryColl.getObject((Object)mainEntryInfo.getId());
                tempEntryInfo.setCurrWrittenOffQty(tempEntryInfo.getCurrWrittenOffQty().add(mainEntryInfo.getCurrWrittenOffQty()));
                tempEntryInfo.setCurrWrittenOffAmount(tempEntryInfo.getCurrWrittenOffAmount().add(mainEntryInfo.getCurrWrittenOffAmount()));
            } else {
                entryColl.addObject((IObjectValue)mainEntryInfo);
            }
            if (entryColl.containsKey((Object)secEntryInfo.getId())) {
                tempEntryInfo = (WriteOffRecordInfo)entryColl.getObject((Object)secEntryInfo.getId());
                tempEntryInfo.setCurrWrittenOffQty(tempEntryInfo.getCurrWrittenOffQty().add(secEntryInfo.getCurrWrittenOffQty()));
                tempEntryInfo.setCurrWrittenOffAmount(tempEntryInfo.getCurrWrittenOffAmount().add(secEntryInfo.getCurrWrittenOffAmount()));
            } else {
                entryColl.addObject((IObjectValue)secEntryInfo);
            }
            return true;
        }
        if (mainEntryInfo.getCurrWrittenOffQty().abs().compareTo(secEntryInfo.getCurrWrittenOffQty().abs()) > 0 && mainEntryInfo.getUnWirteOffQty().abs().compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal mainQty = secEntryInfo.getCurrWrittenOffQty().divide(mainEntryInfo.getBigDecimal("baseConvsRate"), mainEntryInfo.getInt("qtyPrecision"), 4);
            BigDecimal unitCost = SysConstant.BIGZERO;
            if ("FC910EF3".equals(BOSUuid.read((String)mainEntryInfo.getBillID()).getType().toString()) && mainEntryInfo.getBigDecimal("qty").signum() != 0) {
                unitCost = mainEntryInfo.getActualCost().divide(mainEntryInfo.getBigDecimal("qty"), mainEntryInfo.getInt("pricePrecision"), 4);
            } else if ("CC3E933B".equals(BOSUuid.read((String)mainEntryInfo.getBillID()).getType().toString())) {
                unitCost = mainEntryInfo.getActualCost().divide(mainEntryInfo.getBigDecimal("qty"), mainEntryInfo.getInt("pricePrecision"), 4);
            }
            BigDecimal mainAmt = mainQty.multiply(unitCost).setScale(mainEntryInfo.getInt("basePrecision"), 4);
            removeItem.add(secEntryInfo);
            if (entryColl.containsKey((Object)mainEntryInfo.getId())) {
                tempEntryInfo = (WriteOffRecordInfo)entryColl.getObject((Object)mainEntryInfo.getId());
                tempEntryInfo.setCurrWrittenOffQty(tempEntryInfo.getCurrWrittenOffQty().add(isSameSide ? secEntryInfo.getCurrWrittenOffQty().negate() : secEntryInfo.getCurrWrittenOffQty()));
                tempEntryInfo.setCurrWrittenOffAmount(tempEntryInfo.getCurrWrittenOffAmount().add(isSameSide ? mainAmt.negate() : mainAmt));
            } else {
                tempEntryInfo = (WriteOffRecordInfo)mainEntryInfo.clone();
                tempEntryInfo.setCurrWrittenOffQty(isSameSide ? secEntryInfo.getCurrWrittenOffQty().negate() : secEntryInfo.getCurrWrittenOffQty());
                tempEntryInfo.setCurrWrittenOffAmount(isSameSide ? mainAmt.negate() : mainAmt);
                entryColl.addObject((IObjectValue)tempEntryInfo);
            }
            if (entryColl.containsKey((Object)secEntryInfo.getId())) {
                tempEntryInfo = (WriteOffRecordInfo)entryColl.getObject((Object)secEntryInfo.getId());
                tempEntryInfo.setCurrWrittenOffQty(tempEntryInfo.getCurrWrittenOffQty().add(secEntryInfo.getCurrWrittenOffQty()));
                tempEntryInfo.setCurrWrittenOffAmount(tempEntryInfo.getCurrWrittenOffAmount().add(secEntryInfo.getCurrWrittenOffAmount()));
            } else {
                entryColl.addObject((IObjectValue)secEntryInfo);
            }
            BigDecimal curWfBaseQty = mainEntryInfo.getCurrWrittenOffQty().subtract(isSameSide ? secEntryInfo.getCurrWrittenOffQty().negate() : secEntryInfo.getCurrWrittenOffQty());
            mainEntryInfo.setCurrWrittenOffQty(curWfBaseQty);
            BigDecimal curWfLocalAmt = mainEntryInfo.getCurrWrittenOffAmount().subtract(isSameSide ? mainAmt.negate() : mainAmt);
            mainEntryInfo.setCurrWrittenOffAmount(curWfLocalAmt);
            if ("CC3E933B".equals(BOSUuid.read((String)mainEntryInfo.getBillID()).getType().toString())) {
                mainEntryInfo.setUnWirteOffQty(curWfBaseQty);
                mainEntryInfo.setWirttenOffQty(mainEntryInfo.getBigDecimal("baseQty").subtract(curWfBaseQty));
                mainEntryInfo.setBigDecimal("unWriteOffQty", mainEntryInfo.getBigDecimal("unWriteOffQty").subtract(isSameSide ? mainQty.negate() : mainQty));
            }
        } else if (mainEntryInfo.getCurrWrittenOffQty().abs().compareTo(secEntryInfo.getCurrWrittenOffQty().abs()) < 0 && mainEntryInfo.getUnWirteOffQty().abs().compareTo(BigDecimal.ZERO) != 0) {
            if (entryColl.containsKey((Object)mainEntryInfo.getId())) {
                tempEntryInfo = (WriteOffRecordInfo)entryColl.getObject((Object)mainEntryInfo.getId());
                tempEntryInfo.setCurrWrittenOffQty(tempEntryInfo.getCurrWrittenOffQty().add(mainEntryInfo.getCurrWrittenOffQty()));
                tempEntryInfo.setCurrWrittenOffAmount(tempEntryInfo.getCurrWrittenOffAmount().add(mainEntryInfo.getCurrWrittenOffAmount()));
            } else {
                entryColl.addObject((IObjectValue)mainEntryInfo);
            }
            BigDecimal secQty = mainEntryInfo.getCurrWrittenOffQty().divide(secEntryInfo.getBigDecimal("baseConvsRate"), secEntryInfo.getInt("qtyPrecision"), 4);
            BigDecimal unitCost = SysConstant.BIGZERO;
            if ("FC910EF3".equals(BOSUuid.read((String)secEntryInfo.getBillID()).getType().toString()) && secEntryInfo.getBigDecimal("qty").signum() != 0) {
                unitCost = secEntryInfo.getActualCost().divide(secEntryInfo.getBigDecimal("qty"), secEntryInfo.getInt("pricePrecision"), 4);
            } else if ("CC3E933B".equals(BOSUuid.read((String)secEntryInfo.getBillID()).getType().toString())) {
                unitCost = secEntryInfo.getActualCost().divide(secEntryInfo.getBigDecimal("qty"), secEntryInfo.getInt("pricePrecision"), 4);
            }
            BigDecimal secAmt = secQty.multiply(unitCost).setScale(secEntryInfo.getInt("basePrecision"), 4);
            if (isSameSide) {
                removeItem.add(mainEntryInfo);
            }
            if (entryColl.containsKey((Object)secEntryInfo.getId())) {
                tempEntryInfo = (WriteOffRecordInfo)entryColl.getObject((Object)secEntryInfo.getId());
                tempEntryInfo.setCurrWrittenOffQty(tempEntryInfo.getCurrWrittenOffQty().add(isSameSide ? mainEntryInfo.getCurrWrittenOffQty().negate() : mainEntryInfo.getCurrWrittenOffQty()));
                tempEntryInfo.setCurrWrittenOffAmount(tempEntryInfo.getCurrWrittenOffAmount().add(isSameSide ? secAmt.negate() : secAmt));
            } else {
                tempEntryInfo = (WriteOffRecordInfo)secEntryInfo.clone();
                tempEntryInfo.setCurrWrittenOffQty(isSameSide ? mainEntryInfo.getCurrWrittenOffQty().negate() : mainEntryInfo.getCurrWrittenOffQty());
                tempEntryInfo.setCurrWrittenOffAmount(isSameSide ? secAmt.negate() : secAmt);
                entryColl.addObject((IObjectValue)tempEntryInfo);
            }
            BigDecimal curWfBaseQty = secEntryInfo.getCurrWrittenOffQty().subtract(isSameSide ? mainEntryInfo.getCurrWrittenOffQty().negate() : mainEntryInfo.getCurrWrittenOffQty());
            secEntryInfo.setCurrWrittenOffQty(curWfBaseQty);
            BigDecimal curWfLocalAmt = secEntryInfo.getCurrWrittenOffAmount().subtract(isSameSide ? secAmt.negate() : secAmt);
            secEntryInfo.setCurrWrittenOffAmount(curWfLocalAmt);
            if ("CC3E933B".equals(BOSUuid.read((String)secEntryInfo.getBillID()).getType().toString())) {
                secEntryInfo.setUnWirteOffQty(curWfBaseQty);
                secEntryInfo.setWirttenOffQty(secEntryInfo.getBigDecimal("baseQty").subtract(curWfBaseQty));
                secEntryInfo.setBigDecimal("unWriteOffQty", secEntryInfo.getBigDecimal("unWriteOffQty").subtract(isSameSide ? secQty.negate() : secQty));
            }
            return true;
        }
        return false;
    }

    @Override
    public IObjectValue buildWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        CustomerInfo customer;
        WriteOffRecordInfo entryInfo = new WriteOffRecordInfo();
        entryInfo.setId(BOSUuid.create((String)"63AF1D4E"));
        entryInfo.setBillID(rs.getString("id"));
        entryInfo.setBillEntryID(rs.getString("entry.id"));
        entryInfo.setBillNumber(rs.getString("number"));
        String bosType = BOSUuid.read((String)rs.getString("id")).getType().toString();
        if (info != null) {
            entryInfo.setCurrWrittenOffAmount(info.getLocalAmount());
            entryInfo.setCurrWrittenOffQty(info.getBaseQty());
        } else if ("FC910EF3".equals(bosType)) {
            entryInfo.setCurrWrittenOffAmount(rs.getBigDecimal("entry.localUnwriteOffAmount"));
            entryInfo.setCurrWrittenOffQty(rs.getBigDecimal("entry.unwriteOffBaseQty"));
        } else if ("CC3E933B".equals(bosType)) {
            entryInfo.setCurrWrittenOffAmount(rs.getBigDecimal("entry.unWriteOffAmount"));
            entryInfo.setCurrWrittenOffQty(rs.getBigDecimal("entry.unWriteOffBaseQty"));
            AccountViewInfo accountViewIn = null;
            if (rs.getString("accountViewIn.id") != null && rs.getString("accountViewIn.id").length() != 0) {
                accountViewIn = new AccountViewInfo();
                accountViewIn.setId(BOSUuid.read((String)rs.getString("accountViewIn.id")));
                entryInfo.setAccountViewIn(accountViewIn);
            }
            AccountViewInfo accountViewOut = null;
            if (rs.getString("accountViewOut.id") != null && rs.getString("accountViewOut.id").length() != 0) {
                accountViewOut = new AccountViewInfo();
                accountViewOut.setId(BOSUuid.read((String)rs.getString("accountViewOut.id")));
                entryInfo.setAccountViewOut(accountViewOut);
            }
        }
        entryInfo.setBillEntrySeq(rs.getInt("entry.seq"));
        if (rs.getString("material.id") != null) {
            MaterialInfo material = new MaterialInfo();
            material.setId(BOSUuid.read((String)rs.getString("material.id")));
            entryInfo.setMaterial(material);
            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
            baseUnit.setId(BOSUuid.read((String)rs.getString("material.baseUnit.id")));
            entryInfo.setBaseUnit(baseUnit);
        }
        if (rs.getString("assistProperty.id") != null) {
            AsstAttrValueInfo asstAttr = new AsstAttrValueInfo();
            asstAttr.setId(BOSUuid.read((String)rs.getString("assistProperty.id")));
            entryInfo.setAssistProperty(asstAttr);
        }
        entryInfo.setCalcutator(ContextUtil.getCurrentUserInfo((Context)ctx));
        entryInfo.setCompanyOrgUnit(params.getCompanyId());
        PaymentTypeInfo paymentType = new PaymentTypeInfo();
        paymentType.setId(BOSUuid.read((String)rs.getString("paymentType.id")));
        entryInfo.setPaymentType(paymentType);
        entryInfo.setBoolean("entry.isFullWriteOff", rs.getBoolean("entry.isFullWriteOff"));
        entryInfo.setString("sourceBillEntryId", rs.getString("entry.sourceBillEntryId"));
        entryInfo.setInt("pricePrecision", rs.getInt("material.pricePrecision"));
        entryInfo.setInt("qtyPrecision", rs.getInt("multiUnit.qtyPrecision"));
        entryInfo.setBigDecimal("baseConvsRate", rs.getBigDecimal("multiUnit.baseConvsRate") == null ? new BigDecimal("1.00") : rs.getBigDecimal("multiUnit.baseConvsRate"));
        entryInfo.setInt("year", rs.getInt("year"));
        entryInfo.setInt("period", rs.getInt("period"));
        entryInfo.setBigDecimal("exchangeRate", rs.getBigDecimal("exchangeRate"));
        entryInfo.setBigDecimal("discountAmount", rs.getBigDecimal("entry.discountAmount"));
        entryInfo.setBigDecimal("taxRate", rs.getBigDecimal("entry.taxRate"));
        entryInfo.setBigDecimal("baseQty", rs.getBigDecimal("entry.baseQty"));
        entryInfo.setString("currencyId", rs.getString("currency.id"));
        if ("FC910EF3".equals(bosType)) {
            entryInfo.setBillDate(rs.getDate("billDate"));
            entryInfo.setTransactionType(rs.getString("bizType.id"));
            entryInfo.setUnWirteOffQty(rs.getBigDecimal("entry.unwriteOffBaseQty"));
            entryInfo.setUnWriteOffAmount(rs.getBigDecimal("entry.localUnwriteOffAmount"));
            entryInfo.setWirttenOffQty(rs.getBigDecimal("entry.wittenOffBaseQty"));
            entryInfo.setWrittenOffAmount(rs.getBigDecimal("entry.localWrittenOffAmount"));
            entryInfo.setOrderBillNumber(rs.getString("entry.coreBillNumber"));
            entryInfo.setOrderBillEntrySeq(rs.getInt("entry.coreBillEntrySeq"));
            entryInfo.setTax(rs.getBigDecimal("entry.taxAmount"));
            entryInfo.setLocalTax(rs.getBigDecimal("entry.taxAmountLocal"));
            entryInfo.setAmount(rs.getBigDecimal("entry.recievePayAmount"));
            entryInfo.setLocalAmount(rs.getBigDecimal("entry.recievePayAmountLocal"));
            entryInfo.setBillTypeNumber("330");
            entryInfo.setActualCost(rs.getBigDecimal("entry.amountLocal"));
            customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)rs.getString("asstActID")));
            entryInfo.setCustomer(customer);
            entryInfo.setBigDecimal("qty", rs.getBigDecimal("entry.quantity"));
            entryInfo.setInt("basePrecision", rs.getInt("baseCurrency.precision"));
            entryInfo.setBigDecimal("discountRate", rs.getBigDecimal("entry.discountRate"));
            entryInfo.setString("unitId", rs.getString("entry.measureUnit.id"));
        } else if ("CC3E933B".equals(bosType)) {
            entryInfo.setBillDate(rs.getDate("bizDate"));
            entryInfo.setTransactionType(rs.getString("transactionType.id"));
            entryInfo.setUnWirteOffQty(rs.getBigDecimal("entry.unWriteOffBaseQty"));
            entryInfo.setBigDecimal("unWriteOffQty", rs.getBigDecimal("entry.unWriteOffQty"));
            entryInfo.setUnWriteOffAmount(rs.getBigDecimal("entry.unWriteOffAmount"));
            entryInfo.setWirttenOffQty(rs.getBigDecimal("entry.writtenOffBaseQty"));
            entryInfo.setWrittenOffAmount(rs.getBigDecimal("entry.writtenOffAmount"));
            entryInfo.setActualCost(rs.getBigDecimal("entry.actualCost"));
            entryInfo.setTax(rs.getBigDecimal("entry.tax"));
            entryInfo.setLocalTax(rs.getBigDecimal("entry.localTax"));
            entryInfo.setBillTypeNumber("102");
            entryInfo.setOrderBillNumber(rs.getString("entry.saleOrderNumber"));
            entryInfo.setOrderBillEntrySeq(rs.getInt("entry.saleOrderEntrySeq"));
            entryInfo.setAmount(rs.getBigDecimal("entry.amount"));
            entryInfo.setLocalAmount(rs.getBigDecimal("entry.localAmount"));
            customer = new CustomerInfo();
            String customerId = rs.getString("customer.id");
            if (customerId != null) {
                customer.setId(BOSUuid.read((String)customerId));
                entryInfo.setCustomer(customer);
            }
            entryInfo.setBoolean("isWriteOff", rs.getBoolean("transactionType.isWriteOff"));
            entryInfo.setInt("accountType", rs.getInt("materialCompany.accountType"));
            entryInfo.setBoolean("fiVouchered", rs.getBoolean("fiVouchered"));
            entryInfo.setBoolean("isPresent", rs.getBoolean("entry.isPresent"));
            entryInfo.setString("baseCurrencyId", rs.getString("currency2.id"));
            entryInfo.setInt("basePrecision", rs.getInt("currency2.precision"));
            entryInfo.setString("storageOrgUnitId", rs.getString("storageOrgUnit1.id"));
            entryInfo.setString("adminOrgUnitId", rs.getString("adminOrgUnit.id"));
            entryInfo.setString("costCenterOrgUnitId", rs.getString("costCenterOrgUnit.id"));
            entryInfo.setString("warehouseId", rs.getString("warehouse.id"));
            entryInfo.setString("locationId", rs.getString("location.id"));
            entryInfo.setString("projectId", rs.getString("project.id"));
            entryInfo.setString("trackNumberId", rs.getString("trackNumber.id"));
            entryInfo.setBigDecimal("unitActualCost", rs.getBigDecimal("entry.unitActualCost"));
            entryInfo.setBigDecimal("qty", rs.getBigDecimal("entry.qty"));
            entryInfo.setBigDecimal("reverseQty", rs.getBigDecimal("entry.reverseQty"));
            entryInfo.setBoolean("isInitBill", rs.getBoolean("isInitBill"));
            entryInfo.setString("unitId", rs.getString("entry.unit.id"));
            AccountViewInfo accountViewIn = null;
            if (rs.getString("accountViewIn.id") != null && rs.getString("accountViewIn.id").length() != 0) {
                accountViewIn = new AccountViewInfo();
                accountViewIn.setId(BOSUuid.read((String)rs.getString("accountViewIn.id")));
                entryInfo.setAccountViewIn(accountViewIn);
            }
            AccountViewInfo accountViewOut = null;
            if (rs.getString("accountViewOut.id") != null && rs.getString("accountViewOut.id").length() != 0) {
                accountViewOut = new AccountViewInfo();
                accountViewOut.setId(BOSUuid.read((String)rs.getString("accountViewOut.id")));
                entryInfo.setAccountViewOut(accountViewOut);
            }
        }
        return entryInfo;
    }

    @Override
    public SelectorItemCollection getSelector(String bosType, WriteOffCommonParams params) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String[] selectors = null;
        if ("FC910EF3".equals(bosType)) {
            selectors = new String[]{"billDate", "bizType.id", "entry.seq", "entry.wittenOffBaseQty", "entry.localWrittenOffAmount", "entry.unwriteOffBaseQty", "entry.localUnwriteOffAmount", "entry.coreBillNumber", "entry.coreBillEntrySeq", "asstActID", "material.id", "material.baseUnit.id", "assistProperty.id", "baseUnit.id", "entry.recievePayAmountLocal", "entry.amountLocal", "entry.taxAmount", "entry.taxAmountLocal", "entry.recievePayAmount", "paymentType.id", "entry.quantity", "entry.baseQty", "baseCurrency.precision", "entry.taxRate", "entry.discountAmount", "entry.discountRate", "entry.measureUnit.id", "currency.id", "exchangeRate", "year", "period", "multiUnit.baseConvsRate", "multiUnit.qtyPrecision", "material.pricePrecision", "entry.sourceBillEntryId", "entry.isFullWriteOff"};
        } else if ("CC3E933B".equals(bosType)) {
            selectors = new String[]{"bizDate", "transactionType.id", "entry.seq", "entry.writtenOffBaseQty", "entry.writtenOffAmount", "entry.unWriteOffBaseQty", "entry.unWriteOffAmount", "entry.saleOrderNumber", "entry.saleOrderEntrySeq", "customer.id", "material.id", "material.baseUnit.id", "assistProperty.id", "baseUnit.id", "entry.actualCost", "entry.tax", "entry.localTax", "entry.amount", "entry.localAmount", "paymentType.id", "transactionType.isWriteOff", "materialCompany.accountType", "fiVouchered", "entry.isPresent", "year", "period", "currency2.id", "currency2.precision", "storageOrgUnit1.id", "adminOrgUnit.id", "costCenterOrgUnit.id", "warehouse.id", "location.id", "project.id", "trackNumber.id", "material.pricePrecision", "multiUnit.baseConvsRate", "multiUnit.qtyPrecision", "entry.unitActualCost", "entry.qty", "entry.baseQty", "entry.reverseQty", "isInitBill", "entry.taxRate", "entry.discountAmount", "entry.unit.id", "currency.id", "exchangeRate", "entry.unWriteOffQty", "entry.sourceBillEntryId", "entry.isFullWriteOff", "accountViewIn.id", "accountViewOut.id"};
        }
        if (selectors != null) {
            int len = selectors.length;
            for (int i = 0; i < len; ++i) {
                sic.add(new SelectorItemInfo((String)selectors[i]));
            }
        }
        return sic;
    }
}

