/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.IStandardCostAdjBill;
import com.kingdee.eas.scm.cal.StandardCostAdjBillCollection;
import com.kingdee.eas.scm.cal.StandardCostAdjBillEntryInfo;
import com.kingdee.eas.scm.cal.StandardCostAdjBillFactory;
import com.kingdee.eas.scm.cal.StandardCostAdjBillInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IInventoryBalance;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;
import com.kingdee.eas.scm.im.rpt.app.ImRptAppUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class StandardCostAdjImport
extends AbstractDataTransmission {
    private static final String impResources = "com.kingdee.eas.scm.cal.StandardCostAdjBillImportDataResource";
    private PeriodInfo currentPeriodInfo = null;
    private StandardCostAdjBillInfo standardCostAdjBillInfo = null;
    private CompanyOrgUnitInfo cou = null;
    IInventoryBalance iInventoryBalance = null;
    IMaterial iMaterial = null;
    private int amtPrecision = 2;
    private Set<String> materialNumberSet = new HashSet<String>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return StandardCostAdjBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private IMaterial getMaterialInstance(Context ctx) throws BOSException {
        if (this.iMaterial == null) {
            this.iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        }
        return this.iMaterial;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.cal.StandardCostAdjBillQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "number", rs.getString("number"));
            this.putTable(result, "baseStatus", rs.getString("baseStatus"));
            this.putTable(result, "bizDate", rs.getString("bizDate"));
            this.putTable(result, "companyOrgUnit.number", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "companyOrgUnit.name", rs.getString("companyOrgUnit.name"));
            this.putTable(result, "costCenterOrgUnit.number", rs.getString("costCenterOrgUnit.number"));
            this.putTable(result, "costCenterOrgUnit.name", rs.getString("costCenterOrgUnit.name"));
            this.putTable(result, "voucherNumber", rs.getString("voucherNumber"));
            this.putTable(result, "material.number", rs.getString("material.number"));
            this.putTable(result, "material.name", rs.getString("material.name"));
            this.putTable(result, "material.model", rs.getString("material.model"));
            this.putTable(result, "baseUnit.name", rs.getString("baseUnit.name"));
            this.putTable(result, "entry.baseQty", rs.getString("entry.baseQty"));
            this.putTable(result, "entry.oldStandardPrice", rs.getString("entry.oldStandardPrice"));
            this.putTable(result, "entry.oldStandardAmount", rs.getString("entry.oldStandardAmount"));
            this.putTable(result, "entry.newStandardPrice", rs.getString("entry.newStandardPrice"));
            this.putTable(result, "entry.newStandardAmount", rs.getString("entry.newStandardAmount"));
            this.putTable(result, "entry.diffPrice", rs.getString("entry.diffPrice"));
            this.putTable(result, "entry.diffAmount", rs.getString("entry.diffAmount"));
            this.putTable(result, "entry.remark", rs.getString("entry.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        TaskExternalException tex = new TaskExternalException("");
        int size = hsData.size();
        for (int i = 0; i < size; ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    this.materialNumberSet.clear();
                    this.standardCostAdjBillInfo = this.transmitHead(lineData, ctx);
                    if (this.standardCostAdjBillInfo == null) {
                        return null;
                    }
                }
                catch (TaskExternalException ex) {
                    tex.addEntryErrorReason(i, ex.getMessage());
                    break;
                }
            }
            try {
                StandardCostAdjBillEntryInfo entryInfo = this.transmitEntry(lineData, ctx);
                int seq = this.standardCostAdjBillInfo.getEntry().size() + 1;
                entryInfo.setSeq(seq);
                entryInfo.setParent(this.standardCostAdjBillInfo);
                this.standardCostAdjBillInfo.getEntry().add(entryInfo);
                continue;
            }
            catch (TaskExternalException ex) {
                tex.addEntryErrorReason(i, ex.getMessage());
            }
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.standardCostAdjBillInfo;
    }

    public String getMainField() {
        return "number";
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && currentNumber != null && firstNumber.data != null && !"".equals(firstNumber.data) && currentNumber.data != null && !"".equals(currentNumber.data) && firstNumber.equals((Object)currentNumber);
    }

    private StandardCostAdjBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        this.standardCostAdjBillInfo = new StandardCostAdjBillInfo();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object obj = ((DataToken)lineData.get((Object)"bizDate")).data;
        if (obj != null && obj.toString().length() > 0) {
            try {
                obj = df.parse(obj.toString().trim());
            }
            catch (ParseException e) {
                throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "InvalidDateFormat", impResources) + obj.toString());
            }
            if (obj != null && obj instanceof Date) {
                this.standardCostAdjBillInfo.setBizDate((Date)obj);
            }
        } else {
            throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "InvalidDateFormat", impResources) + obj.toString());
        }
        obj = ((DataToken)lineData.get((Object)"companyOrgUnit.number")).data;
        if (obj != null && obj.toString().length() > 0) {
            try {
                ICompanyOrgUnit iOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection col = iOrg.getCompanyOrgUnitCollection(this.getFilter(obj.toString(), "number"));
                if (col.size() <= 0) {
                    throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "couNotExist", impResources) + obj.toString());
                }
                this.cou = col.get(0);
                this.standardCostAdjBillInfo.setCompanyOrgUnit(col.get(0));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        } else {
            throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "couEmpty", impResources));
        }
        try {
            this.doNumber(ctx, lineData);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        try {
            CurrencyInfo baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.cou.getBaseCurrency().getId()));
            this.amtPrecision = baseCurrInfo.getPrecision();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        try {
            this.currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.cou);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TaskExternalException(e.getMessage());
        }
        if (this.standardCostAdjBillInfo.getBizDate().getTime() < this.currentPeriodInfo.getBeginDate().getTime()) {
            throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "bizDateLessThanPeriodStart", impResources));
        }
        this.standardCostAdjBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return this.standardCostAdjBillInfo;
    }

    private IInventoryBalance getInventoryBalanceInstance(Context ctx) throws BOSException {
        if (this.iInventoryBalance == null) {
            this.iInventoryBalance = InventoryBalanceFactory.getLocalInstance((Context)ctx);
        }
        return this.iInventoryBalance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doNumber(Context ctx, Hashtable lineData) throws TaskExternalException, EASBizException, BOSException {
        boolean isUsedParam = DataImportUtils.getImportParam((Context)ctx);
        if (isUsedParam) {
            String souID = this.cou.getId().toString().trim();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            if (!iCodingRuleManager.isExist((IObjectValue)this.standardCostAdjBillInfo, souID)) throw new SCMBillException(SCMBillException.NOCORDRULE);
            this.standardCostAdjBillInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.standardCostAdjBillInfo, souID, ""));
            return;
        }
        Object obj = ((DataToken)lineData.get((Object)"number")).data;
        if (obj == null || obj.toString() == null || obj.toString().trim().length() <= 0) return;
        String number = obj.toString().trim();
        String billID = this.getIdFromNumber(number, ctx);
        this.standardCostAdjBillInfo.setNumber(number);
        boolean isSltImportUpdate = this.isSltImportUpdate();
        if (!isSltImportUpdate && !StringUtil.isEmptyString((String)billID)) {
            throw new TaskExternalException(number + StandardCostAdjImport.getResource(ctx, "EXISTS", impResources));
        }
        if (!isSltImportUpdate || StringUtil.isEmptyString((String)billID)) return;
        StandardCostAdjBillInfo existInfo = null;
        try {
            existInfo = ((IStandardCostAdjBill)this.getController(ctx)).getStandardCostAdjBillInfo((IObjectPK)new ObjectUuidPK(billID));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        if (BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)existInfo.getBaseStatus())) return;
        throw new TaskExternalException(number + StandardCostAdjImport.getResource(ctx, "UnTEMPORARILYSAVEDERROE", impResources));
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        StandardCostAdjBillCollection standardCostAdjBillCollection;
        try {
            standardCostAdjBillCollection = StandardCostAdjBillFactory.getLocalInstance(ctx).getStandardCostAdjBillCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (standardCostAdjBillCollection != null && standardCostAdjBillCollection.size() > 0) {
            return standardCostAdjBillCollection.get(0).getId().toString().trim();
        }
        return null;
    }

    private static String getResource(Context ctx, String strKey, String resource) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    private EntityViewInfo getFilter(String value, String byProperty) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(byProperty, (Object)value, CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StandardCostAdjBillEntryInfo transmitEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null) {
            return null;
        }
        StandardCostAdjBillEntryInfo entryInfo = new StandardCostAdjBillEntryInfo();
        try {
            BigDecimal price = BigDecimal.ZERO;
            int pricePrecision = 2;
            Object data = ((DataToken)hsData.get((Object)"material.number")).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "materialNumberEmpty", impResources));
            String number = data.toString().trim();
            if (this.materialNumberSet.contains(number)) {
                throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "materialReduplicate", impResources));
            }
            this.materialNumberSet.add(number);
            this.iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            MaterialCollection collection = this.iMaterial.getMaterialCollection(this.getFilter(number, "number"));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + StandardCostAdjImport.getResource(ctx, "MaterialNotExists", impResources));
            MaterialInfo info = collection.get(0);
            if (info == null) throw new TaskExternalException(data.toString() + " " + StandardCostAdjImport.getResource(ctx, "MaterialNotExists", impResources));
            MaterialCompanyInfoInfo materialCompanyInfo = this.iMaterial.getCompanyInfo(info.getId().toString(), this.cou.getId().toString());
            if (materialCompanyInfo == null) {
                throw new TaskExternalException(info.getNumber() + " " + this.cou.getNumber() + " " + StandardCostAdjImport.getResource(ctx, "NO_COMPANY_PROPERTY", impResources));
            }
            if (materialCompanyInfo.getAccountType() != AccountType.STANDARDCOST) {
                throw new TaskExternalException(data.toString() + " " + StandardCostAdjImport.getResource(ctx, "MateiralNotStandard", impResources));
            }
            pricePrecision = info.getPricePrecision();
            entryInfo.setMaterial(info);
            entryInfo.setBaseUnit(info.getBaseUnit());
            data = ((DataToken)hsData.get((Object)"entry.newStandardPrice")).data;
            if (data == null || data.toString() == null || data.toString().trim().length() <= 0) throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "newPriceEmpty", impResources));
            try {
                price = ImRptAppUtils.getDataDeciaml((Context)ctx, (String)data.toString().trim());
                price = price.setScale(pricePrecision, 4);
                if (price.compareTo(BigDecimal.ZERO) <= 0) {
                    throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "newPriceLessThanZero", impResources));
                }
                entryInfo.setNewStandardPrice(price);
            }
            catch (TaskExternalException e1) {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Exception e) {
                throw new TaskExternalException(StandardCostAdjImport.getResource(ctx, "newPriceEmpty", impResources));
            }
            data = ((DataToken)hsData.get((Object)"entry.remark")).data;
            if (data != null && data.toString() != null && data.toString().trim().length() > 0) {
                String remark = data.toString().trim();
                entryInfo.setRemark(remark);
            }
            Map result = this.getInventoryBalanceInstance(ctx).getPeriodBeginQtyAndAmount(info.getId().toString(), this.cou.getId().toString(), null, null, this.currentPeriodInfo);
            BigDecimal qty = (BigDecimal)result.get("beginQty");
            BigDecimal oldAmt = (BigDecimal)result.get("beginBalance");
            entryInfo.setBaseQty(qty);
            entryInfo.setOldStandardAmount(oldAmt);
            BigDecimal newAmt = price.multiply(qty).setScale(this.amtPrecision, 4);
            entryInfo.setNewStandardAmount(newAmt);
            entryInfo.setDiffAmount(newAmt.subtract(oldAmt));
            MaterialCompanyInfoInfo matCompanyInfo = this.getMaterialInstance(ctx).getCompanyInfo(info.getId().toString(), this.cou.getId().toString());
            if (matCompanyInfo == null) return entryInfo;
            BigDecimal costPrice = matCompanyInfo.getStandardCost();
            if (costPrice == null) {
                costPrice = BigDecimal.ZERO;
            }
            costPrice = costPrice.setScale(pricePrecision, 4);
            entryInfo.setOldStandardPrice(costPrice);
            BigDecimal diffPrice = price.subtract(costPrice);
            entryInfo.setDiffPrice(diffPrice);
            return entryInfo;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null) {
            return;
        }
        try {
            IObjectPK userPk = ctx.getCaller();
            ObjectUuidPK orgPk = new ObjectUuidPK(this.cou.getId());
            SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)userPk, (IObjectPK)orgPk, (String)"standardcost_new");
            StandardCostAdjBillInfo standardCostAdjBillInfo = (StandardCostAdjBillInfo)coreBaseInfo;
            standardCostAdjBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            String id = this.getIdFromNumber(standardCostAdjBillInfo.getNumber(), ctx);
            if (StringUtil.isEmptyString((String)id)) {
                ServiceStateManager.getInstance().enableNextCallServices();
                this.getController(ctx).addnew((CoreBaseInfo)standardCostAdjBillInfo);
            } else {
                this.getController(ctx).delete((IObjectPK)new ObjectUuidPK(id));
                ServiceStateManager.getInstance().enableNextCallServices();
                this.getController(ctx).addnew(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public int getSubmitType() {
        return 1;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        Object filterInfo = null;
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        if (oldFilterInfo == null) {
            oldFilterInfo = new FilterInfo();
        }
        return oldFilterInfo;
    }
}

