/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.CalculateTypeEnum;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeFactory;
import com.kingdee.eas.basedata.scm.im.inv.StoreTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractStockDetailReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.rpt.IMRptUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StockDetailReportFacadeControllerBean
extends AbstractStockDetailReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final String newline = "\r\n";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.StockDetailReportFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    private static final String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_AR_OtherBill", "T_AR_OtherBillEntry"}};

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = null;
        String tmpPeriodTable = null;
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int beginOldYear = beginYear;
        int beginOldPeriod = beginPeriod;
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        int toPeriod = endYear * 100 + endPeriod;
        String sql = "";
        String formaStr = RptCellFormatter.getTrimZeroFormat();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        params.setInt("amtPrecision", amtPrecision);
        long lStart = 0L;
        long lEnd = 0L;
        lStart = this.GetNowTime();
        sql = this.getCreateTempTab(ctx, tempTable);
        sql = CalculateUtil.transCreateTable(ctx, sql);
        tempTable = this.createTempTable(ctx, sql);
        params.setString("tempTable", tempTable);
        DBUtil.createTempTableIndex(ctx, tempTable, "forderidx", false);
        String newTempTable = this.createTempTable(ctx, sql);
        DBUtil.createTempTableIndex(ctx, newTempTable, "KSQL_SEQ", false);
        int prcPrecision = 0;
        int qtyPrecision = 0;
        String qtyFormat = null;
        String prcFormat = null;
        String amtFormat = null;
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)aCompanyOrgUnitInfo.getId().toString(), (String)"stockdetailreport_view");
        if (checkPermission) {
            IParamControl ipc;
            String isUpdateByARBILL;
            sql = "Create Table tmpPeriodTable (FCompanyOrgUnitID VARCHAR(44) NOT NULL ,FMaterialID VARCHAR(44) NOT NULL,FYear INT,FPeriod INT);";
            tmpPeriodTable = this.createTempTable(ctx, sql);
            lEnd = this.GetNowTime();
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
            PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
            if (100 * beginYear + beginPeriod > currentPeriod) {
                beginYear = currentPeriodInfo.getPeriodYear();
                beginPeriod = currentPeriodInfo.getPeriodNumber();
                params.setInt("accPeriodYearFrom", beginYear);
                params.setInt("accPeriodMonthFrom", beginPeriod);
            }
            boolean isArUpdateInventory = (isUpdateByARBILL = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)params.getObject("company")).getId().toString()), "CONSIGNSALES")) == null ? false : isUpdateByARBILL.trim().equals("true");
            params.setBoolean("isArUpdateInventory", isArUpdateInventory);
            lStart = this.GetNowTime();
            this.getPeriodHappen(ctx, tempTable, params);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u53d6\u5f97\u53d1\u751f\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            lStart = this.GetNowTime();
            sql = this.getPeriodSql(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u83b7\u53d6\u8be5\u7269\u6599\u6709\u53d1\u751f\u7684\u4f1a\u8ba1\u671f\u95f4\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            lStart = this.GetNowTime();
            sql = this.getPeriodBegin(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            lEnd = this.GetNowTime();
            logger.debug((Object)("\u53d6\u5f97\u671f\u521d\u65f6\u95f4:" + String.valueOf(lEnd - lStart)));
            if (toPeriod > currentPeriod) {
                this.insertNextPeriodBegin(ctx, tempTable, currentPeriodInfo, nextPeriodInfo, params);
            }
            int nextPeriod = -1;
            if (nextPeriodInfo != null) {
                nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
            }
            if (toPeriod > nextPeriod && nextPeriod != -1) {
                PeriodInfo next2PeriodInfo = null;
                try {
                    next2PeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo);
                }
                catch (BOSException be) {
                    logger.info((Object)"next 2 period is null");
                }
                catch (EASBizException ee) {
                    logger.info((Object)"next 2 period is null");
                }
                if (next2PeriodInfo != null) {
                    this.insertNextPeriodBegin(ctx, tempTable, nextPeriodInfo, next2PeriodInfo, params);
                }
            }
            amtFormat = CalculateUtil.getFormatPattern(amtPrecision);
            IMaterial aIMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)params.getObject("CurrentMaterialID").toString()));
            MaterialInfo aMaterialInfo = aIMaterial.getMaterialInfo((IObjectPK)pk);
            prcPrecision = aMaterialInfo.getPricePrecision();
            prcFormat = CalculateUtil.getFormatPattern(prcPrecision);
            qtyFormat = null;
            MeasureUnitInfo aMeasureUnitInfo = aMaterialInfo.getBaseUnit();
            String sSQL = "select FQtyPrecision from T_BD_MultiMeasureUnit where FMaterialID='" + aMaterialInfo.getId().toString() + "' and FMeasureUnitID='" + aMeasureUnitInfo.getId().toString() + "'";
            RptRowSet rs = this.executeQuery(sSQL, null, ctx);
            qtyPrecision = 6;
            if (rs.first()) {
                qtyPrecision = rs.getInt(0);
                qtyFormat = CalculateUtil.getFormatPattern(qtyPrecision);
            } else {
                qtyFormat = formaStr;
            }
            this.roundDetailData(ctx, tempTable, amtPrecision, prcPrecision, qtyPrecision);
            sql = this.getPeriodTotal(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDealNextPeriod(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getPeriodYearTotal(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getDropTmpPeriodTab(ctx, tempTable, tmpPeriodTable, params);
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FYear=null Where FYear=0 ";
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FPeriod=null Where FPeriod=0 ";
            this.executeSQL(ctx, sql);
            if (100 * beginOldYear + beginOldPeriod > currentPeriod) {
                sql = "delete from " + tempTable + " where 100*fyear + fperiod < " + (100 * beginOldYear + beginOldPeriod);
                this.executeSQL(ctx, sql);
            }
            String sql2 = "delete from " + tempTable + " where FINQTY = 0 and FINAMOUNT = 0 and FOUTQTY = 0 and FOUTAMOUNT = 0 and FREMAINQTY = 0 and FREMAINAMOUNT = 0 and FINDEX = 0 ";
            this.executeSQL(ctx, sql2);
            params.setInt("accPeriodYearFrom", beginOldYear);
            params.setInt("accPeriodMonthTo", beginOldPeriod);
            this.copyToNewTempTable(ctx, tempTable, newTempTable);
            this.dropTempTable(tempTable, ctx);
        }
        amtPrecision = params.getInt("spinAmountPrecission");
        prcPrecision = params.getInt("spinPricePrecission");
        qtyPrecision = params.getInt("spinQtyPrecission");
        qtyFormat = CalculateUtil.getFormatPattern(qtyPrecision);
        prcFormat = CalculateUtil.getFormatPattern(prcPrecision);
        amtFormat = CalculateUtil.getFormatPattern(amtPrecision);
        RptTableHeader header = this.getRptTableHeader(ctx, qtyFormat, prcFormat, amtFormat);
        String countSql = "select count(1) cc from " + newTempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptParams result = new RptParams();
        result.setString("tempTable", newTempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    private void copyToNewTempTable(Context ctx, String tempTable, String newTempTable) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(newTempTable).append("(");
        sb.append(this.getSelects(true));
        sb.append(")");
        sb.append(" select ").append(this.getSelects(false));
        sb.append(" from ").append(tempTable);
        sb.append(" Order by FYear,IsNull(FPeriod, 99),FIndex,FBizDate,FAuditTime,FBillNumber,FSeq,ABS(isnull(FInQty,0)),FOrderIdx");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getSelects(boolean hasKsqlSeq) {
        StringBuffer sb = new StringBuffer();
        if (hasKsqlSeq) {
            sb.append("KSQL_SEQ,");
        }
        sb.append("FOrderIdx,FIndex,FID,FMaterialID,FBillType,FYear,FPeriod,FVoucherNumber,FVoucherSummary,FBizDate,FAuditTime,FBillNumber,FBizTypeName,FTransactionTypeName,");
        sb.append("FAssistantAttrName,FSeq,FInQty,FInUnitPrice,FInAmount,FOutQty,FOutUnitPrice,FOutAmount,FRemainQty,FRemainUnitPrice,FRemainAmount,FRemark,FLot,FProjectNumber,FProjectName,");
        sb.append("FTrackNumber,FTrackName,FStorageOrgUnitID,FWarehouseID,FStoreTypeID");
        return sb.toString();
    }

    private void roundDetailData(Context ctx, String tempTable, int amtPrecision, int prcPrecision, int qtyPrecision) throws BOSException {
        StringBuffer sqlStr = new StringBuffer();
        sqlStr.append(" Update " + tempTable + " as t10 Set (");
        sqlStr.append(" FInQty,FInUnitPrice,FInAmount,FOutQty,FOutUnitPrice,FOutAmount,FRemainQty,FRemainUnitPrice,FRemainAmount )=");
        sqlStr.append(" (select ");
        sqlStr.append(" round(t1.FInQty,").append(qtyPrecision).append(") as FInQty,");
        sqlStr.append(" round(t1.FInUnitPrice,").append(prcPrecision).append(") as FInUnitPrice,");
        sqlStr.append(" round(t1.FInAmount,").append(amtPrecision).append(") as FInAmount,");
        sqlStr.append(" round(t1.FOutQty,").append(qtyPrecision).append(") as FOutQty,");
        sqlStr.append(" round(t1.FOutUnitPrice,").append(prcPrecision).append(") as FOutUnitPrice,");
        sqlStr.append(" round(t1.FOutAmount,").append(amtPrecision).append(") as FOutAmount,");
        sqlStr.append(" round(t1.FRemainQty,").append(qtyPrecision).append(") as FRemainQty,");
        sqlStr.append(" round(t1.FRemainUnitPrice,").append(prcPrecision).append(") as FRemainUnitPrice,");
        sqlStr.append(" round(t1.FRemainAmount,").append(amtPrecision).append(")as FRemainAmount ");
        sqlStr.append(" From " + tempTable + " as  t1  where t1.findex = 0 and t1.forderidx = t10.forderidx)");
        this.executeSQL(ctx, sqlStr.toString());
    }

    protected RptTableHeader getRptTableHeader(Context ctx, String qtyFormat, String prcFormat, String amtFormat) {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FYear");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FPeriod");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FVoucherNumber");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FVoucherSummary");
        col.setWidth(100);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("FBizDate");
        col.setWidth(90);
        col.setFormatPattern("yyyy-MM-dd");
        header.addColumn(col);
        col = new RptTableColumn("FAuditTime");
        col.setWidth(90);
        col.setFormatPattern("yyyy-MM-dd HH:mm:ss");
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FNumber");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FBizType");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnitNumber");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FStorageOrgUnitName");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FWarehouseNumber");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FWarehouseName");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FStoreTypeName");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FTransactionType");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FLot");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FAssistAttr");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FprojectNumber");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FprojectName");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FtrackNumber");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FtrackName");
        col.setWidth(100);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FInQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainQty");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainUnitPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemark");
        col.setWidth(400);
        col.setAligment(0);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FBillType");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FOrderIdx");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VOUCHERNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VoucherSummary", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AuditTime", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BIZTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStorageOrgUnitNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStorageOrgUnitName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FWarehouseNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FWarehouseName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStoreTypeName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"LOT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ACCESSORIAL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"Remark", (Context)ctx), "FIndex", "FID", "materielID", SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx), "FOrderIdx"}, {SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VOUCHERNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"VoucherSummary", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLDATE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AuditTime", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BILLNO", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BIZTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStorageOrgUnitNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStorageOrgUnitName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FWarehouseNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FWarehouseName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FStoreTypeName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"TRANSTYPE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"LOT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"ACCESSORIAL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"projectName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackNumber", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"trackName", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"Remark", (Context)ctx), "FIndex", "FID", "materielID", SCMUtils.getResource((String)this.res, (String)"BILLTYPE", (Context)ctx), "FOrderIdx"}}, true);
        return header;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        RptParams pp = new RptParams();
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        IMaterial aIMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)params.getObject("CurrentMaterialID").toString()));
        MaterialInfo aMaterialInfo = aIMaterial.getMaterialInfo((IObjectPK)pk);
        int prcPrecision = aMaterialInfo.getPricePrecision();
        MeasureUnitInfo aMeasureUnitInfo = aMaterialInfo.getBaseUnit();
        int qtyPrecision = 6;
        String sSQL = "select FQtyPrecision from T_BD_MultiMeasureUnit where FMaterialID='" + aMaterialInfo.getId().toString() + "' and FMeasureUnitID='" + aMeasureUnitInfo.getId().toString() + "'";
        RptRowSet rs0 = this.executeQuery(sSQL, null, ctx);
        if (rs0.first()) {
            qtyPrecision = rs0.getInt(0);
        }
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("Select bill.FYear,bill.FPeriod,bill.FVoucherNumber,bill.FVoucherSummary,bill.FBizDate,bill.FAuditTime,bill.FBillNumber,bill.FBizTypeName,");
        selectSql.append(" org.fnumber as FStorageOrgUnitNumber,org.fname_" + this.getLoc(ctx) + " as FStorageOrgUnitName,");
        selectSql.append(" wh.fnumber as FWarehouseNumber,wh.fname_" + this.getLoc(ctx) + " as FWarehouseName,");
        selectSql.append(" storeType.fname_" + this.getLoc(ctx) + " as FStoreTypeName,");
        selectSql.append(" isnull(bill.FTransactionTypeName,' ') as FTransactionTypeName ,bill.FLot,bill.FAssistantAttrName,");
        selectSql.append(" bill.FProjectNumber,bill.FProjectName,bill.FTrackNumber,bill.FTrackName,");
        selectSql.append(" round(bill.FInQty,").append(qtyPrecision).append(") as FInQty,");
        selectSql.append(" round(CASE WHEN isnull(bill.FInQty,0)=0 THEN Null ELSE round(decimal(bill.FInAmount,17,4)/decimal(bill.FInQty,21,8),6) END,").append(prcPrecision).append(") FInUnitPrice, ");
        selectSql.append(" round(bill.FInAmount,").append(amtPrecision).append(") as FInAmount,");
        selectSql.append(" round(bill.FOutQty,").append(qtyPrecision).append(") as FOutQty,");
        selectSql.append(" round(CASE WHEN isnull(bill.FOutQty,0)=0 THEN Null ELSE round(decimal(bill.FOutAmount,17,4)/decimal(bill.FOutQty,21,8),6) END,").append(prcPrecision).append(") FOutUnitPrice, ");
        selectSql.append(" round(bill.FOutAmount,").append(amtPrecision).append(") as FOutAmount,round(bill.FRemainQty,").append(qtyPrecision).append(") as FRemainQty,");
        selectSql.append(" round(CASE WHEN isnull(bill.FRemainQty,0)=0 THEN Null ELSE round(decimal(bill.FRemainAmount,17,4)/decimal(bill.FRemainQty,21,8),6) END,").append(prcPrecision).append(") FRemainUnitPrice, ");
        selectSql.append(" round(bill.FRemainAmount,").append(amtPrecision).append(")as FRemainAmount,");
        selectSql.append(" bill.FRemark,bill.FIndex,bill.FID,bill.FMaterialID,bill.FBillType,bill.FOrderIdx ");
        selectSql.append("FROM " + params.getString("tempTable")).append(" as bill ");
        selectSql.append(" LEFT OUTER JOIN T_ORG_Storage org on bill.fstorageorgunitid = org.fid ");
        selectSql.append(" LEFT OUTER JOIN T_DB_Warehouse wh ON bill.FWarehouseID = wh.FID ");
        selectSql.append(" LEFT OUTER JOIN T_IM_STORETYPE storeType ON bill.FStoreTypeID = storeType.FID ");
        StringBuffer orderSql = new StringBuffer();
        orderSql.append(" Order by KSQL_SEQ ASC");
        int start = from + 1;
        int end = from + len;
        StringBuffer whereSql = new StringBuffer();
        whereSql.append(" where KSQL_SEQ >=").append(start).append(" and KSQL_SEQ <=").append(end);
        sql.append(selectSql).append(whereSql).append(orderSql);
        if ("true".equals(params.getString("isPrint"))) {
            StringBuffer printSql = new StringBuffer();
            printSql.append(selectSql).append(orderSql);
            RptRowSet printRs = this.executeQuery(printSql.toString(), null, ctx);
            pp.setObject("printRs", (Object)printRs);
        } else {
            RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
            this.calQueryEndData(ctx, rs, params, selectSql.toString(), orderSql.toString());
            pp.setObject("rowset", (Object)rs);
        }
        return pp;
    }

    private void calQueryEndData(Context ctx, RptRowSet rs, RptParams params, String selectSql, String orderSql) throws BOSException, EASBizException {
        String periodbegin = SCMUtils.getResource((String)this.res, (String)"BEGINBALANCE", (Context)ctx);
        String periodTotal = SCMUtils.getResource((String)this.res, (String)"PERIODTOTAL", (Context)ctx);
        String yearTotal = SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx);
        HashSet<Integer> periodSet = new HashSet<Integer>();
        int year = 0;
        int period = 0;
        while (rs.next()) {
            if (rs.getObject("FYEAR") == null || rs.getObject("FPERIOD") == null) continue;
            year = rs.getInt("FYEAR");
            period = rs.getInt("FPERIOD");
            periodSet.add(year * 100 + period);
        }
        if (periodSet.size() == 0) {
            rs.reset();
            return;
        }
        String periodStr = CollectionUtil.convertList2String(new ArrayList(periodSet), (String)",");
        StringBuffer sb = new StringBuffer();
        sb.append(selectSql);
        sb.append(" WHERE FYear*100+FPeriod in (").append(periodStr).append(") ");
        sb.append(orderSql);
        RptRowSet dataRs = this.executeQuery(sb.toString(), null, ctx);
        int prcPrecision = 2;
        if (params.getString("CurrentMaterialID") != null) {
            MaterialInfo aMaterialInfo = MaterialFactory.getLocalInstance((Context)ctx).getMaterialInfo((IObjectPK)new ObjectUuidPK(params.getString("CurrentMaterialID")));
            prcPrecision = aMaterialInfo.getPricePrecision();
        }
        Map beforeRowMap = new HashMap();
        HashMap dataRowMap = new HashMap();
        String transactionTypeName = null;
        BigDecimal beforeEndAmount = BigDecimal.ZERO;
        BigDecimal beforeEndQty = BigDecimal.ZERO;
        BigDecimal curEndAmount = BigDecimal.ZERO;
        BigDecimal curEndQty = BigDecimal.ZERO;
        BigDecimal curInQty = BigDecimal.ZERO;
        BigDecimal curInAmount = BigDecimal.ZERO;
        BigDecimal curOutQty = BigDecimal.ZERO;
        BigDecimal curOutAmount = BigDecimal.ZERO;
        BigDecimal curEndPrice = BigDecimal.ZERO;
        while (dataRs.next()) {
            transactionTypeName = dataRs.getString("FTRANSACTIONTYPENAME");
            if (periodbegin.equals(transactionTypeName)) {
                beforeRowMap = dataRs.toRowMap();
                continue;
            }
            if (periodTotal.equals(transactionTypeName) || yearTotal.equals(transactionTypeName) || beforeRowMap == null || beforeRowMap.size() <= 0) continue;
            beforeEndQty = beforeRowMap.get("FREMAINQTY") == null ? BigDecimal.ZERO : (BigDecimal)beforeRowMap.get("FREMAINQTY");
            beforeEndAmount = beforeRowMap.get("FREMAINAMOUNT") == null ? BigDecimal.ZERO : (BigDecimal)beforeRowMap.get("FREMAINAMOUNT");
            curInQty = dataRs.getBigDecimal("FINQTY") == null ? BigDecimal.ZERO : dataRs.getBigDecimal("FINQTY");
            curOutQty = dataRs.getBigDecimal("FOUTQTY") == null ? BigDecimal.ZERO : dataRs.getBigDecimal("FOUTQTY");
            curInAmount = dataRs.getBigDecimal("FINAMOUNT") == null ? BigDecimal.ZERO : dataRs.getBigDecimal("FINAMOUNT");
            curOutAmount = dataRs.getBigDecimal("FOUTAMOUNT") == null ? BigDecimal.ZERO : dataRs.getBigDecimal("FOUTAMOUNT");
            curEndQty = beforeEndQty.subtract(curOutQty).add(curInQty);
            curEndAmount = beforeEndAmount.subtract(curOutAmount).add(curInAmount);
            curEndPrice = CalculateUtils.calActualPrice((BigDecimal)curEndAmount, (BigDecimal)curEndQty, (int)prcPrecision);
            dataRs.setValue("FREMAINQTY", (Object)curEndQty);
            dataRs.setValue("FREMAINAMOUNT", (Object)curEndAmount);
            dataRs.setValue("FREMAINUNITPRICE", (Object)curEndPrice);
            beforeRowMap = dataRs.toRowMap();
            dataRowMap.put(dataRs.getString("FOrderIdx"), beforeRowMap);
        }
        rs.reset();
        String fid = null;
        Map rowDataMap = null;
        while (rs.next()) {
            fid = rs.getString("FOrderIdx");
            rowDataMap = (Map)dataRowMap.get(fid);
            if (rowDataMap == null) continue;
            curEndQty = (BigDecimal)rowDataMap.get("FREMAINQTY");
            curEndAmount = (BigDecimal)rowDataMap.get("FREMAINAMOUNT");
            curEndPrice = (BigDecimal)rowDataMap.get("FREMAINUNITPRICE");
            rs.setValue("FREMAINQTY", (Object)curEndQty);
            rs.setValue("FREMAINAMOUNT", (Object)curEndAmount);
            rs.setValue("FREMAINUNITPRICE", (Object)curEndPrice);
        }
        rs.reset();
    }

    private String getCreateTempTab(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE TempReportTable (");
        sql.append("KSQL_SEQ INT IDENTITY(1,1),");
        sql.append("FOrderIdx VARCHAR(44),");
        sql.append("FIndex INT DEFAULT 0,");
        sql.append("FID VARCHAR(44),");
        sql.append("FMaterialID VARCHAR(44), ");
        sql.append("FBillType INT NOT NULL,");
        sql.append("FYear INT,");
        sql.append("FPeriod INT,");
        sql.append("FVoucherNumber NVARCHAR(80),");
        sql.append("FVoucherSummary VARCHAR(1000),");
        sql.append("FBizDate DATETIME,");
        sql.append("FAuditTime DATETIME,");
        sql.append("FBillNumber NVARCHAR(80),");
        sql.append("FBizTypeName VARCHAR(255),");
        sql.append("FTransactionTypeName VARCHAR(255),");
        sql.append("FAssistantAttrName VARCHAR(255),");
        sql.append("FSeq INT DEFAULT 0,");
        sql.append("FInQty NUMERIC(28,16) default 0,");
        sql.append("FInUnitPrice NUMERIC(28,16) default 0,");
        sql.append("FInAmount NUMERIC(19,4) default 0,");
        sql.append("FOutQty NUMERIC(28,16) default 0,");
        sql.append("FOutUnitPrice NUMERIC(28,16) default 0,");
        sql.append("FOutAmount NUMERIC(19,4) default 0,");
        sql.append("FRemainQty NUMERIC(28,16) default 0,");
        sql.append("FRemainUnitPrice NUMERIC(28,16) default 0,");
        sql.append("FRemainAmount NUMERIC(19,4) default 0,");
        sql.append("FRemark NVARCHAR(400),");
        sql.append("FLot VARCHAR(255),");
        sql.append("FProjectNumber NVARCHAR(80),");
        sql.append("FProjectName NVARCHAR(255),");
        sql.append("FTrackNumber NVARCHAR(80),");
        sql.append("FTrackName NVARCHAR(255), ");
        sql.append("FStorageOrgUnitID VARCHAR(44), ");
        sql.append("FWarehouseID VARCHAR(44), ");
        sql.append("FStoreTypeID VARCHAR(44) ");
        sql.append(")");
        return sql.toString();
    }

    private String getCreateTempStandardTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE TempReportTable (");
        sql.append("FBALANCEID VARCHAR(44),");
        sql.append("FBILLID VARCHAR(44),");
        sql.append("FMATERIALID VARCHAR(44),");
        sql.append("FWAREHOUSEID VARCHAR(44),");
        sql.append("FYEAR INT,");
        sql.append("FPERIOD INT,");
        sql.append("FBIZDATE DATETIME,");
        sql.append("FAUDITTIME DATETIME,");
        sql.append("FBillNumber NVARCHAR(80),");
        sql.append("FVoucherID VARCHAR(44),");
        sql.append("FBillTypeID VARCHAR(44),");
        sql.append("FAssistPropertyID VARCHAR(44),");
        sql.append("FRemark NVARCHAR(400),");
        sql.append("FSEQ INT,");
        sql.append("FDIFFAMOUNT NUMERIC(19,4) default 0,");
        sql.append("FAMOUNT NUMERIC(19,4) default 0,");
        sql.append("FTAILDIFF NUMERIC(19,4) default 0)");
        return sql.toString();
    }

    private void getPeriodHappen(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        int i;
        StringBuffer prmtKAClassids;
        boolean isJoinQuery;
        int i2;
        StringBuffer sqlWhere = new StringBuffer();
        String fiOrgUnitID = null;
        String CurrentMaterial = null;
        String warehouseFrom = null;
        String warehouseTo = null;
        String warehouseIn = null;
        String warehouse = null;
        String storageOrgUnitID = null;
        String warehouseID = null;
        boolean ckShowNoCalculate = false;
        boolean noSelectStorageMoveBill = false;
        boolean noSelectWarehouseMoveBill = false;
        int voucher = -1;
        int calType = -1;
        int status = -1;
        StringBuffer bizTypeStr = new StringBuffer();
        StringBuffer transTypeStr = new StringBuffer();
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        if (params.getObject("calType") != null) {
            calType = ((CalculateTypeEnum)params.getObject("calType")).getValue();
        }
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        if (params.getObject("bizType") != null) {
            Object[] bizTypeArray = (Object[])params.getObject("bizType");
            for (i2 = 0; i2 < bizTypeArray.length; ++i2) {
                if (bizTypeArray[i2] == null) continue;
                if (i2 > 0) {
                    bizTypeStr.append(",");
                }
                bizTypeStr.append("'").append(((BizTypeInfo)bizTypeArray[i2]).getId().toString()).append("'");
            }
        }
        if (params.getObject("transactionType") != null) {
            Object[] transTypeArray = (Object[])params.getObject("transactionType");
            for (i2 = 0; i2 < transTypeArray.length; ++i2) {
                if (transTypeArray[i2] == null) continue;
                if (i2 > 0) {
                    transTypeStr.append(",");
                }
                transTypeStr.append("'").append(((TransactionTypeInfo)transTypeArray[i2]).getId().toString()).append("'");
            }
        }
        if (isJoinQuery = params.getBoolean("IsJoinQuery")) {
            warehouse = params.getString("warehouse");
        } else {
            if (params.getObject("warehouseFrom") != null) {
                if (params.getObject("warehouseFrom") instanceof Object[]) {
                    Object[] warehouses = (Object[])params.getObject("warehouseFrom");
                    if (warehouses.length == 1) {
                        warehouseFrom = ((WarehouseInfo)warehouses[0]).getNumber();
                    } else {
                        warehouseIn = CalculateUtil.getObjArrayNumberWithQuote(warehouses);
                    }
                } else {
                    warehouseFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
                }
            }
            if (params.getObject("warehouseTo") != null) {
                warehouseTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            }
        }
        if (params.getString("FStorageOrgUnit") != null) {
            storageOrgUnitID = params.getString("FStorageOrgUnit");
        }
        if (params.getString("FWarehouse") != null) {
            warehouseID = params.getString("FWarehouse");
        }
        ckShowNoCalculate = params.getBoolean("ckShowNoCalculate");
        noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int periodMTo = params.getInt("accPeriodMonthTo");
        sqlWhere.append(" And ( h.FBaseStatus = 2 or h.FBaseStatus = 4) ");
        sqlWhere.append(" And (h.FIsInitBill = 0 or  h.FIsInitBill is null )");
        sqlWhere.append(" And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'");
        if (periodYFrom == periodYTo && periodMFrom == periodMTo) {
            sqlWhere.append(" AND h.FYear = " + periodYFrom + " AND h.FPeriod = " + periodMFrom + " ");
        } else {
            sqlWhere.append(" AND (h.FYear*100+h.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FYear*100+h.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ");
        }
        sqlWhere.append(" AND (h.FYear*100+h.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FYear*100+h.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ");
        if (storageOrgUnitID != null) {
            sqlWhere.append(" AND h.FStorageOrgUnitID = '" + storageOrgUnitID + "'");
        }
        if (warehouseID != null) {
            sqlWhere.append(" AND wh.fid = '" + warehouseID + "'");
        }
        if (CurrentMaterial != null) {
            sqlWhere.append(" AND d.FMaterialID = '" + CurrentMaterial + "' ");
        }
        if (isJoinQuery) {
            if (warehouse != null) {
                sqlWhere.append(" AND wh.FNumber in(" + warehouse + ")");
            }
        } else {
            if (warehouseFrom != null) {
                sqlWhere.append(" AND wh.FNumber >= '" + warehouseFrom + "' ");
            }
            if (warehouseTo != null) {
                sqlWhere.append(" AND wh.FNumber <= '" + warehouseTo + "' ");
            }
            if (warehouseIn != null) {
                sqlWhere.append(" AND wh.FNumber in (" + warehouseIn + ") ");
            }
        }
        String storeType = null;
        StringBuffer storeTypeFilter = new StringBuffer();
        if (params.getString("storeType") != null && (storeType = params.getString("storeType")) != null) {
            String[] storeTypes = storeType.split(",");
            storeTypeFilter.append(" AND storetype.FNumber in (");
            int length = storeTypes.length;
            for (int i3 = 0; i3 < length; ++i3) {
                if (i3 > 0) {
                    storeTypeFilter.append(",");
                }
                storeTypeFilter.append("'").append(storeTypes[i3]).append("'");
            }
            storeTypeFilter.append(") ");
            if (storeTypeFilter.length() > 0) {
                sqlWhere.append(storeTypeFilter.toString());
            }
        }
        if ((prmtKAClassids = this.getKAClassIDs(params)).length() > 0) {
            sqlWhere.append(" AND mcom.FKAClassID in ").append(prmtKAClassids);
        }
        if (calType >= 0) {
            sqlWhere.append(" AND mcom.FCalculateType = " + String.valueOf(calType));
        }
        if (status == 2) {
            sqlWhere.append(" AND h.FBaseStatus = " + String.valueOf(status));
        } else if (status == 4) {
            sqlWhere.append(" AND h.FBaseStatus >= " + String.valueOf(status));
        }
        if (voucher != -1) {
            sqlWhere.append(" And h.ffiVouchered = ").append(voucher);
        }
        String sqlWhereCostAdj = sqlWhere.toString();
        if (!ckShowNoCalculate) {
            sqlWhere.append(" And tr.FIsCalculate = 1 ");
        }
        if (bizTypeStr.length() > 0) {
            sqlWhere.append(" And bt.FID IN (").append(bizTypeStr.toString()).append(") \r\n");
        }
        if (transTypeStr.length() > 0) {
            sqlWhere.append(" And tr.FID IN (").append(transTypeStr.toString()).append(") \r\n");
        }
        sqlWhere.append(" \r\n");
        StringBuffer extendFiled = new StringBuffer();
        extendFiled.append(",d.FLot as FLot, ");
        extendFiled.append("project.fnumber as fprojectnumber,");
        extendFiled.append("project.fname_" + this.getLoc(ctx) + " as fprojectname,");
        extendFiled.append("track.fnumber as ftracknumber,");
        extendFiled.append("track.fname_" + this.getLoc(ctx) + " as ftrackname ").append(newline);
        StringBuffer extendJoin = new StringBuffer();
        extendJoin.append("LEFT join T_MM_Project project on d.FProjectID = project.FID ");
        extendJoin.append("LEFT join T_MM_TrackNumber track on d.FTrackNumberID = track.FID ").append(newline);
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("INSERT INTO " + tempTable + newline).append("(");
        insertSQL.append(this.getSelects(false));
        insertSQL.append(") ");
        StringBuffer sql = new StringBuffer();
        for (i = 0; i < tableName.length; ++i) {
            if (tableName[i][0].equals("T_AR_OtherBill")) {
                if (params.getBoolean("isArUpdateInventory")) {
                    sql.setLength(0);
                    sql.append("SELECT  newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
                    sql.append("h.FID as FID , ");
                    sql.append("d.FMaterialID as FMaterialID, ");
                    sql.append(11).append(" as FBillType, ");
                    sql.append("h.FYear as FYear, ");
                    sql.append("h.FPeriod as FPeriod, ");
                    sql.append("'' as FVoucherNumber, ");
                    sql.append("'' as FVoucherSummary,");
                    sql.append("h.FBizDate as FBizDate, ");
                    sql.append("null as FAuditTime, ");
                    sql.append("h.FNumber as FBillNumber, ");
                    sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName, ");
                    sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName, ");
                    sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName, ");
                    sql.append("d.FSeq as Fseq, ");
                    sql.append("0 as FInQty, ");
                    sql.append("0 as FInUnitPrice, ");
                    sql.append("0 as FInAmount, ");
                    sql.append("d.FBaseQty  as FOutQty, ");
                    sql.append("0 as FOutUnitPrice, ");
                    sql.append("se.FActualCost*(d.FBaseQty/se.fbaseqty)  as FOutAmount, ");
                    sql.append("0 as FRemainQty, ");
                    sql.append("0 as FRemainUnitPrice,  ");
                    sql.append("0 as FRemainAmount,");
                    sql.append("d.FRemark as FRemark  ");
                    sql.append(",d.FLot as FLot, ");
                    sql.append("'' as fprojectnumber,");
                    sql.append("'' as fprojectname,");
                    sql.append("'' as ftracknumber,");
                    sql.append("''  as ftrackname ").append(newline);
                    sql.append(" ,'' as FStorageOrgUnitID, ");
                    sql.append(" ''  as FWarehouseID, ");
                    sql.append(" storetype.fid  as FStoreTypeID ");
                    sql.append("FROM ").append(tableName[i][0]).append(" h ");
                    sql.append(" INNER JOIN ").append(tableName[i][1]).append(" d ON h.FID = d.FParentID ");
                    sql.append(" LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
                    sql.append(" LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID ");
                    sql.append(" inner join T_im_saleissueentry se on se.fid =d.fsourcebillentryid");
                    sql.append(" inner join T_im_saleissuebill si on si.fid =se.fparentid");
                    sql.append(" inner join T_ORG_UNITRELATION relation on si.FStorageOrgUnitID = Relation.FFROMUNITID");
                    sql.append(" inner join t_scm_transactiontype tr on tr.fid = si.ftransactiontypeid ");
                    sql.append(" INNER JOIN T_IM_InvUpdateType invupdatetype ON se.FInvUpdateTypeID = invupdatetype.FID ");
                    sql.append(" INNER JOIN T_IM_StoreType storetype ON invupdatetype.FSTORETYPEID = storetype.FID ");
                    sql.append(" inner JOIN T_SCM_BizType bizType ON si.FBizTypeID = bizType.FID ");
                    sql.append(" WHERE  1 = 1 ");
                    sql.append(" and h.fbillstatus =  3");
                    if (CurrentMaterial != null) {
                        sql.append(" AND d.FMaterialID = '" + CurrentMaterial + "' ");
                        sql.append(" and se.FMATERIALID = '" + CurrentMaterial + "' ");
                    }
                    sql.append(" And h.FCOMPANYID = '" + fiOrgUnitID + "'");
                    sql.append(" And se.fcompanyorgunitid = '" + fiOrgUnitID + "'");
                    sql.append(" and relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
                    sql.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
                    if (periodYFrom == periodYTo && periodMFrom == periodMTo) {
                        sql.append(" AND h.FYear = " + periodYFrom + " AND h.FPeriod = " + periodMFrom + " ");
                    } else {
                        sql.append(" AND (h.FYear*100+h.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And h.FYear*100+h.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ");
                    }
                    sql.append(" AND bizType.fid in (").append(newline);
                    sql.append(" '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("',").append(newline);
                    sql.append(" '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("') ").append(newline);
                    sql.append(storeTypeFilter);
                }
            } else {
                sql.setLength(0);
                sql.append("SELECT newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
                sql.append("h.FID as FID , ");
                sql.append("d.FMaterialID as FMaterialID, ");
                sql.append(i + 1).append(" as FBillType, ");
                sql.append("h.FYear as FYear, ");
                sql.append("h.FPeriod as FPeriod, ");
                sql.append("g.FNumber as FVoucherNumber, ");
                sql.append("g.FAbstract as FVoucherSummary,");
                sql.append("h.FBizDate as FBizDate, ");
                sql.append("h.FAuditTime as FAuditTime, ");
                sql.append("h.FNumber as FBillNumber, ");
                sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName, ");
                sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName, ");
                sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName, ");
                sql.append("d.FSeq as Fseq, ");
                if (i < 4) {
                    sql.append("d.FBaseQty as FInQty, ");
                    sql.append("0 as FInUnitPrice, ");
                    sql.append("(CASE mcom.FAccountType  WHEN 2 THEN d.FStandardCost ELSE d.FActualCost END) as FInAmount, ");
                    sql.append("0 as FOutQty, ");
                    sql.append("0 as FOutUnitPrice, ");
                    sql.append("0 as FOutAmount, ");
                } else {
                    sql.append("0 as FInQty, ");
                    sql.append("0 as FInUnitPrice, ");
                    sql.append("0 as FInAmount, ");
                    sql.append("d.FBaseQty  as FOutQty, ");
                    sql.append("0 as FOutUnitPrice, ");
                    sql.append("(CASE mcom.FAccountType WHEN 2 THEN d.FStandardCost ELSE d.FActualCost END)  as FOutAmount, ");
                }
                sql.append("0 as FRemainQty, ");
                sql.append("0 as FRemainUnitPrice,  ");
                sql.append("0 as FRemainAmount,");
                sql.append("d.FRemark as FRemark  ");
                sql.append(extendFiled);
                sql.append(" ,h.FStorageOrgUnitID as FStorageOrgUnitID, ");
                sql.append(" d.FWarehouseID as FWarehouseID, ");
                sql.append(" storetype.FID as FStoreTypeID ");
                sql.append("FROM ").append(tableName[i][0]).append(" h ");
                sql.append("INNER JOIN ").append(tableName[i][1]).append(" d ON h.FID = d.FParentID ");
                sql.append(" inner join T_ORG_UNITRELATION relation on h.FStorageOrgUnitID = Relation.FFROMUNITID ");
                sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID ");
                sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
                sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
                sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.FInvUpdateTypeID = invupdatetype.FID ");
                if (i < 4) {
                    sql.append("INNER JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypeID = storetype.FID ");
                } else {
                    sql.append("INNER JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypePreID = storetype.FID ");
                }
                sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
                sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
                sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
                sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID ");
                if ("T_IM_MoveInWarehsBill".equalsIgnoreCase(tableName[i][0]) || "T_IM_MoveIssueBill".equalsIgnoreCase(tableName[i][0])) {
                    sql.append(" LEFT JOIN  T_SCM_BizType bz on bz.FID = h.FBizTypeID ");
                }
                sql.append(extendJoin);
                sql.append(" WHERE  1 = 1 ");
                sql.append(sqlWhere.toString());
                sql.append(this.buildStoreTypeWhereSqlForSaleIssue(tableName[i][1], params));
                sql.append(" And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
                sql.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
                if (noSelectStorageMoveBill && ("T_IM_MoveInWarehsBill".equalsIgnoreCase(tableName[i][0]) || "T_IM_MoveIssueBill".equalsIgnoreCase(tableName[i][0]))) {
                    sql.append(" and bz.FID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ");
                }
                if (noSelectWarehouseMoveBill && ("T_IM_MoveInWarehsBill".equalsIgnoreCase(tableName[i][0]) || "T_IM_MoveIssueBill".equalsIgnoreCase(tableName[i][0]))) {
                    sql.append(" and bz.FID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ");
                }
                if ("T_IM_SaleIssueBill".equals(tableName[i][0])) {
                    this.executeSQL(ctx, insertSQL + sql.toString());
                    sql.setLength(0);
                    sql.append(this.getDelegateReturnStr(i, ctx, sqlWhere, params, extendFiled, extendJoin));
                    sql.append(" And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
                    sql.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
                }
            }
            if (sql.length() != 0) {
                this.executeSQL(ctx, insertSQL + sql.toString());
            }
            sql.setLength(0);
        }
        for (i = 0; i < tableName.length; ++i) {
            if (tableName[i][0].equals("T_AR_OtherBill") || tableName[i][0].equals("T_IM_SaleIssueBill")) continue;
            sql.setLength(0);
            sql.append("SELECT newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
            sql.append("h.FID as FID , ");
            sql.append("d.FMaterialID as FMaterialID, ");
            sql.append(i + 1).append(" as FBillType, ");
            sql.append("h.FYear as FYear, ");
            sql.append("h.FPeriod as FPeriod, ");
            sql.append("g.FNumber as FVoucherNumber, ");
            sql.append("g.FAbstract as FVoucherSummary,");
            sql.append("h.FBizDate as FBizDate, ");
            sql.append("h.FAuditTime as FAuditTime, ");
            sql.append("h.FNumber as FBillNumber, ");
            sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName, ");
            sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName, ");
            sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName, ");
            sql.append("d.FSeq as Fseq, ");
            if (i >= 4) {
                sql.append("d.FBaseQty as FInQty, ");
                sql.append("0 as FInUnitPrice, ");
                sql.append("(CASE mcom.FAccountType  WHEN 2 THEN d.FStandardCost ELSE d.FActualCost END) as FInAmount, ");
                sql.append("0 as FOutQty, ");
                sql.append("0 as FOutUnitPrice, ");
                sql.append("0 as FOutAmount, ");
            } else {
                sql.append("0 as FInQty, ");
                sql.append("0 as FInUnitPrice, ");
                sql.append("0 as FInAmount, ");
                sql.append("d.FBaseQty  as FOutQty, ");
                sql.append("0 as FOutUnitPrice, ");
                sql.append("(CASE mcom.FAccountType WHEN 2 THEN d.FStandardCost ELSE d.FActualCost END)  as FOutAmount, ");
            }
            sql.append("0 as FRemainQty, ");
            sql.append("0 as FRemainUnitPrice,  ");
            sql.append("0 as FRemainAmount,");
            sql.append("d.FRemark as FRemark  ");
            sql.append(extendFiled);
            sql.append(" ,h.FStorageOrgUnitID as FStorageOrgUnitID, ");
            sql.append(" d.FWarehouseID as FWarehouseID, ");
            sql.append(" storetype.FID as FStoreTypeID ");
            sql.append("FROM ").append(tableName[i][0]).append(" h ");
            sql.append("INNER JOIN ").append(tableName[i][1]).append(" d ON h.FID = d.FParentID ");
            sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID ");
            sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
            sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
            sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.FInvUpdateTypeID = invupdatetype.FID ");
            if (i >= 4) {
                sql.append("INNER JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypeID = storetype.FID ");
            } else {
                sql.append("INNER JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypePreID = storetype.FID ");
            }
            sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
            sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
            sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
            sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID ");
            if ("T_IM_MoveInWarehsBill".equalsIgnoreCase(tableName[i][0]) || "T_IM_MoveIssueBill".equalsIgnoreCase(tableName[i][0])) {
                sql.append(" LEFT JOIN  T_SCM_BizType bz on bz.FID = h.FBizTypeID ");
            }
            sql.append(extendJoin);
            sql.append(" WHERE  1 = 1 ");
            sql.append(sqlWhere.toString());
            sql.append(this.buildStoreTypeWhereSqlForSaleIssue(tableName[i][1], params));
            if (noSelectStorageMoveBill && ("T_IM_MoveInWarehsBill".equalsIgnoreCase(tableName[i][0]) || "T_IM_MoveIssueBill".equalsIgnoreCase(tableName[i][0]))) {
                sql.append(" and bz.FID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ");
            }
            if (noSelectWarehouseMoveBill && ("T_IM_MoveInWarehsBill".equalsIgnoreCase(tableName[i][0]) || "T_IM_MoveIssueBill".equalsIgnoreCase(tableName[i][0]))) {
                sql.append(" and bz.FID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ");
            }
            if (sql.length() != 0) {
                this.executeSQL(ctx, insertSQL + sql.toString());
            }
            sql.setLength(0);
        }
        sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
        sql.append("h.FID as FID , ");
        sql.append("d.FMaterialID as FMaterialID, ");
        sql.append("9 as FBillType, ");
        sql.append("h.FYear as FYear, ");
        sql.append("h.FPeriod as FPeriod, ");
        sql.append("g.FNumber as FVoucherNumber, ");
        sql.append("g.FAbstract as FVoucherSummary,");
        sql.append("h.FBizDate as FBizDate, ");
        sql.append("h.FAuditTime as FAuditTime, ");
        sql.append("h.FNumber as FBillNumber, ");
        sql.append("NULL as FBizTypeName,");
        sql.append("TO_CHAR(CASE h.FCREATETYPE ");
        sql.append("WHEN 0 THEN '").append(CostAdjuestCreateTypeEnum.AUTOCREATE.getAlias());
        sql.append("' WHEN 1 THEN   '").append(CostAdjuestCreateTypeEnum.USERINPUT.getAlias());
        sql.append("' WHEN 3 THEN  '").append(CostAdjuestCreateTypeEnum.APPORTION.getAlias());
        sql.append("' WHEN 4 THEN  '").append(CostAdjuestCreateTypeEnum.APPORTION_EXPENSE.getAlias());
        sql.append("' WHEN 5 THEN '").append(CostAdjuestCreateTypeEnum.ISSUE_COSTADJUST.getAlias());
        sql.append("' WHEN 6 THEN '").append(CostAdjuestCreateTypeEnum.CLOSEACCOUNTCOSTADJUST.getAlias());
        sql.append("' WHEN 7 THEN '").append(CostAdjuestCreateTypeEnum.ExcepAdjZero.getAlias());
        sql.append("' WHEN 8 THEN '").append(CostAdjuestCreateTypeEnum.DEVOLVE_COST_CALC.getAlias());
        sql.append("' WHEN 9 THEN '").append(CostAdjuestCreateTypeEnum.ExpBalanceAjdust.getAlias());
        sql.append("' WHEN 10 THEN '").append(CostAdjuestCreateTypeEnum.PeriodBeginExpBalanceAjdust.getAlias());
        sql.append("' WHEN 11 THEN '").append(CostAdjuestCreateTypeEnum.DEV_AUTOCREATE.getAlias());
        sql.append("' WHEN 12 THEN '").append(CostAdjuestCreateTypeEnum.MANUALIMPORT.getAlias());
        sql.append("' WHEN 13 THEN '").append(CostAdjuestCreateTypeEnum.PeriodEndExpBalanceAjdust.getAlias());
        sql.append("'  ELSE  '").append(CostAdjuestCreateTypeEnum.AUTOCREATE.getAlias());
        sql.append("' END)||'-'||tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName, ");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName, ");
        sql.append("d.FSeq as Fseq, ");
        sql.append("(CASE h.FCalculateKind WHEN 0 THEN d.FBaseQty ELSE 0 END) as FInQty, ");
        sql.append("(CASE h.FCalculateKind WHEN 0 THEN ").append(" CASE d.FBaseQty WHEN 0 THEN 0 ELSE d.FAmount/d.FBaseQty  END ").append("END ) as FInUnitPrice, ");
        sql.append("(CASE h.FCalculateKind WHEN 0 THEN d.FAmount ELSE 0 END) as FInAmount, ");
        sql.append("(CASE h.FCalculateKind WHEN 1 THEN d.FBaseQty ELSE 0 END) as FOutQty, ");
        sql.append("(CASE h.FCalculateKind WHEN 1 THEN ").append(" CASE d.FBaseQty WHEN 0 THEN 0 ELSE d.FAmount/d.FBaseQty  END ").append("END ) as FOutUnitPrice, ");
        sql.append("(CASE h.FCalculateKind WHEN 1 THEN d.FAmount ELSE 0 END) as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount,");
        sql.append("d.FRemark as FRemark ");
        sql.append(extendFiled);
        sql.append(" ,h.FStorageOrgUnitID as FStorageOrgUnitID, ");
        sql.append(" d.FWarehouseID as FWarehouseID ");
        sql.append(", storetype.FID as FStoreTypeID ");
        sql.append("FROM T_CL_CostAdjustBill h  ");
        sql.append(" INNER JOIN  T_ORG_UNITRELATION relation on h.FStorageOrgUnitID = Relation.FFROMUNITID ");
        sql.append("INNER JOIN T_SCM_BillType tr ON h.FBillTypeID = tr.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
        sql.append("INNER JOIN T_CL_CostAdjustBillEntry d ON h.FID = d.FParentID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
        sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("INNER JOIN T_IM_StoreType storetype ON d.FStoreTypeID = storetype.FID ");
        sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID ");
        sql.append(extendJoin);
        sql.append("WHERE  mcom.FAccountType <> 2 ");
        sql.append(sqlWhereCostAdj);
        sql.append(this.buildStoreTypeWhereSql("T_CL_CostAdjustBill", params));
        sql.append(" And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
        sql.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
        this.executeSQL(ctx, insertSQL + sql.toString());
        int amtPrecision = params.getInt("amtPrecision");
        String createSql = this.getCreateTempStandardTable();
        createSql = CalculateUtil.transCreateTable(ctx, createSql);
        String standardTempTable = this.createTempTable(ctx, createSql);
        sql.setLength(0);
        sql.append("SELECT  BALANCE.FID, BILL.FID, ENTRY.FMATERIALID, BILL.FYEAR, BILL.FPERIOD, BILL.FBIZDATE, BILL.FAUDITTIME,").append("\n");
        sql.append("BILL.FNUMBER, ENTRY.FSEQ, ENTRY.FDIFFAMOUNT, ROUND(ENTRY.FDIFFPRICE *BALANCE.FPERIODBEGINQTY,").append(amtPrecision).append(") AS AMOUNT,").append("\n");
        sql.append("BALANCE.FWAREHOUSEID, BILL.FVOUCHERID, BILL.FBILLTYPEID, ENTRY.FASSISTPROPERTYID, ENTRY.FREMARK").append("\n");
        sql.append("FROM T_CL_STANDARDCOSTADJBILL BILL INNER JOIN T_CL_STANDARDCOSTADJENTRY ENTRY ON BILL.FID = ENTRY.FPARENTID ").append("\n");
        sql.append("INNER JOIN T_IM_INVENTORYBALANCE BALANCE ON ENTRY.FMATERIALID = BALANCE.FMATERIALID AND BILL.FCOMPANYORGUNITID = BALANCE.FCOMPANYORGUNITID AND BILL.FYEAR = BALANCE.FYEAR AND BILL.FPERIOD = BALANCE.FPERIOD").append("\n");
        sql.append("INNER JOIN T_BD_MATERIALCOMPANYINFO MCOM ON ENTRY.FMATERIALID = MCOM.FMATERIALID AND MCOM.FCOMPANYID = BILL.FCOMPANYORGUNITID ").append("\n");
        sql.append("WHERE bill.FBaseStatus = " + String.valueOf(4));
        sql.append(" And bill.FCompanyOrgUnitID = '").append(fiOrgUnitID).append("'").append("\n");
        sql.append(" AND (bill.FYear*100+bill.FPeriod >= " + String.valueOf(periodYFrom * 100 + periodMFrom) + " And bill.FYear*100+bill.FPeriod <= " + String.valueOf(periodYTo * 100 + periodMTo) + ") ").append("\n");
        if (CurrentMaterial != null) {
            sql.append(" AND entry.FMaterialID = '").append(CurrentMaterial).append("' ").append("\n");
        }
        if (voucher != -1) {
            sql.append(" And bill.ffiVouchered = ").append(voucher).append("\n");
        }
        if (prmtKAClassids.length() > 0) {
            sql.append(" AND mcom.FKAClassID in ").append(prmtKAClassids).append("\n");
        }
        if (calType >= 0) {
            sql.append(" AND mcom.FCalculateType = " + String.valueOf(calType)).append("\n");
        }
        sql.append(newline);
        StringBuffer standardInsertSQL = new StringBuffer();
        standardInsertSQL.append("insert into ").append(standardTempTable).append("\n");
        standardInsertSQL.append("(FBALANCEID,FBILLID,FMATERIALID,FYEAR,FPERIOD,FBIZDATE,FAUDITTIME,FBILLNUMBER,FSEQ,FDIFFAMOUNT,FAMOUNT,FWAREHOUSEID,FVoucherID,FBillTypeID,FAssistPropertyID,FRemark) ").append("\n");
        this.executeSQL(ctx, standardInsertSQL.append(sql).toString());
        sql.setLength(0);
        sql.append("UPDATE ").append(standardTempTable).append(" T SET FTAILDIFF = ").append("\n");
        sql.append("(SELECT T.FDIFFAMOUNT - TEMP.SUMAMOUNT FROM");
        sql.append("(SELECT SUMAMOUNT,FBALANCEID,A.FBILLID FROM ").append(standardTempTable).append(" A INNER JOIN ").append("\n");
        sql.append("(SELECT SUM(FAMOUNT) SUMAMOUNT,FBILLID FROM ").append(standardTempTable).append(" GROUP BY FBILLID) B ON A.FBILLID = B.FBILLID) AS TEMP").append("\n");
        sql.append(" WHERE T.FBILLID = TEMP.FBILLID AND T.FBALANCEID = TEMP.FBALANCEID)");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("UPDATE ").append(standardTempTable).append(" T SET FAMOUNT = ").append("\n");
        sql.append("(FAMOUNT + FTAILDIFF) WHERE FBALANCEID = (").append("\n");
        sql.append("SELECT MAX(FBALANCEID) FROM ").append(standardTempTable).append(")").append("\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
        sql.append("h.FBillID as FID , ");
        sql.append("h.FMaterialID as FMaterialID, ");
        sql.append("10 as FBillType, ");
        sql.append("h.FYear as FYear, ");
        sql.append("h.FPeriod as FPeriod, ");
        sql.append("g.FNumber as FVoucherNumber, ");
        sql.append("g.FAbstract as FVoucherSummary,");
        sql.append("h.FBizDate as FBizDate, ");
        sql.append("h.FAuditTime as FAuditTime, ");
        sql.append("h.FBillNumber as FBillNumber, ");
        sql.append("' ' as FBizTypeName, ");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName, ");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName, ");
        sql.append("h.FSeq as Fseq, ");
        sql.append("0 as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("sum(h.FAmount) as FInAmount, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount,");
        sql.append("h.FRemark as FRemark, ");
        sql.append("null as FLot, ");
        sql.append("null as fprojectnumber,");
        sql.append("null as fprojectname,");
        sql.append("null as ftracknumber,");
        sql.append("null as ftrackname ");
        sql.append(" ,null as FStorageOrgUnitID, ");
        sql.append(" null as FWarehouseID ");
        sql.append(",null as FStoreTypeID ");
        sql.append(" from ").append(standardTempTable).append(" as h");
        sql.append(" LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
        sql.append(" INNER JOIN T_SCM_BillType tr ON h.FBillTypeID = tr.FID ");
        sql.append(" LEFT Join T_BD_AsstAttrValue a on h.FAssistPropertyID=a.FID ");
        if (warehouseID != null || warehouseFrom != null || warehouseTo != null || warehouseIn != null) {
            sql.append(" INNER JOIN T_DB_WAREHOUSE WH ON WH.FID = H.FWAREHOUSEID");
        }
        sql.append(" where 1=1");
        if (isJoinQuery) {
            if (warehouseID != null) {
                sql.append(" AND wh.FID = ('" + warehouseID + "')");
            }
        } else {
            if (warehouseFrom != null) {
                sql.append(" AND wh.FNumber >= '" + warehouseFrom + "' ");
            }
            if (warehouseTo != null) {
                sql.append(" AND wh.FNumber <= '" + warehouseTo + "' ");
            }
            if (warehouseIn != null) {
                sql.append(" AND wh.FNumber in (" + warehouseTo + ") ");
            }
        }
        sql.append(" group by h.FBillID,h.FMaterialID,h.FYear,h.FPeriod,g.FNumber,g.FAbstract,h.FBizDate,h.FAuditTime,h.FBillNumber,tr.FName_").append(this.getLoc(ctx));
        sql.append(",a.FName_").append(this.getLoc(ctx)).append(",h.FSeq,h.FRemark");
        this.executeSQL(ctx, insertSQL.append(sql).toString());
        this.dropTempTable(standardTempTable, ctx);
    }

    private String buildStoreTypeWhereSql(String entryTable, RptParams params) {
        StringBuffer retStr = new StringBuffer();
        boolean isArUpdateInventory = params.getBoolean("isArUpdateInventory");
        retStr.append(" AND storetype.FIsForwardAmt = 1 ").append(newline);
        if ("T_IM_SaleIssueEntry".equalsIgnoreCase(entryTable)) {
            if (isArUpdateInventory) {
                retStr.append(" AND (invupdatetype.FStoreTypePreID IN (").append(newline);
                retStr.append(" '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("',").append(newline);
                retStr.append(" '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',").append(newline);
                retStr.append(" '").append("181875d5-0105-1000-e000-0123c0a812fd97D461A6").append("')) ").append(newline);
            } else {
                retStr.append(" AND ((invupdatetype.FStoreTypePreID = '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("' ");
                retStr.append("       and ( invupdatetype.FStoreTypeID <>'").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("'").append(newline);
                retStr.append(" \t\t\tor invupdatetype.FStoreTypeID is null ) )");
                retStr.append("   or invupdatetype.FStoreTypePreID='").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("' ").append(newline);
                retStr.append("   or invupdatetype.FStoreTypePreID='").append("181875d5-0105-1000-e000-0123c0a812fd97D461A6").append("') ").append(newline);
            }
        }
        return retStr.toString();
    }

    private String buildStoreTypeWhereSqlForSaleIssue(String entryTable, RptParams params) {
        StringBuffer retStr = new StringBuffer();
        retStr.append(" AND storetype.FIsForwardAmt = 1 ").append(newline);
        return retStr.toString();
    }

    private String getPeriodSql(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String fiOrgUnitID = null;
        CompanyOrgUnitInfo company = null;
        if (params.getObject("company") != null) {
            company = (CompanyOrgUnitInfo)params.getObject("company");
            fiOrgUnitID = company.getId().toString();
        }
        sql.append("Insert Into " + tmpPeriodTable + " Select '" + fiOrgUnitID + "' as FCompanyOrgUnitID,FMaterialID,FYear,FPeriod From " + tempTable);
        sql.append(" left join T_BD_Period p on (" + tempTable + ".FYear = p.FPeriodYear and " + tempTable + ".FPeriod = p.FPeriodNumber)");
        if (company != null && company.getAccountPeriodType() != null) {
            sql.append(" where p.FTypeID = '" + company.getAccountPeriodType().getId().toString() + "'");
        }
        sql.append(" Group By FMaterialID,FYear,FPeriod; ");
        return sql.toString();
    }

    private String getPeriodBegin(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        boolean ckShowNoCalculate;
        String fiOrgUnitID = null;
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        String warehouseFrom = null;
        String warehouseTo = null;
        String warehouseIn = null;
        String warehouse = null;
        String storageOrgUnitID = null;
        String warehouseID = null;
        boolean isJoinQuery = params.getBoolean("IsJoinQuery");
        if (isJoinQuery) {
            warehouse = params.getString("warehouse");
        } else {
            if (params.getObject("warehouseFrom") != null) {
                if (params.getObject("warehouseFrom") instanceof Object[]) {
                    Object[] warehouses = (Object[])params.getObject("warehouseFrom");
                    if (warehouses.length == 1) {
                        warehouseFrom = ((WarehouseInfo)warehouses[0]).getNumber();
                    } else {
                        warehouseIn = CalculateUtil.getObjArrayNumberWithQuote(warehouses);
                    }
                } else {
                    warehouseFrom = ((WarehouseInfo)params.getObject("warehouseFrom")).getNumber();
                }
            }
            if (params.getObject("warehouseTo") != null) {
                warehouseTo = ((WarehouseInfo)params.getObject("warehouseTo")).getNumber();
            }
        }
        if (params.getString("FStorageOrgUnit") != null) {
            storageOrgUnitID = params.getString("FStorageOrgUnit");
        }
        if (params.getString("FWarehouse") != null) {
            warehouseID = params.getString("FWarehouse");
        }
        String storeType = null;
        StringBuffer storeTypeFilter = new StringBuffer();
        String storeTypeId = null;
        if (params.getString("storeType") != null && (storeType = params.getString("storeType")) != null) {
            StoreTypeInfo storeTypeInfo;
            String[] storeTypes = storeType.split(",");
            storeTypeFilter.append(" AND storetype.FNumber in (");
            if (storeTypes.length == 1 && (storeTypeInfo = StoreTypeFactory.getLocalInstance((Context)ctx).getStoreTypeInfo("where number ='" + storeTypes[0] + "'")) != null) {
                storeTypeId = "'" + storeTypeInfo.getId().toString() + "'";
            }
            int length = storeTypes.length;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    storeTypeFilter.append(",");
                }
                storeTypeFilter.append("'").append(storeTypes[i]).append("'");
            }
            storeTypeFilter.append(") ");
        }
        int periodYFrom = params.getInt("accPeriodYearFrom");
        int periodMFrom = params.getInt("accPeriodMonthFrom");
        int pFrom = periodYFrom * 100 + periodMFrom;
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMTo = params.getInt("accPeriodMonthTo");
        int pTo = periodYTo * 100 + periodMTo;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(tempTable).append(newline).append("(");
        sql.append(this.getSelects(false));
        sql.append(") ");
        sql.append("Select newbosid('ORDERIDX') as FOrderID,-1 as FIndex,' ' AS FID,'").append(CurrentMaterial).append("' FMaterialID,-1 as FBillType,").append(newline);
        sql.append("Case when P.FYear is null then I.FYear else P.FYear END as FYear,").append(newline);
        sql.append("Case when P.FPeriod is null then I.FPeriod else P.FPeriod END as FPeriod,").append(newline);
        sql.append("' ' as FVoucherNumber,' ' as FVoucherSummary,null as FBizDate,null as FAuditTime,' ' as FNumber,' ' as FBizTypeNumber,'").append(SCMUtils.getResource((String)this.res, (String)"BEGINBALANCE", (Context)ctx)).append("' as FTransactionType,' ' as FAssistantAttr,").append(newline);
        sql.append("0 as FSeq,0 as FInQty,0 as FInUnitPrice,0 as FInAmount,0 as FOutQty,0 as FOutUnitPrice,0 as FOutAmount,").append(newline);
        sql.append("ISNULL(I.FPeriodBeginQty, 0) as FRemainQty,0 as FRemainPrice,ISNULL(I.FPeriodBeginBalance, 0) as FRemainAmount,NULL as FRemark").append(newline);
        sql.append(",NULL as FLot, null as FProjectnumber, null as FProjectname,null as FTracknumber,null as FTrackname").append(newline);
        sql.append(",null as FStorageOrgUnitID, ");
        sql.append("null as FWarehouseID ");
        sql.append(",").append(storeTypeId).append(" as FStoreTypeID ");
        sql.append("From ").append(tmpPeriodTable).append(" P Full Outer Join (").append(newline);
        sql.append(" Select Inv.FCompanyOrgUnitId,Inv.FMaterialId,Inv.FYear,Inv.FPeriod,").append(newline);
        sql.append(" SUM(Inv.FPeriodBeginQty) FPeriodBeginQty, SUM(Inv.FPeriodBeginBalance) FPeriodBeginBalance").append(newline);
        sql.append(" From T_IM_InventoryBalance Inv ").append(newline);
        sql.append(" Inner join T_DB_Warehouse wh on Inv.FWarehouseId = wh.fid").append(newline);
        sql.append(" Inner join T_IM_StoreType storetype on Inv.FStoreTypeId = storetype.fid").append(newline);
        sql.append(" Inner join T_BD_MaterialCompanyInfo mcom On Inv.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = Inv.FCompanyOrgUnitID").append(newline);
        sql.append(" Where Inv.FCompanyOrgUnitId = '").append(fiOrgUnitID).append("' AND Inv.FMaterialId = '").append(CurrentMaterial).append("'").append(newline);
        if (isJoinQuery && warehouse != null) {
            sql.append(" AND wh.FNumber in(" + warehouse + ")").append(newline);
        } else {
            if (warehouseFrom != null) {
                sql.append(" AND wh.FNumber >= '" + warehouseFrom + "' ").append(newline);
            }
            if (warehouseTo != null) {
                sql.append(" AND wh.FNumber <= '" + warehouseTo + "' ").append(newline);
            }
            if (warehouseIn != null) {
                sql.append(" AND wh.FNumber in (" + warehouseTo + ") ").append(newline);
            }
        }
        StringBuffer prmtKAClassids = this.getKAClassIDs(params);
        if (prmtKAClassids.length() > 0) {
            sql.append(" AND mcom.FKAClassID in ").append(prmtKAClassids);
        }
        if (storageOrgUnitID != null) {
            sql.append(" AND Inv.FStorageOrgUnitID = '" + storageOrgUnitID + "'");
        }
        if (warehouseID != null) {
            sql.append(" AND wh.fid = '" + warehouseID + "'");
        }
        if (storeTypeFilter.length() > 0) {
            sql.append(storeTypeFilter.toString());
        }
        if (!(ckShowNoCalculate = params.getBoolean("ckShowNoCalculate"))) {
            sql.append(" AND Inv.FIsCalculate = 1 ");
        }
        boolean noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        boolean noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        if (noSelectStorageMoveBill) {
            sql.append(" AND Inv.FMoveType <> 1 ");
        }
        if (noSelectWarehouseMoveBill) {
            sql.append(" AND Inv.FMoveType <> 2 ");
        }
        sql.append(this.buildStoreTypeWhereSql("T_IM_InventoryBalance", params));
        sql.append(" AND Inv.FYear*100+Inv.FPeriod >= ").append(pFrom).append(" and Inv.FYear*100+Inv.FPeriod <= ").append(pTo).append(newline);
        sql.append(" Group by Inv.FCompanyOrgUnitId,Inv.FMaterialId,Inv.FYear,Inv.FPeriod").append(newline);
        sql.append(") as I On I.FCompanyOrgUnitID=P.FCompanyOrgUnitID and I.FMaterialid = P.FMaterialID and I.FYear=P.FYear and I.FPeriod=P.FPeriod").append(newline);
        return sql.toString();
    }

    private StringBuffer getKAClassIDs(RptParams params) {
        StringBuffer prmtKAClassids = new StringBuffer();
        if (params.getObject("prmtKAClass") instanceof Object[]) {
            Object[] prmtKAClass = (Object[])params.getObject("prmtKAClass");
            if (prmtKAClass != null && prmtKAClass.length > 0) {
                for (int i = 0; i < prmtKAClass.length; ++i) {
                    prmtKAClassids = i == 0 ? prmtKAClassids.append("(").append("'").append(((KAClassficationInfo)prmtKAClass[i]).getId().toString()).append("'") : prmtKAClassids.append(",").append("'").append(((KAClassficationInfo)prmtKAClass[i]).getId().toString()).append("'");
                }
            }
        } else if (params.getObject("prmtKAClass") instanceof KAClassficationInfo) {
            prmtKAClassids = prmtKAClassids.append("(").append("'").append(((KAClassficationInfo)params.getObject("prmtKAClass")).getId().toString()).append("'");
        }
        if (prmtKAClassids.length() > 0) {
            prmtKAClassids = prmtKAClassids.append(")");
        }
        return prmtKAClassids;
    }

    private void insertNextPeriodBegin(Context ctx, String tempTable, PeriodInfo currentPeriodInfo, PeriodInfo nextPeriodInfo, RptParams params) throws BOSException {
        if (nextPeriodInfo.getPeriodNumber() != 13) {
            StringBuffer sql = new StringBuffer();
            StringBuffer sqlIn = new StringBuffer();
            String currentMaterial = "";
            if (params.getObject("CurrentMaterialID") != null) {
                currentMaterial = params.getObject("CurrentMaterialID").toString();
            }
            sql.append("select count(1) as cnt from ").append(tempTable).append(" ").append("where ").append("fyear = ").append(nextPeriodInfo.getPeriodYear()).append(" ").append("and fperiod = ").append(nextPeriodInfo.getPeriodNumber()).append(" ").append("and fIndex = -1");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                int cnt;
                if (rs.next() && (cnt = rs.getInt("cnt")) == 0) {
                    sqlIn.append("insert into ").append(tempTable).append("(").append("FORDERIDX,FIndex,FMaterialID,FBilltype,").append("FTransactionTypeName,FYear,FPeriod)").append("values(").append("newbosid('ORDERIDX'),-1,'").append(currentMaterial).append("',-1,").append("'").append(SCMUtils.getResource((String)this.res, (String)"BEGINBALANCE", (Context)ctx)).append("',").append(nextPeriodInfo.getPeriodYear()).append(",").append(nextPeriodInfo.getPeriodNumber()).append("").append(")");
                    this.executeSQL(ctx, sqlIn.toString());
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String getPeriodTotal(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + " \r\n").append("(");
        sql.append(this.getSelects(false));
        sql.append(") ");
        sql.append("Select newbosid('ORDERIDX') as FOrderID,1 as FIndex,");
        sql.append("' ' AS FID,");
        sql.append("'" + CurrentMaterial + "' as FMaterialID,");
        sql.append("-1 as FBillType,");
        sql.append("p.FYear as FYear,\r\n");
        sql.append("p.FPeriod as FPeriod,");
        sql.append("' ' as FVoucherNumber,");
        sql.append("' ' as FVoucherSummary,");
        sql.append("null as FBizDate,");
        sql.append("null as FAuditTime,");
        sql.append("' ' as FNumber,");
        sql.append("' ' as FBizType,");
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"PERIODTOTAL", (Context)ctx) + "' as FTransactionType,");
        sql.append("' ' as FAssistantAttr,");
        sql.append("0 as FSeq,");
        sql.append("sum(p.FInQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("sum(p.FInAmount) as FInAmount,");
        sql.append("sum(p.FOutQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("sum(p.FOutAmount) as FOutAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("null as FRemark, ");
        sql.append("null as FLot, ");
        sql.append("null as fprojectnumber,");
        sql.append("null as fprojectname,");
        sql.append("null as ftracknumber,");
        sql.append("null as ftrackname, ");
        sql.append("null as FStorageOrgUnitID, ");
        sql.append("null as FWarehouseID ");
        sql.append(",null as FStoreTypeID ");
        sql.append(" From " + tempTable + " p \r\n");
        sql.append(" Where p.FIndex=0 or p.Findex = -1 \r\n");
        sql.append(" Group By p.FYear,p.FPeriod\r\n");
        this.executeSQL(ctx, sql.toString());
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t2 Set(FRemainQty,FRemainAmount)=\r\n");
        sql.append("(Select isNull(t1.FRemainQty,0)+isNull(t3.FInQty,0)-isNull(t3.FOutQty,0),");
        sql.append("isNull(t1.FRemainAmount,0)+isNull(t3.FInAmount,0)-isNull(t3.FOutAmount,0) ");
        sql.append("From " + tempTable + " t3," + tempTable + " t1 \r\n");
        sql.append("Where t3.FIndex=1 And t1.FIndex=-1 And t3.FYear=t1.FYear And t3.FPeriod=t1.FPeriod ");
        sql.append(" And t1.FYear*100+t1.FPeriod<=" + String.valueOf(currentPeriod) + " ");
        sql.append(" And t2.FIndex=t3.FIndex And t2.FYear=t3.FYear And t2.FPeriod=t3.FPeriod )");
        return sql.toString();
    }

    private String getPeriodYearTotal(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        String CurrentMaterial = null;
        if (params.getObject("CurrentMaterialID") != null) {
            CurrentMaterial = params.getObject("CurrentMaterialID").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + " \r\n").append("(");
        sql.append(this.getSelects(false));
        sql.append(") ");
        sql.append("Select newbosid('ORDERIDX') as FOrderID,2 as FIndex,");
        sql.append("' ' AS FID,");
        sql.append("'" + CurrentMaterial + "' as FMaterialID,");
        sql.append("-1 as FBillType,");
        sql.append("p.FYear,");
        sql.append("0 as FPeriod,");
        sql.append("' ' as FVoucherNumber,");
        sql.append("' ' as FVoucherSummary,");
        sql.append("null as FBizDate,");
        sql.append("null as FAuditTime,");
        sql.append("' ' as FNumber,");
        sql.append("' ' as FBizType,");
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' as FTransactionType,");
        sql.append("' ' as FAssistantAttr,");
        sql.append("0 as FSeq,");
        sql.append("sum(p.FInQty) as FInQty,");
        sql.append("0 as FInUnitPrice,");
        sql.append("sum(p.FInAmount) as FInAmount,");
        sql.append("sum(p.FOutQty) as FOutQty,");
        sql.append("0 as FOutUnitPrice,");
        sql.append("sum(p.FOutAmount) as FOutAmount,");
        sql.append("0 as FRemainQty,");
        sql.append("0 as FRemainPrice,");
        sql.append("0 as FRemainAmount,");
        sql.append("null as FRemark,");
        sql.append("null as FLot, ");
        sql.append("null as fprojectnumber,");
        sql.append("null as fprojectname,");
        sql.append("null as ftracknumber,");
        sql.append("null as ftrackname ");
        sql.append(",null as FStorageOrgUnitID, ");
        sql.append("null as FWarehouseID ");
        sql.append(",null as FStoreTypeID ");
        sql.append(" From " + tempTable + " p \r\n");
        sql.append(" Where p.FIndex=1\r\n");
        sql.append(" Group By p.FYear\r\n");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t3 \r\n");
        sql.append("Set (FRemainQty,FRemainAmount)=( \r\n");
        sql.append("Select t2.FRemainQty,t2.FRemainAmount From  " + tempTable + " t1 \r\n");
        sql.append("Left Join ( \r\n");
        sql.append("\tSelect t2.FYear,t2.FPeriod,t1.FRemainQty,t1.FRemainAmount  \r\n");
        sql.append("\tFrom " + tempTable + " t1  \r\n");
        sql.append("\tInner Join(  \r\n");
        sql.append("\tselect FYear,Max(FPeriod) FPeriod  From " + tempTable + " t1 group by FYear \r\n");
        sql.append("\t) t2  \r\n");
        sql.append("\tOn  t1.FYear=t2.FYear and t1.FPeriod=t2.FPeriod where  t1.Findex=1 \r\n");
        sql.append(" ) t2  \r\n");
        sql.append("On t1.FYear=t2.FYear \r\n");
        sql.append("Where t1.FIndex=2 And t1.FIndex=t3.FIndex And t1.FYear=t3.FYear)");
        return sql.toString();
    }

    private String getDropTmpPeriodTab(Context ctx, String tempTable, String tmpPeriodTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Drop Table " + tmpPeriodTable + newline);
        return sql.toString();
    }

    private String getDealNextPeriod(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = null;
        int periodYTo = params.getInt("accPeriodYearTo");
        int periodMTo = params.getInt("accPeriodMonthTo");
        int toPeriod = periodYTo * 100 + periodMTo;
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        int nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
        while (toPeriod >= nextPeriod) {
            sql = this.UpdatePeriodFirst(ctx, tempTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            this.executeSQL(ctx, sql);
            sql = this.UpdatePeriodLast(ctx, tempTable, nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
            this.executeSQL(ctx, sql);
            if (toPeriod == nextPeriod) break;
            currentPeriodInfo = nextPeriodInfo;
            if (nextPeriodInfo.getEndDate() == null) break;
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo);
            nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
        }
        return "";
    }

    private String getDealPrice(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FInUnitPrice=(CASE WHEN isnull(FInQty,0)=0 THEN Null ELSE round(decimal(FInAmount,17,4)/decimal(FInQty,21,8),6) END),");
        sql.append("FOutUnitPrice=(CASE WHEN isnull(FOutQty,0)=0 THEN Null ELSE round(decimal(FOutAmount,17,4)/decimal(FOutQty,21,8),6) END)");
        return sql.toString();
    }

    private String UpdatePeriodFirst(Context ctx, String tempTable, int prePeriodY, int prePeriodM, int nextPeriodY, int nextPeriodM) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " AS t3 Set(FRemainQty,FRemainAmount)=\r\n");
        sql.append("(Select t1.FRemainQty,t1.FRemainAmount \r\n");
        sql.append("From " + tempTable + " t1 ," + tempTable + " t2 \r\n");
        sql.append("Where t1.FYear=" + prePeriodY + " And t1.FPeriod=" + prePeriodM + " And t1.FIndex=1 ");
        sql.append("And t2.FYear=" + nextPeriodY + " And t2.FPeriod=" + nextPeriodM + " And t2.FIndex=-1 \r\n");
        sql.append("And t2.FIndex=t3.FIndex And t2.FYear=t3.FYear And t2.FPeriod=t3.FPeriod )");
        return sql.toString();
    }

    private String UpdatePeriodLast(Context ctx, String tempTable, int pYear, int pMonth) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " AS t3 Set(FRemainQty,FRemainAmount)=\r\n");
        sql.append("(Select isNull(t1.FRemainQty,0)+isNull(t2.FInQty,0)-isNull(t2.FOutQty,0),");
        sql.append("isNull(t1.FRemainAmount,0)+isNull(t2.FInAmount,0)-isNull(t2.FOutAmount,0) ");
        sql.append("From " + tempTable + " t2," + tempTable + " t1 \r\n");
        sql.append("Where t2.FIndex=1 And t1.FIndex=-1 And t2.FYear=t1.FYear And t2.FPeriod=t1.FPeriod \r\n");
        sql.append("And t2.FIndex=t3.FIndex And t2.FYear=t3.FYear And t2.FPeriod=t3.FPeriod )");
        return sql.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    @Override
    protected Object[] _getMaterialPKArray(Context ctx, RptParams params) throws BOSException {
        boolean noSelectNoneInOut = params.getBoolean("noSelectNoneInOut");
        int status = -1;
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        }
        PeriodInfo currentPeriodInfo = null;
        PeriodInfo periodInfoFrom = null;
        PeriodInfo periodInfoTo = null;
        try {
            periodInfoFrom = PeriodUtils.getPeriodInfo((Context)ctx, (int)params.getInt("accPeriodYearFrom"), (int)params.getInt("accPeriodMonthFrom"), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            periodInfoTo = PeriodUtils.getPeriodInfo((Context)ctx, (int)params.getInt("accPeriodYearTo"), (int)params.getInt("accPeriodMonthTo"), (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
            currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)params.getObject("company")));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (!noSelectNoneInOut && 100 * periodInfoFrom.getPeriodYear() + periodInfoFrom.getPeriodNumber() > 100 * currentPeriodInfo.getPeriodYear() + currentPeriodInfo.getPeriodNumber()) {
            periodInfoFrom = currentPeriodInfo;
        }
        String fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        Vector<String> materialIDVct = new Vector<String>();
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer billBuff = new StringBuffer();
        sqlBuff.append("create table temp ( fmaterialid varchar(44))");
        String tempTable = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)sqlBuff.toString());
        try {
            StringBuffer prmtKAClassids;
            KsqlUtil.createTempTableIndex((Context)ctx, (String)tempTable, (String)"fmaterialid", (boolean)false);
            sqlBuff.setLength(0);
            String[][] tableName = new String[][]{{"T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry"}, {"T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry"}, {"T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry"}, {"T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry"}, {"T_IM_SaleIssueBill", "T_IM_SaleIssueEntry"}, {"T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry"}, {"T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry"}, {"T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry"}, {"T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry"}, {"T_CL_StandardCostAdjBill", "T_CL_StandardCostAdjEntry"}};
            for (int i = 0; i < tableName.length; ++i) {
                billBuff.append("insert into ").append(tempTable);
                billBuff.append(" select  b.fmaterialid as fmaterialid from ").append(tableName[i][0]).append(" a inner join ").append(tableName[i][1]).append(" b ").append(" on a.fid = b.fparentid ").append(" inner join t_bd_material m on m.fid = b.fmaterialid \n").append("where 1 = 1 ");
                if (tableName[i][0].equals("T_CL_StandardCostAdjBill")) {
                    billBuff.append("and a.fcompanyorgunitid = '").append(fiOrgUnitID).append("' ");
                } else {
                    billBuff.append("and b.fcompanyorgunitid = '").append(fiOrgUnitID).append("' ");
                }
                if (status != -1) {
                    billBuff.append(" and  a.FBaseStatus = " + status + " ");
                } else {
                    billBuff.append(" and  (a.FBaseStatus = 2 or a.FBaseStatus = 4) ");
                }
                if (params.getObject("materialFrom") != null) {
                    if (params.getObject("materialFrom") instanceof Object[]) {
                        Object[] materials = (Object[])params.getObject("materialFrom");
                        if (materials.length == 1) {
                            billBuff.append(" AND m.FNumber >= '" + ((MaterialInfo)materials[0]).getNumber() + "'");
                        } else {
                            billBuff.append(" AND m.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(") ");
                        }
                    } else if (params.getObject("materialFrom") instanceof MaterialInfo) {
                        billBuff.append(" AND m.FNumber >= '" + ((MaterialInfo)params.getObject("materialFrom")).getNumber() + "'");
                    } else {
                        billBuff.append(" AND m.FNumber >= '" + params.getObject("materialFrom") + "'");
                    }
                }
                if (params.getObject("materialTo") != null) {
                    if (params.getObject("materialTo") instanceof MaterialInfo) {
                        billBuff.append(" AND m.FNumber <= '" + ((MaterialInfo)params.getObject("materialTo")).getNumber() + "'");
                    } else {
                        billBuff.append(" AND m.FNumber <= '" + params.getObject("materialTo") + "'");
                    }
                }
                if (periodInfoFrom != null) {
                    billBuff.append("and a.fbizdate >= to_date('").append(IMRptUtils.getFilterBeginDate((Date)periodInfoFrom.getBeginDate())).append("') ");
                }
                if (periodInfoTo != null) {
                    billBuff.append("and a.fbizdate <= to_date('").append(IMRptUtils.getFilterEndDate((Date)periodInfoTo.getEndDate())).append("') ");
                }
                billBuff.append(" group by b.fmaterialid");
                KsqlUtil.execute((Context)ctx, (String)billBuff.toString());
                billBuff.setLength(0);
            }
            if (!noSelectNoneInOut) {
                billBuff.append("insert into ").append(tempTable);
                billBuff.append(" select fmaterialid as fmaterialid from t_im_inventorybalance bal");
                billBuff.append(" inner join t_bd_material m on m.fid = bal.fmaterialid ");
                billBuff.append("where bal.fcompanyorgunitid ='").append(fiOrgUnitID).append("' ");
                if (params.getObject("materialFrom") != null) {
                    if (params.getObject("materialFrom") instanceof Object[]) {
                        Object[] materials = (Object[])params.getObject("materialFrom");
                        if (materials.length == 1) {
                            billBuff.append(" AND m.FNumber >= '" + ((MaterialInfo)materials[0]).getNumber() + "'");
                        } else {
                            billBuff.append(" AND m.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(") ");
                        }
                    } else if (params.getObject("materialFrom") instanceof MaterialInfo) {
                        billBuff.append(" AND m.FNumber >= '" + ((MaterialInfo)params.getObject("materialFrom")).getNumber() + "'");
                    } else {
                        billBuff.append(" AND m.FNumber >= '" + params.getObject("materialFrom") + "'");
                    }
                }
                if (params.getObject("materialTo") != null) {
                    if (params.getObject("materialTo") instanceof MaterialInfo) {
                        billBuff.append(" AND m.FNumber <= '" + ((MaterialInfo)params.getObject("materialTo")).getNumber() + "'");
                    } else {
                        billBuff.append(" AND m.FNumber <= '" + params.getObject("materialTo") + "'");
                    }
                }
                if (periodInfoFrom != null) {
                    billBuff.append("and 100*fyear+fperiod >=").append(100 * periodInfoFrom.getPeriodYear() + periodInfoFrom.getPeriodNumber());
                }
                if (periodInfoTo != null) {
                    billBuff.append("and 100*fyear+fperiod <=").append(100 * periodInfoTo.getPeriodYear() + periodInfoTo.getPeriodNumber());
                }
                billBuff.append(" and (bal.FPERIODBEGINQTY <> 0 or bal.FPERIODBEGINBALANCE <> 0)");
                billBuff.append(" group by fmaterialid");
                KsqlUtil.execute((Context)ctx, (String)billBuff.toString());
                billBuff.setLength(0);
            }
            sqlBuff.append("SELECT TOP " + (Integer)params.getObject("MaxCount") + " B.FID ");
            sqlBuff.append("FROM T_BD_MaterialCompanyInfo A ");
            sqlBuff.append("INNER JOIN T_BD_Material B ON A.FMaterialID = B.FID ");
            sqlBuff.append("INNER JOIN ").append(tempTable).append(" C ON C.FMaterialID = B.FID ");
            sqlBuff.append("WHERE A.FCompanyID = '" + ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString() + "' ");
            if (params.getObject("materialFrom") != null) {
                if (params.getObject("materialFrom") instanceof Object[]) {
                    Object[] materials = (Object[])params.getObject("materialFrom");
                    if (materials.length == 1) {
                        sqlBuff.append(" AND B.FNumber >= '" + ((MaterialInfo)materials[0]).getNumber() + "'");
                    } else {
                        sqlBuff.append(" AND B.FNumber in (").append(CalculateUtil.getObjArrayNumberWithQuote(materials)).append(") ");
                    }
                } else if (params.getObject("materialFrom") instanceof MaterialInfo) {
                    sqlBuff.append(" AND B.FNumber >= '" + ((MaterialInfo)params.getObject("materialFrom")).getNumber() + "'");
                } else {
                    sqlBuff.append(" AND B.FNumber >= '" + params.getObject("materialFrom") + "'");
                }
            }
            if (params.getObject("materialTo") != null) {
                if (params.getObject("materialTo") instanceof MaterialInfo) {
                    sqlBuff.append(" AND B.FNumber <= '" + ((MaterialInfo)params.getObject("materialTo")).getNumber() + "'");
                } else {
                    sqlBuff.append(" AND B.FNumber <= '" + params.getObject("materialTo") + "'");
                }
            }
            int calType = -1;
            if (params.getObject("calType") != null) {
                calType = ((CalculateTypeEnum)params.getObject("calType")).getValue();
            }
            if (calType >= 0) {
                sqlBuff.append(" AND A.FCalculateType = " + String.valueOf(calType));
            }
            if ((prmtKAClassids = this.getKAClassIDs(params)).length() > 0) {
                sqlBuff.append(" AND A.FKAClassID in ").append(prmtKAClassids);
            }
            String sqlStr = "";
            if (params.getBoolean("ckBxMShortName") && params.getString("txtMShortNameFrom").length() > 0 && params.getString("txtMShortNameTo").length() > 0) {
                sqlStr = " AND B.FShortName >= '" + params.getString("txtMShortNameFrom") + "' AND B.FShortName <= '" + params.getString("txtMShortNameTo") + "'";
                sqlBuff = sqlBuff.append(sqlStr);
            } else if (params.getBoolean("ckBxMShortName") && params.getString("txtMShortNameFrom").length() > 0 && params.getString("txtMShortNameTo").length() <= 0) {
                sqlStr = " AND B.FShortName >= '" + params.getString("txtMShortNameFrom").toString() + "'";
                sqlBuff = sqlBuff.append(sqlStr);
            } else if (params.getBoolean("ckBxMShortName") && params.getString("txtMShortNameFrom").length() <= 0 && params.getString("txtMShortNameTo").length() > 0) {
                sqlStr = " AND B.FShortName <= '" + params.getString("txtMShortNameTo").toString() + "'";
                sqlBuff = sqlBuff.append(sqlStr);
            }
            sqlBuff.append(" group by B.FID,B.FNumber");
            sqlBuff.append(" ORDER BY B.FNumber");
            RptRowSet rs = this.executeQuery(sqlBuff.toString(), null, ctx);
            while (rs.next()) {
                materialIDVct.add(rs.getString(0));
            }
            rs = null;
            Object[] objectArray = materialIDVct.toArray();
            return objectArray;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTable);
        }
    }

    private long GetNowTime() {
        Date d = new Date();
        return d.getTime();
    }

    private String getDelegateReturnStr(int i, Context ctx, StringBuffer sqlWhere, RptParams params, StringBuffer extendFiled, StringBuffer extendJoin) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT newbosid('ORDERIDX') as FOrderID,0 as FIndex, ");
        sql.append("h.FID as FID , ");
        sql.append("d.FMaterialID as FMaterialID, ");
        sql.append(i + 1).append(" as FBillType, ");
        sql.append("h.FYear as FYear, ");
        sql.append("h.FPeriod as FPeriod, ");
        sql.append("g.FNumber as FVoucherNumber, ");
        sql.append("g.FAbstract as FVoucherSummary,");
        sql.append("h.FBizDate as FBizDate, ");
        sql.append("h.FAuditTime as FAuditTime, ");
        sql.append("h.FNumber as FBillNumber, ");
        sql.append("bt.FName_" + this.getLoc(ctx) + " as FBizTypeName, ");
        sql.append("tr.FName_" + this.getLoc(ctx) + " as FTransactionTypeName, ");
        sql.append("a.FName_" + this.getLoc(ctx) + " as FAssistantAttrName, ");
        sql.append("d.FSeq as Fseq, ");
        sql.append("d.FBaseQty as FInQty, ");
        sql.append("0 as FInUnitPrice, ");
        sql.append("(CASE mcom.FAccountType  WHEN 2 THEN d.FStandardCost ELSE d.FActualCost END) as FInAmount, ");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutUnitPrice, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainUnitPrice,  ");
        sql.append("0 as FRemainAmount,");
        sql.append("d.FRemark as FRemark  ");
        sql.append(extendFiled);
        sql.append(" ,h.FStorageOrgUnitID as FStorageOrgUnitID, ");
        sql.append(" d.FWarehouseID as FWarehouseID ");
        sql.append(", storetype.FID as FStoreTypeID ");
        sql.append("FROM ").append(tableName[i][0]).append(" h ");
        sql.append("INNER JOIN ").append(tableName[i][1]).append(" d ON h.FID = d.FParentID ");
        sql.append("INNER JOIN T_SCM_TransactionType tr ON h.FTransactionTypeID = tr.FID ");
        sql.append("LEFT JOIN T_SCM_BizType bt ON h.FBizTypeID = bt.FID ");
        sql.append("LEFT JOIN T_GL_Voucher g ON h.FVoucherID = g.FID ");
        sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.FInvUpdateTypeID = invupdatetype.FID ");
        sql.append(" INNER JOIN  T_ORG_UNITRELATION relation on h.FStorageOrgUnitID = Relation.FFROMUNITID ");
        sql.append("INNER JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypeID = storetype.FID ");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID AND mcom.FCompanyID = d.FCompanyOrgUnitID ");
        sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID ");
        sql.append("INNER JOIN t_db_warehouse wh ON d.FWarehouseID = wh.FID ");
        sql.append("LEFT Join T_BD_AsstAttrValue a on d.FAssistPropertyID=a.FID ");
        sql.append(extendJoin);
        sql.append(" WHERE  1 = 1 ");
        sql.append(sqlWhere.toString());
        sql.append(this.buildStoreTypeWhereSqlForSaleIssue(tableName[i][1], params));
        return sql.toString();
    }
}

