/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.KAClassficationInfo;
import com.kingdee.eas.basedata.assistant.PeriodException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.SumTypeEnum;
import com.kingdee.eas.scm.cal.VoucheredEnum;
import com.kingdee.eas.scm.cal.app.AbstractStockGatherReportFacadeControllerBean;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.DbUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StockGatherReportFacadeControllerBean
extends AbstractStockGatherReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.StockGatherReportFacadeControllerBean");
    private String res = "com.kingdee.eas.scm.cal.CalRptResource";
    List<BOSException> excList = new ArrayList<BOSException>();
    public static final String newline = "\r\n";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        IParamControl ipc;
        String isUpdateByARBILL;
        this.dropTempTable(params.getString("tempTable"), ctx);
        String SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int beginOldYear = beginYear;
        int beginOldPeriod = beginPeriod;
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        int toPeriod = endYear * 100 + endPeriod;
        CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)params.getObject("company");
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)cou);
        params.setObject("currPeriod", (Object)currentPeriodInfo);
        int currentPeriod = currentPeriodInfo.getPeriodYear() * 100 + currentPeriodInfo.getPeriodNumber();
        PeriodInfo nextPeriodInfo = null;
        try {
            nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriodInfo);
        }
        catch (Exception be) {
            throw new BOSException((Throwable)be);
        }
        int nextPeriod = 0;
        if (nextPeriodInfo != null) {
            nextPeriod = nextPeriodInfo.getPeriodYear() * 100 + nextPeriodInfo.getPeriodNumber();
        }
        if (100 * beginYear + beginPeriod > currentPeriod) {
            beginYear = currentPeriodInfo.getPeriodYear();
            beginPeriod = currentPeriodInfo.getPeriodNumber();
            params.setInt("accPeriodYearFrom", beginYear);
            params.setInt("accPeriodMonthFrom", beginPeriod);
        }
        boolean isArUpdateInventory = (isUpdateByARBILL = (ipc = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)params.getObject("company")).getId().toString()), "CONSIGNSALES")) == null ? false : isUpdateByARBILL.trim().equals("true");
        params.setBoolean("isArUpdateInventory", isArUpdateInventory);
        long lStart = 0L;
        long lEnd = 0L;
        String tempTable = this.createTempTable(ctx, this.getCreateTable(params));
        DBUtil.createTempTableIndex(ctx, tempTable, "FYear,FPeriod,FINDEX,FMATERIALID,FSUMTYPENAME", false);
        String newTempTable = this.createTempTable(ctx, this.getCreateTable(params));
        DBUtil.createTempTableIndex(ctx, newTempTable, "KSQL_SEQ", false);
        boolean checkPermission = SCMServerUtils.checkFunctionPermission((Context)ctx, (IObjectPK)ctx.getCaller(), (String)cou.getId().toString(), (String)"stockgatherreport_view");
        if (checkPermission) {
            String wherePeriodSql = this.getWherePeriodSql(ctx, params, currentPeriodInfo, true);
            String wherePeriod4Balance = "";
            if (wherePeriodSql != null) {
                wherePeriod4Balance = this.getWherePeriod4Balance(ctx, params, currentPeriodInfo, true);
            }
            params.setString("wherePeriodSql", wherePeriodSql);
            params.setString("wherePeriod4Balance", wherePeriod4Balance);
            if (toPeriod >= currentPeriodInfo.getNumber()) {
                params.setBoolean("hasCurrAndAfterPeriod", true);
                wherePeriodSql = this.getWherePeriodSql(ctx, params, currentPeriodInfo, false);
                if (wherePeriodSql != null) {
                    wherePeriod4Balance = this.getWherePeriod4Balance(ctx, params, currentPeriodInfo, true);
                }
                params.setString("whereCurrAndAfterPeriodSql", wherePeriodSql);
                params.setString("wherePeriod4Balance", wherePeriod4Balance);
            }
            lStart = this.GetNowTime();
            String sql = this.getPeriodHappen(ctx, tempTable, params);
            lEnd = this.GetNowTime();
            logger.info((Object)("StockGatherReporter get period happen data spend time:" + String.valueOf(lEnd - lStart)));
            if (toPeriod > currentPeriod && nextPeriodInfo != null && (sql = this.getInsertNextPeriod(ctx, tempTable, currentPeriodInfo, nextPeriodInfo, SumTypeFieldName)) != null) {
                this.executeSQL(ctx, sql);
            }
            if (toPeriod > nextPeriod && nextPeriod != 0) {
                PeriodInfo next2PeriodInfo = null;
                try {
                    next2PeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)nextPeriodInfo);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (next2PeriodInfo != null && (sql = this.getInsertNextPeriod(ctx, tempTable, nextPeriodInfo, next2PeriodInfo, SumTypeFieldName)) != null) {
                    this.executeSQL(ctx, sql);
                }
            }
            if (toPeriod >= currentPeriod) {
                sql = this.updatePeriodLast(ctx, tempTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber());
                this.executeSQL(ctx, sql);
            }
            if (toPeriod >= nextPeriod && nextPeriod != 0) {
                sql = this.updatePeriodFirst(ctx, tempTable, currentPeriodInfo.getPeriodYear(), currentPeriodInfo.getPeriodNumber(), nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
                this.executeSQL(ctx, sql);
                sql = this.updatePeriodLast(ctx, tempTable, nextPeriodInfo.getPeriodYear(), nextPeriodInfo.getPeriodNumber());
                this.executeSQL(ctx, sql);
            }
            if (params.getBoolean("NoInOrOutNoShow")) {
                sql = "delete from " + tempTable + " where FInQty=0 and FOutQty=0 and FINAMOUNT=0 and FOUTAMOUNT=0";
                this.executeSQL(ctx, sql);
            }
            String sql2 = "delete from " + tempTable + " where FInQty=0 and FOutQty=0 and FINAMOUNT=0 and FOUTAMOUNT=0 and FBEGINQTY = 0 and FBEGINAMOUNT = 0 and FREMAINQTY = 0 and FREMAINAMOUNT = 0";
            this.executeSQL(ctx, sql2);
            int balanceCondition = params.getInt("ShowBalanceCondition");
            switch (balanceCondition) {
                case 1: {
                    sql = "delete from " + tempTable + " where FRemainQty <> 0";
                    break;
                }
                case 2: {
                    sql = "delete from " + tempTable + " where FRemainQty = 0";
                    break;
                }
                case 3: {
                    sql = "delete from " + tempTable + " where FRemainQty <= 0";
                    break;
                }
                case 4: {
                    sql = "delete from " + tempTable + " where FRemainQty >= 0";
                    break;
                }
                default: {
                    sql = null;
                }
            }
            if (sql != null) {
                this.executeSQL(ctx, sql);
            }
            if (100 * beginOldYear + beginOldPeriod > currentPeriod) {
                sql = "delete from " + tempTable + " where 100*fyear + fperiod < " + (100 * beginOldYear + beginOldPeriod) + " or fyear <" + beginOldYear;
                this.executeSQL(ctx, sql);
            }
            sql = this.getPeriodHappenTotal(ctx, tempTable, params);
            this.executeSQL(ctx, sql);
            sql = this.getPeriodTotal(ctx, tempTable, SumTypeFieldName);
            this.executeSQL(ctx, sql);
            this.getYearTotal(ctx, tempTable, beginYear, beginPeriod, endYear, endPeriod, SumTypeFieldName);
            this.getAllTotal(ctx, tempTable, beginYear, beginPeriod, endYear, endPeriod, SumTypeFieldName);
            sql = "Update " + tempTable + " Set FYear=null Where FYear=0 ";
            this.executeSQL(ctx, sql);
            sql = "Update " + tempTable + " Set FPeriod=null Where FPeriod=0 ";
            this.executeSQL(ctx, sql);
            sql = SumTypeFieldName.equals("FCalculateType") ? "Update " + tempTable + " Set FSUMTYPEID=null Where FSUMTYPEID=0 " : "Update " + tempTable + " Set FSUMTYPEID=null Where FSUMTYPEID in('',' ')";
            this.executeSQL(ctx, sql);
            if (SumTypeFieldName.equals("FMaterialGroupLevel")) {
                sql = "update " + tempTable + " as  t2 set FSumTypeName=";
                sql = sql + "(select t3.flongnumber from t_bd_material t1,t_bd_materialgroup t3 where  t2.fmaterialid=t1.fid and t3.fid=t1.fmaterialgroupid and t3.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=') where findex=0";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " as  t2 set FMATERIALGROUPID1=";
                sql = sql + "(select CASE CHARINDEX('!', t3.flongnumber) WHEN 0 THEN t3.flongnumber ELSE LEFT(t3.flongnumber,CHARINDEX('!', t3.flongnumber)-1) END from t_bd_material t1,t_bd_materialgroup t3 where  t2.fmaterialid=t1.fid and t3.fid=t1.fmaterialgroupid and t3.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=') ";
                this.executeSQL(ctx, sql);
                sql = "update " + tempTable + " as  t1 set FMATERIALGROUPNAME1=";
                sql = sql + "(select t2.fname_" + this.getLoc(ctx) + " from t_bd_materialgroup t2 ,t_bd_material t10  where t10.fid = t1.fmaterialid  and t1.FMATERIALGROUPID1=t2.flongnumber  and t2.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=' )  ";
                this.executeSQL(ctx, sql);
                int materialGroupLevel = params.getInt("materialGroupLevel");
                for (int i = 2; i <= materialGroupLevel; ++i) {
                    sql = "update " + tempTable + " set FMATERIALGROUPID" + i + "=CASE LENGTH(FSumTypeName)-LENGTH(FMATERIALGROUPID" + (i - 1) + "||'') when 0 then '' when -1 then '' else SUBSTRING(FSumTypeName,length(FMATERIALGROUPID" + (i - 1) + ")+2,length(FSumTypeName)-length(FMATERIALGROUPID" + (i - 1) + ")) END";
                    this.executeSQL(ctx, sql);
                    sql = "update " + tempTable + " set FMATERIALGROUPID" + i + "=CASE CHARINDEX('!', FMATERIALGROUPID" + i + " ) WHEN 0 THEN FMATERIALGROUPID" + i + "  ELSE LEFT(FMATERIALGROUPID" + i + " ,CHARINDEX('!',FMATERIALGROUPID" + i + " )-1) END";
                    this.executeSQL(ctx, sql);
                    sql = "update " + tempTable + " set FMATERIALGROUPID" + i + "=case  FMATERIALGROUPID" + i + " WHEN '' then '' else FMATERIALGROUPID" + (i - 1) + "||'!'||FMATERIALGROUPID" + i + " END";
                    this.executeSQL(ctx, sql);
                    sql = "update " + tempTable + " as  t1 set FMATERIALGROUPNAME" + i;
                    sql = sql + "=(select t2.fname_" + this.getLoc(ctx) + " from t_bd_materialgroup t2 where t1.FMATERIALGROUPID" + i + "=t2.flongnumber and t2.fgroupstandard = 'dR8lnQEPEADgAAWKwKgSxZeb4R8=' ) ";
                    this.executeSQL(ctx, sql);
                }
                sql = "delete from " + tempTable + " where findex=1";
                this.executeSQL(ctx, sql);
                sql = "update  " + tempTable + " set FMATERIALGROUPNAME1=fsumtypename where findex<>0";
                this.executeSQL(ctx, sql);
                StringBuffer sqlbuff = new StringBuffer();
                for (int i = 1; i <= materialGroupLevel; ++i) {
                    int j;
                    sqlbuff.setLength(0);
                    sqlbuff.append("Insert Into " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT");
                    for (j = 1; j <= i; ++j) {
                        sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                    }
                    sqlbuff.append(")\r\n");
                    sqlbuff.append(" Select 0.5 as FIndex,FCompanyOrgUnitID as FCompanyOrgUnitID,FCOMPANYNAME as FCompanyName,\r\n");
                    sqlbuff.append("FYear,FPeriod,\r\n");
                    sqlbuff.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
                    sqlbuff.append("' ' as FMaterialNumber,' ' as FMaterialModel,");
                    sqlbuff.append("' ' as FBaseUnitName,\r\n");
                    if (SumTypeFieldName.equals("FCalculateType")) {
                        sqlbuff.append("0 as FSumTypeID, ");
                    } else {
                        sqlbuff.append("' ' as FSumTypeID, ");
                    }
                    sqlbuff.append("'' FSumTypeName,\r\n");
                    sqlbuff.append("sum(FBeginQty) as FBeginQty,sum(FBeginAmount) as FBeginAmount,\r\n");
                    sqlbuff.append("sum(FInQty) as FInQty,Sum(FInAmount)as FInAmount,\r\n");
                    sqlbuff.append("Sum(FOutQty) as FOutQty,Sum(FOutAmount) as FOutAmount,\r\n");
                    sqlbuff.append("sum(FRemainQty) as FRemainQty,sum(FRemainAmount) as FRemainAmount \r\n");
                    for (j = 1; j <= i; ++j) {
                        sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                    }
                    sqlbuff.append("||'").append(SCMUtils.getResource((String)this.res, (String)"TOTAL", (Context)ctx));
                    sqlbuff.append("' From " + tempTable + newline);
                    sqlbuff.append("Where FIndex=0 \r\n");
                    sqlbuff.append(" and length(FMATERIALGROUPNAME").append(i).append(")>0 ");
                    sqlbuff.append("Group By FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod \r\n");
                    for (j = 1; j <= i; ++j) {
                        sqlbuff.append(",FMATERIALGROUPID" + j + ",FMATERIALGROUPNAME" + j);
                    }
                    this.executeSQL(ctx, sqlbuff.toString());
                }
            }
            params.setInt("accPeriodYearFrom", beginOldYear);
            params.setInt("accPeriodMonthTo", beginOldPeriod);
            this.copyToNewTempTable(ctx, tempTable, newTempTable, params);
            this.dropTempTable(tempTable, ctx);
        }
        RptTableHeader header1 = this.createTableHeader(ctx, params);
        RptParams result = new RptParams();
        result.setString("tempTable", newTempTable);
        result.setObject("header", (Object)header1);
        return result;
    }

    private void copyToNewTempTable(Context ctx, String tempTable, String newTempTable, RptParams params) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ").append(newTempTable).append("(").append(this.getSelects(params, true)).append(") ");
        sb.append(" select ").append(this.getSelects(params, false));
        sb.append(" from ").append(tempTable);
        if (params.getBoolean("onlyViewSumRow")) {
            sb.append(" Where Findex<>0 ");
        }
        sb.append(" Order by ").append(this.getOrders(params, false));
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getSelects(RptParams params, boolean hasKsqlSeq) {
        StringBuffer sb = new StringBuffer();
        String SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        if (hasKsqlSeq) {
            sb.append("KSQL_SEQ,");
        }
        sb.append("FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,FMATERIALNAME,FMaterialNumber,FSHORTNAME,FMaterialModel,FBASEUNITNAME,");
        sb.append("FSUMTYPEID,FSUMTYPENAME,");
        if ("FMaterialGroupLevel".equals(SumTypeFieldName)) {
            int materialGroupLevel = params.getInt("materialGroupLevel");
            for (int i = 1; i <= materialGroupLevel; ++i) {
                sb.append("FMATERIALGROUPID" + i + ",");
                sb.append("FMATERIALGROUPNAME" + i + ",");
            }
        }
        sb.append("FBEGINQTY,FBEGINAMOUNT,FINQTY,FINAMOUNT,FOUTQTY,FOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT ");
        return sb.toString();
    }

    private String getOrders(RptParams params, boolean hasKsqlSeq) {
        String SumTypeFieldName = null;
        StringBuffer sb = new StringBuffer();
        if (params.getObject("sumType") != null) {
            SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
            if (hasKsqlSeq) {
                sb.append(" KSQL_SEQ ASC,");
            }
            if (SumTypeFieldName.equals("FCalculateType")) {
                sb.append(" isnull(FYear,2099) ,isnull(FPeriod,99),isnull(FSUMTYPEID,9),FIndex,FMaterialNumber ");
            } else if (((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().equals("FMaterialGroupLevel")) {
                int materialGroupLevel = params.getInt("materialGroupLevel");
                sb.append(" isnull(FYear,2099) ,isnull(FPeriod,99)");
                for (int i = 1; i <= materialGroupLevel; ++i) {
                    sb.append(",FMATERIALGROUPID" + i + ",FMATERIALGROUPNAME" + i);
                }
                sb.append(",FIndex,FMaterialNumber");
            } else {
                sb.append(" isnull(FYear,2099) ,isnull(FPeriod,99),isnull(FSUMTYPEID,'zzzzzzzzzz'),FIndex,FMaterialNumber ");
            }
        } else {
            sb.append("1");
        }
        return sb.toString();
    }

    private RptTableHeader createTableHeader(Context ctx, RptParams params) throws BOSException, EASBizException {
        int qtyPresision = params.getInt("spinQtyPrecission");
        int amtPrecision = params.getInt("spinAmountPrecission");
        int prcPresision = params.getInt("spinPricePrecission");
        String qtyFormat = CalculateUtil.getFormatPattern(qtyPresision);
        String amtFormat = CalculateUtil.getFormatPattern(amtPrecision);
        String prcFormat = CalculateUtil.getFormatPattern(prcPresision);
        String SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FCompanyName");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FYear");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FPeriod");
        col.setWidth(50);
        header.addColumn(col);
        col = new RptTableColumn("FSumTypeName");
        col.setWidth(100);
        if (!((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().equals("FMaterialGroupLevel")) {
            header.addColumn(col);
        }
        if (SumTypeFieldName.equals("FMaterialGroupLevel")) {
            int materialGroupLevel = params.getInt("materialGroupLevel");
            for (int i = 1; i <= materialGroupLevel; ++i) {
                col = new RptTableColumn("FMATERIALGROUPNAME" + i);
                col.setWidth(100);
                header.addColumn(col);
            }
        }
        col = new RptTableColumn("FMaterialNumber");
        col.setFormatPattern("@");
        col.setWidth(100);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FMATERIALNAME");
        col.setWidth(150);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FSHORTNAME");
        col.setWidth(150);
        if (params.getBoolean("onlyViewSumRow")) {
            col.setHided(true);
        } else if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName")) {
            col.setHided(false);
        } else {
            col.setHided(true);
        }
        header.addColumn(col);
        col = new RptTableColumn("FMaterialModel");
        col.setWidth(100);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FBASEUNITNAME");
        col.setWidth(100);
        col.setHided(params.getBoolean("onlyViewSumRow"));
        header.addColumn(col);
        col = new RptTableColumn("FBeginQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FBeginPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FBeginAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FInAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FOutAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainQTY");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(qtyFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainPrice");
        col.setWidth(80);
        col.setAligment(2);
        col.setFormatPattern(prcFormat);
        header.addColumn(col);
        col = new RptTableColumn("FRemainAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(amtFormat);
        header.addColumn(col);
        col = new RptTableColumn("FSumTypeID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FMaterialID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FIndex");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FCompanyOrgUnitID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        String intFormat = CalculateUtil.getFormatPattern(0);
        col = new RptTableColumn("fqtyprecision");
        col.setWidth(0);
        col.setHided(true);
        col.setFormatPattern(intFormat);
        header.addColumn(col);
        col = new RptTableColumn("fpriceprecision");
        col.setWidth(0);
        col.setHided(true);
        col.setFormatPattern(intFormat);
        header.addColumn(col);
        SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getAlias(ctx.getLocale());
        if (((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().equals("FMaterialGroupLevel")) {
            int materialGroupLevel = params.getInt("materialGroupLevel");
            Object[][] aObject = new Object[2][materialGroupLevel + 26];
            aObject[0][0] = SCMUtils.getResource((String)this.res, (String)"FICU", (Context)ctx);
            aObject[0][1] = SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx);
            aObject[0][2] = SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx);
            aObject[0][3] = SumTypeFieldName;
            aObject[1][0] = SCMUtils.getResource((String)this.res, (String)"FICU", (Context)ctx);
            aObject[1][1] = SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx);
            aObject[1][2] = SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx);
            for (int i = 1; i <= materialGroupLevel; ++i) {
                aObject[0][2 + i] = i + SCMUtils.getResource((String)this.res, (String)"MATERIALGROUPLEVEL", (Context)ctx);
                aObject[1][2 + i] = i + SCMUtils.getResource((String)this.res, (String)"MATERIALGROUPLEVEL", (Context)ctx);
            }
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"FSHORTNAME", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx);
            aObject[0][3 + materialGroupLevel++] = "FSumTypeID";
            aObject[0][3 + materialGroupLevel++] = "FMaterialID";
            aObject[0][3 + materialGroupLevel++] = "FIndex";
            aObject[0][3 + materialGroupLevel++] = "FCompanyOrgUnitID";
            aObject[0][3 + materialGroupLevel++] = "fqtyprecision";
            aObject[0][3 + materialGroupLevel++] = "fpriceprecision";
            materialGroupLevel = params.getInt("materialGroupLevel");
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"FSHORTNAME", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx);
            aObject[1][3 + materialGroupLevel++] = "FSumTypeID";
            aObject[1][3 + materialGroupLevel++] = "FMaterialID";
            aObject[1][3 + materialGroupLevel++] = "FIndex";
            aObject[1][3 + materialGroupLevel++] = "FCompanyOrgUnitID";
            aObject[1][3 + materialGroupLevel++] = "fqtyprecision";
            aObject[1][3 + materialGroupLevel++] = "fpriceprecision";
            header.setLabels(aObject, true);
        } else {
            header.setLabels((Object[][])new Object[][]{{SCMUtils.getResource((String)this.res, (String)"FICU", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SumTypeFieldName, SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FSHORTNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FIRSTPERIOD", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"IN", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"OUT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"BALANCE", (Context)ctx), "FSumTypeID", "FMaterialID", "FIndex", "FCompanyOrgUnitID", "fqtyprecision", "fpriceprecision"}, {SCMUtils.getResource((String)this.res, (String)"FICU", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"YEAR", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PERIOD", (Context)ctx), SumTypeFieldName, SCMUtils.getResource((String)this.res, (String)"MATERIELCODE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MATERIELNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"FSHORTNAME", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MODEL", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"MEASUREUNIT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"QUANTITY", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"PRICE", (Context)ctx), SCMUtils.getResource((String)this.res, (String)"AMOUNT", (Context)ctx), "FSumTypeID", "FMaterialID", "FIndex", "FCompanyOrgUnitID", "fqtyprecision", "fpriceprecision"}}, true);
        }
        return header;
    }

    private String getWherePeriodSql(Context ctx, RptParams params, PeriodInfo currPeriodInfo, boolean isAllPeriod) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
        if (companyInfo == null) {
            throw new PeriodException(PeriodException.COMPANY_NOT_NULL);
        }
        if (companyInfo.getAccountPeriodType() == null || companyInfo.getAccountPeriodType().getId() == null) {
            ICompanyOrgUnit iCompanyOrgUnit = null;
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            companyInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId()));
        }
        if (companyInfo.getAccountPeriodType() == null) {
            return null;
        }
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        if (!isAllPeriod) {
            beginYear = currPeriodInfo.getPeriodYear();
            beginPeriod = currPeriodInfo.getPeriodNumber();
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo beginPeriodInfo = iPeriod.getPeriodInfo(beginYear, beginPeriod, companyInfo.getAccountPeriodType());
        PeriodInfo endPeriodInfo = iPeriod.getPeriodInfo(endYear, endPeriod, companyInfo.getAccountPeriodType());
        if (beginPeriodInfo == null || beginPeriodInfo.getPeriodYear() == 0 || beginPeriodInfo.getPeriodNumber() == 0) {
            throw new CalculateException(CalculateException.BEGINPERIODINVALID);
        }
        if (endPeriodInfo == null || endPeriodInfo.getPeriodYear() == 0 || endPeriodInfo.getPeriodNumber() == 0) {
            throw new CalculateException(CalculateException.ENDPERIODINVALID);
        }
        StringBuffer wherePeriod = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        wherePeriod.append("(h.fbizdate >= ?");
        wherePeriod.append(" and h.fbizdate <= ?").append(")");
        wherePeriod.append(" and p.FISADJUSTPERIOD = 0 ");
        wherePeriod.append(" and p.FTypeID = '" + companyInfo.getAccountPeriodType().getId().toString() + "' ");
        params.setString("beginPeriodDate", format.format((Object)beginPeriodInfo.getBeginDate()));
        params.setString("endPeriodDate", sdf.format((Object)endPeriodInfo.getEndDate()));
        return wherePeriod.toString();
    }

    private String getWherePeriod4Balance(Context ctx, RptParams params, PeriodInfo currPeriodInfo, boolean isAllPeriod) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        if (params.getObject("company") != null) {
            company = (CompanyOrgUnitInfo)params.getObject("company");
        }
        int beginYear = params.getInt("accPeriodYearFrom");
        int beginPeriod = params.getInt("accPeriodMonthFrom");
        int endYear = params.getInt("accPeriodYearTo");
        int endPeriod = params.getInt("accPeriodMonthTo");
        if (!isAllPeriod) {
            beginYear = currPeriodInfo.getPeriodYear();
            beginPeriod = currPeriodInfo.getPeriodNumber();
        }
        int fromPeriod = beginYear * 100 + beginPeriod;
        int toPeriod = endYear * 100 + endPeriod;
        StringBuffer wherePeriod = new StringBuffer();
        if (fromPeriod == toPeriod) {
            wherePeriod.append("( d.fyear = ? and d.fperiod = ? )");
            params.setInt("fromPeriod", beginYear);
            params.setInt("toPeriod", beginPeriod);
        } else {
            wherePeriod.append("( d.fyear * 100 + d.fperiod >= ? and d.fyear * 100 + d.fperiod <= ? )");
            params.setInt("fromPeriod", fromPeriod);
            params.setInt("toPeriod", toPeriod);
        }
        wherePeriod.append(" and p.FISADJUSTPERIOD = 0 ");
        if (company != null) {
            wherePeriod.append(" and p.FTypeID = '" + company.getAccountPeriodType().getId().toString() + "' ");
        }
        return wherePeriod.toString();
    }

    private long GetNowTime() {
        Date d = new Date();
        return d.getTime();
    }

    private String getCreateTable(RptParams params) {
        StringBuffer sql = new StringBuffer();
        String SumTypeFieldName = null;
        String SumTypeFieldType = null;
        if (params.getObject("sumType") != null) {
            SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
            SumTypeFieldType = SumTypeFieldName.equals("FCalculateType") ? " int," : " Varchar(44),";
        }
        sql.append("Create Table TempReportTable \r\n");
        sql.append("(KSQL_SEQ INT IDENTITY(1,1),FINDEX Int NOT NULL , \r\n");
        sql.append("FCompanyOrgUnitID Varchar(44), \r\n");
        sql.append("FCOMPANYNAME NVarchar(255), \r\n");
        sql.append("FYear int, \r\n");
        sql.append("FPeriod int, \r\n");
        sql.append("FMaterialID Varchar(44), \r\n");
        sql.append("FMATERIALNAME NVarchar(255),\r\n");
        sql.append("FMaterialNumber NVarchar(80),\r\n");
        sql.append("FSHORTNAME NVarchar(200),\r\n");
        sql.append("FMaterialModel NVarchar(300),\r\n");
        sql.append("FBASEUNITNAME NVarchar(255),\r\n");
        sql.append("FSUMTYPEID " + SumTypeFieldType + newline);
        sql.append("FSUMTYPENAME Varchar(1000),\r\n");
        if ("FMaterialGroupLevel".equals(SumTypeFieldName)) {
            int materialGroupLevel = params.getInt("materialGroupLevel");
            for (int i = 1; i <= materialGroupLevel; ++i) {
                sql.append("FMATERIALGROUPID" + i + " Varchar(100),\r\n");
                sql.append("FMATERIALGROUPNAME" + i + " NVarchar(100),\r\n");
            }
        }
        sql.append("FBEGINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FBEGINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FOUTQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FOUTAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FREMAINQTY NUMERIC(21, 8)  ,\r\n");
        sql.append("FREMAINAMOUNT NUMERIC(17, 4) );\r\n");
        return sql.toString();
    }

    private String getCreateTempMidTable() {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable \r\n");
        sql.append("(FINDEX Int NOT NULL , \r\n");
        sql.append("FCompanyOrgUnitID Varchar(44), \r\n");
        sql.append("FCOMPANYNAME NVarchar(255), \r\n");
        sql.append("FYear int, \r\n");
        sql.append("FPeriod int, \r\n");
        sql.append("FMaterialID Varchar(44), \r\n");
        sql.append("FWarehouseID Varchar(44), \r\n");
        sql.append("FStorageOrgUnitID Varchar(44), \r\n");
        sql.append("FBEGINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FBEGINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FINQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FSTDINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FCOSTINAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FOUTQTY NUMERIC(21, 8) ,\r\n");
        sql.append("FSTDOUTAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FCOSTOUTAMOUNT NUMERIC(17, 4)  ,\r\n");
        sql.append("FREMAINQTY NUMERIC(21, 8)  ,\r\n");
        sql.append("FREMAINAMOUNT NUMERIC(17, 4) );\r\n");
        return sql.toString();
    }

    private String getPeriodHappen(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String midTempTable = this.createTempTable(ctx, this.getCreateTable(params));
        StringBuffer sqlAll = new StringBuffer();
        logger.info((Object)"#######################\u7edf\u8ba1\u671f\u521d\u6570\u636e#############################");
        this.getStockSQL(ctx, midTempTable, params);
        boolean hasCurrAndAfterPeriod = params.getBoolean("hasCurrAndAfterPeriod");
        if (hasCurrAndAfterPeriod) {
            this.getCurrPeriodBillSQL(ctx, midTempTable, params);
            logger.info((Object)"#######################\u7edf\u8ba1\u7ed3\u5b58\u6570\u636e#############################");
            this.GetStdAdjBillSQL(ctx, midTempTable, params);
        }
        sqlAll.setLength(0);
        sqlAll.append("INSERT INTO " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,FMATERIALNAME,").append(newline);
        sqlAll.append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID,FSUMTYPENAME,FBEGINQTY,FBEGINAMOUNT,FINQTY,").append(newline);
        sqlAll.append("FINAMOUNT,FOUTQTY,FOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT)").append(newline);
        sqlAll.append("Select 0 as FIndex,FCompanyOrgUnitID,FCompanyName,FYear,FPeriod,FMaterialID,FMaterialName,FMaterialNumber,").append(newline);
        sqlAll.append("FSHORTNAME,FMaterialModel,FBaseUnitName,FSumTypeID,FSumTypeName,sum(FBeginQty),sum(FBeginAmount),").append(newline);
        sqlAll.append("sum(FInQty),sum(FINAmount),sum(FOutQty),sum(FOutAmount),sum(FRemainQty),sum(FRemainAmount)").append(newline);
        sqlAll.append(" From ").append(midTempTable).append(" T ").append(newline);
        sqlAll.append(" Group by FCompanyOrgUnitID,FCompanyName,FYear,FPeriod,FMaterialID,FMaterialName,").append(newline);
        sqlAll.append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBaseUnitName,FSumTypeID,FSumTypeName").append(newline);
        this.executeSQL(ctx, sqlAll.toString());
        this.dropTempTable(midTempTable, ctx);
        return sqlAll.toString();
    }

    private void getCurrPeriodBillSQL(Context ctx, String tempTable, RptParams params) throws BOSException {
        int i;
        int length;
        String fiOrgUnitID = null;
        String MaterialFrom = null;
        String MaterialTo = null;
        String MaterialIn = null;
        String warehouse = null;
        String storeType = null;
        String txtMShortNameFrom = null;
        String txtMShortNameTo = null;
        String SumTypeFieldName = "";
        boolean noSelectStorageMoveBill = false;
        boolean noSelectWarehouseMoveBill = false;
        boolean ckShowNoCalculate = false;
        int voucher = -1;
        SqlParams parameters = new SqlParams();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        if (params.getObject("company") != null) {
            fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        }
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumber(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialFrom")).getNumber() : params.getObject("materialFrom").toString();
            }
        }
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        if (params.getObject("sumType") != null) {
            SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        }
        Object[] prmtKAClass = null;
        if (params.getObject("prmtKAClass") != null) {
            Object[] objectArray;
            Object prmtKAClassObj = params.getObject("prmtKAClass");
            if (prmtKAClassObj instanceof Object[]) {
                objectArray = (Object[])prmtKAClassObj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = prmtKAClassObj;
            }
            prmtKAClass = objectArray;
        }
        if (params.getString("warehouse") != null) {
            warehouse = params.getString("warehouse");
        }
        if (params.getString("storeType") != null) {
            storeType = params.getString("storeType");
        }
        txtMShortNameFrom = params.getString("txtMShortNameFrom");
        txtMShortNameTo = params.getString("txtMShortNameTo");
        ckShowNoCalculate = params.getBoolean("ckShowNoCalculate");
        noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        voucher = ((VoucheredEnum)((Object)params.getObject("voucher"))).getValue();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)params.getObject("company");
        StringBuffer sqlSelect = new StringBuffer();
        String tempMidTable = this.createTempTable(ctx, this.getCreateTempMidTable());
        sqlSelect.append("INSERT INTO " + tempMidTable + "(");
        sqlSelect.append("FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,").append(newline);
        sqlSelect.append("FWarehouseID,FStorageOrgUnitID,").append(newline);
        sqlSelect.append("FBEGINQTY,FBEGINAMOUNT,FINQTY,FSTDINAMOUNT,FCOSTINAMOUNT,").append(newline);
        sqlSelect.append("FOUTQTY,FSTDOUTAMOUNT,FCOSTOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT)").append(newline);
        sqlSelect.append("SELECT /*+ leading(h)*/ 0 as FIndex, ");
        sqlSelect.append("d.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sqlSelect.append("'").append(companyInfo.getName()).append("' as FCompanyName, ");
        sqlSelect.append("h.FYear as FYear, ");
        sqlSelect.append("h.FPeriod as FPeriod, ");
        sqlSelect.append("d.FMaterialID as FMaterialID, ");
        sqlSelect.append("d.FWarehouseID as FWarehouseID, ");
        sqlSelect.append("d.FStorageOrgUnitID as FStorageOrgUnitID, ");
        sqlSelect.append("0 as FBeginQty, ");
        sqlSelect.append("0 as FBeginAmount, ");
        StringBuffer sqlSelectForSaleIuuseInsert = new StringBuffer();
        sqlSelectForSaleIuuseInsert.append("INSERT INTO " + tempMidTable + "(");
        sqlSelectForSaleIuuseInsert.append("FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,").append(newline);
        sqlSelectForSaleIuuseInsert.append("FWarehouseID,FStorageOrgUnitID,").append(newline);
        sqlSelectForSaleIuuseInsert.append("FBEGINQTY,FBEGINAMOUNT,FINQTY,FSTDINAMOUNT,FCOSTINAMOUNT,").append(newline);
        sqlSelectForSaleIuuseInsert.append("FOUTQTY,FSTDOUTAMOUNT,FCOSTOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT)").append(newline);
        sqlSelectForSaleIuuseInsert.append("SELECT  /*+ leading(h)*/ b.FIndex, ");
        sqlSelectForSaleIuuseInsert.append("b.FCompanyOrgUnitID, ");
        sqlSelectForSaleIuuseInsert.append("'").append(companyInfo.getName()).append("' as FCompanyName, ");
        sqlSelectForSaleIuuseInsert.append("b.FYear, ");
        sqlSelectForSaleIuuseInsert.append("b.FPeriod, ");
        sqlSelectForSaleIuuseInsert.append("b.FMaterialID, ");
        sqlSelectForSaleIuuseInsert.append("b.FWarehouseID, ");
        sqlSelectForSaleIuuseInsert.append("b.FStorageOrgUnitID, ");
        sqlSelectForSaleIuuseInsert.append("b.FBeginQty, ");
        sqlSelectForSaleIuuseInsert.append("b.FBeginAmount, ");
        StringBuffer sqlSelectForSaleIuuse = new StringBuffer();
        sqlSelectForSaleIuuse.append("SELECT  /*+ leading(h)*/ 0 as FIndex, ");
        sqlSelectForSaleIuuse.append("d.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sqlSelectForSaleIuuse.append("'").append(companyInfo.getName()).append("' as FCompanyName, ");
        sqlSelectForSaleIuuse.append("h.FYear as FYear, ");
        sqlSelectForSaleIuuse.append("h.FPeriod as FPeriod, ");
        sqlSelectForSaleIuuse.append("d.FMaterialID as FMaterialID, ");
        sqlSelectForSaleIuuse.append("d.FWarehouseID as FWarehouseID, ");
        sqlSelectForSaleIuuse.append("d.FStorageOrgUnitID as FStorageOrgUnitID, ");
        sqlSelectForSaleIuuse.append("0 as FBeginQty, ");
        sqlSelectForSaleIuuse.append("0 as FBeginAmount, ");
        StringBuffer storeTypeFilter = new StringBuffer();
        StringBuffer storeTypeInFilter = new StringBuffer();
        if (storeType != null) {
            String[] storeTypes = storeType.split(",");
            storeTypeFilter.append(" AND storetype.FNumber in (");
            storeTypeInFilter.append(" AND storetypeIn.FNumber in (");
            int length2 = storeTypes.length;
            for (int i2 = 0; i2 < length2; ++i2) {
                if (i2 > 0) {
                    storeTypeFilter.append(",");
                    storeTypeInFilter.append(",");
                }
                storeTypeFilter.append("'").append(storeTypes[i2]).append("'");
                storeTypeInFilter.append("'").append(storeTypes[i2]).append("'");
            }
            storeTypeFilter.append(") ");
            storeTypeInFilter.append(") ");
        }
        String sqlInOutBill = "sum(case when  isnull(storetypeIn.FIsForwardAmt,0) = 1" + storeTypeInFilter + "then d.FBaseQty else 0 end) as FInQty,";
        sqlInOutBill = sqlInOutBill + "sum(case when  isnull(storetypeIn.FIsForwardAmt,0) = 1" + storeTypeInFilter + " then d.FStandardCost else 0 end) as FSTDINAMOUNT,sum(case when  isnull(storetypeIn.FIsForwardAmt,0) = 1 " + storeTypeInFilter + "then d.FActualCost else 0 end) as FCOSTINAMOUNT,";
        sqlInOutBill = sqlInOutBill + "sum(case when  isnull(storetype.FIsForwardAmt,0) = 1 " + storeTypeFilter + "then d.FBaseQty else 0 end) as FOutQty,sum(case when  isnull(storetype.FIsForwardAmt,0) = 1 " + storeTypeFilter + "then d.FStandardCost else 0 end) as FSTDOutAmount, sum(case when  isnull(storetype.FIsForwardAmt,0) = 1 " + storeTypeFilter + "then d.FActualCost else 0 end)  as FCOSTOutAmount,";
        sqlInOutBill = sqlInOutBill + "0 as FRemainQty,0 as FRemainAmount ";
        String saleIuuseSqlOut = "sum(case when  isnull(storetypeIn.FIsForwardAmt,0) = 1" + storeTypeInFilter + "then d.FBASEQTY else 0 end) as FInQty,sum(case when  isnull(storetypeIn.FIsForwardAmt,0) = 1 " + storeTypeInFilter + "then  d.FStandardCost else 0 end) as FSTDINAMOUNT, sum(case when  isnull(storetypeIn.FIsForwardAmt,0) = 1 " + storeTypeInFilter + "then  d.FActualCost else 0 end)  AS FCOSTINAMOUNT,";
        saleIuuseSqlOut = saleIuuseSqlOut + "sum(case when  isnull(storetype.FIsForwardAmt,0) = 1 " + storeTypeFilter + "then d.FBaseQty else 0 end) as FOutQty,";
        saleIuuseSqlOut = saleIuuseSqlOut + "sum(case when  isnull(storetype.FIsForwardAmt,0) = 1 " + storeTypeFilter + "then d.FStandardCost else 0 end ) AS FSTDOUTAMOUNT, sum(case when  isnull(storetype.FIsForwardAmt,0) = 1 " + storeTypeFilter + "then d.FActualCost else 0 end ) AS FCOSTOutAmount,";
        saleIuuseSqlOut = saleIuuseSqlOut + "0 as FRemainQty,0 as FRemainAmount ";
        String saleIuuseSqlOutForOtherBill = "sum(case when tr.FNumber  = '014' or tr.Fnumber = '015' or  tr.FNumber  = '017' or tr.Fnumber = '018'  then d.FBASEQTY else 0 end) as FInQty,sum(d.FStandardCost) as FSTDINAMOUNT, sum(d.FActualCost)  AS FCOSTINAMOUNT,";
        saleIuuseSqlOutForOtherBill = saleIuuseSqlOutForOtherBill + "sum(otherBillEntry.FbaseQty) as FOutQty,";
        saleIuuseSqlOutForOtherBill = saleIuuseSqlOutForOtherBill + "sum(d.FStandardCost) AS FSTDOUTAMOUNT, sum(d.FActualCost*(otherBillEntry.FBaseQty/d.fbaseqty)) AS FCOSTOutAmount,";
        saleIuuseSqlOutForOtherBill = saleIuuseSqlOutForOtherBill + "0 as FRemainQty,0 as FRemainAmount ";
        String saleIuuseSqlOutForOtherBillAndIssue = "b.Finqty as FInQty,b.FSTDINAMOUNT as FSTDINAMOUNT, b.FCOSTINAMOUNT AS FCOSTINAMOUNT,";
        saleIuuseSqlOutForOtherBillAndIssue = saleIuuseSqlOutForOtherBillAndIssue + "sum(isnull(a.FOutQty,0)+b.FOutQty) as FOutQty,";
        saleIuuseSqlOutForOtherBillAndIssue = saleIuuseSqlOutForOtherBillAndIssue + "sum(isnull(a.FSTDOUTAMOUNT,0)+b.FSTDOUTAMOUNT) AS FSTDOUTAMOUNT, sum(isnull(a.FCOSTOutAmount,0)+b.FCOSTOutAmount) AS FCOSTOutAmount,";
        saleIuuseSqlOutForOtherBillAndIssue = saleIuuseSqlOutForOtherBillAndIssue + "0 as FRemainQty,0 as FRemainAmount ";
        String sqlInOut = "0 as FInQty, 0 as FSTDINAMOUNT,";
        sqlInOut = sqlInOut + "case h.FCalculateKind when 0 then sum(d.FActualCost) end as FCOSTINAMOUNT,";
        sqlInOut = sqlInOut + "0 as FOutQty, 0 AS FSTDOutAmount,";
        sqlInOut = sqlInOut + "case h.FCalculateKind when 1 then sum(d.FActualCost) end as FCOSTOutAmount,";
        sqlInOut = sqlInOut + "0 as FRemainQty,0 as FRemainAmount ";
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" WHERE (h.FIsInitBill = 0 or h.FIsInitBill is null ) ");
        if (voucher != -1) {
            sqlWhere.append("And h.ffiVouchered = ? ");
            parameters.addInt(voucher);
        }
        sqlWhere.append(" And d.FCompanyOrgUnitID = ? ");
        parameters.addString(fiOrgUnitID);
        int status = -1;
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
            if (status == 2) {
                sqlWhere.append(" AND h.FBaseStatus = ? ");
                parameters.addInt(status);
            } else if (status == 4) {
                sqlWhere.append(" AND h.FBaseStatus = ? ");
                parameters.addInt(status);
            } else {
                sqlWhere.append(" And (h.FBaseStatus = ? or h.FBaseStatus = ? )");
                parameters.addInt(2).addInt(4);
            }
        }
        String psql = params.getString("whereCurrAndAfterPeriodSql");
        sqlWhere.append(" AND (").append(psql).append(") ");
        parameters.addTimestamp(Timestamp.valueOf(params.getString("beginPeriodDate")));
        parameters.addTimestamp(Timestamp.valueOf(params.getString("endPeriodDate")));
        String sqlWhereCostAdj = sqlWhere.toString() + storeTypeFilter;
        if (!ckShowNoCalculate) {
            sqlWhere.append(" And h.FTransactionTypeID in (select fid from t_scm_transactiontype tr where tr.FIsCalculate = 1) ");
        }
        StringBuffer sqlWhereForIsArUpdate = new StringBuffer();
        sqlWhereForIsArUpdate.append(" WHERE (h.FIsInitBill = 0 or h.FIsInitBill is null ) ");
        if (voucher != -1) {
            sqlWhereForIsArUpdate.append("And h.ffiVouchered = '" + voucher + "'");
        }
        sqlWhereForIsArUpdate.append(" And d.FCompanyOrgUnitID = '" + fiOrgUnitID + "'");
        sqlWhereForIsArUpdate.append(" And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
        sqlWhereForIsArUpdate.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
        if (params.getObject("status") != null) {
            status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
            if (status == 2) {
                sqlWhereForIsArUpdate.append(" AND h.FBaseStatus = " + status + "");
            } else if (status == 4) {
                sqlWhereForIsArUpdate.append(" AND h.FBaseStatus = " + status + "");
            } else {
                sqlWhereForIsArUpdate.append(" And (h.FBaseStatus =2 or h.FBaseStatus =4)");
            }
        }
        sqlWhereForIsArUpdate.append(" and p.FISADJUSTPERIOD = 0 ");
        sqlWhereForIsArUpdate.append(" and p.FTypeID = '" + company.getAccountPeriodType().getId().toString() + "' ");
        sqlWhereForIsArUpdate.append("   and  h.fbizdate >= to_date('").append(Timestamp.valueOf(params.getString("beginPeriodDate"))).append("')");
        sqlWhereForIsArUpdate.append("   and  h.fbizdate <= to_date('").append(Timestamp.valueOf(params.getString("endPeriodDate"))).append("')");
        boolean isArUpdateInventory = params.getBoolean("isArUpdateInventory");
        StringBuffer sqlWhereSaleissue = new StringBuffer();
        sqlWhereSaleissue.append(sqlWhere);
        sqlWhereSaleissue.append(" And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
        sqlWhereSaleissue.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
        StringBuffer sqlWhereSaleissueForOtherBill = new StringBuffer();
        sqlWhereSaleissueForOtherBill.append(sqlWhere);
        sqlWhereSaleissueForOtherBill.append(" And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'");
        sqlWhereSaleissueForOtherBill.append(" and relation.FTOUNITID = '" + fiOrgUnitID + "'");
        sqlWhereSaleissueForOtherBill.append(" AND bizType.fid in (").append(newline);
        sqlWhereSaleissueForOtherBill.append(" '").append("d8e80652-0113-1000-e000-04c5c0a812202407435C").append("',").append(newline);
        sqlWhereSaleissueForOtherBill.append(" '").append("d8e80652-0114-1000-e000-04c5c0a812202407435C").append("') ").append(newline);
        sqlWhereSaleissueForOtherBill.append("   and  otherBill.fbillstatus = 3").append(newline);
        sqlWhereSaleissueForOtherBill.append("   and  otherBill.fbillDate >= to_date('").append(Timestamp.valueOf(params.getString("beginPeriodDate"))).append("')");
        sqlWhereSaleissueForOtherBill.append("   and  otherBill.fbillDate <= to_date('").append(Timestamp.valueOf(params.getString("endPeriodDate"))).append("')");
        StringBuffer sqlWhereSaleissueForIssue = new StringBuffer();
        sqlWhereSaleissueForIssue.append(sqlWhereForIsArUpdate);
        sqlWhere.append(" And (storetype.FIsForwardAmt = 1 or storetypeIn.FIsForwardAmt = 1)");
        StringBuffer sqlGroup = new StringBuffer();
        sqlGroup.append(" GRoup by d.FCompanyOrgUnitID,");
        sqlGroup.append("h.FYear,h.FPeriod,");
        sqlGroup.append("d.FMaterialID,");
        sqlGroup.append("d.FStorageOrgUnitID,");
        sqlGroup.append("d.FWarehouseID");
        StringBuffer sqlGroupIsArUpdate = new StringBuffer();
        sqlGroupIsArUpdate.append(" GRoup by b.FCompanyOrgUnitID,");
        sqlGroupIsArUpdate.append("b.FYear,b.FPeriod,");
        sqlGroupIsArUpdate.append("b.FMaterialID,");
        sqlGroupIsArUpdate.append("b.FStorageOrgUnitID,");
        sqlGroupIsArUpdate.append("b.FWarehouseID,");
        sqlGroupIsArUpdate.append("b.FIndex,b.FBeginQty,b.FBeginAmount,b.Finqty,b.FSTDINAMOUNT,b.FCOSTINAMOUNT");
        SQLThreadPool sqlExecutePool = new SQLThreadPool(ctx);
        String sql = "";
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString();
        sql = sql + " And relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5'";
        sql = sql + " and relation.FTOUNITID = '" + fiOrgUnitID + "'";
        sql = sql + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString() + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString();
        if (noSelectStorageMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ";
        }
        if (noSelectWarehouseMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ";
        }
        sql = sql + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString() + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        String a = sqlSelectForSaleIuuse.toString() + saleIuuseSqlOutForOtherBill;
        a = a + this.sqlForSaleissueIsArUpdateI(ctx, "T_IM_SaleIssueBill", "T_IM_SaleIssueEntry");
        a = a + sqlWhereSaleissueForOtherBill.toString() + sqlGroup.toString();
        String b = sqlSelectForSaleIuuse.toString() + saleIuuseSqlOut;
        b = b + this.sqlForSaleissue(ctx, "T_IM_SaleIssueBill", "T_IM_SaleIssueEntry");
        b = b + sqlWhereSaleissueForIssue.toString() + sqlGroup.toString();
        if (isArUpdateInventory) {
            sql = sqlSelectForSaleIuuseInsert.toString() + saleIuuseSqlOutForOtherBillAndIssue;
            sql = sql + " From (" + a + ") a right join (" + b + ") b on a.fmaterialid = b.fmaterialid";
            sql = sql + sqlGroupIsArUpdate.toString();
            sqlExecutePool.addSQL(new Object[]{sql, parameters});
        } else {
            sql = sqlSelect.toString() + saleIuuseSqlOut;
            sql = sql + this.sqlForSaleissue(ctx, "T_IM_SaleIssueBill", "T_IM_SaleIssueEntry");
            sql = sql + sqlWhereSaleissue.toString() + sqlGroup.toString();
            sqlExecutePool.addSQL(new Object[]{sql, parameters});
        }
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString() + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString();
        if (noSelectStorageMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011a-1000-e000-04c5c0a812202407435C' ";
        }
        if (noSelectWarehouseMoveBill) {
            sql = sql + "and h.FBizTypeID <>'d8e80652-011b-1000-e000-04c5c0a812202407435C' ";
        }
        sql = sql + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sql = sqlSelect.toString() + sqlInOutBill;
        sql = sql + this.sqlFrom(ctx, "T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", SumTypeFieldName);
        sql = sql + sqlWhere.toString() + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sqlGroup.append(",h.FCalculateKind");
        sql = sqlSelect.toString() + sqlInOut;
        sql = sql + this.sqlFrom(ctx, "T_CL_CostAdjustBill", "T_CL_CostAdjustBillEntry", SumTypeFieldName);
        sql = sql + sqlWhereCostAdj + sqlGroup.toString();
        sqlExecutePool.addSQL(new Object[]{sql, parameters});
        sqlExecutePool.startWorker();
        if (this.excList.size() > 0) {
            throw new BOSException((Throwable)this.excList.get(0));
        }
        logger.info((Object)"#######################\u6240\u6709\u5355\u636e\u7684\u603b\u8ba1#############################");
        sqlSelect.setLength(0);
        sqlSelect.append("INSERT INTO " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,FMATERIALNAME,").append(newline);
        sqlSelect.append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID,FSUMTYPENAME,FBEGINQTY,FBEGINAMOUNT,FINQTY,").append(newline);
        sqlSelect.append("FINAMOUNT,FOUTQTY,FOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT)").append(newline);
        sqlSelect.append("SELECT 0 as FIndex, ");
        sqlSelect.append("t.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sqlSelect.append("fi.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sqlSelect.append("t.FYear as FYear, ");
        sqlSelect.append("t.FPeriod as FPeriod, ");
        sqlSelect.append("t.FMaterialID as FMaterialID, ");
        sqlSelect.append("max(m.FName_" + this.getLoc(ctx) + ") as FMaterialName, ");
        sqlSelect.append("max(m.FNumber) as FMaterialNumber, ");
        sqlSelect.append("max(m.FSHORTNAME) as FSHORTNAME, ");
        sqlSelect.append("max(m.FModel) as FMaterialModel, ");
        sqlSelect.append("max(mu.FName_" + this.getLoc(ctx) + ") as FBaseUnitName, ");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sqlSelect.append("case mcom.FCalculateType when 0 then null else mcom.FCalculateType end as FSumTypeID,");
            sqlSelect.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sqlSelect.append("t.FStorageOrgUnitID as FSumTypeID, ");
            sqlSelect.append("so.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sqlSelect.append("t.FWarehouseID as FSumTypeID, ");
            sqlSelect.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sqlSelect.append("mcom.FKAClassID as FSumTypeID,");
            sqlSelect.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FMaterialGroupLevel")) {
            sqlSelect.append("'1' as FSumTypeID,");
            sqlSelect.append("'2' as FSumTypeName, ");
        }
        sqlSelect.append("0 as FBeginQty, ");
        sqlSelect.append("0 as FBeginAmount, ");
        sqlSelect.append("sum(t.FInQty) as FInQty,");
        sqlSelect.append("CASE mcom.FAccountType WHEN 2 THEN sum(t.FSTDInAmount) ELSE sum(T.FCOSTInAmount) END as FInAmount,");
        sqlSelect.append("sum(FOutQty) as FOutQty,");
        sqlSelect.append("CASE mcom.FAccountType WHEN 2 THEN sum(t.FstdOutAmount) ELSE sum(t.FcostOutAmount) END as FOutAmount,");
        sqlSelect.append("0 as FRemainQty,0 as FRemainAmount ");
        sqlSelect.append(" From " + tempMidTable + " t \r\n");
        sqlSelect.append("Inner Join T_BD_Material m On t.FMaterialID=m.FID \r\n");
        sqlSelect.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On t.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = t.FCompanyOrgUnitID \r\n");
        sqlSelect.append("Inner Join T_DB_WAREHOUSE wh on t.FWarehouseID = wh.FID \r\n");
        sqlSelect.append("Inner Join T_ORG_Storage so on t.FStorageOrgUnitID = so.FID \r\n");
        sqlSelect.append("INNER JOIN T_BD_MeasureUnit mu ON m.FBaseUnit = mu.FID \r\n");
        sqlSelect.append("INNER JOIN t_org_company fi ON t.FCompanyOrgUnitID = fi.FID \r\n");
        sqlSelect.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID \r\n");
        sqlSelect.append("WHERE 1 = 1 ");
        SqlParams parametersTemp = new SqlParams();
        if (MaterialFrom != null) {
            sqlSelect.append(" AND m.FNumber >= ? ");
            parametersTemp.addString(MaterialFrom);
        }
        if (MaterialTo != null) {
            sqlSelect.append(" AND m.FNumber <= ? ");
            parametersTemp.addString(MaterialTo);
        }
        if (MaterialIn != null) {
            String[] materials = MaterialIn.split(",");
            sqlSelect.append(" AND m.FNumber in(");
            length = materials.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sqlSelect.append(",");
                }
                sqlSelect.append("?");
                parametersTemp.addString(materials[i]);
            }
            sqlSelect.append(")");
        }
        if (warehouse != null) {
            String[] warehouses = warehouse.split(",");
            sqlSelect.append(" AND wh.FNumber in(");
            length = warehouses.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sqlSelect.append(",");
                }
                sqlSelect.append("?");
                parametersTemp.addString(warehouses[i]);
            }
            sqlSelect.append(")");
        }
        if (prmtKAClass != null) {
            sqlSelect.append(" AND mcom.FKAClassID in(");
            int length3 = prmtKAClass.length;
            for (int i3 = 0; i3 < length3; ++i3) {
                if (i3 > 0) {
                    sqlSelect.append(",");
                }
                sqlSelect.append("?");
                parametersTemp.addString(((KAClassficationInfo)prmtKAClass[i3]).getId().toString());
            }
            sqlSelect.append(")");
        }
        if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName")) {
            if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() > 0) {
                sqlSelect.append(" AND M.FShortName >= ? AND M.FShortName <= ? ");
                parametersTemp.addString(txtMShortNameFrom).addString(txtMShortNameTo);
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() <= 0) {
                sqlSelect.append(" AND M.FShortName >= ? ");
                parametersTemp.addString(txtMShortNameFrom);
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() <= 0 && txtMShortNameTo.trim().length() > 0) {
                sqlSelect.append(" AND M.FShortName <= ? ");
                parametersTemp.addString(txtMShortNameTo);
            }
        }
        sqlSelect.append(" GROUP BY t.FCompanyOrgUnitID,fi.FName_" + this.getLoc(ctx) + ",t.FYear, t.FPeriod,t.FMaterialID,mcom.FAccountType");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sqlSelect.append(",mcom.FCalculateType ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sqlSelect.append(",t.FStorageOrgUnitID,");
            sqlSelect.append("so.FName_" + this.getLoc(ctx) + " ");
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sqlSelect.append(",t.FWarehouseID,");
            sqlSelect.append("wh.FName_" + this.getLoc(ctx) + " ");
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sqlSelect.append(",mcom.FKAClassID,");
            sqlSelect.append("ka.FName_" + this.getLoc(ctx) + " ");
        }
        this.executeUpdate(sqlSelect.toString(), parametersTemp, ctx);
        this.dropTempTable(tempMidTable, ctx);
    }

    private void GetStdAdjBillSQL(Context ctx, String tempTable, RptParams params) throws BOSException {
        int i;
        int length;
        String fiOrgUnitID = null;
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)params.getObject("company");
        fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        String SumTypeFieldName = null;
        SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        String MaterialFrom = null;
        String MaterialIn = null;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumber(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialFrom")).getNumber() : params.getObject("materialFrom").toString();
            }
        }
        String MaterialTo = null;
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        String warehouse = null;
        if (params.getString("warehouse") != null) {
            warehouse = params.getString("warehouse");
        }
        String storeType = null;
        if (params.getString("storeType") != null) {
            storeType = params.getString("storeType");
        }
        String txtMShortNameFrom = params.getString("txtMShortNameFrom");
        String txtMShortNameTo = params.getString("txtMShortNameTo");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,FMATERIALNAME,").append(newline);
        sql.append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID,FSUMTYPENAME,FBEGINQTY,FBEGINAMOUNT,FINQTY,").append(newline);
        sql.append("FINAMOUNT,FOUTQTY,FOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT)").append(newline);
        sql.append("SELECT 0 as FIndex, ");
        sql.append("i.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sql.append("fi.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append("i.FYear as FYear, ");
        sql.append("i.FPeriod as FPeriod, ");
        sql.append("i.FMaterialID as FMaterialID, ");
        sql.append("m.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append("m.FNumber as FMaterialNumber, ");
        sql.append("m.FSHORTNAME as FSHORTNAME, ");
        sql.append("m.FModel as FMaterialModel, ");
        sql.append("mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append("case mcom.FCalculateType when 0 then null else mcom.FCalculateType end as FSumTypeID,");
            sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append("i.FStorageOrgUnitID as FSumTypeID, ");
            sql.append("so.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append("i.FWarehouseID as FSumTypeID, ");
            sql.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append("mcom.FKAClassID as FSumTypeID,");
            sql.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName,");
        } else if (SumTypeFieldName.equals("FMaterialGroupLevel")) {
            sql.append("'1' as FSumTypeID,");
            sql.append("'2' as FSumTypeName, ");
        }
        sql.append("0 as FBeginQty, ");
        sql.append("0 as FBeginAmount, ");
        sql.append("0 as FInQty, ");
        sql.append("sum(i.FPeriodAdjustDiff) as FInAmount,");
        sql.append("0 as FOutQty, ");
        sql.append("0 as FOutAmount, ");
        sql.append("0 as FRemainQty, ");
        sql.append("0 as FRemainAmount \r\n");
        sql.append("From T_IM_InventoryBalance i \r\n");
        sql.append("Inner Join T_BD_PERIOD p On i.FPERIOD = p.FPERIODNUMBER and i.FYEAR = p.FPERIODYEAR \r\n");
        sql.append("INNER Join T_BD_Material m On i.FMaterialID=m.FID \r\n");
        sql.append("INNER JOIN t_org_company fi ON i.FCompanyOrgUnitID = fi.FID \r\n");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On i.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = i.FCompanyOrgUnitID \r\n");
        sql.append("Inner Join T_DB_WAREHOUSE wh on i.FWarehouseID = wh.FID \r\n");
        sql.append("Inner Join T_ORG_Storage so on i.FStorageOrgUnitID = so.FID \r\n");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON m.FBaseUnit = mu.FID \r\n");
        sql.append("INNER JOIN T_IM_StoreType storetype ON i.FStoreTypeID = storetype.FID \r\n");
        sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID \r\n");
        SqlParams parameters = new SqlParams();
        sql.append("WHERE i.FPeriodAdjustDiff<>0 And i.FCompanyOrgUnitID = ? ");
        sql.append(" and p.FISADJUSTPERIOD = 0 ");
        sql.append(" and p.FTypeID = '" + company.getAccountPeriodType().getId().toString() + "' ");
        parameters.addString(fiOrgUnitID);
        PeriodInfo currentPeriodInfo = (PeriodInfo)params.getObject("currPeriod");
        sql.append(" AND i.FYear = ? AND i.FPeriod = ? ");
        parameters.addInt(currentPeriodInfo.getPeriodYear()).addInt(currentPeriodInfo.getPeriodNumber());
        if (MaterialFrom != null) {
            sql.append(" AND m.FNumber >= ? ");
            parameters.addString(MaterialFrom);
        }
        if (MaterialTo != null) {
            sql.append(" AND m.FNumber <= ? ");
            parameters.addString(MaterialTo);
        }
        if (MaterialIn != null) {
            String[] materials = MaterialIn.split(",");
            sql.append(" AND m.FNumber in(");
            length = materials.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                parameters.addString(materials[i]);
            }
            sql.append(")");
        }
        if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName")) {
            if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName >= ? AND M.FShortName <= ? ");
                parameters.addString(txtMShortNameFrom).addString(txtMShortNameTo);
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() <= 0) {
                sql.append(" AND M.FShortName >= ? ");
                parameters.addString(txtMShortNameFrom);
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() <= 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName <= ? ");
                parameters.addString(txtMShortNameTo);
            }
        }
        sql.append(" AND storetype.FIsForwardAmt = 1").append(newline);
        if (warehouse != null) {
            String[] warehouses = warehouse.split(",");
            sql.append(" AND wh.FNumber in(");
            length = warehouses.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                parameters.addString(warehouses[i]);
            }
            sql.append(")");
        }
        if (storeType != null) {
            String[] storeTypes = storeType.split(",");
            sql.append(" AND storetype.FNumber in(");
            length = storeTypes.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                parameters.addString(storeTypes[i]);
            }
            sql.append(")");
        }
        Object prmtKAClassObj = params.getObject("prmtKAClass");
        Object[] prmtKAClass = null;
        if (prmtKAClassObj != null) {
            Object[] objectArray;
            if (prmtKAClassObj instanceof Object[]) {
                objectArray = (Object[])prmtKAClassObj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = prmtKAClassObj;
            }
            prmtKAClass = objectArray;
            if (prmtKAClass != null && prmtKAClass.length > 0) {
                sql.append(" AND mcom.FKAClassID in ( ");
                for (int i2 = 0; i2 < prmtKAClass.length; ++i2) {
                    if (i2 > 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                    parameters.addString(((KAClassficationInfo)prmtKAClass[i2]).getId().toString());
                }
                sql.append(")");
            }
        }
        sql.append("\r\n GRoup by i.FCompanyOrgUnitID,fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("i.FYear,i.FPeriod,");
        sql.append("i.FMaterialID,m.FName_" + this.getLoc(ctx) + ",");
        sql.append("m.FNumber,m.FSHORTNAME,m.FModel,");
        sql.append("mu.FName_" + this.getLoc(ctx) + ",");
        sql.append("mcom.FAccountType");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append(",mcom.FCalculateType ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append(",i.FStorageOrgUnitID,");
            sql.append("so.FName_" + this.getLoc(ctx) + " ");
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append(",i.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx) + " ");
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx) + " ");
        }
        this.executeUpdate(sql.toString(), parameters, ctx);
    }

    private void getStockSQL(Context ctx, String tempTable, RptParams params) throws EASBizException, BOSException {
        boolean ckShowNoCalculate;
        int i;
        int length;
        String fiOrgUnitID = null;
        fiOrgUnitID = ((CompanyOrgUnitInfo)params.getObject("company")).getId().toString();
        String SumTypeFieldName = null;
        SumTypeFieldName = ((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().toString();
        String MaterialFrom = null;
        String MaterialIn = null;
        if (params.getObject("materialFrom") != null) {
            if (params.getObject("materialFrom") instanceof Object[]) {
                Object[] materials = (Object[])params.getObject("materialFrom");
                if (materials.length == 1) {
                    MaterialFrom = ((MaterialInfo)materials[0]).getNumber();
                } else {
                    MaterialIn = CalculateUtil.getObjArrayNumber(materials);
                }
            } else {
                MaterialFrom = params.getObject("materialFrom") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialFrom")).getNumber() : params.getObject("materialFrom").toString();
            }
        }
        String MaterialTo = null;
        if (params.getObject("materialTo") != null) {
            MaterialTo = params.getObject("materialTo") instanceof MaterialInfo ? ((MaterialInfo)params.getObject("materialTo")).getNumber() : params.getObject("materialTo").toString();
        }
        String warehouse = null;
        if (params.getString("warehouse") != null) {
            warehouse = params.getString("warehouse");
        }
        String storeType = null;
        if (params.getString("storeType") != null) {
            storeType = params.getString("storeType");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,FMATERIALNAME,").append(newline);
        sql.append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID,FSUMTYPENAME,FBEGINQTY,FBEGINAMOUNT,FINQTY,").append(newline);
        sql.append("FINAMOUNT,FOUTQTY,FOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT)").append(newline);
        sql.append("SELECT 0 as FIndex, ");
        sql.append("d.FCompanyOrgUnitID as FCompanyOrgUnitID, ");
        sql.append("fi.FName_" + this.getLoc(ctx) + " as FCompanyName, ");
        sql.append("d.FYear as FYear, ");
        sql.append("d.FPeriod as FPeriod, ");
        sql.append("d.FMaterialID as FMaterialID, ");
        sql.append("m.FName_" + this.getLoc(ctx) + " as FMaterialName, ");
        sql.append("m.FNumber as FMaterialNumber, ");
        sql.append("m.FSHORTNAME as FSHORTNAME, ");
        sql.append("m.FModel as FMaterialModel, ");
        sql.append("mu.FName_" + this.getLoc(ctx) + " as FBaseUnitName, ");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append("case mcom.FCalculateType when 0 then null else mcom.FCalculateType end as FSumTypeID,");
            sql.append("(case when mcom.FCalculateType=0 then '" + SCMUtils.getResource((String)this.res, (String)"PURCHASE", (Context)ctx) + "' else (case when mcom.FCalculateType=1 then '" + SCMUtils.getResource((String)this.res, (String)"CONSIGN", (Context)ctx) + "' else (case when mcom.FCalculateType=2 then '" + SCMUtils.getResource((String)this.res, (String)"MAKE", (Context)ctx) + "' else ' ' end) end) end) as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append("d.FStorageOrgUnitID as FSumTypeID, ");
            sql.append("so.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append("d.FWarehouseID as FSumTypeID, ");
            sql.append("wh.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append("mcom.FKAClassID as FSumTypeID, ");
            sql.append("ka.FName_" + this.getLoc(ctx) + " as FSumTypeName, ");
        } else if (SumTypeFieldName.equals("FMaterialGroupLevel")) {
            sql.append("'1' as FSumTypeID,");
            sql.append("'2' as FSumTypeName, ");
        }
        sql.append("sum(d.FPeriodBeginQty) as FBeginQty, ");
        sql.append("sum(d.FPERIODBEGINBALANCE) as FBeginAmount, ");
        int status = ((BillBaseStatusEnum)params.getObject("status")).getValue();
        if (status == 2) {
            sql.append("0 as FInQty,0 as FInAmount,");
            sql.append("0 as FOutQty,0 as FOutAmount,");
            sql.append("sum(d.FPeriodBeginQty) as FRemainQty,");
            sql.append("sum(d.FPERIODBEGINBALANCE) as FRemainAmount \r\n");
        } else {
            sql.append("sum(d.FPeriodReceiptQty) as FInQty,sum(d.FPeriodReceiptAmount) as FInAmount,");
            sql.append("sum(d.FPeriodIssueQty) as FOutQty,sum(d.FPeriodIssueAmount) as FOutAmount,");
            sql.append("sum(d.FPeriodEndQty) as FRemainQty,");
            sql.append("sum(d.FPeriodEndBalance) as FRemainAmount \r\n");
        }
        sql.append("From T_IM_InventoryBalance d \r\n");
        sql.append("Inner Join T_BD_Material m On d.FMaterialID=m.FID \r\n");
        sql.append("INNER JOIN t_org_company fi ON d.FCompanyOrgUnitID = fi.FID \r\n");
        sql.append("INNER JOIN T_BD_MeasureUnit mu ON m.FBaseUnit = mu.FID \r\n");
        sql.append("INNER JOIN T_BD_MaterialCompanyInfo mcom On d.FMaterialID = mcom.FMaterialID  AND mcom.FCompanyID = d.FCompanyOrgUnitID \r\n");
        sql.append("INNER JOIN T_IM_StoreType storetype ON d.FStoreTypeID = storetype.FID \r\n");
        sql.append("Inner Join T_DB_WAREHOUSE wh on d.FWarehouseID = wh.FID \r\n");
        sql.append("Inner Join T_ORG_Storage so on d.FStorageOrgUnitID = so.FID \r\n");
        sql.append("Inner Join T_BD_PERIOD p On d.FPERIOD = p.FPERIODNUMBER and d.FYEAR = p.FPERIODYEAR \r\n");
        sql.append("LEFT JOIN T_BD_KAClassfication ka ON mcom.FKAClassID = ka.FID \r\n");
        SqlParams parameters = new SqlParams();
        sql.append("Where d.FCompanyOrgUnitID = ? ");
        parameters.addString(fiOrgUnitID);
        String psql = params.getString("wherePeriod4Balance");
        sql.append(" AND (").append(psql).append(") ");
        parameters.addInt(params.getInt("fromPeriod")).addInt(params.getInt("toPeriod"));
        if (MaterialFrom != null) {
            sql.append(" AND m.FNumber >= ? ");
            parameters.addString(MaterialFrom);
        }
        if (MaterialTo != null) {
            sql.append(" AND m.FNumber <= ? ");
            parameters.addString(MaterialTo);
        }
        if (MaterialIn != null) {
            String[] materials = MaterialIn.split(",");
            sql.append(" AND m.FNumber in(");
            length = materials.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                parameters.addString(materials[i]);
            }
            sql.append(")");
        }
        if (warehouse != null) {
            String[] warehouses = warehouse.split(",");
            sql.append(" AND wh.FNumber in(");
            length = warehouses.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                parameters.addString(warehouses[i]);
            }
            sql.append(")");
        }
        if (storeType != null) {
            String[] storeTypes = storeType.split(",");
            sql.append(" AND storetype.FNumber in(");
            length = storeTypes.length;
            for (i = 0; i < length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                parameters.addString(storeTypes[i]);
            }
            sql.append(")");
        }
        String txtMShortNameFrom = params.getString("txtMShortNameFrom");
        String txtMShortNameTo = params.getString("txtMShortNameTo");
        if (params.getObject("ckBxMShortName") != null && params.getBoolean("ckBxMShortName")) {
            if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName >= ? AND M.FShortName <= ? ");
                parameters.addString(txtMShortNameFrom).addString(txtMShortNameTo);
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() > 0 && txtMShortNameTo.trim().length() <= 0) {
                sql.append(" AND M.FShortName >= ? ");
                parameters.addString(txtMShortNameFrom);
            } else if (params.getBoolean("ckBxMShortName") && txtMShortNameFrom.trim().length() <= 0 && txtMShortNameTo.trim().length() > 0) {
                sql.append(" AND M.FShortName <= ? ");
                parameters.addString(txtMShortNameTo);
            }
        }
        Object prmtKAClassObj = params.getObject("prmtKAClass");
        Object[] prmtKAClass = null;
        if (prmtKAClassObj != null) {
            Object[] objectArray;
            if (prmtKAClassObj instanceof Object[]) {
                objectArray = (Object[])prmtKAClassObj;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = prmtKAClassObj;
            }
            prmtKAClass = objectArray;
            if (prmtKAClass != null && prmtKAClass.length > 0) {
                sql.append(" AND mcom.FKAClassID in ( ");
                for (int i2 = 0; i2 < prmtKAClass.length; ++i2) {
                    if (i2 > 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                    parameters.addString(((KAClassficationInfo)prmtKAClass[i2]).getId().toString());
                }
                sql.append(")");
            }
        }
        if (!(ckShowNoCalculate = params.getBoolean("ckShowNoCalculate"))) {
            sql.append(" AND d.FIsCalculate = ? ");
            parameters.addInt(1);
        }
        boolean noSelectStorageMoveBill = params.getBoolean("noSelectStorageMoveBill");
        boolean noSelectWarehouseMoveBill = params.getBoolean("noSelectWarehouseMoveBill");
        if (noSelectStorageMoveBill) {
            sql.append(" AND d.FMoveType <> ? ");
            parameters.addInt(1);
        }
        if (noSelectWarehouseMoveBill) {
            sql.append(" AND d.FMoveType <> ? ");
            parameters.addInt(2);
        }
        sql.append(" AND storetype.FIsForwardAmt = 1").append(newline);
        sql.append("Group by d.FCompanyOrgUnitID,fi.FName_" + this.getLoc(ctx) + ",");
        sql.append("d.FYear,d.FPeriod,");
        sql.append("d.FMaterialID,m.FName_" + this.getLoc(ctx) + ",");
        sql.append("m.FNumber,m.FSHORTNAME,m.FModel,");
        sql.append("mu.FName_" + this.getLoc(ctx) + "");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append(",mcom.FCalculateType ");
        } else if (SumTypeFieldName.equals("FStorageOrgUnit")) {
            sql.append(",d.FStorageOrgUnitID,");
            sql.append("so.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FWarehouse")) {
            sql.append(",d.FWarehouseID,");
            sql.append("wh.FName_" + this.getLoc(ctx));
        } else if (SumTypeFieldName.equals("FKAClassfication")) {
            sql.append(",mcom.FKAClassID,");
            sql.append("ka.FName_" + this.getLoc(ctx));
        }
        this.executeUpdate(sql.toString(), parameters, ctx);
    }

    private String sqlFrom(Context ctx, String headTbale, String entryTable, String SumTypeFieldName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" From " + headTbale + " h \r\n");
        sql.append("INNER JOIN " + entryTable + " d ON h.FID = d.FParentID \r\n");
        sql.append("Inner Join T_BD_PERIOD p On h.FPERIOD = p.FPERIODNUMBER and h.FYEAR = p.FPERIODYEAR\r\n");
        if (!"T_CL_CostAdjustBill".equalsIgnoreCase(headTbale)) {
            sql.append("INNER JOIN T_IM_InvUpdateType invupdatetype ON d.FInvUpdateTypeID = invupdatetype.FID \r\n");
            sql.append("LEFT JOIN T_IM_StoreType storetypeIn ON invupdatetype.FStoreTypeID = storetypeIn.FID \r\n");
            sql.append("LEFT JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypePreID = storetype.FID \r\n");
        } else {
            sql.append("LEFT JOIN T_IM_StoreType storetype ON d.FSTORETYPEID = storetype.FID \r\n");
        }
        if ("T_IM_PurInWarehsBill".equalsIgnoreCase(headTbale)) {
            sql.append(" inner join T_ORG_UNITRELATION relation on h.FStorageOrgUnitID = Relation.FFROMUNITID ");
        }
        return sql.toString();
    }

    private String sqlForSaleissue(Context ctx, String headTbale, String entryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" From " + headTbale + " h \r\n");
        sql.append(" Inner Join T_BD_PERIOD p On h.FPERIOD = p.FPERIODNUMBER and h.FYEAR = p.FPERIODYEAR\r\n");
        sql.append(" inner join T_ORG_UNITRELATION relation on h.FStorageOrgUnitID = Relation.FFROMUNITID ");
        sql.append(" inner join " + entryTable + " d ON h.FID = d.FParentID \r\n");
        sql.append(" inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid ");
        sql.append(" INNER JOIN T_IM_InvUpdateType invupdatetype ON d.FInvUpdateTypeID = invupdatetype.FID \r\n");
        sql.append(" LEFT JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypePreID = storetype.FID \r\n");
        sql.append(" LEFT JOIN T_IM_StoreType storetypeIn ON invupdatetype.FStoreTypeID = storetypeIn.FID \r\n");
        return sql.toString();
    }

    private String sqlForSaleissueIsArUpdateI(Context ctx, String headTbale, String entryTable) {
        StringBuffer sql = new StringBuffer();
        sql.append(" From " + headTbale + " h \r\n");
        sql.append(" inner join T_ORG_UNITRELATION relation on h.FStorageOrgUnitID = Relation.FFROMUNITID ");
        sql.append(" inner join " + entryTable + " d ON h.FID = d.FParentID \r\n");
        sql.append(" inner join t_scm_transactiontype tr on tr.fid = h.ftransactiontypeid ");
        sql.append(" INNER JOIN T_IM_InvUpdateType invupdatetype ON d.FInvUpdateTypeID = invupdatetype.FID \r\n");
        sql.append(" INNER JOIN T_IM_StoreType storetype ON invupdatetype.FStoreTypePreID = storetype.FID \r\n");
        sql.append(" INNER JOIN T_ar_otherbillentry otherBillEntry ON d.FID = otherBillEntry.FSOURCEBILLENTRYID  \r\n");
        sql.append(" INNER JOIN T_AR_OtherBill otherBill ON otherBill.Fid = otherBillEntry.FparentID  \r\n");
        sql.append(" INNER JOIN T_SCM_BizType bizType on h.fbiztypeid = bizType.fid \r\n");
        sql.append(" Inner Join T_BD_PERIOD p On h.FPERIOD = p.FPERIODNUMBER and h.FYEAR = p.FPERIODYEAR \r\n");
        return sql.toString();
    }

    private String getInsertNextPeriod(Context ctx, String tempTable, PeriodInfo currentPeriodInfo, PeriodInfo nextPeriodInfo, String SumTypeFieldName) throws BOSException {
        if (nextPeriodInfo.isIsAdjustPeriod() || currentPeriodInfo.isIsAdjustPeriod()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable).append(" ").append("(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID,FMATERIALNAME,").append("FMaterialNumber,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID,FSUMTYPENAME,FBEGINQTY,").append("FBEGINAMOUNT,FINQTY,FINAMOUNT,FOUTQTY,FOUTAMOUNT,FREMAINQTY,FREMAINAMOUNT) ").append("select a.FINDEX,a.FCompanyOrgUnitID,a.FCOMPANYNAME,").append(nextPeriodInfo.getPeriodYear()).append(" as FYear,").append(nextPeriodInfo.getPeriodNumber()).append(" as FPeriod,a.FMaterialID,a.FMATERIALNAME,").append("a.FMaterialNumber,a.FSHORTNAME,a.FMaterialModel,a.FBASEUNITNAME,a.FSUMTYPEID,a.FSUMTYPENAME,").append("0,0,0,0,0,0,0,0 ").append(" from ").append(tempTable).append(" a ").append(" left join ").append("(select fIndex,fmaterialid ");
        if ("FWarehouse".equals(SumTypeFieldName)) {
            sql.append(",FSUMTYPEID ");
        }
        sql.append(" from ").append(tempTable).append(" where ").append(" fyear = ").append(nextPeriodInfo.getPeriodYear()).append(" ").append(" and fperiod = ").append(nextPeriodInfo.getPeriodNumber()).append(" ").append(") b ").append("on a.fmaterialid = b.fmaterialid ");
        if ("FWarehouse".equals(SumTypeFieldName)) {
            sql.append(" and a.FSUMTYPEID = b.FSUMTYPEID ");
        }
        sql.append(" where ").append(" a.fyear = ").append(currentPeriodInfo.getPeriodYear()).append(" ").append(" and a.fperiod = ").append(currentPeriodInfo.getPeriodNumber()).append(" ").append(" and b.fIndex is null");
        return sql.toString();
    }

    private String getPeriodHappenTotal(Context ctx, String tempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT) \r\n");
        sql.append("Select 1,null,FCompanyName,FYear,FPeriod,null,null,null,null,null,null,FSUMTYPEID,FSumTypeName || '" + SCMUtils.getResource((String)this.res, (String)"TOTAL", (Context)ctx) + "',");
        sql.append("sum(FBeginQty),sum(FBeginAmount),sum(FInQty),sum(FInAmount),sum(FOutQty),sum(FOutAmount),sum(FRemainQty),Sum(FRemainAmount) ");
        sql.append("From " + tempTable + " \r\n");
        sql.append("Group By FCompanyName,FYear,FPeriod,FSUMTYPEID,FSumTypeName");
        return sql.toString();
    }

    private String updatePeriodLast(Context ctx, String tempTable, int pYear, int pMonth) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set FRemainQty=Isnull(FBeginQty,0)+Isnull(FInQty,0)-Isnull(FOutQty,0),");
        sql.append("FRemainAmount=Isnull(FBeginAmount,0)+Isnull(FInAmount,0)-Isnull(FOutAmount,0) \r\n");
        sql.append(" Where FYear=" + String.valueOf(pYear) + " And FPeriod=" + String.valueOf(pMonth) + newline);
        return sql.toString();
    }

    private String updatePeriodFirst(Context ctx, String tempTable, int prePeriodY, int prePeriodM, int nextPeriodY, int nextPeriodM) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("Update " + tempTable + " as t1 ");
        sql.append("Set(FBeginQty,FBeginAmount)=(");
        sql.append("\tselect t2.FRemainQty,t2.FRemainAmount ");
        sql.append("\tFrom " + tempTable + " t2 ");
        sql.append("\tWhere t2.FYear=" + prePeriodY);
        sql.append(" \tAnd t2.FPeriod=" + prePeriodM);
        sql.append(" \tAND T1.FINDEX = T2.FINDEX  ");
        sql.append("\tAND T1.FMATERIALID = T2.FMATERIALID ");
        sql.append("\tAND T1.FSUMTYPENAME = T2.FSUMTYPENAME)");
        sql.append(" Where t1.FYear=" + nextPeriodY);
        sql.append("   And t1.Fperiod=" + nextPeriodM);
        return sql.toString();
    }

    private String getPeriodTotal(Context ctx, String tempTable, String SumTypeFieldName) {
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into " + tempTable + "(FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
        sql.append(" Select 2 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
        sql.append("FYear,FPeriod,\r\n");
        sql.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
        sql.append("' ' as FMaterialNumber,' 'AS FSHORTNAME,' ' as FMaterialModel,");
        sql.append("' ' as FBaseUnitName,\r\n");
        if (SumTypeFieldName.equals("FCalculateType")) {
            sql.append("0 as FSumTypeID, ");
        } else {
            sql.append("' ' as FSumTypeID, ");
        }
        sql.append("'" + SCMUtils.getResource((String)this.res, (String)"PERIODTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
        sql.append("sum(FBeginQty) as FBeginQty,sum(FBeginAmount) as FBeginAmount,\r\n");
        sql.append("sum(FInQty) as FInQty,Sum(FInAmount)as FInAmount,\r\n");
        sql.append("Sum(FOutQty) as FOutQty,Sum(FOutAmount) as FOutAmount,\r\n");
        sql.append("sum(FRemainQty) as FRemainQty,sum(FRemainAmount) as FRemainAmount \r\n");
        sql.append("From " + tempTable + newline);
        sql.append("Where FIndex=1 \r\n");
        sql.append("Group By FYear,FPeriod \r\n");
        return sql.toString();
    }

    private void getYearTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, int endYear, int endPeroid, String SumTypeFieldName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FYear,min(FPeriod) FPeriod from ").append(tempTable);
        sql.append(" where FYear =  (select min(FYear) as FYear from ").append(tempTable);
        sql.append(" ) group by FYear");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        while (rs.next()) {
            beginYear = rs.getInt("FYear");
            beginPeriod = rs.getInt("FPeriod");
        }
        sql.setLength(0);
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("Select top 1 * \r\n");
        checkSql.append("From " + tempTable + newline);
        checkSql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + newline);
        RptRowSet rsCount = this.executeQuery(checkSql.toString(), null, ctx);
        if (rsCount.next()) {
            sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME, \r\n");
            sql.append(" FMaterialNumber,FSHORTNAME ,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT, \r\n");
            sql.append(" FINQTY,FINAMOUNT,FOUTQTY ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT ) \r\n");
            sql.append("Select 3 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
            sql.append("FYear, 0 as FPeriod, \r\n");
            sql.append("' ' as FMaterialID,' ' as FMaterialName, \r\n");
            sql.append("' ' as FMaterialNumber,' ' as FSHORTNAME ,' ' as FMaterialModel,");
            sql.append("' ' as FBaseUnitName, \r\n");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("0 as FSumTypeID, ");
            } else {
                sql.append("' ' as FSumTypeID, ");
            }
            sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + newline);
            sql.append("Where FIndex=2 And FYear=" + String.valueOf(beginYear) + " And FPeriod=" + String.valueOf(beginPeriod) + newline);
            this.executeSQL(ctx, sql.toString());
        } else {
            sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME, \r\n");
            sql.append(" FMaterialNumber,FSHORTNAME ,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT, \r\n");
            sql.append(" FINQTY,FINAMOUNT,FOUTQTY ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT ) values ( \r\n");
            sql.append(" 3,' ',' ', " + String.valueOf(beginYear) + ",0,\r\n");
            sql.append("' ',' ',' ',' ',' ',' ', \r\n");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("0, ");
            } else {
                sql.append("' ',");
            }
            sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "',\r\n");
            sql.append("0,0,0,0,0,0,0,0) ");
            this.executeSQL(ctx, sql.toString());
        }
        if (endYear > beginYear) {
            sql = new StringBuffer();
            sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
            sql.append("Select  3 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
            sql.append(" tempTable.FYear as FYear, 0 as FPeriod,\r\n");
            sql.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
            sql.append("' ' as FMaterialNumber,' ' AS FSHORTNAME,' ' as FMaterialModel,");
            sql.append("' ' as FBaseUnitName,\r\n");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("0 as FSumTypeID, ");
            } else {
                sql.append("' ' as FSumTypeID, ");
            }
            sql.append("'" + SCMUtils.getResource((String)this.res, (String)"YEARTOTAL", (Context)ctx) + "' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + " tempTable \r\n");
            sql.append(" inner join ");
            sql.append(" ( select FYear,min(FPeriod) FPeriod from " + tempTable + " where fyear is not null group by FYear ) T ");
            sql.append(" on tempTable.FYear = T.FYear and tempTable.FPeriod = T.FPeriod ");
            sql.append(" Where FIndex=2 And tempTable.FYear>" + String.valueOf(beginYear) + newline);
            this.executeSQL(ctx, sql.toString());
        }
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set(FInQty,FInAmount,FOutQty,FOutAmount)=\r\n");
        sql.append(" (Select FInTotalQty,FInTotalAmount,FOutTotalQty,FOutTotalAmount From \r\n");
        sql.append(" (Select FYear as FYear, \r\n");
        sql.append(" Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInAmount) as FInTotalAmount,\r\n");
        sql.append(" Sum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutAmount) as\t FOutTotalAmount\r\n");
        sql.append(" From " + tempTable + " T1 \r\n");
        sql.append(" Where T1.FIndex=2 \r\n");
        sql.append(" Group By T1.FYear) as i \r\n");
        sql.append(" Where i.FYear = " + tempTable + ".FYear and " + tempTable + ".FIndex=3 )");
        this.executeSQL(ctx, sql.toString());
        sql = new StringBuffer();
        sql.append("Update " + tempTable + " Set ");
        sql.append("FRemainQty = isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FRemainAmount=isnull(FBeginAmount,0)+isnull(FInAmount,0)-isnull(FOutAmount,0) ");
        sql.append("Where FIndex=3  \r\n");
        this.executeSQL(ctx, sql.toString());
    }

    private void getAllTotal(Context ctx, String tempTable, int beginYear, int beginPeriod, int endYear, int endPeriod, String SumTypeFieldName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        StringBuffer checkSql = new StringBuffer();
        checkSql.append("Select top 1 * \r\n");
        checkSql.append("From " + tempTable + newline);
        checkSql.append("Where FIndex=2 And FYear*100+FPeriod>=" + String.valueOf(beginYear * 100 + beginPeriod) + " And FYear*100+FPeriod <=" + String.valueOf(endYear * 100 + endPeriod) + newline);
        checkSql.append(" Order by FYear*100+FPeriod \r\n");
        RptRowSet rsCount = this.executeQuery(checkSql.toString(), null, ctx);
        if (rsCount.next()) {
            sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT   ,FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT)\r\n");
            sql.append("Select 4 as FIndex,' ' as FCompanyOrgUnitID,' ' as FCompanyName,\r\n");
            sql.append("0 as FYear, 0 FPeriod,\r\n");
            sql.append("' ' as FMaterialID,' ' as FMaterialName,\r\n");
            sql.append("' ' as FMaterialNumber,' ' AS FSHORTNAME,' ' as FMaterialModel,");
            sql.append("' ' as FBaseUnitName,\r\n");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("0 as FSumTypeID, ");
            } else {
                sql.append("' ' as FSumTypeID, ");
            }
            sql.append("'" + SCMUtils.getResource((String)this.res, (String)"SUMALL", (Context)ctx) + "' FSumTypeName,\r\n");
            sql.append("FBeginQty,FBeginAmount,\r\n");
            sql.append("0 as FInQty,0 as FInAmount,\r\n");
            sql.append("0 as FOutQty,0 as FOutAmount,\r\n");
            sql.append("0 as FRemainQty,0 as FRemainAmount \r\n");
            sql.append("From " + tempTable + newline);
            sql.append("Where FIndex=2 And FYear=" + rsCount.getInt("FYear") + " And FPeriod=" + rsCount.getInt("FPeriod") + newline);
            this.executeSQL(ctx, sql.toString());
        } else {
            sql.setLength(0);
            sql.append("Insert Into " + tempTable + " (FINDEX,FCompanyOrgUnitID,FCOMPANYNAME,FYear,FPeriod,FMaterialID ,FMATERIALNAME ,FMaterialNumber ,");
            sql.append(" FSHORTNAME,FMaterialModel,FBASEUNITNAME,FSUMTYPEID ,FSUMTYPENAME ,FBEGINQTY ,FBEGINAMOUNT ,");
            sql.append(" FINQTY  ,FINAMOUNT ,FOUTQTY  ,FOUTAMOUNT ,FREMAINQTY ,FREMAINAMOUNT) values \r\n");
            sql.append(" ( 4,' ',' ',0,0,' ',' ',' ',' ',' ',' ', ");
            if (SumTypeFieldName.equals("FCalculateType")) {
                sql.append("0, ");
            } else {
                sql.append("' ', ");
            }
            sql.append("'" + SCMUtils.getResource((String)this.res, (String)"SUMALL", (Context)ctx) + "',\r\n");
            sql.append(" 0,0,0,0,0,0,0,0 ) ");
            this.executeSQL(ctx, sql.toString());
        }
        sql.setLength(0);
        sql.append("Update " + tempTable + " AS T3 Set(FInQty,FInAmount,FOutQty,FOutAmount)=\r\n");
        sql.append("    (Select FInTotalQty,FInTotalAmount,FOutTotalQty,FOutTotalAmount From \r\n");
        sql.append("       (Select Sum(T1.FInQty) as FInTotalQty ,Sum(T1.FInAmount) as FInTotalAmount, \r\n");
        sql.append("       Sum(T1.FOutQty) as FOutTotalQty,Sum(T1.FOutAmount) as FOutTotalAmount \r\n");
        sql.append("        From " + tempTable + " T1 \r\n");
        sql.append("        Where T1.FIndex=3 )\r\n");
        sql.append("    i," + tempTable + " T2 \r\n");
        sql.append("    Where T2.FIndex=4) Where T3.FIndex=4\r\n");
        this.executeSQL(ctx, sql.toString());
        sql.setLength(0);
        sql.append("Update " + tempTable + " Set ");
        sql.append("FRemainQty=isnull(FBeginQty,0)+isnull(FInQty,0)-isnull(FOutQty,0),");
        sql.append("FRemainAmount=isnull(FBeginAmount,0)+isnull(FInAmount,0)-isnull(FOutAmount,0) ");
        sql.append("Where FIndex=4 ");
        this.executeSQL(ctx, sql.toString());
    }

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        return params;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        int pricePrecision = 8;
        int qtyPrecision = params.getInt("spinQtyPrecission");
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        int amtPrecision = CalculateUtil.getLocalCurrencyPrecision(ctx, aCompanyOrgUnitInfo);
        RptParams pp = new RptParams();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT tmp.FCompanyName,tmp.FYear,tmp.FPeriod,");
        if (((SumTypeEnum)((Object)params.getObject("sumType"))).getValue().equals("FMaterialGroupLevel")) {
            int materialGroupLevel = params.getInt("materialGroupLevel");
            for (int i = 1; i <= materialGroupLevel; ++i) {
                sql.append("tmp.FMATERIALGROUPNAME" + i + " ,");
            }
        } else {
            sql.append("tmp.FSumTypeName,");
        }
        sql.append("tmp.FMaterialNumber,tmp.FMATERIALNAME,tmp.FSHORTNAME,tmp.FMaterialModel,tmp.FBASEUNITNAME,");
        sql.append(" Case when isnull(tmp.FBeginQty,0)=0 then Null else round(tmp.FBeginQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end) end as FBeginQty,");
        sql.append("( Case when isnull(tmp.FBeginQty,0)=0 then Null else round(to_decimal(tmp.FBeginAmount/tmp.FBeginQty, 21, 8), case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FBeginPrice,");
        sql.append("round(tmp.FBeginAmount,").append(amtPrecision).append("),");
        sql.append("Case when isnull(tmp.FInQty,0)=0 then Null else round(tmp.FInQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end) end FInQTY ,(Case when isnull(tmp.FInQty,0)=0 then Null else round(tmp.FInAmount/tmp.FInQty,case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FInPrice,");
        sql.append("round(tmp.FInAmount,").append(amtPrecision).append("),");
        sql.append("Case when isnull(tmp.FOutQty,0)=0 then Null else round(tmp.FOutQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end) end as FOutQty ,(Case when isnull(tmp.FOutQty,0)=0 then Null else round(tmp.FOutAmount/tmp.FOutQty,case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FOutPrice,");
        sql.append("round(tmp.FOutAmount,").append(amtPrecision).append("),");
        sql.append("Case when isnull(tmp.FRemainQty,0)=0 then Null else round(tmp.FRemainQTY,case when unit.fqtyprecision is null then " + qtyPrecision + " else unit.fqtyprecision end) end FRemainQTY,(Case when isnull(tmp.FRemainQty,0)=0 then Null else round(tmp.FRemainAmount/tmp.FRemainQty,case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end) end) as FRemainPrice,");
        sql.append("round(tmp.FRemainAmount,").append(amtPrecision).append("),tmp.FSumTypeID,tmp.FMaterialID,tmp.FIndex,tmp.FCompanyOrgUnitID, " + qtyPrecision + " as fqtyprecision,case when material.fpriceprecision is null then " + pricePrecision + " else material.fpriceprecision end as fpriceprecision FROM " + params.getString("tempTable") + " as tmp ");
        sql.append("left join t_bd_material material on tmp.fmaterialid = material.fid left join T_BD_MultiMeasureUnit unit on material.fid = unit.fmaterialId and material.fbaseUnit=unit.FMeasureUnitID ");
        sql.append("where 1 = 1 ");
        int start = from + 1;
        int end = from + len;
        sql.append(" and KSQL_SEQ >= ").append(start).append(" and KSQL_SEQ <= ").append(end);
        if (from == 0) {
            String countSql = "select count(1) from " + params.getString("tempTable");
            RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
            rsCount.next();
            int count = rsCount.getInt(0);
            pp.setInt("totalCount", count);
        }
        sql.append(" Order by tmp.KSQL_SEQ ASC");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    protected boolean isUseRWSplit() {
        return true;
    }

    class SQLThreadPool {
        private Vector sqls = new Vector();
        private int maxThreadCount = 0;
        private int currentThread = 0;
        private boolean isRunning = false;
        private Context ctx;

        public SQLThreadPool(Context ctx) {
            this.ctx = ctx;
        }

        public synchronized void addSQL(Object sql) {
            if (!this.isRunning) {
                this.sqls.add(sql);
                this.addCurrentThreadCount();
            }
        }

        public synchronized int getMaxThreadCount() {
            return this.maxThreadCount;
        }

        public synchronized int getCurrentThread() {
            return this.currentThread;
        }

        public synchronized void subtract() {
            --this.maxThreadCount;
            --this.currentThread;
        }

        public synchronized void addMaxThreadCount() {
            ++this.maxThreadCount;
        }

        public synchronized void addCurrentThreadCount() {
            ++this.currentThread;
        }

        public void startWorker() throws BOSException {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            for (Object[] obj : this.sqls) {
                String sql = (String)obj[0];
                SqlParams params = (SqlParams)obj[1];
                new ThreadWorker(sql, params, this.ctx).start();
            }
            while (this.getCurrentThread() > 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
        }

        class ThreadWorker
        extends Thread {
            private String sql;
            private SqlParams params;
            private Context ctx;

            public ThreadWorker(String sql, SqlParams params, Context ctx) {
                this.sql = sql;
                this.params = params;
                this.ctx = ctx;
            }

            @Override
            public void run() {
                while (SQLThreadPool.this.getMaxThreadCount() > 2) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)e);
                        SQLThreadPool.this.subtract();
                    }
                }
                SQLThreadPool.this.addMaxThreadCount();
                try {
                    long beforeTime = System.currentTimeMillis();
                    StockGatherReportFacadeControllerBean.this.executeUpdate(this.sql, this.params, this.ctx);
                    logger.info((Object)"-----------------------------------");
                    logger.info((Object)this.sql);
                    logger.info((Object)(" spend time is :" + (System.currentTimeMillis() - beforeTime) + "ms"));
                }
                catch (BOSException e) {
                    StockGatherReportFacadeControllerBean.this.excList.add(e);
                }
                finally {
                    SQLThreadPool.this.subtract();
                }
            }
        }
    }
}

