/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobLog;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgFactory;
import com.kingdee.eas.basedata.common.perf.PerfSepCfgInfo;
import com.kingdee.eas.basedata.common.perf.app.PerfSepServerUtils;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.MoveLocationUpdateFacadeFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.IPUtils;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;

public class UpdateBillHandler
implements IJobHandler {
    private static final String RESOURCE = "com.kingdee.eas.scm.cal.UpdateBillResource";

    public Object execute(Job job) throws Exception {
        CompanyOrgUnitInfo company = null;
        Context ctx = null;
        MessageInfo info = null;
        StringBuffer msg = new StringBuffer();
        try {
            ctx = job.getContext();
            JobParam jobParam = (JobParam)job.getParameters();
            Object bizParam = jobParam.getBizParam();
            HashMap paraMap = null;
            Locale locale = null;
            if (bizParam != null && bizParam instanceof Object[]) {
                Object[] parObjs = (Object[])bizParam;
                company = (CompanyOrgUnitInfo)parObjs[0];
                paraMap = (HashMap)parObjs[1];
                locale = (Locale)parObjs[2];
                ctx.put((Object)"UserInfo", parObjs[3]);
                ctx.put((Object)OrgType.Company, (Object)company);
                ctx.put((Object)"CurOU", (Object)company);
                ctx.put((Object)OrgType.ControlUnit, parObjs[5]);
            }
            if (null == company || company.toString().length() <= 0) {
                throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
            }
            ctx.put((Object)"ClientName", (Object)IPUtils.getLocleAddress().getHostName());
            ctx.put((Object)"UPDATE_JOB_INST_ID", (Object)jobParam.getJobId());
            ctx.setLocale(jobParam.getLocale());
            String userId = ctx.getCaller().toString();
            info = new MessageInfo();
            info.setUserID(userId);
            String title = ResourceBase.getString((String)RESOURCE, (String)"updateTaskTitle", (Locale)locale);
            msg.append(MessageFormat.format(title, company.getNumber(), company.getName(), paraMap.get("yearFrom").toString(), paraMap.get("periodFrom"), paraMap.get("yearTo").toString(), paraMap.get("periodTo"))).append("\n");
            info.setOrgNumber(company.getName(locale) + "(" + company.getNumber() + ")");
            boolean isSendMsg = true;
            String jobNum = jobParam.getJobNumber();
            String oql = " where number = '" + jobNum + "'";
            PerfSepCfgInfo pfInfo = PerfSepCfgFactory.getLocalInstance((Context)ctx).getPerfSepCfgInfo(oql);
            if (pfInfo != null) {
                isSendMsg = pfInfo.isIsSendMsg();
            }
            info.setSendMsg(isSendMsg);
            HashMap resultMap = MoveLocationUpdateFacadeFactory.getLocalInstance(ctx).updateBill(paraMap);
            String[] resultMsg = (String[])resultMap.get("resultMsg");
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"updateResut", (Locale)locale)).append("\n");
            if (resultMsg[0].length() > 0) {
                msg.append(resultMsg[0]);
            } else {
                msg.append(ResourceBase.getString((String)RESOURCE, (String)"Null", (Locale)locale)).append("\n");
            }
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"unUpdateResut", (Locale)locale)).append("\n");
            if (resultMsg[1].length() > 0) {
                msg.append(resultMsg[1]);
            } else {
                msg.append(ResourceBase.getString((String)RESOURCE, (String)"Null", (Locale)locale)).append("\n");
            }
            msg.append(ResourceBase.getString((String)RESOURCE, (String)"unUpdateCalType", (Locale)locale)).append("\n");
            if (resultMsg[2].length() > 0) {
                msg.append(resultMsg[2]);
            } else {
                msg.append(ResourceBase.getString((String)RESOURCE, (String)"Null", (Locale)locale)).append("\n");
            }
            info.setbizAction(msg.toString());
            info.setSuccessed(true);
            MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
        }
        catch (EASBizException e) {
            info.setExecption(e.getMessage(ctx.getLocale()));
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw e;
        }
        catch (BOSException be) {
            info.setExecption(be.getMessage());
            info.setSuccessed(false);
            MessageUtil.sendMsg((Context)ctx, info);
            throw be;
        }
        finally {
            JobLog log = new JobLog(JobLog.Type.Info, msg.toString());
            job.saveMessage(log);
            PerfSepServerUtils.updateTaskState((Job)job);
        }
        return Boolean.TRUE;
    }
}

