/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.dao.ormapping.impl.ImplUtils;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.botp.util.BotRelationUtil;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.IWriteOffGroup;
import com.kingdee.eas.scm.cal.WriteOffGroupCollection;
import com.kingdee.eas.scm.cal.WriteOffGroupFactory;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.WriteOffRecordCollection;
import com.kingdee.eas.scm.cal.WriteOffRecordInfo;
import com.kingdee.eas.scm.cal.app.AbstractWriteOffGroupControllerBean;
import com.kingdee.eas.scm.cal.app.bizimpl.WriteOffFilterHelper;
import com.kingdee.eas.scm.cal.info.WriteOffPeriodInfo;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.writeoff.app.ExtendStoreFieldsHandler;
import com.kingdee.eas.scm.im.inv.IPurInWarehsVoucher;
import com.kingdee.eas.scm.im.inv.PurInWarehsVoucherFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsVoucherInfo;
import com.kingdee.eas.scm.im.inv.PurVoucherTypeEnum;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.app.CheckVoucherUtil;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class WriteOffGroupControllerBean
extends AbstractWriteOffGroupControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.cal.app.WriteOffGroupControllerBean");

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum billOperStateEnum, BOTRelationCollection relationInfos) throws BOSException, EASBizException {
        block56: {
            block57: {
                PreparedStatement deleteVoucherSql;
                Connection conn;
                block52: {
                    block54: {
                        PreparedStatement updateDischgVoucherSql;
                        PreparedStatement updatePurVoucherSql;
                        Connection conn2;
                        IRowSet wfGroupRs;
                        block51: {
                            block55: {
                                if (relationInfos.size() < 1) {
                                    return;
                                }
                                BOTRelationInfo botRelation = relationInfos.get(0);
                                if ("D6952559".equals(botRelation.getDestEntityID())) {
                                    this.savePCVoucher(ctx, srcBillPKs, srcBillVOs, billOperStateEnum, relationInfos);
                                    return;
                                }
                                if (!"2652E01E".equals(botRelation.getDestEntityID())) {
                                    return;
                                }
                                IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)("SELECT 1 FROM T_CL_WriteOffRecord WHERE FParentID = '" + srcBillPKs[0] + "' AND FBillTypeNumber IN ('103', '230')"));
                                boolean isPurWriteOffRecord = false;
                                try {
                                    if (rs.next()) {
                                        isPurWriteOffRecord = true;
                                    }
                                }
                                catch (SQLException e) {
                                    throw new BOSException((Throwable)e);
                                }
                                if (!isPurWriteOffRecord) break block54;
                                if (!BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnum)) break block55;
                                this.checkGLDelVoucher(ctx, srcBillPKs, botRelation);
                                String selectVoucherType = "select FVoucherID, FVoucherType from T_IM_PurInWarehsVoucher where FVoucherId IN (%s)";
                                HashSet<String> voucherIDSet = new HashSet<String>();
                                int size = relationInfos.size();
                                for (int i = 0; i < size; ++i) {
                                    voucherIDSet.add(relationInfos.get(i).getDestObjectID());
                                }
                                StringBuilder sb = new StringBuilder(128);
                                for (String id : voucherIDSet) {
                                    sb.append("'").append(id).append("',");
                                }
                                sb.deleteCharAt(sb.length() - 1);
                                IRowSet voucherTypeRs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)String.format(selectVoucherType, sb.toString()));
                                HashMap<String, String> voucherTypeMap = new HashMap<String, String>(128);
                                Connection conn3 = null;
                                PreparedStatement updateSql = null;
                                PreparedStatement deleteSql = null;
                                PreparedStatement deletePurVoucherSql = null;
                                PreparedStatement deleteBotSQL = null;
                                PreparedStatement deleteBotEntrySQL = null;
                                try {
                                    while (voucherTypeRs.next()) {
                                        voucherTypeMap.put(voucherTypeRs.getString("FVoucherID"), voucherTypeRs.getString("FVoucherType"));
                                    }
                                    conn3 = this.getConnection(ctx);
                                    updateSql = conn3.prepareStatement("update T_CL_WriteOffGroup set FIsDischarged = 0 where FID = ?");
                                    deleteSql = conn3.prepareStatement("update T_CL_WriteOffGroup set FVoucherID = null, FFiVouchered = 0 where FID = ?");
                                    deletePurVoucherSql = conn3.prepareStatement("delete from T_IM_PurInWarehsVoucher where FVoucherId = ? and FWriteOffGroupID = ?");
                                    deleteBotSQL = conn3.prepareStatement("delete from t_bot_relation where FDestObjectId = ? and FDestEntityId = ?");
                                    deleteBotEntrySQL = conn3.prepareStatement("delete from t_ar_araprelationentry where FDestObjectId = ?");
                                    boolean isUpdateBatch = false;
                                    boolean isDeleteBatch = false;
                                    ArrayList<String> sqlList = new ArrayList<String>();
                                    int size2 = relationInfos.size();
                                    for (int i = 0; i < size2; ++i) {
                                        if (voucherTypeMap.get(relationInfos.get(i).getDestObjectID()) != null && 2 == Integer.parseInt((String)voucherTypeMap.get(relationInfos.get(i).getDestObjectID()))) {
                                            updateSql.setString(1, relationInfos.get(i).getSrcObjectID());
                                            updateSql.addBatch();
                                            isUpdateBatch = true;
                                        } else {
                                            deleteSql.setString(1, relationInfos.get(i).getSrcObjectID());
                                            deleteSql.addBatch();
                                            isDeleteBatch = true;
                                            sqlList.add(this.deletePurVoucherInfo(ctx, relationInfos.get(i).getSrcObjectID()));
                                            sqlList.add(this.updateCostAdjustBillSQL(relationInfos.get(i).getSrcObjectID(), true));
                                        }
                                        deletePurVoucherSql.setString(1, relationInfos.get(i).getDestObjectID());
                                        deletePurVoucherSql.setString(2, relationInfos.get(i).getSrcObjectID());
                                        deletePurVoucherSql.addBatch();
                                        deleteBotSQL.setString(1, relationInfos.get(i).getDestObjectID());
                                        deleteBotSQL.setString(2, relationInfos.get(i).getDestEntityID());
                                        deleteBotSQL.addBatch();
                                        deleteBotEntrySQL.setString(1, relationInfos.get(i).getDestObjectID());
                                        deleteBotEntrySQL.addBatch();
                                    }
                                    if (isUpdateBatch) {
                                        updateSql.executeBatch();
                                    }
                                    if (isDeleteBatch) {
                                        deleteSql.executeBatch();
                                    }
                                    if (sqlList.size() > 0) {
                                        com.kingdee.eas.scm.cal.util.DBUtil.execBatchSql(ctx, sqlList, true);
                                    }
                                    deletePurVoucherSql.executeBatch();
                                    deleteBotSQL.executeBatch();
                                    deleteBotEntrySQL.executeBatch();
                                }
                                catch (SQLException e) {
                                    try {
                                        throw new BOSException((Throwable)e);
                                    }
                                    catch (Throwable throwable) {
                                        SQLUtils.cleanup(updateSql);
                                        SQLUtils.cleanup(deleteSql);
                                        SQLUtils.cleanup(deletePurVoucherSql);
                                        SQLUtils.cleanup(deleteBotSQL);
                                        SQLUtils.cleanup(deleteBotEntrySQL, (Connection)conn3);
                                        throw throwable;
                                    }
                                }
                                SQLUtils.cleanup((Statement)updateSql);
                                SQLUtils.cleanup((Statement)deleteSql);
                                SQLUtils.cleanup((Statement)deletePurVoucherSql);
                                SQLUtils.cleanup((Statement)deleteBotSQL);
                                SQLUtils.cleanup((Statement)deleteBotEntrySQL, (Connection)conn3);
                                break block56;
                            }
                            if (!BOTBillOperStateEnum.ADDNEW.equals((Object)billOperStateEnum)) break block56;
                            StringBuilder sb = new StringBuilder(128);
                            for (IObjectPK pk : srcBillPKs) {
                                sb.append("'").append(pk.toString()).append("',");
                            }
                            sb.deleteCharAt(sb.length() - 1);
                            wfGroupRs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)String.format("SELECT bill.FID, bill.FDAPType, bill.FCompanyOrgUnitID, bill.FWriteOffYear, bill.FWriteOffPeriod, entry.FBillTypeNumber, entry.FBillID FROM T_CL_WriteOffGroup bill INNER JOIN T_CL_WriteOffRecord entry ON bill.FID = entry.FParentID WHERE bill.FID IN (%s)", sb.toString()));
                            conn2 = null;
                            updatePurVoucherSql = null;
                            updateDischgVoucherSql = null;
                            try {
                                IRowSet checkResult;
                                HashMap<String, Integer> wfGroupMap = new HashMap<String, Integer>(128);
                                while (wfGroupRs.next()) {
                                    if (wfGroupMap.containsKey(wfGroupRs.getString("FID"))) continue;
                                    wfGroupMap.put(wfGroupRs.getString("FID"), wfGroupRs.getInt("FDAPType"));
                                }
                                conn2 = this.getConnection(ctx);
                                updatePurVoucherSql = conn2.prepareStatement("update T_CL_WriteOffGroup set FVoucherID = ?, FFiVouchered = 1 where FID = ?");
                                updateDischgVoucherSql = conn2.prepareStatement("update T_CL_WriteOffGroup set FIsDischarged = 1 where FID = ?");
                                boolean isUpdatePurVoucher = false;
                                boolean isUpdateDischgVoucher = false;
                                HashMap<String, String> grpVouMap = new HashMap<String, String>();
                                ArrayList<String> sqlList = new ArrayList<String>();
                                StringBuffer lockPks = new StringBuffer("");
                                int size = relationInfos.size();
                                for (int i = 0; i < size; ++i) {
                                    if (wfGroupMap.get(relationInfos.get(i).getSrcObjectID()) != null && 2 == (Integer)wfGroupMap.get(relationInfos.get(i).getSrcObjectID())) {
                                        lockPks.append("'").append(relationInfos.get(i).getSrcObjectID()).append("'");
                                        lockPks.append(",");
                                        updateDischgVoucherSql.setString(1, relationInfos.get(i).getSrcObjectID());
                                        updateDischgVoucherSql.addBatch();
                                        isUpdateDischgVoucher = true;
                                        continue;
                                    }
                                    if (wfGroupMap.get(relationInfos.get(i).getSrcObjectID()) == null || 0 != (Integer)wfGroupMap.get(relationInfos.get(i).getSrcObjectID())) continue;
                                    lockPks.append("'").append(relationInfos.get(i).getSrcObjectID()).append("'");
                                    lockPks.append(",");
                                    updatePurVoucherSql.setString(1, relationInfos.get(i).getDestObjectID());
                                    updatePurVoucherSql.setString(2, relationInfos.get(i).getSrcObjectID());
                                    updatePurVoucherSql.addBatch();
                                    isUpdatePurVoucher = true;
                                    grpVouMap.put(relationInfos.get(i).getSrcObjectID(), relationInfos.get(i).getDestObjectID());
                                    sqlList.add(this.updateOtherApBillSQL(relationInfos.get(i).getSrcObjectID(), false));
                                    sqlList.add(this.updateIncomeInvoiceSQL(relationInfos.get(i).getSrcObjectID(), false));
                                    sqlList.add(this.updateCostAdjustBillSQL(relationInfos.get(i).getSrcObjectID(), false));
                                }
                                if (lockPks.length() > 0) {
                                    lockPks.deleteCharAt(lockPks.length() - 1);
                                }
                                if (isUpdateDischgVoucher) {
                                    String lockSql = "UPDATE T_CL_WriteOffGroup SET FID = FID WHERE FID IN (" + lockPks.toString() + ")";
                                    DbUtil.execute((Context)ctx, (String)lockSql);
                                    StringBuffer checkSql = new StringBuffer("");
                                    checkSql.append("SELECT fid  FROM T_CL_WriteOffGroup");
                                    checkSql.append(" WHERE FID IN (").append(lockPks.toString()).append(") and FIsDischarged = 1");
                                    checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                                    if (checkResult.next()) {
                                        throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK);
                                    }
                                    updateDischgVoucherSql.executeBatch();
                                }
                                if (isUpdatePurVoucher) {
                                    String lockSql = "UPDATE T_CL_WriteOffGroup SET FID = FID WHERE FID IN (" + lockPks.toString() + ")";
                                    DbUtil.execute((Context)ctx, (String)lockSql);
                                    StringBuffer checkSql = new StringBuffer("");
                                    checkSql.append("SELECT fid  FROM T_CL_WriteOffGroup");
                                    checkSql.append(" WHERE FID IN (").append(lockPks.toString()).append(") and FFiVouchered = 1");
                                    checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                                    if (checkResult.next()) {
                                        throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK);
                                    }
                                    updatePurVoucherSql.executeBatch();
                                }
                                if (grpVouMap.size() > 0) {
                                    this.addPurVoucherInfo(ctx, grpVouMap);
                                    this.writeBotRelation(ctx, grpVouMap, relationInfos);
                                }
                                if (sqlList.size() > 0) {
                                    com.kingdee.eas.scm.cal.util.DBUtil.execBatchSql(ctx, sqlList, true);
                                }
                                HashSet<String> purBillIdSet = new HashSet<String>();
                                IPurInWarehsVoucher iPurVoucher = PurInWarehsVoucherFactory.getLocalInstance((Context)ctx);
                                wfGroupRs.beforeFirst();
                                Timestamp now = new Timestamp(System.currentTimeMillis());
                                CoreBaseCollection coll = new CoreBaseCollection();
                                HashMap<String, String> botpMap = new HashMap<String, String>();
                                for (int i = 0; i < relationInfos.size(); ++i) {
                                    botpMap.put(relationInfos.get(i).getSrcObjectID(), relationInfos.get(i).getDestObjectID());
                                }
                                while (wfGroupRs.next()) {
                                    if (!wfGroupRs.getString("FBillTypeNumber").equals("103") || purBillIdSet.contains(wfGroupRs.getString("FBillID"))) continue;
                                    purBillIdSet.add(wfGroupRs.getString("FBillID"));
                                    PurInWarehsVoucherInfo voucherInfo = new PurInWarehsVoucherInfo();
                                    voucherInfo.setId(BOSUuid.create((BOSObjectType)voucherInfo.getBOSType()));
                                    voucherInfo.setYear(wfGroupRs.getInt("FWriteOffYear"));
                                    voucherInfo.setPeriod(wfGroupRs.getInt("FWriteOffPeriod"));
                                    voucherInfo.setCompanyOrgUnitId(BOSUuid.read((String)wfGroupRs.getString("FCompanyOrgUnitID")));
                                    voucherInfo.setBillID(BOSUuid.read((String)wfGroupRs.getString("FBillID")));
                                    voucherInfo.setVoucherID(BOSUuid.read((String)((String)botpMap.get(wfGroupRs.getString("FID")))));
                                    voucherInfo.setVoucherType(PurVoucherTypeEnum.getEnum((int)wfGroupRs.getInt("FDAPType")));
                                    voucherInfo.setWriteOffGroupId(BOSUuid.read((String)wfGroupRs.getString("FID")));
                                    voucherInfo.setCreateTime(now);
                                    coll.add((CoreBaseInfo)voucherInfo);
                                }
                                if (coll.size() <= 0) break block51;
                                iPurVoucher.addnewBatchData(coll);
                            }
                            catch (SQLException e) {
                                try {
                                    throw new BOSException((Throwable)e);
                                }
                                catch (Throwable throwable) {
                                    SQLUtils.cleanup((ResultSet)wfGroupRs, updateDischgVoucherSql);
                                    SQLUtils.cleanup(updatePurVoucherSql, conn2);
                                    throw throwable;
                                }
                            }
                        }
                        SQLUtils.cleanup((ResultSet)wfGroupRs, (Statement)updateDischgVoucherSql);
                        SQLUtils.cleanup((Statement)updatePurVoucherSql, (Connection)conn2);
                        break block56;
                    }
                    if (!BOTBillOperStateEnum.DELETE.equals((Object)billOperStateEnum)) break block57;
                    conn = null;
                    deleteVoucherSql = null;
                    try {
                        conn = this.getConnection(ctx);
                        deleteVoucherSql = conn.prepareStatement("update T_CL_WriteOffGroup set FVoucherID = null, FFiVouchered = 0 where FID = ?");
                        boolean isBatch = false;
                        HashSet<String> groupIdSet = new HashSet<String>();
                        int size = relationInfos.size();
                        for (int i = 0; i < size; ++i) {
                            deleteVoucherSql.setString(1, relationInfos.get(i).getSrcObjectID());
                            deleteVoucherSql.addBatch();
                            isBatch = true;
                            groupIdSet.add(relationInfos.get(i).getSrcObjectID());
                        }
                        if (isBatch) {
                            deleteVoucherSql.executeBatch();
                        }
                        if (groupIdSet.size() <= 0) break block52;
                        this.deleteSaleWriteOffVouchered(ctx, groupIdSet);
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(deleteVoucherSql, (Connection)conn);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((Statement)deleteVoucherSql, (Connection)conn);
                break block56;
            }
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)billOperStateEnum)) {
                PreparedStatement updatePurVoucherSql;
                Connection conn;
                block53: {
                    conn = null;
                    updatePurVoucherSql = null;
                    try {
                        conn = this.getConnection(ctx);
                        updatePurVoucherSql = conn.prepareStatement("update T_CL_WriteOffGroup set FVoucherID = ?, FFiVouchered = 1 where FID = ?");
                        boolean isBatch = false;
                        HashSet<String> groupIdSet = new HashSet<String>();
                        StringBuffer lockPks = new StringBuffer("");
                        int size = relationInfos.size();
                        for (int i = 0; i < size; ++i) {
                            lockPks.append("'").append(relationInfos.get(i).getSrcObjectID()).append("'");
                            lockPks.append(",");
                            updatePurVoucherSql.setString(1, relationInfos.get(i).getDestObjectID());
                            updatePurVoucherSql.setString(2, relationInfos.get(i).getSrcObjectID());
                            updatePurVoucherSql.addBatch();
                            isBatch = true;
                            groupIdSet.add(relationInfos.get(i).getSrcObjectID());
                        }
                        if (lockPks.length() > 0) {
                            lockPks.deleteCharAt(lockPks.length() - 1);
                        }
                        String lockSql = "UPDATE T_CL_WriteOffGroup SET FID = FID WHERE FID IN (" + lockPks.toString() + ")";
                        DbUtil.execute((Context)ctx, (String)lockSql);
                        StringBuffer checkSql = new StringBuffer("");
                        checkSql.append("SELECT fid  FROM T_CL_WriteOffGroup");
                        checkSql.append(" WHERE FID IN (").append(lockPks.toString()).append(") and FFiVouchered = 1");
                        IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                        if (checkResult.next()) {
                            throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK);
                        }
                        if (isBatch) {
                            updatePurVoucherSql.executeBatch();
                        }
                        if (groupIdSet.size() <= 0) break block53;
                        this.addSaleWriteOffVouchered(ctx, groupIdSet);
                    }
                    catch (SQLException e) {
                        try {
                            throw new BOSException((Throwable)e);
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(updatePurVoucherSql, (Connection)conn);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((Statement)updatePurVoucherSql, (Connection)conn);
            }
        }
    }

    private void checkGLDelVoucher(Context ctx, IObjectPK[] srcBillPKs, BOTRelationInfo botRelation) throws BOSException, CalculateException {
        if (botRelation.getSrcEntityID().equals("B84FB1E2") && botRelation.getDestEntityID().equals("2652E01E") && srcBillPKs.length == 1) {
            try {
                String sql = "SELECT FVoucherType FROM T_IM_PURINWAREHSVOUCHER where FVOUCHERID = '" + botRelation.getDestObjectID() + "'";
                IRowSet rsVoucherType = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sql);
                boolean isDischgVoucher = false;
                while (rsVoucherType.next()) {
                    if (rsVoucherType.getInt("FVoucherType") != 2) continue;
                    isDischgVoucher = true;
                }
                if (!isDischgVoucher) {
                    return;
                }
                sql = "select FDISCHARGETYPE,FFIVOUCHERED from T_CL_WriteOffGroup where fid = '" + srcBillPKs[0] + "'";
                IRowSet rsCheck = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sql);
                int dischargeType = -1;
                boolean isVouchered = false;
                while (rsCheck.next()) {
                    dischargeType = rsCheck.getInt("FDISCHARGETYPE");
                    isVouchered = rsCheck.getBoolean("FFIVOUCHERED");
                }
                if (dischargeType == 2 && isVouchered) {
                    throw new CalculateException(CalculateException.DELETE_VOUCHER_ERROR);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (!"2652E01E".equals(botRelation.getDestEntityID())) {
            return;
        }
        if (!(BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum) || BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum))) {
            return;
        }
        WriteOffGroupInfo billVO = WriteOffGroupFactory.getLocalInstance(ctx).getWriteOffGroupInfo(srcBillPK, SCMSelectorFactory.getWriteOffGroupSelector());
        String sSQL = "";
        if (this.isPurWriteOffRecord(billVO)) {
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                String voucheType = "-1";
                String selectVoucherType = "select FVoucherType from T_IM_PurInWarehsVoucher where FVoucherId =''{0}''";
                String deletePurVoucherSql = "delete from T_IM_PurInWarehsVoucher where FVoucherId = ''{0}'' and FWriteOffGroupID = ''{1}''";
                sSQL = MessageFormat.format(selectVoucherType, botRelation.getDestObjectID(), botRelation.getSrcObjectID());
                IRowSet voucherTypeRs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sSQL);
                try {
                    while (voucherTypeRs.next()) {
                        voucheType = voucherTypeRs.getString("FVoucherType");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (2 == Integer.parseInt(voucheType)) {
                    String updateDischgVoucherSql = "update T_CL_WriteOffGroup set FIsDischarged = 0 where FID = ''{0}''";
                    sSQL = MessageFormat.format(updateDischgVoucherSql, botRelation.getSrcObjectID());
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
                } else {
                    String deleteVoucherSql = "update T_CL_WriteOffGroup set FVoucherID = null, FFiVouchered = 0 where FID = ''{0}''";
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)this.deletePurVoucherInfo(ctx, botRelation.getSrcObjectID()));
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)this.updateCostAdjustBillSQL(botRelation.getSrcObjectID(), true));
                    sSQL = MessageFormat.format(deleteVoucherSql, botRelation.getSrcObjectID());
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
                }
                sSQL = MessageFormat.format(deletePurVoucherSql, botRelation.getDestObjectID(), botRelation.getSrcObjectID());
                com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
                this.deleteBotRelation(ctx, botRelation);
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                String updatePurVoucherSql = "update T_CL_WriteOffGroup set FVoucherID = ''{0}'', FFiVouchered = 1 where FID = ''{1}''";
                String updateDischgVoucherSql = "update T_CL_WriteOffGroup set FIsDischarged = 1 where FID = ''{0}''";
                if (billVO.getDAPType().getValue() == 2) {
                    sSQL = MessageFormat.format(updateDischgVoucherSql, botRelation.getSrcObjectID());
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
                } else if (billVO.getDAPType().getValue() == 0) {
                    sSQL = MessageFormat.format(updatePurVoucherSql, botRelation.getDestObjectID(), botRelation.getSrcObjectID());
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
                    HashMap<String, String> grpVouMap = new HashMap<String, String>();
                    grpVouMap.put(botRelation.getSrcObjectID(), botRelation.getDestObjectID());
                    this.addPurVoucherInfo(ctx, grpVouMap);
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)this.updateOtherApBillSQL(botRelation.getSrcObjectID(), false));
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)this.updateIncomeInvoiceSQL(botRelation.getSrcObjectID(), false));
                    com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)this.updateCostAdjustBillSQL(botRelation.getSrcObjectID(), false));
                    BOTRelationCollection coll = new BOTRelationCollection();
                    coll.add(botRelation);
                    this.writeBotRelation(ctx, grpVouMap, coll);
                }
                ArrayList<String> purBillId = new ArrayList<String>();
                IPurInWarehsVoucher iPurVoucher = PurInWarehsVoucherFactory.getLocalInstance((Context)ctx);
                for (int i = 0; i < billVO.getEntry().size(); ++i) {
                    WriteOffRecordInfo recordInfo = billVO.getEntry().get(i);
                    if (!recordInfo.getBillTypeNumber().equals("103") || purBillId.indexOf(recordInfo.getBillID()) > -1) continue;
                    purBillId.add(recordInfo.getBillID());
                    PurInWarehsVoucherInfo voucherInfo = new PurInWarehsVoucherInfo();
                    voucherInfo.setId(BOSUuid.create((BOSObjectType)voucherInfo.getBOSType()));
                    voucherInfo.setYear(billVO.getWriteOffYear());
                    voucherInfo.setPeriod(billVO.getWriteOffPeriod());
                    voucherInfo.setCompanyOrgUnitId(billVO.getCompanyOrgUnit().getId());
                    voucherInfo.setBillID(BOSUuid.read((String)recordInfo.getBillID()));
                    voucherInfo.setVoucherID(BOSUuid.read((String)botRelation.getDestObjectID()));
                    voucherInfo.setVoucherType(billVO.getDAPType());
                    voucherInfo.setWriteOffGroupId(billVO.getId());
                    voucherInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    iPurVoucher.save((CoreBaseInfo)voucherInfo);
                }
            }
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            String deleteVoucherSql = " update T_CL_WriteOffGroup set FVoucherID = null, FFiVouchered = 0 where FID = ''{0}''";
            sSQL = MessageFormat.format(deleteVoucherSql, botRelation.getSrcObjectID());
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
            HashSet<String> groupIdSet = new HashSet<String>();
            groupIdSet.add(botRelation.getSrcObjectID());
            this.deleteSaleWriteOffVouchered(ctx, groupIdSet);
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            String updatePurVoucherSql = " update T_CL_WriteOffGroup set FVoucherID = ''{0}'', FFiVouchered = 1 where FID = ''{1}''";
            sSQL = MessageFormat.format(updatePurVoucherSql, botRelation.getDestObjectID(), botRelation.getSrcObjectID());
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL);
            HashSet<String> groupIdSet = new HashSet<String>();
            groupIdSet.add(botRelation.getSrcObjectID());
            this.addSaleWriteOffVouchered(ctx, groupIdSet);
        }
    }

    private String deletePurVoucherInfo(Context ctx, String groupId) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("update t_im_purinwarehsbill AS T set (FFiVouchered,FVoucherID) = (");
        bf.append(" select 0,null from t_cl_writeoffgroup bill");
        bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
        bf.append(" inner join t_im_purinwarehsbill T1 on entry.fbillid = T1.fid");
        bf.append(" inner join t_im_PurInWarehsVoucher voucher on T1.FVoucherID=voucher.FVoucherID");
        bf.append(" where bill.FID = '").append(groupId).append("' and voucher.FVoucherType <> 1");
        bf.append(" and entry.FBillTypeNumber = '103' and T.FID = T1.FID");
        bf.append(" group by bill.FFiVouchered,bill.FVoucherID");
        bf.append(" )");
        return bf.toString();
    }

    private void addPurVoucherInfo(Context ctx, Map<String, String> grpVouMap) throws BOSException {
        Set<String> grpIdSet = grpVouMap.keySet();
        String tempTable = com.kingdee.eas.scm.cal.util.DBUtil.createTempTable(ctx, "tempTable", new String[][]{{"FGroupID", "VARCHAR(44)"}});
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            TempTablePool.getInstance((Context)ctx).createIndex(tempTable, "FGroupID", false, false);
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement("INSERT INTO " + tempTable + " (FGroupID) VALUES (?)");
            for (String id : grpIdSet) {
                ps.setString(1, id);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        StringBuffer sSQL = new StringBuffer(512);
        sSQL.append("select a.FID from ").append(tempTable).append(" bill ");
        sSQL.append("inner join t_cl_writeoffrecord entry on bill.FGroupID = entry.fparentid ");
        sSQL.append("inner join t_im_purinwarehsbill a on entry.fbillid = a.fid ");
        sSQL.append("inner join t_im_purinwarehsentry b on a.fid = b.fparentid ");
        sSQL.append("where a.FFiVouchered = 0");
        sSQL.append("group by a.fid having sum(b.FUnWriteOffQty) = 0");
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        ArrayList<String> purIdList = new ArrayList<String>();
        try {
            while (rs.next()) {
                purIdList.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sSQL.setLength(0);
        sSQL.append("select Temp.FID from (");
        sSQL.append("select a.FID from ").append(tempTable).append(" bill ");
        sSQL.append("inner join t_cl_writeoffrecord entry on bill.FGroupID = entry.fparentid ");
        sSQL.append("inner join t_im_purinwarehsbill a on entry.fbillid = a.fid ");
        sSQL.append("inner join t_im_purinwarehsentry b on a.fid = b.fparentid ");
        sSQL.append("group by a.fid having sum(b.FUnWriteOffQty) = 0");
        sSQL.append(") as Temp inner join t_cl_writeoffrecord entry on Temp.FID = entry.FBillID ");
        sSQL.append("inner join t_cl_writeoffgroup bill on bill.FID = entry.FParentID ");
        sSQL.append("where NOT EXISTS (SELECT 1 FROM ").append(tempTable).append(" temp ");
        sSQL.append("WHERE bill.FID = temp.FGroupID) ");
        sSQL.append("and Bill.FFiVouchered = 0 ");
        sSQL.append("group by Temp.FID");
        rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        try {
            while (rs.next()) {
                purIdList.remove(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (purIdList.size() > 0) {
            StringBuilder sb = new StringBuilder(128);
            for (String id : purIdList) {
                sb.append("'").append(id).append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
            rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)("SELECT bill.FGroupID, entry.FBillID FROM " + tempTable + " bill INNER JOIN T_CL_WriteOffRecord entry ON bill.FGroupID = entry.FParentID WHERE entry.FBillID IN (" + sb.toString() + ")"));
            try {
                String updateSQL = "update t_im_purinwarehsbill set FFiVouchered = 1, FVoucherID = ? where FID = ?";
                conn = EJBFactory.getConnection((Context)ctx);
                ps = conn.prepareStatement(updateSQL);
                boolean isBatch = false;
                while (rs.next()) {
                    ps.setString(1, grpVouMap.get(rs.getString("FGroupID")));
                    ps.setString(2, rs.getString("FBillID"));
                    ps.addBatch();
                    isBatch = true;
                }
                if (isBatch) {
                    ps.executeBatch();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
            }
        }
        TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
    }

    private void addSaleWriteOffVouchered(Context ctx, Set<String> groupIdSet) throws BOSException {
        StringBuilder sb = new StringBuilder(128);
        for (String id : groupIdSet) {
            sb.append("'").append(id).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("select entry.FBILLID as FBILLID from t_cl_writeoffgroup bill ");
        sSQL.append("inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid ");
        sSQL.append("where bill.FID IN (").append(sb.toString()).append(") and entry.FBILLTYPENUMBER ='").append("102").append("' ");
        sSQL.append("group by entry.FBILLID ");
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        HashSet<String> saleIds = new HashSet<String>();
        try {
            while (rs.next()) {
                saleIds.add(rs.getString("FBILLID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String updateSQL = "update t_im_saleissuebill set FisWriteOffVouched = 1  where FID = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(updateSQL);
            for (String id : saleIds) {
                ps.setString(1, id);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    private void deleteSaleWriteOffVouchered(Context ctx, Set<String> groupIdSet) throws BOSException {
        StringBuilder sb = new StringBuilder(128);
        for (String id : groupIdSet) {
            sb.append("'").append(id).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("select entry.FBILLID as FBILLID from t_cl_writeoffgroup bill ");
        sSQL.append("inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid ");
        sSQL.append("where bill.FID IN (").append(sb.toString()).append(") and entry.FBILLTYPENUMBER ='").append("102").append("' ");
        sSQL.append("group by entry.FBILLID ");
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        HashSet<String> saleIds = new HashSet<String>();
        try {
            while (rs.next()) {
                saleIds.add(rs.getString("FBILLID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (saleIds.size() == 0) {
            return;
        }
        String Ids = CalculateUtil.getSqlInString(saleIds);
        sSQL.setLength(0);
        sSQL.append("select entry.FBILLID as FBILLID from t_cl_writeoffgroup bill ");
        sSQL.append("inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid ");
        sSQL.append("where entry.FBILLID in (").append(Ids).append(") and FFIVOUCHERED = 1 ");
        rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
        try {
            while (rs.next()) {
                saleIds.remove(rs.getString("FBILLID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String updateSQL = "update t_im_saleissuebill set FisWriteOffVouched = 0  where FID = ?";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(updateSQL);
            for (String id : saleIds) {
                ps.setString(1, id);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((ResultSet)rs, ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        WriteOffGroupInfo coreBillInfo = (WriteOffGroupInfo)this.getCoreBillBaseInfo(ctx, sourceBillPk);
        if (coreBillInfo.getVoucher() == null) {
            return false;
        }
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        iVoucher.delete((IObjectPK)new ObjectUuidPK(coreBillInfo.getVoucher().getId()));
        IDAPTransformer dapTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
        dapTransformer.undoTransformFromVoucher((BaseVoucherInfo)coreBillInfo.getVoucher());
        return true;
    }

    @Override
    protected void _updateEqualWriteOff(Context ctx, String[] ids) throws BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getWriteOffGroupSelector());
        WriteOffGroupCollection billConlletion = WriteOffGroupFactory.getLocalInstance(ctx).getWriteOffGroupCollection(view);
        WriteOffGroupInfo billVO = null;
        for (int j = 0; j < billConlletion.size(); ++j) {
            boolean isPurToPurWriteOff;
            billVO = billConlletion.get(j);
            int purOrSaleBillCount = 0;
            StringBuffer listStr = new StringBuffer();
            for (int i = 0; i < billVO.getEntry().size(); ++i) {
                WriteOffRecordInfo recordInfo = billVO.getEntry().get(i);
                if (!"103".equals(recordInfo.getBillTypeNumber()) && !"102".equals(recordInfo.getBillTypeNumber())) continue;
                ++purOrSaleBillCount;
                if (listStr.indexOf(recordInfo.getBillID()) >= 0) continue;
                listStr.append(",'").append(recordInfo.getBillID()).append("'");
            }
            String idStr = "";
            if (listStr.length() > 0) {
                idStr = listStr.toString().substring(1);
            }
            boolean bl = isPurToPurWriteOff = purOrSaleBillCount == billVO.getEntry().size();
            if (!isPurToPurWriteOff || !this.isEqualWriteOff(billVO)) continue;
            this.setVoucherFlag(ctx, new String[]{billVO.getId().toString()}, new String[]{idStr}, 0);
        }
    }

    private int isCreateVoucher(Context ctx, int count, String idStr, boolean isAllPurBill) throws BOSException, EASBizException {
        String SEL_VOUCHER_SQL = "select count(FID) as count from T_IM_PurInWarehsBill where FId in ({0}) and (FFiVouchered=1 OR FIsInitBill=1)";
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(SEL_VOUCHER_SQL, idStr));
        try {
            rs.next();
            int num = rs.getInt("count");
            if (num == count) {
                return 0;
            }
            if (num == 0) {
                return 1;
            }
            return -1;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBotRelation(Context ctx, Map<String, String> grpVouMap, BOTRelationCollection relationInfos) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("entry.billID"));
        view.getSelector().add(new SelectorItemInfo("entry.billEntryID"));
        view.getSelector().add(new SelectorItemInfo("entry.billTypeNumber"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", grpVouMap.keySet(), CompareType.INCLUDE));
        view.setFilter(filter);
        WriteOffGroupCollection wfColl = WriteOffGroupFactory.getLocalInstance(ctx).getWriteOffGroupCollection(view);
        WriteOffRecordCollection recColl = null;
        WriteOffRecordInfo record = null;
        String billId = null;
        HashSet<String> billIdSet = new HashSet<String>();
        String destBosType = "2652E01E";
        Date now = new Date();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            IORMappingDAO idao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"59302EC6"), (Context)ctx, (Connection)conn);
            for (int i = 0; i < wfColl.size(); ++i) {
                recColl = wfColl.get(i).getEntry();
                int k = recColl.size();
                for (int j = 0; j < k; ++j) {
                    record = recColl.get(j);
                    billId = record.getBillID();
                    if (billIdSet.contains(billId)) continue;
                    billIdSet.add(billId);
                    BOTRelationInfo info = new BOTRelationInfo();
                    String srcBosType = BOSUuid.read((String)billId).getType().toString();
                    info.setSrcEntityID(srcBosType);
                    info.setDestEntityID(destBosType);
                    info.setSrcObjectID(billId);
                    info.setDestObjectID(grpVouMap.get(wfColl.get(i).getId().toString()));
                    info.setBOTMappingID(relationInfos.get(0).getBOTMappingID());
                    info.setDate(now);
                    info.setOperatorID("sky_lv");
                    info.setIsEffected(true);
                    info.setType(0);
                    idao.addNewBatch((IObjectValue)info);
                }
            }
            idao.executeBatch();
            BOTRelationEntryInfo botEntryInfo = null;
            idao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"97BBCB32"), (Context)ctx, (Connection)conn);
            IObjectValue relEntryInfo = null;
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getEntity(BOSObjectType.create((String)"97BBCB32"));
            int relSize = 0;
            int size = relationInfos.size();
            for (int i = 0; i < size; ++i) {
                int k = relationInfos.get(i).getRelationEntries().size();
                for (int j = 0; j < k; ++j) {
                    botEntryInfo = relationInfos.get(i).getRelationEntries().get(j);
                    record = wfColl.get(BOSUuid.read((String)botEntryInfo.getSrcObjectID())).getEntry().get(BOSUuid.read((String)botEntryInfo.getSrcEntryID()));
                    if (!"230".equals(record.getBillTypeNumber())) continue;
                    relEntryInfo = Utils.newObjectValueInstance((EntityObjectInfo)entityInfo);
                    relEntryInfo.setString("srcObjectID", record.getBillID());
                    relEntryInfo.setString("destObjectID", botEntryInfo.getDestObjectID());
                    relEntryInfo.setString("srcEntryID", record.getBillEntryID());
                    relEntryInfo.setString("destEntryID", botEntryInfo.getDestEntryID());
                    relEntryInfo.setDate("date", now);
                    idao.addNewBatch(relEntryInfo);
                    if (++relSize <= 2000) continue;
                    idao.executeBatch();
                    relSize = 0;
                }
            }
            if (relSize > 0) {
                idao.executeBatch();
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void deleteBotRelation(Context ctx, BOTRelationInfo botRelation) throws BOSException {
        String deleteBotSQL = "delete from t_bot_relation where FDestObjectId=''{0}'' and FDestEntityId=''{1}''";
        String deleteBotEntrySQL = "delete from t_ar_araprelationentry where FDestObjectId=''{0}''";
        String sSQL1 = MessageFormat.format(deleteBotSQL, botRelation.getDestObjectID(), botRelation.getDestEntityID());
        String sSQL2 = MessageFormat.format(deleteBotEntrySQL, botRelation.getDestObjectID());
        com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL1);
        com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)sSQL2);
    }

    private void validateVoucherPeriod(Context ctx, VoucherInfo voucher) throws BOSException, EASBizException {
        if (voucher == null) {
            return;
        }
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)voucher.getCompany());
        if (periodInfo == null) {
            return;
        }
        if (periodInfo.getPeriodYear() * 100 + periodInfo.getPeriodNumber() > voucher.getPeriod().getPeriodYear() * 100 + voucher.getPeriod().getPeriodNumber()) {
            throw new CalculateException(CalculateException.CANNOT_DEL_OLD_VOUCHER);
        }
    }

    private String updateOtherApBillSQL(String id, boolean flag) {
        StringBuffer bf = new StringBuffer();
        bf.append("update t_ap_otherbill AS T set (FFiVouchered,FVoucherID,FVoucherNumber,FVoucherTypeID) = (");
        if (flag) {
            bf.append(" select 0,null,null,null");
        } else {
            bf.append(" select bill.FFiVouchered,bill.FVoucherID,T2.FNumber,T2.FVoucherTypeID");
        }
        bf.append(" from t_cl_writeoffgroup bill");
        bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
        bf.append(" inner join t_ap_otherbill T1 on entry.fbillid = T1.fid");
        if (!flag) {
            bf.append(" inner join t_gl_voucher T2 on bill.FVoucherID = T2.FID");
        }
        bf.append(" where bill.FID = '").append(id).append("'");
        bf.append(" and T.FID = T1.FID");
        bf.append(" group by bill.FFiVouchered,bill.FVoucherID");
        if (!flag) {
            bf.append(",T2.FNumber,T2.FVoucherTypeID");
        }
        bf.append(" )");
        return bf.toString();
    }

    private String updateIncomeInvoiceSQL(String id, boolean flag) {
        StringBuffer bf = new StringBuffer();
        bf.append("If exists (SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = 'T_IM_IncomeInvoice' AND KSQL_COL_Name = 'FBizVoucherID')");
        bf.append(" update T_IM_IncomeInvoice AS T set (FReBusiness,FBizVoucherID,FBizVoucherNumber,FBizVoucherPeriodID,FBizVoucherTypeID) = (");
        if (flag) {
            bf.append(" select 0,null,null,null,null");
        } else {
            bf.append(" select bill.FFiVouchered,bill.FVoucherID,T2.FNumber,T2.FPeriodID,T2.FVoucherTypeID");
        }
        bf.append(" from t_cl_writeoffgroup bill");
        bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
        bf.append(" inner join t_ap_otherbill T1 on entry.fbillid = T1.fid");
        bf.append(" inner join T_BOT_Relation R on R.FSRCObjectID  = T1.fid");
        bf.append(" inner join T_IM_IncomeInvoice IM on IM.FID = R.FDESTObjectID");
        if (!flag) {
            bf.append(" inner join t_gl_voucher T2 on bill.FVoucherID = T2.FID");
        }
        bf.append(" where bill.FID = '").append(id).append("'");
        bf.append(" and T.FID = IM.FID");
        bf.append(" and R.FDestEntityID  = '1343913D'");
        bf.append(" group by bill.FFiVouchered,bill.FVoucherID");
        if (!flag) {
            bf.append(",T2.FNumber,T2.FPeriodID,T2.FVoucherTypeID");
        }
        bf.append(" )");
        return bf.toString();
    }

    private String updateCostAdjustBillSQL(String id, boolean flag) {
        StringBuffer bf = new StringBuffer();
        bf.append("update t_cl_costAdjustBill AS T set (FFiVouchered,FVoucherID) = (");
        if (flag) {
            bf.append(" select 0,null");
        } else {
            bf.append(" select bill.FFiVouchered,bill.FVoucherID");
        }
        bf.append(" from t_cl_writeoffgroup bill");
        bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
        bf.append(" inner join t_cl_costAdjustBill T1 on entry.fbillid = T1.fid");
        bf.append(" where bill.FID = '").append(id).append("'");
        bf.append(" and T.FID = T1.FID");
        bf.append(" group by bill.FFiVouchered,bill.FVoucherID");
        bf.append(" )");
        return bf.toString();
    }

    private void setVoucherFlag(Context ctx, String[] writeOffGroupID, String[] purInWarehsBillIds, int isVouchered) throws BOSException {
        String updateWriteOffVouchered = "update T_CL_WriteOffGroup set FFiVouchered = " + isVouchered + " where FId = ''{0}''";
        String updatePurBillVocuhered = "";
        updatePurBillVocuhered = isVouchered == 1 ? "update T_IM_PurInWarehsBill set FFiVouchered = " + isVouchered + " where FId in (select fparentid  from T_IM_PurInWarehsentry where fparentid in ({0}) group by fparentid having sum(FUnWriteOffQty)=0 )  and fid in (select a.fid from T_IM_PurInWarehsBill a inner join t_cl_writeoffrecord b on a.fid = b.fbillid where a.fid in ({1}) and not exists (select 1 from t_cl_writeoffGroup T1 inner join t_cl_writeoffrecord T2 on T1.fid = T2.fparentid where T2.fbillid = a.fid and T1.FFiVouchered = 0 ))" : "update T_IM_PurInWarehsBill set FFiVouchered = " + isVouchered + " where FId in ({0})  and FVOUCHERID is null";
        if (writeOffGroupID != null && writeOffGroupID.length > 0) {
            com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)MessageFormat.format(updateWriteOffVouchered, writeOffGroupID[0]));
        }
        if (purInWarehsBillIds != null && purInWarehsBillIds.length > 0) {
            if (isVouchered == 1) {
                com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)MessageFormat.format(updatePurBillVocuhered, purInWarehsBillIds[0], purInWarehsBillIds[0]));
            } else {
                updatePurBillVocuhered = updatePurBillVocuhered + " and FVOUCHERID is null";
                com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)MessageFormat.format(updatePurBillVocuhered, purInWarehsBillIds[0]));
            }
        }
    }

    @Override
    protected int _initData(Context ctx, String[] ids) throws BOSException, EASBizException {
        int i;
        WriteOffGroupInfo billVO;
        int[] temp;
        HashSet<String> idSet = new HashSet<String>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            idSet.add(ids[i2]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getWriteOffGroupSelector());
        WriteOffGroupCollection billCollection = WriteOffGroupFactory.getLocalInstance(ctx).getWriteOffGroupCollection(view);
        int result = -1;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        int companyDisChargeType = Integer.parseInt(ipc.getParamValue((IObjectPK)new ObjectUuidPK(billCollection.get(0).getCompanyOrgUnit().getId()), "SCM_CAL_001"));
        Map<String, WriteOffGroupCollection> groupCollectionMap = WriteOffFilterHelper.getGroupingCollAndType(billCollection);
        WriteOffGroupCollection purWriteOffColl = groupCollectionMap.get("purWriteOffColl");
        WriteOffGroupCollection saleWriteOffColl = groupCollectionMap.get("saleWriteOffColl");
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)purWriteOffColl)) {
            temp = new int[purWriteOffColl.size()];
            billCollection = purWriteOffColl;
            int dischargeType = 9999;
            try {
                for (int j = 0; j < billCollection.size(); ++j) {
                    boolean isPurVoucher;
                    billVO = billCollection.get(j);
                    int purBillCount = 0;
                    int purBillEntryCount = 0;
                    StringBuffer listStr = new StringBuffer();
                    for (int i3 = 0; i3 < billVO.getEntry().size(); ++i3) {
                        WriteOffRecordInfo recordInfo = billVO.getEntry().get(i3);
                        if (!"103".equals(recordInfo.getBillTypeNumber())) continue;
                        ++purBillEntryCount;
                        if (listStr.indexOf(recordInfo.getBillID()) >= 0) continue;
                        ++purBillCount;
                        listStr.append(",'").append(recordInfo.getBillID()).append("'");
                    }
                    String idStr = "";
                    if (listStr.length() <= 0) {
                        throw new CalculateException(CalculateException.GEN_VOUCHER_ERROR);
                    }
                    idStr = listStr.toString().substring(1);
                    dischargeType = billVO.getDisChargeType().getValue();
                    boolean isPurToPurWriteOff = purBillEntryCount == billVO.getEntry().size();
                    int isCreateVoucher = this.isCreateVoucher(ctx, purBillCount, idStr, isPurToPurWriteOff);
                    int isInitBillResult = this.isInitBill(ctx, billVO);
                    boolean isInitBill = isInitBillResult != 0;
                    temp[j] = 0;
                    if (isPurToPurWriteOff) {
                        if (isCreateVoucher == -1) {
                            throw new CalculateException(CalculateException.PART_IS_VOUCHERED);
                        }
                        if (this.isEqualWriteOff(billVO)) {
                            if (companyDisChargeType == 1 && isInitBill && !billVO.isFiVouchered()) {
                                if (isInitBillResult == 1) {
                                    if (this.currBillIsVouchered(ctx, billVO)) {
                                        this.setVoucherFlag(ctx, new String[]{billVO.getId().toString()}, new String[]{idStr}, 1);
                                        billVO.setIsDischarged(true);
                                        temp[j] = 1;
                                        continue;
                                    }
                                    billVO.setDAPType(PurVoucherTypeEnum.DischgVoucher);
                                    temp[j] = 3;
                                    continue;
                                }
                                if (!this.currBillIsVouchered(ctx, billVO)) {
                                    this.setVoucherFlag(ctx, new String[]{billVO.getId().toString()}, new String[]{idStr}, 1);
                                    billVO.setIsDischarged(true);
                                    temp[j] = 1;
                                    continue;
                                }
                                billVO.setDAPType(PurVoucherTypeEnum.DischgVoucher);
                                temp[j] = 3;
                                continue;
                            }
                            this.setVoucherFlag(ctx, new String[]{billVO.getId().toString()}, new String[]{idStr}, 1);
                            billVO.setIsDischarged(true);
                            temp[j] = 1;
                            continue;
                        }
                        if (isCreateVoucher == 0) {
                            throw new CalculateException(CalculateException.ALL_IS_VOUCHERED);
                        }
                        billVO.setDAPType(PurVoucherTypeEnum.PurVoucher);
                        temp[j] = 2;
                        if (companyDisChargeType != 1 || !isInitBill || billVO.isFiVouchered() || billVO.isIsDischarged()) continue;
                        billVO.setDAPType(PurVoucherTypeEnum.DischgVoucher);
                        temp[j] = 3;
                        continue;
                    }
                    boolean isDischargeVoucher = isInitBill && !billVO.isIsDischarged() || dischargeType == 2 && !billVO.isIsDischarged() && isCreateVoucher == 0;
                    boolean bl = isPurVoucher = dischargeType == 1 || dischargeType == 2 && billVO.isIsDischarged() || dischargeType == 2 && !billVO.isIsDischarged() && isCreateVoucher == 1 || isInitBill && billVO.isIsDischarged();
                    if (isDischargeVoucher) {
                        billVO.setDAPType(PurVoucherTypeEnum.DischgVoucher);
                        temp[j] = 3;
                        continue;
                    }
                    if (isPurVoucher) {
                        billVO.setDAPType(PurVoucherTypeEnum.PurVoucher);
                        temp[j] = 4;
                        continue;
                    }
                    temp[j] = -1;
                }
                int count1 = 0;
                int count2 = 0;
                int count3 = 0;
                int count4 = 0;
                int count5 = 0;
                for (int i4 = 0; i4 < temp.length; ++i4) {
                    if (temp[i4] == 1) {
                        ++count1;
                    }
                    if (temp[i4] == 2) {
                        ++count2;
                    }
                    if (temp[i4] == 3) {
                        ++count3;
                    }
                    if (temp[i4] == 4) {
                        ++count4;
                    }
                    if (temp[i4] != -1) continue;
                    ++count5;
                }
                if (count1 == temp.length) {
                    result = 1;
                } else if (count2 == temp.length) {
                    result = 0;
                } else if (count3 == temp.length) {
                    result = 0;
                } else if (count4 == temp.length) {
                    result = 0;
                } else if (count5 == temp.length) {
                    throw new CalculateException(CalculateException.HAVE_VOUCH_OTERH);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            IWriteOffGroup iWriteOffGroup = WriteOffGroupFactory.getLocalInstance(ctx);
            if (result == 0) {
                CoreBaseCollection coll = new CoreBaseCollection();
                for (i = 0; i < temp.length; ++i) {
                    coll.add((CoreBaseInfo)billCollection.get(i));
                }
                iWriteOffGroup.save(coll);
            }
        }
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)saleWriteOffColl)) {
            temp = new int[saleWriteOffColl.size()];
            billCollection = saleWriteOffColl;
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < billCollection.size(); ++j) {
                billVO = billCollection.get(j);
                if (billVO.isFiVouchered()) {
                    throw new CalculateException(CalculateException.SALE_PART_IS_VOUCHERED);
                }
                int saleBillEntryCount = 0;
                StringBuffer listStr = new StringBuffer();
                for (i = 0; i < billVO.getEntry().size(); ++i) {
                    WriteOffRecordInfo recordInfo = billVO.getEntry().get(i);
                    if (!"102".equals(recordInfo.getBillTypeNumber())) continue;
                    ++saleBillEntryCount;
                    if (listStr.indexOf(recordInfo.getBillID()) >= 0) continue;
                    ++saleBillEntryCount;
                    listStr.append(",'").append(recordInfo.getBillID()).append("'");
                }
                boolean isSaleToSaleWriteOff = false;
                if (saleBillEntryCount == billVO.getEntry().size() && saleBillEntryCount >= 2) {
                    isSaleToSaleWriteOff = true;
                }
                if (!isSaleToSaleWriteOff || !this.isEqualWriteOff(billVO)) continue;
                temp[j] = 1;
                String updateWriteOffVouchered = "update T_CL_WriteOffGroup set FFiVouchered = 1 where FId = ''{0}'';";
                sb.append(MessageFormat.format(updateWriteOffVouchered, billVO.getId().toString()));
            }
            int count1 = 0;
            for (int i5 = 0; i5 < temp.length; ++i5) {
                if (temp[i5] != 1) continue;
                ++count1;
            }
            if (count1 == temp.length) {
                result = 1;
            } else if (count1 == 0) {
                result = 0;
            }
            if (result == 1 && sb.length() > 0) {
                DBUtil.executeBatch((Context)ctx, (String[])sb.toString().split(";"));
            }
        }
        return result;
    }

    private boolean isPurWriteOffRecord(WriteOffGroupInfo billVO) {
        return "103".equals(billVO.getEntry().get(0).getBillTypeNumber()) || "230".equals(billVO.getEntry().get(0).getBillTypeNumber());
    }

    private boolean isEqualWriteOff(WriteOffGroupInfo billVO) {
        BigDecimal positive = new BigDecimal("0.00");
        BigDecimal negative = new BigDecimal("0.00");
        for (int i = 0; i < billVO.getEntry().size(); ++i) {
            WriteOffRecordInfo recordInfo = billVO.getEntry().get(i);
            if (recordInfo.getCurrWrittenOffAmount().signum() == 1) {
                positive = positive.add(recordInfo.getCurrWrittenOffAmount());
                continue;
            }
            negative = negative.add(recordInfo.getCurrWrittenOffAmount());
        }
        return positive.compareTo(negative.abs()) == 0;
    }

    private boolean currBillIsVouchered(Context ctx, WriteOffGroupInfo billVO) throws BOSException {
        String selectInitBill = "select distinct purbill.fid,purbill.FFIVOUCHERED as isVouchered from T_IM_PurInWarehsBill purbill inner join T_CL_WriteOffRecord record on purbill.FID=record.FBillId inner join T_CL_WriteOffGroup head on head.FID = record.FParentId where head.FId = ''{0}'' and record.FBillTypeNumber=''103'' and purbill.FIsInitBill = 0";
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(selectInitBill, billVO.getId().toString()));
        boolean result = true;
        try {
            while (rs.next()) {
                if (rs.getInt("isVouchered") != 0) continue;
                result = false;
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private int isInitBill(Context ctx, WriteOffGroupInfo billVO) throws BOSException {
        String selectInitBill = "select distinct purbill.fid,purbill.FFIVOUCHERED as isVouchered from T_IM_PurInWarehsBill purbill inner join T_CL_WriteOffRecord record on purbill.FID=record.FBillId inner join T_CL_WriteOffGroup head on head.FID = record.FParentId where head.FId = ''{0}'' and record.FBillTypeNumber=''103'' and purbill.FIsInitBill = 1";
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(selectInitBill, billVO.getId().toString()));
        try {
            if (rs.next()) {
                if (rs.getInt("isVouchered") == 0) {
                    return 1;
                }
                return 2;
            }
            return 0;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _deleteDischargeVoucher(Context ctx, String[] ids) throws BOSException, EASBizException {
        String billId = CalculateUtil.getSqlInString(ids);
        StringBuilder checkVoucherSql = new StringBuilder("select FID from T_CL_WriteOffGroup where FID in {0} and (FIsDischarged=0 or FFiVouchered=1)");
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(checkVoucherSql.toString(), billId));
        try {
            if (rs.next()) {
                throw new CalculateException(CalculateException.DELETE_VOUCHER_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        checkVoucherSql.setLength(0);
        checkVoucherSql.append("SELECT FWRITEOFFGROUPID FROM T_IM_PurInWarehsVoucher where FVOUCHERTYPE = {0} and FWRITEOFFGROUPID in (");
        checkVoucherSql.append("SELECT FWRITEOFFGROUPID FROM T_IM_PurInWarehsVoucher where FVOUCHERTYPE = {1} and  FVOUCHERID in (");
        checkVoucherSql.append("SELECT FVOUCHERID FROM T_IM_PurInWarehsVoucher where FVOUCHERTYPE = {1} and FWRITEOFFGROUPID in {2}");
        checkVoucherSql.append("))");
        rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(checkVoucherSql.toString(), 0, 2, billId));
        try {
            if (rs.next()) {
                throw new CalculateException(CalculateException.DELETE_DISVOUCHER_ERROR);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        String selectWriteOffVoucher = "select FWriteOffGroupId,FVoucherId,FCOMPANYORGUNITID from T_IM_PurInWarehsVoucher where FWriteOffGroupId in {0} and FVoucherType = {1}";
        IRowSet rs1 = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)MessageFormat.format(selectWriteOffVoucher, billId, String.valueOf(2)));
        try {
            int companyDisChargeType;
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            ArrayList<String> voucherIdList = new ArrayList<String>();
            String voucherId = null;
            VoucherInfo voucher = null;
            String companyid = null;
            while (rs1.next()) {
                voucherId = rs1.getString("FVoucherId");
                companyid = rs1.getString("FCOMPANYORGUNITID");
                try {
                    voucher = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), SCMSelectorFactory.getVoucherInfoSelector4Cal());
                }
                catch (EASBizException e) {
                    continue;
                }
                this.validateVoucherPeriod(ctx, voucher);
                voucherIdList.add(voucherId);
            }
            iVoucher.deleteVoucherCollection(voucherIdList, SystemEnum.INVENTORYMANAGEMENT);
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            if (companyid != null && 1 == (companyDisChargeType = Integer.parseInt(ipc.getParamValue((IObjectPK)new ObjectUuidPK(companyid), "SCM_CAL_001")))) {
                StringBuffer sql = new StringBuffer();
                sql.append(" update T_CL_WriteOffGroup set FISDISCHARGED = 0 where fid in  ");
                sql.append(" (select gro.fid from T_CL_WriteOffGroup gro inner join T_CL_WriteOffRecord record on record.fparentid = gro.fid");
                sql.append(" inner join T_im_purInwarehsBill purin on record.fbillid = purin.fid ");
                sql.append(" where gro.fid in {0} and purin.FISINITBILL = 1 and purin.FFIVOUCHERED = 1 and gro.FISDISCHARGED = 1)");
                com.kingdee.eas.scm.cal.util.DBUtil.execute((Context)ctx, (String)MessageFormat.format(sql.toString(), billId));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs1);
        }
    }

    @Override
    protected EntityViewInfo _processEntryFilter(Context ctx, BOSObjectType bosType, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        try {
            ImplUtils.processEntryFilter((BOSObjectType)bosType, (EntityViewInfo)entityViewInfo, (Context)ctx);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return entityViewInfo;
    }

    @Override
    protected Map _loadFinanceData(Context ctx, CompanyOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (null == companyInfo) {
            return null;
        }
        WriteOffPeriodInfo info = new WriteOffPeriodInfo();
        HashMap<String, WriteOffPeriodInfo> map = new HashMap<String, WriteOffPeriodInfo>();
        PeriodInfo curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        int minYear = PeriodUtils.getMaxOrMinPeriodYear((Context)ctx, (String)companyInfo.getId().toString(), (boolean)false);
        int maxYear = PeriodUtils.getMaxOrMinPeriodYear((Context)ctx, (String)companyInfo.getId().toString(), (boolean)true);
        if (null != curPeriodInfo) {
            int minMonth = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)curPeriodInfo.getPeriodYear(), (String)companyInfo.getId().toString());
            int maxMonth = PeriodUtils.getMaxPeriodNumber((Context)ctx, (int)curPeriodInfo.getPeriodYear(), (String)companyInfo.getId().toString());
            info.setMinMonth(minMonth);
            info.setMaxMonth(maxMonth);
        }
        info.setMinYear(minYear);
        info.setMaxYear(maxYear);
        info.setCurPeriodInfo(curPeriodInfo);
        info.setStartPeriodInfo(startPeriodInfo);
        map.put(companyInfo.getId().toString(), info);
        return map;
    }

    @Override
    protected void _validateWriteOffVoucher(Context ctx, String[] ids, String companyOrgUnitId, String billType) throws BOSException, EASBizException {
        if (companyOrgUnitId == null || companyOrgUnitId.length() == 0) {
            return;
        }
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyOrgUnitId));
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (curPeriod == null) {
            return;
        }
        StringBuffer bf = new StringBuffer();
        bf.append("(");
        int length = ids.length;
        for (int i = 0; i < length; ++i) {
            bf.append("'").append(ids[i]).append("'");
            if (i == length - 1) continue;
            bf.append(",");
        }
        bf.append(")");
        String billId = bf.toString();
        bf.setLength(0);
        if (billType.equals("103")) {
            bf.append("select entry.fbillnumber,bill.ffivouchered,bill.FIsDischarged,isnull(bill.FVoucherId,'X') as wfVoucherId,isnull(purBill.FVoucherId,'X') as purVoucherId");
            bf.append(" from t_cl_writeoffgroup bill");
            bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
            bf.append(" inner join t_im_purinwarehsBill purBill on purBill.fid = entry.fbillid");
            bf.append(" where purBill.fid in ").append(billId);
            bf.append(" and bill.FWriteOffYear>=").append(curPeriod.getPeriodYear());
            bf.append(" and bill.FWriteOffPeriod>=").append(curPeriod.getPeriodNumber());
            bf.append(" group by entry.fbillnumber,bill.ffivouchered,bill.FIsDischarged,bill.FVoucherId,purBill.FVoucherId");
        } else if (billType.equals("230") || billType.equals("410")) {
            bf.append("select entry.fbillnumber,bill.ffivouchered");
            bf.append(" from t_cl_writeoffgroup bill");
            bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
            bf.append(" where entry.fbillid in ").append(billId);
            bf.append(" group by entry.fbillnumber,bill.ffivouchered");
        }
        String sql = bf.toString();
        IRowSet rs = null;
        try {
            rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                if (("230".equals(billType) || "410".equals(billType)) && rs.getBoolean("ffivouchered")) {
                    throw new CalculateException(CalculateException.WRITEOFF_VOUCHER_EXIST, new Object[]{rs.getString("fbillnumber")});
                }
                if (!"103".equals(billType)) continue;
                if (rs.getBoolean("ffivouchered") && rs.getString("wfVoucherId").equals(rs.getString("purVoucherId"))) {
                    throw new CalculateException(CalculateException.WRITEOFF_VOUCHER_EXIST, new Object[]{rs.getString("fbillnumber")});
                }
                if (!rs.getBoolean("FIsDischarged")) continue;
                throw new CalculateException(CalculateException.WRITEOFF_DISCHARGEVOUCHER_EXIST, new Object[]{rs.getString("fbillnumber")});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        int dischargeType = CalculateUtil.getDischargeType(ctx, companyOrgUnitId);
        if (dischargeType == 0) {
            return;
        }
        bf.setLength(0);
        if (billType.equals("103")) {
            int year = curPeriod.getPeriodYear();
            int period = curPeriod.getPeriodNumber();
            bf.append(" select bill.fid ");
            bf.append(" from t_cl_writeoffgroup bill");
            bf.append(" inner join t_cl_writeoffrecord entry on bill.fid = entry.fparentid");
            bf.append(" inner join t_im_purinwarehsBill purBill on purBill.fid = entry.fbillid");
            bf.append(" where purBill.fid in ").append(billId).append(" and (");
            bf.append(" (bill.FWriteOffYear > " + year + " ) or (bill.FWriteOffYear = " + year + " and bill.FWriteOffPeriod > " + period + " )");
            bf.append(" ) ");
            rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)bf.toString());
            try {
                if (rs.next()) {
                    throw new CalculateException(CalculateException.NOTDEL_HAS_OHTERWRITEOFF);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        ExtendStoreFieldsHandler.storeField((Context)ctx, (String)"B84FB1E2", (IObjectPK[])new IObjectPK[]{pk});
        return pk;
    }

    protected IObjectPK[] _submitBatchData(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        int size = colls.size();
        for (int i = 0; i < size; ++i) {
            WriteOffGroupInfo writeoffgroupinfo = (WriteOffGroupInfo)colls.getObject(i);
            int year = writeoffgroupinfo.getInt("WriteOffYear");
            int period = writeoffgroupinfo.getInt("WriteOffPeriod");
            Iterator it = writeoffgroupinfo.getEntry().iterator();
            while (it.hasNext()) {
                WriteOffRecordInfo info = (WriteOffRecordInfo)it.next();
                info.setWriteOffYear(year);
                info.setWriteOffPeriod(period);
            }
        }
        IObjectPK[] pks = super._submitBatchData(ctx, colls);
        ExtendStoreFieldsHandler.storeField((Context)ctx, (String)"B84FB1E2", (IObjectPK[])pks);
        return pks;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void savePCVoucher(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("bOTRelationInfos.length:" + bOTRelationInfos.size()));
        if (bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        logger.debug((Object)("botRelation.destEntityId:" + botRelation.getDestEntityID()));
        logger.debug((Object)("botRelation.srcEntityId:" + botRelation.getSrcEntityID()));
        String tableName = "T_CL_WriteOffGroup";
        String tempTableName = null;
        try {
            String fvoucherid = "fPCVoucherid";
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                StringBuffer sql = new StringBuffer();
                StringBuffer sqlin = new StringBuffer();
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        sqlin.append(",");
                    }
                    sqlin.append("'").append(bOTRelationInfos.get(i).getSrcObjectID()).append("'");
                }
                sql.append("update ").append(tableName).append(" set ").append(fvoucherid).append(" = null,fPCvouchered = 0 ").append("where ").append("fid in (").append(sqlin).append(")");
                String sqlStr = sql.toString();
                DbUtil.execute((Context)ctx, (String)sqlStr);
            } else {
                StringBuffer createSql = new StringBuffer();
                createSql.append("create table temptable ( FDestBillID varchar(44),FSrcBillID varchar(44) ); ");
                tempTableName = KsqlUtil.createTempTableWithNewTx((Context)ctx, (String)createSql.toString());
                String[] insertSqls = new String[bOTRelationInfos.size()];
                StringBuffer insertSql = new StringBuffer();
                StringBuffer lockPks = new StringBuffer("");
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    lockPks.append("'").append(srcBillId).append("'");
                    lockPks.append(",");
                    insertSql.append(" insert into ").append(tempTableName).append("(FDestBillID,FSrcBillID) values ('").append(destBillId).append("','").append(srcBillId).append("');");
                    insertSqls[i] = insertSql.toString();
                    insertSql.setLength(0);
                }
                if (lockPks.length() > 0) {
                    lockPks.deleteCharAt(lockPks.length() - 1);
                }
                if (BOTBillOperStateEnum.ADDNEW == bOTBillOperStateEnum) {
                    String lockSql = "UPDATE " + tableName + " SET FID = FID WHERE FID IN (" + lockPks.toString() + ")";
                    DbUtil.execute((Context)ctx, (String)lockSql);
                    StringBuffer checkSql = new StringBuffer("");
                    checkSql.append("SELECT fid  FROM ").append(tableName);
                    checkSql.append(" WHERE FID IN (").append(lockPks.toString()).append(") and fPCvouchered = 1");
                    IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                    if (checkResult.next()) {
                        throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK);
                    }
                }
                DBUtil.executeBatch((Context)ctx, (String[])insertSqls);
                HashMap<String, StringBuffer> destSrcIDMap = new HashMap<String, StringBuffer>();
                int size2 = bOTRelationInfos.size();
                for (int i = 0; i < size2; ++i) {
                    String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    if (destSrcIDMap.containsKey(destBillId)) {
                        ((StringBuffer)destSrcIDMap.get(destBillId)).append(",'").append(srcBillId).append("'");
                        continue;
                    }
                    destSrcIDMap.put(destBillId, new StringBuffer("'" + srcBillId + "'"));
                }
                Iterator it = destSrcIDMap.keySet().iterator();
                String[] sqls = new String[destSrcIDMap.keySet().size()];
                StringBuffer sql = new StringBuffer();
                int cnt = 0;
                String destID = null;
                while (it.hasNext()) {
                    sql.setLength(0);
                    destID = (String)it.next();
                    sql.append("update ").append(tableName).append(" set ").append(fvoucherid).append(" = '").append(destID).append("',").append("fPCvouchered =  1 ").append("where ").append("fid in (").append(" select FSrcBillID from ").append(tempTableName).append(" where FDestBillID = '").append(destID).append("'").append(" )");
                    sqls[cnt] = sql.toString();
                    ++cnt;
                }
                DBUtil.executeBatch((Context)ctx, (String[])sqls);
            }
        }
        catch (BOSException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
                catch (Exception e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (!StringUtil.isEmpty(tempTableName)) {
                    KsqlUtil.releaseTempTable((Context)ctx, tempTableName);
                }
                throw throwable;
            }
        }
        if (!StringUtil.isEmpty((String)tempTableName)) {
            KsqlUtil.releaseTempTable((Context)ctx, (String)tempTableName);
        }
        logger.debug((Object)("batchReverseSave spent:" + (System.currentTimeMillis() - t1) + "ms"));
    }

    @Override
    protected Set _getVoucheredIdSet(Context ctx, List idList) throws BOSException, EASBizException {
        IWriteOffGroup iwrite = WriteOffGroupFactory.getLocalInstance(ctx);
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        Iterator idIter = idSet.iterator();
        HashSet<String> srcObjId = new HashSet<String>();
        HashSet<String> voucherIdSet = new HashSet<String>();
        HashSet<String> discharVoucherSet = new HashSet<String>();
        while (idIter.hasNext()) {
            String id = (String)idIter.next();
            ArrayList voucherList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)id, (String)"2652E01E");
            discharVoucherSet.addAll(voucherList);
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(discharVoucherSet);
        if (temp == null || temp.size() <= 0) {
            return srcObjId;
        }
        String voucherIDStr = CollectionUtil.convertList2String(temp, (String)",", (boolean)true);
        sql.append("select fvoucherid from T_IM_PurInWarehsVoucher where fvoucherid in (");
        sql.append(voucherIDStr).append(") and FVoucherType = ").append(String.valueOf(2));
        IRowSet rs = com.kingdee.eas.scm.cal.util.DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        discharVoucherSet.clear();
        try {
            while (rs.next()) {
                discharVoucherSet.add(rs.getString("fvoucherid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (String id : idSet) {
            ArrayList voucherList = BotRelationUtil.getDestObjectIdByDestType((Context)ctx, (String)id, (String)"2652E01E");
            if (voucherList.size() <= 0) continue;
            for (String voucherId : voucherList) {
                if (voucherIdSet.contains(voucherId) || discharVoucherSet.contains(voucherId)) continue;
                voucherIdSet.add(voucherId);
                if (srcObjId.contains(id)) continue;
                srcObjId.add(id);
            }
        }
        return srcObjId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        DAPTransformResult dAPTransformResult;
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            idSet.add(sourceBillPkList[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("companyOrgUnit.id"));
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        WriteOffGroupCollection billConlletion = WriteOffGroupFactory.getLocalInstance(ctx).getWriteOffGroupCollection(view);
        String couId = billConlletion.get(0).getCompanyOrgUnit().getId().toString();
        ArrayList<String> billNumber = new ArrayList<String>();
        ArrayList<String> billId = null;
        try {
            if (CheckVoucherUtil.isCheckVoucherAndCal((Context)ctx)) {
                billId = new ArrayList<String>();
                IRowSet rs = CheckVoucherUtil.checkGenVoucher((Context)ctx, (String)couId, (boolean)true);
                if (rs.size() > 0) {
                    billId.add("1");
                    throw new CalculateException(CalculateException.IS_CALCULATING_EXCEPTION);
                }
                for (int j = 0; j < billConlletion.size(); ++j) {
                    billNumber.add(billConlletion.get(j).getNumber());
                    billId.add((String)billConlletion.get(j).getId());
                }
                CheckVoucherUtil helper = new CheckVoucherUtil();
                String billType = ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"WriteOffRecord", (Locale)ctx.getLocale());
                EJBTransactionProxy.invokeByManual((Object)helper, (String)"insertGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, List.class, String.class, String.class, String.class}, (Object[])new Object[]{ctx, couId, billNumber, billId, billType, ctx.getUserName(), "generate_voucher"}, (int)3);
            }
            dAPTransformResult = super._generateVoucher(ctx, sourceBillPkList, botMappingPK, botpSelectors);
        }
        catch (Throwable throwable) {
            EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, couId, billId, "generate_voucher"}, (int)3);
            throw throwable;
        }
        EJBTransactionProxy.invokeByManual((Object)new CheckVoucherUtil(), (String)"deleteGenVoucher", (Class[])new Class[]{Context.class, String.class, List.class, String.class}, (Object[])new Object[]{ctx, couId, billId, "generate_voucher"}, (int)3);
        return dAPTransformResult;
    }
}

