/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.alter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindRefactorBillInfo;
import com.kingdee.eas.scm.cal.CalculateKindRefactorEntryCollection;
import com.kingdee.eas.scm.cal.app.alter.AlterObject;
import com.kingdee.eas.scm.cal.app.alter.CalculateKindAlterUtil;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public class CalculateKindAlter {
    private static final String Resource = "com.kingdee.eas.scm.cal.CalCommonResource";

    public void changeAccountType(Context context, CalculateKindRefactorBillInfo bill) throws EASBizException, BOSException, SQLException {
        AlterObject param = new AlterObject();
        param.setcompanyID(bill.getCompanyOrgUnit().getId().toString());
        param.setNewAccountType(bill.getNewAccountType().getValue());
        param.setSourceAccountType(bill.getSoureAccountType().getValue());
        param.setYear(bill.getYear());
        param.setPeriod(bill.getPeriod());
        param.setBill((CoreBillBaseInfo)bill);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)context, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)bill.getCompanyOrgUnit());
        if (currentPeriodInfo == null || currentPeriodInfo.getPeriodYear() != bill.getYear() || currentPeriodInfo.getPeriodNumber() != bill.getPeriod()) {
            throw new CalculateException(CalculateException.PERIODNOTEQUAL);
        }
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)context);
        ObjectUuidPK pk = new ObjectUuidPK(param.getcompanyID());
        String calType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_002");
        param.setCalculateKind(Integer.parseInt(calType));
        CalculateKindRefactorEntryCollection entries = bill.getEntry();
        ArrayList<String> materids = new ArrayList<String>();
        ArrayList<BigDecimal> standardCost = new ArrayList<BigDecimal>();
        for (int i = 0; i < entries.size(); ++i) {
            materids.add(entries.get(i).getMaterial().getId().toString());
            standardCost.add(entries.get(i).getNewStandardPrice());
        }
        param.setMateriaIDS(materids.toArray(new String[materids.size()]));
        param.setNewStandardCost(standardCost.toArray(new BigDecimal[standardCost.size()]));
        this.execChangeAccountType(context, param);
    }

    private void execChangeAccountType(Context ctx, AlterObject param) throws EASBizException, BOSException, SQLException {
        switch (param.getSourceAccountType()) {
            case 1: {
                this.execMoveAddAvgToOther(ctx, param);
                break;
            }
            case 2: {
                this.execStandardToOther(ctx, param);
                break;
            }
            case 3: {
                this.execAddAvgToOther(ctx, param);
                break;
            }
            case 5: {
                this.execSpecialToOther(ctx, param);
                break;
            }
            case 4: {
                this.execFifoToOther(ctx, param);
                break;
            }
            case 6: {
                this.execMovingAddAvgToOther(ctx, param);
            }
        }
    }

    private void execMoveAddAvgToOther(Context ctx, AlterObject param) throws BOSException, EASBizException {
        switch (param.getNewAccountType()) {
            case 2: {
                this.execMoveAddAvgToStandArd(ctx, param);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                CalculateKindAlterUtil.delteRecentCost(ctx, param);
                CalculateKindAlterUtil.updateAccountType(ctx, param);
                break;
            }
        }
    }

    private void execMoveAddAvgToStandArd(Context ctx, AlterObject param) throws BOSException, EASBizException {
        boolean success = CalculateKindAlterUtil.isAlterCalculateType(ctx, param);
        boolean isExistCostAdj = CalculateKindAlterUtil.isExistCostAdjust(ctx, param);
        if (success || isExistCostAdj) {
            throw new CalculateException(CalculateException.ALREADYOCCURBIZ);
        }
        CalculateKindAlterUtil.delteRecentCost(ctx, param);
        CalculateKindAlterUtil.updateStandardCost(ctx, param);
        CalculateKindAlterUtil.updateAccountType(ctx, param);
    }

    private void execStandardToOther(Context ctx, AlterObject param) throws BOSException, EASBizException {
        switch (param.getNewAccountType()) {
            case 1: 
            case 3: 
            case 5: 
            case 6: {
                this.execStandardToMovedAddAvg(ctx, param);
                break;
            }
        }
    }

    private void execStandardToMovedAddAvg(Context ctx, AlterObject param) throws BOSException, EASBizException {
        boolean isExistInitBill = CalculateKindAlterUtil.isExistInitBill(ctx, param);
        if (isExistInitBill) {
            throw new CalculateException(CalculateException.ALREADYINITBILL);
        }
        boolean success = CalculateKindAlterUtil.isAlterCalculateType(ctx, param);
        boolean isExistStandard = CalculateKindAlterUtil.existStandAndCostAdjRefcator(ctx, param);
        if (isExistStandard || success) {
            throw new CalculateException(CalculateException.ALREADYOCCURBIZ);
        }
        CalculateKindAlterUtil.inertRecentCost(ctx, param);
        CalculateKindAlterUtil.updateAccountType(ctx, param);
    }

    private void execAddAvgToOther(Context ctx, AlterObject param) throws BOSException, EASBizException {
        switch (param.getNewAccountType()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 6: {
                CalculateKindAlterUtil.updateAccountType(ctx, param);
                break;
            }
            case 5: {
                this.execAddAvgToSpecial(ctx, param);
                break;
            }
        }
    }

    private void execMovingAddAvgToOther(Context ctx, AlterObject param) throws BOSException, EASBizException {
        switch (param.getNewAccountType()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                CalculateKindAlterUtil.updateAccountType(ctx, param);
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                this.execAddAvgToSpecial(ctx, param);
                break;
            }
        }
    }

    private void execAddAvgToSpecial(Context ctx, AlterObject param) throws BOSException, EASBizException {
        CalculateKindAlterUtil.updateAccountType(ctx, param);
    }

    private void execSpecialToOther(Context ctx, AlterObject param) throws BOSException, EASBizException {
        switch (param.getNewAccountType()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 6: {
                this.execSpecialToAddAvg(ctx, param);
                break;
            }
        }
    }

    private void execSpecialToAddAvg(Context ctx, AlterObject param) throws BOSException, EASBizException {
        CalculateKindAlterUtil.updateAccountType(ctx, param);
    }

    private void execFifoToOther(Context ctx, AlterObject param) throws BOSException, EASBizException, SQLException {
        switch (param.getNewAccountType()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                CalculateKindAlterUtil.deleteCalBanalce(ctx, param);
                CalculateKindAlterUtil.updateAccountType(ctx, param);
            }
        }
    }
}

