/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.scm.cal.app.IshareSqlGenerator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbsShareSqlGenerator
implements IshareSqlGenerator {
    private List billHeadTableNameList = null;
    private List billEntryTableNameList = null;
    private List billQueryLock = null;
    private String companyOrgUnitid = null;
    private String storageOrgUnitid = null;
    private String storageOrgUnitids = null;
    private String warehouseStartNumber = null;
    private String warehouseEndNumber = null;
    private String warehouseNumbers = null;
    private String materialStartNumber = null;
    private String materialEndNumber = null;
    private String materialNumbers = null;
    private String extendFields = null;
    private String extendWhereCondition = null;
    private boolean isExtendWhereCondition;
    private boolean isFilterAccountType = false;
    private int accountType;
    private boolean isExtendJoinTable = false;
    private String extendJoinTable = null;
    private String startTranTypeNumber = null;
    private String endTranTypeNumber = null;
    private String transacionTypeNumbers = null;
    private boolean isFilterVouchered = false;
    private boolean isVouchered = false;
    private boolean isFilterIsCalculate = false;
    private boolean isCalcualte = true;
    private boolean isFilterStorage = false;
    private boolean isFilterWarehouse = false;
    private boolean isFilgerBillStatus = true;
    private boolean isFilterCostMove = false;
    private int billStatus = 4;
    private boolean isFilterMaterial = true;
    private String costMaterialRange = null;
    private boolean isFilterMatChange = false;
    private String bizTypeId;
    private final String newline = "\r\n";
    private boolean isFromCostChk = false;
    private int calculateType = -1;
    private boolean isFilterCalculateType = false;
    private boolean isFilterStoreType = false;
    private String[] storeTypes;

    public boolean isFilterCalculateType() {
        return this.isFilterCalculateType;
    }

    public void setIsFilterCalculateType(boolean isFilterCalculateType) {
        this.isFilterCalculateType = isFilterCalculateType;
    }

    public int getCalculateType() {
        return this.calculateType;
    }

    public void setCalculateType(int calculateType) {
        this.calculateType = calculateType;
    }

    public void setIsFromCostChk(boolean value) {
        this.isFromCostChk = true;
    }

    public boolean isFromCostChk() {
        return this.isFromCostChk;
    }

    public void setQueryStorageIds(String storageIds) {
        this.storageOrgUnitids = storageIds;
    }

    public String getQueryStorageIds() {
        return this.storageOrgUnitids;
    }

    public void setQueryWarehsoueNumbers(String warehouseNumbers) {
        this.warehouseNumbers = warehouseNumbers;
    }

    public String getQueryWarehsoueNumbers() {
        return this.warehouseNumbers;
    }

    public String getCostMaterialRange() {
        return this.costMaterialRange;
    }

    public void setCostMaterialRange(String costMaterialRange) {
        this.costMaterialRange = costMaterialRange;
    }

    public AbsShareSqlGenerator() {
        this.initBillHeadTableName();
        this.initBillEntryTableName();
        this.initBillQueryLock();
    }

    private void initBillHeadTableName() {
        this.billHeadTableNameList = new ArrayList();
        this.billHeadTableNameList.add(0, "T_IM_SaleIssueBill");
        this.billHeadTableNameList.add(1, "T_IM_MaterialReqBill");
        this.billHeadTableNameList.add(2, "T_IM_OtherIssueBill");
        this.billHeadTableNameList.add(3, "T_IM_MoveIssueBill");
        this.billHeadTableNameList.add(4, "T_IM_PurInWarehsBill");
        this.billHeadTableNameList.add(5, "T_IM_ManufactureRecBill");
        this.billHeadTableNameList.add(6, "T_IM_OtherInWarehsBill");
        this.billHeadTableNameList.add(7, "T_IM_MoveInWarehsBill");
    }

    private void initBillEntryTableName() {
        this.billEntryTableNameList = new ArrayList();
        this.billEntryTableNameList.add(0, "T_IM_SaleIssueEntry");
        this.billEntryTableNameList.add(1, "T_IM_MaterialReqBillEntry");
        this.billEntryTableNameList.add(2, "T_IM_OtherIssueBillEntry");
        this.billEntryTableNameList.add(3, "T_IM_MoveIssueBillEntry");
        this.billEntryTableNameList.add(4, "T_IM_PurInWarehsEntry");
        this.billEntryTableNameList.add(5, "T_IM_ManufactureRecBillEntry");
        this.billEntryTableNameList.add(6, "T_IM_OtherInWarehsBillEntry");
        this.billEntryTableNameList.add(7, "T_IM_MoveInWarehsBillEntry");
    }

    private void initBillQueryLock() {
        this.billQueryLock = new ArrayList();
        this.billQueryLock.add(0, "SALEISSUE_LOCK");
        this.billQueryLock.add(1, "MATERIALREQ_LOCK");
        this.billQueryLock.add(2, "OTHERISSUE_LOCK");
        this.billQueryLock.add(3, "MOVEISSUE_LOCK");
        this.billQueryLock.add(4, "PURINWAREHS_LOCK");
        this.billQueryLock.add(5, "MANUFACTUREREC_LOCK");
        this.billQueryLock.add(6, "OTHERINWAREHS_LOCK");
        this.billQueryLock.add(7, "MOVEINWAREHS_LOCK");
    }

    @Override
    public String getPurinwarehsbillSql() {
        return this.getShareBillSelectSQL("T_IM_PurInWarehsBill", "T_IM_PurInWarehsEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getManufactureBillSql() {
        return this.getShareBillSelectSQL("T_IM_ManufactureRecBill", "T_IM_ManufactureRecBillEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getOtherInBillSql() {
        return this.getShareBillSelectSQL("T_IM_OtherInWarehsBill", "T_IM_OtherInWarehsBillEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getMoveInBillSql() {
        return this.getShareBillSelectSQL("T_IM_MoveInWarehsBill", "T_IM_MoveInWarehsBillEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getSaleIssueBillSql() {
        return this.getShareBillSelectSQL("T_IM_SaleIssueBill", "T_IM_SaleIssueEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getMaterialReqBillSql() {
        return this.getShareBillSelectSQL("T_IM_MaterialReqBill", "T_IM_MaterialReqBillEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getOtherIssueBillSql() {
        return this.getShareBillSelectSQL("T_IM_OtherIssueBill", "T_IM_OtherIssueBillEntry", this.getExtendFields(), false, -1);
    }

    @Override
    public String getMoveIssueBillSql() {
        return this.getShareBillSelectSQL("T_IM_MoveIssueBill", "T_IM_MoveIssueBillEntry", this.getExtendFields(), false, -1);
    }

    public String getPeriodBeginSql(String extendFields, PeriodInfo period) {
        return this.getPeriodBeginShareSql(extendFields, period);
    }

    public String getCostAdjustBillSql(int costAdjType) {
        return this.getShareBillSelectSQL("T_CL_COSTADJUSTBILL", "T_CL_COSTADJUSTBILLENTRY", this.getExtendFields(), true, costAdjType);
    }

    public String getCostAdjustBillSql(int costAdjType, String extCondition) {
        return this.getShareBillSelectSQL("T_CL_COSTADJUSTBILL", "T_CL_COSTADJUSTBILLENTRY", this.getExtendFields(), true, costAdjType, extCondition);
    }

    public String getStandArdAdjBillSql() {
        return this.getStandardSelectSQL("T_CL_StandardCostAdjBill", "T_CL_StandardCostAdjentry", this.getExtendFields());
    }

    @Override
    public String getInBillSql() {
        int beginBillNumber = 4;
        int endBillNumber = this.getBillHeadTableName().size() - 1;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)this.billHeadTableNameList.get(i), (String)this.billEntryTableNameList.get(i), this.getExtendFields(), false, -1));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    public String getInBillSql(String extent) {
        int beginBillNumber = 4;
        int endBillNumber = this.getBillHeadTableName().size() - 1;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)this.billHeadTableNameList.get(i), (String)this.billEntryTableNameList.get(i), this.getExtendFields(), false, -1, extent));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    public String getInBillSqlForMoveInWarehsbill() {
        int beginBillNumber = 4;
        int endBillNumber = this.getBillHeadTableName().size() - 1;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQLForMoveInWarehsbill((String)this.billHeadTableNameList.get(i), (String)this.billEntryTableNameList.get(i), this.getExtendFields(), false, -1));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    protected String getShareBillSelectSQLForMoveInWarehsbill(String headTableName, String entryTableName, String extendFields, boolean isCostAdjustBill, int costAdjBillType) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
        stringBuffer.append("SELECT ");
        stringBuffer.append("ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID, ");
        stringBuffer.append("ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID, ");
        stringBuffer.append("ENTRY.FWarehouseID AS FWarehouseID, ");
        stringBuffer.append("ENTRY.FMaterialID AS FMaterialID, ");
        stringBuffer.append("MATERIAL.FBaseUnit AS FBaseUnitId, ");
        stringBuffer.append("ENTRY.FAssistPropertyID AS FAssistPropertyID, ");
        stringBuffer.append("ENTRY.FLot AS FLot, ");
        stringBuffer.append("ENTRY.FQty AS FQty, ");
        stringBuffer.append("ENTRY.FBaseQty AS FBaseQty");
        if (isCostAdjustBill) {
            stringBuffer.append(",ENTRY.FActualCost AS FActualCost ");
        } else {
            stringBuffer.append(",\n CASE WHEN MaterialCompanyInfo.FACCOUNTTYPE = 2");
            stringBuffer.append(" THEN ENTRY.FStandardCost ");
            stringBuffer.append(" ELSE ENTRY.FActualCost  END AS FActualCost");
        }
        stringBuffer.append(",ENTRY.FStandardCost AS FStandardCost");
        stringBuffer.append(",TransactionType.FIsCalculate AS FIsCalculate ");
        stringBuffer.append(",BILL.FBizTypeID AS FBizTypeID ");
        if (extendFields != null && extendFields.trim().length() > 0) {
            stringBuffer.append(extendFields);
        }
        stringBuffer.append("\n FROM " + entryTableName + " ENTRY ");
        stringBuffer.append("\n INNER JOIN " + headTableName + " BILL ");
        stringBuffer.append("ON ENTRY.FParentID = BILL.FID ");
        if (this.isFilterCompany() && this.getCompanyOrgUnitid() != null) {
            stringBuffer.append(" INNER JOIN T_ORG_UNITRELATION Relation ON BILL.FSTORAGEORGUNITID = Relation.FFROMUNITID ");
        }
        stringBuffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS  MaterialCompanyInfo");
        stringBuffer.append(" ON (ENTRY.FMaterialID = MaterialCompanyInfo.FMaterialID AND ENTRY.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        stringBuffer.append("\n LEFT JOIN T_SCM_TransactionType AS  TransactionType ");
        stringBuffer.append(" ON TransactionType.FID = BILL.FTransactionTypeID ");
        stringBuffer.append("\n INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID ");
        stringBuffer.append("\n INNER JOIN T_IM_INVUPDATETYPE UPDATETYPE ON ENTRY.FINVUPDATETYPEID  = UPDATETYPE.FID ");
        if (this.isFilterStorage()) {
            stringBuffer.append("\n INNER JOIN T_ORG_Storage STORAGE ");
            stringBuffer.append("\n ON  STORAGE.FID = ENTRY.FStorageOrgUnitID ");
        }
        if (this.isFilterWarehouse()) {
            stringBuffer.append("\n INNER JOIN T_DB_WAREHOUSE WAREHOUSE ");
            stringBuffer.append("\n ON  WAREHOUSE.FID = ENTRY.FWareHouseID ");
        }
        stringBuffer.append("\n WHERE 1=1 ");
        stringBuffer.append(" AND (BILL.FIsInitBill = 0 OR BILL.FIsInitBill IS NULL)");
        if (this.isFilterCompany() && this.getCompanyOrgUnitid() != null) {
            stringBuffer.append("\n AND ENTRY.FCompanyOrgUnitID = '" + this.getCompanyOrgUnitid() + "'");
            stringBuffer.append("\n AND MaterialCompanyInfo.FCompanyID = '" + this.getCompanyOrgUnitid() + "'");
            stringBuffer.append(" AND Relation.FTOUNITID = '" + this.getCompanyOrgUnitid() + "' ");
            stringBuffer.append(" AND Relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5' ");
        }
        stringBuffer.append(this.getStorageAndWarehsFilterRange("ENTRY"));
        if (this.isFilterMaterial() && this.getQueryStrartMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(this.getQueryStrartMaterialNumber()).append("'");
        }
        if (this.isFilterMaterial() && this.getQueryEndMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER <='").append(this.getQueryEndMaterialNumber()).append("'");
        }
        if (this.isFilterStartDate() && this.getQueryStartDate() != null) {
            stringBuffer.append("\n AND  BILL.FBizDate >= TO_DATE('" + format.format((Object)this.getQueryStartDate()) + "')");
        }
        if (this.isFilterEndDate() && this.getQueryEndDate() != null) {
            stringBuffer.append(" AND  BILL.FBizDate <= TO_DATE('" + format.format((Object)this.getQueryEndDate()) + "')");
        }
        if (this.isFilterPeriod() && this.getQueryPeriod() != null) {
            stringBuffer.append("\n AND  BILL.FPeriod = " + this.getQueryPeriod().getPeriodNumber());
            stringBuffer.append(" AND BILL.FYear = " + this.getQueryPeriod().getPeriodYear());
        }
        if (this.isFilterBillstatus()) {
            if (this.getBillStatus() != -1) {
                stringBuffer.append("\n AND BILL.FBaseStatus = " + this.getBillStatus());
            } else {
                stringBuffer.append("\n AND (BILL.FBaseStatus = 2");
                stringBuffer.append(" OR BILL.FBaseStatus = 4");
                stringBuffer.append("\n )");
            }
        }
        if (this.isFilterAccountType()) {
            stringBuffer.append("\n AND MaterialCompanyInfo.FAccountType = " + this.getAccountType());
        }
        if (this.isFilterTranType() && this.getStartTranTypeNumber() != null) {
            stringBuffer.append("\n AND TransactionType.FNUMBER >= '" + this.getStartTranTypeNumber()).append("'");
        }
        if (this.isFilterTranType() && this.getEndTranTypeNumber() != null) {
            stringBuffer.append(" AND TransactionType.FNUMBER <= '" + this.getEndTranTypeNumber()).append("'");
        }
        if (this.isFilterVouchered()) {
            if (this.getIsVouchered()) {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 1");
            } else {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 0");
            }
        }
        if (this.isFilterIsCalculate() && !isCostAdjustBill) {
            if (this.isCalcualte()) {
                stringBuffer.append("\n AND TransactionType.FIsCalculate =1 ");
            } else {
                stringBuffer.append("\n AND TransactionType.FIsCalculate =0 ");
            }
        }
        if (entryTableName != null && "T_IM_PurInWarehsEntry".equals(entryTableName.trim())) {
            stringBuffer.append("\n AND Entry.FWrittenOffQty =0 ");
        }
        if (headTableName != null && "T_IM_OtherInWarehsBill".equals(headTableName.trim())) {
            stringBuffer.append("\n AND bill.FBIZTYPEID <> 'mxmcXEczQ52MGxLV1Oyh9SQHQ1w=' ");
        }
        if (headTableName != null && "T_IM_MoveInWarehsBill".equals(headTableName.trim()) && this.isExtendWhereCondition && this.getExtendWhereCondition() != null) {
            stringBuffer.append("\n AND ( BILL.FBizTypeID <> 'd8e80652-011a-1000-e000-04c5c0a812202407435C' and BILL.FBizTypeID <> 'd8e80652-011b-1000-e000-04c5c0a812202407435C' ) \n and " + this.getExtendWhereCondition());
        } else if (headTableName != null && !"T_IM_MoveInWarehsBill".equals(headTableName.trim()) && this.isExtendWhereCondition && this.getExtendWhereCondition() != null) {
            stringBuffer.append("\n AND " + this.getExtendWhereCondition());
        }
        if (isCostAdjustBill && (costAdjBillType == 0 || costAdjBillType == 1)) {
            stringBuffer.append("\n AND BILL.FCalculateKind=").append(costAdjBillType);
        }
        if (this.getCostMaterialRange() != null && this.getCostMaterialRange().trim().length() > 0) {
            if (this.getCostMaterialRange().equalsIgnoreCase("rawMaterailCostCal")) {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType = ").append(0);
            } else {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType <> ").append(0);
            }
        }
        stringBuffer.append(this.buildStoreTypeWhereSql(entryTableName));
        if (headTableName != null && "T_IM_OtherInWarehsBill".equals(headTableName.trim())) {
            stringBuffer.append("\n AND isnull(BILL.FSourceBillTypeID,'XXX') <> '").append("50957179-0105-1000-e000-888880a812fd463ED552").append("' ");
        }
        return stringBuffer.toString();
    }

    @Override
    public String getOutBillSql() {
        int beginBillNumber = 0;
        int endBillNumber = 3;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)this.billHeadTableNameList.get(i), (String)this.billEntryTableNameList.get(i), this.getExtendFields(), false, -1));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    public String getOutBillSql(String extent) {
        int beginBillNumber = 0;
        int endBillNumber = 3;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)this.billHeadTableNameList.get(i), (String)this.billEntryTableNameList.get(i), this.getExtendFields(), false, -1, extent));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    @Override
    public String getAllBillShareSql() {
        int beginBillNumber = 0;
        int endBillNumber = 7;
        StringBuffer buffer = new StringBuffer();
        for (int i = beginBillNumber; i <= endBillNumber; ++i) {
            buffer.append(this.getShareBillSelectSQL((String)this.billHeadTableNameList.get(i), (String)this.billEntryTableNameList.get(i), this.getExtendFields(), false, -1));
            if (i >= endBillNumber) continue;
            buffer.append("\n UNION ALL \n");
        }
        return buffer.toString();
    }

    public List getBillHeadTableName() {
        return this.billHeadTableNameList;
    }

    public List getBillEntryTableName() {
        return this.billEntryTableNameList;
    }

    public List getBillQueryLock() {
        return this.billQueryLock;
    }

    protected String getShareBillSelectSQL(String headTableName, String entryTableName, String extendFields, boolean isCostAdjustBill, int costAdjBillType) {
        return this.getShareBillSelectSQL(headTableName, entryTableName, extendFields, isCostAdjustBill, costAdjBillType, null);
    }

    protected String getShareBillSelectSQL(String headTableName, String entryTableName, String extendFields, boolean isCostAdjustBill, int costAdjBillType, String extCondition) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
        stringBuffer.append("SELECT ");
        stringBuffer.append("ENTRY.FCompanyOrgUnitID AS FCompanyOrgUnitID, ");
        stringBuffer.append("ENTRY.FStorageOrgUnitID AS FStorageOrgUnitID, ");
        stringBuffer.append("ENTRY.FWarehouseID AS FWarehouseID, ");
        stringBuffer.append("ENTRY.FMaterialID AS FMaterialID, ");
        stringBuffer.append("MATERIAL.FBaseUnit AS FBaseUnitId, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsLot=1 then ENTRY.FLot else null end) AS FLOT, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsAssistProperty=1 then ENTRY.FAssistPropertyID else null end) AS FAssistPropertyID, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsProject=1 and MATERIALINVENTORY.FIsProjectNumber = 1 then ENTRY.FProjectID else null end) AS FProjectID, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsTrackNumber=1 and MATERIALINVENTORY.FIsTrackingNumber = 1 then ENTRY.FTrackNumberID else null end) AS FTrackNumberID, ");
        stringBuffer.append("ENTRY.FQty AS FQty, ");
        stringBuffer.append("ENTRY.FBaseQty AS FBaseQty");
        if (isCostAdjustBill) {
            stringBuffer.append(",ENTRY.FActualCost AS FActualCost ");
        } else {
            stringBuffer.append(",\n CASE WHEN MaterialCompanyInfo.FACCOUNTTYPE = 2");
            stringBuffer.append(" THEN ENTRY.FStandardCost ");
            stringBuffer.append(" ELSE ENTRY.FActualCost  END AS FActualCost");
        }
        stringBuffer.append(",ENTRY.FStandardCost AS FStandardCost");
        stringBuffer.append(",TransactionType.FIsCalculate AS FIsCalculate ");
        stringBuffer.append(",BILL.FBizTypeID AS FBizTypeID ");
        if (extendFields != null && extendFields.trim().length() > 0) {
            stringBuffer.append(extendFields);
        }
        stringBuffer.append("\n FROM " + entryTableName + " ENTRY ");
        stringBuffer.append("\n INNER JOIN " + headTableName + " BILL ");
        stringBuffer.append("ON ENTRY.FParentID = BILL.FID ");
        if (this.isFilterCompany() && this.getCompanyOrgUnitid() != null) {
            stringBuffer.append("\n INNER JOIN T_ORG_UNITRELATION Relation ON BILL.FSTORAGEORGUNITID = Relation.FFROMUNITID");
        }
        stringBuffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS  MaterialCompanyInfo");
        stringBuffer.append(" ON (ENTRY.FMaterialID = MaterialCompanyInfo.FMaterialID AND ENTRY.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        stringBuffer.append("\n INNER JOIN T_BD_MaterialInventory as MATERIALINVENTORY ");
        stringBuffer.append(" ON (ENTRY.FMaterialID = MATERIALINVENTORY.FMaterialID AND ENTRY.FStorageOrgUnitID = MATERIALINVENTORY.FOrgUnit )");
        stringBuffer.append("\n LEFT JOIN T_SCM_TransactionType AS  TransactionType ");
        stringBuffer.append(" ON TransactionType.FID = BILL.FTransactionTypeID ");
        stringBuffer.append("\n INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID ");
        if (this.isFilterStorage()) {
            stringBuffer.append("\n INNER JOIN T_ORG_Storage STORAGE ");
            stringBuffer.append("\n ON  STORAGE.FID = ENTRY.FStorageOrgUnitID ");
        }
        if (this.isFilterWarehouse()) {
            stringBuffer.append("\n INNER JOIN T_DB_WAREHOUSE WAREHOUSE ");
            stringBuffer.append("\n ON  WAREHOUSE.FID = ENTRY.FWareHouseID ");
        }
        stringBuffer.append("\n WHERE 1=1 ");
        stringBuffer.append(" AND (BILL.FIsInitBill = 0 OR BILL.FIsInitBill IS NULL)");
        if (this.isFilterCompany() && this.getCompanyOrgUnitid() != null) {
            stringBuffer.append("\n AND ENTRY.FCompanyOrgUnitID = '" + this.getCompanyOrgUnitid() + "'");
            stringBuffer.append("\n AND MaterialCompanyInfo.FCompanyID = '" + this.getCompanyOrgUnitid() + "'");
            stringBuffer.append(" AND Relation.FTOUNITID = '" + this.getCompanyOrgUnitid() + "' ");
            stringBuffer.append(" AND Relation.FTYPERELATIONID = '00000000-0000-0000-0000-0000000000070FE9F8B5' ");
        }
        stringBuffer.append(this.getStorageAndWarehsFilterRange("ENTRY"));
        if (this.isFilterMaterial() && this.getQueryStrartMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(this.getQueryStrartMaterialNumber()).append("'");
        }
        if (this.isFilterMaterial() && this.getQueryEndMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER <='").append(this.getQueryEndMaterialNumber()).append("'");
        }
        if (this.isFilterStartDate() && this.getQueryStartDate() != null) {
            stringBuffer.append("\n AND  BILL.FBizDate >= TO_DATE('" + format.format((Object)this.getQueryStartDate()) + "')");
        }
        if (this.isFilterEndDate() && this.getQueryEndDate() != null) {
            stringBuffer.append(" AND  BILL.FBizDate <= TO_DATE('" + format.format((Object)this.getQueryEndDate()) + "')");
        }
        if (this.isFilterPeriod() && this.getQueryPeriod() != null) {
            stringBuffer.append("\n AND  BILL.FPeriod = " + this.getQueryPeriod().getPeriodNumber());
            stringBuffer.append(" AND BILL.FYear = " + this.getQueryPeriod().getPeriodYear());
        }
        if (this.isFilterBillstatus()) {
            if (this.getBillStatus() != -1) {
                stringBuffer.append("\n AND BILL.FBaseStatus = " + this.getBillStatus());
            } else {
                stringBuffer.append("\n AND (BILL.FBaseStatus = 2");
                stringBuffer.append(" OR BILL.FBaseStatus = 4");
                stringBuffer.append("\n )");
            }
        }
        if (this.isFilterAccountType()) {
            stringBuffer.append("\n AND MaterialCompanyInfo.FAccountType = " + this.getAccountType());
        }
        if (this.isFilterTranType() && this.getStartTranTypeNumber() != null) {
            stringBuffer.append("\n AND TransactionType.FNUMBER >= '" + this.getStartTranTypeNumber()).append("'");
        }
        if (this.isFilterTranType() && this.getEndTranTypeNumber() != null) {
            stringBuffer.append(" AND TransactionType.FNUMBER <= '" + this.getEndTranTypeNumber()).append("'");
        }
        if (this.isFilterVouchered()) {
            if (this.getIsVouchered()) {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 1");
            } else {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 0");
            }
        }
        if (this.getCostMaterialRange() != null && this.getCostMaterialRange().trim().length() > 0) {
            if (this.getCostMaterialRange().equalsIgnoreCase("rawMaterailCostCal")) {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType = ").append(0);
            } else {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType <> ").append(0);
            }
        }
        if (this.isFilterIsCalculate() && !isCostAdjustBill) {
            if (this.isCalcualte()) {
                stringBuffer.append("\n AND TransactionType.FIsCalculate =1 ");
            } else {
                stringBuffer.append("\n AND TransactionType.FIsCalculate =0");
            }
        }
        if (this.isExtendWhereCondition && this.getExtendWhereCondition() != null) {
            stringBuffer.append("\n AND " + this.getExtendWhereCondition());
        }
        if (isCostAdjustBill && (costAdjBillType == 0 || costAdjBillType == 1)) {
            stringBuffer.append("\n AND BILL.FCalculateKind=").append(costAdjBillType);
        }
        if (this.isFilterCostMove() && (this.billHeadTableNameList.get(7).equals(headTableName) || this.billHeadTableNameList.get(3).equals(headTableName))) {
            stringBuffer.append("\n and BILL.FBizTypeID NOT IN (");
            stringBuffer.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
            stringBuffer.append(" ,'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
            stringBuffer.append(")");
        }
        if (this.isFilterCostMove() && this.billEntryTableNameList.get(6).equals(entryTableName)) {
            stringBuffer.append("\n AND BILL.FBizTypeID NOT IN (");
            stringBuffer.append(" '").append("kXeVPjHuchDgQKjAYj1RYCQHQ1w=").append("'");
            stringBuffer.append(" ,'").append("kXeVPjF4chDgQKjAYj1RYCQHQ1w=").append("'");
            stringBuffer.append(" ,'").append("kXeVPjGzchDgQKjAYj1RYCQHQ1w=").append("'");
            stringBuffer.append(" ,'").append("kXeUoXWkByTgQKjAYj1F6CQHQ1w=").append("'");
            stringBuffer.append(" ,'").append("kXeUoXXfByTgQKjAYj1F6CQHQ1w=").append("'");
            stringBuffer.append(")");
        }
        if (this.getCostMaterialRange() != null && this.getCostMaterialRange().trim().length() > 0) {
            if (this.getCostMaterialRange().equalsIgnoreCase("rawMaterailCostCal")) {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType = ").append(0);
            } else {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType <> ").append(0);
            }
        }
        if (extCondition != null) {
            stringBuffer.append("\n ").append(extCondition);
        }
        return stringBuffer.toString();
    }

    private String getPeriodBeginShareSql(String extendFields, PeriodInfo periodInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" SELECT ");
        stringBuffer.append("INVENTORYBALANCE.FID, ");
        stringBuffer.append("INVENTORYBALANCE.FCompanyOrgUnitID, ");
        stringBuffer.append("INVENTORYBALANCE.FStorageOrgUnitID, ");
        stringBuffer.append("MATERIAL.FBaseUnit as FBaseUnitId, ");
        stringBuffer.append("INVENTORYBALANCE.FMaterialID, ");
        stringBuffer.append("INVENTORYBALANCE.FWarehouseID, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsLot=1 then INVENTORYBALANCE.FLot else null end) AS FLOT, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsAssistProperty=1 then INVENTORYBALANCE.FAssistPropertyID else null end) AS FAssistPropertyID, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsProject=1 and MATERIALINVENTORY.FIsProjectNumber = 1 then INVENTORYBALANCE.FProjectID else null end) AS FProjectID, ");
        stringBuffer.append("(case when MaterialCompanyInfo.FAccountType=").append(5).append(" and MaterialCompanyInfo.FIsTrackNumber=1 and MATERIALINVENTORY.FIsTrackingNumber = 1 then INVENTORYBALANCE.FTrackNumberID else null end) AS FTrackNumberID, ");
        stringBuffer.append("INVENTORYBALANCE.FPeriodBeginQty AS FBASEQTY, ");
        stringBuffer.append("INVENTORYBALANCE.FPeriodBeginAssistQty, ");
        stringBuffer.append("INVENTORYBALANCE.FPeriodBeginBalance FACTUALCOST, ");
        stringBuffer.append("INVENTORYBALANCE.FPeriodBeginCostDiff ");
        if (extendFields != null && extendFields.trim().length() > 0) {
            stringBuffer.append(",").append(extendFields);
        }
        stringBuffer.append("\n FROM T_IM_INVENTORYBALANCE INVENTORYBALANCE ");
        stringBuffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS  MaterialCompanyInfo");
        stringBuffer.append(" ON (INVENTORYBALANCE.FMaterialID = MaterialCompanyInfo.FMaterialID AND INVENTORYBALANCE.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        stringBuffer.append("\n INNER JOIN T_BD_MaterialInventory AS MATERIALINVENTORY");
        stringBuffer.append(" ON (INVENTORYBALANCE.FMaterialID = MATERIALINVENTORY.FMaterialID AND INVENTORYBALANCE.FStorageOrgUnitID = MATERIALINVENTORY.FOrgUnit )");
        stringBuffer.append("\n INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = INVENTORYBALANCE.FMATERIALID ");
        if (this.isFilterStorage()) {
            stringBuffer.append("\n INNER JOIN T_ORG_Storage STORAGE ");
            stringBuffer.append("\n ON  STORAGE.FID = INVENTORYBALANCE.FStorageOrgUnitID ");
        }
        if (this.isFilterWarehouse()) {
            stringBuffer.append("\n INNER JOIN T_DB_WAREHOUSE WAREHOUSE ");
            stringBuffer.append("\n ON WAREHOUSE.FID = INVENTORYBALANCE.FWareHouseID ");
        }
        if (this.isExtendJoinTable() && this.getExtendJoinTable() != null) {
            stringBuffer.append(this.getExtendJoinTable());
        }
        stringBuffer.append("\n WHERE 1=1 ");
        if (this.isFilterCompany() && this.getCompanyOrgUnitid() != null) {
            stringBuffer.append("\n AND INVENTORYBALANCE.FCompanyOrgUnitID = '" + this.getCompanyOrgUnitid() + "'");
            stringBuffer.append("\n AND MaterialCompanyInfo.FCompanyID = '" + this.getCompanyOrgUnitid() + "'");
        }
        stringBuffer.append(this.getStorageAndWarehsFilterRange("INVENTORYBALANCE"));
        if (this.isFilterMaterial() && this.getQueryStrartMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(this.getQueryStrartMaterialNumber()).append("'");
        }
        if (this.isFilterMaterial() && this.getQueryEndMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER <='").append(this.getQueryEndMaterialNumber()).append("'");
        }
        if (this.isFilterAccountType()) {
            stringBuffer.append(" AND MaterialCompanyInfo.FAccountType = " + this.getAccountType());
        }
        if (this.isExtendWhereCondition && this.getExtendWhereCondition() != null) {
            stringBuffer.append("\n AND " + this.getExtendWhereCondition());
        }
        stringBuffer.append("\n AND INVENTORYBALANCE.FPeriod = " + this.getQueryPeriod().getPeriodNumber());
        stringBuffer.append(" AND INVENTORYBALANCE.FYear = " + this.getQueryPeriod().getPeriodYear());
        stringBuffer.append("\n AND (INVENTORYBALANCE.FISCALCULATE = 1 OR INVENTORYBALANCE.FMoveType IN (1, 2))");
        stringBuffer.append(" AND INVENTORYBALANCE.FStoreTypeId IN (").append("\r\n");
        stringBuffer.append(" '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("',").append("\r\n");
        stringBuffer.append(" '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',").append("\r\n");
        stringBuffer.append(" '").append("181875d5-0105-1000-e000-0123c0a812fd97D461A6").append("')");
        return stringBuffer.toString();
    }

    protected String getStandardSelectSQL(String headTableName, String entryTableName, String extendFields) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-hh-mm-ss");
        stringBuffer.append("SELECT ");
        stringBuffer.append("BILL.FCompanyOrgUnitID AS FCompanyOrgUnitID, ");
        stringBuffer.append("NULL AS FStorageOrgUnitID, ");
        stringBuffer.append("NULL AS FWarehouseID, ");
        stringBuffer.append("ENTRY.FMaterialID AS FMaterialID, ");
        stringBuffer.append("MATERIAL.FBaseUnit AS FBaseUnitId, ");
        stringBuffer.append("NULL AS FLot, ");
        stringBuffer.append("NULL AS FAssistPropertyID, ");
        stringBuffer.append("NULL AS FProjectID, ");
        stringBuffer.append("NULL AS FTrackNumberID, ");
        stringBuffer.append("0 AS FQty, ");
        stringBuffer.append("0 AS FBaseQty");
        stringBuffer.append(",0 AS FActualCost ");
        stringBuffer.append(",ENTRY.fnewstandardamount AS FStandardCost");
        stringBuffer.append(",1 AS FIsCalculate ");
        stringBuffer.append(",null AS FBizTypeID ");
        if (extendFields != null && extendFields.trim().length() > 0) {
            stringBuffer.append(extendFields);
        }
        stringBuffer.append("\n FROM " + entryTableName + " ENTRY ");
        stringBuffer.append("\n INNER JOIN " + headTableName + " BILL ");
        stringBuffer.append("ON ENTRY.FParentID = BILL.FID ");
        stringBuffer.append("\n INNER JOIN T_BD_MaterialCompanyInfo AS  MaterialCompanyInfo");
        stringBuffer.append(" ON (ENTRY.FMaterialID = MaterialCompanyInfo.FMaterialID AND bill.FCompanyOrgUnitID = MaterialCompanyInfo.FCompanyID)");
        stringBuffer.append("\n INNER JOIN T_BD_Material MATERIAL ON MATERIAL.FID = ENTRY.FMATERIALID ");
        stringBuffer.append("\n WHERE 1=1 ");
        if (this.isFilterCompany() && this.getCompanyOrgUnitid() != null) {
            stringBuffer.append("\n AND MaterialCompanyInfo.FCompanyID = '" + this.getCompanyOrgUnitid() + "'");
        }
        if (this.isFilterMaterial() && this.getQueryStrartMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER >='").append(this.getQueryStrartMaterialNumber()).append("'");
        }
        if (this.isFilterMaterial() && this.getQueryEndMaterialNumber() != null) {
            stringBuffer.append("\n AND MATERIAL.FNUMBER <='").append(this.getQueryEndMaterialNumber()).append("'");
        }
        if (this.isFilterStartDate() && this.getQueryStartDate() != null) {
            stringBuffer.append("\n AND  BILL.FBizDate >= TO_DATE('" + format.format((Object)this.getQueryStartDate()) + "')");
        }
        if (this.isFilterEndDate() && this.getQueryEndDate() != null) {
            stringBuffer.append(" AND  BILL.FBizDate <= TO_DATE('" + format.format((Object)this.getQueryEndDate()) + "')");
        }
        if (this.isFilterPeriod() && this.getQueryPeriod() != null) {
            stringBuffer.append("\n AND  ENTRY.FBizDate >= TO_DATE('" + this.getQueryPeriod().getBeginDate()).append("')");
            stringBuffer.append(" AND ENTRY.FBizDate <= TO_DATE('" + this.getQueryPeriod().getEndDate()).append("')");
        }
        if (this.isFilterBillstatus()) {
            if (this.getBillStatus() != -1) {
                stringBuffer.append("\n AND BILL.FBaseStatus = " + this.getBillStatus());
            } else {
                stringBuffer.append("\n AND (BILL.FBaseStatus = 2");
                stringBuffer.append(" OR BILL.FBaseStatus = 4");
                stringBuffer.append("\n )");
            }
        }
        if (this.getCostMaterialRange() != null && this.getCostMaterialRange().trim().length() > 0) {
            if (this.getCostMaterialRange().equalsIgnoreCase("rawMaterailCostCal")) {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType = ").append(0);
            } else {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType <> ").append(0);
            }
        }
        if (this.isFilterAccountType()) {
            stringBuffer.append("\n AND MaterialCompanyInfo.FAccountType = " + this.getAccountType());
        }
        if (this.isFilterVouchered()) {
            if (this.getIsVouchered()) {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 1");
            } else {
                stringBuffer.append("\n AND BILL.FFIVOUCHERED = 0");
            }
        }
        if (this.isExtendWhereCondition && this.getExtendWhereCondition() != null) {
            stringBuffer.append("\n AND " + this.getExtendWhereCondition());
        }
        if (this.getCostMaterialRange() != null && this.getCostMaterialRange().trim().length() > 0) {
            if (this.getCostMaterialRange().equalsIgnoreCase("rawMaterailCostCal")) {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType = ").append(0);
            } else {
                stringBuffer.append(" AND MaterialCompanyInfo.FCalculateType <> ").append(0);
            }
        }
        return stringBuffer.toString();
    }

    private String getStorageAndWarehsFilterRange(String entryTable) {
        StringBuffer sql = new StringBuffer();
        if (!this.isFromCostChk()) {
            if (this.isFilterStorage() && this.getQueryStorageId() != null) {
                sql.append("\n AND ").append(entryTable).append(".FStorageOrgUnitID ='").append(this.getQueryStorageId()).append("'");
            }
            if (this.isFilterWarehouse() && this.getQueryStartWarehsoueNumber() != null) {
                sql.append("\n AND WAREHOUSE.FNUMBER >='").append(this.getQueryStartWarehsoueNumber()).append("'");
            }
            if (this.isFilterWarehouse() && this.getQueryEndWarehsoueNumber() != null) {
                sql.append("\n AND WAREHOUSE.FNUMBER <='").append(this.getQueryEndWarehsoueNumber()).append("'");
            }
        } else {
            if (this.isFilterStorage() && this.getQueryStorageIds() != null) {
                sql.append("\n AND ").append(entryTable).append(".FStorageOrgUnitID in ").append(this.getQueryStorageIds());
            }
            if (this.isFilterWarehouse() && this.getQueryWarehsoueNumbers() != null) {
                sql.append("\n AND WAREHOUSE.FID in ").append(this.getQueryWarehsoueNumbers());
            }
        }
        return sql.toString();
    }

    public boolean isFilterCompany() {
        return true;
    }

    public boolean isFilterBillstatus() {
        return this.isFilgerBillStatus;
    }

    public void setFilterBillstatus(boolean isFilter) {
        this.isFilgerBillStatus = isFilter;
    }

    public boolean isFilterPeriod() {
        return true;
    }

    public boolean isFilterStartDate() {
        return false;
    }

    public boolean isFilterEndDate() {
        return false;
    }

    public boolean isFilterStorage() {
        return this.isFilterStorage;
    }

    public void setIsFilterStorage(boolean value) {
        this.isFilterStorage = value;
    }

    public boolean isFilterWarehouse() {
        return this.isFilterWarehouse;
    }

    public void setIsFilterWarehouse(boolean value) {
        this.isFilterWarehouse = value;
    }

    public boolean isFilterMaterial() {
        return this.isFilterMaterial;
    }

    public void setIsFilterMaterial(boolean isFilter) {
        this.isFilterMaterial = isFilter;
    }

    public void setCompanyOrgUnitId(String companyid) {
        this.companyOrgUnitid = companyid;
    }

    public String getCompanyOrgUnitid() {
        return this.companyOrgUnitid;
    }

    public int getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(int billStatus) {
        this.billStatus = billStatus;
    }

    public void setQueryStorageId(String storageId) {
        this.storageOrgUnitid = storageId;
    }

    public String getQueryStorageId() {
        return this.storageOrgUnitid;
    }

    public boolean isFilterAccountType() {
        return this.isFilterAccountType;
    }

    public void setFilterAccountType(boolean isFilterAccountType) {
        this.isFilterAccountType = isFilterAccountType;
    }

    public boolean isFilterStartWarehouseNumber() {
        return false;
    }

    public boolean isFilterEndWarehouseNumber() {
        return false;
    }

    public boolean isFilterStartMaterialNumber() {
        return false;
    }

    public boolean isFilterEndMaterialNumber() {
        return false;
    }

    public String getQueryStartWarehsoueNumber() {
        return this.warehouseStartNumber;
    }

    public String getQueryEndWarehsoueNumber() {
        return this.warehouseEndNumber;
    }

    public void setQueryStartWarehsoueNumber(String warehouseNumber) {
        this.warehouseStartNumber = warehouseNumber;
    }

    public void setQueryEndWarehsoueNumber(String warehouseNumber) {
        this.warehouseEndNumber = warehouseNumber;
    }

    public String getQueryStrartMaterialNumber() {
        return this.materialStartNumber;
    }

    public String getQueryEndMaterialNumber() {
        return this.materialEndNumber;
    }

    public void setQueryStartMaterialNumber(String materialNumber) {
        this.materialStartNumber = materialNumber;
    }

    public void setQueryEndMaterialNumber(String materialNumber) {
        this.materialEndNumber = materialNumber;
    }

    public abstract PeriodInfo getQueryPeriod();

    public abstract Date getQueryStartDate();

    public abstract Date getQueryEndDate();

    public String getExtendFields() {
        return this.extendFields;
    }

    public void setExtendFields(String extendFields) {
        this.extendFields = extendFields;
    }

    public String getExtendWhereCondition() {
        return this.extendWhereCondition;
    }

    public void setExtendWhereCondition(String extendWhereCondition) {
        this.extendWhereCondition = extendWhereCondition;
    }

    public boolean isExtendWhereCondition() {
        return this.isExtendWhereCondition;
    }

    public void setExtendWhereCondition(boolean isExtendWhereCondition) {
        this.isExtendWhereCondition = isExtendWhereCondition;
    }

    public int getAccountType() {
        return this.accountType;
    }

    public void setAccountType(int accountType) {
        this.accountType = accountType;
    }

    public String getExtendJoinTable() {
        return this.extendJoinTable;
    }

    public void setExtendJoinTable(String extendJoinTable) {
        this.extendJoinTable = extendJoinTable;
    }

    public boolean isExtendJoinTable() {
        return this.isExtendJoinTable;
    }

    public void setExtendJoinTable(boolean isExtendJoinTable) {
        this.isExtendJoinTable = isExtendJoinTable;
    }

    public boolean isFilterTranType() {
        return true;
    }

    public String getEndTranTypeNumber() {
        return this.endTranTypeNumber;
    }

    public void setEndTranTypeNumber(String endTranTypeNumber) {
        this.endTranTypeNumber = endTranTypeNumber;
    }

    public String getStartTranTypeNumber() {
        return this.startTranTypeNumber;
    }

    public void setStartTranTypeNumber(String startTranTypeNumber) {
        this.startTranTypeNumber = startTranTypeNumber;
    }

    public boolean isFilterVouchered() {
        return this.isFilterVouchered;
    }

    public void setisFilterVouchered(boolean isFilterVouchered) {
        this.isFilterVouchered = isFilterVouchered;
    }

    public boolean getIsVouchered() {
        return this.isVouchered;
    }

    public void setIsVouchered(boolean vouchered) {
        this.isVouchered = vouchered;
    }

    public boolean isCalcualte() {
        return this.isCalcualte;
    }

    public void setCalcualte(boolean isCalcualte) {
        this.isCalcualte = isCalcualte;
    }

    public boolean isFilterIsCalculate() {
        return this.isFilterIsCalculate;
    }

    public void setFilterIsCalculate(boolean isFilterIsCalculate) {
        this.isFilterIsCalculate = isFilterIsCalculate;
    }

    public boolean isFilterCostMove() {
        return this.isFilterCostMove;
    }

    public void setFilterCostMove(boolean isFilterCostMove) {
        this.isFilterCostMove = isFilterCostMove;
    }

    private String buildStoreTypeWhereSql(String entryTable) {
        StringBuffer retStr = new StringBuffer();
        String storeType = null;
        storeType = "T_IM_PurInWarehsEntry".equalsIgnoreCase(entryTable) || "T_IM_ManufactureRecBillEntry".equalsIgnoreCase(entryTable) || "T_IM_OtherInWarehsBillEntry".equalsIgnoreCase(entryTable) || "T_IM_MoveInWarehsBillEntry".equalsIgnoreCase(entryTable) ? " UPDATETYPE.FStoreTypeId " : " UPDATETYPE.FStoreTypePreID ";
        retStr.append(" AND " + storeType + " IN (").append("\r\n");
        retStr.append(" '").append("181875d5-0105-1000-e000-0111c0a812fd97D461A6").append("',").append("\r\n");
        retStr.append(" '").append("181875d5-0105-1000-e000-011ac0a812fd97D461A6").append("',").append("\r\n");
        retStr.append(" '").append("181875d5-0105-1000-e000-0123c0a812fd97D461A6").append("') ").append("\r\n");
        return retStr.toString();
    }

    public boolean isFilterMatChange() {
        return this.isFilterMatChange;
    }

    public void setFilterMatChange(boolean isFilterMatChange) {
        this.isFilterMatChange = isFilterMatChange;
    }

    public String[] getStoreTypes() {
        return this.storeTypes;
    }

    public void setStoreTypes(String[] storeTypes) {
        this.storeTypes = storeTypes;
    }

    public boolean isFilterStoreType() {
        return this.isFilterStoreType;
    }

    public void setIsFilterStoreType(boolean isFilterStoreType) {
        this.isFilterStoreType = isFilterStoreType;
    }

    public String getMaterialNumbers() {
        return this.materialNumbers;
    }

    public void setMaterialNumbers(String materialNumbers) {
        this.materialNumbers = materialNumbers;
    }

    public String getTransacionTypeNumbers() {
        return this.transacionTypeNumbers;
    }

    public void setTransacionTypeNumbers(String transacionTypeNumbers) {
        this.transacionTypeNumbers = transacionTypeNumbers;
    }

    public String getBizTypeId() {
        return this.bizTypeId;
    }

    public void setBizTypeId(String bizTypeId) {
        this.bizTypeId = bizTypeId;
    }
}

