/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffGroup;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffHashMap;
import com.kingdee.eas.scm.cal.app.newutil.WriteOffHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractArApCalculate
extends AbstractCalculate {
    @Override
    protected void init(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        super.init(ctx, scminfo);
    }

    @Override
    protected CompanyOrgUnitInfo takeFinanceOrg(Context ctx, CoreBillBaseInfo scminfo) throws EASBizException, BOSException {
        return ((BillBaseInfo)scminfo).getCompany();
    }

    protected OrgUnitInfo takeMasterBizOrg(Context ctx, CoreBillBaseInfo scminfo) throws EASBizException, BOSException {
        return ((BillBaseInfo)scminfo).getCompany();
    }

    protected void calculateBillWrittenOff(Context ctx, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, WriteOffGroupInfo writeoffgroupinfo) throws EASBizException, BOSException {
        Map.Entry mapBill;
        Iterator it;
        if (entry.getUnWriteOffQty().compareTo(CalConstant.ZERO) == 0) {
            return;
        }
        BigDecimal writeOffQtyTotal = CalConstant.ZERO.setScale(entry.getBaseUnitQty().scale());
        BigDecimal writeOffSumInvoTotal = CalConstant.ZERO.setScale(entry.getAmount().scale());
        BigDecimal[] writeOffQtyAndAmount = new BigDecimal[]{writeOffQtyTotal, writeOffSumInvoTotal};
        boolean isFullWriteOff = false;
        CalculateWrittenOffBill invBill = null;
        CalculateWrittenOffGroup billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(entry.getSourceIDKey());
        if (billMap != null && !billMap.isEmpty()) {
            it = billMap.entrySet().iterator();
            mapBill = null;
            while (it.hasNext()) {
                mapBill = it.next();
                invBill = (CalculateWrittenOffBill)mapBill.getValue();
                isFullWriteOff = this.writeOffBill(ctx, invBill, bill, entry, writeoffgroupinfo, writeOffQtyAndAmount);
            }
        }
        if ((billMap = (CalculateWrittenOffGroup)writeOffBillMap.get(entry.getCoreIDKey())) != null && !billMap.isEmpty()) {
            it = billMap.entrySet().iterator();
            mapBill = null;
            while (it.hasNext()) {
                mapBill = it.next();
                invBill = (CalculateWrittenOffBill)mapBill.getValue();
                isFullWriteOff = this.writeOffBill(ctx, invBill, bill, entry, writeoffgroupinfo, writeOffQtyAndAmount);
            }
        }
        if (isFullWriteOff) {
            writeOffQtyAndAmount[0] = entry.getBaseUnitQty();
            writeOffQtyAndAmount[1] = entry.getAmount();
        }
        WriteOffHelper.createWrittenOffRecord(ctx, writeoffgroupinfo, writeOffQtyAndAmount[0], writeOffQtyAndAmount[1], entry.getBaseUnitPrice(), bill, entry, bill.getPaymentType());
        this.turnOverNoteWriteOffInfo(ctx, entry);
    }

    protected boolean writeOffBill(Context ctx, CalculateWrittenOffBill invbill, CalculateWrittenOffBill apBill, CalculateWrittenOffEntry entry, WriteOffGroupInfo writeoffgroupinfo, BigDecimal[] writeOffQtyAndAmount) throws EASBizException, BOSException {
        boolean isFullWriteOff = false;
        ArrayList entrys = invbill.getEntry();
        if (entrys == null || entrys.size() == 0) {
            return isFullWriteOff;
        }
        List entryList = this.getEntryByEntryId(invbill, entry.getSourceBillEntryId());
        if (entryList == null || entryList.size() == 0) {
            entryList = this.getEntryByCoreEntryId(invbill, entry.getOrderBillEntryId());
        }
        if (entryList == null) {
            return isFullWriteOff;
        }
        for (int i = 0; i < entryList.size(); ++i) {
            CalculateWrittenOffEntry invEntry = (CalculateWrittenOffEntry)entryList.get(i);
            isFullWriteOff = this.writeOffEntry(ctx, entry, invEntry, invbill, writeoffgroupinfo, apBill, writeOffQtyAndAmount);
        }
        return isFullWriteOff;
    }

    protected boolean isBillUnWriteOff(Context ctx, CalculateWrittenOffBill invbill) throws BOSException {
        boolean isBillUnWriteOff = false;
        if ("t_im_purinwarehsentry".equals(this.destEntryTableName)) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select sum(abs(isnull(fwrittenOffQty,0))) as sum_wfQty from t_im_purinwarehsentry where fparentid = '").append(invbill.getId()).append("'");
            try {
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs.next()) {
                    isBillUnWriteOff = CalConstant.ZERO.compareTo(rs.getBigDecimal("sum_wfQty")) == 0;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isBillUnWriteOff;
    }

    protected boolean hasMoveMateiral(Context ctx, CalculateWrittenOffBill invbill) throws BOSException {
        boolean hasMoveMateiral = false;
        if ("t_im_purinwarehsentry".equals(this.destEntryTableName)) {
            StringBuffer sql = new StringBuffer();
            sql.append(" select 1 from t_im_purinwarehsentry entry INNER JOIN t_bd_materialcompanyinfo mcom ");
            sql.append(" ON entry.FMaterialID = mcom.FMaterialID and entry.FCompanyOrgUnitID = mcom.FCompanyID");
            sql.append(" WHERE mcom.FAccountType = 1 and entry.FParentid = '").append(invbill.getId()).append("'");
            try {
                IRowSet result = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (result.next()) {
                    hasMoveMateiral = true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return hasMoveMateiral;
    }

    protected abstract boolean writeOffEntry(Context var1, CalculateWrittenOffEntry var2, CalculateWrittenOffEntry var3, CalculateWrittenOffBill var4, WriteOffGroupInfo var5, CalculateWrittenOffBill var6, BigDecimal[] var7) throws EASBizException, BOSException;

    @Override
    protected String getKeyValue(List idList, ResultSet rs, boolean isTakeInvSrcBill) throws SQLException {
        String billId = rs.getString("fid");
        String coreBillId = rs.getString("fcoreBillId");
        String key = idList.contains(billId) ? "SRC_" + billId : "CORE_" + coreBillId;
        return key;
    }

    public void takeSQLSourceBill(Context ctx, String tableName, StringBuffer selectSQL, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill writtenOffBill) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer(selectSQL);
        sql.append(" where Bill.FID = '").append(writtenOffBill.getSourceBillId()).append("'");
        sql.append(" order by Entry.FSeq");
        this.buildBillMap(ctx, tableName, sql, writeOffBillMap, writtenOffBill);
    }

    protected void buildBillMap(Context ctx, String tableName, StringBuffer sql, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill writtenOffBill) throws EASBizException, BOSException {
        super.buildBillMap(ctx, tableName, sql, writeOffBillMap, this.getIDList(writtenOffBill, true), false);
    }

    protected void takeInventoryBills(Context ctx, String billID, String tableName, CalculateWrittenOffHashMap writeOffBillMap, CalculateWrittenOffBill writtenOffBill) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(this.takeSQLBill(ctx, tableName));
        sql.append(this.getInventoryBillWhereSQL(ctx, billID));
        sql.append(this.getOrderBySQL());
        this.buildBillMap(ctx, tableName, sql, writeOffBillMap, writtenOffBill);
    }

    protected abstract String getInventoryBillWhereSQL(Context var1, String var2) throws BOSException;

    protected String getOrderBySQL() {
        StringBuffer sSQL = new StringBuffer();
        sSQL.append(" Order by Bill.FBizDate,Bill.FNumber,Entry.FSeq");
        return sSQL.toString();
    }
}

