/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillCollection;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillFactory;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.ICostAdjustBill;
import com.kingdee.eas.scm.cal.WriteOffGroupInfo;
import com.kingdee.eas.scm.cal.app.calculate.BillWriteOff;
import com.kingdee.eas.scm.cal.app.calculate.MoveWeightedAverageCalculate;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.ICalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateDiffAmt;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculatePrecision;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffGroup;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffHashMap;
import com.kingdee.eas.scm.cal.app.newutil.CostAdjustHelper;
import com.kingdee.eas.scm.cal.app.newutil.InventoryBillHelper;
import com.kingdee.eas.scm.cal.app.newutil.WriteOffHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.app.AutoSplitBillServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingFieldInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public abstract class AbstractCalculate
implements ICalculate {
    private Logger logger = Logger.getLogger(AbstractCalculate.class);
    public static final String WRITE_OFF_NOTE_SEQ = "writeOffNoteSeq";
    public static final String WRITTEN_OFF_NOTE_SEQ = "writtenOffNoteSeq";
    public static final String WRITTEN_OFF_ENTRY = "writetenOff_Entry";
    public static final String WRITTEN_OFF_DIFFDATA = "writeOff_Data";
    public static final String DIFFSUM = "diffSum";
    public static final String OTHERBILL_PRICE = "OtherbillPrice";
    public static final BigDecimal ZERO = new BigDecimal(String.valueOf("0"));
    public static final BigDecimal ONE = new BigDecimal(String.valueOf("1"));
    public static final BigDecimal ONE_MINUS = new BigDecimal(String.valueOf("-1"));
    public static final String INV_BILL_PREFIX = "t_im";
    protected int Local_Currency_Presision = 10;
    protected CompanyOrgUnitInfo companyOrgUnitInfo = null;
    protected String supplier = null;
    private ArrayList turnOverNoteWriteOffSQLArray = new ArrayList();
    public BillWriteOff billwriteoff = new BillWriteOff();
    public MoveWeightedAverageCalculate calculator = new MoveWeightedAverageCalculate();
    protected CoreBillBaseCollection costAdjCollection = null;
    protected ArrayList needReCalcPurInEntryIdList = new ArrayList();
    protected ArrayList saleIssueIdList = null;
    protected boolean[] isSplitBill;
    protected boolean isDebit_Bill = false;
    protected String srcEntryTableName = null;
    protected String destEntryTableName = null;
    protected int dischargeType = 0;
    protected PeriodInfo periodInfo = null;
    protected String materialCalType = null;
    protected boolean isDevolve = false;
    protected boolean isMerageCostAdjust = false;
    protected boolean isAdjust = false;
    protected CompanyOrgUnitInfo srcCompanyOrgInfo = null;

    @Override
    public void calculate(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        this.init(ctx, scminfo);
        this.calculateStrategy(ctx, scminfo);
        this.addCalculatorProcess();
        this.execCalculateSQL(ctx);
        CalculateUtil.writeOffUpdatePurInfo(ctx, this.needReCalcPurInEntryIdList, this.Local_Currency_Presision, false);
        ICostAdjustBill iCostAdjust = CostAdjustBillFactory.getLocalInstance(ctx);
        for (int i = 0; this.costAdjCollection != null && i < this.costAdjCollection.size(); ++i) {
            CostAdjustBillInfo costadjustbillinfo = (CostAdjustBillInfo)this.costAdjCollection.get(i);
            if (costadjustbillinfo.getEntry().size() <= 0) continue;
            iCostAdjust.audit((IObjectPK)new ObjectUuidPK(costadjustbillinfo.getId()));
        }
        if (this.saleIssueIdList != null && this.saleIssueIdList.size() > 0) {
            AutoSplitBillServerUtils.autoSplitBillByWrittenOffQty((Context)ctx, (boolean[])this.isSplitBill, (String[])this.saleIssueIdList.toArray(new String[this.saleIssueIdList.size()]));
        }
    }

    public void calculate(Context ctx, CoreBillBaseInfo scminfo, BizActionEnum bizAction) throws BOSException, EASBizException {
    }

    public void addNewCostAdjustBill(Context ctx, CostAdjustBillCollection collection) throws EASBizException, BOSException {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        this.costAdjCollection = new CoreBillBaseCollection();
        int size = collection.size();
        HashMap<String, Boolean> matIsSpec = new HashMap<String, Boolean>();
        HashSet<String> matSet = new HashSet<String>();
        for (int m = 0; m < size; ++m) {
            CostAdjustBillInfo costadjustbillinfo = collection.get(m);
            if (costadjustbillinfo.getEntry() == null) continue;
            int entrysize = costadjustbillinfo.getEntry().size();
            for (int n = 0; n < entrysize; ++n) {
                CostAdjustBillEntryInfo costAdjinfo = costadjustbillinfo.getEntry().get(n);
                matSet.add(costAdjinfo.getMaterial().getId().toString());
            }
        }
        String sql = "select FMaterialId,FAccountType from t_bd_materialcompanyinfo where fcompanyid = '" + this.companyOrgUnitInfo.getId().toString() + "' and fmaterialid in (" + CalculateUtil.getSqlInString(matSet) + ")";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                matIsSpec.put(rs.getString("FMaterialId"), new Boolean(rs.getInt("FAccountType") == 5));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < size; ++i) {
            CostAdjustBillInfo costadjustbillinfo = collection.get(i);
            if (costadjustbillinfo.getEntry() == null || costadjustbillinfo.getEntry().size() <= 0) continue;
            int entrysize = costadjustbillinfo.getEntry().size();
            this.turnOverNoteWriteOffSQLArray.add(CostAdjustHelper.createCostAdjustBillSQL(costadjustbillinfo));
            this.costAdjCollection.add((CoreBillBaseInfo)costadjustbillinfo);
            for (int j = 0; j < entrysize; ++j) {
                CostAdjustBillEntryInfo costAdjEntry = costadjustbillinfo.getEntry().get(j);
                boolean isSpecialAccType = new Boolean(matIsSpec.get(costAdjEntry.getMaterial().getId().toString()).toString());
                this.turnOverNoteWriteOffSQLArray.add(CostAdjustHelper.createCostAdjustEntrySQL(costadjustbillinfo, costAdjEntry, this.isAdjust, isSpecialAccType));
            }
        }
    }

    protected void addNewWriteOffBill(Context ctx, WriteOffGroupInfo writeoffgroupinfo) throws EASBizException, BOSException {
        int entrysize = writeoffgroupinfo.getEntry().size();
        if (entrysize > 0) {
            this.turnOverNoteWriteOffSQLArray.add(WriteOffHelper.createWrittenOffGroupSQL(writeoffgroupinfo).toString());
            for (int j = 0; j < entrysize; ++j) {
                this.turnOverNoteWriteOffSQLArray.add(WriteOffHelper.createWrittenOffRecordSQL(writeoffgroupinfo.getId(), writeoffgroupinfo.getEntry().get(j)).toString());
            }
        }
    }

    protected void init(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        this.companyOrgUnitInfo = this.takeFinanceOrg(ctx, scminfo);
        if (this.companyOrgUnitInfo == null || this.companyOrgUnitInfo.getId() == null) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        this.Local_Currency_Presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, this.companyOrgUnitInfo);
        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)this.companyOrgUnitInfo);
        this.companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.companyOrgUnitInfo.getId().toString()));
        if (this.periodInfo == null) {
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(this.companyOrgUnitInfo.getName(), this.companyOrgUnitInfo.getNumber())});
        }
        HashMap paramsMap = CalculateUtil.takeSysParamValue(ctx, this.companyOrgUnitInfo, new String[]{"SCM_CAL_002", "SCM_CAL_012"});
        if (paramsMap != null) {
            String calType = (String)paramsMap.get("SCM_CAL_002");
            if (StringUtil.isEmpty((String)calType)) {
                throw new CalculateException(CalculateException.MATERIAL_CAL_KIND_NOT_EXIST);
            }
            this.materialCalType = calType;
            if (paramsMap.get("SCM_CAL_012") != null) {
                this.isAdjust = ((String)paramsMap.get("SCM_CAL_012")).equalsIgnoreCase("true");
            }
        }
        this.initSrcCompanyOrg(ctx, scminfo);
    }

    private void initSrcCompanyOrg(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        Boolean isBizVMI = scminfo.getBoolean("IS_VMI_BIZ");
        if (isBizVMI.booleanValue()) {
            return;
        }
        String srcBillId = null;
        if (((IObjectCollection)scminfo.get("entry")).getObject(0) instanceof ArApBillEntryBaseInfo) {
            ArApBillEntryBaseInfo obi = (ArApBillEntryBaseInfo)((IObjectCollection)scminfo.get("entry")).getObject(0);
            srcBillId = obi.getSourceBillId();
        } else {
            InvBillBaseEntryInfo inv = (InvBillBaseEntryInfo)((IObjectCollection)scminfo.get("entry")).getObject(0);
            srcBillId = inv.getSourceBillId();
        }
        if (srcBillId != null && !"".equals(srcBillId)) {
            CoreBillEntryBaseInfo entry;
            CompanyOrgUnitInfo cou = null;
            ICoreBillBase iCoreBill = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)BOSUuid.read((String)srcBillId).getType().toString()));
            CoreBillBaseInfo srcInfo = iCoreBill.getCoreBillBaseInfo((IObjectPK)new ObjectUuidPK(srcBillId));
            if (srcInfo.get("companyOrgUnit") != null) {
                cou = (CompanyOrgUnitInfo)srcInfo.get("companyOrgUnit");
            } else if (srcInfo.get("storageOrgUnit") != null) {
                cou = CalculateUtil.getCompanyInfoForStorage(ctx, ((StorageOrgUnitInfo)srcInfo.get("storageOrgUnit")).getId().toString());
            }
            if (cou == null && srcInfo.get("entry") != null && (entry = (CoreBillEntryBaseInfo)((IObjectCollection)srcInfo.get("entry")).getObject(0)) != null) {
                cou = (CompanyOrgUnitInfo)entry.get("companyOrgUnit");
            }
            this.srcCompanyOrgInfo = cou;
        }
    }

    private void addCalculatorProcess() throws EASBizException, BOSException {
        ArrayList sqlArray = this.calculator.getCalculatorProcessSqlArray();
        if (sqlArray != null && this.turnOverNoteWriteOffSQLArray != null) {
            for (int i = 0; i < sqlArray.size(); ++i) {
                this.turnOverNoteWriteOffSQLArray.add(sqlArray.get(i));
            }
        }
    }

    protected boolean isNeedCreateCostAdjBill(BigDecimal diffAmount, CalculateWrittenOffBill invBill, CalculateWrittenOffBill apBill) {
        if (apBill.getBillType().equals(invBill.getBillType())) {
            return false;
        }
        if (CalConstant.ZERO.compareTo(diffAmount) != 0) {
            return true;
        }
        return !this.isMerageCostAdjust && (invBill.getPeriodYear() != apBill.getPeriodYear() || invBill.getPeriod() != apBill.getPeriod());
    }

    protected abstract CompanyOrgUnitInfo takeFinanceOrg(Context var1, CoreBillBaseInfo var2) throws EASBizException, BOSException;

    protected abstract CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException;

    public String takeBillEntryCoreBillEntryId(Context ctx, String billID, String tableName, String field) throws BOSException {
        StringBuffer strid = new StringBuffer();
        StringBuffer sqlid = new StringBuffer();
        LowTimer t = new LowTimer();
        sqlid.append(" select ").append(field).append(" from ").append(tableName);
        sqlid.append(" where FParentId='").append(billID).append("'");
        sqlid.append(" group by ").append(field);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            RowSet rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sqlid.toString());
            sqlid = null;
            String id = null;
            while (rs.next()) {
                id = rs.getString(field);
                if (StringUtil.isEmpty((String)id)) continue;
                if (strid.length() > 1) {
                    strid.append(",");
                }
                strid.append("'").append(id).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        this.logger.debug((Object)("--\u53d6\u5173\u8054\u5355\u636eID time:" + t.msValue()));
        return strid.toString();
    }

    protected List getEntryByEntryId(CalculateWrittenOffBill billInfo, String entryID) {
        if (StringUtil.isEmpty((String)entryID) || billInfo == null || billInfo.getEntry() == null) {
            return null;
        }
        ArrayList<CalculateWrittenOffEntry> entryList = new ArrayList<CalculateWrittenOffEntry>();
        CalculateWrittenOffEntry entry = null;
        ArrayList entrys = billInfo.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            entry = (CalculateWrittenOffEntry)entrys.get(i);
            if (entry == null || !entryID.equals(entry.getId())) continue;
            entryList.add(entry);
        }
        return entryList;
    }

    protected List getEntryByCoreEntryId(CalculateWrittenOffBill billInfo, String coreEntryID) {
        if (StringUtil.isEmpty((String)coreEntryID) || billInfo == null || billInfo.getEntry() == null) {
            return null;
        }
        ArrayList<CalculateWrittenOffEntry> entryList = new ArrayList<CalculateWrittenOffEntry>();
        CalculateWrittenOffEntry entry = null;
        ArrayList entrys = billInfo.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            entry = (CalculateWrittenOffEntry)entrys.get(i);
            if (entry == null || !coreEntryID.equals(entry.getOrderBillEntryId())) continue;
            entryList.add(entry);
        }
        return entryList;
    }

    protected List getEntryBySrcEntryId(CalculateWrittenOffBill billInfo, CalculateWrittenOffBill invBill, CalculateWrittenOffEntry srcEntry) {
        if (srcEntry == null || billInfo == null || billInfo.getEntry() == null) {
            return null;
        }
        boolean isRedBill = false;
        if (billInfo.getBillType().equals(invBill.getBillType())) {
            isRedBill = true;
        }
        ArrayList<CalculateWrittenOffEntry> entryList = new ArrayList<CalculateWrittenOffEntry>();
        CalculateWrittenOffEntry entry = null;
        ArrayList entrys = billInfo.getEntry();
        for (int i = 0; i < entrys.size(); ++i) {
            entry = (CalculateWrittenOffEntry)entrys.get(i);
            if (isRedBill && entry.getId().equals(srcEntry.getSourceBillEntryId())) {
                entryList.add(entry);
                continue;
            }
            if (isRedBill || !srcEntry.getId().equals(entry.getSourceBillEntryId())) continue;
            entryList.add(entry);
        }
        return entryList;
    }

    public void turnOverNoteWriteOffInfo(Context ctx, CalculateWrittenOffEntry calEntry) throws EASBizException, BOSException {
        String tableName = calEntry.getTableName();
        HashMap<String, Object> hm = new HashMap<String, Object>();
        if ("t_im_materialreqbillentry".equalsIgnoreCase(tableName) || "t_im_moveissuebillentry".equalsIgnoreCase(tableName) || "t_im_otherissuebillentry".equalsIgnoreCase(tableName)) {
            if (AccountType.MOVE_ADD_AVERAGE.equals((Object)calEntry.getMaterialAccountType())) {
                hm.put("FActualCost", calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
                if (calEntry.getMaterialBaseUnit() != null && calEntry.getMaterialUnit() != null && calEntry.getMaterialUnit().equals((Object)calEntry.getMaterialBaseUnit())) {
                    hm.put("FUnitActualCost", calEntry.getInvoUnitPrice());
                } else {
                    hm.put("FUnitActualCost", "case when FQty = 0 then 0 else ROUND(" + CalculateUtil.to_decimal_divide(StringUtil.bigDecimal2String((BigDecimal)calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4)) + "/fQty") + "," + calEntry.getPrecision().getPricePrecision() + ") end ");
                }
                if ("t_im_materialreqbillentry".equalsIgnoreCase(tableName)) {
                    hm.put("FSCUnWrittenOffAmount", calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
                    hm.put("FSCWrittenOffAmount", ZERO);
                }
            }
        } else if ("t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            hm.put("FLocalUnwriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnwriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FLocalWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
        } else if ("T_AR_IncomeConfimEntry".equalsIgnoreCase(tableName)) {
            hm.put("FLocalUnwriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnwriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FLocalWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
        } else if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            hm.put("FLocalUnwriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnwriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FLocalWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
        } else if ("t_im_purinwarehsentry".equalsIgnoreCase(tableName)) {
            hm.put("FUnWriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnWriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            if (calEntry.getWrittenOffQty().compareTo(calEntry.getBaseUnitQty()) == 0) {
                hm.put("FWrittenOffQty", calEntry.getQty());
                hm.put("FUnWriteOffQty", ZERO);
            } else {
                hm.put("FWrittenOffQty", calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4));
                hm.put("FUnWriteOffQty", calEntry.getQty().subtract(calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4)));
            }
            if (calEntry.isNeedRetWriteUnitCost()) {
                hm.put("FUnitPurchaseCost", calEntry.getUnitPurchaseCost());
                hm.put("FPurchaseCost", calEntry.getPurchaseCost());
                hm.put("FActualCost", calEntry.getActualCost());
                hm.put("FUnitActualCost", calEntry.getUnitActualCost());
            }
        } else if ("t_im_saleissueentry".equalsIgnoreCase(tableName)) {
            hm.put("FUnWriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnWriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FUnWriteOffQty", calEntry.getUnWriteOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4));
            hm.put("FWrittenOffQty", calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4));
            if (CalConstant.ZERO.compareTo(calEntry.getUnWriteOffQty()) == 0) {
                hm.put("FWrittenOffQty", "FQty");
            }
            if (AccountType.MOVE_ADD_AVERAGE.equals((Object)calEntry.getMaterialAccountType())) {
                hm.put("FActualCost", calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
                if (calEntry.getMaterialBaseUnit() != null && calEntry.getMaterialUnit() != null && calEntry.getMaterialUnit().equals((Object)calEntry.getMaterialBaseUnit())) {
                    hm.put("FUnitActualCost", calEntry.getInvoUnitPrice());
                } else {
                    hm.put("FUnitActualCost", "ROUND(" + CalculateUtil.to_decimal_divide(StringUtil.bigDecimal2String((BigDecimal)calEntry.getAmount().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4)) + "/fQty") + "," + calEntry.getPrecision().getPricePrecision() + ")");
                }
            }
        }
        this.createSQLTurnOverNoteWriteOff(tableName, hm, calEntry.getId());
    }

    public void turnOverNoteWriteOffInfo(Context ctx, CalculateWrittenOffEntry calEntry, boolean isRewriteDevolve) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> hm = new HashMap<String, BigDecimal>();
        String tableName = calEntry.getTableName();
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            hm.put("FLocalUnwriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnwriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FLocalWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
        } else if ("t_im_purinwarehsentry".equalsIgnoreCase(tableName)) {
            hm.put("FUnWriteOffAmount", calEntry.getUnWriteOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FUnWriteOffBaseQty", calEntry.getUnWriteOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            hm.put("FWrittenOffAmount", calEntry.getWrittenOffAmt().setScale(calEntry.getPrecision().getLocalCurrencyPrecision(), 4));
            hm.put("FWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
            if (calEntry.getWrittenOffQty().compareTo(calEntry.getBaseUnitQty()) == 0) {
                hm.put("FWrittenOffQty", calEntry.getQty());
                hm.put("FUnWriteOffQty", ZERO);
            } else {
                hm.put("FWrittenOffQty", calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4));
                hm.put("FUnWriteOffQty", calEntry.getQty().subtract(calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4)));
            }
            if (calEntry.isNeedRetWriteUnitCost()) {
                hm.put("FUnitPurchaseCost", calEntry.getUnitPurchaseCost());
                hm.put("FPurchaseCost", calEntry.getPurchaseCost());
                hm.put("FActualCost", calEntry.getActualCost());
                hm.put("FUnitActualCost", calEntry.getUnitActualCost());
            }
            if (isRewriteDevolve && calEntry.getDosingType() != 4) {
                hm.put("FSCUnWrittenOffBaseQty", calEntry.getBaseUnitQty().subtract(calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4)));
                hm.put("FSCWrittenOffBaseQty", calEntry.getWrittenOffQty().setScale(calEntry.getPrecision().getBaseQtyPrecision(), 4));
                if (calEntry.getWrittenOffQty().compareTo(calEntry.getBaseUnitQty()) == 0) {
                    hm.put("FSCWrittenOffQty", calEntry.getQty());
                    hm.put("FSCUnWrittenOffQty", ZERO);
                } else {
                    hm.put("FSCWrittenOffQty", calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4));
                    hm.put("FSCUnWrittenOffQty", calEntry.getQty().subtract(calEntry.getWrittenOffQty().divide(calEntry.getExchangeRateQty(), calEntry.getPrecision().getQtyPrecision(), 4)));
                }
            }
        } else if ("t_im_materialreqbillentry".equalsIgnoreCase(tableName) && isRewriteDevolve) {
            hm.put("FSubWrittenOffQty", calEntry.getScWriteOffQty());
            hm.put("FSubWrittenOffBaseQty", calEntry.getScWriteOffBaseQty());
            hm.put("FSubUnWriteOffQty", calEntry.getScUnWriteOffQty());
            hm.put("FSubUnWriteOffBaseQty", calEntry.getScUnWriteOffBaseQty());
            hm.put("FSCWrittenOffAmount", calEntry.getWrittenOffAmt());
            hm.put("FSCUnWrittenOffAmount", calEntry.getUnWriteOffAmt());
        }
        this.createSQLTurnOverNoteWriteOff(tableName, hm, calEntry.getId());
    }

    public void execCalculateSQL(Context ctx) throws BOSException {
        LowTimer t = new LowTimer();
        if (this.turnOverNoteWriteOffSQLArray == null || this.turnOverNoteWriteOffSQLArray.size() < 1) {
            return;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            int size = this.turnOverNoteWriteOffSQLArray.size();
            this.logger.debug((Object)("Calculate SQL \u603b\u6570:" + size));
            for (int i = 0; i < size; ++i) {
                ps.addBatch((String)this.turnOverNoteWriteOffSQLArray.get(i));
                this.logger.error((Object)("\u7b2c" + (i + 1) + "\u6761SQL\u8bed\u53e5:" + (String)this.turnOverNoteWriteOffSQLArray.get(i)));
            }
            this.logger.debug((Object)("Calculate SQL addBatchTime:" + t.msValue()));
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                int size = this.turnOverNoteWriteOffSQLArray.size();
                for (int i = 0; i < size; ++i) {
                    this.logger.debug((Object)((String)this.turnOverNoteWriteOffSQLArray.get(i)));
                }
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        this.logger.debug((Object)("Calculate SQL runtime :" + t.msValue()));
    }

    protected void createSQLTurnOverNoteWriteOff(String string, HashMap hm, String id) throws EASBizException, BOSException {
        if (id == null || id.length() == 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        boolean bln = false;
        Iterator it = hm.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry mapentry = it.next();
            if (i != 0) {
                sql.append(",");
            } else if (mapentry.getKey() != null && mapentry.getValue() != null) {
                ++i;
            }
            if (mapentry.getKey() == null || mapentry.getValue() == null) continue;
            bln = true;
            if (mapentry.getValue() instanceof BigDecimal) {
                sql.append(mapentry.getKey()).append("=").append(StringUtil.bigDecimal2String((BigDecimal)((BigDecimal)mapentry.getValue())));
                continue;
            }
            sql.append(mapentry.getKey()).append("=").append(mapentry.getValue());
        }
        if (bln) {
            StringBuffer returnStrSQL = new StringBuffer();
            returnStrSQL.append(" update ").append(string);
            returnStrSQL.append(" set ");
            returnStrSQL.append(sql);
            returnStrSQL.append(" where fid = '").append(id).append("'");
            this.turnOverNoteWriteOffSQLArray.add(returnStrSQL.toString());
        }
    }

    protected StringBuffer createSQL4SaleWriteOff(String string, HashMap hm, String id) throws EASBizException, BOSException {
        StringBuffer returnStrSQL = new StringBuffer();
        if (id == null || id.length() == 0) {
            return returnStrSQL;
        }
        StringBuffer sql = new StringBuffer();
        boolean bln = false;
        Iterator it = hm.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry mapentry = it.next();
            if (i != 0) {
                sql.append(",");
            } else if (mapentry.getKey() != null && mapentry.getValue() != null) {
                ++i;
            }
            if (mapentry.getKey() == null || mapentry.getValue() == null) continue;
            bln = true;
            if (mapentry.getValue() instanceof BigDecimal) {
                sql.append(mapentry.getKey()).append("=").append(StringUtil.bigDecimal2String((BigDecimal)((BigDecimal)mapentry.getValue())));
                continue;
            }
            sql.append(mapentry.getKey()).append("=").append(mapentry.getValue());
        }
        if (bln) {
            returnStrSQL.append(" update ").append(string);
            returnStrSQL.append(" set ");
            returnStrSQL.append(sql);
            returnStrSQL.append(" where fid = '").append(id).append("'");
        }
        return returnStrSQL;
    }

    public HashMap takeCalculatePeriod(CalculateWrittenOffBill bill, CalculateWrittenOffBill calBill, PeriodInfo currPeriodInfo) {
        Date bizDate = new Date();
        PeriodInfo period = new PeriodInfo();
        int billperiod = bill.getPeriodYear() * 100 + bill.getPeriod();
        int calbillperiod = calBill.getPeriodYear() * 100 + calBill.getPeriod();
        int currperiod = currPeriodInfo.getPeriodYear() * 100 + currPeriodInfo.getPeriodNumber();
        if (billperiod >= currperiod && calbillperiod >= currperiod || currperiod > billperiod && currperiod <= calbillperiod || currperiod > calbillperiod && currperiod <= billperiod) {
            if (bill.getPeriodYear() == calBill.getPeriodYear() && bill.getPeriod() >= calBill.getPeriod() || bill.getPeriodYear() > calBill.getPeriodYear()) {
                period.setPeriodNumber(bill.getPeriod());
                period.setPeriodYear(bill.getPeriodYear());
                bizDate = bill.getBizDate();
            } else {
                period.setPeriodNumber(calBill.getPeriod());
                period.setPeriodYear(calBill.getPeriodYear());
                bizDate = calBill.getBizDate();
            }
        } else if (billperiod < currperiod && calbillperiod < currperiod) {
            bizDate = currPeriodInfo.getBeginDate();
            period.setPeriodNumber(currPeriodInfo.getPeriodNumber());
            period.setPeriodYear(currPeriodInfo.getPeriodYear());
        }
        HashMap<String, Date> periodMap = new HashMap<String, Date>();
        periodMap.put("BizDate", bizDate);
        periodMap.put("Period", (Date)period);
        return periodMap;
    }

    public Map takeCalculatePeriod(Context ctx, Date billBizDate, CalculateWrittenOffHashMap hashmap, PeriodInfo currPeriodInfo) throws EASBizException, BOSException {
        int billPeriod;
        int currPeriod = CalculateUtil.takePeriodValueByPeriod(currPeriodInfo);
        int maxPeriod = currPeriod > (billPeriod = CalculateUtil.takePeriodValueByDate(ctx, billBizDate, this.companyOrgUnitInfo)) ? currPeriod : billPeriod;
        Date bizDate = currPeriod > billPeriod ? currPeriodInfo.getBeginDate() : billBizDate;
        for (Map.Entry mapEntry : hashmap.entrySet()) {
            for (Map.Entry entrybill : ((CalculateWrittenOffGroup)mapEntry.getValue()).entrySet()) {
                Date invoiceDate = ((CalculateWrittenOffBill)entrybill.getValue()).getBizDate();
                int invoicePeriod = CalculateUtil.takePeriodValueByDate(ctx, invoiceDate, this.companyOrgUnitInfo);
                ArrayList list = ((CalculateWrittenOffBill)entrybill.getValue()).getEntry();
                for (CalculateWrittenOffEntry entry : list) {
                    if (ZERO.compareTo(entry.getWrittenOffQty()) == 0) continue;
                    maxPeriod = maxPeriod < invoicePeriod ? invoicePeriod : maxPeriod;
                    bizDate = maxPeriod < invoicePeriod ? invoiceDate : bizDate;
                }
            }
        }
        PeriodInfo period = new PeriodInfo();
        period.setPeriodYear(maxPeriod / 100);
        period.setPeriodNumber(maxPeriod % 100);
        HashMap<String, Date> PeriodMap = new HashMap<String, Date>();
        PeriodMap.put("BizDate", bizDate);
        PeriodMap.put("Period", (Date)period);
        return PeriodMap;
    }

    protected boolean isNeedReWriteCost(CalculateWrittenOffBill purInbill, CalculateWrittenOffEntry calEntry) {
        if (AccountType.MOVE_ADD_AVERAGE.equals((Object)calEntry.getMaterialAccountType())) {
            return false;
        }
        if (!"t_im_purinwarehsentry".equalsIgnoreCase(calEntry.getTableName())) {
            return false;
        }
        if (CalConstant.ZERO.compareTo(calEntry.getWrittenOffQty()) != 0) {
            return false;
        }
        if (purInbill.isVouchered() || calEntry.isPresent()) {
            return false;
        }
        int billPeriodNumber = purInbill.getPeriodYear() * 100 + purInbill.getPeriod();
        return billPeriodNumber >= this.periodInfo.getNumber();
    }

    public CalculateWrittenOffBill takeBillValue(Context ctx, String tableName, ResultSet rs) throws EASBizException, BOSException, SQLException {
        CalculateWrittenOffBill calBill = new CalculateWrittenOffBill();
        calBill.setId(rs.getString("fid"));
        calBill.setSourceBillId(rs.getString("fsourceBillId"));
        calBill.setNumber(rs.getString("fnumber"));
        calBill.setBizDate(rs.getDate("fbizDate"));
        calBill.setCalculateKindEnum(this.takeOutOrInWarehouseKind());
        calBill.setPeriod(rs.getInt("fPeriod"));
        calBill.setPeriodYear(rs.getInt("fPeriodYear"));
        calBill.setBillType(SCMUtil.getBillTypeNOFormBillTypeID((String)rs.getString("fbillType")));
        calBill.setTransactionTypeID(rs.getString("ftransactionTypeID"));
        calBill.setTableName(InvCommonUtils.getBillTableName((String)calBill.getBillType()));
        calBill.setRedBlueType(rs.getInt("isRedbill"));
        calBill.setIsReversed(rs.getBoolean("isReversed"));
        calBill.setBizType(rs.getString("FBizTypeID"));
        calBill.setBaseStatus(rs.getInt("FBaseStatus"));
        if (tableName != null && (tableName.toLowerCase().indexOf(INV_BILL_PREFIX) > -1 || "t_cl_costadjustbillentry".equalsIgnoreCase(tableName))) {
            calBill.setIsInitBill(rs.getBoolean("fisInitBill"));
            calBill.setTransactionTypeName(rs.getString("ftransactionTypeName"));
            calBill.setIsParticipateInCalculate(rs.getBoolean("IsParticipateInCalculate"));
            calBill.setRecIssueType(rs.getString("recIssueType"));
            calBill.setWriteOff(rs.getBoolean("isWriteOff"));
            calBill.setStoreTypeID(rs.getString("FStoreTypeID"));
        }
        if ("t_im_materialreqbillentry".equalsIgnoreCase(tableName)) {
            calBill.setBizTypeNumber(rs.getString("FBizTypeNumber"));
            calBill.setPurchaseType(rs.getInt("FPurchaseType"));
            calBill.setSupplier(rs.getString("fsupplier"));
            calBill.setCoreBillId(rs.getString("fcoreBillId"));
        } else if ("t_cl_costadjustbillentry".equalsIgnoreCase(tableName)) {
            calBill.setTransactionTypeName(this.takeOutOrInWarehouseKind().toString() + ResourceUtil.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_ADJUST_BILL", (Context)ctx));
            calBill.setIsParticipateInCalculate(true);
        } else if ("t_im_purinwarehsentry".equalsIgnoreCase(tableName)) {
            calBill.setSupplier(rs.getString("fsupplier"));
            calBill.setCustomer(null);
            calBill.setVouchered(rs.getBoolean("ffivouchered"));
            calBill.setCurrency(rs.getString("FCurrencyID"));
            calBill.setExchangeRate(rs.getBigDecimal("FExchangeRate"));
            calBill.setPurchaseType(rs.getInt("FPurchaseType"));
            calBill.setAdminOrgUnit(rs.getString("FAdminOrgUnitID"));
            calBill.setBizTypeNumber(rs.getString("FBizTypeNumber"));
        } else if ("t_im_saleissueentry".equalsIgnoreCase(tableName)) {
            calBill.setSupplier(null);
            calBill.setCustomer(rs.getString("fcustomer"));
            calBill.setPaymentType(rs.getString("paymentType"));
        } else if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            calBill.setSupplier(rs.getString("fsupplier"));
            calBill.setCustomer(null);
            calBill.setCurrency(rs.getString("FCurrencyID"));
            calBill.setExchangeRate(rs.getBigDecimal("FExchangeRate"));
            calBill.setAdminOrgUnit(rs.getString("FAdminOrgUnitID"));
            calBill.setBizTypeNumber(rs.getString("FBizTypeNumber"));
        } else if ("t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            calBill.setSupplier(null);
            calBill.setCustomer(rs.getString("fcustomer"));
            calBill.setPaymentType(rs.getString("paymentType"));
        }
        calBill.setCostCenter(rs.getString("costCenter"));
        return calBill;
    }

    public CalculateWrittenOffEntry takeEntryValue(Context ctx, String tableName, ResultSet rs) throws SQLException, EASBizException, BOSException {
        if (rs == null) {
            return null;
        }
        CalculateWrittenOffEntry cwoEntry = null;
        boolean flag = true;
        flag = "t_ar_otherbillentry".equalsIgnoreCase(tableName) || "t_ap_otherbillentry".equalsIgnoreCase(tableName) ? rs.getInt("FBaseStatus") == 3 : rs.getInt("FBaseStatus") == 4;
        cwoEntry = new CalculateWrittenOffEntry();
        cwoEntry.setParentid(rs.getString("fid"));
        cwoEntry.setId(rs.getString("fentry_id"));
        cwoEntry.setSeq(rs.getInt("fseq"));
        cwoEntry.setOrderBillNumber(rs.getString("fcoreBillNumber"));
        cwoEntry.setOrderBillEntrySeq(rs.getInt("fcoreBillEntrySeq"));
        cwoEntry.setOrderBillId(rs.getString("fcoreBillId"));
        cwoEntry.setOrderBillEntryId(rs.getString("fcoreBillEntryId"));
        cwoEntry.setTableName(InvCommonUtils.getBillEntryTableName((String)SCMUtil.getBillTypeNOFormBillTypeID((String)rs.getString("fbillType"))));
        cwoEntry.setSourceBillid(rs.getString("fsourceBillId"));
        cwoEntry.setSourceBillEntryId(rs.getString("fsourceBillEntryId"));
        cwoEntry.setFinanceOrg(this.companyOrgUnitInfo);
        cwoEntry.setSrcCompanyOrg(this.srcCompanyOrgInfo);
        if ("t_im_otherinwarehsbillentry".equalsIgnoreCase(tableName) || "t_im_otherissuebillentry".equalsIgnoreCase(tableName) || "t_im_moveinwarehsbillentry".equalsIgnoreCase(tableName) || "t_im_moveissuebillentry".equalsIgnoreCase(tableName) || "t_im_purinwarehsentry".equalsIgnoreCase(tableName) || "t_im_manufacturerecbillentry".equalsIgnoreCase(tableName) || "t_im_saleissueentry".equalsIgnoreCase(tableName) || "t_im_materialreqbillentry".equalsIgnoreCase(tableName) || "t_cl_costadjustbillentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setStoreTypeId(rs.getString("FStoreTypeID"));
            cwoEntry.setStoreStateId(rs.getString("FStoreStateID"));
        }
        MaterialInfo material = new MaterialInfo();
        material.setId(BOSUuid.read((String)rs.getString("fmaterial")));
        cwoEntry.setMaterial(material);
        if (rs.getString("fmaterialBaseUnit") != null && rs.getString("fmaterialBaseUnit").length() > 1) {
            MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
            measureUnitInfo.setId(BOSUuid.read((String)rs.getString("fmaterialBaseUnit")));
            cwoEntry.setMaterialBaseUnit(measureUnitInfo);
        }
        if (rs.getString("fmaterialUnit") != null && rs.getString("fmaterialUnit").length() > 1) {
            MeasureUnitInfo measureUnitInfo2 = new MeasureUnitInfo();
            measureUnitInfo2.setId(BOSUuid.read((String)rs.getString("fmaterialUnit")));
            cwoEntry.setMaterialUnit(measureUnitInfo2);
        }
        cwoEntry.setMaterialAccountType(AccountType.getEnum((int)rs.getInt("fmaterialAccountType")));
        CalculatePrecision precision = new CalculatePrecision();
        precision.setPricePrecision(rs.getInt("FPricePrecision"));
        if (precision.getPricePrecision() < 0) {
            precision.setPricePrecision(6);
        }
        precision.setLocalCurrencyPrecision(rs.getInt("FLocalCurrencyPrecision"));
        if (precision.getLocalCurrencyPrecision() < 0) {
            precision.setLocalCurrencyPrecision(2);
        }
        precision.setBaseQtyPrecision(rs.getInt("FBaseQtyPrecision"));
        if (precision.getBaseQtyPrecision() < 0) {
            precision.setBaseQtyPrecision(6);
        }
        precision.setCurrencyPrecision(rs.getInt("FCurrencyPrecision"));
        if (precision.getCurrencyPrecision() < 0) {
            precision.setCurrencyPrecision(2);
        }
        precision.setQtyPrecision(rs.getInt("FQtyPrecision"));
        if (precision.getQtyPrecision() < 0) {
            precision.setQtyPrecision(6);
        }
        cwoEntry.setPrecision(precision);
        cwoEntry.setBaseUnitQty(flag ? rs.getBigDecimal("fbaseUnitQty") : rs.getBigDecimal("fbaseUnitQty").negate());
        cwoEntry.setQty(flag ? rs.getBigDecimal("fqty") : rs.getBigDecimal("fqty").negate());
        cwoEntry.setAmount(flag ? rs.getBigDecimal("famount") : rs.getBigDecimal("famount").negate());
        cwoEntry.setExchangeRateQty(rs.getBigDecimal("fexchangeRateQty"));
        cwoEntry.setExchangeRateAmount(CalConstant.ONE);
        cwoEntry.setAssistProperty(null);
        cwoEntry.setBatch(rs.getString("fbatch"));
        cwoEntry.setLocationId(rs.getString("FLocationID"));
        cwoEntry.setWarehouse(null);
        cwoEntry.setStorageOrg(null);
        cwoEntry.setStorageOrgUnitId(rs.getString("fstorageOrg"));
        cwoEntry.setWarehouseId(rs.getString("fwarehouse"));
        cwoEntry.setMaterialId(rs.getString("fmaterial"));
        cwoEntry.setWrittenOffAmt(rs.getBigDecimal("fwrittenOffAmt") == null ? CalConstant.ZERO : rs.getBigDecimal("fwrittenOffAmt"));
        cwoEntry.setUnWriteOffAmt(rs.getBigDecimal("funWriteOffAmt"));
        cwoEntry.setWrittenOffQty(rs.getBigDecimal("fwrittenOffQty") == null ? CalConstant.ZERO : rs.getBigDecimal("fwrittenOffQty"));
        cwoEntry.setUnWriteOffQty(rs.getBigDecimal("funWriteOffQty"));
        cwoEntry.setCurrWriteOffAmt(CalConstant.ZERO);
        cwoEntry.setCurrWriteOffQty(CalConstant.ZERO);
        cwoEntry.setPresent(rs.getBoolean("fispresent"));
        if ("t_im_materialreqbillentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setScWriteOffQty(rs.getBigDecimal("scWriteOffQty"));
            cwoEntry.setScWriteOffBaseQty(rs.getBigDecimal("scWriteOffBaseQty"));
            cwoEntry.setScUnWriteOffQty(rs.getBigDecimal("scUnWriteOffQty"));
            cwoEntry.setScUnWriteOffBaseQty(rs.getBigDecimal("scUnWriteOffBaseQty"));
            cwoEntry.setSourceBillTypeID(rs.getString("fsourceBillTypeId"));
        } else if ("t_im_purinwarehsentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setFullWriteOff(0 != rs.getInt("fisFullWriteOff"));
            cwoEntry.setReverseQty(rs.getBigDecimal("freverseQty"));
            cwoEntry.setActualCost(rs.getBigDecimal("famount"));
            cwoEntry.setAmount2(rs.getBigDecimal("FAmount2"));
            cwoEntry.setTax(rs.getBigDecimal("FTax"));
            cwoEntry.setLocalTax(rs.getBigDecimal("FLocalTax"));
            cwoEntry.setLocalAmount(rs.getBigDecimal("FLocalAmount"));
            cwoEntry.setSourceBillTypeID(rs.getString("fsourceBillTypeId"));
            cwoEntry.setCurrencyID(rs.getString("FcurrencyID"));
            cwoEntry.setDiscountAmount(rs.getBigDecimal("FDiscountAmount"));
            cwoEntry.setDiscountRate(rs.getBigDecimal("FDiscountRate"));
            cwoEntry.setTaxRate(rs.getBigDecimal("FtaxRate"));
            String assistProperty = rs.getString("fassistProperty");
            if (assistProperty != null && assistProperty.trim().length() > 0) {
                AsstAttrValueInfo assInfo = new AsstAttrValueInfo();
                assInfo.setId(BOSUuid.read((String)assistProperty));
                cwoEntry.setAssistProperty(assInfo);
            }
            cwoEntry.setPurchaseCost(flag ? rs.getBigDecimal("purchaseCost") : rs.getBigDecimal("purchaseCost").negate());
            cwoEntry.setPurchaseFee(flag ? rs.getBigDecimal("purchaseFee") : rs.getBigDecimal("purchaseFee").negate());
            cwoEntry.setMaterialCost(flag ? rs.getBigDecimal("materialCost") : rs.getBigDecimal("materialCost").negate());
            cwoEntry.setDosingType(rs.getInt("dosingType"));
            cwoEntry.setProjectID(rs.getString("FProjectID"));
            cwoEntry.setTrackNumberID(rs.getString("FTrackNumberID"));
        } else if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setFullWriteOff(0 != rs.getInt("fisFullWriteOff"));
            cwoEntry.setActualCost(rs.getBigDecimal("famount"));
            cwoEntry.setAmount2(rs.getBigDecimal("FAmount2"));
            cwoEntry.setTax(rs.getBigDecimal("FTax"));
            cwoEntry.setLocalTax(rs.getBigDecimal("FLocalTax"));
            cwoEntry.setLocalAmount(rs.getBigDecimal("FLocalAmount"));
            cwoEntry.setFullWriteOff(0 != rs.getInt("fisFullWriteOff"));
            cwoEntry.setCurrencyID(rs.getString("FcurrencyID"));
            cwoEntry.setDiscountAmount(rs.getBigDecimal("FDiscountAmount"));
            cwoEntry.setDiscountRate(rs.getBigDecimal("FDiscountRate"));
            cwoEntry.setTaxRate(rs.getBigDecimal("FtaxRate"));
            cwoEntry.setProjectID(rs.getString("FProjectID"));
            cwoEntry.setTrackNumberID(rs.getString("FTrackNumberID"));
        } else if ("t_im_saleissueentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setSourceBillTypeID(rs.getString("fsourceBillTypeId"));
            cwoEntry.setFullWriteOff(0 != rs.getInt("fisFullWriteOff"));
        } else if ("t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setFullWriteOff(0 != rs.getInt("fisFullWriteOff"));
        } else if ("t_im_otherissuebillentry".equalsIgnoreCase(tableName)) {
            cwoEntry.setSourceBillTypeID(rs.getString("fsourceBillTypeId"));
        }
        cwoEntry.setUnitActualCost(rs.getBigDecimal("FUnitActualCost"));
        BigDecimal invoiceBasePrice = ZERO;
        if (ZERO.compareTo(cwoEntry.getBaseUnitQty()) != 0 && ZERO.compareTo(invoiceBasePrice = "t_im_purinwarehsentry".equalsIgnoreCase(tableName) ? cwoEntry.getPurchaseCost().divide(cwoEntry.getBaseUnitQty(), 10, 4) : cwoEntry.getAmount().divide(cwoEntry.getBaseUnitQty(), 10, 4)) > 0) {
            throw new CalculateException(CalculateException.BILL_UNIT_IS_MINUS, new String[]{rs.getString("fnumber"), String.valueOf(cwoEntry.getSeq())});
        }
        cwoEntry.setBaseUnitPrice(invoiceBasePrice);
        cwoEntry.setInvoUnitPrice(invoiceBasePrice);
        if (tableName != null && (tableName.toLowerCase().indexOf(INV_BILL_PREFIX) > -1 || "t_cl_costadjustbillentry".equalsIgnoreCase(tableName))) {
            if (StringUtil.isEmpty((String)rs.getString("fwarehouse"))) {
                throw new CalculateException(CalculateException.WAREHOUSE_NOT_EXIST);
            }
            if (StringUtil.isEmpty((String)rs.getString("fstorageOrg"))) {
                throw new CalculateException(CalculateException.STOREAGE_ORG_NOT_EXIST);
            }
            WarehouseInfo warehouse = new WarehouseInfo();
            warehouse.setId(BOSUuid.read((String)rs.getString("fwarehouse")));
            cwoEntry.setWarehouse(warehouse);
            StorageOrgUnitInfo storageOrgUnit = new StorageOrgUnitInfo();
            storageOrgUnit.setId(BOSUuid.read((String)rs.getString("fstorageOrg")));
            cwoEntry.setStorageOrg(storageOrgUnit);
        }
        return cwoEntry;
    }

    public CalculateWrittenOffBill takeWrittenOffBill(Context ctx, CoreBillBaseInfo bill, String tableName, StringBuffer selectSQL) throws BOSException, EASBizException {
        this.checkMaterialCompany(ctx, bill, tableName);
        CalculateWrittenOffBill calculateWrittenOffBill = null;
        StringBuffer sql = new StringBuffer(selectSQL);
        sql.append(" where Bill.FID = ? ");
        sql.append(" and MATERIALCOMPANY.FStatus = 1 ");
        sql.append(" order by Entry.FSeq");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new String[]{bill.getId().toString()});
        try {
            CalculateWrittenOffEntry calculateWrittenOffEntry = null;
            while (rs.next()) {
                if (calculateWrittenOffBill == null) {
                    calculateWrittenOffBill = this.takeBillValue(ctx, tableName, (ResultSet)rs);
                } else if (calculateWrittenOffBill.getRedBlueType() == 0) {
                    calculateWrittenOffBill.setRedBlueType(rs.getInt("isRedbill"));
                }
                calculateWrittenOffEntry = this.takeEntryValue(ctx, tableName, (ResultSet)rs);
                calculateWrittenOffBill.getEntry().add(calculateWrittenOffEntry);
                if (this.calculator == null) continue;
                this.calculator.materialArrayList.append("'").append(rs.getString("fmaterial")).append("',");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return calculateWrittenOffBill;
    }

    public StringBuffer takeSQLBill(Context ctx, String tableName) throws BOSException {
        StringBuffer storeStateSelector;
        StringBuffer sql = new StringBuffer();
        sql.append(this.getInvBillSelector(ctx));
        StringBuffer storeTypeSelector = this.getStoreTypeSelector(ctx, tableName);
        if (storeTypeSelector != null && storeTypeSelector.length() > 0) {
            sql.append(storeTypeSelector.toString());
        }
        if ((storeStateSelector = this.getStoreStateSelector(ctx, tableName)) != null && storeStateSelector.length() > 0) {
            sql.append(storeStateSelector.toString());
        }
        sql.append(" From ").append(tableName).append(" Entry ");
        String billTabName = InventoryBillHelper.getBillTabNameByEntryTabName(tableName);
        sql.append(" INNER JOIN ").append(billTabName).append(" Bill ON Entry.FParentId = Bill.FID");
        sql.append(" LEFT JOIN T_SCM_BizType BizType On Bill.FBizTypeID = BizType.FID");
        sql.append(" LEFT JOIN T_SCM_TransactionType TransType ON Bill.FTransactionTypeID = TransType.FID");
        StringBuffer storeTypeLeftJoin = this.getStoreTypeLeftJoin(ctx, tableName);
        if (storeTypeLeftJoin != null && storeTypeLeftJoin.length() > 0) {
            sql.append(storeTypeLeftJoin.toString());
        }
        sql.append(this.takeSQLJoinCommon(tableName));
        return sql;
    }

    private StringBuffer getStoreTypeLeftJoin(Context ctx, String tableName) {
        if ("t_cl_costadjustbillentry".equalsIgnoreCase(tableName)) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType on Entry.FInvUpdateTypeID = InvUpdateType.FID");
        return sql;
    }

    private StringBuffer getStoreTypeSelector(Context ctx, String tableName) {
        StringBuffer sql = new StringBuffer();
        if ("t_im_otherinwarehsbillentry".equalsIgnoreCase(tableName) || "t_im_purinwarehsentry".equalsIgnoreCase(tableName) || "t_im_moveinwarehsbillentry".equalsIgnoreCase(tableName) || "t_im_manufacturerecbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,InvUpdateType.FStoreTypeID as ").append("FStoreTypeID");
        } else if ("t_im_saleissueentry".equalsIgnoreCase(tableName) || "t_im_otherissuebillentry".equalsIgnoreCase(tableName) || "t_im_moveissuebillentry".equalsIgnoreCase(tableName) || "t_im_materialreqbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,InvUpdateType.FStoreTypePreID as ").append("FStoreTypeID");
        } else if ("t_cl_costadjustbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,Entry.FStoreTypeID as ").append("FStoreTypeID");
        }
        return sql;
    }

    private StringBuffer getStoreStateSelector(Context ctx, String tableName) {
        StringBuffer sql = new StringBuffer();
        if ("t_im_otherinwarehsbillentry".equalsIgnoreCase(tableName) || "t_im_purinwarehsentry".equalsIgnoreCase(tableName) || "t_im_moveinwarehsbillentry".equalsIgnoreCase(tableName) || "t_im_manufacturerecbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,InvUpdateType.FStoreStateID as ").append("FStoreStateID");
        } else if ("t_im_saleissueentry".equalsIgnoreCase(tableName) || "t_im_otherissuebillentry".equalsIgnoreCase(tableName) || "t_im_moveissuebillentry".equalsIgnoreCase(tableName) || "t_im_materialreqbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,InvUpdateType.FStoreStatePreID as ").append("FStoreStateID");
        } else if ("t_cl_costadjustbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,Entry.FStoreStatusID as ").append("FStoreStateID");
        }
        return sql;
    }

    protected String getInvBillSelector(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" Select Bill.FID AS ").append("fid");
        sql.append(" ,Bill.FNumber AS ").append("fnumber");
        sql.append(" ,Bill.FBizDate AS ").append("fbizDate");
        sql.append(" ,Bill.FPeriod AS ").append("fPeriod");
        sql.append(" ,Bill.FYear AS ").append("fPeriodYear");
        sql.append(" ,Bill.FBillTypeID AS ").append("fbillType");
        sql.append(" ,Bill.FIsInitbill AS ").append("fisInitBill");
        sql.append(" ,Bill.FIsReversed AS ").append("isReversed");
        sql.append(" ,sign(Entry.FQty) AS ").append("isRedbill");
        sql.append(" ,Bill.FFivouchered AS ").append("ffivouchered");
        sql.append(" ,Bill.FBaseStatus AS ").append("FBaseStatus");
        sql.append(" ,Bill.FAdminOrgUnitID AS ").append("FAdminOrgUnitID");
        sql.append(" ,Bill.FCostCenterOrgUnitID AS ").append("costCenter");
        sql.append(" ,Entry.FID AS ").append("fentry_id");
        sql.append(" ,Entry.FSeq AS ").append("fseq");
        sql.append(" ,Entry.FCompanyOrgUnitID AS ").append("ffinanceOrg");
        sql.append(" ,Entry.FStorageOrgUnitId AS ").append("fstorageOrg");
        sql.append(" ,Entry.FIsPresent AS ").append("fispresent");
        sql.append(" ,Entry.FSourceBillId AS ").append("fsourceBillId");
        sql.append(" ,Entry.FSourceBillEntryID AS ").append("fsourceBillEntryId");
        sql.append(" ,Entry.FSourceBillTypeID AS ").append("fsourceBillTypeId");
        sql.append(" ,Entry.FActualCost AS ").append("famount");
        sql.append(" ,Entry.funitactualCost AS ").append("FUnitActualCost");
        sql.append(" ,Entry.FQty AS ").append("fqty");
        sql.append(" ,Entry.FBaseQty AS ").append("fbaseUnitQty");
        sql.append(" ,Entry.FWarehouseid AS ").append("fwarehouse");
        sql.append(" ,Entry.FMaterialid AS ").append("fmaterial");
        sql.append(" ,Entry.FBaseUnitID AS ").append("fmaterialBaseUnit");
        sql.append(" ,Entry.FUnitID AS ").append("fmaterialUnit");
        sql.append(" ,Entry.FAssistPropertyID AS ").append("fassistProperty");
        sql.append(" ,Entry.FLot AS ").append("fbatch");
        sql.append(" ,Entry.FLocationID AS ").append("FLocationID");
        sql.append(" ,0 AS ").append("fcurrWriteOffAmt");
        sql.append(" ,0 AS ").append("fcurrWriteOffQty");
        sql.append(" ,MATERIALCOMPANY.FAccountType AS ").append("fmaterialAccountType");
        sql.append(" ,BizType.FID AS ").append("FBizTypeID");
        sql.append(" ,BizType.FNumber As ").append("FBizTypeNumber");
        sql.append(" ,TransType.FID AS ").append("ftransactionTypeID");
        sql.append(" ,TransType.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS ").append("ftransactionTypeName");
        sql.append(" ,TransType.FIsCalculate AS ").append("IsParticipateInCalculate");
        sql.append(" ,TransType.FIsWriteOff AS ").append("isWriteOff");
        sql.append(" ,TransType.FRITypeID AS ").append("recIssueType");
        sql.append(" ,MATERIAL.FPricePrecision AS ").append("FPricePrecision");
        sql.append(" ,CASE WHEN MeasureUnitBase.FQtyPrecision IS NULL THEN 4 ELSE MeasureUnitBase.FQtyPrecision END AS ").append("FBaseQtyPrecision");
        sql.append(" ,CASE WHEN MeasureUnit.FQtyPrecision IS NULL THEN 4 ELSE MeasureUnit.FQtyPrecision END AS ").append("FQtyPrecision");
        sql.append(" ,").append(this.Local_Currency_Presision).append(" AS ").append("FLocalCurrencyPrecision");
        sql.append(" ,").append(this.Local_Currency_Presision).append(" AS ").append("FCurrencyPrecision");
        sql.append(" ,CASE WHEN MeasureUnit.FBaseConvsRate IS NULL THEN 1 ELSE MeasureUnit.FBaseConvsRate END AS ").append("fexchangeRateQty");
        sql.append(" ,1 AS ").append("fexchangeRateAmount");
        sql.append(this.getExtendInvBillSelector());
        return sql.toString();
    }

    protected void buildBillMap(Context ctx, String tableName, StringBuffer sql, CalculateWrittenOffHashMap writeOffBillMap, List idList, boolean isTakeInvSrcBill) throws EASBizException, BOSException {
        CalculateWrittenOffBill calculateWrittenOffBill = null;
        CalculateWrittenOffEntry calculateWrittenOffEntry = null;
        CalculateWrittenOffGroup billMap = null;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            rs = statement.executeQuery(sql.toString());
            while (rs.next()) {
                String destBillIID = rs.getString("fid");
                String key = this.getKeyValue(idList, rs, isTakeInvSrcBill);
                calculateWrittenOffEntry = this.takeEntryValue(ctx, tableName, rs);
                billMap = writeOffBillMap.get(key) == null ? new CalculateWrittenOffGroup() : (CalculateWrittenOffGroup)writeOffBillMap.get(key);
                calculateWrittenOffBill = billMap.get(destBillIID) == null ? this.takeBillValue(ctx, tableName, rs) : (CalculateWrittenOffBill)billMap.get(destBillIID);
                calculateWrittenOffBill.getEntry().add(calculateWrittenOffEntry);
                billMap.put(destBillIID, calculateWrittenOffBill);
                writeOffBillMap.put(key, billMap);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
    }

    protected List getIDList(CalculateWrittenOffBill bill, boolean isFromSourceBillID) {
        ArrayList<String> idList = new ArrayList<String>();
        if (isFromSourceBillID) {
            if (bill.getEntry() != null && bill.getEntry().size() > 0) {
                int size = bill.getEntry().size();
                for (int i = 0; i < size; ++i) {
                    idList.add(((CalculateWrittenOffEntry)bill.getEntry().get(i)).getSourceBillid());
                }
            }
        } else {
            idList.add(bill.getId());
        }
        return idList;
    }

    protected abstract String getKeyValue(List var1, ResultSet var2, boolean var3) throws SQLException;

    protected abstract String getExtendInvBillSelector();

    public StringBuffer takeSQLAccountReceivableOrPayable(Context ctx, String tableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select Bill.fid AS ").append("fid");
        sql.append(" ,Bill.FCompanyID AS ").append("ffinanceOrg");
        sql.append(" ,entry.FSourceBillId AS ").append("fsourceBillId");
        sql.append(" ,Bill.FNumber AS ").append("fnumber");
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName) || "t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,Bill.FBillDate AS ").append("fbizDate");
        } else {
            sql.append(" ,Bill.FBizDate AS ").append("fbizDate");
        }
        sql.append(" ,Bill.FPeriod AS ").append("fPeriod");
        sql.append(" ,Bill.FYear AS ").append("fPeriodYear");
        sql.append(" ,Bill.FBizTypeID AS ").append("ftransactionTypeID");
        sql.append(" ,null AS ").append("ftransactionTypeName");
        sql.append(" ,0 AS ").append("fisInitBill");
        sql.append(" ,Bill.FIsReverseBill AS ").append("isReversed");
        sql.append(" ,Bill.FRedBlueType AS ").append("isRedbill");
        sql.append(" ,Bill.FBillStatus AS ").append("FBaseStatus");
        sql.append(" ,Bill.FBizTypeid AS ").append("FBizTypeID");
        sql.append(" ,BizType.FNumber AS ").append("FBizTypeNumber");
        sql.append(" ,Bill.FAdminOrgUnitID AS ").append("FAdminOrgUnitID");
        sql.append(" ,Bill.FCostCenterID AS ").append("costCenter");
        sql.append(" ,Entry.FID AS ").append("fentry_id");
        sql.append(" ,Entry.FSeq AS ").append("fseq");
        sql.append(" ,Entry.FSourcebillentryid AS ").append("fsourceBillEntryId");
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,'").append("510b6503-0105-1000-e000-010fc0a812fd463ED552").append("' AS ").append("fbillType");
            sql.append(" ,FAsstActID AS ").append("fsupplier");
            sql.append(" ,null AS ").append("fcustomer");
            sql.append(" ,Entry.FCoreBillNumber AS ").append("fcoreBillNumber");
            sql.append(" ,Entry.FCoreBillID AS ").append("fcoreBillId");
            sql.append(" ,Entry.FCoreBillEntrySeq AS ").append("fcoreBillEntrySeq");
            sql.append(" ,Entry.FCoreBillEntryID AS ").append("fcoreBillEntryId");
            sql.append(" ,Entry.FAmountLocal AS ").append("famount");
            sql.append(" ,Entry.FIsFullWriteOff AS ").append("fisFullWriteOff");
            sql.append(" ,Entry.FTaxAmountLocal AS ").append("FLocalTax");
            sql.append(" ,Entry.FTaxAmount AS ").append("FTax");
            sql.append(" ,Entry.FRecievePayAmountLocal AS ").append("FLocalAmount");
            sql.append(" ,Entry.FRecievePayAmount AS ").append("FAmount2");
            sql.append(" ,Bill.FExchangeRate AS ").append("FExchangeRate");
            sql.append(" ,Bill.FCurrencyID AS ").append("FCurrencyID");
            sql.append(" ,Entry.FPrice AS ").append("FUnitActualCost");
            sql.append(" ,Entry.FDiscountRate AS ").append("FDiscountRate");
            sql.append(" ,Entry.FDiscountAmount AS ").append("FDiscountAmount");
            sql.append(" ,Entry.FtaxRate AS ").append("FtaxRate");
            sql.append(" ,Bill.FCurrencyID AS ").append("FCurrencyID");
            sql.append(" ,srcEntry.FProjectID as ").append("FProjectID");
            sql.append(" ,srcEntry.FTrackNumberID as ").append("FTrackNumberID");
        } else if ("t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" ,'").append("510b6503-0105-1000-e000-0117c0a812fd463ED552").append("' AS ").append("fbillType");
            sql.append(" ,Bill.FPaymentTypeID AS ").append("paymentType");
            sql.append(" ,null AS ").append("fsupplier");
            sql.append(" ,FAsstActID AS ").append("fcustomer");
            sql.append(" ,Entry.FCoreBillNumber AS ").append("fcoreBillNumber");
            sql.append(" ,Entry.FCoreBillID AS ").append("fcoreBillId");
            sql.append(" ,Entry.FCoreBillEntrySeq AS ").append("fcoreBillEntrySeq");
            sql.append(" ,Entry.FCoreBillEntryID AS ").append("fcoreBillEntryId");
            sql.append(" ,Entry.FAmountLocal AS ").append("famount");
            sql.append(" ,Entry.FTaxPrice AS ").append("FUnitActualCost");
            sql.append(" ,Entry.FIsFullWriteOff AS ").append("fisFullWriteOff");
        }
        sql.append(" ,Entry.FIsPresent AS ").append("fispresent");
        sql.append(" ,null AS ").append("fstorageOrg");
        sql.append(" ,null AS ").append("fwarehouse");
        sql.append(" ,Entry.fmaterialid AS ").append("fmaterial");
        sql.append(" ,Entry.FBaseUnitID AS ").append("fmaterialBaseUnit");
        sql.append(" ,Entry.FMeasureUnitID AS ").append("fmaterialUnit");
        sql.append(" ,Entry.fassistPropertyid AS ").append("fassistProperty");
        sql.append(" ,null AS ").append("fbatch");
        sql.append(" ,null AS ").append("FLocationID");
        sql.append(" ,Entry.FLocalUnwriteOffAmount AS ").append("funWriteOffAmt");
        sql.append(" ,Entry.fLocalWrittenOffAmount AS ").append("fwrittenOffAmt");
        sql.append(" ,Entry.funWriteOffBaseQty AS ").append("funWriteOffQty");
        sql.append(" ,Entry.fwrittenOffBaseQty AS ").append("fwrittenOffQty");
        sql.append(" ,0 AS ").append("fcurrWriteOffAmt");
        sql.append(" ,0 AS ").append("fcurrWriteOffQty");
        sql.append(" ,Entry.FBaseQty AS ").append("fbaseUnitQty");
        sql.append(" ,Entry.FQuantity AS ").append("fqty");
        sql.append(" ,MATERIALCOMPANY.FAccountType AS ").append("fmaterialAccountType");
        sql.append(" ,MATERIAL.FPricePrecision AS ").append("FPricePrecision");
        sql.append(" ,CASE WHEN MeasureUnitBase.FQtyPrecision IS NULL THEN 4 ELSE MeasureUnitBase.FQtyPrecision END AS ").append("FBaseQtyPrecision");
        sql.append(" ,CASE WHEN MeasureUnit.FQtyPrecision IS NULL THEN 4 ELSE MeasureUnit.FQtyPrecision END AS ").append("FQtyPrecision");
        sql.append(" ,").append(this.Local_Currency_Presision).append(" AS ").append("FLocalCurrencyPrecision");
        sql.append(" ,").append(this.Local_Currency_Presision).append(" AS ").append("FCurrencyPrecision");
        sql.append(" ,CASE WHEN MeasureUnit.FBaseConvsRate IS NULL THEN 1 ELSE MeasureUnit.FBaseConvsRate END AS ").append("fexchangeRateQty");
        sql.append(" ,1 AS ").append("fexchangeRateAmount");
        sql.append(" From ").append(tableName).append(" Entry");
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" INNER JOIN T_AP_Otherbill Bill");
        } else if ("t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" INNER JOIN T_AR_Otherbill Bill");
        }
        sql.append(" ON Entry.FParentId = Bill.FID");
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName)) {
            sql.append(" left join T_IM_PurInWarehsEntry srcEntry on srcEntry.FID = Entry.FSourceBillEntryID");
        }
        sql.append(" Left Join T_SCM_BizType BizType on Bill.FBizTypeID = BizType.FID");
        sql.append(this.takeSQLJoinCommon(tableName));
        return sql;
    }

    private StringBuffer takeSQLJoinCommon(String tableName) {
        String unitName = "FUnitID";
        String companyName = "Entry.FCompanyOrgUnitID";
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName) || "t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            unitName = "FMeasureUnitID";
            companyName = "Bill.FCompanyID";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (Entry.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" AND ").append(companyName).append(" = MATERIALCOMPANY.FCompanyID )");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FId");
        sql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (Entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND Entry.FBaseUnitID = MeasureUnitBase.FMeasureUnitID )");
        sql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit MeasureUnit");
        sql.append(" ON (Entry.FMaterialID = MeasureUnit.FMaterialid");
        sql.append(" AND Entry.").append(unitName).append(" = MeasureUnit.FMeasureUnitID )");
        return sql;
    }

    public ArrayList getTurnOverNoteWriteOffSQLArray() {
        return this.turnOverNoteWriteOffSQLArray;
    }

    protected void handleFullReverseBill(Context ctx, CalculateWrittenOffEntry writeOffEntry, boolean isDevolve) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("select entry.fid as entryID");
        bf.append(" ,entry.fqty as qty");
        bf.append(" ,entry.FPurchaseFee as purchaseFee");
        bf.append(" ,entry.FMaterialCost as materialCost");
        bf.append(" ,ENTRY.FWrittenOffBaseQty as writtenOffBaseQty");
        bf.append(" ,BASECURRENCY.FPrecision as fprecision");
        bf.append(" from t_im_purinwarehsbill as bill");
        bf.append(" inner join t_im_purinwarehsentry as entry");
        bf.append(" on bill.fid = entry.fparentid");
        bf.append(" LEFT OUTER JOIN T_ORG_Company as COMPANYORGUNIT");
        bf.append(" ON ENTRY.FCompanyOrgUnitID = COMPANYORGUNIT.FID");
        bf.append(" LEFT OUTER JOIN T_BD_Currency AS BASECURRENCY");
        bf.append(" ON COMPANYORGUNIT.FBaseCurrencyID = BASECURRENCY.FID");
        bf.append(" where bill.FIsReversed = 1 and bill.ffiVouchered = 0");
        bf.append(" and bill.fbaseStatus=4 and entry.fsourceBillEntryId = ?");
        String queryReverseBillSql = bf.toString();
        Connection conn = null;
        PreparedStatement pm = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pm = conn.prepareStatement(queryReverseBillSql, 1004, 1007);
            pm.setString(1, writeOffEntry.getId());
            rs = pm.executeQuery();
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            BigDecimal purchaseCost = writeOffEntry.getPurchaseCost();
            BigDecimal unitPurchaseCost = writeOffEntry.getUnitPurchaseCost();
            BigDecimal cost = new BigDecimal("0.00");
            BigDecimal actualCost = null;
            BigDecimal unitActualCost = null;
            int i = 0;
            while (rs.next()) {
                int precision = rs.getInt("fprecision");
                String entryID = rs.getString("entryID");
                BigDecimal writtenOffBaseQty = rs.getBigDecimal("writtenOffBaseQty");
                BigDecimal reverseCost = unitPurchaseCost.multiply(rs.getBigDecimal("qty")).setScale(precision, 4);
                if (writeOffEntry.getQty().compareTo(writeOffEntry.getReverseQty()) == 0 && rs.isLast() && ++i > 1) {
                    reverseCost = purchaseCost.subtract(cost).negate();
                } else if (writeOffEntry.getQty().compareTo(writeOffEntry.getReverseQty()) == 0 && rs.isLast() && i == 1) {
                    reverseCost = purchaseCost.negate();
                }
                cost = cost.add(reverseCost.abs());
                actualCost = reverseCost.add(rs.getBigDecimal("purchaseFee").add(rs.getBigDecimal("materialCost")));
                unitActualCost = actualCost.divide(rs.getBigDecimal("qty"), precision, 4);
                map.put("FUnitPurchaseCost", unitPurchaseCost);
                map.put("FPurchaseCost", reverseCost);
                map.put("FActualCost", unitActualCost);
                map.put("FUnitActualCost", actualCost);
                map.put("FWrittenOffAmount", ZERO.compareTo(writtenOffBaseQty) == 0 ? ZERO : reverseCost);
                map.put("FUnWriteOffAmount", ZERO.compareTo(writtenOffBaseQty) == 0 ? reverseCost : ZERO);
                this.createSQLTurnOverNoteWriteOff("t_im_purinwarehsentry", map, entryID);
                this.needReCalcPurInEntryIdList.add(entryID);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{pm}, new ResultSet[]{rs});
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{pm}, new ResultSet[]{rs});
    }

    public void dealCostAdjust(Context ctx, CalculateDiffAmt cDiffSum, CalculateWrittenOffBill calBill, CalculateWrittenOffEntry calEntry, WriteOffGroupInfo writeoffgroupinfo, CostAdjustBillInfo costadjustbillinfo) throws BOSException, EASBizException {
        costadjustbillinfo.setSourceBillId(calBill.getId());
        int size = cDiffSum.diffAmtGroupSize();
        for (int i = 0; i < size; ++i) {
            HashMap infoMap = (HashMap)cDiffSum.getVDiffAmt().get(i);
            BigDecimal diffSum = (BigDecimal)infoMap.get(DIFFSUM);
            String keyFromWhMaterial = CalculateUtil.getCalTypeMaterialKey(this.materialCalType, calEntry.getMaterialId(), this.companyOrgUnitInfo.getId().toString(), costadjustbillinfo.getStorageOrgUnit().getId().toString(), calEntry.getWarehouseId());
            CostAdjustBillEntryInfo caei = CostAdjustHelper.createCostAdjustEntry2(calBill, calEntry, costadjustbillinfo.getEntry().size(), diffSum, true, this.isMerageCostAdjust);
            costadjustbillinfo.getEntry().add(caei);
            WriteOffHelper.createWrittenOffRecord2(ctx, writeoffgroupinfo, costadjustbillinfo, caei, calEntry);
            if (!this.isMerageCostAdjust) {
                CalculateWrittenOffEntry invoEntry = (CalculateWrittenOffEntry)infoMap.get(WRITTEN_OFF_ENTRY);
                invoEntry.setStoreTypeId(calEntry.getStoreTypeId());
                invoEntry.setStoreStateId(calEntry.getStoreStateId());
                CostAdjustBillEntryInfo costAdjEntry = CostAdjustHelper.createCostAdjustEntry2(calBill, invoEntry, costadjustbillinfo.getEntry().size(), diffSum, false, this.isMerageCostAdjust);
                costAdjEntry.setStorageOrgUnit(caei.getStorageOrgUnit());
                costAdjEntry.setWarehouse(caei.getWarehouse());
                costAdjEntry.setLot(caei.getLot());
                costAdjEntry.setUnit(caei.getUnit());
                costAdjEntry.setAssistProperty(calEntry.getAssistProperty());
                costAdjEntry.setProject(caei.getProject());
                costAdjEntry.setTrackNumber(caei.getTrackNumber());
                costadjustbillinfo.getEntry().add(costAdjEntry);
                WriteOffHelper.createWrittenOffRecord2(ctx, writeoffgroupinfo, costadjustbillinfo, costAdjEntry, calEntry);
            }
            BigDecimal otherbillEntryPrice = (BigDecimal)infoMap.get(OTHERBILL_PRICE);
            if (CalConstant.ZERO.compareTo(diffSum) == 0 || !AccountType.MOVE_ADD_AVERAGE.equals((Object)calEntry.getMaterialAccountType())) continue;
            calEntry.setPurInViocePrice(otherbillEntryPrice);
            calEntry.setNumber(costadjustbillinfo.getNumber());
            costadjustbillinfo.put(keyFromWhMaterial, calEntry);
        }
    }

    protected void purInwareBillUpdate4FullWriteOff(String sql) {
        this.turnOverNoteWriteOffSQLArray.add(sql);
    }

    protected boolean isReturnBiz(Context ctx, String riType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select top 1 1 from T_IM_RecIssueType ").append(" where fbizDirection = ").append(-1).append(" and fid = '").append(riType).append("' ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected String getExtendSaleIssueBillSelector() {
        StringBuffer selector = new StringBuffer();
        selector.append(" ,NULL AS ").append("fsupplier");
        selector.append(" ,Bill.FCustomerid AS ").append("fcustomer");
        selector.append(" ,Bill.FPaymentTypeID AS ").append("paymentType");
        selector.append(" ,Entry.FIsFullWriteOff AS ").append("fisFullWriteOff");
        selector.append(" ,Entry.FSaleOrderID AS ").append("fcoreBillId");
        selector.append(" ,Entry.FSaleOrderNumber AS ").append("fcoreBillNumber");
        selector.append(" ,Entry.FSaleOrderEntrySeq AS ").append("fcoreBillEntrySeq");
        selector.append(" ,Entry.FSaleOrderEntryID AS ").append("fcoreBillEntryId");
        selector.append(" ,Entry.FUnwriteOffAmount AS ").append("funWriteOffAmt");
        selector.append(" ,Entry.FWrittenOffAmount AS ").append("fwrittenOffAmt");
        selector.append(" ,Entry.FUnWriteOffBaseQty AS ").append("funWriteOffQty");
        selector.append(" ,Entry.FWrittenOffBaseQty AS ").append("fwrittenOffQty");
        return selector.toString();
    }

    protected String getExtendPurInBillSelector() {
        StringBuffer selector = new StringBuffer();
        selector.append(" ,Bill.FExchangeRate AS ").append("FExchangeRate");
        selector.append(" ,Bill.FCurrencyID AS ").append("FCurrencyID");
        selector.append(" ,Bill.FSupplierid AS ").append("fsupplier");
        selector.append(" ,NULL AS ").append("fcustomer");
        selector.append(" ,Bill.FPurchaseType AS ").append("FPurchaseType");
        selector.append(" ,Entry.FIsFullWriteOff AS ").append("fisFullWriteOff");
        selector.append(" ,Entry.FReverseQty AS ").append("freverseQty");
        selector.append(" ,Entry.FTax AS ").append("FTax");
        selector.append(" ,Entry.FLocalTax AS ").append("FLocalTax");
        selector.append(" ,Entry.FLocalAmount AS ").append("FLocalAmount");
        selector.append(" ,Entry.FAmount AS ").append("FAmount2");
        selector.append(" ,Entry.FPurchaseCost AS ").append("purchaseCost");
        selector.append(" ,Entry.FPurchaseFee AS ").append("purchaseFee");
        selector.append(" ,Entry.FMaterialCost AS ").append("materialCost");
        selector.append(" ,Entry.FDosingType AS ").append("dosingType");
        selector.append(" ,Entry.FDiscountRate AS ").append("FDiscountRate");
        selector.append(" ,Entry.FDiscountAmount AS ").append("FDiscountAmount");
        selector.append(" ,Entry.FTaxRate AS ").append("FtaxRate");
        selector.append(" ,Entry.FPurOrderID AS ").append("fcoreBillId");
        selector.append(" ,Entry.FPurOrderNumber AS ").append("fcoreBillNumber");
        selector.append(" ,Entry.FPurOrderEntrySeq AS ").append("fcoreBillEntrySeq");
        selector.append(" ,Entry.FPurOrderEntryID AS ").append("fcoreBillEntryId");
        selector.append(" ,Entry.FUnwriteOffAmount AS ").append("funWriteOffAmt");
        selector.append(" ,Entry.FWrittenOffAmount AS ").append("fwrittenOffAmt");
        selector.append(" ,Entry.FUnWriteOffBaseQty AS ").append("funWriteOffQty");
        selector.append(" ,Entry.FWrittenOffBaseQty AS ").append("fwrittenOffQty");
        selector.append(" ,Entry.FProjectID as ").append("FProjectID");
        selector.append(" ,Entry.FTrackNumberID as ").append("FTrackNumberID");
        return selector.toString();
    }

    protected MappingFieldCollection getSameSideMappingField(String[] field) {
        MappingFieldCollection coll = new MappingFieldCollection();
        MappingFieldInfo info = null;
        int len = field.length;
        for (int i = 0; i < len; ++i) {
            info = new MappingFieldInfo();
            info.setSecField(field[i]);
            coll.add(info);
        }
        return coll;
    }

    protected void checkMaterialCompany(Context ctx, CoreBillBaseInfo bill, String tableName) throws BOSException, CalculateException {
        String companyName = "Entry.FCompanyOrgUnitID";
        if ("t_ap_otherbillentry".equalsIgnoreCase(tableName) || "t_ar_otherbillentry".equalsIgnoreCase(tableName)) {
            companyName = "Bill.FCompanyID";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select MATERIAL.Fnumber as Fnumber, Entry.FSeq as FSeq, ");
        sql.append(" COMPANY.Fnumber as FCompany from ").append(tableName).append(" entry");
        String billTabName = InventoryBillHelper.getBillTabNameByEntryTabName(tableName);
        sql.append(" INNER JOIN ").append(billTabName).append(" Bill ON Entry.FParentId = Bill.FID");
        sql.append(" LEFT JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (Entry.FMaterialID = MATERIALCOMPANY.FMaterialID");
        sql.append(" AND ").append(companyName).append(" = MATERIALCOMPANY.FCompanyID )");
        sql.append(" INNER JOIN T_BD_Material MATERIAL ");
        sql.append(" ON Entry.FMaterialID = MATERIAL.FID");
        sql.append(" INNER JOIN T_ORG_COMPANY COMPANY ON COMPANY.FID = ").append(companyName);
        sql.append(" WHERE Bill.FID = ? and MATERIALCOMPANY.FAccountType = 1 and MATERIALCOMPANY.FStatus = 0");
        sql.append(" Order by Entry.FSeq");
        try {
            StringBuffer msg = new StringBuffer();
            String EntrySeq_Mat = EASResource.getString((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"EntrySeq_Mat", (Locale)ctx.getLocale());
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bill.getId().toString()});
            while (rs.next()) {
                msg.append("\n").append(MessageFormat.format(EntrySeq_Mat, rs.getInt("FSeq"), rs.getString("FNumber"), rs.getString("FCompany")));
            }
            if (msg.length() > 0) {
                throw new CalculateException(CalculateException.COMMON, new Object[]{msg.toString()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

