/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostComputeReportInfo;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.BalanceCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateBill;
import com.kingdee.eas.scm.cal.app.calculate.FIFOCalculate;
import com.kingdee.eas.scm.cal.app.calculate.InvBillPriceCalculate;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.ICalculateCost;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.IDBExtends;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.onekey.multipleJob.ThreadLocalHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.tools.SQLUtils;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public abstract class AbstractCalculateCost
extends AbstractCalculateBill
implements ICalculateCost,
IDBExtends {
    private Logger logger = Logger.getLogger(FIFOCalculate.class);
    public static String[] calKindFilterField = new String[]{"FCompanyOrgUnitID", "Fstorageorg", "Fwarehouse"};
    protected static final int PAGE_COUNT = 10000;
    protected static final int PAGE_COUNT_NEW = 1000;
    protected static final int NEW_OUT_PRICE = 0;
    protected static final int NEW_IN_PRICE = 1;
    protected static final int STANDARD_PRICE = 2;
    protected static final int MANUAL_HAND = 3;
    protected static final int NEW_OUT_RETURN_PRICE = 4;
    protected static final String IS_DEAL_COMPLETE = "IS_DEAL_COMPLETE";
    protected static final String IS_MINUS_SETTLEACCOUNT = "IS_MINUS_SETTLEACCOUNT";
    protected static final String UPDATEBILLSQL = "updateBillSQL";
    protected static final String DETAILCOMPUTEREOPRTSQL = "detailReportSQL";
    protected static final String INVENTORYBALANCELIST = "InventoryBalanceList";
    protected static final String CONNECTION = "connection";
    protected static final String MATERIAL_BALANCE_MAP = "MATERIAL_BALANCE_MAP";
    protected static final String EAS_HOME = System.getProperty("EAS_HOME");
    protected int costReportCount = 0;
    protected ArrayList<Exception> ExceptionList = new ArrayList();
    protected int priceType = 0;
    protected static final String RESOURCE = "com.kingdee.eas.scm.cal.CALAutoGenerateResource";
    protected ArrayList<HashMap> updateMovLocList = new ArrayList();
    protected PeriodInfo currPeriod = null;
    protected static int threadPoolNum = 2;

    public void calculateCost(Context ctx, CompanyOrgUnitInfo aCompanyOrgUnitInfo, PeriodInfo aPeriodInfo, String materialCalType, BigDecimal amount, BigDecimal qty, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry) throws BOSException, EASBizException {
    }

    public int getMaterialPageCount(SysTempTableHelper sysTempTableHelper, String tempMaterialTable) throws BOSException {
        int count = sysTempTableHelper.getRowsCount(tempMaterialTable);
        int batch = 0;
        batch = count % 1000 == 0 ? count / 1000 : count / 1000 + 1;
        return batch;
    }

    @Override
    public boolean calculateCost(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        this.init(ctx, params);
        String strCalType = params.getString("CALTYPE");
        this.currPeriod = periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        this.calculateStrategy(ctx, params, strCalType, periodInfo, sysTempTableHelper);
        if (StringUtil.isEmpty((String)params.getString("Colse_Account_Table"))) {
            this.doJumpOrgBills(ctx, params, strCalType, periodInfo, sysTempTableHelper);
        }
        return true;
    }

    private void init(Context ctx, CalculateParams params) throws EASBizException, BOSException {
        this.initParams(ctx, params);
        this.updateMovLocList.clear();
    }

    private void initParams(Context ctx, CalculateParams params) throws BOSException, EASBizException {
        String companyOrgID = params.getString("COMPANY_ID");
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (companyOrgID != null) {
            companyOrgUnitInfo = new CompanyOrgUnitInfo();
            companyOrgUnitInfo.setId(BOSUuid.read((String)params.getString("COMPANY_ID")));
        } else {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("company");
        }
        if (companyOrgUnitInfo == null || companyOrgUnitInfo.getId() == null) {
            throw new CalculateException(CalculateException.FINANCE_ORG_NOT_EXIST);
        }
        if (companyOrgID == null) {
            companyOrgID = companyOrgUnitInfo.getId().toString();
            params.setString("COMPANY_ID", companyOrgID);
        }
        int presision = 2;
        try {
            presision = params.getInt("Local_Currency_Presision");
            if (presision <= 0) {
                presision = CalculateUtil.getLocalCurrencyPrecision2(ctx, companyOrgUnitInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo periodInfo = null;
        if (params.getObject("PERIOD_OBJ") == null) {
            periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo);
            if (periodInfo == null) {
                companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()));
                throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
            }
        } else {
            periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        }
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String strCalType = params.getString("CALTYPE");
        if (strCalType == null) {
            strCalType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "SCM_CAL_002");
        }
        boolean isNotSrcBill = CalculateUtil.getCostCalculateParam(ctx, companyOrgID, "SCM_CAL_014");
        boolean srcBillisPreperiod = CalculateUtil.getCostCalculateParam(ctx, companyOrgID, "SCM_CAL_015");
        params.setBoolean("isNotSrcOutBillCalType", isNotSrcBill);
        params.setBoolean("isSrcPerBillOutBillCalType", srcBillisPreperiod);
        this.writeCostType = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "SCM_CAL_016");
        params.setString("CostType", this.writeCostType);
        this.priceType = Integer.parseInt(iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(companyOrgID), "SCM_CAL_017"));
        boolean isChkEntrust = CalculateUtil.getCostCalculateParam(ctx, companyOrgID, "SCM_CAL_022");
        params.setBoolean("isChkEntrust", isChkEntrust);
        params.setObject("COMPANY_OBJ", (Object)companyOrgUnitInfo);
        params.setInt("Local_Currency_Presision", presision);
        params.setObject("PERIOD_OBJ", (Object)periodInfo);
        params.setString("CALTYPE", strCalType);
        params.setBoolean("isCalMovLocBill", CalculateUtil.getCostCalculateParam(ctx, companyOrgID, "SCM_CAL_029"));
        params.setBoolean("isGetBlueIssueCost", CalculateUtil.getCostCalculateParam(ctx, companyOrgID, "SCM_CAL_031"));
    }

    @Override
    protected abstract AccountType[] takeMaterialAccountType();

    protected abstract boolean calculateStrategy(Context var1, CalculateParams var2, String var3, PeriodInfo var4, SysTempTableHelper var5) throws BOSException, EASBizException;

    @Override
    public String createTempTable(Context ctx, String[][] fields) throws BOSException, EASBizException {
        String serial = this.getTempTableSerialVersionUID();
        if (StringUtil.isEmpty((String)serial)) {
            serial = new Long(new Date().getTime()).toString().substring(8);
        }
        return DBUtil.createTempTable(ctx, serial, fields);
    }

    @Override
    public void dropTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        DBUtil.dropTempTable(ctx, tempTableName);
    }

    protected StringBuffer takeMatrialList(Context ctx, String strCalType, String tempTableName) {
        String storage = "null as fstorageorgunitid";
        String warehouse = "null as Fwarehouseid";
        if (!"0".equals(strCalType)) {
            storage = "fstorageorgunitid";
        }
        if ("2".equals(strCalType)) {
            warehouse = "Fwarehouseid";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FMaterialId ,FmaterialNumber,FCompanyOrgUnitID");
        sql.append(" ,").append(storage);
        sql.append(" ,").append(warehouse);
        sql.append(" ,0,FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision");
        sql.append(" FROM ").append(tempTableName).append("\r\n");
        sql.append(" AS Entry ");
        sql.append(" GROUP By FmaterialNumber,");
        sql.append(this.getGroupSegmentByCalType(strCalType, false, this.INVENTORY_FIELD_NEW));
        sql.append(",FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision");
        return sql;
    }

    protected StringBuffer takeMatrialListNew(Context ctx, String strCalType, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FMaterialId ,FmaterialNumber,FCompanyOrgUnitID");
        sql.append(" ,FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision");
        sql.append(" FROM ").append(tempTableName).append("\r\n");
        sql.append(" AS Entry ");
        sql.append(" GROUP By FmaterialNumber,");
        sql.append(this.getGroupSegmentByCalTypeNew(strCalType, false, this.INVENTORY_FIELD_NEW));
        sql.append(",FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision");
        return sql;
    }

    protected void updateCombitionRetBill(Connection conn, CalculateParams params, String tempTableName) throws BOSException, SQLException {
        String tempAssistTable = params.getString("T_Temp_ASSISTTABLE");
        DBUtil.execute(conn, "insert into " + tempAssistTable + "(FID,FBaseQty,FActualCost,FOutwarehouseType,FEntryTableMame) " + this.getInsertCombitionRetBillSQL(tempTableName));
        DBUtil.execute(conn, this.getUpdateCombitionSrcBillSql(tempTableName, tempAssistTable).toString());
        DBUtil.execute(conn, this.getUpdateCombitionRetBillSql(tempTableName, tempAssistTable).toString());
        DBUtil.execute(conn, " TRUNCATE TABLE " + tempAssistTable);
    }

    protected String getUpdateCombitionSrcBillSql(String fifoBillTmpTabName, String tempAssistTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append(" as T1").append("\t\n");
        buffer.append(" SET (FBaseQty,FActualCost,FisCombition) =(");
        buffer.append("\n SELECT T2.FBaseQty,T2.FActualCost,T2.FOutwarehouseType FROM ");
        buffer.append(tempAssistTable).append(" AS T2 ");
        buffer.append("\n WHERE ").append("T1.FID = T2.FID");
        buffer.append(")");
        return buffer.toString();
    }

    protected String getUpdateCombitionRetBillSql(String fifoBillTmpTabName, String tempAssistTable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append("\t\n");
        buffer.append(" SET FisCombition = 2 ").append("\t\n");
        buffer.append(" WHERE FID IN (SELECT T2.FID FROM ").append(tempAssistTable).append(" T1");
        buffer.append(" INNER JOIN ").append(fifoBillTmpTabName).append(" T2 ON T1.FID = T2.FSourceBillEntryID AND T1.FEntryTableMame = T2.FEntryTableMame)");
        return buffer.toString();
    }

    protected String getInsertCombitionRetBillSQL(String fifoBillTmpTabName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n SELECT T2.FID,(T1.FBASEQTY+T2.FBASEQTY) AS FBASEQTY,(T1.FACTUALCOST+T2.FACTUALCOST) AS FACTUALCOST, 1 AS FisCombition, T2.FEntryTableMame  FROM ");
        buffer.append("\n (SELECT FSourceBillEntryID,FEntryTableMame,SUM(FBaseQty) AS FBASEQTY ,SUM(FActualCost) AS FACTUALCOST FROM ");
        buffer.append(fifoBillTmpTabName);
        buffer.append("\n WHERE FSourceBillEntryID IS NOT NULL");
        buffer.append(" AND FEntryTableMame != 't_cl_costadjustbillentry' AND FEntryTableMame != 'T_CL_InventoryBalance' ");
        buffer.append("\n GROUP BY FSourceBillEntryID,FEntryTableMame) AS T1");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTabName).append(" AS T2");
        buffer.append("\n ON (t1.FSOURCEBILLENTRYID = T2.FBillEntryId AND T1.FEntryTableMame = T2.FEntryTableMame)");
        buffer.append("\n WHERE T1.FBASEQTY * T2.FBASEQTY < 0");
        return buffer.toString();
    }

    protected String getUpdateCombitionAjdustBillSql(String fifoBillTmpTabName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append(" AS T3");
        buffer.append(" SET (FBaseQty,FActualCost,FisCombition) =(");
        buffer.append("\n SELECT (T1.FBASEQTY+T2.FBASEQTY) AS FBASEQTY,(T1.FACTUALCOST+T2.FACTUALCOST) AS FACTUALCOST ,1 AS FisCombition FROM ");
        buffer.append("\n (SELECT FSourceBillEntryID AS FSourceBillEntryID ,SUM(FBaseQty) AS FBASEQTY ,SUM(FActualCost) AS FACTUALCOST FROM ").append(fifoBillTmpTabName);
        buffer.append("\n WHERE FSourceBillEntryID IS NOT NULL");
        buffer.append("  AND FEntryTableMame ='").append("t_cl_costadjustbillentry").append("'");
        buffer.append("\n GROUP BY FSourceBillEntryID) AS T1");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTabName).append(" AS T2");
        buffer.append("\n ON t1.FSOURCEBILLENTRYID = T2.FBillEntryId");
        buffer.append("\n WHERE T3.FID = T2.FID)");
        return buffer.toString();
    }

    protected String getUpdateCombitionBizDateSQL(String fifoBillTmpTabName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append(" AS T1");
        buffer.append("\n SET (FBizDate,FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT TOP 1 ADD_SECONDS(T2.FBIZDATE,1),1 FROM ").append(fifoBillTmpTabName).append(" AS T2");
        buffer.append("\n WHERE T1.FSourceBillEntryID = T2.FBillEntryId ");
        buffer.append("\n AND T2.FISCOMBITION = 1");
        buffer.append("\n )");
        return buffer.toString();
    }

    protected String getUpateCostAdjustBillDate(String fifoBillTmpTalbe, PeriodInfo period) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T ");
        buffer.append("\n SET (FBizDate) = (");
        buffer.append("\n SELECT FBEGINDATE  FROM T_BD_PERIOD WHERE T_BD_PERIOD.FID ='");
        buffer.append(period.getId().toString()).append("')");
        buffer.append("\n WHERE T.FBILLTYPEID = '").append("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552").append("'");
        buffer.append("\n AND EXISTS(SELECT 1 FROM T_CL_CostAdjustBill BILL WHERE BILL.FID = T.FBILLID AND BILL.FCREATETYPE <> 1)");
        buffer.append("\n AND T.FISCOMBITION = 0");
        return buffer.toString();
    }

    protected String[] getUpateMaterialReqPriceFromPrePeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_MATERIALREQBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MATERIALREQBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID");
        buffer.append("\n AND T1.FENTRYTABLEMAME ='T_IM_MaterialReqBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(") ");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n )");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid  \n FROM  T_IM_MATERIALREQBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MATERIALREQBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID");
        buffer.append("\n AND T1.FENTRYTABLEMAME ='T_IM_MaterialReqBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n )");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String[] getUpateSaleIssuePriceFromPrePeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        String[] sqls = new String[4];
        StringBuffer buffer = new StringBuffer();
        StringBuffer joinSql = new StringBuffer();
        joinSql.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        joinSql.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer = this.getUpdateSaleIssuePriceForPrePeriod(fifoBillTmpTalbe, period, joinSql);
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        joinSql.setLength(0);
        joinSql.append("\n INNER JOIN T_SD_SALERETURNSENTRY sen ON ENTRY.FID = sen.FSOURCEBILLENTRYID ");
        joinSql.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        joinSql.append("\n ON sen.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer = this.getUpdateSaleIssuePriceForPrePeriod(fifoBillTmpTalbe, period, joinSql);
        sqls[1] = buffer.toString();
        buffer.setLength(0);
        joinSql.setLength(0);
        joinSql.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        joinSql.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer = this.getUpdateSaleIssueFlagForPrePeriod(fifoBillTmpTalbe, period, joinSql);
        sqls[2] = buffer.toString();
        buffer.setLength(0);
        joinSql.setLength(0);
        joinSql.append("\n INNER JOIN T_SD_SALERETURNSENTRY sen ON ENTRY.FID = sen.FSOURCEBILLENTRYID ");
        joinSql.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        joinSql.append("\n ON sen.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer = this.getUpdateSaleIssueFlagForPrePeriod(fifoBillTmpTalbe, period, joinSql);
        sqls[3] = buffer.toString();
        return sqls;
    }

    private StringBuffer getUpdateSaleIssuePriceForPrePeriod(String fifoBillTmpTalbe, PeriodInfo period, StringBuffer joinSql) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_SALEISSUEENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_SALEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append(joinSql);
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry' and T1.FFIVOUCHERED = 0");
        return buffer;
    }

    private StringBuffer getUpdateSaleIssueFlagForPrePeriod(String fifoBillTmpTalbe, PeriodInfo period, StringBuffer joinSql) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid \n FROM  T_IM_SALEISSUEENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_SALEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append(joinSql);
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry' ");
        return buffer;
    }

    protected String[] getUpateOtherIssuePriceFromPrePeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_OtherIssueBillEntry ENTRY ");
        buffer.append("\n INNER JOIN T_IM_OtherIssueBill bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_OtherIssueBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_OtherIssueBillEntry' and T1.FFIVOUCHERED = 0");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid \n FROM  T_IM_OtherIssueBillEntry ENTRY ");
        buffer.append("\n INNER JOIN T_IM_OtherIssueBill bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_OtherIssueBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_OtherIssueBillEntry' ");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String getInserCostExcepRptPrepSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO T_CL_CostComputeExcepRpt(FID ,FBillId,FNumber,FEntryID,FEntrySeq,");
        buffer.append("FYER,FPERIOD,FMaterialID,FExceptionType,FQty,");
        buffer.append("FUnitActualCost,FActualCost,FComment,FCreatorID,FCreateTime)");
        buffer.append("\n (?,?,?,?,?,");
        buffer.append("?,?,?,?,?,");
        buffer.append("?,?,?,?,?)");
        return buffer.toString();
    }

    protected String getInertBillZeroSQL(Context ctx, String billTempTablename, PeriodInfo period, int accountType, CalculateParams params, String strCalType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO T_CL_CostComputeExcepRpt(FID ,FBillId,FNumber,FEntryID,FEntrySeq,");
        buffer.append("FYEAR,FPERIOD,FMaterialID,FExceptionType,FQty,");
        buffer.append("FUnitActualCost,FActualCost,FComment,FCreatorID,FCreateTime,");
        buffer.append("FCompanyorgunitID,FStorageorgunitID,FWarehouseID)");
        buffer.append("\n SELECT NEWBOSID('99999999'),T1.FBillId,T1.FNumber,T1.FBillEntryId,T1.FSeqNum,");
        buffer.append("\n " + period.getPeriodYear() + "," + period.getPeriodNumber() + ",T1.FMaterialId,0,T1.FBaseQty,");
        buffer.append("\n T1.FPrice,T1.FActualCost,'" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"INBILLCOSTZERO", (Context)ctx) + "',null,now(),");
        buffer.append("\n FCompanyorgunitID,FStorageorgunitID,FWarehouseID");
        buffer.append("\n FROM ").append(billTempTablename).append(" AS T1 ");
        buffer.append("\n INNER JOIN T_BD_MATERIAL MATERIAL ON T1.FMATERIALID = MATERIAL.FID");
        buffer.append("\n WHERE FCalculateKind =0 AND FPrice <=0 ");
        buffer.append("\n AND FEntryTableMame !='t_cl_costadjustbillentry'");
        buffer.append("\n AND T1.FISPRESENT = 0 ");
        buffer.append("\n and T1.FBizTypeID NOT in (");
        buffer.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        buffer.append(" ,'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        buffer.append(" ,'").append("kXeVPjHuchDgQKjAYj1RYCQHQ1w=").append("'");
        buffer.append(" ,'").append("kXeVPjF4chDgQKjAYj1RYCQHQ1w=").append("'");
        buffer.append(" ,'").append("kXeVPjGzchDgQKjAYj1RYCQHQ1w=").append("'");
        buffer.append(" ,'").append("kXeUoXWkByTgQKjAYj1F6CQHQ1w=").append("'");
        buffer.append(" ,'").append("kXeUoXXfByTgQKjAYj1F6CQHQ1w=").append("'");
        buffer.append(")");
        buffer.append(this.takeMaterialNumberWhereSQL(params));
        buffer.append(this.getFilterByCalTypeNojoin(strCalType, params, calKindFilterField));
        return buffer.toString();
    }

    protected String getInsertCostcomputeRptBillZeroSQL(Context ctx, String billTempTablename, PeriodInfo period, int accountType, CalculateParams params, String strCalType) {
        StringBuffer sb = new StringBuffer();
        sb.append("Insert Into T_CL_CostcomputeReport(");
        sb.append("FID,FBillName,FBillNumber,FTimeSerialNumber,FCreateTime");
        sb.append(",\n FCalculateKind,FIncome,FPayout,FSettleAccounts,FMaterialID");
        sb.append(",\n FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FYear,FPeriod");
        sb.append(",\n FControlUnitID,FAccountType");
        sb.append(")");
        sb.append("\n SELECT NEWBOSID('99999999'),T1.FBillTypeName,T1.FNumber,TO_CHAR(T1.FSeqNum),now(),");
        sb.append("\n T1.FCalculateKind,CONCAT(CONCAT(CONCAT(CONCAT(TO_CHAR(T1.FBaseQty), ' * '), TO_CHAR(T1.FPrice)),' ='),TO_CHAR(T1.FActualCost)) AS  inCome,null, CONCAT(CONCAT(CONCAT(CONCAT(TO_CHAR(T1.FBaseQty), ' * '),TO_CHAR( T1.FPrice)), ' =' ),TO_CHAR(T1.FActualCost) ) AS FSettleAccounts,T1.FMaterialID,");
        sb.append("\n T1.FCompanyOrgUnitID,T1.Fstorageorgunitid,T1.Fwarehouseid," + period.getPeriodYear() + "," + period.getPeriodNumber());
        sb.append(",'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sb.append("," + accountType);
        sb.append("\n FROM ").append(billTempTablename).append(" AS T1");
        sb.append("\n INNER JOIN T_BD_MATERIAL MATERIAL ON T1.FMATERIALID = MATERIAL.FID");
        sb.append("\n WHERE FCalculateKind =0 AND FPrice <=0");
        sb.append("\n AND T1.FISPRESENT = 0 ");
        sb.append("\n AND FEntryTableMame !='t_cl_costadjustbillentry'");
        sb.append("\n and T1.FBizTypeID NOT in (");
        sb.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        sb.append(" ,'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        sb.append(")");
        sb.append(this.takeMaterialNumberWhereSQL(params));
        sb.append(this.getFilterByCalTypeNojoin(strCalType, params, calKindFilterField));
        return sb.toString();
    }

    protected boolean checkExistBillZero(Context ctx, Connection con, String billTempTablename, PeriodInfo period, int accountType, CalculateParams params, String strCalType) throws BOSException, SQLException {
        String[] sqls = new String[3];
        String companyOrgID = params.getString("COMPANY_ID");
        Set storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
        Set wareHouseIds = (Set)params.getObject("WAREHOUSEID");
        sqls[0] = "TRUNCATE TABLE T_CL_CostComputeExcepRpt";
        sqls[1] = this.getInsertCostcomputeRptBillZeroSQL(ctx, billTempTablename, period, accountType, params, strCalType);
        sqls[2] = this.getInertBillZeroSQL(ctx, billTempTablename, period, accountType, params, strCalType);
        DBUtil.execute(con, sqls);
        StringBuffer buffer = new StringBuffer();
        buffer.setLength(0);
        buffer.append("SELECT 1 FROM T_CL_CostComputeExcepRpt T1 ");
        buffer.append("\n INNER JOIN T_BD_MATERIAL MATERIAL ON T1.FMATERIALID = MATERIAL.FID");
        buffer.append("\n WHERE FYEAR = " + period.getPeriodYear() + " AND FPERIOD =" + period.getPeriodNumber());
        buffer.append(this.takeMaterialNumberWhereSQL(params));
        if (!StringUtil.isEmpty((String)companyOrgID)) {
            buffer.append(" AND FCompanyOrgUnitID = '").append(companyOrgID).append("'").append("\t\n");
        }
        if ("2".equals(strCalType)) {
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                buffer.append(" AND FStorageorgunitID in ").append(orgIds).append("\t\n");
            }
            if (wareHouseIds != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                buffer.append(" AND FWarehouseID in ").append(warehouseIds).append("\t\n");
            }
        } else if ("1".equals(strCalType) && storageOrgBegs != null && storageOrgBegs.size() > 0) {
            String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
            buffer.append(" AND FStorageorgunitID in ").append(orgIds).append("\t\n");
        }
        return DBUtil.takeValue(con, buffer.toString()) != null;
    }

    protected RecentCostInfo getCombitionList(Context ctx, ArrayList list) {
        RecentCostInfo bill = null;
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                bill = (RecentCostInfo)((RecentCostInfo)list.get(i)).clone();
                bill.setRecentCost(CalculateUtil.ZERO);
            }
            bill.setRecentCost(bill.getRecentCost().add(((RecentCostInfo)list.get(i)).getRecentCost()));
        }
        bill.setRecentQty(CalculateUtil.ZERO);
        bill.setInt("FCalculateKind", 0);
        bill.setString("FNumber", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMBITIONCOSTAJDJUST", (Context)ctx));
        return bill;
    }

    protected void insertFIFOMaterialTMPTable(SysTempTableHelper sysTempTableHelper, StringBuffer buffer, String fifoMaterialTmpTable) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(fifoMaterialTmpTable);
        sql.append(" (FMaterialId,FmaterialNumber,FCompanyOrgUnitID,Fstorageorgunitid,");
        sql.append("\n Fwarehouseid, FIsHasPayoutBill,FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision)");
        sql.append("\n").append(buffer.toString());
        sysTempTableHelper.execute(sql.toString());
    }

    protected void insertFIFOMaterialTMPTableNew(SysTempTableHelper sysTempTableHelper, StringBuffer buffer, String fifoMaterialTmpTable) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(fifoMaterialTmpTable);
        sql.append(" (ksql_seq,FMaterialId,FmaterialNumber,FCompanyOrgUnitID,");
        sql.append("\n FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision)");
        sql.append("\n").append(buffer.toString());
        sysTempTableHelper.execute(sql.toString());
    }

    protected boolean adjustPeriodBegin(ArrayList inList, RecentCostInfo combitionAdjust) {
        RecentCostInfo info;
        if (inList.size() > 0 && !(info = (RecentCostInfo)inList.get(0)).equals(combitionAdjust)) {
            info.setRecentCost(info.getRecentCost().add(combitionAdjust.getRecentCost()));
            if (CalculateUtil.ZERO.compareTo(info.getRecentQty()) != 0) {
                info.setPrice(info.getRecentCost().divide(info.getRecentQty(), info.getInt("FPricePrecision"), 4));
            }
            return true;
        }
        return false;
    }

    protected boolean calculateCurrentUnitCost2(Context ctx, ArrayList rsInpour, RecentCostInfo rsPayout, BigDecimal newInpPrice, ArrayList listPayout, String strCalType) throws BOSException, EASBizException {
        boolean isExceptionState = false;
        boolean isNoNeedUpdate = rsPayout.isDealComplete() || rsPayout.isNeedUpdate();
        BigDecimal baseqtyPayout = rsPayout.getRecentQty();
        BigDecimal amtPayout = rsPayout.getRecentCost();
        BigDecimal pricePayout = rsPayout.getPrice();
        if (rsInpour == null || rsInpour.size() == 0) {
            rsPayout.setBoolean(IS_MINUS_SETTLEACCOUNT, true);
            rsPayout.setRecentQty(baseqtyPayout);
            rsPayout.setRecentCost(CalculateUtil.ZERO);
            rsPayout.setPrice(CalculateUtil.ZERO);
        }
        BigDecimal minTotalQty = CalculateUtil.ZERO;
        BigDecimal mintotalAmount = CalculateUtil.ZERO;
        BigDecimal baseqtyInpour = CalculateUtil.ZERO;
        BigDecimal amtInpour = CalculateUtil.ZERO;
        BigDecimal totalQty = CalculateUtil.ZERO;
        for (int i = 0; i < rsInpour.size(); ++i) {
            RecentCostInfo settleAccounts = (RecentCostInfo)rsInpour.get(i);
            totalQty = totalQty.add(settleAccounts.getRecentQty());
        }
        if (rsPayout.getRecentQty().compareTo(totalQty) > 0) {
            rsPayout.setBoolean(IS_MINUS_SETTLEACCOUNT, true);
        }
        BigDecimal addUpAmount = CalculateUtil.ZERO;
        BigDecimal addUpQty = CalculateUtil.ZERO;
        for (int i = 0; i < rsInpour.size(); ++i) {
            boolean isBreak = true;
            RecentCostInfo settleAccounts = (RecentCostInfo)rsInpour.get(i);
            if (settleAccounts.getBoolean(IS_MINUS_SETTLEACCOUNT)) continue;
            baseqtyInpour = settleAccounts.getRecentQty();
            amtInpour = settleAccounts.getRecentCost();
            BigDecimal priceInpour = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(settleAccounts.getPrice()) < 0) {
                newInpPrice = settleAccounts.getPrice();
            }
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0) {
                priceInpour = amtInpour.divide(baseqtyInpour, rsPayout.getInt("FPricePrecision"), 4);
            }
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) == 0 && CalculateUtil.ZERO.compareTo(amtInpour) == 0) continue;
            addUpAmount = addUpAmount.add(amtInpour);
            addUpQty = addUpQty.add(baseqtyInpour);
            BigDecimal addUpPrice = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(addUpQty) != 0) {
                addUpPrice = addUpAmount.divide(addUpQty, rsPayout.getInt("FPricePrecision"), 4);
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) >= 0) {
                addUpPrice = newInpPrice;
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) >= 0) {
                addUpPrice = pricePayout;
            }
            minTotalQty = addUpQty;
            mintotalAmount = addUpAmount;
            if (!rsPayout.isCostAdjustBill()) {
                if (baseqtyPayout.compareTo(addUpQty) > 0) {
                    baseqtyInpour = CalculateUtil.ZERO;
                    amtInpour = CalculateUtil.ZERO;
                    if (i == rsInpour.size() - 1) {
                        if (CalculateUtil.ZERO.compareTo(addUpPrice) > 0) {
                            baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                            amtInpour = addUpAmount.subtract(amtPayout);
                            isExceptionState = true;
                            return isExceptionState;
                        }
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                        if (!isNoNeedUpdate) {
                            amtPayout = addUpPrice.multiply(baseqtyPayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4);
                            pricePayout = addUpPrice;
                        }
                        amtInpour = addUpAmount.subtract(amtPayout);
                    }
                    if (i < rsInpour.size() - 1 && rsPayout.getBoolean(IS_MINUS_SETTLEACCOUNT)) {
                        rsPayout.setBigDecimal("addUpQty", minTotalQty);
                        rsPayout.setBigDecimal("addUpAmount", mintotalAmount);
                    }
                    isBreak = false;
                } else if (baseqtyPayout.compareTo(addUpQty) == 0) {
                    if (CalculateUtil.ZERO.compareTo(addUpAmount) < 0) {
                        if (rsPayout.getInt("FFiVouchered") == 0) {
                            if (!isNoNeedUpdate) {
                                amtPayout = addUpAmount;
                            }
                            pricePayout = amtPayout.divide(baseqtyPayout, rsPayout.getInt("FPricePrecision"), 4);
                            if (CalculateUtil.ZERO.compareTo(rsPayout.getBigDecimal("FReverseQty")) != 0) {
                                if (!isNoNeedUpdate) {
                                    amtPayout = pricePayout.multiply(baseqtyPayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4);
                                }
                                amtInpour = addUpAmount.subtract(amtPayout);
                            } else {
                                amtInpour = CalculateUtil.ZERO;
                            }
                            baseqtyInpour = CalculateUtil.ZERO;
                        } else {
                            amtPayout = rsPayout.getRecentCost();
                            baseqtyInpour = CalculateUtil.ZERO;
                            amtInpour = addUpAmount.subtract(amtPayout);
                        }
                    } else {
                        if (i == rsInpour.size() - 1) {
                            baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                            amtInpour = addUpAmount.subtract(amtPayout);
                            isExceptionState = true;
                            return isExceptionState;
                        }
                        baseqtyInpour = CalculateUtil.ZERO;
                        amtInpour = CalculateUtil.ZERO;
                        isBreak = false;
                    }
                } else if (baseqtyPayout.compareTo(addUpQty) < 0) {
                    if (CalculateUtil.ZERO.compareTo(addUpAmount) < 0) {
                        if (!rsPayout.getBoolean(IS_MINUS_SETTLEACCOUNT)) {
                            if (rsPayout.getInt("FFiVouchered") == 0) {
                                if (!isNoNeedUpdate) {
                                    amtPayout = baseqtyPayout.subtract(addUpQty.subtract(baseqtyInpour)).multiply(priceInpour).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4).add(addUpAmount.subtract(amtInpour));
                                }
                                if (CalculateUtil.ZERO.compareTo(amtPayout) > 0 && !isNoNeedUpdate) {
                                    amtPayout = baseqtyPayout.multiply(addUpPrice).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4);
                                }
                                pricePayout = CalculateUtil.ZERO.compareTo(baseqtyPayout) != 0 ? amtPayout.divide(baseqtyPayout, rsPayout.getInt("FPricePrecision"), 4) : priceInpour;
                                if (CalculateUtil.ZERO.compareTo(rsPayout.getBigDecimal("FReverseQty")) != 0 && !isNoNeedUpdate) {
                                    amtPayout = baseqtyPayout.add(rsPayout.getBigDecimal("FReverseQty")).multiply(pricePayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4).subtract(rsPayout.getBigDecimal("FReverseQty").multiply(pricePayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4));
                                }
                            }
                        } else if (rsPayout.getInt("FFiVouchered") == 0 && !isNoNeedUpdate) {
                            amtPayout = addUpPrice.multiply(baseqtyPayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4);
                            pricePayout = addUpPrice;
                        }
                        amtInpour = addUpAmount.subtract(amtPayout);
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    } else if (i == rsInpour.size() - 1) {
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                        if (CalculateUtil.ZERO.compareTo(addUpQty) != 0) {
                            addUpPrice = addUpAmount.divide(addUpQty, rsPayout.getInt("FPricePrecision"), 4);
                        }
                        if (CalculateUtil.ZERO.compareTo(addUpPrice) > 0) {
                            isExceptionState = true;
                            return isExceptionState;
                        }
                        if (rsPayout.getInt("FFiVouchered") == 1) {
                            addUpPrice = rsPayout.getPrice();
                        }
                        if (!isNoNeedUpdate) {
                            amtPayout = addUpPrice.multiply(baseqtyPayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4);
                        }
                        amtInpour = addUpAmount.subtract(amtPayout);
                    } else {
                        baseqtyInpour = CalculateUtil.ZERO;
                        amtInpour = CalculateUtil.ZERO;
                        isBreak = false;
                    }
                }
            } else {
                amtInpour = addUpAmount.subtract(amtPayout);
                if (CalculateUtil.ZERO.compareTo(amtInpour) == 0 || CalculateUtil.ZERO.compareTo(baseqtyPayout) == 0) {
                    pricePayout = priceInpour;
                }
            }
            settleAccounts.setRecentCost(amtInpour);
            settleAccounts.setRecentQty(baseqtyInpour);
            rsPayout.setRecentQty(baseqtyPayout);
            rsPayout.setRecentCost(amtPayout);
            rsPayout.setPrice(pricePayout);
            if (isBreak) break;
        }
        if (rsPayout.getBoolean(IS_MINUS_SETTLEACCOUNT)) {
            rsPayout.setBigDecimal("currBalanceQty", minTotalQty);
            rsPayout.setBigDecimal("currBalanceAmount", mintotalAmount);
        }
        this.clearDealedInpourList(rsInpour);
        return isExceptionState;
    }

    protected boolean calculateFIFOOutBillCost(ArrayList rsInpour, RecentCostInfo rsPayout, BigDecimal newInpPrice) throws BOSException, EASBizException {
        boolean isExceptionState = false;
        boolean isNeedUpdate = !rsPayout.isDealComplete() && !rsPayout.isCostAdjustBill() && !rsPayout.isNeedUpdate();
        int localCurrcyPrecision = rsPayout.getInt("FLocalCurrencyPrecision");
        int pricePrecision = rsPayout.getInt("FPricePrecision");
        BigDecimal baseqtyPayout = rsPayout.getRecentQty();
        BigDecimal amtPayout = rsPayout.getRecentCost();
        BigDecimal pricePayout = rsPayout.getPrice();
        BigDecimal baseqtyInpour = CalculateUtil.ZERO;
        BigDecimal amtInpour = CalculateUtil.ZERO;
        BigDecimal addUpAmount = CalculateUtil.ZERO;
        BigDecimal addUpQty = CalculateUtil.ZERO;
        BigDecimal addUpPrice = CalculateUtil.ZERO;
        BigDecimal lastSumQty = CalculateUtil.ZERO;
        BigDecimal lastSumAmount = CalculateUtil.ZERO;
        BigDecimal temp = CalculateUtil.ZERO;
        RecentCostInfo settleAccounts = null;
        boolean isCompleted = false;
        PriceSourEnum priceSource = PriceSourEnum.userDefine;
        for (int i = 0; rsInpour != null && i < rsInpour.size(); ++i) {
            priceSource = PriceSourEnum.fifoPrice;
            isCompleted = false;
            settleAccounts = (RecentCostInfo)rsInpour.get(i);
            baseqtyInpour = settleAccounts.getRecentQty();
            amtInpour = settleAccounts.getRecentCost();
            BigDecimal priceInpour = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(settleAccounts.getPrice()) <= 0) {
                newInpPrice = settleAccounts.getPrice();
            }
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0) {
                priceInpour = amtInpour.divide(baseqtyInpour, pricePrecision, 4);
            }
            if (settleAccounts.getBoolean(IS_MINUS_SETTLEACCOUNT)) {
                if (isNeedUpdate) {
                    pricePayout = priceInpour;
                    amtPayout = baseqtyPayout.multiply(pricePayout).setScale(localCurrcyPrecision, 4);
                }
                settleAccounts.setRecentQty(settleAccounts.getRecentQty().subtract(baseqtyPayout));
                settleAccounts.setRecentCost(settleAccounts.getRecentCost().subtract(amtPayout));
                break;
            }
            addUpAmount = addUpAmount.add(amtInpour);
            addUpQty = addUpQty.add(baseqtyInpour);
            addUpPrice = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(addUpQty) != 0) {
                addUpPrice = addUpAmount.divide(addUpQty, pricePrecision, 4);
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) == 0) {
                addUpPrice = newInpPrice;
                priceSource = PriceSourEnum.newIn;
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) == 0) {
                addUpPrice = pricePayout;
                priceSource = PriceSourEnum.newOut;
            }
            if (baseqtyPayout.compareTo(addUpQty) <= 0) {
                if (isNeedUpdate) {
                    if (baseqtyPayout.compareTo(addUpQty) == 0) {
                        amtPayout = addUpAmount;
                        pricePayout = amtPayout.divide(baseqtyPayout, pricePrecision, 4);
                    } else {
                        temp = baseqtyPayout.subtract(lastSumQty).multiply(priceInpour).setScale(localCurrcyPrecision, 4);
                        if (temp.compareTo(BigDecimal.ZERO) == 0 && baseqtyPayout.subtract(lastSumQty).compareTo(BigDecimal.ZERO) != 0 && priceInpour.compareTo(BigDecimal.ZERO) != 0) {
                            temp = RecentCostHelp.getMinValueByScale(localCurrcyPrecision, baseqtyPayout.subtract(lastSumQty).signum());
                        }
                        amtPayout = lastSumAmount.add(temp);
                        pricePayout = amtPayout.divide(baseqtyPayout, pricePrecision, 4);
                    }
                    baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    amtInpour = addUpAmount.subtract(amtPayout);
                    isCompleted = true;
                } else if (amtPayout.compareTo(addUpAmount) <= 0) {
                    baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    amtInpour = addUpAmount.subtract(amtPayout);
                    if (i == rsInpour.size() - 1 && CalculateUtil.ZERO.compareTo(amtInpour) == 0 && CalculateUtil.ZERO.compareTo(baseqtyInpour) == 0) {
                        settleAccounts.setBoolean(IS_MINUS_SETTLEACCOUNT, true);
                    }
                    isCompleted = true;
                } else {
                    lastSumQty = lastSumQty.add(baseqtyInpour);
                    lastSumAmount = lastSumAmount.add(amtInpour);
                    baseqtyInpour = CalculateUtil.ZERO;
                    amtInpour = CalculateUtil.ZERO;
                    if (i == rsInpour.size() - 1) {
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                        amtInpour = addUpAmount.subtract(amtPayout);
                        settleAccounts.setBoolean(IS_MINUS_SETTLEACCOUNT, true);
                        isCompleted = true;
                    }
                }
            } else {
                lastSumQty = lastSumQty.add(baseqtyInpour);
                lastSumAmount = lastSumAmount.add(amtInpour);
                baseqtyInpour = CalculateUtil.ZERO;
                amtInpour = CalculateUtil.ZERO;
                if (i == rsInpour.size() - 1) {
                    if (isNeedUpdate) {
                        pricePayout = addUpPrice;
                        amtPayout = pricePayout.multiply(baseqtyPayout).setScale(localCurrcyPrecision, 4);
                    }
                    baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    amtInpour = addUpAmount.subtract(amtPayout);
                    settleAccounts.setBoolean(IS_MINUS_SETTLEACCOUNT, true);
                    isCompleted = true;
                }
            }
            settleAccounts.setRecentQty(baseqtyInpour);
            settleAccounts.setRecentCost(amtInpour);
            if (CalculateUtil.ZERO.compareTo(pricePayout) > 0 && isCompleted) {
                isExceptionState = true;
            }
            if (!isExceptionState && CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0 && isCompleted) {
                priceInpour = amtInpour.divide(baseqtyInpour, pricePrecision, 4);
                boolean bl = isExceptionState = CalculateUtil.ZERO.compareTo(priceInpour) > 0;
            }
            if (isCompleted) break;
        }
        if (isNeedUpdate) {
            rsPayout.setPriceSource(priceSource);
            rsPayout.setPrice(pricePayout);
            rsPayout.setRecentCost(amtPayout);
        }
        this.clearDealedInpourList(rsInpour);
        return isExceptionState;
    }

    protected void clearDealedInpourList(ArrayList rsInpour) {
        for (int i = rsInpour.size() - 1; i >= 0; --i) {
            RecentCostInfo settleAccounts = (RecentCostInfo)rsInpour.get(i);
            BigDecimal baseqtyInpour = settleAccounts.getRecentQty();
            BigDecimal amtInpour = settleAccounts.getRecentCost();
            if (CalculateUtil.ZERO.compareTo(baseqtyInpour) != 0 || CalculateUtil.ZERO.compareTo(amtInpour) != 0 || rsInpour.size() <= 1) continue;
            rsInpour.remove(i);
        }
    }

    protected void handleDetailDiffer(Context ctx, ArrayList listIn, ArrayList listPayout, PreparedStatement rptPs, PeriodInfo periodInfo, ArrayList needUpdatedBills, String parent) throws CalculateException, BOSException, EASBizException, SQLException {
        BigDecimal lastQty = new BigDecimal("0");
        BigDecimal lastAmount = new BigDecimal("0");
        boolean isHandleDiffer = false;
        RecentCostInfo outCostInfo = null;
        if (listIn != null && listIn.size() > 0) {
            RecentCostInfo inCostInfo;
            int i;
            for (i = 0; i < listIn.size(); ++i) {
                inCostInfo = (RecentCostInfo)listIn.get(i);
                lastQty = lastQty.add(inCostInfo.getRecentQty());
                lastAmount = lastAmount.add(inCostInfo.getRecentCost());
            }
            if (CalculateUtil.ZERO.compareTo(lastQty) == 0 && CalculateUtil.ZERO.compareTo(lastAmount) != 0) {
                for (i = listPayout.size() - 1; i >= 0; --i) {
                    outCostInfo = (RecentCostInfo)listPayout.get(i);
                    if (!this.isHandleDetailDiffer(lastAmount, outCostInfo)) continue;
                    isHandleDiffer = true;
                    outCostInfo.setRecentCost(outCostInfo.getRecentCost().add(lastAmount));
                    if (CalculateUtil.ZERO.compareTo(outCostInfo.getRecentQty()) != 0) {
                        outCostInfo.setPrice(outCostInfo.getRecentCost().divide(outCostInfo.getRecentQty(), outCostInfo.getInt("FPricePrecision"), 4));
                        break;
                    }
                    outCostInfo.setPrice(CalculateUtil.ZERO);
                    break;
                }
                if (isHandleDiffer) {
                    for (i = 0; i < listIn.size(); ++i) {
                        inCostInfo = (RecentCostInfo)listIn.get(i);
                        inCostInfo.setRecentQty(CalculateUtil.ZERO);
                        inCostInfo.setRecentCost(CalculateUtil.ZERO);
                    }
                    needUpdatedBills.add(outCostInfo);
                    outCostInfo.setNeedUpdate(true);
                    this.computeReportOutAndInWarehouseDetailInfo2(ctx, rptPs, outCostInfo, listIn, periodInfo, 4, 0, parent);
                }
            }
        }
    }

    private boolean isHandleDetailDiffer(BigDecimal adjustAmount, RecentCostInfo infoBill) {
        return infoBill.getInt("FFiVouchered") == 0 && infoBill.getInt("FisCombition") != 1 && !infoBill.isNeedUpdate() && CalculateUtil.ZERO.compareTo(infoBill.getBigDecimal("FReverseQty")) == 0 && CalculateUtil.ZERO.compareTo(infoBill.getRecentCost().add(adjustAmount)) < 0 && !infoBill.isCostPriceMove() && !infoBill.isDealComplete() && !infoBill.isMatAttrChange() && !infoBill.isCostAdjustBill();
    }

    protected String updateBillsPriceSQL(String billEntry, RecentCostInfo bill) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET (FActualCost,FUnitActualCost,FBaseUnitActualCost");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FWrittenOffAmount,FUnWriteOffAmount");
        }
        sql.append(" ) = ( ");
        sql.append(" SELECT ");
        sql.append("  TempT.FActualCost");
        sql.append(" ,case ");
        sql.append("  when Entry.FUNITID = Entry.FBASEUNITID then ").append("\t\n");
        sql.append("     TempT.FActualUnitCost").append("\t\n");
        sql.append("  else ");
        sql.append("     ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE("TempT.FActualCost / Entry.FQty")).append(",TempT.FPricePrecision)");
        sql.append("  end ");
        sql.append(" ,TempT.FActualUnitCost");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(", case");
            sql.append("  when Entry.FWrittenOffBaseQty = Entry.FBaseQty then ").append("\t\n");
            sql.append("  TempT.FActualCost");
            sql.append("  else ");
            sql.append("  ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualUnitCost * Entry.FWrittenOffBaseQty")).append(",TempT.FLocalCurrencyPrecision)");
            sql.append("  end ");
            sql.append(" ,case ");
            sql.append("  when Entry.FWrittenOffBaseQty = Entry.FBaseQty then ").append("\t\n");
            sql.append("  0");
            sql.append("  else ");
            sql.append("  ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualUnitCost * Entry.FbaseQty")).append(",TempT.FLocalCurrencyPrecision) - ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualUnitCost * Entry.FWrittenOffBaseQty")).append(",TempT.FLocalCurrencyPrecision)");
            sql.append("  end ");
        }
        sql.append(" FROM ").append(billEntry).append(" Entry ").append("\t\n");
        sql.append(" INNER JOIN (").append("\t\n");
        sql.append(" select ").append(StringUtil.toString((BigDecimal)bill.getRecentCost())).append(" as FActualCost");
        sql.append(" ,").append(StringUtil.toString((BigDecimal)bill.getPrice())).append(" as FActualUnitCost");
        sql.append(" ,").append(bill.getInt("FLocalCurrencyPrecision")).append(" as FLocalCurrencyPrecision");
        sql.append(" ,").append(bill.getInt("FPricePrecision")).append(" as FPricePrecision");
        sql.append(" ,'").append(bill.getString("FBillEntryId")).append("' as FBillEntryId");
        sql.append(" ) TempT").append("\t\n");
        sql.append(" ON Entry.FID = TempT.FBillEntryId  ");
        sql.append(" WHERE Entry.FID = '").append(bill.getString("FBillEntryId")).append("' ");
        sql.append(" AND T.FID = Entry.FID");
        sql.append(")  ");
        sql.append("\n WHERE T.FID = '").append(bill.getString("FBillEntryId")).append("' ");
        return sql.toString();
    }

    protected void execBatchSql(Context ctx, ArrayList sqlList, boolean isUpdateBill) throws BOSException {
        if (isUpdateBill || sqlList.size() >= 200) {
            long start = System.currentTimeMillis();
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            this.logger.info((Object)("update bill spend time: " + (System.currentTimeMillis() - start)));
            sqlList.clear();
        }
    }

    protected void execBatchSql(Connection conn, ArrayList sqlList, boolean isUpdateBill) throws BOSException, SQLException {
        if (isUpdateBill || sqlList.size() >= 500) {
            long start = System.currentTimeMillis();
            DBUtil.execute(conn, sqlList.toArray(new String[sqlList.size()]));
            this.logger.info((Object)("update bill spend time: " + (System.currentTimeMillis() - start)));
            sqlList.clear();
        }
    }

    protected String getSQLOffSetDetail(Context ctx, PeriodInfo periodInfo, String filterCalType, CalculateParams params, RecentCostInfo bill) throws SQLException {
        String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
        StringBuffer sql = new StringBuffer();
        sql.append("select Bill.FNumber,FBizDate");
        sql.append(",FOutwarehouseType,FBaseQty,FActualCost,").append(bill.getPrice()).append(" as FPrice,0 as FPeriodBeginBalance");
        sql.append(",FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID");
        sql.append(",Bill.FBillTypeName,BILL.FSEQNUM");
        sql.append(" FROM ").append(tempTableFIFOBills).append(" as Bill");
        sql.append(" WHERE Bill.FIsReversed  = 1");
        sql.append(" AND Bill.FSourceBillId = '").append(bill.getString("FBillId")).append("'");
        sql.append(" AND Bill.FSourceBillEntryId = '").append(bill.getString("FBillEntryId")).append("'");
        return sql.toString();
    }

    protected void computeReportOutAndInWarehouseDetailInfo(Context ctx, RecentCostInfo bill, ArrayList list, String strCalType, PeriodInfo periodInfo, int outwarehouseType, CalculateParams params, boolean isMediateUpdate) throws SQLException, EASBizException, BOSException {
        ArrayList computerDetailReportList = (ArrayList)params.getObject(DETAILCOMPUTEREOPRTSQL);
        String storageOrgUnitId = bill.getString("FStorageOrgUnitId");
        String warehouseId = bill.getString("FWarehouseId");
        long timeSerialNumber = bill.getLong("timeSerialNumber");
        StringBuffer income = new StringBuffer();
        StringBuffer payout = new StringBuffer();
        StringBuffer SettleAccounts = new StringBuffer();
        String billName = "";
        String billNumber = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        String createTime = sdf.format(new Date());
        if (2 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_CLOSE_ACCOUNT", (Context)ctx);
            createTime = "1900-01-01 00:00:00.000";
        } else if (3 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_END_CLOSE_ACCOUNT", (Context)ctx);
            createTime = "2900-01-01 00:00:00.000";
            timeSerialNumber = new Long("9999999999999");
        } else {
            createTime = sdf.format(bill.getTimestamp("FBizDate"));
            billNumber = bill.getString("FNumber");
            billName = bill.getString("FBillTypeName");
        }
        if (0 == outwarehouseType) {
            if (bill.getInt("FisCombition") == 1) {
                income.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getBigDecimal("FBaseQtyBak"), bill.getPrice()));
            } else {
                income.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getRecentQty(), bill.getPrice()));
            }
        }
        if (1 == outwarehouseType) {
            if (bill.getInt("FisCombition") == 1) {
                payout.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getBigDecimal("FBaseQtyBak"), bill.getPrice()));
            } else {
                payout.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getRecentQty(), bill.getPrice()));
            }
        }
        if (bill.getBoolean("isExceptionState")) {
            SettleAccounts.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SettleAccounts_Exception", (Context)ctx));
        } else {
            int reportShowRecordsCount = 3;
            int reportShowRecordsCountIndex = 0;
            for (int i = 0; i < list.size(); ++i) {
                RecentCostInfo settleAccounts = (RecentCostInfo)list.get(i);
                if (3 != outwarehouseType && settleAccounts.getLong("timeSerialNumber") - bill.getLong("timeSerialNumber") > 0L) break;
                BigDecimal baseqtyInpour = settleAccounts.getRecentQty();
                BigDecimal amtInpour = settleAccounts.getRecentCost();
                BigDecimal priceInpour = CalculateUtil.ZERO;
                if (CalculateUtil.ZERO.compareTo(settleAccounts.getRecentQty()) != 0) {
                    priceInpour = settleAccounts.getRecentCost().divide(settleAccounts.getRecentQty(), bill.getInt("FPricePrecision"), 4);
                }
                if (CalculateUtil.ZERO.compareTo(baseqtyInpour) == 0 && CalculateUtil.ZERO.compareTo(amtInpour) == 0) continue;
                SettleAccounts.append(RecentCostHelp.takeAmountQytPriceDesc(amtInpour, baseqtyInpour, priceInpour));
                if (3 != outwarehouseType && ++reportShowRecordsCountIndex >= reportShowRecordsCount) {
                    SettleAccounts.append("  ......");
                    break;
                }
                SettleAccounts.append("\n");
            }
            if (SettleAccounts.toString().trim().length() == 0) {
                SettleAccounts.append("0.00 * 0.00 = 0.00\n");
            }
        }
        String settleStr = SettleAccounts.toString();
        if (SettleAccounts.toString().length() > 256) {
            settleStr = SettleAccounts.substring(0, 256);
        }
        computerDetailReportList.add(CostComputeHelp.createCostComputeReport(ctx, periodInfo, bill.getString("FMaterialID"), bill.getString("FCompanyOrgUnitID"), storageOrgUnitId, warehouseId, billName, billNumber, income.toString(), payout.toString(), settleStr, createTime, timeSerialNumber, this.takeMaterialAccountType()[0], null).toString());
        this.execBatchSql(ctx, computerDetailReportList, isMediateUpdate);
    }

    protected void computeReportOutAndInWarehouseDetailInfo2(Context ctx, PreparedStatement ps, RecentCostInfo bill, ArrayList list, PeriodInfo periodInfo, int outwarehouseType, int isSuccess, String parent) throws SQLException, EASBizException, BOSException {
        String storageOrgUnitId = bill.getString("FStorageOrgUnitId");
        String warehouseId = bill.getString("FWarehouseId");
        long timeSerialNumber = bill.getLong("timeSerialNumber");
        StringBuffer income = new StringBuffer();
        StringBuffer payout = new StringBuffer();
        StringBuffer SettleAccounts = new StringBuffer();
        String billName = "";
        String billNumber = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        String createTime = sdf.format(new Date());
        if (2 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_BEGIN_CLOSE_ACCOUNT", (Context)ctx);
            createTime = "1900-01-01 00:00:00.000";
        } else if (3 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"PERIOD_END_CLOSE_ACCOUNT", (Context)ctx);
            createTime = "2900-01-01 00:00:00.000";
            timeSerialNumber = new Long("9999999999999");
        } else if (4 == outwarehouseType) {
            billName = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DealCostDiffApportion", (Context)ctx);
            billNumber = bill.getString("FNumber");
            createTime = "2899-01-01 00:00:00.000";
            timeSerialNumber = new Long("9999999999998");
        } else {
            createTime = sdf.format(bill.getTimestamp("FBizDate"));
            billNumber = bill.getString("FNumber");
            billName = bill.getString("FBillTypeName");
        }
        if (0 == outwarehouseType || 2 == outwarehouseType) {
            income.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getRecentQty(), bill.getPrice()));
        }
        if (1 == outwarehouseType || 4 == outwarehouseType) {
            payout.append(RecentCostHelp.takeAmountQytPriceDesc(bill.getRecentCost(), bill.getRecentQty(), bill.getPrice()));
        }
        if (bill.getBoolean("isExceptionState")) {
            SettleAccounts.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"SettleAccounts_Exception", (Context)ctx));
        } else if (bill.getInt("FisSrcBilInCurrPid") == 1 && bill.getString("fbilltypeid").equals(bill.getString("fsourcebilltypeid"))) {
            SettleAccounts.append(SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DealCombitionBill", (Context)ctx)).append("\n");
        } else {
            int reportShowRecordsCount = 3;
            int reportShowRecordsCountIndex = 0;
            for (int i = 0; list != null && i < list.size(); ++i) {
                RecentCostInfo settleAccounts = (RecentCostInfo)list.get(i);
                if (3 != outwarehouseType && settleAccounts.getLong("timeSerialNumber") - bill.getLong("timeSerialNumber") > 0L) break;
                BigDecimal baseqtyInpour = settleAccounts.getRecentQty();
                BigDecimal amtInpour = settleAccounts.getRecentCost();
                BigDecimal priceInpour = CalculateUtil.ZERO;
                if (CalculateUtil.ZERO.compareTo(settleAccounts.getRecentQty()) != 0) {
                    priceInpour = settleAccounts.getRecentCost().divide(settleAccounts.getRecentQty(), bill.getInt("FPricePrecision"), 4);
                }
                if (CalculateUtil.ZERO.compareTo(baseqtyInpour) == 0 && CalculateUtil.ZERO.compareTo(amtInpour) == 0) continue;
                SettleAccounts.append(RecentCostHelp.takeAmountQytPriceDesc(amtInpour, baseqtyInpour, priceInpour));
                if (3 != outwarehouseType && ++reportShowRecordsCountIndex >= reportShowRecordsCount) {
                    SettleAccounts.append("  ......");
                    break;
                }
                SettleAccounts.append("\n");
            }
            if (SettleAccounts.toString().trim().length() == 0) {
                SettleAccounts.append("0.00 * 0.00 = 0.00\n");
            }
        }
        String settleStr = SettleAccounts.toString();
        if (SettleAccounts.toString().length() > 256) {
            settleStr = SettleAccounts.substring(0, 256);
        }
        String priceSource = "";
        if (bill.getPriceSource() != null) {
            priceSource = bill.getPriceSource().getValue();
        }
        CostComputeHelp.addCostComputerReportBatch(ctx, ps, periodInfo, bill.getString("FMaterialID"), bill.getString("FCompanyOrgUnitID"), storageOrgUnitId, warehouseId, billName, billNumber, income.toString(), payout.toString(), settleStr, createTime, timeSerialNumber, this.takeMaterialAccountType()[0], isSuccess, parent, priceSource, bill.isCostPriceMove());
        ++this.costReportCount;
    }

    private void insertInOutDataToTempTable(Context ctx, SysTempTableHelper sysTempTableHelper, PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempInOutBillsTable) throws BOSException, SQLException {
        StringBuffer inField = new StringBuffer();
        StringBuffer outField = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getInsertMMUnitSQL(tempInOutBillsTable));
        sql.append(this.getTakeInOutBillTempSQLSelect());
        sql.append("\t\n").append(" From (").append("\t\n");
        StringBuffer tempSql = new StringBuffer();
        tempSql.append(sql.toString());
        params.setString("insertSQL", tempSql.toString());
        params.setBoolean("isAccount", true);
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        sql.append(" entry.FCalculateKind,entry.FBillTypeID,");
        sql.append(" SCMTRANSACTIONTYPE.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FTransactionTypeName,");
        inField.append(" Bill.FBizTypeID,Bill.FTransactionTypeID,").append("\t\n");
        inField.append(" Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.FId as FBillId,Entry.FId as FBillEntryId,").append("\t\n");
        inField.append(" 0 AS FCalculateKind,Bill.FIsReversed,Entry.FReverseQty,");
        inField.append(" ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,");
        inField.append(" ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision,");
        inField.append(Local_Currency_Presision).append(" AS FLocalCurrencyPrecision,").append("\t\n");
        inField.append(" ENTRY.FStockTransBillEntryID,BILL.FAUDITTIME,").append("\t\n");
        inField.append(" Bill.FSourceBillTypeID as FSourceBillTypeID,ENTRY.FISPRESENT,InvUpdateType.FStoreTypeID AS FStoreTypeID, InvUpdateType.FStoreTypePreID AS FStoreTypePreID");
        outField.append(" Bill.FBizTypeID,Bill.FTransactionTypeID,").append("\t\n");
        outField.append(" Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.FId as FBillId,Entry.FId as FBillEntryId,").append("\t\n");
        outField.append(" 1 AS FCalculateKind,Bill.FIsReversed,Entry.FReverseQty,");
        outField.append(" ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,");
        outField.append(" ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision,");
        outField.append(Local_Currency_Presision).append(" AS FLocalCurrencyPrecision,").append("\t\n");
        outField.append("ENTRY.FStockTransBillEntryID,BILL.FAUDITTIME,").append("\t\n");
        outField.append(" Bill.FSourceBillTypeID,0 AS FISPRESENT,InvUpdateType.FStoreTypeID AS FStoreTypeID, InvUpdateType.FStoreTypePreID AS FStoreTypePreID");
        this.executeInOutBillSQL(ctx, periodInfo, strCalType, inField.toString(), outField.toString(), params, sysTempTableHelper);
        sysTempTableHelper.analyzeTable(tempInOutBillsTable);
    }

    @Override
    protected String getExtendsFileds() {
        return "";
    }

    protected void buildInOutBillsData(Context ctx, SysTempTableHelper sysTempTableHelper, PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempTableFIFOBills) throws BOSException, SQLException {
        String materialTempTable = "T_BD_Material";
        if (params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_FROM")) || params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_TO")) || params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_IN")) || params != null && !StringUtil.isEmpty((String)params.getString("ThirdPartyMaterialTableName"))) {
            materialTempTable = this.insertMaterialToTempTable(ctx, sysTempTableHelper, params);
            params.setString("materialTempTable", materialTempTable);
        }
        this.insertInOutDataToTempTable(ctx, sysTempTableHelper, periodInfo, strCalType, params, tempTableFIFOBills);
        this.insertOtherDataToTempTable(ctx, sysTempTableHelper, periodInfo, strCalType, params, tempTableFIFOBills, materialTempTable);
    }

    private void insertOtherDataToTempTable(Context ctx, SysTempTableHelper helper, PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempTable, String materialTempTable) throws BOSException {
        int local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String periodBeginTableName = "T_IM_InventoryBalance";
        AccountType accountType = this.takeMaterialAccountType()[0];
        if (accountType != null && accountType.getValue() == 4) {
            periodBeginTableName = "T_CL_InventoryBalance";
        }
        StringBuffer fieldBuffer = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append(this.getInsertMMUnitSQL(tempTable));
        sql.append(this.getSelectSqlByBalance(local_Currency_Presision));
        sql.append(" ,null as FbaseStatus,null as FClosePeriod");
        sql.append(" From (").append("\t\n").append("\t\n");
        StringBuffer inCostAdjBillSql = new StringBuffer();
        StringBuffer outCostAdjBillSql = new StringBuffer();
        inCostAdjBillSql.append(sql.toString());
        outCostAdjBillSql.append(sql.toString());
        fieldBuffer.append(" NULL as FBizTypeID,N'' AS FTRANSACTIONTYPENAME,0 as FFiVouchered,FSeqNum,Entry.FId as FBillId,Entry.FId as FBillEntryId,2 AS FCalculateKind,").append("\t\n");
        fieldBuffer.append(" 0 AS FIsReversed,0 as FReverseQty,NULL AS FStockTransBillEntryID,TO_DATE('1900-01-01 00:00:00.000') as FAUDITTIME,").append("\t\n");
        fieldBuffer.append(" NULL as FSourceBillTypeID,MATERIAL.FNUMBER AS FMATERIALNUMBER,").append("\t\n");
        fieldBuffer.append(" MATERIAL.FBASEUNIT,isnull(MEASUREUNITBASE.FQTYPRECISION,4) as FQtyPrecision ,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,0 AS FISPRESENT ");
        sql.append(this.getSQLPeriodBeginBalanceCalculate(ctx, periodInfo, strCalType, fieldBuffer.toString(), params, "2", periodBeginTableName, materialTempTable));
        sql.append(" ) temp ");
        helper.execute(sql.toString());
        fieldBuffer.setLength(0);
        fieldBuffer.append(" Bill.FBizTypeID,N'' AS FTRANSACTIONTYPENAME,").append("\t\n");
        fieldBuffer.append(" Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.FId as FBillId,Entry.FId as FBillEntryId,").append("\t\n");
        fieldBuffer.append(" 0 AS FCalculateKind,Bill.FIsReversed,Entry.FReverseQty,ENTRY.FStockTransBillEntryID,BILL.FAUDITTIME,").append("\t\n");
        fieldBuffer.append(" NULL as FSourceBillTypeID,MATERIAL.FNUMBER AS FMATERIALNUMBER,").append("\t\n");
        fieldBuffer.append(" MATERIAL.FBASEUNIT,isnull(MeasureUnitBase.FQtyPrecision,4) as FQtyPrecision,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,ENTRY.FISPRESENT");
        inCostAdjBillSql.append(this.getSQLInpourCostAdjBillCalculate(ctx, periodInfo, strCalType, fieldBuffer.toString(), params, materialTempTable)).append("\t\n");
        inCostAdjBillSql.append(" ) temp ");
        helper.execute(inCostAdjBillSql.toString());
        fieldBuffer.setLength(0);
        fieldBuffer.append(" Bill.FBizTypeID,N'' AS FTRANSACTIONTYPENAME,").append("\t\n");
        fieldBuffer.append(" Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.FId as FBillId,Entry.FId as FBillEntryId,").append("\t\n");
        fieldBuffer.append(" 1 AS FCalculateKind,Bill.FIsReversed,Entry.FReverseQty,NULL AS FStockTransBillEntryID,BILL.FAUDITTIME,").append("\t\n");
        fieldBuffer.append(" NULL as FSourceBillTypeID,MATERIAL.FNUMBER AS FMATERIALNUMBER,").append("\t\n");
        fieldBuffer.append(" MATERIAL.FBASEUNIT,isnull(MeasureUnitBase.FQtyPrecision,4) as FQtyPrecision,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,ENTRY.FISPRESENT");
        outCostAdjBillSql.append(this.getOutSQLPayoutCostAdjBillCalculate(ctx, periodInfo, strCalType, fieldBuffer.toString(), params, materialTempTable));
        outCostAdjBillSql.append(" ) temp ");
        helper.execute(outCostAdjBillSql.toString());
    }

    protected String getInsertSQLByBalance(String tempTableFIFOBills) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTableFIFOBills);
        sql.append("(FID,FBillId,FBillEntryId,FEntryTableMame,FNumber,FBizDate,FCompanyOrgUnitID,FMaterialId,").append("\t\n");
        sql.append(" Fstorageorg,Fstorageorgunitid,Fwarehouse,Fwarehouseid,FBaseQty,FBaseQtyBak,FActualCost,FPrice,FReverseQty,FCalculateKind,FSeqNum,FFiVouchered,").append("\t\n");
        sql.append(" FBizTypeID,FSourceBillID,FSourceBillEntryID,FSourceBillEntrySeq,FSourceUnitActualCost,FActualCostBak,FbillTypeID,FTransactionTypeName,FisCombition,FisSrcBilInCurrPid,").append("\t\n");
        sql.append(" FIsPresent,FStockTransBillEntryID,FAUDITTIME,FSourceBillTypeID,FIsReversed,FLot,FMaterialNumber,FBaseUnit,FPricePrecision,FLocalCurrencyPrecision,");
        sql.append(" FIsReWork,FOutwarehouseType,FStoreTypeID,FStoreTypePreID,FBillTypeName,FAssistPropertyID,FProjectID,FTrackNumberID)").append("\t\n");
        sql.append("\t\n");
        return sql.toString();
    }

    protected String getSelectSqlByBalance(int local_Currency_Presision) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT temp.FBillEntryId,temp.FBillId,temp.FBillEntryId,temp.FEntryTableMame,temp.FNumber,temp.FBizDate,temp.FCompanyOrgUnitID,").append("\t\n");
        sql.append(" temp.FMaterialId,temp.Fstorageorg,temp.Fstorageorgunitid,temp.Fwarehouse,temp.Fwarehouseid,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else temp.FBaseQty end,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else temp.FBaseQty end,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else temp.FActualCost end,").append("\t\n");
        sql.append(" temp.FBaseUnitActualCost as FPrice,temp.FReverseQty,temp.FPricePrecision,isnull(temp.FQtyPrecision,4),");
        sql.append(local_Currency_Presision).append(" AS FLocalCurrencyPrecision,").append("\t\n");
        sql.append("temp.FCalculateKind,temp.FbillTypeID,temp.FTransactionTypeName,temp.FSeqNum,ISNULL(temp.FFiVouchered, 0) AS FFiVouchered,").append("\t\n");
        sql.append(" temp.FBizTypeID,temp.FSourceBillID,temp.FSourceBillEntryID,temp.FSourceBillEntrySeq,0 AS FSourceUnitActualCost,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else temp.FActualCost end,temp.FmaterialNumber,").append("\t\n");
        sql.append("0 AS FisCombition,0 AS FisSrcBilInCurrPid,temp.FIsPresent,temp.FStockTransBillEntryID,temp.FAUDITTIME,temp.FSourceBillTypeID,").append("\t\n");
        sql.append(" temp.FIsReversed,");
        sql.append(" temp.FIsReWork,temp.FOutwarehouseType,temp.FStoreTypeID,temp.FStoreTypePreID,temp.FBillTypeName,temp.FBaseUnit,");
        sql.append(" temp.FLot,temp.FAssistPropertyID,temp.FProjectID,temp.FTrackNumberID, ");
        sql.append("temp.FUnitID,temp.FQty,temp.FWrittenOffBaseQty,temp.FUnWriteOffBaseQty,temp.FisWriteOffVouched,temp.FBASECONVSRATE");
        return sql.toString();
    }

    private String createTempTable(Context ctx, SysTempTableHelper sysTempTableHelper, String[][] tableFields, String columns) throws BOSException {
        String tempTableName = sysTempTableHelper.createTempTable(ctx, tableFields);
        if (columns != null && "FID".equalsIgnoreCase(columns)) {
            sysTempTableHelper.createTempTableIndex(tempTableName, "FID", true, false);
        } else {
            sysTempTableHelper.createTempTableIndex(tempTableName, columns, false, false);
        }
        return tempTableName;
    }

    protected String insertMaterialToTempTable(Context ctx, SysTempTableHelper sysTempTableHelper, CalculateParams params) throws BOSException {
        String materialTempTable = this.createTempTable(ctx, sysTempTableHelper, InventoryBillHelp.getMaterialTempTableFields(), "FId");
        String NCM_MatID_TmpTable = params.getString("ThirdPartyMaterialTableName");
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(materialTempTable);
        sql.append(" (FID,FNumber,FPricePrecision,FBaseUnit)").append("\t\n");
        sql.append(" SELECT MATERIAL.FID,MATERIAL.FNumber,MATERIAL.FPricePrecision,MATERIAL.FBaseUnit FROM T_BD_Material MATERIAL").append("\t\n");
        if (!StringUtil.isEmpty((String)NCM_MatID_TmpTable)) {
            sql.append(" INNER JOIN ").append(NCM_MatID_TmpTable).append(" TEMP ON MATERIAL.FID = TEMP.FMATERIALID");
            sql.append(" INNER JOIN T_BD_MATERIALCOMPANYINFO MCI ON MCI.FMATERIALID = TEMP.FMATERIALID AND MCI.FACCOUNTTYPE = ").append(params.getInt("ACCOUNT_TYPE"));
            sql.append(" WHERE MCI.FCOMPANYID = '").append(params.getString("COMPANY_ID")).append("'");
        } else {
            sql.append(" where 1 = 1 ").append(this.takeMaterialNumberWhereSQL(params));
        }
        sysTempTableHelper.execute(sql.toString());
        return materialTempTable;
    }

    protected String getInsertSQL(String tempTableFIFOBills) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTableFIFOBills);
        sql.append("(FID,FBillId,FBillEntryId,FEntryTableMame,FNumber,FBizDate,FCompanyOrgUnitID,FMaterialId,").append("\t\n");
        sql.append(" Fstorageorgunitid,Fwarehouseid,FBaseQty,FBaseQtyBak,FActualCost,FPrice,FReverseQty,FCalculateKind,").append("\t\n");
        sql.append(" FSeqNum,FFiVouchered,FBizTypeID,FSourceBillID,FSourceBillEntryID,FSourceBillEntrySeq,FSourceUnitActualCost,").append("\t\n");
        sql.append(" FActualCostBak,FbillTypeID,FTransactionTypeID,FisCombition,FisSrcBilInCurrPid,FIsPresent,").append("\t\n");
        sql.append(" FStockTransBillEntryID,FAUDITTIME,FSourceBillTypeID,FIsReversed,FLot,FIsReWork,").append("\t\n");
        sql.append(" FOutwarehouseType,FBillTypeName,FAssistPropertyID,FProjectID,FTrackNumberID,").append("\t\n");
        sql.append(" FUnitID,FQty,FWrittenOffBaseQty,FUnWriteOffBaseQty,FStoreTypeID,FStoreTypePreID,FisWriteOffVouched)").append("\t\n");
        sql.append("\t\n");
        return sql.toString();
    }

    protected String getTakeInOutBillTempSQLSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Bill.FBillEntryId,Bill.FBillId,Bill.FBillEntryId,FEntryTableMame,Bill.FNumber,Bill.FBizDate,").append("\t\n");
        sql.append(" Bill.FCompanyOrgUnitID,Bill.FMaterialId,Bill.FStorageorg,Bill.Fstorageorgunitid,Bill.Fwarehouse,Bill.Fwarehouseid,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginQty else Bill.FBaseQty end,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end,").append("\t\n");
        sql.append(" Bill.FBaseUnitActualCost as FPrice,Bill.FReverseQty,");
        sql.append(" Bill.FPricePrecision,Bill.FQtyPrecision,Bill.FLocalCurrencyPrecision,");
        sql.append(" Bill.FCalculateKind,Bill.FbillTypeID,Bill.FTransactionTypeName,Bill.FSeqNum,").append("\t\n");
        sql.append(" ISNULL(Bill.FFiVouchered, 0) AS FFiVouchered,Bill.FBizTypeID,Bill.FSourceBillID,Bill.FSourceBillEntryID,").append("\t\n");
        sql.append(" Bill.FSourceBillEntrySeq,0 AS FSourceUnitActualCost,").append("\t\n");
        sql.append(" case when FCalculateKind = 2 then FPeriodBeginBalance else Bill.FActualCost end,").append("\t\n");
        sql.append(" Bill.FmaterialNumber, 0 AS FisCombition,0 AS FisSrcBilInCurrPid,Bill.FIsPresent,BILL.FStockTransBillEntryID,").append("\t\n");
        sql.append(" BILL.FAUDITTIME,Bill.FSourceBillTypeID,Bill.FIsReversed,Bill.FIsReWork,").append("\t\n");
        sql.append(" Bill.FOutwarehouseType,Bill.FStoreTypeID,Bill.FStoreTypePreID,Bill.FBillTypeName,Bill.FBaseUnit,Bill.FLot,Bill.FAssistPropertyID,Bill.FProjectID,Bill.FTrackNumberID,").append("\t\n");
        sql.append(" Bill.FUnitID,Bill.FQty,Bill.FWrittenOffBaseQty,Bill.FUnWriteOffBaseQty,Bill.FisWriteOffVouched,Bill.FBASECONVSRATE,Bill.FbaseStatus,Bill.FClosePeriod").append("\t\n");
        return sql.toString();
    }

    protected String getTakeInOutBillSQLSelect(Context ctx, int local_Currency_Presision) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT entry.FID,entry.FBillId,entry.FBillEntryId,FEntryTableMame,entry.FNumber,entry.FBizDate,entry.FCompanyOrgUnitID,entry.FMaterialId,").append("\t\n");
        sql.append(" STORAGEORGUNIT.FNumber AS FStorageOrg,entry.Fstorageorgunitid,WAREHOUSE.FNumber AS FWarehouse,entry.Fwarehouseid,entry.FBaseQty,entry.FBaseQtyBak,entry.FActualCost,entry.FPrice,").append("\t\n");
        sql.append(" entry.FReverseQty,ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,");
        sql.append(local_Currency_Presision).append(" AS FLocalCurrencyPrecision,").append("\t\n");
        sql.append(" entry.FCalculateKind,entry.FBillTypeID,");
        sql.append(" SCMTRANSACTIONTYPE.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" AS FTransactionTypeName,");
        sql.append(" entry.FSeqNum,entry.FFiVouchered,entry.FBizTypeID,").append("\t\n");
        sql.append(" entry.FSourceBillID AS FSourceBillID,entry.FSourceBillEntryID AS FSourceBillEntryID,entry.FSourceBillEntrySeq AS FSourceBillEntrySeq,").append("\t\n");
        sql.append(" entry.FSourceUnitActualCost,entry.FActualCostBak,MATERIAL.FNUMBER AS FMATERIALNUMBER,entry.FisCombition,entry.FisSrcBilInCurrPid,").append("\t\n");
        sql.append(" entry.FISPRESENT,entry.FStockTransBillEntryID,entry.FAUDITTIME,entry.FSourceBillTypeID,entry.FIsReversed,").append("\t\n");
        sql.append(" entry.FIsReWork,entry.FOutwarehouseType,entry.FStoreTypeID,entry.FStoreTypePreID,");
        sql.append(" entry.FBillTypeName,MATERIAL.FBaseUnit,").append("\t\n");
        sql.append(" entry.FLot,entry.FAssistPropertyID,entry.FProjectID,entry.FTrackNumberID,");
        sql.append(" entry.FUnitID,entry.FQty,entry.FWrittenOffBaseQty,entry.FUnWriteOffBaseQty ,entry.FisWriteOffVouched ");
        return sql.toString();
    }

    protected String getMultiMeasureUnitSQLSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Bill.FID,Bill.FBillId,Bill.FBillEntryId,FEntryTableMame,Bill.FNumber,Bill.FBizDate,Bill.FCompanyOrgUnitID,Bill.FMaterialId,").append("\t\n");
        sql.append(" Bill.FStorageOrg,Bill.Fstorageorgunitid,Bill.FWarehouse,Bill.Fwarehouseid,Bill.FBaseQty,Bill.FBaseQtyBak,Bill.FActualCost,Bill.FPrice,").append("\t\n");
        sql.append(" Bill.FReverseQty,Bill.FPricePrecision,ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision,");
        sql.append(" Bill.FLocalCurrencyPrecision,").append("\t\n");
        sql.append(" Bill.FCalculateKind,Bill.FBillTypeID,Bill.FTransactionTypeName,Bill.FSeqNum,Bill.FFiVouchered,Bill.FBizTypeID,").append("\t\n");
        sql.append(" Bill.FSourceBillID AS FSourceBillID,Bill.FSourceBillEntryID AS FSourceBillEntryID,Bill.FSourceBillEntrySeq AS FSourceBillEntrySeq,").append("\t\n");
        sql.append(" Bill.FSourceUnitActualCost,Bill.FActualCostBak,Bill.FMATERIALNUMBER,Bill.FisCombition,Bill.FisSrcBilInCurrPid,").append("\t\n");
        sql.append(" Bill.FISPRESENT,BILL.FStockTransBillEntryID,BILL.FAUDITTIME,Bill.FSourceBillTypeID,Bill.FIsReversed,Bill.Flot,").append("\t\n");
        sql.append(" Bill.FIsReWork,Bill.FOutwarehouseType,Bill.FStoreTypeID,Bill.FStoreTypePreID,");
        sql.append(" Bill.FBillTypeName,Bill.FBaseUnit,").append("\t\n");
        sql.append(" Bill.FAssistPropertyID,Bill.FProjectID,Bill.FTrackNumberID,");
        sql.append(" Bill.FUnitID,Bill.FQty,Bill.FWrittenOffBaseQty,Bill.FUnWriteOffBaseQty ,Bill.FisWriteOffVouched");
        return sql.toString();
    }

    protected String getMaterialCompanySqlSelect() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Bill.FID,Bill.FBillId,Bill.FBillEntryId,FEntryTableMame,Bill.FNumber,Bill.FBizDate,Bill.FCompanyOrgUnitID,Bill.FMaterialId,").append("\t\n");
        sql.append(" Bill.FStorageOrg,Bill.Fstorageorgunitid,Bill.FWarehouse,Bill.Fwarehouseid,Bill.FBaseQty,Bill.FBaseQtyBak,Bill.FActualCost,Bill.FPrice,").append("\t\n");
        sql.append(" Bill.FReverseQty,Bill.FPricePrecision,Bill.FLocalCurrencyPrecision,").append("\t\n");
        sql.append(" Bill.FCalculateKind,Bill.FBillTypeID,Bill.FTransactionTypeName,Bill.FSeqNum,Bill.FFiVouchered,Bill.FBizTypeID,").append("\t\n");
        sql.append(" Bill.FSourceBillID AS FSourceBillID,Bill.FSourceBillEntryID AS FSourceBillEntryID,Bill.FSourceBillEntrySeq AS FSourceBillEntrySeq,").append("\t\n");
        sql.append(" Bill.FSourceUnitActualCost,Bill.FActualCostBak,Bill.FMATERIALNUMBER,Bill.FisCombition,Bill.FisSrcBilInCurrPid,").append("\t\n");
        sql.append(" Bill.FISPRESENT,BILL.FStockTransBillEntryID,BILL.FAUDITTIME,Bill.FSourceBillTypeID,Bill.FIsReversed,");
        sql.append(" Bill.FIsReWork,Bill.FOutwarehouseType,Bill.FStoreTypeID,Bill.FStoreTypePreID,Bill.FBillTypeName,Bill.FBaseUnit,").append("\t\n");
        if (AccountType.SPECIAL_ACCT.equals((Object)this.takeMaterialAccountType()[0])) {
            sql.append(" (case when MATERIALCOMPANY.FIsLot = 1 then isnull(Bill.FLot,'X') else null end) AS FLOT,");
            sql.append(" (case when MATERIALCOMPANY.FIsAssistProperty = 1 then isnull(Bill.FAssistPropertyID,'X') else null end) AS FAssistPropertyID,");
            sql.append(" (case when MATERIALCOMPANY.FIsProject = 1 and MATERIALINVENTORY.FIsProjectNumber = 1 then isnull(Bill.FProjectID,'X') else null end) AS FProjectID,");
            sql.append(" (case when MATERIALCOMPANY.FIsTrackNumber = 1 and MATERIALINVENTORY.FIsTrackingNumber = 1 then isnull(Bill.FTrackNumberID,'X') else null end) AS FTrackNumberID,");
        } else {
            sql.append(" null as FLOT,null as FAssistPropertyID,null as FProjectID,null as FTrackNumberID,").append("\t\n");
        }
        sql.append(" Bill.FUnitID,Bill.FQty,Bill.FWrittenOffBaseQty,Bill.FUnWriteOffBaseQty ,Bill.FisWriteOffVouched ");
        return sql.toString();
    }

    protected void writeExceptionReport(Context ctx, ArrayList expRptSqlList, RecentCostInfo bill, PeriodInfo periodInfo) {
        expRptSqlList.add(this.getInserExcepReportSQL(bill, periodInfo));
        try {
            this.execBatchSql(ctx, expRptSqlList, false);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
    }

    protected StringBuffer getSQLOrderBy(String stCalType) {
        return new StringBuffer();
    }

    protected boolean isCalculateInOutBill(RecentCostInfo bill, String strCalType) {
        if (bill.isCostPriceMove()) {
            if ("0".equals(strCalType)) {
                return false;
            }
            if ("1".equals(strCalType)) {
                return bill.isMoveInCostPriceStorage();
            }
            return true;
        }
        return true;
    }

    protected void handleCostPriceMove(RecentCostInfo bill, HashMap costMoveMap) {
        if (bill.isCostPriceMove()) {
            RecentCostInfo moveIssueBill;
            if (bill.isMoveOutBill()) {
                if (costMoveMap.get(bill.getString("FStockTransBillEntryID")) == null) {
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), bill);
                } else {
                    RecentCostInfo preCostMoveBill = (RecentCostInfo)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                    bill.setMoveInbillList(preCostMoveBill.getMoveInbillList());
                    preCostMoveBill.setMoveInbillList(new ArrayList());
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), bill);
                }
            }
            if (bill.isMoveInBill() && (moveIssueBill = (RecentCostInfo)costMoveMap.get(bill.getString("FStockTransBillEntryID"))) != null) {
                moveIssueBill.addMoveInbillList(bill);
            }
        }
    }

    protected void setCostMoveIsCalculate(RecentCostInfo bill, String calType, PeriodInfo periodInfo) {
        if (bill.isCostPriceMove()) {
            if (RecentCostHelp.isPrePeriodBill(bill, periodInfo)) {
                bill.setBoolean("IsCalculate", false);
                bill.setDealComplete(true);
            } else if ("2".equals(calType)) {
                bill.setBoolean("IsCalculate", true);
            } else if ("1".equals(calType)) {
                if (bill.isMoveInCostPriceStorage()) {
                    bill.setBoolean("IsCalculate", true);
                } else {
                    bill.setBoolean("IsCalculate", false);
                }
            } else {
                bill.setBoolean("IsCalculate", false);
            }
        }
    }

    protected void buildCostPriceMove(RecentCostInfo bill, HashMap costMoveMap) {
        if (bill.isCostPriceMove()) {
            RecentCostInfo costMoveBill = null;
            if (costMoveMap.get(bill.getStockTransBillEntryID()) == null) {
                costMoveBill = new RecentCostInfo();
                costMoveBill.setStockTransBillEntryID(bill.getStockTransBillEntryID());
                costMoveMap.put(bill.getStockTransBillEntryID(), costMoveBill);
            } else {
                costMoveBill = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
            }
            if (bill.isMoveOutBill()) {
                costMoveBill.addMoveOutbillList(bill);
            } else if (bill.isMoveInBill()) {
                costMoveBill.addMoveInbillList(bill);
            }
        }
    }

    protected void buildCostPriceMove(RecentCostInfo bill, HashMap costMoveMap, String calType) {
        if (bill.isCostPriceMove()) {
            RecentCostInfo costMoveBill = null;
            if (costMoveMap.get(bill.getStockTransBillEntryID()) == null) {
                costMoveBill = new RecentCostInfo();
                costMoveBill.setStockTransBillEntryID(bill.getStockTransBillEntryID());
                costMoveMap.put(bill.getStockTransBillEntryID(), costMoveBill);
            } else {
                costMoveBill = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
            }
            if (bill.isMoveOutBill()) {
                costMoveBill.addMoveOutbillList(bill);
            } else if (bill.isMoveInBill()) {
                costMoveBill.addMoveInbillList(bill);
            }
        }
    }

    protected void synCostMovePriceBill(HashMap costMoveMap, RecentCostInfo bill) throws CalculateException {
        if (bill.isCostPriceMove()) {
            RecentCostInfo costMoveObj = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
            boolean isMoveInbill = false;
            if (bill.isMoveInBill()) {
                isMoveInbill = true;
            }
            if (!isMoveInbill && costMoveObj != null) {
                RecentCostInfo moveCostBill = null;
                ArrayList moveCostList = costMoveObj.getMoveOutbillList();
                for (int i = 0; i < moveCostList.size(); ++i) {
                    moveCostBill = (RecentCostInfo)moveCostList.get(i);
                    if (moveCostBill.isDealComplete() || moveCostBill.isNeedUpdate()) continue;
                    return;
                }
            }
            this.calCostMoveBill(costMoveObj, bill, isMoveInbill);
        }
    }

    protected void synCostMovePriceReverseBill(HashMap costMoveMap, RecentCostInfo bill) {
        if (bill.isCostPriceMove()) {
            RecentCostInfo costMoveObj = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
            if (costMoveObj == null) {
                return;
            }
            ArrayList moveCostList = null;
            moveCostList = bill.isMoveOutBill() ? costMoveObj.getMoveOutbillList() : costMoveObj.getMoveInbillList();
            if (moveCostList != null) {
                RecentCostInfo moveCostBill = null;
                for (int i = 0; i < moveCostList.size(); ++i) {
                    moveCostBill = (RecentCostInfo)moveCostList.get(i);
                    if (!moveCostBill.isSrcMoveBillInPrePeriod() || !moveCostBill.getFSourceBillEntryID().equals(bill.getFBillEntryId())) continue;
                    moveCostBill.setRecentCost(moveCostBill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4));
                    moveCostBill.setPrice(bill.getPrice());
                    moveCostBill.setNeedUpdate(true);
                }
            }
        }
    }

    protected void calCostMoveBill(RecentCostInfo costMoveObj, RecentCostInfo bill, boolean isMoveInbill) throws CalculateException {
        RecentCostInfo needUpdateMoveCostBill = null;
        ArrayList needUpdateMoveCostList = null;
        RecentCostInfo currResultBill = null;
        ArrayList<Object> currResultBillList = null;
        int listIndex = 0;
        if (costMoveObj == null) {
            return;
        }
        currResultBillList = costMoveObj.getMoveBillList();
        if (currResultBillList == null) {
            ArrayList tempList = costMoveObj.getMoveOutbillList();
            currResultBillList = new ArrayList<Object>();
            for (int i = 0; i < tempList.size(); ++i) {
                currResultBillList.add(((RecentCostInfo)tempList.get(i)).clone());
            }
            costMoveObj.setMoveBillList(currResultBillList);
        }
        if ((needUpdateMoveCostList = isMoveInbill ? costMoveObj.getMoveOutbillList() : costMoveObj.getMoveInbillList()) != null) {
            RecentCostInfo info;
            if (currResultBillList == null && currResultBillList.size() == 0) {
                throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{costMoveObj.get("fmaterialnumber").toString()});
            }
            currResultBill = (RecentCostInfo)currResultBillList.get(listIndex++);
            BigDecimal currResultQty = currResultBill.getRecentQty();
            BigDecimal currResultCost = currResultBill.getRecentCost();
            BigDecimal avgPrice = BigDecimal.ZERO;
            int adjustIndex = -1;
            BigDecimal maxQty = BigDecimal.ZERO;
            BigDecimal outTotalAmount = BigDecimal.ZERO;
            BigDecimal inTotalAmount = BigDecimal.ZERO;
            for (int i = 0; i < needUpdateMoveCostList.size(); ++i) {
                needUpdateMoveCostBill = (RecentCostInfo)needUpdateMoveCostList.get(i);
                if (!needUpdateMoveCostBill.isDealComplete()) {
                    needUpdateMoveCostBill.setPriceSource(PriceSourEnum.costMove);
                }
                if (isMoveInbill) continue;
                BigDecimal qty = needUpdateMoveCostBill.getRecentQty();
                BigDecimal amount = BigDecimal.ZERO;
                while (currResultQty.compareTo(qty) == -1 && listIndex < currResultBillList.size()) {
                    qty = qty.subtract(currResultQty);
                    amount = amount.add(currResultCost);
                    outTotalAmount = outTotalAmount.add(currResultCost);
                    currResultBill.setRecentQty(BigDecimal.ZERO);
                    currResultBill.setRecentCost(BigDecimal.ZERO);
                    currResultBill = (RecentCostInfo)currResultBillList.get(listIndex++);
                    currResultQty = currResultBill.getRecentQty();
                    currResultCost = currResultBill.getRecentCost();
                }
                if (listIndex >= currResultBillList.size() && qty.compareTo(currResultCost) > 1) {
                    throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{bill.get("fmaterialnumber").toString()});
                }
                if (currResultQty.compareTo(qty) == 0) {
                    amount = amount.add(currResultCost);
                    outTotalAmount = outTotalAmount.add(currResultCost);
                    currResultQty = BigDecimal.ZERO;
                    currResultCost = BigDecimal.ZERO;
                } else {
                    BigDecimal amt = qty.multiply(currResultBill.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4);
                    if (amt.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) != 0 && currResultBill.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                        amt = RecentCostHelp.getMinValueByScale(bill.getInt("FLocalCurrencyPrecision"), qty.signum());
                    }
                    amount = amount.add(amt);
                    outTotalAmount = outTotalAmount.add(amt);
                    currResultQty = currResultQty.subtract(qty);
                    currResultCost = currResultCost.subtract(amt);
                }
                currResultBill.setRecentQty(currResultQty);
                currResultBill.setRecentCost(currResultCost);
                if (!needUpdateMoveCostBill.isDealComplete() && !needUpdateMoveCostBill.isNeedUpdate()) {
                    if (maxQty.compareTo(needUpdateMoveCostBill.getRecentQty()) <= 0) {
                        adjustIndex = i;
                        maxQty = needUpdateMoveCostBill.getRecentQty();
                    }
                    needUpdateMoveCostBill.setRecentCost(amount);
                    avgPrice = amount.divide(needUpdateMoveCostBill.getRecentQty(), bill.getInt("FPricePrecision"), 4);
                    needUpdateMoveCostBill.setPrice(avgPrice);
                    needUpdateMoveCostBill.setNeedUpdate(true);
                }
                inTotalAmount = inTotalAmount.add(needUpdateMoveCostBill.getRecentCost());
            }
            this.clearDealedInpourList(currResultBillList);
            if (!isMoveInbill && currResultBillList.size() == 1 && (info = (RecentCostInfo)currResultBillList.get(0)).getRecentQty().compareTo(BigDecimal.ZERO) == 0 && adjustIndex != -1) {
                needUpdateMoveCostBill = (RecentCostInfo)needUpdateMoveCostList.get(adjustIndex);
                BigDecimal diff = outTotalAmount.subtract(inTotalAmount);
                needUpdateMoveCostBill.setRecentCost(needUpdateMoveCostBill.getRecentCost().add(diff));
                RecentCostHelp.calculateAvgPrice(needUpdateMoveCostBill);
                if (needUpdateMoveCostBill.getPrice().compareTo(BigDecimal.ZERO) < 0) {
                    needUpdateMoveCostBill.setIsDealdiffOK(false);
                    needUpdateMoveCostBill.setRecentCost(needUpdateMoveCostBill.getRecentQty().multiply(BigDecimal.ZERO).setScale(bill.getInt("FLocalCurrencyPrecision"), 4));
                    needUpdateMoveCostBill.setPrice(BigDecimal.ZERO);
                }
            }
        }
    }

    protected void reWriteCostPriceMoveInPrice(RecentCostInfo info, ArrayList updateBillSql, HashMap costMoveMap) throws BOSException {
        RecentCostInfo moveIssueBill;
        if (info.isMoveOutBill() && (moveIssueBill = (RecentCostInfo)costMoveMap.get(info.getString("FStockTransBillEntryID"))) != null) {
            if (moveIssueBill.equals(info)) {
                moveIssueBill.setPrice(info.getPrice());
                moveIssueBill.setRecentCost(moveIssueBill.getPrice().multiply(moveIssueBill.getRecentQty()).setScale(moveIssueBill.getInt("FLocalCurrencyPrecision"), 4));
            }
            ArrayList moveinList = moveIssueBill.getMoveInbillList();
            RecentCostInfo inBill = null;
            for (int i = 0; moveinList != null && i < moveinList.size(); ++i) {
                inBill = (RecentCostInfo)moveinList.get(i);
                if (inBill.getBoolean("CALCULATEED")) {
                    inBill = (RecentCostInfo)inBill.clone();
                }
                inBill.setPrice(info.getPrice());
                inBill.setRecentCost(inBill.getPrice().multiply(inBill.getRecentQty()).setScale(inBill.getInt("FLocalCurrencyPrecision"), 4));
                if (inBill.getInt("FFiVouchered") != 0) continue;
                updateBillSql.add(this.updateBillsPriceSQL(inBill.getString("FEntryTableMame"), inBill));
            }
        }
    }

    protected String[] getUpateCostMoveIssueFromPrePeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_MOVEISSUEBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MOVEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_MoveIssueBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n )");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET ( FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid \n FROM  T_IM_MOVEISSUEBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MOVEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_MoveIssueBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n )");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String[] getUpateCostMoveInFromPrePeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        String[] sqls = new String[2];
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID  THEN ENTRY.FUNITACTUALCOST ELSE ");
        buffer.append(" CASE WHEN ENTRY.FBASEQTY =0 THEN 0 ELSE ROUND(TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),TEMPTABLE.FPricePrecision) END END ");
        buffer.append("\n, CASE WHEN ENTRY.FUNITID = ENTRY.FBASEUNITID THEN ");
        buffer.append("\n    CASE WHEN abs(TEMPTABLE.FBASEQTY)=ENTRY.FBASEQTY THEN ENTRY.FACTUALCOST*(TEMPTABLE.FBASEQTY/ENTRY.FBASEQTY) ");
        buffer.append("\n \t ELSE ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*Entry.FUNITACTUALCOST,17,4),TEMPTABLE.FLocalCurrencyPrecision) END");
        buffer.append("\n ELSE  ROUND(TO_DECIMAL(TEMPTABLE.FBASEQTY*TO_DECIMAL(ENTRY.FACTUALCOST/ENTRY.FBASEQTY,21,8),17,4),TEMPTABLE.FLocalCurrencyPrecision) END ");
        buffer.append("\n FROM  T_IM_MOVEINWAREHSBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MOVEINWAREHSBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_MoveInWarehsBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n  AND TEMPTABLE.FFIVOUCHERED = 0");
        buffer.append("\n )");
        sqls[0] = buffer.toString();
        buffer.setLength(0);
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET ( FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT 2 as FisSrcBilInCurrPid \n FROM  T_IM_MOVEINWAREHSBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MOVEINWAREHSBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_MoveInWarehsBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD <").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR <").append(period.getPeriodYear()).append(")");
        buffer.append("\n )");
        sqls[1] = buffer.toString();
        return sqls;
    }

    protected String getInserExcepReportSQL(RecentCostInfo bill, PeriodInfo periodInfo) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO T_CL_CostComputeExcepRpt(FID ,FBillId,FNumber,FEntryID,FEntrySeq,");
        buffer.append("FYEAR,FPERIOD,FMaterialID,FExceptionType,FQty,");
        buffer.append("FUnitActualCost,FActualCost,FComment,FCreatorID,FCreateTime,");
        buffer.append("FCompanyorgunitID,FStorageorgunitID,FWarehouseID)");
        buffer.append("\n VALUES(NEWBOSID('2F1F9D8E'),'" + bill.getString("FBillId") + "','" + bill.getString("FNumber") + "','" + bill.getString("FBillEntryId") + "'," + bill.getInt("FSeqNum") + ",");
        buffer.append(periodInfo.getPeriodYear() + "," + periodInfo.getPeriodNumber() + ",'" + bill.getString("FMaterialID") + "',1," + bill.getRecentQty() + ",");
        buffer.append(bill.getPrice() + "," + bill.getRecentCost() + ",null,null,now(),'");
        buffer.append(bill.getString("FCompanyorgunitID") + "','" + bill.getString("FStorageorgunitID") + "','" + bill.getString("FWarehouseID"));
        buffer.append("')");
        return buffer.toString();
    }

    protected String getInsertFiFoBillSQL(String tempTableFIFOBills) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(tempTableFIFOBills);
        buffer.append("(FID,FBillId,FBillEntryId,FEntryTableMame,FNumber,FBizDate,FCompanyOrgUnitID,FMaterialId,").append("\t\n");
        buffer.append(" FStorageorg,Fstorageorgunitid,Fwarehouse,Fwarehouseid,FBaseQty,FBaseQtyBak,FActualCost,FPrice,FReverseQty,FPricePrecision,").append("\t\n");
        buffer.append(" FLocalCurrencyPrecision,FCalculateKind,FbillTypeID,FTransactionTypeName,FSeqNum,FFiVouchered,FBizTypeID,FSourceBillID,FSourceBillEntryID,FSourceBillEntrySeq,").append("\t\n");
        buffer.append(" FSourceUnitActualCost,FActualCostBak,FmaterialNumber,FisCombition,FisSrcBilInCurrPid,FISPRESENT,FStockTransBillEntryID,FAUDITTIME,").append("\t\n");
        buffer.append(" FSourceBillTypeID,FIsReversed,FIsReWork,FOutwarehouseType,FStoreTypeID,FStoreTypePreID,FBillTypeName,FBaseUnit,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,").append("\t\n");
        buffer.append(" FUnitID,FQty,FWrittenOffBaseQty,FUnWriteOffBaseQty,FisWriteOffVouched)").append("\t\n");
        buffer.append("\t\n");
        return buffer.toString();
    }

    protected String getInsertMMUnitSQL(String tempTableFIFOBills) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("INSERT INTO ").append(tempTableFIFOBills);
        buffer.append("(FID,FBillId,FBillEntryId,FEntryTableMame,FNumber,FBizDate,FCompanyOrgUnitID,FMaterialId,").append("\t\n");
        buffer.append(" FStorageorg,Fstorageorgunitid,Fwarehouse,Fwarehouseid,FBaseQty,FBaseQtyBak,FActualCost,FPrice,FReverseQty,FPricePrecision,FQtyPrecision,").append("\t\n");
        buffer.append(" FLocalCurrencyPrecision,FCalculateKind,FbillTypeID,FTransactionTypeName,FSeqNum,FFiVouchered,FBizTypeID,FSourceBillID,FSourceBillEntryID,FSourceBillEntrySeq,").append("\t\n");
        buffer.append(" FSourceUnitActualCost,FActualCostBak,FmaterialNumber,FisCombition,FisSrcBilInCurrPid,FISPRESENT,FStockTransBillEntryID,FAUDITTIME,").append("\t\n");
        buffer.append(" FSourceBillTypeID,FIsReversed,FIsReWork,FOutwarehouseType,FStoreTypeID,FStoreTypePreID,FBillTypeName,FBaseUnit,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,").append("\t\n");
        buffer.append(" FUnitID,FQty,FWrittenOffBaseQty,FUnWriteOffBaseQty,FisWriteOffVouched,FBASECONVSRATE,FStockStatus,FStockClosePeriod)").append("\t\n");
        buffer.append("\t\n");
        return buffer.toString();
    }

    protected void buildPrePeriodCostMoveBill(Context ctx, SysTempTableHelper sysTempTableHelper, CalculateParams params, String strCalType, PeriodInfo periodInfo, String tempTableFIFOBills) throws BOSException, SQLException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        this.takePreCostMoveBillSQL(ctx, sysTempTableHelper, Local_Currency_Presision, periodInfo, strCalType, params, tempTableFIFOBills);
    }

    protected void takePreCostMoveBillSQL(Context ctx, SysTempTableHelper sysTempTableHelper, int local_Currency_Presision, PeriodInfo periodInfo, String strCalType, CalculateParams params, String tempTableFIFOBill) throws BOSException, SQLException {
        params.setBoolean("isGetPrePeriod", true);
        String tempStockEntryIDs = params.getString("T_Temp_StockTransBillEntryID");
        String fields = "";
        StringBuffer fieldBuffer = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        sql.append("Insert into ").append(tempStockEntryIDs).append("(FStockTransBillEntryID)").append("\t\n");
        sql.append("Select FStockTransBillEntryID From ").append(tempTableFIFOBill).append("\t\n");
        sql.append("Where FStockTransBillEntryID IS NOT NULL").append("\t\n");
        sql.append("Group by FStockTransBillEntryID");
        sysTempTableHelper.execute(sql.toString());
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        fieldBuffer.append(" Bill.FBizTypeID,Bill.FFiVouchered,Entry.FSeq AS FSeqNum,Bill.fid as FBillId,Entry.fid as FBillEntryId,").append("\t\n");
        fieldBuffer.append(" 0 AS FCalculateKind,Bill.FIsReversed,Entry.FReverseQty,");
        fieldBuffer.append(" ISNULL(MATERIAL.FPricePrecision,2) AS FPricePrecision,");
        fieldBuffer.append(" ISNULL(MeasureUnitBase.FQtyPrecision,4) AS FQtyPrecision,");
        fieldBuffer.append(Local_Currency_Presision).append(" AS FLocalCurrencyPrecision,").append("\t\n");
        fieldBuffer.append("ENTRY.FStockTransBillEntryID,BILL.FAUDITTIME,").append("\t\n");
        fieldBuffer.append(" Bill.FSourceBillTypeID as FSourceBillTypeID,").append("\t\n");
        fieldBuffer.append(" ENTRY.FISPRESENT,BILL.FTransactionTypeID");
        sql.setLength(0);
        sql.append(this.getInsertMMUnitSQL(tempTableFIFOBill));
        sql.append(this.getTakeInOutBillTempSQLSelect());
        sql.append("\t\n").append(" From (").append("\t\n");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append(sql.toString());
        String outFieldBuffer = fieldBuffer.toString() + ",NULL AS FStoreTypeID, InvUpdateType.FStoreTypePreID AS FStoreTypePreID";
        fields = this.getInOutBillShareFieldsCalcuate(ctx, outFieldBuffer, INVENTORYBILL_TABLENAME[6], 3, params, false);
        sql.append(this.getPreMoveIssueBillSql(periodInfo, strCalType, params, fields));
        sql.append(" ) Bill ");
        sysTempTableHelper.execute(sql.toString());
        String inFieldBuffer = fieldBuffer.toString() + ",InvUpdateType.FStoreTypeID AS FStoreTypeID, NULL AS FStoreTypePreID";
        fields = this.getInOutBillShareFieldsCalcuate(ctx, inFieldBuffer, INVENTORYBILL_TABLENAME[2], -1, params, false);
        insertSQL.append(this.getPreMoveInBillSql(periodInfo, strCalType, params, fields));
        insertSQL.append(" ) Bill ");
        sysTempTableHelper.execute(insertSQL.toString());
        params.setBoolean("isGetPrePeriod", false);
    }

    private String getPreMoveInBillSql(PeriodInfo periodInfo, String filterCalType, CalculateParams params, String fields) {
        params.setObject("tabName", (Object)INVENTORYBILL_TABLENAME[2]);
        StringBuffer sql = new StringBuffer();
        String tempStockEntryIDs = params.getString("T_Temp_StockTransBillEntryID");
        sql.append(" SELECT ").append(fields).append("\t\n");
        sql.append(" FROM T_IM_MoveInWarehsBillEntry ENTRY ").append("\t\n");
        sql.append(" INNER JOIN T_IM_MoveInWarehsBill BILL ON BILL.FID = ENTRY.FParentID ").append("\t\n");
        sql.append(" INNER JOIN ").append(tempStockEntryIDs).append(" TmpTable ON TmpTable.FStockTransBillEntryID=ENTRY.FStockTransBillEntryID").append("\t\n");
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append("\t\n");
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypeID = StoreType.FID ").append("\t\n");
        String materialTempTable = "T_BD_Material";
        if (params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_FROM")) || params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_TO"))) {
            materialTempTable = params.getString("materialTempTable");
        }
        sql.append(this.getSQLJOINBaseCalcuate(materialTempTable));
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append("\t\n");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID").append("\t\n");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append("\t\n");
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)").append("\t\n");
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid");
        sql.append(" AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)").append("\t\n");
        sql.append(this.getSQLWhereCalcuate(periodInfo, params));
        sql.append(this.getFilterByCalTypeCalculate(filterCalType, params, this.INVENTORY_FIELD));
        sql.append(" AND Bill.FBizTypeID IN (");
        sql.append("'").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(")").append("\t\n");
        sql.append(" AND SCMTRANSACTIONTYPE.FIsCalculate = 1").append("\t\n");
        sql.append(this.getMaterialTypeSQL(params));
        sql.append(this.takeMaterialAccountTypeWhereSQL());
        return sql.toString();
    }

    private String getPreMoveIssueBillSql(PeriodInfo periodInfo, String filterCalType, CalculateParams params, String fields) {
        params.setObject("tabName", (Object)INVENTORYBILL_TABLENAME[6]);
        StringBuffer sql = new StringBuffer();
        String tempStockEntryIDs = params.getString("T_Temp_StockTransBillEntryID");
        sql.append(" SELECT ").append(fields).append("\t\n");
        sql.append(" FROM T_IM_MoveIssueBillEntry ENTRY").append("\t\n");
        sql.append(" INNER JOIN T_IM_MoveIssueBill BILL ON BILL.FID = ENTRY.FParentID ").append("\t\n");
        sql.append(" INNER JOIN ").append(tempStockEntryIDs).append(" TmpTable ON TmpTable.FStockTransBillEntryID=ENTRY.FStockTransBillEntryID").append("\t\n");
        sql.append(" INNER JOIN T_IM_InvUpdateType InvUpdateType ON ENTRY.FInvUpdateTypeID = InvUpdateType.FID ").append("\t\n");
        sql.append(" INNER JOIN T_IM_StoreType StoreType ON InvUpdateType.FStoreTypePreID = StoreType.FID ").append("\t\n");
        String materialTempTable = "T_BD_Material";
        if (params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_FROM")) || params != null && !StringUtil.isEmpty((String)params.getString("MATERIAL_TO"))) {
            materialTempTable = params.getString("materialTempTable");
        }
        sql.append(this.getSQLJOINBaseCalcuate(materialTempTable));
        sql.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append("\t\n");
        sql.append(" INNER JOIN T_BD_MaterialCompanyInfo MATERIALCOMPANY ");
        sql.append(" ON (ENTRY.FMaterialId = MATERIALCOMPANY.FMaterialID").append("\t\n");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = MATERIALCOMPANY.FCompanyID )").append("\t\n");
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnitBase");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND ENTRY.FBaseUnitID = MeasureUnitBase.FMeasureUnitID)").append("\t\n");
        sql.append(" INNER JOIN t_bd_MultiMeasureUnit MeasureUnit");
        sql.append(" ON (ENTRY.FMaterialID = MeasureUnit.FMaterialid");
        sql.append(" AND ENTRY.FUnitID = MeasureUnit.FMeasureUnitID)").append("\t\n");
        sql.append(this.getSQLWhereCalcuate(periodInfo, params));
        sql.append(this.getFilterByCalTypeCalculate(filterCalType, params, this.INVENTORY_FIELD));
        sql.append(" AND Bill.FBizTypeID IN (");
        sql.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(",'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'");
        sql.append(")").append("\t\n");
        sql.append(" AND SCMTRANSACTIONTYPE.FIsCalculate = 1").append("\t\n");
        sql.append(this.getMaterialTypeSQL(params));
        sql.append(this.takeMaterialAccountTypeWhereSQL());
        return sql.toString();
    }

    protected String getMaterialSql(Context ctx, String tmpMaterialTable) {
        StringBuffer tmpMaterila = new StringBuffer();
        tmpMaterila.append("SELECT FMaterialId,FmaterialNumber,FCompanyOrgUnitID,");
        tmpMaterila.append("       FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision \n");
        if (KsqlUtil.isDB2((Context)ctx)) {
            tmpMaterila.append("FROM SESSION.").append(tmpMaterialTable).append("\n");
        } else {
            tmpMaterila.append("FROM ").append(tmpMaterialTable).append("\n");
        }
        tmpMaterila.append("GROUP By FMaterialId,FmaterialNumber,FCompanyOrgUnitID,");
        tmpMaterila.append("         FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision");
        tmpMaterila.append(" ORDER By FMaterialId,FmaterialNumber,FCompanyOrgUnitID,");
        tmpMaterila.append(" FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision");
        return tmpMaterila.toString();
    }

    protected String getMaterialSqlNew(Context ctx, String tmpMaterialTable, CalculateParams params) {
        StringBuffer tmpMaterila = new StringBuffer();
        tmpMaterila.append("SELECT FMaterialId,FmaterialNumber,FCompanyOrgUnitID,");
        tmpMaterila.append("       FPricePrecision,FLocalCurrencyPrecision,FQtyPrecision \n");
        if (KsqlUtil.isDB2((Context)ctx)) {
            tmpMaterila.append("FROM SESSION.").append(tmpMaterialTable).append(" matTbl \n");
        } else {
            tmpMaterila.append("FROM ").append(tmpMaterialTable).append(" matTbl \n");
        }
        return tmpMaterila.toString();
    }

    protected RecentCostInfo convertRecentCostInfo(ResultSet rs, String strCalType, long timeSerialNumber) throws SQLException {
        return this.convertRecentCostInfo(rs, strCalType, timeSerialNumber, false);
    }

    protected RecentCostInfo convertRecentCostInfo(ResultSet rs, String strCalType, long timeSerialNumber, boolean isAddLot, Map<String, String> redAndBlueIdMap) throws SQLException {
        RecentCostInfo bill = new RecentCostInfo();
        bill.setPrice(rs.getBigDecimal("FPrice").setScale(rs.getInt("FPricePrecision"), 4));
        bill.setRecentCost(rs.getBigDecimal("FActualCost").setScale(rs.getInt("FLocalCurrencyPrecision"), 4));
        bill.setRecentQty(rs.getBigDecimal("FBaseQty").setScale(rs.getInt("FQtyPrecision"), 4));
        bill.setInt("FPricePrecision", rs.getInt("FPricePrecision"));
        bill.setInt("FLocalCurrencyPrecision", rs.getInt("FLocalCurrencyPrecision"));
        bill.setInt("FQtyPrecision", rs.getInt("FQtyPrecision"));
        bill.setString("FBillEntryId", rs.getString("FBillEntryId"));
        bill.setString("FBillId", rs.getString("FBillId"));
        bill.setString("FEntryTableMame", rs.getString("FEntryTableMame"));
        bill.setString("FNumber", rs.getString("FNumber"));
        if (rs.getInt("FisWriteOffVouched") == 1) {
            bill.setInt("FFiVouchered", 1);
        } else {
            bill.setInt("FFiVouchered", rs.getInt("FFiVouchered"));
        }
        bill.setLong("timeSerialNumber", timeSerialNumber);
        bill.setBigDecimal("FReverseQty", rs.getBigDecimal("FReverseQty"));
        bill.setBigDecimal("FBaseQtyBak", rs.getBigDecimal("FBaseQtyBak"));
        bill.setInt("FCalculateKind", rs.getInt("FCalculateKind"));
        bill.setBigDecimal("freverseqty", rs.getBigDecimal("freverseqty"));
        bill.setString("FStorageOrgUnitId", rs.getString("FStorageOrgUnitId"));
        bill.setString("FWarehouseId", rs.getString("FWarehouseId"));
        bill.setString("FMaterialID", rs.getString("FMaterialID"));
        bill.setString("FCompanyOrgUnitID", rs.getString("FCompanyOrgUnitID"));
        bill.setString("FBillTypeID", rs.getString("FBillTypeID"));
        bill.setTimestamp("FBizDate", rs.getTimestamp("FBizDate"));
        String billTypeName = "";
        billTypeName = "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getString("FBillTypeID")) ? rs.getString("FBillTypeName") : rs.getString("FBillTypeName") + " - " + rs.getString("FTransactionTypeName");
        if ("T_IM_InventoryBalance".equals(rs.getString("FEntryTableMame"))) {
            billTypeName = "";
        }
        bill.setString("FBillTypeName", billTypeName);
        bill.setDealComplete(false);
        bill.setBoolean(IS_MINUS_SETTLEACCOUNT, false);
        bill.setBigDecimal("addUpQty", CalculateUtil.ZERO);
        bill.setBigDecimal("addUpAmount", CalculateUtil.ZERO);
        bill.setString("FBizTypeID", rs.getString("FBizTypeID"));
        bill.setString("FSourceBillEntryID", rs.getString("FSourceBillEntryID"));
        bill.setBigDecimal("FSourceUnitActualCost", rs.getBigDecimal("FSourceUnitActualCost"));
        bill.setBigDecimal("FActualCostBak", rs.getBigDecimal("FActualCostBak"));
        bill.setString("FmaterialNumber", rs.getString("FmaterialNumber"));
        bill.setInt("FisCombition", rs.getInt("FisCombition"));
        bill.setInt("FisSrcBilInCurrPid", rs.getInt("FisSrcBilInCurrPid"));
        bill.setString("FLot", rs.getString("FLot"));
        bill.setString("strCalType", strCalType);
        bill.setString("FSourceBillTypeID", rs.getString("FSourceBillTypeID"));
        bill.setString("FIsReversed", rs.getString("FIsReversed"));
        bill.setBoolean("IsCalculate", true);
        bill.setString("FAssistPropertyID", rs.getString("FAssistPropertyID"));
        bill.setString("FProjectID", rs.getString("FProjectID"));
        bill.setString("FTrackNumberID", rs.getString("FTrackNumberID"));
        bill.setString("FkeyID", this.getFifoCalTypeKey(bill, strCalType, isAddLot));
        bill.setFkeyID(this.getFifoCalTypeKey(bill, strCalType, isAddLot));
        bill.setString("FkeyID_CSW", this.getCSWKey(bill));
        bill.setInt("isReWork", rs.getInt("FIsReWork"));
        bill.setString("FStoreTypeID", rs.getString("FStoreTypeID"));
        bill.setString("FStoreTypePreID", rs.getString("FStoreTypePreID"));
        bill.setString("FBaseUnit", rs.getString("FBaseUnit"));
        bill.setString("FUnitID", rs.getString("FUnitID"));
        bill.setBigDecimal("FQty", rs.getBigDecimal("FQty"));
        bill.setBigDecimal("FWrittenOffBaseQty", rs.getBigDecimal("FWrittenOffBaseQty"));
        bill.setBigDecimal("FUnWriteOffBaseQty", rs.getBigDecimal("FUnWriteOffBaseQty"));
        bill.setStockTransBillEntryID(rs.getString("FStockTransBillEntryID"));
        if (isAddLot && !StringUtil.isEmpty((String)bill.getString("FStockTransBillEntryID"))) {
            StringBuffer FStockTransBillEntryID = new StringBuffer(bill.getString("FStockTransBillEntryID"));
            FStockTransBillEntryID.append(this.getCalModelKey(bill, "FLot"));
            FStockTransBillEntryID.append(this.getCalModelKey(bill, "FAssistPropertyID"));
            FStockTransBillEntryID.append(this.getCalModelKey(bill, "FProjectID"));
            FStockTransBillEntryID.append(this.getCalModelKey(bill, "FTrackNumberID"));
            bill.setString("FStockTransBillEntryID", FStockTransBillEntryID.toString());
            bill.setStockTransBillEntryID(FStockTransBillEntryID.toString());
        }
        bill.setFBillEntryId(rs.getString("FBillEntryId"));
        bill.setFSourceBillEntryID(rs.getString("FSourceBillEntryID"));
        bill.setFEntryTableMame(rs.getString("FEntryTableMame"));
        bill.setBigDecimal("FBASECONVSRATE", rs.getBigDecimal("FBASECONVSRATE"));
        bill.setStockClose(7 == rs.getInt("FStockStatus"));
        bill.setStockCloseinafterPeriod(rs.getInt("FStockClosePeriod") > this.currPeriod.getNumber());
        if (redAndBlueIdMap != null) {
            bill.setFBlueBillEntryID(redAndBlueIdMap.get(bill.getFBillEntryId()));
        }
        return bill;
    }

    protected RecentCostInfo convertRecentCostInfo(ResultSet rs, String strCalType, long timeSerialNumber, boolean isAddLot) throws SQLException {
        return this.convertRecentCostInfo(rs, strCalType, timeSerialNumber, isAddLot, null);
    }

    protected String getFifoCalTypeKey(RecentCostInfo bill, String strCalType) {
        return this.getFifoCalTypeKey(bill, strCalType, false);
    }

    protected String getFifoCalTypeKey(RecentCostInfo bill, String strCalType, boolean isAddLot) {
        StringBuffer buffer = new StringBuffer();
        if ("0".equals(strCalType)) {
            buffer.append(bill.getString("FCompanyOrgUnitID"));
        } else if ("1".equals(strCalType)) {
            buffer.append(bill.getString("FCompanyOrgUnitID"));
            if (bill.getString("FStorageOrgUnitId") != null) {
                buffer.append("_$$$$_").append(bill.getString("FStorageOrgUnitId"));
            }
        } else {
            buffer.append(bill.getString("FCompanyOrgUnitID"));
            if (bill.getString("FStorageOrgUnitId") != null) {
                buffer.append("_$$$$_").append(bill.getString("FStorageOrgUnitId"));
            }
            if (bill.getString("FWarehouseId") != null) {
                buffer.append("_$$$$_").append(bill.getString("FWarehouseId"));
            }
        }
        if (isAddLot) {
            buffer.append(this.getCalModelKey(bill, "FLot"));
            buffer.append(this.getCalModelKey(bill, "FAssistPropertyID"));
            buffer.append(this.getCalModelKey(bill, "FProjectID"));
            buffer.append(this.getCalModelKey(bill, "FTrackNumberID"));
        }
        return buffer.toString();
    }

    protected StringBuffer getCalModelKey(RecentCostInfo bill, String calModel) {
        StringBuffer calModelSB = new StringBuffer();
        String calModelStr = bill.getString(calModel);
        if (!StringUtils.isEmpty((String)calModelStr)) {
            calModelSB.append("_$$$$_").append(calModelStr);
        } else {
            calModelSB.append("_$$$$_").append("X");
        }
        return calModelSB;
    }

    protected String getCSWKey(RecentCostInfo bill) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bill.getString("FCompanyOrgUnitID"));
        if (bill.getString("FStorageOrgUnitId") != null) {
            buffer.append("_$$$$_").append(bill.getString("FStorageOrgUnitId"));
        }
        if (bill.getString("FWarehouseId") != null) {
            buffer.append("_$$$$_").append(bill.getString("FWarehouseId"));
        }
        return buffer.toString();
    }

    protected String updateBillCostSQL(String billEntry, RecentCostInfo bill) throws SQLException {
        StringBuffer sql = new StringBuffer();
        String recentCost = StringUtil.toString((BigDecimal)bill.getRecentCost());
        String price = StringUtil.toString((BigDecimal)bill.getPrice());
        int pricePrecison = bill.getInt("FPricePrecision");
        int costPrecison = bill.getInt("FLocalCurrencyPrecision");
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET (FActualCost,FUnitActualCost,FBaseUnitActualCost");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FWrittenOffAmount,FUnWriteOffAmount");
        } else if (this.issueTableArray[2][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FSCWrittenOffAmount,FSCUnWrittenOffAmount");
        }
        sql.append(" ) = ( ").append("\t\n");
        sql.append("SELECT ").append(recentCost).append(" as FActualCost,").append("\t\n");
        sql.append("case when Entry.FUNITID = Entry.FBASEUNITID then ").append(price).append("\t\n");
        sql.append(" else ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE(recentCost + "/ Entry.FQty"));
        sql.append(", ").append(pricePrecison).append(")").append("\t\n");
        sql.append("end ").append(" as FActualUnitCost,");
        sql.append(price).append(" as FActualUnitCost").append("\t\n");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(",case when Entry.FWrittenOffBaseQty = Entry.FBaseQty then ").append(recentCost).append("\t\n");
            sql.append("  else ROUND(").append(price).append(" * Entry.FWrittenOffBaseQty, ").append(costPrecison).append(")").append("\t\n");
            sql.append(" end as FWrittenOffAmount").append("\t\n");
            sql.append(",case when Entry.FUnWriteOffBaseQty = Entry.FBaseQty then ").append(recentCost).append("\t\n");
            sql.append("  else ").append(recentCost);
            sql.append(" - ROUND(").append(CalculateUtil.TO_DECIMAL_SUM(price + " * Entry.FWrittenOffBaseQty"));
            sql.append(", ").append(costPrecison).append(")").append("\t\n");
            sql.append("  end as FUnWriteOffAmount").append("\t\n");
        } else if (this.issueTableArray[2][0].equalsIgnoreCase(billEntry)) {
            sql.append(",case when Entry.FSubWrittenOffBaseQty = Entry.FBaseQty then ").append(recentCost).append("\t\n");
            sql.append("  else ROUND(").append(price).append(" * Entry.FSubWrittenOffBaseQty, ").append(costPrecison).append(")").append("\t\n");
            sql.append(" end as FWrittenOffAmount").append("\t\n");
            sql.append(",case when Entry.FSubUnWriteOffBaseQty = Entry.FBaseQty then ").append(recentCost).append("\t\n");
            sql.append("      when Entry.FSubWrittenOffBaseQty = Entry.FBaseQty then ").append(" 0 ").append("\t\n");
            sql.append("  else ").append(recentCost);
            sql.append(" - ROUND(").append(CalculateUtil.TO_DECIMAL_SUM(price + " * Entry.FSubWrittenOffBaseQty"));
            sql.append(", ").append(costPrecison).append(")").append("\t\n");
            sql.append("  end as FUnWriteOffAmount").append("\t\n");
        }
        sql.append("FROM ").append(billEntry).append(" Entry ").append("\t\n");
        sql.append("WHERE Entry.FID = '").append(bill.getString("FBillEntryId")).append("' ");
        sql.append("AND T.FID = Entry.FID");
        sql.append(") ").append("WHERE T.FID = '").append(bill.getString("FBillEntryId")).append("'");
        return sql.toString();
    }

    protected String getUpateMaterialReqPriceFromCurrOrAfterPeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT  FUNITACTUALCOST,TEMPTABLE.FBASEQTY*FUNITACTUALCOST  FROM  T_IM_MATERIALREQBILLENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_MATERIALREQBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID");
        buffer.append("\n AND T1.FENTRYTABLEMAME ='T_IM_MaterialReqBillEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD >=").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR >").append(period.getPeriodYear()).append(")");
        buffer.append("\n )");
        return buffer.toString();
    }

    protected String getUpateSaleIssuePriceFromCurrOrAfterPeriod(String fifoBillTmpTalbe, PeriodInfo period) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTalbe).append(" AS T1");
        buffer.append("\n SET  (FPRICE ,FACTUALCOST) =(");
        buffer.append("\n SELECT  FUNITACTUALCOST,TEMPTABLE.FBASEQTY*FUNITACTUALCOST  FROM  T_IM_SALEISSUEENTRY ENTRY ");
        buffer.append("\n INNER JOIN T_IM_SALEISSUEBILL bill ON bill.FID = ENTRY.FPARENTID ");
        buffer.append("\n INNER JOIN ").append(fifoBillTmpTalbe).append(" AS TEMPTABLE");
        buffer.append("\n ON ENTRY.FID = TEMPTABLE.FSOURCEBILLENTRYID");
        buffer.append("\n WHERE  T1.FID = TEMPTABLE.FID ");
        buffer.append("AND T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry'");
        buffer.append("\n AND ( (bill.FYEAR =").append(period.getPeriodYear());
        buffer.append("\n AND bill.FPERIOD >=").append(period.getPeriodNumber());
        buffer.append(") OR bill.FYEAR >").append(period.getPeriodYear()).append(")");
        buffer.append("\n ) where T1.FENTRYTABLEMAME = 'T_IM_SaleIssueEntry'");
        return buffer.toString();
    }

    protected boolean calculateCurrentBalance(Context ctx, ArrayList rsInpour, RecentCostInfo rsPayout, ArrayList listPayout) throws BOSException, EASBizException {
        boolean isExceptionState = false;
        HashMap<String, BigDecimal> addUpInfo = new HashMap<String, BigDecimal>();
        addUpInfo.put("addUpQty", CalculateUtil.ZERO);
        addUpInfo.put("addUpAmount", CalculateUtil.ZERO);
        BigDecimal baseqtyPayout = rsPayout.getRecentQty();
        BigDecimal amtPayout = rsPayout.getRecentCost();
        BigDecimal pricePayout = rsPayout.getPrice();
        BigDecimal baseqtyInpour = CalculateUtil.ZERO;
        BigDecimal amtInpour = CalculateUtil.ZERO;
        for (int i = 0; i < rsInpour.size(); ++i) {
            boolean isBreak = true;
            RecentCostInfo settleAccounts = (RecentCostInfo)rsInpour.get(i);
            if (settleAccounts.isDealComplete() && settleAccounts.getBoolean(IS_MINUS_SETTLEACCOUNT)) continue;
            baseqtyInpour = settleAccounts.getRecentQty();
            amtInpour = settleAccounts.getRecentCost();
            BigDecimal addUpAmount = (BigDecimal)addUpInfo.get("addUpAmount");
            BigDecimal addUpQty = (BigDecimal)addUpInfo.get("addUpQty");
            addUpAmount = addUpAmount.add(amtInpour);
            addUpQty = addUpQty.add(baseqtyInpour);
            BigDecimal addUpPrice = CalculateUtil.ZERO;
            if (CalculateUtil.ZERO.compareTo(addUpQty) != 0) {
                addUpPrice = addUpAmount.divide(addUpQty, rsPayout.getInt("FPricePrecision"), 4);
            }
            if (CalculateUtil.ZERO.compareTo(addUpPrice) >= 0) {
                addUpPrice = pricePayout;
            }
            if (!rsPayout.isCostAdjustBill()) {
                if (baseqtyPayout.compareTo(addUpQty) > 0) {
                    baseqtyInpour = CalculateUtil.ZERO;
                    amtInpour = CalculateUtil.ZERO;
                    if (i == rsInpour.size() - 1) {
                        if (CalculateUtil.ZERO.compareTo(addUpPrice) > 0) {
                            baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                            amtInpour = addUpAmount.subtract(amtPayout);
                            isExceptionState = true;
                            return isExceptionState;
                        }
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                        amtInpour = addUpAmount.subtract(amtPayout);
                    }
                    isBreak = false;
                } else if (baseqtyPayout.compareTo(addUpQty) == 0) {
                    if (CalculateUtil.ZERO.compareTo(addUpAmount) < 0) {
                        amtPayout = rsPayout.getRecentCost();
                        baseqtyInpour = CalculateUtil.ZERO;
                        amtInpour = addUpAmount.subtract(amtPayout);
                    } else {
                        if (i == rsInpour.size() - 1) {
                            baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                            amtInpour = addUpAmount.subtract(amtPayout);
                            isExceptionState = true;
                            return isExceptionState;
                        }
                        baseqtyInpour = CalculateUtil.ZERO;
                        amtInpour = CalculateUtil.ZERO;
                        isBreak = false;
                    }
                } else if (baseqtyPayout.compareTo(addUpQty) < 0) {
                    if (CalculateUtil.ZERO.compareTo(addUpAmount) < 0) {
                        amtInpour = addUpAmount.subtract(amtPayout);
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                    } else if (i == rsInpour.size() - 1) {
                        baseqtyInpour = addUpQty.subtract(baseqtyPayout);
                        if (CalculateUtil.ZERO.compareTo(addUpQty) != 0) {
                            addUpPrice = addUpAmount.divide(addUpQty, rsPayout.getInt("FPricePrecision"), 4);
                        }
                        if (CalculateUtil.ZERO.compareTo(addUpPrice) > 0) {
                            isExceptionState = true;
                            return isExceptionState;
                        }
                        amtPayout = addUpPrice.multiply(baseqtyPayout).setScale(rsPayout.getInt("FLocalCurrencyPrecision"), 4);
                        amtInpour = addUpAmount.subtract(amtPayout);
                    } else {
                        baseqtyInpour = CalculateUtil.ZERO;
                        amtInpour = CalculateUtil.ZERO;
                        isBreak = false;
                    }
                }
            }
            settleAccounts.setBoolean("CALCULATEED", true);
            addUpInfo.put("addUpQty", addUpQty);
            addUpInfo.put("addUpAmount", addUpAmount);
            settleAccounts.setRecentCost(amtInpour);
            settleAccounts.setRecentQty(baseqtyInpour);
            if (isBreak) break;
        }
        this.clearDealedInpourList(rsInpour);
        return isExceptionState;
    }

    protected void adjustPrePeriodData(Connection conn, CalculateParams params, PeriodInfo periodInfo, String tempTableFIFOBills) throws BOSException, SQLException {
        LowTimer tt = new LowTimer();
        DBUtil.execute(conn, this.getUpateMaterialReqPriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9886\u6599\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(conn, this.getUpateSaleIssuePriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9500\u552e\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(conn, this.getUpdateSrcBillBizDate(tempTableFIFOBills));
    }

    protected String getUpdateSrcBillBizDate(String fifoBillTmpTabName) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("UPDATE ").append(fifoBillTmpTabName).append(" AS T1");
        buffer.append("\n SET (FBizDate,FisSrcBilInCurrPid) =(");
        buffer.append("\n SELECT ADD_SECONDS(T2.FBIZDATE,1),-1 FROM ").append(fifoBillTmpTabName).append(" AS T2");
        buffer.append("\n WHERE T1.FSourceBillEntryID = T2.FBillEntryId and T1.FEntryTablemame = T2.FEntryTablemame");
        buffer.append("\n AND T1.FEntryTablemame !='t_cl_costadjustbillentry'");
        buffer.append("\n AND not (T1.fstoretypeid is null and T1.fbiztypeid = 'd8e80652-0113-1000-e000-04c5c0a812202407435C')");
        buffer.append("\n )");
        return buffer.toString();
    }

    protected void updateBills(Connection conn, ArrayList updateBillSql, HashMap balanceMap, boolean isupdate) throws SQLException, BOSException {
        if (balanceMap != null) {
            ArrayList allBillList = (ArrayList)balanceMap.get("ALLINOUTLIST");
            this.updateBills(conn, updateBillSql, allBillList, balanceMap, isupdate);
        }
    }

    protected void updateBills(Connection conn, ArrayList updateBillSql, List billList, HashMap balanceMap, boolean isupdate) throws SQLException, BOSException {
        if (balanceMap == null || billList == null) {
            return;
        }
        RecentCostInfo billInfo = null;
        for (int i = 0; i < billList.size(); ++i) {
            billInfo = (RecentCostInfo)billList.get(i);
            if (billInfo.getString("FEntryTableMame") == null || !billInfo.isNeedUpdate() || billInfo.getInt("FFiVouchered") == 1) continue;
            updateBillSql.add(this.updateBillCostSQL(billInfo.getString("FEntryTableMame"), billInfo));
        }
        this.execBatchSql(conn, updateBillSql, isupdate);
    }

    protected void executePsBatch(Statement ps) throws SQLException {
        if (ps != null) {
            ps.executeBatch();
            ps.clearBatch();
        }
    }

    protected void handleCostRept(Context ctx, PreparedStatement rptPs, HashMap balanceMap, PeriodInfo period, CalculateParams params) throws SQLException {
        List rptList = (List)balanceMap.get("ALLINOUTLIST");
        this.handleCostRept(ctx, rptPs, period, params, rptList);
    }

    protected void handleCostRept(Context ctx, PreparedStatement rptPs, PeriodInfo period, CalculateParams params, List rptList) throws SQLException {
        String fparentID = params.getString("headerid");
        if (rptList == null) {
            return;
        }
        String CALTYPE = params.getString("CALTYPE");
        String diffAdjustFail = "";
        String diffAdjustFailTips = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"diffAdjustFailTips", (Context)ctx);
        String handleTailDiff = SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"HANDLE_TAIL_DIFF", (Context)ctx);
        RecentCostInfo billInfo = null;
        BOSObjectType bosType = new CostComputeReportInfo().getBOSType();
        Date now = new Date();
        boolean isOnlyWriteExpRpt = params.getBoolean("ISWRITEDEXPCOSTRPT");
        StringBuffer buffer = null;
        int accountType = params.getInt("ACCOUNT_TYPE");
        HashMap keyExceptionState = null;
        if (isOnlyWriteExpRpt && params.getObject("keyExceptionState") != null) {
            keyExceptionState = (HashMap)params.getObject("keyExceptionState");
        }
        for (int i = 0; rptList != null && i < rptList.size(); ++i) {
            int successFlag;
            billInfo = (RecentCostInfo)rptList.get(i);
            if (!RecentCostHelp.isEffectBalance(billInfo, billInfo.getString("strCalType")) && !billInfo.isCommissionSaleOut()) continue;
            if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) == 0) {
                RecentCostHelp.calculateAvgPrice(billInfo);
            }
            if (billInfo.isCostPriceMove() && RecentCostHelp.isPrePeriodBill(billInfo, period) || isOnlyWriteExpRpt && keyExceptionState != null && keyExceptionState.get(billInfo.getString("FkeyID")) != null && !((Boolean)keyExceptionState.get(billInfo.getString("FkeyID"))).booleanValue() && billInfo.getIsDealdiffOK()) continue;
            String intComment = "";
            String outComment = "";
            String balanceCommnet = "";
            rptPs.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
            rptPs.setString(2, billInfo.getString("FBillTypeName"));
            rptPs.setString(3, billInfo.getString("FNumber"));
            rptPs.setString(4, billInfo.getString("timeSerialNumber"));
            if (accountType == 3 || accountType == 5) {
                rptPs.setTimestamp(5, billInfo.getTimestamp("FBizDate"));
            } else {
                rptPs.setTimestamp(5, new Timestamp(now.getTime()));
            }
            rptPs.setString(6, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            rptPs.setInt(7, billInfo.getInt("FCalculateKind"));
            if (1 != billInfo.getInt("FCalculateKind") || billInfo.getBoolean("isOutRetBillisIn")) {
                BigDecimal recentCost = billInfo.getRecentCost();
                int costScale = recentCost.scale();
                BigDecimal recentQty = billInfo.getRecentQty();
                int qtyScale = recentQty.scale();
                if (billInfo.getBoolean("isOutRetBillisIn")) {
                    recentCost = recentCost.multiply(CalculateUtil.ONE_MINUS).setScale(costScale);
                    recentQty = recentQty.multiply(CalculateUtil.ONE_MINUS).setScale(qtyScale);
                }
                intComment = RecentCostHelp.takeAmountQytPriceDesc(recentCost, recentQty, billInfo.getPrice()).toString();
                if (billInfo.isCommissionSaleOut() && (!params.getBoolean("isChkEntrust") || params.getInt("ACCOUNT_TYPE") != 3 && params.getInt("ACCOUNT_TYPE") != 5)) {
                    intComment = intComment + "\n" + RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost(), billInfo.getRecentQty(), billInfo.getPrice()).toString();
                }
            } else {
                outComment = RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost(), billInfo.getRecentQty(), billInfo.getPrice()).toString();
                if (billInfo.isCommissionSaleOut() && (!params.getBoolean("isChkEntrust") || params.getInt("ACCOUNT_TYPE") != 3 && params.getInt("ACCOUNT_TYPE") != 5)) {
                    outComment = outComment + "\n\r" + RecentCostHelp.takeAmountQytPriceDesc(billInfo.getRecentCost().negate(), billInfo.getRecentQty().negate(), billInfo.getPrice()).toString();
                }
                if ("2".equals(CALTYPE) && billInfo.getInt("handleTailDiff") == 1) {
                    outComment = outComment + "\n" + handleTailDiff;
                }
            }
            rptPs.setString(8, intComment);
            rptPs.setString(9, outComment);
            if (billInfo.getBoolean("isExceptionState")) {
                balanceCommnet = billInfo.getString("ERROR_MSG");
            } else if (accountType == 1 || accountType == 6) {
                buffer = RecentCostHelp.takeAmountQytPriceDesc(billInfo.getBigDecimal("MoveAvgCost"), billInfo.getBigDecimal("MoveAvgQty"), billInfo.getBigDecimal("MoveAvgPrice"));
                balanceCommnet = buffer.toString();
            }
            rptPs.setString(10, balanceCommnet);
            rptPs.setString(11, billInfo.getString("FMaterialID"));
            rptPs.setString(12, billInfo.getString("FCompanyOrgUnitID"));
            rptPs.setString(13, billInfo.getString("FStorageOrgUnitID"));
            rptPs.setString(14, billInfo.getString("FWarehouseID"));
            rptPs.setInt(15, period.getPeriodYear());
            rptPs.setInt(16, period.getPeriodNumber());
            rptPs.setString(17, ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString());
            rptPs.setInt(18, accountType);
            int n = successFlag = billInfo.getBoolean("isExceptionState") ? 0 : 1;
            if (i != rptList.size() - 1 || successFlag == 0) {
                // empty if block
            }
            rptPs.setInt(19, successFlag);
            if (accountType == 5) {
                rptPs.setString(20, billInfo.getString("FLot"));
                rptPs.setString(21, billInfo.getString("FAssistPropertyID"));
                rptPs.setString(22, billInfo.getString("FProjectID"));
                rptPs.setString(23, billInfo.getString("FTrackNumberID"));
            } else {
                rptPs.setString(20, "");
                rptPs.setString(21, "");
                rptPs.setString(22, "");
                rptPs.setString(23, "");
            }
            rptPs.setString(24, fparentID);
            if (1 == billInfo.getInt("FCalculateKind")) {
                rptPs.setString(25, billInfo.getPriceSource() != null ? billInfo.getPriceSource().getValue() : "");
            } else {
                rptPs.setString(25, "");
            }
            rptPs.addBatch();
            if (billInfo.getIsDealdiffOK()) continue;
            diffAdjustFail = billInfo.getString("FNumber") + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalRptResource", (String)"diffAdjustFail", (Context)ctx);
            rptPs.setString(1, BOSUuid.create((BOSObjectType)bosType).toString());
            rptPs.setString(3, diffAdjustFail);
            if (accountType == 3 || accountType == 5) {
                rptPs.setTimestamp(5, new Timestamp(billInfo.getTimestamp("FBizDate").getTime() + 1000L));
            } else {
                rptPs.setTimestamp(5, new Timestamp(now.getTime() + 1000L));
            }
            rptPs.setString(8, "");
            rptPs.setString(10, diffAdjustFailTips);
            rptPs.setInt(19, 0);
            rptPs.addBatch();
        }
    }

    protected void handleOtherDataForExpBillQuery(Context ctx, SysTempTableHelper sysTempTableHelper, CalculateParams params, PeriodInfo periodInfo, String tempTableName) throws BOSException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String materialRecordId = null;
        sysTempTableHelper.execute(this.getInsertWriteoffRecordSql(this.issueTableArray[0][1], this.issueTableArray[0][0], periodInfo, params, tempTableName));
        String wirteoffTmpTable = params.getString("T_Temp_WriteOffTable");
        sysTempTableHelper.analyzeTable(wirteoffTmpTable);
        sysTempTableHelper.execute(this.updateWriteOffRecordPriceSQL(this.issueTableArray[0][1], this.issueTableArray[0][0], materialRecordId, periodInfo, tempTableName, params, Local_Currency_Presision));
        sysTempTableHelper.execute(this.updateWriteOffRecordMantissaSQL(this.issueTableArray[0][1], this.issueTableArray[0][0], materialRecordId, periodInfo, tempTableName, params));
        long lstart = 0L;
        long lstop = 0L;
        this.logger.info((Object)"########### updateWriteOffRecordMantissaNextSQL start ##############  ");
        lstart = System.currentTimeMillis();
        sysTempTableHelper.execute(this.updateWriteOffRecordMantissaNextSQL(this.issueTableArray[0][1], this.issueTableArray[0][0], materialRecordId, periodInfo, tempTableName, params));
        lstop = System.currentTimeMillis();
        this.logger.info((Object)("########### updateWriteOffRecordMantissaNextSQL end : " + (lstop - lstart)));
    }

    protected void handleOtherData(Context ctx, SysTempTableHelper sysTempTableHelper, CalculateParams params, PeriodInfo periodInfo, String tempTableName, String strCalType) throws BOSException, SQLException {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String materialRecordId = null;
        if (params.getBoolean("isWriteCostComputePriceSource")) {
            this.processComputePriceRpt(sysTempTableHelper, params, strCalType);
        }
        LowTimer tt = new LowTimer();
        sysTempTableHelper.execute(this.getInsertWriteoffRecordSql(this.issueTableArray[0][1], this.issueTableArray[0][0], periodInfo, params, tempTableName));
        String wirteoffTmpTable = params.getString("T_Temp_WriteOffTable");
        sysTempTableHelper.analyzeTable(wirteoffTmpTable);
        this.logger.info((Object)("\u63d0\u53d6\u6838\u9500\u8bb0\u5f55\u6570\u636e\uff1a" + tt.msValue()));
        tt.reset();
        sysTempTableHelper.execute(this.updateWriteOffRecordPriceSQL(this.issueTableArray[0][1], this.issueTableArray[0][0], materialRecordId, periodInfo, tempTableName, params, Local_Currency_Presision));
        this.logger.info((Object)("\u6838\u9500\u8bb0\u5f55\u7684\u91d1\u989d\u5904\u7406: " + tt.msValue()));
        tt.reset();
        sysTempTableHelper.execute(this.updateWriteOffRecordMantissaSQL(this.issueTableArray[0][1], this.issueTableArray[0][0], materialRecordId, periodInfo, tempTableName, params));
        long lstart = 0L;
        long lstop = 0L;
        this.logger.info((Object)"########### updateWriteOffRecordMantissaNextSQL start ##############  ");
        lstart = System.currentTimeMillis();
        sysTempTableHelper.execute(this.updateWriteOffRecordMantissaNextSQL(this.issueTableArray[0][1], this.issueTableArray[0][0], materialRecordId, periodInfo, tempTableName, params));
        lstop = System.currentTimeMillis();
        this.logger.info((Object)("########### updateWriteOffRecordMantissaNextSQL end : " + (lstop - lstart)));
        this.logger.info((Object)("\u5168\u90e8\u6838\u9500\u5b8c\u5355\u636e\u5c3e\u5dee\u5904\u7406: " + tt.msValue()));
        tt.reset();
        sysTempTableHelper.execute(this.getTempDataBillSQL(ctx, params));
        sysTempTableHelper.execute(this.handleReqBill_CMPJUMP(params));
        this.logger.info((Object)("\u8de8\u8d22\u52a1\u7ec4\u7ec7\u9886\u6599\u6839\u636e\u91c7\u8d2d\u5165\u5e93\u5355\u53cd\u7b97\u9886\u6599\u51fa\u5e93\u6210\u672c: " + tt.msValue()));
        tt.reset();
        sysTempTableHelper.execute(this.handleReqBill_STOJUMP(params));
        this.logger.info((Object)("\u8de8\u5e93\u5b58\u7ec4\u7ec7\u9886\u6599(\u5f02\u4ef7)\u6839\u636e\u8c03\u62e8\u5165\u5e93\u5355\u53cd\u7b97\u9886\u6599\u51fa\u5e93\u6210\u672c: " + tt.msValue()));
        tt.reset();
        this.handleDevWriteOffRecord(ctx, sysTempTableHelper, tempTableName, periodInfo, params);
        this.logger.info((Object)("\u8ba1\u7b97\u59d4\u5916\u6838\u9500\u8bb0\u5f55: " + tt.msValue()));
        tt.reset();
        this.handleMovLocBill(ctx, params, sysTempTableHelper);
        this.logger.info((Object)("\u66f4\u65b0\u672a\u53d6\u5230\u5355\u4ef7\u7684\u5e93\u4f4d\u79fb\u52a8\u5355\u6210\u672c: " + tt.msValue()));
        sysTempTableHelper.releaseTempTable(params.getString("costMoveMatTbl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMovLocBill(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException, SQLException {
        if (!params.getBoolean("isCalMovLocBill") || this.updateMovLocList.size() == 0) {
            return;
        }
        PreparedStatement ps = null;
        String tempTable = null;
        String maxBizDateTable = null;
        String newPriceTable = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Create table tempTable (").append("\r\n");
            sql.append("FmaterialId VARCHAR(44),").append("\r\n");
            sql.append("FcompanyOrgUnitID VARCHAR(44),").append("\r\n");
            sql.append("FstorageOrgUnitID VARCHAR(44),").append("\r\n");
            sql.append("FwareHouseID VARCHAR(44),").append("\r\n");
            sql.append("FLot VARCHAR(44),").append("\r\n");
            sql.append("FAssistPropertyID VARCHAR(44),").append("\r\n");
            sql.append("FProjectID VARCHAR(44),").append("\r\n");
            sql.append("FTrackNumberID VARCHAR(44))").append("\r\n");
            tempTable = sysTempTableHelper.createTempTable(ctx, sql.toString());
            sql.setLength(0);
            sql.append("Insert Into ").append(tempTable).append(" ( ");
            sql.append(" FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID");
            sql.append(",FLOT,FAssistPropertyID,FProjectID,FTrackNumberID ) ");
            sql.append(" VALUES(?,?,?,?,?,?,?,?)");
            Connection conn = sysTempTableHelper.getConn();
            ps = conn.prepareStatement(sql.toString());
            HashMap map = null;
            Iterator<HashMap> iterator = this.updateMovLocList.iterator();
            while (iterator.hasNext()) {
                HashMap obj;
                map = obj = iterator.next();
                ps.setString(1, (String)map.get("materialId"));
                ps.setString(2, (String)map.get("companyOrgUnitID"));
                ps.setString(3, (String)map.get("storageOrgUnitID"));
                ps.setString(4, (String)map.get("wareHouseID"));
                ps.setString(5, (String)map.get("Lot"));
                ps.setString(6, (String)map.get("AssistPropertyID"));
                ps.setString(7, (String)map.get("ProjectID"));
                ps.setString(8, (String)map.get("TrackNumberID"));
                ps.addBatch();
            }
            ps.executeBatch();
            params.setString("tempTable", tempTable);
            InvBillPriceCalculate invBillPriceCalculate = new InvBillPriceCalculate();
            invBillPriceCalculate.setCalType(Integer.parseInt(params.getString("CALTYPE")));
            maxBizDateTable = invBillPriceCalculate.getNewPriceData(ctx, params, this.currPeriod, CalculateKindEnum.OUTPUT_WAREHOUSE);
            newPriceTable = invBillPriceCalculate.getTheNewPriceTmpTable(ctx, maxBizDateTable);
            int currencyPrecision = params.getInt("Local_Currency_Presision");
            PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
            String companyOrgID = params.getString("COMPANY_ID");
            StringBuffer updateSql = new StringBuffer();
            updateSql.append("UPDATE T_IM_MOVELOCATIONBILLENTRY T SET (FPRICE,FAMOUNT) = (SELECT ");
            updateSql.append(" Round(ROUND(ENTRY.FBASEQTY * TMP.FBaseUnitActualCost,").append(currencyPrecision).append(")/ENTRY.FQTY,MAT.FPRICEPRECISION),");
            updateSql.append(" ROUND(ENTRY.FBASEQTY * TMP.FBaseUnitActualCost,").append(currencyPrecision).append(")");
            updateSql.append(" FROM T_IM_MOVELOCATIONBILLENTRY ENTRY ");
            updateSql.append(" INNER JOIN T_IM_MOVELOCATIONBILL BILL ON BILL.FID = ENTRY.FPARENTID ");
            updateSql.append(" INNER JOIN t_bd_material MAT ON MAT.FID = ENTRY.FMATERIALID ");
            updateSql.append(" INNER JOIN t_bd_materialCompanyInfo MC ON MC.FMATERIALID = ENTRY.FMATERIALID ");
            updateSql.append(" \t\tAND MC.FCOMPANYID = ENTRY.FCOMPANYORGUNITID ");
            updateSql.append(" INNER JOIN ").append("\n");
            updateSql.append(newPriceTable);
            updateSql.append(" TMP ON TMP.FMATERIALID = ENTRY.FMATERIALID ");
            if (!params.getString("CALTYPE").equals("0")) {
                updateSql.append("  AND TMP.FSTORAGEORGUNITID = ENTRY.FSTORAGEORGUNITID ");
            }
            if (params.getString("CALTYPE").equals("2")) {
                updateSql.append("  AND TMP.FWAREHOUSEID = ENTRY.FWAREHOUSEID ");
            }
            updateSql.append("  AND (CASE WHEN MC.FISLOT = 0 THEN 1 ");
            updateSql.append("       WHEN MC.FISLOT = 1 AND ISNULL(TMP.FLot, N'null') = ISNULL(ENTRY.FLot, N'null') THEN 1 ");
            updateSql.append("       ELSE 0 END) = 1 ");
            updateSql.append("  AND (CASE WHEN MC.FISASSISTPROPERTY = 0 THEN 1 ");
            updateSql.append("\t\tWHEN MC.FISASSISTPROPERTY = 1 AND ISNULL(TMP.FAssistPropertyID, 'null') = ISNULL(ENTRY.FASSISTPROPERTYID, 'null') THEN 1 ");
            updateSql.append("\t\tELSE 0 END) = 1 ");
            updateSql.append("  AND (CASE WHEN MC.FISPROJECT = 0 THEN 1");
            updateSql.append(" \t\tWHEN MC.FISPROJECT = 1 AND ISNULL(TMP.FProjectID, 'null') = ISNULL(ENTRY.FPROJECTID, 'null') THEN 1 ");
            updateSql.append("      ELSE 0 END) = 1 ");
            updateSql.append("  AND (CASE WHEN MC.FISTRACKNUMBER = 0 THEN 1 ");
            updateSql.append("      WHEN MC.FISTRACKNUMBER = 1 AND ISNULL(TMP.FTrackNumberID, 'null') = ISNULL(ENTRY.FTRACKNUMBERID, 'null') THEN 1 ");
            updateSql.append("      ELSE 0 END) = 1 ");
            updateSql.append(" WHERE BILL.FBASESTATUS = 4 ");
            updateSql.append(" AND ENTRY.FCOMPANYORGUNITID ='").append(companyOrgID).append("'");
            updateSql.append(" AND ENTRY.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            updateSql.append(" AND ENTRY.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            updateSql.append(" AND BILL.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            updateSql.append(" AND BILL.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            updateSql.append(" AND T.FID = ENTRY.FID )");
            sysTempTableHelper.execute(updateSql.toString());
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps);
            sysTempTableHelper.releaseTempTable(maxBizDateTable);
            sysTempTableHelper.releaseTempTable(newPriceTable);
            sysTempTableHelper.releaseTempTable(tempTable);
            this.updateMovLocList.clear();
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps);
        sysTempTableHelper.releaseTempTable(maxBizDateTable);
        sysTempTableHelper.releaseTempTable(newPriceTable);
        sysTempTableHelper.releaseTempTable(tempTable);
        this.updateMovLocList.clear();
    }

    protected void costBillForEntrust(Context ctx, CalculateParams params, String strCalType, SysTempTableHelper sysTempTableHelper) throws BOSException, SQLException {
    }

    private void processComputePriceRpt(SysTempTableHelper sysTempTableHelper, CalculateParams params, String strCalType) throws BOSException {
        String orgIds;
        String costMaterialRange = null;
        String materialFrom = null;
        String materialTo = null;
        String companyOrgID = null;
        Set storageOrgBegs = null;
        Set wareHouseIds = null;
        PeriodInfo periodInfo = null;
        if (params != null) {
            costMaterialRange = params.getString("CALCULATEMATERIALRANGE");
            materialFrom = params.getString("MATERIAL_FROM");
            materialTo = params.getString("MATERIAL_TO");
            companyOrgID = params.getString("COMPANY_ID");
            storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
            wareHouseIds = (Set)params.getObject("WAREHOUSEID");
            periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert into T_CL_CostComputePriceReport (");
        sql.append("FPeriod ,FYear ,FBillName ,FBillNumber ,FIncome ,FPayout ,FSettleAccounts ,").append("\t\n");
        sql.append("FWarehouseID ,FStorageOrgUnitID ,FMaterialID ,FCompanyOrgUnitID ,FCalculateKind ,").append("\t\n");
        sql.append("FAccountType ,FTimeSerialNumber,FLot,FAssistPropertyID,FProjectID,FTrackNumberID,").append("\t\n");
        sql.append("FCreatorID ,FCreateTime ,FLastUpdateUserID ,FLastUpdateTime ,FControlUnitID ,FID,").append("\t\n");
        sql.append("FParentID ,FpriceSource,FState ").append("\t\n");
        sql.append(")").append("\t\n");
        sql.append("  Select A.FPeriod ,A.FYear ,A.FBillName ,A.FBillNumber ,A.FIncome ,A.FPayout ,A.FSettleAccounts ,").append("\t\n");
        sql.append("A.FWarehouseID ,A.FStorageOrgUnitID ,A.FMaterialID ,A.FCompanyOrgUnitID ,A.FCalculateKind ,").append("\t\n");
        sql.append("A.FAccountType ,A.FTimeSerialNumber,A.FLot,A.FAssistPropertyID,A.FProjectID,A.FTrackNumberID,").append("\t\n");
        sql.append("A.FCreatorID ,A.FCreateTime ,A.FLastUpdateUserID ,A.FLastUpdateTime ,A.FControlUnitID ,A.FID,").append("\t\n");
        sql.append("A.FParentID ,A.FpriceSource,A.FISSUSCCESSED ").append("\t\n");
        sql.append(" from T_CL_CostComputeReport A").append("\t\n");
        if (!StringUtil.isEmpty((String)materialFrom) || !StringUtil.isEmpty((String)materialTo)) {
            sql.append("  Inner Join T_BD_Material B on A.FMaterialId = B.FID").append("\t\n");
        }
        sql.append("  Inner Join T_BD_MaterialCompanyInfo C on C.FMaterialId = A.FMaterialId ").append("\t\n");
        sql.append("  and C.FCompanyId = A.FCompanyOrgUnitId ").append("\t\n");
        if (params.getBoolean("IsOtherInvkCostCalculate") && params.getString("ThirdPartyMaterialTableName") != null) {
            String tmpTable = params.getString("ThirdPartyMaterialTableName");
            sql.append(" INNER JOIN ").append(tmpTable).append(" Temp ON A.FMaterialId= Temp.FMATERIALID ");
        }
        sql.append("  Where ").append("A.FCompanyOrgUnitId = '").append(companyOrgID).append("'").append("\t\n");
        sql.append(" AND ").append("C.FCompanyId = '").append(companyOrgID).append("'").append("\t\n");
        if (periodInfo != null) {
            sql.append(" and A.FYear = ").append(periodInfo.getPeriodYear());
            sql.append(" and A.FPeriod = ").append(periodInfo.getPeriodNumber());
        }
        if ("rawMaterailCostCal".equalsIgnoreCase(costMaterialRange)) {
            sql.append(" AND C.FCalculateType = ").append(0).append("\t\n");
        } else if ("fishedGoodsCostCal".equalsIgnoreCase(costMaterialRange)) {
            sql.append(" AND C.FCalculateType <> ").append(0).append("\t\n");
        }
        if (!StringUtil.isEmpty((String)materialFrom)) {
            sql.append(" AND B.FNumber >= N'").append(materialFrom).append("'").append("\t\n");
        }
        if (!StringUtil.isEmpty((String)materialTo)) {
            sql.append(" AND B.FNumber <= N'").append(materialTo).append("'").append("\t\n");
        }
        if ("2".equals(strCalType)) {
            sql.append("AND ( 1=1 ");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sql.append(" AND ").append("A.FStorageOrgUnitID in ").append(orgIds).append("\t\n");
            }
            if (wareHouseIds != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                sql.append(" AND ").append("A.FWarehouseID in ").append(warehouseIds).append("\t\n");
            }
            if (params.getString("costMoveMatTbl") != null) {
                sql.append(" OR A.FMaterialId in (select fid from ").append(params.getString("costMoveMatTbl")).append(")");
            }
            sql.append(")");
        } else if ("1".equals(strCalType)) {
            sql.append("AND ( 1=1 ");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sql.append(" AND ").append("A.FStorageOrgUnitID in ").append(orgIds).append("\t\n");
            }
            if (params.getString("costMoveMatTbl") != null) {
                sql.append(" OR A.FMaterialId in (select fid from ").append(params.getString("costMoveMatTbl")).append(")");
            }
            sql.append(")");
        }
        sql.append(" AND A.FAccountType = ").append(this.takeMaterialAccountType()[0].getValue());
        sysTempTableHelper.execute(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDevWriteOffRecord(Context ctx, SysTempTableHelper sysTempTableHelper, String tempTableName, PeriodInfo periodInfo, CalculateParams params) throws BOSException {
        Set storageOrgBegs = (Set)params.getObject("STORAGEORGUNITID");
        Set wareHouseIds = (Set)params.getObject("WAREHOUSEID");
        String materialFrom = params.getString("MATERIAL_FROM");
        String materialTo = params.getString("MATERIAL_TO");
        String[][] fields = new String[][]{{"fid", "varchar(44) not null"}};
        String idTbl = sysTempTableHelper.createTempTable(ctx, fields);
        sysTempTableHelper.createTempTableIndex(idTbl, "fid", true, false);
        try {
            StringBuffer sql = new StringBuffer(500);
            sql.append("INSERT INTO ").append(idTbl).append(" SELECT distinct r.FBILLENTRYID FROM T_CL_DEVOLVEWRITEOFFRECORD r").append(" \r\n");
            sql.append("INNER JOIN T_CL_DEVOLVEWRITEOFFGROUP g on g.FID = r.FPARENTID").append(" \r\n");
            sql.append("INNER JOIN T_IM_MATERIALREQBILLENTRY entry on entry.FID = r.FBILLENTRYID ").append(" \r\n");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                sql.append("INNER JOIN T_ORG_STORAGE s on s.FID = entry.FSTORAGEORGUNITID ").append(" \r\n");
            }
            if (wareHouseIds != null && wareHouseIds.size() > 0) {
                sql.append("INNER JOIN T_DB_WAREHOUSE w on w.FID = entry.FWAREHOUSEID ").append(" \r\n");
            }
            if (!StringUtil.isEmpty((String)materialFrom) || !StringUtil.isEmpty((String)materialTo)) {
                sql.append("INNER JOIN T_BD_MATERIAL m on m.fid = r.FMATERIALID").append(" \r\n");
            }
            sql.append("where (g.FWRITEOFFYEAR * 100 + g.FWRITEOFFPERIOD) = '").append(periodInfo.getNumber()).append("'").append(" \r\n");
            if (storageOrgBegs != null && storageOrgBegs.size() > 0) {
                String orgIds = CalculateUtil.getSqlIn(storageOrgBegs);
                sql.append(" AND entry.FSTORAGEORGUNITID in ").append(orgIds).append(" \r\n");
            }
            if (wareHouseIds != null && wareHouseIds.size() > 0) {
                String warehouseIds = CalculateUtil.getSqlIn(wareHouseIds);
                sql.append(" AND entry.FWAREHOUSEID in ").append(warehouseIds).append(" \r\n");
            }
            if (!StringUtil.isEmpty((String)materialFrom)) {
                sql.append(" AND M.FNUMBER >= '").append(materialFrom).append("'").append(" \r\n");
            }
            if (!StringUtil.isEmpty((String)materialTo)) {
                sql.append(" AND M.FNUMBER <= '").append(materialTo).append("'").append(" \r\n");
            }
            sysTempTableHelper.execute(sql.toString());
            WriteOffHelp.updDevWritRecordOnMatreqCostChangeCurrPeriod(ctx, idTbl, periodInfo.getNumber());
        }
        finally {
            sysTempTableHelper.releaseTempTable(idTbl);
        }
    }

    protected String getTempDataBillSQL(Context ctx, CalculateParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        String companyOrgID = params.getString("COMPANY_ID");
        if (periodInfo != null) {
            String reqTempTable = DBUtil.createTempTable(ctx, "reqTempTable", this.getReqInfoTableField());
            sql.append("insert into " + reqTempTable + "(FEntryId,FMaterialId,FUnitActualCost,FQty,FBaseQty,FActualCost)");
            sql.append(" select reqentry.fid,reqentry.FMaterialId,purentry.FUnitActualCost,");
            sql.append(" sum(purentry.FQty) ,sum(purentry.FBASEQTY),sum(purentry.FActualCost) ");
            sql.append(" from T_IM_MaterialReqBill reqbill inner join T_IM_MaterialReqBillEntry reqentry on reqbill.fid= reqentry.fparentid ");
            sql.append(" inner join t_im_purinwarehsentry purentry on purentry.FPurOrderEntryId = reqentry.fid  ");
            sql.append(" inner join t_im_purinwarehsbill purbill on purbill.fid = purentry.fparentid   ");
            sql.append(" where reqbill.FBIZTYPEID = '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ");
            sql.append(" AND purbill.FBIZTYPEID = '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ");
            sql.append(" AND reqentry.FCompanyOrgUnitId = '").append(companyOrgID).append("' ");
            sql.append(" AND reqentry.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqentry.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqbill.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FFiVouchered = 0");
            sql.append(" AND reqbill.FBASESTATUS = 4");
            sql.append(" Group by reqentry.fid,reqentry.FMaterialId ,purentry.FUnitActualCost ");
            params.setString("reqTempTable", reqTempTable);
        }
        return sql.toString();
    }

    private String[][] getReqInfoTableField() {
        String[][] fields = new String[][]{{"FEntryId", "varchar(44)"}, {"FMaterialId", "varchar(44)"}, {"FQty", "Numeric(21, 8)"}, {"FBaseQty", "Numeric(21, 8)"}, {"FUnitActualCost", "Numeric(28, 16)"}, {"FActualCost", "Numeric(21, 8)"}};
        return fields;
    }

    protected String handleReqBill_CMPJUMP(CalculateParams params) {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        String companyOrgID = params.getString("COMPANY_ID");
        String tempTable = params.getString("reqTempTable");
        if (periodInfo != null && tempTable != null) {
            sql.append("update T_IM_MaterialReqBillEntry t set (FActualCost,FUnitActualCost,FBaseUnitActualCost) = ");
            sql.append(" (select ");
            sql.append(" case when reqentry.fqty = temp.fqty then  temp.FActualCost else round(reqentry.fqty * temp.FUnitActualCost,").append(Local_Currency_Presision).append(") end , ");
            sql.append(" temp.FUnitActualCost as FUnitActualCost");
            sql.append(" ,(case when temp.FBASEQTY = 0 then 0 else round(TO_DECIMAL( temp.FActualCost/temp.FBASEQTY,21,8),material.FPricePrecision ) end) as FBaseUnitActualCost ");
            sql.append(" from T_IM_MaterialReqBill reqbill inner join T_IM_MaterialReqBillEntry reqentry on reqbill.fid= reqentry.fparentid ");
            sql.append(" inner join  " + tempTable + " as temp on reqentry.fid = temp.FEntryId");
            sql.append(" inner join t_bd_material material on temp.fmaterialid = material.fid ");
            sql.append(" where reqbill.FBIZTYPEID = '").append("nhvcdx82RzuTw48FSlV79CQHQ1w=").append("' ");
            sql.append(" AND reqentry.FCompanyOrgUnitId = '").append(companyOrgID).append("' ");
            sql.append(" AND reqentry.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqentry.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqbill.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FFiVouchered = 0");
            sql.append(" AND reqbill.FBASESTATUS = 4");
            sql.append(" AND t.fid = reqentry.fid)");
        }
        return sql.toString();
    }

    protected String handleReqBill_STOJUMP(CalculateParams params) {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        StringBuffer sql = new StringBuffer();
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 23:59:59.995");
        String companyOrgID = params.getString("COMPANY_ID");
        if (periodInfo != null) {
            sql.append("update T_IM_MaterialReqBillEntry t set (FActualCost,FUnitActualCost,FBaseUnitActualCost) = ");
            sql.append("(select ");
            sql.append(" case when reqentry.fqty = movInEntry.fqty then  movInEntry.FActualCost else round(reqentry.fqty * movInEntry.FUnitActualCost,").append(Local_Currency_Presision).append(") end , ");
            sql.append(" movInEntry.FUnitActualCost as FUnitActualCost");
            sql.append(" ,(case when movInEntry.FBASEQTY = 0 then 0 else round(TO_DECIMAL( movInEntry.FActualCost/movInEntry.FBASEQTY,21,8),material.FPricePrecision ) end ) as FBaseUnitActualCost ");
            sql.append(" from T_IM_MaterialReqBill reqbill inner join T_IM_MaterialReqBillEntry reqentry on reqbill.fid= reqentry.fparentid ");
            sql.append(" inner join T_IM_MoveInWarehsBillEntry movInEntry on movInEntry.FSOURCEBILLENTRYID = reqentry.fid  ");
            sql.append(" inner join t_bd_material material on reqentry.fmaterialid = material.fid ");
            sql.append(" where reqbill.FBIZTYPEID = '").append("i6DbShN4SLaNlFkX90UXOiQHQ1w=").append("' ");
            sql.append(" AND reqentry.FCompanyOrgUnitId = '").append(companyOrgID).append("' ");
            sql.append(" AND reqentry.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqentry.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FBizDate >= TO_DATE('").append(format.format((Object)periodInfo.getBeginDate())).append("')");
            sql.append(" AND reqbill.FBizDate <= TO_DATE('").append(sdf.format((Object)periodInfo.getEndDate())).append("')");
            sql.append(" AND reqbill.FFiVouchered = 0");
            sql.append(" AND reqbill.FBASESTATUS = 4");
            sql.append(" AND t.fid = reqentry.fid)");
        }
        return sql.toString();
    }

    protected void handleBlueBillAndRedBillRel(List redList, RecentCostInfo info) {
        RecentCostInfo billInfo = null;
        for (int i = 0; i < redList.size(); ++i) {
            billInfo = (RecentCostInfo)redList.get(i);
            if (!billInfo.isRedBill() || !info.getFBillEntryId().equals(billInfo.getFSourceBillEntryID()) && !info.getFBillEntryId().equals(billInfo.getFBlueBillEntryID())) continue;
            info.addRedBillList(billInfo);
        }
        ArrayList redBillList = info.getRedBillList();
        if (redBillList != null && redBillList.size() > 0) {
            this.handleSrcBill(redBillList, info);
        }
    }

    protected void handleSrcBill(List srcBillList, RecentCostInfo info) {
        BigDecimal totalAmount = CalculateUtil.ZERO;
        BigDecimal totalQty = CalculateUtil.ZERO;
        RecentCostInfo tmpInfo = null;
        RecentCostInfo lastInfo = null;
        boolean isAdjSeq = false;
        for (int i = 0; srcBillList != null && i < srcBillList.size(); ++i) {
            tmpInfo = (RecentCostInfo)srcBillList.get(i);
            if (!tmpInfo.isDealComplete()) {
                lastInfo = tmpInfo;
            }
            totalQty = totalQty.add(tmpInfo.getRecentQty().abs());
            if (i == srcBillList.size() - 1 && totalQty.compareTo(info.getRecentQty()) == 0) {
                if (tmpInfo.isDealComplete()) {
                    tmpInfo = lastInfo;
                    isAdjSeq = true;
                }
                if (tmpInfo == null) continue;
                if (tmpInfo.isRedBill()) {
                    tmpInfo.setRecentCost(info.getRecentCost().subtract(totalAmount).negate());
                } else if (isAdjSeq) {
                    if ((totalAmount = totalAmount.add(((RecentCostInfo)srcBillList.get(i)).getRecentCost().abs())).compareTo(info.getRecentCost()) != 0) {
                        tmpInfo.setRecentCost(tmpInfo.getRecentCost().add(info.getRecentCost().subtract(totalAmount)));
                    }
                } else {
                    tmpInfo.setRecentCost(info.getRecentCost().subtract(totalAmount));
                }
                tmpInfo.setNeedUpdate(true);
                if (!tmpInfo.isDealComplete()) {
                    tmpInfo.setPriceSource(PriceSourEnum.sourBillPrice);
                }
                tmpInfo.setPrice(info.getPrice());
                break;
            }
            if (!tmpInfo.isDealComplete()) {
                tmpInfo.setRecentCost(tmpInfo.getRecentQty().multiply(info.getPrice()).setScale(tmpInfo.getInt("FLocalCurrencyPrecision"), 4));
                tmpInfo.setPrice(info.getPrice());
                if (!tmpInfo.isDealComplete()) {
                    tmpInfo.setPriceSource(PriceSourEnum.sourBillPrice);
                }
                tmpInfo.setNeedUpdate(true);
            }
            tmpInfo.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
            totalAmount = totalAmount.add(tmpInfo.getRecentCost().abs());
        }
    }

    protected Map<String, String> getRedAndBlueBillEntryIdMap(Context ctx, CalculateParams params, String tempTable, RptRowSet rsMaterial) throws BOSException {
        if (!params.getBoolean("isGetBlueIssueCost")) {
            return null;
        }
        HashMap<String, String> redAndBlueIdMap = new HashMap<String, String>();
        String materialId = rsMaterial.getString("FMaterialID");
        String couId = rsMaterial.getString("fcompanyorgunitid");
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select b.fbillentryid as redEntryId, blueEn.fid as blueEntryId \n");
        selectSql.append("from ").append(tempTable).append(" as b \n");
        selectSql.append("inner join T_SD_SALERETURNSENTRY sen on b.fsourcebillentryid = sen.fid \n");
        selectSql.append("inner join T_IM_SALEISSUEENTRY blueEn on blueEn.fid = sen.FSOURCEBILLENTRYID \n");
        selectSql.append("where b.fmaterialid = '" + materialId + "' and b.fcompanyorgunitid = '" + couId + "' \n");
        selectSql.append("AND b.fsourcebilltypeid = '50957179-0105-1000-e008-8152c0a812fd463ED552' \n");
        selectSql.append("AND b.fbilltypeid = '50957179-0105-1000-e000-015bc0a812fd463ED552' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        try {
            while (rs.next()) {
                redAndBlueIdMap.put(rs.getString("redEntryId"), rs.getString("blueEntryId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return redAndBlueIdMap;
    }

    protected BigDecimal getPrice(Context ctx, CalculateParams params) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String companyId = params.getString("COMPANY_ID");
        String materialId = params.getString("CurrMaterialId");
        String[] calModel = null;
        if (5 == params.getInt("ACCOUNT_TYPE")) {
            calModel = new String[]{params.getString("FLOT"), params.getString("FAssistPropertyID"), params.getString("FProjectID"), params.getString("FTrackNumberID")};
        }
        if (this.priceType == 0) {
            newPrice = this.getNewInOrOutPrice(ctx, periodInfo, companyId, materialId, calModel, true, false, params, false);
        } else if (this.priceType == 1) {
            newPrice = this.getNewInOrOutPrice(ctx, periodInfo, companyId, materialId, calModel, true, true, params, false);
        } else if (this.priceType == 2) {
            newPrice = this.getMaterialStandardCost(ctx, companyId, materialId);
        } else if (this.priceType == 4) {
            newPrice = this.getNewInOrOutPrice(ctx, periodInfo, companyId, materialId, calModel, true, false, params, true);
        }
        return newPrice;
    }

    protected BigDecimal getNewInOrOutPrice(Context ctx, PeriodInfo periodInfo, String companyId, String materialId, String[] calModel, boolean includeBeforePeriod, boolean isInPrice, CalculateParams params, boolean isSaleRe) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        if (companyId == null || materialId == null || periodInfo == null) {
            return newPrice;
        }
        newPrice = this.getNewInOrOutPriceSQL(periodInfo, companyId, materialId, calModel, includeBeforePeriod, isInPrice, params, isSaleRe, ctx);
        return newPrice;
    }

    protected BigDecimal getMaterialStandardCost(Context ctx, String companyId, String materialId) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        if (companyId == null || materialId == null) {
            return newPrice;
        }
        String getMaterialStandardCostSql = "select ISNULL(FStandardCost,0) as FStandardCost from T_BD_MaterialCompanyInfo where FMaterialid='" + materialId + "' and FCompanyid='" + companyId + "'";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getMaterialStandardCostSql);
        try {
            if (rs.next()) {
                newPrice = rs.getBigDecimal("FStandardCost");
            }
            return newPrice;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doJumpOrgBills(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String tempTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getMatReqTempTableFields());
        sysTempTableHelper.createTempTableIndex(tempTableName, "FID", true, true);
        params.setBoolean("KEY_EXTEND_WHERE", true);
        try {
            String selectFields = "Entry.FSourceBillEntryID,Sum(Entry.FActualCost) as FActualCost,case when Sum(Entry.FQty) = 0 then 0 else  Round(TO_DECIMAL(Sum(Entry.FActualCost), 17, 4)/TO_DECIMAL(Sum(Entry.FQty), 21, 8), Max(Material.FPricePrecision)) end as FUnitActualCost";
            String billTypeNo = params.getString("BILLTYPE");
            this.setBillTypeNumber("106");
            String selectSQL = this.getOutWarehsBillSQL(periodInfo, strCalType, params, selectFields, INVENTORYBILL_TABLENAME[6]);
            this.setBillTypeNumber(billTypeNo);
            sql.append("Insert into ").append(tempTableName).append("(FID,FActualCost,FUnitActualCost)").append("\t\n");
            sql.append(selectSQL);
            sql.append(" Group by Entry.FSourceBillEntryID");
            sysTempTableHelper.execute(sql.toString());
            StringBuffer updateIssue = new StringBuffer();
            updateIssue.append("update T_IM_MaterialReqBillEntry as t10 ");
            updateIssue.append("set (FActualCost,FUnitActualCost) ");
            updateIssue.append("= ( ").append("\t\n");
            updateIssue.append("select t1.FActualCost,t1.FUnitActualCost ").append("\t\n");
            updateIssue.append("from ").append(tempTableName).append(" t1 ").append("\t\n");
            updateIssue.append("where t10.fid = t1.fid )");
            StringBuffer updateMoveIn = new StringBuffer();
            updateMoveIn.append("update T_IM_MoveInWarehsBillEntry as t10 ");
            updateMoveIn.append("set (FActualCost,FUnitActualCost) = ( ").append("\t\n");
            updateMoveIn.append("select t1.FActualCost,t1.FUnitActualCost ").append("\t\n");
            updateMoveIn.append("from ").append(tempTableName).append(" t1 ").append("\t\n");
            updateMoveIn.append("where t10.FSourceBillEntryID = t1.fid )");
            sysTempTableHelper.execute(new String[]{updateIssue.toString(), updateMoveIn.toString()});
        }
        finally {
            params.remove("KEY_EXTEND_WHERE");
            sysTempTableHelper.releaseTempTable(tempTableName);
        }
    }

    @Override
    protected StringBuffer getSQLWhereExtends(PeriodInfo periodInfo, CalculateParams params) {
        boolean needExtend = params.getBoolean("KEY_EXTEND_WHERE");
        StringBuffer extendWhere = new StringBuffer();
        if (needExtend) {
            extendWhere.append(" AND Bill.FBizTypeID = '").append("YJN9V65PSkutQxeUH6F72SQHQ1w=").append("'").append("\t\n");
        }
        return extendWhere;
    }

    protected void buildMatAttrChange(RecentCostInfo bill, HashMap matAttrChgMap) {
        String sourceEntryID = bill.getString("FSourceBillEntryID");
        MatAttrChangeVO vo = (MatAttrChangeVO)matAttrChgMap.get(sourceEntryID);
        if (vo == null) {
            vo = new MatAttrChangeVO(sourceEntryID);
        }
        if (bill.isOutBill()) {
            vo.addOutBill(bill);
        } else {
            vo.addInBill(bill);
        }
        matAttrChgMap.put(sourceEntryID, vo);
    }

    protected void calMatAttrChangeCost(Map matAttrChgMap) {
        for (Map.Entry entry : matAttrChgMap.entrySet()) {
            MatAttrChangeVO vo = (MatAttrChangeVO)entry.getValue();
            vo.calculateCost();
        }
    }

    protected void updateToPrePeriodCostMovePrice(HashMap prePeriodCostMoveMap, HashMap costMoveMap, List inBillNeddUpdated) throws CalculateException {
        if (prePeriodCostMoveMap == null || costMoveMap == null || inBillNeddUpdated == null) {
            return;
        }
        RecentCostInfo bill2 = null;
        RecentCostInfo costMoveObj = null;
        RecentCostInfo moveCostBill = null;
        for (RecentCostInfo bill2 : prePeriodCostMoveMap.values()) {
            if (bill2 == null) continue;
            this.synCostMovePriceBill(costMoveMap, bill2);
            if (this.takeMaterialAccountType()[0].equals((Object)AccountType.FIN_FOUT) || (costMoveObj = (RecentCostInfo)costMoveMap.get(bill2.getStockTransBillEntryID())) == null || costMoveObj.getMoveInbillList() == null) continue;
            ArrayList moveCostList = costMoveObj.getMoveInbillList();
            for (int j = 0; j < moveCostList.size(); ++j) {
                moveCostBill = (RecentCostInfo)moveCostList.get(j);
                if (moveCostBill.isDealComplete()) continue;
                inBillNeddUpdated.add(moveCostBill);
            }
        }
    }

    protected int getThreadPoolNum(Context ctx) throws BOSException, EASBizException {
        String key = "DEFAULT_THREADPOOL_NUM";
        try {
            String sql = "SELECT FValue From T_DT_DTTempParam WHERE FKey = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{key});
            if (rs.next()) {
                threadPoolNum = rs.getInt("FValue");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return threadPoolNum;
    }

    public Map getKeyExceptionState(HashMap balanceMap) {
        HashMap keyExceptionMap = new HashMap();
        Iterator iter = balanceMap.entrySet().iterator();
        BalanceCostInfo balInfo = null;
        RecentCostInfo billInfo = null;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getKey().equals("CostPriceMove__") || entry.getKey().equals("ALLINOUTLIST") || entry.getKey().equals("INBILLLIST") || entry.getKey().equals("OUTBILLLIST") || entry.getKey().equals("INBILLNEEDUPDATED") || entry.getKey().equals("costMoveCycle") || entry.getValue() instanceof HashMap) continue;
            balInfo = (BalanceCostInfo)((Object)entry.getValue());
            billInfo = balInfo.getReusltBillInfo();
            keyExceptionMap.put(entry.getKey(), billInfo.getBoolean("isExceptionState") || balInfo.getBoolean("isExceptionState"));
        }
        return keyExceptionMap;
    }

    public void updateMoveLocationBill(Context ctx, CalculateParams params, HashMap balanceMap, ArrayList keyList, String strCalType) throws BOSException, SQLException {
        String materialId = params.getString("CurrMaterialId");
        HashSet updateMoveLocMat = (HashSet)params.getObject("updateMoveLocMat");
        if (!params.getBoolean("isCalMovLocBill") || !updateMoveLocMat.contains(materialId)) {
            return;
        }
        BigDecimal price = BigDecimal.ZERO;
        StringBuffer sql = new StringBuffer();
        StringBuffer updateSql = new StringBuffer();
        ArrayList<String> totalUpdateSql = new ArrayList<String>();
        String fKey = null;
        BalanceCostInfo balanceCostInfo = null;
        RecentCostInfo resultInfo = null;
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String companyId = params.getString("COMPANY_ID");
        String storageOrgUnitID = null;
        String wareHouseID = null;
        int currencyPrecision = params.getInt("Local_Currency_Presision");
        BigDecimal minValueByScale = RecentCostHelp.getMinValueByScale(currencyPrecision, 1);
        int pricePercision = 6;
        String[] calModel = null;
        String getPrecisionSql = "select FPRICEPRECISION from t_bd_material where fid='" + materialId + "'";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getPrecisionSql);
        if (rs.next()) {
            pricePercision = rs.getInt("FPRICEPRECISION");
        }
        HashMap paramFromKey = null;
        for (int i = 0; i < keyList.size(); ++i) {
            fKey = keyList.get(i).toString();
            paramFromKey = this.getParamFromKey(fKey, strCalType, params);
            storageOrgUnitID = (String)paramFromKey.get("storageOrgUnitID");
            wareHouseID = (String)paramFromKey.get("wareHouseID");
            if (5 == params.getInt("ACCOUNT_TYPE")) {
                calModel = new String[]{(String)paramFromKey.get("LOT"), (String)paramFromKey.get("AssistPropertyID"), (String)paramFromKey.get("ProjectID"), (String)paramFromKey.get("TrackNumberID")};
            }
            if ((resultInfo = (balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey))).getReusltBillInfo()).getBoolean("isExceptionState") || resultInfo.getRecentQty().compareTo(BigDecimal.ZERO) > 0 && resultInfo.getRecentCost().compareTo(BigDecimal.ZERO) < 0) continue;
            if (resultInfo.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
                paramFromKey.put("materialId", materialId);
                this.updateMovLocList.add(paramFromKey);
                continue;
            }
            price = resultInfo.getRecentCost().divide(resultInfo.getRecentQty(), pricePercision, 4);
            sql.setLength(0);
            sql.append(this.getMoveLocationUpdateSql(periodInfo, companyId, materialId, currencyPrecision, minValueByScale, pricePercision, price));
            if ("1".equals(strCalType)) {
                sql.append(" and entry.FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
            } else if ("2".equals(strCalType)) {
                sql.append(" and entry.FSTORAGEORGUNITID = '").append(storageOrgUnitID).append("'");
                sql.append(" and entry.FWAREHOUSEID = '").append(wareHouseID).append("'");
            }
            if (5 == params.getInt("ACCOUNT_TYPE")) {
                if (calModel[0] != null && !"X".equals(calModel[0])) {
                    sql.append("  And entry.FLot = '").append(calModel[0]).append("'");
                }
                if (calModel[1] != null && !"X".equals(calModel[1])) {
                    sql.append("  And entry.FAssistPropertyID = '").append(calModel[1]).append("'");
                }
                if (calModel[2] != null && !"X".equals(calModel[2])) {
                    sql.append("  And entry.FProjectID = '").append(calModel[2]).append("'");
                }
                if (calModel[3] != null && !"X".equals(calModel[3])) {
                    sql.append("  And entry.FTrackNumberID = '").append(calModel[3]).append("'");
                }
            }
            sql.append(" )");
            totalUpdateSql.add(sql.toString());
            if (totalUpdateSql.size() <= 500) continue;
            DBUtil.execBatchSql(ctx, totalUpdateSql, true);
            totalUpdateSql.clear();
        }
        if (totalUpdateSql.size() > 0) {
            DBUtil.execBatchSql(ctx, totalUpdateSql, true);
        }
    }

    protected void getNeedUpdateMoveLocBillMaterial(SysTempTableHelper sysTempTableHelper, String materialTempTable, CalculateParams params, PeriodInfo periodInfo) throws BOSException, SQLException {
        if (!params.getBoolean("isCalMovLocBill")) {
            return;
        }
        HashSet<String> updateMoveLocMat = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select ENTRY.FMATERIALID AS FMATERIALID from T_IM_MOVELOCATIONBILLENTRY ENTRY ");
        sql.append(" INNER JOIN  T_IM_MOVELOCATIONBILL BILL on BILL.FID = ENTRY.FPARENTID ");
        sql.append(" WHERE BILL.FBaseStatus = ").append(4);
        sql.append(this.getSQLWherePeriod(null, periodInfo, false, false));
        sql.append(" AND ENTRY.FMATERIALID IN ( SELECT FMATERIALID FROM ").append(materialTempTable).append(" ) ");
        sql.append(" AND ENTRY.FCompanyOrgUnitID = '").append(params.getString("COMPANY_ID")).append("'");
        sql.append(" GROUP BY ENTRY.FMATERIALID");
        IRowSet rs = sysTempTableHelper.executeQuery(sql.toString());
        while (rs.next()) {
            updateMoveLocMat.add(rs.getString("FMATERIALID"));
        }
        params.setObject("updateMoveLocMat", updateMoveLocMat);
    }

    private String getMoveLocationUpdateSql(PeriodInfo periodInfo, String companyId, String materialId, int currencyPrecision, BigDecimal minValueByScale, int pricePercision, BigDecimal price) {
        StringBuffer updateSql = new StringBuffer();
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            updateSql.append("update T_IM_MOVELOCATIONBILLENTRY T set (FPRICE,FAMOUNT) = (select 0,0");
        } else {
            updateSql.append("update T_IM_MOVELOCATIONBILLENTRY T set (FPRICE,FAMOUNT) = (select ");
            updateSql.append(" case when ROUND(entry.FBASEQTY*").append(price.toPlainString()).append(",").append(currencyPrecision).append(") = 0 ");
            updateSql.append(" then Round(").append(minValueByScale).append("/entry.FQTY," + pricePercision + ")");
            updateSql.append(" else Round(ROUND(entry.FBASEQTY*").append(price.toPlainString()).append(",").append(currencyPrecision).append(")/entry.FQTY," + pricePercision + ") end as fprice, ");
            updateSql.append(" case when ROUND(entry.FBASEQTY*").append(price.toPlainString()).append(",").append(currencyPrecision).append(") = 0 ");
            updateSql.append(" then ").append(minValueByScale).append(" else ROUND(entry.FBASEQTY*").append(price.toPlainString()).append(",").append(currencyPrecision).append(") end as famount ");
        }
        updateSql.append(" from T_IM_MOVELOCATIONBILLENTRY entry inner join T_IM_MOVELOCATIONBILL bill on entry.FPARENTID = bill.FID ");
        updateSql.append(" where T.FID = entry.FID and bill.FBASESTATUS = 4 ");
        updateSql.append(" and bill.FYEAR =").append(periodInfo.getPeriodYear());
        updateSql.append(" and bill.FPERIOD =").append(periodInfo.getPeriodNumber());
        updateSql.append(" and entry.FMATERIALID ='").append(materialId).append("'");
        updateSql.append(" and entry.FCOMPANYORGUNITID ='").append(companyId).append("'");
        return updateSql.toString();
    }

    public HashMap getParamFromKey(String fKey, String strCalType, CalculateParams params) {
        HashMap<String, String> keyParam = new HashMap<String, String>();
        if (fKey.length() > 0) {
            String[] temp = fKey.split("\\_\\$\\$\\$\\$\\_");
            keyParam.put("companyOrgUnitID", temp[0]);
            if ("1".equals(strCalType)) {
                keyParam.put("storageOrgUnitID", temp[1]);
            } else if ("2".equals(strCalType)) {
                keyParam.put("storageOrgUnitID", temp[1]);
                keyParam.put("wareHouseID", temp[2]);
            }
            if (5 == params.getInt("ACCOUNT_TYPE")) {
                String key = "X";
                if (!key.equals(temp[temp.length - 4])) {
                    keyParam.put("Lot", temp[temp.length - 4]);
                }
                if (!key.equals(temp[temp.length - 3])) {
                    keyParam.put("AssistPropertyID", temp[temp.length - 3]);
                }
                if (!key.equals(temp[temp.length - 2])) {
                    keyParam.put("ProjectID", temp[temp.length - 2]);
                }
                if (!key.equals(temp[temp.length - 1])) {
                    keyParam.put("TrackNumberID", temp[temp.length - 1]);
                }
            }
        }
        return keyParam;
    }

    public String getSQLWhereFromKeyParam(HashMap keyParam, String alias) {
        StringBuffer sql = new StringBuffer();
        if (keyParam.get("companyOrgUnitID") != null) {
            sql.append(" AND ").append(alias).append(".FCOMPANYORGUNITID ='").append(keyParam.get("companyOrgUnitID").toString()).append("'");
        }
        if (keyParam.get("storageOrgUnitID") != null) {
            sql.append(" AND  ").append(alias).append(".FSTORAGEORGUNITID ='").append(keyParam.get("storageOrgUnitID").toString()).append("'");
        }
        if (keyParam.get("wareHouseID") != null) {
            sql.append(" AND ").append(alias).append(".FWAREHOUSEID ='").append(keyParam.get("wareHouseID").toString()).append("'");
        }
        if (keyParam.get("Lot") != null) {
            sql.append(" AND ").append(alias).append(".FLOT ='").append(keyParam.get("Lot").toString()).append("'");
        }
        if (keyParam.get("AssistPropertyID") != null) {
            sql.append(" AND ").append(alias).append(".FASSISTPROPERTYID ='").append(keyParam.get("AssistPropertyID").toString()).append("'");
        }
        if (keyParam.get("ProjectID") != null) {
            sql.append(" AND ").append(alias).append(".FPROJECTID ='").append(keyParam.get("ProjectID").toString()).append("'");
        }
        if (keyParam.get("TrackNumberID") != null) {
            sql.append(" AND ").append(alias).append(".FTRACKNUMBERID ='").append(keyParam.get("TrackNumberID").toString()).append("'");
        }
        return sql.toString();
    }

    protected Boolean isInBillForSaleReturn(RecentCostInfo bill, CalculateParams params) {
        Boolean isInBill4SaleReturn = false;
        if (bill.getFBlueBillEntryID() != null && bill.isBlueOutBillInPrePeriod() && params.getBoolean("isNotSrcOutBillCalType")) {
            isInBill4SaleReturn = true;
        }
        return isInBill4SaleReturn;
    }

    protected BigDecimal getNewPrice(Context ctx, CalculateParams params, RecentCostInfo resultInfo) throws BOSException {
        BigDecimal price = null;
        Boolean isSpecial = false;
        if (5 == params.getInt("ACCOUNT_TYPE")) {
            isSpecial = true;
        }
        String calType = params.getString("CALTYPE");
        StringBuffer sql = new StringBuffer();
        sql.append("select fprice from T_CL_StockPrice where FCompanyOrgUnitId = '" + params.getString("COMPANY_ID") + "'");
        if (!"0".equals(calType)) {
            sql.append(" and FStorageOrgUnitId = '" + resultInfo.getString("fstorageorgunitid") + "'");
        } else {
            sql.append(" and FStorageOrgUnitId = '93uhNTdxcafgUztAqMC5Zusff9I='");
        }
        if ("2".equals(calType)) {
            sql.append(" and FWarehouseId = '" + resultInfo.getString("fwarehouseid") + "'");
        } else {
            sql.append(" and FWarehouseId = '93uhNTdycafgUztAqMC5Zrvp+K4='");
        }
        sql.append(" and FMaterialId = '" + resultInfo.getString("fmaterialid") + "'");
        if (isSpecial.booleanValue()) {
            if (StringUtil.isEmpty((String)resultInfo.getString("flot"))) {
                sql.append(" and FLot is null");
            } else {
                sql.append(" and FLot = '" + resultInfo.getString("flot") + "'");
            }
            if (StringUtil.isEmpty((String)resultInfo.getString("fassistpropertyid"))) {
                sql.append(" and FAssistPropertyID is null");
            } else {
                sql.append(" and FAssistPropertyID = '" + resultInfo.getString("fassistpropertyid") + "'");
            }
            if (StringUtil.isEmpty((String)resultInfo.getString("fprojectid"))) {
                sql.append(" and fprojectid is null");
            } else {
                sql.append(" and fprojectid = '" + resultInfo.getString("fprojectid") + "'");
            }
            if (StringUtil.isEmpty((String)resultInfo.getString("ftracknumberid"))) {
                sql.append(" and ftracknumberid is null");
            } else {
                sql.append(" and ftracknumberid = '" + resultInfo.getString("ftracknumberid") + "'");
            }
        }
        if (this.priceType == 1) {
            sql.append(" and FPriceType = ").append(0);
        } else {
            sql.append(" and FPriceType = ").append(1);
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                price = rs.getBigDecimal("fprice");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return price;
    }

    protected void checkInterrupted() throws InterruptedException {
        if (ThreadLocalHelper.isOneKeyCalc.get() != null && ((Boolean)ThreadLocalHelper.isOneKeyCalc.get()).booleanValue() && (ThreadLocalHelper.mainExcutor.get() == null || ((ExecutorService)ThreadLocalHelper.mainExcutor.get()).isShutdown())) {
            throw new InterruptedException("\u5176\u4ed6\u4efb\u52a1\u5df2\u4e2d\u65ad job was interrupted by other thread");
        }
    }

    class MatAttrChangeVO {
        private String SourceEntryID = null;
        private List InBillList = null;
        private List OutBillList = null;

        public MatAttrChangeVO(String sourceEntryID) {
            this.SourceEntryID = sourceEntryID;
            this.InBillList = new ArrayList();
            this.OutBillList = new ArrayList();
        }

        public void addInBill(RecentCostInfo inBill) {
            if (this.InBillList.indexOf(inBill) < 0) {
                this.InBillList.add(inBill);
            }
        }

        public void removeInBill(RecentCostInfo inBill) {
            this.InBillList.remove(inBill);
        }

        public void addOutBill(RecentCostInfo outBill) {
            if (this.OutBillList.indexOf(outBill) < 0) {
                this.OutBillList.add(outBill);
            }
        }

        public void removeOutBill(RecentCostInfo outBill) {
            this.OutBillList.remove(outBill);
        }

        public void clearInBillList() {
            this.InBillList.clear();
        }

        public void clearOutBillList() {
            this.OutBillList.clear();
        }

        public String getSourceEntryID() {
            return this.SourceEntryID;
        }

        public List getInBillList() {
            return this.InBillList;
        }

        public List getOutBillList() {
            return this.OutBillList;
        }

        public int getOutBillCount() {
            return this.OutBillList.size();
        }

        public int getInBillCount() {
            return this.InBillList.size();
        }

        public RecentCostInfo getOutBill(int i) {
            return (RecentCostInfo)this.OutBillList.get(i);
        }

        public RecentCostInfo getInBill(int i) {
            return (RecentCostInfo)this.InBillList.get(i);
        }

        public void calculateCost() {
            BigDecimal totalCost = this.getTotalOutCost();
            BigDecimal totalQty = this.getTotalInQty();
            BigDecimal dealCost = new BigDecimal("0");
            BigDecimal recentCost = new BigDecimal("0");
            for (int i = 0; i < this.InBillList.size(); ++i) {
                RecentCostInfo bill = (RecentCostInfo)this.InBillList.get(i);
                recentCost = totalCost.multiply(bill.getRecentQty().divide(totalQty, 8, 4)).setScale(bill.getInt("FLocalCurrencyPrecision"), 4);
                if (i == this.InBillList.size() - 1) {
                    recentCost = totalCost.subtract(dealCost);
                }
                if (!bill.isDealComplete()) {
                    bill.setRecentCost(recentCost);
                    RecentCostHelp.calculateAvgPrice(bill);
                    bill.setPriceSource(PriceSourEnum.matChangeOut);
                    bill.setNeedUpdate(true);
                }
                dealCost = dealCost.add(bill.getRecentCost());
            }
        }

        private BigDecimal getTotalOutCost() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.OutBillList.size(); ++i) {
                RecentCostInfo bill = (RecentCostInfo)this.OutBillList.get(i);
                result = result.add(bill.getRecentCost());
            }
            return result;
        }

        private BigDecimal getTotalInQty() {
            BigDecimal result = new BigDecimal("0.00");
            for (int i = 0; i < this.InBillList.size(); ++i) {
                RecentCostInfo bill = (RecentCostInfo)this.InBillList.get(i);
                result = result.add(bill.getRecentQty());
            }
            return result;
        }
    }
}

