/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.app.calculate.CostAdjustCalculate;
import com.kingdee.eas.scm.cal.app.calculate.InvInpWarehsCalculate;
import com.kingdee.eas.scm.cal.app.calculate.InvOutWarehsCalculate;
import com.kingdee.eas.scm.cal.app.calculate.PurAccountPayableCalculate;
import com.kingdee.eas.scm.cal.app.calculate.PurInWarehouseAPCalculate;
import com.kingdee.eas.scm.cal.app.calculate.Sale2IncomeConfirmCalculate;
import com.kingdee.eas.scm.cal.app.calculate.SaleAccountReceivableCalculate;
import com.kingdee.eas.scm.cal.app.calculate.SaleOutWarehouseARCalculate;
import com.kingdee.eas.scm.cal.app.calculate.StockTranInpWarehsCalculate;
import com.kingdee.eas.scm.cal.app.calculate.StockTranOutWarehsCalculate;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.ICalculate;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.ICalculateCost;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.im.inv.ManufactureRecBillInfo;
import com.kingdee.eas.scm.im.inv.MaterialReqBillInfo;
import com.kingdee.eas.scm.im.inv.MoveInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.MoveIssueBillInfo;
import com.kingdee.eas.scm.im.inv.OtherInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.OtherIssueBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class CalculateFactory {
    private Logger logger = Logger.getLogger(CalculateFactory.class);
    private ICalculate lnkICalculate;

    public ICalculate create(CoreBillBaseInfo calbill) throws CalculateException {
        if (calbill instanceof PurInWarehsBillInfo) {
            this.logger.debug((Object)("\u666e\u901a\u91c7\u8d2d\u5165\u5e93/\u666e\u901a\u91c7\u8d2d\u9000\u8d27 created:" + PurInWarehouseAPCalculate.class.getName()));
            this.lnkICalculate = new PurInWarehouseAPCalculate();
        } else if (calbill instanceof SaleIssueBillInfo) {
            this.lnkICalculate = new SaleOutWarehouseARCalculate();
        } else if (calbill.getBOSType().toString().equals("48DA3A71")) {
            this.lnkICalculate = new PurAccountPayableCalculate();
        } else if (calbill.getBOSType().toString().equals("FC910EF3")) {
            this.lnkICalculate = new SaleAccountReceivableCalculate();
        } else if (calbill.getBOSType().toString().equals("A8378ABC")) {
            this.lnkICalculate = new Sale2IncomeConfirmCalculate();
        } else if (calbill instanceof ManufactureRecBillInfo) {
            this.lnkICalculate = new InvInpWarehsCalculate();
        } else if (calbill instanceof MaterialReqBillInfo) {
            this.lnkICalculate = new InvOutWarehsCalculate();
        } else if (calbill instanceof MoveInWarehsBillInfo) {
            this.lnkICalculate = new StockTranInpWarehsCalculate();
        } else if (calbill instanceof MoveIssueBillInfo) {
            this.lnkICalculate = new StockTranOutWarehsCalculate();
        } else if (calbill instanceof OtherInWarehsBillInfo) {
            this.lnkICalculate = new InvInpWarehsCalculate();
        } else if (calbill instanceof OtherIssueBillInfo) {
            this.lnkICalculate = new InvOutWarehsCalculate();
        } else if (calbill instanceof CostAdjustBillInfo) {
            this.lnkICalculate = new CostAdjustCalculate();
        } else {
            this.logger.debug((Object)CalculateException.TRANSCATIONTYPE_CALCULATE_DEAL_NO_EXIT);
        }
        return this.lnkICalculate;
    }

    public static ICalculateCost create(Context ctx, CalculateParams params) throws CalculateException, BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT FClassName FROM T_CL_CostCalculate WHERE");
        bf.append(" FAccountType = ").append(params.getInt("ACCOUNT_TYPE"));
        bf.append(" AND FCreateItem = ").append(params.getInt("CALCULATE_CREATE_ITEM"));
        String sql = bf.toString();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
        ICalculateCost ical = null;
        try {
            if (!rs.next()) {
                throw new CalculateException(CalculateException.CLASS_NAME_NOT_EXIST);
            }
            ical = (ICalculateCost)Class.forName(rs.getString("FClassName")).newInstance();
        }
        catch (InstantiationException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ical;
    }
}

