/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostAdjuestCreateTypeEnum;
import com.kingdee.eas.scm.cal.CostAdjustBillCollection;
import com.kingdee.eas.scm.cal.CostAdjustBillEntryInfo;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractInventoryCalculate;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.newutil.CostAdjustHelper;
import com.kingdee.eas.scm.cal.newutil.CalConstant;
import com.kingdee.eas.scm.cal.newutil.CalculateUtil;
import com.kingdee.eas.scm.cal.newutil.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CostAdjustCalculate
extends AbstractInventoryCalculate {
    private Logger logger = Logger.getLogger(CostAdjustCalculate.class);
    private CalculateKindEnum outOrInWarehouseKind = null;
    private CoreBillBaseCollection expCostAdjColl = null;

    @Override
    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo) throws BOSException, EASBizException {
        InvBillBaseInfo bill = (InvBillBaseInfo)scminfo;
        this.outOrInWarehouseKind = ((CostAdjustBillInfo)bill).getCalculateKind();
        this.srcEntryTableName = "t_cl_costadjustbillentry";
        StringBuffer selectSQL = this.takeSQLBill(ctx, this.srcEntryTableName);
        CalculateWrittenOffBill costAdjBill = this.takeWrittenOffBill(ctx, (CoreBillBaseInfo)bill, this.srcEntryTableName, selectSQL);
        if (costAdjBill == null) {
            return;
        }
        ArrayList entrys = costAdjBill.getEntry();
        boolean isExistMove_add = false;
        for (int i = entrys.size() - 1; i >= 0; --i) {
            CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)entrys.get(i);
            this.calculator.calculateCost(ctx, this.companyOrgUnitInfo, this.periodInfo, this.materialCalType, entry.getAmount().multiply(CalculateKindEnum.INPUT_WAREHOUSE.equals((Object)((CostAdjustBillInfo)bill).getCalculateKind()) ? CalConstant.ONE : CalConstant.ONE_MINUS), entry.getBaseUnitQty().multiply(CalculateKindEnum.OUTPUT_WAREHOUSE.equals((Object)((CostAdjustBillInfo)bill).getCalculateKind()) ? CalConstant.ONE_MINUS : CalConstant.ONE), costAdjBill, entry, true);
            if (entry.getMaterialAccountType().getValue() == AccountType.MOVE_ADD_AVERAGE.getValue()) {
                isExistMove_add = true;
            }
            if (entry.getNumber() != null || !isExistMove_add) continue;
            entry.setNumber(((CostAdjustBillInfo)bill).getNumber());
        }
        if (isExistMove_add && costAdjBill.getBaseStatus() == 4 && this.isAutoExpAdjust((CostAdjustBillInfo)bill)) {
            this.calculator.setCostBill(true);
            this.expCostAdjColl = new CoreBillBaseCollection();
            this.expCostAdjColl.add((CoreBillBaseInfo)bill);
            this.fillCostAdjBillPrice(ctx, (CostAdjustBillInfo)bill, costAdjBill, ((CostAdjustBillInfo)bill).getCreateType().getValue(), this.materialCalType);
            this.handleExpCostAdj(ctx, true);
        }
        if (4 != costAdjBill.getBaseStatus() && this.isAutoExpAdjust((CostAdjustBillInfo)bill)) {
            this.deleteRelationCostAdjBill(ctx, bill.getNumber());
        }
    }

    @Override
    protected String getExtendInvBillSelector() {
        StringBuffer selector = new StringBuffer();
        selector.append(" ,Bill.FSupplierid AS ").append("fsupplier");
        selector.append(" ,Bill.FCustomerid AS ").append("fcustomer");
        selector.append(" ,'' AS ").append("fcoreBillNumber");
        selector.append(" ,'' AS ").append("fcoreBillId");
        selector.append(" ,0 AS ").append("fcoreBillEntrySeq");
        selector.append(" ,'' AS ").append("fcoreBillEntryId");
        selector.append(" ,0 AS ").append("funWriteOffAmt");
        selector.append(" ,0 AS ").append("fwrittenOffAmt");
        selector.append(" ,0 AS ").append("funWriteOffQty");
        selector.append(" ,0 AS ").append("fwrittenOffQty");
        return selector.toString();
    }

    @Override
    protected CalculateKindEnum takeOutOrInWarehouseKind() throws EASBizException, BOSException {
        return this.outOrInWarehouseKind;
    }

    public void calculateStrategy(Context ctx, CoreBillBaseInfo scminfo, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo periodInfo, String materialCalType, BizActionEnum bizAction) throws BOSException, EASBizException {
    }

    private String getWriteOffRecordParentId(Context ctx, String billid) throws BOSException, EASBizException {
        boolean flag = false;
        StringBuffer bf = new StringBuffer();
        bf.setLength(0);
        bf.append("select distinct fparentid from T_CL_WriteOffRecord");
        bf.append(" where fbillid = '").append(billid).append("'");
        String sql = bf.toString();
        this.logger.debug((Object)("sql=" + sql));
        bf.setLength(0);
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                bf.append(rs.getString("fparentid"));
                flag = true;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return flag ? bf.toString() : null;
    }

    private String getOtherbillEntrySql(String fparentid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT T1.FMATERIALID AS FMaterialid, CASE WHEN T1.FBASEQTY=0 THEN 0 ELSE Round(TO_DECIMAL(T1.FAMOUNTLOCAL/T1.FBASEQTY,21,8),8) END AS FPRICE");
        buffer.append("\n  FROM t_ap_otherbillentry  T1");
        buffer.append(" inner join (");
        buffer.append("\n select WriteOffRecord.FBillEntryId AS fentryId from T_CL_WriteOffRecord WriteOffRecord ");
        buffer.append("\n where WriteOffRecord.fparentid ='").append(fparentid).append("'");
        buffer.append("\n GROUP BY WriteOffRecord.FBillEntryId");
        buffer.append(" ) T2 ");
        buffer.append(" ON T1.FID = T2.fentryId");
        return buffer.toString();
    }

    private boolean isAutoExpAdjust(CostAdjustBillInfo bill) {
        int createType = bill.getCreateType().getValue();
        return createType != 1 && createType != 9;
    }

    private void fillCostAdjBillPrice(Context ctx, CostAdjustBillInfo costAdjbill, CalculateWrittenOffBill calculateWrittenOffBill, int createType, String materialCalType) throws EASBizException, BOSException {
        String parentId = null;
        String querySql = null;
        String costAdjbillId = costAdjbill.getId().toString();
        if (createType == 4) {
            parentId = this.getExpenseRecordParentid(ctx, costAdjbillId);
            if (parentId == null) {
                return;
            }
            querySql = this.getPurinWarehPriceSql(parentId);
        } else if (createType == 0) {
            parentId = this.getWriteOffRecordParentId(ctx, costAdjbillId);
            if (parentId == null) {
                return;
            }
            querySql = this.getOtherbillEntrySql(parentId);
        }
        if (querySql == null) {
            return;
        }
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, querySql);
            ArrayList costEntry = calculateWrittenOffBill.getEntry();
            while (rs.next()) {
                for (int i = 0; i < costEntry.size(); ++i) {
                    CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)costEntry.get(i);
                    String keyFromWhMaterial = CalculateUtil.getCalTypeMaterialKey(materialCalType, entry.getMaterialId(), entry.getFinanceOrg().getId().toString(), entry.getStorageOrgUnitId(), entry.getWarehouseId());
                    if (!rs.getString("FMaterialid").equals(entry.getMaterialId())) continue;
                    entry.setPurInViocePrice(rs.getBigDecimal("FPRICE").setScale(entry.getPrecision().getPricePrecision(), 4));
                    costAdjbill.put(keyFromWhMaterial, entry);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String getExpenseRecordParentid(Context ctx, String costAdjbillId) throws BOSException {
        boolean flag = false;
        StringBuffer bf = new StringBuffer();
        bf.setLength(0);
        bf.append("select distinct fparentid from T_CL_ExpenseApportionEntry");
        bf.append(" where FSourceBillId = '").append(costAdjbillId).append("'");
        String sql = bf.toString();
        this.logger.debug((Object)("sql=" + sql));
        bf.setLength(0);
        try {
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                bf.append(rs.getString("fparentid"));
                flag = true;
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return flag ? bf.toString() : null;
    }

    private String getPurinWarehPriceSql(String fparentid) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT T1.FMATERIALID AS FMaterialid,CASE WHEN T1.FBASEQTY=0 THEN 0 ELSE Round(TO_DECIMAL(T1.FACTUALCOST/T1.FBASEQTY,21,8),8) END AS FPRICE ");
        buffer.append("\n FROM t_im_purinwarehsentry  T1");
        buffer.append(" inner join (");
        buffer.append("\n select expenseEntry.FSourceEntryId AS fentryId from T_CL_ExpenseApportionEntry expenseEntry ");
        buffer.append("\n where expenseEntry.fparentid ='").append(fparentid).append("'");
        buffer.append("\n GROUP BY expenseEntry.FSourceEntryId");
        buffer.append(" ) T2 ");
        buffer.append(" ON T1.FID = T2.fentryId");
        return buffer.toString();
    }

    private void deleteRelationCostAdjBill(Context ctx, String costAdjBillNumber) throws BOSException, EASBizException {
        try {
            costAdjBillNumber = "*" + costAdjBillNumber;
            boolean isFivouchered = CostAdjustHelper.checkCostAdjBillIsVouchered(ctx, new String[]{costAdjBillNumber}, false);
            if (isFivouchered) {
                throw new CalculateException(CalculateException.BILLISGENERATEVOUCHER);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.calculator.unCalculateCost(ctx, CostAdjustHelper.getCostAdjSql(ctx, costAdjBillNumber), CalculateKindEnum.OUTPUT_WAREHOUSE);
        DBUtil.execute(ctx, CostAdjustHelper.getDeleteCostAdjustbill(costAdjBillNumber));
    }

    protected void handleExpCostAdj(Context ctx, boolean isAdjust) throws BOSException, EASBizException {
        HashMap materialRecentCostHashMap = this.calculator.getMaterialRecentCostHashMap();
        if (materialRecentCostHashMap == null || materialRecentCostHashMap.size() <= 0) {
            return;
        }
        this.logger.debug((Object)("materialRecentCostHashMap \u6570:" + materialRecentCostHashMap.size()));
        Iterator it = materialRecentCostHashMap.entrySet().iterator();
        CostAdjustBillInfo expCostAdjBill = null;
        boolean isQtyZero = false;
        while (it.hasNext()) {
            Map.Entry mapentry = it.next();
            if (mapentry.getKey() == null || mapentry.getValue() == null) continue;
            HashMap innerHm = (HashMap)mapentry.getValue();
            String keyFromWhMaterial = CalculateUtil.getCalTypeMaterialKey(this.materialCalType, (String)innerHm.get("FMaterialID"), (String)innerHm.get("FCompanyOrgUnitID"), (String)innerHm.get("FStorageOrgUnitID"), (String)innerHm.get("FWarehouseID"));
            if (CalConstant.ZERO.compareTo((BigDecimal)innerHm.get("FPrice")) <= 0 && (CalConstant.ZERO.compareTo((BigDecimal)innerHm.get("FRecentQty")) != 0 || CalConstant.ZERO.compareTo((BigDecimal)innerHm.get("FRecentCost")) == 0)) continue;
            isQtyZero = CalConstant.ZERO.compareTo((BigDecimal)innerHm.get("FRecentQty")) == 0 && CalConstant.ZERO.compareTo((BigDecimal)innerHm.get("FRecentCost")) != 0;
            if (expCostAdjBill == null) {
                expCostAdjBill = new CostAdjustBillInfo();
            }
            this.doCreateCostAdjustbill(expCostAdjBill, keyFromWhMaterial, innerHm, isQtyZero);
        }
        if (expCostAdjBill != null) {
            CostAdjustBillCollection collection = new CostAdjustBillCollection();
            collection.add(expCostAdjBill);
            this.addNewCostAdjustBill(ctx, collection);
        }
    }

    private void doCreateCostAdjustbill(CostAdjustBillInfo expCostAdjBill, String keyFromWhMaterial, HashMap innerHm, boolean isQtyZero) throws CalculateException {
        int seq = 0;
        BigDecimal adjustAmount = CalConstant.ZERO;
        BigDecimal targetAmount = CalConstant.ZERO;
        for (int i = 0; this.expCostAdjColl != null && i < this.expCostAdjColl.size(); ++i) {
            CostAdjustBillInfo tmpCostBill = (CostAdjustBillInfo)this.expCostAdjColl.get(i);
            CalculateWrittenOffEntry wrioffPurIn = (CalculateWrittenOffEntry)tmpCostBill.get(keyFromWhMaterial);
            if (wrioffPurIn == null) continue;
            expCostAdjBill = CostAdjustHelper.createCostAdjustBill(tmpCostBill, expCostAdjBill, CalculateKindEnum.OUTPUT_WAREHOUSE);
            expCostAdjBill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            expCostAdjBill.setCreateType(CostAdjuestCreateTypeEnum.ExpBalanceAjdust);
            expCostAdjBill.setNumber("*" + wrioffPurIn.getNumber());
            if (isQtyZero) {
                adjustAmount = (BigDecimal)innerHm.get("FRecentCost");
                if (adjustAmount.compareTo(CalConstant.ZERO) == 0) {
                    continue;
                }
            } else {
                targetAmount = wrioffPurIn.getPurInViocePrice().multiply((BigDecimal)innerHm.get("FRecentQty")).setScale(wrioffPurIn.getPrecision().getCurrencyPrecision(), 4);
                adjustAmount = targetAmount.subtract((BigDecimal)innerHm.get("FRecentCost")).multiply(CalConstant.ONE_MINUS);
            }
            CostAdjustBillEntryInfo expCostAjdEntry = CostAdjustHelper.createExpCostAdjustEntry(wrioffPurIn, seq, adjustAmount);
            expCostAjdEntry.setBigDecimal("FRecentCost_tmp", (BigDecimal)innerHm.get("FRecentCost"));
            expCostAjdEntry.setBigDecimal("FPrice_tmp", (BigDecimal)innerHm.get("FPrice"));
            expCostAjdEntry.setBigDecimal("FRecentQty_tmp", (BigDecimal)innerHm.get("FRecentQty"));
            expCostAjdEntry.setBizDate(expCostAdjBill.getBizDate());
            expCostAjdEntry.setParent(expCostAdjBill);
            expCostAdjBill.getEntry().add(expCostAjdEntry);
            ++seq;
        }
    }
}

