/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExceptionBillCalculate
extends AbstractCalculateCost {
    private static Logger logger = Logger.getLogger(ExceptionBillCalculate.class);
    private int billType = 0;
    public static final String RESOURCE_CAL_COMMON = "com.kingdee.eas.scm.cal.CalCommonResource";
    protected String[][] inpourTableArray = new String[][]{{"T_IM_PurInWarehsEntry", "T_IM_PurInWarehsBill", "50957179-0105-1000-e000-015fc0a812fd463ED552"}, {"T_IM_ManufactureRecBillEntry", "T_IM_ManufactureRecBill", "50957179-0105-1000-e000-0167c0a812fd463ED552"}, {"T_IM_MoveInWarehsBillEntry", "T_IM_MoveInWarehsBill", "50957179-0105-1000-e000-0172c0a812fd463ED552"}, {"T_IM_OtherInWarehsBillEntry", "T_IM_OtherInWarehsBill", "50957179-0105-1000-e000-017bc0a812fd463ED552"}, {"T_IM_SaleIssueEntry", "T_IM_SaleIssueBill", "50957179-0105-1000-e000-015bc0a812fd463ED552"}, {"T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill", "50957179-0105-1000-e000-0163c0a812fd463ED552"}, {"T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill", "50957179-0105-1000-e000-0177c0a812fd463ED552"}, {"T_IM_MoveIssueBillEntry", "T_IM_MoveIssueBill", "50957179-0105-1000-e000-016ec0a812fd463ED552"}};

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        String name = this.getClass().getName().replaceAll(this.getClass().getPackage().getName(), "");
        name = name.replace('.', ' ');
        return name.trim();
    }

    @Override
    protected AccountType[] takeMaterialAccountType() {
        List it = AccountType.getEnumList();
        AccountType[] type = new AccountType[it.size() - 1];
        int j = 0;
        for (int i = 0; i < it.size(); ++i) {
            if (AccountType.MOVE_ADD_AVERAGE.equals((Object)((AccountType)it.get(i)))) continue;
            type[j] = (AccountType)it.get(i);
            ++j;
        }
        return type;
    }

    private void createTmpeTable(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException {
        String[] calculateTables = InventoryBillHelp.getCalculateTables();
        String temTableName = null;
        for (int i = 0; i < calculateTables.length; ++i) {
            if (!StringUtil.isEmpty((String)params.getString(calculateTables[i])) || !"T_Temp_WriteOffTable".equals(calculateTables[i])) continue;
            temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getWriteOffTableFields());
            sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
            params.setString("T_Temp_WriteOffTable", temTableName);
            sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_WriteOffTable"), "FBillEntryID,FBillID", false, false);
        }
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        ArrayList collection = (ArrayList)params.getObject("ENTRYCOLL");
        if (collection == null || collection.size() == 0) {
            return false;
        }
        this.setInpWarehsSum(true);
        String[] sSQList = new String[collection.size()];
        params.setObject("SysTempTableHelper", (Object)sysTempTableHelper);
        String tempTableName = params.getString("TEMPTABLE");
        if (tempTableName == null) {
            return false;
        }
        this.createTmpeTable(ctx, params, sysTempTableHelper);
        try {
            String midtempTableName = sysTempTableHelper.createTempTable(ctx, this.getCreateTempTableSQL());
            String idtempTableName = sysTempTableHelper.createTempTable(ctx, this.getCreateIdTempTableSQL());
            this.insertDataToMidTemp(ctx, collection, tempTableName, sysTempTableHelper, midtempTableName, idtempTableName);
            ArrayList list = null;
            HashSet numberSet = new HashSet();
            for (int i = 0; i < collection.size(); ++i) {
                list = (ArrayList)collection.get(i);
                sSQList[i] = this.updateTemp(ctx, list, midtempTableName);
                numberSet.add(list.get(3));
            }
            sysTempTableHelper.execute(sSQList);
            IRowSet result = null;
            String sql = "SELECT FBILLTYPEID,FBilltypeName FROM " + midtempTableName + " group by FBILLTYPEID,FBilltypeName";
            result = sysTempTableHelper.executeQuery(sql);
            String billTypeID = null;
            String billTypeName = null;
            while (result.next()) {
                billTypeID = result.getString("FBILLTYPEID");
                billTypeName = result.getString("FBilltypeName");
                String[] updateTableName = this.getUpdteTableName(billTypeID);
                if (updateTableName == null || updateTableName[0] == null || updateTableName[1] == null) {
                    return false;
                }
                ArrayList<String> errorMsgListIds = new ArrayList<String>();
                this.checkUpdateBillData(ctx, updateTableName[1], updateTableName[0], midtempTableName, periodInfo, params, sysTempTableHelper, billTypeName, billTypeID, errorMsgListIds, numberSet);
                String errorListIds = null;
                if (errorMsgListIds.size() > 0) {
                    errorListIds = CalculateUtil.getSqlInString(errorMsgListIds);
                }
                if (!"50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
                    sysTempTableHelper.execute(this.updateBillsPriceSQL(updateTableName[1], updateTableName[0], midtempTableName, periodInfo, params).toString());
                }
                if ("50957179-0105-1000-e000-015bc0a812fd463ED552".equals(billTypeID)) {
                    this.handleOtherDataForExpBillQuery(ctx, sysTempTableHelper, params, periodInfo, tempTableName);
                }
                if ("50957179-0105-1000-e000-015fc0a812fd463ED552".equals(billTypeID)) {
                    int localCurrPrecesion = params.getInt("Local_Currency_Presision");
                    StringBuffer sSQL = new StringBuffer();
                    sSQL.append("Select bill.FNumber,entry.FSeq,entry.FID,bill.FExchangeRate,bill.FConvertMode,bill.FIsInTax,bill.FIsPriceInTax,");
                    sSQL.append(" Round(temp.FActualcost,temp.flocalcurrencyprecision) as FActualCost,");
                    sSQL.append(" CASE WHEN entry.fqty = 0 THEN 0 ELSE Round(temp.factualbaseunitcost,temp.fpriceprecision) END as FUnitActualCost,");
                    sSQL.append(" IsNull(entry.FPurchaseCost, 0) as FPurchaseCost,");
                    sSQL.append(" IsNull(entry.FUnitPurchaseCost, 0) as FUnitPurchaseCost,IsNull(entry.FPurchaseFee, 0) as FPurchaseFee,");
                    sSQL.append(" IsNull(entry.FMaterialCost, 0) as FMaterialCost,");
                    sSQL.append(" entry.FUnitMaterialCost,entry.FTaxRate,entry.FQty,entry.FWrittenOffQty,entry.FDiscountRate,currency.FPrecision,");
                    sSQL.append(" material.FPricePrecision,entry.FLocalPrice,entry.FLocalAmount ");
                    sSQL.append(" from T_IM_PurInWarehsBill bill, T_IM_PurInWarehsEntry entry, T_BD_Currency currency, T_BD_Material material, ");
                    sSQL.append(midtempTableName).append(" temp ");
                    sSQL.append(" where entry.FParentid=bill.FID and currency.FID=bill.FCurrencyID and material.FID=entry.FMaterialID ");
                    sSQL.append(" and entry.fid = temp.FBillEntryID ");
                    sSQL.append(" and ISNULL(bill.FFiVouchered, 0)=0 and ISNULL(entry.FWrittenOffBaseQty, 0)=0 ");
                    sSQL.append(" and bill.FYear*100 + bill.FPeriod >=").append(periodInfo.getPeriodYear()).append(periodInfo.getPeriodNumber());
                    sSQL.append(" and entry.FDiscountRate <>100 ");
                    sSQL.append(" and temp.FBillTypeId = '").append("50957179-0105-1000-e000-015fc0a812fd463ED552").append("'");
                    if (errorListIds != null) {
                        sSQL.append(" and temp.FBillEntryID Not IN ").append(errorListIds);
                    }
                    IRowSet rs = sysTempTableHelper.executeQuery(sSQL.toString());
                    CalculateUtil.updatePurInfo(ctx, (ResultSet)rs, localCurrPrecesion, true, params);
                }
                sysTempTableHelper.execute(this.updateBillsSumAmountSQL(ctx, updateTableName[1], updateTableName[0], midtempTableName, periodInfo, params));
                if (!"50957179-0105-1000-e000-0163c0a812fd463ED552".equals(billTypeID)) continue;
                StringBuffer querysql = new StringBuffer();
                querysql.append(" select 1 from ").append(updateTableName[0]).append(" T1");
                querysql.append(" inner join  ").append(midtempTableName).append(" T2");
                querysql.append(" on T1.fid = T2.FBillEntryID  ");
                querysql.append(" where (sign(T1.FSUBUNWRITEOFFBASEQTY) = 0 and  sign(T1.FSCUNWRITTENOFFAMOUNT) <>0)  ");
                querysql.append(" or (sign(T1.FSUBUNWRITEOFFBASEQTY) > 0 and  sign(T1.FSCUNWRITTENOFFAMOUNT) <0)  ");
                querysql.append(" or (sign(T1.FSUBUNWRITEOFFBASEQTY) < 0 and  sign(T1.FSCUNWRITTENOFFAMOUNT) >0)  ");
                IRowSet rs = sysTempTableHelper.executeQuery(querysql.toString());
                querysql.setLength(0);
                if (rs.next()) {
                    throw new CalculateException(CalculateException.REWRITEMATREQAMOUNTERROR);
                }
                querysql.append("    SELECT b.fid as fid  FROM T_IM_MATERIALREQBILL a  ");
                querysql.append(" \n inner join T_IM_MATERIALREQBILLENTRY b on a.fid = b.FPARENTID ");
                querysql.append(" \n inner join ").append(midtempTableName).append(" c on b.fid = c.fbillentryID");
                querysql.append(" \n where a.FPURCHASETYPE = 1 and c.FBillTypeId ='");
                querysql.append("50957179-0105-1000-e000-0163c0a812fd463ED552").append("'");
                rs = sysTempTableHelper.executeQuery(querysql.toString());
                ArrayList<String> entryIDList = new ArrayList<String>();
                while (rs.next()) {
                    entryIDList.add(rs.getString("fid"));
                }
                if (entryIDList == null || entryIDList.size() <= 0) continue;
                WriteOffHelp.updDevWritRecordOnMatreqCostChange(ctx, entryIDList);
            }
            Iterator it = numberSet.iterator();
            String number = null;
            StringBuffer msg = new StringBuffer();
            IObjectPK pklog = null;
            int limitLength = 1024;
            ArrayList<String> msgList = new ArrayList<String>();
            String msgToContinue = ResourceUtil.getMessage((String)RESOURCE_CAL_COMMON, (String)"msgToContinue");
            String title = ResourceUtil.getMessage((String)RESOURCE_CAL_COMMON, (String)"exceptionBillLogTiltle");
            while (it.hasNext()) {
                number = it.next().toString();
                if (msg.length() + number.length() > limitLength) {
                    msg.append(msgToContinue);
                    msgList.add(msg.toString());
                    msg.setLength(0);
                }
                msg.append(number).append(", ");
            }
            if (msg.length() > 0) {
                msgList.add(msg.toString());
            }
            for (int i = 0; i < msgList.size(); ++i) {
                pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("13AF665D"), null, (String)((String)msgList.get(i)), (String)title);
                LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return true;
    }

    public ResultSet getPurResultSetByTempTab(Context ctx, SysTempTableHelper sysTempTableHelper, String tempTableName, PeriodInfo currPeriod) throws BOSException {
        if (tempTableName == null || "".equals(tempTableName) || currPeriod == null) {
            return null;
        }
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select bill.FNumber,entry.FSeq,entry.FID,bill.FExchangeRate,bill.FConvertMode,bill.FIsInTax,bill.FIsPriceInTax,");
        sSQL.append("entry.FActualCost,entry.FUnitActualCost,IsNull(entry.FPurchaseCost, 0) as FPurchaseCost,");
        sSQL.append(" IsNull(entry.FUnitPurchaseCost, 0) as FUnitPurchaseCost,IsNull(entry.FPurchaseFee, 0) as FPurchaseFee,IsNull(entry.FMaterialCost, 0) as FMaterialCost,");
        sSQL.append(" entry.FUnitMaterialCost,entry.FTaxRate,entry.FQty,entry.FWrittenOffQty,entry.FDiscountRate,currency.FPrecision,material.FPricePrecision,entry.FLocalPrice,entry.FLocalAmount ");
        sSQL.append(" from T_IM_PurInWarehsBill bill, T_IM_PurInWarehsEntry entry, T_BD_Currency currency, T_BD_Material material, ").append(tempTableName).append(" temp ");
        sSQL.append(" where entry.FParentid=bill.FID and currency.FID=bill.FCurrencyID and material.FID=entry.FMaterialID ");
        sSQL.append(" and entry.fid = temp.FBillEntryID ");
        sSQL.append(" and ISNULL(bill.FFiVouchered, 0)=0 and ISNULL(entry.FWrittenOffBaseQty, 0)=0 ");
        sSQL.append(" and bill.FYear =").append(currPeriod.getPeriodYear()).append(" and bill.FPeriod >=").append(currPeriod.getPeriodNumber());
        sSQL.append(" and entry.FDiscountRate <>100 ");
        sSQL.append(" and temp.FBillTypeId = '").append("50957179-0105-1000-e000-015fc0a812fd463ED552").append("'");
        return DBUtil.executeQuery((Context)ctx, (String)sSQL.toString());
    }

    private String updateTemp(Context ctx, ArrayList list, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        BigDecimal actualBaseUnitCost = (BigDecimal)list.get(1);
        BigDecimal actualCost = (BigDecimal)list.get(2);
        if (CalculateUtil.ZERO.compareTo(actualBaseUnitCost) == 0) {
            actualBaseUnitCost = CalculateUtil.ZERO;
        }
        if (CalculateUtil.ZERO.compareTo(actualCost) == 0) {
            actualCost = CalculateUtil.ZERO;
        }
        sql.append(" update ").append(tempTableName);
        sql.append(" set ");
        sql.append(" FActualBaseUnitCost =").append(actualBaseUnitCost.toPlainString());
        sql.append(",FActualCost =").append(actualCost.toPlainString());
        sql.append(" WHERE FBillEntryID = '").append(list.get(0)).append("'");
        return sql.toString();
    }

    private void insertDataToMidTemp(Context ctx, ArrayList collection, String tempTableName, SysTempTableHelper sysTempTableHelper, String midtempTableName, String idtempTableName) throws BOSException {
        ArrayList list = null;
        StringBuffer idList = new StringBuffer();
        Object[][] params = new Object[collection.size()][1];
        for (int i = 0; i < collection.size(); ++i) {
            list = (ArrayList)collection.get(i);
            params[i][0] = list.get(0);
        }
        String insertIdSQL = this.getIdInsertSql(idtempTableName);
        sysTempTableHelper.executeBatch(ctx, insertIdSQL, params);
        String insertSQL = this.getInsertSql(midtempTableName, this.getSelectSql(tempTableName, idtempTableName));
        sysTempTableHelper.execute(insertSQL);
    }

    private String getIdInsertSql(String idtempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(idtempTableName);
        sql.append("\n (FID) Values (?)");
        return sql.toString();
    }

    private String[][] getCreateTempTableSQL() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}, {"FBilltypeName", "NVARCHAR(255)"}, {"FTRANSACTIONNAME", "NVARCHAR(255)"}, {"FBillNumber", "VARCHAR(80)"}, {"FBizDate", "DATETIME"}, {"FMaterialID", "VARCHAR(44)"}, {"FMATERIALNUMBER", "NVARCHAR(80)"}, {"FMATERIALNAME", "NVARCHAR(255)"}, {"FMODEL", "NVARCHAR(255)"}, {"FUnitId", "VARCHAR(44)"}, {"FunitName", "NVARCHAR(80)"}, {"FQty", "NUMERIC(21,8) default 0"}, {"FActualBaseUnitCost", "NUMERIC(21,8) default 0"}, {"FActualcost", "NUMERIC(17,4) default 0"}, {"FUnitStandardCost", "NUMERIC(21,8) default 0"}, {"FStandardCost", "NUMERIC(17,4) default 0"}, {"FBaseUnitName", "NVARCHAR(80)"}, {"FBaseQty", "NUMERIC(21,8) default 0"}, {"FQtyPrecision", "INT default 2"}, {"FPricePrecision", "INT default 2"}, {"FBILLTYPEID", "VARCHAR(44)"}, {"FBILLID", "VARCHAR(44)"}, {"FLocalCurrencyPrecision", "INT default 2"}, {"FCompanyOrgUnitID", "VARCHAR(44)"}, {"FBaseUnitId", "VARCHAR(44)"}, {"FBillEntryID", "VARCHAR(44)"}};
        return fields;
    }

    private String[][] getCreateIdTempTableSQL() {
        String[][] fields = new String[][]{{"FID", "VARCHAR(44) NOT NULL"}};
        return fields;
    }

    private String getInsertSql(String tempTable, String selectSql) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tempTable);
        sql.append("(FID,FBILLTYPENAME,FTRANSACTIONNAME,FBillNumber,FBizDate,FMaterialID,FMATERIALNUMBER");
        sql.append(",FMATERIALNAME,FMODEL,FUnitId,FunitName,FQty,FActualBaseUnitCost,Factualcost");
        sql.append(",FUnitStandardCost,FStandardCost,FBaseUnitName,FBaseQty,FQtyPrecision,FPricePrecision");
        sql.append(",FBILLTYPEID,FBILLID,FLocalCurrencyPrecision ,FCompanyOrgUnitID,FBaseUnitId ,FBillEntryID)");
        sql.append("\n");
        sql.append(selectSql);
        return sql.toString();
    }

    private String getSelectSql(String tempTable, String idtempTableName) throws BOSException {
        StringBuffer bfSql = new StringBuffer();
        bfSql.append("SELECT a.FID,FBILLTYPENAME,FTRANSACTIONNAME,FBillNumber,FBizDate,FMaterialID,FMATERIALNUMBER ");
        bfSql.append(",FMATERIALNAME,FMODEL,FUnitId,FunitName,FQty,FActualBaseUnitCost,Factualcost");
        bfSql.append(",FUnitStandardCost,FStandardCost,FBaseUnitName,FBaseQty,FQtyPrecision,FPricePrecision");
        bfSql.append(",FBILLTYPEID,FBILLID,FLocalCurrencyPrecision ,FCompanyOrgUnitID,FBaseUnitId ,FBillEntryID");
        bfSql.append("\n FROM  ").append(tempTable).append(" as a");
        bfSql.append("\n Inner Join ").append(idtempTableName).append(" as b");
        bfSql.append("\n on a.FBillEntryID = b.Fid");
        return bfSql.toString();
    }

    private Object updateBillsPriceSQL(String bill, String billEntry, String tempTableName, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        params.setBoolean("includeAfterPeriod", true);
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET (FActualCost,FUnitActualCost");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry) || this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FWrittenOffAmount,FUnWriteOffAmount");
        }
        if (this.issueTableArray[2][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FSCWrittenOffAmount,FSCUnWrittenOffAmount");
        }
        sql.append(" ) = ( ");
        sql.append(" SELECT ");
        sql.append("  ROUND(TempT.FActualCost,TempT.FLocalCurrencyPrecision) ");
        sql.append(" ,case ");
        sql.append("  when Entry.FQty = 0 then 0 ").append("\t\n");
        sql.append("  else ROUND(TempT.FActualBaseUnitCost,TempT.FPricePrecision)").append("\t\n");
        sql.append("  end ");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry) || this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,case ");
            sql.append("  when Entry.FBaseQty = Entry.FWrittenOffQty then TempT.FActualCost ").append("\t\n");
            sql.append(" else ROUND(TempT.FActualBaseUnitCost * Entry.FWrittenOffQty,TempT.FLocalCurrencyPrecision)");
            sql.append(" end ");
            sql.append(" ,case ");
            sql.append("  when Entry.FBaseQty = Entry.FWrittenOffQty then 0 ").append("\t\n");
            sql.append("  else ROUND(TempT.FActualCost,TempT.FLocalCurrencyPrecision) - ROUND(TempT.FActualBaseUnitCost * Entry.FWrittenOffQty,TempT.FLocalCurrencyPrecision)");
            sql.append(" end ");
        }
        if (this.issueTableArray[2][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,case when TempT.FBaseQty = 0 then 0 ");
            sql.append("  when Entry.FBaseQty = Entry.FSUBWRITTENOFFBASEQTY then TempT.FActualCost ");
            sql.append(" else ROUND(TempT.FActualBaseUnitCost * Entry.FSUBWRITTENOFFBASEQTY,TempT.FLocalCurrencyPrecision) end ");
            sql.append(" ,case when TempT.FBaseQty = 0 then 0 ");
            sql.append(" when Entry.FBaseQty = Entry.FSUBWRITTENOFFBASEQTY then 0 ");
            sql.append(" else ROUND(TempT.FActualCost,TempT.FLocalCurrencyPrecision) - ROUND(TempT.FActualBaseUnitCost * Entry.FSUBWRITTENOFFBASEQTY,TempT.FLocalCurrencyPrecision) end ");
        }
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" ON Entry.FID = TempT.FBillEntryID  ");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" LEFT JOIN T_SCM_BizType BIZTYPE ON BILL.FBizTypeID = BIZTYPE.FID ");
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhere4ExpBillQuery(periodInfo, params));
        } else if (this.issueTableArray[2][0].equals(billEntry) || this.issueTableArray[3][0].equals(billEntry)) {
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhereBase(periodInfo, params).append(this.getSQLWhere4RedOutForExpBillQuery(periodInfo, params)));
        } else {
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhere(periodInfo, params));
        }
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" AND ");
            sql.append(this.getSQLExtendWhere());
            sql.append("\n AND ENTRY.FWrittenOffQty = 0");
        }
        sql.append(" AND (BILL.FFiVouchered = 0 OR Bill.FFiVouchered is NULL)").append("\t\n");
        sql.append(" and entry.FInvUpdateTypeID not in (");
        sql.append("  select fid from T_IM_InvUpdateType where ");
        sql.append("  (FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("'").append(" and FStoreTypePreID is null ) ");
        sql.append("  or (FStoreTypePreID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' and FStoreTypeID is null ) ");
        sql.append("  or (FStoreTypePreID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' and FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' )");
        sql.append(" )");
        if (params.getBoolean("checkUnitActualcost")) {
            sql.append(" AND ENTRY.FUNITActualCost <=0").append("\t\n");
        }
        sql.append(" AND T.FID = Entry.FID");
        sql.append(")  ");
        return sql.toString();
    }

    private String updateBillsFlagSQL(String bill, String billEntry, String tempTableName, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET FIsGenCalFlag =0");
        sql.append(" WHERE EXISTS(");
        sql.append(" SELECT 1  ");
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" ON Entry.FID = TempT.FBillEntryID  ");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" LEFT JOIN T_SCM_BizType BIZTYPE ON BILL.FBizTypeID = BIZTYPE.FID ");
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhere4ExpBillQuery(periodInfo, params));
        } else if (this.issueTableArray[2][0].equals(billEntry) || this.issueTableArray[3][0].equals(billEntry)) {
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhereBase(periodInfo, params).append(this.getSQLWhere4RedOutForExpBillQuery(periodInfo, params)));
        } else {
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhere(periodInfo, params));
        }
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" AND ");
            sql.append(this.getSQLExtendWhere());
            sql.append("\n AND ENTRY.FWrittenOffQty = 0");
        }
        sql.append(" AND (BILL.FFiVouchered = 0 OR Bill.FFiVouchered is NULL)").append("\t\n");
        if (this.inpourTableArray[2][0].equalsIgnoreCase(billEntry) || this.inpourTableArray[7][0].equalsIgnoreCase(billEntry)) {
            sql.append(" and BILL.FBizTypeID not in (").append("\t\n");
            sql.append(" '").append("d8e80652-011b-1000-e000-04c5c0a812202407435C").append("'").append("\t\n");
            sql.append(" ,'").append("d8e80652-011a-1000-e000-04c5c0a812202407435C").append("'").append("\t\n");
            sql.append(" ,'").append("YJN9V65PSkutQxeUH6F72SQHQ1w=").append("'");
            sql.append(" )").append("\t\n");
        }
        if (params.getBoolean("checkUnitActualcost")) {
            sql.append(" AND ENTRY.FUNITActualCost <=0").append("\t\n");
        }
        sql.append(" AND T.FID = Entry.FID");
        sql.append(" )  ");
        return sql.toString();
    }

    private void checkUpdateBillData(Context ctx, String bill, String billEntry, String tempTableName, PeriodInfo periodInfo, CalculateParams params, SysTempTableHelper sysTempTableHelper, String billTypeName, String billTypeID, ArrayList<String> errorMsgListIds, Set numberSet) throws BOSException {
        StringBuffer sql = new StringBuffer();
        params.setBoolean("includeAfterPeriod", true);
        sql.append("SELECT FBilltypeName,FBillNumber,FMATERIALNUMBER,FBillEntryID FROM ").append(tempTableName).append(" WHERE FBillEntryID NOT IN (");
        sql.append(" SELECT TempT.FBillEntryID ");
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" ON Entry.FID = TempT.FBillEntryID  ");
        if (this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" LEFT JOIN T_SCM_BizType BIZTYPE ON BILL.FBizTypeID = BIZTYPE.FID ");
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhere4ExpBillQuery(periodInfo, params));
        } else if (this.issueTableArray[2][0].equals(billEntry) || this.issueTableArray[3][0].equals(billEntry)) {
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhereBase(periodInfo, params).append(this.getSQLWhere4RedOutForExpBillQuery(periodInfo, params)));
        } else {
            sql.append(this.getSQLJOIN(params));
            sql.append(this.getSQLWhere(periodInfo, params));
        }
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" AND ");
            sql.append(this.getSQLExtendWhere());
            sql.append("\n AND ENTRY.FWrittenOffQty = 0 ");
        }
        sql.append(" AND (BILL.FFiVouchered = 0 OR Bill.FFiVouchered is NULL)").append("\t\n");
        sql.append(" and entry.FInvUpdateTypeID not in (");
        sql.append("  select fid from T_IM_InvUpdateType where ");
        sql.append("  (FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("'").append(" and FStoreTypePreID is null ) ");
        sql.append("  or (FStoreTypePreID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' and FStoreTypeID is null ) ");
        sql.append("  or (FStoreTypePreID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' and FStoreTypeID = '").append("181875d5-0105-1000-e000-0114c0a812fd97D461A6").append("' )");
        sql.append(" )");
        sql.append(") and FBILLTYPEID = '").append(billTypeID).append("' group by FBilltypeName,FBillNumber,FMATERIALNUMBER,FBillEntryID ");
        StringBuffer msg = null;
        msg = params.getString("ErrorMsgList") == null ? new StringBuffer() : new StringBuffer(params.getString("ErrorMsgList") + "\t\n");
        try {
            IRowSet rs = sysTempTableHelper.executeQuery(sql.toString());
            StringBuffer errorMsg = new StringBuffer();
            int i = 0;
            while (rs.next()) {
                errorMsgListIds.add(rs.getString("FBillEntryID"));
                if (i == 0) {
                    numberSet.remove(rs.getString("FBillNumber"));
                    errorMsg.append(billTypeName).append(":");
                    errorMsg.append("\t\n");
                }
                errorMsg.append(ResourceUtil.getMessage((Context)ctx, (String)RESOURCE_CAL_COMMON, (String)"BillNumber", (String[])new String[]{rs.getString("FBillNumber")})).append(" ");
                errorMsg.append(ResourceUtil.getMessage((Context)ctx, (String)RESOURCE_CAL_COMMON, (String)"EntryMateirlNum", (String[])new String[]{rs.getString("FMATERIALNUMBER")}));
                errorMsg.append("\t\n");
                ++i;
            }
            if (errorMsg.length() > 0) {
                msg.append(errorMsg);
            }
            if (msg != null && msg.toString() != null && msg.toString().trim() != null && msg.toString().trim().length() > 0) {
                params.setString("ErrorMsgList", msg.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String updateBillsSumAmountSQL(Context ctx, String bill, String billEntry, String tempTableName, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(bill).append(" AS T ");
        sql.append(" set (FTotalAmount,FTotalStandardCost,fTotalActualCost) = ");
        sql.append(" ( ");
        sql.append(" select a,b,c");
        sql.append(" from ").append(bill).append(" AS Temp ");
        sql.append(" INNER JOIN ( ");
        sql.append(" select ");
        sql.append(CalculateUtil.TO_DECIMAL_SUM("sum(Entry.FAmount)") + " as a,sum(Entry.FStandardCost) as b");
        sql.append(" ," + CalculateUtil.TO_DECIMAL_SUM("sum(Entry.FActualCost)") + " as c,TBillID.FID");
        sql.append(" FROM ").append(billEntry).append(" As Entry");
        sql.append(" INNER JOIN ");
        sql.append(" (");
        sql.append(" select Bill.FID");
        sql.append(" FROM ").append(bill).append(" AS Bill ");
        sql.append(" INNER JOIN ").append(billEntry).append(" As Entry");
        sql.append(" ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" AS TempT");
        sql.append(" ON Entry.FID = TempT.FBillEntryID  ");
        sql.append(this.getSQLJOIN(params));
        sql.append(this.getSQLWhere(periodInfo, params));
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" AND ");
            sql.append(this.getSQLExtendWhere());
        }
        sql.append(" GROUP BY Bill.FID ");
        sql.append(") TBillID ");
        sql.append(" ON TBillID.FID = Entry.FParentID  ");
        sql.append(" GROUP BY TBillID.FID ");
        sql.append(") T2 ");
        sql.append(" ON Temp.FID = T2.FID  ");
        sql.append(" WHERE Temp.FID = T.FID");
        sql.append(")  ");
        return sql.toString();
    }

    private StringBuffer getSQLExtendWhere() {
        StringBuffer sql = new StringBuffer();
        sql.append(" (");
        sql.append("    (Bill.FIsReversed  = 0 or Bill.FIsReversed  is null)");
        sql.append(" AND (");
        sql.append("     ABS(ENTRY.FReverseQty) = ABS(ENTRY.FWrittenOffQty) ");
        sql.append("  OR ENTRY.FWrittenOffQty = 0");
        sql.append(" )").append("\t\n");
        sql.append(" OR Bill.FIsReversed  = 1 )");
        return sql;
    }

    private String[] getUpdteTableName(String billTypeId) {
        String[] tableName = new String[2];
        for (int i = 0; i < this.inpourTableArray.length; ++i) {
            if (!this.inpourTableArray[i][2].equals(billTypeId)) continue;
            tableName[0] = this.inpourTableArray[i][0];
            tableName[1] = this.inpourTableArray[i][1];
            this.billType = i < 4 ? 0 : 1;
        }
        return tableName;
    }
}

