/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.BalanceCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.help.UpdateBillCostHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class FIFOCalculateNew
extends AbstractCalculateCost {
    private static Logger logger = Logger.getLogger(FIFOCalculateNew.class);
    private CountDownLatch countDown;

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return new AccountType[]{AccountType.FIN_FOUT};
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        Connection conn = null;
        LowTimer calcuateTimer = new LowTimer();
        conn = sysTempTableHelper.getConn();
        params.setBoolean("calculteCostPriceMovein", true);
        params.setBoolean("isCalReversed", true);
        params.setBoolean("IsNeedReWork", true);
        String jobId = (String)ctx.get((Object)"SCM_JOB_INST_ID");
        IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 5, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"247_PutDataToTempTable", (Locale)this.l3));
        }
        String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
        String tempMaterialTable = params.getString("T_Temp_FIFOMaterialListNew");
        this.beforeCalculate(ctx, params, strCalType, periodInfo, sysTempTableHelper, conn, tempTableFIFOBills, tempMaterialTable);
        ArrayList updateBillSQL = new ArrayList();
        params.setObject("updateBillSQL", updateBillSQL);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 65, "", ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l2), ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"255_CostCalculating", (Locale)this.l3));
        }
        String materialSql = this.getMaterialSqlNew(ctx, tempMaterialTable, params);
        int materialPage = this.getMaterialPageCount(sysTempTableHelper, tempMaterialTable);
        this.countDown = new CountDownLatch(materialPage);
        int threadNum = this.getThreadPoolNum(ctx);
        ExecutorService executor = Executors.newFixedThreadPool(threadNum);
        for (int i = 0; i < materialPage; ++i) {
            CalculateThreadForFIFO calThread = new CalculateThreadForFIFO(ctx, conn, params, i * 1000, periodInfo, sysTempTableHelper, materialSql);
            executor.execute(calThread);
        }
        try {
            this.countDown.await();
            this.handleOtherData(ctx, sysTempTableHelper, params, periodInfo, tempTableFIFOBills, strCalType);
        }
        catch (InterruptedException e) {
            logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.info((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        executor.shutdown();
        if (this.ExceptionList.size() > 0) {
            logger.info(this.ExceptionList.get(0));
            throw new BOSException((Throwable)this.ExceptionList.get(0));
        }
        logger.info((Object)("\u8ba1\u7b97\u6210\u672c\u603b\u65f6\u95f4\uff1a" + calcuateTimer.msValue()));
        return false;
    }

    private void beforeCalculate(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper, Connection conn, String tempTableFIFOBills, String tempMaterialTable) throws BOSException {
        LowTimer timer = new LowTimer();
        try {
            this.checkInterrupted();
            timer.reset();
            this.buildInOutBillsData(ctx, sysTempTableHelper, periodInfo, strCalType, params, tempTableFIFOBills);
            logger.info((Object)("\u5165\u5e93\u548c\u51fa\u5e93\u5355\u636e\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            this.checkInterrupted();
            timer.reset();
            this.adjustPrePeriodData(conn, params, periodInfo, tempTableFIFOBills);
            logger.info((Object)("\u8fdb\u884c\u6570\u636e\u8c03\u6574\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.buildPrePeriodCostMoveBill(ctx, sysTempTableHelper, params, strCalType, periodInfo, tempTableFIFOBills);
            logger.info((Object)("\u4ee5\u524d\u671f\u95f4\u7684\u6210\u672c\u4ef7\u8c03\u62e8\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            sysTempTableHelper.analyzeTable(tempTableFIFOBills);
            logger.info((Object)("\u7edf\u8ba1\u5206\u6790\u4e34\u65f6\u8868\u65f6\u95f4\uff1a\uff1a" + timer.msValue()));
            timer.reset();
            StringBuffer sqlmaterial = this.takeMatrialListNew(ctx, strCalType, tempTableFIFOBills);
            this.insertFIFOMaterialTMPTableNew(sysTempTableHelper, sqlmaterial, tempMaterialTable);
            logger.info((Object)("\u6784\u9020\u7269\u6599\u904d\u5386\u96c6\u5408\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.getNeedUpdateMoveLocBillMaterial(sysTempTableHelper, tempMaterialTable, params, periodInfo);
            logger.info((Object)("\u9700\u8981\u66f4\u65b0\u5e93\u4f4d\u79fb\u52a8\u5355\u6210\u672c\u7684\u7269\u6599\uff1a" + timer.msValue()));
            timer.reset();
            ArrayList sqlParams = new ArrayList();
            sysTempTableHelper.execute(this.clearOldPeriodData(params, strCalType, sqlParams), sqlParams);
            logger.info((Object)("\u6e05\u9664\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u65f6\u95f4\uff1a" + timer.msValue()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void fifoCalculate(Context ctx, Connection conn, CalculateParams params, RptRowSet rsMaterial, String strCalType, PeriodInfo periodInfo, PreparedStatement rptPs) throws EASBizException, BOSException {
        ArrayList<RecentCostInfo> listAllBill = new ArrayList<RecentCostInfo>();
        ArrayList handredAdjustList = new ArrayList();
        String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
        Statement stmt = null;
        ResultSet rs = null;
        try {
            this.checkInterrupted();
            String materialId = rsMaterial.getString("FMaterialID");
            params.setString("CurrMaterialId", materialId);
            StringBuffer sql = new StringBuffer();
            sql.append("select Bill.* from ").append(tempTableFIFOBills).append(" Bill ");
            sql.append(" where Bill.FMaterialID = '").append(materialId).append("'");
            sql.append(" and Bill.FCompanyOrgUnitID = '").append(rsMaterial.getString("FCompanyOrgUnitID")).append("'");
            sql.append(this.getSQLOrderBy(strCalType));
            String key = null;
            HashMap<String, ArrayList> calMap = new HashMap<String, ArrayList>();
            HashMap costMoveMap = new HashMap();
            ArrayList listPeriodBeginIn = new ArrayList();
            ArrayList needUpdatedBills = new ArrayList();
            ArrayList listInBill = null;
            HashMap<String, RecentCostInfo> combitionMap = new HashMap<String, RecentCostInfo>();
            HashMap<String, ArrayList> periodBeginInMap = new HashMap<String, ArrayList>();
            HashMap matAttrChgMap = new HashMap();
            HashMap<String, RecentCostInfo> prePeriodCostMoveMap = new HashMap<String, RecentCostInfo>();
            params.setObject("updateBillSQL", needUpdatedBills);
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            long timeSerialNumber = new Date().getTime();
            while (rs.next()) {
                RecentCostInfo combinBill;
                RecentCostInfo bill = this.convertRecentCostInfo(rs, strCalType, timeSerialNumber += 10L);
                if (bill.getInt("FFiVouchered") == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                if (bill.getInt("FisSrcBilInCurrPid") > 0) {
                    bill.setNeedUpdate(true);
                }
                if (bill.getInt("FisCombition") != 1 && CalculateUtil.ZERO.compareTo(bill.getRecentQty()) == 0 && CalculateUtil.ZERO.compareTo(bill.getRecentCost()) == 0) continue;
                key = bill.getString("FkeyID");
                if (calMap.get(key) == null) {
                    listInBill = new ArrayList();
                    calMap.put(key, listInBill);
                } else {
                    listInBill = (ArrayList)calMap.get(key);
                }
                if (periodBeginInMap.get(key) == null) {
                    listPeriodBeginIn = new ArrayList();
                    periodBeginInMap.put(key, listPeriodBeginIn);
                } else {
                    listPeriodBeginIn = (ArrayList)periodBeginInMap.get(key);
                }
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill, strCalType, periodInfo);
                    this.buildCostPriceMove(bill, costMoveMap);
                    if (bill.isMoveOutBill() && RecentCostHelp.isPrePeriodBill(bill, periodInfo)) {
                        prePeriodCostMoveMap.put(bill.getStockTransBillEntryID(), bill);
                    }
                }
                if (!(bill.getInt("FisSrcBilInCurrPid") == 1 && (bill.getInt("FisSrcBilInCurrPid") != 1 || bill.getInt("FisCombition") != 0) || RecentCostHelp.isPrePeriodBill(bill, periodInfo) || bill.isMatAttrChange() && !bill.isOutBill())) {
                    listAllBill.add(bill);
                }
                if (bill.isMatAttrChange()) {
                    bill.setBoolean("IsCalculate", false);
                    this.buildMatAttrChange(bill, matAttrChgMap);
                }
                if (2 == bill.getInt("FCalculateKind")) {
                    if (CalculateUtil.ZERO.compareTo(bill.getRecentQty()) != 0) {
                        bill.setPrice(bill.getRecentCost().divide(bill.getRecentQty(), bill.getInt("FPricePrecision"), 4));
                    }
                    listInBill.add(bill.clone());
                    listPeriodBeginIn.add(bill);
                    continue;
                }
                if (0 == bill.getInt("FCalculateKind")) {
                    if (bill.isCalculate() && !bill.isRedBill() && bill.getInt("FisCombition") != 2 || bill.isCostAdjustBill()) {
                        listInBill.add(bill.clone());
                    }
                    if (bill.getInt("FisCombition") == 1) {
                        combitionMap.put(bill.getString("FBillEntryId"), bill);
                        continue;
                    }
                    if (bill.getInt("FisSrcBilInCurrPid") != 1 || !combitionMap.containsKey(bill.getString("fsourcebillentryid"))) continue;
                    combinBill = (RecentCostInfo)combitionMap.get(bill.getString("fsourcebillentryid"));
                    bill.setLong("timeSerialNumber", combinBill.getLong("timeSerialNumber") + 1L);
                    combinBill.addCombition(bill);
                    continue;
                }
                if (1 != bill.getInt("FCalculateKind") || !bill.isCalculate()) continue;
                if (bill.getInt("FisSrcBilInCurrPid") == 1 && bill.getInt("FisCombition") != 0 && combitionMap.containsKey(bill.getString("fsourcebillentryid"))) {
                    combinBill = (RecentCostInfo)combitionMap.get(bill.getString("fsourcebillentryid"));
                    bill.setLong("timeSerialNumber", combinBill.getLong("timeSerialNumber") + 1L);
                    combinBill.addCombition(bill);
                }
                if (bill.getInt("FisCombition") == 1) {
                    combitionMap.put(bill.getString("FBillEntryId"), bill);
                }
                if (bill.isRedBill() && bill.getInt("FisSrcBilInCurrPid") != 1 && RecentCostHelp.isEffectBalance(bill, strCalType)) {
                    RecentCostInfo tempbill = (RecentCostInfo)bill.clone();
                    tempbill.setRecentCost(tempbill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                    tempbill.setRecentQty(tempbill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                    listInBill.add(tempbill);
                }
                if (!bill.isSrcOutBillInPrePeriod()) continue;
                bill.setNeedUpdate(true);
            }
            HashMap periodBeginInPrice = this.getPriceMap(periodBeginInMap);
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, needUpdatedBills);
            this.calculateCost(ctx, calMap, periodBeginInPrice, combitionMap, costMoveMap, params, rsMaterial, strCalType, periodInfo, matAttrChgMap, rptPs, listAllBill, handredAdjustList);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
    }

    protected void calculateCost(Context ctx, HashMap calMap, HashMap periodBeginInPrice, HashMap combitionMap, HashMap costMoveMap, CalculateParams params, RptRowSet rsMaterial, String strCalType, PeriodInfo periodInfo, HashMap matAttrChgMap, PreparedStatement rptPs, ArrayList listAllBill, ArrayList handredAdjustList) throws SQLException, EASBizException, BOSException {
        HashMap payOutMap = new HashMap();
        ArrayList<RecentCostInfo> listPayout = new ArrayList<RecentCostInfo>();
        ArrayList listInBill = null;
        BigDecimal newOutPrice = CalculateUtil.ZERO;
        BigDecimal newInpPrice = CalculateUtil.ZERO;
        HashMap<String, BigDecimal> newOutPriceMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> newInpPriceMap = new HashMap<String, BigDecimal>();
        HashMap<String, Boolean> exceptMap = null;
        boolean isExceptionState = false;
        ArrayList needUpdatedBills = (ArrayList)params.getObject("updateBillSQL");
        for (int i = 0; listAllBill != null && i < listAllBill.size(); ++i) {
            RecentCostInfo bill = (RecentCostInfo)listAllBill.get(i);
            if (exceptMap != null && exceptMap.get(bill.getString("FkeyID")) != null) continue;
            listInBill = (ArrayList)calMap.get(bill.getString("FkeyID"));
            listPayout = (ArrayList<RecentCostInfo>)payOutMap.get(bill.getString("FkeyID"));
            if (listPayout == null) {
                listPayout = new ArrayList<RecentCostInfo>();
                payOutMap.put(bill.getString("FkeyID"), listPayout);
            }
            if (2 == bill.getInt("FCalculateKind")) {
                newInpPriceMap.put(bill.getFkeyID(), bill.getPrice());
            } else if (0 == bill.getInt("FCalculateKind")) {
                if (CalculateUtil.ZERO.compareTo(bill.getPrice()) <= 0) {
                    newInpPriceMap.put(bill.getFkeyID(), bill.getPrice());
                }
                if (bill.isRedBill() && bill.getInt("FisSrcBilInCurrPid") != 1 && !bill.isCostAdjustBill()) {
                    bill.setRecentCost(bill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                    bill.setRecentQty(bill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                    if (!bill.isCostPriceMove()) {
                        bill.setDealComplete(true);
                    }
                    isExceptionState = this.calculateFIFOOutBillCost(listInBill, bill, (BigDecimal)newInpPriceMap.get(bill.getFkeyID()));
                    bill.setRecentCost(bill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                    bill.setRecentQty(bill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                }
                if (bill.isCostAdjustBill()) {
                    try {
                        this.calculateInCostAdjustBill(listInBill, bill);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage());
                        logger.error((Object)e.getStackTrace());
                    }
                }
            } else {
                if (bill.getInt("FFiVouchered") != 1 && "1".equals(this.writeCostType) && bill.getInt("isReWork") == 1) {
                    RecentCostInfo costInfo = (RecentCostInfo)periodBeginInPrice.get(bill.getString("FkeyID"));
                    if (costInfo != null && CalculateUtil.ZERO.compareTo(costInfo.getPrice()) != 0) {
                        bill.setPrice(costInfo.getPrice());
                        bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4));
                        bill.setPriceSource(PriceSourEnum.periodBeginPriceReWork);
                        bill.setNeedUpdate(true);
                    } else {
                        bill.setPriceSource(PriceSourEnum.zeroPrice);
                        bill.setDealComplete(true);
                    }
                } else if (bill.getInt("FFiVouchered") != 1 && "0".equals(this.writeCostType) && bill.getInt("isReWork") == 1 && !bill.isExistSrcBill()) {
                    bill.setPriceSource(PriceSourEnum.userDefine);
                    bill.setDealComplete(true);
                }
                if (bill.isRedBill()) {
                    bill.setPriceSource(PriceSourEnum.userDefine);
                    if (CalculateUtil.ZERO.compareTo(bill.getRecentCost()) == 0 && !bill.isDealComplete() && bill.getInt("FisSrcBilInCurrPid") == 0) {
                        this.setBillPrice(listInBill, (BigDecimal)newOutPriceMap.get(bill.getFkeyID()), (BigDecimal)newInpPriceMap.get(bill.getFkeyID()), bill);
                        if (CalculateUtil.ZERO.compareTo(bill.getPrice()) == 0 && !bill.isDealComplete()) {
                            bill.setPriceSource(PriceSourEnum.zeroPrice);
                        }
                        if (RecentCostHelp.isEffectBalance(bill, strCalType)) {
                            for (int k = listInBill.size() - 1; k >= 0; --k) {
                                RecentCostInfo settleAccounts = (RecentCostInfo)listInBill.get(k);
                                if (!settleAccounts.getString("FBillEntryId").equals(bill.getString("FBillEntryId"))) continue;
                                settleAccounts.setPrice(bill.getPrice());
                                settleAccounts.setRecentCost(bill.getRecentCost().negate());
                                settleAccounts.setRecentQty(bill.getRecentQty().negate());
                                break;
                            }
                        }
                    }
                } else {
                    listPayout.add(bill);
                    if (bill.getInt("FisCombition") == 1 && !bill.isCostAdjustBill() && CalculateUtil.ZERO.compareTo(bill.getRecentQty()) == 0) {
                        newOutPrice = (BigDecimal)newOutPriceMap.get(bill.getFkeyID());
                        if (newOutPrice != null && CalculateUtil.ZERO.compareTo(newOutPrice) < 0) {
                            bill.setPriceSource(PriceSourEnum.newOut);
                            bill.setPrice(newOutPrice);
                        }
                        if ((newInpPrice = (BigDecimal)newInpPriceMap.get(bill.getFkeyID())) != null && CalculateUtil.ZERO.compareTo(bill.getPrice()) == 0) {
                            bill.setPrice(newInpPrice);
                            bill.setPriceSource(PriceSourEnum.newIn);
                        }
                    } else if (!RecentCostHelp.isEffectBalance(bill, strCalType)) {
                        this.setBillPrice(listInBill, (BigDecimal)newOutPriceMap.get(bill.getFkeyID()), (BigDecimal)newInpPriceMap.get(bill.getFkeyID()), bill);
                    } else if (bill.isCalculate()) {
                        isExceptionState = this.calculateFIFOOutBillCost(listInBill, bill, (BigDecimal)newInpPriceMap.get(bill.getFkeyID()));
                    }
                    newOutPriceMap.put(bill.getFkeyID(), bill.getPrice());
                    if (bill.getInt("FisCombition") == 1 && combitionMap.containsKey(bill.getString("FBillEntryId"))) {
                        RecentCostInfo combitInfo = (RecentCostInfo)combitionMap.get(bill.getString("FBillEntryId"));
                        combitInfo.setBigDecimal("FcombitionCost", bill.getRecentCost());
                    }
                }
            }
            if (isExceptionState) {
                bill.setBoolean("isExceptionState", isExceptionState);
                if (bill.getInt("isReWork") == 1) {
                    needUpdatedBills.add(bill);
                }
                if (params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                    this.computeReportOutAndInWarehouseDetailInfo2(ctx, rptPs, bill, listInBill, periodInfo, bill.getInt("FCalculateKind"), 2, params.getString("headerid"));
                }
                if (exceptMap == null) {
                    exceptMap = new HashMap<String, Boolean>();
                }
                exceptMap.put(bill.getString("FkeyID"), isExceptionState);
                isExceptionState = false;
                if (!"0".equals(strCalType)) continue;
                break;
            }
            if (bill.isCostPriceMove() && bill.isMoveOutBill()) {
                this.synCostMovePriceBill(costMoveMap, bill);
                this.synCostMovePriceToInList(costMoveMap, calMap, bill);
            }
            if (bill.isCostPriceMove() && bill.isMoveInBill() && !bill.isNeedUpdate() && !bill.isDealComplete()) {
                this.synCostMoveInPrice(ctx, costMoveMap, bill);
                this.synCostMovePriceToInList(calMap, bill);
            }
            this.calMatAttrChangeCost(needUpdatedBills, matAttrChgMap);
            this.billDealProces(ctx, bill, params, listInBill, strCalType, needUpdatedBills, periodInfo, combitionMap, rptPs);
        }
        HashMap balanceMap = new HashMap();
        ArrayList<String> calOrder = new ArrayList<String>();
        for (Map.Entry entry : calMap.entrySet()) {
            listInBill = (ArrayList)entry.getValue();
            listPayout = (ArrayList)payOutMap.get(entry.getKey());
            this.handleDetailDiffer(ctx, listInBill, listPayout, rptPs, periodInfo, needUpdatedBills, params.getString("headerid"));
            this.getFifoBalance(balanceMap, listInBill, listPayout, entry.getKey().toString());
            calOrder.add(entry.getKey().toString());
        }
        this.updateMoveLocationBill(ctx, params, balanceMap, calOrder, strCalType);
        if (params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
            this.writeEndCostComputeReport(ctx, strCalType, periodInfo, calMap, rsMaterial, params, exceptMap, rptPs);
        }
    }

    private void calculateInCostAdjustBill(ArrayList rsList, RecentCostInfo currBill) {
        if (!rsList.contains(currBill)) {
            return;
        }
        int previousInBill = -1;
        int currPostion = -1;
        for (int i = 0; i < rsList.size(); ++i) {
            if (!((RecentCostInfo)rsList.get(i)).isCostAdjustBill()) {
                previousInBill = i;
            }
            if (!rsList.get(i).equals(currBill)) continue;
            currPostion = i;
            break;
        }
        if (previousInBill < 0) {
            return;
        }
        int pricePrecision = currBill.getInt("FPricePrecision");
        RecentCostInfo lastRs = (RecentCostInfo)rsList.get(previousInBill);
        lastRs.setRecentCost(lastRs.getRecentCost().add(currBill.getRecentCost()));
        lastRs.setRecentQty(lastRs.getRecentQty().add(currBill.getRecentQty()));
        if (lastRs.getRecentQty().compareTo(BigDecimal.ZERO) == 0) {
            lastRs.setPrice(BigDecimal.ZERO);
        } else {
            lastRs.setPrice(lastRs.getRecentCost().divide(lastRs.getRecentQty(), pricePrecision, 4));
        }
        rsList.remove(currPostion);
    }

    private void synCostMoveInPrice(Context ctx, HashMap costMoveMap, RecentCostInfo bill) throws BOSException, SQLException, CalculateException {
        RecentCostInfo costMoveObj = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
        RecentCostInfo moveCostBill = null;
        BigDecimal moveOutQty = BigDecimal.ZERO;
        BigDecimal moveOutAmt = BigDecimal.ZERO;
        BigDecimal avgPrice = BigDecimal.ZERO;
        ArrayList moveCostList = costMoveObj.getMoveInbillList();
        ArrayList<Object> billList = costMoveObj.getMoveBillList();
        if (billList == null) {
            ArrayList tempList = costMoveObj.getMoveOutbillList();
            billList = new ArrayList<Object>();
            for (int i = 0; i < tempList.size(); ++i) {
                billList.add(((RecentCostInfo)tempList.get(i)).clone());
            }
            costMoveObj.setMoveBillList(billList);
        }
        if (billList == null || billList.size() == 0) {
            throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{costMoveObj.get("fmaterialnumber").toString()});
        }
        int listIndex = 0;
        RecentCostInfo billInfo = (RecentCostInfo)billList.get(listIndex++);
        BigDecimal costMoveQty = billInfo.getQty();
        BigDecimal costMoveCost = billInfo.getRecentCost();
        for (int i = 0; i < moveCostList.size(); ++i) {
            moveCostBill = (RecentCostInfo)moveCostList.get(i);
            if (!moveCostBill.isDealComplete()) {
                moveCostBill.setPriceSource(PriceSourEnum.costMove);
            }
            BigDecimal qty = moveCostBill.getRecentQty();
            BigDecimal amount = BigDecimal.ZERO;
            while (costMoveQty.compareTo(qty) < 0 && listIndex < billList.size()) {
                qty = qty.subtract(costMoveQty);
                amount = amount.add(costMoveCost);
                billInfo.setRecentQty(BigDecimal.ZERO);
                billInfo.setRecentCost(BigDecimal.ZERO);
                billInfo = (RecentCostInfo)billList.get(listIndex++);
                costMoveQty = billInfo.getRecentQty();
                costMoveCost = billInfo.getRecentCost();
            }
            if (listIndex > billList.size()) {
                throw new CalculateException(CalculateException.MOVECOST_QTY_ERROR, new String[]{costMoveObj.get("fmaterialnumber").toString()});
            }
            if (costMoveQty.compareTo(qty) == 0) {
                amount = amount.add(costMoveCost);
                costMoveQty = BigDecimal.ZERO;
                costMoveCost = BigDecimal.ZERO;
            } else {
                BigDecimal amt = qty.multiply(billInfo.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4);
                if (amt.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) != 0 && billInfo.getPrice().compareTo(BigDecimal.ZERO) != 0) {
                    amt = RecentCostHelp.getMinValueByScale(bill.getInt("FLocalCurrencyPrecision"), qty.signum());
                }
                amount = amount.add(amt);
                costMoveQty = costMoveQty.subtract(qty);
                costMoveCost = costMoveCost.subtract(amt);
            }
            billInfo.setRecentQty(costMoveQty);
            billInfo.setRecentCost(costMoveCost);
            if (moveCostBill.getFBillEntryId().equals(bill.getFBillEntryId())) {
                bill.setRecentCost(amount);
                avgPrice = amount.divide(bill.getRecentQty(), bill.getInt("FPricePrecision"), 4);
                bill.setPrice(avgPrice);
                bill.setNeedUpdate(true);
                moveCostList.remove(moveCostBill);
                break;
            }
            moveCostBill.setRecentQty(BigDecimal.ZERO);
            moveCostBill.setRecentCost(BigDecimal.ZERO);
        }
        this.clearDealedInpourList(billList);
        this.clearDealedInpourList(moveCostList);
    }

    private void setBillPrice(ArrayList listInBill, BigDecimal newOutPrice, BigDecimal newInpPrice, RecentCostInfo bill) {
        if (newOutPrice != null && CalculateUtil.ZERO.compareTo(newOutPrice) < 0) {
            bill.setPrice(newOutPrice.setScale(bill.getInt("FPricePrecision"), 4));
            bill.setPriceSource(PriceSourEnum.newOut);
        } else if (newInpPrice != null && CalculateUtil.ZERO.compareTo(newInpPrice) < 0) {
            bill.setPriceSource(PriceSourEnum.newIn);
            bill.setPrice(newInpPrice.setScale(bill.getInt("FPricePrecision"), 4));
        }
        if (CalculateUtil.ZERO.compareTo(bill.getPrice()) == 0) {
            RecentCostInfo settleAccounts = null;
            for (int n = 0; listInBill != null && n < listInBill.size(); ++n) {
                settleAccounts = (RecentCostInfo)listInBill.get(n);
                if (settleAccounts == null || CalculateUtil.ZERO.compareTo(settleAccounts.getPrice()) >= 0) continue;
                bill.setPrice(settleAccounts.getPrice());
                bill.setPriceSource(PriceSourEnum.fifoPrice);
                break;
            }
        }
        bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4));
    }

    protected void billDealProces(Context ctx, RecentCostInfo bill, CalculateParams params, ArrayList listInpour, String strCalType, List needdUpdateBill, PeriodInfo periodInfo, HashMap combitionMap, PreparedStatement rptPs) throws EASBizException, BOSException, SQLException {
        if (bill.getInt("FisCombition") == 1) {
            bill.setBigDecimal("FcombitionQty", bill.getRecentQty());
            bill.setRecentQty(bill.getBigDecimal("FBaseQtyBak"));
            bill.setBigDecimal("FcombitionCost", bill.getRecentCost());
            bill.setRecentCost(bill.getRecentQty().multiply(bill.getPrice()).setScale(bill.getInt("FLocalCurrencyPrecision"), 4));
        }
        if (1 != bill.getInt("FCalculateKind")) {
            if (RecentCostHelp.isEffectBalance(bill, strCalType)) {
                this.writeComputeReport(ctx, rptPs, bill, listInpour, params, periodInfo, bill.getInt("FCalculateKind"), 1, strCalType);
                this.dealInWarehouseCombition(ctx, bill, params, listInpour, strCalType, needdUpdateBill, periodInfo, rptPs);
            }
            if (bill.isCostPriceMove() && !bill.isDealComplete() && bill.isNeedUpdate()) {
                needdUpdateBill.add(bill);
            }
        } else {
            if (RecentCostHelp.isEffectBalance(bill, strCalType)) {
                this.writeComputeReport(ctx, rptPs, bill, listInpour, params, periodInfo, bill.getInt("FCalculateKind"), 1, strCalType);
            }
            this.dealOutWarehouseCombition(ctx, bill, params, listInpour, strCalType, needdUpdateBill, periodInfo, rptPs);
            if (!bill.isDealComplete() && !bill.isCostAdjustBill()) {
                bill.setNeedUpdate(true);
                needdUpdateBill.add(bill);
            }
        }
    }

    private void dealInWarehouseCombition(Context ctx, RecentCostInfo bill, CalculateParams params, ArrayList listInpour, String strCalType, List needdUpdateBill, PeriodInfo periodInfo, PreparedStatement rptPs) throws EASBizException, BOSException, SQLException {
        RecentCostInfo redBillInfo = null;
        if (bill.getInt("FisCombition") == 1) {
            List redBillList = bill.getCombibionList();
            for (int i = 0; redBillList != null && i < redBillList.size(); ++i) {
                redBillInfo = (RecentCostInfo)redBillList.get(i);
                if (bill.isCostPriceMove() && !redBillInfo.isDealComplete()) {
                    redBillInfo.setNeedUpdate(true);
                    needdUpdateBill.add(redBillInfo);
                }
                this.writeComputeReport(ctx, rptPs, (RecentCostInfo)redBillList.get(i), listInpour, params, periodInfo, bill.getInt("FCalculateKind"), 1, strCalType);
            }
        }
    }

    private void dealOutWarehouseCombition(Context ctx, RecentCostInfo bill, CalculateParams params, ArrayList listInpour, String strCalType, List needdUpdateBill, PeriodInfo periodInfo, PreparedStatement rptPs) throws EASBizException, BOSException, SQLException {
        RecentCostInfo redBillInfo = null;
        if (bill.getInt("FisCombition") == 1) {
            List redBillList = bill.getCombibionList();
            if (redBillList != null && redBillList.size() > 0) {
                this.handleSrcBill(redBillList, bill);
            }
            for (int i = 0; redBillList != null && i < redBillList.size(); ++i) {
                redBillInfo = (RecentCostInfo)redBillList.get(i);
                if (!redBillInfo.isDealComplete()) {
                    redBillInfo.setNeedUpdate(true);
                    redBillInfo.setPriceSource(PriceSourEnum.sourBillPrice);
                    needdUpdateBill.add(redBillInfo);
                }
                if (!RecentCostHelp.isEffectBalance(redBillInfo, strCalType)) continue;
                this.writeComputeReport(ctx, rptPs, redBillInfo, listInpour, params, periodInfo, redBillInfo.getInt("FCalculateKind"), 1, strCalType);
            }
        }
    }

    private void writeComputeReport(Context ctx, PreparedStatement ps, RecentCostInfo bill, ArrayList list, CalculateParams params, PeriodInfo periodInfo, int outwarehouseType, int isSuccess, String strCalType) throws SQLException, EASBizException, BOSException {
        if (!params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
            return;
        }
        boolean isWriteExrpt = params.getBoolean("ISWRITEDEXPCOSTRPT");
        if (isWriteExrpt && (isSuccess == 0 || isSuccess == 2)) {
            return;
        }
        this.synListInBill(list, bill, strCalType);
        this.computeReportOutAndInWarehouseDetailInfo2(ctx, ps, bill, list, periodInfo, bill.getInt("FCalculateKind"), isSuccess, params.getString("headerid"));
    }

    @Override
    protected StringBuffer getSQLOrderBy(String stCalType) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Order by Bill.FBizdate,Bill.FAuditTime,Bill.FNumber,Bill.FSeqNum");
        return sql;
    }

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    private void writeEndCostComputeReport(Context ctx, String strCalType, PeriodInfo periodInfo, HashMap calMap, RptRowSet rsMaterial, CalculateParams params, HashMap exceptMap, PreparedStatement rptPs) throws SQLException, EASBizException, BOSException {
        RecentCostInfo tempbill = new RecentCostInfo();
        tempbill.setString("FMaterialID", rsMaterial.getString("FMaterialID"));
        tempbill.setString("FCompanyOrgUnitID", rsMaterial.getString("FCompanyOrgUnitID"));
        tempbill.setInt("FPricePrecision", rsMaterial.getInt("FPricePrecision"));
        String[] idName = new String[]{"FCompanyOrgUnitID", "FStorageOrgUnitId", "FWarehouseId"};
        boolean isWriteExrpt = params.getBoolean("ISWRITEDEXPCOSTRPT");
        Iterator it = calMap.entrySet().iterator();
        ArrayList listInBill = null;
        int isExceptionState = 1;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            String[] orgId = key.split("_[$]{4}_");
            for (int i = 0; i < orgId.length; ++i) {
                tempbill.setString(idName[i], orgId[i]);
            }
            listInBill = (ArrayList)entry.getValue();
            isExceptionState = exceptMap != null && exceptMap.containsKey(key) ? 2 : 1;
            if (isWriteExrpt && isExceptionState != 2) continue;
            this.computeReportOutAndInWarehouseDetailInfo2(ctx, rptPs, tempbill, listInBill, periodInfo, 3, isExceptionState, params.getString("headerid"));
        }
        if (this.costReportCount >= 500) {
            rptPs.executeBatch();
            rptPs.clearBatch();
            this.costReportCount = 0;
        }
    }

    @Override
    protected void adjustPrePeriodData(Connection conn, CalculateParams params, PeriodInfo periodInfo, String tempTableFIFOBills) throws BOSException, SQLException {
        LowTimer tt = new LowTimer();
        this.updateCombitionRetBill(conn, params, tempTableFIFOBills);
        logger.debug((Object)("\u5904\u7406\u671f\u9000\u8d27\u5355\u4e0e\u539f\u5355\u7684\u6570\u91cf\u4e0e\u91d1\u989d\u505a\u4e3a\u4e00\u7b14\u5f71\u54cd\u7ed3\u5b58(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateCostAdjustBillDate(tempTableFIFOBills, periodInfo));
        logger.debug((Object)("\u66f4\u65b0\u6210\u672c\u8c03\u6574\u5355\u65e5\u671f\u4e3a\u5f53\u671f\u7b2c\u4e00\u5929(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpdateCombitionBizDateSQL(tempTableFIFOBills));
        logger.debug((Object)("\u66f4\u5408\u5e76\u7684\u6e90\u5355\u7684\u4e1a\u52a1\u671f\u5230\u4e0b\u6e38\u5355\u636e\u4e0a\u6765(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateMaterialReqPriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9886\u6599\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateSaleIssuePriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9500\u552e\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateCostMoveIssueFromPrePeriod(tempTableFIFOBills, periodInfo));
        logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u51fa\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(conn, this.getUpateCostMoveInFromPrePeriod(tempTableFIFOBills, periodInfo));
        logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u5165\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
    }

    private HashMap getCombitionMap(Context ctx, ArrayList list) {
        RecentCostInfo bill = null;
        RecentCostInfo currBill = null;
        HashMap<String, RecentCostInfo> combtionMap = new HashMap<String, RecentCostInfo>();
        String keyId = null;
        for (int i = 0; i < list.size(); ++i) {
            currBill = (RecentCostInfo)list.get(i);
            keyId = currBill.getString("FkeyID");
            if (!combtionMap.containsKey(keyId)) {
                bill = (RecentCostInfo)currBill.clone();
                bill.setRecentCost(CalculateUtil.ZERO);
                bill.setRecentQty(CalculateUtil.ZERO);
                bill.setInt("FCalculateKind", 0);
                bill.setString("FNumber", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COMBITIONCOSTAJDJUST", (Context)ctx));
                combtionMap.put(keyId, bill);
            } else {
                bill = (RecentCostInfo)combtionMap.get(keyId);
            }
            bill.setRecentCost(bill.getRecentCost().add(currBill.getRecentCost()));
        }
        return combtionMap;
    }

    private void handleCombitionList(Context ctx, ArrayList listAllBill, Map calMap, ArrayList costAdjBillList) {
        HashMap combitionMap = this.getCombitionMap(ctx, costAdjBillList);
        Iterator it = combitionMap.keySet().iterator();
        String keyID = null;
        RecentCostInfo costBill = null;
        RecentCostInfo currInBill = null;
        ArrayList<Object> inBillList = null;
        int index = 0;
        for (index = 0; index < listAllBill.size() && 2 == (costBill = (RecentCostInfo)listAllBill.get(index)).getInt("FCalculateKind"); ++index) {
        }
        while (it.hasNext()) {
            keyID = (String)it.next();
            costBill = (RecentCostInfo)combitionMap.get(keyID);
            inBillList = (ArrayList<Object>)calMap.get(keyID);
            for (int i = 0; inBillList != null && i < inBillList.size(); ++i) {
                currInBill = (RecentCostInfo)inBillList.get(i);
                if (2 != currInBill.getInt("FCalculateKind")) {
                    inBillList.add(i, costBill.clone());
                    listAllBill.add(index++, costBill);
                    break;
                }
                if (2 != currInBill.getInt("FCalculateKind") || i != inBillList.size() - 1) continue;
                inBillList.add(costBill.clone());
                listAllBill.add(index++, costBill);
                break;
            }
            if (inBillList != null) continue;
            inBillList = new ArrayList<Object>();
            inBillList.add(costBill.clone());
            calMap.put(keyID, inBillList);
        }
    }

    private void writeExpCostRpt(Context ctx, CalculateParams params, PeriodInfo periodInfo, RptRowSet rsMaterial, PreparedStatement rptPs) throws BOSException {
        String companyOrgID = params.getString("COMPANY_ID");
        String storageOrgBegID = "";
        String warehouseBegID = "";
        String msg = ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"257_FailCalculate", (Locale)ctx.getLocale());
        try {
            CostComputeHelp.addCostComputerReportBatch(ctx, rptPs, periodInfo, rsMaterial.getString("FmaterialNumber"), companyOrgID, storageOrgBegID, warehouseBegID, null, null, null, msg, msg, "2900-01-01 00:00:00.000", 0L, this.takeMaterialAccountType()[0], 0, params.getString("headerid"), "", false);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"256_FailWriteCost", (Locale)ctx.getLocale()));
        }
    }

    private HashMap getPriceMap(HashMap map) {
        HashMap<String, RecentCostInfo> tmpMap = new HashMap<String, RecentCostInfo>();
        if ("1".equals(this.writeCostType)) {
            for (String key : map.keySet()) {
                ArrayList periodBeginInList = (ArrayList)map.get(key);
                if (periodBeginInList == null || periodBeginInList.size() == 0) continue;
                RecentCostInfo recentCost = (RecentCostInfo)periodBeginInList.get(0);
                recentCost = (RecentCostInfo)recentCost.clone();
                for (int i = 1; i < periodBeginInList.size(); ++i) {
                    RecentCostInfo recentCostTmp = (RecentCostInfo)periodBeginInList.get(i);
                    recentCost.setRecentCost(recentCost.getRecentCost().add(recentCostTmp.getRecentCost()));
                    recentCost.setRecentQty(recentCost.getRecentQty().add(recentCostTmp.getRecentQty()));
                }
                RecentCostHelp.calculateAvgPrice(recentCost);
                tmpMap.put(key, recentCost);
            }
        }
        return tmpMap;
    }

    protected void synCostMovePriceToInList(HashMap costMoveMap, HashMap calMap, RecentCostInfo bill) {
        if (bill.isCostPriceMove()) {
            RecentCostInfo costMoveObj = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
            RecentCostInfo tempBill = null;
            RecentCostInfo moveBill = null;
            ArrayList moveInBill = costMoveObj.getMoveInbillList();
            for (int j = 0; moveInBill != null && j < moveInBill.size(); ++j) {
                moveBill = (RecentCostInfo)moveInBill.get(j);
                List inListBill = (List)calMap.get(moveBill.getString("FkeyID"));
                for (int i = 0; inListBill != null && i < inListBill.size(); ++i) {
                    tempBill = (RecentCostInfo)inListBill.get(i);
                    if (!tempBill.getString("FBillEntryId").equals(moveBill.getString("FBillEntryId"))) continue;
                    tempBill.setRecentCost(moveBill.getRecentCost());
                    tempBill.setPrice(moveBill.getPrice());
                    if (!tempBill.isDealComplete()) {
                        tempBill.setPriceSource(PriceSourEnum.costMove);
                    }
                    tempBill.setSynData(true);
                }
            }
        }
    }

    protected void synCostMovePriceToInList(HashMap calMap, RecentCostInfo bill) {
        RecentCostInfo tempBill = null;
        List inListBill = (List)calMap.get(bill.getString("FkeyID"));
        for (int i = 0; inListBill != null && i < inListBill.size(); ++i) {
            tempBill = (RecentCostInfo)inListBill.get(i);
            if (!tempBill.getString("FBillEntryId").equals(bill.getString("FBillEntryId"))) continue;
            tempBill.setRecentCost(bill.getRecentCost());
            tempBill.setPrice(bill.getPrice());
            if (!tempBill.isDealComplete()) {
                tempBill.setPriceSource(PriceSourEnum.costMove);
            }
            tempBill.setSynData(true);
        }
    }

    @Override
    protected void synCostMovePriceBill(HashMap costMoveMap, RecentCostInfo bill) throws CalculateException {
        if (bill.isCostPriceMove()) {
            RecentCostInfo costMoveObj = (RecentCostInfo)costMoveMap.get(bill.getStockTransBillEntryID());
            boolean isMoveInbill = false;
            if (bill.isMoveInBill()) {
                isMoveInbill = true;
            }
            if (!isMoveInbill) {
                RecentCostInfo moveCostBill = null;
                ArrayList moveCostList = costMoveObj.getMoveOutbillList();
                for (int i = 0; i < moveCostList.size(); ++i) {
                    moveCostBill = (RecentCostInfo)moveCostList.get(i);
                    if (moveCostBill.getString("FBillEntryId").equals(bill.getString("FBillEntryId"))) {
                        moveCostBill.setRecentCost(bill.getRecentCost());
                        moveCostBill.setPrice(bill.getPrice());
                        bill.setNeedUpdate(true);
                    }
                    if (moveCostBill.isDealComplete() || moveCostBill.isNeedUpdate()) continue;
                    return;
                }
            }
            this.calCostMoveBill(costMoveObj, bill, isMoveInbill);
        }
    }

    protected void synListInBill(List listInBill, RecentCostInfo bill, String strCalType) {
        if (bill.isNeedUpdate()) {
            RecentCostInfo InBill = null;
            for (int i = 0; i < listInBill.size(); ++i) {
                InBill = (RecentCostInfo)listInBill.get(i);
                if (InBill.isHasSynData() || !InBill.getString("FBillEntryId").equals(bill.getString("FBillEntryId"))) continue;
                InBill.setRecentCost(bill.getRecentCost());
                InBill.setPrice(bill.getPrice());
                InBill.setRecentQty(bill.getRecentQty());
                if (!bill.isRedBill() || bill.getInt("FisSrcBilInCurrPid") == 1 || !RecentCostHelp.isEffectBalance(bill, strCalType)) break;
                InBill.setRecentCost(bill.getRecentCost().multiply(CalculateUtil.ONE_MINUS));
                InBill.setRecentQty(bill.getRecentQty().multiply(CalculateUtil.ONE_MINUS));
                break;
            }
        }
    }

    protected void calMatAttrChangeCost(List needUpdatedBills, Map matAttrChgMap) {
        RecentCostInfo info = null;
        for (Map.Entry entry : matAttrChgMap.entrySet()) {
            AbstractCalculateCost.MatAttrChangeVO vo = (AbstractCalculateCost.MatAttrChangeVO)entry.getValue();
            vo.calculateCost();
            for (int i = 0; i < vo.getInBillCount(); ++i) {
                info = vo.getInBill(i);
                if (info == null || info.getInt("FFiVouchered") != 0) continue;
                needUpdatedBills.add(info);
            }
        }
    }

    private void getFifoBalance(HashMap balanceMap, ArrayList listInBill, ArrayList listPayout, String fKey) {
        BalanceCostInfo balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(fKey));
        RecentCostInfo resultInfo = null;
        RecentCostInfo tempInfo = null;
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        if (balanceCostInfo != null) {
            resultInfo = balanceCostInfo.getReusltBillInfo();
            totalQty = resultInfo.getRecentQty();
            totalAmount = resultInfo.getRecentCost();
        } else {
            balanceCostInfo = new BalanceCostInfo();
            resultInfo = new RecentCostInfo();
            if (listInBill != null && listInBill.size() > 0) {
                for (int i = 0; i < listInBill.size(); ++i) {
                    tempInfo = (RecentCostInfo)listInBill.get(i);
                    totalQty = totalQty.add(tempInfo.getRecentQty());
                    totalAmount = totalAmount.add(tempInfo.getRecentCost());
                }
            }
        }
        resultInfo.setRecentQty(totalQty);
        resultInfo.setRecentCost(totalAmount);
        balanceCostInfo.setReusltBillInfo(resultInfo);
        balanceMap.put(fKey, balanceCostInfo);
    }

    class CalculateThreadForFIFO
    implements Runnable {
        Context ctx;
        CalculateParams params;
        SysTempTableHelper sysTempTableHelper;
        Connection conn;
        String materialSql;
        PeriodInfo periodInfo;
        int startIndex = 0;

        public CalculateThreadForFIFO(Context ctx, Connection conn, CalculateParams params, int startIndex, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper, String materialSql) {
            this.ctx = ctx;
            try {
                this.params = (CalculateParams)params.clone();
            }
            catch (CloneNotSupportedException e) {
                FIFOCalculateNew.this.ExceptionList.add(e);
            }
            this.sysTempTableHelper = sysTempTableHelper;
            this.conn = conn;
            this.materialSql = materialSql;
            this.periodInfo = periodInfo;
            this.startIndex = startIndex;
        }

        @Override
        public void run() {
            try {
                this.asynCalculate();
            }
            catch (Exception e) {
                FIFOCalculateNew.this.ExceptionList.add(e);
                logger.info((Object)e);
            }
            finally {
                FIFOCalculateNew.this.countDown.countDown();
            }
        }

        private void asynCalculate() throws BOSException, SQLException {
            UpdateBillCostHelper updateBillCostHelper = new UpdateBillCostHelper(this.conn);
            PreparedStatement rptPs = this.conn.prepareStatement(CostComputeHelp.getCreateCostComputeReportSQL());
            StringBuffer querySql = new StringBuffer();
            querySql.append(this.materialSql).append(" where ksql_seq > ").append(this.startIndex).append(" and ksql_seq <= ").append(1000 + this.startIndex);
            RptRowSet rsMaterial = DBUtils.executeQuery((String)querySql.toString(), (Connection)this.conn);
            try {
                while (rsMaterial.next()) {
                    try {
                        FIFOCalculateNew.this.fifoCalculate(this.ctx, this.conn, this.params, rsMaterial, this.params.getString("CALTYPE"), this.periodInfo, rptPs);
                        updateBillCostHelper.updateBills((List)this.params.getObject("updateBillSQL"), new HashMap());
                    }
                    catch (Exception e) {
                        FIFOCalculateNew.this.writeExpCostRpt(this.ctx, this.params, this.periodInfo, rsMaterial, rptPs);
                        logger.error((Object)("deal material failed:" + rsMaterial.getString("FmaterialNumber") + " \u5931\u8d25."));
                        logger.error((Object)e);
                        FIFOCalculateNew.this.ExceptionList.add(e);
                    }
                }
                updateBillCostHelper.executeBatch(true);
                FIFOCalculateNew.this.executePsBatch(rptPs);
            }
            catch (Exception e) {
                FIFOCalculateNew.this.ExceptionList.add(e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Statement)rptPs);
            }
        }
    }
}

