/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.barcode.scm.util.ResourceUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.TransactionTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.cal.InpWarehsSumCalculateCollection;
import com.kingdee.eas.scm.cal.InpWarehsSumCalculateInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.help.InventoryBillHelp;
import com.kingdee.eas.scm.cal.app.help.WriteOffHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class InpWarehsSumCalculate
extends AbstractCalculateCost {
    private static Logger logger = Logger.getLogger(InpWarehsSumCalculate.class);
    private int billType = 0;

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        String name = this.getClass().getName().replaceAll(this.getClass().getPackage().getName(), "");
        name = name.replace('.', ' ');
        return name.trim();
    }

    @Override
    protected AccountType[] takeMaterialAccountType() {
        List it = AccountType.getEnumList();
        AccountType[] type = new AccountType[it.size() - 1];
        int j = 0;
        for (int i = 0; i < it.size(); ++i) {
            if (AccountType.MOVE_ADD_AVERAGE.equals((Object)((AccountType)it.get(i)))) continue;
            type[j] = (AccountType)it.get(i);
            ++j;
        }
        return type;
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        InpWarehsSumCalculateCollection collection = (InpWarehsSumCalculateCollection)((Object)params.getObject("ENTRYCOLL"));
        if (collection == null || collection.size() == 0) {
            return false;
        }
        int cal_sum_condition = params.getInt("SUMCONDITION");
        this.setBillTypeNumber(params.getString("BILLTYPE"));
        this.setInpWarehsSum(true);
        params.setObject("SysTempTableHelper", (Object)sysTempTableHelper);
        String detailTableName = params.getString("DETAILTEMPTABLE");
        if (detailTableName == null) {
            return false;
        }
        sysTempTableHelper.analyzeTable(detailTableName);
        ArrayList<String> sqlList = new ArrayList<String>();
        InpWarehsSumCalculateInfo entry = null;
        for (int i = 0; i < collection.size(); ++i) {
            entry = collection.get(i);
            String sql = this.updateTemp(ctx, entry, detailTableName);
            if (sql == null) continue;
            sqlList.add(sql);
        }
        sysTempTableHelper.execute(sqlList);
        String[] updateTableName = this.getUpdteTableName();
        if (updateTableName == null || updateTableName[0] == null || updateTableName[1] == null) {
            return false;
        }
        if ("103".equals(params.getString("BILLTYPE"))) {
            String tempPurinwarehData = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getPurInwarehsTempFields());
            this.getPurInwarehsHistoryData(params, tempPurinwarehData, updateTableName[0], sysTempTableHelper);
            params.setString("T_Temp_PurinwarehData", tempPurinwarehData);
        }
        sysTempTableHelper.execute(this.updateMaterialMantissaAmount(detailTableName, cal_sum_condition, periodInfo, params).toString());
        sysTempTableHelper.execute(this.updateMantissaAmt(detailTableName));
        sysTempTableHelper.execute(this.updateDiffActualAndPrice(detailTableName));
        sysTempTableHelper.execute(this.updateBillsPriceSQL(updateTableName[0], detailTableName, cal_sum_condition, periodInfo, params).toString());
        if ("102".equals(params.getString("BILLTYPE"))) {
            this.createTmpeTable(ctx, params, sysTempTableHelper);
            InpWarehsSumCalculate.getSaleResultSetByTempTab(ctx, detailTableName, params);
            String tempSaleIssueTableName = params.getString("T_Temp_SaleIssueWriteoffRecord");
            this.handleOtherDataForExpBillQuery(ctx, sysTempTableHelper, params, periodInfo, tempSaleIssueTableName);
            sysTempTableHelper.releaseTempTable(tempSaleIssueTableName);
            sysTempTableHelper.releaseTempTable(params.getString("T_Temp_WriteOffTable"));
        }
        if ("103".equals(params.getString("BILLTYPE"))) {
            int localCurrPrecesion = params.getInt("Local_Currency_Presision");
            CalculateUtil.inpSumUpdatePurInfo(ctx, detailTableName, cal_sum_condition, periodInfo, localCurrPrecesion, params);
        }
        if ("104".equals(params.getString("BILLTYPE"))) {
            StringBuffer querysql = new StringBuffer();
            ArrayList<String> entryIDList = new ArrayList<String>();
            querysql.append("    SELECT b.fid as fid  FROM T_IM_MATERIALREQBILL a  ");
            querysql.append(" \n inner join T_IM_MATERIALREQBILLENTRY b on a.fid = b.FPARENTID ");
            querysql.append(" \n inner join ").append(detailTableName).append(" c on b.fid = c.fentryID");
            querysql.append(" \n where a.FPURCHASETYPE = 1 and c.FBillTypeId ='");
            querysql.append("50957179-0105-1000-e000-0163c0a812fd463ED552").append("'");
            IRowSet rs = sysTempTableHelper.executeQuery(querysql.toString());
            try {
                while (rs.next()) {
                    entryIDList.add(rs.getString("fid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (entryIDList != null && entryIDList.size() > 0) {
                WriteOffHelp.updDevWritRecordOnMatreqCostChange(ctx, entryIDList);
            }
        }
        this.writeLog(ctx, detailTableName);
        return true;
    }

    private void getPurInwarehsHistoryData(CalculateParams params, String tempPurinwarehData, String billEntry, SysTempTableHelper sysTempTableHelper) throws BOSException {
        String detailTableName = params.getString("DETAILTEMPTABLE");
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tempPurinwarehData);
        sql.append(" SELECT entry.Fid, entry.FActualCost, entry.FUnitActualCost,");
        sql.append(" entry.FWrittenOffAmount,entry.FUnWriteOffAmount ");
        sql.append(" FROM ").append(billEntry).append(" AS entry ");
        sql.append(" where entry.fid in ( select FEntryID from " + detailTableName + " ) ");
        sysTempTableHelper.execute(sql.toString());
    }

    private String updateMantissaAmt(String tempTable) {
        StringBuffer sb = new StringBuffer();
        sb.append(" update ").append(tempTable).append(" set FMantissaAmt =  0  where FEntryID not in ( ");
        sb.append("  select max (FEntryID) from ").append(tempTable).append(" group by FGatherID ");
        sb.append(" )");
        return sb.toString();
    }

    private String updateDiffActualAndPrice(String detailTempTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("update ").append(detailTempTable).append(" set ");
        sb.append("FActualCost = FActualCost + FMantissaAmt, ");
        sb.append("FActualBaseUnitCost = Round((FActualCost + FMantissaAmt) / FBaseQty, 8) ");
        sb.append("where FMantissaAmt <> 0");
        return sb.toString();
    }

    public static void getSaleResultSetByTempTab(Context ctx, String tempTableName, CalculateParams params) throws BOSException {
        if (tempTableName == null || "".equals(tempTableName)) {
            return;
        }
        SysTempTableHelper sysTempTableHelper = (SysTempTableHelper)params.getObject("SysTempTableHelper");
        String tempSaleIssueTableName = params.getString("T_Temp_SaleIssueWriteoffRecord");
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Insert into ").append(tempSaleIssueTableName).append("(FBillEntryID, FBillID)");
        sSQL.append("Select entry.FID, entry.FParentId ");
        sSQL.append("from T_IM_SaleIssueEntry entry, ").append(tempTableName).append(" temp ");
        sSQL.append(" where entry.fid = temp.FEntryID ");
        sysTempTableHelper.execute(sSQL.toString());
    }

    public String getSQLThisInpourBill(PeriodInfo periodInfo, String filterCalType, String extendFields, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(extendFields);
        sql.append(",ENTRY.FParentid,ENTRY.FId,").append("\t\n");
        sql.append(" case when (MATERIALCOMPANY.FAccountType = ").append(5).append(" and MATERIALCOMPANY.FIsLot = 1)").append(" then").append("  ENTRY.FLOT ELSE NULL END AS FLOT,").append("\t\n");
        sql.append(" case when (MATERIALCOMPANY.FAccountType = ").append(5).append(" and MATERIALCOMPANY.FIsAssistProperty = 1)").append(" then").append("  ENTRY.FAssistPropertyID ELSE NULL END AS FAssistPropertyID,").append("\t\n");
        sql.append(" case when (MATERIALCOMPANY.FAccountType = ").append(5).append(" and MATERIALCOMPANY.FIsProject = 1 and MATERIALINVENTORY.FIsProjectNumber = 1)").append(" then").append("  ENTRY.FProjectID ELSE NULL END AS FProjectID,").append("\t\n");
        sql.append(" case when (MATERIALCOMPANY.FAccountType = ").append(5).append(" and MATERIALCOMPANY.FIsTrackNumber = 1 and MATERIALINVENTORY.FIsTrackingNumber = 1)").append(" then").append("  ENTRY.FTrackNumberID ELSE NULL END AS FTrackNumberID ").append("\t\n");
        String tempFields = sql.toString();
        sql.setLength(0);
        sql.append(this.getSQLInpourBill(periodInfo, filterCalType, tempFields, params));
        if ("103".equals(this.getBillTypeNumber())) {
            sql.append("\n AND  ENTRY.FWrittenOffQty = 0");
        }
        return sql.toString();
    }

    @Override
    protected String getReverseBillCondition() {
        StringBuffer sql = new StringBuffer();
        sql.append(" And ISNULL(BILL.FISREVERSED,0) = 0 ");
        return sql.toString();
    }

    private String updateMaterialMantissaAmount(String tempTableName, int cal_sum_conditino, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(tempTableName).append(" AS T ");
        sql.append(" SET (FMantissaAmt");
        sql.append(" ) = ( ");
        sql.append("  select MantissaAmt from ( ");
        sql.append("  select MantissaAmt,FGatherID from ( ");
        sql.append(" select max(temp.FGatherActualCost)- sum(temp.FActualCost)  as MantissaAmt,FGatherID from  ");
        sql.append(tempTableName).append(" as temp group by FGatherID  ");
        sql.append("   ) t1 ) t2  ");
        sql.append(" where t.FGatherID = t2.FGatherID ) ");
        return sql.toString();
    }

    private Object updateBillsPriceSQL(String billEntry, String tempTableName, int cal_sum_conditino, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET (FActualCost,FUnitActualCost");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry) || this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FWrittenOffAmount,FUnWriteOffAmount");
        }
        if (this.issueTableArray[2][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,FSCWrittenOffAmount,FSCUnWrittenOffAmount");
        }
        sql.append(" ) = ( ");
        sql.append(" SELECT ");
        sql.append("  ROUND(TempT.FActualCost,TempT.FLocalCurrencyPrecision) ");
        sql.append(" ,case ");
        sql.append("  when Entry.FUNITID = Entry.FBASEUNITID then ").append("\t\n");
        sql.append("     ROUND(TempT.FActualBaseUnitCost,TempT.FPricePrecision)").append("\t\n");
        sql.append("  else (case when Entry.FQty = 0 then 0 else ");
        sql.append("     ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE("ROUND(" + CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FbaseQty") + ",TempT.FLocalCurrencyPrecision) / Entry.FQty")).append(",TempT.FPricePrecision)");
        sql.append("  end) end ");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry) || this.issueTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FWrittenOffBaseQty")).append(",TempT.FLocalCurrencyPrecision)");
            sql.append(" ,ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FbaseQty")).append(",TempT.FLocalCurrencyPrecision) - ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FWrittenOffBaseQty")).append(",TempT.FLocalCurrencyPrecision)");
        }
        if (this.issueTableArray[2][0].equalsIgnoreCase(billEntry)) {
            sql.append(" ,ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FSubWrittenOffBaseQty")).append(",TempT.FLocalCurrencyPrecision)");
            sql.append(" ,ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FbaseQty")).append(",TempT.FLocalCurrencyPrecision) - ROUND(").append(CalculateUtil.TO_DECIMAL_SUM("TempT.FActualBaseUnitCost * Entry.FSubWrittenOffBaseQty")).append(",TempT.FLocalCurrencyPrecision)");
        }
        sql.append(" FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" on entry.fid = TempT.FEntryID ");
        sql.append(" where T.FID = Entry.FID");
        sql.append(")");
        return sql.toString();
    }

    private String updateBillsFlagSQL(String billEntry, String tempTableName) {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE ").append(billEntry).append(" AS T ");
        sql.append(" SET FIsGenCalFlag =0");
        sql.append(" WHERE EXISTS(");
        sql.append(" SELECT 1 FROM ").append(billEntry).append(" Entry ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" on entry.fid = TempT.FEntryID ");
        sql.append(" where T.FID = Entry.FID");
        sql.append(" )");
        return sql.toString();
    }

    private String updateTemp(Context ctx, InpWarehsSumCalculateInfo entry, String tempTableName) {
        if (entry.getActualBaseUnitCost() == null || entry.getActualCost() == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTableName);
        sql.append(" set ");
        sql.append(" FActualBaseUnitCost = ").append(StringUtil.toString((BigDecimal)entry.getActualBaseUnitCost().setScale(entry.getPricePrecision(), 4)));
        sql.append(",FActualCost = round(").append(StringUtil.toString((BigDecimal)entry.getActualBaseUnitCost().setScale(entry.getPricePrecision(), 4))).append(" * FBaseQty,FLocalCurrencyPrecision ) ");
        sql.append(",FGatherActualCost =").append(StringUtil.toString((BigDecimal)entry.getActualCost().setScale(entry.getLocalCurrencyPrecision(), 4)));
        sql.append(",FMantissaAmt = 0");
        sql.append(",FLastBillEntryID=' '");
        sql.append(" WHERE FGatherID = '").append(entry.getRecordID()).append("'");
        return sql.toString();
    }

    protected StringBuffer getCostCenterFieldSQL() {
        StringBuffer fields = new StringBuffer();
        if ("104".equals(this.getBillTypeNumber()) || "105".equals(this.getBillTypeNumber())) {
            fields.append(" ENTRY.FCostCenterOrgUnitID ");
        } else {
            fields.append(" BILL.FCostCenterOrgUnitID ");
        }
        return fields;
    }

    protected StringBuffer getAdminOrgUnitFieldSQL() {
        StringBuffer fields = new StringBuffer();
        if ("104".equals(this.getBillTypeNumber()) || "105".equals(this.getBillTypeNumber())) {
            fields.append(" ENTRY.FAdminOrgUnitID ");
        } else {
            fields.append(" BILL.FAdminOrgUnitID ");
        }
        return fields;
    }

    public String getBillDetailRecordSQLNew(Context ctx, PeriodInfo periodInfo, CalculateParams params) {
        this.setBillTypeNumber(params.getString("BILLTYPE"));
        this.setInpWarehsSum(true);
        StringBuffer fields = new StringBuffer();
        fields.append(" Bill.FIsReversed");
        fields.append(",SCMTRANSACTIONTYPE.FNumber AS TRANSACTIONTYPEFNumber").append("\t\n");
        fields.append(",").append(this.getAdminOrgUnitFieldSQL()).append(" AS FAdminOrgUnitID");
        if (null != params && params.getInt("SUMCONDITION") == 4) {
            fields.append(",").append(this.getCostCenterFieldSQL()).append(" as FCostCenterOrgUnitID");
        } else {
            fields.append(",'' as FCostCenterOrgUnitID");
        }
        fields.append(",ENTRY.FWrittenOffQty");
        fields.append(",ENTRY.FReverseQty").append("\t\n");
        fields.append(",MATERIAL.FID AS MATERIALFID");
        fields.append(",MATERIAL.FBaseUnit AS MATERIALFBaseUnit").append("\t\n");
        fields.append(",MATERIAL.FPricePrecision AS FPricePrecision");
        fields.append(",MATERIAL.FNumber AS MATERIALFNumber").append("\t\n");
        fields.append(",MATERIAL.FModel AS MATERIALFModel").append("\t\n");
        fields.append(",MATERIAL.FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()) + " AS MATERIALFName");
        fields.append(",MATERIALCOMPANY.FAccountType");
        String sqlThisInpourBill = this.getSQLThisInpourBill(periodInfo, null, fields.toString(), params);
        return this.getBillDetailRecordSQL(params, sqlThisInpourBill);
    }

    public String getInpWarehsSumBillNew(Context ctx, PeriodInfo periodInfo, CalculateParams params, String detailTableName) {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        String storage = "' '";
        if (params != null && params.getInt("SUMCONDITION") == 1) {
            storage = "FSTORAGEORGUNITID";
        }
        String warehouse = "' '";
        if (null != params && params.getInt("SUMCONDITION") == 2) {
            storage = "FSTORAGEORGUNITID";
            warehouse = "FWarehouseID";
        }
        String dept = "' '";
        if (params != null && params.getInt("SUMCONDITION") == 3) {
            dept = "FAdminOrgUnitID";
        }
        String costCenter = "' '";
        if (null != params && params.getInt("SUMCONDITION") == 4) {
            costCenter = "FCostCenterOrgUnitID";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newbosid('clreport') as FID");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' AS FCreatorID");
        sql.append(" ,TO_DATE('").append(sdf.format(new Date())).append("') AS FCreateTime");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("' AS FLastUpdateUserID");
        sql.append(" ,TO_DATE('").append(sdf.format(new Date())).append("') AS FLastUpdateTime");
        sql.append(" ,'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("' AS FControlUnitID");
        sql.append(" ,FBASEQTY AS FBASEQTY");
        sql.append(" ,Case when FBASEQTY=0 then 0 else ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE("FActualCost/FBASEQTY")).append(",FPricePrecision) end AS FPrice");
        sql.append(" ,FActualCost AS FActualCost").append("\t\n");
        sql.append(" ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sql.append(" ,FPricePrecision");
        sql.append(" ,").append(Local_Currency_Presision).append(" AS FLocalCurrencyPrecision").append("\t\n");
        sql.append(" ,").append(storage).append(" AS FSTORAGEORGUNITID");
        sql.append(" ,").append(warehouse).append(" AS FWarehouseID");
        sql.append(" ,").append(dept).append(" AS FAdminOrgUnitID");
        sql.append(" ,").append(costCenter).append(" AS FCostCenterOrgUnitID");
        sql.append(" , entry.FMaterialID");
        sql.append(" ,FCompanyOrgUnitID");
        sql.append(" ,0 AS FMantissaAmt,' ' AS FLastBillEntryID").append("\t\n");
        sql.append(" ,ENTRY.FLot AS FLot").append("\t\n");
        sql.append(" ,ENTRY.FAccountType AS FAccountType").append("\t\n");
        sql.append(" ,ENTRY.FAssistPropertyID AS FAssistPropertyID").append("\t\n");
        sql.append(" ,ENTRY.FProjectID AS FProjectID").append("\t\n");
        sql.append(" ,ENTRY.FTrackNumberID AS FTrackNumberID").append("\t\n");
        sql.append(" FROM (").append("\t\n");
        sql.append(" SELECT ").append("\t\n");
        sql.append("  FMaterialID,FMaterialNumber,FMaterialName,FMaterialModel,FMaterialBaseUnitID,FCompanyOrgUnitID").append("\t\n");
        sql.append(" ,").append(storage).append(" AS FSTORAGEORGUNITID");
        sql.append(" ,").append(warehouse).append(" AS FWarehouseID");
        sql.append(" ,").append(dept).append(" AS FAdminOrgUnitID");
        sql.append(" ,").append(costCenter).append(" AS FCostCenterOrgUnitID");
        sql.append(" ,").append(CalculateUtil.TO_DECIMAL_DIVIDE("SUM(FBASEQTY)")).append(" AS FBASEQTY");
        if (!this.isDb2(ctx)) {
            sql.append(" ,").append(CalculateUtil.TO_DECIMAL_AMTForOracle("SUM(FActualCost)")).append(" AS FActualCost");
        } else {
            sql.append(" ,").append(CalculateUtil.TO_DECIMAL_DIVIDE("SUM(FActualCost)")).append(" AS FActualCost");
        }
        sql.append(" ,max(FPricePrecision) AS FPricePrecision").append("\t\n");
        sql.append(" ,FLot AS FLot").append("\t\n");
        sql.append(" ,FAccountType AS FAccountType").append("\t\n");
        sql.append(" ,FAssistPropertyID AS FAssistPropertyID").append("\t\n");
        sql.append(" ,FProjectID AS FProjectID").append("\t\n");
        sql.append(" ,FTrackNumberID AS FTrackNumberID").append("\t\n");
        sql.append(" FROM ").append(detailTableName).append(" ALLENTRY").append("\t\n");
        sql.append("  GROUP BY ALLENTRY.FCompanyOrgUnitID,ALLENTRY.FMaterialID,ALLENTRY.FMaterialBaseUnitID\t").append("\t\n");
        sql.append(",ALLENTRY.FMaterialNumber,ALLENTRY.FMaterialName,ALLENTRY.FMaterialModel").append("\t\n");
        if (params != null && params.getInt("SUMCONDITION") == 1) {
            sql.append(",ALLENTRY.FSTORAGEORGUNITID");
        }
        if (params != null && params.getInt("SUMCONDITION") == 2) {
            sql.append(",ALLENTRY.FSTORAGEORGUNITID");
            sql.append(",ALLENTRY.FWarehouseID");
        }
        if (params != null && params.getInt("SUMCONDITION") == 3) {
            sql.append(",ALLENTRY.FAdminOrgUnitID");
        }
        if (params != null && params.getInt("SUMCONDITION") == 4) {
            sql.append(",ALLENTRY.FCostCenterOrgUnitID");
        }
        sql.append(",ALLENTRY.FLot,ALLENTRY.FAccountType,ALLENTRY.FAssistPropertyID,ALLENTRY.FProjectID,ALLENTRY.FTrackNumberID");
        sql.append(" ) ENTRY").append("\t\n");
        sql.append(" LEFT OUTER JOIN t_bd_MultiMeasureUnit MeasureUnitBase").append("\t\n");
        sql.append(" ON (Entry.FMaterialID = MeasureUnitBase.FMaterialid");
        sql.append(" AND  Entry.FMaterialBaseUnitID = MeasureUnitBase.FMeasureUnitID )");
        return sql.toString();
    }

    public String getInpWarehsSumBill(Context ctx, PeriodInfo periodInfo, CalculateParams params) {
        int Local_Currency_Presision = params.getInt("Local_Currency_Presision");
        this.setBillTypeNumber(params.getString("BILLTYPE"));
        this.setInpWarehsSum(true);
        String storage = "' '";
        if (params != null && params.getInt("SUMCONDITION") == 1) {
            storage = "FSTORAGEORGUNITID";
        }
        String warehouse = "' '";
        if (null != params && params.getInt("SUMCONDITION") == 2) {
            storage = "FSTORAGEORGUNITID";
            warehouse = "FWarehouseID";
        }
        String dept = "' '";
        if (params != null && params.getInt("SUMCONDITION") == 3) {
            dept = "FAdminOrgUnitID";
        }
        String costCenter = "' '";
        if (null != params && params.getInt("SUMCONDITION") == 4) {
            costCenter = "FCostCenterOrgUnitID";
        }
        StringBuffer fields = new StringBuffer();
        fields.append(" Bill.FIsReversed");
        fields.append(",SCMTRANSACTIONTYPE.FNumber AS TRANSACTIONTYPEFNumber").append("\t\n");
        fields.append(",").append(this.getAdminOrgUnitFieldSQL()).append(" AS FAdminOrgUnitID");
        if (null != params && params.getInt("SUMCONDITION") == 4) {
            fields.append(",").append(this.getCostCenterFieldSQL()).append(" as FCostCenterOrgUnitID");
        }
        fields.append(",ENTRY.FWrittenOffQty");
        fields.append(",ENTRY.FReverseQty").append("\t\n");
        fields.append(",MATERIAL.FID AS MATERIALFID");
        fields.append(",MATERIAL.FBaseUnit AS MATERIALFBaseUnit").append("\t\n");
        fields.append(",MATERIAL.FPricePrecision AS FPricePrecision");
        fields.append(",MATERIAL.FNumber AS MATERIALFNumber").append("\t\n");
        fields.append(",MATERIAL.FModel AS MATERIALFModel").append("\t\n");
        fields.append(",MATERIAL.FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale()) + " AS MATERIALFName");
        fields.append(",MATERIALCOMPANY.FAccountType");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.000");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT newbosid('clreport')");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId()).append("'");
        sql.append(" ,TO_DATE('").append(sdf.format(new Date())).append("')");
        sql.append(" ,'").append(ContextUtil.getCurrentCtrlUnit((Context)ctx) == null ? "" : ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(" ,FBASEQTY AS FBASEQTY");
        sql.append(" ,Case when FBASEQTY=0 then 0 else ROUND(").append(CalculateUtil.TO_DECIMAL_DIVIDE("FActualCost/FBASEQTY")).append(",FPricePrecision) end AS FPrice");
        sql.append(" ,FActualCost AS FActualCost").append("\t\n");
        sql.append(" ,MeasureUnitBase.FQtyPrecision AS FQtyPrecision");
        sql.append(" ,FPricePrecision");
        sql.append(" ,").append(Local_Currency_Presision).append(" AS localCurrcyPrecision").append("\t\n");
        sql.append(" ,").append(storage).append(" AS FSTORAGEORGUNITID");
        sql.append(" ,").append(warehouse).append(" AS FWarehouseID");
        sql.append(" ,").append(dept).append(" AS FAdminOrgUnitID");
        sql.append(" ,").append(costCenter).append(" AS FCostCenterOrgUnitID");
        sql.append(" ,MATERIALFID");
        sql.append(" ,FCompanyOrgUnitID");
        sql.append(" ,0 AS FMantissaAmt,' ' AS FLastBillEntryID").append("\t\n");
        sql.append(" ,ENTRY.FLot ").append("\t\n");
        sql.append(" ,ENTRY.FAccountType").append("\t\n");
        sql.append(" ,ENTRY.FAssistPropertyID").append("\t\n");
        sql.append(" ,ENTRY.FProjectID").append("\t\n");
        sql.append(" ,ENTRY.FTrackNumberID").append("\t\n");
        sql.append(" FROM (").append("\t\n");
        sql.append(" SELECT ").append("\t\n");
        sql.append("  MATERIALFID,MATERIALFNUMBER,MATERIALFName,MATERIALFModel,MATERIALFBaseUnit,FCompanyOrgUnitID").append("\t\n");
        sql.append(" ,").append(storage).append(" AS FSTORAGEORGUNITID");
        sql.append(" ,").append(warehouse).append(" AS FWarehouseID");
        sql.append(" ,").append(dept).append(" AS FAdminOrgUnitID");
        sql.append(" ,").append(costCenter).append(" AS FCostCenterOrgUnitID");
        sql.append(" ,").append(CalculateUtil.TO_DECIMAL_DIVIDE("SUM(FBASEQTY)")).append(" AS FBASEQTY");
        if (!this.isDb2(ctx)) {
            sql.append(" ,").append(CalculateUtil.TO_DECIMAL_AMTForOracle("SUM(FActualCost)")).append(" AS FActualCost");
        } else {
            sql.append(" ,").append(CalculateUtil.TO_DECIMAL_DIVIDE("SUM(FActualCost)")).append(" AS FActualCost");
        }
        sql.append(" ,max(FPricePrecision) AS FPricePrecision").append("\t\n");
        sql.append(" ,FLot AS FLot").append("\t\n");
        sql.append(" ,FAccountType AS FAccountType").append("\t\n");
        sql.append(" ,FAssistPropertyID AS FAssistPropertyID").append("\t\n");
        sql.append(" ,FProjectID AS FProjectID").append("\t\n");
        sql.append(" ,FTrackNumberID AS FTrackNumberID").append("\t\n");
        sql.append(" FROM (select temp.* from (").append("\t\n");
        String SQLThisInpourBill = this.getSQLThisInpourBill(periodInfo, null, fields.toString(), params);
        sql.append(SQLThisInpourBill);
        sql.append(") temp ");
        if (params.getBoolean("ckBxZeroPrice")) {
            sql.append(" where temp.FBaseUnitActualCost <= 0").append("\t\n");
        }
        sql.append(" ) ALLENTRY").append("\t\n");
        sql.append(" GROUP BY ALLENTRY.FCompanyOrgUnitID,ALLENTRY.MATERIALFID,ALLENTRY.MATERIALFBaseUnit").append("\t\n");
        sql.append(",ALLENTRY.MATERIALFNUMBER,ALLENTRY.MATERIALFName,ALLENTRY.MATERIALFModel").append("\t\n");
        if (params != null && params.getInt("SUMCONDITION") == 1) {
            sql.append(",ALLENTRY.FSTORAGEORGUNITID");
        }
        if (params != null && params.getInt("SUMCONDITION") == 2) {
            sql.append(",ALLENTRY.FSTORAGEORGUNITID");
            sql.append(",ALLENTRY.FWarehouseID");
        }
        if (params != null && params.getInt("SUMCONDITION") == 3) {
            sql.append(",ALLENTRY.FAdminOrgUnitID");
        }
        if (params != null && params.getInt("SUMCONDITION") == 4) {
            sql.append(",ALLENTRY.FCostCenterOrgUnitID");
        }
        sql.append(",ALLENTRY.FLot,ALLENTRY.FAccountType,ALLENTRY.FAssistPropertyID,ALLENTRY.FProjectID,ALLENTRY.FTrackNumberID");
        sql.append(" ) ENTRY").append("\t\n");
        sql.append(" LEFT OUTER JOIN t_bd_MultiMeasureUnit MeasureUnitBase").append("\t\n");
        sql.append(" ON (Entry.MATERIALFID = MeasureUnitBase.FMaterialid");
        sql.append(" AND Entry.MATERIALFBaseUnit = MeasureUnitBase.FMeasureUnitID)");
        logger.debug((Object)("\u5165\u5e93\u6c47\u603b\u6838\u7b97SQL\uff1a\n" + sql.toString()));
        this.getBillDetailRecordSQL(params, SQLThisInpourBill);
        return sql.toString();
    }

    public String getBillDetailRecordSQL(CalculateParams params, String SQLThisInpourBill) {
        StringBuilder sql = new StringBuilder();
        sql.append(SQLThisInpourBill);
        if (params.getBoolean("ckBxMShortName") && (params.getString("txtMShortNameFrom").length() > 0 || params.getString("txtMShortNameTo").length() > 0)) {
            if (params.getString("txtMShortNameFrom").length() > 0 && params.getString("txtMShortNameTo").length() > 0) {
                sql.append(" AND MATERIAL.FSHORTNAME >='").append(params.getString("txtMShortNameFrom").trim() + "'").append(" AND MATERIAL.FSHORTNAME<= '").append(params.getString("txtMShortNameTo").trim()).append("'");
            } else if (params.getString("txtMShortNameFrom").length() > 0 && params.getString("txtMShortNameTo").length() <= 0) {
                sql.append(" AND MATERIAL.FSHORTNAME >= '").append(params.getString("txtMShortNameFrom").trim()).append("'");
            } else if (params.getString("txtMShortNameFrom").length() <= 0 && params.getString("txtMShortNameTo").length() > 0) {
                sql.append(" AND MATERIAL.FSHORTNAME<= '").append(params.getString("txtMShortNameTo").trim()).append("'");
            }
        }
        StringBuilder billRecordSQL = new StringBuilder();
        String materialGroupStandardID = params.getString("MATERIALGROUPSTANDARD_ID");
        String materialGroupIDS = params.getString("MATERIALGROUP_IDS");
        billRecordSQL.append(" select temp.* from (").append("\t\n");
        billRecordSQL.append((CharSequence)sql);
        billRecordSQL.append(") temp ");
        billRecordSQL.append(" inner join T_BD_MaterialGroupDetial T on temp.FMaterialId = T.FMaterialId");
        billRecordSQL.append(" inner join T_BD_MaterialGroup T2 on T.FMaterialGroupId = T2.FID");
        billRecordSQL.append(" where 1=1 ");
        if (null != materialGroupStandardID) {
            billRecordSQL.append(" and T2.fgroupstandard = '").append(materialGroupStandardID).append("'");
        }
        if (null != materialGroupIDS) {
            billRecordSQL.append(" and T.FMaterialGroupID in ").append(materialGroupIDS);
        }
        if (params.getBoolean("ckBxZeroPrice")) {
            billRecordSQL.append(" and temp.FBaseUnitActualCost <= 0").append("\t\n");
        }
        params.setString("billDetailRecordSQL", billRecordSQL.toString());
        return billRecordSQL.toString();
    }

    @Override
    protected StringBuffer getSQLCostAdjExtendWhere() {
        return this.null_string;
    }

    @Override
    protected StringBuffer getSQLWhereExtends(PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" AND (BILL.FFiVouchered = 0 OR Bill.FFiVouchered is NULL)").append("\t\n");
        if ("109".equals(this.getBillTypeNumber())) {
            sql.append(" AND BILL.FBizTypeID <> '").append("kXeVPjE9chDgQKjAYj1RYCQHQ1w=").append("'").append("\t\n");
        }
        if (!("102".equals(this.getBillTypeNumber()) || "108".equals(this.getBillTypeNumber()) || "104".equals(this.getBillTypeNumber()))) {
            sql.append(" AND (Entry.FIsPresent  = 0 OR Entry.FIsPresent  is NULL)").append("\t\n").append("\t\n");
        }
        if (params != null) {
            Object trackNumberTo;
            Object trackNumberFrom;
            Object projectTo;
            Object projectFrom;
            AdminOrgUnitInfo adminOrgUnitInfo;
            CostCenterOrgUnitInfo costCenterOrgUnitInfo;
            WarehouseInfo warehouseInfo;
            StorageOrgUnitInfo storageOrgUnitInfo;
            int i;
            String id;
            Object[] obj;
            sql.append(" and ENTRY.FCOMPANYORGUNITID = N'").append(params.getString("COMPANY_ID")).append("'").append("\t\n");
            if (params.getString("BILLTYPE_ID") != null && params.getString("BILLTYPE_ID").length() != 0) {
                sql.append(" and Bill.FBILLTYPEID = '").append(params.getString("BILLTYPE_ID")).append("'").append("\t\n");
            }
            if (params.getObject("TRANSACTIONS") != null && (obj = (Object[])params.getObject("TRANSACTIONS")) != null && obj.length > 0) {
                TransactionTypeInfo transactionTypeInfo = (TransactionTypeInfo)obj[0];
                id = "'" + transactionTypeInfo.getId().toString() + "'";
                for (i = 1; i < obj.length; ++i) {
                    transactionTypeInfo = (TransactionTypeInfo)obj[i];
                    id = id + ",'" + transactionTypeInfo.getId().toString() + "'";
                }
                sql.append(" and SCMTRANSACTIONTYPE.FID in (").append(id).append(")").append("\t\n");
            }
            if (params.getObject("STORAGEORGUNIT") != null && (obj = (Object[])params.getObject("STORAGEORGUNIT")) != null && obj.length > 0 && (storageOrgUnitInfo = (StorageOrgUnitInfo)obj[0]) != null) {
                id = "'" + storageOrgUnitInfo.getId().toString() + "'";
                for (i = 1; i < obj.length; ++i) {
                    storageOrgUnitInfo = (StorageOrgUnitInfo)obj[i];
                    id = id + ",'" + storageOrgUnitInfo.getId().toString() + "'";
                }
                sql.append(" and STORAGEORGUNIT.FID in (").append(id).append(")").append("\t\n");
            }
            if (params.getObject("WAREHOUSE") != null && (obj = (Object[])params.getObject("WAREHOUSE")) != null && obj.length > 0 && (warehouseInfo = (WarehouseInfo)obj[0]) != null) {
                id = "'" + warehouseInfo.getId().toString() + "'";
                for (i = 1; i < obj.length; ++i) {
                    warehouseInfo = (WarehouseInfo)obj[i];
                    id = id + ",'" + warehouseInfo.getId().toString() + "'";
                }
                sql.append(" and WAREHOUSE.FID in (").append(id).append(")").append("\t\n");
            }
            if (params.getObject("COSTCENTER") != null && (obj = (Object[])params.getObject("COSTCENTER")) != null && obj.length > 0 && (costCenterOrgUnitInfo = (CostCenterOrgUnitInfo)obj[0]) != null) {
                id = "'" + costCenterOrgUnitInfo.getId().toString() + "'";
                for (i = 1; i < obj.length; ++i) {
                    costCenterOrgUnitInfo = (CostCenterOrgUnitInfo)obj[i];
                    id = id + ",'" + costCenterOrgUnitInfo.getId().toString() + "'";
                }
                sql.append(" and ").append(this.getCostCenterFieldSQL()).append(" in (").append(id).append(")").append("\t\n");
            }
            if (params.getObject("DEPARTMENT") != null && (obj = (Object[])params.getObject("DEPARTMENT")) != null && obj.length > 0 && (adminOrgUnitInfo = (AdminOrgUnitInfo)obj[0]) != null) {
                id = "'" + adminOrgUnitInfo.getId().toString() + "'";
                for (i = 1; i < obj.length; ++i) {
                    adminOrgUnitInfo = (AdminOrgUnitInfo)obj[i];
                    id = id + ",'" + adminOrgUnitInfo.getId().toString() + "'";
                }
                sql.append(" and ").append(this.getAdminOrgUnitFieldSQL()).append(" IN (").append(id).append(")").append("\t\n");
            }
            if (!StringUtil.isEmpty((String)params.getString("LOT_FROM"))) {
                sql.append(" AND ENTRY.FLot >= N'").append(params.getString("LOT_FROM")).append("'").append("\t\n");
            }
            if (!StringUtil.isEmpty((String)params.getString("LOT_TO"))) {
                sql.append(" AND ENTRY.FLot <= N'").append(params.getString("LOT_TO")).append("'").append("\t\n");
            }
            if ((projectFrom = params.getObject("PROJECT_FROM")) != null && projectFrom instanceof ProjectInfo) {
                sql.append(" and project.FNumber >= N'").append(((ProjectInfo)projectFrom).getNumber()).append("'").append("\t\n");
            }
            if ((projectTo = params.getObject("PROJECT_TO")) != null && projectTo instanceof ProjectInfo) {
                sql.append(" and project.FNumber <= N'").append(((ProjectInfo)projectTo).getNumber()).append("'").append("\t\n");
            }
            if ((trackNumberFrom = params.getObject("TRACKNUMBER_FROM")) != null && trackNumberFrom instanceof TrackNumberInfo) {
                sql.append(" and trackNumber.FNumber >= N'").append(((TrackNumberInfo)trackNumberFrom).getNumber()).append("'").append("\t\n");
            }
            if ((trackNumberTo = params.getObject("TRACKNUMBER_TO")) != null && trackNumberTo instanceof TrackNumberInfo) {
                sql.append(" and trackNumber.FNumber <= N'").append(((TrackNumberInfo)trackNumberTo).getNumber()).append("'").append("\t\n");
            }
        }
        return sql;
    }

    @Override
    protected StringBuffer getSQLJoinExtends(CalculateParams params) {
        StringBuffer extendSql = new StringBuffer();
        if (params.getObject("PROJECT_FROM") != null || params.getObject("PROJECT_TO") != null) {
            extendSql.append(" inner join T_MM_Project project on project.FID = ENTRY.FProjectID ").append("\t\n");
        }
        if (params.getObject("TRACKNUMBER_FROM") != null || params.getObject("TRACKNUMBER_TO") != null) {
            extendSql.append(" inner join T_MM_TrackNumber trackNumber on trackNumber.FID = ENTRY.FTrackNumberID ").append("\t\n");
        }
        return extendSql;
    }

    protected String takeReverseBillsSQL1(String bill, String billEntry, String tempBillID, String targetTempTableName, String tempTableName, String strCalType, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(targetTempTableName);
        sql.append("(FSourceBillId,FSourceBillEntryId,FPricePrecision,FQtyPrecision,FLocalCurrencyPrecision");
        sql.append(",Factualcost,FQTY,FUnitActualCost)");
        sql.append("\n SELECT Entry.FPARENTId,Entry.FID ");
        sql.append(" ,TempT.FPricePrecision,TempT.FQtyPrecision,TempT.FLocalCurrencyPrecision,Entry.Factualcost,Entry.FQty,ENTRY.FUnitActualCost");
        sql.append(" FROM ").append(billEntry).append(" as Entry  ");
        sql.append(" INNER JOIN ").append(bill).append(" as Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" ON (Entry.FMaterialID = TempT.FMaterialID  ");
        sql.append(" AND Entry.FCompanyOrgUnitID = TempT.FCompanyOrgUnitID ");
        if (!"0".equals(strCalType)) {
            sql.append(" AND Entry.fstorageorgunitid = TempT.fstorageorgunitid ");
        }
        if ("2".equals(strCalType)) {
            sql.append(" AND Entry.fwarehouseid = TempT.fwarehouseid ");
        }
        sql.append(" )");
        sql.append(this.getSQLJOIN(params, this.billType));
        sql.append(this.getSQLWhere(periodInfo, null, true));
        sql.append(" AND (BILL.FFiVouchered = 0)").append("\t\n");
        sql.append(" AND Bill.FIsReversed  = 0 ");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append("\n AND Entry.FWrittenOffQty =0 ");
        }
        if (!StringUtil.isEmpty((String)tempBillID)) {
            sql.append(" AND TempT.FID = '").append(tempBillID).append("' ");
        }
        sql.append(" AND TempT.FAccountType <> ").append(5);
        return sql.toString();
    }

    protected String takeReverseBillsSQL2(String bill, String billEntry, String tempBillID, String targetTempTableName, String tempTableName, String strCalType, PeriodInfo periodInfo, CalculateParams params) {
        String temp_SpecialCalTypeTemp = params.getString("T_Temp_SpecialCalTypeTempResault");
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(targetTempTableName);
        sql.append("(FSourceBillId,FSourceBillEntryId,FPricePrecision,FQtyPrecision,FLocalCurrencyPrecision");
        sql.append(",Factualcost,FQTY,FUnitActualCost)");
        sql.append("\n SELECT Entry.FPARENTId,Entry.FID ");
        sql.append(" ,TempT.FPricePrecision,TempT.FQtyPrecision,TempT.FLocalCurrencyPrecision,Entry.Factualcost,Entry.FQty,Entry.FUnitActualCost");
        sql.append(" FROM (");
        sql.append("select entry.* , t.FActualLot , t.FActualAssistPropertyID ,");
        sql.append("  t.FActualProjectID,  t.FActualTrackNumberID ");
        sql.append(" from ").append(billEntry).append(" entry ");
        sql.append(" inner join ").append(temp_SpecialCalTypeTemp).append(" as t ");
        sql.append(" on entry.Fid = t.FID ");
        sql.append(") Entry ");
        sql.append(" INNER JOIN ").append(bill).append(" as Bill ON Bill.FID = Entry.FParentID  ");
        sql.append(" INNER JOIN ").append(tempTableName).append(" as TempT");
        sql.append(" ON (Entry.FMaterialID = TempT.FMaterialID ");
        sql.append(" AND isnull(Entry.FActualLot,'X') = isnull(TempT.FLot,'X')");
        sql.append(" AND isnull(Entry.FActualAssistPropertyID,'X') = isnull(TempT.FAssistPropertyID,'X')");
        sql.append(" AND isnull(Entry.FActualProjectID,'X') = isnull(TempT.FProjectID,'X')");
        sql.append(" AND isnull(Entry.FActualTrackNumberID,'X') = isnull(TempT.FTrackNumberID,'X')");
        sql.append(" AND Entry.FCompanyOrgUnitID = TempT.FCompanyOrgUnitID ");
        if (!"0".equals(strCalType)) {
            sql.append(" AND Entry.fstorageorgunitid = TempT.fstorageorgunitid ");
        }
        if ("2".equals(strCalType)) {
            sql.append(" AND Entry.fwarehouseid = TempT.fwarehouseid ");
        }
        sql.append(" )");
        sql.append(this.getSQLJOIN(params, this.billType));
        sql.append(this.getSQLWhere(periodInfo, null, true));
        sql.append(" AND (BILL.FFiVouchered = 0)").append("\t\n");
        sql.append(" AND Bill.FIsReversed  = 0 ");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append("\n AND Entry.FWrittenOffQty =0 ");
        }
        if (!StringUtil.isEmpty((String)tempBillID)) {
            sql.append(" AND TempT.FID = '").append(tempBillID).append("' ");
        }
        sql.append(" AND TempT.FAccountType = ").append(5);
        return sql.toString();
    }

    protected StringBuffer takeFullReverseBill1(String bill, String billEntry, String GZTTableFullReverse, String tempTableName, String cal_sum_conditino, PeriodInfo periodInfo, CalculateParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(GZTTableFullReverse);
        sql.append(" SELECT ").append("\t\n");
        sql.append(" ENTRY.fsourcebillid,ENTRY.fsourcebillentryid");
        sql.append(" ,abs(ENTRY.factualcost)-abs(sum(otherOffSetbillEntry.factualcost)) as factualcost");
        sql.append(" from ").append(tempTableName).append(" TempT").append("\t\n");
        sql.append(" inner join ").append(billEntry).append(" ENTRY");
        sql.append(" ON (ENTRY.fmaterialid=TempT.fmaterialid ");
        sql.append(" AND ENTRY.fcompanyorgunitid=TempT.fcompanyorgunitid ");
        if (!"0".equals(cal_sum_conditino)) {
            sql.append(" AND ENTRY.fstorageorgunitid=TempT.fstorageorgunitid ");
        }
        if ("2".equals(cal_sum_conditino)) {
            sql.append(" AND ENTRY.Fwarehouseid=TempT.Fwarehouseid ");
        }
        sql.append(" ) ");
        sql.append(" inner join ").append(bill).append(" BILL").append("\t\n");
        sql.append(" on BILL.fid=ENTRY.fparentid ").append("\t\n");
        sql.append(" INNER JOIN ").append(billEntry).append(" otherOffSetbillEntry ");
        sql.append(" ON (");
        sql.append("     ENTRY.fsourcebillid = otherOffSetbillEntry.fsourcebillid");
        sql.append(" AND ENTRY.fsourcebillentryid=otherOffSetbillEntry.fsourcebillentryid").append("\t\n");
        sql.append(" )").append("\t\n");
        sql.append(" INNER JOIN ").append(bill).append(" otherOffSetbill ");
        sql.append(" ON otherOffSetbill.fid=otherOffSetbillEntry.fparentid ");
        sql.append(this.getSQLJOIN(params, this.billType));
        sql.append(this.getSQLWhere(periodInfo, params, true));
        sql.append(" AND abs(ENTRY.fqty)=abs(ENTRY.freverseqty)");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append("\n AND Entry.FWrittenOffQty =0 ");
        }
        sql.append(" AND (BILL.FIsReversed  = 0 or BILL.FIsReversed is Null)");
        sql.append(" AND otherOffSetbill.FIsReversed  = 1 ").append("\t\n");
        sql.append(" AND TempT.FAccountType <> ").append(5);
        sql.append(" GROUP BY ENTRY.fsourcebillid,ENTRY.fsourcebillentryid,ENTRY.factualcost");
        return sql;
    }

    protected StringBuffer takeFullReverseBill2(String bill, String billEntry, String GZTTableFullReverse, String tempTableName, String cal_sum_conditino, PeriodInfo periodInfo, CalculateParams params) {
        String temp_SpecialCalTypeTemp = params.getString("T_Temp_SpecialCalTypeTempResault");
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(GZTTableFullReverse);
        sql.append(" SELECT ").append("\t\n");
        sql.append(" ENTRY.fsourcebillid,ENTRY.fsourcebillentryid");
        sql.append(" ,abs(ENTRY.factualcost)-abs(sum(otherOffSetbillEntry.factualcost)) as factualcost");
        sql.append(" from ").append(tempTableName).append(" TempT").append("\t\n");
        sql.append(" inner join (");
        sql.append(" select entry.* , t.FActualLot, t.FActualAssistPropertyID,");
        sql.append("  t.FActualProjectID,  t.FActualTrackNumberID ");
        sql.append(" from ").append(billEntry).append(" entry ");
        sql.append(" inner join ").append(temp_SpecialCalTypeTemp).append(" as t ");
        sql.append(" on entry.Fid = t.FID ");
        sql.append(") Entry ");
        sql.append(" ON (ENTRY.fmaterialid=TempT.fmaterialid ");
        sql.append(" AND isnull(Entry.FActualLot,'X') = isnull(TempT.FLot,'X')");
        sql.append(" AND isnull(Entry.FActualAssistPropertyID,'X') = isnull(TempT.FAssistPropertyID,'X')");
        sql.append(" AND isnull(Entry.FActualProjectID,'X') = isnull(TempT.FProjectID,'X')");
        sql.append(" AND isnull(Entry.FActualTrackNumberID,'X') = isnull(TempT.FTrackNumberID,'X')");
        sql.append(" AND ENTRY.fcompanyorgunitid=TempT.fcompanyorgunitid ");
        if (!"0".equals(cal_sum_conditino)) {
            sql.append(" AND ENTRY.fstorageorgunitid=TempT.fstorageorgunitid ");
        }
        if ("2".equals(cal_sum_conditino)) {
            sql.append(" AND ENTRY.Fwarehouseid=TempT.Fwarehouseid ");
        }
        sql.append(" ) ");
        sql.append(" inner join ").append(bill).append(" BILL").append("\t\n");
        sql.append(" on BILL.fid=ENTRY.fparentid ").append("\t\n");
        sql.append(" INNER JOIN ").append(billEntry).append(" otherOffSetbillEntry ");
        sql.append(" ON (");
        sql.append("     ENTRY.fsourcebillid = otherOffSetbillEntry.fsourcebillid");
        sql.append(" AND ENTRY.fsourcebillentryid=otherOffSetbillEntry.fsourcebillentryid").append("\t\n");
        sql.append(" )").append("\t\n");
        sql.append(" INNER JOIN ").append(bill).append(" otherOffSetbill ");
        sql.append(" ON otherOffSetbill.fid=otherOffSetbillEntry.fparentid ");
        sql.append(this.getSQLJOIN(params, this.billType));
        sql.append(this.getSQLWhere(periodInfo, params, true));
        sql.append(" AND abs(ENTRY.fqty)=abs(ENTRY.freverseqty)");
        sql.append(" AND (BILL.FIsReversed  = 0 or BILL.FIsReversed is Null)");
        if (this.inpourTableArray[0][0].equalsIgnoreCase(billEntry)) {
            sql.append("\n AND Entry.FWrittenOffQty =0 ");
        }
        sql.append(" AND otherOffSetbill.FIsReversed  = 1 ").append("\t\n");
        sql.append(" AND TempT.FAccountType = ").append(5);
        sql.append(" GROUP BY ENTRY.fsourcebillid,ENTRY.fsourcebillentryid,ENTRY.factualcost");
        return sql;
    }

    protected StringBuffer getSQLCostAdjJoinExtends() {
        return this.null_string;
    }

    public boolean isDb2(Context ctx) {
        if (ctx.get((Object)"dbType") != null) {
            String dbType = (String)ctx.get((Object)"dbType");
            if ((dbType = dbType.toLowerCase()).indexOf("db2") > -1) {
                return true;
            }
        }
        return false;
    }

    private void createTmpeTable(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException {
        String temTableName = null;
        if (StringUtil.isEmpty((String)params.getString("T_Temp_WriteOffTable"))) {
            temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getWriteOffTableFields());
            params.setString("T_Temp_WriteOffTable", temTableName);
            sysTempTableHelper.createTempTableIndex(temTableName, "FID", true, false);
            sysTempTableHelper.createTempTableIndex(params.getString("T_Temp_WriteOffTable"), "FBillEntryID,FBillID", false, false);
        }
        if (StringUtil.isEmpty((String)params.getString("T_Temp_SaleIssueWriteoffRecord"))) {
            temTableName = sysTempTableHelper.createTempTable(ctx, InventoryBillHelp.getSaleIssueWriteOffTableFields());
            params.setString("T_Temp_SaleIssueWriteoffRecord", temTableName);
        }
    }

    private String[] getUpdteTableName() {
        String[] tableName = new String[2];
        String billTypeId = this.getBillTypeId(this.getBillTypeNumber());
        if (billTypeId == null) {
            return null;
        }
        for (int i = 0; i < this.inpourTableArray.length; ++i) {
            if (!this.inpourTableArray[i][2].equals(billTypeId)) continue;
            tableName[0] = this.inpourTableArray[i][0];
            tableName[1] = this.inpourTableArray[i][1];
            this.billType = i < 4 ? 0 : 1;
        }
        return tableName;
    }

    private String getBillTypeId(String billTypeNo) {
        String billTypeId = null;
        if ("103".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-015fc0a812fd463ED552";
        } else if ("105".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-0167c0a812fd463ED552";
        } else if ("109".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-017bc0a812fd463ED552";
        } else if ("102".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-015bc0a812fd463ED552";
        } else if ("104".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-0163c0a812fd463ED552";
        } else if ("108".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-0177c0a812fd463ED552";
        } else if ("107".equals(billTypeNo)) {
            billTypeId = "50957179-0105-1000-e000-0172c0a812fd463ED552";
        }
        return billTypeId;
    }

    private void writeLog(Context ctx, String detailTableName) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select fnumber as num from " + detailTableName));
        HashSet<String> numberSet = new HashSet<String>();
        try {
            while (rs.next()) {
                numberSet.add(rs.getString("num"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        Iterator it = numberSet.iterator();
        String number = null;
        StringBuffer msg = new StringBuffer();
        IObjectPK pklog = null;
        int limitLength = 1024;
        ArrayList<String> msgList = new ArrayList<String>();
        String resource = "com.kingdee.eas.scm.cal.CalCommonResource";
        String msgToContinue = ResourceUtil.getMessage((String)resource, (String)"msgToContinue");
        String title = ResourceUtil.getMessage((String)resource, (String)"inwarehsSumLogTitle");
        while (it.hasNext()) {
            number = it.next().toString();
            if (msg.length() + number.length() > limitLength) {
                msg.append(msgToContinue);
                msgList.add(msg.toString());
                msg.setLength(0);
            }
            msg.append(number).append(", ");
        }
        if (msg.length() > 0) {
            msgList.add(msg.toString());
        }
        for (int i = 0; i < msgList.size(); ++i) {
            pklog = LogUtil.beginLogWithDescription((Context)ctx, (String)"1", (BOSObjectType)new BOSObjectType("13AF665D"), null, (String)((String)msgList.get(i)), (String)title);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }
}

