/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CostAdjustBillInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;

public class IssueCostAdjustCalculate
extends AbstractCalculateCost {
    private static final int MAX_STATEMENT = 30;

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return null;
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        String companyOrgUnitID = params.getString("COMPANY_ID");
        boolean isFullIssueCostAdjust = IssueCostAdjustCalculate.isFullIssueCostAdjust(ctx, companyOrgUnitID);
        int localCurrencyPrecision = params.getInt("Local_Currency_Presision");
        String tempTableName = params.getString("T_Temp_CostAdjusTable");
        String tempAssistTableName = params.getString("T_Temp_PeriodCostAdjustAssistTable");
        String tempAssistTableName2 = params.getString("T_Temp_PeriodEndCostAdjustAssistTable");
        this.deleteCostAdjustBill(ctx, companyOrgUnitID, periodInfo, sysTempTableHelper);
        sysTempTableHelper.execute(this.getPeriodCostAdjstSQL(tempAssistTableName, companyOrgUnitID, periodInfo));
        sysTempTableHelper.execute(this.getPeriodCostAdjstSQL2(tempAssistTableName, companyOrgUnitID, periodInfo));
        sysTempTableHelper.execute(this.takeCostAdjustListSQL(tempTableName, tempAssistTableName, localCurrencyPrecision));
        this.processCostAdjust(ctx, tempTableName, companyOrgUnitID, periodInfo, sysTempTableHelper);
        if (!isFullIssueCostAdjust) {
            sysTempTableHelper.execute(this.updatePeriodBeginQty(tempTableName, periodInfo));
            sysTempTableHelper.execute(this.updatePeriodBeginUnWriteOffQty(tempTableName, periodInfo));
            sysTempTableHelper.execute(this.updatePeriodWrittenOffQty(tempTableName, tempAssistTableName, periodInfo));
            sysTempTableHelper.execute(this.getPeriodEndCostAdjustSQL(tempAssistTableName2, tempTableName, companyOrgUnitID, periodInfo));
            sysTempTableHelper.execute(this.takePeroidEndWrittenOffSQL(tempTableName, tempAssistTableName2));
        }
        this.processIssueDiffAmount(ctx, tempTableName, isFullIssueCostAdjust, sysTempTableHelper);
        this.createCostAdjust(ctx, tempTableName, params, periodInfo, sysTempTableHelper);
        return true;
    }

    private void deleteCostAdjustBill(Context ctx, String companyOrgUnitID, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        StringBuffer bf = new StringBuffer();
        bf.append("select b.fid from t_cl_costadjustbill a ");
        bf.append("inner join t_cl_costadjustbillentry b on a.fid=b.fparentid ");
        bf.append("where b.FCompanyOrgUnitID = '" + companyOrgUnitID + "' ");
        bf.append("AND a.fyear= " + periodInfo.getPeriodYear() + " and a.fperiod= " + periodInfo.getPeriodNumber() + " ");
        bf.append("and a.ffivouchered = 1 ");
        bf.append("and a.FCreateType = ").append(5).append(" ");
        IRowSet rs = sysTempTableHelper.executeQuery(bf.toString());
        if (rs.size() != 0) {
            throw new CalculateException(CalculateException.DELETECOSTADJUST_ISVOUCHERED);
        }
        bf = new StringBuffer();
        bf.append("delete from t_cl_costadjustbillentry ");
        bf.append("where fid in( ");
        bf.append("select b.fid from t_cl_costadjustbill a ");
        bf.append("inner join t_cl_costadjustbillentry b on a.fid = b.fparentid ");
        bf.append("where b.FCompanyOrgUnitID = '" + companyOrgUnitID + "' ");
        bf.append("AND a.fyear= " + periodInfo.getPeriodYear() + " and a.fperiod= " + periodInfo.getPeriodNumber() + " ");
        bf.append("and a.FCreateType = ").append(5).append(" ");
        bf.append("and a.ffivouchered = 0 )");
        sysTempTableHelper.execute(bf.toString());
        bf = new StringBuffer();
        bf.append("delete from t_cl_costadjustbill where fid in ( ");
        bf.append("select a.fid from t_cl_costadjustbill a ");
        bf.append("left join t_cl_costadjustbillentry b on a.fid = b.fparentid ");
        bf.append("where b.fid is null ");
        bf.append("AND a.fyear= " + periodInfo.getPeriodYear() + " and a.fperiod= " + periodInfo.getPeriodNumber() + " ");
        bf.append("and a.FCreateType = ").append(5).append(" ");
        bf.append("and a.ffivouchered = 0 )");
        sysTempTableHelper.execute(bf.toString());
    }

    @Override
    protected StringBuffer getSQLCostAdjExtendWhere() {
        return null;
    }

    @Override
    protected StringBuffer getSQLWhereExtends(PeriodInfo periodInfo, CalculateParams params) {
        return null;
    }

    @Override
    protected StringBuffer getSQLJoinExtends(CalculateParams params) {
        return null;
    }

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    private String getPeriodCostAdjstSQL(String tempAssistTableName, String companyOrgUnitID, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(tempAssistTableName);
        bf.append(" SELECT A.FSOURCEBILLID,A.FSOURCEBILLENTRYID,A.FParentID,A.FID");
        bf.append(" ,A.FMaterialID,A.FStorageOrgUnitID,A.FWarehouseID");
        bf.append(" FROM T_CL_CostAdjustBillEntry A");
        bf.append(" INNER JOIN (");
        bf.append(" SELECT B.FBillID,B.FBillEntryID FROM T_CL_WriteOffRecord B");
        bf.append(" WHERE B.FBillTypeNumber = '").append("410").append("'");
        bf.append(" AND B.FBillDate >= to_date('").append(periodInfo.getBeginDate()).append("')");
        bf.append(" AND B.FBillDate <= to_date('").append(periodInfo.getEndDate()).append("')");
        bf.append(" ) TempT ON A.FParentID = TempT.FBillID AND A.FID = TempT.FBillEntryID");
        bf.append(" INNER JOIN T_IM_PurInWarehsBill T ON T.FID = A.FSOURCEBILLID");
        bf.append(" INNER JOIN T_BD_MaterialCompanyInfo B ON B.FMaterialID = A.FMaterialID AND B.FCompanyID = A.FCompanyOrgUnitID ");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = A.FStoreTypeID");
        bf.append(" WHERE A.FCompanyOrgUnitID = '").append(companyOrgUnitID).append("'");
        bf.append(" AND T.FBizDate < to_date('").append(periodInfo.getBeginDate()).append("')");
        bf.append(" AND B.FAccountType = ").append(AccountType.FIN_FOUT.getValue());
        bf.append(" AND S.FIsForwardAmt = 1");
        return bf.toString();
    }

    private String getPeriodCostAdjstSQL2(String tempAssistTableName, String companyOrgUnitID, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(tempAssistTableName);
        bf.append(" SELECT A.FSOURCEBILLID,A.FSOURCEBILLENTRYID,A.FParentID,A.FID");
        bf.append(" ,A.FMaterialID,A.FStorageOrgUnitID,A.FWarehouseID");
        bf.append(" FROM T_CL_CostAdjustBillEntry A");
        bf.append(" INNER JOIN T_CL_CostAdjustBill C ON C.FID = A.FParentID");
        bf.append(" INNER JOIN T_IM_PurInWarehsBill T ON T.FID = A.FSOURCEBILLID");
        bf.append(" INNER JOIN T_BD_MaterialCompanyInfo B ON B.FMaterialID = A.FMaterialID AND B.FCompanyID = A.FCompanyOrgUnitID ");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = A.FStoreTypeID");
        bf.append(" WHERE A.FCompanyOrgUnitID = '").append(companyOrgUnitID).append("'");
        bf.append(" AND T.FBizDate < to_date('").append(periodInfo.getBeginDate()).append("')");
        bf.append(" AND C.FYear = ").append(periodInfo.getPeriodYear());
        bf.append(" AND C.FPeriod = ").append(periodInfo.getPeriodNumber());
        bf.append(" AND C.FCreateType = ").append(4);
        bf.append(" AND B.FAccountType = ").append(AccountType.FIN_FOUT.getValue());
        bf.append(" AND S.FIsForwardAmt = 1");
        return bf.toString();
    }

    private String getPeriodEndCostAdjustSQL(String tempAssistTableName2, String tempTableName, String companyOrgUnitID, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(tempAssistTableName2);
        bf.append(" SELECT A.FSOURCEBILLID,A.FSOURCEBILLENTRYID,A.FParentID,A.FID");
        bf.append(" ,A.FMaterialID,A.FStorageOrgUnitID,A.FWarehouseID");
        bf.append(" FROM T_CL_CostAdjustBillEntry A");
        bf.append(" INNER JOIN (");
        bf.append(" SELECT B.FBillID,B.FBillEntryID FROM T_CL_WriteOffRecord B");
        bf.append(" WHERE B.FBillTypeNumber = '410' ");
        bf.append(" AND B.FBillDate > to_date('").append(periodInfo.getEndDate()).append("')");
        bf.append(" ) TempT ON A.FParentID = TempT.FBillID AND A.FID = TempT.FBillEntryID");
        bf.append(" INNER JOIN ").append(tempTableName).append(" T");
        bf.append(" ON T.FMaterialID = A.FMaterialID");
        bf.append(" AND T.FStorageOrgUnitID = A.FStorageOrgUnitID");
        bf.append(" AND T.FWarehouseID = A.FWarehouseID");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = A.FStoreTypeID");
        bf.append(" WHERE A.FCompanyOrgUnitID = '").append(companyOrgUnitID).append("'");
        bf.append(" AND S.FIsForwardAmt = 1");
        return bf.toString();
    }

    private String takeCostAdjustListSQL(String tempTableName, String tempAssistTableName, int localCurrencyPrecision) {
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ").append(tempTableName);
        bf.append("(FID,FMaterialID,FStorageOrgUnitID,FWarehouseID,FLocalCurrencyPrecision,FDiffAmount,FIssueDiffAmount");
        bf.append(",FPeriodBeginQty,FPeriodBeginUnWriteOffQty,FPeriodWrittenOffQty,FPeriodEndWrittenOffQty,FAssistPropertyID,");
        bf.append("FLocationID,FProjectID,FTrackNumberID,FAdminOrgUnitId,FCostCenterOrgUnitId,FLot )");
        bf.append("\n SELECT");
        bf.append(" NEWBOSID('2774F28C')");
        bf.append(" ,Entry.FMaterialID,Entry.FStorageOrgUnitID,Entry.FWarehouseID");
        bf.append(" ,").append(localCurrencyPrecision);
        bf.append(" ,SUM(Entry.FActualCost) AS FActualCost");
        bf.append(" ,0,0,0,0,0");
        bf.append(" ,Entry.FAssistPropertyID,Entry.FLocationID,Entry.FProjectID,Entry.FTrackNumberID");
        bf.append(" ,bill.FAdminOrgUnitId,bill.FCostCenterOrgUnitId,Entry.FLot");
        bf.append(" FROM T_CL_CostAdjustBillEntry Entry");
        bf.append(" INNER JOIN T_CL_CostAdjustBill bill on bill.FId = Entry.FParentId");
        bf.append(" INNER JOIN ").append(tempAssistTableName).append(" TempT");
        bf.append(" ON Entry.FParentID = TempT.FCostAdjustBillID");
        bf.append(" AND Entry.FID = TempT.FCostAdjustEntryID");
        bf.append(" GROUP BY bill.FAdminOrgUnitId,bill.FCostCenterOrgUnitId");
        bf.append(" ,Entry.FMaterialID,Entry.FStorageOrgUnitID,Entry.FWarehouseID");
        bf.append(" ,Entry.FAssistPropertyID,Entry.FLocationID,Entry.FProjectID,Entry.FTrackNumberID,Entry.FLot");
        return bf.toString();
    }

    private String updatePeriodBeginQty(String tempTableName, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTableName).append(" AS T");
        bf.append(" SET (FPeriodBeginQty) = (");
        bf.append(" SELECT TT.FPeriodBeginQty FROM (");
        bf.append(" SELECT Entry.FMaterialID,Entry.FStorageOrgUnitID,Entry.FWarehouseID,SUM(Entry.FPeriodBeginQty) AS FPeriodBeginQty");
        bf.append(" FROM T_IM_InventoryBalance Entry");
        bf.append(" INNER JOIN ").append(tempTableName).append(" TempT ON Entry.FMaterialID = TempT.FMaterialID");
        bf.append(" AND Entry.FStorageOrgUnitID = TempT.FStorageOrgUnitID");
        bf.append(" AND Entry.FWarehouseID = TempT.FWarehouseID");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = Entry.FStoreTypeID");
        bf.append(" WHERE Entry.FYear = ").append(periodInfo.getPeriodYear());
        bf.append(" AND Entry.FPeriod = ").append(periodInfo.getPeriodNumber());
        bf.append(" AND S.FIsForwardAmt = 1");
        bf.append(" GROUP BY Entry.FMaterialID,Entry.FStorageOrgUnitID,Entry.FWarehouseID");
        bf.append(" ) TT");
        bf.append(" WHERE T.FMaterialID = TT.FMaterialID");
        bf.append(" AND T.FStorageOrgUnitID = TT.FStorageOrgUnitID");
        bf.append(" AND T.FWarehouseID = TT.FWarehouseID )");
        return bf.toString();
    }

    private String updatePeriodBeginUnWriteOffQty(String tempTableName, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTableName).append(" AS T");
        bf.append(" SET (FPeriodBeginUnWriteOffQty) = (");
        bf.append(" SELECT FUnWriteOffBaseQty FROM (");
        bf.append(" SELECT Entry.FMaterialID,Entry.FStorageOrgUnitID,Entry.FWarehouseID");
        bf.append(" ,SUM(Entry.FUnWriteOffBaseQty) AS FUnWriteOffBaseQty");
        bf.append(" FROM T_IM_PurInWarehsEntry Entry");
        bf.append(" INNER JOIN T_IM_PurInWarehsBill Bill ON Bill.FID = Entry.FParentID");
        bf.append(" INNER JOIN ").append(tempTableName).append(" TempT");
        bf.append(" ON Entry.FMaterialID = TempT.FMaterialID");
        bf.append(" AND Entry.FStorageOrgUnitID = TempT.FStorageOrgUnitID");
        bf.append(" AND Entry.FWarehouseID = TempT.FWarehouseID");
        bf.append(" INNER JOIN T_IM_InvUpdateType InvUpd ON InvUpd.FID = Entry.FInvUpdateTypeID");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = InvUpd.FStoreTypeID");
        bf.append(" WHERE Bill.FBizDate < to_date('").append(periodInfo.getBeginDate()).append("')");
        bf.append(" AND S.FIsForwardAmt = 1");
        bf.append(" GROUP BY Entry.FMaterialID,Entry.FStorageOrgUnitID,Entry.FWarehouseID");
        bf.append(" ) TT");
        bf.append(" WHERE T.FMaterialID = TT.FMaterialID");
        bf.append(" AND T.FStorageOrgUnitID = TT.FStorageOrgUnitID");
        bf.append(" AND T.FWarehouseID = TT.FWarehouseID )");
        return bf.toString();
    }

    private String updatePeriodWrittenOffQty(String tempTableName, String tempAssistTableName, PeriodInfo periodInfo) {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTableName).append(" AS T");
        bf.append(" SET (FPeriodWrittenOffQty) = (");
        bf.append(" SELECT FCurrWrittenOffQty FROM (");
        bf.append(" SELECT TempT.FMaterialID,TempT.FStorageOrgUnitID,TempT.FWarehouseID");
        bf.append(" ,SUM(Entry.FCurrWrittenOffQty) AS FCurrWrittenOffQty");
        bf.append(" FROM T_CL_WriteOffRecord Entry");
        bf.append(" INNER JOIN T_CL_WriteOffGroup Bill ON Bill.FID = Entry.FParentID");
        bf.append(" INNER JOIN ").append(tempAssistTableName).append(" TempT");
        bf.append(" ON Entry.FBillID = TempT.FPurInWarehsBillID");
        bf.append(" AND Entry.FBillEntryID = TempT.FPurInWarehsEntryID");
        bf.append(" WHERE Bill.FWriteOffYear = ").append(periodInfo.getPeriodYear());
        bf.append(" AND Bill.FWriteOffPeriod = ").append(periodInfo.getPeriodNumber());
        bf.append(" GROUP BY TempT.FMaterialID,TempT.FStorageOrgUnitID,TempT.FWarehouseID");
        bf.append(" ) TT");
        bf.append(" WHERE T.FMaterialID = TT.FMaterialID");
        bf.append(" AND T.FStorageOrgUnitID = TT.FStorageOrgUnitID");
        bf.append(" AND T.FWarehouseID = TT.FWarehouseID )");
        return bf.toString();
    }

    private String takePeroidEndWrittenOffSQL(String tempTableName, String tempAssistTableName2) {
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ").append(tempTableName).append(" AS T");
        bf.append(" SET (FPeriodEndWrittenOffQty) = (");
        bf.append(" SELECT FCurrWrittenOffQty FROM (");
        bf.append(" SELECT TempT.FMaterialID,TempT.FStorageOrgUnitID,TempT.FWarehouseID");
        bf.append(" ,SUM(Entry.FCurrWrittenOffQty) AS FCurrWrittenOffQty");
        bf.append(" FROM T_CL_WriteOffRecord Entry");
        bf.append(" INNER JOIN ").append(tempAssistTableName2).append(" TempT");
        bf.append(" ON Entry.FBillID = TempT.FPurInWarehsBillID");
        bf.append(" AND Entry.FBillEntryID = TempT.FPurInWarehsEntryID");
        bf.append(" GROUP BY TempT.FMaterialID,TempT.FStorageOrgUnitID,TempT.FWarehouseID");
        bf.append(" ) TT");
        bf.append(" WHERE T.FMaterialID = TT.FMaterialID");
        bf.append(" AND T.FStorageOrgUnitID = TT.FStorageOrgUnitID");
        bf.append(" AND T.FWarehouseID = TT.FWarehouseID )");
        return bf.toString();
    }

    private void processIssueDiffAmount(Context ctx, String tempTableName, boolean isFullIssueCostAdjust, SysTempTableHelper sysTempTableHelper) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("((TempT.FPeriodBeginUnWriteOffQty+TempT.FPeriodWrittenOffQty+TempT.FPeriodEndWrittenOffQty)-TempT.FPeriodBeginQty)");
        bf.append("*TempT.FDiffAmount");
        String temp = bf.toString();
        bf.setLength(0);
        bf.append("UPDATE ").append(tempTableName).append(" AS T");
        bf.append(" SET (FIssueDiffAmount) = (");
        bf.append(" SELECT");
        if (isFullIssueCostAdjust) {
            bf.append(" TempT.FDiffAmount");
        } else {
            bf.append(" CASE WHEN TempT.FPeriodBeginQty <= 0 THEN");
            bf.append(" TempT.FDiffAmount");
            bf.append(" ELSE");
            bf.append(" CASE WHEN (TempT.FPeriodBeginUnWriteOffQty+TempT.FPeriodWrittenOffQty+TempT.FPeriodEndWrittenOffQty)-TempT.FPeriodBeginQty >0 AND");
            bf.append(" (TempT.FPeriodBeginUnWriteOffQty+TempT.FPeriodWrittenOffQty+TempT.FPeriodEndWrittenOffQty)-TempT.FPeriodBeginQty");
            bf.append("  >= TempT.FPeriodWrittenOffQty THEN");
            bf.append(" TempT.FDiffAmount");
            bf.append(" WHEN (TempT.FPeriodBeginUnWriteOffQty+TempT.FPeriodWrittenOffQty+TempT.FPeriodEndWrittenOffQty)-TempT.FPeriodBeginQty >0 AND");
            bf.append(" (TempT.FPeriodBeginUnWriteOffQty+TempT.FPeriodWrittenOffQty+TempT.FPeriodEndWrittenOffQty)-TempT.FPeriodBeginQty");
            bf.append("  < TempT.FPeriodWrittenOffQty THEN");
            bf.append(" ROUND(");
            bf.append(CalculateUtil.TO_DECIMAL_DIVIDE(CalculateUtil.TO_DECIMAL_QTY(temp) + "/TempT.FPeriodWrittenOffQty"));
            bf.append(",TempT.FLocalCurrencyPrecision)");
            bf.append(" ELSE");
            bf.append(" 0 ");
            bf.append(" END");
            bf.append(" END");
        }
        bf.append(" FROM ").append(tempTableName).append(" TempT");
        bf.append(" WHERE T.FID = TempT.FID )");
        sysTempTableHelper.execute(bf.toString());
    }

    private void processCostAdjust(Context ctx, String tempTable, String companyOrgUnitID, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE FROM ").append(tempTable).append(" WHERE FID IN (");
        bf.append(" SELECT TempT.FID FROM T_CL_CostAdjustBill Bill");
        bf.append(" INNER JOIN T_CL_CostAdjustBillEntry Entry ON Bill.FID = Entry.FParentID");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = Entry.FStoreTypeID");
        bf.append(" INNER JOIN ").append(tempTable).append(" TempT");
        bf.append(" ON TempT.FMaterialID = Entry.FMaterialID");
        bf.append(" AND TempT.FStorageOrgUnitID = Entry.FStorageOrgUnitID");
        bf.append(" AND TempT.FWarehouseID = Entry.FWarehouseID");
        bf.append(" WHERE Bill.FYear = ").append(periodInfo.getPeriodYear());
        bf.append(" AND Bill.FPeriod = ").append(periodInfo.getPeriodNumber());
        bf.append(" AND Bill.FCreateType = ").append(5);
        bf.append(" AND Entry.FCompanyOrgUnitID = '").append(companyOrgUnitID).append("'");
        bf.append(" AND Bill.FFiVouchered = 1 AND S.FIsForwardAmt = 1");
        bf.append(" )");
        String deleteTempTable = bf.toString();
        bf.setLength(0);
        bf.append("DELETE FROM T_CL_CostAdjustBillEntry WHERE FID IN (");
        bf.append(" SELECT Entry.FID FROM T_CL_CostAdjustBill Bill");
        bf.append(" INNER JOIN T_CL_CostAdjustBillEntry Entry ON Bill.FID = Entry.FParentID");
        bf.append(" INNER JOIN T_IM_StoreType S ON S.FID = Entry.FStoreTypeID");
        bf.append(" WHERE Bill.FYear = ").append(periodInfo.getPeriodYear());
        bf.append(" AND Bill.FPeriod = ").append(periodInfo.getPeriodNumber());
        bf.append(" AND Bill.FCreateType = ").append(5);
        bf.append(" AND Entry.FCompanyOrgUnitID = '").append(companyOrgUnitID).append("'");
        bf.append(" AND Bill.FFiVouchered = 0 AND S.FIsForwardAmt = 1");
        bf.append(" )");
        String deleteEntrySQL = bf.toString();
        bf.setLength(0);
        bf.append("DELETE FROM T_CL_CostAdjustBill WHERE FID IN (");
        bf.append(" SELECT Bill.FID FROM T_CL_CostAdjustBill Bill");
        bf.append(" LEFT JOIN T_CL_CostAdjustBillEntry Entry ON Bill.FID = Entry.FParentID");
        bf.append(" WHERE Entry.FID IS NULL )");
        bf.append(" AND FFiVouchered = 0");
        String deleteBillSQL = bf.toString();
        sysTempTableHelper.execute(deleteTempTable);
        sysTempTableHelper.execute(deleteEntrySQL);
        sysTempTableHelper.execute(deleteBillSQL);
    }

    private void createCostAdjust(Context ctx, String tempTableName, CalculateParams params, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException {
        int issueType = params.getInt("COST_ADJUST_ISSUE_TYPE");
        String companyOrgUnitID = params.getString("COMPANY_ID");
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO T_CL_CostAdjustBill(FID,FNumber,FIssueType,FCreateType,");
        bf.append("FCalculateKind,FSupplierID,FStorageOrgUnitID,FBaseStatus,FSourceBillID,FSourceBillTypeID,FBillTypeID,");
        bf.append("FYear,FPeriod,FBizDate,FCreatorID,FCreateTime,FAuditorID,FAuditTime,FControlUnitID,FAdminOrgUnitId,FCostCenterOrgUnitId)");
        bf.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertBillSql = bf.toString();
        bf.setLength(0);
        bf.append("INSERT INTO T_CL_CostAdjustBillEntry(FID,FParentID,FStorageOrgUnitID,FCompanyOrgUnitID,");
        bf.append("FWareHouseID,FLot,FQty,FBaseQty,FPrice,FAmount,FStandardCost,FActualCost,FMaterialID,FUnitID,");
        bf.append("FBaseUnitID,FBaseStatus,FSourceBillID,FSourceBillEntryID,FSourceBillNumber,FSourceBillEntrySeq,FSeq,FStoreTypeID,FStoreStatusID");
        bf.append(",FBizDate,FAssistPropertyID,FLocationID,FProjectID,FTrackNumberID");
        bf.append(" )VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String insertEntrySql = bf.toString();
        bf.setLength(0);
        bf.append("SELECT");
        bf.append(" TempT.FID AS FID");
        bf.append(" ,TempT.FMaterialID AS FMaterialID");
        bf.append(" ,TempT.FStorageOrgUnitID AS FStorageOrgUnitID");
        bf.append(" ,TempT.FWarehouseID AS FWarehouseID");
        bf.append(" ,TempT.FIssueDiffAmount AS FIssueDiffAmount");
        bf.append(" ,Material.FBaseUnit AS FUnitID");
        bf.append(" ,TempT.FAssistPropertyID AS FAssistPropertyID");
        bf.append(" ,TempT.FLocationID AS FLocationID");
        bf.append(" ,TempT.FProjectID AS FProjectID");
        bf.append(" ,TempT.FTrackNumberID AS FTrackNumberID");
        bf.append(" ,TempT.FAdminOrgUnitId AS FAdminOrgUnitId");
        bf.append(" ,TempT.FCostCenterOrgUnitId AS FCostCenterOrgUnitId");
        bf.append(" ,TempT.FLot AS FLot");
        bf.append(" FROM ").append(tempTableName).append(" TempT");
        bf.append(" INNER JOIN T_BD_Material Material ON TempT.FMaterialID = Material.FID");
        bf.append(" WHERE TempT.FIssueDiffAmount <> 0");
        bf.append(" ORDER BY FStorageOrgUnitID,FAdminOrgUnitId,FCostCenterOrgUnitId ");
        String querySql = bf.toString();
        Connection conn = null;
        PreparedStatement pm1 = null;
        PreparedStatement pm2 = null;
        IRowSet rs = sysTempTableHelper.executeQuery(querySql);
        HashSet<String> entryIdSet = new HashSet<String>();
        try {
            conn = sysTempTableHelper.getConn();
            pm1 = conn.prepareStatement(insertBillSql);
            pm2 = conn.prepareStatement(insertEntrySql);
            String billID = BOSUuid.create((BOSObjectType)new CostAdjustBillInfo().getBOSType()).toString();
            int count = 0;
            String firstStorage = null;
            String firstAdminOrgId = null;
            String firstCostCenterId = null;
            String storageOrgUnitID = null;
            String adminOrgId = null;
            String costCenterId = null;
            String firstKey = null;
            String key = null;
            while (rs.next()) {
                storageOrgUnitID = rs.getString("FStorageOrgUnitID");
                adminOrgId = rs.getString("FAdminOrgUnitId");
                costCenterId = rs.getString("FCostCenterOrgUnitId");
                key = storageOrgUnitID + adminOrgId + costCenterId;
                if (!key.equals(firstKey) || count >= 30) {
                    billID = BOSUuid.create((BOSObjectType)new CostAdjustBillInfo().getBOSType()).toString();
                    pm2.executeBatch();
                    pm2.clearBatch();
                    count = 0;
                }
                entryIdSet.add(rs.getString("FID"));
                ++count;
                pm2.setString(1, rs.getString("FID"));
                pm2.setString(2, billID);
                pm2.setString(3, storageOrgUnitID);
                pm2.setString(4, companyOrgUnitID);
                pm2.setString(5, rs.getString("FWarehouseID"));
                pm2.setString(6, rs.getString("FLot"));
                pm2.setBigDecimal(7, CalculateUtil.ZERO);
                pm2.setBigDecimal(8, CalculateUtil.ZERO);
                pm2.setBigDecimal(9, CalculateUtil.ZERO);
                pm2.setBigDecimal(10, rs.getBigDecimal("FIssueDiffAmount"));
                pm2.setBigDecimal(11, CalculateUtil.ZERO);
                pm2.setBigDecimal(12, rs.getBigDecimal("FIssueDiffAmount"));
                pm2.setString(13, rs.getString("FMaterialID"));
                pm2.setString(14, rs.getString("FUnitID"));
                pm2.setString(15, rs.getString("FUnitID"));
                pm2.setInt(16, 4);
                pm2.setString(17, null);
                pm2.setString(18, null);
                pm2.setString(19, null);
                pm2.setInt(20, 0);
                pm2.setInt(21, count);
                pm2.setString(22, "181875d5-0105-1000-e000-0111c0a812fd97D461A6");
                pm2.setString(23, "181875d5-0105-1000-e000-012ec0a812fd62A73FA5");
                pm2.setTimestamp(24, this.getTime(periodInfo.getBeginDate()));
                pm2.setString(25, rs.getString("FAssistPropertyID"));
                pm2.setString(26, rs.getString("FLocationID"));
                pm2.setString(27, rs.getString("FProjectID"));
                pm2.setString(28, rs.getString("FTrackNumberID"));
                pm2.addBatch();
                if (count == 1) {
                    String number = String.valueOf(System.currentTimeMillis());
                    pm1.setString(1, billID);
                    pm1.setString(2, number);
                    pm1.setInt(3, issueType);
                    pm1.setInt(4, 5);
                    pm1.setInt(5, 1);
                    pm1.setString(6, null);
                    pm1.setString(7, storageOrgUnitID);
                    pm1.setInt(8, 4);
                    pm1.setString(9, null);
                    pm1.setString(10, null);
                    pm1.setString(11, "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552");
                    pm1.setInt(12, periodInfo.getPeriodYear());
                    pm1.setInt(13, periodInfo.getPeriodNumber());
                    pm1.setTimestamp(14, this.getTime(periodInfo.getBeginDate()));
                    pm1.setString(15, this.getCurrentUserID(ctx));
                    pm1.setTimestamp(16, this.getTime(new Date()));
                    pm1.setString(17, this.getCurrentUserID(ctx));
                    pm1.setTimestamp(18, this.getTime(new Date()));
                    pm1.setString(19, this.getControlUnitID(ctx));
                    pm1.setString(20, adminOrgId);
                    pm1.setString(21, costCenterId);
                    pm1.addBatch();
                }
                firstStorage = storageOrgUnitID;
                firstAdminOrgId = adminOrgId;
                firstCostCenterId = costCenterId;
                firstKey = firstStorage + firstAdminOrgId + firstCostCenterId;
            }
            pm1.executeBatch();
            if (count < 30) {
                pm2.executeBatch();
            }
            if (entryIdSet.size() != 0) {
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" update T_CL_CostAdjustBillEntry as t  ");
                updateSql.append(" set (FLocationID) = ( ");
                updateSql.append(" select top 1  t1.fid from T_DB_Location as t1 inner join T_DB_WAREHOUSE as t2 on t1.fwarehouseid = t2.fid ");
                updateSql.append(" where t.FLocationID is null and t2.fid = t.fwarehouseid and  t2.FHasLocation = 1 ");
                updateSql.append(" and t.fid in (" + CalculateUtil.getSqlInString(entryIdSet) + ") ");
                updateSql.append(" ) ");
                sysTempTableHelper.execute(new String[]{updateSql.toString()});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pm1);
                SQLUtils.cleanup(pm2);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pm1);
        SQLUtils.cleanup((Statement)pm2);
    }

    private Timestamp getTime(Date date) {
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        createtime.toString();
        return createtime;
    }

    private String getCurrentUserID(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        return userInfo.getId().toString();
    }

    private String getControlUnitID(Context ctx) {
        CtrlUnitInfo ctrlUnitInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        return null == ctrlUnitInfo ? "" : ctrlUnitInfo.getId().toString();
    }

    public static boolean isFullIssueCostAdjust(Context ctx, String companyOrgUnitID) throws EASBizException, BOSException {
        IParamControl ipc = null != ctx ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        ObjectUuidPK pk = new ObjectUuidPK(companyOrgUnitID);
        String calType = ipc.getParamValue((IObjectPK)pk, "SCM_CAL_005");
        return "0".equalsIgnoreCase(calType);
    }

    protected StringBuffer getSQLCostAdjJoinExtends() {
        return null;
    }
}

