/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.CalculateKindEnum;
import com.kingdee.eas.scm.cal.CostComputeReportInfo;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.interfaces.ICalculateCost;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculatePrecision;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffBill;
import com.kingdee.eas.scm.cal.app.calculate.model.CalculateWrittenOffEntry;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class MoveWeightedAverageCalculate
implements ICalculateCost {
    private Logger logger = Logger.getLogger(MoveWeightedAverageCalculate.class);
    public StringBuffer materialArrayList = new StringBuffer();
    private HashMap materialRecentCostHashMap = null;
    private ArrayList sqlArray = new ArrayList();
    private HashMap hmCalType = new HashMap();
    private HashMap hmCurrPeriod = new HashMap();
    private Context ctx = null;
    private boolean isCostBill = false;
    protected static final int NEW_OUT_PRICE = 0;
    protected static final int NEW_IN_PRICE = 1;
    protected static final int STANDARD_PRICE = 2;
    public final String newline = "\t\n";
    public static final String[][] INVENTORYBILL_TABLENAME = new String[][]{{"T_IM_PurInWarehsEntry", "T_IM_PurInWarehsBill"}, {"T_IM_ManufactureRecBillEntry", "T_IM_ManufactureRecBill"}, {"T_IM_MoveInWarehsBillEntry", "T_IM_MoveInWarehsBill"}, {"T_IM_OtherInWarehsBillEntry", "T_IM_OtherInWarehsBill"}, {"T_IM_SaleIssueEntry", "T_IM_SaleIssueBill"}, {"T_IM_MaterialReqBillEntry", "T_IM_MaterialReqBill"}, {"T_IM_MoveIssueBillEntry", "T_IM_MoveIssueBill"}, {"T_IM_OtherIssueBillEntry", "T_IM_OtherIssueBill"}, {"T_CL_CostAdjustBillEntry", "T_CL_CostAdjustBill"}};

    public void calculateCost(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo periodInfo, String materialCalType, BigDecimal sum, BigDecimal qty, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, boolean IS_WRITE_COST_COMPUTE_REPORT) throws EASBizException, BOSException {
        this.ctx = ctx;
        if (bill.getIsInitBill()) {
            this.logger.debug((Object)"---------\u5373\u65f6\u6210\u672c:\u521d\u59cb\u5316\u5355\u636e\u4e0d\u53c2\u4e0e\u6838\u7b97");
            return;
        }
        if (!this.isAffectCost(bill, entry)) {
            this.logger.debug((Object)"---------\u5373\u65f6\u6210\u672c:\u4e0d\u5f71\u54cd\u6210\u672c");
            return;
        }
        if (!AccountType.MOVE_ADD_AVERAGE.equals((Object)entry.getMaterialAccountType())) {
            this.logger.debug((Object)"---------\u5373\u65f6\u6210\u672c:\u975e\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u7b97\u6cd5\u7684\u7269\u6599\u4e0d\u9700\u8981\u8ba1\u7b97\u5373\u65f6\u6210\u672c");
            return;
        }
        if (CalculateUtil.ZERO.compareTo(sum) == 0 && CalculateUtil.ZERO.compareTo(qty) == 0) {
            this.logger.debug((Object)"---------\u5373\u65f6\u6210\u672c:\u5982\u6838\u9500\u6570\u91cf\u5dee\u7b49\u4e8e0\uff08\u6210\u672c\u8c03\u6574\u5355\uff09\u6838\u9500\u8bb0\u5f55\uff0c\u6838\u9500\u91d1\u989d\u5dee\u7b49\u4e8e0\uff08\u51b2\u9500\u5355\uff09\u6838\u9500\u8bb0\u5f55,\u5f53\u90fd\u4e3a0\u4e0d\u5f71\u54cd\u5373\u65f6\u6210\u672c\uff0c\u4e0d\u5904\u7406");
            return;
        }
        if (materialCalType == null) {
            throw new CalculateException(CalculateException.MATERIAL_CAL_KIND_NOT_EXIST);
        }
        if (periodInfo == null) {
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId().toString()));
            throw new CalculateException(CalculateException.ACCT_PERIOD_NOT_EXIST, new String[]{CalculateUtil.takeFormateDesc(companyOrgUnitInfo.getName(), companyOrgUnitInfo.getNumber())});
        }
        if (!this.hmCalType.containsKey(companyOrgUnitInfo.getId().toString())) {
            this.hmCalType.put(companyOrgUnitInfo.getId().toString(), materialCalType);
        }
        if (!this.hmCurrPeriod.containsKey(companyOrgUnitInfo.getId().toString())) {
            this.hmCurrPeriod.put(companyOrgUnitInfo.getId().toString(), periodInfo);
        }
        if (this.materialArrayList == null || this.materialArrayList.length() <= 0) {
            this.logger.debug((Object)"---------\u79fb\u52a8\u52a0\u6743\u5e73\u5747\u8ba1\u4ef7\u6cd5\u7269\u6599\u96c6\u5408\u4e3aNULL---------");
            return;
        }
        this.logger.debug((Object)"---------\u884c\u5373\u65f6\u6210\u672c\u5904\u7406------------------------");
        this.logger.debug((Object)("---------\u5373\u65f6\u6210\u672c createCostComputeReport: \u884c\uff1a" + entry.getSeq()));
        LowTimer t = new LowTimer();
        String id = CalculateUtil.getCalTypeMaterialKey(materialCalType, entry.getMaterialId(), companyOrgUnitInfo.getId().toString(), entry.getStorageOrgUnitId(), entry.getWarehouseId());
        if (this.materialRecentCostHashMap == null || this.materialRecentCostHashMap != null && this.materialRecentCostHashMap.get(id) == null) {
            this.takeMaterialRecentCost(ctx, companyOrgUnitInfo, this.materialArrayList, materialCalType, entry, id);
        }
        String settleAccountsDesc = new RecentCostHelp().calculateCost(ctx, materialCalType, entry, this.materialRecentCostHashMap, qty, sum);
        if (entry.getBaseUnitPrice() != null && entry.getPrecision() != null) {
            entry.setBaseUnitPrice(entry.getBaseUnitPrice().setScale(entry.getPrecision().getPricePrecision(), 4));
        }
        if (IS_WRITE_COST_COMPUTE_REPORT && settleAccountsDesc != null && settleAccountsDesc.length() > 0) {
            CostComputeReportInfo cinfo = CostComputeHelp.createCostComputeReport(ctx, materialCalType, periodInfo, sum, qty, entry.getPrecision(), settleAccountsDesc, bill, entry);
            this.addNewCostComputeReport(ctx, cinfo);
        }
        this.logger.debug((Object)("---------\u5373\u65f6\u6210\u672c createCostComputeReport: " + t.msValue()));
    }

    private boolean isAffectCost(CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry) {
        String storeType = entry.getStoreTypeId();
        if (("181875d5-0105-1000-e000-0111c0a812fd97D461A6".equals(storeType) || "181875d5-0105-1000-e000-011ac0a812fd97D461A6".equals(storeType) || "181875d5-0105-1000-e000-0123c0a812fd97D461A6".equals(storeType)) && bill.getIsParticipateInCalculate()) {
            this.logger.debug((Object)"\u662f\u5426\u5f71\u54cd\u6210\u672c:true");
            return true;
        }
        return false;
    }

    public void calculateCost(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo periodInfo, String materialCalType, CalculateWrittenOffBill bill, boolean IS_WRITE_COST_COMPUTE_REPORT) throws EASBizException, BOSException {
        if (this.materialArrayList == null || this.materialArrayList.length() <= 0) {
            return;
        }
        ArrayList purit = bill.getEntry();
        int size = purit.size();
        for (int i = 0; i < size; ++i) {
            CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)purit.get(i);
            this.calculateCost(ctx, companyOrgUnitInfo, periodInfo, materialCalType, entry.getAmount(), entry.getBaseUnitQty(), bill, entry, IS_WRITE_COST_COMPUTE_REPORT);
        }
    }

    public void calculateCost(Context ctx, String sql, boolean IS_WRITE_COST_COMPUTE_REPORT, CalculateKindEnum calculateKind) throws EASBizException, BOSException {
        this._calculateCost(ctx, sql, CalculateUtil.ONE, IS_WRITE_COST_COMPUTE_REPORT, calculateKind);
    }

    public void unCalculateCost(Context ctx, String sql, CalculateKindEnum calculateKind) throws EASBizException, BOSException {
        this._calculateCost(ctx, sql, CalculateUtil.ONE_MINUS, true, calculateKind);
    }

    private void _calculateCost(Context ctx, String sql, BigDecimal sign, boolean IS_WRITE_COST_COMPUTE_REPORT, CalculateKindEnum calculateKind) throws EASBizException, BOSException {
        Connection conn = null;
        try {
            CompanyOrgUnitInfo companyOrgUnitInfo;
            conn = EJBFactory.getConnection((Context)ctx);
            LowTimer t = new LowTimer();
            RowSet rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql);
            this.logger.debug((Object)("----\u53d6\u7269\u6599\u603b\u6570\u91cf\uff0c\u91d1\u989d runtime: " + t.msValue()));
            boolean isHasData = false;
            while (rs.next()) {
                isHasData = true;
                this.materialArrayList.append("'").append(rs.getString("FMATERIALID")).append("',");
                companyOrgUnitInfo = new CompanyOrgUnitInfo();
                companyOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FCompanyOrgUnitId")));
                if (!this.hmCalType.containsKey(rs.getString("FCompanyOrgUnitId"))) {
                    this.hmCalType.put(rs.getString("FCompanyOrgUnitId"), CalculateUtil.takeSysServerParamValue(ctx, companyOrgUnitInfo, "SCM_CAL_002"));
                }
                if (this.hmCurrPeriod.containsKey(rs.getString("FCompanyOrgUnitId"))) continue;
                this.hmCurrPeriod.put(rs.getString("FCompanyOrgUnitId"), SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo));
            }
            if (isHasData) {
                rs.beforeFirst();
                t.reset();
                while (rs.next()) {
                    companyOrgUnitInfo = new CompanyOrgUnitInfo();
                    companyOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FCompanyOrgUnitId")));
                    PeriodInfo periodInfo = (PeriodInfo)this.hmCurrPeriod.get(rs.getString("FCompanyOrgUnitId"));
                    String materialCalType = (String)this.hmCalType.get(rs.getString("FCompanyOrgUnitId"));
                    if (CalculateKindEnum.INPUT_WAREHOUSE == calculateKind) {
                        this.calculateCost(ctx, companyOrgUnitInfo, periodInfo, materialCalType, rs.getBigDecimal("FCost").multiply(sign), rs.getBigDecimal("FQty").multiply(sign), this.getBillInfo(ctx, rs, sign, calculateKind), this.getEntryInfo(ctx, companyOrgUnitInfo, rs, sign), IS_WRITE_COST_COMPUTE_REPORT);
                        continue;
                    }
                    this.calculateCost(ctx, companyOrgUnitInfo, periodInfo, materialCalType, rs.getBigDecimal("FCost"), rs.getBigDecimal("FQty"), this.getBillInfo(ctx, rs, sign, calculateKind), this.getEntryInfo(ctx, companyOrgUnitInfo, rs, sign), IS_WRITE_COST_COMPUTE_REPORT);
                }
            }
            this.logger.debug((Object)("----\u66f4\u65b0\u7269\u6599\u5373\u65f6\u6210\u672csql runtime: " + t.msValue()));
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private CalculateWrittenOffEntry getEntryInfo(Context ctx, CompanyOrgUnitInfo cou, ResultSet rs, BigDecimal sign) throws SQLException {
        CalculateWrittenOffEntry entry = new CalculateWrittenOffEntry();
        CalculatePrecision precision = new CalculatePrecision();
        String materialID = rs.getString("FMaterialID");
        String companyID = cou.getId().toString();
        String storageID = rs.getString("FStorageOrgUnitID");
        String warehouseID = rs.getString("FWarehouseID");
        if (materialID != null && materialID.trim().length() > 0) {
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)materialID));
            entry.setMaterial(materialInfo);
            entry.setMaterialId(materialID);
            entry.setMaterialAccountType(AccountType.getEnum((int)rs.getInt("FAccountType")));
            precision.setQtyPrecision(rs.getInt("FQtyPrecision"));
            precision.setPricePrecision(rs.getInt("FPricePrecision"));
            precision.setBaseQtyPrecision(rs.getInt("FQtyPrecision"));
        }
        if (companyID != null && companyID.trim().length() > 0) {
            entry.setFinanceOrg(cou);
            precision.setLocalCurrencyPrecision(rs.getInt("FLocalCurrencyPrecision"));
        }
        if (storageID != null && storageID.trim().length() > 0) {
            StorageOrgUnitInfo sou = new StorageOrgUnitInfo();
            sou.setId(BOSUuid.read((String)storageID));
            entry.setStorageOrg(sou);
            entry.setStorageOrgUnitId(storageID);
        }
        if (warehouseID != null && warehouseID.trim().length() > 0) {
            WarehouseInfo wi = new WarehouseInfo();
            wi.setId(BOSUuid.read((String)warehouseID));
            entry.setWarehouse(wi);
            entry.setWarehouseId(warehouseID);
        }
        entry.setAmount(rs.getBigDecimal("FCost").multiply(sign));
        entry.setBaseUnitQty(rs.getBigDecimal("FQty").multiply(sign));
        entry.setBaseUnitPrice(CalculateUtil.ZERO.compareTo(entry.getBaseUnitQty()) == 0 ? CalculateUtil.ZERO : entry.getAmount().divide(entry.getBaseUnitQty(), precision.getPricePrecision(), 4));
        entry.setPrecision(precision);
        entry.setExchangeRateAmount(new BigDecimal(1));
        entry.setExchangeRateQty(new BigDecimal(1));
        entry.setStoreTypeId("181875d5-0105-1000-e000-0111c0a812fd97D461A6");
        return entry;
    }

    private CalculateWrittenOffBill getBillInfo(Context ctx, RowSet rs, BigDecimal sign, CalculateKindEnum calculateKind) throws BOSException, EASBizException, SQLException {
        String transactionTypeName = " ";
        String number = " ";
        try {
            transactionTypeName = rs.getString("FDescriptionName");
            if (CalculateUtil.ONE_MINUS.compareTo(sign) == 0) {
                transactionTypeName = transactionTypeName + "[" + SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"UN_OPERATION", (Context)ctx) + "]";
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        CalculateWrittenOffBill bill = new CalculateWrittenOffBill();
        bill.setIsInitBill(false);
        bill.setIsParticipateInCalculate(true);
        bill.setCalculateKindEnum(calculateKind);
        bill.setTransactionTypeName(transactionTypeName);
        bill.setNumber(number);
        bill.setStoreTypeID("181875d5-0105-1000-e000-0111c0a812fd97D461A6");
        return bill;
    }

    private void takeMaterialRecentCost(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, StringBuffer materialIdSet, String materialCalType, CalculateWrittenOffEntry entry, String id) throws BOSException {
        if (entry == null) {
            return;
        }
        this.lockRecentcostTable(ctx, companyOrgUnitInfo, materialIdSet, materialCalType);
        StringBuffer sql = this.getRecentCostSql(companyOrgUnitInfo, materialCalType, entry);
        this.buildMaterialHashMap(ctx, materialCalType, sql);
        if (!this.materialRecentCostHashMap.containsKey(id)) {
            Object newRecordId = EJBTransactionProxy.invokeByManual((Object)this, (String)"insertRecentCostNewTx", (Class[])new Class[]{Context.class, String.class, CalculateWrittenOffEntry.class}, (Object[])new Object[]{ctx, materialCalType, entry}, (int)3);
            DBUtil.execute((Context)ctx, (String)("update t_cl_recentCost set fid = fid where fid = '" + newRecordId + "'"));
            HashMap<String, Object> innerHm = new HashMap<String, Object>();
            innerHm.put("isUpdate", true);
            innerHm.put("FPrice", BigDecimal.ZERO);
            innerHm.put("FRecentQty", BigDecimal.ZERO);
            innerHm.put("FRecentCost", BigDecimal.ZERO);
            innerHm.put("FMaterialID", entry.getMaterialId());
            innerHm.put("FCompanyOrgUnitID", entry.getFinanceOrg().getId().toString());
            String newKey = CalculateUtil.getCalTypeMaterialKey(materialCalType, entry.getMaterialId(), entry.getFinanceOrg().getId().toString(), entry.getStorageOrgUnitId(), entry.getWarehouseId());
            this.materialRecentCostHashMap.put(newKey, innerHm);
        }
    }

    private StringBuffer getRecentCostSql(CompanyOrgUnitInfo companyOrgUnitInfo, String materialCalType, CalculateWrittenOffEntry entry) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID");
        if (!"0".equals(materialCalType)) {
            sql.append(",FStorageOrgUnitID");
        }
        if ("2".equals(materialCalType)) {
            sql.append(",FWarehouseID");
        }
        sql.append(",FRecentCost AS FRecentCost,FRecentQty AS FRecentQty,FPrice AS FPrice ");
        sql.append(" from t_cl_recentcost");
        sql.append(" where fmaterialid = '").append(entry.getMaterialId()).append("'");
        sql.append(" and fcompanyorgunitid = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        if (!"0".equals(materialCalType)) {
            sql.append(" and FStorageOrgUnitID = '").append(entry.getStorageOrgUnitId()).append("'");
        }
        if ("2".equals(materialCalType)) {
            sql.append(" and FWarehouseID = '").append(entry.getWarehouseId()).append("'");
        }
        return sql;
    }

    private String insertRecentCostNewTx(Context ctx, String calcType, CalculateWrittenOffEntry entry) throws BOSException, SQLException {
        String sql = RecentCostHelp.getInsertPrepareRecentCostSQL();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)"select newbosid('D2B6D7EB')");
        rs.next();
        String id = rs.getString(1);
        Object[] param = new Object[8];
        param[0] = id;
        param[1] = BigDecimal.ZERO;
        param[2] = BigDecimal.ZERO;
        param[3] = BigDecimal.ZERO;
        param[4] = entry.getMaterialId();
        param[5] = entry.getFinanceOrg().getId().toString();
        if (!"0".equals(calcType)) {
            param[6] = entry.getStorageOrgUnitId();
        }
        if ("2".equals(calcType)) {
            param[7] = entry.getWarehouseId();
        }
        DBUtil.execute((Context)ctx, (String)sql, (Object[])param);
        return id;
    }

    private HashMap takeMaterialRecentCost(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, StringBuffer materialIdSet, String materialCalType) throws BOSException {
        String temp = materialIdSet.toString();
        if (temp == null || temp.length() <= 0) {
            return this.materialRecentCostHashMap;
        }
        if ((temp = temp.trim()).endsWith(",")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.startsWith(",")) {
            temp = temp.substring(1, temp.length());
        }
        this.lockRecentcostTable(ctx, companyOrgUnitInfo, materialIdSet, materialCalType);
        StringBuffer sql = new StringBuffer();
        sql.append(" select FMaterialID,FCompanyOrgUnitID");
        if (!"0".equals(materialCalType)) {
            sql.append(",FStorageOrgUnitID");
        }
        if ("2".equals(materialCalType)) {
            sql.append(",FWarehouseID");
        }
        sql.append(",AVG(DISTINCT FRecentCost) AS FRecentCost,AVG(DISTINCT FRecentQty) AS FRecentQty,AVG(DISTINCT FPrice) AS FPrice ");
        sql.append(" from t_cl_recentcost");
        sql.append(" where fmaterialid in (").append(temp).append(")");
        sql.append(" and fcompanyorgunitid = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        sql.append(RecentCostHelp.getGroupSegmentByCalMode(materialCalType));
        sql.append(" , FMaterialID");
        return this.buildMaterialHashMap(ctx, materialCalType, sql);
    }

    private HashMap buildMaterialHashMap(Context ctx, String materialCalType, StringBuffer sql) throws SQLDataException {
        if (this.materialRecentCostHashMap == null) {
            this.materialRecentCostHashMap = new HashMap();
        }
        Connection conn = null;
        RowSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            rs = SQLUtils.getJdbcRowSet((Connection)conn, (String)sql.toString());
            while (rs.next()) {
                HashMap<String, Object> innerHm = new HashMap<String, Object>();
                innerHm.put("isUpdate", new Boolean(true));
                innerHm.put("FPrice", rs.getBigDecimal("FPrice"));
                innerHm.put("FRecentQty", rs.getBigDecimal("FRecentQty"));
                innerHm.put("FRecentCost", rs.getBigDecimal("FRecentCost"));
                innerHm.put("FMaterialID", rs.getString("FMaterialID"));
                innerHm.put("FCompanyOrgUnitID", rs.getString("FCompanyOrgUnitID"));
                String id = CalculateUtil.getCalTypeMaterialKey(materialCalType, rs.getString("FMaterialID"), rs.getString("FCompanyOrgUnitID"), rs.getString("FStorageOrgUnitID"), rs.getString("FWarehouseID"));
                this.materialRecentCostHashMap.put(id.toString(), innerHm);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((ResultSet)rs);
        return this.materialRecentCostHashMap;
    }

    private void createSQLMaterialRecentCost() throws EASBizException, BOSException {
        if (this.materialRecentCostHashMap == null || this.materialRecentCostHashMap.size() <= 0) {
            return;
        }
        this.logger.debug((Object)("materialRecentCostHashMap \u6570:" + this.materialRecentCostHashMap.size()));
        for (Map.Entry mapentry : this.materialRecentCostHashMap.entrySet()) {
            if (mapentry.getKey() == null || mapentry.getValue() == null) continue;
            HashMap innerHm = (HashMap)mapentry.getValue();
            String returnStrSQL = null;
            String materialCalType = (String)this.hmCalType.get(innerHm.get("FCompanyOrgUnitID"));
            String storageOrgUnitID = null;
            String warehouseID = null;
            if (!this.isCostBill && ((BigDecimal)innerHm.get("FPrice")).compareTo(CalculateUtil.ZERO) < 0) {
                IMaterial im = MaterialFactory.getLocalInstance((Context)this.ctx);
                MaterialInfo minfo = im.getMaterialInfo((IObjectPK)new ObjectUuidPK((String)innerHm.get("FMaterialID")));
                throw new CalculateException(CalculateException.MATERIAL_RECENT_UNIT_COST_LESS_ZERO, new String[]{CalculateUtil.takeFormateDesc(minfo.getName(), minfo.getNumber())});
            }
            if (!"0".equals(materialCalType) && null == (storageOrgUnitID = (String)innerHm.get("FStorageOrgUnitID")) || "2".equals(materialCalType) && null == (warehouseID = (String)innerHm.get("FWarehouseID")) || (returnStrSQL = (Boolean)innerHm.get("isUpdate") != false ? RecentCostHelp.updateRecentCostSQL((BigDecimal)innerHm.get("FPrice"), (BigDecimal)innerHm.get("FRecentQty"), (BigDecimal)innerHm.get("FRecentCost"), (String)innerHm.get("FMaterialID"), (String)innerHm.get("FCompanyOrgUnitID"), storageOrgUnitID, warehouseID, materialCalType).toString() : RecentCostHelp.insertRecentCostSQL((BigDecimal)innerHm.get("FPrice"), (BigDecimal)innerHm.get("FRecentQty"), (BigDecimal)innerHm.get("FRecentCost"), (String)innerHm.get("FMaterialID"), (String)innerHm.get("FCompanyOrgUnitID"), (String)innerHm.get("FStorageOrgUnitID"), (String)innerHm.get("FWarehouseID")).toString()) == null) continue;
            this.sqlArray.add(returnStrSQL);
        }
    }

    @Override
    public boolean calculateCost(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)params.getObject("COMPANY_OBJ");
        PeriodInfo periodInfo = (PeriodInfo)params.getObject("PERIOD_OBJ");
        String materialCalType = params.getString("CALTYPE");
        BigDecimal amount = params.getBigDecimal("Amount");
        BigDecimal qty = params.getBigDecimal("Qty");
        CalculateWrittenOffBill bill = (CalculateWrittenOffBill)params.getObject("BILL");
        CalculateWrittenOffEntry entry = (CalculateWrittenOffEntry)params.getObject("ENTRYCOLL");
        boolean IS_WRITE_COST_COMPUTE_REPORT = params.getBoolean("ISWRITECOSTCOMPUTEREPORT");
        this.calculateCost(ctx, companyOrgUnitInfo, periodInfo, materialCalType, amount, qty, bill, entry, IS_WRITE_COST_COMPUTE_REPORT);
        return true;
    }

    public boolean commit(Context ctx) throws EASBizException, BOSException {
        LowTimer t = new LowTimer();
        ArrayList sqlArray = this.getCalculatorProcessSqlArray();
        if (sqlArray == null || sqlArray.size() < 1) {
            return false;
        }
        Connection conn = null;
        Statement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.createStatement();
            int size = sqlArray.size();
            this.logger.debug((Object)("updateTurnOverNoteWriteOffSQL \u6570:" + size));
            for (int i = 0; i < size; ++i) {
                ps.addBatch((String)sqlArray.get(i));
            }
            this.logger.debug((Object)("sqlArray addBatchTime:" + t.msValue()));
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                this.sqlArray.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        this.sqlArray.clear();
        this.logger.debug((Object)("sqlArray runtime:" + t.msValue()));
        return true;
    }

    private void addNewCostComputeReport(Context ctx, CostComputeReportInfo cinfo) throws EASBizException, BOSException {
        this.sqlArray.add(CostComputeHelp.createCostComputeReport(ctx, cinfo).toString());
    }

    public ArrayList getCalculatorProcessSqlArray() throws EASBizException, BOSException {
        this.logger.debug((Object)("CostComputeReport \u6570:" + this.sqlArray.size()));
        this.createSQLMaterialRecentCost();
        return this.sqlArray;
    }

    protected void takeOutWarehouseCost(Context ctx, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, String materialCalType, CalculateKindEnum ckenum, String tableNameEntry) throws EASBizException, BOSException {
        if (!this.isAffectCost(bill, entry)) {
            return;
        }
        if (bill.isReversed()) {
            return;
        }
        if (AccountType.STANDARDCOST.equals((Object)entry.getMaterialAccountType())) {
            // empty if block
        }
        if (AccountType.MOVE_ADD_AVERAGE.equals((Object)entry.getMaterialAccountType())) {
            RecentCostInfo recentCostInfo = null;
            recentCostInfo = CostComputeHelp.isRedBill(bill, entry) ? this.getRedBillCost(ctx, bill, entry, materialCalType, ckenum, tableNameEntry) : RecentCostHelp.getMaterialRecentCost(ctx, materialCalType, entry, ckenum, this.materialRecentCostHashMap);
            if (bill.getBillType().equals("102") && bill.getTransactionTypeID().equals("wxI1pBHYRwCcMmgJoF8w5rAI3Kc=")) {
                String orderEntryID = entry.getOrderBillEntryId();
                String sql = "select FActualCost,FUnitActualCost from t_im_purinwarehsentry where FPurOrderEntryID = '" + orderEntryID + "'";
                IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql);
                try {
                    if (rs != null && rs.next()) {
                        recentCostInfo.setRecentCost(rs.getBigDecimal("FActualCost"));
                        recentCostInfo.setPrice(rs.getBigDecimal("FUnitActualCost"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            if (CalculateUtil.ZERO.compareTo(recentCostInfo.getRecentCost()) != 0 && CalculateUtil.ZERO.compareTo(recentCostInfo.getPrice()) != 0) {
                this.logger.debug((Object)"\u53d6\u5373\u65f6\u51fa\u5e93\u6210\u672c\u53ca\u5355\u4ef7\u3002");
                entry.setAmount(recentCostInfo.getRecentCost());
                entry.setBaseUnitPrice(recentCostInfo.getPrice());
                entry.setInvoUnitPrice(recentCostInfo.getPrice());
            } else {
                this.logger.debug((Object)"\u5373\u65f6\u51fa\u5e93\u6210\u672c\u6216\u5355\u4ef7\u4e3a0\uff0c\u4ee5\u5355\u636e\u6210\u672c\u4e3a\u51c6\u3002");
                if (!(CalculateUtil.ZERO.compareTo(entry.getAmount()) != 0 || "50957179-0105-1000-e004-4152c0a812fd463ED552".equals(entry.getSourceBillTypeID()) && CalculateUtil.ZERO.compareTo(entry.getBaseUnitQty()) == 0 || "t_im_materialreqbillentry".equalsIgnoreCase(tableNameEntry))) {
                    throw RecentCostHelp.throwException(ctx, CalculateException.MATERIAL_RECENT_COST_EQUAL_ZERO, materialCalType, entry, recentCostInfo.getString("exception_msg"));
                }
            }
            if ("t_im_saleissueentry".equalsIgnoreCase(tableNameEntry)) {
                entry.setWrittenOffAmt(CalculateUtil.ZERO);
                entry.setUnWriteOffAmt(entry.getAmount());
                if (entry.getWrittenOffQty().abs().compareTo(entry.getBaseUnitQty().abs()) == 0) {
                    entry.setWrittenOffAmt(entry.getAmount());
                    entry.setUnWriteOffAmt(CalculateUtil.ZERO);
                }
            }
        }
    }

    private void lockRecentcostTable(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, StringBuffer materialIdSet, String materialCalType) throws BOSException {
        String temp = materialIdSet.toString();
        if (temp == null || temp.length() <= 0) {
            return;
        }
        if ((temp = temp.trim()).endsWith(",")) {
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.startsWith(",")) {
            temp = temp.substring(1, temp.length());
        }
        StringBuffer lockBuffer = new StringBuffer();
        lockBuffer.append("UPDATE T_CL_RECENTCOST SET FID = FID ");
        lockBuffer.append("\n where fmaterialid in (").append(temp).append(")");
        lockBuffer.append("\n and fcompanyorgunitid = '").append(companyOrgUnitInfo.getId().toString()).append("'");
        DBUtil.execute((Context)ctx, (String)lockBuffer.toString());
    }

    public HashMap getMaterialRecentCostHashMap() {
        return this.materialRecentCostHashMap;
    }

    private RecentCostInfo getSourceBillCost(Context ctx, String entryTableName, CalculateWrittenOffEntry entry) throws BOSException {
        RecentCostInfo recentCostInfo = new RecentCostInfo();
        recentCostInfo.setRecentCost(CalculateUtil.ZERO);
        recentCostInfo.setPrice(CalculateUtil.ZERO);
        StringBuffer sql = new StringBuffer();
        sql.append(" select decimal(t1.funitactualcost / t2.FBaseConvsRate,17,8) as funitactualcost  ");
        sql.append(" from ").append(entryTableName).append(" t1 ");
        sql.append(" inner join t_bd_multimeasureunit t2 on t1.fmaterialid = t2.fmaterialid and t1.funitid = t2.fmeasureunitid ");
        sql.append(" where t1.fid ='").append(entry.getSourceBillEntryId()).append("'");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                recentCostInfo.setRecentCost(entry.getBaseUnitQty().multiply(rs.getBigDecimal("funitactualcost")));
                recentCostInfo.setPrice(rs.getBigDecimal("funitactualcost"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return recentCostInfo;
    }

    private RecentCostInfo getBillCost(CalculateWrittenOffEntry entry) {
        RecentCostInfo recentCostInfo = new RecentCostInfo();
        recentCostInfo.setRecentCost(CalculateUtil.ZERO);
        recentCostInfo.setPrice(CalculateUtil.ZERO);
        if (entry.getBaseUnitPrice() != null) {
            recentCostInfo.setRecentCost(entry.getBaseUnitQty().multiply(entry.getBaseUnitPrice()));
            recentCostInfo.setPrice(entry.getBaseUnitPrice());
        }
        return recentCostInfo;
    }

    private RecentCostInfo getBillCost4Out(Context ctx, String materialCalType, CalculateWrittenOffEntry entry, CalculateKindEnum ckenum) throws EASBizException, BOSException {
        RecentCostInfo recentCostInfo = null;
        recentCostInfo = RecentCostHelp.getMaterialRecentCost(ctx, materialCalType, entry, ckenum, this.materialRecentCostHashMap);
        if (CalculateUtil.ZERO.compareTo(recentCostInfo.getRecentCost()) == 0 && CalculateUtil.ZERO.compareTo(recentCostInfo.getPrice()) == 0) {
            recentCostInfo = this.getBillCost(entry);
        }
        return recentCostInfo;
    }

    private RecentCostInfo getBillCost4In(Context ctx, String materialCalType, CalculateWrittenOffEntry entry, CalculateKindEnum ckenum) throws EASBizException, BOSException {
        RecentCostInfo recentCostInfo = null;
        recentCostInfo = this.getBillCost(entry);
        if (CalculateUtil.ZERO.compareTo(recentCostInfo.getRecentCost()) == 0 && CalculateUtil.ZERO.compareTo(recentCostInfo.getPrice()) == 0) {
            recentCostInfo = RecentCostHelp.getMaterialRecentCost(ctx, materialCalType, entry, ckenum, this.materialRecentCostHashMap);
        }
        return recentCostInfo;
    }

    private boolean isHasSourceBill(String billType, String sourceBillType, CalculateWrittenOffEntry entry) {
        boolean flag = true;
        if (sourceBillType == null || !billType.equals(sourceBillType) || entry.getSrcCompanyOrg() == null || !entry.getSrcCompanyOrg().getId().equals((Object)entry.getFinanceOrg().getId())) {
            flag = false;
        }
        return flag;
    }

    private RecentCostInfo getRedBillCost(Context ctx, CalculateWrittenOffBill bill, CalculateWrittenOffEntry entry, String materialCalType, CalculateKindEnum ckenum, String tableNameEntry) throws EASBizException, BOSException {
        boolean isNotSrcBill;
        RecentCostInfo recentCostInfo = null;
        boolean isHasSourceBill = this.isHasSourceBill(bill.getBillType(), SCMUtils.getBillTypeNOFormBillTypeID((String)entry.getSourceBillTypeID()), entry);
        recentCostInfo = isHasSourceBill && !bill.isIssysbill() ? this.getSourceBillCost(ctx, tableNameEntry, entry) : ((isNotSrcBill = CalculateUtil.getCostCalculateParam(ctx, entry.getFinanceOrg().getId().toString(), "SCM_CAL_014")) ? this.getBillCost4In(ctx, materialCalType, entry, ckenum) : this.getBillCost4Out(ctx, materialCalType, entry, ckenum));
        if (CalculateUtil.ZERO.compareTo(recentCostInfo.getPrice()) == 0 && CalculateUtil.ZERO.compareTo(recentCostInfo.getRecentCost()) == 0) {
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            String companyId = entry.getFinanceOrg().getId().toString();
            String materialId = entry.getMaterialId();
            int periodInfo = bill.getPeriodYear() * 100 + bill.getPeriod();
            BigDecimal newPrice = CalculateUtil.ZERO;
            int priceType = Integer.parseInt(iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(entry.getFinanceOrg().getId().toString()), "SCM_CAL_017"));
            if (priceType == 0) {
                newPrice = this.getNewInOrOutPrice(ctx, periodInfo, companyId, materialId, materialCalType, true, false, this.getFifoCalTypeKey(entry, materialCalType));
            } else if (priceType == 1) {
                newPrice = this.getNewInOrOutPrice(ctx, periodInfo, companyId, materialId, materialCalType, true, true, this.getFifoCalTypeKey(entry, materialCalType));
            } else if (priceType == 2) {
                newPrice = this.getMaterialStandardCost(ctx, companyId, materialId);
            }
            recentCostInfo.setRecentCost(entry.getBaseUnitQty().multiply(newPrice));
            recentCostInfo.setPrice(newPrice);
        }
        return recentCostInfo;
    }

    protected BigDecimal getNewInOrOutPrice(Context ctx, int periodInfo, String companyId, String materialId, String calType, boolean includeBeforePeriod, boolean isInPrice, String fkey) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        if (companyId == null || materialId == null || periodInfo == 0) {
            return newPrice;
        }
        String getSQL = this.getNewInOrOutPriceSQL(periodInfo, companyId, materialId, calType, includeBeforePeriod, isInPrice, fkey);
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getSQL);
        try {
            if (rs.next()) {
                newPrice = rs.getBigDecimal("FBaseUnitActualCost");
            }
            return newPrice;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected BigDecimal getMaterialStandardCost(Context ctx, String companyId, String materialId) throws BOSException {
        BigDecimal newPrice = CalculateUtil.ZERO;
        if (companyId == null || materialId == null) {
            return newPrice;
        }
        String getMaterialStandardCostSql = "select ISNULL(FStandardCost,0) as FStandardCost from T_BD_MaterialCompanyInfo where FMaterialid='" + materialId + "' and FCompanyid='" + companyId + "'";
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)getMaterialStandardCostSql);
        try {
            if (rs.next()) {
                newPrice = rs.getBigDecimal("FStandardCost");
            }
            return newPrice;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getNewInOrOutPriceSQL(int periodInfo, String CompanyId, String materialId, String strCalType, boolean includeBeforePeriod, boolean isInPrice, String fkey) {
        int i;
        if (CompanyId == null || materialId == null || periodInfo == 0) {
            return null;
        }
        String storageOrgUnitID = null;
        String wareHouseID = null;
        if (fkey.length() > 0 && fkey.split("\\_\\$\\$\\$\\$\\_").length >= 2) {
            String[] temp = fkey.split("\\_\\$\\$\\$\\$\\_");
            if ("1".equals(strCalType)) {
                storageOrgUnitID = temp[1];
            } else if ("2".equals(strCalType)) {
                storageOrgUnitID = temp[1];
                wareHouseID = temp[2];
            }
        }
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append("Where Bill.FBaseStatus = ").append(4).append("\t\n");
        whereSQL.append("  And ISNULL(BILL.FIsInitBill, 0) = 0 And ISNULL(Bill.FIsReversed, 0) = 0").append("\t\n");
        whereSQL.append("  And Entry.FUnitActualCost > 0").append("\t\n");
        whereSQL.append("  And Entry.FCompanyOrgUnitId = '").append(CompanyId).append("'").append("\t\n");
        if ("2".equals(strCalType)) {
            if (!StringUtil.isEmpty((String)storageOrgUnitID)) {
                whereSQL.append(" AND ").append("Entry.FStorageOrgUnitID = '").append(storageOrgUnitID).append("'").append("\t\n");
            }
            if (!StringUtil.isEmpty((String)wareHouseID)) {
                whereSQL.append(" AND ").append("Entry.FWarehouseID = '").append(wareHouseID).append("'").append("\t\n");
            }
        } else if ("1".equals(strCalType) && !StringUtil.isEmpty((String)storageOrgUnitID)) {
            whereSQL.append(" AND ").append("Entry.FStorageOrgUnitID = '").append(storageOrgUnitID).append("'").append("\t\n");
        }
        whereSQL.append("  And Entry.FMaterialId = '").append(materialId).append("'").append("\t\n");
        whereSQL.append("  And SCMTRANSACTIONTYPE.FIsCalculate = 1").append("\t\n");
        if (includeBeforePeriod) {
            whereSQL.append("  And Bill.FYear * 100 + Bill.FPeriod <= ").append(periodInfo);
        } else {
            whereSQL.append("  And Bill.FYear = ").append(periodInfo / 100).append("  And Bill.FPeriod = ").append(periodInfo % 100);
        }
        String calTypeSQL = this.getCalTypeSQL(strCalType, "Entry");
        StringBuffer selectBillPriceSQL = new StringBuffer();
        selectBillPriceSQL.append("Select Entry.FCompanyOrgUnitId, ").append("\t\n");
        selectBillPriceSQL.append(calTypeSQL);
        selectBillPriceSQL.append(" Entry.FMaterialId,Bill.FBizDate,").append("\t\n");
        selectBillPriceSQL.append(" CASE WHEN ENTRY.FUNITID=ENTRY.FBASEUNITID OR ENTRY.FBaseQty=0 THEN ISNULL(ENTRY.FUNITACTUALCOST,0)").append("\t\n");
        selectBillPriceSQL.append("     ELSE TO_Decimal(ISNULL(ENTRY.FActualCost,0)/ENTRY.FBaseQty, 21, 8)").append("\t\n");
        selectBillPriceSQL.append(" END AS FBaseUnitActualCost");
        String selectMaxBizDateSQL = "Select Entry.FCompanyOrgUnitId," + calTypeSQL + " Entry.FMaterialId,Max(Bill.FBizDate) as FBizDate";
        String groupBySQL = "Group By Entry.FCompanyOrgUnitId," + calTypeSQL + " Entry.FMaterialId";
        StringBuffer sSQL = new StringBuffer();
        sSQL.append("Select Temp.FCompanyOrgUnitId,");
        sSQL.append(this.getCalTypeSQL(strCalType, "Temp"));
        sSQL.append(" Temp.FMaterialId,Max(Temp.FBaseUnitActualCost) as FBaseUnitActualCost From (").append("\t\n");
        int start = 0;
        int end = 0;
        if (isInPrice) {
            start = 0;
            end = 3;
        } else {
            start = 4;
            end = 7;
        }
        for (i = start; i <= end; ++i) {
            if (i > start) {
                sSQL.append("\t\n").append("\t\n").append(" Union All ").append("\t\n").append("\t\n");
            }
            sSQL.append(" ").append(selectBillPriceSQL).append("\t\n");
            sSQL.append(" From ").append(INVENTORYBILL_TABLENAME[i][0]).append(" Entry").append("\t\n");
            sSQL.append(" INNER JOIN ").append(INVENTORYBILL_TABLENAME[i][1]).append(" Bill On Bill.FID = Entry.FParentID").append("\t\n");
            sSQL.append(" INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE");
            sSQL.append(" ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append("\t\n");
            sSQL.append(" ").append(whereSQL);
        }
        sSQL.append(") Temp Inner Join (").append("\t\n");
        sSQL.append(" ").append("Select Entry.FCompanyOrgUnitId,");
        sSQL.append(this.getCalTypeSQL(strCalType, "Entry"));
        sSQL.append(" Entry.FMaterialId,Max(Entry.FBizDate) as FBizDate").append(" From (").append("\t\n");
        for (i = start; i <= end; ++i) {
            if (i > start) {
                sSQL.append("\t\n").append("\t\n").append("  Union All ").append("\t\n").append("\t\n");
            }
            sSQL.append("  ").append(selectMaxBizDateSQL).append("\t\n");
            sSQL.append("  From ").append(INVENTORYBILL_TABLENAME[i][0]).append(" Entry").append("\t\n");
            sSQL.append("  INNER JOIN ").append(INVENTORYBILL_TABLENAME[i][1]).append(" Bill On Bill.FID = Entry.FParentID").append("\t\n");
            sSQL.append("  INNER JOIN T_SCM_TransactionType SCMTRANSACTIONTYPE");
            sSQL.append(" ON BILL.FTransactionTypeID = SCMTRANSACTIONTYPE.FID").append("\t\n");
            sSQL.append("  ").append(whereSQL).append("\t\n");
            sSQL.append("  ").append(groupBySQL);
        }
        sSQL.append("\t\n").append(" ) Entry ").append(groupBySQL).append("\t\n");
        sSQL.append(") MaxBizDate ON Temp.FCompanyOrgUnitId = MaxBizDate.FCompanyOrgUnitId").append("\t\n");
        if ("2".equals(strCalType)) {
            sSQL.append(" And Temp.FStorageOrgUnitID = MaxBizDate.FStorageOrgUnitID And Temp.FWarehouseID = MaxBizDate.FWarehouseID ").append("\t\n");
        } else if ("1".equals(strCalType)) {
            sSQL.append(" And Temp.FStorageOrgUnitID = MaxBizDate.FStorageOrgUnitID ").append("\t\n");
        }
        sSQL.append("And Temp.FMaterialId = MaxBizDate.FMaterialId").append("\t\n");
        sSQL.append("And Temp.FBizDate = MaxBizDate.FBizDate").append("\t\n");
        sSQL.append("Group By Temp.FCompanyOrgUnitId,");
        sSQL.append(this.getCalTypeSQL(strCalType, "Temp"));
        sSQL.append("Temp.FMaterialId");
        return sSQL.toString();
    }

    private String getCalTypeSQL(String strCalType, String tablename) {
        StringBuffer calTypeSQL = new StringBuffer();
        if ("2".equals(strCalType)) {
            calTypeSQL.append(" Entry.FStorageOrgUnitID ,Entry.FWarehouseID, ").append("\t\n");
        } else if ("1".equals(strCalType)) {
            calTypeSQL.append(" Entry.FStorageOrgUnitID, ").append("\t\n");
        } else {
            calTypeSQL.append(" ").append("\t\n");
        }
        return calTypeSQL.toString().replaceAll("Entry", tablename);
    }

    protected String getFifoCalTypeKey(CalculateWrittenOffEntry entry, String strCalType) {
        StringBuffer buffer = new StringBuffer();
        String companyID = entry.getFinanceOrg().getId().toString();
        String storageID = entry.getStorageOrgUnitId();
        String wareHouseID = entry.getWarehouseId();
        if ("0".equals(strCalType)) {
            buffer.append(companyID);
        } else if ("1".equals(strCalType)) {
            buffer.append(companyID);
            if (storageID != null) {
                buffer.append("_$$$$_").append(storageID);
            }
        } else {
            buffer.append(companyID);
            if (storageID != null) {
                buffer.append("_$$$$_").append(storageID);
            }
            if (wareHouseID != null) {
                buffer.append("_$$$$_").append(wareHouseID);
            }
        }
        return buffer.toString();
    }

    public boolean isCostBill() {
        return this.isCostBill;
    }

    public void setCostBill(boolean isCostBill) {
        this.isCostBill = isCostBill;
    }
}

