/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.cal.app.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.common.perf.IJobInstStatusFacade;
import com.kingdee.eas.basedata.common.perf.JobInstStatusFacadeFactory;
import com.kingdee.eas.basedata.master.material.AccountType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.cal.CalculateException;
import com.kingdee.eas.scm.cal.PriceSourEnum;
import com.kingdee.eas.scm.cal.RecentCostInfo;
import com.kingdee.eas.scm.cal.app.BalanceCostInfo;
import com.kingdee.eas.scm.cal.app.calculate.AbstractCalculateCost;
import com.kingdee.eas.scm.cal.app.calculate.MoveAverageReCalculateNew;
import com.kingdee.eas.scm.cal.app.help.CostComputeHelp;
import com.kingdee.eas.scm.cal.app.help.RecentCostHelp;
import com.kingdee.eas.scm.cal.app.help.UpdateBillCostHelper;
import com.kingdee.eas.scm.cal.util.CalculateParams;
import com.kingdee.eas.scm.cal.util.CalculateUtil;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.app.util.SysTempTableHelper;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.util.LowTimer;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class MoveingWeightedAverageCalculate
extends AbstractCalculateCost {
    private Logger logger = Logger.getLogger(MoveAverageReCalculateNew.class);
    private CountDownLatch countDown = null;

    @Override
    protected AccountType[] takeMaterialAccountType() {
        return new AccountType[]{AccountType.MOVE_WEIGHTED_AVERAGE};
    }

    @Override
    protected boolean calculateStrategy(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement reptPs = null;
        LowTimer timer = new LowTimer();
        conn = sysTempTableHelper.getConn();
        params.setBoolean("isCalReversed", true);
        params.setBoolean("IsNeedReWork", true);
        PeriodInfo perPeriod = null;
        try {
            perPeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
            params.setObject("perPeriod", (Object)perPeriod);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean isNotSrcBill = CalculateUtil.getCostCalculateParam(ctx, params.getString("COMPANY_ID"), "SCM_CAL_014");
        boolean srcBillisPreperiod = CalculateUtil.getCostCalculateParam(ctx, params.getString("COMPANY_ID"), "SCM_CAL_015");
        params.setBoolean("isNotSrcOutBillCalType", isNotSrcBill);
        params.setBoolean("isSrcPerBillOutBillCalType", srcBillisPreperiod);
        params.setBoolean("calculteCostPriceMovein", true);
        params.setString("ERROR_MSG", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"COST_NOT_PRICE", (Context)ctx));
        params.setString("DETAILADJUST", SCMUtils.getResource((String)"com.kingdee.eas.scm.cal.CalCommonResource", (String)"DETAILADJUST", (Context)ctx));
        String jobId = (String)ctx.get((Object)"SCM_JOB_INST_ID");
        IJobInstStatusFacade iJobInstStatusFacade = JobInstStatusFacadeFactory.getLocalInstance((Context)ctx);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 15, "Extract data into the temporary table", "\u53d6\u6570\u636e\u5230\u4e34\u65f6\u8868\u4e2d", "\u53d6\u6578\u64da\u5230\u81e8\u6642\u88f1\u4e2d");
        }
        String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
        String tempMaterialTable = params.getString("T_Temp_FIFOMaterialList");
        this.beforeCalculate(ctx, params, strCalType, periodInfo, sysTempTableHelper, conn, reptPs, timer, tempTableFIFOBills, tempMaterialTable);
        if (!StringUtils.isEmpty((String)jobId)) {
            iJobInstStatusFacade.updateProgress(jobId, 60, "Cost calculation is in progress", "\u6b63\u5728\u8fdb\u884c\u6210\u672c\u8ba1\u7b97", "\u6b63\u5728\u9032\u884c\u6210\u672c\u8a08\u7b97");
        }
        String materialSql = this.getMaterialSql(ctx, tempMaterialTable);
        LowTimer calcuateTimer = new LowTimer();
        int materialPage = this.getMaterialPageCount(sysTempTableHelper, tempMaterialTable);
        this.countDown = new CountDownLatch(materialPage);
        int threadNum = this.getThreadPoolNum(ctx);
        ExecutorService executor = Executors.newFixedThreadPool(threadNum);
        for (int i = 0; i < materialPage; ++i) {
            CalculateThreadForMoveingWeightedAvg calThread = new CalculateThreadForMoveingWeightedAvg(ctx, params, sysTempTableHelper, conn, materialSql, periodInfo, i * 1000, tempTableFIFOBills, strCalType);
            executor.execute(calThread);
        }
        try {
            this.countDown.await();
            this.handleOtherData(ctx, sysTempTableHelper, params, periodInfo, tempTableFIFOBills, strCalType);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        executor.shutdown();
        if (this.ExceptionList.size() > 0) {
            this.logger.error(this.ExceptionList.get(0));
            throw new BOSException((Throwable)this.ExceptionList.get(0));
        }
        this.logger.error((Object)("\u8ba1\u7b97\u6210\u672c\u603b\u65f6\u95f4\uff1a" + calcuateTimer.msValue()));
        return false;
    }

    private void beforeCalculate(Context ctx, CalculateParams params, String strCalType, PeriodInfo periodInfo, SysTempTableHelper sysTempTableHelper, Connection conn, PreparedStatement reptPs, LowTimer timer, String tempTableFIFOBills, String tempMaterialTable) throws BOSException {
        try {
            timer.reset();
            this.checkInterrupted();
            this.buildInOutBillsData(ctx, sysTempTableHelper, periodInfo, strCalType, params, tempTableFIFOBills);
            this.logger.info((Object)("\u5165\u5e93\u548c\u51fa\u5e93\u5355\u636e\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            this.checkInterrupted();
            timer.reset();
            this.buildPrePeriodCostMoveBill(ctx, sysTempTableHelper, params, strCalType, periodInfo, tempTableFIFOBills);
            this.logger.info((Object)("\u4ee5\u524d\u671f\u95f4\u7684\u6210\u672c\u4ef7\u8c03\u62e8\u53d6\u6570\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.adjustPrePeriodData(conn, params, periodInfo, tempTableFIFOBills);
            this.logger.info((Object)("\u8fdb\u884c\u6570\u636e\u8c03\u6574\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            sysTempTableHelper.analyzeTable(tempTableFIFOBills);
            this.logger.info((Object)("\u7edf\u8ba1\u5206\u6790\u4e34\u65f6\u8868\u65f6\u95f4\uff1a\uff1a" + timer.msValue()));
            timer.reset();
            StringBuffer sqlmaterial = this.takeMatrialList(ctx, strCalType, tempTableFIFOBills);
            this.insertFIFOMaterialTMPTable(sysTempTableHelper, sqlmaterial, tempMaterialTable);
            this.logger.info((Object)("\u6784\u9020\u7269\u6599\u904d\u5386\u96c6\u5408\u65f6\u95f4\uff1a" + timer.msValue()));
            timer.reset();
            this.getNeedUpdateMoveLocBillMaterial(sysTempTableHelper, tempMaterialTable, params, periodInfo);
            this.logger.info((Object)("\u9700\u8981\u66f4\u65b0\u5e93\u4f4d\u79fb\u52a8\u5355\u6210\u672c\u7684\u7269\u6599\uff1a" + timer.msValue()));
            timer.reset();
            ArrayList sqlParams = new ArrayList();
            sysTempTableHelper.execute(this.clearOldPeriodData(params, strCalType, sqlParams), sqlParams);
            this.logger.info((Object)("\u6e05\u9664\u6210\u672c\u8ba1\u7b97\u62a5\u544a\u65f6\u95f4\uff1a" + timer.msValue()));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void adjustPrePeriodData(Connection conn, CalculateParams params, PeriodInfo periodInfo, String tempTableFIFOBills) throws BOSException, SQLException {
        LowTimer tt = new LowTimer();
        DBUtil.execute(conn, this.getUpateMaterialReqPriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9886\u6599\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateSaleIssuePriceFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u9500\u552e\u51fa\u5e93\u9000\u8d27\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        tt.reset();
        DBUtil.execute(conn, this.getUpateCostMoveIssueFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u51fa\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(conn, this.getUpateCostMoveInFromPrePeriod(tempTableFIFOBills, periodInfo));
        this.logger.debug((Object)("\u66f4\u65b0\u4e0a\u671f\u5173\u8054\u751f\u6210\u5230\u672c\u671f\u7684\u6210\u672c\u4ef7\u8c03\u62d4\u5165\u9000\u8d27\u5355\u6216\u8005\u51b2\u9500\u5355\u7684\u5355\u4ef7\u4e3a\u4e0a\u671f\u7684\u5355\u4ef7(ms)" + tt.msValue()));
        DBUtil.execute(conn, this.getUpdateSrcBillBizDate(tempTableFIFOBills));
    }

    @Override
    public String[][] getTempTableFields() {
        return null;
    }

    @Override
    public String getTempTableSerialVersionUID() {
        return null;
    }

    protected StringBuffer getSQLWherePeriod(PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer();
        if (periodInfo != null) {
            sql.append(" ((and BILL.FYear = ").append(periodInfo.getPeriodYear()).append("\t\n");
            sql.append(" and BILL.FPeriod >= ").append(periodInfo.getPeriodNumber()).append(")");
            sql.append(" OR BILL.FYear > ").append(periodInfo.getPeriodYear()).append("\t\n").append(")");
        }
        return sql;
    }

    @Override
    protected StringBuffer getSQLOrderBy(String stCalType) {
        StringBuffer sql = new StringBuffer();
        sql.append(" Order by Bill.FBizdate,BILL.FAUDITTIME,Bill.FNumber desc ,Bill.FSeqNum,bill.fcalculatekind ");
        return sql;
    }

    private HashMap moveWeightedAvgCalculate(Context ctx, Connection conn, CalculateParams params, RptRowSet rsMaterial, String strCalType, PeriodInfo periodInfo) throws EASBizException, BOSException {
        HashMap hashMap;
        ResultSet rs = null;
        Statement stmt = null;
        try {
            this.checkInterrupted();
            String materialId = rsMaterial.getString("FMaterialID");
            params.setString("CurrMaterialId", materialId);
            String tempTableFIFOBills = params.getString("T_Temp_FIFOBills");
            StringBuffer sql = new StringBuffer();
            sql.append("select * from ").append(tempTableFIFOBills).append(" Bill ");
            sql.append(" where fmaterialid = '").append(materialId).append("'");
            sql.append("   and fcompanyorgunitid = '").append(rsMaterial.getString("fcompanyorgunitid")).append("'");
            sql.append(this.getSQLOrderBy(strCalType));
            ArrayList<RecentCostInfo> listAllBill = new ArrayList<RecentCostInfo>();
            ArrayList<RecentCostInfo> listRedOutBill = new ArrayList<RecentCostInfo>();
            HashMap costMoveMap = new HashMap();
            HashMap<String, RecentCostInfo> periodBillMap = new HashMap<String, RecentCostInfo>();
            HashMap matAttrChgMap = new HashMap();
            HashMap<String, RecentCostInfo> prePeriodCostMoveMap = new HashMap<String, RecentCostInfo>();
            HashMap<String, RecentCostInfo> costBillMap = new HashMap<String, RecentCostInfo>();
            HashMap<String, RecentCostInfo> combitionMap = new HashMap<String, RecentCostInfo>();
            RecentCostInfo periodBeginBill = null;
            RecentCostInfo bill = null;
            RecentCostInfo costBill = null;
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql.toString());
            long timeSerialNumber = new Date().getTime();
            Map<String, String> redAndBlueIdMap = this.getRedAndBlueBillEntryIdMap(ctx, params, tempTableFIFOBills, rsMaterial);
            while (rs.next()) {
                bill = this.convertRecentCostInfo(rs, strCalType, timeSerialNumber += 10L, false, redAndBlueIdMap);
                if (bill.getInt("FFiVouchered") == 1) {
                    bill.setPriceSource(PriceSourEnum.fiVouchered);
                    bill.setDealComplete(true);
                }
                if (2 == bill.getInt("FCalculateKind")) {
                    periodBeginBill = (RecentCostInfo)periodBillMap.get(bill.getString("FkeyID"));
                    if (periodBeginBill == null) {
                        periodBeginBill = bill;
                        periodBillMap.put(bill.getString("FkeyID"), periodBeginBill);
                        listAllBill.add(periodBeginBill);
                    } else {
                        periodBeginBill.setRecentCost(periodBeginBill.getRecentCost().add(bill.getRecentCost()));
                        periodBeginBill.setRecentQty(periodBeginBill.getRecentQty().add(bill.getRecentQty()));
                    }
                    RecentCostHelp.calculateAvgPrice(periodBeginBill);
                }
                Boolean isInBill4SaleReturn = this.isInBillForSaleReturn(bill, params);
                if (1 == bill.getInt("FCalculateKind")) {
                    if (bill.getString("FSourceBillEntryID") != null) {
                        if (bill.isSrcOutBillInPrePeriod()) {
                            if (params.getBoolean("isSrcPerBillOutBillCalType")) {
                                bill.setBoolean("isOutRetBillisIn", true);
                            }
                            bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                        } else if (bill.isSrcOutBillInCurrentPd() || bill.getFBlueBillEntryID() != null && !isInBill4SaleReturn.booleanValue()) {
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            bill.setNeedUpdate(true);
                            if (bill.getFBlueBillEntryID() != null && !isInBill4SaleReturn.booleanValue()) {
                                bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            }
                        } else {
                            if (bill.isRedBill() && params.getBoolean("isNotSrcOutBillCalType") && bill.getFBlueBillEntryID() == null || isInBill4SaleReturn.booleanValue()) {
                                bill.setBoolean("isOutRetBillisIn", true);
                                bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            }
                            if (isInBill4SaleReturn.booleanValue()) {
                                bill.setPriceSource(PriceSourEnum.sourBillPrice);
                            }
                        }
                    } else {
                        if (bill.isNotSrcOutRetBill() && params.getBoolean("isNotSrcOutBillCalType")) {
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            bill.setBoolean("isOutRetBillisIn", true);
                        }
                        if (bill.isSrcOutBillInPrePeriod() && params.getBoolean("isSrcPerBillOutBillCalType")) {
                            bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                            bill.setBoolean("isOutRetBillisIn", true);
                        }
                    }
                }
                bill.setBigDecimal("MoveAvgQty", CalculateUtil.ZERO);
                bill.setBigDecimal("MoveAvgPrice", CalculateUtil.ZERO);
                bill.setBigDecimal("MoveAvgCost", CalculateUtil.ZERO);
                if (bill.isCostPriceMove()) {
                    this.setCostMoveIsCalculate(bill, strCalType, periodInfo);
                    this.buildCostPriceMove(bill, costMoveMap);
                    if (bill.isMoveOutBill() && RecentCostHelp.isPrePeriodBill(bill, periodInfo)) {
                        prePeriodCostMoveMap.put(bill.getStockTransBillEntryID(), bill);
                    }
                }
                if (bill.isMatAttrChange()) {
                    bill.setBoolean("IsCalculate", false);
                    this.buildMatAttrChange(bill, matAttrChgMap);
                }
                if (RecentCostHelp.isPrePeriodBill(bill, periodInfo) || 2 == bill.getInt("FCalculateKind")) continue;
                combitionMap.put(bill.getString("FBillEntryId"), bill);
                if (bill.getInt("FisSrcBilInCurrPid") == -1) {
                    if (!combitionMap.containsKey(bill.getString("fsourcebillentryid"))) continue;
                    RecentCostInfo combinBill = (RecentCostInfo)combitionMap.get(bill.getString("fsourcebillentryid"));
                    bill.setLong("timeSerialNumber", combinBill.getLong("timeSerialNumber") + 1L);
                    int index = listAllBill.indexOf(combinBill);
                    listAllBill.add(index + 1, bill);
                    if (!bill.isRedBill()) continue;
                    listRedOutBill.add(bill);
                    continue;
                }
                if ("3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(bill.getString("FBillTypeID"))) {
                    costBill = (RecentCostInfo)costBillMap.get(bill.getString("fbillid") + bill.getFkeyID());
                    if (costBill == null) {
                        costBill = bill;
                        costBillMap.put(bill.getString("fbillid") + bill.getFkeyID(), bill);
                        listAllBill.add(costBill);
                        continue;
                    }
                    costBill.setRecentCost(costBill.getRecentCost().add(bill.getRecentCost()));
                    costBill.setRecentQty(costBill.getRecentQty().add(bill.getRecentQty()));
                    continue;
                }
                listAllBill.add(bill);
                if (!bill.isRedBill()) continue;
                listRedOutBill.add(bill);
            }
            this.updateToPrePeriodCostMovePrice(prePeriodCostMoveMap, costMoveMap, null);
            HashMap balanceMap = this.calculateOutBillCost(ctx, params, conn, periodInfo, listAllBill, strCalType, costMoveMap, listRedOutBill);
            this.updateMoveLocationBill(ctx, params, balanceMap, (ArrayList)params.getObject("calOrder"), strCalType);
            this.calMatAttrChangeCost(matAttrChgMap);
            hashMap = balanceMap;
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return hashMap;
    }

    private HashMap calculateOutBillCost(Context ctx, CalculateParams params, Connection conn, PeriodInfo period, List listAllBill, String strCalType, HashMap costMoveMap, List listRedOutBill) throws BOSException, CalculateException {
        BalanceCostInfo balanceCostInfo = null;
        HashMap<String, Object> balanceMap = new HashMap<String, Object>();
        boolean isCalculate_NotSrcBill = params.getBoolean("isNotSrcOutBillCalType");
        boolean isCalculate_isSrcPrePerod = params.getBoolean("isSrcPerBillOutBillCalType");
        RecentCostInfo bill = null;
        ArrayList<String> calOrder = new ArrayList<String>();
        params.setObject("calOrder", calOrder);
        for (int i = 0; listAllBill != null && i < listAllBill.size(); ++i) {
            bill = (RecentCostInfo)listAllBill.get(i);
            String key = bill.getString("FkeyID");
            if (balanceMap.get(key) == null) {
                balanceCostInfo = new BalanceCostInfo();
                balanceCostInfo.setStrCalType(strCalType);
                balanceCostInfo.setBigDecimal("RecentPurInPrice", CalculateUtil.ZERO);
                balanceCostInfo.setBigDecimal("RecentOutPrice", CalculateUtil.ZERO);
                balanceCostInfo.setBigDecimal("RecentPrice", CalculateUtil.ZERO);
                RecentCostInfo tmpInfo = (RecentCostInfo)bill.clone();
                tmpInfo.setRecentCost(CalculateUtil.ZERO);
                tmpInfo.setRecentQty(CalculateUtil.ZERO);
                RecentCostHelp.calculateAvgPrice(tmpInfo);
                balanceCostInfo.setReusltBillInfo(tmpInfo);
                calOrder.add(key);
            } else {
                balanceCostInfo = (BalanceCostInfo)((Object)balanceMap.get(key));
            }
            params.setObject("CAL_TYPE_KEY", (Object)key);
            if (balanceCostInfo.getBoolean("isExceptionState")) continue;
            if (1 != bill.getInt("FCalculateKind")) {
                this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, true);
            } else if (1 == bill.getInt("FCalculateKind")) {
                boolean isInBill4SaleReturn = this.isInBillForSaleReturn(bill, params);
                if (bill.isRedBill() && !bill.isCostAdjustBill()) {
                    if (bill.getString("FSourceBillEntryID") != null && bill.getString("fbilltypeid").equals(bill.getString("fsourcebilltypeid"))) {
                        if (!bill.getBoolean("IS_NOT_AGAIN_UPDATE_COST")) {
                            bill.setNeedUpdate(true);
                            if (bill.isSrcOutBillInPrePeriod()) {
                                bill.setBoolean("isOutRetBillisIn", isCalculate_isSrcPrePerod);
                                bill.setBoolean("IS_NOT_AGAIN_UPDATE_COST", true);
                                this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, isCalculate_isSrcPrePerod);
                            } else {
                                bill.setNeedUpdate(true);
                                bill.setPriceSource(PriceSourEnum.sourBillPrice);
                                this.calculateBlueOutCost(ctx, params, balanceCostInfo, bill);
                            }
                        } else {
                            this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, false);
                        }
                    } else if (!isCalculate_NotSrcBill) {
                        bill.setNeedUpdate(true);
                        this.calculateBlueOutCost(ctx, params, balanceCostInfo, bill);
                    } else {
                        boolean isInBill = isCalculate_NotSrcBill;
                        if (bill.getFBlueBillEntryID() != null && !isInBill4SaleReturn) {
                            isInBill = false;
                        }
                        this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, isInBill);
                        bill.setBoolean("isOutRetBillisIn", isInBill);
                    }
                } else if (CalculateUtil.ZERO.compareTo(bill.getRecentQty()) <= 0 && !bill.isCostAdjustBill()) {
                    this.calculateBlueOutCost(ctx, params, balanceCostInfo, bill);
                    this.synCostMovePriceBill(costMoveMap, bill);
                    this.handleBlueBillAndRedBillRel(listRedOutBill, bill);
                    bill.setBoolean("ISADJUSTDIFFER", true);
                } else {
                    this.calcualteBlueInOrOutBillCost(ctx, params, conn, period, balanceCostInfo, bill, strCalType, false);
                }
            }
            balanceMap.put(key, (Object)balanceCostInfo);
        }
        this.handleDetailDiff(listAllBill, balanceMap);
        balanceMap.put("ALLINOUTLIST", listAllBill);
        return balanceMap;
    }

    private boolean calcualteBlueInOrOutBillCost(Context ctx, CalculateParams params, Connection conn, PeriodInfo period, BalanceCostInfo balanceBill, RecentCostInfo billInfo, String strCalType, boolean isIn) throws BOSException {
        BigDecimal avgPrice = balanceBill.getPrice();
        BigDecimal recntOutPrice = balanceBill.getBigDecimal("RecentOutPrice");
        BigDecimal recntInPrice = balanceBill.getBigDecimal("RecentPurInPrice");
        PriceSourEnum priceSource = PriceSourEnum.realtimePrice;
        if (CalculateUtil.isZero(avgPrice)) {
            avgPrice = recntInPrice;
            priceSource = PriceSourEnum.newIn;
        }
        if (CalculateUtil.isZero(avgPrice)) {
            avgPrice = recntOutPrice;
            priceSource = PriceSourEnum.newOut;
        }
        if (CalculateUtil.isZero(avgPrice)) {
            avgPrice = billInfo.getPrice();
            priceSource = PriceSourEnum.userDefine;
        }
        if (!isIn && CalculateUtil.isZero(avgPrice)) {
            if (this.priceType == 0 || this.priceType == 1) {
                avgPrice = this.getNewPrice(ctx, params, billInfo);
            }
            if (avgPrice == null) {
                avgPrice = this.getPrice(ctx, params);
            }
            if (this.priceType == 0) {
                priceSource = PriceSourEnum.newOut;
            } else if (this.priceType == 1) {
                priceSource = PriceSourEnum.newIn;
            } else if (this.priceType == 2) {
                priceSource = PriceSourEnum.standUnitPrice;
            } else if (this.priceType == 4) {
                priceSource = PriceSourEnum.newReturnPrice;
            }
        }
        if (avgPrice == null) {
            avgPrice = CalculateUtil.ZERO;
        }
        if (!(isIn || billInfo.isDealComplete() || billInfo.isCostAdjustBill())) {
            if (CalculateUtil.ZERO.compareTo(avgPrice) >= 0 && 2 != billInfo.getInt("FCalculateKind")) {
                if (CalculateUtil.ZERO.compareTo(avgPrice) > 0) {
                    priceSource = PriceSourEnum.negativePrice;
                }
                if (CalculateUtil.ZERO.compareTo(avgPrice) == 0) {
                    priceSource = PriceSourEnum.zeroPrice;
                }
                if (this.priceType == 3 && billInfo.getPrice().compareTo(CalculateUtil.ZERO) > 0) {
                    priceSource = PriceSourEnum.userDefine;
                }
                billInfo.setPriceSource(priceSource);
                billInfo.setBoolean("isExceptionState", true);
                billInfo.setString("ERROR_MSG", params.getString("ERROR_MSG"));
                balanceBill.setBoolean("isExceptionState", true);
                return false;
            }
            if (!billInfo.getBoolean("IS_NOT_AGAIN_UPDATE_COST")) {
                BigDecimal cost = billInfo.getRecentQty().multiply(avgPrice).setScale(billInfo.getInt("FLocalCurrencyPrecision"), 4);
                if (BigDecimal.ZERO.compareTo(cost) == 0 && avgPrice.compareTo(BigDecimal.ZERO) != 0 && billInfo.getRecentQty().compareTo(BigDecimal.ZERO) != 0) {
                    cost = RecentCostHelp.getMinValueByScale(billInfo.getInt("FLocalCurrencyPrecision"), billInfo.getRecentQty().signum());
                }
                billInfo.setRecentCost(cost);
                billInfo.setPrice(avgPrice);
                if (!billInfo.isDealComplete()) {
                    billInfo.setPriceSource(priceSource);
                }
                billInfo.setNeedUpdate(true);
            }
            if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) != 0) {
                balanceBill.setBigDecimal("RecentOutPrice", avgPrice);
            }
        } else if (CalculateUtil.ZERO.compareTo(billInfo.getPrice()) != 0) {
            balanceBill.setBigDecimal("RecentPurInPrice", billInfo.getPrice());
        }
        balanceBill.calculateBalance(billInfo, isIn);
        if (2 != billInfo.getInt("FCalculateKind") && CalculateUtil.ZERO.compareTo(balanceBill.getPrice()) > 0) {
            billInfo.setBoolean("isExceptionState", true);
            billInfo.setString("ERROR_MSG", params.getString("ERROR_MSG"));
            balanceBill.setBoolean("isExceptionState", true);
            return false;
        }
        balanceBill.setBigDecimal("RecentPrice", balanceBill.getPrice());
        return true;
    }

    private void calculateBlueOutCost(Context ctx, CalculateParams params, BalanceCostInfo balanceBill, RecentCostInfo billInfo) throws BOSException {
        BigDecimal recntInPrice = balanceBill.getBigDecimal("RecentPrice");
        PriceSourEnum priceSource = PriceSourEnum.realtimePrice;
        if (CalculateUtil.isZero(recntInPrice)) {
            if (this.priceType == 0) {
                recntInPrice = balanceBill.getBigDecimal("RecentOutPrice");
                if (CalculateUtil.isZero(recntInPrice)) {
                    recntInPrice = this.getNewPrice(ctx, params, billInfo);
                }
                if (recntInPrice == null) {
                    recntInPrice = this.getPrice(ctx, params);
                }
                priceSource = PriceSourEnum.newOut;
            } else if (this.priceType == 1) {
                recntInPrice = balanceBill.getBigDecimal("RecentPurInPrice");
                if (CalculateUtil.isZero(recntInPrice)) {
                    recntInPrice = this.getNewPrice(ctx, params, billInfo);
                }
                if (recntInPrice == null) {
                    recntInPrice = this.getPrice(ctx, params);
                }
                priceSource = PriceSourEnum.newIn;
            } else if (this.priceType == 2) {
                recntInPrice = this.getPrice(ctx, params);
                priceSource = PriceSourEnum.standUnitPrice;
            } else if (this.priceType == 4) {
                recntInPrice = this.getPrice(ctx, params);
                priceSource = PriceSourEnum.newReturnPrice;
            }
        }
        if (billInfo.getPriceSource() == PriceSourEnum.sourBillPrice) {
            priceSource = PriceSourEnum.sourBillPrice;
            recntInPrice = billInfo.getPrice();
        }
        if (recntInPrice == null) {
            recntInPrice = CalculateUtil.ZERO;
        }
        if (CalculateUtil.ZERO.compareTo(recntInPrice) >= 0) {
            billInfo.setBoolean("isExceptionState", true);
            if (CalculateUtil.ZERO.compareTo(recntInPrice) > 0) {
                priceSource = PriceSourEnum.negativePrice;
            }
            if (CalculateUtil.ZERO.compareTo(recntInPrice) == 0) {
                priceSource = PriceSourEnum.zeroPrice;
            }
            billInfo.setPriceSource(priceSource);
            billInfo.setString("ERROR_MSG", params.getString("ERROR_MSG"));
            balanceBill.setBoolean("isExceptionState", true);
            return;
        }
        if (!billInfo.getBoolean("IS_NOT_AGAIN_UPDATE_COST") && !billInfo.isDealComplete()) {
            BigDecimal cost = billInfo.getRecentQty().multiply(recntInPrice).setScale(billInfo.getInt("FLocalCurrencyPrecision"), 4);
            if (cost.compareTo(BigDecimal.ZERO) == 0 && billInfo.getRecentQty().compareTo(BigDecimal.ZERO) != 0 && recntInPrice.compareTo(BigDecimal.ZERO) != 0) {
                cost = RecentCostHelp.getMinValueByScale(billInfo.getInt("FLocalCurrencyPrecision"), billInfo.getRecentQty().signum());
            }
            billInfo.setRecentCost(cost);
            billInfo.setPrice(recntInPrice);
            billInfo.setPriceSource(priceSource);
            billInfo.setNeedUpdate(true);
            if (CalculateUtil.ZERO.compareTo(recntInPrice) != 0) {
                balanceBill.setBigDecimal("RecentOutPrice", recntInPrice);
            }
        }
        balanceBill.calculateBalance(billInfo, false);
        balanceBill.setBigDecimal("RecentPrice", balanceBill.getPrice());
    }

    @Override
    protected void handleCostPriceMove(RecentCostInfo bill, HashMap costMoveMap) {
        if (bill.isCostPriceMove()) {
            ArrayList costMoveOutList = null;
            if (bill.isMoveOutBill()) {
                if (costMoveMap.get(bill.getString("FStockTransBillEntryID")) == null) {
                    costMoveOutList = new ArrayList();
                    costMoveOutList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), costMoveOutList);
                } else {
                    costMoveOutList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                    costMoveOutList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), costMoveOutList);
                }
            }
            if (bill.isMoveInBill()) {
                RecentCostInfo moveIssueBill = null;
                costMoveOutList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                if (costMoveOutList != null && costMoveOutList.size() > 0) {
                    for (int i = 0; i < costMoveOutList.size(); ++i) {
                        moveIssueBill = (RecentCostInfo)costMoveOutList.get(i);
                        if (bill.getString("FSourceBillEntryID") == null || !bill.getString("FSourceBillEntryID").equals(moveIssueBill.getString("FBillEntryId"))) continue;
                        moveIssueBill.addMoveInbillList(bill);
                        return;
                    }
                    moveIssueBill = (RecentCostInfo)costMoveOutList.get(costMoveOutList.size() - 1);
                    moveIssueBill.addMoveInbillList(bill);
                }
            }
        }
    }

    protected void holdCostPriceMove(RecentCostInfo bill, Map costMoveMap, List moveInList) {
        if (bill.isCostPriceMove()) {
            if (bill.isMoveOutBill()) {
                ArrayList moveIssueList = null;
                if (costMoveMap.get(bill.getString("FStockTransBillEntryID")) == null) {
                    moveIssueList = new ArrayList();
                    moveIssueList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), moveIssueList);
                } else {
                    moveIssueList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"));
                    moveIssueList.add(bill);
                    costMoveMap.put(bill.getString("FStockTransBillEntryID"), moveIssueList);
                }
            } else if (bill.isMoveInBill()) {
                moveInList.add(bill);
            }
        }
    }

    protected void buildCostMoveInOutRelation(Map costMoveMap, List moveInList) {
        RecentCostInfo bill = null;
        ArrayList costMoveOutList = null;
        RecentCostInfo moveIssueBill = null;
        for (int i = 0; i < moveInList.size(); ++i) {
            bill = (RecentCostInfo)moveInList.get(i);
            if (!bill.isCostPriceMove() || !bill.isMoveInBill() || (costMoveOutList = (ArrayList)costMoveMap.get(bill.getString("FStockTransBillEntryID"))) == null || costMoveOutList.size() <= 0) continue;
            for (int j = 0; j < costMoveOutList.size(); ++j) {
                moveIssueBill = (RecentCostInfo)costMoveOutList.get(j);
                if (bill.getString("FSourceBillEntryID") == null || !bill.getString("FSourceBillEntryID").equals(moveIssueBill.getString("FBillEntryId"))) continue;
                moveIssueBill.addMoveInbillList(bill);
                return;
            }
            moveIssueBill = (RecentCostInfo)costMoveOutList.get(costMoveOutList.size() - 1);
            moveIssueBill.addMoveInbillList(bill);
        }
    }

    protected void reWriteCostPriceMoveInPrice(RecentCostInfo info, HashMap costMoveMap) {
        if (info.isMoveOutBill()) {
            List costMoveOutList = (List)costMoveMap.get(info.getString("FStockTransBillEntryID"));
            for (int i = 0; costMoveOutList != null && i < costMoveOutList.size(); ++i) {
                ArrayList moveinList = ((RecentCostInfo)costMoveOutList.get(i)).getMoveInbillList();
                this.handleSrcBill(moveinList, info);
            }
        }
    }

    private void handleDetailDiff(List allList, HashMap costMoveMap) {
        RecentCostInfo tmpBillInfo = null;
        BalanceCostInfo balanceInfo = null;
        if (costMoveMap == null || costMoveMap.size() == 0 || allList == null || allList.size() == 0) {
            return;
        }
        Iterator iter = costMoveMap.entrySet().iterator();
        String mapKey = null;
        block0: while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            mapKey = (String)entry.getKey();
            balanceInfo = (BalanceCostInfo)((Object)entry.getValue());
            if (balanceInfo == null) {
                return;
            }
            if (!balanceInfo.isNeedAdjustDetail()) continue;
            for (int i = allList.size() - 1; i >= 0; --i) {
                tmpBillInfo = (RecentCostInfo)allList.get(i);
                if (mapKey == null || !mapKey.equals(tmpBillInfo.getString("FkeyID")) || !this.isHandleDetailDiffer(balanceInfo, tmpBillInfo)) continue;
                tmpBillInfo.setRecentCost(tmpBillInfo.getRecentCost().add(balanceInfo.getRecentCost()));
                RecentCostHelp.calculateAvgPrice(tmpBillInfo);
                tmpBillInfo.setBigDecimal("MoveAvgQty", CalculateUtil.ZERO);
                tmpBillInfo.setBigDecimal("MoveAvgPrice", CalculateUtil.ZERO);
                tmpBillInfo.setBigDecimal("MoveAvgCost", CalculateUtil.ZERO);
                tmpBillInfo.setBoolean("ADJUSTDIFFERED", true);
                balanceInfo.handleDetailDifer(tmpBillInfo);
                tmpBillInfo.setInt("handleTailDiff", 1);
                continue block0;
            }
        }
    }

    private boolean isHandleDetailDiffer(BalanceCostInfo balanceInfo, RecentCostInfo infoBill) {
        return !infoBill.isDealComplete() && infoBill.getBoolean("ISADJUSTDIFFER") && CalculateUtil.ZERO.compareTo(balanceInfo.getRecentCost().add(infoBill.getRecentCost())) < 0 && CalculateUtil.ZERO.compareTo(infoBill.getBigDecimal("FReverseQty")) == 0 && !infoBill.isCostPriceMove() && !infoBill.isMatAttrChange();
    }

    class CalculateThreadForMoveingWeightedAvg
    implements Runnable {
        Context ctx;
        CalculateParams params;
        SysTempTableHelper sysTempTableHelper;
        Connection conn;
        String materialSql;
        PeriodInfo periodInfo;
        int startIndex = 0;
        String tempTableFIFOBills;
        String strCalType;

        public CalculateThreadForMoveingWeightedAvg(Context ctx, CalculateParams params, SysTempTableHelper sysTempTableHelper, Connection conn, String materialSql, PeriodInfo periodInfo, int startIndex, String tempTableFIFOBills, String strCalType) {
            this.ctx = ctx;
            try {
                this.params = (CalculateParams)params.clone();
            }
            catch (CloneNotSupportedException e) {
                MoveingWeightedAverageCalculate.this.ExceptionList.add(e);
            }
            this.sysTempTableHelper = sysTempTableHelper;
            this.conn = conn;
            this.materialSql = materialSql;
            this.periodInfo = periodInfo;
            this.startIndex = startIndex;
            this.tempTableFIFOBills = tempTableFIFOBills;
            this.strCalType = strCalType;
        }

        @Override
        public void run() {
            try {
                this.asynCalculate();
            }
            catch (Exception e) {
                MoveingWeightedAverageCalculate.this.ExceptionList.add(e);
                MoveingWeightedAverageCalculate.this.logger.error((Object)e);
            }
            finally {
                System.out.println("countDown == " + MoveingWeightedAverageCalculate.this.countDown.getCount());
                MoveingWeightedAverageCalculate.this.countDown.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void asynCalculate() throws BOSException, SQLException {
            UpdateBillCostHelper updateBillCostHelper = new UpdateBillCostHelper(this.conn);
            PreparedStatement reptPs = null;
            if (this.params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                reptPs = this.conn.prepareStatement(CostComputeHelp.getCreateCostComputeReportSQL());
            }
            HashMap balanceMap = null;
            int materialCount = 0;
            RptRowSet rsMaterial = DBUtils.executeQuery((String)this.materialSql, null, (int)this.startIndex, (int)1000, (Connection)this.conn);
            try {
                while (rsMaterial.next()) {
                    ++materialCount;
                    this.params.setObject("MATERIAL_LIST", (Object)rsMaterial);
                    try {
                        balanceMap = MoveingWeightedAverageCalculate.this.moveWeightedAvgCalculate(this.ctx, this.conn, this.params, rsMaterial, this.strCalType, this.periodInfo);
                        updateBillCostHelper.updateBills((List)balanceMap.get("ALLINOUTLIST"), new HashMap());
                        if (this.params.getBoolean("ISWRITECOSTCOMPUTEREPORT")) {
                            if (this.params.getBoolean("ISWRITEDEXPCOSTRPT")) {
                                Map keyExceptionState = MoveingWeightedAverageCalculate.this.getKeyExceptionState(balanceMap);
                                this.params.setObject("keyExceptionState", (Object)keyExceptionState);
                            }
                            MoveingWeightedAverageCalculate.this.handleCostRept(this.ctx, reptPs, balanceMap, this.periodInfo, this.params);
                        }
                        if (materialCount % 500 == 0) {
                            MoveingWeightedAverageCalculate.this.executePsBatch(reptPs);
                        }
                        if (balanceMap == null) continue;
                        balanceMap.clear();
                    }
                    catch (Exception e) {
                        MoveingWeightedAverageCalculate.this.logger.error((Object)e);
                        MoveingWeightedAverageCalculate.this.ExceptionList.add(e);
                    }
                }
                updateBillCostHelper.executeBatch(true);
                MoveingWeightedAverageCalculate.this.executePsBatch(reptPs);
                return;
            }
            finally {
                SQLUtils.cleanup((Statement)reptPs);
            }
        }
    }
}

